/* timer-state.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from timer-state.vala, do not modify */

/*
 * Copyright (c) 2011-2015 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Arun Mahapatra <pratikarun@gmail.com>
 *          Kamil Prusko <kamilprusko@gmail.com>
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include "gnome-pomodoro.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

#define POMODORO_MIN_POMODORO_TIME 60.0
#define POMODORO_POMODORO_THRESHOLD 0.90
#define POMODORO_MISSING_SCORE_THRESHOLD 0.50
#define POMODORO_SHORT_TO_LONG_BREAK_THRESHOLD 0.50
#define POMODORO_TIME_TO_RESET_SCORE 3600.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_TIMER_STATE_0_PROPERTY,
	POMODORO_TIMER_STATE_NAME_PROPERTY,
	POMODORO_TIMER_STATE_ELAPSED_PROPERTY,
	POMODORO_TIMER_STATE_DURATION_PROPERTY,
	POMODORO_TIMER_STATE_TIMESTAMP_PROPERTY,
	POMODORO_TIMER_STATE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_timer_state_properties[POMODORO_TIMER_STATE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	POMODORO_DISABLED_STATE_0_PROPERTY,
	POMODORO_DISABLED_STATE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_disabled_state_properties[POMODORO_DISABLED_STATE_NUM_PROPERTIES];
enum  {
	POMODORO_POMODORO_STATE_0_PROPERTY,
	POMODORO_POMODORO_STATE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_pomodoro_state_properties[POMODORO_POMODORO_STATE_NUM_PROPERTIES];
enum  {
	POMODORO_BREAK_STATE_0_PROPERTY,
	POMODORO_BREAK_STATE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_break_state_properties[POMODORO_BREAK_STATE_NUM_PROPERTIES];
enum  {
	POMODORO_SHORT_BREAK_STATE_0_PROPERTY,
	POMODORO_SHORT_BREAK_STATE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_short_break_state_properties[POMODORO_SHORT_BREAK_STATE_NUM_PROPERTIES];
enum  {
	POMODORO_LONG_BREAK_STATE_0_PROPERTY,
	POMODORO_LONG_BREAK_STATE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_long_break_state_properties[POMODORO_LONG_BREAK_STATE_NUM_PROPERTIES];

struct _PomodoroTimerStatePrivate {
	gchar* _name;
	gdouble _elapsed;
	gdouble _duration;
	gdouble _timestamp;
};

static gint PomodoroTimerState_private_offset;
static gpointer pomodoro_timer_state_parent_class = NULL;
static gpointer pomodoro_disabled_state_parent_class = NULL;
static gpointer pomodoro_pomodoro_state_parent_class = NULL;
static gpointer pomodoro_break_state_parent_class = NULL;
static gpointer pomodoro_short_break_state_parent_class = NULL;
static gpointer pomodoro_long_break_state_parent_class = NULL;

static PomodoroTimerState* pomodoro_timer_state_real_create_next_state (PomodoroTimerState* self,
                                                                 gdouble score,
                                                                 gdouble timestamp);
static gdouble pomodoro_timer_state_real_calculate_score (PomodoroTimerState* self,
                                                   gdouble score,
                                                   gdouble timestamp);
static GObject * pomodoro_timer_state_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void pomodoro_timer_state_finalize (GObject * obj);
static GType pomodoro_timer_state_get_type_once (void);
static void _vala_pomodoro_timer_state_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_pomodoro_timer_state_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static PomodoroTimerState* pomodoro_disabled_state_real_create_next_state (PomodoroTimerState* base,
                                                                    gdouble score,
                                                                    gdouble timestamp);
static gdouble pomodoro_disabled_state_real_calculate_score (PomodoroTimerState* base,
                                                      gdouble score,
                                                      gdouble timestamp);
static GObject * pomodoro_disabled_state_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static GType pomodoro_disabled_state_get_type_once (void);
static PomodoroTimerState* pomodoro_pomodoro_state_real_create_next_state (PomodoroTimerState* base,
                                                                    gdouble score,
                                                                    gdouble timestamp);
static gdouble pomodoro_pomodoro_state_real_calculate_score (PomodoroTimerState* base,
                                                      gdouble score,
                                                      gdouble timestamp);
static GObject * pomodoro_pomodoro_state_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static GType pomodoro_pomodoro_state_get_type_once (void);
static PomodoroTimerState* pomodoro_break_state_real_create_next_state (PomodoroTimerState* base,
                                                                 gdouble score,
                                                                 gdouble timestamp);
static GType pomodoro_break_state_get_type_once (void);
static GObject * pomodoro_short_break_state_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static GType pomodoro_short_break_state_get_type_once (void);
static gdouble pomodoro_long_break_state_real_calculate_score (PomodoroTimerState* base,
                                                        gdouble score,
                                                        gdouble timestamp);
static GObject * pomodoro_long_break_state_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static GType pomodoro_long_break_state_get_type_once (void);

static inline gpointer
pomodoro_timer_state_get_instance_private (PomodoroTimerState* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroTimerState_private_offset);
}

static PomodoroTimerState*
pomodoro_timer_state_real_create_next_state (PomodoroTimerState* self,
                                             gdouble score,
                                             gdouble timestamp)
{
	g_critical ("Type `%s' does not implement abstract method `pomodoro_timer_state_create_next_state'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PomodoroTimerState*
pomodoro_timer_state_create_next_state (PomodoroTimerState* self,
                                        gdouble score,
                                        gdouble timestamp)
{
	PomodoroTimerStateClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = POMODORO_TIMER_STATE_GET_CLASS (self);
	if (_klass_->create_next_state) {
		return _klass_->create_next_state (self, score, timestamp);
	}
	return NULL;
}

/**
         * Returns acumulated score, or 0.0 if taken a long break.
         */
static gdouble
pomodoro_timer_state_real_calculate_score (PomodoroTimerState* self,
                                           gdouble score,
                                           gdouble timestamp)
{
	gdouble result;
	result = score;
	return result;
}

gdouble
pomodoro_timer_state_calculate_score (PomodoroTimerState* self,
                                      gdouble score,
                                      gdouble timestamp)
{
	PomodoroTimerStateClass* _klass_;
	g_return_val_if_fail (self != NULL, 0.0);
	_klass_ = POMODORO_TIMER_STATE_GET_CLASS (self);
	if (_klass_->calculate_score) {
		return _klass_->calculate_score (self, score, timestamp);
	}
	return -1.0;
}

PomodoroTimerState*
pomodoro_timer_state_lookup (const gchar* name)
{
	PomodoroTimerState* state = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	PomodoroTimerState* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("pomodoro")))) {
		switch (0) {
			default:
			{
				PomodoroPomodoroState* _tmp3_;
				_tmp3_ = pomodoro_pomodoro_state_new ();
				_g_object_unref0 (state);
				state = (PomodoroTimerState*) _tmp3_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("short-break")))) {
		switch (0) {
			default:
			{
				PomodoroShortBreakState* _tmp4_;
				_tmp4_ = pomodoro_short_break_state_new ();
				_g_object_unref0 (state);
				state = (PomodoroTimerState*) _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("long-break")))) {
		switch (0) {
			default:
			{
				PomodoroLongBreakState* _tmp5_;
				_tmp5_ = pomodoro_long_break_state_new ();
				_g_object_unref0 (state);
				state = (PomodoroTimerState*) _tmp5_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("null")))) {
		switch (0) {
			default:
			{
				PomodoroDisabledState* _tmp6_;
				_tmp6_ = pomodoro_disabled_state_new ();
				_g_object_unref0 (state);
				state = (PomodoroTimerState*) _tmp6_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_object_unref0 (state);
				state = NULL;
				break;
			}
		}
	}
	result = state;
	return result;
}

gboolean
pomodoro_timer_state_is_completed (PomodoroTimerState* self)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_elapsed;
	_tmp1_ = self->priv->_duration;
	result = _tmp0_ >= _tmp1_;
	return result;
}

PomodoroTimerState*
pomodoro_timer_state_construct (GType object_type)
{
	PomodoroTimerState * self = NULL;
	self = (PomodoroTimerState*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
pomodoro_timer_state_get_name (PomodoroTimerState* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
pomodoro_timer_state_set_name (PomodoroTimerState* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_timer_state_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_NAME_PROPERTY]);
	}
}

gdouble
pomodoro_timer_state_get_elapsed (PomodoroTimerState* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_elapsed;
	return result;
}

void
pomodoro_timer_state_set_elapsed (PomodoroTimerState* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_timer_state_get_elapsed (self);
	if (old_value != value) {
		self->priv->_elapsed = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_ELAPSED_PROPERTY]);
	}
}

gdouble
pomodoro_timer_state_get_duration (PomodoroTimerState* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_duration;
	return result;
}

void
pomodoro_timer_state_set_duration (PomodoroTimerState* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_timer_state_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_DURATION_PROPERTY]);
	}
}

gdouble
pomodoro_timer_state_get_timestamp (PomodoroTimerState* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_timestamp;
	return result;
}

void
pomodoro_timer_state_set_timestamp (PomodoroTimerState* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_timer_state_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_TIMESTAMP_PROPERTY]);
	}
}

static GObject *
pomodoro_timer_state_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroTimerState * self;
	parent_class = G_OBJECT_CLASS (pomodoro_timer_state_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_TIMER_STATE, PomodoroTimerState);
	pomodoro_timer_state_set_timestamp (self, pomodoro_get_current_time ());
	return obj;
}

static void
pomodoro_timer_state_class_init (PomodoroTimerStateClass * klass,
                                 gpointer klass_data)
{
	pomodoro_timer_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroTimerState_private_offset);
	((PomodoroTimerStateClass *) klass)->create_next_state = (PomodoroTimerState* (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_timer_state_real_create_next_state;
	((PomodoroTimerStateClass *) klass)->calculate_score = (gdouble (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_timer_state_real_calculate_score;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_timer_state_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_timer_state_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_timer_state_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_timer_state_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_STATE_NAME_PROPERTY, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_STATE_ELAPSED_PROPERTY, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_ELAPSED_PROPERTY] = g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_STATE_DURATION_PROPERTY, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_DURATION_PROPERTY] = g_param_spec_double ("duration", "duration", "duration", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_STATE_TIMESTAMP_PROPERTY, pomodoro_timer_state_properties[POMODORO_TIMER_STATE_TIMESTAMP_PROPERTY] = g_param_spec_double ("timestamp", "timestamp", "timestamp", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
pomodoro_timer_state_instance_init (PomodoroTimerState * self,
                                    gpointer klass)
{
	self->priv = pomodoro_timer_state_get_instance_private (self);
	self->priv->_elapsed = 0.0;
	self->priv->_duration = 0.0;
}

static void
pomodoro_timer_state_finalize (GObject * obj)
{
	PomodoroTimerState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_TIMER_STATE, PomodoroTimerState);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (pomodoro_timer_state_parent_class)->finalize (obj);
}

static GType
pomodoro_timer_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroTimerStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_timer_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroTimerState), 0, (GInstanceInitFunc) pomodoro_timer_state_instance_init, NULL };
	GType pomodoro_timer_state_type_id;
	pomodoro_timer_state_type_id = g_type_register_static (G_TYPE_OBJECT, "PomodoroTimerState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PomodoroTimerState_private_offset = g_type_add_instance_private (pomodoro_timer_state_type_id, sizeof (PomodoroTimerStatePrivate));
	return pomodoro_timer_state_type_id;
}

GType
pomodoro_timer_state_get_type (void)
{
	static volatile gsize pomodoro_timer_state_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_timer_state_type_id__once)) {
		GType pomodoro_timer_state_type_id;
		pomodoro_timer_state_type_id = pomodoro_timer_state_get_type_once ();
		g_once_init_leave (&pomodoro_timer_state_type_id__once, pomodoro_timer_state_type_id);
	}
	return pomodoro_timer_state_type_id__once;
}

static void
_vala_pomodoro_timer_state_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	PomodoroTimerState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_TIMER_STATE, PomodoroTimerState);
	switch (property_id) {
		case POMODORO_TIMER_STATE_NAME_PROPERTY:
		g_value_set_string (value, pomodoro_timer_state_get_name (self));
		break;
		case POMODORO_TIMER_STATE_ELAPSED_PROPERTY:
		g_value_set_double (value, pomodoro_timer_state_get_elapsed (self));
		break;
		case POMODORO_TIMER_STATE_DURATION_PROPERTY:
		g_value_set_double (value, pomodoro_timer_state_get_duration (self));
		break;
		case POMODORO_TIMER_STATE_TIMESTAMP_PROPERTY:
		g_value_set_double (value, pomodoro_timer_state_get_timestamp (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_timer_state_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	PomodoroTimerState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_TIMER_STATE, PomodoroTimerState);
	switch (property_id) {
		case POMODORO_TIMER_STATE_NAME_PROPERTY:
		pomodoro_timer_state_set_name (self, g_value_get_string (value));
		break;
		case POMODORO_TIMER_STATE_ELAPSED_PROPERTY:
		pomodoro_timer_state_set_elapsed (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_STATE_DURATION_PROPERTY:
		pomodoro_timer_state_set_duration (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_STATE_TIMESTAMP_PROPERTY:
		pomodoro_timer_state_set_timestamp (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

PomodoroDisabledState*
pomodoro_disabled_state_construct_with_timestamp (GType object_type,
                                                  gdouble timestamp)
{
	PomodoroDisabledState * self = NULL;
	self = (PomodoroDisabledState*) pomodoro_timer_state_construct (object_type);
	pomodoro_timer_state_set_timestamp ((PomodoroTimerState*) self, timestamp);
	return self;
}

PomodoroDisabledState*
pomodoro_disabled_state_new_with_timestamp (gdouble timestamp)
{
	return pomodoro_disabled_state_construct_with_timestamp (POMODORO_TYPE_DISABLED_STATE, timestamp);
}

static PomodoroTimerState*
pomodoro_disabled_state_real_create_next_state (PomodoroTimerState* base,
                                                gdouble score,
                                                gdouble timestamp)
{
	PomodoroDisabledState * self;
	gdouble _tmp0_;
	gdouble _tmp1_;
	PomodoroDisabledState* _tmp2_;
	PomodoroTimerState* _tmp3_;
	PomodoroTimerState* result;
	self = (PomodoroDisabledState*) base;
	_tmp0_ = pomodoro_timer_state_get_timestamp ((PomodoroTimerState*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pomodoro_disabled_state_new_with_timestamp (_tmp1_);
	_tmp3_ = POMODORO_IS_TIMER_STATE (_tmp2_) ? ((PomodoroTimerState*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	result = _tmp3_;
	return result;
}

static gdouble
pomodoro_disabled_state_real_calculate_score (PomodoroTimerState* base,
                                              gdouble score,
                                              gdouble timestamp)
{
	PomodoroDisabledState * self;
	gdouble elapsed = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble result;
	self = (PomodoroDisabledState*) base;
	_tmp0_ = pomodoro_timer_state_get_timestamp ((PomodoroTimerState*) self);
	_tmp1_ = _tmp0_;
	elapsed = timestamp - _tmp1_;
	if (elapsed < POMODORO_TIME_TO_RESET_SCORE) {
		_tmp2_ = score;
	} else {
		_tmp2_ = 0.0;
	}
	result = _tmp2_;
	return result;
}

PomodoroDisabledState*
pomodoro_disabled_state_construct (GType object_type)
{
	PomodoroDisabledState * self = NULL;
	self = (PomodoroDisabledState*) pomodoro_timer_state_construct (object_type);
	return self;
}

PomodoroDisabledState*
pomodoro_disabled_state_new (void)
{
	return pomodoro_disabled_state_construct (POMODORO_TYPE_DISABLED_STATE);
}

static GObject *
pomodoro_disabled_state_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroDisabledState * self;
	parent_class = G_OBJECT_CLASS (pomodoro_disabled_state_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_DISABLED_STATE, PomodoroDisabledState);
	pomodoro_timer_state_set_name ((PomodoroTimerState*) self, "null");
	return obj;
}

static void
pomodoro_disabled_state_class_init (PomodoroDisabledStateClass * klass,
                                    gpointer klass_data)
{
	pomodoro_disabled_state_parent_class = g_type_class_peek_parent (klass);
	((PomodoroTimerStateClass *) klass)->create_next_state = (PomodoroTimerState* (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_disabled_state_real_create_next_state;
	((PomodoroTimerStateClass *) klass)->calculate_score = (gdouble (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_disabled_state_real_calculate_score;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_disabled_state_constructor;
}

static void
pomodoro_disabled_state_instance_init (PomodoroDisabledState * self,
                                       gpointer klass)
{
}

static GType
pomodoro_disabled_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroDisabledStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_disabled_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroDisabledState), 0, (GInstanceInitFunc) pomodoro_disabled_state_instance_init, NULL };
	GType pomodoro_disabled_state_type_id;
	pomodoro_disabled_state_type_id = g_type_register_static (POMODORO_TYPE_TIMER_STATE, "PomodoroDisabledState", &g_define_type_info, 0);
	return pomodoro_disabled_state_type_id;
}

GType
pomodoro_disabled_state_get_type (void)
{
	static volatile gsize pomodoro_disabled_state_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_disabled_state_type_id__once)) {
		GType pomodoro_disabled_state_type_id;
		pomodoro_disabled_state_type_id = pomodoro_disabled_state_get_type_once ();
		g_once_init_leave (&pomodoro_disabled_state_type_id__once, pomodoro_disabled_state_type_id);
	}
	return pomodoro_disabled_state_type_id__once;
}

PomodoroPomodoroState*
pomodoro_pomodoro_state_construct_with_timestamp (GType object_type,
                                                  gdouble timestamp)
{
	PomodoroPomodoroState * self = NULL;
	self = (PomodoroPomodoroState*) pomodoro_timer_state_construct (object_type);
	pomodoro_timer_state_set_timestamp ((PomodoroTimerState*) self, timestamp);
	return self;
}

PomodoroPomodoroState*
pomodoro_pomodoro_state_new_with_timestamp (gdouble timestamp)
{
	return pomodoro_pomodoro_state_construct_with_timestamp (POMODORO_TYPE_POMODORO_STATE, timestamp);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static PomodoroTimerState*
pomodoro_pomodoro_state_real_create_next_state (PomodoroTimerState* base,
                                                gdouble score,
                                                gdouble timestamp)
{
	PomodoroPomodoroState * self;
	gdouble score_limit = 0.0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gdouble _tmp3_;
	gdouble min_long_break_score = 0.0;
	PomodoroTimerState* _tmp4_ = NULL;
	PomodoroTimerState* next_state = NULL;
	PomodoroTimerState* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	PomodoroTimerState* result;
	self = (PomodoroPomodoroState*) base;
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_get_double (_tmp2_, "long-break-interval");
	_g_object_unref0 (_tmp2_);
	score_limit = _tmp3_;
	min_long_break_score = MAX (score_limit * POMODORO_POMODORO_THRESHOLD, score_limit - POMODORO_MISSING_SCORE_THRESHOLD);
	if (score >= min_long_break_score) {
		PomodoroLongBreakState* _tmp5_;
		PomodoroTimerState* _tmp6_;
		_tmp5_ = pomodoro_long_break_state_new_with_timestamp (timestamp);
		_tmp6_ = POMODORO_IS_TIMER_STATE (_tmp5_) ? ((PomodoroTimerState*) _tmp5_) : NULL;
		if (_tmp6_ == NULL) {
			_g_object_unref0 (_tmp5_);
		}
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp6_;
	} else {
		PomodoroShortBreakState* _tmp7_;
		PomodoroTimerState* _tmp8_;
		_tmp7_ = pomodoro_short_break_state_new_with_timestamp (timestamp);
		_tmp8_ = POMODORO_IS_TIMER_STATE (_tmp7_) ? ((PomodoroTimerState*) _tmp7_) : NULL;
		if (_tmp8_ == NULL) {
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp8_;
	}
	_tmp9_ = _g_object_ref0 (_tmp4_);
	next_state = _tmp9_;
	_tmp10_ = pomodoro_timer_state_get_elapsed ((PomodoroTimerState*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = pomodoro_timer_state_get_duration ((PomodoroTimerState*) self);
	_tmp13_ = _tmp12_;
	pomodoro_timer_state_set_elapsed (next_state, MAX (_tmp11_ - _tmp13_, 0.0));
	result = next_state;
	_g_object_unref0 (_tmp4_);
	return result;
}

static gdouble
pomodoro_pomodoro_state_real_calculate_score (PomodoroTimerState* base,
                                              gdouble score,
                                              gdouble timestamp)
{
	PomodoroPomodoroState * self;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble achieved_score = 0.0;
	gdouble _tmp9_ = 0.0;
	gboolean _tmp10_ = FALSE;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble result;
	self = (PomodoroPomodoroState*) base;
	_tmp1_ = pomodoro_timer_state_get_duration ((PomodoroTimerState*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0.0) {
		gdouble _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		_tmp3_ = pomodoro_timer_state_get_elapsed ((PomodoroTimerState*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = pomodoro_timer_state_get_duration ((PomodoroTimerState*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = pomodoro_timer_state_get_duration ((PomodoroTimerState*) self);
		_tmp8_ = _tmp7_;
		_tmp0_ = MIN (_tmp4_, _tmp6_) / _tmp8_;
	} else {
		_tmp0_ = 0.0;
	}
	achieved_score = _tmp0_;
	_tmp11_ = pomodoro_timer_state_get_duration ((PomodoroTimerState*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ <= POMODORO_MIN_POMODORO_TIME) {
		_tmp10_ = TRUE;
	} else {
		gdouble _tmp13_;
		gdouble _tmp14_;
		_tmp13_ = pomodoro_timer_state_get_elapsed ((PomodoroTimerState*) self);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_ >= POMODORO_MIN_POMODORO_TIME;
	}
	if (_tmp10_) {
		_tmp9_ = score + achieved_score;
	} else {
		_tmp9_ = score;
	}
	result = _tmp9_;
	return result;
}

PomodoroPomodoroState*
pomodoro_pomodoro_state_construct (GType object_type)
{
	PomodoroPomodoroState * self = NULL;
	self = (PomodoroPomodoroState*) pomodoro_timer_state_construct (object_type);
	return self;
}

PomodoroPomodoroState*
pomodoro_pomodoro_state_new (void)
{
	return pomodoro_pomodoro_state_construct (POMODORO_TYPE_POMODORO_STATE);
}

static GObject *
pomodoro_pomodoro_state_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroPomodoroState * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (pomodoro_pomodoro_state_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_POMODORO_STATE, PomodoroPomodoroState);
	pomodoro_timer_state_set_name ((PomodoroTimerState*) self, "pomodoro");
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_tmp2_ = _tmp1_;
	pomodoro_timer_state_set_duration ((PomodoroTimerState*) self, g_settings_get_double (_tmp2_, "pomodoro-duration"));
	_g_object_unref0 (_tmp2_);
	return obj;
}

static void
pomodoro_pomodoro_state_class_init (PomodoroPomodoroStateClass * klass,
                                    gpointer klass_data)
{
	pomodoro_pomodoro_state_parent_class = g_type_class_peek_parent (klass);
	((PomodoroTimerStateClass *) klass)->create_next_state = (PomodoroTimerState* (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_pomodoro_state_real_create_next_state;
	((PomodoroTimerStateClass *) klass)->calculate_score = (gdouble (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_pomodoro_state_real_calculate_score;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_pomodoro_state_constructor;
}

static void
pomodoro_pomodoro_state_instance_init (PomodoroPomodoroState * self,
                                       gpointer klass)
{
}

static GType
pomodoro_pomodoro_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroPomodoroStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_pomodoro_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroPomodoroState), 0, (GInstanceInitFunc) pomodoro_pomodoro_state_instance_init, NULL };
	GType pomodoro_pomodoro_state_type_id;
	pomodoro_pomodoro_state_type_id = g_type_register_static (POMODORO_TYPE_TIMER_STATE, "PomodoroPomodoroState", &g_define_type_info, 0);
	return pomodoro_pomodoro_state_type_id;
}

GType
pomodoro_pomodoro_state_get_type (void)
{
	static volatile gsize pomodoro_pomodoro_state_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_pomodoro_state_type_id__once)) {
		GType pomodoro_pomodoro_state_type_id;
		pomodoro_pomodoro_state_type_id = pomodoro_pomodoro_state_get_type_once ();
		g_once_init_leave (&pomodoro_pomodoro_state_type_id__once, pomodoro_pomodoro_state_type_id);
	}
	return pomodoro_pomodoro_state_type_id__once;
}

static PomodoroTimerState*
pomodoro_break_state_real_create_next_state (PomodoroTimerState* base,
                                             gdouble score,
                                             gdouble timestamp)
{
	PomodoroBreakState * self;
	PomodoroPomodoroState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* result;
	self = (PomodoroBreakState*) base;
	_tmp0_ = pomodoro_pomodoro_state_new_with_timestamp (timestamp);
	_tmp1_ = POMODORO_IS_TIMER_STATE (_tmp0_) ? ((PomodoroTimerState*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

PomodoroBreakState*
pomodoro_break_state_construct (GType object_type)
{
	PomodoroBreakState * self = NULL;
	self = (PomodoroBreakState*) pomodoro_timer_state_construct (object_type);
	return self;
}

static void
pomodoro_break_state_class_init (PomodoroBreakStateClass * klass,
                                 gpointer klass_data)
{
	pomodoro_break_state_parent_class = g_type_class_peek_parent (klass);
	((PomodoroTimerStateClass *) klass)->create_next_state = (PomodoroTimerState* (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_break_state_real_create_next_state;
}

static void
pomodoro_break_state_instance_init (PomodoroBreakState * self,
                                    gpointer klass)
{
}

static GType
pomodoro_break_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroBreakStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_break_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroBreakState), 0, (GInstanceInitFunc) pomodoro_break_state_instance_init, NULL };
	GType pomodoro_break_state_type_id;
	pomodoro_break_state_type_id = g_type_register_static (POMODORO_TYPE_TIMER_STATE, "PomodoroBreakState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return pomodoro_break_state_type_id;
}

GType
pomodoro_break_state_get_type (void)
{
	static volatile gsize pomodoro_break_state_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_break_state_type_id__once)) {
		GType pomodoro_break_state_type_id;
		pomodoro_break_state_type_id = pomodoro_break_state_get_type_once ();
		g_once_init_leave (&pomodoro_break_state_type_id__once, pomodoro_break_state_type_id);
	}
	return pomodoro_break_state_type_id__once;
}

PomodoroShortBreakState*
pomodoro_short_break_state_construct_with_timestamp (GType object_type,
                                                     gdouble timestamp)
{
	PomodoroShortBreakState * self = NULL;
	self = (PomodoroShortBreakState*) pomodoro_break_state_construct (object_type);
	pomodoro_timer_state_set_timestamp ((PomodoroTimerState*) self, timestamp);
	return self;
}

PomodoroShortBreakState*
pomodoro_short_break_state_new_with_timestamp (gdouble timestamp)
{
	return pomodoro_short_break_state_construct_with_timestamp (POMODORO_TYPE_SHORT_BREAK_STATE, timestamp);
}

PomodoroShortBreakState*
pomodoro_short_break_state_construct (GType object_type)
{
	PomodoroShortBreakState * self = NULL;
	self = (PomodoroShortBreakState*) pomodoro_break_state_construct (object_type);
	return self;
}

PomodoroShortBreakState*
pomodoro_short_break_state_new (void)
{
	return pomodoro_short_break_state_construct (POMODORO_TYPE_SHORT_BREAK_STATE);
}

static GObject *
pomodoro_short_break_state_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroShortBreakState * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (pomodoro_short_break_state_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_SHORT_BREAK_STATE, PomodoroShortBreakState);
	pomodoro_timer_state_set_name ((PomodoroTimerState*) self, "short-break");
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_tmp2_ = _tmp1_;
	pomodoro_timer_state_set_duration ((PomodoroTimerState*) self, g_settings_get_double (_tmp2_, "short-break-duration"));
	_g_object_unref0 (_tmp2_);
	return obj;
}

static void
pomodoro_short_break_state_class_init (PomodoroShortBreakStateClass * klass,
                                       gpointer klass_data)
{
	pomodoro_short_break_state_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = pomodoro_short_break_state_constructor;
}

static void
pomodoro_short_break_state_instance_init (PomodoroShortBreakState * self,
                                          gpointer klass)
{
}

static GType
pomodoro_short_break_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroShortBreakStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_short_break_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroShortBreakState), 0, (GInstanceInitFunc) pomodoro_short_break_state_instance_init, NULL };
	GType pomodoro_short_break_state_type_id;
	pomodoro_short_break_state_type_id = g_type_register_static (POMODORO_TYPE_BREAK_STATE, "PomodoroShortBreakState", &g_define_type_info, 0);
	return pomodoro_short_break_state_type_id;
}

GType
pomodoro_short_break_state_get_type (void)
{
	static volatile gsize pomodoro_short_break_state_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_short_break_state_type_id__once)) {
		GType pomodoro_short_break_state_type_id;
		pomodoro_short_break_state_type_id = pomodoro_short_break_state_get_type_once ();
		g_once_init_leave (&pomodoro_short_break_state_type_id__once, pomodoro_short_break_state_type_id);
	}
	return pomodoro_short_break_state_type_id__once;
}

PomodoroLongBreakState*
pomodoro_long_break_state_construct_with_timestamp (GType object_type,
                                                    gdouble timestamp)
{
	PomodoroLongBreakState * self = NULL;
	self = (PomodoroLongBreakState*) pomodoro_break_state_construct (object_type);
	pomodoro_timer_state_set_timestamp ((PomodoroTimerState*) self, timestamp);
	return self;
}

PomodoroLongBreakState*
pomodoro_long_break_state_new_with_timestamp (gdouble timestamp)
{
	return pomodoro_long_break_state_construct_with_timestamp (POMODORO_TYPE_LONG_BREAK_STATE, timestamp);
}

static gdouble
pomodoro_long_break_state_real_calculate_score (PomodoroTimerState* base,
                                                gdouble score,
                                                gdouble timestamp)
{
	PomodoroLongBreakState * self;
	gdouble short_break_duration = 0.0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gdouble _tmp3_;
	gdouble long_break_duration = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble min_elapsed = 0.0;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp7_ = FALSE;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble result;
	self = (PomodoroLongBreakState*) base;
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_get_double (_tmp2_, "short-break-duration");
	_g_object_unref0 (_tmp2_);
	short_break_duration = _tmp3_;
	_tmp4_ = pomodoro_timer_state_get_duration ((PomodoroTimerState*) self);
	_tmp5_ = _tmp4_;
	long_break_duration = _tmp5_;
	min_elapsed = short_break_duration + ((long_break_duration - short_break_duration) * POMODORO_SHORT_TO_LONG_BREAK_THRESHOLD);
	_tmp8_ = pomodoro_timer_state_get_elapsed ((PomodoroTimerState*) self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ >= min_elapsed) {
		_tmp7_ = TRUE;
	} else {
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp10_ = pomodoro_timer_state_get_timestamp ((PomodoroTimerState*) self);
		_tmp11_ = _tmp10_;
		_tmp7_ = (timestamp - _tmp11_) >= min_elapsed;
	}
	if (_tmp7_) {
		_tmp6_ = 0.0;
	} else {
		_tmp6_ = score;
	}
	result = _tmp6_;
	return result;
}

PomodoroLongBreakState*
pomodoro_long_break_state_construct (GType object_type)
{
	PomodoroLongBreakState * self = NULL;
	self = (PomodoroLongBreakState*) pomodoro_break_state_construct (object_type);
	return self;
}

PomodoroLongBreakState*
pomodoro_long_break_state_new (void)
{
	return pomodoro_long_break_state_construct (POMODORO_TYPE_LONG_BREAK_STATE);
}

static GObject *
pomodoro_long_break_state_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroLongBreakState * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (pomodoro_long_break_state_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_LONG_BREAK_STATE, PomodoroLongBreakState);
	pomodoro_timer_state_set_name ((PomodoroTimerState*) self, "long-break");
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "preferences");
	_tmp2_ = _tmp1_;
	pomodoro_timer_state_set_duration ((PomodoroTimerState*) self, g_settings_get_double (_tmp2_, "long-break-duration"));
	_g_object_unref0 (_tmp2_);
	return obj;
}

static void
pomodoro_long_break_state_class_init (PomodoroLongBreakStateClass * klass,
                                      gpointer klass_data)
{
	pomodoro_long_break_state_parent_class = g_type_class_peek_parent (klass);
	((PomodoroTimerStateClass *) klass)->calculate_score = (gdouble (*) (PomodoroTimerState*, gdouble, gdouble)) pomodoro_long_break_state_real_calculate_score;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_long_break_state_constructor;
}

static void
pomodoro_long_break_state_instance_init (PomodoroLongBreakState * self,
                                         gpointer klass)
{
}

static GType
pomodoro_long_break_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroLongBreakStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_long_break_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroLongBreakState), 0, (GInstanceInitFunc) pomodoro_long_break_state_instance_init, NULL };
	GType pomodoro_long_break_state_type_id;
	pomodoro_long_break_state_type_id = g_type_register_static (POMODORO_TYPE_BREAK_STATE, "PomodoroLongBreakState", &g_define_type_info, 0);
	return pomodoro_long_break_state_type_id;
}

GType
pomodoro_long_break_state_get_type (void)
{
	static volatile gsize pomodoro_long_break_state_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_long_break_state_type_id__once)) {
		GType pomodoro_long_break_state_type_id;
		pomodoro_long_break_state_type_id = pomodoro_long_break_state_get_type_once ();
		g_once_init_leave (&pomodoro_long_break_state_type_id__once, pomodoro_long_break_state_type_id);
	}
	return pomodoro_long_break_state_type_id__once;
}

