#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 116
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 46
#define ALIAS_COUNT 0
#define TOKEN_COUNT 28
#define EXTERNAL_TOKEN_COUNT 11
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_LT_BANG = 1,
  aux_sym_doctype_token1 = 2,
  anon_sym_GT = 3,
  sym__doctype = 4,
  anon_sym_LT = 5,
  anon_sym_SLASH_GT = 6,
  anon_sym_LT_SLASH = 7,
  anon_sym_EQ = 8,
  sym_attribute_name = 9,
  sym_attribute_value = 10,
  anon_sym_SQUOTE = 11,
  aux_sym_quoted_attribute_value_token1 = 12,
  anon_sym_DQUOTE = 13,
  aux_sym_quoted_attribute_value_token2 = 14,
  sym_text = 15,
  anon_sym_DASH_DASH_DASH = 16,
  anon_sym_RBRACE = 17,
  sym__frontmatter_start = 18,
  sym__interpolation_start = 19,
  sym__start_tag_name = 20,
  sym__script_start_tag_name = 21,
  sym__style_start_tag_name = 22,
  sym__end_tag_name = 23,
  sym_erroneous_end_tag_name = 24,
  sym__implicit_end_tag = 25,
  sym_raw_text = 26,
  sym_comment = 27,
  sym_fragment = 28,
  sym_doctype = 29,
  sym__node = 30,
  sym_element = 31,
  sym_script_element = 32,
  sym_style_element = 33,
  sym_start_tag = 34,
  sym_script_start_tag = 35,
  sym_style_start_tag = 36,
  sym_self_closing_tag = 37,
  sym_end_tag = 38,
  sym_erroneous_end_tag = 39,
  sym_attribute = 40,
  sym_quoted_attribute_value = 41,
  sym_frontmatter = 42,
  sym_interpolation = 43,
  aux_sym_fragment_repeat1 = 44,
  aux_sym_start_tag_repeat1 = 45,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT_BANG] = "<!",
  [aux_sym_doctype_token1] = "doctype_token1",
  [anon_sym_GT] = ">",
  [sym__doctype] = "doctype",
  [anon_sym_LT] = "<",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_EQ] = "=",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_attribute_value_token1] = "attribute_value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_quoted_attribute_value_token2] = "attribute_value",
  [sym_text] = "text",
  [anon_sym_DASH_DASH_DASH] = "---",
  [anon_sym_RBRACE] = "}",
  [sym__frontmatter_start] = "---",
  [sym__interpolation_start] = "{",
  [sym__start_tag_name] = "tag_name",
  [sym__script_start_tag_name] = "tag_name",
  [sym__style_start_tag_name] = "tag_name",
  [sym__end_tag_name] = "tag_name",
  [sym_erroneous_end_tag_name] = "erroneous_end_tag_name",
  [sym__implicit_end_tag] = "_implicit_end_tag",
  [sym_raw_text] = "raw_text",
  [sym_comment] = "comment",
  [sym_fragment] = "fragment",
  [sym_doctype] = "doctype",
  [sym__node] = "_node",
  [sym_element] = "element",
  [sym_script_element] = "script_element",
  [sym_style_element] = "style_element",
  [sym_start_tag] = "start_tag",
  [sym_script_start_tag] = "start_tag",
  [sym_style_start_tag] = "start_tag",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_end_tag] = "end_tag",
  [sym_erroneous_end_tag] = "erroneous_end_tag",
  [sym_attribute] = "attribute",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [sym_frontmatter] = "frontmatter",
  [sym_interpolation] = "interpolation",
  [aux_sym_fragment_repeat1] = "fragment_repeat1",
  [aux_sym_start_tag_repeat1] = "start_tag_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT_BANG] = anon_sym_LT_BANG,
  [aux_sym_doctype_token1] = aux_sym_doctype_token1,
  [anon_sym_GT] = anon_sym_GT,
  [sym__doctype] = sym__doctype,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_attribute_value_token1] = sym_attribute_value,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_quoted_attribute_value_token2] = sym_attribute_value,
  [sym_text] = sym_text,
  [anon_sym_DASH_DASH_DASH] = anon_sym_DASH_DASH_DASH,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym__frontmatter_start] = anon_sym_DASH_DASH_DASH,
  [sym__interpolation_start] = sym__interpolation_start,
  [sym__start_tag_name] = sym__start_tag_name,
  [sym__script_start_tag_name] = sym__start_tag_name,
  [sym__style_start_tag_name] = sym__start_tag_name,
  [sym__end_tag_name] = sym__start_tag_name,
  [sym_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [sym__implicit_end_tag] = sym__implicit_end_tag,
  [sym_raw_text] = sym_raw_text,
  [sym_comment] = sym_comment,
  [sym_fragment] = sym_fragment,
  [sym_doctype] = sym_doctype,
  [sym__node] = sym__node,
  [sym_element] = sym_element,
  [sym_script_element] = sym_script_element,
  [sym_style_element] = sym_style_element,
  [sym_start_tag] = sym_start_tag,
  [sym_script_start_tag] = sym_start_tag,
  [sym_style_start_tag] = sym_start_tag,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_end_tag] = sym_end_tag,
  [sym_erroneous_end_tag] = sym_erroneous_end_tag,
  [sym_attribute] = sym_attribute,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [sym_frontmatter] = sym_frontmatter,
  [sym_interpolation] = sym_interpolation,
  [aux_sym_fragment_repeat1] = aux_sym_fragment_repeat1,
  [aux_sym_start_tag_repeat1] = aux_sym_start_tag_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_doctype_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__doctype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__frontmatter_start] = {
    .visible = true,
    .named = false,
  },
  [sym__interpolation_start] = {
    .visible = true,
    .named = false,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__script_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__style_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_doctype] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_script_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_style_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_frontmatter] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_fragment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_start_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(17);
      if (lookahead == '"') ADVANCE(32);
      if (lookahead == '\'') ADVANCE(29);
      if (lookahead == '-') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '=') ADVANCE(26);
      if (lookahead == '>') ADVANCE(21);
      if (lookahead == '}') ADVANCE(37);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(32);
      if (lookahead == '\'') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(28);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(33);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 3:
      if (lookahead == '\'') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(36);
      END_STATE();
    case 5:
      if (lookahead == '-') ADVANCE(4);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '=') ADVANCE(26);
      if (lookahead == '>') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == '>') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(12);
      END_STATE();
    case 9:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 10:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(8);
      END_STATE();
    case 11:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(9);
      END_STATE();
    case 12:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(11);
      END_STATE();
    case 14:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(14);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 15:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(20);
      END_STATE();
    case 16:
      if (eof) ADVANCE(17);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LT_BANG);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym_doctype_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym_doctype_token1);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym__doctype);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '/') ADVANCE(25);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(31);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(34);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_text);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(14);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_DASH);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 16, .external_lex_state = 2},
  [2] = {.lex_state = 16, .external_lex_state = 3},
  [3] = {.lex_state = 16, .external_lex_state = 3},
  [4] = {.lex_state = 16, .external_lex_state = 3},
  [5] = {.lex_state = 16, .external_lex_state = 3},
  [6] = {.lex_state = 16, .external_lex_state = 4},
  [7] = {.lex_state = 16, .external_lex_state = 3},
  [8] = {.lex_state = 16, .external_lex_state = 4},
  [9] = {.lex_state = 16, .external_lex_state = 4},
  [10] = {.lex_state = 16, .external_lex_state = 4},
  [11] = {.lex_state = 16, .external_lex_state = 4},
  [12] = {.lex_state = 16, .external_lex_state = 3},
  [13] = {.lex_state = 16, .external_lex_state = 3},
  [14] = {.lex_state = 1, .external_lex_state = 4},
  [15] = {.lex_state = 16, .external_lex_state = 3},
  [16] = {.lex_state = 16, .external_lex_state = 3},
  [17] = {.lex_state = 16, .external_lex_state = 4},
  [18] = {.lex_state = 16, .external_lex_state = 3},
  [19] = {.lex_state = 16, .external_lex_state = 4},
  [20] = {.lex_state = 16, .external_lex_state = 3},
  [21] = {.lex_state = 16, .external_lex_state = 4},
  [22] = {.lex_state = 16, .external_lex_state = 3},
  [23] = {.lex_state = 16, .external_lex_state = 4},
  [24] = {.lex_state = 16, .external_lex_state = 3},
  [25] = {.lex_state = 16, .external_lex_state = 4},
  [26] = {.lex_state = 16, .external_lex_state = 4},
  [27] = {.lex_state = 16, .external_lex_state = 3},
  [28] = {.lex_state = 16, .external_lex_state = 4},
  [29] = {.lex_state = 1, .external_lex_state = 4},
  [30] = {.lex_state = 16, .external_lex_state = 4},
  [31] = {.lex_state = 16, .external_lex_state = 3},
  [32] = {.lex_state = 16, .external_lex_state = 4},
  [33] = {.lex_state = 16, .external_lex_state = 4},
  [34] = {.lex_state = 16, .external_lex_state = 3},
  [35] = {.lex_state = 16, .external_lex_state = 3},
  [36] = {.lex_state = 16, .external_lex_state = 3},
  [37] = {.lex_state = 16, .external_lex_state = 4},
  [38] = {.lex_state = 16, .external_lex_state = 4},
  [39] = {.lex_state = 16, .external_lex_state = 4},
  [40] = {.lex_state = 16, .external_lex_state = 3},
  [41] = {.lex_state = 16, .external_lex_state = 3},
  [42] = {.lex_state = 16, .external_lex_state = 4},
  [43] = {.lex_state = 16, .external_lex_state = 3},
  [44] = {.lex_state = 16, .external_lex_state = 4},
  [45] = {.lex_state = 6, .external_lex_state = 5},
  [46] = {.lex_state = 6, .external_lex_state = 5},
  [47] = {.lex_state = 6, .external_lex_state = 5},
  [48] = {.lex_state = 6, .external_lex_state = 5},
  [49] = {.lex_state = 6, .external_lex_state = 5},
  [50] = {.lex_state = 6, .external_lex_state = 6},
  [51] = {.lex_state = 6, .external_lex_state = 5},
  [52] = {.lex_state = 6, .external_lex_state = 6},
  [53] = {.lex_state = 6, .external_lex_state = 6},
  [54] = {.lex_state = 6, .external_lex_state = 6},
  [55] = {.lex_state = 6, .external_lex_state = 6},
  [56] = {.lex_state = 6, .external_lex_state = 5},
  [57] = {.lex_state = 6, .external_lex_state = 5},
  [58] = {.lex_state = 6, .external_lex_state = 6},
  [59] = {.lex_state = 6, .external_lex_state = 5},
  [60] = {.lex_state = 0, .external_lex_state = 7},
  [61] = {.lex_state = 6, .external_lex_state = 5},
  [62] = {.lex_state = 6, .external_lex_state = 5},
  [63] = {.lex_state = 0, .external_lex_state = 8},
  [64] = {.lex_state = 0, .external_lex_state = 8},
  [65] = {.lex_state = 0, .external_lex_state = 8},
  [66] = {.lex_state = 0, .external_lex_state = 8},
  [67] = {.lex_state = 0, .external_lex_state = 7},
  [68] = {.lex_state = 3, .external_lex_state = 6},
  [69] = {.lex_state = 0, .external_lex_state = 6},
  [70] = {.lex_state = 0, .external_lex_state = 9},
  [71] = {.lex_state = 0, .external_lex_state = 8},
  [72] = {.lex_state = 0, .external_lex_state = 8},
  [73] = {.lex_state = 0, .external_lex_state = 8},
  [74] = {.lex_state = 0, .external_lex_state = 8},
  [75] = {.lex_state = 0, .external_lex_state = 8},
  [76] = {.lex_state = 0, .external_lex_state = 8},
  [77] = {.lex_state = 0, .external_lex_state = 8},
  [78] = {.lex_state = 0, .external_lex_state = 8},
  [79] = {.lex_state = 0, .external_lex_state = 6},
  [80] = {.lex_state = 2, .external_lex_state = 6},
  [81] = {.lex_state = 6, .external_lex_state = 6},
  [82] = {.lex_state = 6, .external_lex_state = 6},
  [83] = {.lex_state = 6, .external_lex_state = 6},
  [84] = {.lex_state = 0, .external_lex_state = 6},
  [85] = {.lex_state = 0, .external_lex_state = 9},
  [86] = {.lex_state = 6, .external_lex_state = 6},
  [87] = {.lex_state = 6, .external_lex_state = 6},
  [88] = {.lex_state = 0, .external_lex_state = 8},
  [89] = {.lex_state = 2, .external_lex_state = 6},
  [90] = {.lex_state = 3, .external_lex_state = 6},
  [91] = {.lex_state = 0, .external_lex_state = 6},
  [92] = {.lex_state = 0, .external_lex_state = 10},
  [93] = {.lex_state = 0, .external_lex_state = 6},
  [94] = {.lex_state = 0, .external_lex_state = 6},
  [95] = {.lex_state = 0, .external_lex_state = 6},
  [96] = {.lex_state = 0, .external_lex_state = 6},
  [97] = {.lex_state = 0, .external_lex_state = 6},
  [98] = {.lex_state = 0, .external_lex_state = 6},
  [99] = {.lex_state = 0, .external_lex_state = 11},
  [100] = {.lex_state = 0, .external_lex_state = 6},
  [101] = {.lex_state = 0, .external_lex_state = 6},
  [102] = {.lex_state = 0, .external_lex_state = 6},
  [103] = {.lex_state = 15, .external_lex_state = 6},
  [104] = {.lex_state = 0, .external_lex_state = 6},
  [105] = {.lex_state = 0, .external_lex_state = 6},
  [106] = {.lex_state = 0, .external_lex_state = 6},
  [107] = {.lex_state = 0, .external_lex_state = 6},
  [108] = {.lex_state = 0, .external_lex_state = 6},
  [109] = {.lex_state = 0, .external_lex_state = 6},
  [110] = {.lex_state = 0, .external_lex_state = 6},
  [111] = {.lex_state = 0, .external_lex_state = 11},
  [112] = {.lex_state = 15, .external_lex_state = 6},
  [113] = {.lex_state = 0, .external_lex_state = 6},
  [114] = {.lex_state = 0, .external_lex_state = 10},
  [115] = {.lex_state = 0, .external_lex_state = 6},
};

enum {
  ts_external_token__frontmatter_start = 0,
  ts_external_token__interpolation_start = 1,
  ts_external_token__start_tag_name = 2,
  ts_external_token__script_start_tag_name = 3,
  ts_external_token__style_start_tag_name = 4,
  ts_external_token__end_tag_name = 5,
  ts_external_token_erroneous_end_tag_name = 6,
  ts_external_token_SLASH_GT = 7,
  ts_external_token__implicit_end_tag = 8,
  ts_external_token_raw_text = 9,
  ts_external_token_comment = 10,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__frontmatter_start] = sym__frontmatter_start,
  [ts_external_token__interpolation_start] = sym__interpolation_start,
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__script_start_tag_name] = sym__script_start_tag_name,
  [ts_external_token__style_start_tag_name] = sym__style_start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
  [ts_external_token__implicit_end_tag] = sym__implicit_end_tag,
  [ts_external_token_raw_text] = sym_raw_text,
  [ts_external_token_comment] = sym_comment,
};

static const bool ts_external_scanner_states[12][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__frontmatter_start] = true,
    [ts_external_token__interpolation_start] = true,
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
  },
  [2] = {
    [ts_external_token__frontmatter_start] = true,
    [ts_external_token__interpolation_start] = true,
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__interpolation_start] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token__interpolation_start] = true,
    [ts_external_token_comment] = true,
  },
  [5] = {
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token_comment] = true,
  },
  [6] = {
    [ts_external_token_comment] = true,
  },
  [7] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [8] = {
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
  },
  [9] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [10] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [11] = {
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT_BANG] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym__doctype] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DASH_DASH_DASH] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym__frontmatter_start] = ACTIONS(1),
    [sym__interpolation_start] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__script_start_tag_name] = ACTIONS(1),
    [sym__style_start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym_erroneous_end_tag_name] = ACTIONS(1),
    [sym__implicit_end_tag] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_fragment] = STATE(95),
    [sym_doctype] = STATE(9),
    [sym__node] = STATE(9),
    [sym_element] = STATE(9),
    [sym_script_element] = STATE(9),
    [sym_style_element] = STATE(9),
    [sym_start_tag] = STATE(4),
    [sym_script_start_tag] = STATE(66),
    [sym_style_start_tag] = STATE(65),
    [sym_self_closing_tag] = STATE(17),
    [sym_erroneous_end_tag] = STATE(9),
    [sym_frontmatter] = STATE(8),
    [sym_interpolation] = STATE(9),
    [aux_sym_fragment_repeat1] = STATE(9),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_LT_BANG] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(9),
    [anon_sym_LT_SLASH] = ACTIONS(11),
    [sym_text] = ACTIONS(13),
    [sym__frontmatter_start] = ACTIONS(15),
    [sym__interpolation_start] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_LT_BANG,
    ACTIONS(21), 1,
      anon_sym_LT,
    ACTIONS(23), 1,
      anon_sym_LT_SLASH,
    ACTIONS(25), 1,
      sym_text,
    ACTIONS(27), 1,
      sym__interpolation_start,
    ACTIONS(29), 1,
      sym__implicit_end_tag,
    STATE(3), 1,
      sym_start_tag,
    STATE(22), 1,
      sym_self_closing_tag,
    STATE(43), 1,
      sym_end_tag,
    STATE(63), 1,
      sym_script_start_tag,
    STATE(64), 1,
      sym_style_start_tag,
    STATE(7), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [47] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_LT_BANG,
    ACTIONS(21), 1,
      anon_sym_LT,
    ACTIONS(23), 1,
      anon_sym_LT_SLASH,
    ACTIONS(27), 1,
      sym__interpolation_start,
    ACTIONS(31), 1,
      sym_text,
    ACTIONS(33), 1,
      sym__implicit_end_tag,
    STATE(3), 1,
      sym_start_tag,
    STATE(18), 1,
      sym_end_tag,
    STATE(22), 1,
      sym_self_closing_tag,
    STATE(63), 1,
      sym_script_start_tag,
    STATE(64), 1,
      sym_style_start_tag,
    STATE(2), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [94] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_LT_BANG,
    ACTIONS(21), 1,
      anon_sym_LT,
    ACTIONS(27), 1,
      sym__interpolation_start,
    ACTIONS(35), 1,
      anon_sym_LT_SLASH,
    ACTIONS(37), 1,
      sym_text,
    ACTIONS(39), 1,
      sym__implicit_end_tag,
    STATE(3), 1,
      sym_start_tag,
    STATE(22), 1,
      sym_self_closing_tag,
    STATE(26), 1,
      sym_end_tag,
    STATE(63), 1,
      sym_script_start_tag,
    STATE(64), 1,
      sym_style_start_tag,
    STATE(5), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [141] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_LT_BANG,
    ACTIONS(21), 1,
      anon_sym_LT,
    ACTIONS(25), 1,
      sym_text,
    ACTIONS(27), 1,
      sym__interpolation_start,
    ACTIONS(35), 1,
      anon_sym_LT_SLASH,
    ACTIONS(41), 1,
      sym__implicit_end_tag,
    STATE(3), 1,
      sym_start_tag,
    STATE(22), 1,
      sym_self_closing_tag,
    STATE(44), 1,
      sym_end_tag,
    STATE(63), 1,
      sym_script_start_tag,
    STATE(64), 1,
      sym_style_start_tag,
    STATE(7), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [188] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(17), 1,
      sym__interpolation_start,
    ACTIONS(43), 1,
      ts_builtin_sym_end,
    ACTIONS(45), 1,
      sym_text,
    STATE(4), 1,
      sym_start_tag,
    STATE(17), 1,
      sym_self_closing_tag,
    STATE(65), 1,
      sym_style_start_tag,
    STATE(66), 1,
      sym_script_start_tag,
    STATE(10), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [232] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(47), 1,
      anon_sym_LT_BANG,
    ACTIONS(50), 1,
      anon_sym_LT,
    ACTIONS(53), 1,
      anon_sym_LT_SLASH,
    ACTIONS(56), 1,
      sym_text,
    ACTIONS(59), 1,
      sym__interpolation_start,
    ACTIONS(62), 1,
      sym__implicit_end_tag,
    STATE(3), 1,
      sym_start_tag,
    STATE(22), 1,
      sym_self_closing_tag,
    STATE(63), 1,
      sym_script_start_tag,
    STATE(64), 1,
      sym_style_start_tag,
    STATE(7), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [276] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(17), 1,
      sym__interpolation_start,
    ACTIONS(64), 1,
      ts_builtin_sym_end,
    ACTIONS(66), 1,
      sym_text,
    STATE(4), 1,
      sym_start_tag,
    STATE(17), 1,
      sym_self_closing_tag,
    STATE(65), 1,
      sym_style_start_tag,
    STATE(66), 1,
      sym_script_start_tag,
    STATE(6), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [320] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(17), 1,
      sym__interpolation_start,
    ACTIONS(45), 1,
      sym_text,
    ACTIONS(64), 1,
      ts_builtin_sym_end,
    STATE(4), 1,
      sym_start_tag,
    STATE(17), 1,
      sym_self_closing_tag,
    STATE(65), 1,
      sym_style_start_tag,
    STATE(66), 1,
      sym_script_start_tag,
    STATE(10), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [364] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(62), 1,
      ts_builtin_sym_end,
    ACTIONS(68), 1,
      anon_sym_LT_BANG,
    ACTIONS(71), 1,
      anon_sym_LT,
    ACTIONS(74), 1,
      anon_sym_LT_SLASH,
    ACTIONS(77), 1,
      sym_text,
    ACTIONS(80), 1,
      sym__interpolation_start,
    STATE(4), 1,
      sym_start_tag,
    STATE(17), 1,
      sym_self_closing_tag,
    STATE(65), 1,
      sym_style_start_tag,
    STATE(66), 1,
      sym_script_start_tag,
    STATE(10), 8,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      sym_interpolation,
      aux_sym_fragment_repeat1,
  [408] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_LT,
    ACTIONS(83), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LT,
    ACTIONS(87), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_LT,
    ACTIONS(83), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [450] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      sym_attribute_value,
    ACTIONS(93), 1,
      anon_sym_SQUOTE,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__interpolation_start,
    STATE(81), 2,
      sym_quoted_attribute_value,
      sym_interpolation,
  [470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(99), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_LT,
    ACTIONS(103), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      anon_sym_LT,
    ACTIONS(107), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [512] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_LT,
    ACTIONS(111), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [526] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_LT,
    ACTIONS(115), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [540] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      anon_sym_LT,
    ACTIONS(119), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [554] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(121), 1,
      anon_sym_LT,
    ACTIONS(119), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      anon_sym_LT,
    ACTIONS(107), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_LT,
    ACTIONS(87), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [596] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      anon_sym_LT,
    ACTIONS(123), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [610] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 1,
      anon_sym_LT,
    ACTIONS(127), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 1,
      anon_sym_LT,
    ACTIONS(111), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [638] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      anon_sym_LT,
    ACTIONS(131), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [652] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_LT,
    ACTIONS(135), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [666] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 1,
      sym_attribute_value,
    ACTIONS(141), 1,
      anon_sym_SQUOTE,
    ACTIONS(143), 1,
      anon_sym_DQUOTE,
    ACTIONS(145), 1,
      sym__interpolation_start,
    STATE(59), 2,
      sym_quoted_attribute_value,
      sym_interpolation,
  [686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_LT,
    ACTIONS(103), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 1,
      anon_sym_LT,
    ACTIONS(127), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(99), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [728] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 1,
      anon_sym_LT,
    ACTIONS(147), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [742] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(151), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [756] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 1,
      anon_sym_LT,
    ACTIONS(155), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      anon_sym_LT,
    ACTIONS(159), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(151), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 1,
      anon_sym_LT,
    ACTIONS(155), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 1,
      anon_sym_LT,
    ACTIONS(163), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [826] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 1,
      anon_sym_LT,
    ACTIONS(163), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_LT,
    ACTIONS(135), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      anon_sym_LT,
    ACTIONS(123), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 1,
      anon_sym_LT,
    ACTIONS(167), 5,
      sym__interpolation_start,
      sym__implicit_end_tag,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 1,
      anon_sym_LT,
    ACTIONS(167), 5,
      sym__interpolation_start,
      ts_builtin_sym_end,
      anon_sym_LT_BANG,
      anon_sym_LT_SLASH,
      sym_text,
  [896] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 1,
      sym_attribute_name,
    ACTIONS(171), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(45), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [911] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_GT,
    ACTIONS(178), 1,
      anon_sym_SLASH_GT,
    ACTIONS(180), 1,
      sym_attribute_name,
    STATE(45), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [928] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 1,
      sym_attribute_name,
    ACTIONS(182), 1,
      anon_sym_GT,
    ACTIONS(184), 1,
      anon_sym_SLASH_GT,
    STATE(46), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [945] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 1,
      sym_attribute_name,
    ACTIONS(182), 1,
      anon_sym_GT,
    ACTIONS(186), 1,
      anon_sym_SLASH_GT,
    STATE(49), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [962] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_GT,
    ACTIONS(180), 1,
      sym_attribute_name,
    ACTIONS(188), 1,
      anon_sym_SLASH_GT,
    STATE(45), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [979] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(190), 1,
      anon_sym_GT,
    ACTIONS(192), 1,
      sym_attribute_name,
    STATE(55), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      anon_sym_EQ,
    ACTIONS(194), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [1005] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 1,
      anon_sym_GT,
    ACTIONS(198), 1,
      sym_attribute_name,
    STATE(52), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [1019] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      sym_attribute_name,
    ACTIONS(201), 1,
      anon_sym_GT,
    STATE(52), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [1033] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      sym_attribute_name,
    ACTIONS(203), 1,
      anon_sym_GT,
    STATE(53), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [1047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      sym_attribute_name,
    ACTIONS(205), 1,
      anon_sym_GT,
    STATE(52), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [1061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [1070] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [1079] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 1,
      anon_sym_EQ,
    ACTIONS(194), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1090] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [1099] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 1,
      sym__start_tag_name,
    ACTIONS(213), 1,
      sym__script_start_tag_name,
    ACTIONS(215), 1,
      sym__style_start_tag_name,
  [1112] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [1121] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [1130] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_LT_SLASH,
    ACTIONS(223), 1,
      sym_raw_text,
    STATE(16), 1,
      sym_end_tag,
  [1143] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_LT_SLASH,
    ACTIONS(225), 1,
      sym_raw_text,
    STATE(15), 1,
      sym_end_tag,
  [1156] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_LT_SLASH,
    ACTIONS(229), 1,
      sym_raw_text,
    STATE(32), 1,
      sym_end_tag,
  [1169] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_LT_SLASH,
    ACTIONS(231), 1,
      sym_raw_text,
    STATE(30), 1,
      sym_end_tag,
  [1182] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      sym__script_start_tag_name,
    ACTIONS(215), 1,
      sym__style_start_tag_name,
    ACTIONS(233), 1,
      sym__start_tag_name,
  [1195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_SQUOTE,
    ACTIONS(237), 1,
      aux_sym_quoted_attribute_value_token1,
  [1205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_LT_SLASH,
    STATE(39), 1,
      sym_end_tag,
  [1215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym__end_tag_name,
    ACTIONS(241), 1,
      sym_erroneous_end_tag_name,
  [1225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(243), 1,
      anon_sym_RBRACE,
    ACTIONS(245), 1,
      sym_raw_text,
  [1235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 1,
      anon_sym_DASH_DASH_DASH,
    ACTIONS(249), 1,
      sym_raw_text,
  [1245] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [1253] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(253), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [1261] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_RBRACE,
    ACTIONS(257), 1,
      sym_raw_text,
  [1271] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [1279] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(261), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [1287] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(263), 1,
      anon_sym_RBRACE,
    ACTIONS(265), 1,
      sym_raw_text,
  [1297] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_LT_SLASH,
    STATE(41), 1,
      sym_end_tag,
  [1307] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_DQUOTE,
    ACTIONS(267), 1,
      aux_sym_quoted_attribute_value_token2,
  [1317] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1325] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1333] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1341] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_LT_SLASH,
    STATE(28), 1,
      sym_end_tag,
  [1351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(269), 1,
      sym__end_tag_name,
  [1361] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1369] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(271), 1,
      anon_sym_RBRACE,
    ACTIONS(273), 1,
      sym_raw_text,
  [1387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 1,
      anon_sym_DQUOTE,
    ACTIONS(277), 1,
      aux_sym_quoted_attribute_value_token2,
  [1397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(275), 1,
      anon_sym_SQUOTE,
    ACTIONS(279), 1,
      aux_sym_quoted_attribute_value_token1,
  [1407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_LT_SLASH,
    STATE(40), 1,
      sym_end_tag,
  [1417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 1,
      sym__end_tag_name,
  [1424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 1,
      anon_sym_DASH_DASH_DASH,
  [1431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_GT,
  [1438] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      ts_builtin_sym_end,
  [1445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_RBRACE,
  [1452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      anon_sym_SQUOTE,
  [1459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_GT,
  [1466] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 1,
      sym_erroneous_end_tag_name,
  [1473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 1,
      anon_sym_GT,
  [1480] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      sym__doctype,
  [1487] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 1,
      anon_sym_RBRACE,
  [1494] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 1,
      aux_sym_doctype_token1,
  [1501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_SQUOTE,
  [1508] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 1,
      anon_sym_DQUOTE,
  [1515] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      anon_sym_GT,
  [1522] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(307), 1,
      anon_sym_RBRACE,
  [1529] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 1,
      anon_sym_GT,
  [1536] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 1,
      anon_sym_RBRACE,
  [1543] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 1,
      anon_sym_GT,
  [1550] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      sym_erroneous_end_tag_name,
  [1557] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 1,
      aux_sym_doctype_token1,
  [1564] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 1,
      anon_sym_DQUOTE,
  [1571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      sym__end_tag_name,
  [1578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 1,
      sym__doctype,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 47,
  [SMALL_STATE(4)] = 94,
  [SMALL_STATE(5)] = 141,
  [SMALL_STATE(6)] = 188,
  [SMALL_STATE(7)] = 232,
  [SMALL_STATE(8)] = 276,
  [SMALL_STATE(9)] = 320,
  [SMALL_STATE(10)] = 364,
  [SMALL_STATE(11)] = 408,
  [SMALL_STATE(12)] = 422,
  [SMALL_STATE(13)] = 436,
  [SMALL_STATE(14)] = 450,
  [SMALL_STATE(15)] = 470,
  [SMALL_STATE(16)] = 484,
  [SMALL_STATE(17)] = 498,
  [SMALL_STATE(18)] = 512,
  [SMALL_STATE(19)] = 526,
  [SMALL_STATE(20)] = 540,
  [SMALL_STATE(21)] = 554,
  [SMALL_STATE(22)] = 568,
  [SMALL_STATE(23)] = 582,
  [SMALL_STATE(24)] = 596,
  [SMALL_STATE(25)] = 610,
  [SMALL_STATE(26)] = 624,
  [SMALL_STATE(27)] = 638,
  [SMALL_STATE(28)] = 652,
  [SMALL_STATE(29)] = 666,
  [SMALL_STATE(30)] = 686,
  [SMALL_STATE(31)] = 700,
  [SMALL_STATE(32)] = 714,
  [SMALL_STATE(33)] = 728,
  [SMALL_STATE(34)] = 742,
  [SMALL_STATE(35)] = 756,
  [SMALL_STATE(36)] = 770,
  [SMALL_STATE(37)] = 784,
  [SMALL_STATE(38)] = 798,
  [SMALL_STATE(39)] = 812,
  [SMALL_STATE(40)] = 826,
  [SMALL_STATE(41)] = 840,
  [SMALL_STATE(42)] = 854,
  [SMALL_STATE(43)] = 868,
  [SMALL_STATE(44)] = 882,
  [SMALL_STATE(45)] = 896,
  [SMALL_STATE(46)] = 911,
  [SMALL_STATE(47)] = 928,
  [SMALL_STATE(48)] = 945,
  [SMALL_STATE(49)] = 962,
  [SMALL_STATE(50)] = 979,
  [SMALL_STATE(51)] = 993,
  [SMALL_STATE(52)] = 1005,
  [SMALL_STATE(53)] = 1019,
  [SMALL_STATE(54)] = 1033,
  [SMALL_STATE(55)] = 1047,
  [SMALL_STATE(56)] = 1061,
  [SMALL_STATE(57)] = 1070,
  [SMALL_STATE(58)] = 1079,
  [SMALL_STATE(59)] = 1090,
  [SMALL_STATE(60)] = 1099,
  [SMALL_STATE(61)] = 1112,
  [SMALL_STATE(62)] = 1121,
  [SMALL_STATE(63)] = 1130,
  [SMALL_STATE(64)] = 1143,
  [SMALL_STATE(65)] = 1156,
  [SMALL_STATE(66)] = 1169,
  [SMALL_STATE(67)] = 1182,
  [SMALL_STATE(68)] = 1195,
  [SMALL_STATE(69)] = 1205,
  [SMALL_STATE(70)] = 1215,
  [SMALL_STATE(71)] = 1225,
  [SMALL_STATE(72)] = 1235,
  [SMALL_STATE(73)] = 1245,
  [SMALL_STATE(74)] = 1253,
  [SMALL_STATE(75)] = 1261,
  [SMALL_STATE(76)] = 1271,
  [SMALL_STATE(77)] = 1279,
  [SMALL_STATE(78)] = 1287,
  [SMALL_STATE(79)] = 1297,
  [SMALL_STATE(80)] = 1307,
  [SMALL_STATE(81)] = 1317,
  [SMALL_STATE(82)] = 1325,
  [SMALL_STATE(83)] = 1333,
  [SMALL_STATE(84)] = 1341,
  [SMALL_STATE(85)] = 1351,
  [SMALL_STATE(86)] = 1361,
  [SMALL_STATE(87)] = 1369,
  [SMALL_STATE(88)] = 1377,
  [SMALL_STATE(89)] = 1387,
  [SMALL_STATE(90)] = 1397,
  [SMALL_STATE(91)] = 1407,
  [SMALL_STATE(92)] = 1417,
  [SMALL_STATE(93)] = 1424,
  [SMALL_STATE(94)] = 1431,
  [SMALL_STATE(95)] = 1438,
  [SMALL_STATE(96)] = 1445,
  [SMALL_STATE(97)] = 1452,
  [SMALL_STATE(98)] = 1459,
  [SMALL_STATE(99)] = 1466,
  [SMALL_STATE(100)] = 1473,
  [SMALL_STATE(101)] = 1480,
  [SMALL_STATE(102)] = 1487,
  [SMALL_STATE(103)] = 1494,
  [SMALL_STATE(104)] = 1501,
  [SMALL_STATE(105)] = 1508,
  [SMALL_STATE(106)] = 1515,
  [SMALL_STATE(107)] = 1522,
  [SMALL_STATE(108)] = 1529,
  [SMALL_STATE(109)] = 1536,
  [SMALL_STATE(110)] = 1543,
  [SMALL_STATE(111)] = 1550,
  [SMALL_STATE(112)] = 1557,
  [SMALL_STATE(113)] = 1564,
  [SMALL_STATE(114)] = 1571,
  [SMALL_STATE(115)] = 1578,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fragment, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fragment, 2),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [47] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(115),
  [50] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(60),
  [53] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(111),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(7),
  [59] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(88),
  [62] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2),
  [64] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fragment, 1),
  [66] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(101),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(67),
  [74] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(99),
  [77] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(10),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(71),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_end_tag, 3),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_end_tag, 3),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 2),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 2),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 2),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 2),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_frontmatter, 2),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_frontmatter, 2),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 2),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 2),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_erroneous_end_tag, 3),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_erroneous_end_tag, 3),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 4),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 4),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 4),
  [133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 4),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 3),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 3),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_frontmatter, 3),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_frontmatter, 3),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 3),
  [153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 3),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctype, 4),
  [157] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctype, 4),
  [159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 3),
  [161] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 3),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 3),
  [165] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 3),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2),
  [173] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(51),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(58),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 2),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 3),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 4),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 4),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 3),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 3),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [285] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_astro_external_scanner_create(void);
void tree_sitter_astro_external_scanner_destroy(void *);
bool tree_sitter_astro_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_astro_external_scanner_serialize(void *, char *);
void tree_sitter_astro_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_astro(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_astro_external_scanner_create,
      tree_sitter_astro_external_scanner_destroy,
      tree_sitter_astro_external_scanner_scan,
      tree_sitter_astro_external_scanner_serialize,
      tree_sitter_astro_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
