#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1610
#define LARGE_STATE_COUNT 324
#define SYMBOL_COUNT 246
#define ALIAS_COUNT 4
#define TOKEN_COUNT 130
#define EXTERNAL_TOKEN_COUNT 9
#define FIELD_COUNT 36
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 108

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_as = 6,
  anon_sym_LBRACE = 7,
  anon_sym_COMMA = 8,
  anon_sym_RBRACE = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_with = 12,
  anon_sym_var = 13,
  anon_sym_let = 14,
  anon_sym_const = 15,
  anon_sym_else = 16,
  anon_sym_if = 17,
  anon_sym_switch = 18,
  anon_sym_for = 19,
  anon_sym_LPAREN = 20,
  anon_sym_SEMI = 21,
  anon_sym_RPAREN = 22,
  anon_sym_await = 23,
  anon_sym_in = 24,
  anon_sym_of = 25,
  anon_sym_while = 26,
  anon_sym_do = 27,
  anon_sym_try = 28,
  anon_sym_break = 29,
  anon_sym_continue = 30,
  anon_sym_debugger = 31,
  anon_sym_return = 32,
  anon_sym_throw = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_LT_SLASH = 44,
  anon_sym_class = 45,
  anon_sym_extends = 46,
  anon_sym_async = 47,
  anon_sym_function = 48,
  anon_sym_EQ_GT = 49,
  sym_optional_chain = 50,
  anon_sym_new = 51,
  anon_sym_DOT = 52,
  anon_sym_PLUS_EQ = 53,
  anon_sym_DASH_EQ = 54,
  anon_sym_STAR_EQ = 55,
  anon_sym_SLASH_EQ = 56,
  anon_sym_PERCENT_EQ = 57,
  anon_sym_CARET_EQ = 58,
  anon_sym_AMP_EQ = 59,
  anon_sym_PIPE_EQ = 60,
  anon_sym_GT_GT_EQ = 61,
  anon_sym_GT_GT_GT_EQ = 62,
  anon_sym_LT_LT_EQ = 63,
  anon_sym_STAR_STAR_EQ = 64,
  anon_sym_AMP_AMP_EQ = 65,
  anon_sym_PIPE_PIPE_EQ = 66,
  anon_sym_QMARK_QMARK_EQ = 67,
  anon_sym_DOT_DOT_DOT = 68,
  anon_sym_AMP_AMP = 69,
  anon_sym_PIPE_PIPE = 70,
  anon_sym_GT_GT = 71,
  anon_sym_GT_GT_GT = 72,
  anon_sym_LT_LT = 73,
  anon_sym_AMP = 74,
  anon_sym_CARET = 75,
  anon_sym_PIPE = 76,
  anon_sym_PLUS = 77,
  anon_sym_DASH = 78,
  anon_sym_SLASH = 79,
  anon_sym_PERCENT = 80,
  anon_sym_STAR_STAR = 81,
  anon_sym_LT_EQ = 82,
  anon_sym_EQ_EQ = 83,
  anon_sym_EQ_EQ_EQ = 84,
  anon_sym_BANG_EQ = 85,
  anon_sym_BANG_EQ_EQ = 86,
  anon_sym_GT_EQ = 87,
  anon_sym_QMARK_QMARK = 88,
  anon_sym_instanceof = 89,
  anon_sym_BANG = 90,
  anon_sym_TILDE = 91,
  anon_sym_typeof = 92,
  anon_sym_void = 93,
  anon_sym_delete = 94,
  anon_sym_PLUS_PLUS = 95,
  anon_sym_DASH_DASH = 96,
  anon_sym_DQUOTE = 97,
  anon_sym_SQUOTE = 98,
  sym_unescaped_double_string_fragment = 99,
  sym_unescaped_single_string_fragment = 100,
  sym_escape_sequence = 101,
  sym_comment = 102,
  anon_sym_BQUOTE = 103,
  anon_sym_DOLLAR_LBRACE = 104,
  anon_sym_SLASH2 = 105,
  sym_regex_pattern = 106,
  sym_regex_flags = 107,
  sym_number = 108,
  sym_private_property_identifier = 109,
  anon_sym_target = 110,
  anon_sym_meta = 111,
  sym_this = 112,
  sym_super = 113,
  sym_true = 114,
  sym_false = 115,
  sym_null = 116,
  sym_undefined = 117,
  anon_sym_AT = 118,
  anon_sym_static = 119,
  aux_sym_method_definition_token1 = 120,
  anon_sym_get = 121,
  anon_sym_set = 122,
  sym_glimmer_template_tag_name = 123,
  sym__automatic_semicolon = 124,
  sym__template_chars = 125,
  sym__ternary_qmark = 126,
  sym_html_comment = 127,
  sym_jsx_text = 128,
  sym_raw_text = 129,
  sym_program = 130,
  sym_export_statement = 131,
  sym_namespace_export = 132,
  sym_export_clause = 133,
  sym_export_specifier = 134,
  sym__module_export_name = 135,
  sym_declaration = 136,
  sym_import = 137,
  sym_import_statement = 138,
  sym_import_clause = 139,
  sym__from_clause = 140,
  sym_namespace_import = 141,
  sym_named_imports = 142,
  sym_import_specifier = 143,
  sym_import_attribute = 144,
  sym_statement = 145,
  sym_expression_statement = 146,
  sym_variable_declaration = 147,
  sym_lexical_declaration = 148,
  sym_variable_declarator = 149,
  sym_statement_block = 150,
  sym_else_clause = 151,
  sym_if_statement = 152,
  sym_switch_statement = 153,
  sym_for_statement = 154,
  sym_for_in_statement = 155,
  sym__for_header = 156,
  sym_while_statement = 157,
  sym_do_statement = 158,
  sym_try_statement = 159,
  sym_with_statement = 160,
  sym_break_statement = 161,
  sym_continue_statement = 162,
  sym_debugger_statement = 163,
  sym_return_statement = 164,
  sym_throw_statement = 165,
  sym_empty_statement = 166,
  sym_labeled_statement = 167,
  sym_switch_body = 168,
  sym_switch_case = 169,
  sym_switch_default = 170,
  sym_catch_clause = 171,
  sym_finally_clause = 172,
  sym_parenthesized_expression = 173,
  sym_expression = 174,
  sym_primary_expression = 175,
  sym_yield_expression = 176,
  sym_object = 177,
  sym_object_pattern = 178,
  sym_assignment_pattern = 179,
  sym_object_assignment_pattern = 180,
  sym_array = 181,
  sym_array_pattern = 182,
  sym_glimmer_template = 183,
  sym_glimmer_opening_tag = 184,
  sym_glimmer_closing_tag = 185,
  sym_class = 186,
  sym_class_declaration = 187,
  sym_class_heritage = 188,
  sym_function_expression = 189,
  sym_function_declaration = 190,
  sym_generator_function = 191,
  sym_generator_function_declaration = 192,
  sym_arrow_function = 193,
  sym_call_expression = 194,
  sym_new_expression = 195,
  sym_await_expression = 196,
  sym_member_expression = 197,
  sym_subscript_expression = 198,
  sym_assignment_expression = 199,
  sym__augmented_assignment_lhs = 200,
  sym_augmented_assignment_expression = 201,
  sym__initializer = 202,
  sym__destructuring_pattern = 203,
  sym_spread_element = 204,
  sym_ternary_expression = 205,
  sym_binary_expression = 206,
  sym_unary_expression = 207,
  sym_update_expression = 208,
  sym_sequence_expression = 209,
  sym_string = 210,
  sym_template_string = 211,
  sym_template_substitution = 212,
  sym_regex = 213,
  sym_meta_property = 214,
  sym_arguments = 215,
  sym_decorator = 216,
  sym_decorator_member_expression = 217,
  sym_decorator_call_expression = 218,
  sym_class_body = 219,
  sym_field_definition = 220,
  sym_formal_parameters = 221,
  sym_class_static_block = 222,
  sym_pattern = 223,
  sym_rest_pattern = 224,
  sym_method_definition = 225,
  sym_pair = 226,
  sym_pair_pattern = 227,
  sym__property_name = 228,
  sym_computed_property_name = 229,
  aux_sym_program_repeat1 = 230,
  aux_sym_export_statement_repeat1 = 231,
  aux_sym_export_clause_repeat1 = 232,
  aux_sym_named_imports_repeat1 = 233,
  aux_sym_variable_declaration_repeat1 = 234,
  aux_sym_switch_body_repeat1 = 235,
  aux_sym_object_repeat1 = 236,
  aux_sym_object_pattern_repeat1 = 237,
  aux_sym_array_repeat1 = 238,
  aux_sym_array_pattern_repeat1 = 239,
  aux_sym_sequence_expression_repeat1 = 240,
  aux_sym_string_repeat1 = 241,
  aux_sym_string_repeat2 = 242,
  aux_sym_template_string_repeat1 = 243,
  aux_sym_class_body_repeat1 = 244,
  aux_sym_formal_parameters_repeat1 = 245,
  alias_sym_property_identifier = 246,
  alias_sym_shorthand_property_identifier = 247,
  alias_sym_shorthand_property_identifier_pattern = 248,
  alias_sym_statement_identifier = 249,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_as] = "as",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [sym_optional_chain] = "optional_chain",
  [anon_sym_new] = "new",
  [anon_sym_DOT] = ".",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [aux_sym_method_definition_token1] = "static get",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym_glimmer_template_tag_name] = "glimmer_template_tag_name",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym_raw_text] = "raw_text",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_field_definition] = "field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [sym_optional_chain] = sym_optional_chain,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [aux_sym_method_definition_token1] = aux_sym_method_definition_token1,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym_glimmer_template_tag_name] = sym_glimmer_template_tag_name,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = sym__ternary_qmark,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym_raw_text] = sym_raw_text,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_field_definition] = sym_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_method_definition_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym_glimmer_template_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_close_tag = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constructor = 9,
  field_declaration = 10,
  field_decorator = 11,
  field_finalizer = 12,
  field_flags = 13,
  field_function = 14,
  field_handler = 15,
  field_increment = 16,
  field_index = 17,
  field_initializer = 18,
  field_key = 19,
  field_kind = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_optional_chain = 28,
  field_parameter = 29,
  field_parameters = 30,
  field_pattern = 31,
  field_property = 32,
  field_right = 33,
  field_source = 34,
  field_template = 35,
  field_value = 36,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_template] = "template",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 2},
  [23] = {.index = 27, .length = 1},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 32, .length = 6},
  [27] = {.index = 38, .length = 2},
  [28] = {.index = 40, .length = 2},
  [29] = {.index = 42, .length = 2},
  [30] = {.index = 44, .length = 1},
  [31] = {.index = 45, .length = 1},
  [32] = {.index = 46, .length = 1},
  [33] = {.index = 47, .length = 1},
  [34] = {.index = 48, .length = 2},
  [35] = {.index = 50, .length = 1},
  [36] = {.index = 51, .length = 2},
  [37] = {.index = 53, .length = 2},
  [38] = {.index = 55, .length = 1},
  [39] = {.index = 18, .length = 2},
  [40] = {.index = 20, .length = 2},
  [41] = {.index = 56, .length = 3},
  [42] = {.index = 59, .length = 3},
  [43] = {.index = 59, .length = 3},
  [44] = {.index = 62, .length = 2},
  [45] = {.index = 62, .length = 2},
  [46] = {.index = 64, .length = 3},
  [47] = {.index = 67, .length = 2},
  [48] = {.index = 69, .length = 2},
  [49] = {.index = 71, .length = 2},
  [50] = {.index = 73, .length = 2},
  [51] = {.index = 75, .length = 1},
  [52] = {.index = 76, .length = 1},
  [53] = {.index = 18, .length = 2},
  [54] = {.index = 77, .length = 2},
  [55] = {.index = 79, .length = 3},
  [56] = {.index = 82, .length = 1},
  [57] = {.index = 83, .length = 3},
  [58] = {.index = 86, .length = 6},
  [59] = {.index = 92, .length = 2},
  [60] = {.index = 94, .length = 3},
  [61] = {.index = 97, .length = 1},
  [62] = {.index = 98, .length = 2},
  [63] = {.index = 100, .length = 2},
  [64] = {.index = 102, .length = 2},
  [65] = {.index = 104, .length = 4},
  [66] = {.index = 108, .length = 2},
  [67] = {.index = 110, .length = 2},
  [68] = {.index = 112, .length = 2},
  [69] = {.index = 110, .length = 2},
  [70] = {.index = 114, .length = 2},
  [71] = {.index = 116, .length = 3},
  [72] = {.index = 119, .length = 2},
  [73] = {.index = 121, .length = 2},
  [74] = {.index = 123, .length = 2},
  [75] = {.index = 125, .length = 3},
  [76] = {.index = 128, .length = 2},
  [77] = {.index = 130, .length = 2},
  [78] = {.index = 132, .length = 4},
  [79] = {.index = 136, .length = 2},
  [80] = {.index = 138, .length = 2},
  [81] = {.index = 140, .length = 3},
  [82] = {.index = 143, .length = 2},
  [83] = {.index = 145, .length = 3},
  [84] = {.index = 148, .length = 3},
  [85] = {.index = 151, .length = 3},
  [86] = {.index = 154, .length = 2},
  [87] = {.index = 156, .length = 3},
  [88] = {.index = 159, .length = 4},
  [89] = {.index = 163, .length = 3},
  [90] = {.index = 163, .length = 3},
  [91] = {.index = 166, .length = 3},
  [92] = {.index = 169, .length = 3},
  [93] = {.index = 172, .length = 3},
  [94] = {.index = 175, .length = 4},
  [95] = {.index = 179, .length = 2},
  [96] = {.index = 181, .length = 4},
  [97] = {.index = 185, .length = 4},
  [98] = {.index = 189, .length = 4},
  [99] = {.index = 193, .length = 3},
  [100] = {.index = 196, .length = 2},
  [101] = {.index = 198, .length = 4},
  [102] = {.index = 202, .length = 5},
  [103] = {.index = 207, .length = 4},
  [104] = {.index = 211, .length = 5},
  [105] = {.index = 216, .length = 4},
  [106] = {.index = 220, .length = 4},
  [107] = {.index = 224, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_argument, 0},
    {field_operator, 1},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_declaration, 2},
  [16] =
    {field_body, 2},
    {field_label, 0},
  [18] =
    {field_left, 0},
    {field_right, 2},
  [20] =
    {field_body, 2},
    {field_parameter, 0},
  [22] =
    {field_source, 1},
  [23] =
    {field_body, 2},
    {field_object, 1},
  [25] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [27] =
    {field_kind, 0},
  [28] =
    {field_condition, 1},
    {field_consequence, 2},
  [30] =
    {field_body, 2},
    {field_value, 1},
  [32] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [38] =
    {field_body, 2},
    {field_condition, 1},
  [40] =
    {field_body, 1},
    {field_handler, 2},
  [42] =
    {field_body, 1},
    {field_finalizer, 2},
  [44] =
    {field_label, 1},
  [45] =
    {field_template, 0},
  [46] =
    {field_member, 0},
  [47] =
    {field_property, 0},
  [48] =
    {field_body, 2},
    {field_name, 1},
  [50] =
    {field_body, 2},
  [51] =
    {field_body, 2},
    {field_parameters, 1},
  [53] =
    {field_arguments, 2},
    {field_constructor, 1},
  [55] =
    {field_pattern, 1},
  [56] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [59] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [62] =
    {field_object, 0},
    {field_property, 2},
  [64] =
    {field_arguments, 2},
    {field_function, 0},
    {field_optional_chain, 1},
  [67] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [69] =
    {field_body, 2},
    {field_parameters, 0},
  [71] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [73] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [75] =
    {field_source, 2, .inherited = true},
  [76] =
    {field_value, 2},
  [77] =
    {field_key, 0},
    {field_value, 2},
  [79] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [82] =
    {field_value, 1},
  [83] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [86] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [92] =
    {field_body, 1},
    {field_condition, 3},
  [94] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [97] =
    {field_property, 1},
  [98] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [100] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
  [102] =
    {field_member, 1, .inherited = true},
    {field_template, 1, .inherited = true},
  [104] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
    {field_template, 0, .inherited = true},
    {field_template, 1, .inherited = true},
  [108] =
    {field_body, 3},
    {field_name, 1},
  [110] =
    {field_body, 3},
    {field_parameter, 1},
  [112] =
    {field_body, 3},
    {field_parameters, 2},
  [114] =
    {field_body, 3},
    {field_parameters, 1},
  [116] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [119] =
    {field_flags, 3},
    {field_pattern, 1},
  [121] =
    {field_index, 2},
    {field_object, 0},
  [123] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [125] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [128] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [130] =
    {field_alias, 2},
    {field_name, 0},
  [132] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [136] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [138] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
  [140] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [143] =
    {field_body, 4},
    {field_parameters, 3},
  [145] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [148] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [151] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [154] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [156] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [159] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [163] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [166] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [169] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
    {field_value, 3, .inherited = true},
  [172] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [175] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [179] =
    {field_body, 3},
    {field_value, 1},
  [181] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [185] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [189] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [193] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [196] =
    {field_body, 4},
    {field_parameter, 2},
  [198] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
  [202] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [207] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [211] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [216] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [220] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [224] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_statement_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [18] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [19] = {
    [1] = sym_identifier,
  },
  [30] = {
    [1] = alias_sym_statement_identifier,
  },
  [42] = {
    [2] = alias_sym_property_identifier,
  },
  [44] = {
    [2] = alias_sym_property_identifier,
  },
  [53] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [67] = {
    [1] = sym_identifier,
  },
  [89] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 13,
  [17] = 14,
  [18] = 18,
  [19] = 13,
  [20] = 14,
  [21] = 13,
  [22] = 14,
  [23] = 14,
  [24] = 13,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 36,
  [38] = 38,
  [39] = 25,
  [40] = 40,
  [41] = 38,
  [42] = 27,
  [43] = 43,
  [44] = 44,
  [45] = 26,
  [46] = 29,
  [47] = 30,
  [48] = 31,
  [49] = 32,
  [50] = 33,
  [51] = 34,
  [52] = 35,
  [53] = 43,
  [54] = 44,
  [55] = 40,
  [56] = 56,
  [57] = 56,
  [58] = 56,
  [59] = 56,
  [60] = 56,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 77,
  [79] = 77,
  [80] = 77,
  [81] = 77,
  [82] = 77,
  [83] = 83,
  [84] = 84,
  [85] = 83,
  [86] = 84,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 89,
  [91] = 91,
  [92] = 87,
  [93] = 93,
  [94] = 94,
  [95] = 94,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 97,
  [100] = 100,
  [101] = 97,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 106,
  [110] = 108,
  [111] = 111,
  [112] = 112,
  [113] = 111,
  [114] = 114,
  [115] = 115,
  [116] = 111,
  [117] = 117,
  [118] = 114,
  [119] = 115,
  [120] = 112,
  [121] = 121,
  [122] = 117,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 123,
  [129] = 129,
  [130] = 124,
  [131] = 126,
  [132] = 132,
  [133] = 124,
  [134] = 125,
  [135] = 135,
  [136] = 125,
  [137] = 137,
  [138] = 123,
  [139] = 139,
  [140] = 123,
  [141] = 141,
  [142] = 142,
  [143] = 139,
  [144] = 144,
  [145] = 135,
  [146] = 142,
  [147] = 147,
  [148] = 126,
  [149] = 132,
  [150] = 124,
  [151] = 125,
  [152] = 137,
  [153] = 153,
  [154] = 154,
  [155] = 132,
  [156] = 139,
  [157] = 142,
  [158] = 139,
  [159] = 159,
  [160] = 142,
  [161] = 161,
  [162] = 162,
  [163] = 126,
  [164] = 139,
  [165] = 142,
  [166] = 126,
  [167] = 132,
  [168] = 124,
  [169] = 125,
  [170] = 123,
  [171] = 132,
  [172] = 129,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 174,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 181,
  [193] = 183,
  [194] = 178,
  [195] = 195,
  [196] = 173,
  [197] = 180,
  [198] = 198,
  [199] = 182,
  [200] = 185,
  [201] = 186,
  [202] = 187,
  [203] = 188,
  [204] = 189,
  [205] = 190,
  [206] = 191,
  [207] = 195,
  [208] = 198,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 209,
  [214] = 210,
  [215] = 211,
  [216] = 216,
  [217] = 212,
  [218] = 176,
  [219] = 175,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 216,
  [225] = 225,
  [226] = 216,
  [227] = 181,
  [228] = 183,
  [229] = 178,
  [230] = 173,
  [231] = 180,
  [232] = 182,
  [233] = 185,
  [234] = 187,
  [235] = 174,
  [236] = 189,
  [237] = 190,
  [238] = 191,
  [239] = 195,
  [240] = 198,
  [241] = 209,
  [242] = 210,
  [243] = 211,
  [244] = 212,
  [245] = 176,
  [246] = 175,
  [247] = 247,
  [248] = 183,
  [249] = 178,
  [250] = 173,
  [251] = 180,
  [252] = 182,
  [253] = 174,
  [254] = 185,
  [255] = 187,
  [256] = 188,
  [257] = 189,
  [258] = 190,
  [259] = 191,
  [260] = 195,
  [261] = 198,
  [262] = 209,
  [263] = 210,
  [264] = 211,
  [265] = 212,
  [266] = 266,
  [267] = 221,
  [268] = 268,
  [269] = 176,
  [270] = 174,
  [271] = 175,
  [272] = 181,
  [273] = 181,
  [274] = 183,
  [275] = 178,
  [276] = 276,
  [277] = 173,
  [278] = 180,
  [279] = 279,
  [280] = 182,
  [281] = 185,
  [282] = 187,
  [283] = 188,
  [284] = 189,
  [285] = 190,
  [286] = 191,
  [287] = 195,
  [288] = 198,
  [289] = 209,
  [290] = 210,
  [291] = 211,
  [292] = 212,
  [293] = 176,
  [294] = 175,
  [295] = 188,
  [296] = 296,
  [297] = 297,
  [298] = 297,
  [299] = 296,
  [300] = 297,
  [301] = 301,
  [302] = 301,
  [303] = 303,
  [304] = 303,
  [305] = 301,
  [306] = 303,
  [307] = 307,
  [308] = 307,
  [309] = 309,
  [310] = 63,
  [311] = 62,
  [312] = 312,
  [313] = 313,
  [314] = 307,
  [315] = 307,
  [316] = 316,
  [317] = 307,
  [318] = 318,
  [319] = 312,
  [320] = 307,
  [321] = 316,
  [322] = 312,
  [323] = 313,
  [324] = 61,
  [325] = 318,
  [326] = 326,
  [327] = 64,
  [328] = 307,
  [329] = 329,
  [330] = 329,
  [331] = 313,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 65,
  [340] = 66,
  [341] = 341,
  [342] = 61,
  [343] = 343,
  [344] = 338,
  [345] = 63,
  [346] = 346,
  [347] = 64,
  [348] = 326,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 62,
  [356] = 307,
  [357] = 307,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 427,
  [429] = 429,
  [430] = 341,
  [431] = 427,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 438,
  [440] = 437,
  [441] = 433,
  [442] = 442,
  [443] = 443,
  [444] = 437,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 438,
  [449] = 449,
  [450] = 432,
  [451] = 437,
  [452] = 433,
  [453] = 453,
  [454] = 341,
  [455] = 455,
  [456] = 434,
  [457] = 425,
  [458] = 435,
  [459] = 426,
  [460] = 446,
  [461] = 461,
  [462] = 429,
  [463] = 463,
  [464] = 437,
  [465] = 465,
  [466] = 437,
  [467] = 447,
  [468] = 461,
  [469] = 341,
  [470] = 445,
  [471] = 438,
  [472] = 472,
  [473] = 438,
  [474] = 474,
  [475] = 475,
  [476] = 438,
  [477] = 477,
  [478] = 442,
  [479] = 433,
  [480] = 433,
  [481] = 481,
  [482] = 481,
  [483] = 483,
  [484] = 484,
  [485] = 463,
  [486] = 477,
  [487] = 437,
  [488] = 461,
  [489] = 447,
  [490] = 490,
  [491] = 438,
  [492] = 481,
  [493] = 437,
  [494] = 483,
  [495] = 484,
  [496] = 438,
  [497] = 437,
  [498] = 438,
  [499] = 490,
  [500] = 433,
  [501] = 501,
  [502] = 67,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 62,
  [509] = 509,
  [510] = 63,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 61,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 64,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 66,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 65,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 525,
  [570] = 570,
  [571] = 571,
  [572] = 542,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 501,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 506,
  [584] = 584,
  [585] = 585,
  [586] = 545,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 503,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 505,
  [597] = 515,
  [598] = 545,
  [599] = 67,
  [600] = 504,
  [601] = 511,
  [602] = 67,
  [603] = 603,
  [604] = 525,
  [605] = 522,
  [606] = 509,
  [607] = 542,
  [608] = 507,
  [609] = 506,
  [610] = 578,
  [611] = 559,
  [612] = 526,
  [613] = 560,
  [614] = 506,
  [615] = 519,
  [616] = 520,
  [617] = 561,
  [618] = 521,
  [619] = 562,
  [620] = 584,
  [621] = 574,
  [622] = 524,
  [623] = 576,
  [624] = 624,
  [625] = 540,
  [626] = 543,
  [627] = 627,
  [628] = 528,
  [629] = 624,
  [630] = 72,
  [631] = 571,
  [632] = 550,
  [633] = 534,
  [634] = 74,
  [635] = 73,
  [636] = 75,
  [637] = 531,
  [638] = 533,
  [639] = 544,
  [640] = 70,
  [641] = 69,
  [642] = 68,
  [643] = 564,
  [644] = 514,
  [645] = 518,
  [646] = 71,
  [647] = 553,
  [648] = 552,
  [649] = 554,
  [650] = 555,
  [651] = 556,
  [652] = 556,
  [653] = 557,
  [654] = 545,
  [655] = 525,
  [656] = 542,
  [657] = 595,
  [658] = 512,
  [659] = 579,
  [660] = 580,
  [661] = 558,
  [662] = 567,
  [663] = 588,
  [664] = 592,
  [665] = 594,
  [666] = 570,
  [667] = 573,
  [668] = 578,
  [669] = 585,
  [670] = 587,
  [671] = 591,
  [672] = 593,
  [673] = 565,
  [674] = 517,
  [675] = 581,
  [676] = 527,
  [677] = 589,
  [678] = 529,
  [679] = 546,
  [680] = 530,
  [681] = 532,
  [682] = 574,
  [683] = 576,
  [684] = 571,
  [685] = 595,
  [686] = 579,
  [687] = 580,
  [688] = 588,
  [689] = 592,
  [690] = 594,
  [691] = 570,
  [692] = 573,
  [693] = 575,
  [694] = 585,
  [695] = 587,
  [696] = 591,
  [697] = 593,
  [698] = 581,
  [699] = 589,
  [700] = 566,
  [701] = 582,
  [702] = 568,
  [703] = 584,
  [704] = 563,
  [705] = 513,
  [706] = 506,
  [707] = 567,
  [708] = 535,
  [709] = 537,
  [710] = 566,
  [711] = 538,
  [712] = 539,
  [713] = 582,
  [714] = 541,
  [715] = 568,
  [716] = 547,
  [717] = 548,
  [718] = 549,
  [719] = 575,
  [720] = 542,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 545,
  [728] = 525,
  [729] = 627,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 542,
  [737] = 591,
  [738] = 593,
  [739] = 581,
  [740] = 589,
  [741] = 566,
  [742] = 582,
  [743] = 568,
  [744] = 576,
  [745] = 584,
  [746] = 571,
  [747] = 747,
  [748] = 595,
  [749] = 749,
  [750] = 579,
  [751] = 751,
  [752] = 752,
  [753] = 749,
  [754] = 723,
  [755] = 755,
  [756] = 580,
  [757] = 588,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 545,
  [763] = 525,
  [764] = 764,
  [765] = 592,
  [766] = 594,
  [767] = 751,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 603,
  [772] = 574,
  [773] = 749,
  [774] = 774,
  [775] = 570,
  [776] = 770,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 760,
  [782] = 567,
  [783] = 769,
  [784] = 573,
  [785] = 785,
  [786] = 778,
  [787] = 780,
  [788] = 774,
  [789] = 575,
  [790] = 749,
  [791] = 751,
  [792] = 792,
  [793] = 578,
  [794] = 785,
  [795] = 585,
  [796] = 624,
  [797] = 587,
  [798] = 798,
  [799] = 779,
  [800] = 800,
  [801] = 798,
  [802] = 792,
  [803] = 576,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 556,
  [808] = 808,
  [809] = 809,
  [810] = 808,
  [811] = 808,
  [812] = 812,
  [813] = 808,
  [814] = 808,
  [815] = 734,
  [816] = 808,
  [817] = 574,
  [818] = 571,
  [819] = 567,
  [820] = 579,
  [821] = 580,
  [822] = 588,
  [823] = 592,
  [824] = 594,
  [825] = 570,
  [826] = 573,
  [827] = 575,
  [828] = 578,
  [829] = 585,
  [830] = 587,
  [831] = 591,
  [832] = 593,
  [833] = 581,
  [834] = 589,
  [835] = 566,
  [836] = 582,
  [837] = 568,
  [838] = 584,
  [839] = 506,
  [840] = 595,
  [841] = 841,
  [842] = 841,
  [843] = 841,
  [844] = 841,
  [845] = 845,
  [846] = 841,
  [847] = 845,
  [848] = 848,
  [849] = 723,
  [850] = 850,
  [851] = 851,
  [852] = 850,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 853,
  [857] = 854,
  [858] = 854,
  [859] = 853,
  [860] = 860,
  [861] = 861,
  [862] = 861,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 865,
  [867] = 865,
  [868] = 868,
  [869] = 868,
  [870] = 868,
  [871] = 868,
  [872] = 865,
  [873] = 865,
  [874] = 865,
  [875] = 868,
  [876] = 868,
  [877] = 877,
  [878] = 877,
  [879] = 877,
  [880] = 877,
  [881] = 877,
  [882] = 877,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 62,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 63,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 521,
  [944] = 517,
  [945] = 559,
  [946] = 61,
  [947] = 64,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 889,
  [954] = 893,
  [955] = 955,
  [956] = 892,
  [957] = 889,
  [958] = 958,
  [959] = 958,
  [960] = 960,
  [961] = 961,
  [962] = 562,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 925,
  [968] = 933,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 963,
  [975] = 961,
  [976] = 549,
  [977] = 935,
  [978] = 978,
  [979] = 969,
  [980] = 964,
  [981] = 965,
  [982] = 902,
  [983] = 970,
  [984] = 971,
  [985] = 972,
  [986] = 973,
  [987] = 987,
  [988] = 988,
  [989] = 558,
  [990] = 960,
  [991] = 935,
  [992] = 903,
  [993] = 988,
  [994] = 994,
  [995] = 978,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 997,
  [1000] = 996,
  [1001] = 997,
  [1002] = 998,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1003,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1007,
  [1009] = 1009,
  [1010] = 1009,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1011,
  [1014] = 1004,
  [1015] = 1006,
  [1016] = 1012,
  [1017] = 997,
  [1018] = 997,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1024,
  [1028] = 1024,
  [1029] = 1024,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1024,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1024,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1044,
  [1048] = 1048,
  [1049] = 522,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1031,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1058,
  [1060] = 1038,
  [1061] = 1022,
  [1062] = 515,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1034,
  [1072] = 1070,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 515,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1077,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1075,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1088,
  [1091] = 1073,
  [1092] = 1092,
  [1093] = 1081,
  [1094] = 1094,
  [1095] = 522,
  [1096] = 1079,
  [1097] = 1089,
  [1098] = 1094,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1052,
  [1117] = 1100,
  [1118] = 1101,
  [1119] = 1113,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1053,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1026,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1111,
  [1130] = 1130,
  [1131] = 1101,
  [1132] = 1132,
  [1133] = 1104,
  [1134] = 1134,
  [1135] = 1103,
  [1136] = 1136,
  [1137] = 1112,
  [1138] = 1101,
  [1139] = 1139,
  [1140] = 1111,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1112,
  [1144] = 1111,
  [1145] = 1112,
  [1146] = 1146,
  [1147] = 1084,
  [1148] = 1142,
  [1149] = 1048,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1040,
  [1154] = 1152,
  [1155] = 1128,
  [1156] = 1151,
  [1157] = 1100,
  [1158] = 1150,
  [1159] = 1125,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1132,
  [1163] = 1161,
  [1164] = 1164,
  [1165] = 1122,
  [1166] = 1100,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1168,
  [1188] = 1174,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1184,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 343,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1189,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1180,
  [1207] = 1181,
  [1208] = 1208,
  [1209] = 1208,
  [1210] = 1179,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1167,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1199,
  [1223] = 1178,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1182,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1175,
  [1233] = 1180,
  [1234] = 1181,
  [1235] = 1235,
  [1236] = 1184,
  [1237] = 1217,
  [1238] = 1170,
  [1239] = 1228,
  [1240] = 1175,
  [1241] = 1202,
  [1242] = 1178,
  [1243] = 1225,
  [1244] = 1204,
  [1245] = 1231,
  [1246] = 1173,
  [1247] = 1214,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1189,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1231,
  [1254] = 1252,
  [1255] = 1255,
  [1256] = 1226,
  [1257] = 1257,
  [1258] = 1185,
  [1259] = 1259,
  [1260] = 1208,
  [1261] = 1261,
  [1262] = 1183,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 530,
  [1270] = 532,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1107,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1282,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1320,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1325,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1336,
  [1338] = 1335,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1323,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1346,
  [1347] = 1347,
  [1348] = 1311,
  [1349] = 1282,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1359,
  [1360] = 1273,
  [1361] = 1310,
  [1362] = 1315,
  [1363] = 1324,
  [1364] = 1326,
  [1365] = 1327,
  [1366] = 1366,
  [1367] = 1367,
  [1368] = 1263,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1357,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1377,
  [1378] = 1378,
  [1379] = 1274,
  [1380] = 1275,
  [1381] = 1276,
  [1382] = 1280,
  [1383] = 1294,
  [1384] = 1301,
  [1385] = 1304,
  [1386] = 1386,
  [1387] = 1314,
  [1388] = 1295,
  [1389] = 1389,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1375,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1376,
  [1402] = 1267,
  [1403] = 1328,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1404,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1407,
  [1410] = 1377,
  [1411] = 1411,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1290,
  [1419] = 1356,
  [1420] = 1367,
  [1421] = 1421,
  [1422] = 1279,
  [1423] = 1309,
  [1424] = 1316,
  [1425] = 1318,
  [1426] = 1421,
  [1427] = 1296,
  [1428] = 1297,
  [1429] = 1305,
  [1430] = 1322,
  [1431] = 1415,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1432,
  [1444] = 1433,
  [1445] = 1434,
  [1446] = 1286,
  [1447] = 1298,
  [1448] = 1299,
  [1449] = 1300,
  [1450] = 1306,
  [1451] = 1307,
  [1452] = 1308,
  [1453] = 1435,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1390,
  [1458] = 1391,
  [1459] = 1459,
  [1460] = 1392,
  [1461] = 1400,
  [1462] = 1436,
  [1463] = 1437,
  [1464] = 1342,
  [1465] = 1465,
  [1466] = 1438,
  [1467] = 1439,
  [1468] = 1370,
  [1469] = 1412,
  [1470] = 1413,
  [1471] = 1393,
  [1472] = 1321,
  [1473] = 1473,
  [1474] = 1351,
  [1475] = 1475,
  [1476] = 1476,
  [1477] = 1477,
  [1478] = 1371,
  [1479] = 1312,
  [1480] = 1394,
  [1481] = 1395,
  [1482] = 1334,
  [1483] = 1440,
  [1484] = 1441,
  [1485] = 1442,
  [1486] = 1378,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1345,
  [1490] = 1372,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1347,
  [1494] = 1373,
  [1495] = 1414,
  [1496] = 1386,
  [1497] = 1344,
  [1498] = 540,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1408,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1502,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1508,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1511,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1517,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1517,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1503,
  [1531] = 1531,
  [1532] = 1518,
  [1533] = 1506,
  [1534] = 1114,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1512,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1507,
  [1544] = 1544,
  [1545] = 1529,
  [1546] = 1546,
  [1547] = 1503,
  [1548] = 1535,
  [1549] = 1508,
  [1550] = 1550,
  [1551] = 1544,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1511,
  [1555] = 1550,
  [1556] = 1556,
  [1557] = 1525,
  [1558] = 1529,
  [1559] = 1559,
  [1560] = 1518,
  [1561] = 1520,
  [1562] = 1542,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1526,
  [1566] = 1542,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1521,
  [1570] = 1507,
  [1571] = 1508,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1512,
  [1577] = 1574,
  [1578] = 1574,
  [1579] = 1579,
  [1580] = 1529,
  [1581] = 1581,
  [1582] = 1563,
  [1583] = 1583,
  [1584] = 1574,
  [1585] = 1506,
  [1586] = 1586,
  [1587] = 1506,
  [1588] = 1588,
  [1589] = 1518,
  [1590] = 1507,
  [1591] = 1529,
  [1592] = 1503,
  [1593] = 1593,
  [1594] = 1564,
  [1595] = 1517,
  [1596] = 1518,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1503,
  [1600] = 1506,
  [1601] = 1601,
  [1602] = 1511,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1507,
  [1607] = 1556,
  [1608] = 1517,
  [1609] = 1609,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(75);
      ADVANCE_MAP(
        '!', 155,
        '"', 159,
        '#', 3,
        '$', 201,
        '%', 143,
        '&', 130,
        '\'', 160,
        '(', 83,
        ')', 85,
        '*', 78,
        '+', 137,
        ',', 81,
        '-', 139,
        '.', 102,
        '/', 182,
        '0', 187,
        ':', 86,
        ';', 84,
        '<', 93,
        '=', 88,
        '>', 96,
        '?', 20,
        '@', 205,
        '[', 90,
        '\\', 33,
        ']', 91,
        '^', 133,
        '`', 180,
        's', 199,
        '{', 80,
        '|', 134,
        '}', 82,
        '~', 156,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(72);
      if (lookahead > '@') ADVANCE(203);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(206);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(71);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(183);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(34);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(204);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 154,
        '"', 159,
        '#', 28,
        '\'', 160,
        '(', 83,
        '*', 77,
        '+', 136,
        ',', 81,
        '-', 138,
        '.', 19,
        '/', 140,
        '0', 187,
        ';', 84,
        '<', 92,
        '@', 205,
        '[', 90,
        '\\', 35,
        '`', 180,
        's', 199,
        '{', 80,
        '}', 82,
        '~', 156,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 154,
        '"', 159,
        '#', 28,
        '\'', 160,
        '(', 83,
        '+', 136,
        '-', 138,
        '.', 103,
        '/', 140,
        '0', 187,
        '<', 92,
        '@', 205,
        '[', 90,
        '\\', 35,
        '`', 180,
        '{', 80,
        '~', 156,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 26,
        '"', 159,
        '#', 28,
        '%', 143,
        '&', 130,
        '\'', 160,
        '(', 83,
        ')', 85,
        '*', 78,
        '+', 137,
        ',', 81,
        '-', 139,
        '.', 103,
        '/', 141,
        '0', 187,
        ':', 86,
        ';', 84,
        '<', 93,
        '=', 88,
        '>', 96,
        '?', 20,
        '@', 205,
        '[', 90,
        '\\', 35,
        ']', 91,
        '^', 133,
        '`', 180,
        '{', 80,
        '|', 134,
        '}', 82,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (lookahead > '#' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 26,
        '%', 142,
        '&', 131,
        '(', 83,
        ')', 85,
        '*', 79,
        '+', 136,
        ',', 81,
        '-', 138,
        '.', 101,
        '/', 140,
        ':', 86,
        ';', 84,
        '<', 94,
        '=', 27,
        '>', 97,
        '?', 21,
        '[', 90,
        '\\', 35,
        ']', 91,
        '^', 132,
        '`', 180,
        '{', 80,
        '|', 135,
        '}', 82,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 26,
        '%', 142,
        '&', 131,
        '(', 83,
        ')', 85,
        '*', 79,
        '+', 136,
        ',', 81,
        '-', 138,
        '.', 101,
        '/', 140,
        ':', 86,
        ';', 84,
        '<', 94,
        '=', 27,
        '>', 97,
        '?', 21,
        '[', 90,
        '\\', 35,
        ']', 91,
        '^', 132,
        '`', 180,
        '{', 80,
        '|', 135,
        '}', 82,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 159,
        '#', 28,
        '\'', 160,
        '(', 83,
        '*', 77,
        '.', 103,
        '/', 16,
        '0', 187,
        '<', 25,
        '@', 205,
        '[', 90,
        '\\', 35,
        's', 199,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '/') ADVANCE(16);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(10);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(164);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '`') ADVANCE(180);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      END_STATE();
    case 13:
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '`') ADVANCE(180);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      END_STATE();
    case 14:
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '/') ADVANCE(16);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(14);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(170);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(179);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '?') ADVANCE(153);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '?') ADVANCE(152);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(119);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(182);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 24:
      if (lookahead == '/') ADVANCE(16);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 25:
      if (lookahead == '/') ADVANCE(98);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 28:
      if (lookahead == '\\') ADVANCE(34);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(204);
      END_STATE();
    case 29:
      if (lookahead == '\\') ADVANCE(70);
      if (lookahead == ']') ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(29);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 31:
      if (lookahead == 'g') ADVANCE(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(1);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(62);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(177);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(41);
      if (lookahead == 'x') ADVANCE(62);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(177);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 37:
      if (lookahead == '{') ADVANCE(181);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 41:
      if (lookahead == '{') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 42:
      if (lookahead == '}') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 46:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 47:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(190);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(191);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(203);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(173);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 70:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(29);
      END_STATE();
    case 71:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(184);
      END_STATE();
    case 72:
      if (eof) ADVANCE(75);
      ADVANCE_MAP(
        '!', 155,
        '"', 159,
        '#', 3,
        '$', 201,
        '%', 143,
        '&', 130,
        '\'', 160,
        '(', 83,
        ')', 85,
        '*', 78,
        '+', 137,
        ',', 81,
        '-', 139,
        '.', 102,
        '/', 141,
        '0', 187,
        ':', 86,
        ';', 84,
        '<', 93,
        '=', 88,
        '>', 96,
        '?', 20,
        '@', 205,
        '[', 90,
        '\\', 35,
        ']', 91,
        '^', 133,
        '`', 180,
        's', 199,
        '{', 80,
        '|', 134,
        '}', 82,
        '~', 156,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(72);
      if (lookahead > '@') ADVANCE(203);
      END_STATE();
    case 73:
      if (eof) ADVANCE(75);
      ADVANCE_MAP(
        '!', 155,
        '"', 159,
        '#', 28,
        '%', 142,
        '&', 131,
        '\'', 160,
        '(', 83,
        ')', 85,
        '*', 79,
        '+', 136,
        ',', 81,
        '-', 138,
        '.', 103,
        '/', 140,
        '0', 187,
        ':', 86,
        ';', 84,
        '<', 94,
        '=', 87,
        '>', 97,
        '?', 21,
        '@', 205,
        '[', 90,
        '\\', 35,
        ']', 91,
        '^', 132,
        '`', 180,
        '{', 80,
        '|', 135,
        '}', 82,
        '~', 156,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(73);
      if (lookahead > '#') ADVANCE(203);
      END_STATE();
    case 74:
      if (eof) ADVANCE(75);
      ADVANCE_MAP(
        '!', 154,
        '"', 159,
        '#', 3,
        '\'', 160,
        '(', 83,
        ')', 85,
        '*', 77,
        '+', 136,
        ',', 81,
        '-', 138,
        '.', 19,
        '/', 140,
        '0', 187,
        ':', 86,
        ';', 84,
        '<', 92,
        '=', 89,
        '>', 95,
        '@', 205,
        '[', 90,
        '\\', 35,
        ']', 91,
        '`', 180,
        '{', 80,
        '}', 82,
        '~', 156,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(74);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(203);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(145);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(144);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(147);
      if (lookahead == '>') ADVANCE(99);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(99);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(129);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_optional_chain);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(112);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(121);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(120);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '|') ADVANCE(123);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(122);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(157);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(157);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(158);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(179);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(179);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(163);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(161);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(164);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(169);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(167);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(170);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(173);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(173);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(176);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(71);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(183);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(35);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(185);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 195,
        '0', 189,
        '_', 51,
        'n', 186,
        'B', 47,
        'b', 47,
        'E', 46,
        'e', 46,
        'O', 48,
        'o', 48,
        'X', 56,
        'x', 56,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == 'a') ADVANCE(200);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == 'c') ADVANCE(202);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(197);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == 't') ADVANCE(196);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == 't') ADVANCE(198);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '{') ADVANCE(181);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(31);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(34);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_method_definition_token1);
      if (lookahead == '\n') ADVANCE(206);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'l', 9,
        'm', 10,
        'n', 11,
        'o', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'v', 17,
        'w', 18,
        'y', 19,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'm') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'w') ADVANCE(48);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'h') ADVANCE(51);
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'y') ADVANCE(53);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(60);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(67);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(70);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(71);
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(73);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 33:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 37:
      if (lookahead == 'p') ADVANCE(79);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 41:
      if (lookahead == 'w') ADVANCE(83);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(84);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(87);
      END_STATE();
    case 47:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 52:
      if (lookahead == 'u') ADVANCE(94);
      if (lookahead == 'y') ADVANCE(95);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 54:
      if (lookahead == 'd') ADVANCE(97);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 64:
      if (lookahead == 'c') ADVANCE(107);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 66:
      if (lookahead == 's') ADVANCE(109);
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 73:
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(118);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(119);
      END_STATE();
    case 77:
      if (lookahead == 'c') ADVANCE(120);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 79:
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(125);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 87:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 89:
      if (lookahead == 't') ADVANCE(128);
      END_STATE();
    case 90:
      if (lookahead == 'g') ADVANCE(129);
      END_STATE();
    case 91:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 92:
      if (lookahead == 's') ADVANCE(131);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(132);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 99:
      if (lookahead == 'd') ADVANCE(136);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 101:
      if (lookahead == 'h') ADVANCE(138);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 103:
      if (lookahead == 'c') ADVANCE(140);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 105:
      if (lookahead == 'k') ADVANCE(142);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 107:
      if (lookahead == 'h') ADVANCE(143);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(144);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 111:
      if (lookahead == 'g') ADVANCE(147);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 115:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 116:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 118:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(155);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(156);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(158);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 128:
      if (lookahead == 'c') ADVANCE(160);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 132:
      if (lookahead == 'w') ADVANCE(163);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 135:
      if (lookahead == 'f') ADVANCE(165);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 139:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(168);
      END_STATE();
    case 147:
      if (lookahead == 'g') ADVANCE(169);
      END_STATE();
    case 148:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 150:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 151:
      if (lookahead == 'd') ADVANCE(173);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 153:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 154:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 156:
      if (lookahead == 'n') ADVANCE(177);
      END_STATE();
    case 157:
      if (lookahead == 'n') ADVANCE(178);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(179);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 160:
      if (lookahead == 'h') ADVANCE(180);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(181);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 164:
      if (lookahead == 'f') ADVANCE(183);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(184);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 168:
      if (lookahead == 'u') ADVANCE(185);
      END_STATE();
    case 169:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 173:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 174:
      if (lookahead == 'y') ADVANCE(189);
      END_STATE();
    case 175:
      if (lookahead == 'o') ADVANCE(190);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 177:
      if (lookahead == 'c') ADVANCE(191);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(192);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 184:
      if (lookahead == 'n') ADVANCE(193);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 197:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_glimmer_template_tag_name);
      END_STATE();
    case 199:
      if (lookahead == 'd') ADVANCE(201);
      END_STATE();
    case 200:
      if (lookahead == 'f') ADVANCE(202);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 74, .external_lex_state = 2},
  [2] = {.lex_state = 4, .external_lex_state = 2},
  [3] = {.lex_state = 4, .external_lex_state = 2},
  [4] = {.lex_state = 4, .external_lex_state = 2},
  [5] = {.lex_state = 4, .external_lex_state = 2},
  [6] = {.lex_state = 4, .external_lex_state = 2},
  [7] = {.lex_state = 74, .external_lex_state = 2},
  [8] = {.lex_state = 74, .external_lex_state = 2},
  [9] = {.lex_state = 74, .external_lex_state = 2},
  [10] = {.lex_state = 74, .external_lex_state = 2},
  [11] = {.lex_state = 74, .external_lex_state = 2},
  [12] = {.lex_state = 74, .external_lex_state = 2},
  [13] = {.lex_state = 74, .external_lex_state = 2},
  [14] = {.lex_state = 74, .external_lex_state = 2},
  [15] = {.lex_state = 74, .external_lex_state = 2},
  [16] = {.lex_state = 74, .external_lex_state = 2},
  [17] = {.lex_state = 74, .external_lex_state = 2},
  [18] = {.lex_state = 74, .external_lex_state = 2},
  [19] = {.lex_state = 74, .external_lex_state = 2},
  [20] = {.lex_state = 74, .external_lex_state = 2},
  [21] = {.lex_state = 74, .external_lex_state = 2},
  [22] = {.lex_state = 74, .external_lex_state = 2},
  [23] = {.lex_state = 74, .external_lex_state = 2},
  [24] = {.lex_state = 74, .external_lex_state = 2},
  [25] = {.lex_state = 74, .external_lex_state = 2},
  [26] = {.lex_state = 74, .external_lex_state = 2},
  [27] = {.lex_state = 74, .external_lex_state = 2},
  [28] = {.lex_state = 74, .external_lex_state = 2},
  [29] = {.lex_state = 74, .external_lex_state = 2},
  [30] = {.lex_state = 74, .external_lex_state = 2},
  [31] = {.lex_state = 74, .external_lex_state = 2},
  [32] = {.lex_state = 74, .external_lex_state = 2},
  [33] = {.lex_state = 74, .external_lex_state = 2},
  [34] = {.lex_state = 74, .external_lex_state = 2},
  [35] = {.lex_state = 74, .external_lex_state = 2},
  [36] = {.lex_state = 74, .external_lex_state = 2},
  [37] = {.lex_state = 74, .external_lex_state = 2},
  [38] = {.lex_state = 74, .external_lex_state = 2},
  [39] = {.lex_state = 74, .external_lex_state = 2},
  [40] = {.lex_state = 74, .external_lex_state = 2},
  [41] = {.lex_state = 74, .external_lex_state = 2},
  [42] = {.lex_state = 74, .external_lex_state = 2},
  [43] = {.lex_state = 74, .external_lex_state = 2},
  [44] = {.lex_state = 74, .external_lex_state = 2},
  [45] = {.lex_state = 74, .external_lex_state = 2},
  [46] = {.lex_state = 74, .external_lex_state = 2},
  [47] = {.lex_state = 74, .external_lex_state = 2},
  [48] = {.lex_state = 74, .external_lex_state = 2},
  [49] = {.lex_state = 74, .external_lex_state = 2},
  [50] = {.lex_state = 74, .external_lex_state = 2},
  [51] = {.lex_state = 74, .external_lex_state = 2},
  [52] = {.lex_state = 74, .external_lex_state = 2},
  [53] = {.lex_state = 74, .external_lex_state = 2},
  [54] = {.lex_state = 74, .external_lex_state = 2},
  [55] = {.lex_state = 74, .external_lex_state = 2},
  [56] = {.lex_state = 73, .external_lex_state = 3},
  [57] = {.lex_state = 73, .external_lex_state = 4},
  [58] = {.lex_state = 73, .external_lex_state = 4},
  [59] = {.lex_state = 73, .external_lex_state = 3},
  [60] = {.lex_state = 73, .external_lex_state = 3},
  [61] = {.lex_state = 73, .external_lex_state = 4},
  [62] = {.lex_state = 73, .external_lex_state = 4},
  [63] = {.lex_state = 73, .external_lex_state = 4},
  [64] = {.lex_state = 73, .external_lex_state = 4},
  [65] = {.lex_state = 73, .external_lex_state = 4},
  [66] = {.lex_state = 73, .external_lex_state = 4},
  [67] = {.lex_state = 73, .external_lex_state = 4},
  [68] = {.lex_state = 73, .external_lex_state = 4},
  [69] = {.lex_state = 73, .external_lex_state = 4},
  [70] = {.lex_state = 73, .external_lex_state = 4},
  [71] = {.lex_state = 73, .external_lex_state = 4},
  [72] = {.lex_state = 73, .external_lex_state = 4},
  [73] = {.lex_state = 73, .external_lex_state = 4},
  [74] = {.lex_state = 73, .external_lex_state = 4},
  [75] = {.lex_state = 73, .external_lex_state = 4},
  [76] = {.lex_state = 74, .external_lex_state = 2},
  [77] = {.lex_state = 74, .external_lex_state = 2},
  [78] = {.lex_state = 74, .external_lex_state = 2},
  [79] = {.lex_state = 74, .external_lex_state = 2},
  [80] = {.lex_state = 74, .external_lex_state = 2},
  [81] = {.lex_state = 74, .external_lex_state = 2},
  [82] = {.lex_state = 74, .external_lex_state = 2},
  [83] = {.lex_state = 74, .external_lex_state = 2},
  [84] = {.lex_state = 74, .external_lex_state = 2},
  [85] = {.lex_state = 74, .external_lex_state = 2},
  [86] = {.lex_state = 74, .external_lex_state = 2},
  [87] = {.lex_state = 74, .external_lex_state = 2},
  [88] = {.lex_state = 74, .external_lex_state = 2},
  [89] = {.lex_state = 74, .external_lex_state = 2},
  [90] = {.lex_state = 74, .external_lex_state = 2},
  [91] = {.lex_state = 74, .external_lex_state = 2},
  [92] = {.lex_state = 74, .external_lex_state = 2},
  [93] = {.lex_state = 74, .external_lex_state = 2},
  [94] = {.lex_state = 74, .external_lex_state = 2},
  [95] = {.lex_state = 74, .external_lex_state = 2},
  [96] = {.lex_state = 74, .external_lex_state = 2},
  [97] = {.lex_state = 74, .external_lex_state = 2},
  [98] = {.lex_state = 74, .external_lex_state = 2},
  [99] = {.lex_state = 74, .external_lex_state = 2},
  [100] = {.lex_state = 74, .external_lex_state = 2},
  [101] = {.lex_state = 74, .external_lex_state = 2},
  [102] = {.lex_state = 74, .external_lex_state = 2},
  [103] = {.lex_state = 74, .external_lex_state = 2},
  [104] = {.lex_state = 74, .external_lex_state = 2},
  [105] = {.lex_state = 74, .external_lex_state = 2},
  [106] = {.lex_state = 74, .external_lex_state = 2},
  [107] = {.lex_state = 74, .external_lex_state = 5},
  [108] = {.lex_state = 74, .external_lex_state = 2},
  [109] = {.lex_state = 74, .external_lex_state = 2},
  [110] = {.lex_state = 74, .external_lex_state = 2},
  [111] = {.lex_state = 6, .external_lex_state = 4},
  [112] = {.lex_state = 74, .external_lex_state = 2},
  [113] = {.lex_state = 6, .external_lex_state = 4},
  [114] = {.lex_state = 74, .external_lex_state = 2},
  [115] = {.lex_state = 74, .external_lex_state = 2},
  [116] = {.lex_state = 6, .external_lex_state = 4},
  [117] = {.lex_state = 74, .external_lex_state = 2},
  [118] = {.lex_state = 74, .external_lex_state = 2},
  [119] = {.lex_state = 74, .external_lex_state = 2},
  [120] = {.lex_state = 74, .external_lex_state = 2},
  [121] = {.lex_state = 74, .external_lex_state = 2},
  [122] = {.lex_state = 74, .external_lex_state = 2},
  [123] = {.lex_state = 5, .external_lex_state = 2},
  [124] = {.lex_state = 74, .external_lex_state = 2},
  [125] = {.lex_state = 74, .external_lex_state = 2},
  [126] = {.lex_state = 74, .external_lex_state = 2},
  [127] = {.lex_state = 74, .external_lex_state = 2},
  [128] = {.lex_state = 5, .external_lex_state = 2},
  [129] = {.lex_state = 74, .external_lex_state = 2},
  [130] = {.lex_state = 74, .external_lex_state = 2},
  [131] = {.lex_state = 74, .external_lex_state = 2},
  [132] = {.lex_state = 74, .external_lex_state = 2},
  [133] = {.lex_state = 74, .external_lex_state = 2},
  [134] = {.lex_state = 74, .external_lex_state = 2},
  [135] = {.lex_state = 74, .external_lex_state = 2},
  [136] = {.lex_state = 74, .external_lex_state = 2},
  [137] = {.lex_state = 74, .external_lex_state = 2},
  [138] = {.lex_state = 5, .external_lex_state = 2},
  [139] = {.lex_state = 74, .external_lex_state = 2},
  [140] = {.lex_state = 5, .external_lex_state = 2},
  [141] = {.lex_state = 74, .external_lex_state = 2},
  [142] = {.lex_state = 74, .external_lex_state = 2},
  [143] = {.lex_state = 74, .external_lex_state = 2},
  [144] = {.lex_state = 74, .external_lex_state = 2},
  [145] = {.lex_state = 74, .external_lex_state = 2},
  [146] = {.lex_state = 74, .external_lex_state = 2},
  [147] = {.lex_state = 74, .external_lex_state = 2},
  [148] = {.lex_state = 74, .external_lex_state = 2},
  [149] = {.lex_state = 74, .external_lex_state = 2},
  [150] = {.lex_state = 74, .external_lex_state = 2},
  [151] = {.lex_state = 74, .external_lex_state = 2},
  [152] = {.lex_state = 74, .external_lex_state = 2},
  [153] = {.lex_state = 74, .external_lex_state = 2},
  [154] = {.lex_state = 74, .external_lex_state = 2},
  [155] = {.lex_state = 74, .external_lex_state = 2},
  [156] = {.lex_state = 74, .external_lex_state = 2},
  [157] = {.lex_state = 74, .external_lex_state = 2},
  [158] = {.lex_state = 74, .external_lex_state = 2},
  [159] = {.lex_state = 74, .external_lex_state = 2},
  [160] = {.lex_state = 74, .external_lex_state = 2},
  [161] = {.lex_state = 74, .external_lex_state = 2},
  [162] = {.lex_state = 74, .external_lex_state = 2},
  [163] = {.lex_state = 74, .external_lex_state = 2},
  [164] = {.lex_state = 74, .external_lex_state = 2},
  [165] = {.lex_state = 74, .external_lex_state = 2},
  [166] = {.lex_state = 74, .external_lex_state = 2},
  [167] = {.lex_state = 74, .external_lex_state = 2},
  [168] = {.lex_state = 74, .external_lex_state = 2},
  [169] = {.lex_state = 74, .external_lex_state = 2},
  [170] = {.lex_state = 5, .external_lex_state = 2},
  [171] = {.lex_state = 74, .external_lex_state = 2},
  [172] = {.lex_state = 74, .external_lex_state = 2},
  [173] = {.lex_state = 74, .external_lex_state = 2},
  [174] = {.lex_state = 74, .external_lex_state = 2},
  [175] = {.lex_state = 74, .external_lex_state = 2},
  [176] = {.lex_state = 74, .external_lex_state = 2},
  [177] = {.lex_state = 74, .external_lex_state = 2},
  [178] = {.lex_state = 74, .external_lex_state = 2},
  [179] = {.lex_state = 74, .external_lex_state = 2},
  [180] = {.lex_state = 74, .external_lex_state = 2},
  [181] = {.lex_state = 74, .external_lex_state = 2},
  [182] = {.lex_state = 74, .external_lex_state = 2},
  [183] = {.lex_state = 74, .external_lex_state = 2},
  [184] = {.lex_state = 74, .external_lex_state = 2},
  [185] = {.lex_state = 74, .external_lex_state = 2},
  [186] = {.lex_state = 74, .external_lex_state = 2},
  [187] = {.lex_state = 74, .external_lex_state = 2},
  [188] = {.lex_state = 74, .external_lex_state = 2},
  [189] = {.lex_state = 74, .external_lex_state = 2},
  [190] = {.lex_state = 74, .external_lex_state = 2},
  [191] = {.lex_state = 74, .external_lex_state = 2},
  [192] = {.lex_state = 74, .external_lex_state = 2},
  [193] = {.lex_state = 74, .external_lex_state = 2},
  [194] = {.lex_state = 74, .external_lex_state = 2},
  [195] = {.lex_state = 74, .external_lex_state = 2},
  [196] = {.lex_state = 74, .external_lex_state = 2},
  [197] = {.lex_state = 74, .external_lex_state = 2},
  [198] = {.lex_state = 74, .external_lex_state = 2},
  [199] = {.lex_state = 74, .external_lex_state = 2},
  [200] = {.lex_state = 74, .external_lex_state = 2},
  [201] = {.lex_state = 74, .external_lex_state = 2},
  [202] = {.lex_state = 74, .external_lex_state = 2},
  [203] = {.lex_state = 74, .external_lex_state = 2},
  [204] = {.lex_state = 74, .external_lex_state = 2},
  [205] = {.lex_state = 74, .external_lex_state = 2},
  [206] = {.lex_state = 74, .external_lex_state = 2},
  [207] = {.lex_state = 74, .external_lex_state = 2},
  [208] = {.lex_state = 74, .external_lex_state = 2},
  [209] = {.lex_state = 74, .external_lex_state = 2},
  [210] = {.lex_state = 74, .external_lex_state = 2},
  [211] = {.lex_state = 74, .external_lex_state = 2},
  [212] = {.lex_state = 74, .external_lex_state = 2},
  [213] = {.lex_state = 74, .external_lex_state = 2},
  [214] = {.lex_state = 74, .external_lex_state = 2},
  [215] = {.lex_state = 74, .external_lex_state = 2},
  [216] = {.lex_state = 74, .external_lex_state = 2},
  [217] = {.lex_state = 74, .external_lex_state = 2},
  [218] = {.lex_state = 74, .external_lex_state = 2},
  [219] = {.lex_state = 74, .external_lex_state = 2},
  [220] = {.lex_state = 74, .external_lex_state = 2},
  [221] = {.lex_state = 74, .external_lex_state = 2},
  [222] = {.lex_state = 74, .external_lex_state = 2},
  [223] = {.lex_state = 74, .external_lex_state = 2},
  [224] = {.lex_state = 74, .external_lex_state = 2},
  [225] = {.lex_state = 74, .external_lex_state = 2},
  [226] = {.lex_state = 74, .external_lex_state = 2},
  [227] = {.lex_state = 74, .external_lex_state = 2},
  [228] = {.lex_state = 74, .external_lex_state = 2},
  [229] = {.lex_state = 74, .external_lex_state = 2},
  [230] = {.lex_state = 74, .external_lex_state = 2},
  [231] = {.lex_state = 74, .external_lex_state = 2},
  [232] = {.lex_state = 74, .external_lex_state = 2},
  [233] = {.lex_state = 74, .external_lex_state = 2},
  [234] = {.lex_state = 74, .external_lex_state = 2},
  [235] = {.lex_state = 74, .external_lex_state = 2},
  [236] = {.lex_state = 74, .external_lex_state = 2},
  [237] = {.lex_state = 74, .external_lex_state = 2},
  [238] = {.lex_state = 74, .external_lex_state = 2},
  [239] = {.lex_state = 74, .external_lex_state = 2},
  [240] = {.lex_state = 74, .external_lex_state = 2},
  [241] = {.lex_state = 74, .external_lex_state = 2},
  [242] = {.lex_state = 74, .external_lex_state = 2},
  [243] = {.lex_state = 74, .external_lex_state = 2},
  [244] = {.lex_state = 74, .external_lex_state = 2},
  [245] = {.lex_state = 74, .external_lex_state = 2},
  [246] = {.lex_state = 74, .external_lex_state = 2},
  [247] = {.lex_state = 74, .external_lex_state = 2},
  [248] = {.lex_state = 74, .external_lex_state = 2},
  [249] = {.lex_state = 74, .external_lex_state = 2},
  [250] = {.lex_state = 74, .external_lex_state = 2},
  [251] = {.lex_state = 74, .external_lex_state = 2},
  [252] = {.lex_state = 74, .external_lex_state = 2},
  [253] = {.lex_state = 74, .external_lex_state = 2},
  [254] = {.lex_state = 74, .external_lex_state = 2},
  [255] = {.lex_state = 74, .external_lex_state = 2},
  [256] = {.lex_state = 74, .external_lex_state = 2},
  [257] = {.lex_state = 74, .external_lex_state = 2},
  [258] = {.lex_state = 74, .external_lex_state = 2},
  [259] = {.lex_state = 74, .external_lex_state = 2},
  [260] = {.lex_state = 74, .external_lex_state = 2},
  [261] = {.lex_state = 74, .external_lex_state = 2},
  [262] = {.lex_state = 74, .external_lex_state = 2},
  [263] = {.lex_state = 74, .external_lex_state = 2},
  [264] = {.lex_state = 74, .external_lex_state = 2},
  [265] = {.lex_state = 74, .external_lex_state = 2},
  [266] = {.lex_state = 74, .external_lex_state = 2},
  [267] = {.lex_state = 74, .external_lex_state = 2},
  [268] = {.lex_state = 74, .external_lex_state = 2},
  [269] = {.lex_state = 74, .external_lex_state = 2},
  [270] = {.lex_state = 74, .external_lex_state = 2},
  [271] = {.lex_state = 74, .external_lex_state = 2},
  [272] = {.lex_state = 74, .external_lex_state = 2},
  [273] = {.lex_state = 74, .external_lex_state = 2},
  [274] = {.lex_state = 74, .external_lex_state = 2},
  [275] = {.lex_state = 74, .external_lex_state = 2},
  [276] = {.lex_state = 74, .external_lex_state = 2},
  [277] = {.lex_state = 74, .external_lex_state = 2},
  [278] = {.lex_state = 74, .external_lex_state = 2},
  [279] = {.lex_state = 74, .external_lex_state = 2},
  [280] = {.lex_state = 74, .external_lex_state = 2},
  [281] = {.lex_state = 74, .external_lex_state = 2},
  [282] = {.lex_state = 74, .external_lex_state = 2},
  [283] = {.lex_state = 74, .external_lex_state = 2},
  [284] = {.lex_state = 74, .external_lex_state = 2},
  [285] = {.lex_state = 74, .external_lex_state = 2},
  [286] = {.lex_state = 74, .external_lex_state = 2},
  [287] = {.lex_state = 74, .external_lex_state = 2},
  [288] = {.lex_state = 74, .external_lex_state = 2},
  [289] = {.lex_state = 74, .external_lex_state = 2},
  [290] = {.lex_state = 74, .external_lex_state = 2},
  [291] = {.lex_state = 74, .external_lex_state = 2},
  [292] = {.lex_state = 74, .external_lex_state = 2},
  [293] = {.lex_state = 74, .external_lex_state = 2},
  [294] = {.lex_state = 74, .external_lex_state = 2},
  [295] = {.lex_state = 74, .external_lex_state = 2},
  [296] = {.lex_state = 6, .external_lex_state = 4},
  [297] = {.lex_state = 6, .external_lex_state = 4},
  [298] = {.lex_state = 6, .external_lex_state = 4},
  [299] = {.lex_state = 6, .external_lex_state = 4},
  [300] = {.lex_state = 6, .external_lex_state = 4},
  [301] = {.lex_state = 6, .external_lex_state = 4},
  [302] = {.lex_state = 6, .external_lex_state = 4},
  [303] = {.lex_state = 6, .external_lex_state = 4},
  [304] = {.lex_state = 6, .external_lex_state = 4},
  [305] = {.lex_state = 6, .external_lex_state = 4},
  [306] = {.lex_state = 6, .external_lex_state = 4},
  [307] = {.lex_state = 6, .external_lex_state = 3},
  [308] = {.lex_state = 6, .external_lex_state = 3},
  [309] = {.lex_state = 74, .external_lex_state = 2},
  [310] = {.lex_state = 74, .external_lex_state = 5},
  [311] = {.lex_state = 74, .external_lex_state = 5},
  [312] = {.lex_state = 6, .external_lex_state = 4},
  [313] = {.lex_state = 6, .external_lex_state = 3},
  [314] = {.lex_state = 6, .external_lex_state = 4},
  [315] = {.lex_state = 6, .external_lex_state = 4},
  [316] = {.lex_state = 6, .external_lex_state = 4},
  [317] = {.lex_state = 6, .external_lex_state = 4},
  [318] = {.lex_state = 6, .external_lex_state = 3},
  [319] = {.lex_state = 6, .external_lex_state = 4},
  [320] = {.lex_state = 6, .external_lex_state = 4},
  [321] = {.lex_state = 6, .external_lex_state = 4},
  [322] = {.lex_state = 6, .external_lex_state = 4},
  [323] = {.lex_state = 6, .external_lex_state = 3},
  [324] = {.lex_state = 74, .external_lex_state = 2},
  [325] = {.lex_state = 6, .external_lex_state = 3},
  [326] = {.lex_state = 6, .external_lex_state = 3},
  [327] = {.lex_state = 74, .external_lex_state = 2},
  [328] = {.lex_state = 6, .external_lex_state = 3},
  [329] = {.lex_state = 6, .external_lex_state = 4},
  [330] = {.lex_state = 6, .external_lex_state = 4},
  [331] = {.lex_state = 6, .external_lex_state = 3},
  [332] = {.lex_state = 74, .external_lex_state = 2},
  [333] = {.lex_state = 74, .external_lex_state = 5},
  [334] = {.lex_state = 74, .external_lex_state = 2},
  [335] = {.lex_state = 74, .external_lex_state = 5},
  [336] = {.lex_state = 74, .external_lex_state = 2},
  [337] = {.lex_state = 74, .external_lex_state = 5},
  [338] = {.lex_state = 6, .external_lex_state = 4},
  [339] = {.lex_state = 74, .external_lex_state = 5},
  [340] = {.lex_state = 74, .external_lex_state = 5},
  [341] = {.lex_state = 74, .external_lex_state = 5},
  [342] = {.lex_state = 74, .external_lex_state = 5},
  [343] = {.lex_state = 74, .external_lex_state = 2},
  [344] = {.lex_state = 6, .external_lex_state = 4},
  [345] = {.lex_state = 74, .external_lex_state = 5},
  [346] = {.lex_state = 74, .external_lex_state = 5},
  [347] = {.lex_state = 74, .external_lex_state = 5},
  [348] = {.lex_state = 6, .external_lex_state = 3},
  [349] = {.lex_state = 74, .external_lex_state = 5},
  [350] = {.lex_state = 74, .external_lex_state = 5},
  [351] = {.lex_state = 74, .external_lex_state = 2},
  [352] = {.lex_state = 74, .external_lex_state = 5},
  [353] = {.lex_state = 74, .external_lex_state = 5},
  [354] = {.lex_state = 74, .external_lex_state = 5},
  [355] = {.lex_state = 74, .external_lex_state = 5},
  [356] = {.lex_state = 6, .external_lex_state = 3},
  [357] = {.lex_state = 6, .external_lex_state = 3},
  [358] = {.lex_state = 74, .external_lex_state = 2},
  [359] = {.lex_state = 74, .external_lex_state = 2},
  [360] = {.lex_state = 74, .external_lex_state = 2},
  [361] = {.lex_state = 74, .external_lex_state = 2},
  [362] = {.lex_state = 74, .external_lex_state = 2},
  [363] = {.lex_state = 74, .external_lex_state = 2},
  [364] = {.lex_state = 74, .external_lex_state = 2},
  [365] = {.lex_state = 74, .external_lex_state = 2},
  [366] = {.lex_state = 74, .external_lex_state = 2},
  [367] = {.lex_state = 74, .external_lex_state = 2},
  [368] = {.lex_state = 74, .external_lex_state = 2},
  [369] = {.lex_state = 74, .external_lex_state = 2},
  [370] = {.lex_state = 74, .external_lex_state = 2},
  [371] = {.lex_state = 74, .external_lex_state = 2},
  [372] = {.lex_state = 74, .external_lex_state = 2},
  [373] = {.lex_state = 74, .external_lex_state = 2},
  [374] = {.lex_state = 74, .external_lex_state = 2},
  [375] = {.lex_state = 74, .external_lex_state = 2},
  [376] = {.lex_state = 74, .external_lex_state = 2},
  [377] = {.lex_state = 74, .external_lex_state = 2},
  [378] = {.lex_state = 74, .external_lex_state = 2},
  [379] = {.lex_state = 74, .external_lex_state = 2},
  [380] = {.lex_state = 74, .external_lex_state = 2},
  [381] = {.lex_state = 74, .external_lex_state = 2},
  [382] = {.lex_state = 74, .external_lex_state = 2},
  [383] = {.lex_state = 74, .external_lex_state = 2},
  [384] = {.lex_state = 6, .external_lex_state = 3},
  [385] = {.lex_state = 74, .external_lex_state = 2},
  [386] = {.lex_state = 74, .external_lex_state = 2},
  [387] = {.lex_state = 74, .external_lex_state = 2},
  [388] = {.lex_state = 74, .external_lex_state = 2},
  [389] = {.lex_state = 74, .external_lex_state = 2},
  [390] = {.lex_state = 74, .external_lex_state = 2},
  [391] = {.lex_state = 74, .external_lex_state = 2},
  [392] = {.lex_state = 74, .external_lex_state = 2},
  [393] = {.lex_state = 74, .external_lex_state = 2},
  [394] = {.lex_state = 74, .external_lex_state = 2},
  [395] = {.lex_state = 74, .external_lex_state = 2},
  [396] = {.lex_state = 74, .external_lex_state = 2},
  [397] = {.lex_state = 74, .external_lex_state = 2},
  [398] = {.lex_state = 74, .external_lex_state = 2},
  [399] = {.lex_state = 74, .external_lex_state = 2},
  [400] = {.lex_state = 74, .external_lex_state = 2},
  [401] = {.lex_state = 74, .external_lex_state = 2},
  [402] = {.lex_state = 74, .external_lex_state = 2},
  [403] = {.lex_state = 74, .external_lex_state = 2},
  [404] = {.lex_state = 74, .external_lex_state = 2},
  [405] = {.lex_state = 74, .external_lex_state = 2},
  [406] = {.lex_state = 74, .external_lex_state = 2},
  [407] = {.lex_state = 74, .external_lex_state = 2},
  [408] = {.lex_state = 74, .external_lex_state = 2},
  [409] = {.lex_state = 74, .external_lex_state = 2},
  [410] = {.lex_state = 74, .external_lex_state = 2},
  [411] = {.lex_state = 74, .external_lex_state = 2},
  [412] = {.lex_state = 74, .external_lex_state = 2},
  [413] = {.lex_state = 74, .external_lex_state = 2},
  [414] = {.lex_state = 74, .external_lex_state = 2},
  [415] = {.lex_state = 74, .external_lex_state = 2},
  [416] = {.lex_state = 74, .external_lex_state = 2},
  [417] = {.lex_state = 74, .external_lex_state = 2},
  [418] = {.lex_state = 74, .external_lex_state = 2},
  [419] = {.lex_state = 74, .external_lex_state = 2},
  [420] = {.lex_state = 74, .external_lex_state = 2},
  [421] = {.lex_state = 74, .external_lex_state = 2},
  [422] = {.lex_state = 74, .external_lex_state = 2},
  [423] = {.lex_state = 74, .external_lex_state = 2},
  [424] = {.lex_state = 6, .external_lex_state = 4},
  [425] = {.lex_state = 6, .external_lex_state = 3},
  [426] = {.lex_state = 6, .external_lex_state = 3},
  [427] = {.lex_state = 6, .external_lex_state = 4},
  [428] = {.lex_state = 6, .external_lex_state = 4},
  [429] = {.lex_state = 6, .external_lex_state = 3},
  [430] = {.lex_state = 6, .external_lex_state = 3},
  [431] = {.lex_state = 6, .external_lex_state = 4},
  [432] = {.lex_state = 6, .external_lex_state = 3},
  [433] = {.lex_state = 6, .external_lex_state = 3},
  [434] = {.lex_state = 6, .external_lex_state = 3},
  [435] = {.lex_state = 6, .external_lex_state = 3},
  [436] = {.lex_state = 6, .external_lex_state = 3},
  [437] = {.lex_state = 6, .external_lex_state = 3},
  [438] = {.lex_state = 6, .external_lex_state = 3},
  [439] = {.lex_state = 6, .external_lex_state = 3},
  [440] = {.lex_state = 6, .external_lex_state = 3},
  [441] = {.lex_state = 6, .external_lex_state = 3},
  [442] = {.lex_state = 6, .external_lex_state = 3},
  [443] = {.lex_state = 74, .external_lex_state = 2},
  [444] = {.lex_state = 6, .external_lex_state = 4},
  [445] = {.lex_state = 6, .external_lex_state = 4},
  [446] = {.lex_state = 6, .external_lex_state = 4},
  [447] = {.lex_state = 6, .external_lex_state = 3},
  [448] = {.lex_state = 6, .external_lex_state = 4},
  [449] = {.lex_state = 74, .external_lex_state = 2},
  [450] = {.lex_state = 6, .external_lex_state = 4},
  [451] = {.lex_state = 6, .external_lex_state = 4},
  [452] = {.lex_state = 6, .external_lex_state = 4},
  [453] = {.lex_state = 74, .external_lex_state = 2},
  [454] = {.lex_state = 6, .external_lex_state = 4},
  [455] = {.lex_state = 74, .external_lex_state = 2},
  [456] = {.lex_state = 6, .external_lex_state = 4},
  [457] = {.lex_state = 6, .external_lex_state = 4},
  [458] = {.lex_state = 6, .external_lex_state = 4},
  [459] = {.lex_state = 6, .external_lex_state = 4},
  [460] = {.lex_state = 6, .external_lex_state = 4},
  [461] = {.lex_state = 6, .external_lex_state = 3},
  [462] = {.lex_state = 6, .external_lex_state = 4},
  [463] = {.lex_state = 6, .external_lex_state = 3},
  [464] = {.lex_state = 6, .external_lex_state = 4},
  [465] = {.lex_state = 74, .external_lex_state = 2},
  [466] = {.lex_state = 6, .external_lex_state = 4},
  [467] = {.lex_state = 6, .external_lex_state = 3},
  [468] = {.lex_state = 6, .external_lex_state = 3},
  [469] = {.lex_state = 74, .external_lex_state = 2},
  [470] = {.lex_state = 6, .external_lex_state = 4},
  [471] = {.lex_state = 6, .external_lex_state = 4},
  [472] = {.lex_state = 74, .external_lex_state = 2},
  [473] = {.lex_state = 6, .external_lex_state = 4},
  [474] = {.lex_state = 74, .external_lex_state = 2},
  [475] = {.lex_state = 74, .external_lex_state = 2},
  [476] = {.lex_state = 6, .external_lex_state = 4},
  [477] = {.lex_state = 6, .external_lex_state = 3},
  [478] = {.lex_state = 6, .external_lex_state = 3},
  [479] = {.lex_state = 6, .external_lex_state = 4},
  [480] = {.lex_state = 6, .external_lex_state = 4},
  [481] = {.lex_state = 6, .external_lex_state = 3},
  [482] = {.lex_state = 6, .external_lex_state = 3},
  [483] = {.lex_state = 6, .external_lex_state = 3},
  [484] = {.lex_state = 6, .external_lex_state = 3},
  [485] = {.lex_state = 6, .external_lex_state = 3},
  [486] = {.lex_state = 6, .external_lex_state = 3},
  [487] = {.lex_state = 6, .external_lex_state = 3},
  [488] = {.lex_state = 6, .external_lex_state = 3},
  [489] = {.lex_state = 6, .external_lex_state = 3},
  [490] = {.lex_state = 6, .external_lex_state = 3},
  [491] = {.lex_state = 6, .external_lex_state = 3},
  [492] = {.lex_state = 6, .external_lex_state = 3},
  [493] = {.lex_state = 6, .external_lex_state = 3},
  [494] = {.lex_state = 6, .external_lex_state = 3},
  [495] = {.lex_state = 6, .external_lex_state = 3},
  [496] = {.lex_state = 6, .external_lex_state = 3},
  [497] = {.lex_state = 6, .external_lex_state = 3},
  [498] = {.lex_state = 6, .external_lex_state = 3},
  [499] = {.lex_state = 6, .external_lex_state = 3},
  [500] = {.lex_state = 6, .external_lex_state = 3},
  [501] = {.lex_state = 73, .external_lex_state = 3},
  [502] = {.lex_state = 73, .external_lex_state = 4},
  [503] = {.lex_state = 73, .external_lex_state = 3},
  [504] = {.lex_state = 73, .external_lex_state = 3},
  [505] = {.lex_state = 73, .external_lex_state = 3},
  [506] = {.lex_state = 73, .external_lex_state = 3},
  [507] = {.lex_state = 73, .external_lex_state = 3},
  [508] = {.lex_state = 73, .external_lex_state = 4},
  [509] = {.lex_state = 73, .external_lex_state = 3},
  [510] = {.lex_state = 73, .external_lex_state = 4},
  [511] = {.lex_state = 73, .external_lex_state = 3},
  [512] = {.lex_state = 73, .external_lex_state = 3},
  [513] = {.lex_state = 73, .external_lex_state = 3},
  [514] = {.lex_state = 73, .external_lex_state = 3},
  [515] = {.lex_state = 73, .external_lex_state = 3},
  [516] = {.lex_state = 73, .external_lex_state = 3},
  [517] = {.lex_state = 73, .external_lex_state = 3},
  [518] = {.lex_state = 73, .external_lex_state = 3},
  [519] = {.lex_state = 73, .external_lex_state = 3},
  [520] = {.lex_state = 73, .external_lex_state = 3},
  [521] = {.lex_state = 73, .external_lex_state = 3},
  [522] = {.lex_state = 73, .external_lex_state = 3},
  [523] = {.lex_state = 73, .external_lex_state = 3},
  [524] = {.lex_state = 73, .external_lex_state = 3},
  [525] = {.lex_state = 73, .external_lex_state = 3},
  [526] = {.lex_state = 73, .external_lex_state = 3},
  [527] = {.lex_state = 73, .external_lex_state = 3},
  [528] = {.lex_state = 73, .external_lex_state = 3},
  [529] = {.lex_state = 73, .external_lex_state = 3},
  [530] = {.lex_state = 73, .external_lex_state = 3},
  [531] = {.lex_state = 73, .external_lex_state = 3},
  [532] = {.lex_state = 73, .external_lex_state = 3},
  [533] = {.lex_state = 73, .external_lex_state = 3},
  [534] = {.lex_state = 73, .external_lex_state = 3},
  [535] = {.lex_state = 73, .external_lex_state = 3},
  [536] = {.lex_state = 73, .external_lex_state = 3},
  [537] = {.lex_state = 73, .external_lex_state = 3},
  [538] = {.lex_state = 73, .external_lex_state = 3},
  [539] = {.lex_state = 73, .external_lex_state = 3},
  [540] = {.lex_state = 73, .external_lex_state = 3},
  [541] = {.lex_state = 73, .external_lex_state = 3},
  [542] = {.lex_state = 73, .external_lex_state = 3},
  [543] = {.lex_state = 73, .external_lex_state = 3},
  [544] = {.lex_state = 73, .external_lex_state = 3},
  [545] = {.lex_state = 73, .external_lex_state = 3},
  [546] = {.lex_state = 73, .external_lex_state = 3},
  [547] = {.lex_state = 73, .external_lex_state = 3},
  [548] = {.lex_state = 73, .external_lex_state = 3},
  [549] = {.lex_state = 73, .external_lex_state = 3},
  [550] = {.lex_state = 73, .external_lex_state = 3},
  [551] = {.lex_state = 73, .external_lex_state = 3},
  [552] = {.lex_state = 73, .external_lex_state = 3},
  [553] = {.lex_state = 73, .external_lex_state = 3},
  [554] = {.lex_state = 73, .external_lex_state = 3},
  [555] = {.lex_state = 73, .external_lex_state = 3},
  [556] = {.lex_state = 7, .external_lex_state = 3},
  [557] = {.lex_state = 73, .external_lex_state = 3},
  [558] = {.lex_state = 73, .external_lex_state = 3},
  [559] = {.lex_state = 73, .external_lex_state = 3},
  [560] = {.lex_state = 73, .external_lex_state = 3},
  [561] = {.lex_state = 73, .external_lex_state = 3},
  [562] = {.lex_state = 73, .external_lex_state = 3},
  [563] = {.lex_state = 73, .external_lex_state = 3},
  [564] = {.lex_state = 73, .external_lex_state = 3},
  [565] = {.lex_state = 73, .external_lex_state = 3},
  [566] = {.lex_state = 73, .external_lex_state = 3},
  [567] = {.lex_state = 73, .external_lex_state = 3},
  [568] = {.lex_state = 73, .external_lex_state = 3},
  [569] = {.lex_state = 73, .external_lex_state = 3},
  [570] = {.lex_state = 73, .external_lex_state = 3},
  [571] = {.lex_state = 73, .external_lex_state = 3},
  [572] = {.lex_state = 73, .external_lex_state = 3},
  [573] = {.lex_state = 73, .external_lex_state = 3},
  [574] = {.lex_state = 73, .external_lex_state = 3},
  [575] = {.lex_state = 73, .external_lex_state = 3},
  [576] = {.lex_state = 73, .external_lex_state = 3},
  [577] = {.lex_state = 73, .external_lex_state = 4},
  [578] = {.lex_state = 73, .external_lex_state = 3},
  [579] = {.lex_state = 73, .external_lex_state = 3},
  [580] = {.lex_state = 73, .external_lex_state = 3},
  [581] = {.lex_state = 73, .external_lex_state = 3},
  [582] = {.lex_state = 73, .external_lex_state = 3},
  [583] = {.lex_state = 73, .external_lex_state = 3},
  [584] = {.lex_state = 73, .external_lex_state = 3},
  [585] = {.lex_state = 73, .external_lex_state = 3},
  [586] = {.lex_state = 73, .external_lex_state = 3},
  [587] = {.lex_state = 73, .external_lex_state = 3},
  [588] = {.lex_state = 73, .external_lex_state = 3},
  [589] = {.lex_state = 73, .external_lex_state = 3},
  [590] = {.lex_state = 73, .external_lex_state = 4},
  [591] = {.lex_state = 73, .external_lex_state = 3},
  [592] = {.lex_state = 73, .external_lex_state = 3},
  [593] = {.lex_state = 73, .external_lex_state = 3},
  [594] = {.lex_state = 73, .external_lex_state = 3},
  [595] = {.lex_state = 73, .external_lex_state = 3},
  [596] = {.lex_state = 73, .external_lex_state = 4},
  [597] = {.lex_state = 73, .external_lex_state = 4},
  [598] = {.lex_state = 73, .external_lex_state = 4},
  [599] = {.lex_state = 73, .external_lex_state = 4},
  [600] = {.lex_state = 73, .external_lex_state = 4},
  [601] = {.lex_state = 73, .external_lex_state = 4},
  [602] = {.lex_state = 73, .external_lex_state = 4},
  [603] = {.lex_state = 73, .external_lex_state = 3},
  [604] = {.lex_state = 73, .external_lex_state = 4},
  [605] = {.lex_state = 73, .external_lex_state = 4},
  [606] = {.lex_state = 73, .external_lex_state = 4},
  [607] = {.lex_state = 73, .external_lex_state = 4},
  [608] = {.lex_state = 73, .external_lex_state = 4},
  [609] = {.lex_state = 73, .external_lex_state = 4},
  [610] = {.lex_state = 73, .external_lex_state = 4},
  [611] = {.lex_state = 73, .external_lex_state = 4},
  [612] = {.lex_state = 73, .external_lex_state = 4},
  [613] = {.lex_state = 73, .external_lex_state = 4},
  [614] = {.lex_state = 73, .external_lex_state = 4},
  [615] = {.lex_state = 73, .external_lex_state = 4},
  [616] = {.lex_state = 73, .external_lex_state = 4},
  [617] = {.lex_state = 73, .external_lex_state = 4},
  [618] = {.lex_state = 73, .external_lex_state = 4},
  [619] = {.lex_state = 73, .external_lex_state = 4},
  [620] = {.lex_state = 73, .external_lex_state = 4},
  [621] = {.lex_state = 73, .external_lex_state = 4},
  [622] = {.lex_state = 73, .external_lex_state = 4},
  [623] = {.lex_state = 73, .external_lex_state = 4},
  [624] = {.lex_state = 73, .external_lex_state = 3},
  [625] = {.lex_state = 73, .external_lex_state = 4},
  [626] = {.lex_state = 73, .external_lex_state = 4},
  [627] = {.lex_state = 73, .external_lex_state = 3},
  [628] = {.lex_state = 73, .external_lex_state = 4},
  [629] = {.lex_state = 73, .external_lex_state = 3},
  [630] = {.lex_state = 73, .external_lex_state = 4},
  [631] = {.lex_state = 73, .external_lex_state = 4},
  [632] = {.lex_state = 73, .external_lex_state = 4},
  [633] = {.lex_state = 73, .external_lex_state = 4},
  [634] = {.lex_state = 73, .external_lex_state = 4},
  [635] = {.lex_state = 73, .external_lex_state = 4},
  [636] = {.lex_state = 73, .external_lex_state = 4},
  [637] = {.lex_state = 73, .external_lex_state = 4},
  [638] = {.lex_state = 73, .external_lex_state = 4},
  [639] = {.lex_state = 73, .external_lex_state = 4},
  [640] = {.lex_state = 73, .external_lex_state = 4},
  [641] = {.lex_state = 73, .external_lex_state = 4},
  [642] = {.lex_state = 73, .external_lex_state = 4},
  [643] = {.lex_state = 73, .external_lex_state = 4},
  [644] = {.lex_state = 73, .external_lex_state = 4},
  [645] = {.lex_state = 73, .external_lex_state = 4},
  [646] = {.lex_state = 73, .external_lex_state = 4},
  [647] = {.lex_state = 73, .external_lex_state = 4},
  [648] = {.lex_state = 73, .external_lex_state = 4},
  [649] = {.lex_state = 73, .external_lex_state = 4},
  [650] = {.lex_state = 73, .external_lex_state = 4},
  [651] = {.lex_state = 7, .external_lex_state = 4},
  [652] = {.lex_state = 7, .external_lex_state = 4},
  [653] = {.lex_state = 73, .external_lex_state = 4},
  [654] = {.lex_state = 73, .external_lex_state = 3},
  [655] = {.lex_state = 73, .external_lex_state = 3},
  [656] = {.lex_state = 73, .external_lex_state = 3},
  [657] = {.lex_state = 73, .external_lex_state = 4},
  [658] = {.lex_state = 73, .external_lex_state = 4},
  [659] = {.lex_state = 73, .external_lex_state = 4},
  [660] = {.lex_state = 73, .external_lex_state = 4},
  [661] = {.lex_state = 73, .external_lex_state = 4},
  [662] = {.lex_state = 73, .external_lex_state = 4},
  [663] = {.lex_state = 73, .external_lex_state = 4},
  [664] = {.lex_state = 73, .external_lex_state = 4},
  [665] = {.lex_state = 73, .external_lex_state = 4},
  [666] = {.lex_state = 73, .external_lex_state = 4},
  [667] = {.lex_state = 73, .external_lex_state = 4},
  [668] = {.lex_state = 73, .external_lex_state = 4},
  [669] = {.lex_state = 73, .external_lex_state = 4},
  [670] = {.lex_state = 73, .external_lex_state = 4},
  [671] = {.lex_state = 73, .external_lex_state = 4},
  [672] = {.lex_state = 73, .external_lex_state = 4},
  [673] = {.lex_state = 73, .external_lex_state = 4},
  [674] = {.lex_state = 73, .external_lex_state = 4},
  [675] = {.lex_state = 73, .external_lex_state = 4},
  [676] = {.lex_state = 73, .external_lex_state = 4},
  [677] = {.lex_state = 73, .external_lex_state = 4},
  [678] = {.lex_state = 73, .external_lex_state = 4},
  [679] = {.lex_state = 73, .external_lex_state = 4},
  [680] = {.lex_state = 73, .external_lex_state = 4},
  [681] = {.lex_state = 73, .external_lex_state = 4},
  [682] = {.lex_state = 73, .external_lex_state = 4},
  [683] = {.lex_state = 73, .external_lex_state = 4},
  [684] = {.lex_state = 73, .external_lex_state = 4},
  [685] = {.lex_state = 73, .external_lex_state = 4},
  [686] = {.lex_state = 73, .external_lex_state = 4},
  [687] = {.lex_state = 73, .external_lex_state = 4},
  [688] = {.lex_state = 73, .external_lex_state = 4},
  [689] = {.lex_state = 73, .external_lex_state = 4},
  [690] = {.lex_state = 73, .external_lex_state = 4},
  [691] = {.lex_state = 73, .external_lex_state = 4},
  [692] = {.lex_state = 73, .external_lex_state = 4},
  [693] = {.lex_state = 73, .external_lex_state = 4},
  [694] = {.lex_state = 73, .external_lex_state = 4},
  [695] = {.lex_state = 73, .external_lex_state = 4},
  [696] = {.lex_state = 73, .external_lex_state = 4},
  [697] = {.lex_state = 73, .external_lex_state = 4},
  [698] = {.lex_state = 73, .external_lex_state = 4},
  [699] = {.lex_state = 73, .external_lex_state = 4},
  [700] = {.lex_state = 73, .external_lex_state = 4},
  [701] = {.lex_state = 73, .external_lex_state = 4},
  [702] = {.lex_state = 73, .external_lex_state = 4},
  [703] = {.lex_state = 73, .external_lex_state = 4},
  [704] = {.lex_state = 73, .external_lex_state = 4},
  [705] = {.lex_state = 73, .external_lex_state = 4},
  [706] = {.lex_state = 73, .external_lex_state = 4},
  [707] = {.lex_state = 73, .external_lex_state = 4},
  [708] = {.lex_state = 73, .external_lex_state = 4},
  [709] = {.lex_state = 73, .external_lex_state = 4},
  [710] = {.lex_state = 73, .external_lex_state = 4},
  [711] = {.lex_state = 73, .external_lex_state = 4},
  [712] = {.lex_state = 73, .external_lex_state = 4},
  [713] = {.lex_state = 73, .external_lex_state = 4},
  [714] = {.lex_state = 73, .external_lex_state = 4},
  [715] = {.lex_state = 73, .external_lex_state = 4},
  [716] = {.lex_state = 73, .external_lex_state = 4},
  [717] = {.lex_state = 73, .external_lex_state = 4},
  [718] = {.lex_state = 73, .external_lex_state = 4},
  [719] = {.lex_state = 73, .external_lex_state = 4},
  [720] = {.lex_state = 73, .external_lex_state = 3},
  [721] = {.lex_state = 73, .external_lex_state = 4},
  [722] = {.lex_state = 73, .external_lex_state = 4},
  [723] = {.lex_state = 73, .external_lex_state = 4},
  [724] = {.lex_state = 73, .external_lex_state = 4},
  [725] = {.lex_state = 73, .external_lex_state = 4},
  [726] = {.lex_state = 73, .external_lex_state = 4},
  [727] = {.lex_state = 73, .external_lex_state = 3},
  [728] = {.lex_state = 73, .external_lex_state = 3},
  [729] = {.lex_state = 73, .external_lex_state = 3},
  [730] = {.lex_state = 73, .external_lex_state = 3},
  [731] = {.lex_state = 73, .external_lex_state = 4},
  [732] = {.lex_state = 73, .external_lex_state = 4},
  [733] = {.lex_state = 73, .external_lex_state = 3},
  [734] = {.lex_state = 73, .external_lex_state = 3},
  [735] = {.lex_state = 73, .external_lex_state = 4},
  [736] = {.lex_state = 73, .external_lex_state = 3},
  [737] = {.lex_state = 73, .external_lex_state = 3},
  [738] = {.lex_state = 73, .external_lex_state = 3},
  [739] = {.lex_state = 73, .external_lex_state = 3},
  [740] = {.lex_state = 73, .external_lex_state = 3},
  [741] = {.lex_state = 73, .external_lex_state = 3},
  [742] = {.lex_state = 73, .external_lex_state = 3},
  [743] = {.lex_state = 73, .external_lex_state = 3},
  [744] = {.lex_state = 73, .external_lex_state = 3},
  [745] = {.lex_state = 73, .external_lex_state = 3},
  [746] = {.lex_state = 73, .external_lex_state = 3},
  [747] = {.lex_state = 73, .external_lex_state = 3},
  [748] = {.lex_state = 73, .external_lex_state = 3},
  [749] = {.lex_state = 73, .external_lex_state = 3},
  [750] = {.lex_state = 73, .external_lex_state = 3},
  [751] = {.lex_state = 73, .external_lex_state = 3},
  [752] = {.lex_state = 73, .external_lex_state = 3},
  [753] = {.lex_state = 73, .external_lex_state = 3},
  [754] = {.lex_state = 73, .external_lex_state = 4},
  [755] = {.lex_state = 73, .external_lex_state = 3},
  [756] = {.lex_state = 73, .external_lex_state = 3},
  [757] = {.lex_state = 73, .external_lex_state = 3},
  [758] = {.lex_state = 73, .external_lex_state = 3},
  [759] = {.lex_state = 73, .external_lex_state = 3},
  [760] = {.lex_state = 73, .external_lex_state = 3},
  [761] = {.lex_state = 73, .external_lex_state = 3},
  [762] = {.lex_state = 73, .external_lex_state = 3},
  [763] = {.lex_state = 73, .external_lex_state = 3},
  [764] = {.lex_state = 73, .external_lex_state = 3},
  [765] = {.lex_state = 73, .external_lex_state = 3},
  [766] = {.lex_state = 73, .external_lex_state = 3},
  [767] = {.lex_state = 73, .external_lex_state = 3},
  [768] = {.lex_state = 73, .external_lex_state = 3},
  [769] = {.lex_state = 73, .external_lex_state = 3},
  [770] = {.lex_state = 73, .external_lex_state = 3},
  [771] = {.lex_state = 73, .external_lex_state = 4},
  [772] = {.lex_state = 73, .external_lex_state = 3},
  [773] = {.lex_state = 73, .external_lex_state = 3},
  [774] = {.lex_state = 73, .external_lex_state = 3},
  [775] = {.lex_state = 73, .external_lex_state = 3},
  [776] = {.lex_state = 73, .external_lex_state = 3},
  [777] = {.lex_state = 73, .external_lex_state = 3},
  [778] = {.lex_state = 73, .external_lex_state = 3},
  [779] = {.lex_state = 73, .external_lex_state = 3},
  [780] = {.lex_state = 73, .external_lex_state = 3},
  [781] = {.lex_state = 73, .external_lex_state = 3},
  [782] = {.lex_state = 73, .external_lex_state = 3},
  [783] = {.lex_state = 73, .external_lex_state = 3},
  [784] = {.lex_state = 73, .external_lex_state = 3},
  [785] = {.lex_state = 73, .external_lex_state = 3},
  [786] = {.lex_state = 73, .external_lex_state = 3},
  [787] = {.lex_state = 73, .external_lex_state = 3},
  [788] = {.lex_state = 73, .external_lex_state = 3},
  [789] = {.lex_state = 73, .external_lex_state = 3},
  [790] = {.lex_state = 73, .external_lex_state = 3},
  [791] = {.lex_state = 73, .external_lex_state = 3},
  [792] = {.lex_state = 73, .external_lex_state = 3},
  [793] = {.lex_state = 73, .external_lex_state = 3},
  [794] = {.lex_state = 73, .external_lex_state = 3},
  [795] = {.lex_state = 73, .external_lex_state = 3},
  [796] = {.lex_state = 73, .external_lex_state = 3},
  [797] = {.lex_state = 73, .external_lex_state = 3},
  [798] = {.lex_state = 73, .external_lex_state = 3},
  [799] = {.lex_state = 73, .external_lex_state = 3},
  [800] = {.lex_state = 73, .external_lex_state = 3},
  [801] = {.lex_state = 73, .external_lex_state = 3},
  [802] = {.lex_state = 73, .external_lex_state = 3},
  [803] = {.lex_state = 73, .external_lex_state = 3},
  [804] = {.lex_state = 73, .external_lex_state = 3},
  [805] = {.lex_state = 73, .external_lex_state = 3},
  [806] = {.lex_state = 73, .external_lex_state = 4},
  [807] = {.lex_state = 7, .external_lex_state = 3},
  [808] = {.lex_state = 4, .external_lex_state = 2},
  [809] = {.lex_state = 73, .external_lex_state = 4},
  [810] = {.lex_state = 4, .external_lex_state = 2},
  [811] = {.lex_state = 4, .external_lex_state = 2},
  [812] = {.lex_state = 73, .external_lex_state = 3},
  [813] = {.lex_state = 4, .external_lex_state = 2},
  [814] = {.lex_state = 4, .external_lex_state = 2},
  [815] = {.lex_state = 73, .external_lex_state = 3},
  [816] = {.lex_state = 4, .external_lex_state = 2},
  [817] = {.lex_state = 73, .external_lex_state = 3},
  [818] = {.lex_state = 73, .external_lex_state = 3},
  [819] = {.lex_state = 73, .external_lex_state = 3},
  [820] = {.lex_state = 73, .external_lex_state = 3},
  [821] = {.lex_state = 73, .external_lex_state = 3},
  [822] = {.lex_state = 73, .external_lex_state = 3},
  [823] = {.lex_state = 73, .external_lex_state = 3},
  [824] = {.lex_state = 73, .external_lex_state = 3},
  [825] = {.lex_state = 73, .external_lex_state = 3},
  [826] = {.lex_state = 73, .external_lex_state = 3},
  [827] = {.lex_state = 73, .external_lex_state = 3},
  [828] = {.lex_state = 73, .external_lex_state = 3},
  [829] = {.lex_state = 73, .external_lex_state = 3},
  [830] = {.lex_state = 73, .external_lex_state = 3},
  [831] = {.lex_state = 73, .external_lex_state = 3},
  [832] = {.lex_state = 73, .external_lex_state = 3},
  [833] = {.lex_state = 73, .external_lex_state = 3},
  [834] = {.lex_state = 73, .external_lex_state = 3},
  [835] = {.lex_state = 73, .external_lex_state = 3},
  [836] = {.lex_state = 73, .external_lex_state = 3},
  [837] = {.lex_state = 73, .external_lex_state = 3},
  [838] = {.lex_state = 73, .external_lex_state = 3},
  [839] = {.lex_state = 73, .external_lex_state = 3},
  [840] = {.lex_state = 73, .external_lex_state = 3},
  [841] = {.lex_state = 73, .external_lex_state = 3},
  [842] = {.lex_state = 73, .external_lex_state = 3},
  [843] = {.lex_state = 73, .external_lex_state = 3},
  [844] = {.lex_state = 73, .external_lex_state = 3},
  [845] = {.lex_state = 73, .external_lex_state = 3},
  [846] = {.lex_state = 73, .external_lex_state = 3},
  [847] = {.lex_state = 73, .external_lex_state = 3},
  [848] = {.lex_state = 73, .external_lex_state = 3},
  [849] = {.lex_state = 73, .external_lex_state = 3},
  [850] = {.lex_state = 73, .external_lex_state = 3},
  [851] = {.lex_state = 4, .external_lex_state = 2},
  [852] = {.lex_state = 73, .external_lex_state = 3},
  [853] = {.lex_state = 4, .external_lex_state = 2},
  [854] = {.lex_state = 4, .external_lex_state = 2},
  [855] = {.lex_state = 4, .external_lex_state = 2},
  [856] = {.lex_state = 4, .external_lex_state = 2},
  [857] = {.lex_state = 4, .external_lex_state = 2},
  [858] = {.lex_state = 4, .external_lex_state = 2},
  [859] = {.lex_state = 4, .external_lex_state = 2},
  [860] = {.lex_state = 4, .external_lex_state = 2},
  [861] = {.lex_state = 74, .external_lex_state = 2},
  [862] = {.lex_state = 74, .external_lex_state = 2},
  [863] = {.lex_state = 4, .external_lex_state = 2},
  [864] = {.lex_state = 74, .external_lex_state = 2},
  [865] = {.lex_state = 74, .external_lex_state = 2},
  [866] = {.lex_state = 74, .external_lex_state = 2},
  [867] = {.lex_state = 74, .external_lex_state = 2},
  [868] = {.lex_state = 74, .external_lex_state = 2},
  [869] = {.lex_state = 74, .external_lex_state = 2},
  [870] = {.lex_state = 74, .external_lex_state = 2},
  [871] = {.lex_state = 74, .external_lex_state = 2},
  [872] = {.lex_state = 74, .external_lex_state = 2},
  [873] = {.lex_state = 74, .external_lex_state = 2},
  [874] = {.lex_state = 74, .external_lex_state = 2},
  [875] = {.lex_state = 74, .external_lex_state = 2},
  [876] = {.lex_state = 74, .external_lex_state = 2},
  [877] = {.lex_state = 74, .external_lex_state = 2},
  [878] = {.lex_state = 74, .external_lex_state = 2},
  [879] = {.lex_state = 74, .external_lex_state = 2},
  [880] = {.lex_state = 74, .external_lex_state = 2},
  [881] = {.lex_state = 74, .external_lex_state = 2},
  [882] = {.lex_state = 74, .external_lex_state = 2},
  [883] = {.lex_state = 74, .external_lex_state = 5},
  [884] = {.lex_state = 4, .external_lex_state = 2},
  [885] = {.lex_state = 74, .external_lex_state = 2},
  [886] = {.lex_state = 74, .external_lex_state = 2},
  [887] = {.lex_state = 74, .external_lex_state = 2},
  [888] = {.lex_state = 74, .external_lex_state = 2},
  [889] = {.lex_state = 74, .external_lex_state = 5},
  [890] = {.lex_state = 74, .external_lex_state = 2},
  [891] = {.lex_state = 74, .external_lex_state = 5},
  [892] = {.lex_state = 74, .external_lex_state = 5},
  [893] = {.lex_state = 74, .external_lex_state = 5},
  [894] = {.lex_state = 74, .external_lex_state = 2},
  [895] = {.lex_state = 4, .external_lex_state = 2},
  [896] = {.lex_state = 74, .external_lex_state = 5},
  [897] = {.lex_state = 74, .external_lex_state = 2},
  [898] = {.lex_state = 4, .external_lex_state = 2},
  [899] = {.lex_state = 74, .external_lex_state = 2},
  [900] = {.lex_state = 4, .external_lex_state = 2},
  [901] = {.lex_state = 4, .external_lex_state = 2},
  [902] = {.lex_state = 74, .external_lex_state = 5},
  [903] = {.lex_state = 74, .external_lex_state = 5},
  [904] = {.lex_state = 4, .external_lex_state = 2},
  [905] = {.lex_state = 4, .external_lex_state = 2},
  [906] = {.lex_state = 9, .external_lex_state = 2},
  [907] = {.lex_state = 4, .external_lex_state = 2},
  [908] = {.lex_state = 4, .external_lex_state = 2},
  [909] = {.lex_state = 4, .external_lex_state = 2},
  [910] = {.lex_state = 4, .external_lex_state = 2},
  [911] = {.lex_state = 4, .external_lex_state = 2},
  [912] = {.lex_state = 4, .external_lex_state = 2},
  [913] = {.lex_state = 4, .external_lex_state = 2},
  [914] = {.lex_state = 4, .external_lex_state = 2},
  [915] = {.lex_state = 4, .external_lex_state = 2},
  [916] = {.lex_state = 4, .external_lex_state = 2},
  [917] = {.lex_state = 4, .external_lex_state = 2},
  [918] = {.lex_state = 4, .external_lex_state = 2},
  [919] = {.lex_state = 4, .external_lex_state = 2},
  [920] = {.lex_state = 4, .external_lex_state = 5},
  [921] = {.lex_state = 4, .external_lex_state = 2},
  [922] = {.lex_state = 4, .external_lex_state = 2},
  [923] = {.lex_state = 74, .external_lex_state = 5},
  [924] = {.lex_state = 4, .external_lex_state = 5},
  [925] = {.lex_state = 74, .external_lex_state = 5},
  [926] = {.lex_state = 4, .external_lex_state = 2},
  [927] = {.lex_state = 4, .external_lex_state = 2},
  [928] = {.lex_state = 4, .external_lex_state = 2},
  [929] = {.lex_state = 4, .external_lex_state = 2},
  [930] = {.lex_state = 4, .external_lex_state = 2},
  [931] = {.lex_state = 4, .external_lex_state = 2},
  [932] = {.lex_state = 4, .external_lex_state = 2},
  [933] = {.lex_state = 74, .external_lex_state = 5},
  [934] = {.lex_state = 4, .external_lex_state = 2},
  [935] = {.lex_state = 74, .external_lex_state = 5},
  [936] = {.lex_state = 74, .external_lex_state = 2},
  [937] = {.lex_state = 4, .external_lex_state = 2},
  [938] = {.lex_state = 4, .external_lex_state = 2},
  [939] = {.lex_state = 4, .external_lex_state = 2},
  [940] = {.lex_state = 4, .external_lex_state = 2},
  [941] = {.lex_state = 4, .external_lex_state = 2},
  [942] = {.lex_state = 4, .external_lex_state = 2},
  [943] = {.lex_state = 4, .external_lex_state = 2},
  [944] = {.lex_state = 4, .external_lex_state = 2},
  [945] = {.lex_state = 4, .external_lex_state = 2},
  [946] = {.lex_state = 4, .external_lex_state = 2},
  [947] = {.lex_state = 4, .external_lex_state = 2},
  [948] = {.lex_state = 9, .external_lex_state = 2},
  [949] = {.lex_state = 4, .external_lex_state = 2},
  [950] = {.lex_state = 4, .external_lex_state = 2},
  [951] = {.lex_state = 74, .external_lex_state = 2},
  [952] = {.lex_state = 74, .external_lex_state = 2},
  [953] = {.lex_state = 74, .external_lex_state = 2},
  [954] = {.lex_state = 74, .external_lex_state = 2},
  [955] = {.lex_state = 74, .external_lex_state = 2},
  [956] = {.lex_state = 74, .external_lex_state = 2},
  [957] = {.lex_state = 74, .external_lex_state = 2},
  [958] = {.lex_state = 74, .external_lex_state = 2},
  [959] = {.lex_state = 74, .external_lex_state = 2},
  [960] = {.lex_state = 74, .external_lex_state = 2},
  [961] = {.lex_state = 74, .external_lex_state = 2},
  [962] = {.lex_state = 4, .external_lex_state = 2},
  [963] = {.lex_state = 74, .external_lex_state = 2},
  [964] = {.lex_state = 74, .external_lex_state = 2},
  [965] = {.lex_state = 74, .external_lex_state = 2},
  [966] = {.lex_state = 4, .external_lex_state = 2},
  [967] = {.lex_state = 74, .external_lex_state = 2},
  [968] = {.lex_state = 74, .external_lex_state = 2},
  [969] = {.lex_state = 74, .external_lex_state = 2},
  [970] = {.lex_state = 74, .external_lex_state = 2},
  [971] = {.lex_state = 74, .external_lex_state = 2},
  [972] = {.lex_state = 74, .external_lex_state = 2},
  [973] = {.lex_state = 74, .external_lex_state = 2},
  [974] = {.lex_state = 74, .external_lex_state = 2},
  [975] = {.lex_state = 74, .external_lex_state = 2},
  [976] = {.lex_state = 4, .external_lex_state = 2},
  [977] = {.lex_state = 74, .external_lex_state = 2},
  [978] = {.lex_state = 74, .external_lex_state = 2},
  [979] = {.lex_state = 74, .external_lex_state = 2},
  [980] = {.lex_state = 74, .external_lex_state = 2},
  [981] = {.lex_state = 74, .external_lex_state = 2},
  [982] = {.lex_state = 74, .external_lex_state = 2},
  [983] = {.lex_state = 74, .external_lex_state = 2},
  [984] = {.lex_state = 74, .external_lex_state = 2},
  [985] = {.lex_state = 74, .external_lex_state = 2},
  [986] = {.lex_state = 74, .external_lex_state = 2},
  [987] = {.lex_state = 4, .external_lex_state = 2},
  [988] = {.lex_state = 74, .external_lex_state = 2},
  [989] = {.lex_state = 4, .external_lex_state = 2},
  [990] = {.lex_state = 74, .external_lex_state = 2},
  [991] = {.lex_state = 74, .external_lex_state = 2},
  [992] = {.lex_state = 74, .external_lex_state = 2},
  [993] = {.lex_state = 74, .external_lex_state = 2},
  [994] = {.lex_state = 4, .external_lex_state = 2},
  [995] = {.lex_state = 74, .external_lex_state = 2},
  [996] = {.lex_state = 74, .external_lex_state = 2},
  [997] = {.lex_state = 6, .external_lex_state = 2},
  [998] = {.lex_state = 74, .external_lex_state = 2},
  [999] = {.lex_state = 6, .external_lex_state = 2},
  [1000] = {.lex_state = 74, .external_lex_state = 2},
  [1001] = {.lex_state = 6, .external_lex_state = 2},
  [1002] = {.lex_state = 74, .external_lex_state = 2},
  [1003] = {.lex_state = 74, .external_lex_state = 2},
  [1004] = {.lex_state = 74, .external_lex_state = 2},
  [1005] = {.lex_state = 74, .external_lex_state = 2},
  [1006] = {.lex_state = 74, .external_lex_state = 2},
  [1007] = {.lex_state = 74, .external_lex_state = 2},
  [1008] = {.lex_state = 74, .external_lex_state = 2},
  [1009] = {.lex_state = 74, .external_lex_state = 2},
  [1010] = {.lex_state = 74, .external_lex_state = 2},
  [1011] = {.lex_state = 74, .external_lex_state = 2},
  [1012] = {.lex_state = 74, .external_lex_state = 2},
  [1013] = {.lex_state = 74, .external_lex_state = 2},
  [1014] = {.lex_state = 74, .external_lex_state = 2},
  [1015] = {.lex_state = 74, .external_lex_state = 2},
  [1016] = {.lex_state = 74, .external_lex_state = 2},
  [1017] = {.lex_state = 6, .external_lex_state = 2},
  [1018] = {.lex_state = 6, .external_lex_state = 2},
  [1019] = {.lex_state = 73, .external_lex_state = 2},
  [1020] = {.lex_state = 74, .external_lex_state = 2},
  [1021] = {.lex_state = 74, .external_lex_state = 2},
  [1022] = {.lex_state = 74, .external_lex_state = 2},
  [1023] = {.lex_state = 74, .external_lex_state = 2},
  [1024] = {.lex_state = 74, .external_lex_state = 2},
  [1025] = {.lex_state = 74, .external_lex_state = 2},
  [1026] = {.lex_state = 74, .external_lex_state = 2},
  [1027] = {.lex_state = 74, .external_lex_state = 2},
  [1028] = {.lex_state = 74, .external_lex_state = 2},
  [1029] = {.lex_state = 74, .external_lex_state = 2},
  [1030] = {.lex_state = 74, .external_lex_state = 2},
  [1031] = {.lex_state = 74, .external_lex_state = 2},
  [1032] = {.lex_state = 74, .external_lex_state = 2},
  [1033] = {.lex_state = 74, .external_lex_state = 2},
  [1034] = {.lex_state = 74, .external_lex_state = 2},
  [1035] = {.lex_state = 74, .external_lex_state = 2},
  [1036] = {.lex_state = 74, .external_lex_state = 2},
  [1037] = {.lex_state = 74, .external_lex_state = 2},
  [1038] = {.lex_state = 74, .external_lex_state = 2},
  [1039] = {.lex_state = 74, .external_lex_state = 2},
  [1040] = {.lex_state = 74, .external_lex_state = 2},
  [1041] = {.lex_state = 74, .external_lex_state = 2},
  [1042] = {.lex_state = 74, .external_lex_state = 2},
  [1043] = {.lex_state = 74, .external_lex_state = 5},
  [1044] = {.lex_state = 74, .external_lex_state = 2},
  [1045] = {.lex_state = 74, .external_lex_state = 5},
  [1046] = {.lex_state = 74, .external_lex_state = 2},
  [1047] = {.lex_state = 74, .external_lex_state = 5},
  [1048] = {.lex_state = 74, .external_lex_state = 5},
  [1049] = {.lex_state = 74, .external_lex_state = 2},
  [1050] = {.lex_state = 74, .external_lex_state = 5},
  [1051] = {.lex_state = 74, .external_lex_state = 2},
  [1052] = {.lex_state = 74, .external_lex_state = 5},
  [1053] = {.lex_state = 74, .external_lex_state = 5},
  [1054] = {.lex_state = 74, .external_lex_state = 2},
  [1055] = {.lex_state = 74, .external_lex_state = 5},
  [1056] = {.lex_state = 74, .external_lex_state = 2},
  [1057] = {.lex_state = 74, .external_lex_state = 2},
  [1058] = {.lex_state = 12, .external_lex_state = 6},
  [1059] = {.lex_state = 12, .external_lex_state = 6},
  [1060] = {.lex_state = 74, .external_lex_state = 5},
  [1061] = {.lex_state = 74, .external_lex_state = 5},
  [1062] = {.lex_state = 74, .external_lex_state = 2},
  [1063] = {.lex_state = 74, .external_lex_state = 2},
  [1064] = {.lex_state = 74, .external_lex_state = 2},
  [1065] = {.lex_state = 74, .external_lex_state = 5},
  [1066] = {.lex_state = 12, .external_lex_state = 6},
  [1067] = {.lex_state = 74, .external_lex_state = 5},
  [1068] = {.lex_state = 74, .external_lex_state = 5},
  [1069] = {.lex_state = 74, .external_lex_state = 2},
  [1070] = {.lex_state = 12, .external_lex_state = 6},
  [1071] = {.lex_state = 74, .external_lex_state = 5},
  [1072] = {.lex_state = 12, .external_lex_state = 6},
  [1073] = {.lex_state = 74, .external_lex_state = 2},
  [1074] = {.lex_state = 74, .external_lex_state = 2},
  [1075] = {.lex_state = 74, .external_lex_state = 2},
  [1076] = {.lex_state = 74, .external_lex_state = 5},
  [1077] = {.lex_state = 74, .external_lex_state = 2},
  [1078] = {.lex_state = 74, .external_lex_state = 2},
  [1079] = {.lex_state = 74, .external_lex_state = 2},
  [1080] = {.lex_state = 74, .external_lex_state = 2},
  [1081] = {.lex_state = 74, .external_lex_state = 2},
  [1082] = {.lex_state = 74, .external_lex_state = 2},
  [1083] = {.lex_state = 74, .external_lex_state = 5},
  [1084] = {.lex_state = 74, .external_lex_state = 2},
  [1085] = {.lex_state = 74, .external_lex_state = 2},
  [1086] = {.lex_state = 74, .external_lex_state = 2},
  [1087] = {.lex_state = 74, .external_lex_state = 5},
  [1088] = {.lex_state = 74, .external_lex_state = 2},
  [1089] = {.lex_state = 74, .external_lex_state = 2},
  [1090] = {.lex_state = 74, .external_lex_state = 2},
  [1091] = {.lex_state = 74, .external_lex_state = 2},
  [1092] = {.lex_state = 74, .external_lex_state = 2},
  [1093] = {.lex_state = 74, .external_lex_state = 2},
  [1094] = {.lex_state = 74, .external_lex_state = 2},
  [1095] = {.lex_state = 74, .external_lex_state = 5},
  [1096] = {.lex_state = 74, .external_lex_state = 2},
  [1097] = {.lex_state = 74, .external_lex_state = 2},
  [1098] = {.lex_state = 74, .external_lex_state = 2},
  [1099] = {.lex_state = 74, .external_lex_state = 2},
  [1100] = {.lex_state = 11, .external_lex_state = 7},
  [1101] = {.lex_state = 15, .external_lex_state = 7},
  [1102] = {.lex_state = 74, .external_lex_state = 2},
  [1103] = {.lex_state = 74, .external_lex_state = 2},
  [1104] = {.lex_state = 74, .external_lex_state = 2},
  [1105] = {.lex_state = 11, .external_lex_state = 7},
  [1106] = {.lex_state = 74, .external_lex_state = 2},
  [1107] = {.lex_state = 74, .external_lex_state = 5},
  [1108] = {.lex_state = 15, .external_lex_state = 7},
  [1109] = {.lex_state = 74, .external_lex_state = 5},
  [1110] = {.lex_state = 74, .external_lex_state = 5},
  [1111] = {.lex_state = 11, .external_lex_state = 7},
  [1112] = {.lex_state = 15, .external_lex_state = 7},
  [1113] = {.lex_state = 74, .external_lex_state = 2},
  [1114] = {.lex_state = 74, .external_lex_state = 5},
  [1115] = {.lex_state = 74, .external_lex_state = 2},
  [1116] = {.lex_state = 74, .external_lex_state = 2},
  [1117] = {.lex_state = 11, .external_lex_state = 7},
  [1118] = {.lex_state = 15, .external_lex_state = 7},
  [1119] = {.lex_state = 74, .external_lex_state = 2},
  [1120] = {.lex_state = 74, .external_lex_state = 2},
  [1121] = {.lex_state = 74, .external_lex_state = 5},
  [1122] = {.lex_state = 74, .external_lex_state = 2},
  [1123] = {.lex_state = 74, .external_lex_state = 2},
  [1124] = {.lex_state = 74, .external_lex_state = 5},
  [1125] = {.lex_state = 74, .external_lex_state = 2},
  [1126] = {.lex_state = 74, .external_lex_state = 5},
  [1127] = {.lex_state = 74, .external_lex_state = 2},
  [1128] = {.lex_state = 74, .external_lex_state = 2},
  [1129] = {.lex_state = 11, .external_lex_state = 7},
  [1130] = {.lex_state = 74, .external_lex_state = 2},
  [1131] = {.lex_state = 15, .external_lex_state = 7},
  [1132] = {.lex_state = 74, .external_lex_state = 2},
  [1133] = {.lex_state = 74, .external_lex_state = 2},
  [1134] = {.lex_state = 74, .external_lex_state = 5},
  [1135] = {.lex_state = 74, .external_lex_state = 2},
  [1136] = {.lex_state = 74, .external_lex_state = 5},
  [1137] = {.lex_state = 15, .external_lex_state = 7},
  [1138] = {.lex_state = 15, .external_lex_state = 7},
  [1139] = {.lex_state = 74, .external_lex_state = 5},
  [1140] = {.lex_state = 11, .external_lex_state = 7},
  [1141] = {.lex_state = 74, .external_lex_state = 5},
  [1142] = {.lex_state = 73, .external_lex_state = 2},
  [1143] = {.lex_state = 15, .external_lex_state = 7},
  [1144] = {.lex_state = 11, .external_lex_state = 7},
  [1145] = {.lex_state = 15, .external_lex_state = 7},
  [1146] = {.lex_state = 74, .external_lex_state = 2},
  [1147] = {.lex_state = 74, .external_lex_state = 2},
  [1148] = {.lex_state = 73, .external_lex_state = 2},
  [1149] = {.lex_state = 74, .external_lex_state = 2},
  [1150] = {.lex_state = 74, .external_lex_state = 2},
  [1151] = {.lex_state = 74, .external_lex_state = 2},
  [1152] = {.lex_state = 74, .external_lex_state = 2},
  [1153] = {.lex_state = 74, .external_lex_state = 5},
  [1154] = {.lex_state = 74, .external_lex_state = 2},
  [1155] = {.lex_state = 74, .external_lex_state = 2},
  [1156] = {.lex_state = 74, .external_lex_state = 2},
  [1157] = {.lex_state = 11, .external_lex_state = 7},
  [1158] = {.lex_state = 74, .external_lex_state = 2},
  [1159] = {.lex_state = 74, .external_lex_state = 2},
  [1160] = {.lex_state = 74, .external_lex_state = 2},
  [1161] = {.lex_state = 74, .external_lex_state = 2},
  [1162] = {.lex_state = 74, .external_lex_state = 2},
  [1163] = {.lex_state = 74, .external_lex_state = 2},
  [1164] = {.lex_state = 12, .external_lex_state = 6},
  [1165] = {.lex_state = 74, .external_lex_state = 2},
  [1166] = {.lex_state = 11, .external_lex_state = 7},
  [1167] = {.lex_state = 73, .external_lex_state = 2},
  [1168] = {.lex_state = 74, .external_lex_state = 2},
  [1169] = {.lex_state = 74, .external_lex_state = 5},
  [1170] = {.lex_state = 74, .external_lex_state = 2},
  [1171] = {.lex_state = 74, .external_lex_state = 2},
  [1172] = {.lex_state = 74, .external_lex_state = 2},
  [1173] = {.lex_state = 74, .external_lex_state = 2},
  [1174] = {.lex_state = 74, .external_lex_state = 2},
  [1175] = {.lex_state = 74, .external_lex_state = 2},
  [1176] = {.lex_state = 74, .external_lex_state = 2},
  [1177] = {.lex_state = 74, .external_lex_state = 2},
  [1178] = {.lex_state = 74, .external_lex_state = 2},
  [1179] = {.lex_state = 74, .external_lex_state = 2},
  [1180] = {.lex_state = 74, .external_lex_state = 2},
  [1181] = {.lex_state = 74, .external_lex_state = 2},
  [1182] = {.lex_state = 74, .external_lex_state = 2},
  [1183] = {.lex_state = 74, .external_lex_state = 2},
  [1184] = {.lex_state = 74, .external_lex_state = 2},
  [1185] = {.lex_state = 74, .external_lex_state = 2},
  [1186] = {.lex_state = 74, .external_lex_state = 2},
  [1187] = {.lex_state = 74, .external_lex_state = 2},
  [1188] = {.lex_state = 74, .external_lex_state = 2},
  [1189] = {.lex_state = 74, .external_lex_state = 2},
  [1190] = {.lex_state = 74, .external_lex_state = 2},
  [1191] = {.lex_state = 74, .external_lex_state = 2},
  [1192] = {.lex_state = 74, .external_lex_state = 5},
  [1193] = {.lex_state = 74, .external_lex_state = 2},
  [1194] = {.lex_state = 74, .external_lex_state = 2},
  [1195] = {.lex_state = 74, .external_lex_state = 5},
  [1196] = {.lex_state = 74, .external_lex_state = 2},
  [1197] = {.lex_state = 74, .external_lex_state = 2},
  [1198] = {.lex_state = 74, .external_lex_state = 2},
  [1199] = {.lex_state = 74, .external_lex_state = 2},
  [1200] = {.lex_state = 74, .external_lex_state = 5},
  [1201] = {.lex_state = 74, .external_lex_state = 2},
  [1202] = {.lex_state = 74, .external_lex_state = 2},
  [1203] = {.lex_state = 74, .external_lex_state = 5},
  [1204] = {.lex_state = 74, .external_lex_state = 2},
  [1205] = {.lex_state = 74, .external_lex_state = 2},
  [1206] = {.lex_state = 74, .external_lex_state = 2},
  [1207] = {.lex_state = 74, .external_lex_state = 2},
  [1208] = {.lex_state = 74, .external_lex_state = 2},
  [1209] = {.lex_state = 74, .external_lex_state = 2},
  [1210] = {.lex_state = 74, .external_lex_state = 2},
  [1211] = {.lex_state = 74, .external_lex_state = 2},
  [1212] = {.lex_state = 74, .external_lex_state = 2},
  [1213] = {.lex_state = 74, .external_lex_state = 2},
  [1214] = {.lex_state = 74, .external_lex_state = 2},
  [1215] = {.lex_state = 74, .external_lex_state = 2},
  [1216] = {.lex_state = 73, .external_lex_state = 2},
  [1217] = {.lex_state = 74, .external_lex_state = 2},
  [1218] = {.lex_state = 74, .external_lex_state = 2},
  [1219] = {.lex_state = 74, .external_lex_state = 5},
  [1220] = {.lex_state = 74, .external_lex_state = 2},
  [1221] = {.lex_state = 74, .external_lex_state = 2},
  [1222] = {.lex_state = 74, .external_lex_state = 2},
  [1223] = {.lex_state = 74, .external_lex_state = 2},
  [1224] = {.lex_state = 74, .external_lex_state = 2},
  [1225] = {.lex_state = 74, .external_lex_state = 2},
  [1226] = {.lex_state = 74, .external_lex_state = 2},
  [1227] = {.lex_state = 74, .external_lex_state = 2},
  [1228] = {.lex_state = 74, .external_lex_state = 2},
  [1229] = {.lex_state = 74, .external_lex_state = 2},
  [1230] = {.lex_state = 74, .external_lex_state = 2},
  [1231] = {.lex_state = 9, .external_lex_state = 8},
  [1232] = {.lex_state = 74, .external_lex_state = 2},
  [1233] = {.lex_state = 74, .external_lex_state = 2},
  [1234] = {.lex_state = 74, .external_lex_state = 2},
  [1235] = {.lex_state = 74, .external_lex_state = 5},
  [1236] = {.lex_state = 74, .external_lex_state = 2},
  [1237] = {.lex_state = 74, .external_lex_state = 2},
  [1238] = {.lex_state = 74, .external_lex_state = 2},
  [1239] = {.lex_state = 74, .external_lex_state = 2},
  [1240] = {.lex_state = 74, .external_lex_state = 2},
  [1241] = {.lex_state = 74, .external_lex_state = 2},
  [1242] = {.lex_state = 74, .external_lex_state = 2},
  [1243] = {.lex_state = 74, .external_lex_state = 2},
  [1244] = {.lex_state = 74, .external_lex_state = 2},
  [1245] = {.lex_state = 9, .external_lex_state = 8},
  [1246] = {.lex_state = 74, .external_lex_state = 2},
  [1247] = {.lex_state = 74, .external_lex_state = 2},
  [1248] = {.lex_state = 74, .external_lex_state = 2},
  [1249] = {.lex_state = 74, .external_lex_state = 5},
  [1250] = {.lex_state = 74, .external_lex_state = 2},
  [1251] = {.lex_state = 74, .external_lex_state = 5},
  [1252] = {.lex_state = 74, .external_lex_state = 2},
  [1253] = {.lex_state = 9, .external_lex_state = 8},
  [1254] = {.lex_state = 74, .external_lex_state = 2},
  [1255] = {.lex_state = 74, .external_lex_state = 5},
  [1256] = {.lex_state = 74, .external_lex_state = 2},
  [1257] = {.lex_state = 74, .external_lex_state = 2},
  [1258] = {.lex_state = 74, .external_lex_state = 2},
  [1259] = {.lex_state = 74, .external_lex_state = 2},
  [1260] = {.lex_state = 74, .external_lex_state = 2},
  [1261] = {.lex_state = 74, .external_lex_state = 2},
  [1262] = {.lex_state = 74, .external_lex_state = 2},
  [1263] = {.lex_state = 74, .external_lex_state = 2},
  [1264] = {.lex_state = 74, .external_lex_state = 2},
  [1265] = {.lex_state = 74, .external_lex_state = 2},
  [1266] = {.lex_state = 74, .external_lex_state = 2},
  [1267] = {.lex_state = 74, .external_lex_state = 2},
  [1268] = {.lex_state = 74, .external_lex_state = 2},
  [1269] = {.lex_state = 74, .external_lex_state = 5},
  [1270] = {.lex_state = 74, .external_lex_state = 5},
  [1271] = {.lex_state = 74, .external_lex_state = 2},
  [1272] = {.lex_state = 74, .external_lex_state = 5},
  [1273] = {.lex_state = 74, .external_lex_state = 2},
  [1274] = {.lex_state = 74, .external_lex_state = 2},
  [1275] = {.lex_state = 74, .external_lex_state = 2},
  [1276] = {.lex_state = 74, .external_lex_state = 2},
  [1277] = {.lex_state = 74, .external_lex_state = 2},
  [1278] = {.lex_state = 74, .external_lex_state = 2},
  [1279] = {.lex_state = 74, .external_lex_state = 2},
  [1280] = {.lex_state = 74, .external_lex_state = 2},
  [1281] = {.lex_state = 74, .external_lex_state = 2},
  [1282] = {.lex_state = 9, .external_lex_state = 2},
  [1283] = {.lex_state = 74, .external_lex_state = 2},
  [1284] = {.lex_state = 74, .external_lex_state = 2},
  [1285] = {.lex_state = 74, .external_lex_state = 2},
  [1286] = {.lex_state = 74, .external_lex_state = 2},
  [1287] = {.lex_state = 74, .external_lex_state = 2},
  [1288] = {.lex_state = 74, .external_lex_state = 2},
  [1289] = {.lex_state = 74, .external_lex_state = 5},
  [1290] = {.lex_state = 74, .external_lex_state = 2},
  [1291] = {.lex_state = 74, .external_lex_state = 5},
  [1292] = {.lex_state = 74, .external_lex_state = 5},
  [1293] = {.lex_state = 74, .external_lex_state = 2},
  [1294] = {.lex_state = 74, .external_lex_state = 2},
  [1295] = {.lex_state = 74, .external_lex_state = 2},
  [1296] = {.lex_state = 74, .external_lex_state = 2},
  [1297] = {.lex_state = 74, .external_lex_state = 2},
  [1298] = {.lex_state = 74, .external_lex_state = 2},
  [1299] = {.lex_state = 74, .external_lex_state = 2},
  [1300] = {.lex_state = 74, .external_lex_state = 2},
  [1301] = {.lex_state = 74, .external_lex_state = 2},
  [1302] = {.lex_state = 74, .external_lex_state = 2},
  [1303] = {.lex_state = 74, .external_lex_state = 2},
  [1304] = {.lex_state = 74, .external_lex_state = 2},
  [1305] = {.lex_state = 74, .external_lex_state = 2},
  [1306] = {.lex_state = 74, .external_lex_state = 2},
  [1307] = {.lex_state = 74, .external_lex_state = 2},
  [1308] = {.lex_state = 74, .external_lex_state = 2},
  [1309] = {.lex_state = 74, .external_lex_state = 2},
  [1310] = {.lex_state = 74, .external_lex_state = 2},
  [1311] = {.lex_state = 74, .external_lex_state = 2},
  [1312] = {.lex_state = 74, .external_lex_state = 2},
  [1313] = {.lex_state = 9, .external_lex_state = 2},
  [1314] = {.lex_state = 74, .external_lex_state = 2},
  [1315] = {.lex_state = 74, .external_lex_state = 2},
  [1316] = {.lex_state = 74, .external_lex_state = 2},
  [1317] = {.lex_state = 74, .external_lex_state = 5},
  [1318] = {.lex_state = 74, .external_lex_state = 2},
  [1319] = {.lex_state = 74, .external_lex_state = 2},
  [1320] = {.lex_state = 74, .external_lex_state = 5},
  [1321] = {.lex_state = 74, .external_lex_state = 2},
  [1322] = {.lex_state = 74, .external_lex_state = 2},
  [1323] = {.lex_state = 74, .external_lex_state = 2},
  [1324] = {.lex_state = 74, .external_lex_state = 2},
  [1325] = {.lex_state = 74, .external_lex_state = 2},
  [1326] = {.lex_state = 74, .external_lex_state = 2},
  [1327] = {.lex_state = 74, .external_lex_state = 2},
  [1328] = {.lex_state = 74, .external_lex_state = 2},
  [1329] = {.lex_state = 74, .external_lex_state = 5},
  [1330] = {.lex_state = 74, .external_lex_state = 2},
  [1331] = {.lex_state = 74, .external_lex_state = 5},
  [1332] = {.lex_state = 74, .external_lex_state = 5},
  [1333] = {.lex_state = 74, .external_lex_state = 2},
  [1334] = {.lex_state = 74, .external_lex_state = 2},
  [1335] = {.lex_state = 74, .external_lex_state = 2},
  [1336] = {.lex_state = 74, .external_lex_state = 2},
  [1337] = {.lex_state = 74, .external_lex_state = 2},
  [1338] = {.lex_state = 74, .external_lex_state = 2},
  [1339] = {.lex_state = 74, .external_lex_state = 2},
  [1340] = {.lex_state = 74, .external_lex_state = 2},
  [1341] = {.lex_state = 74, .external_lex_state = 2},
  [1342] = {.lex_state = 74, .external_lex_state = 2},
  [1343] = {.lex_state = 74, .external_lex_state = 2},
  [1344] = {.lex_state = 74, .external_lex_state = 2},
  [1345] = {.lex_state = 74, .external_lex_state = 2},
  [1346] = {.lex_state = 74, .external_lex_state = 2},
  [1347] = {.lex_state = 74, .external_lex_state = 2},
  [1348] = {.lex_state = 74, .external_lex_state = 2},
  [1349] = {.lex_state = 9, .external_lex_state = 2},
  [1350] = {.lex_state = 74, .external_lex_state = 5},
  [1351] = {.lex_state = 74, .external_lex_state = 2},
  [1352] = {.lex_state = 74, .external_lex_state = 2},
  [1353] = {.lex_state = 74, .external_lex_state = 2},
  [1354] = {.lex_state = 74, .external_lex_state = 2},
  [1355] = {.lex_state = 74, .external_lex_state = 2},
  [1356] = {.lex_state = 74, .external_lex_state = 2},
  [1357] = {.lex_state = 74, .external_lex_state = 2},
  [1358] = {.lex_state = 74, .external_lex_state = 5},
  [1359] = {.lex_state = 74, .external_lex_state = 5},
  [1360] = {.lex_state = 74, .external_lex_state = 2},
  [1361] = {.lex_state = 74, .external_lex_state = 2},
  [1362] = {.lex_state = 74, .external_lex_state = 2},
  [1363] = {.lex_state = 74, .external_lex_state = 2},
  [1364] = {.lex_state = 74, .external_lex_state = 2},
  [1365] = {.lex_state = 74, .external_lex_state = 2},
  [1366] = {.lex_state = 74, .external_lex_state = 2},
  [1367] = {.lex_state = 74, .external_lex_state = 2},
  [1368] = {.lex_state = 74, .external_lex_state = 2},
  [1369] = {.lex_state = 74, .external_lex_state = 2},
  [1370] = {.lex_state = 74, .external_lex_state = 2},
  [1371] = {.lex_state = 74, .external_lex_state = 2},
  [1372] = {.lex_state = 74, .external_lex_state = 2},
  [1373] = {.lex_state = 74, .external_lex_state = 2},
  [1374] = {.lex_state = 74, .external_lex_state = 2},
  [1375] = {.lex_state = 74, .external_lex_state = 2},
  [1376] = {.lex_state = 74, .external_lex_state = 2},
  [1377] = {.lex_state = 74, .external_lex_state = 2},
  [1378] = {.lex_state = 74, .external_lex_state = 2},
  [1379] = {.lex_state = 74, .external_lex_state = 2},
  [1380] = {.lex_state = 74, .external_lex_state = 2},
  [1381] = {.lex_state = 74, .external_lex_state = 2},
  [1382] = {.lex_state = 74, .external_lex_state = 2},
  [1383] = {.lex_state = 74, .external_lex_state = 2},
  [1384] = {.lex_state = 74, .external_lex_state = 2},
  [1385] = {.lex_state = 74, .external_lex_state = 2},
  [1386] = {.lex_state = 74, .external_lex_state = 2},
  [1387] = {.lex_state = 74, .external_lex_state = 2},
  [1388] = {.lex_state = 74, .external_lex_state = 2},
  [1389] = {.lex_state = 74, .external_lex_state = 2},
  [1390] = {.lex_state = 74, .external_lex_state = 2},
  [1391] = {.lex_state = 74, .external_lex_state = 2},
  [1392] = {.lex_state = 74, .external_lex_state = 2},
  [1393] = {.lex_state = 74, .external_lex_state = 2},
  [1394] = {.lex_state = 74, .external_lex_state = 2},
  [1395] = {.lex_state = 74, .external_lex_state = 2},
  [1396] = {.lex_state = 74, .external_lex_state = 2},
  [1397] = {.lex_state = 74, .external_lex_state = 2},
  [1398] = {.lex_state = 74, .external_lex_state = 5},
  [1399] = {.lex_state = 74, .external_lex_state = 2},
  [1400] = {.lex_state = 74, .external_lex_state = 2},
  [1401] = {.lex_state = 74, .external_lex_state = 2},
  [1402] = {.lex_state = 74, .external_lex_state = 2},
  [1403] = {.lex_state = 74, .external_lex_state = 2},
  [1404] = {.lex_state = 74, .external_lex_state = 2},
  [1405] = {.lex_state = 74, .external_lex_state = 2},
  [1406] = {.lex_state = 74, .external_lex_state = 2},
  [1407] = {.lex_state = 74, .external_lex_state = 2},
  [1408] = {.lex_state = 74, .external_lex_state = 2},
  [1409] = {.lex_state = 74, .external_lex_state = 2},
  [1410] = {.lex_state = 74, .external_lex_state = 2},
  [1411] = {.lex_state = 74, .external_lex_state = 2},
  [1412] = {.lex_state = 74, .external_lex_state = 2},
  [1413] = {.lex_state = 74, .external_lex_state = 2},
  [1414] = {.lex_state = 74, .external_lex_state = 2},
  [1415] = {.lex_state = 74, .external_lex_state = 2},
  [1416] = {.lex_state = 74, .external_lex_state = 2},
  [1417] = {.lex_state = 9, .external_lex_state = 8},
  [1418] = {.lex_state = 74, .external_lex_state = 2},
  [1419] = {.lex_state = 74, .external_lex_state = 2},
  [1420] = {.lex_state = 74, .external_lex_state = 2},
  [1421] = {.lex_state = 74, .external_lex_state = 2},
  [1422] = {.lex_state = 74, .external_lex_state = 2},
  [1423] = {.lex_state = 74, .external_lex_state = 2},
  [1424] = {.lex_state = 74, .external_lex_state = 2},
  [1425] = {.lex_state = 74, .external_lex_state = 2},
  [1426] = {.lex_state = 74, .external_lex_state = 2},
  [1427] = {.lex_state = 74, .external_lex_state = 2},
  [1428] = {.lex_state = 74, .external_lex_state = 2},
  [1429] = {.lex_state = 74, .external_lex_state = 2},
  [1430] = {.lex_state = 74, .external_lex_state = 2},
  [1431] = {.lex_state = 74, .external_lex_state = 2},
  [1432] = {.lex_state = 74, .external_lex_state = 2},
  [1433] = {.lex_state = 74, .external_lex_state = 2},
  [1434] = {.lex_state = 74, .external_lex_state = 2},
  [1435] = {.lex_state = 74, .external_lex_state = 2},
  [1436] = {.lex_state = 74, .external_lex_state = 2},
  [1437] = {.lex_state = 74, .external_lex_state = 2},
  [1438] = {.lex_state = 74, .external_lex_state = 2},
  [1439] = {.lex_state = 74, .external_lex_state = 2},
  [1440] = {.lex_state = 74, .external_lex_state = 2},
  [1441] = {.lex_state = 74, .external_lex_state = 2},
  [1442] = {.lex_state = 74, .external_lex_state = 2},
  [1443] = {.lex_state = 74, .external_lex_state = 2},
  [1444] = {.lex_state = 74, .external_lex_state = 2},
  [1445] = {.lex_state = 74, .external_lex_state = 2},
  [1446] = {.lex_state = 74, .external_lex_state = 2},
  [1447] = {.lex_state = 74, .external_lex_state = 2},
  [1448] = {.lex_state = 74, .external_lex_state = 2},
  [1449] = {.lex_state = 74, .external_lex_state = 2},
  [1450] = {.lex_state = 74, .external_lex_state = 2},
  [1451] = {.lex_state = 74, .external_lex_state = 2},
  [1452] = {.lex_state = 74, .external_lex_state = 2},
  [1453] = {.lex_state = 74, .external_lex_state = 2},
  [1454] = {.lex_state = 74, .external_lex_state = 5},
  [1455] = {.lex_state = 74, .external_lex_state = 2},
  [1456] = {.lex_state = 74, .external_lex_state = 2},
  [1457] = {.lex_state = 74, .external_lex_state = 2},
  [1458] = {.lex_state = 74, .external_lex_state = 2},
  [1459] = {.lex_state = 74, .external_lex_state = 5},
  [1460] = {.lex_state = 74, .external_lex_state = 2},
  [1461] = {.lex_state = 74, .external_lex_state = 2},
  [1462] = {.lex_state = 74, .external_lex_state = 2},
  [1463] = {.lex_state = 74, .external_lex_state = 2},
  [1464] = {.lex_state = 74, .external_lex_state = 2},
  [1465] = {.lex_state = 74, .external_lex_state = 5},
  [1466] = {.lex_state = 74, .external_lex_state = 2},
  [1467] = {.lex_state = 74, .external_lex_state = 2},
  [1468] = {.lex_state = 74, .external_lex_state = 2},
  [1469] = {.lex_state = 74, .external_lex_state = 2},
  [1470] = {.lex_state = 74, .external_lex_state = 2},
  [1471] = {.lex_state = 74, .external_lex_state = 2},
  [1472] = {.lex_state = 74, .external_lex_state = 2},
  [1473] = {.lex_state = 74, .external_lex_state = 2},
  [1474] = {.lex_state = 74, .external_lex_state = 2},
  [1475] = {.lex_state = 74, .external_lex_state = 2},
  [1476] = {.lex_state = 74, .external_lex_state = 2},
  [1477] = {.lex_state = 74, .external_lex_state = 2},
  [1478] = {.lex_state = 74, .external_lex_state = 2},
  [1479] = {.lex_state = 74, .external_lex_state = 2},
  [1480] = {.lex_state = 74, .external_lex_state = 2},
  [1481] = {.lex_state = 74, .external_lex_state = 2},
  [1482] = {.lex_state = 74, .external_lex_state = 2},
  [1483] = {.lex_state = 74, .external_lex_state = 2},
  [1484] = {.lex_state = 74, .external_lex_state = 2},
  [1485] = {.lex_state = 74, .external_lex_state = 2},
  [1486] = {.lex_state = 74, .external_lex_state = 2},
  [1487] = {.lex_state = 74, .external_lex_state = 2},
  [1488] = {.lex_state = 74, .external_lex_state = 2},
  [1489] = {.lex_state = 74, .external_lex_state = 2},
  [1490] = {.lex_state = 74, .external_lex_state = 2},
  [1491] = {.lex_state = 74, .external_lex_state = 5},
  [1492] = {.lex_state = 74, .external_lex_state = 2},
  [1493] = {.lex_state = 74, .external_lex_state = 2},
  [1494] = {.lex_state = 74, .external_lex_state = 2},
  [1495] = {.lex_state = 74, .external_lex_state = 2},
  [1496] = {.lex_state = 74, .external_lex_state = 2},
  [1497] = {.lex_state = 74, .external_lex_state = 2},
  [1498] = {.lex_state = 74, .external_lex_state = 5},
  [1499] = {.lex_state = 74, .external_lex_state = 5},
  [1500] = {.lex_state = 74, .external_lex_state = 5},
  [1501] = {.lex_state = 74, .external_lex_state = 2},
  [1502] = {.lex_state = 74, .external_lex_state = 2},
  [1503] = {.lex_state = 74, .external_lex_state = 2},
  [1504] = {.lex_state = 74, .external_lex_state = 2},
  [1505] = {.lex_state = 74, .external_lex_state = 2},
  [1506] = {.lex_state = 74, .external_lex_state = 2},
  [1507] = {.lex_state = 74, .external_lex_state = 2},
  [1508] = {.lex_state = 74, .external_lex_state = 2},
  [1509] = {.lex_state = 74, .external_lex_state = 2},
  [1510] = {.lex_state = 74, .external_lex_state = 2},
  [1511] = {.lex_state = 23, .external_lex_state = 2},
  [1512] = {.lex_state = 74, .external_lex_state = 2},
  [1513] = {.lex_state = 74, .external_lex_state = 2},
  [1514] = {.lex_state = 74, .external_lex_state = 2},
  [1515] = {.lex_state = 23, .external_lex_state = 2},
  [1516] = {.lex_state = 74, .external_lex_state = 2},
  [1517] = {.lex_state = 74, .external_lex_state = 2},
  [1518] = {.lex_state = 74, .external_lex_state = 2},
  [1519] = {.lex_state = 74, .external_lex_state = 2},
  [1520] = {.lex_state = 74, .external_lex_state = 2},
  [1521] = {.lex_state = 74, .external_lex_state = 2},
  [1522] = {.lex_state = 74, .external_lex_state = 2},
  [1523] = {.lex_state = 74, .external_lex_state = 2},
  [1524] = {.lex_state = 74, .external_lex_state = 2},
  [1525] = {.lex_state = 74, .external_lex_state = 2},
  [1526] = {.lex_state = 74, .external_lex_state = 2},
  [1527] = {.lex_state = 74, .external_lex_state = 2},
  [1528] = {.lex_state = 74, .external_lex_state = 2},
  [1529] = {.lex_state = 74, .external_lex_state = 2},
  [1530] = {.lex_state = 74, .external_lex_state = 2},
  [1531] = {.lex_state = 74, .external_lex_state = 2},
  [1532] = {.lex_state = 74, .external_lex_state = 2},
  [1533] = {.lex_state = 74, .external_lex_state = 2},
  [1534] = {.lex_state = 74, .external_lex_state = 2},
  [1535] = {.lex_state = 74, .external_lex_state = 2},
  [1536] = {.lex_state = 74, .external_lex_state = 2},
  [1537] = {.lex_state = 74, .external_lex_state = 2},
  [1538] = {.lex_state = 74, .external_lex_state = 2},
  [1539] = {.lex_state = 74, .external_lex_state = 2},
  [1540] = {.lex_state = 74, .external_lex_state = 2},
  [1541] = {.lex_state = 74, .external_lex_state = 2},
  [1542] = {.lex_state = 74, .external_lex_state = 2},
  [1543] = {.lex_state = 74, .external_lex_state = 2},
  [1544] = {.lex_state = 74, .external_lex_state = 2},
  [1545] = {.lex_state = 74, .external_lex_state = 2},
  [1546] = {.lex_state = 74, .external_lex_state = 2},
  [1547] = {.lex_state = 74, .external_lex_state = 2},
  [1548] = {.lex_state = 74, .external_lex_state = 2},
  [1549] = {.lex_state = 74, .external_lex_state = 2},
  [1550] = {.lex_state = 74, .external_lex_state = 2},
  [1551] = {.lex_state = 74, .external_lex_state = 2},
  [1552] = {.lex_state = 74, .external_lex_state = 2},
  [1553] = {.lex_state = 74, .external_lex_state = 2},
  [1554] = {.lex_state = 23, .external_lex_state = 2},
  [1555] = {.lex_state = 74, .external_lex_state = 2},
  [1556] = {.lex_state = 74, .external_lex_state = 2},
  [1557] = {.lex_state = 74, .external_lex_state = 2},
  [1558] = {.lex_state = 74, .external_lex_state = 2},
  [1559] = {.lex_state = 74, .external_lex_state = 2},
  [1560] = {.lex_state = 74, .external_lex_state = 2},
  [1561] = {.lex_state = 74, .external_lex_state = 2},
  [1562] = {.lex_state = 74, .external_lex_state = 2},
  [1563] = {.lex_state = 74, .external_lex_state = 2},
  [1564] = {.lex_state = 74, .external_lex_state = 2},
  [1565] = {.lex_state = 74, .external_lex_state = 2},
  [1566] = {.lex_state = 74, .external_lex_state = 2},
  [1567] = {.lex_state = 74, .external_lex_state = 2},
  [1568] = {.lex_state = 74, .external_lex_state = 2},
  [1569] = {.lex_state = 74, .external_lex_state = 2},
  [1570] = {.lex_state = 74, .external_lex_state = 2},
  [1571] = {.lex_state = 74, .external_lex_state = 2},
  [1572] = {.lex_state = 74, .external_lex_state = 2},
  [1573] = {.lex_state = 74, .external_lex_state = 2},
  [1574] = {.lex_state = 2, .external_lex_state = 9},
  [1575] = {.lex_state = 74, .external_lex_state = 2},
  [1576] = {.lex_state = 74, .external_lex_state = 2},
  [1577] = {.lex_state = 2, .external_lex_state = 9},
  [1578] = {.lex_state = 2, .external_lex_state = 9},
  [1579] = {.lex_state = 74, .external_lex_state = 2},
  [1580] = {.lex_state = 74, .external_lex_state = 2},
  [1581] = {.lex_state = 74, .external_lex_state = 2},
  [1582] = {.lex_state = 74, .external_lex_state = 2},
  [1583] = {.lex_state = 74, .external_lex_state = 2},
  [1584] = {.lex_state = 2, .external_lex_state = 9},
  [1585] = {.lex_state = 74, .external_lex_state = 2},
  [1586] = {.lex_state = 74, .external_lex_state = 2},
  [1587] = {.lex_state = 74, .external_lex_state = 2},
  [1588] = {.lex_state = 74, .external_lex_state = 2},
  [1589] = {.lex_state = 74, .external_lex_state = 2},
  [1590] = {.lex_state = 74, .external_lex_state = 2},
  [1591] = {.lex_state = 74, .external_lex_state = 2},
  [1592] = {.lex_state = 74, .external_lex_state = 2},
  [1593] = {.lex_state = 74, .external_lex_state = 2},
  [1594] = {.lex_state = 74, .external_lex_state = 2},
  [1595] = {.lex_state = 74, .external_lex_state = 2},
  [1596] = {.lex_state = 74, .external_lex_state = 2},
  [1597] = {.lex_state = 74, .external_lex_state = 2},
  [1598] = {.lex_state = 74, .external_lex_state = 2},
  [1599] = {.lex_state = 74, .external_lex_state = 2},
  [1600] = {.lex_state = 74, .external_lex_state = 2},
  [1601] = {.lex_state = 74, .external_lex_state = 2},
  [1602] = {.lex_state = 23, .external_lex_state = 2},
  [1603] = {.lex_state = 74, .external_lex_state = 2},
  [1604] = {.lex_state = 74, .external_lex_state = 2},
  [1605] = {.lex_state = 74, .external_lex_state = 2},
  [1606] = {.lex_state = 74, .external_lex_state = 2},
  [1607] = {.lex_state = 74, .external_lex_state = 2},
  [1608] = {.lex_state = 74, .external_lex_state = 2},
  [1609] = {.lex_state = 74, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [sym_optional_chain] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [aux_sym_method_definition_token1] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym_glimmer_template_tag_name] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1539),
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1559),
    [sym_object_assignment_pattern] = STATE(1228),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1559),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1559),
    [sym_spread_element] = STATE(1232),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(732),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [sym_rest_pattern] = STATE(1228),
    [sym_method_definition] = STATE(1232),
    [sym_pair] = STATE(1232),
    [sym_pair_pattern] = STATE(1228),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(884),
    [aux_sym_object_repeat1] = STATE(1223),
    [aux_sym_object_pattern_repeat1] = STATE(1225),
    [sym_identifier] = ACTIONS(95),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(105),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(109),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(117),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(121),
    [anon_sym_set] = ACTIONS(121),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1559),
    [sym_object_assignment_pattern] = STATE(1228),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1559),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1559),
    [sym_spread_element] = STATE(1232),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(732),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [sym_rest_pattern] = STATE(1228),
    [sym_method_definition] = STATE(1232),
    [sym_pair] = STATE(1232),
    [sym_pair_pattern] = STATE(1228),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(884),
    [aux_sym_object_repeat1] = STATE(1223),
    [aux_sym_object_pattern_repeat1] = STATE(1225),
    [sym_identifier] = ACTIONS(95),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(105),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(109),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(117),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(121),
    [anon_sym_set] = ACTIONS(121),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1559),
    [sym_object_assignment_pattern] = STATE(1228),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1559),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1559),
    [sym_spread_element] = STATE(1232),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(732),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [sym_rest_pattern] = STATE(1228),
    [sym_method_definition] = STATE(1232),
    [sym_pair] = STATE(1232),
    [sym_pair_pattern] = STATE(1228),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(884),
    [aux_sym_object_repeat1] = STATE(1223),
    [aux_sym_object_pattern_repeat1] = STATE(1225),
    [sym_identifier] = ACTIONS(95),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(125),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(105),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(109),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(117),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(121),
    [anon_sym_set] = ACTIONS(121),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1559),
    [sym_object_assignment_pattern] = STATE(1228),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1559),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1559),
    [sym_spread_element] = STATE(1240),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(732),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [sym_rest_pattern] = STATE(1228),
    [sym_method_definition] = STATE(1240),
    [sym_pair] = STATE(1240),
    [sym_pair_pattern] = STATE(1228),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(884),
    [aux_sym_object_repeat1] = STATE(1242),
    [aux_sym_object_pattern_repeat1] = STATE(1225),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(133),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(137),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(139),
    [anon_sym_set] = ACTIONS(139),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1559),
    [sym_object_assignment_pattern] = STATE(1228),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1559),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1559),
    [sym_spread_element] = STATE(1240),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(732),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [sym_rest_pattern] = STATE(1228),
    [sym_method_definition] = STATE(1240),
    [sym_pair] = STATE(1240),
    [sym_pair_pattern] = STATE(1228),
    [sym__property_name] = STATE(1221),
    [sym_computed_property_name] = STATE(1221),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(884),
    [aux_sym_object_repeat1] = STATE(1242),
    [aux_sym_object_pattern_repeat1] = STATE(1225),
    [sym_identifier] = ACTIONS(141),
    [anon_sym_export] = ACTIONS(143),
    [anon_sym_STAR] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(101),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(145),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(147),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(113),
    [sym_private_property_identifier] = ACTIONS(115),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(149),
    [aux_sym_method_definition_token1] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(151),
    [anon_sym_set] = ACTIONS(151),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [ts_builtin_sym_end] = ACTIONS(153),
    [sym_identifier] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(158),
    [anon_sym_default] = ACTIONS(161),
    [anon_sym_LBRACE] = ACTIONS(163),
    [anon_sym_RBRACE] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(166),
    [anon_sym_with] = ACTIONS(169),
    [anon_sym_var] = ACTIONS(172),
    [anon_sym_let] = ACTIONS(175),
    [anon_sym_const] = ACTIONS(178),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(184),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(190),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_await] = ACTIONS(196),
    [anon_sym_while] = ACTIONS(199),
    [anon_sym_do] = ACTIONS(202),
    [anon_sym_try] = ACTIONS(205),
    [anon_sym_break] = ACTIONS(208),
    [anon_sym_continue] = ACTIONS(211),
    [anon_sym_debugger] = ACTIONS(214),
    [anon_sym_return] = ACTIONS(217),
    [anon_sym_throw] = ACTIONS(220),
    [anon_sym_case] = ACTIONS(161),
    [anon_sym_yield] = ACTIONS(223),
    [anon_sym_LBRACK] = ACTIONS(226),
    [anon_sym_LT] = ACTIONS(229),
    [anon_sym_class] = ACTIONS(232),
    [anon_sym_async] = ACTIONS(235),
    [anon_sym_function] = ACTIONS(238),
    [anon_sym_new] = ACTIONS(241),
    [anon_sym_PLUS] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(244),
    [anon_sym_SLASH] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(250),
    [anon_sym_TILDE] = ACTIONS(250),
    [anon_sym_typeof] = ACTIONS(244),
    [anon_sym_void] = ACTIONS(244),
    [anon_sym_delete] = ACTIONS(244),
    [anon_sym_PLUS_PLUS] = ACTIONS(253),
    [anon_sym_DASH_DASH] = ACTIONS(253),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [anon_sym_SQUOTE] = ACTIONS(259),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(262),
    [sym_number] = ACTIONS(265),
    [sym_private_property_identifier] = ACTIONS(268),
    [sym_this] = ACTIONS(271),
    [sym_super] = ACTIONS(271),
    [sym_true] = ACTIONS(271),
    [sym_false] = ACTIONS(271),
    [sym_null] = ACTIONS(271),
    [sym_undefined] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_static] = ACTIONS(280),
    [anon_sym_get] = ACTIONS(280),
    [anon_sym_set] = ACTIONS(280),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(283),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(10),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(287),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(291),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(293),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(291),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(8),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(295),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(295),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [ts_builtin_sym_end] = ACTIONS(305),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(12),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [ts_builtin_sym_end] = ACTIONS(305),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(313),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(315),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(321),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(374),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(413),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(390),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(1573),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(366),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(367),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(369),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(375),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(378),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(380),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(382),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(364),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(364),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(388),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(374),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(1198),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(388),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(390),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(359),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(371),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(413),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(366),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(367),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(369),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(375),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(378),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(380),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(382),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1088),
    [sym_identifier] = ACTIONS(323),
    [anon_sym_export] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(329),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(337),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(341),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(345),
    [anon_sym_get] = ACTIONS(345),
    [anon_sym_set] = ACTIONS(345),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(359),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(371),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(387),
    [sym_import] = STATE(1142),
    [sym_import_statement] = STATE(387),
    [sym_statement] = STATE(343),
    [sym_expression_statement] = STATE(387),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_statement_block] = STATE(387),
    [sym_if_statement] = STATE(387),
    [sym_switch_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_do_statement] = STATE(387),
    [sym_try_statement] = STATE(387),
    [sym_with_statement] = STATE(387),
    [sym_break_statement] = STATE(387),
    [sym_continue_statement] = STATE(387),
    [sym_debugger_statement] = STATE(387),
    [sym_return_statement] = STATE(387),
    [sym_throw_statement] = STATE(387),
    [sym_empty_statement] = STATE(387),
    [sym_labeled_statement] = STATE(387),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(731),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1332),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1090),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(567),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_STAR] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_COLON] = ACTIONS(355),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(662),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_STAR] = ACTIONS(405),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym__automatic_semicolon] = ACTIONS(355),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [58] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(707),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_STAR] = ACTIONS(421),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym__automatic_semicolon] = ACTIONS(355),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [59] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(782),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_STAR] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_COLON] = ACTIONS(355),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [60] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(819),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(475),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_in] = ACTIONS(363),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(363),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [sym_optional_chain] = ACTIONS(355),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(363),
    [anon_sym_GT_GT_GT] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(363),
    [anon_sym_CARET] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(363),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(355),
    [anon_sym_STAR_STAR] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(355),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_QMARK_QMARK] = ACTIONS(355),
    [anon_sym_instanceof] = ACTIONS(363),
    [anon_sym_BANG] = ACTIONS(485),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym__ternary_qmark] = ACTIONS(355),
    [sym_html_comment] = ACTIONS(5),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(497),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(499),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(497),
    [anon_sym_COMMA] = ACTIONS(497),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_import] = ACTIONS(499),
    [anon_sym_with] = ACTIONS(499),
    [anon_sym_var] = ACTIONS(499),
    [anon_sym_let] = ACTIONS(499),
    [anon_sym_const] = ACTIONS(499),
    [anon_sym_else] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_switch] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_SEMI] = ACTIONS(497),
    [anon_sym_await] = ACTIONS(499),
    [anon_sym_in] = ACTIONS(499),
    [anon_sym_of] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(499),
    [anon_sym_do] = ACTIONS(499),
    [anon_sym_try] = ACTIONS(499),
    [anon_sym_break] = ACTIONS(499),
    [anon_sym_continue] = ACTIONS(499),
    [anon_sym_debugger] = ACTIONS(499),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_throw] = ACTIONS(499),
    [anon_sym_case] = ACTIONS(499),
    [anon_sym_yield] = ACTIONS(499),
    [anon_sym_LBRACK] = ACTIONS(497),
    [anon_sym_LT] = ACTIONS(499),
    [anon_sym_GT] = ACTIONS(499),
    [anon_sym_class] = ACTIONS(499),
    [anon_sym_async] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(499),
    [sym_optional_chain] = ACTIONS(497),
    [anon_sym_new] = ACTIONS(499),
    [anon_sym_DOT] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(497),
    [anon_sym_PIPE_PIPE] = ACTIONS(497),
    [anon_sym_GT_GT] = ACTIONS(499),
    [anon_sym_GT_GT_GT] = ACTIONS(497),
    [anon_sym_LT_LT] = ACTIONS(497),
    [anon_sym_AMP] = ACTIONS(499),
    [anon_sym_CARET] = ACTIONS(497),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(499),
    [anon_sym_DASH] = ACTIONS(499),
    [anon_sym_SLASH] = ACTIONS(499),
    [anon_sym_PERCENT] = ACTIONS(497),
    [anon_sym_STAR_STAR] = ACTIONS(497),
    [anon_sym_LT_EQ] = ACTIONS(497),
    [anon_sym_EQ_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(497),
    [anon_sym_GT_EQ] = ACTIONS(497),
    [anon_sym_QMARK_QMARK] = ACTIONS(497),
    [anon_sym_instanceof] = ACTIONS(499),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(499),
    [anon_sym_void] = ACTIONS(499),
    [anon_sym_delete] = ACTIONS(499),
    [anon_sym_PLUS_PLUS] = ACTIONS(497),
    [anon_sym_DASH_DASH] = ACTIONS(497),
    [anon_sym_DQUOTE] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(497),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(497),
    [sym_number] = ACTIONS(497),
    [sym_private_property_identifier] = ACTIONS(497),
    [sym_this] = ACTIONS(499),
    [sym_super] = ACTIONS(499),
    [sym_true] = ACTIONS(499),
    [sym_false] = ACTIONS(499),
    [sym_null] = ACTIONS(499),
    [sym_undefined] = ACTIONS(499),
    [anon_sym_AT] = ACTIONS(497),
    [anon_sym_static] = ACTIONS(499),
    [anon_sym_get] = ACTIONS(499),
    [anon_sym_set] = ACTIONS(499),
    [sym__automatic_semicolon] = ACTIONS(497),
    [sym__ternary_qmark] = ACTIONS(497),
    [sym_html_comment] = ACTIONS(5),
  },
  [62] = {
    [ts_builtin_sym_end] = ACTIONS(497),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(499),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(497),
    [anon_sym_COMMA] = ACTIONS(497),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_import] = ACTIONS(499),
    [anon_sym_with] = ACTIONS(499),
    [anon_sym_var] = ACTIONS(499),
    [anon_sym_let] = ACTIONS(499),
    [anon_sym_const] = ACTIONS(499),
    [anon_sym_else] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_switch] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_SEMI] = ACTIONS(497),
    [anon_sym_await] = ACTIONS(499),
    [anon_sym_in] = ACTIONS(499),
    [anon_sym_of] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(499),
    [anon_sym_do] = ACTIONS(499),
    [anon_sym_try] = ACTIONS(499),
    [anon_sym_break] = ACTIONS(499),
    [anon_sym_continue] = ACTIONS(499),
    [anon_sym_debugger] = ACTIONS(499),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_throw] = ACTIONS(499),
    [anon_sym_case] = ACTIONS(499),
    [anon_sym_yield] = ACTIONS(499),
    [anon_sym_LBRACK] = ACTIONS(497),
    [anon_sym_LT] = ACTIONS(499),
    [anon_sym_GT] = ACTIONS(499),
    [anon_sym_class] = ACTIONS(499),
    [anon_sym_async] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(499),
    [sym_optional_chain] = ACTIONS(497),
    [anon_sym_new] = ACTIONS(499),
    [anon_sym_DOT] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(497),
    [anon_sym_PIPE_PIPE] = ACTIONS(497),
    [anon_sym_GT_GT] = ACTIONS(499),
    [anon_sym_GT_GT_GT] = ACTIONS(497),
    [anon_sym_LT_LT] = ACTIONS(497),
    [anon_sym_AMP] = ACTIONS(499),
    [anon_sym_CARET] = ACTIONS(497),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(499),
    [anon_sym_DASH] = ACTIONS(499),
    [anon_sym_SLASH] = ACTIONS(499),
    [anon_sym_PERCENT] = ACTIONS(497),
    [anon_sym_STAR_STAR] = ACTIONS(497),
    [anon_sym_LT_EQ] = ACTIONS(497),
    [anon_sym_EQ_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(497),
    [anon_sym_BANG_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(497),
    [anon_sym_GT_EQ] = ACTIONS(497),
    [anon_sym_QMARK_QMARK] = ACTIONS(497),
    [anon_sym_instanceof] = ACTIONS(499),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(499),
    [anon_sym_void] = ACTIONS(499),
    [anon_sym_delete] = ACTIONS(499),
    [anon_sym_PLUS_PLUS] = ACTIONS(497),
    [anon_sym_DASH_DASH] = ACTIONS(497),
    [anon_sym_DQUOTE] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(497),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(497),
    [sym_number] = ACTIONS(497),
    [sym_private_property_identifier] = ACTIONS(497),
    [sym_this] = ACTIONS(499),
    [sym_super] = ACTIONS(499),
    [sym_true] = ACTIONS(499),
    [sym_false] = ACTIONS(499),
    [sym_null] = ACTIONS(499),
    [sym_undefined] = ACTIONS(499),
    [anon_sym_AT] = ACTIONS(497),
    [anon_sym_static] = ACTIONS(499),
    [anon_sym_get] = ACTIONS(499),
    [anon_sym_set] = ACTIONS(499),
    [sym__automatic_semicolon] = ACTIONS(501),
    [sym__ternary_qmark] = ACTIONS(497),
    [sym_html_comment] = ACTIONS(5),
  },
  [63] = {
    [ts_builtin_sym_end] = ACTIONS(503),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_STAR] = ACTIONS(505),
    [anon_sym_default] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_import] = ACTIONS(505),
    [anon_sym_with] = ACTIONS(505),
    [anon_sym_var] = ACTIONS(505),
    [anon_sym_let] = ACTIONS(505),
    [anon_sym_const] = ACTIONS(505),
    [anon_sym_else] = ACTIONS(505),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(505),
    [anon_sym_in] = ACTIONS(505),
    [anon_sym_of] = ACTIONS(505),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_do] = ACTIONS(505),
    [anon_sym_try] = ACTIONS(505),
    [anon_sym_break] = ACTIONS(505),
    [anon_sym_continue] = ACTIONS(505),
    [anon_sym_debugger] = ACTIONS(505),
    [anon_sym_return] = ACTIONS(505),
    [anon_sym_throw] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(505),
    [anon_sym_yield] = ACTIONS(505),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_GT] = ACTIONS(505),
    [anon_sym_class] = ACTIONS(505),
    [anon_sym_async] = ACTIONS(505),
    [anon_sym_function] = ACTIONS(505),
    [sym_optional_chain] = ACTIONS(503),
    [anon_sym_new] = ACTIONS(505),
    [anon_sym_DOT] = ACTIONS(505),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(505),
    [anon_sym_GT_GT_GT] = ACTIONS(503),
    [anon_sym_LT_LT] = ACTIONS(503),
    [anon_sym_AMP] = ACTIONS(505),
    [anon_sym_CARET] = ACTIONS(503),
    [anon_sym_PIPE] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(505),
    [anon_sym_DASH] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(505),
    [anon_sym_PERCENT] = ACTIONS(503),
    [anon_sym_STAR_STAR] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(505),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(505),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(505),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_TILDE] = ACTIONS(503),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_void] = ACTIONS(505),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(503),
    [sym_private_property_identifier] = ACTIONS(503),
    [sym_this] = ACTIONS(505),
    [sym_super] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_undefined] = ACTIONS(505),
    [anon_sym_AT] = ACTIONS(503),
    [anon_sym_static] = ACTIONS(505),
    [anon_sym_get] = ACTIONS(505),
    [anon_sym_set] = ACTIONS(505),
    [sym__automatic_semicolon] = ACTIONS(507),
    [sym__ternary_qmark] = ACTIONS(503),
    [sym_html_comment] = ACTIONS(5),
  },
  [64] = {
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym_identifier] = ACTIONS(511),
    [anon_sym_export] = ACTIONS(511),
    [anon_sym_STAR] = ACTIONS(511),
    [anon_sym_default] = ACTIONS(511),
    [anon_sym_LBRACE] = ACTIONS(509),
    [anon_sym_COMMA] = ACTIONS(509),
    [anon_sym_RBRACE] = ACTIONS(509),
    [anon_sym_import] = ACTIONS(511),
    [anon_sym_with] = ACTIONS(511),
    [anon_sym_var] = ACTIONS(511),
    [anon_sym_let] = ACTIONS(511),
    [anon_sym_const] = ACTIONS(511),
    [anon_sym_else] = ACTIONS(511),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_switch] = ACTIONS(511),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(509),
    [anon_sym_SEMI] = ACTIONS(509),
    [anon_sym_await] = ACTIONS(511),
    [anon_sym_in] = ACTIONS(511),
    [anon_sym_of] = ACTIONS(511),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(511),
    [anon_sym_try] = ACTIONS(511),
    [anon_sym_break] = ACTIONS(511),
    [anon_sym_continue] = ACTIONS(511),
    [anon_sym_debugger] = ACTIONS(511),
    [anon_sym_return] = ACTIONS(511),
    [anon_sym_throw] = ACTIONS(511),
    [anon_sym_case] = ACTIONS(511),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_LT] = ACTIONS(511),
    [anon_sym_GT] = ACTIONS(511),
    [anon_sym_class] = ACTIONS(511),
    [anon_sym_async] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(511),
    [sym_optional_chain] = ACTIONS(509),
    [anon_sym_new] = ACTIONS(511),
    [anon_sym_DOT] = ACTIONS(511),
    [anon_sym_AMP_AMP] = ACTIONS(509),
    [anon_sym_PIPE_PIPE] = ACTIONS(509),
    [anon_sym_GT_GT] = ACTIONS(511),
    [anon_sym_GT_GT_GT] = ACTIONS(509),
    [anon_sym_LT_LT] = ACTIONS(509),
    [anon_sym_AMP] = ACTIONS(511),
    [anon_sym_CARET] = ACTIONS(509),
    [anon_sym_PIPE] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(511),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_SLASH] = ACTIONS(511),
    [anon_sym_PERCENT] = ACTIONS(509),
    [anon_sym_STAR_STAR] = ACTIONS(509),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_EQ_EQ] = ACTIONS(511),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(509),
    [anon_sym_BANG_EQ] = ACTIONS(511),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(509),
    [anon_sym_GT_EQ] = ACTIONS(509),
    [anon_sym_QMARK_QMARK] = ACTIONS(509),
    [anon_sym_instanceof] = ACTIONS(511),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_typeof] = ACTIONS(511),
    [anon_sym_void] = ACTIONS(511),
    [anon_sym_delete] = ACTIONS(511),
    [anon_sym_PLUS_PLUS] = ACTIONS(509),
    [anon_sym_DASH_DASH] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(509),
    [sym_number] = ACTIONS(509),
    [sym_private_property_identifier] = ACTIONS(509),
    [sym_this] = ACTIONS(511),
    [sym_super] = ACTIONS(511),
    [sym_true] = ACTIONS(511),
    [sym_false] = ACTIONS(511),
    [sym_null] = ACTIONS(511),
    [sym_undefined] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(509),
    [anon_sym_static] = ACTIONS(511),
    [anon_sym_get] = ACTIONS(511),
    [anon_sym_set] = ACTIONS(511),
    [sym__automatic_semicolon] = ACTIONS(509),
    [sym__ternary_qmark] = ACTIONS(509),
    [sym_html_comment] = ACTIONS(5),
  },
  [65] = {
    [ts_builtin_sym_end] = ACTIONS(513),
    [sym_identifier] = ACTIONS(515),
    [anon_sym_export] = ACTIONS(515),
    [anon_sym_STAR] = ACTIONS(515),
    [anon_sym_default] = ACTIONS(515),
    [anon_sym_LBRACE] = ACTIONS(513),
    [anon_sym_COMMA] = ACTIONS(513),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_import] = ACTIONS(515),
    [anon_sym_with] = ACTIONS(515),
    [anon_sym_var] = ACTIONS(515),
    [anon_sym_let] = ACTIONS(515),
    [anon_sym_const] = ACTIONS(515),
    [anon_sym_else] = ACTIONS(515),
    [anon_sym_if] = ACTIONS(515),
    [anon_sym_switch] = ACTIONS(515),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(513),
    [anon_sym_SEMI] = ACTIONS(513),
    [anon_sym_await] = ACTIONS(515),
    [anon_sym_in] = ACTIONS(515),
    [anon_sym_of] = ACTIONS(515),
    [anon_sym_while] = ACTIONS(515),
    [anon_sym_do] = ACTIONS(515),
    [anon_sym_try] = ACTIONS(515),
    [anon_sym_break] = ACTIONS(515),
    [anon_sym_continue] = ACTIONS(515),
    [anon_sym_debugger] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(515),
    [anon_sym_throw] = ACTIONS(515),
    [anon_sym_case] = ACTIONS(515),
    [anon_sym_yield] = ACTIONS(515),
    [anon_sym_LBRACK] = ACTIONS(513),
    [anon_sym_LT] = ACTIONS(515),
    [anon_sym_GT] = ACTIONS(515),
    [anon_sym_class] = ACTIONS(515),
    [anon_sym_async] = ACTIONS(515),
    [anon_sym_function] = ACTIONS(515),
    [sym_optional_chain] = ACTIONS(513),
    [anon_sym_new] = ACTIONS(515),
    [anon_sym_DOT] = ACTIONS(515),
    [anon_sym_AMP_AMP] = ACTIONS(513),
    [anon_sym_PIPE_PIPE] = ACTIONS(513),
    [anon_sym_GT_GT] = ACTIONS(515),
    [anon_sym_GT_GT_GT] = ACTIONS(513),
    [anon_sym_LT_LT] = ACTIONS(513),
    [anon_sym_AMP] = ACTIONS(515),
    [anon_sym_CARET] = ACTIONS(513),
    [anon_sym_PIPE] = ACTIONS(515),
    [anon_sym_PLUS] = ACTIONS(515),
    [anon_sym_DASH] = ACTIONS(515),
    [anon_sym_SLASH] = ACTIONS(515),
    [anon_sym_PERCENT] = ACTIONS(513),
    [anon_sym_STAR_STAR] = ACTIONS(513),
    [anon_sym_LT_EQ] = ACTIONS(513),
    [anon_sym_EQ_EQ] = ACTIONS(515),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(513),
    [anon_sym_BANG_EQ] = ACTIONS(515),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(513),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_QMARK_QMARK] = ACTIONS(513),
    [anon_sym_instanceof] = ACTIONS(515),
    [anon_sym_BANG] = ACTIONS(515),
    [anon_sym_TILDE] = ACTIONS(513),
    [anon_sym_typeof] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_delete] = ACTIONS(515),
    [anon_sym_PLUS_PLUS] = ACTIONS(513),
    [anon_sym_DASH_DASH] = ACTIONS(513),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_SQUOTE] = ACTIONS(513),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(513),
    [sym_number] = ACTIONS(513),
    [sym_private_property_identifier] = ACTIONS(513),
    [sym_this] = ACTIONS(515),
    [sym_super] = ACTIONS(515),
    [sym_true] = ACTIONS(515),
    [sym_false] = ACTIONS(515),
    [sym_null] = ACTIONS(515),
    [sym_undefined] = ACTIONS(515),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_static] = ACTIONS(515),
    [anon_sym_get] = ACTIONS(515),
    [anon_sym_set] = ACTIONS(515),
    [sym__automatic_semicolon] = ACTIONS(513),
    [sym__ternary_qmark] = ACTIONS(513),
    [sym_html_comment] = ACTIONS(5),
  },
  [66] = {
    [ts_builtin_sym_end] = ACTIONS(517),
    [sym_identifier] = ACTIONS(519),
    [anon_sym_export] = ACTIONS(519),
    [anon_sym_STAR] = ACTIONS(519),
    [anon_sym_default] = ACTIONS(519),
    [anon_sym_LBRACE] = ACTIONS(517),
    [anon_sym_COMMA] = ACTIONS(517),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_import] = ACTIONS(519),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_var] = ACTIONS(519),
    [anon_sym_let] = ACTIONS(519),
    [anon_sym_const] = ACTIONS(519),
    [anon_sym_else] = ACTIONS(519),
    [anon_sym_if] = ACTIONS(519),
    [anon_sym_switch] = ACTIONS(519),
    [anon_sym_for] = ACTIONS(519),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_SEMI] = ACTIONS(517),
    [anon_sym_await] = ACTIONS(519),
    [anon_sym_in] = ACTIONS(519),
    [anon_sym_of] = ACTIONS(519),
    [anon_sym_while] = ACTIONS(519),
    [anon_sym_do] = ACTIONS(519),
    [anon_sym_try] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(519),
    [anon_sym_debugger] = ACTIONS(519),
    [anon_sym_return] = ACTIONS(519),
    [anon_sym_throw] = ACTIONS(519),
    [anon_sym_case] = ACTIONS(519),
    [anon_sym_yield] = ACTIONS(519),
    [anon_sym_LBRACK] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(519),
    [anon_sym_GT] = ACTIONS(519),
    [anon_sym_class] = ACTIONS(519),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(519),
    [sym_optional_chain] = ACTIONS(517),
    [anon_sym_new] = ACTIONS(519),
    [anon_sym_DOT] = ACTIONS(519),
    [anon_sym_AMP_AMP] = ACTIONS(517),
    [anon_sym_PIPE_PIPE] = ACTIONS(517),
    [anon_sym_GT_GT] = ACTIONS(519),
    [anon_sym_GT_GT_GT] = ACTIONS(517),
    [anon_sym_LT_LT] = ACTIONS(517),
    [anon_sym_AMP] = ACTIONS(519),
    [anon_sym_CARET] = ACTIONS(517),
    [anon_sym_PIPE] = ACTIONS(519),
    [anon_sym_PLUS] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(519),
    [anon_sym_SLASH] = ACTIONS(519),
    [anon_sym_PERCENT] = ACTIONS(517),
    [anon_sym_STAR_STAR] = ACTIONS(517),
    [anon_sym_LT_EQ] = ACTIONS(517),
    [anon_sym_EQ_EQ] = ACTIONS(519),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(517),
    [anon_sym_BANG_EQ] = ACTIONS(519),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(517),
    [anon_sym_GT_EQ] = ACTIONS(517),
    [anon_sym_QMARK_QMARK] = ACTIONS(517),
    [anon_sym_instanceof] = ACTIONS(519),
    [anon_sym_BANG] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(517),
    [anon_sym_typeof] = ACTIONS(519),
    [anon_sym_void] = ACTIONS(519),
    [anon_sym_delete] = ACTIONS(519),
    [anon_sym_PLUS_PLUS] = ACTIONS(517),
    [anon_sym_DASH_DASH] = ACTIONS(517),
    [anon_sym_DQUOTE] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(517),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(517),
    [sym_number] = ACTIONS(517),
    [sym_private_property_identifier] = ACTIONS(517),
    [sym_this] = ACTIONS(519),
    [sym_super] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_undefined] = ACTIONS(519),
    [anon_sym_AT] = ACTIONS(517),
    [anon_sym_static] = ACTIONS(519),
    [anon_sym_get] = ACTIONS(519),
    [anon_sym_set] = ACTIONS(519),
    [sym__automatic_semicolon] = ACTIONS(517),
    [sym__ternary_qmark] = ACTIONS(517),
    [sym_html_comment] = ACTIONS(5),
  },
  [67] = {
    [ts_builtin_sym_end] = ACTIONS(503),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_STAR] = ACTIONS(521),
    [anon_sym_default] = ACTIONS(505),
    [anon_sym_LBRACE] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(523),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_import] = ACTIONS(505),
    [anon_sym_with] = ACTIONS(505),
    [anon_sym_var] = ACTIONS(505),
    [anon_sym_let] = ACTIONS(505),
    [anon_sym_const] = ACTIONS(505),
    [anon_sym_else] = ACTIONS(505),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_switch] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(505),
    [anon_sym_in] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_do] = ACTIONS(505),
    [anon_sym_try] = ACTIONS(505),
    [anon_sym_break] = ACTIONS(505),
    [anon_sym_continue] = ACTIONS(505),
    [anon_sym_debugger] = ACTIONS(505),
    [anon_sym_return] = ACTIONS(505),
    [anon_sym_throw] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(505),
    [anon_sym_yield] = ACTIONS(505),
    [anon_sym_EQ] = ACTIONS(525),
    [anon_sym_LBRACK] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_GT] = ACTIONS(521),
    [anon_sym_class] = ACTIONS(505),
    [anon_sym_async] = ACTIONS(505),
    [anon_sym_function] = ACTIONS(505),
    [sym_optional_chain] = ACTIONS(523),
    [anon_sym_new] = ACTIONS(505),
    [anon_sym_DOT] = ACTIONS(521),
    [anon_sym_AMP_AMP] = ACTIONS(523),
    [anon_sym_PIPE_PIPE] = ACTIONS(523),
    [anon_sym_GT_GT] = ACTIONS(521),
    [anon_sym_GT_GT_GT] = ACTIONS(523),
    [anon_sym_LT_LT] = ACTIONS(523),
    [anon_sym_AMP] = ACTIONS(521),
    [anon_sym_CARET] = ACTIONS(523),
    [anon_sym_PIPE] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(505),
    [anon_sym_DASH] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(505),
    [anon_sym_PERCENT] = ACTIONS(523),
    [anon_sym_STAR_STAR] = ACTIONS(523),
    [anon_sym_LT_EQ] = ACTIONS(523),
    [anon_sym_EQ_EQ] = ACTIONS(521),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(523),
    [anon_sym_BANG_EQ] = ACTIONS(521),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(523),
    [anon_sym_GT_EQ] = ACTIONS(523),
    [anon_sym_QMARK_QMARK] = ACTIONS(523),
    [anon_sym_instanceof] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_TILDE] = ACTIONS(503),
    [anon_sym_typeof] = ACTIONS(505),
    [anon_sym_void] = ACTIONS(505),
    [anon_sym_delete] = ACTIONS(505),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(503),
    [sym_number] = ACTIONS(503),
    [sym_private_property_identifier] = ACTIONS(503),
    [sym_this] = ACTIONS(505),
    [sym_super] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_undefined] = ACTIONS(505),
    [anon_sym_AT] = ACTIONS(503),
    [anon_sym_static] = ACTIONS(505),
    [anon_sym_get] = ACTIONS(505),
    [anon_sym_set] = ACTIONS(505),
    [sym__automatic_semicolon] = ACTIONS(527),
    [sym__ternary_qmark] = ACTIONS(523),
    [sym_html_comment] = ACTIONS(5),
  },
  [68] = {
    [ts_builtin_sym_end] = ACTIONS(529),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_default] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(529),
    [anon_sym_COMMA] = ACTIONS(535),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_import] = ACTIONS(531),
    [anon_sym_with] = ACTIONS(531),
    [anon_sym_var] = ACTIONS(531),
    [anon_sym_let] = ACTIONS(531),
    [anon_sym_const] = ACTIONS(531),
    [anon_sym_else] = ACTIONS(531),
    [anon_sym_if] = ACTIONS(531),
    [anon_sym_switch] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(531),
    [anon_sym_LPAREN] = ACTIONS(529),
    [anon_sym_SEMI] = ACTIONS(529),
    [anon_sym_await] = ACTIONS(531),
    [anon_sym_in] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(531),
    [anon_sym_do] = ACTIONS(531),
    [anon_sym_try] = ACTIONS(531),
    [anon_sym_break] = ACTIONS(531),
    [anon_sym_continue] = ACTIONS(531),
    [anon_sym_debugger] = ACTIONS(531),
    [anon_sym_return] = ACTIONS(531),
    [anon_sym_throw] = ACTIONS(531),
    [anon_sym_case] = ACTIONS(531),
    [anon_sym_yield] = ACTIONS(531),
    [anon_sym_LBRACK] = ACTIONS(529),
    [anon_sym_LT] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(533),
    [anon_sym_class] = ACTIONS(531),
    [anon_sym_async] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(531),
    [sym_optional_chain] = ACTIONS(535),
    [anon_sym_new] = ACTIONS(531),
    [anon_sym_DOT] = ACTIONS(533),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [anon_sym_GT_GT] = ACTIONS(533),
    [anon_sym_GT_GT_GT] = ACTIONS(535),
    [anon_sym_LT_LT] = ACTIONS(535),
    [anon_sym_AMP] = ACTIONS(533),
    [anon_sym_CARET] = ACTIONS(535),
    [anon_sym_PIPE] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(531),
    [anon_sym_DASH] = ACTIONS(531),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_PERCENT] = ACTIONS(535),
    [anon_sym_STAR_STAR] = ACTIONS(535),
    [anon_sym_LT_EQ] = ACTIONS(535),
    [anon_sym_EQ_EQ] = ACTIONS(533),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(535),
    [anon_sym_BANG_EQ] = ACTIONS(533),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(535),
    [anon_sym_GT_EQ] = ACTIONS(535),
    [anon_sym_QMARK_QMARK] = ACTIONS(535),
    [anon_sym_instanceof] = ACTIONS(533),
    [anon_sym_BANG] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(529),
    [anon_sym_typeof] = ACTIONS(531),
    [anon_sym_void] = ACTIONS(531),
    [anon_sym_delete] = ACTIONS(531),
    [anon_sym_PLUS_PLUS] = ACTIONS(529),
    [anon_sym_DASH_DASH] = ACTIONS(529),
    [anon_sym_DQUOTE] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(529),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(529),
    [sym_number] = ACTIONS(529),
    [sym_private_property_identifier] = ACTIONS(529),
    [sym_this] = ACTIONS(531),
    [sym_super] = ACTIONS(531),
    [sym_true] = ACTIONS(531),
    [sym_false] = ACTIONS(531),
    [sym_null] = ACTIONS(531),
    [sym_undefined] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(529),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
    [sym__automatic_semicolon] = ACTIONS(537),
    [sym__ternary_qmark] = ACTIONS(535),
    [sym_html_comment] = ACTIONS(5),
  },
  [69] = {
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_STAR] = ACTIONS(543),
    [anon_sym_default] = ACTIONS(541),
    [anon_sym_LBRACE] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(545),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_import] = ACTIONS(541),
    [anon_sym_with] = ACTIONS(541),
    [anon_sym_var] = ACTIONS(541),
    [anon_sym_let] = ACTIONS(541),
    [anon_sym_const] = ACTIONS(541),
    [anon_sym_else] = ACTIONS(541),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_switch] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_LPAREN] = ACTIONS(539),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_await] = ACTIONS(541),
    [anon_sym_in] = ACTIONS(543),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_do] = ACTIONS(541),
    [anon_sym_try] = ACTIONS(541),
    [anon_sym_break] = ACTIONS(541),
    [anon_sym_continue] = ACTIONS(541),
    [anon_sym_debugger] = ACTIONS(541),
    [anon_sym_return] = ACTIONS(541),
    [anon_sym_throw] = ACTIONS(541),
    [anon_sym_case] = ACTIONS(541),
    [anon_sym_yield] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(541),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_class] = ACTIONS(541),
    [anon_sym_async] = ACTIONS(541),
    [anon_sym_function] = ACTIONS(541),
    [sym_optional_chain] = ACTIONS(545),
    [anon_sym_new] = ACTIONS(541),
    [anon_sym_DOT] = ACTIONS(543),
    [anon_sym_AMP_AMP] = ACTIONS(545),
    [anon_sym_PIPE_PIPE] = ACTIONS(545),
    [anon_sym_GT_GT] = ACTIONS(543),
    [anon_sym_GT_GT_GT] = ACTIONS(545),
    [anon_sym_LT_LT] = ACTIONS(545),
    [anon_sym_AMP] = ACTIONS(543),
    [anon_sym_CARET] = ACTIONS(545),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(541),
    [anon_sym_DASH] = ACTIONS(541),
    [anon_sym_SLASH] = ACTIONS(541),
    [anon_sym_PERCENT] = ACTIONS(545),
    [anon_sym_STAR_STAR] = ACTIONS(545),
    [anon_sym_LT_EQ] = ACTIONS(545),
    [anon_sym_EQ_EQ] = ACTIONS(543),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(545),
    [anon_sym_BANG_EQ] = ACTIONS(543),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(545),
    [anon_sym_GT_EQ] = ACTIONS(545),
    [anon_sym_QMARK_QMARK] = ACTIONS(545),
    [anon_sym_instanceof] = ACTIONS(543),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_TILDE] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(541),
    [anon_sym_void] = ACTIONS(541),
    [anon_sym_delete] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(539),
    [sym_number] = ACTIONS(539),
    [sym_private_property_identifier] = ACTIONS(539),
    [sym_this] = ACTIONS(541),
    [sym_super] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_undefined] = ACTIONS(541),
    [anon_sym_AT] = ACTIONS(539),
    [anon_sym_static] = ACTIONS(541),
    [anon_sym_get] = ACTIONS(541),
    [anon_sym_set] = ACTIONS(541),
    [sym__automatic_semicolon] = ACTIONS(547),
    [sym__ternary_qmark] = ACTIONS(545),
    [sym_html_comment] = ACTIONS(5),
  },
  [70] = {
    [ts_builtin_sym_end] = ACTIONS(549),
    [sym_identifier] = ACTIONS(551),
    [anon_sym_export] = ACTIONS(551),
    [anon_sym_STAR] = ACTIONS(553),
    [anon_sym_default] = ACTIONS(551),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_COMMA] = ACTIONS(555),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_import] = ACTIONS(551),
    [anon_sym_with] = ACTIONS(551),
    [anon_sym_var] = ACTIONS(551),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(551),
    [anon_sym_else] = ACTIONS(551),
    [anon_sym_if] = ACTIONS(551),
    [anon_sym_switch] = ACTIONS(551),
    [anon_sym_for] = ACTIONS(551),
    [anon_sym_LPAREN] = ACTIONS(549),
    [anon_sym_SEMI] = ACTIONS(549),
    [anon_sym_await] = ACTIONS(551),
    [anon_sym_in] = ACTIONS(553),
    [anon_sym_while] = ACTIONS(551),
    [anon_sym_do] = ACTIONS(551),
    [anon_sym_try] = ACTIONS(551),
    [anon_sym_break] = ACTIONS(551),
    [anon_sym_continue] = ACTIONS(551),
    [anon_sym_debugger] = ACTIONS(551),
    [anon_sym_return] = ACTIONS(551),
    [anon_sym_throw] = ACTIONS(551),
    [anon_sym_case] = ACTIONS(551),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(551),
    [anon_sym_GT] = ACTIONS(553),
    [anon_sym_class] = ACTIONS(551),
    [anon_sym_async] = ACTIONS(551),
    [anon_sym_function] = ACTIONS(551),
    [sym_optional_chain] = ACTIONS(555),
    [anon_sym_new] = ACTIONS(551),
    [anon_sym_DOT] = ACTIONS(553),
    [anon_sym_AMP_AMP] = ACTIONS(555),
    [anon_sym_PIPE_PIPE] = ACTIONS(555),
    [anon_sym_GT_GT] = ACTIONS(553),
    [anon_sym_GT_GT_GT] = ACTIONS(555),
    [anon_sym_LT_LT] = ACTIONS(555),
    [anon_sym_AMP] = ACTIONS(553),
    [anon_sym_CARET] = ACTIONS(555),
    [anon_sym_PIPE] = ACTIONS(553),
    [anon_sym_PLUS] = ACTIONS(551),
    [anon_sym_DASH] = ACTIONS(551),
    [anon_sym_SLASH] = ACTIONS(551),
    [anon_sym_PERCENT] = ACTIONS(555),
    [anon_sym_STAR_STAR] = ACTIONS(555),
    [anon_sym_LT_EQ] = ACTIONS(555),
    [anon_sym_EQ_EQ] = ACTIONS(553),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(555),
    [anon_sym_BANG_EQ] = ACTIONS(553),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(555),
    [anon_sym_GT_EQ] = ACTIONS(555),
    [anon_sym_QMARK_QMARK] = ACTIONS(555),
    [anon_sym_instanceof] = ACTIONS(553),
    [anon_sym_BANG] = ACTIONS(551),
    [anon_sym_TILDE] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(551),
    [anon_sym_void] = ACTIONS(551),
    [anon_sym_delete] = ACTIONS(551),
    [anon_sym_PLUS_PLUS] = ACTIONS(549),
    [anon_sym_DASH_DASH] = ACTIONS(549),
    [anon_sym_DQUOTE] = ACTIONS(549),
    [anon_sym_SQUOTE] = ACTIONS(549),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(549),
    [sym_number] = ACTIONS(549),
    [sym_private_property_identifier] = ACTIONS(549),
    [sym_this] = ACTIONS(551),
    [sym_super] = ACTIONS(551),
    [sym_true] = ACTIONS(551),
    [sym_false] = ACTIONS(551),
    [sym_null] = ACTIONS(551),
    [sym_undefined] = ACTIONS(551),
    [anon_sym_AT] = ACTIONS(549),
    [anon_sym_static] = ACTIONS(551),
    [anon_sym_get] = ACTIONS(551),
    [anon_sym_set] = ACTIONS(551),
    [sym__automatic_semicolon] = ACTIONS(557),
    [sym__ternary_qmark] = ACTIONS(555),
    [sym_html_comment] = ACTIONS(5),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(559),
    [sym_identifier] = ACTIONS(561),
    [anon_sym_export] = ACTIONS(561),
    [anon_sym_STAR] = ACTIONS(563),
    [anon_sym_default] = ACTIONS(561),
    [anon_sym_LBRACE] = ACTIONS(559),
    [anon_sym_COMMA] = ACTIONS(565),
    [anon_sym_RBRACE] = ACTIONS(559),
    [anon_sym_import] = ACTIONS(561),
    [anon_sym_with] = ACTIONS(561),
    [anon_sym_var] = ACTIONS(561),
    [anon_sym_let] = ACTIONS(561),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_else] = ACTIONS(561),
    [anon_sym_if] = ACTIONS(561),
    [anon_sym_switch] = ACTIONS(561),
    [anon_sym_for] = ACTIONS(561),
    [anon_sym_LPAREN] = ACTIONS(559),
    [anon_sym_SEMI] = ACTIONS(559),
    [anon_sym_await] = ACTIONS(561),
    [anon_sym_in] = ACTIONS(563),
    [anon_sym_while] = ACTIONS(561),
    [anon_sym_do] = ACTIONS(561),
    [anon_sym_try] = ACTIONS(561),
    [anon_sym_break] = ACTIONS(561),
    [anon_sym_continue] = ACTIONS(561),
    [anon_sym_debugger] = ACTIONS(561),
    [anon_sym_return] = ACTIONS(561),
    [anon_sym_throw] = ACTIONS(561),
    [anon_sym_case] = ACTIONS(561),
    [anon_sym_yield] = ACTIONS(561),
    [anon_sym_LBRACK] = ACTIONS(559),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_GT] = ACTIONS(563),
    [anon_sym_class] = ACTIONS(561),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(561),
    [sym_optional_chain] = ACTIONS(565),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT] = ACTIONS(563),
    [anon_sym_AMP_AMP] = ACTIONS(565),
    [anon_sym_PIPE_PIPE] = ACTIONS(565),
    [anon_sym_GT_GT] = ACTIONS(563),
    [anon_sym_GT_GT_GT] = ACTIONS(565),
    [anon_sym_LT_LT] = ACTIONS(565),
    [anon_sym_AMP] = ACTIONS(563),
    [anon_sym_CARET] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(563),
    [anon_sym_PLUS] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(561),
    [anon_sym_PERCENT] = ACTIONS(565),
    [anon_sym_STAR_STAR] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(565),
    [anon_sym_EQ_EQ] = ACTIONS(563),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(565),
    [anon_sym_BANG_EQ] = ACTIONS(563),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(565),
    [anon_sym_GT_EQ] = ACTIONS(565),
    [anon_sym_QMARK_QMARK] = ACTIONS(565),
    [anon_sym_instanceof] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(561),
    [anon_sym_TILDE] = ACTIONS(559),
    [anon_sym_typeof] = ACTIONS(561),
    [anon_sym_void] = ACTIONS(561),
    [anon_sym_delete] = ACTIONS(561),
    [anon_sym_PLUS_PLUS] = ACTIONS(559),
    [anon_sym_DASH_DASH] = ACTIONS(559),
    [anon_sym_DQUOTE] = ACTIONS(559),
    [anon_sym_SQUOTE] = ACTIONS(559),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(559),
    [sym_number] = ACTIONS(559),
    [sym_private_property_identifier] = ACTIONS(559),
    [sym_this] = ACTIONS(561),
    [sym_super] = ACTIONS(561),
    [sym_true] = ACTIONS(561),
    [sym_false] = ACTIONS(561),
    [sym_null] = ACTIONS(561),
    [sym_undefined] = ACTIONS(561),
    [anon_sym_AT] = ACTIONS(559),
    [anon_sym_static] = ACTIONS(561),
    [anon_sym_get] = ACTIONS(561),
    [anon_sym_set] = ACTIONS(561),
    [sym__automatic_semicolon] = ACTIONS(567),
    [sym__ternary_qmark] = ACTIONS(565),
    [sym_html_comment] = ACTIONS(5),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(569),
    [sym_identifier] = ACTIONS(571),
    [anon_sym_export] = ACTIONS(571),
    [anon_sym_STAR] = ACTIONS(573),
    [anon_sym_default] = ACTIONS(571),
    [anon_sym_LBRACE] = ACTIONS(569),
    [anon_sym_COMMA] = ACTIONS(575),
    [anon_sym_RBRACE] = ACTIONS(569),
    [anon_sym_import] = ACTIONS(571),
    [anon_sym_with] = ACTIONS(571),
    [anon_sym_var] = ACTIONS(571),
    [anon_sym_let] = ACTIONS(571),
    [anon_sym_const] = ACTIONS(571),
    [anon_sym_else] = ACTIONS(571),
    [anon_sym_if] = ACTIONS(571),
    [anon_sym_switch] = ACTIONS(571),
    [anon_sym_for] = ACTIONS(571),
    [anon_sym_LPAREN] = ACTIONS(569),
    [anon_sym_SEMI] = ACTIONS(569),
    [anon_sym_await] = ACTIONS(571),
    [anon_sym_in] = ACTIONS(573),
    [anon_sym_while] = ACTIONS(571),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(571),
    [anon_sym_break] = ACTIONS(571),
    [anon_sym_continue] = ACTIONS(571),
    [anon_sym_debugger] = ACTIONS(571),
    [anon_sym_return] = ACTIONS(571),
    [anon_sym_throw] = ACTIONS(571),
    [anon_sym_case] = ACTIONS(571),
    [anon_sym_yield] = ACTIONS(571),
    [anon_sym_LBRACK] = ACTIONS(569),
    [anon_sym_LT] = ACTIONS(571),
    [anon_sym_GT] = ACTIONS(573),
    [anon_sym_class] = ACTIONS(571),
    [anon_sym_async] = ACTIONS(571),
    [anon_sym_function] = ACTIONS(571),
    [sym_optional_chain] = ACTIONS(575),
    [anon_sym_new] = ACTIONS(571),
    [anon_sym_DOT] = ACTIONS(573),
    [anon_sym_AMP_AMP] = ACTIONS(575),
    [anon_sym_PIPE_PIPE] = ACTIONS(575),
    [anon_sym_GT_GT] = ACTIONS(573),
    [anon_sym_GT_GT_GT] = ACTIONS(575),
    [anon_sym_LT_LT] = ACTIONS(575),
    [anon_sym_AMP] = ACTIONS(573),
    [anon_sym_CARET] = ACTIONS(575),
    [anon_sym_PIPE] = ACTIONS(573),
    [anon_sym_PLUS] = ACTIONS(571),
    [anon_sym_DASH] = ACTIONS(571),
    [anon_sym_SLASH] = ACTIONS(571),
    [anon_sym_PERCENT] = ACTIONS(575),
    [anon_sym_STAR_STAR] = ACTIONS(575),
    [anon_sym_LT_EQ] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(573),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(575),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(575),
    [anon_sym_GT_EQ] = ACTIONS(575),
    [anon_sym_QMARK_QMARK] = ACTIONS(575),
    [anon_sym_instanceof] = ACTIONS(573),
    [anon_sym_BANG] = ACTIONS(571),
    [anon_sym_TILDE] = ACTIONS(569),
    [anon_sym_typeof] = ACTIONS(571),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(571),
    [anon_sym_PLUS_PLUS] = ACTIONS(569),
    [anon_sym_DASH_DASH] = ACTIONS(569),
    [anon_sym_DQUOTE] = ACTIONS(569),
    [anon_sym_SQUOTE] = ACTIONS(569),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(569),
    [sym_number] = ACTIONS(569),
    [sym_private_property_identifier] = ACTIONS(569),
    [sym_this] = ACTIONS(571),
    [sym_super] = ACTIONS(571),
    [sym_true] = ACTIONS(571),
    [sym_false] = ACTIONS(571),
    [sym_null] = ACTIONS(571),
    [sym_undefined] = ACTIONS(571),
    [anon_sym_AT] = ACTIONS(569),
    [anon_sym_static] = ACTIONS(571),
    [anon_sym_get] = ACTIONS(571),
    [anon_sym_set] = ACTIONS(571),
    [sym__automatic_semicolon] = ACTIONS(577),
    [sym__ternary_qmark] = ACTIONS(575),
    [sym_html_comment] = ACTIONS(5),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(579),
    [sym_identifier] = ACTIONS(581),
    [anon_sym_export] = ACTIONS(581),
    [anon_sym_STAR] = ACTIONS(583),
    [anon_sym_default] = ACTIONS(581),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(585),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_import] = ACTIONS(581),
    [anon_sym_with] = ACTIONS(581),
    [anon_sym_var] = ACTIONS(581),
    [anon_sym_let] = ACTIONS(581),
    [anon_sym_const] = ACTIONS(581),
    [anon_sym_else] = ACTIONS(581),
    [anon_sym_if] = ACTIONS(581),
    [anon_sym_switch] = ACTIONS(581),
    [anon_sym_for] = ACTIONS(581),
    [anon_sym_LPAREN] = ACTIONS(579),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_await] = ACTIONS(581),
    [anon_sym_in] = ACTIONS(583),
    [anon_sym_while] = ACTIONS(581),
    [anon_sym_do] = ACTIONS(581),
    [anon_sym_try] = ACTIONS(581),
    [anon_sym_break] = ACTIONS(581),
    [anon_sym_continue] = ACTIONS(581),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(581),
    [anon_sym_throw] = ACTIONS(581),
    [anon_sym_case] = ACTIONS(581),
    [anon_sym_yield] = ACTIONS(581),
    [anon_sym_LBRACK] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(581),
    [anon_sym_GT] = ACTIONS(583),
    [anon_sym_class] = ACTIONS(581),
    [anon_sym_async] = ACTIONS(581),
    [anon_sym_function] = ACTIONS(581),
    [sym_optional_chain] = ACTIONS(585),
    [anon_sym_new] = ACTIONS(581),
    [anon_sym_DOT] = ACTIONS(583),
    [anon_sym_AMP_AMP] = ACTIONS(585),
    [anon_sym_PIPE_PIPE] = ACTIONS(585),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_GT_GT_GT] = ACTIONS(585),
    [anon_sym_LT_LT] = ACTIONS(585),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(585),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_PLUS] = ACTIONS(581),
    [anon_sym_DASH] = ACTIONS(581),
    [anon_sym_SLASH] = ACTIONS(581),
    [anon_sym_PERCENT] = ACTIONS(585),
    [anon_sym_STAR_STAR] = ACTIONS(585),
    [anon_sym_LT_EQ] = ACTIONS(585),
    [anon_sym_EQ_EQ] = ACTIONS(583),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(585),
    [anon_sym_BANG_EQ] = ACTIONS(583),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(585),
    [anon_sym_GT_EQ] = ACTIONS(585),
    [anon_sym_QMARK_QMARK] = ACTIONS(585),
    [anon_sym_instanceof] = ACTIONS(583),
    [anon_sym_BANG] = ACTIONS(581),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_typeof] = ACTIONS(581),
    [anon_sym_void] = ACTIONS(581),
    [anon_sym_delete] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(579),
    [anon_sym_DASH_DASH] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_SQUOTE] = ACTIONS(579),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(579),
    [sym_number] = ACTIONS(579),
    [sym_private_property_identifier] = ACTIONS(579),
    [sym_this] = ACTIONS(581),
    [sym_super] = ACTIONS(581),
    [sym_true] = ACTIONS(581),
    [sym_false] = ACTIONS(581),
    [sym_null] = ACTIONS(581),
    [sym_undefined] = ACTIONS(581),
    [anon_sym_AT] = ACTIONS(579),
    [anon_sym_static] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(581),
    [anon_sym_set] = ACTIONS(581),
    [sym__automatic_semicolon] = ACTIONS(587),
    [sym__ternary_qmark] = ACTIONS(585),
    [sym_html_comment] = ACTIONS(5),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(589),
    [sym_identifier] = ACTIONS(591),
    [anon_sym_export] = ACTIONS(591),
    [anon_sym_STAR] = ACTIONS(593),
    [anon_sym_default] = ACTIONS(591),
    [anon_sym_LBRACE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(595),
    [anon_sym_RBRACE] = ACTIONS(589),
    [anon_sym_import] = ACTIONS(591),
    [anon_sym_with] = ACTIONS(591),
    [anon_sym_var] = ACTIONS(591),
    [anon_sym_let] = ACTIONS(591),
    [anon_sym_const] = ACTIONS(591),
    [anon_sym_else] = ACTIONS(591),
    [anon_sym_if] = ACTIONS(591),
    [anon_sym_switch] = ACTIONS(591),
    [anon_sym_for] = ACTIONS(591),
    [anon_sym_LPAREN] = ACTIONS(589),
    [anon_sym_SEMI] = ACTIONS(589),
    [anon_sym_await] = ACTIONS(591),
    [anon_sym_in] = ACTIONS(593),
    [anon_sym_while] = ACTIONS(591),
    [anon_sym_do] = ACTIONS(591),
    [anon_sym_try] = ACTIONS(591),
    [anon_sym_break] = ACTIONS(591),
    [anon_sym_continue] = ACTIONS(591),
    [anon_sym_debugger] = ACTIONS(591),
    [anon_sym_return] = ACTIONS(591),
    [anon_sym_throw] = ACTIONS(591),
    [anon_sym_case] = ACTIONS(591),
    [anon_sym_yield] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(589),
    [anon_sym_LT] = ACTIONS(591),
    [anon_sym_GT] = ACTIONS(593),
    [anon_sym_class] = ACTIONS(591),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(591),
    [sym_optional_chain] = ACTIONS(595),
    [anon_sym_new] = ACTIONS(591),
    [anon_sym_DOT] = ACTIONS(593),
    [anon_sym_AMP_AMP] = ACTIONS(595),
    [anon_sym_PIPE_PIPE] = ACTIONS(595),
    [anon_sym_GT_GT] = ACTIONS(593),
    [anon_sym_GT_GT_GT] = ACTIONS(595),
    [anon_sym_LT_LT] = ACTIONS(595),
    [anon_sym_AMP] = ACTIONS(593),
    [anon_sym_CARET] = ACTIONS(595),
    [anon_sym_PIPE] = ACTIONS(593),
    [anon_sym_PLUS] = ACTIONS(591),
    [anon_sym_DASH] = ACTIONS(591),
    [anon_sym_SLASH] = ACTIONS(591),
    [anon_sym_PERCENT] = ACTIONS(595),
    [anon_sym_STAR_STAR] = ACTIONS(595),
    [anon_sym_LT_EQ] = ACTIONS(595),
    [anon_sym_EQ_EQ] = ACTIONS(593),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(595),
    [anon_sym_BANG_EQ] = ACTIONS(593),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(595),
    [anon_sym_GT_EQ] = ACTIONS(595),
    [anon_sym_QMARK_QMARK] = ACTIONS(595),
    [anon_sym_instanceof] = ACTIONS(593),
    [anon_sym_BANG] = ACTIONS(591),
    [anon_sym_TILDE] = ACTIONS(589),
    [anon_sym_typeof] = ACTIONS(591),
    [anon_sym_void] = ACTIONS(591),
    [anon_sym_delete] = ACTIONS(591),
    [anon_sym_PLUS_PLUS] = ACTIONS(589),
    [anon_sym_DASH_DASH] = ACTIONS(589),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [anon_sym_SQUOTE] = ACTIONS(589),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [sym_number] = ACTIONS(589),
    [sym_private_property_identifier] = ACTIONS(589),
    [sym_this] = ACTIONS(591),
    [sym_super] = ACTIONS(591),
    [sym_true] = ACTIONS(591),
    [sym_false] = ACTIONS(591),
    [sym_null] = ACTIONS(591),
    [sym_undefined] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(589),
    [anon_sym_static] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(591),
    [anon_sym_set] = ACTIONS(591),
    [sym__automatic_semicolon] = ACTIONS(597),
    [sym__ternary_qmark] = ACTIONS(595),
    [sym_html_comment] = ACTIONS(5),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(599),
    [sym_identifier] = ACTIONS(601),
    [anon_sym_export] = ACTIONS(601),
    [anon_sym_STAR] = ACTIONS(603),
    [anon_sym_default] = ACTIONS(601),
    [anon_sym_LBRACE] = ACTIONS(599),
    [anon_sym_COMMA] = ACTIONS(605),
    [anon_sym_RBRACE] = ACTIONS(599),
    [anon_sym_import] = ACTIONS(601),
    [anon_sym_with] = ACTIONS(601),
    [anon_sym_var] = ACTIONS(601),
    [anon_sym_let] = ACTIONS(601),
    [anon_sym_const] = ACTIONS(601),
    [anon_sym_else] = ACTIONS(601),
    [anon_sym_if] = ACTIONS(601),
    [anon_sym_switch] = ACTIONS(601),
    [anon_sym_for] = ACTIONS(601),
    [anon_sym_LPAREN] = ACTIONS(599),
    [anon_sym_SEMI] = ACTIONS(599),
    [anon_sym_await] = ACTIONS(601),
    [anon_sym_in] = ACTIONS(603),
    [anon_sym_while] = ACTIONS(601),
    [anon_sym_do] = ACTIONS(601),
    [anon_sym_try] = ACTIONS(601),
    [anon_sym_break] = ACTIONS(601),
    [anon_sym_continue] = ACTIONS(601),
    [anon_sym_debugger] = ACTIONS(601),
    [anon_sym_return] = ACTIONS(601),
    [anon_sym_throw] = ACTIONS(601),
    [anon_sym_case] = ACTIONS(601),
    [anon_sym_yield] = ACTIONS(601),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(601),
    [anon_sym_GT] = ACTIONS(603),
    [anon_sym_class] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(601),
    [anon_sym_function] = ACTIONS(601),
    [sym_optional_chain] = ACTIONS(605),
    [anon_sym_new] = ACTIONS(601),
    [anon_sym_DOT] = ACTIONS(603),
    [anon_sym_AMP_AMP] = ACTIONS(605),
    [anon_sym_PIPE_PIPE] = ACTIONS(605),
    [anon_sym_GT_GT] = ACTIONS(603),
    [anon_sym_GT_GT_GT] = ACTIONS(605),
    [anon_sym_LT_LT] = ACTIONS(605),
    [anon_sym_AMP] = ACTIONS(603),
    [anon_sym_CARET] = ACTIONS(605),
    [anon_sym_PIPE] = ACTIONS(603),
    [anon_sym_PLUS] = ACTIONS(601),
    [anon_sym_DASH] = ACTIONS(601),
    [anon_sym_SLASH] = ACTIONS(601),
    [anon_sym_PERCENT] = ACTIONS(605),
    [anon_sym_STAR_STAR] = ACTIONS(605),
    [anon_sym_LT_EQ] = ACTIONS(605),
    [anon_sym_EQ_EQ] = ACTIONS(603),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(605),
    [anon_sym_BANG_EQ] = ACTIONS(603),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(605),
    [anon_sym_GT_EQ] = ACTIONS(605),
    [anon_sym_QMARK_QMARK] = ACTIONS(605),
    [anon_sym_instanceof] = ACTIONS(603),
    [anon_sym_BANG] = ACTIONS(601),
    [anon_sym_TILDE] = ACTIONS(599),
    [anon_sym_typeof] = ACTIONS(601),
    [anon_sym_void] = ACTIONS(601),
    [anon_sym_delete] = ACTIONS(601),
    [anon_sym_PLUS_PLUS] = ACTIONS(599),
    [anon_sym_DASH_DASH] = ACTIONS(599),
    [anon_sym_DQUOTE] = ACTIONS(599),
    [anon_sym_SQUOTE] = ACTIONS(599),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(599),
    [sym_number] = ACTIONS(599),
    [sym_private_property_identifier] = ACTIONS(599),
    [sym_this] = ACTIONS(601),
    [sym_super] = ACTIONS(601),
    [sym_true] = ACTIONS(601),
    [sym_false] = ACTIONS(601),
    [sym_null] = ACTIONS(601),
    [sym_undefined] = ACTIONS(601),
    [anon_sym_AT] = ACTIONS(599),
    [anon_sym_static] = ACTIONS(601),
    [anon_sym_get] = ACTIONS(601),
    [anon_sym_set] = ACTIONS(601),
    [sym__automatic_semicolon] = ACTIONS(607),
    [sym__ternary_qmark] = ACTIONS(605),
    [sym_html_comment] = ACTIONS(5),
  },
  [76] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(761),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1237),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1258),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(615),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [77] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(769),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1237),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1258),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(615),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [78] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1217),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1185),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(621),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [79] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1217),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1185),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(623),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [80] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1217),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1185),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [81] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1217),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1185),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(627),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [82] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1217),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1185),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(613),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [83] = {
    [sym_declaration] = STATE(363),
    [sym_import] = STATE(1142),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(806),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1133),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(631),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [84] = {
    [sym_declaration] = STATE(417),
    [sym_import] = STATE(1142),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(809),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1133),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(631),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(633),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [85] = {
    [sym_declaration] = STATE(363),
    [sym_import] = STATE(1142),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(806),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1104),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(631),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [86] = {
    [sym_declaration] = STATE(417),
    [sym_import] = STATE(1142),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(809),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_class_declaration] = STATE(389),
    [sym_function_expression] = STATE(612),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function] = STATE(612),
    [sym_generator_function_declaration] = STATE(389),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1104),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(631),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(339),
    [anon_sym_async] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(343),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [87] = {
    [sym_import] = STATE(1148),
    [sym_variable_declaration] = STATE(110),
    [sym_lexical_declaration] = STATE(110),
    [sym_empty_statement] = STATE(110),
    [sym_parenthesized_expression] = STATE(490),
    [sym_expression] = STATE(798),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1241),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1241),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(490),
    [sym_subscript_expression] = STATE(490),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1241),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1556),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(637),
    [anon_sym_export] = ACTIONS(639),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(643),
    [anon_sym_let] = ACTIONS(645),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(639),
    [anon_sym_get] = ACTIONS(639),
    [anon_sym_set] = ACTIONS(639),
    [sym_html_comment] = ACTIONS(5),
  },
  [88] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(847),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(492),
    [sym_subscript_expression] = STATE(492),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(655),
    [anon_sym_export] = ACTIONS(657),
    [anon_sym_LBRACE] = ACTIONS(659),
    [anon_sym_COMMA] = ACTIONS(661),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(663),
    [anon_sym_RBRACK] = ACTIONS(665),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(671),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(657),
    [anon_sym_get] = ACTIONS(657),
    [anon_sym_set] = ACTIONS(657),
    [sym_html_comment] = ACTIONS(5),
  },
  [89] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1214),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1128),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_pattern_repeat1] = STATE(1187),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(661),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_RBRACK] = ACTIONS(681),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [90] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1247),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1155),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_pattern_repeat1] = STATE(1168),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(661),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_RBRACK] = ACTIONS(665),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [91] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(759),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1355),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_spread_element] = STATE(1212),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(687),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_RBRACK] = ACTIONS(687),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [92] = {
    [sym_import] = STATE(1148),
    [sym_variable_declaration] = STATE(108),
    [sym_lexical_declaration] = STATE(108),
    [sym_empty_statement] = STATE(108),
    [sym_parenthesized_expression] = STATE(490),
    [sym_expression] = STATE(801),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1241),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1241),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(490),
    [sym_subscript_expression] = STATE(490),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1241),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1607),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(637),
    [anon_sym_export] = ACTIONS(639),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(643),
    [anon_sym_let] = ACTIONS(645),
    [anon_sym_const] = ACTIONS(647),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(639),
    [anon_sym_get] = ACTIONS(639),
    [anon_sym_set] = ACTIONS(639),
    [sym_html_comment] = ACTIONS(5),
  },
  [93] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1355),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_COMMA] = ACTIONS(690),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [94] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1248),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1571),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1160),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(692),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [95] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(749),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1248),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1549),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1160),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(692),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [96] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1416),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1176),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(694),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [97] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(791),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_spread_element] = STATE(1180),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1181),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(698),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [98] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1416),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1176),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(702),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [99] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(751),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_spread_element] = STATE(1206),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1207),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(704),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [100] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1248),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1160),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(692),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [101] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_spread_element] = STATE(1233),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [aux_sym_array_repeat1] = STATE(1234),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(706),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [102] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(759),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_spread_element] = STATE(1212),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_COMMA] = ACTIONS(708),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(708),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_RBRACK] = ACTIONS(708),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [103] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(812),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1097),
    [sym_assignment_pattern] = STATE(1302),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1097),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1097),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [sym_pattern] = STATE(1230),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(609),
    [anon_sym_export] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(619),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(611),
    [anon_sym_get] = ACTIONS(611),
    [anon_sym_set] = ACTIONS(611),
    [sym_html_comment] = ACTIONS(5),
  },
  [104] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1302),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1230),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [105] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1089),
    [sym_assignment_pattern] = STATE(1416),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1089),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1089),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [sym_pattern] = STATE(1176),
    [sym_rest_pattern] = STATE(1086),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(673),
    [anon_sym_export] = ACTIONS(675),
    [anon_sym_LBRACE] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(683),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(675),
    [anon_sym_get] = ACTIONS(675),
    [anon_sym_set] = ACTIONS(675),
    [sym_html_comment] = ACTIONS(5),
  },
  [106] = {
    [sym_import] = STATE(1148),
    [sym_empty_statement] = STATE(115),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(774),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1548),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [107] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(735),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1491),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(710),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym__automatic_semicolon] = ACTIONS(710),
    [sym_html_comment] = ACTIONS(5),
  },
  [108] = {
    [sym_import] = STATE(1148),
    [sym_empty_statement] = STATE(117),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(787),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1526),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [109] = {
    [sym_import] = STATE(1148),
    [sym_empty_statement] = STATE(119),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(788),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1535),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [110] = {
    [sym_import] = STATE(1148),
    [sym_empty_statement] = STATE(122),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(780),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1565),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [111] = {
    [sym_namespace_export] = STATE(1346),
    [sym_export_clause] = STATE(1134),
    [sym_declaration] = STATE(405),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_class_declaration] = STATE(389),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function_declaration] = STATE(389),
    [sym_decorator] = STATE(966),
    [aux_sym_export_statement_repeat1] = STATE(1127),
    [aux_sym_object_repeat1] = STATE(1201),
    [aux_sym_object_pattern_repeat1] = STATE(1210),
    [anon_sym_STAR] = ACTIONS(712),
    [anon_sym_default] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(720),
    [anon_sym_var] = ACTIONS(722),
    [anon_sym_let] = ACTIONS(724),
    [anon_sym_const] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_in] = ACTIONS(729),
    [anon_sym_COLON] = ACTIONS(731),
    [anon_sym_EQ] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(718),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_class] = ACTIONS(736),
    [anon_sym_async] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(740),
    [anon_sym_EQ_GT] = ACTIONS(742),
    [sym_optional_chain] = ACTIONS(718),
    [anon_sym_DOT] = ACTIONS(718),
    [anon_sym_PLUS_EQ] = ACTIONS(744),
    [anon_sym_DASH_EQ] = ACTIONS(744),
    [anon_sym_STAR_EQ] = ACTIONS(744),
    [anon_sym_SLASH_EQ] = ACTIONS(744),
    [anon_sym_PERCENT_EQ] = ACTIONS(744),
    [anon_sym_CARET_EQ] = ACTIONS(744),
    [anon_sym_AMP_EQ] = ACTIONS(744),
    [anon_sym_PIPE_EQ] = ACTIONS(744),
    [anon_sym_GT_GT_EQ] = ACTIONS(744),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(744),
    [anon_sym_LT_LT_EQ] = ACTIONS(744),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(744),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(744),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(744),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(744),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(729),
    [anon_sym_GT_GT_GT] = ACTIONS(729),
    [anon_sym_LT_LT] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(729),
    [anon_sym_CARET] = ACTIONS(729),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_PLUS] = ACTIONS(729),
    [anon_sym_DASH] = ACTIONS(729),
    [anon_sym_SLASH] = ACTIONS(729),
    [anon_sym_PERCENT] = ACTIONS(729),
    [anon_sym_STAR_STAR] = ACTIONS(729),
    [anon_sym_LT_EQ] = ACTIONS(718),
    [anon_sym_EQ_EQ] = ACTIONS(729),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(718),
    [anon_sym_BANG_EQ] = ACTIONS(729),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(718),
    [anon_sym_GT_EQ] = ACTIONS(718),
    [anon_sym_QMARK_QMARK] = ACTIONS(729),
    [anon_sym_instanceof] = ACTIONS(718),
    [anon_sym_PLUS_PLUS] = ACTIONS(718),
    [anon_sym_DASH_DASH] = ACTIONS(718),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(91),
    [sym__automatic_semicolon] = ACTIONS(718),
    [sym__ternary_qmark] = ACTIONS(718),
    [sym_html_comment] = ACTIONS(5),
  },
  [112] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(760),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1594),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(746),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [113] = {
    [sym_namespace_export] = STATE(1346),
    [sym_export_clause] = STATE(1134),
    [sym_declaration] = STATE(405),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_class_declaration] = STATE(389),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function_declaration] = STATE(389),
    [sym_decorator] = STATE(966),
    [aux_sym_export_statement_repeat1] = STATE(1127),
    [aux_sym_object_repeat1] = STATE(1250),
    [aux_sym_object_pattern_repeat1] = STATE(1210),
    [anon_sym_STAR] = ACTIONS(712),
    [anon_sym_default] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(748),
    [anon_sym_var] = ACTIONS(722),
    [anon_sym_let] = ACTIONS(724),
    [anon_sym_const] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_in] = ACTIONS(729),
    [anon_sym_COLON] = ACTIONS(731),
    [anon_sym_EQ] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(718),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_class] = ACTIONS(736),
    [anon_sym_async] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(740),
    [anon_sym_EQ_GT] = ACTIONS(742),
    [sym_optional_chain] = ACTIONS(718),
    [anon_sym_DOT] = ACTIONS(718),
    [anon_sym_PLUS_EQ] = ACTIONS(744),
    [anon_sym_DASH_EQ] = ACTIONS(744),
    [anon_sym_STAR_EQ] = ACTIONS(744),
    [anon_sym_SLASH_EQ] = ACTIONS(744),
    [anon_sym_PERCENT_EQ] = ACTIONS(744),
    [anon_sym_CARET_EQ] = ACTIONS(744),
    [anon_sym_AMP_EQ] = ACTIONS(744),
    [anon_sym_PIPE_EQ] = ACTIONS(744),
    [anon_sym_GT_GT_EQ] = ACTIONS(744),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(744),
    [anon_sym_LT_LT_EQ] = ACTIONS(744),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(744),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(744),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(744),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(744),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(729),
    [anon_sym_GT_GT_GT] = ACTIONS(729),
    [anon_sym_LT_LT] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(729),
    [anon_sym_CARET] = ACTIONS(729),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_PLUS] = ACTIONS(729),
    [anon_sym_DASH] = ACTIONS(729),
    [anon_sym_SLASH] = ACTIONS(729),
    [anon_sym_PERCENT] = ACTIONS(729),
    [anon_sym_STAR_STAR] = ACTIONS(729),
    [anon_sym_LT_EQ] = ACTIONS(718),
    [anon_sym_EQ_EQ] = ACTIONS(729),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(718),
    [anon_sym_BANG_EQ] = ACTIONS(729),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(718),
    [anon_sym_GT_EQ] = ACTIONS(718),
    [anon_sym_QMARK_QMARK] = ACTIONS(729),
    [anon_sym_instanceof] = ACTIONS(718),
    [anon_sym_PLUS_PLUS] = ACTIONS(718),
    [anon_sym_DASH_DASH] = ACTIONS(718),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(91),
    [sym__automatic_semicolon] = ACTIONS(718),
    [sym__ternary_qmark] = ACTIONS(718),
    [sym_html_comment] = ACTIONS(5),
  },
  [114] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(786),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1504),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(750),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [115] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(799),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1520),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(752),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [116] = {
    [sym_namespace_export] = STATE(1346),
    [sym_export_clause] = STATE(1134),
    [sym_declaration] = STATE(405),
    [sym_variable_declaration] = STATE(389),
    [sym_lexical_declaration] = STATE(389),
    [sym_class_declaration] = STATE(389),
    [sym_function_declaration] = STATE(389),
    [sym_generator_function_declaration] = STATE(389),
    [sym_decorator] = STATE(966),
    [aux_sym_export_statement_repeat1] = STATE(1127),
    [aux_sym_object_repeat1] = STATE(1250),
    [aux_sym_object_pattern_repeat1] = STATE(1210),
    [anon_sym_STAR] = ACTIONS(712),
    [anon_sym_default] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(754),
    [anon_sym_var] = ACTIONS(722),
    [anon_sym_let] = ACTIONS(724),
    [anon_sym_const] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_SEMI] = ACTIONS(718),
    [anon_sym_in] = ACTIONS(729),
    [anon_sym_COLON] = ACTIONS(731),
    [anon_sym_EQ] = ACTIONS(734),
    [anon_sym_LBRACK] = ACTIONS(718),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_class] = ACTIONS(736),
    [anon_sym_async] = ACTIONS(738),
    [anon_sym_function] = ACTIONS(740),
    [anon_sym_EQ_GT] = ACTIONS(742),
    [sym_optional_chain] = ACTIONS(718),
    [anon_sym_DOT] = ACTIONS(718),
    [anon_sym_PLUS_EQ] = ACTIONS(744),
    [anon_sym_DASH_EQ] = ACTIONS(744),
    [anon_sym_STAR_EQ] = ACTIONS(744),
    [anon_sym_SLASH_EQ] = ACTIONS(744),
    [anon_sym_PERCENT_EQ] = ACTIONS(744),
    [anon_sym_CARET_EQ] = ACTIONS(744),
    [anon_sym_AMP_EQ] = ACTIONS(744),
    [anon_sym_PIPE_EQ] = ACTIONS(744),
    [anon_sym_GT_GT_EQ] = ACTIONS(744),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(744),
    [anon_sym_LT_LT_EQ] = ACTIONS(744),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(744),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(744),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(744),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(744),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(729),
    [anon_sym_GT_GT_GT] = ACTIONS(729),
    [anon_sym_LT_LT] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(729),
    [anon_sym_CARET] = ACTIONS(729),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_PLUS] = ACTIONS(729),
    [anon_sym_DASH] = ACTIONS(729),
    [anon_sym_SLASH] = ACTIONS(729),
    [anon_sym_PERCENT] = ACTIONS(729),
    [anon_sym_STAR_STAR] = ACTIONS(729),
    [anon_sym_LT_EQ] = ACTIONS(718),
    [anon_sym_EQ_EQ] = ACTIONS(729),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(718),
    [anon_sym_BANG_EQ] = ACTIONS(729),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(718),
    [anon_sym_GT_EQ] = ACTIONS(718),
    [anon_sym_QMARK_QMARK] = ACTIONS(729),
    [anon_sym_instanceof] = ACTIONS(718),
    [anon_sym_PLUS_PLUS] = ACTIONS(718),
    [anon_sym_DASH_DASH] = ACTIONS(718),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(91),
    [sym__automatic_semicolon] = ACTIONS(718),
    [sym__ternary_qmark] = ACTIONS(718),
    [sym_html_comment] = ACTIONS(5),
  },
  [117] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(776),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1544),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [118] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(778),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1502),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(758),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [119] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(779),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1561),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(760),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [120] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(781),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1564),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(762),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [121] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1202),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1202),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1202),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(764),
    [anon_sym_export] = ACTIONS(766),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(768),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_const] = ACTIONS(772),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(774),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(776),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(766),
    [anon_sym_get] = ACTIONS(766),
    [anon_sym_set] = ACTIONS(766),
    [sym_html_comment] = ACTIONS(5),
  },
  [122] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(770),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1551),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(778),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [123] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(452),
    [sym_expression] = STATE(850),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(590),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(452),
    [sym_subscript_expression] = STATE(452),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(780),
    [anon_sym_export] = ACTIONS(782),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(782),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(784),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(786),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(788),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(782),
    [anon_sym_get] = ACTIONS(782),
    [anon_sym_set] = ACTIONS(782),
    [sym_html_comment] = ACTIONS(5),
  },
  [124] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(539),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(742),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [125] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(541),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(743),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [126] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(527),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(589),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [127] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(777),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1540),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [128] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(501),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(503),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_DOT] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [129] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(802),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [130] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(712),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(713),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [131] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(676),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(677),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [132] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(537),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(566),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [133] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(539),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(582),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [134] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(541),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(568),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [135] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(773),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1508),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [136] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(714),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(715),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [137] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(785),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1525),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [138] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(501),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(503),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(798),
    [anon_sym_export] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(800),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(802),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_DOT] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(800),
    [anon_sym_get] = ACTIONS(800),
    [anon_sym_set] = ACTIONS(800),
    [sym_html_comment] = ACTIONS(5),
  },
  [139] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(622),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(623),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [140] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(452),
    [sym_expression] = STATE(850),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(590),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(452),
    [sym_subscript_expression] = STATE(452),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(804),
    [anon_sym_export] = ACTIONS(806),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(806),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(808),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT] = ACTIONS(786),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(788),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(806),
    [anon_sym_get] = ACTIONS(806),
    [anon_sym_set] = ACTIONS(806),
    [sym_html_comment] = ACTIONS(5),
  },
  [141] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(764),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1552),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [142] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(658),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(659),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [143] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(622),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(683),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym_html_comment] = ACTIONS(5),
  },
  [144] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(800),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1541),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [145] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(753),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1509),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [146] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(658),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(686),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym_html_comment] = ACTIONS(5),
  },
  [147] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(721),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_sequence_expression] = STATE(1500),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [148] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(676),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(699),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym_html_comment] = ACTIONS(5),
  },
  [149] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(709),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(700),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym_html_comment] = ACTIONS(5),
  },
  [150] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(712),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(701),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym_html_comment] = ACTIONS(5),
  },
  [151] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(714),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(702),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1595),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1595),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(999),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1595),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1596),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(435),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(439),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym_html_comment] = ACTIONS(5),
  },
  [152] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(794),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1557),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [153] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(752),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1604),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [154] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(755),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1510),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [155] = {
    [sym_import] = STATE(1142),
    [sym_statement_block] = STATE(709),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(710),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [156] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(524),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(576),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [157] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(512),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(579),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [158] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(524),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(744),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [159] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(758),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1513),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [160] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(512),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(750),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [161] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(747),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1583),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [162] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(768),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1516),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [163] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(527),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(740),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [164] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(524),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(803),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [165] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(512),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(820),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [166] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(527),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(834),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [167] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(537),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [168] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(539),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(836),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [169] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(541),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(837),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [170] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(501),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(503),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(810),
    [anon_sym_export] = ACTIONS(812),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(812),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(814),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_DOT] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(812),
    [anon_sym_get] = ACTIONS(812),
    [anon_sym_set] = ACTIONS(812),
    [sym_html_comment] = ACTIONS(5),
  },
  [171] = {
    [sym_import] = STATE(1148),
    [sym_statement_block] = STATE(537),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(741),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [172] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(792),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1563),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [173] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(631),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [174] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(841),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [175] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(606),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [176] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(620),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [177] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(812),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [178] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(621),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [179] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(848),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [180] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(657),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [181] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(596),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [182] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(660),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [183] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(600),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [184] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(433),
    [sym_expression] = STATE(843),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1517),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1517),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(433),
    [sym_subscript_expression] = STATE(433),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1001),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1517),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1532),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_TILDE] = ACTIONS(463),
    [anon_sym_typeof] = ACTIONS(461),
    [anon_sym_void] = ACTIONS(461),
    [anon_sym_delete] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(467),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym_html_comment] = ACTIONS(5),
  },
  [185] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(663),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [186] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(771),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [187] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(664),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [188] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(665),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [189] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(666),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [190] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(667),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [191] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(719),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [192] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(505),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [193] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(504),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [194] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(574),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [195] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(668),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [196] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(571),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [197] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(595),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [198] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(669),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [199] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(580),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [200] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(588),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [201] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(603),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [202] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(592),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [203] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(594),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [204] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(570),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [205] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(573),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [206] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(575),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [207] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(578),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [208] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [209] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(587),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [210] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [211] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(593),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [212] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(581),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [213] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(670),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [214] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(671),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [215] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(672),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [216] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(500),
    [sym_expression] = STATE(849),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1608),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1608),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(500),
    [sym_subscript_expression] = STATE(500),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(997),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1608),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1589),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(485),
    [anon_sym_void] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_DASH_DASH] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(493),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym_html_comment] = ACTIONS(5),
  },
  [217] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [218] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(584),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [219] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(509),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [220] = {
    [sym_import] = STATE(1142),
    [sym_parenthesized_expression] = STATE(480),
    [sym_expression] = STATE(722),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(628),
    [sym_object] = STATE(612),
    [sym_object_pattern] = STATE(1527),
    [sym_array] = STATE(612),
    [sym_array_pattern] = STATE(1527),
    [sym_glimmer_template] = STATE(628),
    [sym_glimmer_opening_tag] = STATE(1245),
    [sym_class] = STATE(612),
    [sym_function_expression] = STATE(612),
    [sym_generator_function] = STATE(612),
    [sym_arrow_function] = STATE(612),
    [sym_call_expression] = STATE(612),
    [sym_new_expression] = STATE(601),
    [sym_await_expression] = STATE(628),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(628),
    [sym__augmented_assignment_lhs] = STATE(1018),
    [sym_augmented_assignment_expression] = STATE(628),
    [sym__destructuring_pattern] = STATE(1527),
    [sym_ternary_expression] = STATE(628),
    [sym_binary_expression] = STATE(628),
    [sym_unary_expression] = STATE(628),
    [sym_update_expression] = STATE(628),
    [sym_string] = STATE(612),
    [sym_template_string] = STATE(612),
    [sym_regex] = STATE(612),
    [sym_meta_property] = STATE(612),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1560),
    [aux_sym_export_statement_repeat1] = STATE(1156),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_export] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_import] = ACTIONS(409),
    [anon_sym_let] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(75),
    [anon_sym_DASH_DASH] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(77),
    [anon_sym_SQUOTE] = ACTIONS(79),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(81),
    [sym_number] = ACTIONS(83),
    [sym_private_property_identifier] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(403),
    [anon_sym_get] = ACTIONS(403),
    [anon_sym_set] = ACTIONS(403),
    [sym_html_comment] = ACTIONS(5),
  },
  [221] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(847),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1519),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1519),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(441),
    [sym_subscript_expression] = STATE(441),
    [sym_assignment_expression] = STATE(528),
    [sym__augmented_assignment_lhs] = STATE(1017),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym__destructuring_pattern] = STATE(1519),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_string] = STATE(526),
    [sym_template_string] = STATE(526),
    [sym_regex] = STATE(526),
    [sym_meta_property] = STATE(526),
    [sym_decorator] = STATE(966),
    [sym_formal_parameters] = STATE(1518),
    [aux_sym_export_statement_repeat1] = STATE(1151),
    [sym_identifier] = ACTIONS(347),
    [anon_sym_export] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_import] = ACTIONS(357),
    [anon_sym_let] = ACTIONS(349),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_await] = ACTIONS(361),
    [anon_sym_yield] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(379),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(379),
    [anon_sym_void] = ACTIONS(379),
    [anon_sym_delete] = ACTIONS(379),
    [anon_sym_PLUS_PLUS] = ACTIONS(385),
    [anon_sym_DASH_DASH] = ACTIONS(385),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [sym_number] = ACTIONS(393),
    [sym_private_property_identifier] = ACTIONS(395),
    [sym_this] = ACTIONS(397),
    [sym_super] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_undefined] = ACTIONS(399),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(349),
    [anon_sym_get] = ACTIONS(349),
    [anon_sym_set] = ACTIONS(349),
    [sym_html_comment] = ACTIONS(5),
  },
  [222] = {
    [sym_import] = STATE(1148),
    [sym_parenthesized_expression] = STATE(441),
    [sym_expression] = STATE(730),
    [sym_primary_expression] = STATE(507),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(526),
    [sym_object_pattern] = STATE(1147),
    [sym_array] = STATE(526),
    [sym_array_pattern] = STATE(1147),
    [sym_glimmer_template] = STATE(528),
    [sym_glimmer_opening_tag] = STATE(1231),
    [sym_class] = STATE(526),
    [sym_function_expression] = STATE(526),
    [sym_generator_function] = STATE(526),
    [sym_arrow_function] = STATE(526),
    [sym_call_expression] = STATE(526),
    [sym_new_expression] = STATE(511),
    [sym_await_expression] = STATE(528),
    [s