#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2904
#define LARGE_STATE_COUNT 467
#define SYMBOL_COUNT 282
#define ALIAS_COUNT 0
#define TOKEN_COUNT 110
#define EXTERNAL_TOKEN_COUNT 5
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 68

enum ts_symbol_identifiers {
  anon_sym_module = 1,
  anon_sym_import = 2,
  anon_sym_EQ = 3,
  sym_pub = 4,
  anon_sym_infix = 5,
  anon_sym_infixr = 6,
  anon_sym_infixl = 7,
  anon_sym_abstract = 8,
  anon_sym_extern = 9,
  anon_sym_COLON = 10,
  anon_sym_RPAREN = 11,
  anon_sym_inline = 12,
  anon_sym_cs = 13,
  anon_sym_js = 14,
  anon_sym_c = 15,
  anon_sym_alias = 16,
  anon_sym_type = 17,
  anon_sym_struct = 18,
  anon_sym_effect = 19,
  anon_sym_named = 20,
  anon_sym_in = 21,
  anon_sym_open = 22,
  anon_sym_extend = 23,
  anon_sym_co = 24,
  anon_sym_div = 25,
  anon_sym_lazy = 26,
  anon_sym_value = 27,
  anon_sym_reference = 28,
  anon_sym_ref = 29,
  anon_sym_linear = 30,
  anon_sym_RBRACK = 31,
  anon_sym_GT = 32,
  anon_sym_PIPE = 33,
  anon_sym_ctx = 34,
  anon_sym_COMMA = 35,
  anon_sym_DASH_GT = 36,
  sym_con = 37,
  anon_sym_val = 38,
  anon_sym_fun = 39,
  anon_sym_ctl = 40,
  anon_sym_noinline = 41,
  anon_sym_fip = 42,
  anon_sym_fbip = 43,
  anon_sym__ = 44,
  anon_sym_tail = 45,
  anon_sym_var = 46,
  anon_sym_COLON_EQ = 47,
  anon_sym_match = 48,
  anon_sym_fn = 49,
  anon_sym_return = 50,
  anon_sym_if = 51,
  anon_sym_then = 52,
  anon_sym_elif = 53,
  anon_sym_else = 54,
  anon_sym_BANG = 55,
  anon_sym_TILDE = 56,
  anon_sym_DOT = 57,
  anon_sym_mask = 58,
  anon_sym_behind = 59,
  sym_borrow = 60,
  anon_sym_file = 61,
  anon_sym_scoped = 62,
  anon_sym_initially = 63,
  anon_sym_finally = 64,
  sym_qconid = 65,
  sym_conid = 66,
  anon_sym_as = 67,
  anon_sym_handler = 68,
  anon_sym_handle = 69,
  sym_override = 70,
  anon_sym_with = 71,
  anon_sym_LT_DASH = 72,
  anon_sym_brk = 73,
  anon_sym_final = 74,
  anon_sym_raw = 75,
  anon_sym_forall = 76,
  anon_sym_some = 77,
  anon_sym_COLON_COLON = 78,
  anon_sym_LBRACK = 79,
  anon_sym_LT = 80,
  anon_sym_LPAREN = 81,
  sym__symbols = 82,
  sym_id = 83,
  sym_escape = 84,
  sym_linecomment = 85,
  anon_sym_SLASH_STAR = 86,
  aux_sym_blockcomment_token1 = 87,
  anon_sym_STAR_SLASH = 88,
  aux_sym_float_token1 = 89,
  aux_sym_float_token2 = 90,
  aux_sym_int_token1 = 91,
  aux_sym_int_token2 = 92,
  sym_qid = 93,
  sym_qidop = 94,
  aux_sym_idop_token1 = 95,
  anon_sym_RPAREN2 = 96,
  sym__WILDCARDID = 97,
  anon_sym_QMARK = 98,
  anon_sym_DQUOTE = 99,
  aux_sym_string_token1 = 100,
  anon_sym_DQUOTE2 = 101,
  anon_sym_SQUOTE = 102,
  aux_sym_char_token1 = 103,
  anon_sym_SQUOTE2 = 104,
  sym__open_brace = 105,
  sym__close_brace = 106,
  sym__semi = 107,
  sym__raw_string = 108,
  sym__end_continuation_signal = 109,
  sym_program = 110,
  sym_eimport = 111,
  sym_import = 112,
  sym_modulepath = 113,
  sym_semis = 114,
  sym_declarations = 115,
  sym_fixitydecl = 116,
  sym_fixity = 117,
  sym_topdecl = 118,
  sym_externdecl = 119,
  sym_externtype = 120,
  sym_externbody = 121,
  sym_externstat = 122,
  sym_externinline = 123,
  sym_externimpbody = 124,
  sym_externimp = 125,
  sym_externval = 126,
  sym_externtarget = 127,
  sym_aliasdecl = 128,
  sym_typedecl = 129,
  sym_typemod = 130,
  sym_structmod = 131,
  sym_effectmod = 132,
  sym_typebody = 133,
  sym_typeid = 134,
  sym_commas = 135,
  sym__comma = 136,
  sym_constructors = 137,
  sym_constructor = 138,
  sym_conparams = 139,
  sym_sconparams = 140,
  sym_opdecls = 141,
  sym_operations = 142,
  sym_operation = 143,
  sym_puredecl = 144,
  sym_inlinemod = 145,
  sym_fipmod = 146,
  sym_fiplimit = 147,
  sym_tailmod = 148,
  sym_fundecl = 149,
  sym_binder = 150,
  sym_funbody = 151,
  sym_annotres = 152,
  sym_block = 153,
  sym_statement = 154,
  sym_decl = 155,
  sym_bodyexpr = 156,
  sym__blockexpr = 157,
  sym_expr = 158,
  sym_basicexpr = 159,
  sym_matchexpr = 160,
  sym_fnexpr = 161,
  sym_returnexpr = 162,
  sym_ifexpr = 163,
  sym_elifs = 164,
  sym_valexpr = 165,
  sym_opexpr = 166,
  sym_ntlexpr = 167,
  sym_atom = 168,
  sym_name = 169,
  sym_literal = 170,
  sym_mask = 171,
  sym_behindmod = 172,
  sym_ctxexpr = 173,
  sym_ctxhole = 174,
  sym_arguments = 175,
  sym_argument = 176,
  sym_parameters = 177,
  sym_parameter = 178,
  sym_paramid = 179,
  sym_pparameters = 180,
  sym_pparameter = 181,
  sym_aexprs = 182,
  sym_cexprs = 183,
  sym__aexpr = 184,
  sym_annot = 185,
  sym__qoperator = 186,
  sym_qidentifier = 187,
  sym_identifier = 188,
  sym_wildcard = 189,
  sym_qimplicit = 190,
  sym_qvarid = 191,
  sym_varid = 192,
  sym__qconstructor = 193,
  sym_op = 194,
  sym_matchrules = 195,
  sym_matchrule = 196,
  sym_patterns = 197,
  sym_apatterns = 198,
  sym__apattern = 199,
  sym_pattern = 200,
  sym_patargs = 201,
  sym_patarg = 202,
  sym_handlerexpr = 203,
  sym_witheff = 204,
  sym_withstat = 205,
  sym_withexpr = 206,
  sym_opclauses = 207,
  sym_opclausex = 208,
  sym_opclause = 209,
  sym_controlmod = 210,
  sym_opparams = 211,
  sym_opparam = 212,
  sym_tbinder = 213,
  sym_typescheme = 214,
  sym_type = 215,
  sym_someforalls = 216,
  sym_typeparams = 217,
  sym_qualifier = 218,
  sym_predicate = 219,
  sym__tarrow = 220,
  sym_tresult = 221,
  sym_tatomic = 222,
  sym_tbasic = 223,
  sym__typeapp = 224,
  sym_typecon = 225,
  sym_tparams = 226,
  sym_tparam = 227,
  sym_targuments = 228,
  sym__anntype = 229,
  sym_kannot = 230,
  sym_kind = 231,
  sym_katom = 232,
  sym__open_brace_ = 233,
  sym__close_brace_ = 234,
  sym__open_square_brace = 235,
  sym__open_angle_brace = 236,
  sym__open_round_brace = 237,
  sym__IMPORT_EXTERN = 238,
  sym_blockcomment = 239,
  sym_float = 240,
  sym_int = 241,
  sym_idop = 242,
  sym_OP = 243,
  sym__IMPLICITID = 244,
  sym_string = 245,
  sym_char = 246,
  aux_sym_semis_repeat1 = 247,
  aux_sym_declarations_repeat1 = 248,
  aux_sym_fixitydecl_repeat1 = 249,
  aux_sym_externbody_repeat1 = 250,
  aux_sym_externimpbody_repeat1 = 251,
  aux_sym_externimp_repeat1 = 252,
  aux_sym_commas_repeat1 = 253,
  aux_sym_constructors_repeat1 = 254,
  aux_sym_sconparams_repeat1 = 255,
  aux_sym_operations_repeat1 = 256,
  aux_sym_block_repeat1 = 257,
  aux_sym_elifs_repeat1 = 258,
  aux_sym_opexpr_repeat1 = 259,
  aux_sym_opexpr_repeat2 = 260,
  aux_sym_opexpr_repeat3 = 261,
  aux_sym_ntlexpr_repeat1 = 262,
  aux_sym_ntlexpr_repeat2 = 263,
  aux_sym_arguments_repeat1 = 264,
  aux_sym_parameters_repeat1 = 265,
  aux_sym_pparameters_repeat1 = 266,
  aux_sym_aexprs_repeat1 = 267,
  aux_sym_matchrules_repeat1 = 268,
  aux_sym_patterns_repeat1 = 269,
  aux_sym_apatterns_repeat1 = 270,
  aux_sym_pattern_repeat1 = 271,
  aux_sym_opclauses_repeat1 = 272,
  aux_sym_opparams_repeat1 = 273,
  aux_sym_typeparams_repeat1 = 274,
  aux_sym_qualifier_repeat1 = 275,
  aux_sym_tparams_repeat1 = 276,
  aux_sym_targuments_repeat1 = 277,
  aux_sym_kind_repeat1 = 278,
  aux_sym_kind_repeat2 = 279,
  aux_sym_blockcomment_repeat1 = 280,
  aux_sym_string_repeat1 = 281,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_module] = "module",
  [anon_sym_import] = "import",
  [anon_sym_EQ] = "=",
  [sym_pub] = "pub",
  [anon_sym_infix] = "infix",
  [anon_sym_infixr] = "infixr",
  [anon_sym_infixl] = "infixl",
  [anon_sym_abstract] = "abstract",
  [anon_sym_extern] = "extern",
  [anon_sym_COLON] = ":",
  [anon_sym_RPAREN] = ")",
  [anon_sym_inline] = "inline",
  [anon_sym_cs] = "cs",
  [anon_sym_js] = "js",
  [anon_sym_c] = "c",
  [anon_sym_alias] = "alias",
  [anon_sym_type] = "type",
  [anon_sym_struct] = "struct",
  [anon_sym_effect] = "effect",
  [anon_sym_named] = "named",
  [anon_sym_in] = "in",
  [anon_sym_open] = "open",
  [anon_sym_extend] = "extend",
  [anon_sym_co] = "co",
  [anon_sym_div] = "div",
  [anon_sym_lazy] = "lazy",
  [anon_sym_value] = "value",
  [anon_sym_reference] = "reference",
  [anon_sym_ref] = "ref",
  [anon_sym_linear] = "linear",
  [anon_sym_RBRACK] = "]",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_ctx] = "ctx",
  [anon_sym_COMMA] = ",",
  [anon_sym_DASH_GT] = "->",
  [sym_con] = "con",
  [anon_sym_val] = "val",
  [anon_sym_fun] = "fun",
  [anon_sym_ctl] = "ctl",
  [anon_sym_noinline] = "noinline",
  [anon_sym_fip] = "fip",
  [anon_sym_fbip] = "fbip",
  [anon_sym__] = "_",
  [anon_sym_tail] = "tail",
  [anon_sym_var] = "var",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_match] = "match",
  [anon_sym_fn] = "fn",
  [anon_sym_return] = "return",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_DOT] = ".",
  [anon_sym_mask] = "mask",
  [anon_sym_behind] = "behind",
  [sym_borrow] = "borrow",
  [anon_sym_file] = "file",
  [anon_sym_scoped] = "scoped",
  [anon_sym_initially] = "initially",
  [anon_sym_finally] = "finally",
  [sym_qconid] = "qconid",
  [sym_conid] = "conid",
  [anon_sym_as] = "as",
  [anon_sym_handler] = "handler",
  [anon_sym_handle] = "handle",
  [sym_override] = "override",
  [anon_sym_with] = "with",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_brk] = "brk",
  [anon_sym_final] = "final",
  [anon_sym_raw] = "raw",
  [anon_sym_forall] = "forall",
  [anon_sym_some] = "some",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LT] = "<",
  [anon_sym_LPAREN] = "(",
  [sym__symbols] = "_symbols",
  [sym_id] = "id",
  [sym_escape] = "escape",
  [sym_linecomment] = "linecomment",
  [anon_sym_SLASH_STAR] = "/*",
  [aux_sym_blockcomment_token1] = "blockcomment_token1",
  [anon_sym_STAR_SLASH] = "*/",
  [aux_sym_float_token1] = "float_token1",
  [aux_sym_float_token2] = "float_token2",
  [aux_sym_int_token1] = "int_token1",
  [aux_sym_int_token2] = "int_token2",
  [sym_qid] = "qid",
  [sym_qidop] = "qidop",
  [aux_sym_idop_token1] = "idop_token1",
  [anon_sym_RPAREN2] = ")",
  [sym__WILDCARDID] = "_WILDCARDID",
  [anon_sym_QMARK] = "\?",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_char_token1] = "char_token1",
  [anon_sym_SQUOTE2] = "'",
  [sym__open_brace] = "{",
  [sym__close_brace] = "}",
  [sym__semi] = ";",
  [sym__raw_string] = "_raw_string",
  [sym__end_continuation_signal] = "_end_continuation_signal",
  [sym_program] = "program",
  [sym_eimport] = "eimport",
  [sym_import] = "import",
  [sym_modulepath] = "modulepath",
  [sym_semis] = "semis",
  [sym_declarations] = "declarations",
  [sym_fixitydecl] = "fixitydecl",
  [sym_fixity] = "fixity",
  [sym_topdecl] = "topdecl",
  [sym_externdecl] = "externdecl",
  [sym_externtype] = "externtype",
  [sym_externbody] = "externbody",
  [sym_externstat] = "externstat",
  [sym_externinline] = "externinline",
  [sym_externimpbody] = "externimpbody",
  [sym_externimp] = "externimp",
  [sym_externval] = "externval",
  [sym_externtarget] = "externtarget",
  [sym_aliasdecl] = "aliasdecl",
  [sym_typedecl] = "typedecl",
  [sym_typemod] = "typemod",
  [sym_structmod] = "structmod",
  [sym_effectmod] = "effectmod",
  [sym_typebody] = "typebody",
  [sym_typeid] = "typeid",
  [sym_commas] = "commas",
  [sym__comma] = "_comma",
  [sym_constructors] = "constructors",
  [sym_constructor] = "constructor",
  [sym_conparams] = "conparams",
  [sym_sconparams] = "sconparams",
  [sym_opdecls] = "opdecls",
  [sym_operations] = "operations",
  [sym_operation] = "operation",
  [sym_puredecl] = "puredecl",
  [sym_inlinemod] = "inlinemod",
  [sym_fipmod] = "fipmod",
  [sym_fiplimit] = "fiplimit",
  [sym_tailmod] = "tailmod",
  [sym_fundecl] = "fundecl",
  [sym_binder] = "binder",
  [sym_funbody] = "funbody",
  [sym_annotres] = "annotres",
  [sym_block] = "block",
  [sym_statement] = "statement",
  [sym_decl] = "decl",
  [sym_bodyexpr] = "bodyexpr",
  [sym__blockexpr] = "_blockexpr",
  [sym_expr] = "expr",
  [sym_basicexpr] = "basicexpr",
  [sym_matchexpr] = "matchexpr",
  [sym_fnexpr] = "fnexpr",
  [sym_returnexpr] = "returnexpr",
  [sym_ifexpr] = "ifexpr",
  [sym_elifs] = "elifs",
  [sym_valexpr] = "valexpr",
  [sym_opexpr] = "opexpr",
  [sym_ntlexpr] = "ntlexpr",
  [sym_atom] = "atom",
  [sym_name] = "name",
  [sym_literal] = "literal",
  [sym_mask] = "mask",
  [sym_behindmod] = "behindmod",
  [sym_ctxexpr] = "ctxexpr",
  [sym_ctxhole] = "ctxhole",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym_paramid] = "paramid",
  [sym_pparameters] = "pparameters",
  [sym_pparameter] = "pparameter",
  [sym_aexprs] = "aexprs",
  [sym_cexprs] = "cexprs",
  [sym__aexpr] = "_aexpr",
  [sym_annot] = "annot",
  [sym__qoperator] = "_qoperator",
  [sym_qidentifier] = "qidentifier",
  [sym_identifier] = "identifier",
  [sym_wildcard] = "wildcard",
  [sym_qimplicit] = "qimplicit",
  [sym_qvarid] = "qvarid",
  [sym_varid] = "varid",
  [sym__qconstructor] = "_qconstructor",
  [sym_op] = "op",
  [sym_matchrules] = "matchrules",
  [sym_matchrule] = "matchrule",
  [sym_patterns] = "patterns",
  [sym_apatterns] = "apatterns",
  [sym__apattern] = "_apattern",
  [sym_pattern] = "pattern",
  [sym_patargs] = "patargs",
  [sym_patarg] = "patarg",
  [sym_handlerexpr] = "handlerexpr",
  [sym_witheff] = "witheff",
  [sym_withstat] = "withstat",
  [sym_withexpr] = "withexpr",
  [sym_opclauses] = "opclauses",
  [sym_opclausex] = "opclausex",
  [sym_opclause] = "opclause",
  [sym_controlmod] = "controlmod",
  [sym_opparams] = "opparams",
  [sym_opparam] = "opparam",
  [sym_tbinder] = "tbinder",
  [sym_typescheme] = "typescheme",
  [sym_type] = "type",
  [sym_someforalls] = "someforalls",
  [sym_typeparams] = "typeparams",
  [sym_qualifier] = "qualifier",
  [sym_predicate] = "predicate",
  [sym__tarrow] = "_tarrow",
  [sym_tresult] = "tresult",
  [sym_tatomic] = "tatomic",
  [sym_tbasic] = "tbasic",
  [sym__typeapp] = "_typeapp",
  [sym_typecon] = "typecon",
  [sym_tparams] = "tparams",
  [sym_tparam] = "tparam",
  [sym_targuments] = "targuments",
  [sym__anntype] = "_anntype",
  [sym_kannot] = "kannot",
  [sym_kind] = "kind",
  [sym_katom] = "katom",
  [sym__open_brace_] = "_open_brace_",
  [sym__close_brace_] = "_close_brace_",
  [sym__open_square_brace] = "_open_square_brace",
  [sym__open_angle_brace] = "_open_angle_brace",
  [sym__open_round_brace] = "_open_round_brace",
  [sym__IMPORT_EXTERN] = "_IMPORT_EXTERN",
  [sym_blockcomment] = "blockcomment",
  [sym_float] = "float",
  [sym_int] = "int",
  [sym_idop] = "idop",
  [sym_OP] = "OP",
  [sym__IMPLICITID] = "_IMPLICITID",
  [sym_string] = "string",
  [sym_char] = "char",
  [aux_sym_semis_repeat1] = "semis_repeat1",
  [aux_sym_declarations_repeat1] = "declarations_repeat1",
  [aux_sym_fixitydecl_repeat1] = "fixitydecl_repeat1",
  [aux_sym_externbody_repeat1] = "externbody_repeat1",
  [aux_sym_externimpbody_repeat1] = "externimpbody_repeat1",
  [aux_sym_externimp_repeat1] = "externimp_repeat1",
  [aux_sym_commas_repeat1] = "commas_repeat1",
  [aux_sym_constructors_repeat1] = "constructors_repeat1",
  [aux_sym_sconparams_repeat1] = "sconparams_repeat1",
  [aux_sym_operations_repeat1] = "operations_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_elifs_repeat1] = "elifs_repeat1",
  [aux_sym_opexpr_repeat1] = "opexpr_repeat1",
  [aux_sym_opexpr_repeat2] = "opexpr_repeat2",
  [aux_sym_opexpr_repeat3] = "opexpr_repeat3",
  [aux_sym_ntlexpr_repeat1] = "ntlexpr_repeat1",
  [aux_sym_ntlexpr_repeat2] = "ntlexpr_repeat2",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_pparameters_repeat1] = "pparameters_repeat1",
  [aux_sym_aexprs_repeat1] = "aexprs_repeat1",
  [aux_sym_matchrules_repeat1] = "matchrules_repeat1",
  [aux_sym_patterns_repeat1] = "patterns_repeat1",
  [aux_sym_apatterns_repeat1] = "apatterns_repeat1",
  [aux_sym_pattern_repeat1] = "pattern_repeat1",
  [aux_sym_opclauses_repeat1] = "opclauses_repeat1",
  [aux_sym_opparams_repeat1] = "opparams_repeat1",
  [aux_sym_typeparams_repeat1] = "typeparams_repeat1",
  [aux_sym_qualifier_repeat1] = "qualifier_repeat1",
  [aux_sym_tparams_repeat1] = "tparams_repeat1",
  [aux_sym_targuments_repeat1] = "targuments_repeat1",
  [aux_sym_kind_repeat1] = "kind_repeat1",
  [aux_sym_kind_repeat2] = "kind_repeat2",
  [aux_sym_blockcomment_repeat1] = "blockcomment_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_pub] = sym_pub,
  [anon_sym_infix] = anon_sym_infix,
  [anon_sym_infixr] = anon_sym_infixr,
  [anon_sym_infixl] = anon_sym_infixl,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym_cs] = anon_sym_cs,
  [anon_sym_js] = anon_sym_js,
  [anon_sym_c] = anon_sym_c,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_effect] = anon_sym_effect,
  [anon_sym_named] = anon_sym_named,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_extend] = anon_sym_extend,
  [anon_sym_co] = anon_sym_co,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_lazy] = anon_sym_lazy,
  [anon_sym_value] = anon_sym_value,
  [anon_sym_reference] = anon_sym_reference,
  [anon_sym_ref] = anon_sym_ref,
  [anon_sym_linear] = anon_sym_linear,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_ctx] = anon_sym_ctx,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [sym_con] = sym_con,
  [anon_sym_val] = anon_sym_val,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_ctl] = anon_sym_ctl,
  [anon_sym_noinline] = anon_sym_noinline,
  [anon_sym_fip] = anon_sym_fip,
  [anon_sym_fbip] = anon_sym_fbip,
  [anon_sym__] = anon_sym__,
  [anon_sym_tail] = anon_sym_tail,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_mask] = anon_sym_mask,
  [anon_sym_behind] = anon_sym_behind,
  [sym_borrow] = sym_borrow,
  [anon_sym_file] = anon_sym_file,
  [anon_sym_scoped] = anon_sym_scoped,
  [anon_sym_initially] = anon_sym_initially,
  [anon_sym_finally] = anon_sym_finally,
  [sym_qconid] = sym_qconid,
  [sym_conid] = sym_conid,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_handler] = anon_sym_handler,
  [anon_sym_handle] = anon_sym_handle,
  [sym_override] = sym_override,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_brk] = anon_sym_brk,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_raw] = anon_sym_raw,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_some] = anon_sym_some,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [sym__symbols] = sym__symbols,
  [sym_id] = sym_id,
  [sym_escape] = sym_escape,
  [sym_linecomment] = sym_linecomment,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [aux_sym_blockcomment_token1] = aux_sym_blockcomment_token1,
  [anon_sym_STAR_SLASH] = anon_sym_STAR_SLASH,
  [aux_sym_float_token1] = aux_sym_float_token1,
  [aux_sym_float_token2] = aux_sym_float_token2,
  [aux_sym_int_token1] = aux_sym_int_token1,
  [aux_sym_int_token2] = aux_sym_int_token2,
  [sym_qid] = sym_qid,
  [sym_qidop] = sym_qidop,
  [aux_sym_idop_token1] = aux_sym_idop_token1,
  [anon_sym_RPAREN2] = anon_sym_RPAREN,
  [sym__WILDCARDID] = sym__WILDCARDID,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_char_token1] = aux_sym_char_token1,
  [anon_sym_SQUOTE2] = anon_sym_SQUOTE,
  [sym__open_brace] = sym__open_brace,
  [sym__close_brace] = sym__close_brace,
  [sym__semi] = sym__semi,
  [sym__raw_string] = sym__raw_string,
  [sym__end_continuation_signal] = sym__end_continuation_signal,
  [sym_program] = sym_program,
  [sym_eimport] = sym_eimport,
  [sym_import] = sym_import,
  [sym_modulepath] = sym_modulepath,
  [sym_semis] = sym_semis,
  [sym_declarations] = sym_declarations,
  [sym_fixitydecl] = sym_fixitydecl,
  [sym_fixity] = sym_fixity,
  [sym_topdecl] = sym_topdecl,
  [sym_externdecl] = sym_externdecl,
  [sym_externtype] = sym_externtype,
  [sym_externbody] = sym_externbody,
  [sym_externstat] = sym_externstat,
  [sym_externinline] = sym_externinline,
  [sym_externimpbody] = sym_externimpbody,
  [sym_externimp] = sym_externimp,
  [sym_externval] = sym_externval,
  [sym_externtarget] = sym_externtarget,
  [sym_aliasdecl] = sym_aliasdecl,
  [sym_typedecl] = sym_typedecl,
  [sym_typemod] = sym_typemod,
  [sym_structmod] = sym_structmod,
  [sym_effectmod] = sym_effectmod,
  [sym_typebody] = sym_typebody,
  [sym_typeid] = sym_typeid,
  [sym_commas] = sym_commas,
  [sym__comma] = sym__comma,
  [sym_constructors] = sym_constructors,
  [sym_constructor] = sym_constructor,
  [sym_conparams] = sym_conparams,
  [sym_sconparams] = sym_sconparams,
  [sym_opdecls] = sym_opdecls,
  [sym_operations] = sym_operations,
  [sym_operation] = sym_operation,
  [sym_puredecl] = sym_puredecl,
  [sym_inlinemod] = sym_inlinemod,
  [sym_fipmod] = sym_fipmod,
  [sym_fiplimit] = sym_fiplimit,
  [sym_tailmod] = sym_tailmod,
  [sym_fundecl] = sym_fundecl,
  [sym_binder] = sym_binder,
  [sym_funbody] = sym_funbody,
  [sym_annotres] = sym_annotres,
  [sym_block] = sym_block,
  [sym_statement] = sym_statement,
  [sym_decl] = sym_decl,
  [sym_bodyexpr] = sym_bodyexpr,
  [sym__blockexpr] = sym__blockexpr,
  [sym_expr] = sym_expr,
  [sym_basicexpr] = sym_basicexpr,
  [sym_matchexpr] = sym_matchexpr,
  [sym_fnexpr] = sym_fnexpr,
  [sym_returnexpr] = sym_returnexpr,
  [sym_ifexpr] = sym_ifexpr,
  [sym_elifs] = sym_elifs,
  [sym_valexpr] = sym_valexpr,
  [sym_opexpr] = sym_opexpr,
  [sym_ntlexpr] = sym_ntlexpr,
  [sym_atom] = sym_atom,
  [sym_name] = sym_name,
  [sym_literal] = sym_literal,
  [sym_mask] = sym_mask,
  [sym_behindmod] = sym_behindmod,
  [sym_ctxexpr] = sym_ctxexpr,
  [sym_ctxhole] = sym_ctxhole,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym_paramid] = sym_paramid,
  [sym_pparameters] = sym_pparameters,
  [sym_pparameter] = sym_pparameter,
  [sym_aexprs] = sym_aexprs,
  [sym_cexprs] = sym_cexprs,
  [sym__aexpr] = sym__aexpr,
  [sym_annot] = sym_annot,
  [sym__qoperator] = sym__qoperator,
  [sym_qidentifier] = sym_qidentifier,
  [sym_identifier] = sym_identifier,
  [sym_wildcard] = sym_wildcard,
  [sym_qimplicit] = sym_qimplicit,
  [sym_qvarid] = sym_qvarid,
  [sym_varid] = sym_varid,
  [sym__qconstructor] = sym__qconstructor,
  [sym_op] = sym_op,
  [sym_matchrules] = sym_matchrules,
  [sym_matchrule] = sym_matchrule,
  [sym_patterns] = sym_patterns,
  [sym_apatterns] = sym_apatterns,
  [sym__apattern] = sym__apattern,
  [sym_pattern] = sym_pattern,
  [sym_patargs] = sym_patargs,
  [sym_patarg] = sym_patarg,
  [sym_handlerexpr] = sym_handlerexpr,
  [sym_witheff] = sym_witheff,
  [sym_withstat] = sym_withstat,
  [sym_withexpr] = sym_withexpr,
  [sym_opclauses] = sym_opclauses,
  [sym_opclausex] = sym_opclausex,
  [sym_opclause] = sym_opclause,
  [sym_controlmod] = sym_controlmod,
  [sym_opparams] = sym_opparams,
  [sym_opparam] = sym_opparam,
  [sym_tbinder] = sym_tbinder,
  [sym_typescheme] = sym_typescheme,
  [sym_type] = sym_type,
  [sym_someforalls] = sym_someforalls,
  [sym_typeparams] = sym_typeparams,
  [sym_qualifier] = sym_qualifier,
  [sym_predicate] = sym_predicate,
  [sym__tarrow] = sym__tarrow,
  [sym_tresult] = sym_tresult,
  [sym_tatomic] = sym_tatomic,
  [sym_tbasic] = sym_tbasic,
  [sym__typeapp] = sym__typeapp,
  [sym_typecon] = sym_typecon,
  [sym_tparams] = sym_tparams,
  [sym_tparam] = sym_tparam,
  [sym_targuments] = sym_targuments,
  [sym__anntype] = sym__anntype,
  [sym_kannot] = sym_kannot,
  [sym_kind] = sym_kind,
  [sym_katom] = sym_katom,
  [sym__open_brace_] = sym__open_brace_,
  [sym__close_brace_] = sym__close_brace_,
  [sym__open_square_brace] = sym__open_square_brace,
  [sym__open_angle_brace] = sym__open_angle_brace,
  [sym__open_round_brace] = sym__open_round_brace,
  [sym__IMPORT_EXTERN] = sym__IMPORT_EXTERN,
  [sym_blockcomment] = sym_blockcomment,
  [sym_float] = sym_float,
  [sym_int] = sym_int,
  [sym_idop] = sym_idop,
  [sym_OP] = sym_OP,
  [sym__IMPLICITID] = sym__IMPLICITID,
  [sym_string] = sym_string,
  [sym_char] = sym_char,
  [aux_sym_semis_repeat1] = aux_sym_semis_repeat1,
  [aux_sym_declarations_repeat1] = aux_sym_declarations_repeat1,
  [aux_sym_fixitydecl_repeat1] = aux_sym_fixitydecl_repeat1,
  [aux_sym_externbody_repeat1] = aux_sym_externbody_repeat1,
  [aux_sym_externimpbody_repeat1] = aux_sym_externimpbody_repeat1,
  [aux_sym_externimp_repeat1] = aux_sym_externimp_repeat1,
  [aux_sym_commas_repeat1] = aux_sym_commas_repeat1,
  [aux_sym_constructors_repeat1] = aux_sym_constructors_repeat1,
  [aux_sym_sconparams_repeat1] = aux_sym_sconparams_repeat1,
  [aux_sym_operations_repeat1] = aux_sym_operations_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_elifs_repeat1] = aux_sym_elifs_repeat1,
  [aux_sym_opexpr_repeat1] = aux_sym_opexpr_repeat1,
  [aux_sym_opexpr_repeat2] = aux_sym_opexpr_repeat2,
  [aux_sym_opexpr_repeat3] = aux_sym_opexpr_repeat3,
  [aux_sym_ntlexpr_repeat1] = aux_sym_ntlexpr_repeat1,
  [aux_sym_ntlexpr_repeat2] = aux_sym_ntlexpr_repeat2,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_pparameters_repeat1] = aux_sym_pparameters_repeat1,
  [aux_sym_aexprs_repeat1] = aux_sym_aexprs_repeat1,
  [aux_sym_matchrules_repeat1] = aux_sym_matchrules_repeat1,
  [aux_sym_patterns_repeat1] = aux_sym_patterns_repeat1,
  [aux_sym_apatterns_repeat1] = aux_sym_apatterns_repeat1,
  [aux_sym_pattern_repeat1] = aux_sym_pattern_repeat1,
  [aux_sym_opclauses_repeat1] = aux_sym_opclauses_repeat1,
  [aux_sym_opparams_repeat1] = aux_sym_opparams_repeat1,
  [aux_sym_typeparams_repeat1] = aux_sym_typeparams_repeat1,
  [aux_sym_qualifier_repeat1] = aux_sym_qualifier_repeat1,
  [aux_sym_tparams_repeat1] = aux_sym_tparams_repeat1,
  [aux_sym_targuments_repeat1] = aux_sym_targuments_repeat1,
  [aux_sym_kind_repeat1] = aux_sym_kind_repeat1,
  [aux_sym_kind_repeat2] = aux_sym_kind_repeat2,
  [aux_sym_blockcomment_repeat1] = aux_sym_blockcomment_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_pub] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_infix] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infixr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infixl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_js] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_c] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_effect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_named] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_co] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lazy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_value] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reference] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ctx] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_con] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_val] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ctl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_noinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fip] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fbip] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mask] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_behind] = {
    .visible = true,
    .named = false,
  },
  [sym_borrow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_file] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_scoped] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_initially] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [sym_qconid] = {
    .visible = true,
    .named = true,
  },
  [sym_conid] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_handler] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_handle] = {
    .visible = true,
    .named = false,
  },
  [sym_override] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_brk] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_some] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__symbols] = {
    .visible = false,
    .named = true,
  },
  [sym_id] = {
    .visible = true,
    .named = true,
  },
  [sym_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_linecomment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_blockcomment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_STAR_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_float_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_float_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_int_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_int_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_qid] = {
    .visible = true,
    .named = true,
  },
  [sym_qidop] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_idop_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_RPAREN2] = {
    .visible = true,
    .named = false,
  },
  [sym__WILDCARDID] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym__open_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__close_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__semi] = {
    .visible = true,
    .named = false,
  },
  [sym__raw_string] = {
    .visible = false,
    .named = true,
  },
  [sym__end_continuation_signal] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_eimport] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_modulepath] = {
    .visible = true,
    .named = true,
  },
  [sym_semis] = {
    .visible = true,
    .named = true,
  },
  [sym_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_fixitydecl] = {
    .visible = true,
    .named = true,
  },
  [sym_fixity] = {
    .visible = true,
    .named = true,
  },
  [sym_topdecl] = {
    .visible = true,
    .named = true,
  },
  [sym_externdecl] = {
    .visible = true,
    .named = true,
  },
  [sym_externtype] = {
    .visible = true,
    .named = true,
  },
  [sym_externbody] = {
    .visible = true,
    .named = true,
  },
  [sym_externstat] = {
    .visible = true,
    .named = true,
  },
  [sym_externinline] = {
    .visible = true,
    .named = true,
  },
  [sym_externimpbody] = {
    .visible = true,
    .named = true,
  },
  [sym_externimp] = {
    .visible = true,
    .named = true,
  },
  [sym_externval] = {
    .visible = true,
    .named = true,
  },
  [sym_externtarget] = {
    .visible = true,
    .named = true,
  },
  [sym_aliasdecl] = {
    .visible = true,
    .named = true,
  },
  [sym_typedecl] = {
    .visible = true,
    .named = true,
  },
  [sym_typemod] = {
    .visible = true,
    .named = true,
  },
  [sym_structmod] = {
    .visible = true,
    .named = true,
  },
  [sym_effectmod] = {
    .visible = true,
    .named = true,
  },
  [sym_typebody] = {
    .visible = true,
    .named = true,
  },
  [sym_typeid] = {
    .visible = true,
    .named = true,
  },
  [sym_commas] = {
    .visible = true,
    .named = true,
  },
  [sym__comma] = {
    .visible = false,
    .named = true,
  },
  [sym_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_conparams] = {
    .visible = true,
    .named = true,
  },
  [sym_sconparams] = {
    .visible = true,
    .named = true,
  },
  [sym_opdecls] = {
    .visible = true,
    .named = true,
  },
  [sym_operations] = {
    .visible = true,
    .named = true,
  },
  [sym_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_puredecl] = {
    .visible = true,
    .named = true,
  },
  [sym_inlinemod] = {
    .visible = true,
    .named = true,
  },
  [sym_fipmod] = {
    .visible = true,
    .named = true,
  },
  [sym_fiplimit] = {
    .visible = true,
    .named = true,
  },
  [sym_tailmod] = {
    .visible = true,
    .named = true,
  },
  [sym_fundecl] = {
    .visible = true,
    .named = true,
  },
  [sym_binder] = {
    .visible = true,
    .named = true,
  },
  [sym_funbody] = {
    .visible = true,
    .named = true,
  },
  [sym_annotres] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_bodyexpr] = {
    .visible = true,
    .named = true,
  },
  [sym__blockexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_basicexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_matchexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_fnexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_returnexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_ifexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_elifs] = {
    .visible = true,
    .named = true,
  },
  [sym_valexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_opexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_ntlexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_mask] = {
    .visible = true,
    .named = true,
  },
  [sym_behindmod] = {
    .visible = true,
    .named = true,
  },
  [sym_ctxexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_ctxhole] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_paramid] = {
    .visible = true,
    .named = true,
  },
  [sym_pparameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pparameter] = {
    .visible = true,
    .named = true,
  },
  [sym_aexprs] = {
    .visible = true,
    .named = true,
  },
  [sym_cexprs] = {
    .visible = true,
    .named = true,
  },
  [sym__aexpr] = {
    .visible = false,
    .named = true,
  },
  [sym_annot] = {
    .visible = true,
    .named = true,
  },
  [sym__qoperator] = {
    .visible = false,
    .named = true,
  },
  [sym_qidentifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym_qimplicit] = {
    .visible = true,
    .named = true,
  },
  [sym_qvarid] = {
    .visible = true,
    .named = true,
  },
  [sym_varid] = {
    .visible = true,
    .named = true,
  },
  [sym__qconstructor] = {
    .visible = false,
    .named = true,
  },
  [sym_op] = {
    .visible = true,
    .named = true,
  },
  [sym_matchrules] = {
    .visible = true,
    .named = true,
  },
  [sym_matchrule] = {
    .visible = true,
    .named = true,
  },
  [sym_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_apatterns] = {
    .visible = true,
    .named = true,
  },
  [sym__apattern] = {
    .visible = false,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_patargs] = {
    .visible = true,
    .named = true,
  },
  [sym_patarg] = {
    .visible = true,
    .named = true,
  },
  [sym_handlerexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_witheff] = {
    .visible = true,
    .named = true,
  },
  [sym_withstat] = {
    .visible = true,
    .named = true,
  },
  [sym_withexpr] = {
    .visible = true,
    .named = true,
  },
  [sym_opclauses] = {
    .visible = true,
    .named = true,
  },
  [sym_opclausex] = {
    .visible = true,
    .named = true,
  },
  [sym_opclause] = {
    .visible = true,
    .named = true,
  },
  [sym_controlmod] = {
    .visible = true,
    .named = true,
  },
  [sym_opparams] = {
    .visible = true,
    .named = true,
  },
  [sym_opparam] = {
    .visible = true,
    .named = true,
  },
  [sym_tbinder] = {
    .visible = true,
    .named = true,
  },
  [sym_typescheme] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_someforalls] = {
    .visible = true,
    .named = true,
  },
  [sym_typeparams] = {
    .visible = true,
    .named = true,
  },
  [sym_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym__tarrow] = {
    .visible = false,
    .named = true,
  },
  [sym_tresult] = {
    .visible = true,
    .named = true,
  },
  [sym_tatomic] = {
    .visible = true,
    .named = true,
  },
  [sym_tbasic] = {
    .visible = true,
    .named = true,
  },
  [sym__typeapp] = {
    .visible = false,
    .named = true,
  },
  [sym_typecon] = {
    .visible = true,
    .named = true,
  },
  [sym_tparams] = {
    .visible = true,
    .named = true,
  },
  [sym_tparam] = {
    .visible = true,
    .named = true,
  },
  [sym_targuments] = {
    .visible = true,
    .named = true,
  },
  [sym__anntype] = {
    .visible = false,
    .named = true,
  },
  [sym_kannot] = {
    .visible = true,
    .named = true,
  },
  [sym_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_katom] = {
    .visible = true,
    .named = true,
  },
  [sym__open_brace_] = {
    .visible = false,
    .named = true,
  },
  [sym__close_brace_] = {
    .visible = false,
    .named = true,
  },
  [sym__open_square_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__open_angle_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__open_round_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__IMPORT_EXTERN] = {
    .visible = false,
    .named = true,
  },
  [sym_blockcomment] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_int] = {
    .visible = true,
    .named = true,
  },
  [sym_idop] = {
    .visible = true,
    .named = true,
  },
  [sym_OP] = {
    .visible = true,
    .named = true,
  },
  [sym__IMPLICITID] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_char] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_semis_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fixitydecl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_externbody_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_externimpbody_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_externimp_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_commas_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sconparams_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elifs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_opexpr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_opexpr_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_opexpr_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ntlexpr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ntlexpr_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pparameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_aexprs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_matchrules_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_apatterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_opclauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_opparams_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typeparams_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_qualifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tparams_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_targuments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_kind_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_kind_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_blockcomment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_call = 1,
  field_constructor = 2,
  field_dot = 3,
  field_dotcall = 4,
  field_effect_multiple = 5,
  field_effect_single = 6,
  field_fun = 7,
  field_index = 8,
  field_list = 9,
  field_named_effect_multiple = 10,
  field_named_effect_single = 11,
  field_struct = 12,
  field_trailing_lambda = 13,
  field_tuple = 14,
  field_type = 15,
  field_val = 16,
  field_var = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_call] = "call",
  [field_constructor] = "constructor",
  [field_dot] = "dot",
  [field_dotcall] = "dotcall",
  [field_effect_multiple] = "effect_multiple",
  [field_effect_single] = "effect_single",
  [field_fun] = "fun",
  [field_index] = "index",
  [field_list] = "list",
  [field_named_effect_multiple] = "named_effect_multiple",
  [field_named_effect_single] = "named_effect_single",
  [field_struct] = "struct",
  [field_trailing_lambda] = "trailing_lambda",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_val] = "val",
  [field_var] = "var",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 2},
  [3] = {.index = 4, .length = 2},
  [4] = {.index = 6, .length = 3},
  [5] = {.index = 9, .length = 3},
  [6] = {.index = 12, .length = 3},
  [7] = {.index = 15, .length = 3},
  [8] = {.index = 18, .length = 3},
  [9] = {.index = 21, .length = 3},
  [10] = {.index = 24, .length = 4},
  [11] = {.index = 28, .length = 4},
  [12] = {.index = 32, .length = 4},
  [13] = {.index = 36, .length = 4},
  [14] = {.index = 40, .length = 4},
  [15] = {.index = 44, .length = 4},
  [16] = {.index = 48, .length = 4},
  [17] = {.index = 52, .length = 1},
  [18] = {.index = 53, .length = 4},
  [19] = {.index = 57, .length = 5},
  [20] = {.index = 62, .length = 5},
  [21] = {.index = 67, .length = 5},
  [22] = {.index = 72, .length = 5},
  [23] = {.index = 77, .length = 5},
  [24] = {.index = 82, .length = 1},
  [25] = {.index = 83, .length = 5},
  [26] = {.index = 88, .length = 2},
  [27] = {.index = 90, .length = 2},
  [28] = {.index = 92, .length = 1},
  [29] = {.index = 93, .length = 5},
  [30] = {.index = 98, .length = 5},
  [31] = {.index = 103, .length = 5},
  [32] = {.index = 108, .length = 6},
  [33] = {.index = 114, .length = 6},
  [34] = {.index = 120, .length = 4},
  [35] = {.index = 124, .length = 2},
  [36] = {.index = 126, .length = 2},
  [37] = {.index = 128, .length = 2},
  [38] = {.index = 130, .length = 10},
  [39] = {.index = 140, .length = 10},
  [40] = {.index = 150, .length = 2},
  [41] = {.index = 152, .length = 5},
  [42] = {.index = 157, .length = 3},
  [43] = {.index = 160, .length = 3},
  [44] = {.index = 163, .length = 3},
  [45] = {.index = 166, .length = 2},
  [46] = {.index = 168, .length = 2},
  [47] = {.index = 170, .length = 6},
  [48] = {.index = 176, .length = 6},
  [49] = {.index = 182, .length = 6},
  [50] = {.index = 188, .length = 7},
  [51] = {.index = 195, .length = 8},
  [52] = {.index = 203, .length = 8},
  [53] = {.index = 211, .length = 4},
  [54] = {.index = 215, .length = 3},
  [55] = {.index = 218, .length = 3},
  [56] = {.index = 221, .length = 3},
  [57] = {.index = 224, .length = 10},
  [58] = {.index = 234, .length = 4},
  [59] = {.index = 238, .length = 3},
  [60] = {.index = 241, .length = 3},
  [61] = {.index = 244, .length = 3},
  [62] = {.index = 247, .length = 8},
  [63] = {.index = 255, .length = 4},
  [64] = {.index = 259, .length = 5},
  [65] = {.index = 264, .length = 4},
  [66] = {.index = 268, .length = 4},
  [67] = {.index = 272, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type, 0},
    {field_type, 1},
  [2] =
    {field_struct, 0},
    {field_struct, 1},
  [4] =
    {field_effect_single, 0},
    {field_effect_single, 1},
  [6] =
    {field_type, 0},
    {field_type, 1},
    {field_type, 2},
  [9] =
    {field_struct, 0},
    {field_struct, 1},
    {field_struct, 2},
  [12] =
    {field_effect_multiple, 0},
    {field_effect_multiple, 1},
    {field_effect_multiple, 2},
  [15] =
    {field_effect_single, 0},
    {field_effect_single, 1},
    {field_effect_single, 2},
  [18] =
    {field_named_effect_single, 0},
    {field_named_effect_single, 1},
    {field_named_effect_single, 2},
  [21] =
    {field_fun, 0},
    {field_fun, 1},
    {field_fun, 2},
  [24] =
    {field_type, 0},
    {field_type, 1},
    {field_type, 2},
    {field_type, 3},
  [28] =
    {field_struct, 0},
    {field_struct, 1},
    {field_struct, 2},
    {field_struct, 3},
  [32] =
    {field_effect_multiple, 0},
    {field_effect_multiple, 1},
    {field_effect_multiple, 2},
    {field_effect_multiple, 3},
  [36] =
    {field_effect_single, 0},
    {field_effect_single, 1},
    {field_effect_single, 2},
    {field_effect_single, 3},
  [40] =
    {field_named_effect_multiple, 0},
    {field_named_effect_multiple, 1},
    {field_named_effect_multiple, 2},
    {field_named_effect_multiple, 3},
  [44] =
    {field_named_effect_single, 0},
    {field_named_effect_single, 1},
    {field_named_effect_single, 2},
    {field_named_effect_single, 3},
  [48] =
    {field_val, 0},
    {field_val, 1},
    {field_val, 2},
    {field_val, 3},
  [52] =
    {field_constructor, 0},
  [53] =
    {field_fun, 0},
    {field_fun, 1},
    {field_fun, 2},
    {field_fun, 3},
  [57] =
    {field_type, 0},
    {field_type, 1},
    {field_type, 2},
    {field_type, 3},
    {field_type, 4},
  [62] =
    {field_struct, 0},
    {field_struct, 1},
    {field_struct, 2},
    {field_struct, 3},
    {field_struct, 4},
  [67] =
    {field_effect_multiple, 0},
    {field_effect_multiple, 1},
    {field_effect_multiple, 2},
    {field_effect_multiple, 3},
    {field_effect_multiple, 4},
  [72] =
    {field_named_effect_multiple, 0},
    {field_named_effect_multiple, 1},
    {field_named_effect_multiple, 2},
    {field_named_effect_multiple, 3},
    {field_named_effect_multiple, 4},
  [77] =
    {field_named_effect_single, 0},
    {field_named_effect_single, 1},
    {field_named_effect_single, 2},
    {field_named_effect_single, 3},
    {field_named_effect_single, 4},
  [82] =
    {field_trailing_lambda, 0},
  [83] =
    {field_call, 1, .inherited = true},
    {field_dot, 1, .inherited = true},
    {field_dotcall, 1, .inherited = true},
    {field_index, 1, .inherited = true},
    {field_trailing_lambda, 1, .inherited = true},
  [88] =
    {field_list, 0},
    {field_list, 1},
  [90] =
    {field_tuple, 0},
    {field_tuple, 1},
  [92] =
    {field_constructor, 1},
  [93] =
    {field_effect_single, 0},
    {field_effect_single, 1},
    {field_effect_single, 2},
    {field_effect_single, 3},
    {field_effect_single, 4},
  [98] =
    {field_val, 0},
    {field_val, 1},
    {field_val, 2},
    {field_val, 3},
    {field_val, 4},
  [103] =
    {field_fun, 0},
    {field_fun, 1},
    {field_fun, 2},
    {field_fun, 3},
    {field_fun, 4},
  [108] =
    {field_named_effect_multiple, 0},
    {field_named_effect_multiple, 1},
    {field_named_effect_multiple, 2},
    {field_named_effect_multiple, 3},
    {field_named_effect_multiple, 4},
    {field_named_effect_multiple, 5},
  [114] =
    {field_named_effect_single, 0},
    {field_named_effect_single, 1},
    {field_named_effect_single, 2},
    {field_named_effect_single, 3},
    {field_named_effect_single, 4},
    {field_named_effect_single, 5},
  [120] =
    {field_call, 1, .inherited = true},
    {field_dot, 1, .inherited = true},
    {field_dotcall, 1, .inherited = true},
    {field_index, 1, .inherited = true},
  [124] =
    {field_dot, 0},
    {field_dot, 1},
  [126] =
    {field_index, 0},
    {field_index, 1},
  [128] =
    {field_call, 0},
    {field_call, 1},
  [130] =
    {field_call, 0, .inherited = true},
    {field_call, 1, .inherited = true},
    {field_dot, 0, .inherited = true},
    {field_dot, 1, .inherited = true},
    {field_dotcall, 0, .inherited = true},
    {field_dotcall, 1, .inherited = true},
    {field_index, 0, .inherited = true},
    {field_index, 1, .inherited = true},
    {field_trailing_lambda, 0, .inherited = true},
    {field_trailing_lambda, 1, .inherited = true},
  [140] =
    {field_call, 1, .inherited = true},
    {field_call, 2, .inherited = true},
    {field_dot, 1, .inherited = true},
    {field_dot, 2, .inherited = true},
    {field_dotcall, 1, .inherited = true},
    {field_dotcall, 2, .inherited = true},
    {field_index, 1, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_trailing_lambda, 1, .inherited = true},
    {field_trailing_lambda, 2, .inherited = true},
  [150] =
    {field_fun, 0},
    {field_fun, 1},
  [152] =
    {field_call, 2, .inherited = true},
    {field_dot, 2, .inherited = true},
    {field_dotcall, 2, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_trailing_lambda, 2, .inherited = true},
  [157] =
    {field_constructor, 0},
    {field_constructor, 1},
    {field_constructor, 2},
  [160] =
    {field_list, 0},
    {field_list, 1},
    {field_list, 2},
  [163] =
    {field_tuple, 0},
    {field_tuple, 1},
    {field_tuple, 2},
  [166] =
    {field_list, 1},
    {field_list, 2},
  [168] =
    {field_tuple, 1},
    {field_tuple, 2},
  [170] =
    {field_type, 0},
    {field_type, 1},
    {field_type, 2},
    {field_type, 3},
    {field_type, 4},
    {field_type, 5},
  [176] =
    {field_struct, 0},
    {field_struct, 1},
    {field_struct, 2},
    {field_struct, 3},
    {field_struct, 4},
    {field_struct, 5},
  [182] =
    {field_effect_multiple, 0},
    {field_effect_multiple, 1},
    {field_effect_multiple, 2},
    {field_effect_multiple, 3},
    {field_effect_multiple, 4},
    {field_effect_multiple, 5},
  [188] =
    {field_named_effect_multiple, 0},
    {field_named_effect_multiple, 1},
    {field_named_effect_multiple, 2},
    {field_named_effect_multiple, 3},
    {field_named_effect_multiple, 4},
    {field_named_effect_multiple, 5},
    {field_named_effect_multiple, 6},
  [195] =
    {field_call, 0, .inherited = true},
    {field_call, 1, .inherited = true},
    {field_dot, 0, .inherited = true},
    {field_dot, 1, .inherited = true},
    {field_dotcall, 0, .inherited = true},
    {field_dotcall, 1, .inherited = true},
    {field_index, 0, .inherited = true},
    {field_index, 1, .inherited = true},
  [203] =
    {field_call, 1, .inherited = true},
    {field_call, 2, .inherited = true},
    {field_dot, 1, .inherited = true},
    {field_dot, 2, .inherited = true},
    {field_dotcall, 1, .inherited = true},
    {field_dotcall, 2, .inherited = true},
    {field_index, 1, .inherited = true},
    {field_index, 2, .inherited = true},
  [211] =
    {field_call, 2, .inherited = true},
    {field_dot, 2, .inherited = true},
    {field_dotcall, 2, .inherited = true},
    {field_index, 2, .inherited = true},
  [215] =
    {field_dotcall, 0},
    {field_dotcall, 1},
    {field_dotcall, 2},
  [218] =
    {field_index, 0},
    {field_index, 1},
    {field_index, 2},
  [221] =
    {field_call, 0},
    {field_call, 1},
    {field_call, 2},
  [224] =
    {field_call, 2, .inherited = true},
    {field_call, 3, .inherited = true},
    {field_dot, 2, .inherited = true},
    {field_dot, 3, .inherited = true},
    {field_dotcall, 2, .inherited = true},
    {field_dotcall, 3, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_index, 3, .inherited = true},
    {field_trailing_lambda, 2, .inherited = true},
    {field_trailing_lambda, 3, .inherited = true},
  [234] =
    {field_constructor, 0},
    {field_constructor, 1},
    {field_constructor, 2},
    {field_constructor, 3},
  [238] =
    {field_constructor, 1},
    {field_constructor, 2},
    {field_constructor, 3},
  [241] =
    {field_list, 1},
    {field_list, 2},
    {field_list, 3},
  [244] =
    {field_tuple, 1},
    {field_tuple, 2},
    {field_tuple, 3},
  [247] =
    {field_call, 2, .inherited = true},
    {field_call, 3, .inherited = true},
    {field_dot, 2, .inherited = true},
    {field_dot, 3, .inherited = true},
    {field_dotcall, 2, .inherited = true},
    {field_dotcall, 3, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_index, 3, .inherited = true},
  [255] =
    {field_dotcall, 0},
    {field_dotcall, 1},
    {field_dotcall, 2},
    {field_dotcall, 3},
  [259] =
    {field_call, 3, .inherited = true},
    {field_dot, 3, .inherited = true},
    {field_dotcall, 3, .inherited = true},
    {field_index, 3, .inherited = true},
    {field_trailing_lambda, 3, .inherited = true},
  [264] =
    {field_var, 0},
    {field_var, 1},
    {field_var, 2},
    {field_var, 3},
  [268] =
    {field_constructor, 1},
    {field_constructor, 2},
    {field_constructor, 3},
    {field_constructor, 4},
  [272] =
    {field_call, 3, .inherited = true},
    {field_dot, 3, .inherited = true},
    {field_dotcall, 3, .inherited = true},
    {field_index, 3, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 2,
  [6] = 6,
  [7] = 3,
  [8] = 4,
  [9] = 2,
  [10] = 6,
  [11] = 3,
  [12] = 4,
  [13] = 2,
  [14] = 6,
  [15] = 3,
  [16] = 4,
  [17] = 2,
  [18] = 6,
  [19] = 3,
  [20] = 4,
  [21] = 2,
  [22] = 6,
  [23] = 3,
  [24] = 4,
  [25] = 2,
  [26] = 3,
  [27] = 4,
  [28] = 3,
  [29] = 4,
  [30] = 6,
  [31] = 3,
  [32] = 4,
  [33] = 2,
  [34] = 3,
  [35] = 4,
  [36] = 2,
  [37] = 3,
  [38] = 4,
  [39] = 2,
  [40] = 3,
  [41] = 4,
  [42] = 2,
  [43] = 3,
  [44] = 4,
  [45] = 2,
  [46] = 3,
  [47] = 4,
  [48] = 2,
  [49] = 3,
  [50] = 4,
  [51] = 2,
  [52] = 3,
  [53] = 4,
  [54] = 2,
  [55] = 3,
  [56] = 4,
  [57] = 2,
  [58] = 3,
  [59] = 4,
  [60] = 2,
  [61] = 3,
  [62] = 4,
  [63] = 2,
  [64] = 3,
  [65] = 4,
  [66] = 2,
  [67] = 2,
  [68] = 68,
  [69] = 68,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 68,
  [75] = 70,
  [76] = 71,
  [77] = 72,
  [78] = 78,
  [79] = 79,
  [80] = 73,
  [81] = 81,
  [82] = 71,
  [83] = 72,
  [84] = 84,
  [85] = 73,
  [86] = 72,
  [87] = 73,
  [88] = 81,
  [89] = 84,
  [90] = 70,
  [91] = 91,
  [92] = 92,
  [93] = 78,
  [94] = 70,
  [95] = 68,
  [96] = 71,
  [97] = 91,
  [98] = 78,
  [99] = 92,
  [100] = 91,
  [101] = 72,
  [102] = 71,
  [103] = 103,
  [104] = 104,
  [105] = 104,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 115,
  [117] = 113,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 115,
  [125] = 113,
  [126] = 118,
  [127] = 115,
  [128] = 118,
  [129] = 129,
  [130] = 122,
  [131] = 123,
  [132] = 112,
  [133] = 113,
  [134] = 110,
  [135] = 115,
  [136] = 118,
  [137] = 137,
  [138] = 122,
  [139] = 123,
  [140] = 140,
  [141] = 122,
  [142] = 113,
  [143] = 113,
  [144] = 115,
  [145] = 118,
  [146] = 123,
  [147] = 122,
  [148] = 123,
  [149] = 149,
  [150] = 137,
  [151] = 115,
  [152] = 118,
  [153] = 119,
  [154] = 122,
  [155] = 123,
  [156] = 113,
  [157] = 119,
  [158] = 120,
  [159] = 159,
  [160] = 118,
  [161] = 115,
  [162] = 113,
  [163] = 118,
  [164] = 118,
  [165] = 118,
  [166] = 118,
  [167] = 118,
  [168] = 112,
  [169] = 169,
  [170] = 137,
  [171] = 118,
  [172] = 172,
  [173] = 113,
  [174] = 118,
  [175] = 118,
  [176] = 118,
  [177] = 118,
  [178] = 122,
  [179] = 118,
  [180] = 110,
  [181] = 110,
  [182] = 110,
  [183] = 110,
  [184] = 110,
  [185] = 110,
  [186] = 110,
  [187] = 110,
  [188] = 123,
  [189] = 113,
  [190] = 149,
  [191] = 115,
  [192] = 110,
  [193] = 120,
  [194] = 122,
  [195] = 123,
  [196] = 196,
  [197] = 113,
  [198] = 198,
  [199] = 115,
  [200] = 119,
  [201] = 122,
  [202] = 123,
  [203] = 120,
  [204] = 113,
  [205] = 205,
  [206] = 115,
  [207] = 115,
  [208] = 122,
  [209] = 123,
  [210] = 118,
  [211] = 113,
  [212] = 112,
  [213] = 115,
  [214] = 122,
  [215] = 122,
  [216] = 123,
  [217] = 122,
  [218] = 123,
  [219] = 115,
  [220] = 129,
  [221] = 122,
  [222] = 123,
  [223] = 223,
  [224] = 113,
  [225] = 119,
  [226] = 115,
  [227] = 120,
  [228] = 122,
  [229] = 123,
  [230] = 230,
  [231] = 113,
  [232] = 115,
  [233] = 115,
  [234] = 118,
  [235] = 122,
  [236] = 123,
  [237] = 112,
  [238] = 113,
  [239] = 123,
  [240] = 115,
  [241] = 122,
  [242] = 122,
  [243] = 123,
  [244] = 123,
  [245] = 245,
  [246] = 115,
  [247] = 119,
  [248] = 122,
  [249] = 123,
  [250] = 113,
  [251] = 120,
  [252] = 113,
  [253] = 110,
  [254] = 110,
  [255] = 110,
  [256] = 110,
  [257] = 110,
  [258] = 258,
  [259] = 110,
  [260] = 110,
  [261] = 112,
  [262] = 113,
  [263] = 149,
  [264] = 115,
  [265] = 265,
  [266] = 122,
  [267] = 123,
  [268] = 110,
  [269] = 110,
  [270] = 113,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 272,
  [276] = 276,
  [277] = 273,
  [278] = 271,
  [279] = 272,
  [280] = 272,
  [281] = 271,
  [282] = 276,
  [283] = 283,
  [284] = 273,
  [285] = 285,
  [286] = 286,
  [287] = 272,
  [288] = 271,
  [289] = 272,
  [290] = 272,
  [291] = 271,
  [292] = 272,
  [293] = 273,
  [294] = 285,
  [295] = 271,
  [296] = 272,
  [297] = 271,
  [298] = 271,
  [299] = 273,
  [300] = 273,
  [301] = 273,
  [302] = 302,
  [303] = 273,
  [304] = 271,
  [305] = 305,
  [306] = 272,
  [307] = 271,
  [308] = 272,
  [309] = 273,
  [310] = 271,
  [311] = 311,
  [312] = 272,
  [313] = 273,
  [314] = 273,
  [315] = 272,
  [316] = 316,
  [317] = 271,
  [318] = 272,
  [319] = 272,
  [320] = 286,
  [321] = 271,
  [322] = 272,
  [323] = 273,
  [324] = 271,
  [325] = 272,
  [326] = 271,
  [327] = 273,
  [328] = 271,
  [329] = 272,
  [330] = 271,
  [331] = 331,
  [332] = 272,
  [333] = 273,
  [334] = 273,
  [335] = 271,
  [336] = 273,
  [337] = 273,
  [338] = 273,
  [339] = 273,
  [340] = 271,
  [341] = 272,
  [342] = 271,
  [343] = 273,
  [344] = 344,
  [345] = 345,
  [346] = 344,
  [347] = 345,
  [348] = 344,
  [349] = 344,
  [350] = 345,
  [351] = 344,
  [352] = 345,
  [353] = 345,
  [354] = 345,
  [355] = 344,
  [356] = 356,
  [357] = 356,
  [358] = 358,
  [359] = 358,
  [360] = 358,
  [361] = 358,
  [362] = 362,
  [363] = 362,
  [364] = 364,
  [365] = 365,
  [366] = 358,
  [367] = 358,
  [368] = 356,
  [369] = 358,
  [370] = 358,
  [371] = 365,
  [372] = 356,
  [373] = 362,
  [374] = 364,
  [375] = 364,
  [376] = 358,
  [377] = 365,
  [378] = 356,
  [379] = 356,
  [380] = 358,
  [381] = 358,
  [382] = 358,
  [383] = 362,
  [384] = 364,
  [385] = 358,
  [386] = 358,
  [387] = 358,
  [388] = 388,
  [389] = 365,
  [390] = 358,
  [391] = 362,
  [392] = 358,
  [393] = 364,
  [394] = 358,
  [395] = 365,
  [396] = 358,
  [397] = 362,
  [398] = 364,
  [399] = 365,
  [400] = 358,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 401,
  [405] = 405,
  [406] = 402,
  [407] = 407,
  [408] = 403,
  [409] = 409,
  [410] = 401,
  [411] = 402,
  [412] = 403,
  [413] = 401,
  [414] = 402,
  [415] = 407,
  [416] = 403,
  [417] = 402,
  [418] = 403,
  [419] = 403,
  [420] = 401,
  [421] = 402,
  [422] = 403,
  [423] = 409,
  [424] = 401,
  [425] = 402,
  [426] = 403,
  [427] = 401,
  [428] = 402,
  [429] = 403,
  [430] = 401,
  [431] = 401,
  [432] = 402,
  [433] = 403,
  [434] = 401,
  [435] = 402,
  [436] = 401,
  [437] = 402,
  [438] = 403,
  [439] = 401,
  [440] = 402,
  [441] = 403,
  [442] = 401,
  [443] = 402,
  [444] = 403,
  [445] = 401,
  [446] = 402,
  [447] = 403,
  [448] = 401,
  [449] = 402,
  [450] = 403,
  [451] = 401,
  [452] = 402,
  [453] = 403,
  [454] = 401,
  [455] = 402,
  [456] = 403,
  [457] = 401,
  [458] = 402,
  [459] = 403,
  [460] = 401,
  [461] = 402,
  [462] = 403,
  [463] = 401,
  [464] = 402,
  [465] = 403,
  [466] = 405,
  [467] = 467,
  [468] = 467,
  [469] = 467,
  [470] = 467,
  [471] = 467,
  [472] = 467,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 474,
  [477] = 474,
  [478] = 475,
  [479] = 475,
  [480] = 474,
  [481] = 475,
  [482] = 474,
  [483] = 474,
  [484] = 484,
  [485] = 475,
  [486] = 475,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 489,
  [491] = 489,
  [492] = 489,
  [493] = 489,
  [494] = 489,
  [495] = 489,
  [496] = 496,
  [497] = 489,
  [498] = 498,
  [499] = 498,
  [500] = 500,
  [501] = 498,
  [502] = 500,
  [503] = 498,
  [504] = 500,
  [505] = 498,
  [506] = 500,
  [507] = 498,
  [508] = 500,
  [509] = 498,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 498,
  [514] = 514,
  [515] = 515,
  [516] = 500,
  [517] = 498,
  [518] = 500,
  [519] = 519,
  [520] = 498,
  [521] = 500,
  [522] = 498,
  [523] = 500,
  [524] = 498,
  [525] = 500,
  [526] = 498,
  [527] = 500,
  [528] = 498,
  [529] = 500,
  [530] = 498,
  [531] = 500,
  [532] = 498,
  [533] = 500,
  [534] = 498,
  [535] = 500,
  [536] = 536,
  [537] = 498,
  [538] = 500,
  [539] = 500,
  [540] = 498,
  [541] = 500,
  [542] = 500,
  [543] = 543,
  [544] = 498,
  [545] = 500,
  [546] = 546,
  [547] = 546,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 552,
  [554] = 548,
  [555] = 555,
  [556] = 552,
  [557] = 546,
  [558] = 548,
  [559] = 552,
  [560] = 548,
  [561] = 561,
  [562] = 552,
  [563] = 563,
  [564] = 546,
  [565] = 552,
  [566] = 552,
  [567] = 552,
  [568] = 546,
  [569] = 552,
  [570] = 548,
  [571] = 546,
  [572] = 548,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 588,
  [592] = 592,
  [593] = 593,
  [594] = 588,
  [595] = 588,
  [596] = 588,
  [597] = 588,
  [598] = 588,
  [599] = 588,
  [600] = 588,
  [601] = 588,
  [602] = 588,
  [603] = 588,
  [604] = 588,
  [605] = 588,
  [606] = 588,
  [607] = 588,
  [608] = 588,
  [609] = 609,
  [610] = 610,
  [611] = 588,
  [612] = 588,
  [613] = 588,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 619,
  [622] = 622,
  [623] = 618,
  [624] = 624,
  [625] = 624,
  [626] = 626,
  [627] = 627,
  [628] = 624,
  [629] = 624,
  [630] = 624,
  [631] = 626,
  [632] = 626,
  [633] = 626,
  [634] = 626,
  [635] = 626,
  [636] = 624,
  [637] = 624,
  [638] = 626,
  [639] = 639,
  [640] = 639,
  [641] = 641,
  [642] = 639,
  [643] = 639,
  [644] = 639,
  [645] = 639,
  [646] = 639,
  [647] = 647,
  [648] = 639,
  [649] = 639,
  [650] = 650,
  [651] = 651,
  [652] = 650,
  [653] = 650,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 656,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 655,
  [668] = 668,
  [669] = 669,
  [670] = 656,
  [671] = 671,
  [672] = 671,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 665,
  [678] = 678,
  [679] = 679,
  [680] = 674,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 688,
  [691] = 691,
  [692] = 689,
  [693] = 688,
  [694] = 689,
  [695] = 695,
  [696] = 689,
  [697] = 697,
  [698] = 691,
  [699] = 699,
  [700] = 697,
  [701] = 691,
  [702] = 691,
  [703] = 699,
  [704] = 699,
  [705] = 705,
  [706] = 699,
  [707] = 689,
  [708] = 697,
  [709] = 688,
  [710] = 697,
  [711] = 688,
  [712] = 695,
  [713] = 691,
  [714] = 691,
  [715] = 689,
  [716] = 688,
  [717] = 514,
  [718] = 718,
  [719] = 719,
  [720] = 627,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 721,
  [725] = 721,
  [726] = 721,
  [727] = 721,
  [728] = 721,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 721,
  [735] = 730,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 627,
  [740] = 561,
  [741] = 738,
  [742] = 742,
  [743] = 679,
  [744] = 744,
  [745] = 738,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 738,
  [750] = 750,
  [751] = 627,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 746,
  [760] = 738,
  [761] = 761,
  [762] = 473,
  [763] = 484,
  [764] = 764,
  [765] = 496,
  [766] = 489,
  [767] = 627,
  [768] = 768,
  [769] = 510,
  [770] = 515,
  [771] = 771,
  [772] = 487,
  [773] = 773,
  [774] = 488,
  [775] = 773,
  [776] = 773,
  [777] = 777,
  [778] = 768,
  [779] = 771,
  [780] = 780,
  [781] = 781,
  [782] = 777,
  [783] = 783,
  [784] = 777,
  [785] = 777,
  [786] = 768,
  [787] = 787,
  [788] = 773,
  [789] = 773,
  [790] = 790,
  [791] = 777,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 551,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 489,
  [800] = 800,
  [801] = 800,
  [802] = 802,
  [803] = 742,
  [804] = 514,
  [805] = 561,
  [806] = 806,
  [807] = 731,
  [808] = 731,
  [809] = 747,
  [810] = 755,
  [811] = 473,
  [812] = 731,
  [813] = 752,
  [814] = 742,
  [815] = 679,
  [816] = 660,
  [817] = 484,
  [818] = 510,
  [819] = 753,
  [820] = 820,
  [821] = 473,
  [822] = 761,
  [823] = 823,
  [824] = 824,
  [825] = 484,
  [826] = 731,
  [827] = 737,
  [828] = 757,
  [829] = 744,
  [830] = 830,
  [831] = 742,
  [832] = 832,
  [833] = 754,
  [834] = 753,
  [835] = 748,
  [836] = 679,
  [837] = 752,
  [838] = 551,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 496,
  [844] = 753,
  [845] = 823,
  [846] = 755,
  [847] = 736,
  [848] = 747,
  [849] = 755,
  [850] = 756,
  [851] = 679,
  [852] = 852,
  [853] = 823,
  [854] = 752,
  [855] = 855,
  [856] = 747,
  [857] = 488,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 758,
  [862] = 862,
  [863] = 742,
  [864] = 842,
  [865] = 683,
  [866] = 754,
  [867] = 755,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 515,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 756,
  [879] = 736,
  [880] = 880,
  [881] = 869,
  [882] = 679,
  [883] = 868,
  [884] = 752,
  [885] = 488,
  [886] = 753,
  [887] = 761,
  [888] = 888,
  [889] = 870,
  [890] = 742,
  [891] = 737,
  [892] = 484,
  [893] = 893,
  [894] = 487,
  [895] = 473,
  [896] = 896,
  [897] = 897,
  [898] = 757,
  [899] = 877,
  [900] = 897,
  [901] = 748,
  [902] = 744,
  [903] = 868,
  [904] = 869,
  [905] = 747,
  [906] = 906,
  [907] = 870,
  [908] = 908,
  [909] = 758,
  [910] = 748,
  [911] = 875,
  [912] = 758,
  [913] = 754,
  [914] = 888,
  [915] = 761,
  [916] = 916,
  [917] = 917,
  [918] = 916,
  [919] = 514,
  [920] = 488,
  [921] = 487,
  [922] = 660,
  [923] = 514,
  [924] = 756,
  [925] = 906,
  [926] = 496,
  [927] = 496,
  [928] = 737,
  [929] = 757,
  [930] = 744,
  [931] = 931,
  [932] = 736,
  [933] = 496,
  [934] = 561,
  [935] = 561,
  [936] = 936,
  [937] = 683,
  [938] = 515,
  [939] = 515,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 943,
  [946] = 944,
  [947] = 941,
  [948] = 942,
  [949] = 943,
  [950] = 944,
  [951] = 941,
  [952] = 941,
  [953] = 942,
  [954] = 515,
  [955] = 943,
  [956] = 944,
  [957] = 942,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 514,
  [970] = 970,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 942,
  [976] = 976,
  [977] = 941,
  [978] = 942,
  [979] = 943,
  [980] = 944,
  [981] = 941,
  [982] = 944,
  [983] = 473,
  [984] = 984,
  [985] = 984,
  [986] = 942,
  [987] = 660,
  [988] = 984,
  [989] = 943,
  [990] = 944,
  [991] = 943,
  [992] = 984,
  [993] = 561,
  [994] = 941,
  [995] = 944,
  [996] = 942,
  [997] = 984,
  [998] = 943,
  [999] = 941,
  [1000] = 1000,
  [1001] = 943,
  [1002] = 944,
  [1003] = 941,
  [1004] = 942,
  [1005] = 943,
  [1006] = 944,
  [1007] = 942,
  [1008] = 484,
  [1009] = 941,
  [1010] = 944,
  [1011] = 943,
  [1012] = 488,
  [1013] = 943,
  [1014] = 944,
  [1015] = 941,
  [1016] = 942,
  [1017] = 943,
  [1018] = 942,
  [1019] = 941,
  [1020] = 942,
  [1021] = 943,
  [1022] = 944,
  [1023] = 683,
  [1024] = 941,
  [1025] = 944,
  [1026] = 941,
  [1027] = 942,
  [1028] = 1028,
  [1029] = 941,
  [1030] = 942,
  [1031] = 1031,
  [1032] = 942,
  [1033] = 1033,
  [1034] = 944,
  [1035] = 943,
  [1036] = 941,
  [1037] = 944,
  [1038] = 1038,
  [1039] = 943,
  [1040] = 941,
  [1041] = 944,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 943,
  [1047] = 942,
  [1048] = 1045,
  [1049] = 941,
  [1050] = 1050,
  [1051] = 941,
  [1052] = 1042,
  [1053] = 1042,
  [1054] = 1043,
  [1055] = 1045,
  [1056] = 1044,
  [1057] = 1044,
  [1058] = 1044,
  [1059] = 943,
  [1060] = 1045,
  [1061] = 943,
  [1062] = 943,
  [1063] = 944,
  [1064] = 1050,
  [1065] = 944,
  [1066] = 941,
  [1067] = 944,
  [1068] = 942,
  [1069] = 1042,
  [1070] = 942,
  [1071] = 1043,
  [1072] = 942,
  [1073] = 487,
  [1074] = 1043,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1076,
  [1081] = 1075,
  [1082] = 1077,
  [1083] = 1078,
  [1084] = 1079,
  [1085] = 1044,
  [1086] = 1044,
  [1087] = 1045,
  [1088] = 1042,
  [1089] = 1043,
  [1090] = 1044,
  [1091] = 1045,
  [1092] = 1042,
  [1093] = 1043,
  [1094] = 1044,
  [1095] = 1045,
  [1096] = 1050,
  [1097] = 1042,
  [1098] = 1043,
  [1099] = 1044,
  [1100] = 1045,
  [1101] = 1042,
  [1102] = 1043,
  [1103] = 1044,
  [1104] = 1042,
  [1105] = 1043,
  [1106] = 1045,
  [1107] = 1045,
  [1108] = 1050,
  [1109] = 1042,
  [1110] = 1043,
  [1111] = 1050,
  [1112] = 1075,
  [1113] = 1044,
  [1114] = 1078,
  [1115] = 1079,
  [1116] = 1076,
  [1117] = 1076,
  [1118] = 1045,
  [1119] = 1042,
  [1120] = 1043,
  [1121] = 1044,
  [1122] = 1077,
  [1123] = 1078,
  [1124] = 1079,
  [1125] = 1076,
  [1126] = 1075,
  [1127] = 1075,
  [1128] = 1078,
  [1129] = 1077,
  [1130] = 1079,
  [1131] = 1050,
  [1132] = 1045,
  [1133] = 1042,
  [1134] = 1043,
  [1135] = 1077,
  [1136] = 1045,
  [1137] = 1050,
  [1138] = 1042,
  [1139] = 1043,
  [1140] = 1044,
  [1141] = 1045,
  [1142] = 1042,
  [1143] = 1043,
  [1144] = 1044,
  [1145] = 1145,
  [1146] = 1075,
  [1147] = 1147,
  [1148] = 1147,
  [1149] = 1149,
  [1150] = 1045,
  [1151] = 1151,
  [1152] = 1050,
  [1153] = 1042,
  [1154] = 1043,
  [1155] = 1044,
  [1156] = 1156,
  [1157] = 1147,
  [1158] = 1147,
  [1159] = 1159,
  [1160] = 1147,
  [1161] = 1156,
  [1162] = 1042,
  [1163] = 1043,
  [1164] = 1044,
  [1165] = 1077,
  [1166] = 1078,
  [1167] = 1079,
  [1168] = 1076,
  [1169] = 1075,
  [1170] = 1156,
  [1171] = 1156,
  [1172] = 1147,
  [1173] = 1077,
  [1174] = 1078,
  [1175] = 1079,
  [1176] = 1076,
  [1177] = 1045,
  [1178] = 1045,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1042,
  [1182] = 1075,
  [1183] = 1043,
  [1184] = 1149,
  [1185] = 1044,
  [1186] = 1042,
  [1187] = 1045,
  [1188] = 1042,
  [1189] = 1043,
  [1190] = 1044,
  [1191] = 1043,
  [1192] = 1179,
  [1193] = 1179,
  [1194] = 1044,
  [1195] = 1159,
  [1196] = 1045,
  [1197] = 1045,
  [1198] = 1050,
  [1199] = 1077,
  [1200] = 1151,
  [1201] = 1145,
  [1202] = 1078,
  [1203] = 1079,
  [1204] = 1076,
  [1205] = 1042,
  [1206] = 1043,
  [1207] = 1044,
  [1208] = 1050,
  [1209] = 1179,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1075,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 679,
  [1231] = 880,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1253,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1212,
  [1259] = 1259,
  [1260] = 1213,
  [1261] = 1215,
  [1262] = 1216,
  [1263] = 1217,
  [1264] = 1218,
  [1265] = 1220,
  [1266] = 1222,
  [1267] = 1223,
  [1268] = 1224,
  [1269] = 1225,
  [1270] = 1226,
  [1271] = 1227,
  [1272] = 1228,
  [1273] = 1229,
  [1274] = 742,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1219,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 880,
  [1283] = 1275,
  [1284] = 1284,
  [1285] = 1233,
  [1286] = 1237,
  [1287] = 1238,
  [1288] = 1242,
  [1289] = 679,
  [1290] = 1077,
  [1291] = 1291,
  [1292] = 1078,
  [1293] = 1079,
  [1294] = 1076,
  [1295] = 1075,
  [1296] = 742,
  [1297] = 1248,
  [1298] = 1257,
  [1299] = 1156,
  [1300] = 1249,
  [1301] = 1281,
  [1302] = 1156,
  [1303] = 1221,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1250,
  [1307] = 1259,
  [1308] = 1279,
  [1309] = 484,
  [1310] = 1284,
  [1311] = 1232,
  [1312] = 473,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1210,
  [1316] = 1276,
  [1317] = 1313,
  [1318] = 1314,
  [1319] = 1319,
  [1320] = 1320,
  [1321] = 1321,
  [1322] = 1234,
  [1323] = 1235,
  [1324] = 1077,
  [1325] = 1078,
  [1326] = 1079,
  [1327] = 1076,
  [1328] = 1075,
  [1329] = 1077,
  [1330] = 1078,
  [1331] = 1079,
  [1332] = 1076,
  [1333] = 1075,
  [1334] = 1291,
  [1335] = 1236,
  [1336] = 1319,
  [1337] = 1320,
  [1338] = 1321,
  [1339] = 1239,
  [1340] = 1240,
  [1341] = 1241,
  [1342] = 1278,
  [1343] = 1077,
  [1344] = 1243,
  [1345] = 1345,
  [1346] = 1244,
  [1347] = 1245,
  [1348] = 1246,
  [1349] = 1247,
  [1350] = 1345,
  [1351] = 1280,
  [1352] = 1352,
  [1353] = 1211,
  [1354] = 1256,
  [1355] = 1078,
  [1356] = 1079,
  [1357] = 1251,
  [1358] = 1252,
  [1359] = 1304,
  [1360] = 1076,
  [1361] = 1253,
  [1362] = 1254,
  [1363] = 1255,
  [1364] = 1352,
  [1365] = 1156,
  [1366] = 1156,
  [1367] = 1179,
  [1368] = 1156,
  [1369] = 1369,
  [1370] = 1179,
  [1371] = 1371,
  [1372] = 1372,
  [1373] = 1179,
  [1374] = 1369,
  [1375] = 1371,
  [1376] = 1372,
  [1377] = 1369,
  [1378] = 1371,
  [1379] = 1372,
  [1380] = 1369,
  [1381] = 1371,
  [1382] = 1369,
  [1383] = 1371,
  [1384] = 1372,
  [1385] = 1156,
  [1386] = 1372,
  [1387] = 487,
  [1388] = 1369,
  [1389] = 1179,
  [1390] = 1372,
  [1391] = 488,
  [1392] = 1371,
  [1393] = 1233,
  [1394] = 1221,
  [1395] = 1245,
  [1396] = 1210,
  [1397] = 1250,
  [1398] = 1259,
  [1399] = 1284,
  [1400] = 1075,
  [1401] = 1215,
  [1402] = 1179,
  [1403] = 1219,
  [1404] = 1279,
  [1405] = 1216,
  [1406] = 880,
  [1407] = 1217,
  [1408] = 1218,
  [1409] = 1275,
  [1410] = 1220,
  [1411] = 1210,
  [1412] = 1319,
  [1413] = 1222,
  [1414] = 1223,
  [1415] = 1224,
  [1416] = 1225,
  [1417] = 1226,
  [1418] = 1232,
  [1419] = 1227,
  [1420] = 1228,
  [1421] = 1229,
  [1422] = 1246,
  [1423] = 1242,
  [1424] = 1247,
  [1425] = 1275,
  [1426] = 1242,
  [1427] = 1179,
  [1428] = 1276,
  [1429] = 1429,
  [1430] = 742,
  [1431] = 1237,
  [1432] = 1179,
  [1433] = 1079,
  [1434] = 1345,
  [1435] = 1234,
  [1436] = 742,
  [1437] = 679,
  [1438] = 1235,
  [1439] = 1313,
  [1440] = 742,
  [1441] = 679,
  [1442] = 1252,
  [1443] = 1078,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1278,
  [1447] = 1321,
  [1448] = 1448,
  [1449] = 1079,
  [1450] = 1239,
  [1451] = 1240,
  [1452] = 1241,
  [1453] = 1251,
  [1454] = 1076,
  [1455] = 1253,
  [1456] = 1254,
  [1457] = 1255,
  [1458] = 1256,
  [1459] = 1257,
  [1460] = 1078,
  [1461] = 1291,
  [1462] = 1280,
  [1463] = 1320,
  [1464] = 1077,
  [1465] = 1248,
  [1466] = 1352,
  [1467] = 1212,
  [1468] = 1249,
  [1469] = 1238,
  [1470] = 1077,
  [1471] = 1078,
  [1472] = 1079,
  [1473] = 1076,
  [1474] = 1075,
  [1475] = 1314,
  [1476] = 1243,
  [1477] = 1477,
  [1478] = 1284,
  [1479] = 1210,
  [1480] = 1480,
  [1481] = 1281,
  [1482] = 1448,
  [1483] = 1213,
  [1484] = 1304,
  [1485] = 742,
  [1486] = 1075,
  [1487] = 1238,
  [1488] = 1077,
  [1489] = 1244,
  [1490] = 1076,
  [1491] = 1211,
  [1492] = 1284,
  [1493] = 1236,
  [1494] = 1226,
  [1495] = 1352,
  [1496] = 1249,
  [1497] = 1281,
  [1498] = 1211,
  [1499] = 1499,
  [1500] = 742,
  [1501] = 679,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 679,
  [1505] = 1219,
  [1506] = 1221,
  [1507] = 1250,
  [1508] = 1259,
  [1509] = 880,
  [1510] = 1284,
  [1511] = 1232,
  [1512] = 1210,
  [1513] = 1233,
  [1514] = 1234,
  [1515] = 1235,
  [1516] = 1236,
  [1517] = 1444,
  [1518] = 1237,
  [1519] = 1279,
  [1520] = 1239,
  [1521] = 1240,
  [1522] = 1241,
  [1523] = 1523,
  [1524] = 1243,
  [1525] = 1244,
  [1526] = 1245,
  [1527] = 1246,
  [1528] = 1247,
  [1529] = 1529,
  [1530] = 1248,
  [1531] = 1251,
  [1532] = 1252,
  [1533] = 1253,
  [1534] = 1254,
  [1535] = 1304,
  [1536] = 1256,
  [1537] = 1257,
  [1538] = 1212,
  [1539] = 1539,
  [1540] = 1275,
  [1541] = 1213,
  [1542] = 1215,
  [1543] = 1216,
  [1544] = 1217,
  [1545] = 1218,
  [1546] = 1220,
  [1547] = 1547,
  [1548] = 1222,
  [1549] = 1223,
  [1550] = 1224,
  [1551] = 1225,
  [1552] = 1227,
  [1553] = 1228,
  [1554] = 1229,
  [1555] = 679,
  [1556] = 1276,
  [1557] = 1313,
  [1558] = 1238,
  [1559] = 1314,
  [1560] = 1242,
  [1561] = 1278,
  [1562] = 1280,
  [1563] = 1077,
  [1564] = 1078,
  [1565] = 1079,
  [1566] = 1076,
  [1567] = 1075,
  [1568] = 1568,
  [1569] = 1319,
  [1570] = 1320,
  [1571] = 1571,
  [1572] = 742,
  [1573] = 1321,
  [1574] = 1275,
  [1575] = 1575,
  [1576] = 1291,
  [1577] = 1345,
  [1578] = 1578,
  [1579] = 1077,
  [1580] = 1078,
  [1581] = 1079,
  [1582] = 1076,
  [1583] = 1075,
  [1584] = 1284,
  [1585] = 1210,
  [1586] = 1255,
  [1587] = 1077,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 1499,
  [1591] = 1591,
  [1592] = 1578,
  [1593] = 1503,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1078,
  [1597] = 1597,
  [1598] = 1079,
  [1599] = 1076,
  [1600] = 731,
  [1601] = 1601,
  [1602] = 1075,
  [1603] = 1603,
  [1604] = 755,
  [1605] = 1605,
  [1606] = 1539,
  [1607] = 1547,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 758,
  [1611] = 1076,
  [1612] = 1612,
  [1613] = 1284,
  [1614] = 748,
  [1615] = 753,
  [1616] = 1078,
  [1617] = 1079,
  [1618] = 1618,
  [1619] = 1076,
  [1620] = 1620,
  [1621] = 1210,
  [1622] = 1075,
  [1623] = 1623,
  [1624] = 1077,
  [1625] = 1603,
  [1626] = 747,
  [1627] = 1595,
  [1628] = 1628,
  [1629] = 756,
  [1630] = 736,
  [1631] = 754,
  [1632] = 1075,
  [1633] = 1591,
  [1634] = 1077,
  [1635] = 737,
  [1636] = 757,
  [1637] = 752,
  [1638] = 761,
  [1639] = 744,
  [1640] = 1601,
  [1641] = 1078,
  [1642] = 1079,
  [1643] = 1609,
  [1644] = 1237,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1314,
  [1648] = 1233,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1238,
  [1653] = 1653,
  [1654] = 1284,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1219,
  [1658] = 1658,
  [1659] = 1304,
  [1660] = 1319,
  [1661] = 888,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1313,
  [1665] = 679,
  [1666] = 1320,
  [1667] = 1242,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1211,
  [1671] = 1278,
  [1672] = 1345,
  [1673] = 1673,
  [1674] = 880,
  [1675] = 875,
  [1676] = 1248,
  [1677] = 1677,
  [1678] = 1321,
  [1679] = 1280,
  [1680] = 1680,
  [1681] = 906,
  [1682] = 1275,
  [1683] = 742,
  [1684] = 1210,
  [1685] = 1685,
  [1686] = 1276,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1658,
  [1696] = 514,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1680,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1694,
  [1703] = 1703,
  [1704] = 1673,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1689,
  [1709] = 1709,
  [1710] = 1651,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1645,
  [1714] = 1668,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 473,
  [1718] = 1709,
  [1719] = 1685,
  [1720] = 1720,
  [1721] = 484,
  [1722] = 1220,
  [1723] = 561,
  [1724] = 1724,
  [1725] = 1215,
  [1726] = 1726,
  [1727] = 1156,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1216,
  [1731] = 1217,
  [1732] = 1255,
  [1733] = 1256,
  [1734] = 1247,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1218,
  [1738] = 1243,
  [1739] = 1246,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1251,
  [1743] = 1222,
  [1744] = 1744,
  [1745] = 1223,
  [1746] = 1254,
  [1747] = 1224,
  [1748] = 1156,
  [1749] = 1225,
  [1750] = 1226,
  [1751] = 1252,
  [1752] = 1227,
  [1753] = 1228,
  [1754] = 1229,
  [1755] = 488,
  [1756] = 1257,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1156,
  [1760] = 1212,
  [1761] = 487,
  [1762] = 1253,
  [1763] = 1234,
  [1764] = 1235,
  [1765] = 1236,
  [1766] = 1239,
  [1767] = 1240,
  [1768] = 1241,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1232,
  [1772] = 1213,
  [1773] = 1244,
  [1774] = 1774,
  [1775] = 1245,
  [1776] = 1776,
  [1777] = 1156,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1280,
  [1797] = 1797,
  [1798] = 1248,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1276,
  [1802] = 1233,
  [1803] = 1803,
  [1804] = 685,
  [1805] = 1237,
  [1806] = 1278,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1809,
  [1812] = 1809,
  [1813] = 1809,
  [1814] = 1809,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1810,
  [1818] = 1818,
  [1819] = 742,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1810,
  [1824] = 1156,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1809,
  [1834] = 1834,
  [1835] = 1809,
  [1836] = 1836,
  [1837] = 1809,
  [1838] = 1810,
  [1839] = 1809,
  [1840] = 1809,
  [1841] = 1809,
  [1842] = 1809,
  [1843] = 1809,
  [1844] = 1844,
  [1845] = 1825,
  [1846] = 1826,
  [1847] = 1826,
  [1848] = 1809,
  [1849] = 1844,
  [1850] = 1850,
  [1851] = 1851,
  [1852] = 1852,
  [1853] = 1853,
  [1854] = 1818,
  [1855] = 1855,
  [1856] = 1809,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 731,
  [1860] = 1844,
  [1861] = 1818,
  [1862] = 1862,
  [1863] = 1809,
  [1864] = 1844,
  [1865] = 1865,
  [1866] = 1809,
  [1867] = 1810,
  [1868] = 1809,
  [1869] = 1869,
  [1870] = 484,
  [1871] = 1810,
  [1872] = 1872,
  [1873] = 1156,
  [1874] = 1825,
  [1875] = 1809,
  [1876] = 1844,
  [1877] = 1844,
  [1878] = 1809,
  [1879] = 1879,
  [1880] = 473,
  [1881] = 742,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1884,
  [1885] = 1885,
  [1886] = 679,
  [1887] = 875,
  [1888] = 1885,
  [1889] = 1883,
  [1890] = 1890,
  [1891] = 1891,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1882,
  [1897] = 753,
  [1898] = 484,
  [1899] = 1156,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1884,
  [1903] = 1232,
  [1904] = 1904,
  [1905] = 1883,
  [1906] = 1906,
  [1907] = 1156,
  [1908] = 1908,
  [1909] = 1909,
  [1910] = 1275,
  [1911] = 1884,
  [1912] = 1912,
  [1913] = 1913,
  [1914] = 888,
  [1915] = 1915,
  [1916] = 1156,
  [1917] = 1900,
  [1918] = 1918,
  [1919] = 1884,
  [1920] = 1920,
  [1921] = 1885,
  [1922] = 1922,
  [1923] = 1923,
  [1924] = 1924,
  [1925] = 752,
  [1926] = 488,
  [1927] = 1927,
  [1928] = 1900,
  [1929] = 1929,
  [1930] = 1890,
  [1931] = 1885,
  [1932] = 1883,
  [1933] = 1933,
  [1934] = 1885,
  [1935] = 1883,
  [1936] = 473,
  [1937] = 1884,
  [1938] = 731,
  [1939] = 1939,
  [1940] = 1900,
  [1941] = 1941,
  [1942] = 1882,
  [1943] = 1883,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1884,
  [1947] = 1947,
  [1948] = 731,
  [1949] = 1949,
  [1950] = 1950,
  [1951] = 906,
  [1952] = 1900,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1900,
  [1956] = 755,
  [1957] = 1885,
  [1958] = 1900,
  [1959] = 1156,
  [1960] = 747,
  [1961] = 1961,
  [1962] = 1254,
  [1963] = 1963,
  [1964] = 1964,
  [1965] = 753,
  [1966] = 1966,
  [1967] = 1967,
  [1968] = 1968,
  [1969] = 755,
  [1970] = 1970,
  [1971] = 1971,
  [1972] = 1623,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1971,
  [1976] = 742,
  [1977] = 1973,
  [1978] = 748,
  [1979] = 1979,
  [1980] = 1971,
  [1981] = 1973,
  [1982] = 1968,
  [1983] = 1961,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1984,
  [1991] = 1985,
  [1992] = 1986,
  [1993] = 1255,
  [1994] = 1988,
  [1995] = 1995,
  [1996] = 1256,
  [1997] = 1997,
  [1998] = 1988,
  [1999] = 1973,
  [2000] = 1257,
  [2001] = 1212,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 1246,
  [2006] = 1620,
  [2007] = 1213,
  [2008] = 2008,
  [2009] = 1215,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 1970,
  [2015] = 2015,
  [2016] = 679,
  [2017] = 2017,
  [2018] = 1974,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 1216,
  [2022] = 1217,
  [2023] = 754,
  [2024] = 1971,
  [2025] = 2025,
  [2026] = 1247,
  [2027] = 1218,
  [2028] = 1968,
  [2029] = 1220,
  [2030] = 2030,
  [2031] = 1968,
  [2032] = 1222,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 1236,
  [2036] = 1223,
  [2037] = 1224,
  [2038] = 1970,
  [2039] = 1971,
  [2040] = 1225,
  [2041] = 1241,
  [2042] = 1984,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 1235,
  [2046] = 1226,
  [2047] = 2012,
  [2048] = 2012,
  [2049] = 2012,
  [2050] = 1227,
  [2051] = 2051,
  [2052] = 1228,
  [2053] = 2053,
  [2054] = 1229,
  [2055] = 487,
  [2056] = 1973,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 488,
  [2061] = 1970,
  [2062] = 747,
  [2063] = 1961,
  [2064] = 2064,
  [2065] = 1571,
  [2066] = 1575,
  [2067] = 906,
  [2068] = 1974,
  [2069] = 1649,
  [2070] = 756,
  [2071] = 736,
  [2072] = 2072,
  [2073] = 1971,
  [2074] = 1529,
  [2075] = 875,
  [2076] = 1239,
  [2077] = 2077,
  [2078] = 1243,
  [2079] = 1973,
  [2080] = 679,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 1251,
  [2085] = 1240,
  [2086] = 1968,
  [2087] = 2087,
  [2088] = 1252,
  [2089] = 758,
  [2090] = 761,
  [2091] = 2091,
  [2092] = 888,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 2095,
  [2096] = 1970,
  [2097] = 1985,
  [2098] = 1986,
  [2099] = 1971,
  [2100] = 1234,
  [2101] = 1244,
  [2102] = 2012,
  [2103] = 2103,
  [2104] = 1245,
  [2105] = 2105,
  [2106] = 753,
  [2107] = 755,
  [2108] = 752,
  [2109] = 2109,
  [2110] = 747,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 1973,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 752,
  [2118] = 2118,
  [2119] = 737,
  [2120] = 757,
  [2121] = 744,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 1253,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2129,
  [2130] = 2127,
  [2131] = 2131,
  [2132] = 757,
  [2133] = 744,
  [2134] = 2134,
  [2135] = 2127,
  [2136] = 2136,
  [2137] = 2127,
  [2138] = 2138,
  [2139] = 2127,
  [2140] = 2140,
  [2141] = 2127,
  [2142] = 2142,
  [2143] = 2127,
  [2144] = 2128,
  [2145] = 2127,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2134,
  [2149] = 2149,
  [2150] = 1655,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2156,
  [2157] = 2127,
  [2158] = 2158,
  [2159] = 2142,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2163,
  [2164] = 2153,
  [2165] = 2162,
  [2166] = 2166,
  [2167] = 2167,
  [2168] = 2160,
  [2169] = 2169,
  [2170] = 2142,
  [2171] = 2134,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2129,
  [2177] = 2160,
  [2178] = 1597,
  [2179] = 2179,
  [2180] = 2142,
  [2181] = 2127,
  [2182] = 1031,
  [2183] = 2175,
  [2184] = 2129,
  [2185] = 2185,
  [2186] = 2128,
  [2187] = 2127,
  [2188] = 2128,
  [2189] = 1623,
  [2190] = 2153,
  [2191] = 2134,
  [2192] = 2151,
  [2193] = 2134,
  [2194] = 2194,
  [2195] = 2195,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 1906,
  [2200] = 2179,
  [2201] = 2201,
  [2202] = 1891,
  [2203] = 2129,
  [2204] = 2204,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2207,
  [2208] = 2208,
  [2209] = 1529,
  [2210] = 2210,
  [2211] = 2179,
  [2212] = 2212,
  [2213] = 1895,
  [2214] = 2127,
  [2215] = 1238,
  [2216] = 2216,
  [2217] = 2127,
  [2218] = 2218,
  [2219] = 2175,
  [2220] = 2127,
  [2221] = 2153,
  [2222] = 2222,
  [2223] = 2223,
  [2224] = 1869,
  [2225] = 748,
  [2226] = 2226,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 1605,
  [2230] = 2127,
  [2231] = 2179,
  [2232] = 2160,
  [2233] = 2233,
  [2234] = 758,
  [2235] = 1242,
  [2236] = 2236,
  [2237] = 754,
  [2238] = 2238,
  [2239] = 2153,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2160,
  [2245] = 1589,
  [2246] = 761,
  [2247] = 2247,
  [2248] = 2142,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 1855,
  [2252] = 2207,
  [2253] = 2127,
  [2254] = 1571,
  [2255] = 1575,
  [2256] = 2256,
  [2257] = 2127,
  [2258] = 737,
  [2259] = 2259,
  [2260] = 2153,
  [2261] = 1649,
  [2262] = 2262,
  [2263] = 2263,
  [2264] = 2129,
  [2265] = 2160,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2142,
  [2269] = 2172,
  [2270] = 2129,
  [2271] = 756,
  [2272] = 2127,
  [2273] = 2273,
  [2274] = 1663,
  [2275] = 2128,
  [2276] = 736,
  [2277] = 2128,
  [2278] = 2172,
  [2279] = 2127,
  [2280] = 2280,
  [2281] = 1588,
  [2282] = 2134,
  [2283] = 2127,
  [2284] = 1620,
  [2285] = 1649,
  [2286] = 2286,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2289,
  [2294] = 2294,
  [2295] = 2289,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2297,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2298,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 1720,
  [2313] = 2313,
  [2314] = 860,
  [2315] = 1707,
  [2316] = 2291,
  [2317] = 2317,
  [2318] = 2318,
  [2319] = 2319,
  [2320] = 2294,
  [2321] = 2321,
  [2322] = 1284,
  [2323] = 2323,
  [2324] = 2297,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2250,
  [2328] = 2328,
  [2329] = 1588,
  [2330] = 2330,
  [2331] = 2330,
  [2332] = 1701,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2288,
  [2337] = 2337,
  [2338] = 2289,
  [2339] = 2290,
  [2340] = 2226,
  [2341] = 1692,
  [2342] = 2291,
  [2343] = 1210,
  [2344] = 2297,
  [2345] = 2298,
  [2346] = 2346,
  [2347] = 2334,
  [2348] = 2348,
  [2349] = 2348,
  [2350] = 2350,
  [2351] = 2351,
  [2352] = 2330,
  [2353] = 2353,
  [2354] = 2354,
  [2355] = 2355,
  [2356] = 2298,
  [2357] = 2348,
  [2358] = 2358,
  [2359] = 2304,
  [2360] = 2358,
  [2361] = 2298,
  [2362] = 2335,
  [2363] = 1589,
  [2364] = 2364,
  [2365] = 2335,
  [2366] = 2291,
  [2367] = 2367,
  [2368] = 2368,
  [2369] = 2369,
  [2370] = 2370,
  [2371] = 2350,
  [2372] = 2334,
  [2373] = 2298,
  [2374] = 2348,
  [2375] = 2375,
  [2376] = 2304,
  [2377] = 742,
  [2378] = 1663,
  [2379] = 2334,
  [2380] = 2298,
  [2381] = 2381,
  [2382] = 2382,
  [2383] = 2335,
  [2384] = 2287,
  [2385] = 2335,
  [2386] = 2287,
  [2387] = 2387,
  [2388] = 2290,
  [2389] = 2364,
  [2390] = 2297,
  [2391] = 2334,
  [2392] = 2392,
  [2393] = 2291,
  [2394] = 2394,
  [2395] = 2287,
  [2396] = 2298,
  [2397] = 2297,
  [2398] = 2350,
  [2399] = 2399,
  [2400] = 2400,
  [2401] = 2401,
  [2402] = 2319,
  [2403] = 2325,
  [2404] = 2288,
  [2405] = 2405,
  [2406] = 2406,
  [2407] = 2297,
  [2408] = 2354,
  [2409] = 2298,
  [2410] = 2298,
  [2411] = 2411,
  [2412] = 2298,
  [2413] = 2298,
  [2414] = 2414,
  [2415] = 2294,
  [2416] = 2289,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2306,
  [2421] = 2421,
  [2422] = 2422,
  [2423] = 2152,
  [2424] = 2424,
  [2425] = 2298,
  [2426] = 2426,
  [2427] = 2427,
  [2428] = 2298,
  [2429] = 2287,
  [2430] = 2297,
  [2431] = 2350,
  [2432] = 2298,
  [2433] = 2298,
  [2434] = 2348,
  [2435] = 2354,
  [2436] = 2298,
  [2437] = 2437,
  [2438] = 2348,
  [2439] = 2439,
  [2440] = 2297,
  [2441] = 2441,
  [2442] = 1605,
  [2443] = 2358,
  [2444] = 1597,
  [2445] = 2445,
  [2446] = 2298,
  [2447] = 2335,
  [2448] = 1655,
  [2449] = 2449,
  [2450] = 2287,
  [2451] = 2451,
  [2452] = 2291,
  [2453] = 2453,
  [2454] = 2298,
  [2455] = 2455,
  [2456] = 2297,
  [2457] = 2350,
  [2458] = 2458,
  [2459] = 2459,
  [2460] = 2350,
  [2461] = 2294,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2354,
  [2465] = 2334,
  [2466] = 2325,
  [2467] = 2467,
  [2468] = 2468,
  [2469] = 2297,
  [2470] = 2470,
  [2471] = 2471,
  [2472] = 2297,
  [2473] = 2297,
  [2474] = 2294,
  [2475] = 2297,
  [2476] = 2297,
  [2477] = 2297,
  [2478] = 2354,
  [2479] = 2479,
  [2480] = 2297,
  [2481] = 2481,
  [2482] = 2297,
  [2483] = 2483,
  [2484] = 2297,
  [2485] = 2348,
  [2486] = 2354,
  [2487] = 2294,
  [2488] = 2297,
  [2489] = 2298,
  [2490] = 2490,
  [2491] = 2491,
  [2492] = 1692,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2496,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2500,
  [2501] = 2498,
  [2502] = 2502,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2506,
  [2507] = 2507,
  [2508] = 2498,
  [2509] = 2509,
  [2510] = 2510,
  [2511] = 2503,
  [2512] = 2512,
  [2513] = 2513,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 2519,
  [2520] = 2520,
  [2521] = 2521,
  [2522] = 2509,
  [2523] = 2523,
  [2524] = 2524,
  [2525] = 2525,
  [2526] = 2526,
  [2527] = 2527,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 2530,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2533,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 2495,
  [2539] = 2516,
  [2540] = 2527,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 2426,
  [2546] = 2546,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 2459,
  [2551] = 2468,
  [2552] = 2552,
  [2553] = 2536,
  [2554] = 2554,
  [2555] = 2495,
  [2556] = 2556,
  [2557] = 2557,
  [2558] = 2558,
  [2559] = 2559,
  [2560] = 2496,
  [2561] = 2513,
  [2562] = 2498,
  [2563] = 2503,
  [2564] = 2564,
  [2565] = 2513,
  [2566] = 2536,
  [2567] = 2567,
  [2568] = 1276,
  [2569] = 1701,
  [2570] = 2570,
  [2571] = 2513,
  [2572] = 2516,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2575,
  [2576] = 2576,
  [2577] = 2577,
  [2578] = 2578,
  [2579] = 2517,
  [2580] = 2536,
  [2581] = 2581,
  [2582] = 2495,
  [2583] = 2516,
  [2584] = 2527,
  [2585] = 2585,
  [2586] = 2495,
  [2587] = 2514,
  [2588] = 2525,
  [2589] = 2589,
  [2590] = 2515,
  [2591] = 2536,
  [2592] = 2592,
  [2593] = 2495,
  [2594] = 2516,
  [2595] = 2527,
  [2596] = 2527,
  [2597] = 2496,
  [2598] = 2598,
  [2599] = 2498,
  [2600] = 2503,
  [2601] = 2516,
  [2602] = 2536,
  [2603] = 2603,
  [2604] = 2495,
  [2605] = 2516,
  [2606] = 2527,
  [2607] = 2526,
  [2608] = 2533,
  [2609] = 2609,
  [2610] = 2536,
  [2611] = 2611,
  [2612] = 2495,
  [2613] = 2516,
  [2614] = 2527,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2536,
  [2619] = 2517,
  [2620] = 2495,
  [2621] = 2516,
  [2622] = 2527,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2536,
  [2627] = 2536,
  [2628] = 2495,
  [2629] = 2516,
  [2630] = 2527,
  [2631] = 2503,
  [2632] = 2495,
  [2633] = 2633,
  [2634] = 2536,
  [2635] = 2496,
  [2636] = 2495,
  [2637] = 2516,
  [2638] = 2527,
  [2639] = 2513,
  [2640] = 2498,
  [2641] = 2503,
  [2642] = 2642,
  [2643] = 2307,
  [2644] = 2516,
  [2645] = 2517,
  [2646] = 2525,
  [2647] = 2527,
  [2648] = 2514,
  [2649] = 2533,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2515,
  [2653] = 2653,
  [2654] = 2536,
  [2655] = 2655,
  [2656] = 2495,
  [2657] = 2498,
  [2658] = 2658,
  [2659] = 2516,
  [2660] = 2516,
  [2661] = 2490,
  [2662] = 2527,
  [2663] = 2517,
  [2664] = 2664,
  [2665] = 2533,
  [2666] = 2625,
  [2667] = 2490,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2490,
  [2671] = 2536,
  [2672] = 2490,
  [2673] = 2490,
  [2674] = 2490,
  [2675] = 2490,
  [2676] = 2490,
  [2677] = 2490,
  [2678] = 2490,
  [2679] = 2490,
  [2680] = 2490,
  [2681] = 2490,
  [2682] = 2490,
  [2683] = 2490,
  [2684] = 2684,
  [2685] = 2495,
  [2686] = 2498,
  [2687] = 2687,
  [2688] = 2536,
  [2689] = 2689,
  [2690] = 2495,
  [2691] = 2490,
  [2692] = 2516,
  [2693] = 2527,
  [2694] = 2516,
  [2695] = 2695,
  [2696] = 2321,
  [2697] = 2527,
  [2698] = 2509,
  [2699] = 2533,
  [2700] = 2530,
  [2701] = 2701,
  [2702] = 2702,
  [2703] = 2703,
  [2704] = 2704,
  [2705] = 2705,
  [2706] = 2706,
  [2707] = 2707,
  [2708] = 2708,
  [2709] = 2509,
  [2710] = 2530,
  [2711] = 2525,
  [2712] = 2541,
  [2713] = 2713,
  [2714] = 2514,
  [2715] = 2527,
  [2716] = 2716,
  [2717] = 2495,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2720,
  [2721] = 2525,
  [2722] = 2515,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2496,
  [2727] = 2536,
  [2728] = 2707,
  [2729] = 2495,
  [2730] = 2529,
  [2731] = 2546,
  [2732] = 2708,
  [2733] = 2733,
  [2734] = 2536,
  [2735] = 2495,
  [2736] = 2736,
  [2737] = 2737,
  [2738] = 2087,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2742,
  [2743] = 2743,
  [2744] = 2744,
  [2745] = 2516,
  [2746] = 2707,
  [2747] = 2747,
  [2748] = 2525,
  [2749] = 2723,
  [2750] = 2750,
  [2751] = 2713,
  [2752] = 2752,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2527,
  [2756] = 2756,
  [2757] = 2527,
  [2758] = 2758,
  [2759] = 2759,
  [2760] = 2760,
  [2761] = 2708,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2541,
  [2765] = 2765,
  [2766] = 2528,
  [2767] = 2718,
  [2768] = 2768,
  [2769] = 2549,
  [2770] = 2770,
  [2771] = 2490,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2720,
  [2776] = 2713,
  [2777] = 2777,
  [2778] = 2533,
  [2779] = 2516,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2526,
  [2785] = 2785,
  [2786] = 2786,
  [2787] = 2524,
  [2788] = 2527,
  [2789] = 2789,
  [2790] = 1278,
  [2791] = 2546,
  [2792] = 2792,
  [2793] = 2536,
  [2794] = 2536,
  [2795] = 2495,
  [2796] = 2516,
  [2797] = 2527,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2541,
  [2801] = 2801,
  [2802] = 2495,
  [2803] = 2803,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2496,
  [2807] = 2533,
  [2808] = 2498,
  [2809] = 2503,
  [2810] = 2810,
  [2811] = 2760,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 2765,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2513,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2541,
  [2822] = 2514,
  [2823] = 2515,
  [2824] = 2516,
  [2825] = 2528,
  [2826] = 2517,
  [2827] = 2827,
  [2828] = 2828,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2509,
  [2833] = 2833,
  [2834] = 685,
  [2835] = 2835,
  [2836] = 2707,
  [2837] = 2716,
  [2838] = 2708,
  [2839] = 2839,
  [2840] = 2541,
  [2841] = 2525,
  [2842] = 2842,
  [2843] = 2718,
  [2844] = 2483,
  [2845] = 2527,
  [2846] = 2528,
  [2847] = 2720,
  [2848] = 2848,
  [2849] = 2720,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2512,
  [2853] = 2853,
  [2854] = 2819,
  [2855] = 2855,
  [2856] = 2548,
  [2857] = 2541,
  [2858] = 2411,
  [2859] = 2533,
  [2860] = 2860,
  [2861] = 2861,
  [2862] = 2625,
  [2863] = 2541,
  [2864] = 2851,
  [2865] = 2865,
  [2866] = 2617,
  [2867] = 2490,
  [2868] = 2868,
  [2869] = 2869,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 1280,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2876,
  [2877] = 2877,
  [2878] = 2118,
  [2879] = 2879,
  [2880] = 2880,
  [2881] = 2558,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2481,
  [2885] = 2355,
  [2886] = 2533,
  [2887] = 2887,
  [2888] = 2888,
  [2889] = 2889,
  [2890] = 2812,
  [2891] = 2664,
  [2892] = 2490,
  [2893] = 2536,
  [2894] = 2894,
  [2895] = 2664,
  [2896] = 1720,
  [2897] = 2517,
  [2898] = 2424,
  [2899] = 1707,
  [2900] = 2536,
  [2901] = 2528,
  [2902] = 2311,
  [2903] = 2333,
};

static TSCharacterRange sym__symbols_character_set_2[] = {
  {'!', '!'}, {'$', '&'}, {'*', '+'}, {'-', '.'}, {':', ':'}, {'<', '@'}, {'\\', '\\'}, {'^', '^'},
  {'|', '|'}, {'~', '~'},
};

static TSCharacterRange sym_qidop_character_set_1[] = {
  {'!', '!'}, {'$', '&'}, {')', '+'}, {'-', '.'}, {':', ':'}, {'<', '@'}, {'\\', '\\'}, {'^', '^'},
  {'|', '|'}, {'~', '~'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(272);
      ADVANCE_MAP(
        '!', 426,
        '"', 915,
        '\'', 919,
        '(', 496,
        ')', 906,
        '*', 46,
        ',', 374,
        '-', 50,
        '.', 430,
        '/', 38,
        '0', 886,
        ':', 288,
        '<', 492,
        '=', 276,
        '>', 366,
        '?', 908,
        '@', 263,
        '[', 490,
        '\\', 57,
        ']', 365,
        '^', 439,
        '_', 405,
        'a', 81,
        'b', 100,
        'c', 315,
        'd', 136,
        'e', 125,
        'f', 82,
        'h', 65,
        'i', 126,
        'j', 219,
        'l', 59,
        'm', 60,
        'n', 61,
        'o', 202,
        'p', 236,
        'r', 62,
        's', 86,
        't', 70,
        'v', 64,
        'w', 140,
        '|', 368,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(268);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 906,
        '-', 51,
        '/', 38,
        '0', 886,
        '<', 491,
        '?', 908,
        '@', 264,
        '[', 490,
        '_', 404,
        'b', 529,
        'c', 306,
        'd', 554,
        'e', 615,
        'f', 519,
        'h', 502,
        'i', 548,
        'j', 605,
        'l', 503,
        'm', 504,
        'n', 505,
        'o', 597,
        'r', 508,
        's', 520,
        't', 511,
        'v', 506,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 50,
        '/', 38,
        '0', 886,
        ':', 288,
        '<', 491,
        '=', 276,
        '>', 366,
        '?', 908,
        '@', 264,
        '[', 490,
        ']', 365,
        '_', 404,
        'b', 530,
        'c', 307,
        'd', 554,
        'e', 615,
        'f', 517,
        'h', 502,
        'i', 548,
        'j', 605,
        'l', 503,
        'm', 504,
        'n', 505,
        'o', 597,
        'r', 531,
        's', 520,
        't', 511,
        'v', 506,
        'w', 556,
        '|', 368,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 51,
        '/', 38,
        '0', 886,
        ':', 54,
        '<', 40,
        '=', 276,
        '>', 366,
        '?', 908,
        '@', 264,
        '[', 490,
        ']', 365,
        '_', 404,
        'b', 530,
        'c', 307,
        'd', 554,
        'e', 615,
        'f', 516,
        'h', 502,
        'i', 548,
        'j', 605,
        'l', 503,
        'm', 504,
        'n', 505,
        'o', 597,
        'r', 531,
        's', 520,
        't', 511,
        'v', 507,
        'w', 556,
        '|', 368,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        '-', 51,
        '/', 38,
        '0', 886,
        '?', 908,
        '@', 264,
        '[', 490,
        '_', 404,
        'b', 530,
        'c', 307,
        'd', 554,
        'e', 615,
        'f', 517,
        'h', 502,
        'i', 548,
        'j', 605,
        'l', 503,
        'm', 504,
        'n', 505,
        'o', 597,
        'r', 531,
        's', 520,
        't', 511,
        'v', 506,
        'w', 556,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        '-', 51,
        '/', 38,
        '0', 886,
        '<', 491,
        '?', 908,
        '@', 264,
        '[', 490,
        '_', 404,
        'b', 530,
        'c', 307,
        'd', 554,
        'e', 615,
        'f', 518,
        'i', 582,
        'j', 605,
        'l', 503,
        'm', 509,
        'n', 595,
        'o', 598,
        'r', 540,
        's', 520,
        't', 511,
        'v', 514,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        '-', 51,
        '/', 38,
        '0', 886,
        '<', 491,
        '?', 908,
        '@', 264,
        '[', 490,
        '_', 404,
        'b', 529,
        'c', 306,
        'd', 554,
        'e', 615,
        'f', 519,
        'h', 502,
        'i', 548,
        'j', 605,
        'l', 503,
        'm', 504,
        'n', 505,
        'o', 597,
        'r', 508,
        's', 520,
        't', 511,
        'v', 506,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 427,
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        '-', 901,
        '/', 900,
        '0', 886,
        '?', 909,
        '@', 904,
        '[', 490,
        '_', 404,
        'b', 530,
        'c', 307,
        'd', 554,
        'e', 615,
        'f', 517,
        'h', 502,
        'i', 548,
        'j', 605,
        'l', 503,
        'm', 504,
        'n', 505,
        'o', 597,
        'r', 531,
        's', 520,
        't', 511,
        'v', 506,
        'w', 556,
        '~', 429,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('$' <= lookahead && lookahead <= '+') ||
          ('.' <= lookahead && lookahead <= ':') ||
          ('<' <= lookahead && lookahead <= '>') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '|') ADVANCE(903);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(915);
      if (lookahead == '/') ADVANCE(912);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(913);
      if (lookahead != 0) ADVANCE(914);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 50,
        '/', 38,
        '0', 886,
        ':', 286,
        '=', 276,
        '>', 366,
        '?', 908,
        '@', 264,
        '[', 490,
        ']', 365,
        '^', 439,
        '_', 405,
        'b', 640,
        'c', 311,
        'd', 655,
        'e', 700,
        'f', 633,
        'i', 676,
        'j', 693,
        'l', 623,
        'n', 686,
        'o', 689,
        'r', 641,
        's', 635,
        't', 628,
        'v', 624,
        '|', 368,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        '-', 51,
        '/', 38,
        '0', 886,
        '@', 264,
        '[', 490,
        '_', 405,
        'b', 640,
        'c', 311,
        'd', 655,
        'e', 700,
        'f', 633,
        'i', 676,
        'j', 693,
        'l', 623,
        'n', 686,
        'o', 689,
        'r', 641,
        's', 635,
        't', 628,
        'v', 624,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        '-', 901,
        '/', 900,
        '0', 886,
        '@', 904,
        '[', 490,
        '_', 405,
        'b', 640,
        'c', 311,
        'd', 655,
        'e', 700,
        'f', 633,
        'i', 676,
        'j', 693,
        'l', 623,
        'n', 686,
        'o', 689,
        'r', 641,
        's', 635,
        't', 628,
        'v', 624,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      if (set_contains(sym_qidop_character_set_1, 10, lookahead)) ADVANCE(903);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '"', 910,
        '(', 496,
        '-', 499,
        '.', 431,
        '/', 497,
        ':', 498,
        '<', 494,
        '>', 367,
        '[', 490,
        'c', 316,
        'e', 154,
        'f', 176,
        'i', 195,
        'j', 219,
        'm', 75,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('=' <= lookahead && lookahead <= '@') ||
          lookahead == '\\' ||
          lookahead == '^' ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 902,
        '/', 900,
        '<', 495,
        '@', 905,
        '[', 490,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 715,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      if (set_contains(sym_qidop_character_set_1, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 55,
        '/', 38,
        ':', 287,
        '<', 491,
        '=', 276,
        '>', 366,
        '@', 263,
        ']', 365,
        'b', 208,
        'c', 199,
        'f', 147,
        'h', 65,
        'i', 194,
        'l', 58,
        'p', 236,
        'r', 63,
        'v', 74,
        '|', 368,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 55,
        '/', 38,
        '<', 491,
        '@', 266,
        '[', 490,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 715,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 52,
        '/', 38,
        '0', 888,
        '<', 491,
        '>', 366,
        '@', 266,
        '[', 490,
        ']', 365,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 715,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(887);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 52,
        '/', 38,
        '0', 888,
        '?', 908,
        '@', 264,
        '_', 404,
        'b', 530,
        'c', 308,
        'd', 554,
        'e', 615,
        'f', 518,
        'i', 582,
        'j', 605,
        'l', 503,
        'n', 595,
        'o', 598,
        'r', 540,
        's', 520,
        't', 511,
        'v', 514,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(887);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '.', 431,
        '/', 497,
        ':', 498,
        '<', 494,
        '=', 277,
        '>', 367,
        '[', 490,
        ']', 365,
        'f', 176,
        'm', 75,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          ('*' <= lookahead && lookahead <= '-') ||
          lookahead == '?' ||
          lookahead == '@' ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 19:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '.', 431,
        '/', 497,
        ':', 498,
        '<', 494,
        '>', 367,
        '[', 490,
        ']', 365,
        'b', 208,
        'c', 232,
        'e', 155,
        'f', 83,
        'i', 177,
        'm', 75,
        'p', 236,
        'r', 63,
        't', 69,
        'v', 74,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          ('*' <= lookahead && lookahead <= '-') ||
          ('=' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 20:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '.', 431,
        '/', 497,
        ':', 289,
        '<', 494,
        '>', 367,
        '[', 490,
        ']', 365,
        'b', 208,
        'c', 232,
        'e', 154,
        'f', 146,
        'i', 194,
        'm', 75,
        'r', 63,
        'v', 74,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          ('*' <= lookahead && lookahead <= '-') ||
          ('=' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 21:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '/', 38,
        ':', 54,
        '<', 492,
        '=', 276,
        '>', 366,
        '@', 266,
        '[', 490,
        ']', 365,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 716,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
        'w', 744,
        '|', 368,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 22:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '/', 38,
        ':', 54,
        '<', 491,
        '=', 276,
        '>', 366,
        '@', 266,
        '[', 490,
        ']', 365,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 716,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
        'w', 744,
        '|', 368,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 23:
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        '/', 38,
        '@', 266,
        '^', 439,
        '_', 405,
        'b', 640,
        'c', 311,
        'd', 655,
        'e', 700,
        'f', 633,
        'i', 676,
        'j', 693,
        'l', 623,
        'n', 686,
        'o', 689,
        'p', 696,
        'r', 641,
        's', 635,
        't', 628,
        'v', 624,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        '(', 496,
        '.', 431,
        '/', 497,
        ':', 289,
        '<', 493,
        '>', 367,
        '[', 490,
        'f', 176,
        'i', 177,
        'm', 75,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '(', 496,
        '/', 38,
        '<', 491,
        '@', 266,
        '[', 490,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 715,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 717,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '(', 496,
        '/', 38,
        '<', 491,
        '@', 266,
        '[', 490,
        '_', 405,
        'b', 731,
        'c', 312,
        'd', 741,
        'e', 789,
        'f', 716,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        '(', 496,
        '/', 38,
        '<', 491,
        '@', 266,
        '[', 490,
        'b', 640,
        'c', 309,
        'd', 655,
        'e', 700,
        'f', 633,
        'i', 676,
        'j', 693,
        'l', 623,
        'n', 686,
        'o', 689,
        'r', 641,
        's', 635,
        't', 628,
        'v', 624,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 28:
      ADVANCE_MAP(
        '(', 496,
        '/', 38,
        '@', 266,
        'b', 815,
        'c', 314,
        'd', 824,
        'e', 867,
        'f', 803,
        'i', 841,
        'j', 861,
        'l', 797,
        'n', 852,
        'o', 856,
        'r', 814,
        's', 804,
        't', 801,
        'v', 799,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 29:
      ADVANCE_MAP(
        '(', 496,
        '/', 38,
        '@', 266,
        'b', 815,
        'c', 314,
        'd', 824,
        'e', 867,
        'f', 803,
        'i', 842,
        'j', 861,
        'l', 797,
        'n', 852,
        'o', 856,
        'r', 814,
        's', 804,
        't', 801,
        'v', 799,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 30:
      if (lookahead == '(') ADVANCE(496);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '@') ADVANCE(266);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 31:
      if (lookahead == '(') ADVANCE(48);
      if (lookahead == '@') ADVANCE(265);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(461);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(892);
      END_STATE();
    case 32:
      if (lookahead == '(') ADVANCE(48);
      if (lookahead == '@') ADVANCE(267);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(898);
      END_STATE();
    case 33:
      ADVANCE_MAP(
        ')', 290,
        ',', 374,
        '-', 55,
        '/', 38,
        ':', 288,
        '<', 40,
        '=', 276,
        '>', 366,
        ']', 365,
        'e', 154,
        'i', 177,
        'w', 140,
        '|', 368,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33);
      END_STATE();
    case 34:
      ADVANCE_MAP(
        ')', 290,
        ',', 374,
        '/', 497,
        ':', 498,
        '<', 494,
        '>', 367,
        ']', 365,
        'e', 154,
        'i', 177,
        'r', 123,
        't', 135,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          ('*' <= lookahead && lookahead <= '.') ||
          ('=' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 35:
      ADVANCE_MAP(
        ')', 290,
        ',', 374,
        '/', 497,
        ':', 289,
        '<', 494,
        '>', 367,
        ']', 365,
        'e', 154,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          ('*' <= lookahead && lookahead <= '.') ||
          ('=' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 36:
      if (lookahead == ')') ADVANCE(899);
      END_STATE();
    case 37:
      if (lookahead == ')') ADVANCE(899);
      if (set_contains(sym_qidop_character_set_1, 10, lookahead)) ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(875);
      if (lookahead == '/') ADVANCE(874);
      END_STATE();
    case 39:
      if (lookahead == '*') ADVANCE(47);
      if (lookahead == '/') ADVANCE(878);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(879);
      if (lookahead != 0) ADVANCE(877);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(474);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == ':') ADVANCE(53);
      if (lookahead == '<') ADVANCE(491);
      if (lookahead == 'i') ADVANCE(177);
      if (lookahead == 'w') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41);
      END_STATE();
    case 42:
      if (lookahead == '-') ADVANCE(499);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(498);
      if (lookahead == '<') ADVANCE(494);
      if (lookahead == '>') ADVANCE(367);
      if (lookahead == 'e') ADVANCE(154);
      if (lookahead == '|') ADVANCE(369);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 43:
      ADVANCE_MAP(
        '/', 38,
        ':', 53,
        '<', 491,
        '@', 266,
        'b', 640,
        'c', 310,
        'd', 655,
        'e', 700,
        'f', 634,
        'i', 676,
        'j', 693,
        'l', 623,
        'n', 686,
        'o', 689,
        'p', 696,
        'r', 625,
        's', 635,
        't', 628,
        'v', 629,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 44:
      ADVANCE_MAP(
        '/', 38,
        '@', 266,
        'b', 731,
        'c', 313,
        'd', 741,
        'e', 789,
        'f', 716,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 45:
      ADVANCE_MAP(
        '/', 38,
        '@', 266,
        'b', 731,
        'c', 313,
        'd', 741,
        'e', 790,
        'f', 716,
        'i', 763,
        'j', 781,
        'l', 708,
        'n', 773,
        'o', 776,
        'r', 730,
        's', 718,
        't', 712,
        'v', 710,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 46:
      if (lookahead == '/') ADVANCE(880);
      END_STATE();
    case 47:
      if (lookahead == '/') ADVANCE(880);
      if (lookahead != 0) ADVANCE(877);
      END_STATE();
    case 48:
      if (lookahead == '/') ADVANCE(36);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(37);
      END_STATE();
    case 49:
      if (lookahead == '/') ADVANCE(918);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(917);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(917);
      END_STATE();
    case 50:
      if (lookahead == '0') ADVANCE(886);
      if (lookahead == '>') ADVANCE(375);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      END_STATE();
    case 51:
      if (lookahead == '0') ADVANCE(886);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      END_STATE();
    case 52:
      if (lookahead == '0') ADVANCE(888);
      if (lookahead == '>') ADVANCE(375);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(887);
      END_STATE();
    case 53:
      if (lookahead == ':') ADVANCE(489);
      END_STATE();
    case 54:
      if (lookahead == ':') ADVANCE(489);
      if (lookahead == '=') ADVANCE(413);
      END_STATE();
    case 55:
      if (lookahead == '>') ADVANCE(375);
      END_STATE();
    case 56:
      if (lookahead == '@') ADVANCE(267);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(896);
      END_STATE();
    case 57:
      ADVANCE_MAP(
        'U', 262,
        'u', 260,
        'x', 258,
        '"', 873,
        '\'', 873,
        '\\', 873,
        'n', 873,
        'r', 873,
        't', 873,
      );
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(246);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(246);
      if (lookahead == 'i') ADVANCE(190);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(221);
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(174);
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(241);
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(241);
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(159);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(161);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(220);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(167);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(137);
      if (lookahead == 'h') ADVANCE(120);
      if (lookahead == 'y') ADVANCE(206);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(137);
      if (lookahead == 'y') ADVANCE(206);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(158);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(163);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(223);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(164);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(90);
      END_STATE();
    case 79:
      if (lookahead == 'b') ADVANCE(278);
      END_STATE();
    case 80:
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(141);
      END_STATE();
    case 81:
      if (lookahead == 'b') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(141);
      if (lookahead == 's') ADVANCE(464);
      END_STATE();
    case 82:
      if (lookahead == 'b') ADVANCE(142);
      if (lookahead == 'i') ADVANCE(166);
      if (lookahead == 'n') ADVANCE(417);
      if (lookahead == 'o') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(142);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == 'n') ADVANCE(417);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 84:
      if (lookahead == 'b') ADVANCE(142);
      if (lookahead == 'i') ADVANCE(203);
      if (lookahead == 'n') ADVANCE(417);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 85:
      if (lookahead == 'b') ADVANCE(142);
      if (lookahead == 'i') ADVANCE(203);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(200);
      if (lookahead == 'o') ADVANCE(175);
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(224);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(227);
      END_STATE();
    case 91:
      if (lookahead == 'c') ADVANCE(112);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(321);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(434);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(329);
      END_STATE();
    case 95:
      if (lookahead == 'd') ADVANCE(445);
      END_STATE();
    case 96:
      if (lookahead == 'd') ADVANCE(239);
      END_STATE();
    case 97:
      if (lookahead == 'd') ADVANCE(170);
      END_STATE();
    case 98:
      if (lookahead == 'd') ADVANCE(111);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(425);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(440);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(487);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(318);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(349);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(468);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(389);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(469);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(354);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(213);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 125:
      if (lookahead == 'f') ADVANCE(130);
      if (lookahead == 'l') ADVANCE(139);
      if (lookahead == 'x') ADVANCE(231);
      END_STATE();
    case 126:
      if (lookahead == 'f') ADVANCE(421);
      if (lookahead == 'm') ADVANCE(205);
      if (lookahead == 'n') ADVANCE(323);
      END_STATE();
    case 127:
      if (lookahead == 'f') ADVANCE(359);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(359);
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 129:
      if (lookahead == 'f') ADVANCE(424);
      END_STATE();
    case 130:
      if (lookahead == 'f') ADVANCE(114);
      END_STATE();
    case 131:
      if (lookahead == 'f') ADVANCE(138);
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 132:
      if (lookahead == 'h') ADVANCE(471);
      END_STATE();
    case 133:
      if (lookahead == 'h') ADVANCE(415);
      END_STATE();
    case 134:
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 135:
      if (lookahead == 'h') ADVANCE(120);
      END_STATE();
    case 136:
      if (lookahead == 'i') ADVANCE(240);
      END_STATE();
    case 137:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 138:
      if (lookahead == 'i') ADVANCE(242);
      END_STATE();
    case 139:
      if (lookahead == 'i') ADVANCE(129);
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 141:
      if (lookahead == 'i') ADVANCE(67);
      END_STATE();
    case 142:
      if (lookahead == 'i') ADVANCE(204);
      END_STATE();
    case 143:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(235);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == 'n') ADVANCE(417);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 152:
      if (lookahead == 'k') ADVANCE(476);
      END_STATE();
    case 153:
      if (lookahead == 'k') ADVANCE(432);
      END_STATE();
    case 154:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 155:
      if (lookahead == 'l') ADVANCE(139);
      if (lookahead == 'x') ADVANCE(234);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(386);
      END_STATE();
    case 157:
      if (lookahead == 'l') ADVANCE(386);
      if (lookahead == 'x') ADVANCE(370);
      END_STATE();
    case 158:
      if (lookahead == 'l') ADVANCE(382);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(382);
      if (lookahead == 'r') ADVANCE(411);
      END_STATE();
    case 160:
      if (lookahead == 'l') ADVANCE(406);
      END_STATE();
    case 161:
      if (lookahead == 'l') ADVANCE(481);
      END_STATE();
    case 162:
      if (lookahead == 'l') ADVANCE(485);
      END_STATE();
    case 163:
      if (lookahead == 'l') ADVANCE(379);
      END_STATE();
    case 164:
      if (lookahead == 'l') ADVANCE(478);
      END_STATE();
    case 165:
      if (lookahead == 'l') ADVANCE(245);
      END_STATE();
    case 166:
      if (lookahead == 'l') ADVANCE(104);
      if (lookahead == 'n') ADVANCE(66);
      if (lookahead == 'p') ADVANCE(394);
      END_STATE();
    case 167:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(149);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 171:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 172:
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 173:
      if (lookahead == 'm') ADVANCE(205);
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 174:
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 175:
      if (lookahead == 'm') ADVANCE(105);
      END_STATE();
    case 176:
      if (lookahead == 'n') ADVANCE(417);
      END_STATE();
    case 177:
      if (lookahead == 'n') ADVANCE(323);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(383);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(324);
      END_STATE();
    case 180:
      if (lookahead == 'n') ADVANCE(423);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(284);
      END_STATE();
    case 182:
      if (lookahead == 'n') ADVANCE(419);
      END_STATE();
    case 183:
      if (lookahead == 'n') ADVANCE(378);
      END_STATE();
    case 184:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 186:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 187:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 188:
      if (lookahead == 'n') ADVANCE(94);
      if (lookahead == 'r') ADVANCE(181);
      END_STATE();
    case 189:
      if (lookahead == 'n') ADVANCE(168);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 191:
      if (lookahead == 'n') ADVANCE(76);
      if (lookahead == 'p') ADVANCE(394);
      END_STATE();
    case 192:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 193:
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 194:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 196:
      if (lookahead == 'o') ADVANCE(334);
      END_STATE();
    case 197:
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(212);
      END_STATE();
    case 199:
      if (lookahead == 'o') ADVANCE(183);
      if (lookahead == 't') ADVANCE(156);
      END_STATE();
    case 200:
      if (lookahead == 'o') ADVANCE(207);
      END_STATE();
    case 201:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 202:
      if (lookahead == 'p') ADVANCE(118);
      if (lookahead == 'v') ADVANCE(116);
      END_STATE();
    case 203:
      if (lookahead == 'p') ADVANCE(394);
      END_STATE();
    case 204:
      if (lookahead == 'p') ADVANCE(399);
      END_STATE();
    case 205:
      if (lookahead == 'p') ADVANCE(198);
      END_STATE();
    case 206:
      if (lookahead == 'p') ADVANCE(106);
      END_STATE();
    case 207:
      if (lookahead == 'p') ADVANCE(121);
      END_STATE();
    case 208:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 209:
      if (lookahead == 'r') ADVANCE(360);
      END_STATE();
    case 210:
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 211:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 212:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 213:
      if (lookahead == 'r') ADVANCE(217);
      END_STATE();
    case 214:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 215:
      if (lookahead == 'r') ADVANCE(181);
      END_STATE();
    case 216:
      if (lookahead == 'r') ADVANCE(182);
      END_STATE();
    case 217:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(122);
      END_STATE();
    case 219:
      if (lookahead == 's') ADVANCE(301);
      END_STATE();
    case 220:
      if (lookahead == 's') ADVANCE(317);
      END_STATE();
    case 221:
      if (lookahead == 's') ADVANCE(153);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 222:
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 223:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 224:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 225:
      if (lookahead == 't') ADVANCE(274);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(319);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 228:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 229:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 231:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 232:
      if (lookahead == 't') ADVANCE(156);
      END_STATE();
    case 233:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(150);
      END_STATE();
    case 236:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 237:
      if (lookahead == 'u') ADVANCE(216);
      END_STATE();
    case 238:
      if (lookahead == 'u') ADVANCE(89);
      END_STATE();
    case 239:
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 240:
      if (lookahead == 'v') ADVANCE(339);
      END_STATE();
    case 241:
      if (lookahead == 'w') ADVANCE(482);
      END_STATE();
    case 242:
      if (lookahead == 'x') ADVANCE(280);
      END_STATE();
    case 243:
      if (lookahead == 'y') ADVANCE(344);
      END_STATE();
    case 244:
      if (lookahead == 'y') ADVANCE(455);
      END_STATE();
    case 245:
      if (lookahead == 'y') ADVANCE(450);
      END_STATE();
    case 246:
      if (lookahead == 'z') ADVANCE(243);
      END_STATE();
    case 247:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(882);
      END_STATE();
    case 248:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(884);
      END_STATE();
    case 249:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(885);
      END_STATE();
    case 250:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(881);
      END_STATE();
    case 251:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(882);
      END_STATE();
    case 252:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(884);
      END_STATE();
    case 253:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(887);
      END_STATE();
    case 254:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(873);
      END_STATE();
    case 255:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(889);
      END_STATE();
    case 256:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(883);
      END_STATE();
    case 257:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(890);
      END_STATE();
    case 258:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(254);
      END_STATE();
    case 259:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(258);
      END_STATE();
    case 260:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(259);
      END_STATE();
    case 261:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(260);
      END_STATE();
    case 262:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(261);
      END_STATE();
    case 263:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 264:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 265:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(461);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 266:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 267:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 268:
      if (eof) ADVANCE(272);
      ADVANCE_MAP(
        '!', 426,
        '"', 910,
        '\'', 916,
        '(', 496,
        ')', 290,
        '*', 46,
        ',', 374,
        '-', 50,
        '.', 430,
        '/', 38,
        '0', 886,
        ':', 288,
        '<', 492,
        '=', 276,
        '>', 366,
        '?', 908,
        '@', 263,
        '[', 490,
        ']', 365,
        '^', 439,
        '_', 405,
        'a', 81,
        'b', 100,
        'c', 315,
        'd', 136,
        'e', 125,
        'f', 82,
        'h', 65,
        'i', 126,
        'j', 219,
        'l', 59,
        'm', 60,
        'n', 61,
        'o', 202,
        'p', 236,
        'r', 62,
        's', 86,
        't', 70,
        'v', 64,
        'w', 140,
        '|', 368,
        '~', 428,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(268);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      END_STATE();
    case 269:
      if (eof) ADVANCE(272);
      ADVANCE_MAP(
        '"', 910,
        '\'', 919,
        '(', 496,
        ')', 290,
        ',', 374,
        '.', 431,
        '/', 497,
        ':', 498,
        '<', 494,
        '>', 367,
        '[', 490,
        ']', 365,
        'a', 80,
        'c', 196,
        'd', 136,
        'e', 125,
        'f', 84,
        'i', 173,
        'l', 59,
        'm', 197,
        'n', 61,
        'o', 201,
        'p', 236,
        'r', 101,
        's', 229,
        't', 70,
        'v', 72,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(270);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '-') ||
          ('=' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 270:
      if (eof) ADVANCE(272);
      ADVANCE_MAP(
        '"', 910,
        '(', 496,
        ')', 290,
        ',', 374,
        '.', 431,
        '/', 497,
        ':', 498,
        '<', 494,
        '>', 367,
        '[', 490,
        ']', 365,
        'a', 80,
        'c', 196,
        'd', 136,
        'e', 125,
        'f', 84,
        'i', 173,
        'l', 59,
        'm', 197,
        'n', 61,
        'o', 201,
        'p', 236,
        'r', 101,
        's', 229,
        't', 70,
        'v', 72,
        '|', 369,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(270);
      if (lookahead == '!' ||
          ('$' <= lookahead && lookahead <= '&') ||
          ('*' <= lookahead && lookahead <= '-') ||
          ('=' <= lookahead && lookahead <= '@') ||
          ('\\' <= lookahead && lookahead <= '^') ||
          lookahead == '~') ADVANCE(500);
      END_STATE();
    case 271:
      if (eof) ADVANCE(272);
      ADVANCE_MAP(
        '(', 496,
        ')', 290,
        ',', 374,
        '-', 55,
        '/', 38,
        ':', 288,
        '<', 491,
        '=', 276,
        '>', 366,
        ']', 365,
        'a', 81,
        'b', 99,
        'c', 196,
        'd', 136,
        'e', 125,
        'f', 85,
        'i', 173,
        'l', 59,
        'n', 61,
        'o', 201,
        'p', 236,
        'r', 115,
        's', 229,
        't', 71,
        'v', 72,
        'w', 140,
        '|', 368,
      );
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(271);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_pub);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_pub);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_infix);
      if (lookahead == 'l') ADVANCE(282);
      if (lookahead == 'r') ADVANCE(281);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_infixr);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_infixl);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_extern);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(489);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(489);
      if (lookahead == '=') ADVANCE(413);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(414);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_inline);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_cs);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_cs);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_cs);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_cs);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_cs);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_js);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_js);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_js);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_js);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_js);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(335);
      if (lookahead == 's') ADVANCE(297);
      if (lookahead == 't') ADVANCE(570);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(335);
      if (lookahead == 's') ADVANCE(297);
      if (lookahead == 't') ADVANCE(616);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(335);
      if (lookahead == 's') ADVANCE(297);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'o') ADVANCE(336);
      if (lookahead == 's') ADVANCE(298);
      if (lookahead == 't') ADVANCE(701);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'o') ADVANCE(336);
      if (lookahead == 's') ADVANCE(298);
      if (lookahead == 't') ADVANCE(666);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'o') ADVANCE(336);
      if (lookahead == 's') ADVANCE(298);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(337);
      if (lookahead == 's') ADVANCE(299);
      if (lookahead == 't') ADVANCE(788);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(337);
      if (lookahead == 's') ADVANCE(299);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(338);
      if (lookahead == 's') ADVANCE(300);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == 'o') ADVANCE(334);
      if (lookahead == 's') ADVANCE(296);
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_c);
      if (lookahead == 's') ADVANCE(296);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_effect);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_named);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_named);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_open);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_extend);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_extend);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_extend);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_extend);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_extend);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_co);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_co);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_co);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_co);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_co);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_div);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_div);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_div);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_div);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_div);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_lazy);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_lazy);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_value);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_value);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_value);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_value);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_value);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_reference);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_reference);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_reference);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_reference);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_reference);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_ref);
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_linear);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_linear);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_linear);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_linear);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_linear);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_GT);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_ctx);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_ctx);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_ctx);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_ctx);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_con);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_val);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_val);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(534);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_val);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'u') ADVANCE(644);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_val);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_fun);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_fun);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_fun);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_ctl);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_ctl);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_ctl);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_noinline);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_noinline);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_noinline);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_noinline);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_noinline);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_fip);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_fip);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_fip);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_fip);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_fip);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_fbip);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_fbip);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_fbip);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_fbip);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_fbip);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(907);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_tail);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_tail);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_tail);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_tail);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_tail);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_var);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_match);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_fn);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_mask);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_mask);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_behind);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_behind);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_behind);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_behind);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_behind);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_borrow);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_file);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_file);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_file);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_file);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_file);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_scoped);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_scoped);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_scoped);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_scoped);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_scoped);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_initially);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_initially);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_initially);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_initially);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_initially);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_finally);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_finally);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_finally);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_finally);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_qconid);
      if (lookahead == '\'') ADVANCE(460);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_qconid);
      if (lookahead == '\'') ADVANCE(460);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(461);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_conid);
      if (lookahead == '\'') ADVANCE(462);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_conid);
      if (lookahead == '\'') ADVANCE(462);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(463);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_handler);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_handler);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_handle);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(466);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_handle);
      if (lookahead == 'r') ADVANCE(465);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_override);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_override);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_with);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_with);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_brk);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_brk);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_final);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(618);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(703);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_raw);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_raw);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_raw);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_forall);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_some);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_some);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(474);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(475);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_LT);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_LT);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym__symbols);
      if (lookahead == '*') ADVANCE(875);
      if (lookahead == '/') ADVANCE(874);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym__symbols);
      if (lookahead == '=') ADVANCE(414);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym__symbols);
      if (lookahead == '>') ADVANCE(376);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym__symbols);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(500);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(583);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(620);
      if (lookahead == 'i') ADVANCE(591);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(606);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(581);
      if (lookahead == 'o') ADVANCE(559);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(568);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(567);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(614);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(607);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(577);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(557);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(600);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(571);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(573);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(578);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(555);
      if (lookahead == 'i') ADVANCE(575);
      if (lookahead == 'n') ADVANCE(418);
      if (lookahead == 'u') ADVANCE(586);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(555);
      if (lookahead == 'i') ADVANCE(575);
      if (lookahead == 'n') ADVANCE(418);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(555);
      if (lookahead == 'i') ADVANCE(575);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(555);
      if (lookahead == 'i') ADVANCE(576);
      if (lookahead == 'n') ADVANCE(418);
      if (lookahead == 'u') ADVANCE(586);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'c') ADVANCE(594);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'c') ADVANCE(552);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'c') ADVANCE(539);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(322);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(435);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(330);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(446);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(579);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'd') ADVANCE(538);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(553);
      if (lookahead == 'r') ADVANCE(566);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(553);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(601);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(441);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(350);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(467);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(292);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(390);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(470);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(355);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(550);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(523);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(604);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(584);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(526);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(512);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(587);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(589);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(422);
      if (lookahead == 'n') ADVANCE(558);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(542);
      if (lookahead == 't') ADVANCE(611);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(542);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'h') ADVANCE(472);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'h') ADVANCE(416);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'h') ADVANCE(561);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(613);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(596);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(608);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(569);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(610);
      if (lookahead == 'l') ADVANCE(562);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(590);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(528);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(588);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(592);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(515);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(593);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'k') ADVANCE(433);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'k') ADVANCE(477);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(380);
      if (lookahead == 'r') ADVANCE(412);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(380);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(407);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(387);
      if (lookahead == 'x') ADVANCE(371);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(479);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(618);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(612);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(619);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(533);
      if (lookahead == 'n') ADVANCE(510);
      if (lookahead == 'p') ADVANCE(395);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(533);
      if (lookahead == 'n') ADVANCE(513);
      if (lookahead == 'p') ADVANCE(395);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(572);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(574);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(535);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(564);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'm') ADVANCE(541);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(558);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(527);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(325);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(420);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(384);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(522);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(524);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(525);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(580);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(545);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(536);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(537);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(599);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(559);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'p') ADVANCE(400);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'p') ADVANCE(543);
      if (lookahead == 'v') ADVANCE(532);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'p') ADVANCE(543);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'p') ADVANCE(544);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(361);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(603);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(585);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(560);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(546);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 's') ADVANCE(302);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 's') ADVANCE(565);
      if (lookahead == 't') ADVANCE(521);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 's') ADVANCE(565);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 't') ADVANCE(551);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 't') ADVANCE(547);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 't') ADVANCE(563);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(602);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(534);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'v') ADVANCE(340);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'w') ADVANCE(483);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(609);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(371);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(345);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(456);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(451);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == 'z') ADVANCE(617);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(621);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(501);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(621);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(705);
      if (lookahead == 'i') ADVANCE(683);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(664);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(699);
      if (lookahead == 'e') ADVANCE(653);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(691);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(673);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(658);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(668);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'b') ADVANCE(656);
      if (lookahead == 'i') ADVANCE(671);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'b') ADVANCE(656);
      if (lookahead == 'i') ADVANCE(672);
      if (lookahead == 'u') ADVANCE(679);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'c') ADVANCE(687);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'c') ADVANCE(647);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'd') ADVANCE(436);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'd') ADVANCE(331);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'd') ADVANCE(447);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(654);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(653);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(442);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(692);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(351);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(293);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(391);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(356);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(639);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(677);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(626);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(681);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'e') ADVANCE(680);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'f') ADVANCE(643);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'h') ADVANCE(660);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(698);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(688);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(694);
      if (lookahead == 'l') ADVANCE(661);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(665);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(682);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(678);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(684);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(685);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'i') ADVANCE(631);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(697);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(408);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(388);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(381);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(480);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(703);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(704);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(642);
      if (lookahead == 'n') ADVANCE(627);
      if (lookahead == 'p') ADVANCE(396);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(642);
      if (lookahead == 'n') ADVANCE(630);
      if (lookahead == 'p') ADVANCE(396);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(669);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(670);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'l') ADVANCE(662);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(657);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(326);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(637);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(385);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(636);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(638);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(675);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(650);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(645);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'n') ADVANCE(646);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'o') ADVANCE(659);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'o') ADVANCE(690);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'p') ADVANCE(401);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'p') ADVANCE(649);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'p') ADVANCE(648);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'r') ADVANCE(362);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'r') ADVANCE(652);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 's') ADVANCE(303);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 't') ADVANCE(663);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 't') ADVANCE(651);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'u') ADVANCE(632);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'u') ADVANCE(644);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'v') ADVANCE(341);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'w') ADVANCE(484);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'x') ADVANCE(695);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'x') ADVANCE(372);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'y') ADVANCE(346);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'y') ADVANCE(457);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'y') ADVANCE(452);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == 'z') ADVANCE(702);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(706);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(794);
      if (lookahead == 'i') ADVANCE(770);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(753);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(756);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(746);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(757);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'a') ADVANCE(758);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'b') ADVANCE(742);
      if (lookahead == 'i') ADVANCE(759);
      if (lookahead == 'o') ADVANCE(780);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'b') ADVANCE(742);
      if (lookahead == 'i') ADVANCE(759);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(774);
      if (lookahead == 'o') ADVANCE(761);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(774);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(729);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'd') ADVANCE(437);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'd') ADVANCE(332);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'd') ADVANCE(448);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(488);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(767);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(443);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(352);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(294);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(392);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(738);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(740);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(779);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(722);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(764);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(709);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(768);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'e') ADVANCE(765);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'f') ADVANCE(732);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'h') ADVANCE(473);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'h') ADVANCE(747);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(787);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(775);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(783);
      if (lookahead == 'l') ADVANCE(748);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(782);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(769);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(752);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(766);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(771);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(772);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(714);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(486);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(409);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(786);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(792);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(793);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(754);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(751);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(755);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(725);
      if (lookahead == 'n') ADVANCE(711);
      if (lookahead == 'p') ADVANCE(397);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'l') ADVANCE(749);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'm') ADVANCE(723);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(285);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(743);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(327);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(719);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(720);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(721);
      if (lookahead == 'r') ADVANCE(762);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(721);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(760);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(735);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(727);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(728);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(745);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(777);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'p') ADVANCE(402);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'p') ADVANCE(734);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'p') ADVANCE(733);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(363);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(737);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(713);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 's') ADVANCE(304);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 't') ADVANCE(739);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 't') ADVANCE(750);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 't') ADVANCE(736);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 't') ADVANCE(724);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(726);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(342);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'x') ADVANCE(373);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'x') ADVANCE(784);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'x') ADVANCE(785);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(347);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(458);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(453);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == 'z') ADVANCE(791);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(795);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(707);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(795);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(871);
      if (lookahead == 'i') ADVANCE(848);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(858);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(834);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(837);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(828);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'a') ADVANCE(838);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'b') ADVANCE(825);
      if (lookahead == 'i') ADVANCE(839);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'c') ADVANCE(853);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'c') ADVANCE(813);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'd') ADVANCE(438);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'd') ADVANCE(333);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'd') ADVANCE(449);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(444);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(353);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(295);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(393);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(358);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(822);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(823);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(860);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(808);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(798);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(843);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(846);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(844);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'f') ADVANCE(816);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'h') ADVANCE(829);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(866);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(854);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(863);
      if (lookahead == 'l') ADVANCE(830);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(847);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(833);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(845);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(849);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(802);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(850);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(410);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(865);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(869);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(870);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(835);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(836);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(809);
      if (lookahead == 'n') ADVANCE(800);
      if (lookahead == 'p') ADVANCE(398);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(832);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'm') ADVANCE(855);
      if (lookahead == 'n') ADVANCE(826);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(826);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(328);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(805);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(806);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(807);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(840);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(818);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(811);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(812);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(859);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(827);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(857);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'p') ADVANCE(403);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'p') ADVANCE(851);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'p') ADVANCE(819);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'p') ADVANCE(817);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(364);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(862);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(821);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 's') ADVANCE(305);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 't') ADVANCE(275);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 't') ADVANCE(831);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 't') ADVANCE(820);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(810);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'v') ADVANCE(343);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(864);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'y') ADVANCE(348);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'y') ADVANCE(459);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'y') ADVANCE(454);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == 'z') ADVANCE(868);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(872);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_id);
      if (lookahead == '\'') ADVANCE(796);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(872);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_escape);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_linecomment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(874);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(914);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(aux_sym_blockcomment_token1);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(aux_sym_blockcomment_token1);
      if (lookahead == '*') ADVANCE(875);
      if (lookahead == '/') ADVANCE(874);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(aux_sym_blockcomment_token1);
      if (lookahead == '*') ADVANCE(47);
      if (lookahead == '/') ADVANCE(878);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(879);
      if (lookahead != 0) ADVANCE(877);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(anon_sym_STAR_SLASH);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(aux_sym_float_token1);
      if (lookahead == '_') ADVANCE(250);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(881);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(aux_sym_float_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(882);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(aux_sym_float_token2);
      if (lookahead == '_') ADVANCE(256);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(883);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(aux_sym_float_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(884);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(aux_sym_int_token1);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == '_') ADVANCE(249);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(885);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(aux_sym_int_token1);
      if (lookahead == '.') ADVANCE(250);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(247);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(255);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(aux_sym_int_token1);
      if (lookahead == '_') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(887);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(aux_sym_int_token1);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(257);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(aux_sym_int_token2);
      if (lookahead == '.') ADVANCE(256);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(889);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(aux_sym_int_token2);
      if (lookahead == '_') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(890);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(891);
      if (lookahead == '/') ADVANCE(31);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(891);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(892);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(893);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(893);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(894);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(895);
      if (lookahead == '/') ADVANCE(56);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(895);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(896);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(897);
      if (lookahead == '/') ADVANCE(32);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_qid);
      if (lookahead == '\'') ADVANCE(897);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(898);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_qidop);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(aux_sym_idop_token1);
      if (lookahead == '*') ADVANCE(875);
      if (lookahead == '/') ADVANCE(874);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(aux_sym_idop_token1);
      if (lookahead == '0') ADVANCE(886);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(885);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(aux_sym_idop_token1);
      if (lookahead == '>') ADVANCE(377);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(aux_sym_idop_token1);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(aux_sym_idop_token1);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(463);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(aux_sym_idop_token1);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(706);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_RPAREN2);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym__WILDCARDID);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(907);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (set_contains(sym__symbols_character_set_2, 10, lookahead)) ADVANCE(903);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(914);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(874);
      if (lookahead != 0) ADVANCE(911);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(876);
      if (lookahead == '/') ADVANCE(911);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(914);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(912);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(913);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(914);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(914);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym_char_token1);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(aux_sym_char_token1);
      if (lookahead == '*') ADVANCE(875);
      if (lookahead == '/') ADVANCE(874);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(anon_sym_SQUOTE2);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 269, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 3},
  [3] = {.lex_state = 2, .external_lex_state = 3},
  [4] = {.lex_state = 2, .external_lex_state = 3},
  [5] = {.lex_state = 2, .external_lex_state = 3},
  [6] = {.lex_state = 3, .external_lex_state = 4},
  [7] = {.lex_state = 2, .external_lex_state = 3},
  [8] = {.lex_state = 2, .external_lex_state = 3},
  [9] = {.lex_state = 2, .external_lex_state = 3},
  [10] = {.lex_state = 3, .external_lex_state = 4},
  [11] = {.lex_state = 2, .external_lex_state = 3},
  [12] = {.lex_state = 2, .external_lex_state = 3},
  [13] = {.lex_state = 2, .external_lex_state = 3},
  [14] = {.lex_state = 3, .external_lex_state = 4},
  [15] = {.lex_state = 2, .external_lex_state = 3},
  [16] = {.lex_state = 2, .external_lex_state = 3},
  [17] = {.lex_state = 2, .external_lex_state = 3},
  [18] = {.lex_state = 3, .external_lex_state = 4},
  [19] = {.lex_state = 2, .external_lex_state = 3},
  [20] = {.lex_state = 2, .external_lex_state = 3},
  [21] = {.lex_state = 2, .external_lex_state = 3},
  [22] = {.lex_state = 3, .external_lex_state = 4},
  [23] = {.lex_state = 2, .external_lex_state = 3},
  [24] = {.lex_state = 2, .external_lex_state = 3},
  [25] = {.lex_state = 2, .external_lex_state = 3},
  [26] = {.lex_state = 2, .external_lex_state = 3},
  [27] = {.lex_state = 2, .external_lex_state = 3},
  [28] = {.lex_state = 2, .external_lex_state = 3},
  [29] = {.lex_state = 2, .external_lex_state = 3},
  [30] = {.lex_state = 3, .external_lex_state = 4},
  [31] = {.lex_state = 2, .external_lex_state = 3},
  [32] = {.lex_state = 2, .external_lex_state = 3},
  [33] = {.lex_state = 2, .external_lex_state = 3},
  [34] = {.lex_state = 2, .external_lex_state = 3},
  [35] = {.lex_state = 2, .external_lex_state = 3},
  [36] = {.lex_state = 2, .external_lex_state = 3},
  [37] = {.lex_state = 2, .external_lex_state = 3},
  [38] = {.lex_state = 2, .external_lex_state = 3},
  [39] = {.lex_state = 2, .external_lex_state = 3},
  [40] = {.lex_state = 2, .external_lex_state = 3},
  [41] = {.lex_state = 2, .external_lex_state = 3},
  [42] = {.lex_state = 2, .external_lex_state = 3},
  [43] = {.lex_state = 2, .external_lex_state = 3},
  [44] = {.lex_state = 2, .external_lex_state = 3},
  [45] = {.lex_state = 2, .external_lex_state = 3},
  [46] = {.lex_state = 2, .external_lex_state = 3},
  [47] = {.lex_state = 2, .external_lex_state = 3},
  [48] = {.lex_state = 2, .external_lex_state = 3},
  [49] = {.lex_state = 2, .external_lex_state = 3},
  [50] = {.lex_state = 2, .external_lex_state = 3},
  [51] = {.lex_state = 2, .external_lex_state = 3},
  [52] = {.lex_state = 2, .external_lex_state = 3},
  [53] = {.lex_state = 2, .external_lex_state = 3},
  [54] = {.lex_state = 2, .external_lex_state = 3},
  [55] = {.lex_state = 2, .external_lex_state = 3},
  [56] = {.lex_state = 2, .external_lex_state = 3},
  [57] = {.lex_state = 2, .external_lex_state = 3},
  [58] = {.lex_state = 2, .external_lex_state = 3},
  [59] = {.lex_state = 2, .external_lex_state = 3},
  [60] = {.lex_state = 2, .external_lex_state = 3},
  [61] = {.lex_state = 2, .external_lex_state = 3},
  [62] = {.lex_state = 2, .external_lex_state = 3},
  [63] = {.lex_state = 2, .external_lex_state = 3},
  [64] = {.lex_state = 2, .external_lex_state = 3},
  [65] = {.lex_state = 2, .external_lex_state = 3},
  [66] = {.lex_state = 2, .external_lex_state = 3},
  [67] = {.lex_state = 2, .external_lex_state = 3},
  [68] = {.lex_state = 2, .external_lex_state = 3},
  [69] = {.lex_state = 2, .external_lex_state = 3},
  [70] = {.lex_state = 2, .external_lex_state = 3},
  [71] = {.lex_state = 2, .external_lex_state = 3},
  [72] = {.lex_state = 2, .external_lex_state = 3},
  [73] = {.lex_state = 2, .external_lex_state = 3},
  [74] = {.lex_state = 2, .external_lex_state = 3},
  [75] = {.lex_state = 2, .external_lex_state = 3},
  [76] = {.lex_state = 2, .external_lex_state = 3},
  [77] = {.lex_state = 2, .external_lex_state = 3},
  [78] = {.lex_state = 2, .external_lex_state = 3},
  [79] = {.lex_state = 2, .external_lex_state = 3},
  [80] = {.lex_state = 2, .external_lex_state = 3},
  [81] = {.lex_state = 2, .external_lex_state = 3},
  [82] = {.lex_state = 2, .external_lex_state = 3},
  [83] = {.lex_state = 2, .external_lex_state = 3},
  [84] = {.lex_state = 2, .external_lex_state = 3},
  [85] = {.lex_state = 2, .external_lex_state = 3},
  [86] = {.lex_state = 2, .external_lex_state = 3},
  [87] = {.lex_state = 2, .external_lex_state = 3},
  [88] = {.lex_state = 2, .external_lex_state = 3},
  [89] = {.lex_state = 2, .external_lex_state = 3},
  [90] = {.lex_state = 2, .external_lex_state = 3},
  [91] = {.lex_state = 2, .external_lex_state = 3},
  [92] = {.lex_state = 2, .external_lex_state = 3},
  [93] = {.lex_state = 2, .external_lex_state = 3},
  [94] = {.lex_state = 2, .external_lex_state = 3},
  [95] = {.lex_state = 2, .external_lex_state = 3},
  [96] = {.lex_state = 2, .external_lex_state = 3},
  [97] = {.lex_state = 2, .external_lex_state = 3},
  [98] = {.lex_state = 2, .external_lex_state = 3},
  [99] = {.lex_state = 2, .external_lex_state = 3},
  [100] = {.lex_state = 2, .external_lex_state = 3},
  [101] = {.lex_state = 2, .external_lex_state = 3},
  [102] = {.lex_state = 2, .external_lex_state = 3},
  [103] = {.lex_state = 2, .external_lex_state = 3},
  [104] = {.lex_state = 1, .external_lex_state = 5},
  [105] = {.lex_state = 1, .external_lex_state = 5},
  [106] = {.lex_state = 2, .external_lex_state = 3},
  [107] = {.lex_state = 2, .external_lex_state = 3},
  [108] = {.lex_state = 2, .external_lex_state = 3},
  [109] = {.lex_state = 2, .external_lex_state = 3},
  [110] = {.lex_state = 2, .external_lex_state = 3},
  [111] = {.lex_state = 2, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 6},
  [113] = {.lex_state = 2, .external_lex_state = 3},
  [114] = {.lex_state = 2, .external_lex_state = 3},
  [115] = {.lex_state = 2, .external_lex_state = 3},
  [116] = {.lex_state = 2, .external_lex_state = 3},
  [117] = {.lex_state = 2, .external_lex_state = 3},
  [118] = {.lex_state = 2, .external_lex_state = 3},
  [119] = {.lex_state = 3, .external_lex_state = 6},
  [120] = {.lex_state = 3, .external_lex_state = 6},
  [121] = {.lex_state = 2, .external_lex_state = 3},
  [122] = {.lex_state = 2, .external_lex_state = 3},
  [123] = {.lex_state = 2, .external_lex_state = 3},
  [124] = {.lex_state = 2, .external_lex_state = 3},
  [125] = {.lex_state = 2, .external_lex_state = 3},
  [126] = {.lex_state = 2, .external_lex_state = 3},
  [127] = {.lex_state = 2, .external_lex_state = 3},
  [128] = {.lex_state = 2, .external_lex_state = 3},
  [129] = {.lex_state = 1, .external_lex_state = 5},
  [130] = {.lex_state = 2, .external_lex_state = 3},
  [131] = {.lex_state = 2, .external_lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 6},
  [133] = {.lex_state = 2, .external_lex_state = 3},
  [134] = {.lex_state = 2, .external_lex_state = 3},
  [135] = {.lex_state = 2, .external_lex_state = 3},
  [136] = {.lex_state = 2, .external_lex_state = 3},
  [137] = {.lex_state = 2, .external_lex_state = 3},
  [138] = {.lex_state = 2, .external_lex_state = 3},
  [139] = {.lex_state = 2, .external_lex_state = 3},
  [140] = {.lex_state = 2, .external_lex_state = 3},
  [141] = {.lex_state = 2, .external_lex_state = 3},
  [142] = {.lex_state = 2, .external_lex_state = 3},
  [143] = {.lex_state = 2, .external_lex_state = 3},
  [144] = {.lex_state = 2, .external_lex_state = 3},
  [145] = {.lex_state = 2, .external_lex_state = 3},
  [146] = {.lex_state = 2, .external_lex_state = 3},
  [147] = {.lex_state = 2, .external_lex_state = 3},
  [148] = {.lex_state = 2, .external_lex_state = 3},
  [149] = {.lex_state = 2, .external_lex_state = 3},
  [150] = {.lex_state = 2, .external_lex_state = 3},
  [151] = {.lex_state = 2, .external_lex_state = 3},
  [152] = {.lex_state = 2, .external_lex_state = 3},
  [153] = {.lex_state = 3, .external_lex_state = 6},
  [154] = {.lex_state = 2, .external_lex_state = 3},
  [155] = {.lex_state = 2, .external_lex_state = 3},
  [156] = {.lex_state = 2, .external_lex_state = 3},
  [157] = {.lex_state = 3, .external_lex_state = 6},
  [158] = {.lex_state = 3, .external_lex_state = 6},
  [159] = {.lex_state = 2, .external_lex_state = 3},
  [160] = {.lex_state = 2, .external_lex_state = 3},
  [161] = {.lex_state = 2, .external_lex_state = 3},
  [162] = {.lex_state = 2, .external_lex_state = 3},
  [163] = {.lex_state = 2, .external_lex_state = 3},
  [164] = {.lex_state = 2, .external_lex_state = 3},
  [165] = {.lex_state = 2, .external_lex_state = 3},
  [166] = {.lex_state = 2, .external_lex_state = 3},
  [167] = {.lex_state = 2, .external_lex_state = 3},
  [168] = {.lex_state = 3, .external_lex_state = 6},
  [169] = {.lex_state = 2, .external_lex_state = 3},
  [170] = {.lex_state = 2, .external_lex_state = 3},
  [171] = {.lex_state = 2, .external_lex_state = 3},
  [172] = {.lex_state = 2, .external_lex_state = 3},
  [173] = {.lex_state = 2, .external_lex_state = 3},
  [174] = {.lex_state = 2, .external_lex_state = 3},
  [175] = {.lex_state = 2, .external_lex_state = 3},
  [176] = {.lex_state = 2, .external_lex_state = 3},
  [177] = {.lex_state = 2, .external_lex_state = 3},
  [178] = {.lex_state = 2, .external_lex_state = 3},
  [179] = {.lex_state = 2, .external_lex_state = 3},
  [180] = {.lex_state = 2, .external_lex_state = 3},
  [181] = {.lex_state = 2, .external_lex_state = 3},
  [182] = {.lex_state = 2, .external_lex_state = 3},
  [183] = {.lex_state = 2, .external_lex_state = 3},
  [184] = {.lex_state = 2, .external_lex_state = 3},
  [185] = {.lex_state = 2, .external_lex_state = 3},
  [186] = {.lex_state = 2, .external_lex_state = 3},
  [187] = {.lex_state = 2, .external_lex_state = 3},
  [188] = {.lex_state = 2, .external_lex_state = 3},
  [189] = {.lex_state = 2, .external_lex_state = 3},
  [190] = {.lex_state = 2, .external_lex_state = 3},
  [191] = {.lex_state = 2, .external_lex_state = 3},
  [192] = {.lex_state = 2, .external_lex_state = 3},
  [193] = {.lex_state = 3, .external_lex_state = 6},
  [194] = {.lex_state = 2, .external_lex_state = 3},
  [195] = {.lex_state = 2, .external_lex_state = 3},
  [196] = {.lex_state = 2, .external_lex_state = 3},
  [197] = {.lex_state = 2, .external_lex_state = 3},
  [198] = {.lex_state = 2, .external_lex_state = 3},
  [199] = {.lex_state = 2, .external_lex_state = 3},
  [200] = {.lex_state = 3, .external_lex_state = 6},
  [201] = {.lex_state = 2, .external_lex_state = 3},
  [202] = {.lex_state = 2, .external_lex_state = 3},
  [203] = {.lex_state = 3, .external_lex_state = 6},
  [204] = {.lex_state = 2, .external_lex_state = 3},
  [205] = {.lex_state = 2, .external_lex_state = 3},
  [206] = {.lex_state = 2, .external_lex_state = 3},
  [207] = {.lex_state = 2, .external_lex_state = 3},
  [208] = {.lex_state = 2, .external_lex_state = 3},
  [209] = {.lex_state = 2, .external_lex_state = 3},
  [210] = {.lex_state = 2, .external_lex_state = 3},
  [211] = {.lex_state = 2, .external_lex_state = 3},
  [212] = {.lex_state = 3, .external_lex_state = 6},
  [213] = {.lex_state = 2, .external_lex_state = 3},
  [214] = {.lex_state = 2, .external_lex_state = 3},
  [215] = {.lex_state = 2, .external_lex_state = 3},
  [216] = {.lex_state = 2, .external_lex_state = 3},
  [217] = {.lex_state = 2, .external_lex_state = 3},
  [218] = {.lex_state = 2, .external_lex_state = 3},
  [219] = {.lex_state = 2, .external_lex_state = 3},
  [220] = {.lex_state = 1, .external_lex_state = 5},
  [221] = {.lex_state = 2, .external_lex_state = 3},
  [222] = {.lex_state = 2, .external_lex_state = 3},
  [223] = {.lex_state = 2, .external_lex_state = 3},
  [224] = {.lex_state = 2, .external_lex_state = 3},
  [225] = {.lex_state = 3, .external_lex_state = 6},
  [226] = {.lex_state = 2, .external_lex_state = 3},
  [227] = {.lex_state = 3, .external_lex_state = 6},
  [228] = {.lex_state = 2, .external_lex_state = 3},
  [229] = {.lex_state = 2, .external_lex_state = 3},
  [230] = {.lex_state = 2, .external_lex_state = 3},
  [231] = {.lex_state = 2, .external_lex_state = 3},
  [232] = {.lex_state = 2, .external_lex_state = 3},
  [233] = {.lex_state = 2, .external_lex_state = 3},
  [234] = {.lex_state = 2, .external_lex_state = 3},
  [235] = {.lex_state = 2, .external_lex_state = 3},
  [236] = {.lex_state = 2, .external_lex_state = 3},
  [237] = {.lex_state = 3, .external_lex_state = 6},
  [238] = {.lex_state = 2, .external_lex_state = 3},
  [239] = {.lex_state = 2, .external_lex_state = 3},
  [240] = {.lex_state = 2, .external_lex_state = 3},
  [241] = {.lex_state = 2, .external_lex_state = 3},
  [242] = {.lex_state = 2, .external_lex_state = 3},
  [243] = {.lex_state = 2, .external_lex_state = 3},
  [244] = {.lex_state = 2, .external_lex_state = 3},
  [245] = {.lex_state = 2, .external_lex_state = 3},
  [246] = {.lex_state = 2, .external_lex_state = 3},
  [247] = {.lex_state = 3, .external_lex_state = 6},
  [248] = {.lex_state = 2, .external_lex_state = 3},
  [249] = {.lex_state = 2, .external_lex_state = 3},
  [250] = {.lex_state = 2, .external_lex_state = 3},
  [251] = {.lex_state = 3, .external_lex_state = 6},
  [252] = {.lex_state = 2, .external_lex_state = 3},
  [253] = {.lex_state = 2, .external_lex_state = 3},
  [254] = {.lex_state = 2, .external_lex_state = 3},
  [255] = {.lex_state = 2, .external_lex_state = 3},
  [256] = {.lex_state = 2, .external_lex_state = 3},
  [257] = {.lex_state = 2, .external_lex_state = 3},
  [258] = {.lex_state = 2, .external_lex_state = 3},
  [259] = {.lex_state = 2, .external_lex_state = 3},
  [260] = {.lex_state = 2, .external_lex_state = 3},
  [261] = {.lex_state = 3, .external_lex_state = 6},
  [262] = {.lex_state = 2, .external_lex_state = 3},
  [263] = {.lex_state = 2, .external_lex_state = 3},
  [264] = {.lex_state = 2, .external_lex_state = 3},
  [265] = {.lex_state = 2, .external_lex_state = 3},
  [266] = {.lex_state = 2, .external_lex_state = 3},
  [267] = {.lex_state = 2, .external_lex_state = 3},
  [268] = {.lex_state = 2, .external_lex_state = 3},
  [269] = {.lex_state = 2, .external_lex_state = 3},
  [270] = {.lex_state = 2, .external_lex_state = 3},
  [271] = {.lex_state = 2, .external_lex_state = 3},
  [272] = {.lex_state = 2, .external_lex_state = 3},
  [273] = {.lex_state = 2, .external_lex_state = 3},
  [274] = {.lex_state = 2, .external_lex_state = 3},
  [275] = {.lex_state = 2, .external_lex_state = 3},
  [276] = {.lex_state = 2, .external_lex_state = 3},
  [277] = {.lex_state = 2, .external_lex_state = 3},
  [278] = {.lex_state = 2, .external_lex_state = 3},
  [279] = {.lex_state = 2, .external_lex_state = 3},
  [280] = {.lex_state = 2, .external_lex_state = 3},
  [281] = {.lex_state = 2, .external_lex_state = 3},
  [282] = {.lex_state = 2, .external_lex_state = 3},
  [283] = {.lex_state = 2, .external_lex_state = 3},
  [284] = {.lex_state = 2, .external_lex_state = 3},
  [285] = {.lex_state = 2, .external_lex_state = 3},
  [286] = {.lex_state = 2, .external_lex_state = 3},
  [287] = {.lex_state = 2, .external_lex_state = 3},
  [288] = {.lex_state = 2, .external_lex_state = 3},
  [289] = {.lex_state = 2, .external_lex_state = 3},
  [290] = {.lex_state = 2, .external_lex_state = 3},
  [291] = {.lex_state = 2, .external_lex_state = 3},
  [292] = {.lex_state = 2, .external_lex_state = 3},
  [293] = {.lex_state = 2, .external_lex_state = 3},
  [294] = {.lex_state = 2, .external_lex_state = 3},
  [295] = {.lex_state = 2, .external_lex_state = 3},
  [296] = {.lex_state = 2, .external_lex_state = 3},
  [297] = {.lex_state = 2, .external_lex_state = 3},
  [298] = {.lex_state = 2, .external_lex_state = 3},
  [299] = {.lex_state = 2, .external_lex_state = 3},
  [300] = {.lex_state = 2, .external_lex_state = 3},
  [301] = {.lex_state = 2, .external_lex_state = 3},
  [302] = {.lex_state = 2, .external_lex_state = 3},
  [303] = {.lex_state = 2, .external_lex_state = 3},
  [304] = {.lex_state = 2, .external_lex_state = 3},
  [305] = {.lex_state = 2, .external_lex_state = 3},
  [306] = {.lex_state = 2, .external_lex_state = 3},
  [307] = {.lex_state = 2, .external_lex_state = 3},
  [308] = {.lex_state = 2, .external_lex_state = 3},
  [309] = {.lex_state = 2, .external_lex_state = 3},
  [310] = {.lex_state = 2, .external_lex_state = 3},
  [311] = {.lex_state = 3, .external_lex_state = 6},
  [312] = {.lex_state = 2, .external_lex_state = 3},
  [313] = {.lex_state = 2, .external_lex_state = 3},
  [314] = {.lex_state = 2, .external_lex_state = 3},
  [315] = {.lex_state = 2, .external_lex_state = 3},
  [316] = {.lex_state = 2, .external_lex_state = 3},
  [317] = {.lex_state = 2, .external_lex_state = 3},
  [318] = {.lex_state = 2, .external_lex_state = 3},
  [319] = {.lex_state = 2, .external_lex_state = 3},
  [320] = {.lex_state = 2, .external_lex_state = 3},
  [321] = {.lex_state = 2, .external_lex_state = 3},
  [322] = {.lex_state = 2, .external_lex_state = 3},
  [323] = {.lex_state = 2, .external_lex_state = 3},
  [324] = {.lex_state = 2, .external_lex_state = 3},
  [325] = {.lex_state = 2, .external_lex_state = 3},
  [326] = {.lex_state = 2, .external_lex_state = 3},
  [327] = {.lex_state = 2, .external_lex_state = 3},
  [328] = {.lex_state = 2, .external_lex_state = 3},
  [329] = {.lex_state = 2, .external_lex_state = 3},
  [330] = {.lex_state = 2, .external_lex_state = 3},
  [331] = {.lex_state = 2, .external_lex_state = 3},
  [332] = {.lex_state = 2, .external_lex_state = 3},
  [333] = {.lex_state = 2, .external_lex_state = 3},
  [334] = {.lex_state = 2, .external_lex_state = 3},
  [335] = {.lex_state = 2, .external_lex_state = 3},
  [336] = {.lex_state = 2, .external_lex_state = 3},
  [337] = {.lex_state = 2, .external_lex_state = 3},
  [338] = {.lex_state = 2, .external_lex_state = 3},
  [339] = {.lex_state = 2, .external_lex_state = 3},
  [340] = {.lex_state = 2, .external_lex_state = 3},
  [341] = {.lex_state = 2, .external_lex_state = 3},
  [342] = {.lex_state = 2, .external_lex_state = 3},
  [343] = {.lex_state = 2, .external_lex_state = 3},
  [344] = {.lex_state = 5, .external_lex_state = 5},
  [345] = {.lex_state = 5, .external_lex_state = 5},
  [346] = {.lex_state = 5, .external_lex_state = 5},
  [347] = {.lex_state = 5, .external_lex_state = 5},
  [348] = {.lex_state = 5, .external_lex_state = 5},
  [349] = {.lex_state = 5, .external_lex_state = 5},
  [350] = {.lex_state = 5, .external_lex_state = 5},
  [351] = {.lex_state = 5, .external_lex_state = 5},
  [352] = {.lex_state = 5, .external_lex_state = 5},
  [353] = {.lex_state = 5, .external_lex_state = 5},
  [354] = {.lex_state = 5, .external_lex_state = 5},
  [355] = {.lex_state = 5, .external_lex_state = 5},
  [356] = {.lex_state = 5, .external_lex_state = 5},
  [357] = {.lex_state = 5, .external_lex_state = 5},
  [358] = {.lex_state = 5, .external_lex_state = 5},
  [359] = {.lex_state = 5, .external_lex_state = 5},
  [360] = {.lex_state = 5, .external_lex_state = 5},
  [361] = {.lex_state = 5, .external_lex_state = 5},
  [362] = {.lex_state = 5, .external_lex_state = 5},
  [363] = {.lex_state = 5, .external_lex_state = 5},
  [364] = {.lex_state = 5, .external_lex_state = 5},
  [365] = {.lex_state = 5, .external_lex_state = 5},
  [366] = {.lex_state = 5, .external_lex_state = 5},
  [367] = {.lex_state = 5, .external_lex_state = 5},
  [368] = {.lex_state = 5, .external_lex_state = 5},
  [369] = {.lex_state = 5, .external_lex_state = 5},
  [370] = {.lex_state = 5, .external_lex_state = 5},
  [371] = {.lex_state = 5, .external_lex_state = 5},
  [372] = {.lex_state = 5, .external_lex_state = 5},
  [373] = {.lex_state = 5, .external_lex_state = 5},
  [374] = {.lex_state = 5, .external_lex_state = 5},
  [375] = {.lex_state = 5, .external_lex_state = 5},
  [376] = {.lex_state = 5, .external_lex_state = 5},
  [377] = {.lex_state = 5, .external_lex_state = 5},
  [378] = {.lex_state = 5, .external_lex_state = 5},
  [379] = {.lex_state = 5, .external_lex_state = 5},
  [380] = {.lex_state = 5, .external_lex_state = 5},
  [381] = {.lex_state = 5, .external_lex_state = 5},
  [382] = {.lex_state = 5, .external_lex_state = 5},
  [383] = {.lex_state = 5, .external_lex_state = 5},
  [384] = {.lex_state = 5, .external_lex_state = 5},
  [385] = {.lex_state = 5, .external_lex_state = 5},
  [386] = {.lex_state = 5, .external_lex_state = 5},
  [387] = {.lex_state = 5, .external_lex_state = 5},
  [388] = {.lex_state = 5, .external_lex_state = 5},
  [389] = {.lex_state = 5, .external_lex_state = 5},
  [390] = {.lex_state = 5, .external_lex_state = 5},
  [391] = {.lex_state = 5, .external_lex_state = 5},
  [392] = {.lex_state = 5, .external_lex_state = 5},
  [393] = {.lex_state = 5, .external_lex_state = 5},
  [394] = {.lex_state = 5, .external_lex_state = 5},
  [395] = {.lex_state = 5, .external_lex_state = 5},
  [396] = {.lex_state = 5, .external_lex_state = 5},
  [397] = {.lex_state = 5, .external_lex_state = 5},
  [398] = {.lex_state = 5, .external_lex_state = 5},
  [399] = {.lex_state = 5, .external_lex_state = 5},
  [400] = {.lex_state = 5, .external_lex_state = 5},
  [401] = {.lex_state = 5, .external_lex_state = 5},
  [402] = {.lex_state = 5, .external_lex_state = 5},
  [403] = {.lex_state = 5, .external_lex_state = 5},
  [404] = {.lex_state = 5, .external_lex_state = 5},
  [405] = {.lex_state = 5, .external_lex_state = 5},
  [406] = {.lex_state = 5, .external_lex_state = 5},
  [407] = {.lex_state = 5, .external_lex_state = 5},
  [408] = {.lex_state = 5, .external_lex_state = 5},
  [409] = {.lex_state = 5, .external_lex_state = 5},
  [410] = {.lex_state = 5, .external_lex_state = 5},
  [411] = {.lex_state = 5, .external_lex_state = 5},
  [412] = {.lex_state = 5, .external_lex_state = 5},
  [413] = {.lex_state = 5, .external_lex_state = 5},
  [414] = {.lex_state = 5, .external_lex_state = 5},
  [415] = {.lex_state = 5, .external_lex_state = 5},
  [416] = {.lex_state = 5, .external_lex_state = 5},
  [417] = {.lex_state = 5, .external_lex_state = 5},
  [418] = {.lex_state = 5, .external_lex_state = 5},
  [419] = {.lex_state = 5, .external_lex_state = 5},
  [420] = {.lex_state = 5, .external_lex_state = 5},
  [421] = {.lex_state = 5, .external_lex_state = 5},
  [422] = {.lex_state = 5, .external_lex_state = 5},
  [423] = {.lex_state = 5, .external_lex_state = 5},
  [424] = {.lex_state = 5, .external_lex_state = 5},
  [425] = {.lex_state = 5, .external_lex_state = 5},
  [426] = {.lex_state = 5, .external_lex_state = 5},
  [427] = {.lex_state = 5, .external_lex_state = 5},
  [428] = {.lex_state = 5, .external_lex_state = 5},
  [429] = {.lex_state = 5, .external_lex_state = 5},
  [430] = {.lex_state = 5, .external_lex_state = 5},
  [431] = {.lex_state = 5, .external_lex_state = 5},
  [432] = {.lex_state = 5, .external_lex_state = 5},
  [433] = {.lex_state = 5, .external_lex_state = 5},
  [434] = {.lex_state = 5, .external_lex_state = 5},
  [435] = {.lex_state = 5, .external_lex_state = 5},
  [436] = {.lex_state = 5, .external_lex_state = 5},
  [437] = {.lex_state = 5, .external_lex_state = 5},
  [438] = {.lex_state = 5, .external_lex_state = 5},
  [439] = {.lex_state = 5, .external_lex_state = 5},
  [440] = {.lex_state = 5, .external_lex_state = 5},
  [441] = {.lex_state = 5, .external_lex_state = 5},
  [442] = {.lex_state = 5, .external_lex_state = 5},
  [443] = {.lex_state = 5, .external_lex_state = 5},
  [444] = {.lex_state = 5, .external_lex_state = 5},
  [445] = {.lex_state = 5, .external_lex_state = 5},
  [446] = {.lex_state = 5, .external_lex_state = 5},
  [447] = {.lex_state = 5, .external_lex_state = 5},
  [448] = {.lex_state = 5, .external_lex_state = 5},
  [449] = {.lex_state = 5, .external_lex_state = 5},
  [450] = {.lex_state = 5, .external_lex_state = 5},
  [451] = {.lex_state = 5, .external_lex_state = 5},
  [452] = {.lex_state = 5, .external_lex_state = 5},
  [453] = {.lex_state = 5, .external_lex_state = 5},
  [454] = {.lex_state = 5, .external_lex_state = 5},
  [455] = {.lex_state = 5, .external_lex_state = 5},
  [456] = {.lex_state = 5, .external_lex_state = 5},
  [457] = {.lex_state = 5, .external_lex_state = 5},
  [458] = {.lex_state = 5, .external_lex_state = 5},
  [459] = {.lex_state = 5, .external_lex_state = 5},
  [460] = {.lex_state = 5, .external_lex_state = 5},
  [461] = {.lex_state = 5, .external_lex_state = 5},
  [462] = {.lex_state = 5, .external_lex_state = 5},
  [463] = {.lex_state = 5, .external_lex_state = 5},
  [464] = {.lex_state = 5, .external_lex_state = 5},
  [465] = {.lex_state = 5, .external_lex_state = 5},
  [466] = {.lex_state = 5, .external_lex_state = 5},
  [467] = {.lex_state = 5, .external_lex_state = 5},
  [468] = {.lex_state = 5, .external_lex_state = 5},
  [469] = {.lex_state = 5, .external_lex_state = 5},
  [470] = {.lex_state = 5, .external_lex_state = 5},
  [471] = {.lex_state = 5, .external_lex_state = 5},
  [472] = {.lex_state = 5, .external_lex_state = 5},
  [473] = {.lex_state = 3, .external_lex_state = 4},
  [474] = {.lex_state = 9, .external_lex_state = 4},
  [475] = {.lex_state = 9, .external_lex_state = 4},
  [476] = {.lex_state = 9, .external_lex_state = 4},
  [477] = {.lex_state = 9, .external_lex_state = 4},
  [478] = {.lex_state = 9, .external_lex_state = 4},
  [479] = {.lex_state = 9, .external_lex_state = 4},
  [480] = {.lex_state = 9, .external_lex_state = 4},
  [481] = {.lex_state = 9, .external_lex_state = 4},
  [482] = {.lex_state = 9, .external_lex_state = 4},
  [483] = {.lex_state = 9, .external_lex_state = 4},
  [484] = {.lex_state = 3, .external_lex_state = 4},
  [485] = {.lex_state = 9, .external_lex_state = 4},
  [486] = {.lex_state = 9, .external_lex_state = 4},
  [487] = {.lex_state = 3, .external_lex_state = 4},
  [488] = {.lex_state = 3, .external_lex_state = 4},
  [489] = {.lex_state = 7, .external_lex_state = 7},
  [490] = {.lex_state = 7, .external_lex_state = 7},
  [491] = {.lex_state = 7, .external_lex_state = 7},
  [492] = {.lex_state = 7, .external_lex_state = 7},
  [493] = {.lex_state = 7, .external_lex_state = 7},
  [494] = {.lex_state = 7, .external_lex_state = 7},
  [495] = {.lex_state = 7, .external_lex_state = 7},
  [496] = {.lex_state = 2, .external_lex_state = 7},
  [497] = {.lex_state = 7, .external_lex_state = 7},
  [498] = {.lex_state = 9, .external_lex_state = 5},
  [499] = {.lex_state = 9, .external_lex_state = 5},
  [500] = {.lex_state = 9, .external_lex_state = 5},
  [501] = {.lex_state = 9, .external_lex_state = 5},
  [502] = {.lex_state = 9, .external_lex_state = 5},
  [503] = {.lex_state = 9, .external_lex_state = 5},
  [504] = {.lex_state = 9, .external_lex_state = 5},
  [505] = {.lex_state = 9, .external_lex_state = 5},
  [506] = {.lex_state = 9, .external_lex_state = 5},
  [507] = {.lex_state = 9, .external_lex_state = 5},
  [508] = {.lex_state = 9, .external_lex_state = 5},
  [509] = {.lex_state = 9, .external_lex_state = 5},
  [510] = {.lex_state = 2, .external_lex_state = 7},
  [511] = {.lex_state = 3, .external_lex_state = 6},
  [512] = {.lex_state = 9, .external_lex_state = 5},
  [513] = {.lex_state = 9, .external_lex_state = 5},
  [514] = {.lex_state = 2, .external_lex_state = 7},
  [515] = {.lex_state = 2, .external_lex_state = 3},
  [516] = {.lex_state = 9, .external_lex_state = 5},
  [517] = {.lex_state = 9, .external_lex_state = 5},
  [518] = {.lex_state = 9, .external_lex_state = 5},
  [519] = {.lex_state = 9, .external_lex_state = 5},
  [520] = {.lex_state = 9, .external_lex_state = 5},
  [521] = {.lex_state = 9, .external_lex_state = 5},
  [522] = {.lex_state = 9, .external_lex_state = 5},
  [523] = {.lex_state = 9, .external_lex_state = 5},
  [524] = {.lex_state = 9, .external_lex_state = 5},
  [525] = {.lex_state = 9, .external_lex_state = 5},
  [526] = {.lex_state = 9, .external_lex_state = 5},
  [527] = {.lex_state = 9, .external_lex_state = 5},
  [528] = {.lex_state = 9, .external_lex_state = 5},
  [529] = {.lex_state = 9, .external_lex_state = 5},
  [530] = {.lex_state = 9, .external_lex_state = 5},
  [531] = {.lex_state = 9, .external_lex_state = 5},
  [532] = {.lex_state = 9, .external_lex_state = 5},
  [533] = {.lex_state = 9, .external_lex_state = 5},
  [534] = {.lex_state = 9, .external_lex_state = 5},
  [535] = {.lex_state = 9, .external_lex_state = 5},
  [536] = {.lex_state = 9, .external_lex_state = 5},
  [537] = {.lex_state = 9, .external_lex_state = 5},
  [538] = {.lex_state = 9, .external_lex_state = 5},
  [539] = {.lex_state = 9, .external_lex_state = 5},
  [540] = {.lex_state = 9, .external_lex_state = 5},
  [541] = {.lex_state = 9, .external_lex_state = 5},
  [542] = {.lex_state = 9, .external_lex_state = 5},
  [543] = {.lex_state = 9, .external_lex_state = 5},
  [544] = {.lex_state = 9, .external_lex_state = 5},
  [545] = {.lex_state = 9, .external_lex_state = 5},
  [546] = {.lex_state = 9, .external_lex_state = 6},
  [547] = {.lex_state = 9, .external_lex_state = 6},
  [548] = {.lex_state = 9, .external_lex_state = 6},
  [549] = {.lex_state = 2, .external_lex_state = 3},
  [550] = {.lex_state = 2, .external_lex_state = 3},
  [551] = {.lex_state = 2, .external_lex_state = 3},
  [552] = {.lex_state = 16},
  [553] = {.lex_state = 16},
  [554] = {.lex_state = 9, .external_lex_state = 6},
  [555] = {.lex_state = 9, .external_lex_state = 5},
  [556] = {.lex_state = 16},
  [557] = {.lex_state = 9, .external_lex_state = 6},
  [558] = {.lex_state = 9, .external_lex_state = 6},
  [559] = {.lex_state = 16},
  [560] = {.lex_state = 9, .external_lex_state = 6},
  [561] = {.lex_state = 2, .external_lex_state = 3},
  [562] = {.lex_state = 16},
  [563] = {.lex_state = 9, .external_lex_state = 5},
  [564] = {.lex_state = 9, .external_lex_state = 6},
  [565] = {.lex_state = 16},
  [566] = {.lex_state = 16},
  [567] = {.lex_state = 16},
  [568] = {.lex_state = 9, .external_lex_state = 6},
  [569] = {.lex_state = 16},
  [570] = {.lex_state = 9, .external_lex_state = 6},
  [571] = {.lex_state = 9, .external_lex_state = 6},
  [572] = {.lex_state = 9, .external_lex_state = 6},
  [573] = {.lex_state = 9, .external_lex_state = 5},
  [574] = {.lex_state = 269, .external_lex_state = 2},
  [575] = {.lex_state = 269, .external_lex_state = 2},
  [576] = {.lex_state = 269, .external_lex_state = 8},
  [577] = {.lex_state = 9, .external_lex_state = 6},
  [578] = {.lex_state = 269, .external_lex_state = 8},
  [579] = {.lex_state = 269, .external_lex_state = 8},
  [580] = {.lex_state = 9, .external_lex_state = 6},
  [581] = {.lex_state = 9, .external_lex_state = 5},
  [582] = {.lex_state = 9, .external_lex_state = 5},
  [583] = {.lex_state = 9, .external_lex_state = 5},
  [584] = {.lex_state = 9, .external_lex_state = 5},
  [585] = {.lex_state = 9, .external_lex_state = 5},
  [586] = {.lex_state = 9, .external_lex_state = 5},
  [587] = {.lex_state = 9, .external_lex_state = 5},
  [588] = {.lex_state = 9, .external_lex_state = 5},
  [589] = {.lex_state = 269, .external_lex_state = 9},
  [590] = {.lex_state = 9, .external_lex_state = 5},
  [591] = {.lex_state = 9, .external_lex_state = 5},
  [592] = {.lex_state = 269, .external_lex_state = 9},
  [593] = {.lex_state = 269, .external_lex_state = 9},
  [594] = {.lex_state = 9, .external_lex_state = 5},
  [595] = {.lex_state = 9, .external_lex_state = 5},
  [596] = {.lex_state = 9, .external_lex_state = 5},
  [597] = {.lex_state = 9, .external_lex_state = 5},
  [598] = {.lex_state = 9, .external_lex_state = 5},
  [599] = {.lex_state = 9, .external_lex_state = 5},
  [600] = {.lex_state = 9, .external_lex_state = 5},
  [601] = {.lex_state = 9, .external_lex_state = 5},
  [602] = {.lex_state = 9, .external_lex_state = 5},
  [603] = {.lex_state = 9, .external_lex_state = 5},
  [604] = {.lex_state = 9, .external_lex_state = 5},
  [605] = {.lex_state = 9, .external_lex_state = 5},
  [606] = {.lex_state = 9, .external_lex_state = 5},
  [607] = {.lex_state = 9, .external_lex_state = 5},
  [608] = {.lex_state = 9, .external_lex_state = 5},
  [609] = {.lex_state = 269},
  [610] = {.lex_state = 9, .external_lex_state = 5},
  [611] = {.lex_state = 9, .external_lex_state = 5},
  [612] = {.lex_state = 9, .external_lex_state = 5},
  [613] = {.lex_state = 9, .external_lex_state = 5},
  [614] = {.lex_state = 9, .external_lex_state = 5},
  [615] = {.lex_state = 269},
  [616] = {.lex_state = 269},
  [617] = {.lex_state = 9, .external_lex_state = 5},
  [618] = {.lex_state = 269, .external_lex_state = 9},
  [619] = {.lex_state = 269, .external_lex_state = 9},
  [620] = {.lex_state = 16},
  [621] = {.lex_state = 269},
  [622] = {.lex_state = 9, .external_lex_state = 5},
  [623] = {.lex_state = 269},
  [624] = {.lex_state = 16},
  [625] = {.lex_state = 16},
  [626] = {.lex_state = 16},
  [627] = {.lex_state = 22},
  [628] = {.lex_state = 16},
  [629] = {.lex_state = 16},
  [630] = {.lex_state = 16},
  [631] = {.lex_state = 16},
  [632] = {.lex_state = 16},
  [633] = {.lex_state = 16},
  [634] = {.lex_state = 16},
  [635] = {.lex_state = 16},
  [636] = {.lex_state = 16},
  [637] = {.lex_state = 16},
  [638] = {.lex_state = 16},
  [639] = {.lex_state = 16},
  [640] = {.lex_state = 16},
  [641] = {.lex_state = 25},
  [642] = {.lex_state = 16},
  [643] = {.lex_state = 16},
  [644] = {.lex_state = 16},
  [645] = {.lex_state = 16},
  [646] = {.lex_state = 16},
  [647] = {.lex_state = 25},
  [648] = {.lex_state = 16},
  [649] = {.lex_state = 16},
  [650] = {.lex_state = 16},
  [651] = {.lex_state = 16},
  [652] = {.lex_state = 16},
  [653] = {.lex_state = 16},
  [654] = {.lex_state = 16},
  [655] = {.lex_state = 16},
  [656] = {.lex_state = 16},
  [657] = {.lex_state = 16},
  [658] = {.lex_state = 16},
  [659] = {.lex_state = 16},
  [660] = {.lex_state = 5, .external_lex_state = 10},
  [661] = {.lex_state = 16},
  [662] = {.lex_state = 16},
  [663] = {.lex_state = 5, .external_lex_state = 10},
  [664] = {.lex_state = 16},
  [665] = {.lex_state = 16},
  [666] = {.lex_state = 16},
  [667] = {.lex_state = 16},
  [668] = {.lex_state = 16},
  [669] = {.lex_state = 5, .external_lex_state = 5},
  [670] = {.lex_state = 16},
  [671] = {.lex_state = 16},
  [672] = {.lex_state = 16},
  [673] = {.lex_state = 16},
  [674] = {.lex_state = 16},
  [675] = {.lex_state = 16},
  [676] = {.lex_state = 16},
  [677] = {.lex_state = 16},
  [678] = {.lex_state = 16},
  [679] = {.lex_state = 269, .external_lex_state = 2},
  [680] = {.lex_state = 16},
  [681] = {.lex_state = 16},
  [682] = {.lex_state = 5, .external_lex_state = 5},
  [683] = {.lex_state = 5, .external_lex_state = 5},
  [684] = {.lex_state = 5, .external_lex_state = 5},
  [685] = {.lex_state = 5, .external_lex_state = 5},
  [686] = {.lex_state = 5, .external_lex_state = 5},
  [687] = {.lex_state = 5, .external_lex_state = 5},
  [688] = {.lex_state = 26},
  [689] = {.lex_state = 26},
  [690] = {.lex_state = 26},
  [691] = {.lex_state = 26},
  [692] = {.lex_state = 26},
  [693] = {.lex_state = 26},
  [694] = {.lex_state = 26},
  [695] = {.lex_state = 26},
  [696] = {.lex_state = 26},
  [697] = {.lex_state = 26},
  [698] = {.lex_state = 26},
  [699] = {.lex_state = 26},
  [700] = {.lex_state = 26},
  [701] = {.lex_state = 26},
  [702] = {.lex_state = 26},
  [703] = {.lex_state = 26},
  [704] = {.lex_state = 26},
  [705] = {.lex_state = 26},
  [706] = {.lex_state = 26},
  [707] = {.lex_state = 26},
  [708] = {.lex_state = 26},
  [709] = {.lex_state = 26},
  [710] = {.lex_state = 26},
  [711] = {.lex_state = 26},
  [712] = {.lex_state = 26},
  [713] = {.lex_state = 26},
  [714] = {.lex_state = 26},
  [715] = {.lex_state = 26},
  [716] = {.lex_state = 26},
  [717] = {.lex_state = 9, .external_lex_state = 10},
  [718] = {.lex_state = 26},
  [719] = {.lex_state = 26},
  [720] = {.lex_state = 22, .external_lex_state = 11},
  [721] = {.lex_state = 26},
  [722] = {.lex_state = 26},
  [723] = {.lex_state = 26},
  [724] = {.lex_state = 26},
  [725] = {.lex_state = 26},
  [726] = {.lex_state = 26},
  [727] = {.lex_state = 26},
  [728] = {.lex_state = 26},
  [729] = {.lex_state = 26},
  [730] = {.lex_state = 23, .external_lex_state = 8},
  [731] = {.lex_state = 22},
  [732] = {.lex_state = 26},
  [733] = {.lex_state = 26},
  [734] = {.lex_state = 26},
  [735] = {.lex_state = 23, .external_lex_state = 8},
  [736] = {.lex_state = 21},
  [737] = {.lex_state = 21},
  [738] = {.lex_state = 17},
  [739] = {.lex_state = 21},
  [740] = {.lex_state = 9, .external_lex_state = 5},
  [741] = {.lex_state = 17},
  [742] = {.lex_state = 22},
  [743] = {.lex_state = 22},
  [744] = {.lex_state = 21},
  [745] = {.lex_state = 17},
  [746] = {.lex_state = 17},
  [747] = {.lex_state = 22},
  [748] = {.lex_state = 21},
  [749] = {.lex_state = 17},
  [750] = {.lex_state = 9, .external_lex_state = 5},
  [751] = {.lex_state = 22, .external_lex_state = 12},
  [752] = {.lex_state = 22},
  [753] = {.lex_state = 22},
  [754] = {.lex_state = 21},
  [755] = {.lex_state = 22},
  [756] = {.lex_state = 21},
  [757] = {.lex_state = 21},
  [758] = {.lex_state = 21},
  [759] = {.lex_state = 17},
  [760] = {.lex_state = 17},
  [761] = {.lex_state = 21},
  [762] = {.lex_state = 9, .external_lex_state = 4},
  [763] = {.lex_state = 9, .external_lex_state = 4},
  [764] = {.lex_state = 269},
  [765] = {.lex_state = 9, .external_lex_state = 10},
  [766] = {.lex_state = 11, .external_lex_state = 10},
  [767] = {.lex_state = 26, .external_lex_state = 12},
  [768] = {.lex_state = 26},
  [769] = {.lex_state = 9, .external_lex_state = 10},
  [770] = {.lex_state = 9, .external_lex_state = 5},
  [771] = {.lex_state = 23, .external_lex_state = 9},
  [772] = {.lex_state = 9, .external_lex_state = 4},
  [773] = {.lex_state = 26},
  [774] = {.lex_state = 9, .external_lex_state = 4},
  [775] = {.lex_state = 26},
  [776] = {.lex_state = 26},
  [777] = {.lex_state = 26},
  [778] = {.lex_state = 26},
  [779] = {.lex_state = 23, .external_lex_state = 9},
  [780] = {.lex_state = 43},
  [781] = {.lex_state = 26},
  [782] = {.lex_state = 26},
  [783] = {.lex_state = 43},
  [784] = {.lex_state = 26},
  [785] = {.lex_state = 26},
  [786] = {.lex_state = 26},
  [787] = {.lex_state = 43},
  [788] = {.lex_state = 26},
  [789] = {.lex_state = 26},
  [790] = {.lex_state = 43},
  [791] = {.lex_state = 26},
  [792] = {.lex_state = 23},
  [793] = {.lex_state = 23, .external_lex_state = 9},
  [794] = {.lex_state = 23, .external_lex_state = 9},
  [795] = {.lex_state = 9, .external_lex_state = 5},
  [796] = {.lex_state = 23, .external_lex_state = 9},
  [797] = {.lex_state = 23},
  [798] = {.lex_state = 9, .external_lex_state = 6},
  [799] = {.lex_state = 13, .external_lex_state = 13},
  [800] = {.lex_state = 23},
  [801] = {.lex_state = 23},
  [802] = {.lex_state = 9, .external_lex_state = 5},
  [803] = {.lex_state = 271, .external_lex_state = 2},
  [804] = {.lex_state = 16, .external_lex_state = 13},
  [805] = {.lex_state = 16},
  [806] = {.lex_state = 23},
  [807] = {.lex_state = 22, .external_lex_state = 11},
  [808] = {.lex_state = 21},
  [809] = {.lex_state = 22, .external_lex_state = 11},
  [810] = {.lex_state = 22, .external_lex_state = 11},
  [811] = {.lex_state = 269, .external_lex_state = 11},
  [812] = {.lex_state = 22, .external_lex_state = 12},
  [813] = {.lex_state = 22, .external_lex_state = 11},
  [814] = {.lex_state = 22, .external_lex_state = 11},
  [815] = {.lex_state = 22, .external_lex_state = 11},
  [816] = {.lex_state = 16, .external_lex_state = 13},
  [817] = {.lex_state = 269, .external_lex_state = 11},
  [818] = {.lex_state = 16, .external_lex_state = 13},
  [819] = {.lex_state = 22, .external_lex_state = 11},
  [820] = {.lex_state = 29},
  [821] = {.lex_state = 269, .external_lex_state = 8},
  [822] = {.lex_state = 22, .external_lex_state = 11},
  [823] = {.lex_state = 9},
  [824] = {.lex_state = 29},
  [825] = {.lex_state = 269, .external_lex_state = 8},
  [826] = {.lex_state = 26, .external_lex_state = 12},
  [827] = {.lex_state = 22, .external_lex_state = 11},
  [828] = {.lex_state = 22, .external_lex_state = 11},
  [829] = {.lex_state = 22, .external_lex_state = 11},
  [830] = {.lex_state = 9},
  [831] = {.lex_state = 21},
  [832] = {.lex_state = 27},
  [833] = {.lex_state = 22, .external_lex_state = 11},
  [834] = {.lex_state = 21},
  [835] = {.lex_state = 22, .external_lex_state = 11},
  [836] = {.lex_state = 21},
  [837] = {.lex_state = 22, .external_lex_state = 12},
  [838] = {.lex_state = 16},
  [839] = {.lex_state = 9},
  [840] = {.lex_state = 27},
  [841] = {.lex_state = 9},
  [842] = {.lex_state = 23},
  [843] = {.lex_state = 16, .external_lex_state = 13},
  [844] = {.lex_state = 22, .external_lex_state = 12},
  [845] = {.lex_state = 9},
  [846] = {.lex_state = 21},
  [847] = {.lex_state = 22, .external_lex_state = 11},
  [848] = {.lex_state = 21},
  [849] = {.lex_state = 22, .external_lex_state = 12},
  [850] = {.lex_state = 22, .external_lex_state = 11},
  [851] = {.lex_state = 22, .external_lex_state = 12},
  [852] = {.lex_state = 29},
  [853] = {.lex_state = 9},
  [854] = {.lex_state = 21},
  [855] = {.lex_state = 27},
  [856] = {.lex_state = 22, .external_lex_state = 12},
  [857] = {.lex_state = 269, .external_lex_state = 11},
  [858] = {.lex_state = 28},
  [859] = {.lex_state = 27},
  [860] = {.lex_state = 269, .external_lex_state = 2},
  [861] = {.lex_state = 22, .external_lex_state = 11},
  [862] = {.lex_state = 27},
  [863] = {.lex_state = 22, .external_lex_state = 12},
  [864] = {.lex_state = 23},
  [865] = {.lex_state = 16},
  [866] = {.lex_state = 22, .external_lex_state = 12},
  [867] = {.lex_state = 26, .external_lex_state = 12},
  [868] = {.lex_state = 29},
  [869] = {.lex_state = 29},
  [870] = {.lex_state = 29},
  [871] = {.lex_state = 29},
  [872] = {.lex_state = 29},
  [873] = {.lex_state = 29},
  [874] = {.lex_state = 16},
  [875] = {.lex_state = 16},
  [876] = {.lex_state = 16},
  [877] = {.lex_state = 9},
  [878] = {.lex_state = 22, .external_lex_state = 12},
  [879] = {.lex_state = 22, .external_lex_state = 12},
  [880] = {.lex_state = 9},
  [881] = {.lex_state = 29},
  [882] = {.lex_state = 26, .external_lex_state = 12},
  [883] = {.lex_state = 29},
  [884] = {.lex_state = 26, .external_lex_state = 12},
  [885] = {.lex_state = 269, .external_lex_state = 8},
  [886] = {.lex_state = 26, .external_lex_state = 12},
  [887] = {.lex_state = 22, .external_lex_state = 12},
  [888] = {.lex_state = 16},
  [889] = {.lex_state = 29},
  [890] = {.lex_state = 26, .external_lex_state = 12},
  [891] = {.lex_state = 22, .external_lex_state = 12},
  [892] = {.lex_state = 23, .external_lex_state = 8},
  [893] = {.lex_state = 29},
  [894] = {.lex_state = 269, .external_lex_state = 8},
  [895] = {.lex_state = 23, .external_lex_state = 8},
  [896] = {.lex_state = 29},
  [897] = {.lex_state = 9},
  [898] = {.lex_state = 22, .external_lex_state = 12},
  [899] = {.lex_state = 9},
  [900] = {.lex_state = 9},
  [901] = {.lex_state = 22, .external_lex_state = 12},
  [902] = {.lex_state = 22, .external_lex_state = 12},
  [903] = {.lex_state = 29},
  [904] = {.lex_state = 29},
  [905] = {.lex_state = 26, .external_lex_state = 12},
  [906] = {.lex_state = 16},
  [907] = {.lex_state = 29},
  [908] = {.lex_state = 29},
  [909] = {.lex_state = 22, .external_lex_state = 12},
  [910] = {.lex_state = 26, .external_lex_state = 12},
  [911] = {.lex_state = 26},
  [912] = {.lex_state = 26, .external_lex_state = 12},
  [913] = {.lex_state = 26, .external_lex_state = 12},
  [914] = {.lex_state = 26},
  [915] = {.lex_state = 26, .external_lex_state = 12},
  [916] = {.lex_state = 269, .external_lex_state = 9},
  [917] = {.lex_state = 26},
  [918] = {.lex_state = 269},
  [919] = {.lex_state = 26, .external_lex_state = 13},
  [920] = {.lex_state = 23, .external_lex_state = 8},
  [921] = {.lex_state = 23, .external_lex_state = 8},
  [922] = {.lex_state = 26, .external_lex_state = 13},
  [923] = {.lex_state = 23, .external_lex_state = 13},
  [924] = {.lex_state = 26, .external_lex_state = 12},
  [925] = {.lex_state = 26},
  [926] = {.lex_state = 9, .external_lex_state = 13},
  [927] = {.lex_state = 26, .external_lex_state = 13},
  [928] = {.lex_state = 26, .external_lex_state = 12},
  [929] = {.lex_state = 26, .external_lex_state = 12},
  [930] = {.lex_state = 26, .external_lex_state = 12},
  [931] = {.lex_state = 26},
  [932] = {.lex_state = 26, .external_lex_state = 12},
  [933] = {.lex_state = 23, .external_lex_state = 13},
  [934] = {.lex_state = 26},
  [935] = {.lex_state = 23},
  [936] = {.lex_state = 23, .external_lex_state = 9},
  [937] = {.lex_state = 26},
  [938] = {.lex_state = 26},
  [939] = {.lex_state = 9},
  [940] = {.lex_state = 9, .external_lex_state = 9},
  [941] = {.lex_state = 19, .external_lex_state = 12},
  [942] = {.lex_state = 19, .external_lex_state = 12},
  [943] = {.lex_state = 20, .external_lex_state = 12},
  [944] = {.lex_state = 19, .external_lex_state = 12},
  [945] = {.lex_state = 19, .external_lex_state = 12},
  [946] = {.lex_state = 20, .external_lex_state = 12},
  [947] = {.lex_state = 20, .external_lex_state = 12},
  [948] = {.lex_state = 20, .external_lex_state = 12},
  [949] = {.lex_state = 20, .external_lex_state = 12},
  [950] = {.lex_state = 20, .external_lex_state = 12},
  [951] = {.lex_state = 19, .external_lex_state = 12},
  [952] = {.lex_state = 20, .external_lex_state = 12},
  [953] = {.lex_state = 19, .external_lex_state = 12},
  [954] = {.lex_state = 23},
  [955] = {.lex_state = 19, .external_lex_state = 12},
  [956] = {.lex_state = 19, .external_lex_state = 12},
  [957] = {.lex_state = 20, .external_lex_state = 12},
  [958] = {.lex_state = 45},
  [959] = {.lex_state = 9},
  [960] = {.lex_state = 9},
  [961] = {.lex_state = 9},
  [962] = {.lex_state = 44},
  [963] = {.lex_state = 9, .external_lex_state = 9},
  [964] = {.lex_state = 9},
  [965] = {.lex_state = 44},
  [966] = {.lex_state = 9},
  [967] = {.lex_state = 44},
  [968] = {.lex_state = 9},
  [969] = {.lex_state = 9, .external_lex_state = 13},
  [970] = {.lex_state = 9},
  [971] = {.lex_state = 44},
  [972] = {.lex_state = 44},
  [973] = {.lex_state = 9},
  [974] = {.lex_state = 9},
  [975] = {.lex_state = 20, .external_lex_state = 12},
  [976] = {.lex_state = 9, .external_lex_state = 12},
  [977] = {.lex_state = 19, .external_lex_state = 2},
  [978] = {.lex_state = 19, .external_lex_state = 2},
  [979] = {.lex_state = 19, .external_lex_state = 2},
  [980] = {.lex_state = 19, .external_lex_state = 2},
  [981] = {.lex_state = 19, .external_lex_state = 2},
  [982] = {.lex_state = 19, .external_lex_state = 12},
  [983] = {.lex_state = 9, .external_lex_state = 8},
  [984] = {.lex_state = 9},
  [985] = {.lex_state = 9},
  [986] = {.lex_state = 20, .external_lex_state = 12},
  [987] = {.lex_state = 9, .external_lex_state = 13},
  [988] = {.lex_state = 9},
  [989] = {.lex_state = 20, .external_lex_state = 12},
  [990] = {.lex_state = 20, .external_lex_state = 12},
  [991] = {.lex_state = 19, .external_lex_state = 12},
  [992] = {.lex_state = 9},
  [993] = {.lex_state = 9},
  [994] = {.lex_state = 20, .external_lex_state = 12},
  [995] = {.lex_state = 20, .external_lex_state = 12},
  [996] = {.lex_state = 19, .external_lex_state = 12},
  [997] = {.lex_state = 9},
  [998] = {.lex_state = 19, .external_lex_state = 12},
  [999] = {.lex_state = 19, .external_lex_state = 12},
  [1000] = {.lex_state = 9},
  [1001] = {.lex_state = 20, .external_lex_state = 12},
  [1002] = {.lex_state = 19, .external_lex_state = 12},
  [1003] = {.lex_state = 20, .external_lex_state = 12},
  [1004] = {.lex_state = 19, .external_lex_state = 2},
  [1005] = {.lex_state = 19, .external_lex_state = 2},
  [1006] = {.lex_state = 19, .external_lex_state = 2},
  [1007] = {.lex_state = 19, .external_lex_state = 12},
  [1008] = {.lex_state = 9, .external_lex_state = 8},
  [1009] = {.lex_state = 19, .external_lex_state = 12},
  [1010] = {.lex_state = 269, .external_lex_state = 2},
  [1011] = {.lex_state = 12, .external_lex_state = 12},
  [1012] = {.lex_state = 9, .external_lex_state = 8},
  [1013] = {.lex_state = 12, .external_lex_state = 12},
  [1014] = {.lex_state = 12, .external_lex_state = 12},
  [1015] = {.lex_state = 269, .external_lex_state = 2},
  [1016] = {.lex_state = 269, .external_lex_state = 2},
  [1017] = {.lex_state = 269, .external_lex_state = 2},
  [1018] = {.lex_state = 12, .external_lex_state = 12},
  [1019] = {.lex_state = 269, .external_lex_state = 2},
  [1020] = {.lex_state = 269, .external_lex_state = 2},
  [1021] = {.lex_state = 269, .external_lex_state = 2},
  [1022] = {.lex_state = 269, .external_lex_state = 2},
  [1023] = {.lex_state = 9},
  [1024] = {.lex_state = 12, .external_lex_state = 12},
  [1025] = {.lex_state = 12, .external_lex_state = 12},
  [1026] = {.lex_state = 12, .external_lex_state = 12},
  [1027] = {.lex_state = 12, .external_lex_state = 12},
  [1028] = {.lex_state = 9},
  [1029] = {.lex_state = 19, .external_lex_state = 2},
  [1030] = {.lex_state = 19, .external_lex_state = 2},
  [1031] = {.lex_state = 9, .external_lex_state = 12},
  [1032] = {.lex_state = 19, .external_lex_state = 2},
  [1033] = {.lex_state = 9, .external_lex_state = 9},
  [1034] = {.lex_state = 19, .external_lex_state = 2},
  [1035] = {.lex_state = 19, .external_lex_state = 2},
  [1036] = {.lex_state = 19, .external_lex_state = 2},
  [1037] = {.lex_state = 19, .external_lex_state = 2},
  [1038] = {.lex_state = 9},
  [1039] = {.lex_state = 19, .external_lex_state = 2},
  [1040] = {.lex_state = 12, .external_lex_state = 12},
  [1041] = {.lex_state = 12, .external_lex_state = 12},
  [1042] = {.lex_state = 19, .external_lex_state = 12},
  [1043] = {.lex_state = 19, .external_lex_state = 12},
  [1044] = {.lex_state = 19, .external_lex_state = 12},
  [1045] = {.lex_state = 19, .external_lex_state = 12},
  [1046] = {.lex_state = 12, .external_lex_state = 12},
  [1047] = {.lex_state = 269, .external_lex_state = 2},
  [1048] = {.lex_state = 20, .external_lex_state = 12},
  [1049] = {.lex_state = 269, .external_lex_state = 2},
  [1050] = {.lex_state = 20, .external_lex_state = 12},
  [1051] = {.lex_state = 12, .external_lex_state = 12},
  [1052] = {.lex_state = 20, .external_lex_state = 12},
  [1053] = {.lex_state = 20, .external_lex_state = 12},
  [1054] = {.lex_state = 20, .external_lex_state = 12},
  [1055] = {.lex_state = 20, .external_lex_state = 12},
  [1056] = {.lex_state = 19, .external_lex_state = 12},
  [1057] = {.lex_state = 20, .external_lex_state = 12},
  [1058] = {.lex_state = 20, .external_lex_state = 12},
  [1059] = {.lex_state = 12, .external_lex_state = 12},
  [1060] = {.lex_state = 19, .external_lex_state = 12},
  [1061] = {.lex_state = 269, .external_lex_state = 2},
  [1062] = {.lex_state = 269, .external_lex_state = 2},
  [1063] = {.lex_state = 12, .external_lex_state = 12},
  [1064] = {.lex_state = 19, .external_lex_state = 12},
  [1065] = {.lex_state = 269, .external_lex_state = 2},
  [1066] = {.lex_state = 269, .external_lex_state = 2},
  [1067] = {.lex_state = 269, .external_lex_state = 2},
  [1068] = {.lex_state = 269, .external_lex_state = 2},
  [1069] = {.lex_state = 19, .external_lex_state = 12},
  [1070] = {.lex_state = 12, .external_lex_state = 12},
  [1071] = {.lex_state = 19, .external_lex_state = 12},
  [1072] = {.lex_state = 12, .external_lex_state = 12},
  [1073] = {.lex_state = 9},
  [1074] = {.lex_state = 20, .external_lex_state = 12},
  [1075] = {.lex_state = 20, .external_lex_state = 12},
  [1076] = {.lex_state = 20, .external_lex_state = 12},
  [1077] = {.lex_state = 19, .external_lex_state = 12},
  [1078] = {.lex_state = 19, .external_lex_state = 12},
  [1079] = {.lex_state = 19, .external_lex_state = 12},
  [1080] = {.lex_state = 19, .external_lex_state = 12},
  [1081] = {.lex_state = 19, .external_lex_state = 12},
  [1082] = {.lex_state = 20, .external_lex_state = 12},
  [1083] = {.lex_state = 20, .external_lex_state = 12},
  [1084] = {.lex_state = 20, .external_lex_state = 12},
  [1085] = {.lex_state = 19, .external_lex_state = 12},
  [1086] = {.lex_state = 20, .external_lex_state = 12},
  [1087] = {.lex_state = 19, .external_lex_state = 12},
  [1088] = {.lex_state = 19, .external_lex_state = 12},
  [1089] = {.lex_state = 19, .external_lex_state = 12},
  [1090] = {.lex_state = 19, .external_lex_state = 12},
  [1091] = {.lex_state = 20, .external_lex_state = 12},
  [1092] = {.lex_state = 20, .external_lex_state = 12},
  [1093] = {.lex_state = 20, .external_lex_state = 12},
  [1094] = {.lex_state = 20, .external_lex_state = 12},
  [1095] = {.lex_state = 19, .external_lex_state = 2},
  [1096] = {.lex_state = 19, .external_lex_state = 2},
  [1097] = {.lex_state = 19, .external_lex_state = 2},
  [1098] = {.lex_state = 19, .external_lex_state = 2},
  [1099] = {.lex_state = 19, .external_lex_state = 2},
  [1100] = {.lex_state = 19, .external_lex_state = 2},
  [1101] = {.lex_state = 19, .external_lex_state = 2},
  [1102] = {.lex_state = 19, .external_lex_state = 2},
  [1103] = {.lex_state = 19, .external_lex_state = 2},
  [1104] = {.lex_state = 19, .external_lex_state = 12},
  [1105] = {.lex_state = 19, .external_lex_state = 12},
  [1106] = {.lex_state = 19, .external_lex_state = 12},
  [1107] = {.lex_state = 20, .external_lex_state = 12},
  [1108] = {.lex_state = 20, .external_lex_state = 12},
  [1109] = {.lex_state = 20, .external_lex_state = 12},
  [1110] = {.lex_state = 20, .external_lex_state = 12},
  [1111] = {.lex_state = 19, .external_lex_state = 12},
  [1112] = {.lex_state = 20, .external_lex_state = 12},
  [1113] = {.lex_state = 12, .external_lex_state = 12},
  [1114] = {.lex_state = 20, .external_lex_state = 12},
  [1115] = {.lex_state = 20, .external_lex_state = 12},
  [1116] = {.lex_state = 20, .external_lex_state = 12},
  [1117] = {.lex_state = 19, .external_lex_state = 12},
  [1118] = {.lex_state = 12, .external_lex_state = 12},
  [1119] = {.lex_state = 12, .external_lex_state = 12},
  [1120] = {.lex_state = 12, .external_lex_state = 12},
  [1121] = {.lex_state = 12, .external_lex_state = 12},
  [1122] = {.lex_state = 19, .external_lex_state = 2},
  [1123] = {.lex_state = 19, .external_lex_state = 2},
  [1124] = {.lex_state = 19, .external_lex_state = 2},
  [1125] = {.lex_state = 19, .external_lex_state = 2},
  [1126] = {.lex_state = 19, .external_lex_state = 2},
  [1127] = {.lex_state = 19, .external_lex_state = 12},
  [1128] = {.lex_state = 19, .external_lex_state = 12},
  [1129] = {.lex_state = 20, .external_lex_state = 12},
  [1130] = {.lex_state = 19, .external_lex_state = 12},
  [1131] = {.lex_state = 12, .external_lex_state = 12},
  [1132] = {.lex_state = 12, .external_lex_state = 12},
  [1133] = {.lex_state = 12, .external_lex_state = 12},
  [1134] = {.lex_state = 12, .external_lex_state = 12},
  [1135] = {.lex_state = 19, .external_lex_state = 12},
  [1136] = {.lex_state = 269, .external_lex_state = 2},
  [1137] = {.lex_state = 269, .external_lex_state = 2},
  [1138] = {.lex_state = 269, .external_lex_state = 2},
  [1139] = {.lex_state = 269, .external_lex_state = 2},
  [1140] = {.lex_state = 269, .external_lex_state = 2},
  [1141] = {.lex_state = 269, .external_lex_state = 2},
  [1142] = {.lex_state = 269, .external_lex_state = 2},
  [1143] = {.lex_state = 269, .external_lex_state = 2},
  [1144] = {.lex_state = 269, .external_lex_state = 2},
  [1145] = {.lex_state = 269},
  [1146] = {.lex_state = 269, .external_lex_state = 2},
  [1147] = {.lex_state = 20, .external_lex_state = 8},
  [1148] = {.lex_state = 20, .external_lex_state = 8},
  [1149] = {.lex_state = 269},
  [1150] = {.lex_state = 19, .external_lex_state = 2},
  [1151] = {.lex_state = 269},
  [1152] = {.lex_state = 19, .external_lex_state = 2},
  [1153] = {.lex_state = 19, .external_lex_state = 2},
  [1154] = {.lex_state = 19, .external_lex_state = 2},
  [1155] = {.lex_state = 19, .external_lex_state = 2},
  [1156] = {.lex_state = 19, .external_lex_state = 12},
  [1157] = {.lex_state = 20, .external_lex_state = 8},
  [1158] = {.lex_state = 20, .external_lex_state = 8},
  [1159] = {.lex_state = 269},
  [1160] = {.lex_state = 20, .external_lex_state = 8},
  [1161] = {.lex_state = 20, .external_lex_state = 12},
  [1162] = {.lex_state = 19, .external_lex_state = 2},
  [1163] = {.lex_state = 19, .external_lex_state = 2},
  [1164] = {.lex_state = 19, .external_lex_state = 2},
  [1165] = {.lex_state = 12, .external_lex_state = 12},
  [1166] = {.lex_state = 12, .external_lex_state = 12},
  [1167] = {.lex_state = 12, .external_lex_state = 12},
  [1168] = {.lex_state = 12, .external_lex_state = 12},
  [1169] = {.lex_state = 12, .external_lex_state = 12},
  [1170] = {.lex_state = 19, .external_lex_state = 12},
  [1171] = {.lex_state = 20, .external_lex_state = 12},
  [1172] = {.lex_state = 20, .external_lex_state = 8},
  [1173] = {.lex_state = 269, .external_lex_state = 2},
  [1174] = {.lex_state = 269, .external_lex_state = 2},
  [1175] = {.lex_state = 269, .external_lex_state = 2},
  [1176] = {.lex_state = 269, .external_lex_state = 2},
  [1177] = {.lex_state = 19, .external_lex_state = 2},
  [1178] = {.lex_state = 269, .external_lex_state = 2},
  [1179] = {.lex_state = 20, .external_lex_state = 12},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 12, .external_lex_state = 12},
  [1182] = {.lex_state = 19, .external_lex_state = 2},
  [1183] = {.lex_state = 12, .external_lex_state = 12},
  [1184] = {.lex_state = 269, .external_lex_state = 12},
  [1185] = {.lex_state = 12, .external_lex_state = 12},
  [1186] = {.lex_state = 269, .external_lex_state = 2},
  [1187] = {.lex_state = 12, .external_lex_state = 12},
  [1188] = {.lex_state = 12, .external_lex_state = 12},
  [1189] = {.lex_state = 12, .external_lex_state = 12},
  [1190] = {.lex_state = 12, .external_lex_state = 12},
  [1191] = {.lex_state = 269, .external_lex_state = 2},
  [1192] = {.lex_state = 20, .external_lex_state = 12},
  [1193] = {.lex_state = 19, .external_lex_state = 12},
  [1194] = {.lex_state = 269, .external_lex_state = 2},
  [1195] = {.lex_state = 269, .external_lex_state = 12},
  [1196] = {.lex_state = 12, .external_lex_state = 12},
  [1197] = {.lex_state = 269, .external_lex_state = 2},
  [1198] = {.lex_state = 12, .external_lex_state = 12},
  [1199] = {.lex_state = 19, .external_lex_state = 2},
  [1200] = {.lex_state = 269, .external_lex_state = 12},
  [1201] = {.lex_state = 269, .external_lex_state = 12},
  [1202] = {.lex_state = 19, .external_lex_state = 2},
  [1203] = {.lex_state = 19, .external_lex_state = 2},
  [1204] = {.lex_state = 19, .external_lex_state = 2},
  [1205] = {.lex_state = 269, .external_lex_state = 2},
  [1206] = {.lex_state = 269, .external_lex_state = 2},
  [1207] = {.lex_state = 269, .external_lex_state = 2},
  [1208] = {.lex_state = 269, .external_lex_state = 2},
  [1209] = {.lex_state = 19, .external_lex_state = 12},
  [1210] = {.lex_state = 20, .external_lex_state = 12},
  [1211] = {.lex_state = 20, .external_lex_state = 12},
  [1212] = {.lex_state = 19, .external_lex_state = 12},
  [1213] = {.lex_state = 19, .external_lex_state = 12},
  [1214] = {.lex_state = 269, .external_lex_state = 2},
  [1215] = {.lex_state = 19, .external_lex_state = 12},
  [1216] = {.lex_state = 19, .external_lex_state = 12},
  [1217] = {.lex_state = 19, .external_lex_state = 12},
  [1218] = {.lex_state = 19, .external_lex_state = 12},
  [1219] = {.lex_state = 20, .external_lex_state = 12},
  [1220] = {.lex_state = 19, .external_lex_state = 12},
  [1221] = {.lex_state = 19, .external_lex_state = 12},
  [1222] = {.lex_state = 19, .external_lex_state = 12},
  [1223] = {.lex_state = 19, .external_lex_state = 12},
  [1224] = {.lex_state = 19, .external_lex_state = 12},
  [1225] = {.lex_state = 19, .external_lex_state = 12},
  [1226] = {.lex_state = 19, .external_lex_state = 12},
  [1227] = {.lex_state = 19, .external_lex_state = 12},
  [1228] = {.lex_state = 19, .external_lex_state = 12},
  [1229] = {.lex_state = 19, .external_lex_state = 12},
  [1230] = {.lex_state = 19, .external_lex_state = 12},
  [1231] = {.lex_state = 20, .external_lex_state = 12},
  [1232] = {.lex_state = 20, .external_lex_state = 12},
  [1233] = {.lex_state = 20, .external_lex_state = 12},
  [1234] = {.lex_state = 20, .external_lex_state = 12},
  [1235] = {.lex_state = 20, .external_lex_state = 12},
  [1236] = {.lex_state = 20, .external_lex_state = 12},
  [1237] = {.lex_state = 20, .external_lex_state = 12},
  [1238] = {.lex_state = 20, .external_lex_state = 12},
  [1239] = {.lex_state = 20, .external_lex_state = 12},
  [1240] = {.lex_state = 20, .external_lex_state = 12},
  [1241] = {.lex_state = 20, .external_lex_state = 12},
  [1242] = {.lex_state = 20, .external_lex_state = 12},
  [1243] = {.lex_state = 20, .external_lex_state = 12},
  [1244] = {.lex_state = 20, .external_lex_state = 12},
  [1245] = {.lex_state = 20, .external_lex_state = 12},
  [1246] = {.lex_state = 20, .external_lex_state = 12},
  [1247] = {.lex_state = 20, .external_lex_state = 12},
  [1248] = {.lex_state = 20, .external_lex_state = 12},
  [1249] = {.lex_state = 19, .external_lex_state = 12},
  [1250] = {.lex_state = 19, .external_lex_state = 12},
  [1251] = {.lex_state = 20, .external_lex_state = 12},
  [1252] = {.lex_state = 20, .external_lex_state = 12},
  [1253] = {.lex_state = 20, .external_lex_state = 12},
  [1254] = {.lex_state = 20, .external_lex_state = 12},
  [1255] = {.lex_state = 20, .external_lex_state = 12},
  [1256] = {.lex_state = 20, .external_lex_state = 12},
  [1257] = {.lex_state = 20, .external_lex_state = 12},
  [1258] = {.lex_state = 20, .external_lex_state = 12},
  [1259] = {.lex_state = 19, .external_lex_state = 12},
  [1260] = {.lex_state = 20, .external_lex_state = 12},
  [1261] = {.lex_state = 20, .external_lex_state = 12},
  [1262] = {.lex_state = 20, .external_lex_state = 12},
  [1263] = {.lex_state = 20, .external_lex_state = 12},
  [1264] = {.lex_state = 20, .external_lex_state = 12},
  [1265] = {.lex_state = 20, .external_lex_state = 12},
  [1266] = {.lex_state = 20, .external_lex_state = 12},
  [1267] = {.lex_state = 20, .external_lex_state = 12},
  [1268] = {.lex_state = 20, .external_lex_state = 12},
  [1269] = {.lex_state = 20, .external_lex_state = 12},
  [1270] = {.lex_state = 20, .external_lex_state = 12},
  [1271] = {.lex_state = 20, .external_lex_state = 12},
  [1272] = {.lex_state = 20, .external_lex_state = 12},
  [1273] = {.lex_state = 20, .external_lex_state = 12},
  [1274] = {.lex_state = 19, .external_lex_state = 12},
  [1275] = {.lex_state = 20, .external_lex_state = 12},
  [1276] = {.lex_state = 20, .external_lex_state = 12},
  [1277] = {.lex_state = 19, .external_lex_state = 12},
  [1278] = {.lex_state = 20, .external_lex_state = 12},
  [1279] = {.lex_state = 19, .external_lex_state = 12},
  [1280] = {.lex_state = 20, .external_lex_state = 12},
  [1281] = {.lex_state = 19, .external_lex_state = 12},
  [1282] = {.lex_state = 19, .external_lex_state = 12},
  [1283] = {.lex_state = 19, .external_lex_state = 12},
  [1284] = {.lex_state = 20, .external_lex_state = 12},
  [1285] = {.lex_state = 19, .external_lex_state = 12},
  [1286] = {.lex_state = 19, .external_lex_state = 12},
  [1287] = {.lex_state = 19, .external_lex_state = 12},
  [1288] = {.lex_state = 19, .external_lex_state = 12},
  [1289] = {.lex_state = 20, .external_lex_state = 12},
  [1290] = {.lex_state = 12, .external_lex_state = 12},
  [1291] = {.lex_state = 20, .external_lex_state = 12},
  [1292] = {.lex_state = 12, .external_lex_state = 12},
  [1293] = {.lex_state = 12, .external_lex_state = 12},
  [1294] = {.lex_state = 12, .external_lex_state = 12},
  [1295] = {.lex_state = 12, .external_lex_state = 12},
  [1296] = {.lex_state = 20, .external_lex_state = 12},
  [1297] = {.lex_state = 19, .external_lex_state = 12},
  [1298] = {.lex_state = 19, .external_lex_state = 12},
  [1299] = {.lex_state = 19, .external_lex_state = 2},
  [1300] = {.lex_state = 20, .external_lex_state = 12},
  [1301] = {.lex_state = 20, .external_lex_state = 12},
  [1302] = {.lex_state = 19, .external_lex_state = 2},
  [1303] = {.lex_state = 20, .external_lex_state = 12},
  [1304] = {.lex_state = 19, .external_lex_state = 12},
  [1305] = {.lex_state = 12, .external_lex_state = 4},
  [1306] = {.lex_state = 20, .external_lex_state = 12},
  [1307] = {.lex_state = 20, .external_lex_state = 12},
  [1308] = {.lex_state = 20, .external_lex_state = 12},
  [1309] = {.lex_state = 14, .external_lex_state = 8},
  [1310] = {.lex_state = 19, .external_lex_state = 12},
  [1311] = {.lex_state = 19, .external_lex_state = 12},
  [1312] = {.lex_state = 14, .external_lex_state = 8},
  [1313] = {.lex_state = 19, .external_lex_state = 12},
  [1314] = {.lex_state = 19, .external_lex_state = 12},
  [1315] = {.lex_state = 19, .external_lex_state = 12},
  [1316] = {.lex_state = 19, .external_lex_state = 12},
  [1317] = {.lex_state = 20, .external_lex_state = 12},
  [1318] = {.lex_state = 20, .external_lex_state = 12},
  [1319] = {.lex_state = 19, .external_lex_state = 12},
  [1320] = {.lex_state = 19, .external_lex_state = 12},
  [1321] = {.lex_state = 19, .external_lex_state = 12},
  [1322] = {.lex_state = 19, .external_lex_state = 12},
  [1323] = {.lex_state = 19, .external_lex_state = 12},
  [1324] = {.lex_state = 34},
  [1325] = {.lex_state = 34},
  [1326] = {.lex_state = 34},
  [1327] = {.lex_state = 34},
  [1328] = {.lex_state = 34},
  [1329] = {.lex_state = 35},
  [1330] = {.lex_state = 35},
  [1331] = {.lex_state = 35},
  [1332] = {.lex_state = 35},
  [1333] = {.lex_state = 35},
  [1334] = {.lex_state = 19, .external_lex_state = 12},
  [1335] = {.lex_state = 19, .external_lex_state = 12},
  [1336] = {.lex_state = 20, .external_lex_state = 12},
  [1337] = {.lex_state = 20, .external_lex_state = 12},
  [1338] = {.lex_state = 20, .external_lex_state = 12},
  [1339] = {.lex_state = 19, .external_lex_state = 12},
  [1340] = {.lex_state = 19, .external_lex_state = 12},
  [1341] = {.lex_state = 19, .external_lex_state = 12},
  [1342] = {.lex_state = 19, .external_lex_state = 12},
  [1343] = {.lex_state = 269, .external_lex_state = 2},
  [1344] = {.lex_state = 19, .external_lex_state = 12},
  [1345] = {.lex_state = 20, .external_lex_state = 12},
  [1346] = {.lex_state = 19, .external_lex_state = 12},
  [1347] = {.lex_state = 19, .external_lex_state = 12},
  [1348] = {.lex_state = 19, .external_lex_state = 12},
  [1349] = {.lex_state = 19, .external_lex_state = 12},
  [1350] = {.lex_state = 19, .external_lex_state = 12},
  [1351] = {.lex_state = 19, .external_lex_state = 12},
  [1352] = {.lex_state = 19, .external_lex_state = 12},
  [1353] = {.lex_state = 19, .external_lex_state = 12},
  [1354] = {.lex_state = 19, .external_lex_state = 12},
  [1355] = {.lex_state = 269, .external_lex_state = 2},
  [1356] = {.lex_state = 269, .external_lex_state = 2},
  [1357] = {.lex_state = 19, .external_lex_state = 12},
  [1358] = {.lex_state = 19, .external_lex_state = 12},
  [1359] = {.lex_state = 20, .external_lex_state = 12},
  [1360] = {.lex_state = 269, .external_lex_state = 2},
  [1361] = {.lex_state = 19, .external_lex_state = 12},
  [1362] = {.lex_state = 19, .external_lex_state = 12},
  [1363] = {.lex_state = 19, .external_lex_state = 12},
  [1364] = {.lex_state = 20, .external_lex_state = 12},
  [1365] = {.lex_state = 269, .external_lex_state = 2},
  [1366] = {.lex_state = 12, .external_lex_state = 12},
  [1367] = {.lex_state = 24, .external_lex_state = 2},
  [1368] = {.lex_state = 12, .external_lex_state = 12},
  [1369] = {.lex_state = 20, .external_lex_state = 9},
  [1370] = {.lex_state = 19, .external_lex_state = 2},
  [1371] = {.lex_state = 20, .external_lex_state = 9},
  [1372] = {.lex_state = 20, .external_lex_state = 9},
  [1373] = {.lex_state = 18, .external_lex_state = 12},
  [1374] = {.lex_state = 20, .external_lex_state = 9},
  [1375] = {.lex_state = 20, .external_lex_state = 9},
  [1376] = {.lex_state = 20, .external_lex_state = 9},
  [1377] = {.lex_state = 20, .external_lex_state = 9},
  [1378] = {.lex_state = 20, .external_lex_state = 9},
  [1379] = {.lex_state = 20, .external_lex_state = 9},
  [1380] = {.lex_state = 20, .external_lex_state = 9},
  [1381] = {.lex_state = 20, .external_lex_state = 9},
  [1382] = {.lex_state = 20, .external_lex_state = 9},
  [1383] = {.lex_state = 20, .external_lex_state = 9},
  [1384] = {.lex_state = 20, .external_lex_state = 9},
  [1385] = {.lex_state = 269, .external_lex_state = 2},
  [1386] = {.lex_state = 20, .external_lex_state = 9},
  [1387] = {.lex_state = 14, .external_lex_state = 8},
  [1388] = {.lex_state = 20, .external_lex_state = 9},
  [1389] = {.lex_state = 19, .external_lex_state = 2},
  [1390] = {.lex_state = 20, .external_lex_state = 9},
  [1391] = {.lex_state = 14, .external_lex_state = 8},
  [1392] = {.lex_state = 20, .external_lex_state = 9},
  [1393] = {.lex_state = 19, .external_lex_state = 2},
  [1394] = {.lex_state = 19, .external_lex_state = 2},
  [1395] = {.lex_state = 19, .external_lex_state = 2},
  [1396] = {.lex_state = 19, .external_lex_state = 2},
  [1397] = {.lex_state = 19, .external_lex_state = 2},
  [1398] = {.lex_state = 19, .external_lex_state = 2},
  [1399] = {.lex_state = 24, .external_lex_state = 2},
  [1400] = {.lex_state = 35},
  [1401] = {.lex_state = 19, .external_lex_state = 2},
  [1402] = {.lex_state = 12, .external_lex_state = 12},
  [1403] = {.lex_state = 19, .external_lex_state = 2},
  [1404] = {.lex_state = 19, .external_lex_state = 2},
  [1405] = {.lex_state = 19, .external_lex_state = 2},
  [1406] = {.lex_state = 19, .external_lex_state = 2},
  [1407] = {.lex_state = 19, .external_lex_state = 2},
  [1408] = {.lex_state = 19, .external_lex_state = 2},
  [1409] = {.lex_state = 19, .external_lex_state = 2},
  [1410] = {.lex_state = 19, .external_lex_state = 2},
  [1411] = {.lex_state = 24, .external_lex_state = 2},
  [1412] = {.lex_state = 19, .external_lex_state = 2},
  [1413] = {.lex_state = 19, .external_lex_state = 2},
  [1414] = {.lex_state = 19, .external_lex_state = 2},
  [1415] = {.lex_state = 19, .external_lex_state = 2},
  [1416] = {.lex_state = 19, .external_lex_state = 2},
  [1417] = {.lex_state = 19, .external_lex_state = 2},
  [1418] = {.lex_state = 19, .external_lex_state = 2},
  [1419] = {.lex_state = 19, .external_lex_state = 2},
  [1420] = {.lex_state = 19, .external_lex_state = 2},
  [1421] = {.lex_state = 19, .external_lex_state = 2},
  [1422] = {.lex_state = 19, .external_lex_state = 2},
  [1423] = {.lex_state = 19, .external_lex_state = 2},
  [1424] = {.lex_state = 19, .external_lex_state = 2},
  [1425] = {.lex_state = 24, .external_lex_state = 2},
  [1426] = {.lex_state = 18, .external_lex_state = 12},
  [1427] = {.lex_state = 24, .external_lex_state = 12},
  [1428] = {.lex_state = 19, .external_lex_state = 2},
  [1429] = {.lex_state = 19, .external_lex_state = 8},
  [1430] = {.lex_state = 18, .external_lex_state = 12},
  [1431] = {.lex_state = 19, .external_lex_state = 2},
  [1432] = {.lex_state = 12, .external_lex_state = 12},
  [1433] = {.lex_state = 34},
  [1434] = {.lex_state = 19, .external_lex_state = 2},
  [1435] = {.lex_state = 19, .external_lex_state = 2},
  [1436] = {.lex_state = 24, .external_lex_state = 2},
  [1437] = {.lex_state = 24, .external_lex_state = 2},
  [1438] = {.lex_state = 19, .external_lex_state = 2},
  [1439] = {.lex_state = 19, .external_lex_state = 2},
  [1440] = {.lex_state = 19, .external_lex_state = 2},
  [1441] = {.lex_state = 19, .external_lex_state = 2},
  [1442] = {.lex_state = 19, .external_lex_state = 2},
  [1443] = {.lex_state = 35},
  [1444] = {.lex_state = 24, .external_lex_state = 2},
  [1445] = {.lex_state = 20, .external_lex_state = 9},
  [1446] = {.lex_state = 19, .external_lex_state = 2},
  [1447] = {.lex_state = 19, .external_lex_state = 2},
  [1448] = {.lex_state = 14},
  [1449] = {.lex_state = 35},
  [1450] = {.lex_state = 19, .external_lex_state = 2},
  [1451] = {.lex_state = 19, .external_lex_state = 2},
  [1452] = {.lex_state = 19, .external_lex_state = 2},
  [1453] = {.lex_state = 19, .external_lex_state = 2},
  [1454] = {.lex_state = 35},
  [1455] = {.lex_state = 19, .external_lex_state = 2},
  [1456] = {.lex_state = 19, .external_lex_state = 2},
  [1457] = {.lex_state = 19, .external_lex_state = 2},
  [1458] = {.lex_state = 19, .external_lex_state = 2},
  [1459] = {.lex_state = 19, .external_lex_state = 2},
  [1460] = {.lex_state = 34},
  [1461] = {.lex_state = 19, .external_lex_state = 2},
  [1462] = {.lex_state = 19, .external_lex_state = 2},
  [1463] = {.lex_state = 19, .external_lex_state = 2},
  [1464] = {.lex_state = 34},
  [1465] = {.lex_state = 19, .external_lex_state = 2},
  [1466] = {.lex_state = 19, .external_lex_state = 2},
  [1467] = {.lex_state = 19, .external_lex_state = 2},
  [1468] = {.lex_state = 19, .external_lex_state = 2},
  [1469] = {.lex_state = 19, .external_lex_state = 2},
  [1470] = {.lex_state = 34, .external_lex_state = 11},
  [1471] = {.lex_state = 34, .external_lex_state = 11},
  [1472] = {.lex_state = 34, .external_lex_state = 11},
  [1473] = {.lex_state = 34, .external_lex_state = 11},
  [1474] = {.lex_state = 34, .external_lex_state = 11},
  [1475] = {.lex_state = 19, .external_lex_state = 2},
  [1476] = {.lex_state = 19, .external_lex_state = 2},
  [1477] = {.lex_state = 18, .external_lex_state = 12},
  [1478] = {.lex_state = 18, .external_lex_state = 12},
  [1479] = {.lex_state = 18, .external_lex_state = 12},
  [1480] = {.lex_state = 18, .external_lex_state = 12},
  [1481] = {.lex_state = 19, .external_lex_state = 2},
  [1482] = {.lex_state = 14},
  [1483] = {.lex_state = 19, .external_lex_state = 2},
  [1484] = {.lex_state = 19, .external_lex_state = 2},
  [1485] = {.lex_state = 271},
  [1486] = {.lex_state = 34},
  [1487] = {.lex_state = 18, .external_lex_state = 12},
  [1488] = {.lex_state = 35},
  [1489] = {.lex_state = 19, .external_lex_state = 2},
  [1490] = {.lex_state = 34},
  [1491] = {.lex_state = 19, .external_lex_state = 2},
  [1492] = {.lex_state = 19, .external_lex_state = 2},
  [1493] = {.lex_state = 19, .external_lex_state = 2},
  [1494] = {.lex_state = 12, .external_lex_state = 12},
  [1495] = {.lex_state = 12, .external_lex_state = 12},
  [1496] = {.lex_state = 12, .external_lex_state = 12},
  [1497] = {.lex_state = 12, .external_lex_state = 12},
  [1498] = {.lex_state = 12, .external_lex_state = 12},
  [1499] = {.lex_state = 269},
  [1500] = {.lex_state = 12, .external_lex_state = 12},
  [1501] = {.lex_state = 12, .external_lex_state = 12},
  [1502] = {.lex_state = 12, .external_lex_state = 6},
  [1503] = {.lex_state = 269},
  [1504] = {.lex_state = 271},
  [1505] = {.lex_state = 12, .external_lex_state = 12},
  [1506] = {.lex_state = 12, .external_lex_state = 12},
  [1507] = {.lex_state = 12, .external_lex_state = 12},
  [1508] = {.lex_state = 12, .external_lex_state = 12},
  [1509] = {.lex_state = 12, .external_lex_state = 12},
  [1510] = {.lex_state = 24, .external_lex_state = 12},
  [1511] = {.lex_state = 12, .external_lex_state = 12},
  [1512] = {.lex_state = 24, .external_lex_state = 12},
  [1513] = {.lex_state = 12, .external_lex_state = 12},
  [1514] = {.lex_state = 12, .external_lex_state = 12},
  [1515] = {.lex_state = 12, .external_lex_state = 12},
  [1516] = {.lex_state = 12, .external_lex_state = 12},
  [1517] = {.lex_state = 24, .external_lex_state = 12},
  [1518] = {.lex_state = 12, .external_lex_state = 12},
  [1519] = {.lex_state = 12, .external_lex_state = 12},
  [1520] = {.lex_state = 12, .external_lex_state = 12},
  [1521] = {.lex_state = 12, .external_lex_state = 12},
  [1522] = {.lex_state = 12, .external_lex_state = 12},
  [1523] = {.lex_state = 12, .external_lex_state = 6},
  [1524] = {.lex_state = 12, .external_lex_state = 12},
  [1525] = {.lex_state = 12, .external_lex_state = 12},
  [1526] = {.lex_state = 12, .external_lex_state = 12},
  [1527] = {.lex_state = 12, .external_lex_state = 12},
  [1528] = {.lex_state = 12, .external_lex_state = 12},
  [1529] = {.lex_state = 14},
  [1530] = {.lex_state = 12, .external_lex_state = 12},
  [1531] = {.lex_state = 12, .external_lex_state = 12},
  [1532] = {.lex_state = 12, .external_lex_state = 12},
  [1533] = {.lex_state = 12, .external_lex_state = 12},
  [1534] = {.lex_state = 12, .external_lex_state = 12},
  [1535] = {.lex_state = 12, .external_lex_state = 12},
  [1536] = {.lex_state = 12, .external_lex_state = 12},
  [1537] = {.lex_state = 12, .external_lex_state = 12},
  [1538] = {.lex_state = 12, .external_lex_state = 12},
  [1539] = {.lex_state = 269},
  [1540] = {.lex_state = 24, .external_lex_state = 12},
  [1541] = {.lex_state = 12, .external_lex_state = 12},
  [1542] = {.lex_state = 12, .external_lex_state = 12},
  [1543] = {.lex_state = 12, .external_lex_state = 12},
  [1544] = {.lex_state = 12, .external_lex_state = 12},
  [1545] = {.lex_state = 12, .external_lex_state = 12},
  [1546] = {.lex_state = 12, .external_lex_state = 12},
  [1547] = {.lex_state = 269},
  [1548] = {.lex_state = 12, .external_lex_state = 12},
  [1549] = {.lex_state = 12, .external_lex_state = 12},
  [1550] = {.lex_state = 12, .external_lex_state = 12},
  [1551] = {.lex_state = 12, .external_lex_state = 12},
  [1552] = {.lex_state = 12, .external_lex_state = 12},
  [1553] = {.lex_state = 12, .external_lex_state = 12},
  [1554] = {.lex_state = 12, .external_lex_state = 12},
  [1555] = {.lex_state = 24, .external_lex_state = 12},
  [1556] = {.lex_state = 12, .external_lex_state = 12},
  [1557] = {.lex_state = 12, .external_lex_state = 12},
  [1558] = {.lex_state = 12, .external_lex_state = 12},
  [1559] = {.lex_state = 12, .external_lex_state = 12},
  [1560] = {.lex_state = 12, .external_lex_state = 12},
  [1561] = {.lex_state = 12, .external_lex_state = 12},
  [1562] = {.lex_state = 12, .external_lex_state = 12},
  [1563] = {.lex_state = 42},
  [1564] = {.lex_state = 42},
  [1565] = {.lex_state = 42},
  [1566] = {.lex_state = 42},
  [1567] = {.lex_state = 42},
  [1568] = {.lex_state = 12, .external_lex_state = 6},
  [1569] = {.lex_state = 12, .external_lex_state = 12},
  [1570] = {.lex_state = 12, .external_lex_state = 12},
  [1571] = {.lex_state = 14},
  [1572] = {.lex_state = 24, .external_lex_state = 12},
  [1573] = {.lex_state = 12, .external_lex_state = 12},
  [1574] = {.lex_state = 12, .external_lex_state = 12},
  [1575] = {.lex_state = 14},
  [1576] = {.lex_state = 12, .external_lex_state = 12},
  [1577] = {.lex_state = 12, .external_lex_state = 12},
  [1578] = {.lex_state = 269},
  [1579] = {.lex_state = 34, .external_lex_state = 11},
  [1580] = {.lex_state = 34, .external_lex_state = 11},
  [1581] = {.lex_state = 34, .external_lex_state = 11},
  [1582] = {.lex_state = 34, .external_lex_state = 11},
  [1583] = {.lex_state = 34, .external_lex_state = 11},
  [1584] = {.lex_state = 12, .external_lex_state = 12},
  [1585] = {.lex_state = 12, .external_lex_state = 12},
  [1586] = {.lex_state = 12, .external_lex_state = 12},
  [1587] = {.lex_state = 34, .external_lex_state = 11},
  [1588] = {.lex_state = 14},
  [1589] = {.lex_state = 14},
  [1590] = {.lex_state = 269, .external_lex_state = 12},
  [1591] = {.lex_state = 34},
  [1592] = {.lex_state = 269, .external_lex_state = 12},
  [1593] = {.lex_state = 269, .external_lex_state = 12},
  [1594] = {.lex_state = 12, .external_lex_state = 6},
  [1595] = {.lex_state = 34},
  [1596] = {.lex_state = 34, .external_lex_state = 11},
  [1597] = {.lex_state = 14},
  [1598] = {.lex_state = 34, .external_lex_state = 11},
  [1599] = {.lex_state = 34, .external_lex_state = 11},
  [1600] = {.lex_state = 271},
  [1601] = {.lex_state = 34},
  [1602] = {.lex_state = 34, .external_lex_state = 11},
  [1603] = {.lex_state = 34},
  [1604] = {.lex_state = 271},
  [1605] = {.lex_state = 14},
  [1606] = {.lex_state = 269, .external_lex_state = 12},
  [1607] = {.lex_state = 269, .external_lex_state = 12},
  [1608] = {.lex_state = 14, .external_lex_state = 8},
  [1609] = {.lex_state = 34},
  [1610] = {.lex_state = 33},
  [1611] = {.lex_state = 42},
  [1612] = {.lex_state = 19, .external_lex_state = 9},
  [1613] = {.lex_state = 271},
  [1614] = {.lex_state = 33},
  [1615] = {.lex_state = 271},
  [1616] = {.lex_state = 34, .external_lex_state = 11},
  [1617] = {.lex_state = 34, .external_lex_state = 11},
  [1618] = {.lex_state = 2, .external_lex_state = 2},
  [1619] = {.lex_state = 34, .external_lex_state = 11},
  [1620] = {.lex_state = 33},
  [1621] = {.lex_state = 271},
  [1622] = {.lex_state = 42},
  [1623] = {.lex_state = 33},
  [1624] = {.lex_state = 34, .external_lex_state = 11},
  [1625] = {.lex_state = 34, .external_lex_state = 12},
  [1626] = {.lex_state = 271},
  [1627] = {.lex_state = 34, .external_lex_state = 12},
  [1628] = {.lex_state = 2, .external_lex_state = 2},
  [1629] = {.lex_state = 33},
  [1630] = {.lex_state = 33},
  [1631] = {.lex_state = 33},
  [1632] = {.lex_state = 34, .external_lex_state = 11},
  [1633] = {.lex_state = 34, .external_lex_state = 12},
  [1634] = {.lex_state = 42},
  [1635] = {.lex_state = 33},
  [1636] = {.lex_state = 33},
  [1637] = {.lex_state = 271},
  [1638] = {.lex_state = 33},
  [1639] = {.lex_state = 33},
  [1640] = {.lex_state = 34, .external_lex_state = 12},
  [1641] = {.lex_state = 42},
  [1642] = {.lex_state = 42},
  [1643] = {.lex_state = 34, .external_lex_state = 12},
  [1644] = {.lex_state = 269},
  [1645] = {.lex_state = 269},
  [1646] = {.lex_state = 19, .external_lex_state = 9},
  [1647] = {.lex_state = 269},
  [1648] = {.lex_state = 269},
  [1649] = {.lex_state = 271},
  [1650] = {.lex_state = 14},
  [1651] = {.lex_state = 269},
  [1652] = {.lex_state = 269},
  [1653] = {.lex_state = 20, .external_lex_state = 9},
  [1654] = {.lex_state = 269},
  [1655] = {.lex_state = 33},
  [1656] = {.lex_state = 19, .external_lex_state = 9},
  [1657] = {.lex_state = 269},
  [1658] = {.lex_state = 269},
  [1659] = {.lex_state = 269},
  [1660] = {.lex_state = 269},
  [1661] = {.lex_state = 14},
  [1662] = {.lex_state = 14},
  [1663] = {.lex_state = 33},
  [1664] = {.lex_state = 269},
  [1665] = {.lex_state = 269},
  [1666] = {.lex_state = 269},
  [1667] = {.lex_state = 269},
  [1668] = {.lex_state = 269},
  [1669] = {.lex_state = 14},
  [1670] = {.lex_state = 269},
  [1671] = {.lex_state = 269},
  [1672] = {.lex_state = 269},
  [1673] = {.lex_state = 269},
  [1674] = {.lex_state = 269},
  [1675] = {.lex_state = 14},
  [1676] = {.lex_state = 269},
  [1677] = {.lex_state = 19, .external_lex_state = 9},
  [1678] = {.lex_state = 269},
  [1679] = {.lex_state = 269},
  [1680] = {.lex_state = 269},
  [1681] = {.lex_state = 14},
  [1682] = {.lex_state = 269},
  [1683] = {.lex_state = 269},
  [1684] = {.lex_state = 269},
  [1685] = {.lex_state = 269},
  [1686] = {.lex_state = 269},
  [1687] = {.lex_state = 14},
  [1688] = {.lex_state = 2, .external_lex_state = 12},
  [1689] = {.lex_state = 19},
  [1690] = {.lex_state = 2, .external_lex_state = 2},
  [1691] = {.lex_state = 2, .external_lex_state = 12},
  [1692] = {.lex_state = 3},
  [1693] = {.lex_state = 2},
  [1694] = {.lex_state = 19},
  [1695] = {.lex_state = 269, .external_lex_state = 12},
  [1696] = {.lex_state = 17, .external_lex_state = 13},
  [1697] = {.lex_state = 2, .external_lex_state = 2},
  [1698] = {.lex_state = 2, .external_lex_state = 2},
  [1699] = {.lex_state = 269, .external_lex_state = 12},
  [1700] = {.lex_state = 14, .external_lex_state = 9},
  [1701] = {.lex_state = 3},
  [1702] = {.lex_state = 19},
  [1703] = {.lex_state = 41, .external_lex_state = 12},
  [1704] = {.lex_state = 269, .external_lex_state = 12},
  [1705] = {.lex_state = 2, .external_lex_state = 2},
  [1706] = {.lex_state = 2},
  [1707] = {.lex_state = 3},
  [1708] = {.lex_state = 19},
  [1709] = {.lex_state = 19},
  [1710] = {.lex_state = 269, .external_lex_state = 12},
  [1711] = {.lex_state = 12, .external_lex_state = 11},
  [1712] = {.lex_state = 41, .external_lex_state = 12},
  [1713] = {.lex_state = 269, .external_lex_state = 12},
  [1714] = {.lex_state = 269, .external_lex_state = 12},
  [1715] = {.lex_state = 2, .external_lex_state = 12},
  [1716] = {.lex_state = 2, .external_lex_state = 2},
  [1717] = {.lex_state = 12, .external_lex_state = 4},
  [1718] = {.lex_state = 19},
  [1719] = {.lex_state = 269, .external_lex_state = 12},
  [1720] = {.lex_state = 3},
  [1721] = {.lex_state = 12, .external_lex_state = 4},
  [1722] = {.lex_state = 33},
  [1723] = {.lex_state = 17},
  [1724] = {.lex_state = 19},
  [1725] = {.lex_state = 33},
  [1726] = {.lex_state = 19},
  [1727] = {.lex_state = 271},
  [1728] = {.lex_state = 2, .external_lex_state = 12},
  [1729] = {.lex_state = 0, .external_lex_state = 2},
  [1730] = {.lex_state = 33},
  [1731] = {.lex_state = 33},
  [1732] = {.lex_state = 33},
  [1733] = {.lex_state = 33},
  [1734] = {.lex_state = 33},
  [1735] = {.lex_state = 12, .external_lex_state = 9},
  [1736] = {.lex_state = 19},
  [1737] = {.lex_state = 33},
  [1738] = {.lex_state = 33},
  [1739] = {.lex_state = 33},
  [1740] = {.lex_state = 2, .external_lex_state = 12},
  [1741] = {.lex_state = 12, .external_lex_state = 9},
  [1742] = {.lex_state = 33},
  [1743] = {.lex_state = 33},
  [1744] = {.lex_state = 19},
  [1745] = {.lex_state = 33},
  [1746] = {.lex_state = 33},
  [1747] = {.lex_state = 33},
  [1748] = {.lex_state = 19},
  [1749] = {.lex_state = 33},
  [1750] = {.lex_state = 33},
  [1751] = {.lex_state = 33},
  [1752] = {.lex_state = 33},
  [1753] = {.lex_state = 33},
  [1754] = {.lex_state = 33},
  [1755] = {.lex_state = 12, .external_lex_state = 4},
  [1756] = {.lex_state = 33},
  [1757] = {.lex_state = 19},
  [1758] = {.lex_state = 0, .external_lex_state = 2},
  [1759] = {.lex_state = 19},
  [1760] = {.lex_state = 33},
  [1761] = {.lex_state = 12, .external_lex_state = 4},
  [1762] = {.lex_state = 33},
  [1763] = {.lex_state = 33},
  [1764] = {.lex_state = 33},
  [1765] = {.lex_state = 33},
  [1766] = {.lex_state = 33},
  [1767] = {.lex_state = 33},
  [1768] = {.lex_state = 33},
  [1769] = {.lex_state = 271},
  [1770] = {.lex_state = 19},
  [1771] = {.lex_state = 33},
  [1772] = {.lex_state = 33},
  [1773] = {.lex_state = 33},
  [1774] = {.lex_state = 271},
  [1775] = {.lex_state = 33},
  [1776] = {.lex_state = 19},
  [1777] = {.lex_state = 271},
  [1778] = {.lex_state = 14, .external_lex_state = 9},
  [1779] = {.lex_state = 2},
  [1780] = {.lex_state = 2},
  [1781] = {.lex_state = 2},
  [1782] = {.lex_state = 2},
  [1783] = {.lex_state = 2},
  [1784] = {.lex_state = 2},
  [1785] = {.lex_state = 19, .external_lex_state = 9},
  [1786] = {.lex_state = 2},
  [1787] = {.lex_state = 12, .external_lex_state = 6},
  [1788] = {.lex_state = 2},
  [1789] = {.lex_state = 2},
  [1790] = {.lex_state = 2},
  [1791] = {.lex_state = 2},
  [1792] = {.lex_state = 2},
  [1793] = {.lex_state = 12, .external_lex_state = 9},
  [1794] = {.lex_state = 14, .external_lex_state = 9},
  [1795] = {.lex_state = 271},
  [1796] = {.lex_state = 2},
  [1797] = {.lex_state = 2},
  [1798] = {.lex_state = 2},
  [1799] = {.lex_state = 2},
  [1800] = {.lex_state = 2},
  [1801] = {.lex_state = 2},
  [1802] = {.lex_state = 2},
  [1803] = {.lex_state = 2},
  [1804] = {.lex_state = 19},
  [1805] = {.lex_state = 2},
  [1806] = {.lex_state = 2},
  [1807] = {.lex_state = 2},
  [1808] = {.lex_state = 2},
  [1809] = {.lex_state = 2},
  [1810] = {.lex_state = 2, .external_lex_state = 12},
  [1811] = {.lex_state = 2},
  [1812] = {.lex_state = 2},
  [1813] = {.lex_state = 2},
  [1814] = {.lex_state = 2},
  [1815] = {.lex_state = 0, .external_lex_state = 12},
  [1816] = {.lex_state = 0, .external_lex_state = 2},
  [1817] = {.lex_state = 2, .external_lex_state = 12},
  [1818] = {.lex_state = 0},
  [1819] = {.lex_state = 41, .external_lex_state = 12},
  [1820] = {.lex_state = 2},
  [1821] = {.lex_state = 0, .external_lex_state = 2},
  [1822] = {.lex_state = 2},
  [1823] = {.lex_state = 2, .external_lex_state = 12},
  [1824] = {.lex_state = 0, .external_lex_state = 11},
  [1825] = {.lex_state = 0},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 0, .external_lex_state = 12},
  [1828] = {.lex_state = 19},
  [1829] = {.lex_state = 0, .external_lex_state = 2},
  [1830] = {.lex_state = 0, .external_lex_state = 2},
  [1831] = {.lex_state = 0, .external_lex_state = 2},
  [1832] = {.lex_state = 2},
  [1833] = {.lex_state = 2},
  [1834] = {.lex_state = 0, .external_lex_state = 2},
  [1835] = {.lex_state = 2},
  [1836] = {.lex_state = 0, .external_lex_state = 12},
  [1837] = {.lex_state = 2},
  [1838] = {.lex_state = 2, .external_lex_state = 12},
  [1839] = {.lex_state = 2},
  [1840] = {.lex_state = 2},
  [1841] = {.lex_state = 2},
  [1842] = {.lex_state = 2},
  [1843] = {.lex_state = 2},
  [1844] = {.lex_state = 2, .external_lex_state = 12},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 0},
  [1847] = {.lex_state = 0},
  [1848] = {.lex_state = 2},
  [1849] = {.lex_state = 2, .external_lex_state = 12},
  [1850] = {.lex_state = 19},
  [1851] = {.lex_state = 2},
  [1852] = {.lex_state = 0, .external_lex_state = 2},
  [1853] = {.lex_state = 0, .external_lex_state = 12},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 271},
  [1856] = {.lex_state = 2},
  [1857] = {.lex_state = 2},
  [1858] = {.lex_state = 0, .external_lex_state = 2},
  [1859] = {.lex_state = 271, .external_lex_state = 11},
  [1860] = {.lex_state = 2, .external_lex_state = 12},
  [1861] = {.lex_state = 0},
  [1862] = {.lex_state = 12},
  [1863] = {.lex_state = 2},
  [1864] = {.lex_state = 2, .external_lex_state = 12},
  [1865] = {.lex_state = 2},
  [1866] = {.lex_state = 2},
  [1867] = {.lex_state = 2, .external_lex_state = 12},
  [1868] = {.lex_state = 2},
  [1869] = {.lex_state = 271},
  [1870] = {.lex_state = 12, .external_lex_state = 8},
  [1871] = {.lex_state = 2, .external_lex_state = 12},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0, .external_lex_state = 11},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 2},
  [1876] = {.lex_state = 2, .external_lex_state = 12},
  [1877] = {.lex_state = 2, .external_lex_state = 12},
  [1878] = {.lex_state = 2},
  [1879] = {.lex_state = 0, .external_lex_state = 12},
  [1880] = {.lex_state = 12, .external_lex_state = 8},
  [1881] = {.lex_state = 271, .external_lex_state = 11},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 0, .external_lex_state = 12},
  [1884] = {.lex_state = 0, .external_lex_state = 12},
  [1885] = {.lex_state = 0, .external_lex_state = 12},
  [1886] = {.lex_state = 271, .external_lex_state = 11},
  [1887] = {.lex_state = 0, .external_lex_state = 12},
  [1888] = {.lex_state = 0, .external_lex_state = 12},
  [1889] = {.lex_state = 0, .external_lex_state = 12},
  [1890] = {.lex_state = 269},
  [1891] = {.lex_state = 2, .external_lex_state = 2},
  [1892] = {.lex_state = 269, .external_lex_state = 5},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 14, .external_lex_state = 9},
  [1895] = {.lex_state = 2, .external_lex_state = 2},
  [1896] = {.lex_state = 0},
  [1897] = {.lex_state = 271, .external_lex_state = 11},
  [1898] = {.lex_state = 12, .external_lex_state = 11},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 30},
  [1901] = {.lex_state = 0},
  [1902] = {.lex_state = 0, .external_lex_state = 12},
  [1903] = {.lex_state = 0, .external_lex_state = 11},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 0, .external_lex_state = 12},
  [1906] = {.lex_state = 2, .external_lex_state = 2},
  [1907] = {.lex_state = 0, .external_lex_state = 11},
  [1908] = {.lex_state = 269},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 2},
  [1911] = {.lex_state = 0, .external_lex_state = 12},
  [1912] = {.lex_state = 0},
  [1913] = {.lex_state = 2},
  [1914] = {.lex_state = 0, .external_lex_state = 12},
  [1915] = {.lex_state = 271},
  [1916] = {.lex_state = 0, .external_lex_state = 11},
  [1917] = {.lex_state = 30},
  [1918] = {.lex_state = 269},
  [1919] = {.lex_state = 0, .external_lex_state = 12},
  [1920] = {.lex_state = 0},
  [1921] = {.lex_state = 0, .external_lex_state = 12},
  [1922] = {.lex_state = 269},
  [1923] = {.lex_state = 2},
  [1924] = {.lex_state = 0},
  [1925] = {.lex_state = 271, .external_lex_state = 11},
  [1926] = {.lex_state = 12, .external_lex_state = 8},
  [1927] = {.lex_state = 0},
  [1928] = {.lex_state = 30},
  [1929] = {.lex_state = 2},
  [1930] = {.lex_state = 269},
  [1931] = {.lex_state = 0, .external_lex_state = 12},
  [1932] = {.lex_state = 0, .external_lex_state = 12},
  [1933] = {.lex_state = 2},
  [1934] = {.lex_state = 0, .external_lex_state = 12},
  [1935] = {.lex_state = 0, .external_lex_state = 12},
  [1936] = {.lex_state = 12, .external_lex_state = 11},
  [1937] = {.lex_state = 0, .external_lex_state = 12},
  [1938] = {.lex_state = 0},
  [1939] = {.lex_state = 269},
  [1940] = {.lex_state = 30},
  [1941] = {.lex_state = 269},
  [1942] = {.lex_state = 0},
  [1943] = {.lex_state = 0, .external_lex_state = 12},
  [1944] = {.lex_state = 0},
  [1945] = {.lex_state = 0, .external_lex_state = 12},
  [1946] = {.lex_state = 0, .external_lex_state = 12},
  [1947] = {.lex_state = 269},
  [1948] = {.lex_state = 271, .external_lex_state = 12},
  [1949] = {.lex_state = 0, .external_lex_state = 12},
  [1950] = {.lex_state = 12},
  [1951] = {.lex_state = 0, .external_lex_state = 12},
  [1952] = {.lex_state = 30},
  [1953] = {.lex_state = 269},
  [1954] = {.lex_state = 2},
  [1955] = {.lex_state = 30},
  [1956] = {.lex_state = 271, .external_lex_state = 11},
  [1957] = {.lex_state = 0, .external_lex_state = 12},
  [1958] = {.lex_state = 30},
  [1959] = {.lex_state = 0},
  [1960] = {.lex_state = 271, .external_lex_state = 11},
  [1961] = {.lex_state = 269},
  [1962] = {.lex_state = 0, .external_lex_state = 11},
  [1963] = {.lex_state = 0, .external_lex_state = 11},
  [1964] = {.lex_state = 0, .external_lex_state = 11},
  [1965] = {.lex_state = 271, .external_lex_state = 12},
  [1966] = {.lex_state = 269},
  [1967] = {.lex_state = 269},
  [1968] = {.lex_state = 0},
  [1969] = {.lex_state = 271, .external_lex_state = 12},
  [1970] = {.lex_state = 0},
  [1971] = {.lex_state = 8},
  [1972] = {.lex_state = 0, .external_lex_state = 11},
  [1973] = {.lex_state = 8},
  [1974] = {.lex_state = 269},
  [1975] = {.lex_state = 8},
  [1976] = {.lex_state = 0},
  [1977] = {.lex_state = 8},
  [1978] = {.lex_state = 0, .external_lex_state = 11},
  [1979] = {.lex_state = 269},
  [1980] = {.lex_state = 8},
  [1981] = {.lex_state = 8},
  [1982] = {.lex_state = 0},
  [1983] = {.lex_state = 269},
  [1984] = {.lex_state = 269},
  [1985] = {.lex_state = 269},
  [1986] = {.lex_state = 269},
  [1987] = {.lex_state = 269},
  [1988] = {.lex_state = 269},
  [1989] = {.lex_state = 0, .external_lex_state = 11},
  [1990] = {.lex_state = 269},
  [1991] = {.lex_state = 269},
  [1992] = {.lex_state = 269},
  [1993] = {.lex_state = 0, .external_lex_state = 11},
  [1994] = {.lex_state = 269},
  [1995] = {.lex_state = 2},
  [1996] = {.lex_state = 0, .external_lex_state = 11},
  [1997] = {.lex_state = 269},
  [1998] = {.lex_state = 269},
  [1999] = {.lex_state = 8},
  [2000] = {.lex_state = 0, .external_lex_state = 11},
  [2001] = {.lex_state = 0, .external_lex_state = 11},
  [2002] = {.lex_state = 0, .external_lex_state = 12},
  [2003] = {.lex_state = 269},
  [2004] = {.lex_state = 269},
  [2005] = {.lex_state = 0, .external_lex_state = 11},
  [2006] = {.lex_state = 0, .external_lex_state = 11},
  [2007] = {.lex_state = 0, .external_lex_state = 11},
  [2008] = {.lex_state = 2},
  [2009] = {.lex_state = 0, .external_lex_state = 11},
  [2010] = {.lex_state = 0, .external_lex_state = 11},
  [2011] = {.lex_state = 269},
  [2012] = {.lex_state = 271},
  [2013] = {.lex_state = 0, .external_lex_state = 2},
  [2014] = {.lex_state = 0},
  [2015] = {.lex_state = 0, .external_lex_state = 11},
  [2016] = {.lex_state = 0},
  [2017] = {.lex_state = 0, .external_lex_state = 11},
  [2018] = {.lex_state = 269},
  [2019] = {.lex_state = 12, .external_lex_state = 9},
  [2020] = {.lex_state = 0},
  [2021] = {.lex_state = 0, .external_lex_state = 11},
  [2022] = {.lex_state = 0, .external_lex_state = 11},
  [2023] = {.lex_state = 0, .external_lex_state = 11},
  [2024] = {.lex_state = 8},
  [2025] = {.lex_state = 0, .external_lex_state = 2},
  [2026] = {.lex_state = 0, .external_lex_state = 11},
  [2027] = {.lex_state = 0, .external_lex_state = 11},
  [2028] = {.lex_state = 0},
  [2029] = {.lex_state = 0, .external_lex_state = 11},
  [2030] = {.lex_state = 269},
  [2031] = {.lex_state = 0},
  [2032] = {.lex_state = 0, .external_lex_state = 11},
  [2033] = {.lex_state = 2},
  [2034] = {.lex_state = 269},
  [2035] = {.lex_state = 0, .external_lex_state = 11},
  [2036] = {.lex_state = 0, .external_lex_state = 11},
  [2037] = {.lex_state = 0, .external_lex_state = 11},
  [2038] = {.lex_state = 0},
  [2039] = {.lex_state = 8},
  [2040] = {.lex_state = 0, .external_lex_state = 11},
  [2041] = {.lex_state = 0, .external_lex_state = 11},
  [2042] = {.lex_state = 269},
  [2043] = {.lex_state = 8},
  [2044] = {.lex_state = 269},
  [2045] = {.lex_state = 0, .external_lex_state = 11},
  [2046] = {.lex_state = 0, .external_lex_state = 11},
  [2047] = {.lex_state = 271},
  [2048] = {.lex_state = 271},
  [2049] = {.lex_state = 271},
  [2050] = {.lex_state = 0, .external_lex_state = 11},
  [2051] = {.lex_state = 0},
  [2052] = {.lex_state = 0, .external_lex_state = 11},
  [2053] = {.lex_state = 269},
  [2054] = {.lex_state = 0, .external_lex_state = 11},
  [2055] = {.lex_state = 12, .external_lex_state = 11},
  [2056] = {.lex_state = 8},
  [2057] = {.lex_state = 0, .external_lex_state = 11},
  [2058] = {.lex_state = 0, .external_lex_state = 11},
  [2059] = {.lex_state = 0},
  [2060] = {.lex_state = 12, .external_lex_state = 11},
  [2061] = {.lex_state = 0},
  [2062] = {.lex_state = 271, .external_lex_state = 12},
  [2063] = {.lex_state = 269},
  [2064] = {.lex_state = 0, .external_lex_state = 12},
  [2065] = {.lex_state = 0, .external_lex_state = 2},
  [2066] = {.lex_state = 0, .external_lex_state = 2},
  [2067] = {.lex_state = 0, .external_lex_state = 2},
  [2068] = {.lex_state = 269},
  [2069] = {.lex_state = 0, .external_lex_state = 11},
  [2070] = {.lex_state = 0, .external_lex_state = 11},
  [2071] = {.lex_state = 0, .external_lex_state = 11},
  [2072] = {.lex_state = 0, .external_lex_state = 11},
  [2073] = {.lex_state = 8},
  [2074] = {.lex_state = 0, .external_lex_state = 2},
  [2075] = {.lex_state = 0, .external_lex_state = 2},
  [2076] = {.lex_state = 0, .external_lex_state = 11},
  [2077] = {.lex_state = 0, .external_lex_state = 12},
  [2078] = {.lex_state = 0, .external_lex_state = 11},
  [2079] = {.lex_state = 8},
  [2080] = {.lex_state = 271, .external_lex_state = 12},
  [2081] = {.lex_state = 0},
  [2082] = {.lex_state = 269},
  [2083] = {.lex_state = 269},
  [2084] = {.lex_state = 0, .external_lex_state = 11},
  [2085] = {.lex_state = 0, .external_lex_state = 11},
  [2086] = {.lex_state = 0},
  [2087] = {.lex_state = 2},
  [2088] = {.lex_state = 0, .external_lex_state = 11},
  [2089] = {.lex_state = 0, .external_lex_state = 11},
  [2090] = {.lex_state = 0, .external_lex_state = 11},
  [2091] = {.lex_state = 17},
  [2092] = {.lex_state = 0, .external_lex_state = 2},
  [2093] = {.lex_state = 0},
  [2094] = {.lex_state = 269},
  [2095] = {.lex_state = 2},
  [2096] = {.lex_state = 0},
  [2097] = {.lex_state = 269},
  [2098] = {.lex_state = 269},
  [2099] = {.lex_state = 8},
  [2100] = {.lex_state = 0, .external_lex_state = 11},
  [2101] = {.lex_state = 0, .external_lex_state = 11},
  [2102] = {.lex_state = 271},
  [2103] = {.lex_state = 0},
  [2104] = {.lex_state = 0, .external_lex_state = 11},
  [2105] = {.lex_state = 2},
  [2106] = {.lex_state = 0},
  [2107] = {.lex_state = 0},
  [2108] = {.lex_state = 0},
  [2109] = {.lex_state = 2},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 269},
  [2113] = {.lex_state = 8},
  [2114] = {.lex_state = 269},
  [2115] = {.lex_state = 0, .external_lex_state = 11},
  [2116] = {.lex_state = 0},
  [2117] = {.lex_state = 271, .external_lex_state = 12},
  [2118] = {.lex_state = 2},
  [2119] = {.lex_state = 0, .external_lex_state = 11},
  [2120] = {.lex_state = 0, .external_lex_state = 11},
  [2121] = {.lex_state = 0, .external_lex_state = 11},
  [2122] = {.lex_state = 0, .external_lex_state = 12},
  [2123] = {.lex_state = 0, .external_lex_state = 11},
  [2124] = {.lex_state = 0, .external_lex_state = 11},
  [2125] = {.lex_state = 0, .external_lex_state = 2},
  [2126] = {.lex_state = 269},
  [2127] = {.lex_state = 0},
  [2128] = {.lex_state = 0, .external_lex_state = 12},
  [2129] = {.lex_state = 0, .external_lex_state = 12},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 0},
  [2132] = {.lex_state = 0, .external_lex_state = 12},
  [2133] = {.lex_state = 0, .external_lex_state = 12},
  [2134] = {.lex_state = 0, .external_lex_state = 12},
  [2135] = {.lex_state = 0},
  [2136] = {.lex_state = 0, .external_lex_state = 12},
  [2137] = {.lex_state = 0},
  [2138] = {.lex_state = 0},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 269},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 0, .external_lex_state = 12},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0, .external_lex_state = 12},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 8},
  [2147] = {.lex_state = 0, .external_lex_state = 11},
  [2148] = {.lex_state = 0, .external_lex_state = 12},
  [2149] = {.lex_state = 0, .external_lex_state = 12},
  [2150] = {.lex_state = 0, .external_lex_state = 11},
  [2151] = {.lex_state = 39},
  [2152] = {.lex_state = 2},
  [2153] = {.lex_state = 0, .external_lex_state = 12},
  [2154] = {.lex_state = 0, .external_lex_state = 12},
  [2155] = {.lex_state = 0, .external_lex_state = 11},
  [2156] = {.lex_state = 269, .external_lex_state = 5},
  [2157] = {.lex_state = 0},
  [2158] = {.lex_state = 0, .external_lex_state = 12},
  [2159] = {.lex_state = 0, .external_lex_state = 12},
  [2160] = {.lex_state = 0, .external_lex_state = 12},
  [2161] = {.lex_state = 0, .external_lex_state = 12},
  [2162] = {.lex_state = 0, .external_lex_state = 11},
  [2163] = {.lex_state = 0, .external_lex_state = 11},
  [2164] = {.lex_state = 0, .external_lex_state = 12},
  [2165] = {.lex_state = 0, .external_lex_state = 11},
  [2166] = {.lex_state = 2},
  [2167] = {.lex_state = 2},
  [2168] = {.lex_state = 0, .external_lex_state = 12},
  [2169] = {.lex_state = 0},
  [2170] = {.lex_state = 0, .external_lex_state = 12},
  [2171] = {.lex_state = 0, .external_lex_state = 12},
  [2172] = {.lex_state = 0},
  [2173] = {.lex_state = 2},
  [2174] = {.lex_state = 2},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0, .external_lex_state = 12},
  [2177] = {.lex_state = 0, .external_lex_state = 12},
  [2178] = {.lex_state = 0, .external_lex_state = 2},
  [2179] = {.lex_state = 2},
  [2180] = {.lex_state = 0, .external_lex_state = 12},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 269, .external_lex_state = 5},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 0, .external_lex_state = 12},
  [2185] = {.lex_state = 0, .external_lex_state = 12},
  [2186] = {.lex_state = 0, .external_lex_state = 12},
  [2187] = {.lex_state = 0},
  [2188] = {.lex_state = 0, .external_lex_state = 12},
  [2189] = {.lex_state = 0, .external_lex_state = 12},
  [2190] = {.lex_state = 0, .external_lex_state = 12},
  [2191] = {.lex_state = 0, .external_lex_state = 12},
  [2192] = {.lex_state = 39},
  [2193] = {.lex_state = 0, .external_lex_state = 12},
  [2194] = {.lex_state = 269},
  [2195] = {.lex_state = 0, .external_lex_state = 11},
  [2196] = {.lex_state = 0, .external_lex_state = 11},
  [2197] = {.lex_state = 269},
  [2198] = {.lex_state = 0, .external_lex_state = 12},
  [2199] = {.lex_state = 2},
  [2200] = {.lex_state = 2},
  [2201] = {.lex_state = 2},
  [2202] = {.lex_state = 2},
  [2203] = {.lex_state = 0, .external_lex_state = 12},
  [2204] = {.lex_state = 2},
  [2205] = {.lex_state = 0, .external_lex_state = 11},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 39},
  [2208] = {.lex_state = 269, .external_lex_state = 5},
  [2209] = {.lex_state = 0, .external_lex_state = 12},
  [2210] = {.lex_state = 0},
  [2211] = {.lex_state = 2},
  [2212] = {.lex_state = 2},
  [2213] = {.lex_state = 2},
  [2214] = {.lex_state = 0},
  [2215] = {.lex_state = 2},
  [2216] = {.lex_state = 269},
  [2217] = {.lex_state = 0},
  [2218] = {.lex_state = 269},
  [2219] = {.lex_state = 0},
  [2220] = {.lex_state = 0},
  [2221] = {.lex_state = 0, .external_lex_state = 12},
  [2222] = {.lex_state = 14},
  [2223] = {.lex_state = 0, .external_lex_state = 11},
  [2224] = {.lex_state = 0, .external_lex_state = 12},
  [2225] = {.lex_state = 0, .external_lex_state = 12},
  [2226] = {.lex_state = 2},
  [2227] = {.lex_state = 0, .external_lex_state = 12},
  [2228] = {.lex_state = 0, .external_lex_state = 11},
  [2229] = {.lex_state = 0, .external_lex_state = 2},
  [2230] = {.lex_state = 0},
  [2231] = {.lex_state = 2},
  [2232] = {.lex_state = 0, .external_lex_state = 12},
  [2233] = {.lex_state = 0, .external_lex_state = 12},
  [2234] = {.lex_state = 0, .external_lex_state = 12},
  [2235] = {.lex_state = 2},
  [2236] = {.lex_state = 269, .external_lex_state = 5},
  [2237] = {.lex_state = 0, .external_lex_state = 12},
  [2238] = {.lex_state = 0, .external_lex_state = 11},
  [2239] = {.lex_state = 0, .external_lex_state = 12},
  [2240] = {.lex_state = 269},
  [2241] = {.lex_state = 0, .external_lex_state = 12},
  [2242] = {.lex_state = 2},
  [2243] = {.lex_state = 0},
  [2244] = {.lex_state = 0, .external_lex_state = 12},
  [2245] = {.lex_state = 0, .external_lex_state = 2},
  [2246] = {.lex_state = 0, .external_lex_state = 12},
  [2247] = {.lex_state = 0, .external_lex_state = 11},
  [2248] = {.lex_state = 0, .external_lex_state = 12},
  [2249] = {.lex_state = 2},
  [2250] = {.lex_state = 2},
  [2251] = {.lex_state = 0, .external_lex_state = 12},
  [2252] = {.lex_state = 39},
  [2253] = {.lex_state = 0},
  [2254] = {.lex_state = 0, .external_lex_state = 12},
  [2255] = {.lex_state = 0, .external_lex_state = 12},
  [2256] = {.lex_state = 39},
  [2257] = {.lex_state = 0},
  [2258] = {.lex_state = 0, .external_lex_state = 12},
  [2259] = {.lex_state = 0, .external_lex_state = 12},
  [2260] = {.lex_state = 0, .external_lex_state = 12},
  [2261] = {.lex_state = 0, .external_lex_state = 12},
  [2262] = {.lex_state = 0, .external_lex_state = 12},
  [2263] = {.lex_state = 16},
  [2264] = {.lex_state = 0, .external_lex_state = 12},
  [2265] = {.lex_state = 0, .external_lex_state = 12},
  [2266] = {.lex_state = 0, .external_lex_state = 11},
  [2267] = {.lex_state = 269},
  [2268] = {.lex_state = 0, .external_lex_state = 12},
  [2269] = {.lex_state = 0},
  [2270] = {.lex_state = 0, .external_lex_state = 12},
  [2271] = {.lex_state = 0, .external_lex_state = 12},
  [2272] = {.lex_state = 0},
  [2273] = {.lex_state = 269},
  [2274] = {.lex_state = 0, .external_lex_state = 11},
  [2275] = {.lex_state = 0, .external_lex_state = 12},
  [2276] = {.lex_state = 0, .external_lex_state = 12},
  [2277] = {.lex_state = 0, .external_lex_state = 12},
  [2278] = {.lex_state = 0},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 0, .external_lex_state = 12},
  [2281] = {.lex_state = 0, .external_lex_state = 2},
  [2282] = {.lex_state = 0, .external_lex_state = 12},
  [2283] = {.lex_state = 0},
  [2284] = {.lex_state = 0, .external_lex_state = 12},
  [2285] = {.lex_state = 0},
  [2286] = {.lex_state = 269, .external_lex_state = 5},
  [2287] = {.lex_state = 0, .external_lex_state = 9},
  [2288] = {.lex_state = 0},
  [2289] = {.lex_state = 2},
  [2290] = {.lex_state = 0},
  [2291] = {.lex_state = 0, .external_lex_state = 12},
  [2292] = {.lex_state = 269},
  [2293] = {.lex_state = 2},
  [2294] = {.lex_state = 0, .external_lex_state = 12},
  [2295] = {.lex_state = 2},
  [2296] = {.lex_state = 269},
  [2297] = {.lex_state = 0},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 269},
  [2300] = {.lex_state = 0},
  [2301] = {.lex_state = 269},
  [2302] = {.lex_state = 0, .external_lex_state = 11},
  [2303] = {.lex_state = 0},
  [2304] = {.lex_state = 0},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 0},
  [2307] = {.lex_state = 0, .external_lex_state = 11},
  [2308] = {.lex_state = 269},
  [2309] = {.lex_state = 0, .external_lex_state = 9},
  [2310] = {.lex_state = 269},
  [2311] = {.lex_state = 39},
  [2312] = {.lex_state = 0, .external_lex_state = 11},
  [2313] = {.lex_state = 269},
  [2314] = {.lex_state = 0, .external_lex_state = 11},
  [2315] = {.lex_state = 0, .external_lex_state = 11},
  [2316] = {.lex_state = 0, .external_lex_state = 12},
  [2317] = {.lex_state = 269},
  [2318] = {.lex_state = 0},
  [2319] = {.lex_state = 0, .external_lex_state = 9},
  [2320] = {.lex_state = 0, .external_lex_state = 12},
  [2321] = {.lex_state = 0, .external_lex_state = 11},
  [2322] = {.lex_state = 0, .external_lex_state = 11},
  [2323] = {.lex_state = 0, .external_lex_state = 11},
  [2324] = {.lex_state = 0},
  [2325] = {.lex_state = 0},
  [2326] = {.lex_state = 0},
  [2327] = {.lex_state = 0, .external_lex_state = 11},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 0, .external_lex_state = 12},
  [2330] = {.lex_state = 0},
  [2331] = {.lex_state = 0},
  [2332] = {.lex_state = 0, .external_lex_state = 11},
  [2333] = {.lex_state = 39},
  [2334] = {.lex_state = 0, .external_lex_state = 9},
  [2335] = {.lex_state = 0, .external_lex_state = 9},
  [2336] = {.lex_state = 0},
  [2337] = {.lex_state = 269},
  [2338] = {.lex_state = 2},
  [2339] = {.lex_state = 0},
  [2340] = {.lex_state = 0, .external_lex_state = 11},
  [2341] = {.lex_state = 0, .external_lex_state = 11},
  [2342] = {.lex_state = 0, .external_lex_state = 12},
  [2343] = {.lex_state = 0, .external_lex_state = 11},
  [2344] = {.lex_state = 0},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 0},
  [2347] = {.lex_state = 0, .external_lex_state = 9},
  [2348] = {.lex_state = 0},
  [2349] = {.lex_state = 0},
  [2350] = {.lex_state = 0},
  [2351] = {.lex_state = 0, .external_lex_state = 11},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 14},
  [2354] = {.lex_state = 49},
  [2355] = {.lex_state = 269},
  [2356] = {.lex_state = 0},
  [2357] = {.lex_state = 0},
  [2358] = {.lex_state = 0},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 0},
  [2361] = {.lex_state = 0},
  [2362] = {.lex_state = 0, .external_lex_state = 9},
  [2363] = {.lex_state = 0, .external_lex_state = 12},
  [2364] = {.lex_state = 0, .external_lex_state = 9},
  [2365] = {.lex_state = 0, .external_lex_state = 9},
  [2366] = {.lex_state = 0, .external_lex_state = 12},
  [2367] = {.lex_state = 0, .external_lex_state = 9},
  [2368] = {.lex_state = 0, .external_lex_state = 11},
  [2369] = {.lex_state = 269},
  [2370] = {.lex_state = 0, .external_lex_state = 9},
  [2371] = {.lex_state = 0},
  [2372] = {.lex_state = 0, .external_lex_state = 9},
  [2373] = {.lex_state = 0},
  [2374] = {.lex_state = 0},
  [2375] = {.lex_state = 0},
  [2376] = {.lex_state = 0},
  [2377] = {.lex_state = 269, .external_lex_state = 5},
  [2378] = {.lex_state = 0, .external_lex_state = 12},
  [2379] = {.lex_state = 0, .external_lex_state = 9},
  [2380] = {.lex_state = 0},
  [2381] = {.lex_state = 269},
  [2382] = {.lex_state = 0},
  [2383] = {.lex_state = 0, .external_lex_state = 9},
  [2384] = {.lex_state = 0, .external_lex_state = 9},
  [2385] = {.lex_state = 0, .external_lex_state = 9},
  [2386] = {.lex_state = 0, .external_lex_state = 9},
  [2387] = {.lex_state = 0},
  [2388] = {.lex_state = 0},
  [2389] = {.lex_state = 0, .external_lex_state = 9},
  [2390] = {.lex_state = 0},
  [2391] = {.lex_state = 0, .external_lex_state = 9},
  [2392] = {.lex_state = 0},
  [2393] = {.lex_state = 0, .external_lex_state = 12},
  [2394] = {.lex_state = 0},
  [2395] = {.lex_state = 0, .external_lex_state = 9},
  [2396] = {.lex_state = 0},
  [2397] = {.lex_state = 0},
  [2398] = {.lex_state = 0},
  [2399] = {.lex_state = 269},
  [2400] = {.lex_state = 269},
  [2401] = {.lex_state = 14},
  [2402] = {.lex_state = 0, .external_lex_state = 9},
  [2403] = {.lex_state = 0},
  [2404] = {.lex_state = 0},
  [2405] = {.lex_state = 0},
  [2406] = {.lex_state = 0, .external_lex_state = 9},
  [2407] = {.lex_state = 0},
  [2408] = {.lex_state = 49},
  [2409] = {.lex_state = 0},
  [2410] = {.lex_state = 0},
  [2411] = {.lex_state = 0, .external_lex_state = 11},
  [2412] = {.lex_state = 0},
  [2413] = {.lex_state = 0},
  [2414] = {.lex_state = 0},
  [2415] = {.lex_state = 0, .external_lex_state = 12},
  [2416] = {.lex_state = 2},
  [2417] = {.lex_state = 269},
  [2418] = {.lex_state = 269},
  [2419] = {.lex_state = 269},
  [2420] = {.lex_state = 0},
  [2421] = {.lex_state = 269},
  [2422] = {.lex_state = 0, .external_lex_state = 9},
  [2423] = {.lex_state = 0, .external_lex_state = 11},
  [2424] = {.lex_state = 269},
  [2425] = {.lex_state = 0},
  [2426] = {.lex_state = 0, .external_lex_state = 11},
  [2427] = {.lex_state = 0},
  [2428] = {.lex_state = 0},
  [2429] = {.lex_state = 0, .external_lex_state = 9},
  [2430] = {.lex_state = 0},
  [2431] = {.lex_state = 0},
  [2432] = {.lex_state = 0},
  [2433] = {.lex_state = 0},
  [2434] = {.lex_state = 0},
  [2435] = {.lex_state = 49},
  [2436] = {.lex_state = 0},
  [2437] = {.lex_state = 269, .external_lex_state = 5},
  [2438] = {.lex_state = 0},
  [2439] = {.lex_state = 0, .external_lex_state = 9},
  [2440] = {.lex_state = 0},
  [2441] = {.lex_state = 269},
  [2442] = {.lex_state = 0, .external_lex_state = 12},
  [2443] = {.lex_state = 0},
  [2444] = {.lex_state = 0, .external_lex_state = 12},
  [2445] = {.lex_state = 0},
  [2446] = {.lex_state = 0},
  [2447] = {.lex_state = 0, .external_lex_state = 9},
  [2448] = {.lex_state = 0, .external_lex_state = 12},
  [2449] = {.lex_state = 0},
  [2450] = {.lex_state = 0, .external_lex_state = 9},
  [2451] = {.lex_state = 0},
  [2452] = {.lex_state = 0, .external_lex_state = 12},
  [2453] = {.lex_state = 0, .external_lex_state = 9},
  [2454] = {.lex_state = 0},
  [2455] = {.lex_state = 0},
  [2456] = {.lex_state = 0},
  [2457] = {.lex_state = 0},
  [2458] = {.lex_state = 0},
  [2459] = {.lex_state = 0, .external_lex_state = 11},
  [2460] = {.lex_state = 0},
  [2461] = {.lex_state = 0, .external_lex_state = 12},
  [2462] = {.lex_state = 0, .external_lex_state = 9},
  [2463] = {.lex_state = 0, .external_lex_state = 12},
  [2464] = {.lex_state = 49},
  [2465] = {.lex_state = 0, .external_lex_state = 9},
  [2466] = {.lex_state = 0},
  [2467] = {.lex_state = 0, .external_lex_state = 9},
  [2468] = {.lex_state = 0, .external_lex_state = 11},
  [2469] = {.lex_state = 0},
  [2470] = {.lex_state = 0},
  [2471] = {.lex_state = 269},
  [2472] = {.lex_state = 0},
  [2473] = {.lex_state = 0},
  [2474] = {.lex_state = 0, .external_lex_state = 12},
  [2475] = {.lex_state = 0},
  [2476] = {.lex_state = 0},
  [2477] = {.lex_state = 0},
  [2478] = {.lex_state = 49},
  [2479] = {.lex_state = 269},
  [2480] = {.lex_state = 0},
  [2481] = {.lex_state = 269},
  [2482] = {.lex_state = 0},
  [2483] = {.lex_state = 0, .external_lex_state = 11},
  [2484] = {.lex_state = 0},
  [2485] = {.lex_state = 0},
  [2486] = {.lex_state = 49},
  [2487] = {.lex_state = 0, .external_lex_state = 12},
  [2488] = {.lex_state = 0},
  [2489] = {.lex_state = 0},
  [2490] = {.lex_state = 0},
  [2491] = {.lex_state = 0, .external_lex_state = 11},
  [2492] = {.lex_state = 0, .external_lex_state = 12},
  [2493] = {.lex_state = 0, .external_lex_state = 11},
  [2494] = {.lex_state = 0, .external_lex_state = 11},
  [2495] = {.lex_state = 269},
  [2496] = {.lex_state = 0},
  [2497] = {.lex_state = 0},
  [2498] = {.lex_state = 269},
  [2499] = {.lex_state = 0},
  [2500] = {.lex_state = 0},
  [2501] = {.lex_state = 269},
  [2502] = {.lex_state = 0, .external_lex_state = 11},
  [2503] = {.lex_state = 269},
  [2504] = {.lex_state = 0},
  [2505] = {.lex_state = 0},
  [2506] = {.lex_state = 0, .external_lex_state = 11},
  [2507] = {.lex_state = 269},
  [2508] = {.lex_state = 269},
  [2509] = {.lex_state = 0},
  [2510] = {.lex_state = 0, .external_lex_state = 11},
  [2511] = {.lex_state = 269},
  [2512] = {.lex_state = 0},
  [2513] = {.lex_state = 269},
  [2514] = {.lex_state = 0},
  [2515] = {.lex_state = 269},
  [2516] = {.lex_state = 269},
  [2517] = {.lex_state = 0},
  [2518] = {.lex_state = 0, .external_lex_state = 11},
  [2519] = {.lex_state = 269},
  [2520] = {.lex_state = 0, .external_lex_state = 11},
  [2521] = {.lex_state = 0, .external_lex_state = 11},
  [2522] = {.lex_state = 0},
  [2523] = {.lex_state = 0, .external_lex_state = 11},
  [2524] = {.lex_state = 269},
  [2525] = {.lex_state = 0},
  [2526] = {.lex_state = 0},
  [2527] = {.lex_state = 0},
  [2528] = {.lex_state = 0},
  [2529] = {.lex_state = 0},
  [2530] = {.lex_state = 0},
  [2531] = {.lex_state = 0},
  [2532] = {.lex_state = 0, .external_lex_state = 11},
  [2533] = {.lex_state = 1},
  [2534] = {.lex_state = 0},
  [2535] = {.lex_state = 1},
  [2536] = {.lex_state = 0},
  [2537] = {.lex_state = 0},
  [2538] = {.lex_state = 269},
  [2539] = {.lex_state = 269},
  [2540] = {.lex_state = 0},
  [2541] = {.lex_state = 11},
  [2542] = {.lex_state = 269},
  [2543] = {.lex_state = 269},
  [2544] = {.lex_state = 0},
  [2545] = {.lex_state = 0},
  [2546] = {.lex_state = 0},
  [2547] = {.lex_state = 0, .external_lex_state = 12},
  [2548] = {.lex_state = 0},
  [2549] = {.lex_state = 0, .external_lex_state = 11},
  [2550] = {.lex_state = 0},
  [2551] = {.lex_state = 0},
  [2552] = {.lex_state = 269},
  [2553] = {.lex_state = 0},
  [2554] = {.lex_state = 0, .external_lex_state = 11},
  [2555] = {.lex_state = 269},
  [2556] = {.lex_state = 0, .external_lex_state = 11},
  [2557] = {.lex_state = 0, .external_lex_state = 11},
  [2558] = {.lex_state = 269},
  [2559] = {.lex_state = 0, .external_lex_state = 11},
  [2560] = {.lex_state = 0},
  [2561] = {.lex_state = 269},
  [2562] = {.lex_state = 269},
  [2563] = {.lex_state = 269},
  [2564] = {.lex_state = 0},
  [2565] = {.lex_state = 269},
  [2566] = {.lex_state = 0},
  [2567] = {.lex_state = 0},
  [2568] = {.lex_state = 0, .external_lex_state = 11},
  [2569] = {.lex_state = 0, .external_lex_state = 12},
  [2570] = {.lex_state = 0, .external_lex_state = 11},
  [2571] = {.lex_state = 269},
  [2572] = {.lex_state = 269},
  [2573] = {.lex_state = 0, .external_lex_state = 11},
  [2574] = {.lex_state = 0},
  [2575] = {.lex_state = 0},
  [2576] = {.lex_state = 0, .external_lex_state = 11},
  [2577] = {.lex_state = 0},
  [2578] = {.lex_state = 0},
  [2579] = {.lex_state = 0},
  [2580] = {.lex_state = 0},
  [2581] = {.lex_state = 0, .external_lex_state = 11},
  [2582] = {.lex_state = 269},
  [2583] = {.lex_state = 269},
  [2584] = {.lex_state = 0},
  [2585] = {.lex_state = 0, .external_lex_state = 11},
  [2586] = {.lex_state = 269},
  [2587] = {.lex_state = 0},
  [2588] = {.lex_state = 0},
  [2589] = {.lex_state = 0},
  [2590] = {.lex_state = 269},
  [2591] = {.lex_state = 0},
  [2592] = {.lex_state = 0, .external_lex_state = 11},
  [2593] = {.lex_state = 269},
  [2594] = {.lex_state = 269},
  [2595] = {.lex_state = 0},
  [2596] = {.lex_state = 0},
  [2597] = {.lex_state = 0},
  [2598] = {.lex_state = 0, .external_lex_state = 11},
  [2599] = {.lex_state = 269},
  [2600] = {.lex_state = 269},
  [2601] = {.lex_state = 269},
  [2602] = {.lex_state = 0},
  [2603] = {.lex_state = 0},
  [2604] = {.lex_state = 269},
  [2605] = {.lex_state = 269},
  [2606] = {.lex_state = 0},
  [2607] = {.lex_state = 0},
  [2608] = {.lex_state = 1},
  [2609] = {.lex_state = 0, .external_lex_state = 11},
  [2610] = {.lex_state = 0},
  [2611] = {.lex_state = 0},
  [2612] = {.lex_state = 269},
  [2613] = {.lex_state = 269},
  [2614] = {.lex_state = 0},
  [2615] = {.lex_state = 0, .external_lex_state = 11},
  [2616] = {.lex_state = 0, .external_lex_state = 11},
  [2617] = {.lex_state = 269},
  [2618] = {.lex_state = 0},
  [2619] = {.lex_state = 0},
  [2620] = {.lex_state = 269},
  [2621] = {.lex_state = 269},
  [2622] = {.lex_state = 0},
  [2623] = {.lex_state = 0, .external_lex_state = 11},
  [2624] = {.lex_state = 0},
  [2625] = {.lex_state = 0},
  [2626] = {.lex_state = 0},
  [2627] = {.lex_state = 0},
  [2628] = {.lex_state = 269},
  [2629] = {.lex_state = 269},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 269},
  [2632] = {.lex_state = 269},
  [2633] = {.lex_state = 0, .external_lex_state = 11},
  [2634] = {.lex_state = 0},
  [2635] = {.lex_state = 0},
  [2636] = {.lex_state = 269},
  [2637] = {.lex_state = 269},
  [2638] = {.lex_state = 0},
  [2639] = {.lex_state = 269},
  [2640] = {.lex_state = 269},
  [2641] = {.lex_state = 269},
  [2642] = {.lex_state = 0, .external_lex_state = 11},
  [2643] = {.lex_state = 0},
  [2644] = {.lex_state = 269},
  [2645] = {.lex_state = 0},
  [2646] = {.lex_state = 0},
  [2647] = {.lex_state = 0},
  [2648] = {.lex_state = 0},
  [2649] = {.lex_state = 1},
  [2650] = {.lex_state = 0, .external_lex_state = 12},
  [2651] = {.lex_state = 0},
  [2652] = {.lex_state = 269},
  [2653] = {.lex_state = 0, .external_lex_state = 11},
  [2654] = {.lex_state = 0},
  [2655] = {.lex_state = 0, .external_lex_state = 11},
  [2656] = {.lex_state = 269},
  [2657] = {.lex_state = 269},
  [2658] = {.lex_state = 0, .external_lex_state = 11},
  [2659] = {.lex_state = 269},
  [2660] = {.lex_state = 269},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 0},
  [2663] = {.lex_state = 0},
  [2664] = {.lex_state = 0},
  [2665] = {.lex_state = 1},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 0},
  [2668] = {.lex_state = 0},
  [2669] = {.lex_state = 0, .external_lex_state = 12},
  [2670] = {.lex_state = 0},
  [2671] = {.lex_state = 0},
  [2672] = {.lex_state = 0},
  [2673] = {.lex_state = 0},
  [2674] = {.lex_state = 0},
  [2675] = {.lex_state = 0},
  [2676] = {.lex_state = 0},
  [2677] = {.lex_state = 0},
  [2678] = {.lex_state = 0},
  [2679] = {.lex_state = 0},
  [2680] = {.lex_state = 0},
  [2681] = {.lex_state = 0},
  [2682] = {.lex_state = 0},
  [2683] = {.lex_state = 0},
  [2684] = {.lex_state = 0},
  [2685] = {.lex_state = 269},
  [2686] = {.lex_state = 269},
  [2687] = {.lex_state = 0, .external_lex_state = 11},
  [2688] = {.lex_state = 0},
  [2689] = {.lex_state = 0, .external_lex_state = 11},
  [2690] = {.lex_state = 269},
  [2691] = {.lex_state = 0},
  [2692] = {.lex_state = 269},
  [2693] = {.lex_state = 0},
  [2694] = {.lex_state = 269},
  [2695] = {.lex_state = 0, .external_lex_state = 11},
  [2696] = {.lex_state = 0},
  [2697] = {.lex_state = 0},
  [2698] = {.lex_state = 0},
  [2699] = {.lex_state = 1},
  [2700] = {.lex_state = 0},
  [2701] = {.lex_state = 0, .external_lex_state = 11},
  [2702] = {.lex_state = 0, .external_lex_state = 11},
  [2703] = {.lex_state = 0, .external_lex_state = 11},
  [2704] = {.lex_state = 0, .external_lex_state = 11},
  [2705] = {.lex_state = 0, .external_lex_state = 12},
  [2706] = {.lex_state = 0, .external_lex_state = 11},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 269},
  [2709] = {.lex_state = 0},
  [2710] = {.lex_state = 0},
  [2711] = {.lex_state = 0},
  [2712] = {.lex_state = 11},
  [2713] = {.lex_state = 0},
  [2714] = {.lex_state = 0},
  [2715] = {.lex_state = 0},
  [2716] = {.lex_state = 0},
  [2717] = {.lex_state = 269},
  [2718] = {.lex_state = 269},
  [2719] = {.lex_state = 0},
  [2720] = {.lex_state = 269},
  [2721] = {.lex_state = 0},
  [2722] = {.lex_state = 269},
  [2723] = {.lex_state = 0},
  [2724] = {.lex_state = 0, .external_lex_state = 11},
  [2725] = {.lex_state = 0, .external_lex_state = 11},
  [2726] = {.lex_state = 0},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 0},
  [2729] = {.lex_state = 269},
  [2730] = {.lex_state = 0},
  [2731] = {.lex_state = 0},
  [2732] = {.lex_state = 269},
  [2733] = {.lex_state = 0},
  [2734] = {.lex_state = 0},
  [2735] = {.lex_state = 269},
  [2736] = {.lex_state = 0},
  [2737] = {.lex_state = 0, .external_lex_state = 11},
  [2738] = {.lex_state = 0, .external_lex_state = 12},
  [2739] = {.lex_state = 0, .external_lex_state = 11},
  [2740] = {.lex_state = 0, .external_lex_state = 11},
  [2741] = {.lex_state = 0, .external_lex_state = 11},
  [2742] = {.lex_state = 0, .external_lex_state = 12},
  [2743] = {.lex_state = 0, .external_lex_state = 11},
  [2744] = {.lex_state = 0, .external_lex_state = 11},
  [2745] = {.lex_state = 269},
  [2746] = {.lex_state = 0},
  [2747] = {.lex_state = 0},
  [2748] = {.lex_state = 0},
  [2749] = {.lex_state = 0},
  [2750] = {.lex_state = 0, .external_lex_state = 11},
  [2751] = {.lex_state = 0},
  [2752] = {.lex_state = 0},
  [2753] = {.lex_state = 0, .external_lex_state = 11},
  [2754] = {.lex_state = 0, .external_lex_state = 11},
  [2755] = {.lex_state = 0},
  [2756] = {.lex_state = 0},
  [2757] = {.lex_state = 0},
  [2758] = {.lex_state = 0, .external_lex_state = 11},
  [2759] = {.lex_state = 0, .external_lex_state = 11},
  [2760] = {.lex_state = 0},
  [2761] = {.lex_state = 269},
  [2762] = {.lex_state = 0},
  [2763] = {.lex_state = 269},
  [2764] = {.lex_state = 11},
  [2765] = {.lex_state = 269},
  [2766] = {.lex_state = 0},
  [2767] = {.lex_state = 269},
  [2768] = {.lex_state = 0},
  [2769] = {.lex_state = 0},
  [2770] = {.lex_state = 0},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 0, .external_lex_state = 11},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 0, .external_lex_state = 11},
  [2775] = {.lex_state = 269},
  [2776] = {.lex_state = 0},
  [2777] = {.lex_state = 0},
  [2778] = {.lex_state = 1},
  [2779] = {.lex_state = 269},
  [2780] = {.lex_state = 0, .external_lex_state = 11},
  [2781] = {.lex_state = 0, .external_lex_state = 11},
  [2782] = {.lex_state = 269},
  [2783] = {.lex_state = 0, .external_lex_state = 11},
  [2784] = {.lex_state = 0},
  [2785] = {.lex_state = 0},
  [2786] = {.lex_state = 0, .external_lex_state = 11},
  [2787] = {.lex_state = 269},
  [2788] = {.lex_state = 0},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 0, .external_lex_state = 11},
  [2791] = {.lex_state = 0},
  [2792] = {.lex_state = 0, .external_lex_state = 11},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 269},
  [2796] = {.lex_state = 269},
  [2797] = {.lex_state = 0},
  [2798] = {.lex_state = 0, .external_lex_state = 11},
  [2799] = {.lex_state = 0, .external_lex_state = 11},
  [2800] = {.lex_state = 11},
  [2801] = {.lex_state = 0, .external_lex_state = 11},
  [2802] = {.lex_state = 269},
  [2803] = {.lex_state = 0, .external_lex_state = 11},
  [2804] = {.lex_state = 0},
  [2805] = {.lex_state = 0, .external_lex_state = 11},
  [2806] = {.lex_state = 0},
  [2807] = {.lex_state = 1},
  [2808] = {.lex_state = 269},
  [2809] = {.lex_state = 269},
  [2810] = {.lex_state = 0},
  [2811] = {.lex_state = 0},
  [2812] = {.lex_state = 0},
  [2813] = {.lex_state = 0},
  [2814] = {.lex_state = 269},
  [2815] = {.lex_state = 0, .external_lex_state = 11},
  [2816] = {.lex_state = 0, .external_lex_state = 11},
  [2817] = {.lex_state = 0, .external_lex_state = 11},
  [2818] = {.lex_state = 269},
  [2819] = {.lex_state = 0, .external_lex_state = 11},
  [2820] = {.lex_state = 0},
  [2821] = {.lex_state = 11},
  [2822] = {.lex_state = 0},
  [2823] = {.lex_state = 269},
  [2824] = {.lex_state = 269},
  [2825] = {.lex_state = 0},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 0},
  [2828] = {.lex_state = 0},
  [2829] = {.lex_state = 0, .external_lex_state = 11},
  [2830] = {.lex_state = 0, .external_lex_state = 11},
  [2831] = {.lex_state = 0, .external_lex_state = 11},
  [2832] = {.lex_state = 0},
  [2833] = {.lex_state = 0, .external_lex_state = 11},
  [2834] = {.lex_state = 0, .external_lex_state = 12},
  [2835] = {.lex_state = 269},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 269},
  [2839] = {.lex_state = 0},
  [2840] = {.lex_state = 11},
  [2841] = {.lex_state = 0},
  [2842] = {.lex_state = 0, .external_lex_state = 11},
  [2843] = {.lex_state = 269},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 0},
  [2846] = {.lex_state = 0},
  [2847] = {.lex_state = 269},
  [2848] = {.lex_state = 0},
  [2849] = {.lex_state = 269},
  [2850] = {.lex_state = 269},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 0, .external_lex_state = 11},
  [2854] = {.lex_state = 0},
  [2855] = {.lex_state = 0, .external_lex_state = 11},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 11},
  [2858] = {.lex_state = 0},
  [2859] = {.lex_state = 1},
  [2860] = {.lex_state = 0, .external_lex_state = 11},
  [2861] = {.lex_state = 0, .external_lex_state = 11},
  [2862] = {.lex_state = 0},
  [2863] = {.lex_state = 11},
  [2864] = {.lex_state = 0},
  [2865] = {.lex_state = 0, .external_lex_state = 11},
  [2866] = {.lex_state = 269},
  [2867] = {.lex_state = 0},
  [2868] = {.lex_state = 0},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 0, .external_lex_state = 11},
  [2871] = {.lex_state = 0, .external_lex_state = 11},
  [2872] = {.lex_state = 0, .external_lex_state = 11},
  [2873] = {.lex_state = 0, .external_lex_state = 11},
  [2874] = {.lex_state = 0, .external_lex_state = 11},
  [2875] = {.lex_state = 0},
  [2876] = {.lex_state = 0},
  [2877] = {.lex_state = 0, .external_lex_state = 11},
  [2878] = {.lex_state = 0, .external_lex_state = 12},
  [2879] = {.lex_state = 0, .external_lex_state = 11},
  [2880] = {.lex_state = 0, .external_lex_state = 11},
  [2881] = {.lex_state = 269},
  [2882] = {.lex_state = 269},
  [2883] = {.lex_state = 0},
  [2884] = {.lex_state = 0, .external_lex_state = 11},
  [2885] = {.lex_state = 0, .external_lex_state = 11},
  [2886] = {.lex_state = 1},
  [2887] = {.lex_state = 0, .external_lex_state = 11},
  [2888] = {.lex_state = 0, .external_lex_state = 11},
  [2889] = {.lex_state = 2},
  [2890] = {.lex_state = 0, .external_lex_state = 11},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 0},
  [2894] = {.lex_state = 0, .external_lex_state = 11},
  [2895] = {.lex_state = 0},
  [2896] = {.lex_state = 0, .external_lex_state = 12},
  [2897] = {.lex_state = 0},
  [2898] = {.lex_state = 0, .external_lex_state = 11},
  [2899] = {.lex_state = 0, .external_lex_state = 12},
  [2900] = {.lex_state = 0},
  [2901] = {.lex_state = 0},
  [2902] = {(TSStateId)(-1)},
  [2903] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_blockcomment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_pub] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_cs] = ACTIONS(1),
    [anon_sym_js] = ACTIONS(1),
    [anon_sym_c] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_effect] = ACTIONS(1),
    [anon_sym_named] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_extend] = ACTIONS(1),
    [anon_sym_co] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_lazy] = ACTIONS(1),
    [anon_sym_value] = ACTIONS(1),
    [anon_sym_reference] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [anon_sym_linear] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_ctx] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_val] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_ctl] = ACTIONS(1),
    [anon_sym_noinline] = ACTIONS(1),
    [anon_sym_fip] = ACTIONS(1),
    [anon_sym_fbip] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_tail] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_mask] = ACTIONS(1),
    [anon_sym_behind] = ACTIONS(1),
    [sym_borrow] = ACTIONS(1),
    [anon_sym_file] = ACTIONS(1),
    [anon_sym_scoped] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [sym_conid] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_handler] = ACTIONS(1),
    [anon_sym_handle] = ACTIONS(1),
    [sym_override] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_brk] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_raw] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_some] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [sym_escape] = ACTIONS(1),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_STAR_SLASH] = ACTIONS(1),
    [aux_sym_float_token1] = ACTIONS(1),
    [aux_sym_float_token2] = ACTIONS(1),
    [aux_sym_int_token1] = ACTIONS(1),
    [aux_sym_int_token2] = ACTIONS(1),
    [anon_sym_RPAREN2] = ACTIONS(1),
    [sym__WILDCARDID] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE2] = ACTIONS(1),
    [sym__open_brace] = ACTIONS(1),
    [sym__close_brace] = ACTIONS(1),
    [sym__semi] = ACTIONS(1),
    [sym__raw_string] = ACTIONS(1),
    [sym__end_continuation_signal] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(2756),
    [sym_eimport] = STATE(2165),
    [sym_import] = STATE(2165),
    [sym_semis] = STATE(609),
    [sym_declarations] = STATE(2828),
    [sym_fixitydecl] = STATE(2165),
    [sym_fixity] = STATE(973),
    [sym_topdecl] = STATE(2165),
    [sym_externdecl] = STATE(2655),
    [sym_aliasdecl] = STATE(2655),
    [sym_typedecl] = STATE(2655),
    [sym_typemod] = STATE(2768),
    [sym_structmod] = STATE(2387),
    [sym_effectmod] = STATE(2574),
    [sym_puredecl] = STATE(2655),
    [sym_inlinemod] = STATE(1770),
    [sym_fipmod] = STATE(2427),
    [sym_tailmod] = STATE(2116),
    [sym__open_brace_] = STATE(579),
    [sym__IMPORT_EXTERN] = STATE(2077),
    [sym_blockcomment] = STATE(1),
    [aux_sym_semis_repeat1] = STATE(817),
    [aux_sym_declarations_repeat1] = STATE(623),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_module] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [sym_pub] = ACTIONS(13),
    [anon_sym_infix] = ACTIONS(15),
    [anon_sym_infixr] = ACTIONS(17),
    [anon_sym_infixl] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(19),
    [anon_sym_extern] = ACTIONS(21),
    [anon_sym_inline] = ACTIONS(23),
    [anon_sym_alias] = ACTIONS(25),
    [anon_sym_type] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_effect] = ACTIONS(31),
    [anon_sym_named] = ACTIONS(33),
    [anon_sym_open] = ACTIONS(35),
    [anon_sym_extend] = ACTIONS(35),
    [anon_sym_co] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(37),
    [anon_sym_lazy] = ACTIONS(35),
    [anon_sym_value] = ACTIONS(39),
    [anon_sym_reference] = ACTIONS(39),
    [anon_sym_ref] = ACTIONS(41),
    [anon_sym_linear] = ACTIONS(43),
    [anon_sym_val] = ACTIONS(45),
    [anon_sym_fun] = ACTIONS(47),
    [anon_sym_noinline] = ACTIONS(23),
    [anon_sym_fip] = ACTIONS(49),
    [anon_sym_fbip] = ACTIONS(49),
    [anon_sym_tail] = ACTIONS(51),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [sym__open_brace] = ACTIONS(53),
    [sym__semi] = ACTIONS(55),
  },
  [2] = {
    [sym_block] = STATE(1322),
    [sym_bodyexpr] = STATE(1215),
    [sym__blockexpr] = STATE(1347),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(2),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_COLON] = ACTIONS(57),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [3] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2101),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(3),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_COLON] = ACTIONS(115),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [4] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2124),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(4),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [5] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2009),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(5),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_COLON] = ACTIONS(167),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [6] = {
    [sym_semis] = STATE(119),
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1476),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(6),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_semis_repeat1] = STATE(484),
    [aux_sym_block_repeat1] = STATE(120),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(177),
    [sym__semi] = ACTIONS(179),
    [sym__raw_string] = ACTIONS(163),
  },
  [7] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1773),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(7),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_COLON] = ACTIONS(181),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(187),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [8] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1762),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(8),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_COLON] = ACTIONS(203),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(187),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [9] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1725),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(9),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_COLON] = ACTIONS(205),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(187),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [10] = {
    [sym_semis] = STATE(157),
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1738),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(10),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_semis_repeat1] = STATE(484),
    [aux_sym_block_repeat1] = STATE(158),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(207),
    [sym__semi] = ACTIONS(179),
    [sym__raw_string] = ACTIONS(163),
  },
  [11] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1773),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(11),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_COLON] = ACTIONS(181),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(215),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [12] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1762),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(12),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_COLON] = ACTIONS(203),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(215),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [13] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1725),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(13),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_COLON] = ACTIONS(205),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(215),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [14] = {
    [sym_semis] = STATE(200),
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1344),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(14),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_semis_repeat1] = STATE(484),
    [aux_sym_block_repeat1] = STATE(203),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(249),
    [sym__semi] = ACTIONS(179),
    [sym__raw_string] = ACTIONS(163),
  },
  [15] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2101),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2553),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(15),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_COLON] = ACTIONS(115),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_val] = ACTIONS(255),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [16] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2124),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2553),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(16),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_val] = ACTIONS(255),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [17] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2009),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2553),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(17),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_COLON] = ACTIONS(167),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_val] = ACTIONS(255),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [18] = {
    [sym_semis] = STATE(225),
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1243),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(18),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_semis_repeat1] = STATE(484),
    [aux_sym_block_repeat1] = STATE(227),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(265),
    [sym__semi] = ACTIONS(179),
    [sym__raw_string] = ACTIONS(163),
  },
  [19] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1773),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1040),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2794),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(19),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(413),
    [anon_sym_COLON] = ACTIONS(181),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(273),
    [anon_sym_val] = ACTIONS(275),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [20] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1762),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1040),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2794),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(20),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(413),
    [anon_sym_COLON] = ACTIONS(203),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(273),
    [anon_sym_val] = ACTIONS(275),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [21] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1725),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1040),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2794),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(21),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(413),
    [anon_sym_COLON] = ACTIONS(205),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(273),
    [anon_sym_val] = ACTIONS(275),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [22] = {
    [sym_semis] = STATE(247),
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1524),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(22),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_semis_repeat1] = STATE(484),
    [aux_sym_block_repeat1] = STATE(251),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(307),
    [sym__semi] = ACTIONS(179),
    [sym__raw_string] = ACTIONS(163),
  },
  [23] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1489),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(23),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(315),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [24] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1455),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(24),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_COLON] = ACTIONS(331),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(315),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [25] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1401),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(25),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_COLON] = ACTIONS(333),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(315),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [26] = {
    [sym_block] = STATE(1322),
    [sym_bodyexpr] = STATE(1346),
    [sym__blockexpr] = STATE(1347),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(26),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_COLON] = ACTIONS(335),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [27] = {
    [sym_block] = STATE(1322),
    [sym_bodyexpr] = STATE(1361),
    [sym__blockexpr] = STATE(1347),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(27),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_COLON] = ACTIONS(337),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [28] = {
    [sym_block] = STATE(1234),
    [sym_bodyexpr] = STATE(1244),
    [sym__blockexpr] = STATE(1245),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(1003),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2627),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(28),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(420),
    [anon_sym_COLON] = ACTIONS(339),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(345),
    [anon_sym_val] = ACTIONS(347),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [29] = {
    [sym_block] = STATE(1234),
    [sym_bodyexpr] = STATE(1253),
    [sym__blockexpr] = STATE(1245),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(1003),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2627),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(29),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(420),
    [anon_sym_COLON] = ACTIONS(361),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(345),
    [anon_sym_val] = ACTIONS(347),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [30] = {
    [sym_semis] = STATE(153),
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(2078),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(30),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_semis_repeat1] = STATE(484),
    [aux_sym_block_repeat1] = STATE(193),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(363),
    [sym__semi] = ACTIONS(179),
    [sym__raw_string] = ACTIONS(163),
  },
  [31] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1489),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(31),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(365),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [32] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1455),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(32),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_COLON] = ACTIONS(331),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(365),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [33] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1401),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(33),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_COLON] = ACTIONS(333),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(365),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [34] = {
    [sym_block] = STATE(1514),
    [sym_bodyexpr] = STATE(1525),
    [sym__blockexpr] = STATE(1526),
    [sym_expr] = STATE(1515),
    [sym_basicexpr] = STATE(1514),
    [sym_matchexpr] = STATE(1516),
    [sym_fnexpr] = STATE(1516),
    [sym_returnexpr] = STATE(1514),
    [sym_ifexpr] = STATE(1516),
    [sym_valexpr] = STATE(1514),
    [sym_opexpr] = STATE(1516),
    [sym_atom] = STATE(1051),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1516),
    [sym_withstat] = STATE(2671),
    [sym_withexpr] = STATE(1514),
    [sym__open_brace_] = STATE(22),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(34),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(424),
    [anon_sym_COLON] = ACTIONS(375),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(377),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(379),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_val] = ACTIONS(383),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(385),
    [anon_sym_fn] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(393),
    [anon_sym_handle] = ACTIONS(395),
    [sym_override] = ACTIONS(377),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [35] = {
    [sym_block] = STATE(1514),
    [sym_bodyexpr] = STATE(1533),
    [sym__blockexpr] = STATE(1526),
    [sym_expr] = STATE(1515),
    [sym_basicexpr] = STATE(1514),
    [sym_matchexpr] = STATE(1516),
    [sym_fnexpr] = STATE(1516),
    [sym_returnexpr] = STATE(1514),
    [sym_ifexpr] = STATE(1516),
    [sym_valexpr] = STATE(1514),
    [sym_opexpr] = STATE(1516),
    [sym_atom] = STATE(1051),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1516),
    [sym_withstat] = STATE(2671),
    [sym_withexpr] = STATE(1514),
    [sym__open_brace_] = STATE(22),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(35),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(424),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(377),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(379),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_val] = ACTIONS(383),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(385),
    [anon_sym_fn] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(393),
    [anon_sym_handle] = ACTIONS(395),
    [sym_override] = ACTIONS(377),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [36] = {
    [sym_block] = STATE(1514),
    [sym_bodyexpr] = STATE(1542),
    [sym__blockexpr] = STATE(1526),
    [sym_expr] = STATE(1515),
    [sym_basicexpr] = STATE(1514),
    [sym_matchexpr] = STATE(1516),
    [sym_fnexpr] = STATE(1516),
    [sym_returnexpr] = STATE(1514),
    [sym_ifexpr] = STATE(1516),
    [sym_valexpr] = STATE(1514),
    [sym_opexpr] = STATE(1516),
    [sym_atom] = STATE(1051),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1516),
    [sym_withstat] = STATE(2671),
    [sym_withexpr] = STATE(1514),
    [sym__open_brace_] = STATE(22),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(36),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(424),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(377),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(379),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_val] = ACTIONS(383),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(385),
    [anon_sym_fn] = ACTIONS(387),
    [anon_sym_return] = ACTIONS(389),
    [anon_sym_if] = ACTIONS(391),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(393),
    [anon_sym_handle] = ACTIONS(395),
    [sym_override] = ACTIONS(377),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [37] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2101),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1015),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2688),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(37),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(463),
    [anon_sym_COLON] = ACTIONS(115),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(401),
    [anon_sym_val] = ACTIONS(403),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [38] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2124),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1015),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2688),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(38),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(463),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(401),
    [anon_sym_val] = ACTIONS(403),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [39] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2009),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1015),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2688),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(39),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(463),
    [anon_sym_COLON] = ACTIONS(167),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(401),
    [anon_sym_val] = ACTIONS(403),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [40] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1773),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(941),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2580),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(40),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(451),
    [anon_sym_COLON] = ACTIONS(181),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(411),
    [anon_sym_val] = ACTIONS(413),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [41] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1762),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(941),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2580),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(41),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(451),
    [anon_sym_COLON] = ACTIONS(203),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(411),
    [anon_sym_val] = ACTIONS(413),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [42] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1725),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(941),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2580),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(42),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(451),
    [anon_sym_COLON] = ACTIONS(205),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(411),
    [anon_sym_val] = ACTIONS(413),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [43] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1773),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(947),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2536),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(43),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(454),
    [anon_sym_COLON] = ACTIONS(181),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(421),
    [anon_sym_val] = ACTIONS(423),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(427),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [44] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1762),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(947),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2536),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(44),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(454),
    [anon_sym_COLON] = ACTIONS(203),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(421),
    [anon_sym_val] = ACTIONS(423),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(427),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [45] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1725),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(947),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2536),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(45),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(454),
    [anon_sym_COLON] = ACTIONS(205),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(421),
    [anon_sym_val] = ACTIONS(423),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(427),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [46] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2101),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(981),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2610),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(46),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(457),
    [anon_sym_COLON] = ACTIONS(115),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_val] = ACTIONS(433),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [47] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2124),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(981),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2610),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(47),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(457),
    [anon_sym_COLON] = ACTIONS(165),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_val] = ACTIONS(433),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [48] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2009),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(981),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2610),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(48),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(457),
    [anon_sym_COLON] = ACTIONS(167),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(431),
    [anon_sym_val] = ACTIONS(433),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [49] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1773),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1026),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2591),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(49),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(439),
    [anon_sym_COLON] = ACTIONS(181),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(441),
    [anon_sym_val] = ACTIONS(443),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [50] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1762),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1026),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2591),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(50),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(439),
    [anon_sym_COLON] = ACTIONS(203),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(441),
    [anon_sym_val] = ACTIONS(443),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [51] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(1725),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1026),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2591),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(51),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(439),
    [anon_sym_COLON] = ACTIONS(205),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(441),
    [anon_sym_val] = ACTIONS(443),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [52] = {
    [sym_block] = STATE(1322),
    [sym_bodyexpr] = STATE(1346),
    [sym__blockexpr] = STATE(1347),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(951),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2602),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(52),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(436),
    [anon_sym_COLON] = ACTIONS(335),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(451),
    [anon_sym_val] = ACTIONS(453),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(457),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [53] = {
    [sym_block] = STATE(1322),
    [sym_bodyexpr] = STATE(1361),
    [sym__blockexpr] = STATE(1347),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(951),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2602),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(53),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(436),
    [anon_sym_COLON] = ACTIONS(337),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(451),
    [anon_sym_val] = ACTIONS(453),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(457),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [54] = {
    [sym_block] = STATE(1322),
    [sym_bodyexpr] = STATE(1215),
    [sym__blockexpr] = STATE(1347),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(951),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2602),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(54),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(436),
    [anon_sym_COLON] = ACTIONS(57),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(451),
    [anon_sym_val] = ACTIONS(453),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(457),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [55] = {
    [sym_block] = STATE(1234),
    [sym_bodyexpr] = STATE(1244),
    [sym__blockexpr] = STATE(1245),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(952),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2618),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(55),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(445),
    [anon_sym_COLON] = ACTIONS(339),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(461),
    [anon_sym_val] = ACTIONS(463),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(465),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [56] = {
    [sym_block] = STATE(1234),
    [sym_bodyexpr] = STATE(1253),
    [sym__blockexpr] = STATE(1245),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(952),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2618),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(56),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(445),
    [anon_sym_COLON] = ACTIONS(361),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(461),
    [anon_sym_val] = ACTIONS(463),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(465),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [57] = {
    [sym_block] = STATE(1234),
    [sym_bodyexpr] = STATE(1261),
    [sym__blockexpr] = STATE(1245),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(952),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2618),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(57),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(445),
    [anon_sym_COLON] = ACTIONS(471),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(461),
    [anon_sym_val] = ACTIONS(463),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(465),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [58] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1489),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(977),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2626),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(58),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(442),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_val] = ACTIONS(475),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [59] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1455),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(977),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2626),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(59),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(442),
    [anon_sym_COLON] = ACTIONS(331),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_val] = ACTIONS(475),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [60] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1401),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(977),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2626),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(60),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(442),
    [anon_sym_COLON] = ACTIONS(333),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(473),
    [anon_sym_val] = ACTIONS(475),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [61] = {
    [sym_block] = STATE(1514),
    [sym_bodyexpr] = STATE(1525),
    [sym__blockexpr] = STATE(1526),
    [sym_expr] = STATE(1515),
    [sym_basicexpr] = STATE(1514),
    [sym_matchexpr] = STATE(1516),
    [sym_fnexpr] = STATE(1516),
    [sym_returnexpr] = STATE(1514),
    [sym_ifexpr] = STATE(1516),
    [sym_valexpr] = STATE(1514),
    [sym_opexpr] = STATE(1516),
    [sym_atom] = STATE(1024),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1516),
    [sym_withstat] = STATE(2634),
    [sym_withexpr] = STATE(1514),
    [sym__open_brace_] = STATE(22),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(61),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(448),
    [anon_sym_COLON] = ACTIONS(375),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(377),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(379),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(483),
    [anon_sym_val] = ACTIONS(485),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(385),
    [anon_sym_fn] = ACTIONS(487),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(393),
    [anon_sym_handle] = ACTIONS(395),
    [sym_override] = ACTIONS(377),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [62] = {
    [sym_block] = STATE(1514),
    [sym_bodyexpr] = STATE(1533),
    [sym__blockexpr] = STATE(1526),
    [sym_expr] = STATE(1515),
    [sym_basicexpr] = STATE(1514),
    [sym_matchexpr] = STATE(1516),
    [sym_fnexpr] = STATE(1516),
    [sym_returnexpr] = STATE(1514),
    [sym_ifexpr] = STATE(1516),
    [sym_valexpr] = STATE(1514),
    [sym_opexpr] = STATE(1516),
    [sym_atom] = STATE(1024),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1516),
    [sym_withstat] = STATE(2634),
    [sym_withexpr] = STATE(1514),
    [sym__open_brace_] = STATE(22),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(62),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(448),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(377),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(379),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(483),
    [anon_sym_val] = ACTIONS(485),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(385),
    [anon_sym_fn] = ACTIONS(487),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(393),
    [anon_sym_handle] = ACTIONS(395),
    [sym_override] = ACTIONS(377),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [63] = {
    [sym_block] = STATE(1514),
    [sym_bodyexpr] = STATE(1542),
    [sym__blockexpr] = STATE(1526),
    [sym_expr] = STATE(1515),
    [sym_basicexpr] = STATE(1514),
    [sym_matchexpr] = STATE(1516),
    [sym_fnexpr] = STATE(1516),
    [sym_returnexpr] = STATE(1514),
    [sym_ifexpr] = STATE(1516),
    [sym_valexpr] = STATE(1514),
    [sym_opexpr] = STATE(1516),
    [sym_atom] = STATE(1024),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1516),
    [sym_withstat] = STATE(2634),
    [sym_withexpr] = STATE(1514),
    [sym__open_brace_] = STATE(22),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(63),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(448),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(377),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(379),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(483),
    [anon_sym_val] = ACTIONS(485),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(385),
    [anon_sym_fn] = ACTIONS(487),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(393),
    [anon_sym_handle] = ACTIONS(395),
    [sym_override] = ACTIONS(377),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [64] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1489),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1019),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2793),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(64),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(460),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_val] = ACTIONS(495),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(497),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [65] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1455),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1019),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2793),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(65),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(460),
    [anon_sym_COLON] = ACTIONS(331),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_val] = ACTIONS(495),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(497),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [66] = {
    [sym_block] = STATE(1435),
    [sym_bodyexpr] = STATE(1401),
    [sym__blockexpr] = STATE(1395),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1019),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2793),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(66),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(460),
    [anon_sym_COLON] = ACTIONS(333),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_val] = ACTIONS(495),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(497),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [67] = {
    [sym_block] = STATE(1234),
    [sym_bodyexpr] = STATE(1261),
    [sym__blockexpr] = STATE(1245),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(1003),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2627),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(67),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(420),
    [anon_sym_COLON] = ACTIONS(471),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_DASH_GT] = ACTIONS(345),
    [anon_sym_val] = ACTIONS(347),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [68] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2732),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(68),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [69] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2708),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(69),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(513),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [70] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2720),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(70),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(515),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [71] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_cexprs] = STATE(2822),
    [sym__aexpr] = STATE(2081),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(71),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(517),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [72] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_aexprs] = STATE(2823),
    [sym__aexpr] = STATE(2083),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(72),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(517),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [73] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2836),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(73),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_RBRACK] = ACTIONS(519),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [74] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2838),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(74),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(521),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [75] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2847),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(75),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(523),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [76] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_cexprs] = STATE(2514),
    [sym__aexpr] = STATE(2081),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(76),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(525),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [77] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_aexprs] = STATE(2515),
    [sym__aexpr] = STATE(2083),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(77),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(525),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [78] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(2643),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(78),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(187),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [79] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2695),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(79),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [80] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2746),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(80),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_RBRACK] = ACTIONS(527),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [81] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2811),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(81),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_RBRACK] = ACTIONS(529),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [82] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_cexprs] = STATE(2587),
    [sym__aexpr] = STATE(2081),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(82),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(531),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [83] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_aexprs] = STATE(2590),
    [sym__aexpr] = STATE(2083),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(83),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(531),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [84] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2814),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(84),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(533),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [85] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2728),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(85),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_RBRACK] = ACTIONS(535),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [86] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_aexprs] = STATE(2652),
    [sym__aexpr] = STATE(2083),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(86),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [87] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2707),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(87),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_RBRACK] = ACTIONS(539),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [88] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2760),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(88),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_RBRACK] = ACTIONS(541),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [89] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2765),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(89),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(543),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [90] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2775),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(90),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(545),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [91] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2426),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(91),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [92] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2787),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(92),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(547),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [93] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2307),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(93),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [94] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2849),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(94),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(549),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [95] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2761),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(95),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(551),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [96] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_cexprs] = STATE(2714),
    [sym__aexpr] = STATE(2081),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(96),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(553),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [97] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2426),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2553),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(97),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_val] = ACTIONS(255),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [98] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2307),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2553),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(98),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_val] = ACTIONS(255),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [99] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(2197),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_arguments] = STATE(2524),
    [sym_argument] = STATE(1953),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1477),
    [sym_qimplicit] = STATE(1480),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1478),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(99),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1478),
    [sym__IMPLICITID] = STATE(1487),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_RPAREN] = ACTIONS(555),
    [anon_sym_inline] = ACTIONS(505),
    [anon_sym_cs] = ACTIONS(505),
    [anon_sym_js] = ACTIONS(505),
    [anon_sym_c] = ACTIONS(505),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(505),
    [anon_sym_extend] = ACTIONS(505),
    [anon_sym_co] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_lazy] = ACTIONS(507),
    [anon_sym_value] = ACTIONS(505),
    [anon_sym_reference] = ACTIONS(505),
    [anon_sym_linear] = ACTIONS(505),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(505),
    [anon_sym_fip] = ACTIONS(505),
    [anon_sym_fbip] = ACTIONS(505),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(505),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(505),
    [anon_sym_file] = ACTIONS(505),
    [anon_sym_scoped] = ACTIONS(505),
    [anon_sym_initially] = ACTIONS(505),
    [anon_sym_finally] = ACTIONS(505),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(509),
    [sym_id] = ACTIONS(505),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [100] = {
    [sym_block] = STATE(1763),
    [sym_bodyexpr] = STATE(2545),
    [sym__blockexpr] = STATE(1775),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(100),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(187),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [101] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_aexprs] = STATE(2722),
    [sym__aexpr] = STATE(2083),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(101),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(553),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [102] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_cexprs] = STATE(2648),
    [sym__aexpr] = STATE(2081),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(102),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(537),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [103] = {
    [sym_block] = STATE(2100),
    [sym_bodyexpr] = STATE(2829),
    [sym__blockexpr] = STATE(2104),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(103),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(125),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [104] = {
    [sym_binder] = STATE(2548),
    [sym_basicexpr] = STATE(2411),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1444),
    [sym_identifier] = STATE(1425),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1425),
    [sym_varid] = STATE(1399),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_witheff] = STATE(1708),
    [sym_opclause] = STATE(2411),
    [sym_controlmod] = STATE(2664),
    [sym__open_square_brace] = STATE(96),
    [sym__open_angle_brace] = STATE(653),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(104),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1399),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_inline] = ACTIONS(557),
    [anon_sym_cs] = ACTIONS(557),
    [anon_sym_js] = ACTIONS(557),
    [anon_sym_c] = ACTIONS(557),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(557),
    [anon_sym_extend] = ACTIONS(557),
    [anon_sym_co] = ACTIONS(557),
    [anon_sym_div] = ACTIONS(557),
    [anon_sym_lazy] = ACTIONS(559),
    [anon_sym_value] = ACTIONS(557),
    [anon_sym_reference] = ACTIONS(557),
    [anon_sym_linear] = ACTIONS(557),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(561),
    [anon_sym_fun] = ACTIONS(563),
    [anon_sym_ctl] = ACTIONS(563),
    [anon_sym_noinline] = ACTIONS(557),
    [anon_sym_fip] = ACTIONS(557),
    [anon_sym_fbip] = ACTIONS(557),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(557),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(565),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(557),
    [anon_sym_file] = ACTIONS(557),
    [anon_sym_scoped] = ACTIONS(557),
    [anon_sym_initially] = ACTIONS(557),
    [anon_sym_finally] = ACTIONS(557),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(567),
    [anon_sym_brk] = ACTIONS(563),
    [anon_sym_final] = ACTIONS(569),
    [anon_sym_raw] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(571),
    [anon_sym_LPAREN] = ACTIONS(573),
    [sym_id] = ACTIONS(557),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(575),
    [sym_qidop] = ACTIONS(577),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__raw_string] = ACTIONS(163),
  },
  [105] = {
    [sym_binder] = STATE(2856),
    [sym_basicexpr] = STATE(2858),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_ifexpr] = STATE(1765),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1517),
    [sym_identifier] = STATE(1540),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1540),
    [sym_varid] = STATE(1510),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_witheff] = STATE(1689),
    [sym_opclause] = STATE(2858),
    [sym_controlmod] = STATE(2891),
    [sym__open_square_brace] = STATE(82),
    [sym__open_angle_brace] = STATE(653),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(105),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1510),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(579),
    [anon_sym_cs] = ACTIONS(579),
    [anon_sym_js] = ACTIONS(579),
    [anon_sym_c] = ACTIONS(579),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(579),
    [anon_sym_extend] = ACTIONS(579),
    [anon_sym_co] = ACTIONS(579),
    [anon_sym_div] = ACTIONS(579),
    [anon_sym_lazy] = ACTIONS(581),
    [anon_sym_value] = ACTIONS(579),
    [anon_sym_reference] = ACTIONS(579),
    [anon_sym_linear] = ACTIONS(579),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(583),
    [anon_sym_fun] = ACTIONS(585),
    [anon_sym_ctl] = ACTIONS(585),
    [anon_sym_noinline] = ACTIONS(579),
    [anon_sym_fip] = ACTIONS(579),
    [anon_sym_fbip] = ACTIONS(579),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(579),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(587),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(579),
    [anon_sym_file] = ACTIONS(579),
    [anon_sym_scoped] = ACTIONS(579),
    [anon_sym_initially] = ACTIONS(579),
    [anon_sym_finally] = ACTIONS(579),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(589),
    [anon_sym_brk] = ACTIONS(585),
    [anon_sym_final] = ACTIONS(569),
    [anon_sym_raw] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(571),
    [anon_sym_LPAREN] = ACTIONS(591),
    [sym_id] = ACTIONS(579),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(593),
    [sym_qidop] = ACTIONS(595),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__raw_string] = ACTIONS(113),
  },
  [106] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym__aexpr] = STATE(2194),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(106),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(597),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [107] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym__aexpr] = STATE(2194),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(107),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_RBRACK] = ACTIONS(599),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [108] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym__aexpr] = STATE(2194),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(108),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(601),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [109] = {
    [sym_block] = STATE(1763),
    [sym_expr] = STATE(1913),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym__aexpr] = STATE(2194),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(109),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_RPAREN] = ACTIONS(603),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [110] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(2622),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(110),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [111] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(2305),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(941),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2580),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(111),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(451),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(413),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [112] = {
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(2007),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(112),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_block_repeat1] = STATE(311),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(363),
    [sym__raw_string] = ACTIONS(163),
  },
  [113] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1453),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(113),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [114] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(2865),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(114),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [115] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1456),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(115),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [116] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(1962),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(116),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [117] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1742),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(994),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2893),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(117),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(430),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(217),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(221),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [118] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(1907),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1015),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2688),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(118),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(463),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(403),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [119] = {
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1442),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(119),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_block_repeat1] = STATE(132),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(177),
    [sym__raw_string] = ACTIONS(163),
  },
  [120] = {
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1442),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(120),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_block_repeat1] = STATE(311),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(177),
    [sym__raw_string] = ACTIONS(163),
  },
  [121] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(2754),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(121),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [122] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1416),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(122),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [123] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1420),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1049),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2727),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(123),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(404),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(317),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(321),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [124] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1746),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(124),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [125] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1742),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1040),
    [sym_name] = STATE(1569),
    [sym_literal] = STATE(1569),
    [sym_mask] = STATE(1569),
    [sym_ctxexpr] = STATE(1569),
    [sym_ctxhole] = STATE(1569),
    [sym_qidentifier] = STATE(1570),
    [sym_identifier] = STATE(1574),
    [sym_qimplicit] = STATE(1570),
    [sym_qvarid] = STATE(1574),
    [sym_varid] = STATE(1584),
    [sym__qconstructor] = STATE(1570),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2794),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(76),
    [sym__open_round_brace] = STATE(77),
    [sym_blockcomment] = STATE(125),
    [sym_float] = STATE(1518),
    [sym_int] = STATE(1518),
    [sym_idop] = STATE(1584),
    [sym__IMPLICITID] = STATE(1558),
    [sym_string] = STATE(1518),
    [sym_char] = STATE(1518),
    [aux_sym_opexpr_repeat1] = STATE(413),
    [anon_sym_inline] = ACTIONS(267),
    [anon_sym_cs] = ACTIONS(267),
    [anon_sym_js] = ACTIONS(267),
    [anon_sym_c] = ACTIONS(267),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_extend] = ACTIONS(267),
    [anon_sym_co] = ACTIONS(267),
    [anon_sym_div] = ACTIONS(267),
    [anon_sym_lazy] = ACTIONS(269),
    [anon_sym_value] = ACTIONS(267),
    [anon_sym_reference] = ACTIONS(267),
    [anon_sym_linear] = ACTIONS(267),
    [anon_sym_ctx] = ACTIONS(271),
    [anon_sym_val] = ACTIONS(275),
    [anon_sym_noinline] = ACTIONS(267),
    [anon_sym_fip] = ACTIONS(267),
    [anon_sym_fbip] = ACTIONS(267),
    [anon_sym__] = ACTIONS(277),
    [anon_sym_tail] = ACTIONS(267),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(281),
    [anon_sym_if] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(285),
    [anon_sym_behind] = ACTIONS(267),
    [anon_sym_file] = ACTIONS(267),
    [anon_sym_scoped] = ACTIONS(267),
    [anon_sym_initially] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [sym_qconid] = ACTIONS(287),
    [sym_conid] = ACTIONS(287),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(289),
    [sym_id] = ACTIONS(267),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(291),
    [aux_sym_float_token2] = ACTIONS(291),
    [aux_sym_int_token1] = ACTIONS(293),
    [aux_sym_int_token2] = ACTIONS(293),
    [sym_qid] = ACTIONS(295),
    [sym_qidop] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(303),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(305),
  },
  [126] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1759),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(941),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2580),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(126),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(451),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(413),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [127] = {
    [sym_block] = STATE(1322),
    [sym__blockexpr] = STATE(1362),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(127),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [128] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1748),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(941),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2580),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(128),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(451),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(413),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [129] = {
    [sym_basicexpr] = STATE(2483),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1029),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_witheff] = STATE(1694),
    [sym_opclause] = STATE(2483),
    [sym_controlmod] = STATE(2664),
    [sym__open_square_brace] = STATE(96),
    [sym__open_angle_brace] = STATE(653),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(129),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(434),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(561),
    [anon_sym_fun] = ACTIONS(563),
    [anon_sym_ctl] = ACTIONS(563),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(565),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_brk] = ACTIONS(563),
    [anon_sym_final] = ACTIONS(569),
    [anon_sym_raw] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(571),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__raw_string] = ACTIONS(163),
  },
  [130] = {
    [sym_block] = STATE(1322),
    [sym__blockexpr] = STATE(1225),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(130),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [131] = {
    [sym_block] = STATE(1322),
    [sym__blockexpr] = STATE(1228),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(131),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [132] = {
    [sym_statement] = STATE(2196),
    [sym_decl] = STATE(2554),
    [sym_basicexpr] = STATE(2554),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2554),
    [sym_ifexpr] = STATE(2035),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2368),
    [sym__close_brace_] = STATE(1483),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(132),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_block_repeat1] = STATE(311),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(169),
    [anon_sym_fun] = ACTIONS(171),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_var] = ACTIONS(173),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(175),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__close_brace] = ACTIONS(177),
    [sym__raw_string] = ACTIONS(163),
  },
  [133] = {
    [sym_block] = STATE(1322),
    [sym__blockexpr] = STATE(1357),
    [sym_expr] = STATE(1323),
    [sym_basicexpr] = STATE(1322),
    [sym_matchexpr] = STATE(1335),
    [sym_fnexpr] = STATE(1335),
    [sym_returnexpr] = STATE(1322),
    [sym_ifexpr] = STATE(1335),
    [sym_valexpr] = STATE(1322),
    [sym_opexpr] = STATE(1335),
    [sym_atom] = STATE(999),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1335),
    [sym_withstat] = STATE(2900),
    [sym_withexpr] = STATE(1322),
    [sym__open_brace_] = STATE(14),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(133),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(410),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(61),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(63),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(69),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(73),
    [anon_sym_fn] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(87),
    [anon_sym_handle] = ACTIONS(89),
    [sym_override] = ACTIONS(61),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [134] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(2788),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(134),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [135] = {
    [sym_block] = STATE(1234),
    [sym__blockexpr] = STATE(1254),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(1003),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2627),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(135),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(420),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(347),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [136] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1777),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(947),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2536),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(136),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(454),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(211),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(423),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(427),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [137] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(2426),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(137),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [138] = {
    [sym_block] = STATE(1234),
    [sym__blockexpr] = STATE(1269),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(1003),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2627),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(138),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(420),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(347),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [139] = {
    [sym_block] = STATE(1234),
    [sym__blockexpr] = STATE(1272),
    [sym_expr] = STATE(1235),
    [sym_basicexpr] = STATE(1234),
    [sym_matchexpr] = STATE(1236),
    [sym_fnexpr] = STATE(1236),
    [sym_returnexpr] = STATE(1234),
    [sym_ifexpr] = STATE(1236),
    [sym_valexpr] = STATE(1234),
    [sym_opexpr] = STATE(1236),
    [sym_atom] = STATE(1003),
    [sym_name] = STATE(1336),
    [sym_literal] = STATE(1336),
    [sym_mask] = STATE(1336),
    [sym_ctxexpr] = STATE(1336),
    [sym_ctxhole] = STATE(1336),
    [sym_qidentifier] = STATE(1337),
    [sym_identifier] = STATE(1275),
    [sym_qimplicit] = STATE(1337),
    [sym_qvarid] = STATE(1275),
    [sym_varid] = STATE(1284),
    [sym__qconstructor] = STATE(1337),
    [sym_handlerexpr] = STATE(1236),
    [sym_withstat] = STATE(2627),
    [sym_withexpr] = STATE(1234),
    [sym__open_brace_] = STATE(18),
    [sym__open_square_brace] = STATE(71),
    [sym__open_round_brace] = STATE(72),
    [sym_blockcomment] = STATE(139),
    [sym_float] = STATE(1237),
    [sym_int] = STATE(1237),
    [sym_idop] = STATE(1284),
    [sym__IMPLICITID] = STATE(1238),
    [sym_string] = STATE(1237),
    [sym_char] = STATE(1237),
    [aux_sym_opexpr_repeat1] = STATE(420),
    [anon_sym_inline] = ACTIONS(209),
    [anon_sym_cs] = ACTIONS(209),
    [anon_sym_js] = ACTIONS(209),
    [anon_sym_c] = ACTIONS(209),
    [anon_sym_named] = ACTIONS(341),
    [anon_sym_open] = ACTIONS(209),
    [anon_sym_extend] = ACTIONS(209),
    [anon_sym_co] = ACTIONS(209),
    [anon_sym_div] = ACTIONS(209),
    [anon_sym_lazy] = ACTIONS(343),
    [anon_sym_value] = ACTIONS(209),
    [anon_sym_reference] = ACTIONS(209),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ctx] = ACTIONS(213),
    [anon_sym_val] = ACTIONS(347),
    [anon_sym_noinline] = ACTIONS(209),
    [anon_sym_fip] = ACTIONS(209),
    [anon_sym_fbip] = ACTIONS(209),
    [anon_sym__] = ACTIONS(219),
    [anon_sym_tail] = ACTIONS(209),
    [anon_sym_match] = ACTIONS(349),
    [anon_sym_fn] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(227),
    [anon_sym_behind] = ACTIONS(209),
    [anon_sym_file] = ACTIONS(209),
    [anon_sym_scoped] = ACTIONS(209),
    [anon_sym_initially] = ACTIONS(209),
    [anon_sym_finally] = ACTIONS(209),
    [sym_qconid] = ACTIONS(229),
    [sym_conid] = ACTIONS(229),
    [anon_sym_handler] = ACTIONS(357),
    [anon_sym_handle] = ACTIONS(359),
    [sym_override] = ACTIONS(341),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(231),
    [sym_id] = ACTIONS(209),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(233),
    [aux_sym_float_token2] = ACTIONS(233),
    [aux_sym_int_token1] = ACTIONS(235),
    [aux_sym_int_token2] = ACTIONS(235),
    [sym_qid] = ACTIONS(237),
    [sym_qidop] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(243),
    [anon_sym_SQUOTE] = ACTIONS(245),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(247),
  },
  [140] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(2502),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(140),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [141] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1749),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(141),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [142] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1453),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(142),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [143] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(2084),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(143),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [144] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1456),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(144),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [145] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(1873),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(981),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2610),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(145),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(457),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(433),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(439),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [146] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(1753),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(146),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STATE(1310),
    [sym__IMPLICITID] = STATE(1287),
    [sym_string] = STATE(1286),
    [sym_char] = STATE(1286),
    [aux_sym_opexpr_repeat1] = STATE(427),
    [anon_sym_inline] = ACTIONS(59),
    [anon_sym_cs] = ACTIONS(59),
    [anon_sym_js] = ACTIONS(59),
    [anon_sym_c] = ACTIONS(59),
    [anon_sym_named] = ACTIONS(183),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_extend] = ACTIONS(59),
    [anon_sym_co] = ACTIONS(59),
    [anon_sym_div] = ACTIONS(59),
    [anon_sym_lazy] = ACTIONS(185),
    [anon_sym_value] = ACTIONS(59),
    [anon_sym_reference] = ACTIONS(59),
    [anon_sym_linear] = ACTIONS(59),
    [anon_sym_ctx] = ACTIONS(65),
    [anon_sym_val] = ACTIONS(189),
    [anon_sym_noinline] = ACTIONS(59),
    [anon_sym_fip] = ACTIONS(59),
    [anon_sym_fbip] = ACTIONS(59),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_tail] = ACTIONS(59),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_fn] = ACTIONS(193),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(83),
    [anon_sym_behind] = ACTIONS(59),
    [anon_sym_file] = ACTIONS(59),
    [anon_sym_scoped] = ACTIONS(59),
    [anon_sym_initially] = ACTIONS(59),
    [anon_sym_finally] = ACTIONS(59),
    [sym_qconid] = ACTIONS(85),
    [sym_conid] = ACTIONS(85),
    [anon_sym_handler] = ACTIONS(199),
    [anon_sym_handle] = ACTIONS(201),
    [sym_override] = ACTIONS(183),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(95),
    [sym_id] = ACTIONS(59),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(97),
    [aux_sym_float_token2] = ACTIONS(97),
    [aux_sym_int_token1] = ACTIONS(99),
    [aux_sym_int_token2] = ACTIONS(99),
    [sym_qid] = ACTIONS(101),
    [sym_qidop] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(113),
  },
  [147] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1416),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(147),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [148] = {
    [sym_block] = STATE(1435),
    [sym__blockexpr] = STATE(1420),
    [sym_expr] = STATE(1438),
    [sym_basicexpr] = STATE(1435),
    [sym_matchexpr] = STATE(1493),
    [sym_fnexpr] = STATE(1493),
    [sym_returnexpr] = STATE(1435),
    [sym_ifexpr] = STATE(1493),
    [sym_valexpr] = STATE(1435),
    [sym_opexpr] = STATE(1493),
    [sym_atom] = STATE(1036),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(1493),
    [sym_withstat] = STATE(2654),
    [sym_withexpr] = STATE(1435),
    [sym__open_brace_] = STATE(6),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(148),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(401),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(313),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(251),
    [anon_sym_val] = ACTIONS(367),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(319),
    [anon_sym_fn] = ACTIONS(369),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(327),
    [anon_sym_handle] = ACTIONS(329),
    [sym_override] = ACTIONS(311),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(263),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [149] = {
    [sym_block] = STATE(2100),
    [sym__blockexpr] = STATE(2321),
    [sym_expr] = STATE(2045),
    [sym_basicexpr] = STATE(2100),
    [sym_matchexpr] = STATE(2035),
    [sym_fnexpr] = STATE(2035),
    [sym_returnexpr] = STATE(2100),
    [sym_ifexpr] = STATE(2035),
    [sym_valexpr] = STATE(2100),
    [sym_opexpr] = STATE(2035),
    [sym_atom] = STATE(1066),
    [sym_name] = STATE(1412),
    [sym_literal] = STATE(1412),
    [sym_mask] = STATE(1412),
    [sym_ctxexpr] = STATE(1412),
    [sym_ctxhole] = STATE(1412),
    [sym_qidentifier] = STATE(1463),
    [sym_identifier] = STATE(1409),
    [sym_qimplicit] = STATE(1463),
    [sym_qvarid] = STATE(1409),
    [sym_varid] = STATE(1492),
    [sym__qconstructor] = STATE(1463),
    [sym_handlerexpr] = STATE(2035),
    [sym_withstat] = STATE(2734),
    [sym_withexpr] = STATE(2100),
    [sym__open_brace_] = STATE(30),
    [sym__open_square_brace] = STATE(96),
    [sym__open_round_brace] = STATE(101),
    [sym_blockcomment] = STATE(149),
    [sym_float] = STATE(1431),
    [sym_int] = STATE(1431),
    [sym_idop] = STATE(1492),
    [sym__IMPLICITID] = STATE(1469),
    [sym_string] = STATE(1431),
    [sym_char] = STATE(1431),
    [aux_sym_opexpr_repeat1] = STATE(431),
    [anon_sym_inline] = ACTIONS(117),
    [anon_sym_cs] = ACTIONS(117),
    [anon_sym_js] = ACTIONS(117),
    [anon_sym_c] = ACTIONS(117),
    [anon_sym_named] = ACTIONS(119),
    [anon_sym_open] = ACTIONS(117),
    [anon_sym_extend] = ACTIONS(117),
    [anon_sym_co] = ACTIONS(117),
    [anon_sym_div] = ACTIONS(117),
    [anon_sym_lazy] = ACTIONS(121),
    [anon_sym_value] = ACTIONS(117),
    [anon_sym_reference] = ACTIONS(117),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ctx] = ACTIONS(123),
    [anon_sym_val] = ACTIONS(127),
    [anon_sym_noinline] = ACTIONS(117),
    [anon_sym_fip] = ACTIONS(117),
    [anon_sym_fbip] = ACTIONS(117),
    [anon_sym__] = ACTIONS(129),
    [anon_sym_tail] = ACTIONS(117),
    [anon_sym_match] = ACTIONS(131),
    [anon_sym_fn] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_TILDE] = ACTIONS(81),
    [anon_sym_mask] = ACTIONS(139),
    [anon_sym_behind] = ACTIONS(117),
    [anon_sym_file] = ACTIONS(117),
    [anon_sym_scoped] = ACTIONS(117),
    [anon_sym_initially] = ACTIONS(117),
    [anon_sym_finally] = ACTIONS(117),
    [sym_qconid] = ACTIONS(141),
    [sym_conid] = ACTIONS(141),
    [anon_sym_handler] = ACTIONS(143),
    [anon_sym_handle] = ACTIONS(145),
    [sym_override] = ACTIONS(119),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LPAREN] = ACTIONS(147),
    [sym_id] = ACTIONS(117),
    [sym_linecomment] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [aux_sym_float_token1] = ACTIONS(149),
    [aux_sym_float_token2] = ACTIONS(149),
    [aux_sym_int_token1] = ACTIONS(151),
    [aux_sym_int_token2] = ACTIONS(151),
    [sym_qid] = ACTIONS(153),
    [sym_qidop] = ACTIONS(155),
    [anon_sym_QMARK] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [sym__open_brace] = ACTIONS(111),
    [sym__raw_string] = ACTIONS(163),
  },
  [150] = {
    [sym_block] = STATE(1763),
    [sym__blockexpr] = STATE(2545),
    [sym_expr] = STATE(1764),
    [sym_basicexpr] = STATE(1763),
    [sym_matchexpr] = STATE(1765),
    [sym_fnexpr] = STATE(1765),
    [sym_returnexpr] = STATE(1763),
    [sym_ifexpr] = STATE(1765),
    [sym_valexpr] = STATE(1763),
    [sym_opexpr] = STATE(1765),
    [sym_atom] = STATE(1009),
    [sym_name] = STATE(1319),
    [sym_literal] = STATE(1319),
    [sym_mask] = STATE(1319),
    [sym_ctxexpr] = STATE(1319),
    [sym_ctxhole] = STATE(1319),
    [sym_qidentifier] = STATE(1320),
    [sym_identifier] = STATE(1283),
    [sym_qimplicit] = STATE(1320),
    [sym_qvarid] = STATE(1283),
    [sym_varid] = STATE(1310),
    [sym__qconstructor] = STATE(1320),
    [sym_handlerexpr] = STATE(1765),
    [sym_withstat] = STATE(2566),
    [sym_withexpr] = STATE(1763),
    [sym__open_brace_] = STATE(10),
    [sym__open_square_brace] = STATE(82),
    [sym__open_round_brace] = STATE(83),
    [sym_blockcomment] = STATE(150),
    [sym_float] = STATE(1286),
    [sym_int] = STATE(1286),
    [sym_idop] = STA