#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 901
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 106
#define ALIAS_COUNT 0
#define TOKEN_COUNT 62
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 5
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 12

enum ts_symbol_identifiers {
  sym_simple_word = 1,
  anon_sym_LF = 2,
  anon_sym_SEMI = 3,
  sym_comment = 4,
  anon_sym_while = 5,
  anon_sym_expr = 6,
  anon_sym_foreach = 7,
  anon_sym_global = 8,
  anon_sym_namespace = 9,
  anon_sym_try = 10,
  anon_sym_on = 11,
  anon_sym_error = 12,
  anon_sym_finally = 13,
  sym_unpack = 14,
  sym__ident = 15,
  anon_sym_LPAREN = 16,
  anon_sym_RPAREN = 17,
  anon_sym_DOLLAR = 18,
  anon_sym_LBRACE = 19,
  aux_sym_variable_substitution_token1 = 20,
  anon_sym_RBRACE = 21,
  anon_sym_set = 22,
  anon_sym_proc = 23,
  anon_sym_DASH = 24,
  anon_sym_PLUS = 25,
  anon_sym_TILDE = 26,
  anon_sym_BANG = 27,
  anon_sym_STAR_STAR = 28,
  anon_sym_SLASH = 29,
  anon_sym_STAR = 30,
  anon_sym_PERCENT = 31,
  anon_sym_LT_LT = 32,
  anon_sym_GT_GT = 33,
  anon_sym_GT = 34,
  anon_sym_LT = 35,
  anon_sym_GT_EQ = 36,
  anon_sym_LT_EQ = 37,
  anon_sym_EQ_EQ = 38,
  anon_sym_BANG_EQ = 39,
  anon_sym_eq = 40,
  anon_sym_ne = 41,
  anon_sym_in = 42,
  anon_sym_ni = 43,
  anon_sym_AMP = 44,
  anon_sym_CARET = 45,
  anon_sym_PIPE = 46,
  anon_sym_AMP_AMP = 47,
  anon_sym_PIPE_PIPE = 48,
  anon_sym_QMARK = 49,
  anon_sym_COLON = 50,
  anon_sym_elseif = 51,
  anon_sym_else = 52,
  anon_sym_if = 53,
  anon_sym_catch = 54,
  anon_sym_DQUOTE = 55,
  sym_escaped_character = 56,
  sym__quoted_word_content = 57,
  anon_sym_LBRACK = 58,
  anon_sym_RBRACK = 59,
  sym_concat = 60,
  sym__ns_delim = 61,
  sym_source_file = 62,
  sym_while = 63,
  sym_expr_cmd = 64,
  sym_foreach = 65,
  sym_global = 66,
  sym_namespace = 67,
  sym_try = 68,
  sym_finally = 69,
  sym__command = 70,
  sym_command = 71,
  sym_word_list = 72,
  sym__word_simple = 73,
  sym__concat_word = 74,
  sym_id = 75,
  sym_array_index = 76,
  sym_variable_substitution = 77,
  sym_braced_word = 78,
  sym_braced_word_simple = 79,
  sym_set = 80,
  sym_procedure = 81,
  sym__argument_word = 82,
  sym_argument = 83,
  sym_arguments = 84,
  sym__expr = 85,
  sym_expr = 86,
  sym_unary_expr = 87,
  sym_binop_expr = 88,
  sym_ternary_expr = 89,
  sym_elseif = 90,
  sym_else = 91,
  sym_conditional = 92,
  sym_catch = 93,
  sym_quoted_word = 94,
  sym_command_substitution = 95,
  aux_sym__commands_repeat1 = 96,
  aux_sym__commands_repeat2 = 97,
  aux_sym_global_repeat1 = 98,
  aux_sym_word_list_repeat1 = 99,
  aux_sym__concat_word_repeat1 = 100,
  aux_sym_id_repeat1 = 101,
  aux_sym_braced_word_simple_repeat1 = 102,
  aux_sym_arguments_repeat1 = 103,
  aux_sym_conditional_repeat1 = 104,
  aux_sym_quoted_word_repeat1 = 105,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_simple_word] = "simple_word",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [sym_comment] = "comment",
  [anon_sym_while] = "while",
  [anon_sym_expr] = "expr",
  [anon_sym_foreach] = "foreach",
  [anon_sym_global] = "global",
  [anon_sym_namespace] = "namespace",
  [anon_sym_try] = "try",
  [anon_sym_on] = "on",
  [anon_sym_error] = "error",
  [anon_sym_finally] = "finally",
  [sym_unpack] = "unpack",
  [sym__ident] = "_ident",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACE] = "{",
  [aux_sym_variable_substitution_token1] = "variable_substitution_token1",
  [anon_sym_RBRACE] = "}",
  [anon_sym_set] = "set",
  [anon_sym_proc] = "proc",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG] = "!",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR] = "*",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_eq] = "eq",
  [anon_sym_ne] = "ne",
  [anon_sym_in] = "in",
  [anon_sym_ni] = "ni",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_catch] = "catch",
  [anon_sym_DQUOTE] = "\"",
  [sym_escaped_character] = "escaped_character",
  [sym__quoted_word_content] = "_quoted_word_content",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_concat] = "concat",
  [sym__ns_delim] = "_ns_delim",
  [sym_source_file] = "source_file",
  [sym_while] = "while",
  [sym_expr_cmd] = "expr_cmd",
  [sym_foreach] = "foreach",
  [sym_global] = "global",
  [sym_namespace] = "namespace",
  [sym_try] = "try",
  [sym_finally] = "finally",
  [sym__command] = "_command",
  [sym_command] = "command",
  [sym_word_list] = "word_list",
  [sym__word_simple] = "_word_simple",
  [sym__concat_word] = "_concat_word",
  [sym_id] = "id",
  [sym_array_index] = "array_index",
  [sym_variable_substitution] = "variable_substitution",
  [sym_braced_word] = "braced_word",
  [sym_braced_word_simple] = "braced_word_simple",
  [sym_set] = "set",
  [sym_procedure] = "procedure",
  [sym__argument_word] = "_argument_word",
  [sym_argument] = "argument",
  [sym_arguments] = "arguments",
  [sym__expr] = "_expr",
  [sym_expr] = "expr",
  [sym_unary_expr] = "unary_expr",
  [sym_binop_expr] = "binop_expr",
  [sym_ternary_expr] = "ternary_expr",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_conditional] = "conditional",
  [sym_catch] = "catch",
  [sym_quoted_word] = "quoted_word",
  [sym_command_substitution] = "command_substitution",
  [aux_sym__commands_repeat1] = "_commands_repeat1",
  [aux_sym__commands_repeat2] = "_commands_repeat2",
  [aux_sym_global_repeat1] = "global_repeat1",
  [aux_sym_word_list_repeat1] = "word_list_repeat1",
  [aux_sym__concat_word_repeat1] = "_concat_word_repeat1",
  [aux_sym_id_repeat1] = "id_repeat1",
  [aux_sym_braced_word_simple_repeat1] = "braced_word_simple_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_conditional_repeat1] = "conditional_repeat1",
  [aux_sym_quoted_word_repeat1] = "quoted_word_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_simple_word] = sym_simple_word,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_comment] = sym_comment,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_expr] = anon_sym_expr,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_finally] = anon_sym_finally,
  [sym_unpack] = sym_unpack,
  [sym__ident] = sym__ident,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [aux_sym_variable_substitution_token1] = aux_sym_variable_substitution_token1,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_proc] = anon_sym_proc,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_ne] = anon_sym_ne,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_ni] = anon_sym_ni,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_escaped_character] = sym_escaped_character,
  [sym__quoted_word_content] = sym__quoted_word_content,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_concat] = sym_concat,
  [sym__ns_delim] = sym__ns_delim,
  [sym_source_file] = sym_source_file,
  [sym_while] = sym_while,
  [sym_expr_cmd] = sym_expr_cmd,
  [sym_foreach] = sym_foreach,
  [sym_global] = sym_global,
  [sym_namespace] = sym_namespace,
  [sym_try] = sym_try,
  [sym_finally] = sym_finally,
  [sym__command] = sym__command,
  [sym_command] = sym_command,
  [sym_word_list] = sym_word_list,
  [sym__word_simple] = sym__word_simple,
  [sym__concat_word] = sym__concat_word,
  [sym_id] = sym_id,
  [sym_array_index] = sym_array_index,
  [sym_variable_substitution] = sym_variable_substitution,
  [sym_braced_word] = sym_braced_word,
  [sym_braced_word_simple] = sym_braced_word_simple,
  [sym_set] = sym_set,
  [sym_procedure] = sym_procedure,
  [sym__argument_word] = sym__argument_word,
  [sym_argument] = sym_argument,
  [sym_arguments] = sym_arguments,
  [sym__expr] = sym__expr,
  [sym_expr] = sym_expr,
  [sym_unary_expr] = sym_unary_expr,
  [sym_binop_expr] = sym_binop_expr,
  [sym_ternary_expr] = sym_ternary_expr,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_conditional] = sym_conditional,
  [sym_catch] = sym_catch,
  [sym_quoted_word] = sym_quoted_word,
  [sym_command_substitution] = sym_command_substitution,
  [aux_sym__commands_repeat1] = aux_sym__commands_repeat1,
  [aux_sym__commands_repeat2] = aux_sym__commands_repeat2,
  [aux_sym_global_repeat1] = aux_sym_global_repeat1,
  [aux_sym_word_list_repeat1] = aux_sym_word_list_repeat1,
  [aux_sym__concat_word_repeat1] = aux_sym__concat_word_repeat1,
  [aux_sym_id_repeat1] = aux_sym_id_repeat1,
  [aux_sym_braced_word_simple_repeat1] = aux_sym_braced_word_simple_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_conditional_repeat1] = aux_sym_conditional_repeat1,
  [aux_sym_quoted_word_repeat1] = aux_sym_quoted_word_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_simple_word] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_expr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [sym_unpack] = {
    .visible = true,
    .named = true,
  },
  [sym__ident] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_substitution_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_proc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ne] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ni] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_escaped_character] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_word_content] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_concat] = {
    .visible = true,
    .named = true,
  },
  [sym__ns_delim] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_expr_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_global] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym_finally] = {
    .visible = true,
    .named = true,
  },
  [sym__command] = {
    .visible = false,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_word_list] = {
    .visible = true,
    .named = true,
  },
  [sym__word_simple] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_word] = {
    .visible = false,
    .named = true,
  },
  [sym_id] = {
    .visible = true,
    .named = true,
  },
  [sym_array_index] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_word] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_word_simple] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_word] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_binop_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym_catch] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_word] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__commands_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__commands_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_word_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__concat_word_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_id_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_braced_word_simple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conditional_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_word_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_arguments = 1,
  field_body = 2,
  field_condition = 3,
  field_default = 4,
  field_name = 5,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_default] = "default",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 3},
  [5] = {.index = 8, .length = 1},
  [6] = {.index = 9, .length = 3},
  [7] = {.index = 12, .length = 1},
  [8] = {.index = 13, .length = 4},
  [9] = {.index = 17, .length = 4},
  [10] = {.index = 21, .length = 2},
  [11] = {.index = 23, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 0},
    {field_name, 1},
  [3] =
    {field_arguments, 1},
    {field_name, 0},
  [5] =
    {field_arguments, 2},
    {field_name, 0},
    {field_name, 1},
  [8] =
    {field_condition, 1},
  [9] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [12] =
    {field_name, 1},
  [13] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 1},
    {field_name, 2},
  [17] =
    {field_arguments, 2},
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [21] =
    {field_default, 2},
    {field_name, 1},
  [23] =
    {field_arguments, 3},
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_name, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 4,
  [7] = 4,
  [8] = 8,
  [9] = 8,
  [10] = 5,
  [11] = 8,
  [12] = 2,
  [13] = 2,
  [14] = 4,
  [15] = 2,
  [16] = 5,
  [17] = 5,
  [18] = 18,
  [19] = 5,
  [20] = 2,
  [21] = 4,
  [22] = 5,
  [23] = 23,
  [24] = 4,
  [25] = 8,
  [26] = 8,
  [27] = 8,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 30,
  [32] = 32,
  [33] = 30,
  [34] = 30,
  [35] = 30,
  [36] = 32,
  [37] = 30,
  [38] = 38,
  [39] = 39,
  [40] = 39,
  [41] = 39,
  [42] = 39,
  [43] = 39,
  [44] = 44,
  [45] = 39,
  [46] = 39,
  [47] = 47,
  [48] = 48,
  [49] = 38,
  [50] = 38,
  [51] = 39,
  [52] = 48,
  [53] = 53,
  [54] = 48,
  [55] = 39,
  [56] = 44,
  [57] = 53,
  [58] = 47,
  [59] = 44,
  [60] = 53,
  [61] = 47,
  [62] = 39,
  [63] = 63,
  [64] = 63,
  [65] = 65,
  [66] = 65,
  [67] = 67,
  [68] = 65,
  [69] = 63,
  [70] = 70,
  [71] = 70,
  [72] = 70,
  [73] = 73,
  [74] = 74,
  [75] = 73,
  [76] = 73,
  [77] = 77,
  [78] = 74,
  [79] = 74,
  [80] = 77,
  [81] = 77,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 83,
  [89] = 89,
  [90] = 82,
  [91] = 89,
  [92] = 86,
  [93] = 87,
  [94] = 85,
  [95] = 87,
  [96] = 83,
  [97] = 38,
  [98] = 84,
  [99] = 85,
  [100] = 48,
  [101] = 44,
  [102] = 53,
  [103] = 86,
  [104] = 82,
  [105] = 84,
  [106] = 89,
  [107] = 47,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 67,
  [112] = 112,
  [113] = 65,
  [114] = 114,
  [115] = 115,
  [116] = 70,
  [117] = 63,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 77,
  [133] = 73,
  [134] = 67,
  [135] = 74,
  [136] = 67,
  [137] = 86,
  [138] = 82,
  [139] = 83,
  [140] = 84,
  [141] = 87,
  [142] = 85,
  [143] = 89,
  [144] = 125,
  [145] = 114,
  [146] = 119,
  [147] = 112,
  [148] = 124,
  [149] = 127,
  [150] = 128,
  [151] = 129,
  [152] = 130,
  [153] = 110,
  [154] = 131,
  [155] = 126,
  [156] = 109,
  [157] = 123,
  [158] = 122,
  [159] = 121,
  [160] = 120,
  [161] = 118,
  [162] = 115,
  [163] = 119,
  [164] = 121,
  [165] = 120,
  [166] = 118,
  [167] = 115,
  [168] = 108,
  [169] = 112,
  [170] = 118,
  [171] = 125,
  [172] = 128,
  [173] = 131,
  [174] = 127,
  [175] = 126,
  [176] = 109,
  [177] = 129,
  [178] = 128,
  [179] = 123,
  [180] = 127,
  [181] = 124,
  [182] = 130,
  [183] = 120,
  [184] = 122,
  [185] = 114,
  [186] = 110,
  [187] = 121,
  [188] = 122,
  [189] = 123,
  [190] = 109,
  [191] = 129,
  [192] = 110,
  [193] = 124,
  [194] = 130,
  [195] = 112,
  [196] = 119,
  [197] = 131,
  [198] = 108,
  [199] = 126,
  [200] = 114,
  [201] = 115,
  [202] = 125,
  [203] = 203,
  [204] = 204,
  [205] = 204,
  [206] = 203,
  [207] = 207,
  [208] = 208,
  [209] = 204,
  [210] = 203,
  [211] = 207,
  [212] = 208,
  [213] = 204,
  [214] = 203,
  [215] = 207,
  [216] = 208,
  [217] = 108,
  [218] = 207,
  [219] = 208,
  [220] = 220,
  [221] = 220,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 225,
  [227] = 224,
  [228] = 223,
  [229] = 225,
  [230] = 224,
  [231] = 222,
  [232] = 222,
  [233] = 223,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 234,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 241,
  [245] = 238,
  [246] = 236,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 235,
  [251] = 251,
  [252] = 240,
  [253] = 251,
  [254] = 235,
  [255] = 243,
  [256] = 249,
  [257] = 242,
  [258] = 248,
  [259] = 247,
  [260] = 236,
  [261] = 261,
  [262] = 243,
  [263] = 263,
  [264] = 234,
  [265] = 238,
  [266] = 241,
  [267] = 243,
  [268] = 241,
  [269] = 247,
  [270] = 270,
  [271] = 271,
  [272] = 242,
  [273] = 270,
  [274] = 238,
  [275] = 234,
  [276] = 240,
  [277] = 251,
  [278] = 278,
  [279] = 236,
  [280] = 247,
  [281] = 270,
  [282] = 235,
  [283] = 249,
  [284] = 248,
  [285] = 242,
  [286] = 248,
  [287] = 261,
  [288] = 249,
  [289] = 270,
  [290] = 251,
  [291] = 278,
  [292] = 240,
  [293] = 271,
  [294] = 271,
  [295] = 239,
  [296] = 239,
  [297] = 263,
  [298] = 263,
  [299] = 278,
  [300] = 261,
  [301] = 271,
  [302] = 278,
  [303] = 239,
  [304] = 263,
  [305] = 261,
  [306] = 306,
  [307] = 307,
  [308] = 306,
  [309] = 307,
  [310] = 310,
  [311] = 311,
  [312] = 310,
  [313] = 311,
  [314] = 307,
  [315] = 306,
  [316] = 316,
  [317] = 53,
  [318] = 311,
  [319] = 47,
  [320] = 44,
  [321] = 310,
  [322] = 53,
  [323] = 316,
  [324] = 316,
  [325] = 47,
  [326] = 38,
  [327] = 48,
  [328] = 38,
  [329] = 48,
  [330] = 44,
  [331] = 331,
  [332] = 331,
  [333] = 333,
  [334] = 334,
  [335] = 70,
  [336] = 336,
  [337] = 331,
  [338] = 331,
  [339] = 336,
  [340] = 70,
  [341] = 331,
  [342] = 334,
  [343] = 63,
  [344] = 334,
  [345] = 331,
  [346] = 65,
  [347] = 347,
  [348] = 348,
  [349] = 65,
  [350] = 334,
  [351] = 348,
  [352] = 63,
  [353] = 334,
  [354] = 347,
  [355] = 334,
  [356] = 356,
  [357] = 77,
  [358] = 358,
  [359] = 358,
  [360] = 356,
  [361] = 361,
  [362] = 358,
  [363] = 363,
  [364] = 74,
  [365] = 365,
  [366] = 366,
  [367] = 366,
  [368] = 361,
  [369] = 369,
  [370] = 366,
  [371] = 371,
  [372] = 361,
  [373] = 77,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 381,
  [384] = 375,
  [385] = 374,
  [386] = 382,
  [387] = 371,
  [388] = 369,
  [389] = 365,
  [390] = 363,
  [391] = 376,
  [392] = 377,
  [393] = 378,
  [394] = 379,
  [395] = 380,
  [396] = 73,
  [397] = 382,
  [398] = 381,
  [399] = 375,
  [400] = 374,
  [401] = 371,
  [402] = 369,
  [403] = 365,
  [404] = 363,
  [405] = 356,
  [406] = 380,
  [407] = 379,
  [408] = 378,
  [409] = 377,
  [410] = 53,
  [411] = 47,
  [412] = 44,
  [413] = 48,
  [414] = 38,
  [415] = 53,
  [416] = 47,
  [417] = 44,
  [418] = 48,
  [419] = 38,
  [420] = 376,
  [421] = 73,
  [422] = 74,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 347,
  [427] = 425,
  [428] = 336,
  [429] = 429,
  [430] = 63,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 348,
  [436] = 436,
  [437] = 433,
  [438] = 425,
  [439] = 433,
  [440] = 440,
  [441] = 85,
  [442] = 70,
  [443] = 443,
  [444] = 444,
  [445] = 83,
  [446] = 443,
  [447] = 85,
  [448] = 448,
  [449] = 424,
  [450] = 423,
  [451] = 431,
  [452] = 436,
  [453] = 87,
  [454] = 454,
  [455] = 455,
  [456] = 84,
  [457] = 454,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 87,
  [463] = 461,
  [464] = 86,
  [465] = 82,
  [466] = 89,
  [467] = 444,
  [468] = 440,
  [469] = 434,
  [470] = 460,
  [471] = 432,
  [472] = 429,
  [473] = 86,
  [474] = 432,
  [475] = 448,
  [476] = 65,
  [477] = 423,
  [478] = 431,
  [479] = 436,
  [480] = 448,
  [481] = 82,
  [482] = 443,
  [483] = 48,
  [484] = 424,
  [485] = 455,
  [486] = 458,
  [487] = 459,
  [488] = 454,
  [489] = 89,
  [490] = 460,
  [491] = 84,
  [492] = 83,
  [493] = 461,
  [494] = 444,
  [495] = 443,
  [496] = 455,
  [497] = 440,
  [498] = 70,
  [499] = 434,
  [500] = 458,
  [501] = 63,
  [502] = 429,
  [503] = 459,
  [504] = 38,
  [505] = 53,
  [506] = 65,
  [507] = 47,
  [508] = 44,
  [509] = 73,
  [510] = 70,
  [511] = 511,
  [512] = 65,
  [513] = 63,
  [514] = 77,
  [515] = 515,
  [516] = 515,
  [517] = 74,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 74,
  [522] = 519,
  [523] = 520,
  [524] = 511,
  [525] = 525,
  [526] = 77,
  [527] = 518,
  [528] = 525,
  [529] = 73,
  [530] = 83,
  [531] = 77,
  [532] = 74,
  [533] = 87,
  [534] = 85,
  [535] = 86,
  [536] = 82,
  [537] = 89,
  [538] = 538,
  [539] = 538,
  [540] = 87,
  [541] = 86,
  [542] = 538,
  [543] = 84,
  [544] = 538,
  [545] = 82,
  [546] = 89,
  [547] = 73,
  [548] = 83,
  [549] = 538,
  [550] = 538,
  [551] = 85,
  [552] = 84,
  [553] = 538,
  [554] = 538,
  [555] = 538,
  [556] = 538,
  [557] = 86,
  [558] = 85,
  [559] = 559,
  [560] = 48,
  [561] = 44,
  [562] = 562,
  [563] = 515,
  [564] = 47,
  [565] = 511,
  [566] = 53,
  [567] = 567,
  [568] = 568,
  [569] = 519,
  [570] = 559,
  [571] = 571,
  [572] = 571,
  [573] = 562,
  [574] = 562,
  [575] = 575,
  [576] = 571,
  [577] = 571,
  [578] = 562,
  [579] = 579,
  [580] = 575,
  [581] = 571,
  [582] = 582,
  [583] = 562,
  [584] = 518,
  [585] = 511,
  [586] = 518,
  [587] = 575,
  [588] = 579,
  [589] = 571,
  [590] = 575,
  [591] = 82,
  [592] = 575,
  [593] = 562,
  [594] = 575,
  [595] = 575,
  [596] = 571,
  [597] = 562,
  [598] = 575,
  [599] = 571,
  [600] = 515,
  [601] = 571,
  [602] = 562,
  [603] = 525,
  [604] = 520,
  [605] = 87,
  [606] = 525,
  [607] = 89,
  [608] = 38,
  [609] = 520,
  [610] = 84,
  [611] = 83,
  [612] = 575,
  [613] = 571,
  [614] = 562,
  [615] = 582,
  [616] = 562,
  [617] = 568,
  [618] = 618,
  [619] = 619,
  [620] = 119,
  [621] = 65,
  [622] = 520,
  [623] = 520,
  [624] = 511,
  [625] = 625,
  [626] = 63,
  [627] = 627,
  [628] = 518,
  [629] = 119,
  [630] = 70,
  [631] = 631,
  [632] = 515,
  [633] = 525,
  [634] = 518,
  [635] = 525,
  [636] = 112,
  [637] = 112,
  [638] = 515,
  [639] = 639,
  [640] = 625,
  [641] = 511,
  [642] = 642,
  [643] = 582,
  [644] = 559,
  [645] = 579,
  [646] = 627,
  [647] = 642,
  [648] = 568,
  [649] = 619,
  [650] = 650,
  [651] = 631,
  [652] = 650,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 625,
  [657] = 657,
  [658] = 658,
  [659] = 87,
  [660] = 660,
  [661] = 89,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 653,
  [666] = 84,
  [667] = 667,
  [668] = 83,
  [669] = 657,
  [670] = 670,
  [671] = 671,
  [672] = 660,
  [673] = 654,
  [674] = 654,
  [675] = 660,
  [676] = 658,
  [677] = 667,
  [678] = 654,
  [679] = 660,
  [680] = 654,
  [681] = 681,
  [682] = 658,
  [683] = 660,
  [684] = 658,
  [685] = 657,
  [686] = 686,
  [687] = 655,
  [688] = 657,
  [689] = 657,
  [690] = 690,
  [691] = 691,
  [692] = 664,
  [693] = 658,
  [694] = 670,
  [695] = 657,
  [696] = 696,
  [697] = 671,
  [698] = 663,
  [699] = 658,
  [700] = 690,
  [701] = 660,
  [702] = 654,
  [703] = 703,
  [704] = 703,
  [705] = 703,
  [706] = 703,
  [707] = 703,
  [708] = 703,
  [709] = 703,
  [710] = 703,
  [711] = 703,
  [712] = 650,
  [713] = 642,
  [714] = 703,
  [715] = 671,
  [716] = 716,
  [717] = 716,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 721,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 655,
  [734] = 734,
  [735] = 639,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 722,
  [740] = 740,
  [741] = 723,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 720,
  [748] = 724,
  [749] = 729,
  [750] = 738,
  [751] = 639,
  [752] = 736,
  [753] = 753,
  [754] = 746,
  [755] = 745,
  [756] = 756,
  [757] = 757,
  [758] = 719,
  [759] = 737,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 663,
  [765] = 765,
  [766] = 667,
  [767] = 721,
  [768] = 768,
  [769] = 744,
  [770] = 768,
  [771] = 732,
  [772] = 756,
  [773] = 727,
  [774] = 670,
  [775] = 757,
  [776] = 719,
  [777] = 743,
  [778] = 778,
  [779] = 757,
  [780] = 763,
  [781] = 731,
  [782] = 763,
  [783] = 730,
  [784] = 778,
  [785] = 765,
  [786] = 762,
  [787] = 756,
  [788] = 734,
  [789] = 789,
  [790] = 760,
  [791] = 791,
  [792] = 726,
  [793] = 728,
  [794] = 789,
  [795] = 795,
  [796] = 740,
  [797] = 742,
  [798] = 753,
  [799] = 718,
  [800] = 727,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 740,
  [806] = 806,
  [807] = 801,
  [808] = 802,
  [809] = 803,
  [810] = 806,
  [811] = 806,
  [812] = 804,
  [813] = 722,
  [814] = 814,
  [815] = 806,
  [816] = 801,
  [817] = 802,
  [818] = 803,
  [819] = 803,
  [820] = 804,
  [821] = 804,
  [822] = 803,
  [823] = 806,
  [824] = 801,
  [825] = 802,
  [826] = 803,
  [827] = 806,
  [828] = 804,
  [829] = 802,
  [830] = 801,
  [831] = 789,
  [832] = 738,
  [833] = 736,
  [834] = 834,
  [835] = 802,
  [836] = 768,
  [837] = 801,
  [838] = 806,
  [839] = 778,
  [840] = 728,
  [841] = 803,
  [842] = 804,
  [843] = 734,
  [844] = 745,
  [845] = 803,
  [846] = 846,
  [847] = 737,
  [848] = 834,
  [849] = 804,
  [850] = 802,
  [851] = 801,
  [852] = 834,
  [853] = 729,
  [854] = 806,
  [855] = 85,
  [856] = 804,
  [857] = 724,
  [858] = 86,
  [859] = 803,
  [860] = 716,
  [861] = 732,
  [862] = 744,
  [863] = 863,
  [864] = 742,
  [865] = 802,
  [866] = 834,
  [867] = 731,
  [868] = 801,
  [869] = 869,
  [870] = 801,
  [871] = 730,
  [872] = 834,
  [873] = 806,
  [874] = 804,
  [875] = 723,
  [876] = 834,
  [877] = 877,
  [878] = 802,
  [879] = 760,
  [880] = 834,
  [881] = 718,
  [882] = 720,
  [883] = 834,
  [884] = 762,
  [885] = 804,
  [886] = 834,
  [887] = 746,
  [888] = 803,
  [889] = 834,
  [890] = 806,
  [891] = 802,
  [892] = 753,
  [893] = 765,
  [894] = 863,
  [895] = 877,
  [896] = 801,
  [897] = 726,
  [898] = 639,
  [899] = 863,
  [900] = 877,
};

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < '('
    ? (c < ' '
      ? (c < 11
        ? c == '\t'
        : c <= '\r')
      : (c <= '"' || c == '$'))
    : (c <= ')' || (c < '{'
      ? (c < '['
        ? c == ';'
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_simple_word_character_set_1(int32_t c) {
  return (c < '('
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= '"' || c == '$'))
    : (c <= ')' || (c < '{'
      ? (c < '['
        ? c == ';'
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(49);
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(71);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ':') ADVANCE(118);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') SKIP(37)
      if (lookahead == ']') ADVANCE(125);
      if (lookahead == '^') ADVANCE(108);
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(127);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '~') ADVANCE(72);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(50);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ']') ADVANCE(130);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(1)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(21)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(20)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(23)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(26)
      if (lookahead == '\r') SKIP(11)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(24)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(25)
      if (lookahead == '\r') ADVANCE(120);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(30)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(30)
      if (lookahead == '\r') SKIP(15)
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(52);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ')' &&
          lookahead != ']') ADVANCE(130);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '+') ADVANCE(71);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead == '{') ADVANCE(61);
      if (lookahead == '~') ADVANCE(72);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(130);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(71);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '^') ADVANCE(108);
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(127);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(109);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(130);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(106);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(70);
      if (lookahead == '-') ADVANCE(68);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == ':') ADVANCE(117);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '=') ADVANCE(28);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(115);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == ']') ADVANCE(125);
      if (lookahead == '^') ADVANCE(107);
      if (lookahead == 'e') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '{') ADVANCE(62);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(130);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == ']') ADVANCE(125);
      if (lookahead == '{') ADVANCE(62);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '}') ADVANCE(130);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '{') ADVANCE(61);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != ']') ADVANCE(130);
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(123);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(14);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(123);
      END_STATE();
    case 26:
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == ']') ADVANCE(125);
      if (lookahead == '{') ADVANCE(61);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(26)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '$' &&
          lookahead != ';' &&
          lookahead != '[') ADVANCE(130);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 29:
      if (lookahead == '\\') ADVANCE(63);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(65);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(66);
      END_STATE();
    case 30:
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '{') ADVANCE(61);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30)
      END_STATE();
    case 31:
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '{') ADVANCE(61);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 34:
      if (lookahead == 'q') ADVANCE(97);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(56);
      END_STATE();
    case 36:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 37:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(36)
      END_STATE();
    case 38:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') ADVANCE(50);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(38)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ']') ADVANCE(130);
      END_STATE();
    case 39:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(41)
      END_STATE();
    case 40:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(41)
      if (lookahead == '\r') SKIP(39)
      END_STATE();
    case 41:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') ADVANCE(51);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(105);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(71);
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(116);
      if (lookahead == '\\') SKIP(40)
      if (lookahead == '^') ADVANCE(108);
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(127);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(41)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != ')' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '{') ADVANCE(130);
      END_STATE();
    case 42:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') ADVANCE(51);
      if (lookahead == '!') ADVANCE(27);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(106);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(70);
      if (lookahead == '-') ADVANCE(68);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '=') ADVANCE(28);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(115);
      if (lookahead == '\\') SKIP(45)
      if (lookahead == '^') ADVANCE(107);
      if (lookahead == 'e') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(42)
      END_STATE();
    case 43:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') ADVANCE(51);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '\\') SKIP(47)
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(43)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '{') ADVANCE(130);
      END_STATE();
    case 44:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(42)
      END_STATE();
    case 45:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(42)
      if (lookahead == '\r') SKIP(44)
      END_STATE();
    case 46:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(43)
      END_STATE();
    case 47:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') SKIP(43)
      if (lookahead == '\r') SKIP(46)
      END_STATE();
    case 48:
      if (eof) ADVANCE(49);
      if (lookahead == '\n') ADVANCE(52);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ';') ADVANCE(53);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '}') ADVANCE(67);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(48)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ')' &&
          lookahead != ']') ADVANCE(130);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(50);
      if (lookahead == '\\') ADVANCE(2);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(52);
      if (lookahead == '\\') ADVANCE(8);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_comment);
      if (sym_comment_character_set_1(lookahead)) ADVANCE(55);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_unpack);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym__ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '*') ADVANCE(35);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_variable_substitution_token1);
      if (lookahead == '\n') ADVANCE(65);
      if (lookahead == '\r') ADVANCE(64);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(66);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_variable_substitution_token1);
      if (lookahead == '\n') ADVANCE(65);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(66);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(aux_sym_variable_substitution_token1);
      if (lookahead == '\\') ADVANCE(63);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(65);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(66);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_variable_substitution_token1);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(75);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(74);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(91);
      if (lookahead == '>') ADVANCE(85);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(90);
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(93);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_eq);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_eq);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_ne);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_ne);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_in);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_ni);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_ni);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(112);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(111);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < ' ' || '"' < lookahead) &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(130);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(113);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_escaped_character);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym__quoted_word_content);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(123);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym__quoted_word_content);
      if (lookahead == '"') ADVANCE(119);
      if (lookahead == '$') ADVANCE(60);
      if (lookahead == '[') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(14);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(123);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym__quoted_word_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_simple_word);
      if (lookahead == '=') ADVANCE(95);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_simple_word);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(104);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_simple_word);
      if (lookahead == 'n') ADVANCE(102);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_simple_word);
      if (lookahead == 'q') ADVANCE(98);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_simple_word);
      if (!sym_simple_word_character_set_1(lookahead)) ADVANCE(130);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'c') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'g') ADVANCE(5);
      if (lookahead == 'i') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(7);
      if (lookahead == 'o') ADVANCE(8);
      if (lookahead == 'p') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == 'w') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 'x') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'i') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(20);
      END_STATE();
    case 6:
      if (lookahead == 'f') ADVANCE(21);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 8:
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 9:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(27);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 14:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 's') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      if (lookahead == 'm') ADVANCE(35);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 26:
      if (lookahead == 'y') ADVANCE(38);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(40);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'b') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(48);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(50);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 42:
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_expr);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(53);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 47:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_proc);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 51:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(59);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(60);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 56:
      if (lookahead == 'p') ADVANCE(62);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 59:
      if (lookahead == 'y') ADVANCE(63);
      END_STATE();
    case 60:
      if (lookahead == 'h') ADVANCE(64);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 38},
  [2] = {.lex_state = 38},
  [3] = {.lex_state = 38},
  [4] = {.lex_state = 38},
  [5] = {.lex_state = 38},
  [6] = {.lex_state = 38},
  [7] = {.lex_state = 38},
  [8] = {.lex_state = 38},
  [9] = {.lex_state = 38},
  [10] = {.lex_state = 38},
  [11] = {.lex_state = 38},
  [12] = {.lex_state = 38},
  [13] = {.lex_state = 38},
  [14] = {.lex_state = 38},
  [15] = {.lex_state = 38},
  [16] = {.lex_state = 38},
  [17] = {.lex_state = 38},
  [18] = {.lex_state = 38},
  [19] = {.lex_state = 38},
  [20] = {.lex_state = 38},
  [21] = {.lex_state = 38},
  [22] = {.lex_state = 38},
  [23] = {.lex_state = 38},
  [24] = {.lex_state = 38},
  [25] = {.lex_state = 38},
  [26] = {.lex_state = 38},
  [27] = {.lex_state = 38},
  [28] = {.lex_state = 38},
  [29] = {.lex_state = 38},
  [30] = {.lex_state = 38},
  [31] = {.lex_state = 38},
  [32] = {.lex_state = 38},
  [33] = {.lex_state = 38},
  [34] = {.lex_state = 38},
  [35] = {.lex_state = 38},
  [36] = {.lex_state = 38},
  [37] = {.lex_state = 38},
  [38] = {.lex_state = 19, .external_lex_state = 1},
  [39] = {.lex_state = 21},
  [40] = {.lex_state = 21},
  [41] = {.lex_state = 21},
  [42] = {.lex_state = 21},
  [43] = {.lex_state = 21},
  [44] = {.lex_state = 41, .external_lex_state = 1},
  [45] = {.lex_state = 21},
  [46] = {.lex_state = 21},
  [47] = {.lex_state = 19, .external_lex_state = 1},
  [48] = {.lex_state = 41, .external_lex_state = 1},
  [49] = {.lex_state = 41, .external_lex_state = 1},
  [50] = {.lex_state = 41, .external_lex_state = 1},
  [51] = {.lex_state = 21},
  [52] = {.lex_state = 41, .external_lex_state = 1},
  [53] = {.lex_state = 19, .external_lex_state = 1},
  [54] = {.lex_state = 19, .external_lex_state = 1},
  [55] = {.lex_state = 21},
  [56] = {.lex_state = 41, .external_lex_state = 1},
  [57] = {.lex_state = 41, .external_lex_state = 1},
  [58] = {.lex_state = 41, .external_lex_state = 1},
  [59] = {.lex_state = 19, .external_lex_state = 1},
  [60] = {.lex_state = 41, .external_lex_state = 1},
  [61] = {.lex_state = 41, .external_lex_state = 1},
  [62] = {.lex_state = 21},
  [63] = {.lex_state = 41, .external_lex_state = 2},
  [64] = {.lex_state = 41, .external_lex_state = 2},
  [65] = {.lex_state = 41, .external_lex_state = 1},
  [66] = {.lex_state = 41, .external_lex_state = 1},
  [67] = {.lex_state = 19, .external_lex_state = 2},
  [68] = {.lex_state = 19, .external_lex_state = 1},
  [69] = {.lex_state = 19, .external_lex_state = 2},
  [70] = {.lex_state = 41, .external_lex_state = 2},
  [71] = {.lex_state = 41, .external_lex_state = 2},
  [72] = {.lex_state = 19, .external_lex_state = 2},
  [73] = {.lex_state = 41, .external_lex_state = 2},
  [74] = {.lex_state = 41, .external_lex_state = 2},
  [75] = {.lex_state = 19, .external_lex_state = 2},
  [76] = {.lex_state = 41, .external_lex_state = 2},
  [77] = {.lex_state = 41, .external_lex_state = 2},
  [78] = {.lex_state = 41, .external_lex_state = 2},
  [79] = {.lex_state = 19, .external_lex_state = 2},
  [80] = {.lex_state = 19, .external_lex_state = 2},
  [81] = {.lex_state = 41, .external_lex_state = 2},
  [82] = {.lex_state = 19, .external_lex_state = 2},
  [83] = {.lex_state = 19, .external_lex_state = 2},
  [84] = {.lex_state = 41, .external_lex_state = 2},
  [85] = {.lex_state = 41, .external_lex_state = 2},
  [86] = {.lex_state = 41, .external_lex_state = 2},
  [87] = {.lex_state = 41, .external_lex_state = 2},
  [88] = {.lex_state = 41, .external_lex_state = 2},
  [89] = {.lex_state = 41, .external_lex_state = 2},
  [90] = {.lex_state = 41, .external_lex_state = 2},
  [91] = {.lex_state = 41, .external_lex_state = 2},
  [92] = {.lex_state = 19, .external_lex_state = 2},
  [93] = {.lex_state = 19, .external_lex_state = 2},
  [94] = {.lex_state = 19, .external_lex_state = 2},
  [95] = {.lex_state = 41, .external_lex_state = 2},
  [96] = {.lex_state = 41, .external_lex_state = 2},
  [97] = {.lex_state = 20, .external_lex_state = 1},
  [98] = {.lex_state = 41, .external_lex_state = 2},
  [99] = {.lex_state = 41, .external_lex_state = 2},
  [100] = {.lex_state = 20, .external_lex_state = 1},
  [101] = {.lex_state = 20, .external_lex_state = 1},
  [102] = {.lex_state = 20, .external_lex_state = 1},
  [103] = {.lex_state = 41, .external_lex_state = 2},
  [104] = {.lex_state = 41, .external_lex_state = 2},
  [105] = {.lex_state = 19, .external_lex_state = 2},
  [106] = {.lex_state = 19, .external_lex_state = 2},
  [107] = {.lex_state = 20, .external_lex_state = 1},
  [108] = {.lex_state = 19},
  [109] = {.lex_state = 19},
  [110] = {.lex_state = 19},
  [111] = {.lex_state = 20, .external_lex_state = 2},
  [112] = {.lex_state = 19},
  [113] = {.lex_state = 20, .external_lex_state = 1},
  [114] = {.lex_state = 19},
  [115] = {.lex_state = 19},
  [116] = {.lex_state = 20, .external_lex_state = 2},
  [117] = {.lex_state = 20, .external_lex_state = 2},
  [118] = {.lex_state = 19},
  [119] = {.lex_state = 19},
  [120] = {.lex_state = 19},
  [121] = {.lex_state = 19},
  [122] = {.lex_state = 19},
  [123] = {.lex_state = 19},
  [124] = {.lex_state = 19},
  [125] = {.lex_state = 19},
  [126] = {.lex_state = 19},
  [127] = {.lex_state = 19},
  [128] = {.lex_state = 19},
  [129] = {.lex_state = 19},
  [130] = {.lex_state = 19},
  [131] = {.lex_state = 19},
  [132] = {.lex_state = 20, .external_lex_state = 2},
  [133] = {.lex_state = 20, .external_lex_state = 2},
  [134] = {.lex_state = 42, .external_lex_state = 2},
  [135] = {.lex_state = 20, .external_lex_state = 2},
  [136] = {.lex_state = 42, .external_lex_state = 2},
  [137] = {.lex_state = 20, .external_lex_state = 2},
  [138] = {.lex_state = 20, .external_lex_state = 2},
  [139] = {.lex_state = 20, .external_lex_state = 2},
  [140] = {.lex_state = 20, .external_lex_state = 2},
  [141] = {.lex_state = 20, .external_lex_state = 2},
  [142] = {.lex_state = 20, .external_lex_state = 2},
  [143] = {.lex_state = 20, .external_lex_state = 2},
  [144] = {.lex_state = 20},
  [145] = {.lex_state = 20},
  [146] = {.lex_state = 20},
  [147] = {.lex_state = 20},
  [148] = {.lex_state = 20},
  [149] = {.lex_state = 20},
  [150] = {.lex_state = 20},
  [151] = {.lex_state = 20},
  [152] = {.lex_state = 20},
  [153] = {.lex_state = 20},
  [154] = {.lex_state = 20},
  [155] = {.lex_state = 20},
  [156] = {.lex_state = 20},
  [157] = {.lex_state = 20},
  [158] = {.lex_state = 20},
  [159] = {.lex_state = 20},
  [160] = {.lex_state = 20},
  [161] = {.lex_state = 20},
  [162] = {.lex_state = 20},
  [163] = {.lex_state = 42},
  [164] = {.lex_state = 42},
  [165] = {.lex_state = 42},
  [166] = {.lex_state = 42},
  [167] = {.lex_state = 42},
  [168] = {.lex_state = 42},
  [169] = {.lex_state = 42},
  [170] = {.lex_state = 42},
  [171] = {.lex_state = 42},
  [172] = {.lex_state = 42},
  [173] = {.lex_state = 42},
  [174] = {.lex_state = 42},
  [175] = {.lex_state = 42},
  [176] = {.lex_state = 42},
  [177] = {.lex_state = 42},
  [178] = {.lex_state = 42},
  [179] = {.lex_state = 42},
  [180] = {.lex_state = 42},
  [181] = {.lex_state = 42},
  [182] = {.lex_state = 42},
  [183] = {.lex_state = 42},
  [184] = {.lex_state = 42},
  [185] = {.lex_state = 42},
  [186] = {.lex_state = 42},
  [187] = {.lex_state = 42},
  [188] = {.lex_state = 42},
  [189] = {.lex_state = 42},
  [190] = {.lex_state = 42},
  [191] = {.lex_state = 42},
  [192] = {.lex_state = 42},
  [193] = {.lex_state = 42},
  [194] = {.lex_state = 42},
  [195] = {.lex_state = 42},
  [196] = {.lex_state = 42},
  [197] = {.lex_state = 42},
  [198] = {.lex_state = 42},
  [199] = {.lex_state = 42},
  [200] = {.lex_state = 42},
  [201] = {.lex_state = 42},
  [202] = {.lex_state = 42},
  [203] = {.lex_state = 20},
  [204] = {.lex_state = 20},
  [205] = {.lex_state = 20},
  [206] = {.lex_state = 20},
  [207] = {.lex_state = 20},
  [208] = {.lex_state = 20},
  [209] = {.lex_state = 20},
  [210] = {.lex_state = 20},
  [211] = {.lex_state = 20},
  [212] = {.lex_state = 20},
  [213] = {.lex_state = 20},
  [214] = {.lex_state = 20},
  [215] = {.lex_state = 20},
  [216] = {.lex_state = 20},
  [217] = {.lex_state = 20},
  [218] = {.lex_state = 20},
  [219] = {.lex_state = 20},
  [220] = {.lex_state = 38},
  [221] = {.lex_state = 38},
  [222] = {.lex_state = 18},
  [223] = {.lex_state = 18},
  [224] = {.lex_state = 18},
  [225] = {.lex_state = 18},
  [226] = {.lex_state = 18},
  [227] = {.lex_state = 18},
  [228] = {.lex_state = 18},
  [229] = {.lex_state = 18},
  [230] = {.lex_state = 18},
  [231] = {.lex_state = 18},
  [232] = {.lex_state = 18},
  [233] = {.lex_state = 18},
  [234] = {.lex_state = 18},
  [235] = {.lex_state = 18},
  [236] = {.lex_state = 18},
  [237] = {.lex_state = 18},
  [238] = {.lex_state = 18},
  [239] = {.lex_state = 18},
  [240] = {.lex_state = 18},
  [241] = {.lex_state = 18},
  [242] = {.lex_state = 18},
  [243] = {.lex_state = 18},
  [244] = {.lex_state = 18},
  [245] = {.lex_state = 18},
  [246] = {.lex_state = 18},
  [247] = {.lex_state = 18},
  [248] = {.lex_state = 18},
  [249] = {.lex_state = 18},
  [250] = {.lex_state = 18},
  [251] = {.lex_state = 18},
  [252] = {.lex_state = 18},
  [253] = {.lex_state = 18},
  [254] = {.lex_state = 18},
  [255] = {.lex_state = 18},
  [256] = {.lex_state = 18},
  [257] = {.lex_state = 18},
  [258] = {.lex_state = 18},
  [259] = {.lex_state = 18},
  [260] = {.lex_state = 18},
  [261] = {.lex_state = 18},
  [262] = {.lex_state = 18},
  [263] = {.lex_state = 18},
  [264] = {.lex_state = 18},
  [265] = {.lex_state = 18},
  [266] = {.lex_state = 18},
  [267] = {.lex_state = 18},
  [268] = {.lex_state = 18},
  [269] = {.lex_state = 18},
  [270] = {.lex_state = 18},
  [271] = {.lex_state = 18},
  [272] = {.lex_state = 18},
  [273] = {.lex_state = 18},
  [274] = {.lex_state = 18},
  [275] = {.lex_state = 18},
  [276] = {.lex_state = 18},
  [277] = {.lex_state = 18},
  [278] = {.lex_state = 18},
  [279] = {.lex_state = 18},
  [280] = {.lex_state = 18},
  [281] = {.lex_state = 18},
  [282] = {.lex_state = 18},
  [283] = {.lex_state = 18},
  [284] = {.lex_state = 18},
  [285] = {.lex_state = 18},
  [286] = {.lex_state = 18},
  [287] = {.lex_state = 18},
  [288] = {.lex_state = 18},
  [289] = {.lex_state = 18},
  [290] = {.lex_state = 18},
  [291] = {.lex_state = 18},
  [292] = {.lex_state = 18},
  [293] = {.lex_state = 18},
  [294] = {.lex_state = 18},
  [295] = {.lex_state = 18},
  [296] = {.lex_state = 18},
  [297] = {.lex_state = 18},
  [298] = {.lex_state = 18},
  [299] = {.lex_state = 18},
  [300] = {.lex_state = 18},
  [301] = {.lex_state = 18},
  [302] = {.lex_state = 18},
  [303] = {.lex_state = 18},
  [304] = {.lex_state = 18},
  [305] = {.lex_state = 18},
  [306] = {.lex_state = 48},
  [307] = {.lex_state = 48},
  [308] = {.lex_state = 48},
  [309] = {.lex_state = 48},
  [310] = {.lex_state = 48},
  [311] = {.lex_state = 48},
  [312] = {.lex_state = 48},
  [313] = {.lex_state = 48},
  [314] = {.lex_state = 22},
  [315] = {.lex_state = 22},
  [316] = {.lex_state = 22},
  [317] = {.lex_state = 48, .external_lex_state = 1},
  [318] = {.lex_state = 22},
  [319] = {.lex_state = 48, .external_lex_state = 1},
  [320] = {.lex_state = 48, .external_lex_state = 1},
  [321] = {.lex_state = 22},
  [322] = {.lex_state = 48, .external_lex_state = 1},
  [323] = {.lex_state = 22},
  [324] = {.lex_state = 22},
  [325] = {.lex_state = 48, .external_lex_state = 1},
  [326] = {.lex_state = 48, .external_lex_state = 1},
  [327] = {.lex_state = 48, .external_lex_state = 1},
  [328] = {.lex_state = 48, .external_lex_state = 1},
  [329] = {.lex_state = 48, .external_lex_state = 1},
  [330] = {.lex_state = 48, .external_lex_state = 1},
  [331] = {.lex_state = 23},
  [332] = {.lex_state = 23},
  [333] = {.lex_state = 23},
  [334] = {.lex_state = 23},
  [335] = {.lex_state = 48, .external_lex_state = 2},
  [336] = {.lex_state = 48},
  [337] = {.lex_state = 23},
  [338] = {.lex_state = 23},
  [339] = {.lex_state = 48},
  [340] = {.lex_state = 48, .external_lex_state = 2},
  [341] = {.lex_state = 23},
  [342] = {.lex_state = 23},
  [343] = {.lex_state = 48, .external_lex_state = 2},
  [344] = {.lex_state = 23},
  [345] = {.lex_state = 23},
  [346] = {.lex_state = 48, .external_lex_state = 1},
  [347] = {.lex_state = 48},
  [348] = {.lex_state = 48},
  [349] = {.lex_state = 48, .external_lex_state = 1},
  [350] = {.lex_state = 23},
  [351] = {.lex_state = 48},
  [352] = {.lex_state = 48, .external_lex_state = 2},
  [353] = {.lex_state = 23},
  [354] = {.lex_state = 48},
  [355] = {.lex_state = 23},
  [356] = {.lex_state = 22},
  [357] = {.lex_state = 48, .external_lex_state = 2},
  [358] = {.lex_state = 22},
  [359] = {.lex_state = 22},
  [360] = {.lex_state = 22},
  [361] = {.lex_state = 22},
  [362] = {.lex_state = 22},
  [363] = {.lex_state = 22},
  [364] = {.lex_state = 48, .external_lex_state = 2},
  [365] = {.lex_state = 22},
  [366] = {.lex_state = 23},
  [367] = {.lex_state = 23},
  [368] = {.lex_state = 22},
  [369] = {.lex_state = 22},
  [370] = {.lex_state = 23},
  [371] = {.lex_state = 22},
  [372] = {.lex_state = 22},
  [373] = {.lex_state = 48, .external_lex_state = 2},
  [374] = {.lex_state = 22},
  [375] = {.lex_state = 22},
  [376] = {.lex_state = 22},
  [377] = {.lex_state = 22},
  [378] = {.lex_state = 22},
  [379] = {.lex_state = 22},
  [380] = {.lex_state = 22},
  [381] = {.lex_state = 22},
  [382] = {.lex_state = 22},
  [383] = {.lex_state = 22},
  [384] = {.lex_state = 22},
  [385] = {.lex_state = 22},
  [386] = {.lex_state = 22},
  [387] = {.lex_state = 22},
  [388] = {.lex_state = 22},
  [389] = {.lex_state = 22},
  [390] = {.lex_state = 22},
  [391] = {.lex_state = 22},
  [392] = {.lex_state = 22},
  [393] = {.lex_state = 22},
  [394] = {.lex_state = 22},
  [395] = {.lex_state = 22},
  [396] = {.lex_state = 48, .external_lex_state = 2},
  [397] = {.lex_state = 22},
  [398] = {.lex_state = 22},
  [399] = {.lex_state = 22},
  [400] = {.lex_state = 22},
  [401] = {.lex_state = 22},
  [402] = {.lex_state = 22},
  [403] = {.lex_state = 22},
  [404] = {.lex_state = 22},
  [405] = {.lex_state = 22},
  [406] = {.lex_state = 22},
  [407] = {.lex_state = 22},
  [408] = {.lex_state = 22},
  [409] = {.lex_state = 22},
  [410] = {.lex_state = 26, .external_lex_state = 1},
  [411] = {.lex_state = 26, .external_lex_state = 1},
  [412] = {.lex_state = 26, .external_lex_state = 1},
  [413] = {.lex_state = 26, .external_lex_state = 1},
  [414] = {.lex_state = 26, .external_lex_state = 1},
  [415] = {.lex_state = 22, .external_lex_state = 1},
  [416] = {.lex_state = 22, .external_lex_state = 1},
  [417] = {.lex_state = 22, .external_lex_state = 1},
  [418] = {.lex_state = 22, .external_lex_state = 1},
  [419] = {.lex_state = 22, .external_lex_state = 1},
  [420] = {.lex_state = 22},
  [421] = {.lex_state = 48, .external_lex_state = 2},
  [422] = {.lex_state = 48, .external_lex_state = 2},
  [423] = {.lex_state = 23},
  [424] = {.lex_state = 23},
  [425] = {.lex_state = 23},
  [426] = {.lex_state = 22},
  [427] = {.lex_state = 23},
  [428] = {.lex_state = 22},
  [429] = {.lex_state = 23},
  [430] = {.lex_state = 26, .external_lex_state = 2},
  [431] = {.lex_state = 23},
  [432] = {.lex_state = 23},
  [433] = {.lex_state = 23},
  [434] = {.lex_state = 23},
  [435] = {.lex_state = 22},
  [436] = {.lex_state = 23},
  [437] = {.lex_state = 23},
  [438] = {.lex_state = 23},
  [439] = {.lex_state = 23},
  [440] = {.lex_state = 23},
  [441] = {.lex_state = 48, .external_lex_state = 2},
  [442] = {.lex_state = 26, .external_lex_state = 2},
  [443] = {.lex_state = 23},
  [444] = {.lex_state = 23},
  [445] = {.lex_state = 48, .external_lex_state = 2},
  [446] = {.lex_state = 23},
  [447] = {.lex_state = 48, .external_lex_state = 2},
  [448] = {.lex_state = 23},
  [449] = {.lex_state = 23},
  [450] = {.lex_state = 23},
  [451] = {.lex_state = 23},
  [452] = {.lex_state = 23},
  [453] = {.lex_state = 48, .external_lex_state = 2},
  [454] = {.lex_state = 23},
  [455] = {.lex_state = 23},
  [456] = {.lex_state = 48, .external_lex_state = 2},
  [457] = {.lex_state = 23},
  [458] = {.lex_state = 23},
  [459] = {.lex_state = 23},
  [460] = {.lex_state = 23},
  [461] = {.lex_state = 23},
  [462] = {.lex_state = 48, .external_lex_state = 2},
  [463] = {.lex_state = 23},
  [464] = {.lex_state = 48, .external_lex_state = 2},
  [465] = {.lex_state = 48, .external_lex_state = 2},
  [466] = {.lex_state = 48, .external_lex_state = 2},
  [467] = {.lex_state = 23},
  [468] = {.lex_state = 23},
  [469] = {.lex_state = 23},
  [470] = {.lex_state = 23},
  [471] = {.lex_state = 23},
  [472] = {.lex_state = 23},
  [473] = {.lex_state = 48, .external_lex_state = 2},
  [474] = {.lex_state = 23},
  [475] = {.lex_state = 23},
  [476] = {.lex_state = 26, .external_lex_state = 1},
  [477] = {.lex_state = 23},
  [478] = {.lex_state = 23},
  [479] = {.lex_state = 23},
  [480] = {.lex_state = 23},
  [481] = {.lex_state = 48, .external_lex_state = 2},
  [482] = {.lex_state = 23},
  [483] = {.lex_state = 23, .external_lex_state = 1},
  [484] = {.lex_state = 23},
  [485] = {.lex_state = 23},
  [486] = {.lex_state = 23},
  [487] = {.lex_state = 23},
  [488] = {.lex_state = 23},
  [489] = {.lex_state = 48, .external_lex_state = 2},
  [490] = {.lex_state = 23},
  [491] = {.lex_state = 48, .external_lex_state = 2},
  [492] = {.lex_state = 48, .external_lex_state = 2},
  [493] = {.lex_state = 23},
  [494] = {.lex_state = 23},
  [495] = {.lex_state = 23},
  [496] = {.lex_state = 23},
  [497] = {.lex_state = 23},
  [498] = {.lex_state = 22, .external_lex_state = 2},
  [499] = {.lex_state = 23},
  [500] = {.lex_state = 23},
  [501] = {.lex_state = 22, .external_lex_state = 2},
  [502] = {.lex_state = 23},
  [503] = {.lex_state = 23},
  [504] = {.lex_state = 23, .external_lex_state = 1},
  [505] = {.lex_state = 23, .external_lex_state = 1},
  [506] = {.lex_state = 22, .external_lex_state = 1},
  [507] = {.lex_state = 23, .external_lex_state = 1},
  [508] = {.lex_state = 23, .external_lex_state = 1},
  [509] = {.lex_state = 22, .external_lex_state = 2},
  [510] = {.lex_state = 23, .external_lex_state = 2},
  [511] = {.lex_state = 48},
  [512] = {.lex_state = 23, .external_lex_state = 1},
  [513] = {.lex_state = 23, .external_lex_state = 2},
  [514] = {.lex_state = 22, .external_lex_state = 2},
  [515] = {.lex_state = 48},
  [516] = {.lex_state = 48},
  [517] = {.lex_state = 22, .external_lex_state = 2},
  [518] = {.lex_state = 48},
  [519] = {.lex_state = 48},
  [520] = {.lex_state = 48},
  [521] = {.lex_state = 26, .external_lex_state = 2},
  [522] = {.lex_state = 48},
  [523] = {.lex_state = 48},
  [524] = {.lex_state = 48},
  [525] = {.lex_state = 48},
  [526] = {.lex_state = 26, .external_lex_state = 2},
  [527] = {.lex_state = 48},
  [528] = {.lex_state = 48},
  [529] = {.lex_state = 26, .external_lex_state = 2},
  [530] = {.lex_state = 26, .external_lex_state = 2},
  [531] = {.lex_state = 23, .external_lex_state = 2},
  [532] = {.lex_state = 23, .external_lex_state = 2},
  [533] = {.lex_state = 26, .external_lex_state = 2},
  [534] = {.lex_state = 22, .external_lex_state = 2},
  [535] = {.lex_state = 26, .external_lex_state = 2},
  [536] = {.lex_state = 26, .external_lex_state = 2},
  [537] = {.lex_state = 26, .external_lex_state = 2},
  [538] = {.lex_state = 22},
  [539] = {.lex_state = 22},
  [540] = {.lex_state = 22, .external_lex_state = 2},
  [541] = {.lex_state = 22, .external_lex_state = 2},
  [542] = {.lex_state = 22},
  [543] = {.lex_state = 26, .external_lex_state = 2},
  [544] = {.lex_state = 22},
  [545] = {.lex_state = 22, .external_lex_state = 2},
  [546] = {.lex_state = 22, .external_lex_state = 2},
  [547] = {.lex_state = 23, .external_lex_state = 2},
  [548] = {.lex_state = 22, .external_lex_state = 2},
  [549] = {.lex_state = 22},
  [550] = {.lex_state = 22},
  [551] = {.lex_state = 26, .external_lex_state = 2},
  [552] = {.lex_state = 22, .external_lex_state = 2},
  [553] = {.lex_state = 22},
  [554] = {.lex_state = 22},
  [555] = {.lex_state = 22},
  [556] = {.lex_state = 22},
  [557] = {.lex_state = 23, .external_lex_state = 2},
  [558] = {.lex_state = 23, .external_lex_state = 2},
  [559] = {.lex_state = 43},
  [560] = {.lex_state = 24, .external_lex_state = 3},
  [561] = {.lex_state = 24, .external_lex_state = 3},
  [562] = {.lex_state = 25},
  [563] = {.lex_state = 22},
  [564] = {.lex_state = 24, .external_lex_state = 3},
  [565] = {.lex_state = 22},
  [566] = {.lex_state = 24, .external_lex_state = 3},
  [567] = {.lex_state = 25},
  [568] = {.lex_state = 43},
  [569] = {.lex_state = 22},
  [570] = {.lex_state = 43},
  [571] = {.lex_state = 25},
  [572] = {.lex_state = 25},
  [573] = {.lex_state = 25},
  [574] = {.lex_state = 25},
  [575] = {.lex_state = 22},
  [576] = {.lex_state = 25},
  [577] = {.lex_state = 25},
  [578] = {.lex_state = 25},
  [579] = {.lex_state = 43},
  [580] = {.lex_state = 22},
  [581] = {.lex_state = 25},
  [582] = {.lex_state = 43},
  [583] = {.lex_state = 25},
  [584] = {.lex_state = 26},
  [585] = {.lex_state = 26},
  [586] = {.lex_state = 22},
  [587] = {.lex_state = 22},
  [588] = {.lex_state = 43},
  [589] = {.lex_state = 25},
  [590] = {.lex_state = 22},
  [591] = {.lex_state = 23, .external_lex_state = 2},
  [592] = {.lex_state = 22},
  [593] = {.lex_state = 25},
  [594] = {.lex_state = 22},
  [595] = {.lex_state = 22},
  [596] = {.lex_state = 25},
  [597] = {.lex_state = 25},
  [598] = {.lex_state = 22},
  [599] = {.lex_state = 25},
  [600] = {.lex_state = 26},
  [601] = {.lex_state = 25},
  [602] = {.lex_state = 25},
  [603] = {.lex_state = 26},
  [604] = {.lex_state = 22},
  [605] = {.lex_state = 23, .external_lex_state = 2},
  [606] = {.lex_state = 22},
  [607] = {.lex_state = 23, .external_lex_state = 2},
  [608] = {.lex_state = 24, .external_lex_state = 3},
  [609] = {.lex_state = 26},
  [610] = {.lex_state = 23, .external_lex_state = 2},
  [611] = {.lex_state = 23, .external_lex_state = 2},
  [612] = {.lex_state = 22},
  [613] = {.lex_state = 25},
  [614] = {.lex_state = 25},
  [615] = {.lex_state = 43},
  [616] = {.lex_state = 25},
  [617] = {.lex_state = 43},
  [618] = {.lex_state = 26},
  [619] = {.lex_state = 22},
  [620] = {.lex_state = 22},
  [621] = {.lex_state = 24, .external_lex_state = 3},
  [622] = {.lex_state = 43},
  [623] = {.lex_state = 43},
  [624] = {.lex_state = 43},
  [625] = {.lex_state = 43},
  [626] = {.lex_state = 24},
  [627] = {.lex_state = 22},
  [628] = {.lex_state = 43},
  [629] = {.lex_state = 23},
  [630] = {.lex_state = 24},
  [631] = {.lex_state = 22},
  [632] = {.lex_state = 43},
  [633] = {.lex_state = 43},
  [634] = {.lex_state = 43},
  [635] = {.lex_state = 43},
  [636] = {.lex_state = 22},
  [637] = {.lex_state = 23},
  [638] = {.lex_state = 43},
  [639] = {.lex_state = 22},
  [640] = {.lex_state = 43},
  [641] = {.lex_state = 43},
  [642] = {.lex_state = 43},
  [643] = {.lex_state = 26},
  [644] = {.lex_state = 26},
  [645] = {.lex_state = 26},
  [646] = {.lex_state = 23},
  [647] = {.lex_state = 43},
  [648] = {.lex_state = 26},
  [649] = {.lex_state = 23},
  [650] = {.lex_state = 43},
  [651] = {.lex_state = 23},
  [652] = {.lex_state = 43},
  [653] = {.lex_state = 26},
  [654] = {.lex_state = 41},
  [655] = {.lex_state = 43},
  [656] = {.lex_state = 26},
  [657] = {.lex_state = 41},
  [658] = {.lex_state = 41},
  [659] = {.lex_state = 25},
  [660] = {.lex_state = 41},
  [661] = {.lex_state = 25},
  [662] = {.lex_state = 41},
  [663] = {.lex_state = 43},
  [664] = {.lex_state = 41},
  [665] = {.lex_state = 26},
  [666] = {.lex_state = 25},
  [667] = {.lex_state = 43},
  [668] = {.lex_state = 25},
  [669] = {.lex_state = 41},
  [670] = {.lex_state = 43},
  [671] = {.lex_state = 43},
  [672] = {.lex_state = 41},
  [673] = {.lex_state = 41},
  [674] = {.lex_state = 41},
  [675] = {.lex_state = 41},
  [676] = {.lex_state = 41},
  [677] = {.lex_state = 43},
  [678] = {.lex_state = 41},
  [679] = {.lex_state = 41},
  [680] = {.lex_state = 41},
  [681] = {.lex_state = 41},
  [682] = {.lex_state = 41},
  [683] = {.lex_state = 41},
  [684] = {.lex_state = 41},
  [685] = {.lex_state = 41},
  [686] = {.lex_state = 41},
  [687] = {.lex_state = 43},
  [688] = {.lex_state = 41},
  [689] = {.lex_state = 41},
  [690] = {.lex_state = 26},
  [691] = {.lex_state = 26},
  [692] = {.lex_state = 41},
  [693] = {.lex_state = 41},
  [694] = {.lex_state = 43},
  [695] = {.lex_state = 41},
  [696] = {.lex_state = 41},
  [697] = {.lex_state = 43},
  [698] = {.lex_state = 43},
  [699] = {.lex_state = 41},
  [700] = {.lex_state = 26},
  [701] = {.lex_state = 41},
  [702] = {.lex_state = 41},
  [703] = {.lex_state = 31, .external_lex_state = 3},
  [704] = {.lex_state = 31, .external_lex_state = 3},
  [705] = {.lex_state = 31, .external_lex_state = 3},
  [706] = {.lex_state = 31, .external_lex_state = 3},
  [707] = {.lex_state = 31, .external_lex_state = 3},
  [708] = {.lex_state = 31, .external_lex_state = 3},
  [709] = {.lex_state = 31, .external_lex_state = 3},
  [710] = {.lex_state = 31, .external_lex_state = 3},
  [711] = {.lex_state = 31, .external_lex_state = 3},
  [712] = {.lex_state = 26},
  [713] = {.lex_state = 26},
  [714] = {.lex_state = 31, .external_lex_state = 3},
  [715] = {.lex_state = 26},
  [716] = {.lex_state = 41},
  [717] = {.lex_state = 41},
  [718] = {.lex_state = 41},
  [719] = {.lex_state = 26},
  [720] = {.lex_state = 41},
  [721] = {.lex_state = 26},
  [722] = {.lex_state = 41},
  [723] = {.lex_state = 41},
  [724] = {.lex_state = 41},
  [725] = {.lex_state = 26},
  [726] = {.lex_state = 41},
  [727] = {.lex_state = 41},
  [728] = {.lex_state = 41},
  [729] = {.lex_state = 41},
  [730] = {.lex_state = 41},
  [731] = {.lex_state = 41},
  [732] = {.lex_state = 41},
  [733] = {.lex_state = 26},
  [734] = {.lex_state = 41},
  [735] = {.lex_state = 41},
  [736] = {.lex_state = 41},
  [737] = {.lex_state = 41},
  [738] = {.lex_state = 41},
  [739] = {.lex_state = 41},
  [740] = {.lex_state = 41},
  [741] = {.lex_state = 41},
  [742] = {.lex_state = 41},
  [743] = {.lex_state = 41},
  [744] = {.lex_state = 41},
  [745] = {.lex_state = 41},
  [746] = {.lex_state = 41},
  [747] = {.lex_state = 41},
  [748] = {.lex_state = 41},
  [749] = {.lex_state = 41},
  [750] = {.lex_state = 41},
  [751] = {.lex_state = 41},
  [752] = {.lex_state = 41},
  [753] = {.lex_state = 41},
  [754] = {.lex_state = 41},
  [755] = {.lex_state = 41},
  [756] = {.lex_state = 26},
  [757] = {.lex_state = 26},
  [758] = {.lex_state = 26},
  [759] = {.lex_state = 41},
  [760] = {.lex_state = 41},
  [761] = {.lex_state = 26},
  [762] = {.lex_state = 41},
  [763] = {.lex_state = 26},
  [764] = {.lex_state = 26},
  [765] = {.lex_state = 41},
  [766] = {.lex_state = 26},
  [767] = {.lex_state = 26},
  [768] = {.lex_state = 41},
  [769] = {.lex_state = 41},
  [770] = {.lex_state = 41},
  [771] = {.lex_state = 41},
  [772] = {.lex_state = 26},
  [773] = {.lex_state = 41},
  [774] = {.lex_state = 26},
  [775] = {.lex_state = 26},
  [776] = {.lex_state = 26},
  [777] = {.lex_state = 41},
  [778] = {.lex_state = 41},
  [779] = {.lex_state = 26},
  [780] = {.lex_state = 26},
  [781] = {.lex_state = 41},
  [782] = {.lex_state = 26},
  [783] = {.lex_state = 41},
  [784] = {.lex_state = 41},
  [785] = {.lex_state = 41},
  [786] = {.lex_state = 41},
  [787] = {.lex_state = 26},
  [788] = {.lex_state = 41},
  [789] = {.lex_state = 41},
  [790] = {.lex_state = 41},
  [791] = {.lex_state = 26},
  [792] = {.lex_state = 41},
  [793] = {.lex_state = 41},
  [794] = {.lex_state = 41},
  [795] = {.lex_state = 26},
  [796] = {.lex_state = 41},
  [797] = {.lex_state = 41},
  [798] = {.lex_state = 41},
  [799] = {.lex_state = 41},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 31},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 31},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 31},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 31},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 31},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 31},
  [821] = {.lex_state = 31},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 31},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 31},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 31},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 29},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 31},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 31},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 26},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 29},
  [849] = {.lex_state = 31},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 31},
  [852] = {.lex_state = 29},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 31},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 26},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 29},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 31},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 31},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 29},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 31},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 29},
  [877] = {.lex_state = 26},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 29},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 29},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 31},
  [886] = {.lex_state = 29},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 29},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 26},
  [895] = {.lex_state = 26},
  [896] = {.lex_state = 31},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 26},
  [900] = {.lex_state = 26},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_simple_word] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_expr] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [sym_unpack] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_proc] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_eq] = ACTIONS(1),
    [anon_sym_ne] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_ni] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_concat] = ACTIONS(1),
    [sym__ns_delim] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(869),
    [sym_while] = STATE(662),
    [sym_expr_cmd] = STATE(662),
    [sym_foreach] = STATE(662),
    [sym_global] = STATE(662),
    [sym_namespace] = STATE(662),
    [sym_try] = STATE(662),
    [sym__command] = STATE(662),
    [sym_command] = STATE(662),
    [sym__concat_word] = STATE(307),
    [sym_variable_substitution] = STATE(364),
    [sym_braced_word] = STATE(307),
    [sym_set] = STATE(662),
    [sym_procedure] = STATE(662),
    [sym_conditional] = STATE(662),
    [sym_catch] = STATE(662),
    [sym_quoted_word] = STATE(364),
    [sym_command_substitution] = STATE(364),
    [aux_sym__commands_repeat1] = STATE(29),
    [sym_simple_word] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(5),
    [sym_comment] = ACTIONS(7),
    [anon_sym_while] = ACTIONS(9),
    [anon_sym_expr] = ACTIONS(11),
    [anon_sym_foreach] = ACTIONS(13),
    [anon_sym_global] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_try] = ACTIONS(19),
    [sym_unpack] = ACTIONS(21),
    [anon_sym_DOLLAR] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_set] = ACTIONS(27),
    [anon_sym_proc] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_catch] = ACTIONS(33),
    [anon_sym_DQUOTE] = ACTIONS(35),
    [sym_escaped_character] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(37),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_RBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [86] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [172] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [258] = 23,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      sym_comment,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(81), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(685), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [344] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [430] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(89), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [516] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [602] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [688] = 23,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    STATE(30), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(95), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(669), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [774] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [860] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(103), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [946] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(105), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1032] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1118] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1204] = 23,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(113), 1,
      sym_comment,
    ACTIONS(115), 1,
      anon_sym_RBRACE,
    STATE(31), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(111), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(657), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1290] = 23,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(119), 1,
      sym_comment,
    ACTIONS(121), 1,
      anon_sym_RBRACE,
    STATE(33), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(117), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(695), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1376] = 23,
    ACTIONS(9), 1,
      anon_sym_while,
    ACTIONS(11), 1,
      anon_sym_expr,
    ACTIONS(13), 1,
      anon_sym_foreach,
    ACTIONS(15), 1,
      anon_sym_global,
    ACTIONS(17), 1,
      anon_sym_namespace,
    ACTIONS(19), 1,
      anon_sym_try,
    ACTIONS(21), 1,
      sym_unpack,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_proc,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_catch,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(123), 1,
      ts_builtin_sym_end,
    ACTIONS(127), 1,
      sym_comment,
    STATE(220), 1,
      aux_sym__commands_repeat1,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(125), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(307), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(777), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1462] = 23,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      sym_comment,
    ACTIONS(133), 1,
      anon_sym_RBRACE,
    STATE(35), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(129), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(689), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1548] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1634] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(137), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1720] = 23,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(141), 1,
      sym_comment,
    ACTIONS(143), 1,
      anon_sym_RBRACE,
    STATE(37), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(139), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(688), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1806] = 23,
    ACTIONS(9), 1,
      anon_sym_while,
    ACTIONS(11), 1,
      anon_sym_expr,
    ACTIONS(13), 1,
      anon_sym_foreach,
    ACTIONS(15), 1,
      anon_sym_global,
    ACTIONS(17), 1,
      anon_sym_namespace,
    ACTIONS(19), 1,
      anon_sym_try,
    ACTIONS(21), 1,
      sym_unpack,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_proc,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_catch,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(127), 1,
      sym_comment,
    ACTIONS(145), 1,
      ts_builtin_sym_end,
    STATE(220), 1,
      aux_sym__commands_repeat1,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(125), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(307), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(777), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1892] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [1978] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2064] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2150] = 23,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(153), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2236] = 23,
    ACTIONS(9), 1,
      anon_sym_while,
    ACTIONS(11), 1,
      anon_sym_expr,
    ACTIONS(13), 1,
      anon_sym_foreach,
    ACTIONS(15), 1,
      anon_sym_global,
    ACTIONS(17), 1,
      anon_sym_namespace,
    ACTIONS(19), 1,
      anon_sym_try,
    ACTIONS(21), 1,
      sym_unpack,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_proc,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_catch,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(127), 1,
      sym_comment,
    ACTIONS(155), 1,
      ts_builtin_sym_end,
    STATE(220), 1,
      aux_sym__commands_repeat1,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(125), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(307), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(777), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2322] = 22,
    ACTIONS(9), 1,
      anon_sym_while,
    ACTIONS(11), 1,
      anon_sym_expr,
    ACTIONS(13), 1,
      anon_sym_foreach,
    ACTIONS(15), 1,
      anon_sym_global,
    ACTIONS(17), 1,
      anon_sym_namespace,
    ACTIONS(19), 1,
      anon_sym_try,
    ACTIONS(21), 1,
      sym_unpack,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_proc,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_catch,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(307), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(696), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2405] = 22,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(159), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(675), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2488] = 22,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(161), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(672), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2571] = 22,
    ACTIONS(43), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(743), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2654] = 22,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(163), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(660), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2737] = 22,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(701), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2820] = 22,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(167), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(679), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2903] = 22,
    ACTIONS(9), 1,
      anon_sym_while,
    ACTIONS(11), 1,
      anon_sym_expr,
    ACTIONS(13), 1,
      anon_sym_foreach,
    ACTIONS(15), 1,
      anon_sym_global,
    ACTIONS(17), 1,
      anon_sym_namespace,
    ACTIONS(19), 1,
      anon_sym_try,
    ACTIONS(21), 1,
      sym_unpack,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      anon_sym_set,
    ACTIONS(29), 1,
      anon_sym_proc,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      anon_sym_catch,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(127), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(307), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(777), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [2986] = 22,
    ACTIONS(45), 1,
      anon_sym_while,
    ACTIONS(47), 1,
      anon_sym_expr,
    ACTIONS(49), 1,
      anon_sym_foreach,
    ACTIONS(51), 1,
      anon_sym_global,
    ACTIONS(53), 1,
      anon_sym_namespace,
    ACTIONS(55), 1,
      anon_sym_try,
    ACTIONS(57), 1,
      sym_unpack,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_set,
    ACTIONS(67), 1,
      anon_sym_proc,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_catch,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      sym_comment,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(41), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(309), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(683), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3069] = 4,
    ACTIONS(175), 1,
      sym__ns_delim,
    STATE(59), 1,
      aux_sym_id_repeat1,
    ACTIONS(173), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(171), 31,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [3113] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(179), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(890), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3191] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(213), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(827), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3269] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(215), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(810), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3347] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(217), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(806), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3425] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(219), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(811), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3503] = 4,
    ACTIONS(225), 1,
      sym__ns_delim,
    STATE(57), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(223), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [3547] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(227), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(838), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3625] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(229), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(873), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3703] = 4,
    ACTIONS(175), 1,
      sym__ns_delim,
    STATE(53), 1,
      aux_sym_id_repeat1,
    ACTIONS(233), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(231), 31,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [3747] = 4,
    ACTIONS(225), 1,
      sym__ns_delim,
    STATE(61), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(223), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [3791] = 4,
    ACTIONS(235), 1,
      sym__ns_delim,
    STATE(56), 1,
      aux_sym_id_repeat1,
    ACTIONS(173), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(171), 31,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [3835] = 4,
    ACTIONS(225), 1,
      sym__ns_delim,
    STATE(44), 1,
      aux_sym_id_repeat1,
    ACTIONS(173), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(171), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [3879] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(237), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(815), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [3957] = 4,
    ACTIONS(235), 1,
      sym__ns_delim,
    STATE(58), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(223), 31,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4001] = 4,
    ACTIONS(243), 1,
      sym__ns_delim,
    STATE(53), 1,
      aux_sym_id_repeat1,
    ACTIONS(241), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(239), 31,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4045] = 4,
    ACTIONS(175), 1,
      sym__ns_delim,
    STATE(47), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(223), 31,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4089] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(246), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(854), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [4167] = 4,
    ACTIONS(235), 1,
      sym__ns_delim,
    STATE(60), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(223), 31,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4211] = 4,
    ACTIONS(248), 1,
      sym__ns_delim,
    STATE(57), 1,
      aux_sym_id_repeat1,
    ACTIONS(241), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(239), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4255] = 4,
    ACTIONS(235), 1,
      sym__ns_delim,
    STATE(60), 1,
      aux_sym_id_repeat1,
    ACTIONS(233), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(231), 31,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4299] = 4,
    ACTIONS(175), 1,
      sym__ns_delim,
    STATE(53), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(223), 31,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4343] = 4,
    ACTIONS(251), 1,
      sym__ns_delim,
    STATE(60), 1,
      aux_sym_id_repeat1,
    ACTIONS(241), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(239), 31,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4387] = 4,
    ACTIONS(225), 1,
      sym__ns_delim,
    STATE(57), 1,
      aux_sym_id_repeat1,
    ACTIONS(233), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(231), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4431] = 21,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_expr,
    ACTIONS(185), 1,
      anon_sym_foreach,
    ACTIONS(187), 1,
      anon_sym_global,
    ACTIONS(189), 1,
      anon_sym_namespace,
    ACTIONS(191), 1,
      anon_sym_try,
    ACTIONS(193), 1,
      sym_unpack,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_set,
    ACTIONS(201), 1,
      anon_sym_proc,
    ACTIONS(203), 1,
      anon_sym_if,
    ACTIONS(205), 1,
      anon_sym_catch,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(254), 1,
      sym_comment,
    STATE(314), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    STATE(823), 12,
      sym_while,
      sym_expr_cmd,
      sym_foreach,
      sym_global,
      sym_namespace,
      sym_try,
      sym__command,
      sym_command,
      sym_set,
      sym_procedure,
      sym_conditional,
      sym_catch,
  [4509] = 4,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    STATE(98), 1,
      sym_array_index,
    ACTIONS(256), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(258), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4552] = 4,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym_array_index,
    ACTIONS(256), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(258), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4595] = 2,
    ACTIONS(241), 4,
      sym_concat,
      sym__ns_delim,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(239), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4634] = 2,
    ACTIONS(241), 3,
      sym_concat,
      sym__ns_delim,
      anon_sym_LF,
    ACTIONS(239), 31,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4673] = 5,
    ACTIONS(266), 1,
      anon_sym_LPAREN,
    ACTIONS(268), 1,
      sym_escaped_character,
    ACTIONS(270), 1,
      sym_concat,
    STATE(80), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4718] = 2,
    ACTIONS(241), 3,
      sym_concat,
      sym__ns_delim,
      sym_escaped_character,
    ACTIONS(239), 31,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4757] = 4,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    STATE(105), 1,
      sym_array_index,
    ACTIONS(256), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(258), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4800] = 4,
    ACTIONS(262), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      sym_array_index,
    ACTIONS(274), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(276), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4843] = 4,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    STATE(87), 1,
      sym_array_index,
    ACTIONS(274), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(276), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4886] = 4,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    STATE(93), 1,
      sym_array_index,
    ACTIONS(274), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(276), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [4929] = 4,
    ACTIONS(282), 1,
      sym_concat,
    STATE(73), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(278), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(280), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [4971] = 4,
    ACTIONS(285), 1,
      sym_concat,
    STATE(81), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(268), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(264), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5013] = 4,
    ACTIONS(278), 1,
      sym_escaped_character,
    ACTIONS(287), 1,
      sym_concat,
    STATE(75), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5055] = 4,
    ACTIONS(278), 1,
      anon_sym_LF,
    ACTIONS(290), 1,
      sym_concat,
    STATE(76), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5097] = 4,
    ACTIONS(293), 1,
      anon_sym_LF,
    ACTIONS(297), 1,
      sym_concat,
    STATE(76), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5139] = 4,
    ACTIONS(268), 1,
      anon_sym_LF,
    ACTIONS(297), 1,
      sym_concat,
    STATE(77), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5181] = 4,
    ACTIONS(268), 1,
      sym_escaped_character,
    ACTIONS(270), 1,
      sym_concat,
    STATE(80), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5223] = 4,
    ACTIONS(270), 1,
      sym_concat,
    ACTIONS(293), 1,
      sym_escaped_character,
    STATE(75), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5265] = 4,
    ACTIONS(285), 1,
      sym_concat,
    STATE(73), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(293), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(295), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5307] = 2,
    ACTIONS(278), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(280), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5344] = 2,
    ACTIONS(301), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(299), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5381] = 2,
    ACTIONS(303), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(305), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5418] = 2,
    ACTIONS(307), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(309), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5455] = 2,
    ACTIONS(311), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(313), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5492] = 2,
    ACTIONS(315), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(317), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5529] = 2,
    ACTIONS(301), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(299), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5566] = 2,
    ACTIONS(319), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(321), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5603] = 2,
    ACTIONS(278), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(280), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5640] = 2,
    ACTIONS(319), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(321), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5677] = 2,
    ACTIONS(311), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(313), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5714] = 2,
    ACTIONS(315), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(317), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5751] = 2,
    ACTIONS(307), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(309), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [5788] = 2,
    ACTIONS(315), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(317), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5825] = 2,
    ACTIONS(301), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(299), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5862] = 4,
    ACTIONS(323), 1,
      sym__ns_delim,
    STATE(101), 1,
      aux_sym_id_repeat1,
    ACTIONS(171), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(173), 25,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [5903] = 2,
    ACTIONS(303), 3,
      sym_concat,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(305), 29,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5940] = 2,
    ACTIONS(307), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(309), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [5977] = 4,
    ACTIONS(323), 1,
      sym__ns_delim,
    STATE(107), 1,
      aux_sym_id_repeat1,
    ACTIONS(223), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(221), 25,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6018] = 4,
    ACTIONS(323), 1,
      sym__ns_delim,
    STATE(102), 1,
      aux_sym_id_repeat1,
    ACTIONS(223), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(221), 25,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6059] = 4,
    ACTIONS(325), 1,
      sym__ns_delim,
    STATE(102), 1,
      aux_sym_id_repeat1,
    ACTIONS(239), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(241), 25,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6100] = 2,
    ACTIONS(311), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(313), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [6137] = 2,
    ACTIONS(278), 2,
      sym_concat,
      anon_sym_LF,
    ACTIONS(280), 30,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_elseif,
      anon_sym_else,
  [6174] = 2,
    ACTIONS(303), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(305), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6211] = 2,
    ACTIONS(319), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(321), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6248] = 4,
    ACTIONS(323), 1,
      sym__ns_delim,
    STATE(102), 1,
      aux_sym_id_repeat1,
    ACTIONS(231), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(233), 25,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6289] = 16,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(346), 1,
      anon_sym_AMP,
    ACTIONS(348), 1,
      anon_sym_CARET,
    ACTIONS(350), 1,
      anon_sym_PIPE,
    ACTIONS(352), 1,
      anon_sym_AMP_AMP,
    ACTIONS(354), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(356), 1,
      anon_sym_QMARK,
    ACTIONS(358), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(328), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6353] = 8,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 16,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6401] = 2,
    ACTIONS(366), 1,
      sym_escaped_character,
    ACTIONS(364), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6437] = 5,
    ACTIONS(368), 1,
      anon_sym_LPAREN,
    ACTIONS(370), 1,
      sym_concat,
    STATE(132), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(268), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6479] = 2,
    ACTIONS(374), 1,
      sym_escaped_character,
    ACTIONS(372), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6515] = 2,
    ACTIONS(239), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(241), 26,
      sym_concat,
      sym__ns_delim,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6551] = 15,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(346), 1,
      anon_sym_AMP,
    ACTIONS(348), 1,
      anon_sym_CARET,
    ACTIONS(350), 1,
      anon_sym_PIPE,
    ACTIONS(352), 1,
      anon_sym_AMP_AMP,
    ACTIONS(354), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(378), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(376), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6613] = 14,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(346), 1,
      anon_sym_AMP,
    ACTIONS(348), 1,
      anon_sym_CARET,
    ACTIONS(350), 1,
      anon_sym_PIPE,
    ACTIONS(352), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 8,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6673] = 4,
    ACTIONS(380), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_array_index,
    ACTIONS(276), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(274), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6713] = 4,
    ACTIONS(380), 1,
      anon_sym_LPAREN,
    STATE(140), 1,
      sym_array_index,
    ACTIONS(258), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(256), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6753] = 13,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(346), 1,
      anon_sym_AMP,
    ACTIONS(348), 1,
      anon_sym_CARET,
    ACTIONS(350), 1,
      anon_sym_PIPE,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 9,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6811] = 2,
    ACTIONS(384), 1,
      sym_escaped_character,
    ACTIONS(382), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6847] = 12,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(346), 1,
      anon_sym_AMP,
    ACTIONS(348), 1,
      anon_sym_CARET,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 10,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6903] = 11,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(346), 1,
      anon_sym_AMP,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 11,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [6957] = 10,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(340), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(342), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(344), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 12,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7009] = 2,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(360), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7045] = 2,
    ACTIONS(388), 1,
      sym_escaped_character,
    ACTIONS(386), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7081] = 2,
    ACTIONS(392), 1,
      sym_escaped_character,
    ACTIONS(390), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7117] = 7,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(338), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 18,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7163] = 4,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 26,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7203] = 2,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(360), 30,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7239] = 3,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(360), 29,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7277] = 5,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 24,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7319] = 6,
    ACTIONS(332), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 1,
      sym_escaped_character,
    ACTIONS(330), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(336), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(334), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 22,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [7363] = 4,
    ACTIONS(370), 1,
      sym_concat,
    STATE(133), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(293), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7402] = 4,
    ACTIONS(394), 1,
      sym_concat,
    STATE(133), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(278), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7441] = 5,
    ACTIONS(268), 1,
      anon_sym_LF,
    ACTIONS(297), 1,
      sym_concat,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    STATE(77), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [7482] = 4,
    ACTIONS(370), 1,
      sym_concat,
    STATE(132), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(268), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7521] = 5,
    ACTIONS(285), 1,
      sym_concat,
    ACTIONS(399), 1,
      anon_sym_LPAREN,
    STATE(81), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(268), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(264), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [7562] = 2,
    ACTIONS(313), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(311), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7596] = 2,
    ACTIONS(280), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(278), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7630] = 2,
    ACTIONS(299), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(301), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7664] = 2,
    ACTIONS(305), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(303), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7698] = 2,
    ACTIONS(317), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(315), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7732] = 2,
    ACTIONS(309), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(307), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7766] = 2,
    ACTIONS(321), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(319), 24,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7800] = 2,
    ACTIONS(390), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(392), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7833] = 16,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(378), 5,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7894] = 2,
    ACTIONS(382), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(384), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7927] = 2,
    ACTIONS(372), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(374), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7960] = 2,
    ACTIONS(386), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(388), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [7993] = 5,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(360), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(362), 20,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8032] = 2,
    ACTIONS(360), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(362), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8065] = 3,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(360), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(362), 22,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8100] = 6,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(360), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(362), 18,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8141] = 2,
    ACTIONS(364), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(366), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8174] = 7,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(360), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(362), 16,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8217] = 9,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(360), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(362), 14,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8264] = 10,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(360), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(362), 12,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8313] = 2,
    ACTIONS(360), 5,
      anon_sym_STAR,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(362), 23,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8346] = 12,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(360), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(362), 8,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8399] = 13,
    ACTIONS(360), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(362), 8,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8454] = 14,
    ACTIONS(360), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(362), 7,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8511] = 14,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(362), 7,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8568] = 15,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(362), 6,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [8627] = 2,
    ACTIONS(384), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(382), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [8659] = 11,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(447), 1,
      anon_sym_AMP,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 6,
      anon_sym_SEMI,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [8709] = 12,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(447), 1,
      anon_sym_AMP,
    ACTIONS(449), 1,
      anon_sym_CARET,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 5,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [8761] = 13,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(447), 1,
      anon_sym_AMP,
    ACTIONS(449), 1,
      anon_sym_CARET,
    ACTIONS(451), 1,
      anon_sym_PIPE,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 4,
      anon_sym_SEMI,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8815] = 14,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(447), 1,
      anon_sym_AMP,
    ACTIONS(449), 1,
      anon_sym_CARET,
    ACTIONS(451), 1,
      anon_sym_PIPE,
    ACTIONS(453), 1,
      anon_sym_AMP_AMP,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(360), 3,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8871] = 16,
    ACTIONS(328), 1,
      anon_sym_SEMI,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(447), 1,
      anon_sym_AMP,
    ACTIONS(449), 1,
      anon_sym_CARET,
    ACTIONS(451), 1,
      anon_sym_PIPE,
    ACTIONS(453), 1,
      anon_sym_AMP_AMP,
    ACTIONS(455), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(457), 1,
      anon_sym_QMARK,
    ACTIONS(358), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8931] = 2,
    ACTIONS(374), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(372), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [8963] = 13,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(475), 1,
      anon_sym_AMP,
    ACTIONS(477), 1,
      anon_sym_CARET,
    ACTIONS(479), 1,
      anon_sym_PIPE,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9017] = 2,
    ACTIONS(392), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(390), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9049] = 2,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(360), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9081] = 6,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 18,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9121] = 4,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 21,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9157] = 7,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 14,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9199] = 8,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9243] = 3,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(360), 25,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9277] = 2,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(360), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9309] = 2,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(360), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9341] = 4,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 22,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9377] = 2,
    ACTIONS(388), 1,
      anon_sym_LF,
    ACTIONS(386), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9409] = 5,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 20,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9447] = 12,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(475), 1,
      anon_sym_AMP,
    ACTIONS(477), 1,
      anon_sym_CARET,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9499] = 10,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 7,
      anon_sym_SEMI,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9547] = 15,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(447), 1,
      anon_sym_AMP,
    ACTIONS(449), 1,
      anon_sym_CARET,
    ACTIONS(451), 1,
      anon_sym_PIPE,
    ACTIONS(453), 1,
      anon_sym_AMP_AMP,
    ACTIONS(455), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(376), 2,
      anon_sym_SEMI,
      anon_sym_QMARK,
    ACTIONS(378), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(443), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(445), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [9605] = 2,
    ACTIONS(366), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(364), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9637] = 11,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(475), 1,
      anon_sym_AMP,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9687] = 10,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 8,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9735] = 2,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(360), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9767] = 8,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(441), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 11,
      anon_sym_SEMI,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9811] = 3,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(360), 24,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9845] = 2,
    ACTIONS(366), 1,
      anon_sym_LF,
    ACTIONS(364), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9877] = 2,
    ACTIONS(388), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(386), 25,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9909] = 5,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 19,
      anon_sym_SEMI,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9947] = 2,
    ACTIONS(374), 1,
      anon_sym_LF,
    ACTIONS(372), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [9979] = 2,
    ACTIONS(384), 1,
      anon_sym_LF,
    ACTIONS(382), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [10011] = 6,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 17,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [10051] = 16,
    ACTIONS(358), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(475), 1,
      anon_sym_AMP,
    ACTIONS(477), 1,
      anon_sym_CARET,
    ACTIONS(479), 1,
      anon_sym_PIPE,
    ACTIONS(481), 1,
      anon_sym_AMP_AMP,
    ACTIONS(483), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(485), 1,
      anon_sym_QMARK,
    ACTIONS(328), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [10111] = 7,
    ACTIONS(433), 1,
      anon_sym_STAR_STAR,
    ACTIONS(362), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(431), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(435), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(439), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(360), 13,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [10153] = 15,
    ACTIONS(378), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(475), 1,
      anon_sym_AMP,
    ACTIONS(477), 1,
      anon_sym_CARET,
    ACTIONS(479), 1,
      anon_sym_PIPE,
    ACTIONS(481), 1,
      anon_sym_AMP_AMP,
    ACTIONS(483), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(376), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_QMARK,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [10211] = 14,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(461), 1,
      anon_sym_STAR_STAR,
    ACTIONS(475), 1,
      anon_sym_AMP,
    ACTIONS(477), 1,
      anon_sym_CARET,
    ACTIONS(479), 1,
      anon_sym_PIPE,
    ACTIONS(481), 1,
      anon_sym_AMP_AMP,
    ACTIONS(459), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(465), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(469), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(473), 2,
      anon_sym_in,
      anon_sym_ni,
    ACTIONS(463), 3,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(360), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(467), 4,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [10267] = 2,
    ACTIONS(392), 1,
      anon_sym_LF,
    ACTIONS(390), 26,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_eq,
      anon_sym_ne,
      anon_sym_in,
      anon_sym_ni,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [10299] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(487), 1,
      anon_sym_RPAREN,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10359] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(491), 1,
      anon_sym_RBRACE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10419] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(493), 1,
      anon_sym_RBRACE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10479] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(495), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10539] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(497), 1,
      anon_sym_COLON,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10599] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(499), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10659] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(501), 1,
      anon_sym_RBRACE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10719] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(503), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10779] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(505), 1,
      anon_sym_COLON,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10839] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(507), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10899] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(509), 1,
      anon_sym_RBRACE,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [10959] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [11019] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(513), 1,
      anon_sym_COLON,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [11079] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(515), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [11139] = 17,
    ACTIONS(358), 1,
      anon_sym_RBRACK,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [11199] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(517), 1,
      anon_sym_COLON,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [11259] = 17,
    ACTIONS(403), 1,
      anon_sym_STAR_STAR,
    ACTIONS(407), 1,
      anon_sym_STAR,
    ACTIONS(421), 1,
      anon_sym_AMP,
    ACTIONS(423), 1,
      anon_sym_CARET,
    ACTIONS(425), 1,
      anon_sym_PIPE,
    ACTIONS(427), 1,
      anon_sym_AMP_AMP,
    ACTIONS(429), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(489), 1,
      anon_sym_QMARK,
    ACTIONS(519), 1,
      anon_sym_RPAREN,
    ACTIONS(401), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(405), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(409), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(411), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(413), 2,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(415), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(417), 2,
      anon_sym_eq,
      anon_sym_ne,
    ACTIONS(419), 2,
      anon_sym_in,
      anon_sym_ni,
  [11319] = 4,
    ACTIONS(521), 1,
      ts_builtin_sym_end,
    STATE(220), 1,
      aux_sym__commands_repeat1,
    ACTIONS(525), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    ACTIONS(523), 18,
      sym_comment,
      anon_sym_while,
      anon_sym_expr,
      anon_sym_foreach,
      anon_sym_global,
      anon_sym_namespace,
      anon_sym_try,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_set,
      anon_sym_proc,
      anon_sym_if,
      anon_sym_catch,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [11350] = 3,
    STATE(221), 1,
      aux_sym__commands_repeat1,
    ACTIONS(528), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    ACTIONS(523), 19,
      sym_comment,
      anon_sym_while,
      anon_sym_expr,
      anon_sym_foreach,
      anon_sym_global,
      anon_sym_namespace,
      anon_sym_try,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_set,
      anon_sym_proc,
      anon_sym_if,
      anon_sym_catch,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [11379] = 11,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(537), 1,
      anon_sym_LBRACE,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(892), 1,
      sym_expr,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(217), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11422] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(409), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11465] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(401), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11508] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(403), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11551] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(389), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11594] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(387), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11637] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(377), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11680] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11723] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(371), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11766] = 11,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(569), 1,
      anon_sym_LBRACE,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(753), 1,
      sym_expr,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(168), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11809] = 11,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(585), 1,
      anon_sym_LBRACE,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(798), 1,
      sym_expr,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(198), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11852] = 11,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(553), 1,
      anon_sym_LBRACE,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(392), 1,
      sym_expr,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(108), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11895] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(197), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11932] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(120), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [11969] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(155), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12006] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(154), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12043] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(152), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12080] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(214), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12117] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(201), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12154] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(151), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12191] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(174), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12228] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(172), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12265] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(191), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12302] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(194), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12339] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(199), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12376] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(190), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12413] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(184), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12450] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(164), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12487] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(165), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12524] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(166), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12561] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(167), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12598] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(170), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12635] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(183), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12672] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(150), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12709] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(187), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12746] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(149), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12783] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(188), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12820] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(176), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12857] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(175), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12894] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(213), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12931] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(128), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [12968] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(200), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13005] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(173), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13042] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(182), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13079] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(177), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13116] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(178), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13153] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(129), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13190] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(156), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13227] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(212), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13264] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(207), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13301] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(180), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13338] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(216), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13375] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(130), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13412] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(131), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13449] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(162), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13486] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(161), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13523] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(186), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13560] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(126), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13597] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(109), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13634] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(208), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13671] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(160), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13708] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(159), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13745] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(158), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13782] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(127), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13819] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(122), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13856] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(204), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13893] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(121), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13930] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(219), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [13967] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(118), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14004] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(153), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14041] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(115), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14078] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(211), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14115] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(215), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14152] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(210), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14189] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(206), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14226] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(114), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14263] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(145), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14300] = 9,
    ACTIONS(579), 1,
      sym_simple_word,
    ACTIONS(581), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(587), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(192), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14337] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(209), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14374] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(218), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14411] = 9,
    ACTIONS(547), 1,
      sym_simple_word,
    ACTIONS(549), 1,
      anon_sym_LPAREN,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(555), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(110), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14448] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(203), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14485] = 9,
    ACTIONS(563), 1,
      sym_simple_word,
    ACTIONS(565), 1,
      anon_sym_LPAREN,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(571), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(185), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14522] = 9,
    ACTIONS(531), 1,
      sym_simple_word,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
    ACTIONS(539), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_BANG,
    STATE(205), 5,
      sym__concat_word,
      sym__expr,
      sym_unary_expr,
      sym_binop_expr,
      sym_ternary_expr,
  [14559] = 10,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(597), 1,
      sym_unpack,
    STATE(738), 1,
      sym_word_list,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(595), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(310), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14597] = 11,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(599), 1,
      ts_builtin_sym_end,
    ACTIONS(603), 1,
      sym_unpack,
    STATE(781), 1,
      sym_word_list,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(601), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(312), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14637] = 11,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      sym_unpack,
    ACTIONS(605), 1,
      ts_builtin_sym_end,
    STATE(750), 1,
      sym_word_list,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(595), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(312), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14677] = 10,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(597), 1,
      sym_unpack,
    STATE(731), 1,
      sym_word_list,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(601), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(310), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14715] = 9,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(597), 1,
      sym_unpack,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(607), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(311), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14750] = 9,
    ACTIONS(614), 1,
      sym_unpack,
    ACTIONS(617), 1,
      anon_sym_DOLLAR,
    ACTIONS(620), 1,
      anon_sym_LBRACE,
    ACTIONS(623), 1,
      anon_sym_DQUOTE,
    ACTIONS(626), 1,
      anon_sym_LBRACK,
    ACTIONS(609), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(612), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(311), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14785] = 10,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      sym_unpack,
    ACTIONS(629), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(607), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(313), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14822] = 10,
    ACTIONS(631), 1,
      ts_builtin_sym_end,
    ACTIONS(636), 1,
      sym_unpack,
    ACTIONS(639), 1,
      anon_sym_DOLLAR,
    ACTIONS(642), 1,
      anon_sym_LBRACE,
    ACTIONS(645), 1,
      anon_sym_DQUOTE,
    ACTIONS(648), 1,
      anon_sym_LBRACK,
    ACTIONS(612), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    ACTIONS(633), 2,
      sym_escaped_character,
      sym_simple_word,
    STATE(313), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14859] = 11,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(601), 1,
      anon_sym_RBRACK,
    ACTIONS(651), 1,
      sym_unpack,
    STATE(867), 1,
      sym_word_list,
    STATE(321), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14897] = 11,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(595), 1,
      anon_sym_RBRACK,
    ACTIONS(651), 1,
      sym_unpack,
    STATE(832), 1,
      sym_word_list,
    STATE(321), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14935] = 10,
    ACTIONS(3), 1,
      sym_simple_word,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      sym_unpack,
    ACTIONS(653), 1,
      sym_escaped_character,
    STATE(760), 1,
      sym_word_list,
    STATE(312), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [14970] = 4,
    ACTIONS(241), 1,
      sym_concat,
    ACTIONS(655), 1,
      sym__ns_delim,
    STATE(317), 1,
      aux_sym_id_repeat1,
    ACTIONS(239), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [14993] = 10,
    ACTIONS(612), 1,
      anon_sym_RBRACK,
    ACTIONS(658), 1,
      sym_simple_word,
    ACTIONS(661), 1,
      sym_unpack,
    ACTIONS(664), 1,
      anon_sym_DOLLAR,
    ACTIONS(667), 1,
      anon_sym_LBRACE,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(673), 1,
      sym_escaped_character,
    ACTIONS(676), 1,
      anon_sym_LBRACK,
    STATE(318), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15028] = 4,
    ACTIONS(679), 1,
      sym__ns_delim,
    STATE(322), 1,
      aux_sym_id_repeat1,
    ACTIONS(233), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(231), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15051] = 4,
    ACTIONS(221), 1,
      sym_concat,
    ACTIONS(681), 1,
      sym__ns_delim,
    STATE(317), 1,
      aux_sym_id_repeat1,
    ACTIONS(223), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15074] = 10,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_RBRACK,
    ACTIONS(651), 1,
      sym_unpack,
    STATE(318), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15109] = 4,
    ACTIONS(683), 1,
      sym__ns_delim,
    STATE(322), 1,
      aux_sym_id_repeat1,
    ACTIONS(241), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(239), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15132] = 10,
    ACTIONS(39), 1,
      sym_simple_word,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(597), 1,
      sym_unpack,
    ACTIONS(686), 1,
      sym_escaped_character,
    STATE(790), 1,
      sym_word_list,
    STATE(310), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15167] = 10,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(651), 1,
      sym_unpack,
    STATE(879), 1,
      sym_word_list,
    STATE(321), 3,
      sym__concat_word,
      sym_braced_word,
      aux_sym_word_list_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15202] = 4,
    ACTIONS(233), 1,
      sym_concat,
    ACTIONS(681), 1,
      sym__ns_delim,
    STATE(317), 1,
      aux_sym_id_repeat1,
    ACTIONS(231), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15225] = 4,
    ACTIONS(679), 1,
      sym__ns_delim,
    STATE(330), 1,
      aux_sym_id_repeat1,
    ACTIONS(173), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(171), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15248] = 4,
    ACTIONS(679), 1,
      sym__ns_delim,
    STATE(319), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(223), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15271] = 4,
    ACTIONS(173), 1,
      sym_concat,
    ACTIONS(681), 1,
      sym__ns_delim,
    STATE(320), 1,
      aux_sym_id_repeat1,
    ACTIONS(171), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15294] = 4,
    ACTIONS(221), 1,
      sym_concat,
    ACTIONS(681), 1,
      sym__ns_delim,
    STATE(325), 1,
      aux_sym_id_repeat1,
    ACTIONS(223), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15317] = 4,
    ACTIONS(679), 1,
      sym__ns_delim,
    STATE(322), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(223), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15340] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(694), 1,
      anon_sym_RBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15372] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(702), 1,
      anon_sym_RBRACE,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15404] = 9,
    ACTIONS(704), 1,
      sym_simple_word,
    ACTIONS(707), 1,
      anon_sym_DOLLAR,
    ACTIONS(710), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_RBRACE,
    ACTIONS(715), 1,
      anon_sym_DQUOTE,
    ACTIONS(718), 1,
      sym_escaped_character,
    ACTIONS(721), 1,
      anon_sym_LBRACK,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15436] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(724), 1,
      anon_sym_RBRACE,
    STATE(337), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15468] = 4,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    STATE(453), 1,
      sym_array_index,
    ACTIONS(274), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(276), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15490] = 7,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    STATE(351), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    ACTIONS(728), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15518] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(730), 1,
      anon_sym_RBRACE,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15550] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(732), 1,
      anon_sym_RBRACE,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15582] = 8,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(734), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(728), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(348), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15612] = 4,
    ACTIONS(274), 1,
      sym_concat,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    STATE(462), 1,
      sym_array_index,
    ACTIONS(276), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15634] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(738), 1,
      anon_sym_RBRACE,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15666] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(740), 1,
      anon_sym_RBRACE,
    STATE(341), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15698] = 4,
    ACTIONS(256), 1,
      sym_concat,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    STATE(491), 1,
      sym_array_index,
    ACTIONS(258), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15720] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(742), 1,
      anon_sym_RBRACE,
    STATE(338), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15752] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(744), 1,
      anon_sym_RBRACE,
    STATE(333), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15784] = 2,
    ACTIONS(241), 3,
      sym_concat,
      sym__ns_delim,
      ts_builtin_sym_end,
    ACTIONS(239), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15802] = 8,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(746), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(748), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(339), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15832] = 8,
    ACTIONS(750), 1,
      ts_builtin_sym_end,
    ACTIONS(757), 1,
      anon_sym_DOLLAR,
    ACTIONS(760), 1,
      anon_sym_DQUOTE,
    ACTIONS(763), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 2,
      sym_escaped_character,
      sym_simple_word,
    ACTIONS(755), 2,
      anon_sym_LF,
      anon_sym_SEMI,
    STATE(348), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15862] = 2,
    ACTIONS(241), 2,
      sym_concat,
      sym__ns_delim,
    ACTIONS(239), 11,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15880] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(766), 1,
      anon_sym_RBRACE,
    STATE(331), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15912] = 7,
    ACTIONS(771), 1,
      anon_sym_DOLLAR,
    ACTIONS(774), 1,
      anon_sym_DQUOTE,
    ACTIONS(777), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 2,
      sym_escaped_character,
      sym_simple_word,
    STATE(351), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    ACTIONS(755), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15940] = 4,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    STATE(456), 1,
      sym_array_index,
    ACTIONS(256), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(258), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [15962] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_RBRACE,
    STATE(332), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [15994] = 7,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 2,
      sym_escaped_character,
      sym_simple_word,
    STATE(336), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    ACTIONS(748), 3,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16022] = 9,
    ACTIONS(688), 1,
      sym_simple_word,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(692), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      sym_escaped_character,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(782), 1,
      anon_sym_RBRACE,
    STATE(345), 3,
      sym__concat_word,
      sym_braced_word_simple,
      aux_sym_braced_word_simple_repeat1,
    STATE(532), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16054] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(786), 1,
      sym_unpack,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(713), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16085] = 3,
    ACTIONS(798), 1,
      sym_concat,
    STATE(421), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [16104] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(800), 1,
      sym_unpack,
    STATE(763), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16135] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(802), 1,
      sym_unpack,
    STATE(780), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16166] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(806), 1,
      sym_unpack,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(647), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16197] = 9,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(810), 1,
      sym_unpack,
    STATE(369), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16228] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(812), 1,
      sym_unpack,
    STATE(782), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16259] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(814), 1,
      sym_unpack,
    STATE(783), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16290] = 4,
    ACTIONS(268), 1,
      ts_builtin_sym_end,
    ACTIONS(816), 1,
      sym_concat,
    STATE(373), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [16311] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(818), 1,
      sym_unpack,
    STATE(771), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16342] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    STATE(374), 3,
      sym__word_simple,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16371] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    STATE(385), 3,
      sym__word_simple,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16400] = 9,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(822), 1,
      sym_unpack,
    STATE(388), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16431] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(824), 1,
      sym_unpack,
    STATE(722), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16462] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_LBRACE,
    STATE(400), 3,
      sym__word_simple,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16491] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym_unpack,
    STATE(568), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16522] = 9,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(828), 1,
      sym_unpack,
    STATE(402), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16553] = 4,
    ACTIONS(293), 1,
      ts_builtin_sym_end,
    ACTIONS(816), 1,
      sym_concat,
    STATE(396), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [16574] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(830), 1,
      sym_unpack,
    STATE(765), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16605] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(832), 1,
      sym_unpack,
    STATE(793), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16636] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(834), 1,
      sym_unpack,
    STATE(766), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16667] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(836), 1,
      sym_unpack,
    STATE(764), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16698] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(838), 1,
      sym_unpack,
    STATE(733), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16729] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(840), 1,
      sym_unpack,
    STATE(897), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16760] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(842), 1,
      sym_unpack,
    STATE(882), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16791] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(844), 1,
      sym_unpack,
    STATE(799), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16822] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(846), 1,
      sym_unpack,
    STATE(860), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16853] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(848), 1,
      sym_unpack,
    STATE(881), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16884] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      sym_unpack,
    STATE(840), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16915] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(852), 1,
      sym_unpack,
    STATE(893), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16946] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(854), 1,
      sym_unpack,
    STATE(716), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [16977] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(856), 1,
      sym_unpack,
    STATE(648), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17008] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(858), 1,
      sym_unpack,
    STATE(813), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17039] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(860), 1,
      sym_unpack,
    STATE(861), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17070] = 9,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(862), 1,
      sym_unpack,
    STATE(871), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17101] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(866), 1,
      sym_unpack,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(677), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17132] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(870), 1,
      sym_unpack,
    STATE(698), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17163] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(872), 1,
      sym_unpack,
    STATE(687), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17194] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      sym_unpack,
    STATE(792), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17225] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(876), 1,
      sym_unpack,
    STATE(720), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17256] = 4,
    ACTIONS(278), 1,
      ts_builtin_sym_end,
    ACTIONS(878), 1,
      sym_concat,
    STATE(396), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [17277] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(881), 1,
      sym_unpack,
    STATE(717), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17308] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(883), 1,
      sym_unpack,
    STATE(718), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17339] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(885), 1,
      sym_unpack,
    STATE(728), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17370] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(887), 1,
      sym_unpack,
    STATE(785), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17401] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(889), 1,
      sym_unpack,
    STATE(617), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17432] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(891), 1,
      sym_unpack,
    STATE(739), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17463] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(893), 1,
      sym_unpack,
    STATE(732), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17494] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(895), 1,
      sym_unpack,
    STATE(730), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17525] = 9,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    ACTIONS(897), 1,
      sym_unpack,
    STATE(642), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17556] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(899), 1,
      sym_unpack,
    STATE(747), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17587] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(901), 1,
      sym_unpack,
    STATE(726), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17618] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(903), 1,
      sym_unpack,
    STATE(655), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17649] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(905), 1,
      sym_unpack,
    STATE(663), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17680] = 4,
    ACTIONS(907), 1,
      sym__ns_delim,
    STATE(410), 1,
      aux_sym_id_repeat1,
    ACTIONS(239), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
    ACTIONS(241), 5,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
  [17701] = 4,
    ACTIONS(910), 1,
      sym__ns_delim,
    STATE(410), 1,
      aux_sym_id_repeat1,
    ACTIONS(231), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
    ACTIONS(233), 5,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
  [17722] = 4,
    ACTIONS(910), 1,
      sym__ns_delim,
    STATE(410), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 5,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(223), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [17743] = 4,
    ACTIONS(910), 1,
      sym__ns_delim,
    STATE(411), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 5,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(223), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [17764] = 4,
    ACTIONS(910), 1,
      sym__ns_delim,
    STATE(412), 1,
      aux_sym_id_repeat1,
    ACTIONS(171), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
    ACTIONS(173), 5,
      sym_concat,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
  [17785] = 4,
    ACTIONS(912), 1,
      sym__ns_delim,
    STATE(415), 1,
      aux_sym_id_repeat1,
    ACTIONS(241), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(239), 8,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [17806] = 4,
    ACTIONS(915), 1,
      sym__ns_delim,
    STATE(415), 1,
      aux_sym_id_repeat1,
    ACTIONS(233), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(231), 8,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [17827] = 4,
    ACTIONS(915), 1,
      sym__ns_delim,
    STATE(415), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(223), 8,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [17848] = 4,
    ACTIONS(915), 1,
      sym__ns_delim,
    STATE(416), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(223), 8,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [17869] = 4,
    ACTIONS(915), 1,
      sym__ns_delim,
    STATE(417), 1,
      aux_sym_id_repeat1,
    ACTIONS(173), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(171), 8,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [17890] = 9,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    ACTIONS(917), 1,
      sym_unpack,
    STATE(667), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17921] = 3,
    ACTIONS(919), 1,
      sym_concat,
    STATE(421), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [17940] = 3,
    ACTIONS(798), 1,
      sym_concat,
    STATE(357), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [17959] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(667), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [17987] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(694), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18015] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(758), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18043] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(748), 1,
      anon_sym_RBRACK,
    STATE(428), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18071] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(776), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18099] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(728), 1,
      anon_sym_RBRACK,
    STATE(435), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18127] = 8,
    ACTIONS(3), 1,
      sym_simple_word,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      sym_escaped_character,
    STATE(308), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18155] = 4,
    ACTIONS(922), 1,
      anon_sym_LPAREN,
    STATE(543), 1,
      sym_array_index,
    ACTIONS(256), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(258), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [18175] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(749), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18203] = 8,
    ACTIONS(3), 1,
      sym_simple_word,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      sym_escaped_character,
    STATE(522), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(364), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18231] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(383), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18259] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(652), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18287] = 8,
    ACTIONS(755), 1,
      anon_sym_RBRACK,
    ACTIONS(924), 1,
      sym_simple_word,
    ACTIONS(927), 1,
      anon_sym_DOLLAR,
    ACTIONS(930), 1,
      anon_sym_DQUOTE,
    ACTIONS(933), 1,
      sym_escaped_character,
    ACTIONS(936), 1,
      anon_sym_LBRACK,
    STATE(435), 2,
      sym__concat_word,
      aux_sym_global_repeat1,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18315] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(741), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18343] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(381), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18371] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(719), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18399] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(398), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18427] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(797), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18455] = 2,
    ACTIONS(307), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(309), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [18471] = 4,
    ACTIONS(922), 1,
      anon_sym_LPAREN,
    STATE(533), 1,
      sym_array_index,
    ACTIONS(274), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(276), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [18491] = 8,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_escaped_character,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    ACTIONS(939), 1,
      sym_simple_word,
    ACTIONS(941), 1,
      anon_sym_LBRACE,
    STATE(123), 2,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(79), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18519] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(727), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18547] = 2,
    ACTIONS(301), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(299), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [18563] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(943), 1,
      anon_sym_LBRACE,
    STATE(179), 2,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18591] = 2,
    ACTIONS(307), 1,
      sym_concat,
    ACTIONS(309), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [18607] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(715), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18635] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(774), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18663] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(766), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18691] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(853), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18719] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(875), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18747] = 2,
    ACTIONS(315), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(317), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [18763] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(887), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18791] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(862), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18819] = 2,
    ACTIONS(303), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(305), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [18835] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(746), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18863] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(884), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18891] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(843), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18919] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(643), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18947] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(881), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [18975] = 2,
    ACTIONS(315), 1,
      sym_concat,
    ACTIONS(317), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [18991] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(799), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19019] = 2,
    ACTIONS(311), 1,
      sym_concat,
    ACTIONS(313), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19035] = 2,
    ACTIONS(278), 1,
      sym_concat,
    ACTIONS(280), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19051] = 2,
    ACTIONS(319), 1,
      sym_concat,
    ACTIONS(321), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19067] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(800), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19095] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(864), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19123] = 8,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(790), 1,
      anon_sym_LBRACE,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(712), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19151] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(582), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19179] = 8,
    ACTIONS(39), 1,
      sym_simple_word,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(686), 1,
      sym_escaped_character,
    STATE(519), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19207] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(315), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19235] = 2,
    ACTIONS(311), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(313), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19251] = 8,
    ACTIONS(177), 1,
      sym_simple_word,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(197), 1,
      anon_sym_LBRACE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(209), 1,
      sym_escaped_character,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(569), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(517), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19279] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(697), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19307] = 2,
    ACTIONS(239), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
    ACTIONS(241), 6,
      sym_concat,
      sym__ns_delim,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
  [19323] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(677), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19351] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(729), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19379] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(723), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19407] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(671), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19435] = 2,
    ACTIONS(278), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(280), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19451] = 8,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(543), 1,
      sym_escaped_character,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(945), 1,
      sym_simple_word,
    ACTIONS(947), 1,
      anon_sym_LBRACE,
    STATE(157), 2,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(135), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19479] = 4,
    ACTIONS(949), 1,
      sym__ns_delim,
    STATE(507), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(223), 7,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [19499] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(670), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19527] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(744), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19555] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(762), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19583] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(734), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19611] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(754), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19639] = 2,
    ACTIONS(319), 2,
      sym_concat,
      ts_builtin_sym_end,
    ACTIONS(321), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19655] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(615), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19683] = 2,
    ACTIONS(303), 1,
      sym_concat,
    ACTIONS(305), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19699] = 2,
    ACTIONS(301), 1,
      sym_concat,
    ACTIONS(299), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [19715] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(718), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19743] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(773), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19771] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(951), 1,
      anon_sym_LBRACE,
    STATE(189), 2,
      sym__concat_word,
      sym_braced_word_simple,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19799] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(769), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19827] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(742), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19855] = 4,
    ACTIONS(953), 1,
      anon_sym_LPAREN,
    STATE(540), 1,
      sym_array_index,
    ACTIONS(274), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(276), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [19875] = 8,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(591), 1,
      sym_escaped_character,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(864), 1,
      sym_simple_word,
    ACTIONS(868), 1,
      anon_sym_LBRACE,
    STATE(650), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(78), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19903] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(786), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19931] = 4,
    ACTIONS(953), 1,
      anon_sym_LPAREN,
    STATE(552), 1,
      sym_array_index,
    ACTIONS(256), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(258), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [19951] = 8,
    ACTIONS(39), 1,
      sym_simple_word,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(686), 1,
      sym_escaped_character,
    STATE(306), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(422), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [19979] = 8,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(575), 1,
      sym_escaped_character,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(804), 1,
      sym_simple_word,
    ACTIONS(808), 1,
      anon_sym_LBRACE,
    STATE(788), 2,
      sym__concat_word,
      sym_braced_word,
    STATE(74), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20007] = 4,
    ACTIONS(949), 1,
      sym__ns_delim,
    STATE(508), 1,
      aux_sym_id_repeat1,
    ACTIONS(173), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(171), 7,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20027] = 4,
    ACTIONS(955), 1,
      sym__ns_delim,
    STATE(505), 1,
      aux_sym_id_repeat1,
    ACTIONS(241), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(239), 7,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20047] = 2,
    ACTIONS(241), 3,
      sym_concat,
      sym__ns_delim,
      sym_escaped_character,
    ACTIONS(239), 8,
      sym_unpack,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20063] = 4,
    ACTIONS(949), 1,
      sym__ns_delim,
    STATE(505), 1,
      aux_sym_id_repeat1,
    ACTIONS(233), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(231), 7,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20083] = 4,
    ACTIONS(949), 1,
      sym__ns_delim,
    STATE(505), 1,
      aux_sym_id_repeat1,
    ACTIONS(221), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(223), 7,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20103] = 4,
    ACTIONS(278), 1,
      sym_escaped_character,
    ACTIONS(958), 1,
      sym_concat,
    STATE(509), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20122] = 4,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    STATE(605), 1,
      sym_array_index,
    ACTIONS(274), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(276), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20141] = 1,
    ACTIONS(963), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20154] = 2,
    ACTIONS(241), 3,
      sym_concat,
      sym__ns_delim,
      sym_escaped_character,
    ACTIONS(239), 7,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20169] = 4,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    STATE(610), 1,
      sym_array_index,
    ACTIONS(256), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(258), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20188] = 4,
    ACTIONS(293), 1,
      sym_escaped_character,
    ACTIONS(965), 1,
      sym_concat,
    STATE(509), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20207] = 1,
    ACTIONS(967), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20220] = 2,
    ACTIONS(969), 1,
      ts_builtin_sym_end,
    ACTIONS(967), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20235] = 4,
    ACTIONS(268), 1,
      sym_escaped_character,
    ACTIONS(965), 1,
      sym_concat,
    STATE(514), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20254] = 2,
    ACTIONS(971), 1,
      ts_builtin_sym_end,
    ACTIONS(973), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20269] = 1,
    ACTIONS(612), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20282] = 2,
    ACTIONS(975), 1,
      ts_builtin_sym_end,
    ACTIONS(977), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20297] = 4,
    ACTIONS(979), 1,
      sym_concat,
    STATE(526), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(268), 3,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(264), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20316] = 2,
    ACTIONS(631), 1,
      ts_builtin_sym_end,
    ACTIONS(612), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20331] = 1,
    ACTIONS(977), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20344] = 2,
    ACTIONS(981), 1,
      ts_builtin_sym_end,
    ACTIONS(963), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20359] = 2,
    ACTIONS(983), 1,
      ts_builtin_sym_end,
    ACTIONS(985), 9,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20374] = 4,
    ACTIONS(979), 1,
      sym_concat,
    STATE(529), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(293), 3,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(295), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20393] = 1,
    ACTIONS(973), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20406] = 1,
    ACTIONS(985), 10,
      anon_sym_LF,
      anon_sym_SEMI,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      sym_escaped_character,
      anon_sym_LBRACK,
      sym_simple_word,
  [20419] = 4,
    ACTIONS(987), 1,
      sym_concat,
    STATE(529), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(278), 3,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(280), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20438] = 2,
    ACTIONS(301), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(299), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20452] = 4,
    ACTIONS(293), 1,
      sym_escaped_character,
    ACTIONS(990), 1,
      sym_concat,
    STATE(547), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(295), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20470] = 4,
    ACTIONS(268), 1,
      sym_escaped_character,
    ACTIONS(990), 1,
      sym_concat,
    STATE(531), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(264), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20488] = 2,
    ACTIONS(315), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(317), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20502] = 2,
    ACTIONS(307), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(309), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20516] = 2,
    ACTIONS(311), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(313), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20530] = 2,
    ACTIONS(278), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(280), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20544] = 2,
    ACTIONS(319), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(321), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20558] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(819), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20582] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(826), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20606] = 2,
    ACTIONS(315), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(317), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20620] = 2,
    ACTIONS(311), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(313), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20634] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(818), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20658] = 2,
    ACTIONS(303), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(305), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20672] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(809), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20696] = 2,
    ACTIONS(278), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(280), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20710] = 2,
    ACTIONS(319), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(321), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20724] = 4,
    ACTIONS(278), 1,
      sym_escaped_character,
    ACTIONS(992), 1,
      sym_concat,
    STATE(547), 1,
      aux_sym__concat_word_repeat1,
    ACTIONS(280), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20742] = 2,
    ACTIONS(301), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(299), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20756] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(803), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20780] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(841), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20804] = 2,
    ACTIONS(307), 4,
      sym_concat,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACK,
    ACTIONS(309), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [20818] = 2,
    ACTIONS(303), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(305), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [20832] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(822), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20856] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(845), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20880] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(888), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20904] = 7,
    ACTIONS(784), 1,
      sym_simple_word,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(794), 1,
      sym_escaped_character,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    STATE(859), 1,
      sym__concat_word,
    STATE(521), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [20928] = 2,
    ACTIONS(311), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(313), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20941] = 2,
    ACTIONS(307), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(309), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [20954] = 6,
    ACTIONS(997), 1,
      anon_sym_SEMI,
    ACTIONS(999), 1,
      anon_sym_elseif,
    ACTIONS(1001), 1,
      anon_sym_else,
    STATE(748), 1,
      sym_else,
    ACTIONS(995), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(625), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [20975] = 3,
    ACTIONS(1003), 1,
      sym__ns_delim,
    STATE(564), 1,
      aux_sym_id_repeat1,
    ACTIONS(223), 6,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [20990] = 3,
    ACTIONS(1003), 1,
      sym__ns_delim,
    STATE(566), 1,
      aux_sym_id_repeat1,
    ACTIONS(223), 6,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [21005] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1007), 1,
      anon_sym_DQUOTE,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1009), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(571), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21024] = 2,
    ACTIONS(969), 1,
      sym_escaped_character,
    ACTIONS(967), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [21037] = 3,
    ACTIONS(1003), 1,
      sym__ns_delim,
    STATE(566), 1,
      aux_sym_id_repeat1,
    ACTIONS(231), 6,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [21052] = 2,
    ACTIONS(981), 1,
      sym_escaped_character,
    ACTIONS(963), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [21065] = 3,
    ACTIONS(1013), 1,
      sym__ns_delim,
    STATE(566), 1,
      aux_sym_id_repeat1,
    ACTIONS(239), 6,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [21080] = 5,
    ACTIONS(1016), 1,
      anon_sym_DOLLAR,
    ACTIONS(1019), 1,
      anon_sym_DQUOTE,
    ACTIONS(1024), 1,
      anon_sym_LBRACK,
    ACTIONS(1021), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21099] = 6,
    ACTIONS(999), 1,
      anon_sym_elseif,
    ACTIONS(1001), 1,
      anon_sym_else,
    ACTIONS(1029), 1,
      anon_sym_SEMI,
    STATE(796), 1,
      sym_else,
    ACTIONS(1027), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(579), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21120] = 2,
    ACTIONS(631), 1,
      sym_escaped_character,
    ACTIONS(612), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [21133] = 6,
    ACTIONS(995), 1,
      anon_sym_LF,
    ACTIONS(1031), 1,
      anon_sym_elseif,
    ACTIONS(1033), 1,
      anon_sym_else,
    STATE(724), 1,
      sym_else,
    ACTIONS(997), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(640), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21154] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1035), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21173] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1039), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21192] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1041), 1,
      anon_sym_DQUOTE,
    ACTIONS(1043), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(576), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21211] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1045), 1,
      anon_sym_DQUOTE,
    ACTIONS(1047), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(572), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21230] = 6,
    ACTIONS(690), 1,
      anon_sym_DOLLAR,
    ACTIONS(696), 1,
      anon_sym_DQUOTE,
    ACTIONS(700), 1,
      anon_sym_LBRACK,
    ACTIONS(1049), 1,
      sym_simple_word,
    ACTIONS(1051), 1,
      sym_escaped_character,
    STATE(591), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21251] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1053), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21270] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1055), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21289] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1057), 1,
      anon_sym_DQUOTE,
    ACTIONS(1059), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(577), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21308] = 6,
    ACTIONS(999), 1,
      anon_sym_elseif,
    ACTIONS(1001), 1,
      anon_sym_else,
    ACTIONS(1063), 1,
      anon_sym_SEMI,
    STATE(745), 1,
      sym_else,
    ACTIONS(1061), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(625), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21329] = 6,
    ACTIONS(583), 1,
      anon_sym_DOLLAR,
    ACTIONS(589), 1,
      anon_sym_DQUOTE,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(1065), 1,
      sym_simple_word,
    ACTIONS(1067), 1,
      sym_escaped_character,
    STATE(104), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21350] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1069), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21369] = 6,
    ACTIONS(999), 1,
      anon_sym_elseif,
    ACTIONS(1001), 1,
      anon_sym_else,
    ACTIONS(1063), 1,
      anon_sym_SEMI,
    STATE(745), 1,
      sym_else,
    ACTIONS(1061), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(559), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21390] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1071), 1,
      anon_sym_DQUOTE,
    ACTIONS(1073), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(581), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21409] = 2,
    ACTIONS(971), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    ACTIONS(973), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [21422] = 2,
    ACTIONS(981), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    ACTIONS(963), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [21435] = 2,
    ACTIONS(971), 1,
      sym_escaped_character,
    ACTIONS(973), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [21448] = 6,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(541), 1,
      anon_sym_DQUOTE,
    ACTIONS(545), 1,
      anon_sym_LBRACK,
    ACTIONS(1075), 1,
      sym_simple_word,
    ACTIONS(1077), 1,
      sym_escaped_character,
    STATE(138), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21469] = 6,
    ACTIONS(1031), 1,
      anon_sym_elseif,
    ACTIONS(1033), 1,
      anon_sym_else,
    ACTIONS(1061), 1,
      anon_sym_LF,
    STATE(755), 1,
      sym_else,
    ACTIONS(1063), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(640), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21490] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1079), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21509] = 6,
    ACTIONS(567), 1,
      anon_sym_DOLLAR,
    ACTIONS(573), 1,
      anon_sym_DQUOTE,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    ACTIONS(1081), 1,
      sym_simple_word,
    ACTIONS(1083), 1,
      sym_escaped_character,
    STATE(90), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21530] = 2,
    ACTIONS(278), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(280), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [21543] = 6,
    ACTIONS(551), 1,
      anon_sym_DOLLAR,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(561), 1,
      anon_sym_LBRACK,
    ACTIONS(1085), 1,
      sym_simple_word,
    ACTIONS(1087), 1,
      sym_escaped_character,
    STATE(82), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21564] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1089), 1,
      anon_sym_DQUOTE,
    ACTIONS(1091), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(589), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21583] = 6,
    ACTIONS(23), 1,
      anon_sym_DOLLAR,
    ACTIONS(35), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(1093), 1,
      sym_simple_word,
    ACTIONS(1095), 1,
      sym_escaped_character,
    STATE(481), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21604] = 6,
    ACTIONS(788), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      anon_sym_DQUOTE,
    ACTIONS(796), 1,
      anon_sym_LBRACK,
    ACTIONS(1097), 1,
      sym_simple_word,
    ACTIONS(1099), 1,
      sym_escaped_character,
    STATE(536), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21625] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21644] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1103), 1,
      anon_sym_DQUOTE,
    ACTIONS(1105), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(596), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21663] = 6,
    ACTIONS(195), 1,
      anon_sym_DOLLAR,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    ACTIONS(1107), 1,
      sym_simple_word,
    ACTIONS(1109), 1,
      sym_escaped_character,
    STATE(545), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21684] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1111), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21703] = 2,
    ACTIONS(969), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    ACTIONS(967), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [21716] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1113), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21735] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1115), 1,
      anon_sym_DQUOTE,
    ACTIONS(1117), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(599), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21754] = 2,
    ACTIONS(983), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    ACTIONS(985), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [21767] = 2,
    ACTIONS(975), 1,
      sym_escaped_character,
    ACTIONS(977), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [21780] = 2,
    ACTIONS(315), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(317), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [21793] = 2,
    ACTIONS(983), 1,
      sym_escaped_character,
    ACTIONS(985), 7,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_simple_word,
  [21806] = 2,
    ACTIONS(319), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(321), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [21819] = 3,
    ACTIONS(1003), 1,
      sym__ns_delim,
    STATE(561), 1,
      aux_sym_id_repeat1,
    ACTIONS(171), 6,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [21834] = 2,
    ACTIONS(975), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
    ACTIONS(977), 5,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
      sym_simple_word,
  [21847] = 2,
    ACTIONS(303), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(305), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [21860] = 2,
    ACTIONS(301), 2,
      sym_concat,
      sym_escaped_character,
    ACTIONS(299), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [21873] = 6,
    ACTIONS(59), 1,
      anon_sym_DOLLAR,
    ACTIONS(73), 1,
      anon_sym_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(1119), 1,
      sym_simple_word,
    ACTIONS(1121), 1,
      sym_escaped_character,
    STATE(465), 3,
      sym_variable_substitution,
      sym_quoted_word,
      sym_command_substitution,
  [21894] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1123), 1,
      anon_sym_DQUOTE,
    ACTIONS(1037), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(567), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21913] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1125), 1,
      anon_sym_DQUOTE,
    ACTIONS(1127), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(613), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21932] = 6,
    ACTIONS(1031), 1,
      anon_sym_elseif,
    ACTIONS(1033), 1,
      anon_sym_else,
    ACTIONS(1061), 1,
      anon_sym_LF,
    STATE(755), 1,
      sym_else,
    ACTIONS(1063), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(570), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21953] = 5,
    ACTIONS(1005), 1,
      anon_sym_DOLLAR,
    ACTIONS(1011), 1,
      anon_sym_LBRACK,
    ACTIONS(1129), 1,
      anon_sym_DQUOTE,
    ACTIONS(1131), 2,
      sym_escaped_character,
      sym__quoted_word_content,
    STATE(601), 3,
      sym_variable_substitution,
      sym_command_substitution,
      aux_sym_quoted_word_repeat1,
  [21972] = 6,
    ACTIONS(1027), 1,
      anon_sym_LF,
    ACTIONS(1031), 1,
      anon_sym_elseif,
    ACTIONS(1033), 1,
      anon_sym_else,
    STATE(740), 1,
      sym_else,
    ACTIONS(1029), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(588), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [21993] = 5,
    ACTIONS(1133), 1,
      sym_simple_word,
    ACTIONS(1135), 1,
      anon_sym_LBRACE,
    ACTIONS(1137), 1,
      anon_sym_RBRACE,
    ACTIONS(1139), 1,
      anon_sym_DQUOTE,
    STATE(814), 3,
      sym_braced_word,
      sym__argument_word,
      sym_quoted_word,
  [22011] = 2,
    ACTIONS(1143), 1,
      sym_escaped_character,
    ACTIONS(1141), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22023] = 2,
    ACTIONS(384), 1,
      sym_escaped_character,
    ACTIONS(382), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22035] = 2,
    ACTIONS(241), 1,
      sym__ns_delim,
    ACTIONS(239), 6,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22047] = 2,
    ACTIONS(975), 1,
      anon_sym_LF,
    ACTIONS(977), 6,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [22059] = 2,
    ACTIONS(975), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(977), 5,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
  [22071] = 2,
    ACTIONS(981), 1,
      anon_sym_LF,
    ACTIONS(963), 6,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [22083] = 4,
    ACTIONS(1149), 1,
      anon_sym_elseif,
    ACTIONS(1145), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1147), 2,
      anon_sym_SEMI,
      anon_sym_else,
    STATE(625), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [22099] = 3,
    ACTIONS(1152), 1,
      anon_sym_LPAREN,
    STATE(666), 1,
      sym_array_index,
    ACTIONS(258), 5,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22113] = 2,
    ACTIONS(1156), 1,
      sym_escaped_character,
    ACTIONS(1154), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22125] = 2,
    ACTIONS(971), 1,
      anon_sym_LF,
    ACTIONS(973), 6,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [22137] = 2,
    ACTIONS(384), 1,
      sym_escaped_character,
    ACTIONS(382), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22149] = 3,
    ACTIONS(1152), 1,
      anon_sym_LPAREN,
    STATE(659), 1,
      sym_array_index,
    ACTIONS(276), 5,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22163] = 2,
    ACTIONS(1160), 1,
      sym_escaped_character,
    ACTIONS(1158), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22175] = 2,
    ACTIONS(969), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(967), 5,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
  [22187] = 2,
    ACTIONS(983), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(985), 5,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
  [22199] = 2,
    ACTIONS(971), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(973), 5,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
  [22211] = 2,
    ACTIONS(983), 1,
      anon_sym_LF,
    ACTIONS(985), 6,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [22223] = 2,
    ACTIONS(374), 1,
      sym_escaped_character,
    ACTIONS(372), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22235] = 2,
    ACTIONS(374), 1,
      sym_escaped_character,
    ACTIONS(372), 6,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22247] = 2,
    ACTIONS(969), 1,
      anon_sym_LF,
    ACTIONS(967), 6,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [22259] = 2,
    ACTIONS(1164), 1,
      sym_escaped_character,
    ACTIONS(1162), 6,
      sym_unpack,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22271] = 4,
    ACTIONS(1145), 1,
      anon_sym_LF,
    ACTIONS(1166), 1,
      anon_sym_elseif,
    STATE(640), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
    ACTIONS(1147), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_else,
  [22287] = 2,
    ACTIONS(981), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(963), 5,
      anon_sym_SEMI,
      anon_sym_on,
      anon_sym_finally,
      anon_sym_elseif,
      anon_sym_else,
  [22299] = 5,
    ACTIONS(1169), 1,
      anon_sym_LF,
    ACTIONS(1173), 1,
      anon_sym_on,
    ACTIONS(1175), 1,
      anon_sym_finally,
    STATE(736), 1,
      sym_finally,
    ACTIONS(1171), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [22316] = 5,
    ACTIONS(1061), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 1,
      anon_sym_elseif,
    ACTIONS(1179), 1,
      anon_sym_else,
    STATE(844), 1,
      sym_else,
    STATE(644), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [22333] = 5,
    ACTIONS(995), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 1,
      anon_sym_elseif,
    ACTIONS(1179), 1,
      anon_sym_else,
    STATE(857), 1,
      sym_else,
    STATE(656), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [22350] = 5,
    ACTIONS(1061), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 1,
      anon_sym_elseif,
    ACTIONS(1179), 1,
      anon_sym_else,
    STATE(844), 1,
      sym_else,
    STATE(656), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [22367] = 2,
    ACTIONS(1156), 1,
      sym_escaped_character,
    ACTIONS(1154), 5,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22378] = 5,
    ACTIONS(1171), 1,
      anon_sym_SEMI,
    ACTIONS(1181), 1,
      anon_sym_on,
    ACTIONS(1183), 1,
      anon_sym_finally,
    STATE(752), 1,
      sym_finally,
    ACTIONS(1169), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [22395] = 5,
    ACTIONS(1027), 1,
      anon_sym_RBRACK,
    ACTIONS(1177), 1,
      anon_sym_elseif,
    ACTIONS(1179), 1,
      anon_sym_else,
    STATE(805), 1,
      sym_else,
    STATE(645), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [22412] = 2,
    ACTIONS(1143), 1,
      sym_escaped_character,
    ACTIONS(1141), 5,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22423] = 5,
    ACTIONS(1175), 1,
      anon_sym_finally,
    ACTIONS(1185), 1,
      anon_sym_LF,
    ACTIONS(1189), 1,
      anon_sym_on,
    STATE(784), 1,
      sym_finally,
    ACTIONS(1187), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [22440] = 2,
    ACTIONS(1160), 1,
      sym_escaped_character,
    ACTIONS(1158), 5,
      anon_sym_DOLLAR,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_simple_word,
  [22451] = 5,
    ACTIONS(1183), 1,
      anon_sym_finally,
    ACTIONS(1187), 1,
      anon_sym_SEMI,
    ACTIONS(1191), 1,
      anon_sym_on,
    STATE(778), 1,
      sym_finally,
    ACTIONS(1185), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [22468] = 4,
    ACTIONS(1193), 1,
      sym_simple_word,
    ACTIONS(1195), 1,
      anon_sym_LBRACE,
    ACTIONS(1197), 1,
      anon_sym_RBRACE,
    STATE(690), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [22482] = 5,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    ACTIONS(1199), 1,
      anon_sym_LF,
    ACTIONS(1201), 1,
      anon_sym_SEMI,
    STATE(25), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22498] = 4,
    ACTIONS(1183), 1,
      anon_sym_finally,
    ACTIONS(1205), 1,
      anon_sym_SEMI,
    STATE(759), 1,
      sym_finally,
    ACTIONS(1203), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [22512] = 4,
    ACTIONS(1145), 1,
      anon_sym_RBRACK,
    ACTIONS(1147), 1,
      anon_sym_else,
    ACTIONS(1207), 1,
      anon_sym_elseif,
    STATE(656), 2,
      sym_elseif,
      aux_sym_conditional_repeat1,
  [22526] = 5,
    ACTIONS(1210), 1,
      anon_sym_LF,
    ACTIONS(1212), 1,
      anon_sym_SEMI,
    ACTIONS(1214), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      aux_sym__commands_repeat1,
    STATE(673), 1,
      aux_sym__commands_repeat2,
  [22542] = 5,
    ACTIONS(91), 1,
      anon_sym_RBRACE,
    ACTIONS(1216), 1,
      anon_sym_LF,
    ACTIONS(1218), 1,
      anon_sym_SEMI,
    STATE(2), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22558] = 1,
    ACTIONS(317), 5,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22566] = 5,
    ACTIONS(137), 1,
      anon_sym_RBRACE,
    ACTIONS(1220), 1,
      anon_sym_LF,
    ACTIONS(1222), 1,
      anon_sym_SEMI,
    STATE(9), 1,
      aux_sym__commands_repeat1,
    STATE(693), 1,
      aux_sym__commands_repeat2,
  [22582] = 1,
    ACTIONS(321), 5,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22590] = 5,
    ACTIONS(1224), 1,
      ts_builtin_sym_end,
    ACTIONS(1226), 1,
      anon_sym_LF,
    ACTIONS(1228), 1,
      anon_sym_SEMI,
    STATE(23), 1,
      aux_sym__commands_repeat1,
    STATE(686), 1,
      aux_sym__commands_repeat2,
  [22606] = 2,
    ACTIONS(1230), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1232), 3,
      anon_sym_SEMI,
      anon_sym_elseif,
      anon_sym_else,
  [22616] = 5,
    ACTIONS(1234), 1,
      ts_builtin_sym_end,
    ACTIONS(1236), 1,
      anon_sym_LF,
    ACTIONS(1239), 1,
      anon_sym_SEMI,
    STATE(36), 1,
      aux_sym__commands_repeat1,
    STATE(664), 1,
      aux_sym__commands_repeat2,
  [22632] = 4,
    ACTIONS(1193), 1,
      sym_simple_word,
    ACTIONS(1195), 1,
      anon_sym_LBRACE,
    ACTIONS(1242), 1,
      anon_sym_RBRACE,
    STATE(700), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [22646] = 1,
    ACTIONS(305), 5,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22654] = 4,
    ACTIONS(1183), 1,
      anon_sym_finally,
    ACTIONS(1246), 1,
      anon_sym_SEMI,
    STATE(770), 1,
      sym_finally,
    ACTIONS(1244), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [22668] = 1,
    ACTIONS(299), 5,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      sym_escaped_character,
      sym__quoted_word_content,
      anon_sym_LBRACK,
  [22676] = 5,
    ACTIONS(1248), 1,
      anon_sym_LF,
    ACTIONS(1250), 1,
      anon_sym_SEMI,
    ACTIONS(1252), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym__commands_repeat1,
    STATE(674), 1,
      aux_sym__commands_repeat2,
  [22692] = 2,
    ACTIONS(1254), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1256), 3,
      anon_sym_SEMI,
      anon_sym_elseif,
      anon_sym_else,
  [22702] = 4,
    ACTIONS(1183), 1,
      anon_sym_finally,
    ACTIONS(1260), 1,
      anon_sym_SEMI,
    STATE(794), 1,
      sym_finally,
    ACTIONS(1258), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [22716] = 5,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    ACTIONS(1262), 1,
      anon_sym_LF,
    ACTIONS(1264), 1,
      anon_sym_SEMI,
    STATE(26), 1,
      aux_sym__commands_repeat1,
    STATE(699), 1,
      aux_sym__commands_repeat2,
  [22732] = 5,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    ACTIONS(1262), 1,
      anon_sym_LF,
    ACTIONS(1264), 1,
      anon_sym_SEMI,
    STATE(26), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22748] = 5,
    ACTIONS(89), 1,
      anon_sym_RBRACE,
    ACTIONS(1266), 1,
      anon_sym_LF,
    ACTIONS(1268), 1,
      anon_sym_SEMI,
    STATE(27), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22764] = 5,
    ACTIONS(89), 1,
      anon_sym_RBRACE,
    ACTIONS(1266), 1,
      anon_sym_LF,
    ACTIONS(1268), 1,
      anon_sym_SEMI,
    STATE(27), 1,
      aux_sym__commands_repeat1,
    STATE(676), 1,
      aux_sym__commands_repeat2,
  [22780] = 5,
    ACTIONS(153), 1,
      anon_sym_RBRACE,
    ACTIONS(1270), 1,
      anon_sym_LF,
    ACTIONS(1272), 1,
      anon_sym_SEMI,
    STATE(15), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22796] = 4,
    ACTIONS(1175), 1,
      anon_sym_finally,
    ACTIONS(1244), 1,
      anon_sym_LF,
    STATE(768), 1,
      sym_finally,
    ACTIONS(1246), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [22810] = 5,
    ACTIONS(137), 1,
      anon_sym_RBRACE,
    ACTIONS(1220), 1,
      anon_sym_LF,
    ACTIONS(1222), 1,
      anon_sym_SEMI,
    STATE(9), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22826] = 5,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    ACTIONS(1274), 1,
      anon_sym_LF,
    ACTIONS(1276), 1,
      anon_sym_SEMI,
    STATE(8), 1,
      aux_sym__commands_repeat1,
    STATE(658), 1,
      aux_sym__commands_repeat2,
  [22842] = 5,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    ACTIONS(1274), 1,
      anon_sym_LF,
    ACTIONS(1276), 1,
      anon_sym_SEMI,
    STATE(8), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22858] = 5,
    ACTIONS(123), 1,
      ts_builtin_sym_end,
    ACTIONS(1278), 1,
      anon_sym_LF,
    ACTIONS(1280), 1,
      anon_sym_SEMI,
    STATE(28), 1,
      aux_sym__commands_repeat1,
    STATE(664), 1,
      aux_sym__commands_repeat2,
  [22874] = 5,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    ACTIONS(1282), 1,
      anon_sym_LF,
    ACTIONS(1284), 1,
      anon_sym_SEMI,
    STATE(3), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22890] = 5,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    ACTIONS(1199), 1,
      anon_sym_LF,
    ACTIONS(1201), 1,
      anon_sym_SEMI,
    STATE(25), 1,
      aux_sym__commands_repeat1,
    STATE(682), 1,
      aux_sym__commands_repeat2,
  [22906] = 5,
    ACTIONS(101), 1,
      anon_sym_RBRACE,
    ACTIONS(1286), 1,
      anon_sym_LF,
    ACTIONS(1288), 1,
      anon_sym_SEMI,
    STATE(12), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [22922] = 5,
    ACTIONS(1290), 1,
      anon_sym_LF,
    ACTIONS(1292), 1,
      anon_sym_SEMI,
    ACTIONS(1294), 1,
      anon_sym_RBRACE,
    STATE(14), 1,
      aux_sym__commands_repeat1,
    STATE(702), 1,
      aux_sym__commands_repeat2,
  [22938] = 5,
    ACTIONS(145), 1,
      ts_builtin_sym_end,
    ACTIONS(1296), 1,
      anon_sym_LF,
    ACTIONS(1298), 1,
      anon_sym_SEMI,
    STATE(18), 1,
      aux_sym__commands_repeat1,
    STATE(664), 1,
      aux_sym__commands_repeat2,
  [22954] = 4,
    ACTIONS(1175), 1,
      anon_sym_finally,
    ACTIONS(1203), 1,
      anon_sym_LF,
    STATE(737), 1,
      sym_finally,
    ACTIONS(1205), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [22968] = 5,
    ACTIONS(1300), 1,
      anon_sym_LF,
    ACTIONS(1302), 1,
      anon_sym_SEMI,
    ACTIONS(1304), 1,
      anon_sym_RBRACE,
    STATE(24), 1,
      aux_sym__commands_repeat1,
    STATE(654), 1,
      aux_sym__commands_repeat2,
  [22984] = 5,
    ACTIONS(1306), 1,
      anon_sym_LF,
    ACTIONS(1308), 1,
      anon_sym_SEMI,
    ACTIONS(1310), 1,
      anon_sym_RBRACE,
    STATE(4), 1,
      aux_sym__commands_repeat1,
    STATE(680), 1,
      aux_sym__commands_repeat2,
  [23000] = 4,
    ACTIONS(1193), 1,
      sym_simple_word,
    ACTIONS(1195), 1,
      anon_sym_LBRACE,
    ACTIONS(1312), 1,
      anon_sym_RBRACE,
    STATE(691), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [23014] = 4,
    ACTIONS(1314), 1,
      sym_simple_word,
    ACTIONS(1317), 1,
      anon_sym_LBRACE,
    ACTIONS(1320), 1,
      anon_sym_RBRACE,
    STATE(691), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [23028] = 5,
    ACTIONS(1322), 1,
      anon_sym_LF,
    ACTIONS(1325), 1,
      anon_sym_SEMI,
    ACTIONS(1328), 1,
      anon_sym_RBRACE,
    STATE(32), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [23044] = 5,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    ACTIONS(1330), 1,
      anon_sym_LF,
    ACTIONS(1332), 1,
      anon_sym_SEMI,
    STATE(20), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [23060] = 2,
    ACTIONS(1254), 1,
      anon_sym_LF,
    ACTIONS(1256), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [23070] = 5,
    ACTIONS(1334), 1,
      anon_sym_LF,
    ACTIONS(1336), 1,
      anon_sym_SEMI,
    ACTIONS(1338), 1,
      anon_sym_RBRACE,
    STATE(21), 1,
      aux_sym__commands_repeat1,
    STATE(678), 1,
      aux_sym__commands_repeat2,
  [23086] = 5,
    ACTIONS(145), 1,
      ts_builtin_sym_end,
    ACTIONS(1296), 1,
      anon_sym_LF,
    ACTIONS(1298), 1,
      anon_sym_SEMI,
    STATE(18), 1,
      aux_sym__commands_repeat1,
    STATE(681), 1,
      aux_sym__commands_repeat2,
  [23102] = 4,
    ACTIONS(1175), 1,
      anon_sym_finally,
    ACTIONS(1258), 1,
      anon_sym_LF,
    STATE(789), 1,
      sym_finally,
    ACTIONS(1260), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23116] = 2,
    ACTIONS(1230), 1,
      anon_sym_LF,
    ACTIONS(1232), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_elseif,
      anon_sym_else,
  [23126] = 5,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    ACTIONS(1340), 1,
      anon_sym_LF,
    ACTIONS(1342), 1,
      anon_sym_SEMI,
    STATE(13), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [23142] = 4,
    ACTIONS(1193), 1,
      sym_simple_word,
    ACTIONS(1195), 1,
      anon_sym_LBRACE,
    ACTIONS(1344), 1,
      anon_sym_RBRACE,
    STATE(691), 2,
      sym_argument,
      aux_sym_arguments_repeat1,
  [23156] = 5,
    ACTIONS(107), 1,
      anon_sym_RBRACE,
    ACTIONS(1346), 1,
      anon_sym_LF,
    ACTIONS(1348), 1,
      anon_sym_SEMI,
    STATE(11), 1,
      aux_sym__commands_repeat1,
    STATE(684), 1,
      aux_sym__commands_repeat2,
  [23172] = 5,
    ACTIONS(107), 1,
      anon_sym_RBRACE,
    ACTIONS(1346), 1,
      anon_sym_LF,
    ACTIONS(1348), 1,
      anon_sym_SEMI,
    STATE(11), 1,
      aux_sym__commands_repeat1,
    STATE(692), 1,
      aux_sym__commands_repeat2,
  [23188] = 4,
    ACTIONS(1350), 1,
      sym__ident,
    ACTIONS(1352), 1,
      anon_sym_LBRACE,
    ACTIONS(1354), 1,
      sym__ns_delim,
    STATE(498), 1,
      sym_id,
  [23201] = 4,
    ACTIONS(1356), 1,
      sym__ident,
    ACTIONS(1358), 1,
      anon_sym_LBRACE,
    ACTIONS(1360), 1,
      sym__ns_delim,
    STATE(442), 1,
      sym_id,
  [23214] = 4,
    ACTIONS(1362), 1,
      sym__ident,
    ACTIONS(1364), 1,
      anon_sym_LBRACE,
    ACTIONS(1366), 1,
      sym__ns_delim,
    STATE(72), 1,
      sym_id,
  [23227] = 4,
    ACTIONS(1368), 1,
      sym__ident,
    ACTIONS(1370), 1,
      anon_sym_LBRACE,
    ACTIONS(1372), 1,
      sym__ns_delim,
    STATE(340), 1,
      sym_id,
  [23240] = 4,
    ACTIONS(1374), 1,
      sym__ident,
    ACTIONS(1376), 1,
      anon_sym_LBRACE,
    ACTIONS(1378), 1,
      sym__ns_delim,
    STATE(630), 1,
      sym_id,
  [23253] = 4,
    ACTIONS(1380), 1,
      sym__ident,
    ACTIONS(1382), 1,
      anon_sym_LBRACE,
    ACTIONS(1384), 1,
      sym__ns_delim,
    STATE(71), 1,
      sym_id,
  [23266] = 4,
    ACTIONS(1386), 1,
      sym__ident,
    ACTIONS(1388), 1,
      anon_sym_LBRACE,
    ACTIONS(1390), 1,
      sym__ns_delim,
    STATE(116), 1,
      sym_id,
  [23279] = 4,
    ACTIONS(1392), 1,
      sym__ident,
    ACTIONS(1394), 1,
      anon_sym_LBRACE,
    ACTIONS(1396), 1,
      sym__ns_delim,
    STATE(70), 1,
      sym_id,
  [23292] = 4,
    ACTIONS(1398), 1,
      sym__ident,
    ACTIONS(1400), 1,
      anon_sym_LBRACE,
    ACTIONS(1402), 1,
      sym__ns_delim,
    STATE(510), 1,
      sym_id,
  [23305] = 4,
    ACTIONS(1185), 1,
      anon_sym_RBRACK,
    ACTIONS(1404), 1,
      anon_sym_on,
    ACTIONS(1406), 1,
      anon_sym_finally,
    STATE(839), 1,
      sym_finally,
  [23318] = 4,
    ACTIONS(1169), 1,
      anon_sym_RBRACK,
    ACTIONS(1406), 1,
      anon_sym_finally,
    ACTIONS(1408), 1,
      anon_sym_on,
    STATE(833), 1,
      sym_finally,
  [23331] = 4,
    ACTIONS(1410), 1,
      sym__ident,
    ACTIONS(1412), 1,
      anon_sym_LBRACE,
    ACTIONS(1414), 1,
      sym__ns_delim,
    STATE(335), 1,
      sym_id,
  [23344] = 3,
    ACTIONS(1258), 1,
      anon_sym_RBRACK,
    ACTIONS(1406), 1,
      anon_sym_finally,
    STATE(831), 1,
      sym_finally,
  [23354] = 2,
    ACTIONS(1418), 1,
      anon_sym_SEMI,
    ACTIONS(1416), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23362] = 2,
    ACTIONS(1416), 1,
      anon_sym_LF,
    ACTIONS(1418), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23370] = 2,
    ACTIONS(1420), 1,
      anon_sym_LF,
    ACTIONS(1422), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23378] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(406), 1,
      sym_arguments,
  [23388] = 2,
    ACTIONS(1428), 1,
      anon_sym_LF,
    ACTIONS(1430), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23396] = 3,
    ACTIONS(1432), 1,
      sym_simple_word,
    ACTIONS(1434), 1,
      anon_sym_LBRACE,
    STATE(367), 1,
      sym_arguments,
  [23406] = 2,
    ACTIONS(1438), 1,
      anon_sym_SEMI,
    ACTIONS(1436), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23414] = 2,
    ACTIONS(1440), 1,
      anon_sym_LF,
    ACTIONS(1442), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23422] = 2,
    ACTIONS(1444), 1,
      anon_sym_LF,
    ACTIONS(1446), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23430] = 3,
    ACTIONS(1432), 1,
      sym_simple_word,
    ACTIONS(1434), 1,
      anon_sym_LBRACE,
    STATE(370), 1,
      sym_arguments,
  [23440] = 2,
    ACTIONS(1450), 1,
      anon_sym_SEMI,
    ACTIONS(1448), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23448] = 2,
    ACTIONS(1454), 1,
      anon_sym_SEMI,
    ACTIONS(1452), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23456] = 2,
    ACTIONS(1456), 1,
      anon_sym_LF,
    ACTIONS(1458), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23464] = 2,
    ACTIONS(1460), 1,
      anon_sym_LF,
    ACTIONS(1462), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23472] = 2,
    ACTIONS(1464), 1,
      anon_sym_LF,
    ACTIONS(1466), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23480] = 2,
    ACTIONS(1468), 1,
      anon_sym_LF,
    ACTIONS(1470), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23488] = 2,
    ACTIONS(1472), 1,
      anon_sym_LF,
    ACTIONS(1474), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23496] = 3,
    ACTIONS(1203), 1,
      anon_sym_RBRACK,
    ACTIONS(1406), 1,
      anon_sym_finally,
    STATE(847), 1,
      sym_finally,
  [23506] = 2,
    ACTIONS(1476), 1,
      anon_sym_LF,
    ACTIONS(1478), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23514] = 2,
    ACTIONS(1164), 1,
      anon_sym_LF,
    ACTIONS(1162), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23522] = 2,
    ACTIONS(1185), 1,
      anon_sym_LF,
    ACTIONS(1187), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23530] = 2,
    ACTIONS(1244), 1,
      anon_sym_LF,
    ACTIONS(1246), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23538] = 2,
    ACTIONS(1480), 1,
      anon_sym_LF,
    ACTIONS(1482), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23546] = 2,
    ACTIONS(1436), 1,
      anon_sym_LF,
    ACTIONS(1438), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23554] = 2,
    ACTIONS(1061), 1,
      anon_sym_LF,
    ACTIONS(1063), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23562] = 2,
    ACTIONS(1442), 1,
      anon_sym_SEMI,
    ACTIONS(1440), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23570] = 2,
    ACTIONS(1484), 1,
      anon_sym_LF,
    ACTIONS(1486), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23578] = 2,
    ACTIONS(1234), 1,
      anon_sym_LF,
    ACTIONS(1328), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23586] = 2,
    ACTIONS(1488), 1,
      anon_sym_LF,
    ACTIONS(1490), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23594] = 2,
    ACTIONS(997), 1,
      anon_sym_SEMI,
    ACTIONS(995), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23602] = 2,
    ACTIONS(1494), 1,
      anon_sym_SEMI,
    ACTIONS(1492), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23610] = 2,
    ACTIONS(1430), 1,
      anon_sym_SEMI,
    ACTIONS(1428), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23618] = 2,
    ACTIONS(1446), 1,
      anon_sym_SEMI,
    ACTIONS(1444), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23626] = 2,
    ACTIONS(1462), 1,
      anon_sym_SEMI,
    ACTIONS(1460), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23634] = 2,
    ACTIONS(1482), 1,
      anon_sym_SEMI,
    ACTIONS(1480), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23642] = 2,
    ACTIONS(1162), 1,
      anon_sym_SEMI,
    ACTIONS(1164), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23650] = 2,
    ACTIONS(1187), 1,
      anon_sym_SEMI,
    ACTIONS(1185), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23658] = 2,
    ACTIONS(1498), 1,
      anon_sym_SEMI,
    ACTIONS(1496), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23666] = 2,
    ACTIONS(1492), 1,
      anon_sym_LF,
    ACTIONS(1494), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23674] = 2,
    ACTIONS(995), 1,
      anon_sym_LF,
    ACTIONS(997), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23682] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(376), 1,
      sym_arguments,
  [23692] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(378), 1,
      sym_arguments,
  [23702] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(380), 1,
      sym_arguments,
  [23712] = 2,
    ACTIONS(1246), 1,
      anon_sym_SEMI,
    ACTIONS(1244), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23720] = 2,
    ACTIONS(1502), 1,
      anon_sym_SEMI,
    ACTIONS(1500), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23728] = 1,
    ACTIONS(1504), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_simple_word,
  [23734] = 2,
    ACTIONS(1506), 1,
      anon_sym_LF,
    ACTIONS(1508), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23742] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_arguments,
  [23752] = 2,
    ACTIONS(1232), 1,
      anon_sym_else,
    ACTIONS(1230), 2,
      anon_sym_elseif,
      anon_sym_RBRACK,
  [23760] = 2,
    ACTIONS(1512), 1,
      anon_sym_SEMI,
    ACTIONS(1510), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23768] = 3,
    ACTIONS(1244), 1,
      anon_sym_RBRACK,
    ACTIONS(1406), 1,
      anon_sym_finally,
    STATE(836), 1,
      sym_finally,
  [23778] = 3,
    ACTIONS(1432), 1,
      sym_simple_word,
    ACTIONS(1434), 1,
      anon_sym_LBRACE,
    STATE(366), 1,
      sym_arguments,
  [23788] = 2,
    ACTIONS(1258), 1,
      anon_sym_LF,
    ACTIONS(1260), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23796] = 2,
    ACTIONS(1490), 1,
      anon_sym_SEMI,
    ACTIONS(1488), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23804] = 2,
    ACTIONS(1260), 1,
      anon_sym_SEMI,
    ACTIONS(1258), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23812] = 2,
    ACTIONS(1474), 1,
      anon_sym_SEMI,
    ACTIONS(1472), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23820] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(391), 1,
      sym_arguments,
  [23830] = 2,
    ACTIONS(1452), 1,
      anon_sym_LF,
    ACTIONS(1454), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23838] = 2,
    ACTIONS(1256), 1,
      anon_sym_else,
    ACTIONS(1254), 2,
      anon_sym_elseif,
      anon_sym_RBRACK,
  [23846] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(393), 1,
      sym_arguments,
  [23856] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(395), 1,
      sym_arguments,
  [23866] = 2,
    ACTIONS(1328), 1,
      anon_sym_SEMI,
    ACTIONS(1234), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23874] = 2,
    ACTIONS(1516), 1,
      anon_sym_SEMI,
    ACTIONS(1514), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23882] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(408), 1,
      sym_arguments,
  [23892] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(397), 1,
      sym_arguments,
  [23902] = 2,
    ACTIONS(1470), 1,
      anon_sym_SEMI,
    ACTIONS(1468), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23910] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(386), 1,
      sym_arguments,
  [23920] = 2,
    ACTIONS(1466), 1,
      anon_sym_SEMI,
    ACTIONS(1464), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23928] = 2,
    ACTIONS(1514), 1,
      anon_sym_LF,
    ACTIONS(1516), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23936] = 2,
    ACTIONS(1510), 1,
      anon_sym_LF,
    ACTIONS(1512), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23944] = 2,
    ACTIONS(1508), 1,
      anon_sym_SEMI,
    ACTIONS(1506), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23952] = 3,
    ACTIONS(1424), 1,
      sym_simple_word,
    ACTIONS(1426), 1,
      anon_sym_LBRACE,
    STATE(420), 1,
      sym_arguments,
  [23962] = 2,
    ACTIONS(1478), 1,
      anon_sym_SEMI,
    ACTIONS(1476), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [23970] = 2,
    ACTIONS(1518), 1,
      anon_sym_LF,
    ACTIONS(1520), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23978] = 2,
    ACTIONS(1500), 1,
      anon_sym_LF,
    ACTIONS(1502), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [23986] = 1,
    ACTIONS(1522), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_simple_word,
  [23992] = 2,
    ACTIONS(1448), 1,
      anon_sym_LF,
    ACTIONS(1450), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [24000] = 2,
    ACTIONS(1458), 1,
      anon_sym_SEMI,
    ACTIONS(1456), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [24008] = 2,
    ACTIONS(1520), 1,
      anon_sym_SEMI,
    ACTIONS(1518), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [24016] = 1,
    ACTIONS(1524), 3,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_simple_word,
  [24022] = 2,
    ACTIONS(1063), 1,
      anon_sym_SEMI,
    ACTIONS(1061), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [24030] = 2,
    ACTIONS(1486), 1,
      anon_sym_SEMI,
    ACTIONS(1484), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [24038] = 2,
    ACTIONS(1496), 1,
      anon_sym_LF,
    ACTIONS(1498), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [24046] = 2,
    ACTIONS(1422), 1,
      anon_sym_SEMI,
    ACTIONS(1420), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
  [24054] = 1,
    ACTIONS(1452), 1,
      anon_sym_RBRACK,
  [24058] = 1,
    ACTIONS(1526), 1,
      sym__ident,
  [24062] = 1,
    ACTIONS(1528), 1,
      anon_sym_RBRACE,
  [24066] = 1,
    ACTIONS(1530), 1,
      anon_sym_RPAREN,
  [24070] = 1,
    ACTIONS(1532), 1,
      sym__ident,
  [24074] = 1,
    ACTIONS(1061), 1,
      anon_sym_RBRACK,
  [24078] = 1,
    ACTIONS(1534), 1,
      anon_sym_RBRACK,
  [24082] = 1,
    ACTIONS(1536), 1,
      sym__ident,
  [24086] = 1,
    ACTIONS(1538), 1,
      anon_sym_RBRACE,
  [24090] = 1,
    ACTIONS(1540), 1,
      anon_sym_RPAREN,
  [24094] = 1,
    ACTIONS(1542), 1,
      anon_sym_RBRACK,
  [24098] = 1,
    ACTIONS(1544), 1,
      anon_sym_RBRACK,
  [24102] = 1,
    ACTIONS(1546), 1,
      sym__ident,
  [24106] = 1,
    ACTIONS(1436), 1,
      anon_sym_RBRACK,
  [24110] = 1,
    ACTIONS(1548), 1,
      anon_sym_RBRACE,
  [24114] = 1,
    ACTIONS(1550), 1,
      anon_sym_RBRACK,
  [24118] = 1,
    ACTIONS(1552), 1,
      sym__ident,
  [24122] = 1,
    ACTIONS(1554), 1,
      anon_sym_RBRACE,
  [24126] = 1,
    ACTIONS(1556), 1,
      anon_sym_RPAREN,
  [24130] = 1,
    ACTIONS(1558), 1,
      anon_sym_RPAREN,
  [24134] = 1,
    ACTIONS(1560), 1,
      sym__ident,
  [24138] = 1,
    ACTIONS(1562), 1,
      sym__ident,
  [24142] = 1,
    ACTIONS(1564), 1,
      anon_sym_RPAREN,
  [24146] = 1,
    ACTIONS(1566), 1,
      anon_sym_RBRACK,
  [24150] = 1,
    ACTIONS(1568), 1,
      sym__ident,
  [24154] = 1,
    ACTIONS(1570), 1,
      anon_sym_RBRACE,
  [24158] = 1,
    ACTIONS(1572), 1,
      anon_sym_RPAREN,
  [24162] = 1,
    ACTIONS(1574), 1,
      anon_sym_RBRACK,
  [24166] = 1,
    ACTIONS(1576), 1,
      sym__ident,
  [24170] = 1,
    ACTIONS(1578), 1,
      anon_sym_RBRACE,
  [24174] = 1,
    ACTIONS(1580), 1,
      sym__ident,
  [24178] = 1,
    ACTIONS(1518), 1,
      anon_sym_RBRACK,
  [24182] = 1,
    ACTIONS(1480), 1,
      anon_sym_RBRACK,
  [24186] = 1,
    ACTIONS(1185), 1,
      anon_sym_RBRACK,
  [24190] = 1,
    ACTIONS(1582), 1,
      aux_sym_variable_substitution_token1,
  [24194] = 1,
    ACTIONS(1584), 1,
      anon_sym_RBRACE,
  [24198] = 1,
    ACTIONS(1258), 1,
      anon_sym_RBRACK,
  [24202] = 1,
    ACTIONS(1586), 1,
      sym__ident,
  [24206] = 1,
    ACTIONS(1588), 1,
      anon_sym_RBRACK,
  [24210] = 1,
    ACTIONS(1514), 1,
      anon_sym_RBRACK,
  [24214] = 1,
    ACTIONS(1456), 1,
      anon_sym_RBRACK,
  [24218] = 1,
    ACTIONS(1590), 1,
      anon_sym_RPAREN,
  [24222] = 1,
    ACTIONS(1592), 1,
      sym__ident,
  [24226] = 1,
    ACTIONS(1476), 1,
      anon_sym_RBRACK,
  [24230] = 1,
    ACTIONS(995), 1,
      anon_sym_RBRACK,
  [24234] = 1,
    ACTIONS(1594), 1,
      anon_sym_RPAREN,
  [24238] = 1,
    ACTIONS(1596), 1,
      sym_simple_word,
  [24242] = 1,
    ACTIONS(1244), 1,
      anon_sym_RBRACK,
  [24246] = 1,
    ACTIONS(1598), 1,
      aux_sym_variable_substitution_token1,
  [24250] = 1,
    ACTIONS(1600), 1,
      sym__ident,
  [24254] = 1,
    ACTIONS(1602), 1,
      anon_sym_RBRACE,
  [24258] = 1,
    ACTIONS(1604), 1,
      sym__ident,
  [24262] = 1,
    ACTIONS(1606), 1,
      aux_sym_variable_substitution_token1,
  [24266] = 1,
    ACTIONS(1460), 1,
      anon_sym_RBRACK,
  [24270] = 1,
    ACTIONS(1608), 1,
      anon_sym_RBRACK,
  [24274] = 1,
    ACTIONS(307), 1,
      anon_sym_RBRACE,
  [24278] = 1,
    ACTIONS(1610), 1,
      sym__ident,
  [24282] = 1,
    ACTIONS(1444), 1,
      anon_sym_RBRACK,
  [24286] = 1,
    ACTIONS(311), 1,
      anon_sym_RBRACE,
  [24290] = 1,
    ACTIONS(1612), 1,
      anon_sym_RPAREN,
  [24294] = 1,
    ACTIONS(1416), 1,
      anon_sym_RBRACK,
  [24298] = 1,
    ACTIONS(1472), 1,
      anon_sym_RBRACK,
  [24302] = 1,
    ACTIONS(1488), 1,
      anon_sym_RBRACK,
  [24306] = 1,
    ACTIONS(1614), 1,
      anon_sym_error,
  [24310] = 1,
    ACTIONS(1484), 1,
      anon_sym_RBRACK,
  [24314] = 1,
    ACTIONS(1616), 1,
      anon_sym_RBRACE,
  [24318] = 1,
    ACTIONS(1618), 1,
      aux_sym_variable_substitution_token1,
  [24322] = 1,
    ACTIONS(1468), 1,
      anon_sym_RBRACK,
  [24326] = 1,
    ACTIONS(1620), 1,
      sym__ident,
  [24330] = 1,
    ACTIONS(1622), 1,
      ts_builtin_sym_end,
  [24334] = 1,
    ACTIONS(1624), 1,
      sym__ident,
  [24338] = 1,
    ACTIONS(1464), 1,
      anon_sym_RBRACK,
  [24342] = 1,
    ACTIONS(1626), 1,
      aux_sym_variable_substitution_token1,
  [24346] = 1,
    ACTIONS(1628), 1,
      anon_sym_RBRACK,
  [24350] = 1,
    ACTIONS(1630), 1,
      sym__ident,
  [24354] = 1,
    ACTIONS(1440), 1,
      anon_sym_RBRACK,
  [24358] = 1,
    ACTIONS(1632), 1,
      aux_sym_variable_substitution_token1,
  [24362] = 1,
    ACTIONS(1634), 1,
      anon_sym_error,
  [24366] = 1,
    ACTIONS(1636), 1,
      anon_sym_RBRACE,
  [24370] = 1,
    ACTIONS(1500), 1,
      anon_sym_RBRACK,
  [24374] = 1,
    ACTIONS(1638), 1,
      aux_sym_variable_substitution_token1,
  [24378] = 1,
    ACTIONS(1420), 1,
      anon_sym_RBRACK,
  [24382] = 1,
    ACTIONS(1428), 1,
      anon_sym_RBRACK,
  [24386] = 1,
    ACTIONS(1640), 1,
      aux_sym_variable_substitution_token1,
  [24390] = 1,
    ACTIONS(1506), 1,
      anon_sym_RBRACK,
  [24394] = 1,
    ACTIONS(1642), 1,
      sym__ident,
  [24398] = 1,
    ACTIONS(1644), 1,
      aux_sym_variable_substitution_token1,
  [24402] = 1,
    ACTIONS(1492), 1,
      anon_sym_RBRACK,
  [24406] = 1,
    ACTIONS(1646), 1,
      anon_sym_RPAREN,
  [24410] = 1,
    ACTIONS(1648), 1,
      aux_sym_variable_substitution_token1,
  [24414] = 1,
    ACTIONS(1650), 1,
      anon_sym_RBRACK,
  [24418] = 1,
    ACTIONS(1652), 1,
      anon_sym_RBRACE,
  [24422] = 1,
    ACTIONS(1496), 1,
      anon_sym_RBRACK,
  [24426] = 1,
    ACTIONS(1510), 1,
      anon_sym_RBRACK,
  [24430] = 1,
    ACTIONS(1654), 1,
      anon_sym_error,
  [24434] = 1,
    ACTIONS(1656), 1,
      anon_sym_error,
  [24438] = 1,
    ACTIONS(1658), 1,
      sym__ident,
  [24442] = 1,
    ACTIONS(1448), 1,
      anon_sym_RBRACK,
  [24446] = 1,
    ACTIONS(1164), 1,
      anon_sym_RBRACK,
  [24450] = 1,
    ACTIONS(1660), 1,
      anon_sym_error,
  [24454] = 1,
    ACTIONS(1662), 1,
      anon_sym_error,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 86,
  [SMALL_STATE(4)] = 172,
  [SMALL_STATE(5)] = 258,
  [SMALL_STATE(6)] = 344,
  [SMALL_STATE(7)] = 430,
  [SMALL_STATE(8)] = 516,
  [SMALL_STATE(9)] = 602,
  [SMALL_STATE(10)] = 688,
  [SMALL_STATE(11)] = 774,
  [SMALL_STATE(12)] = 860,
  [SMALL_STATE(13)] = 946,
  [SMALL_STATE(14)] = 1032,
  [SMALL_STATE(15)] = 1118,
  [SMALL_STATE(16)] = 1204,
  [SMALL_STATE(17)] = 1290,
  [SMALL_STATE(18)] = 1376,
  [SMALL_STATE(19)] = 1462,
  [SMALL_STATE(20)] = 1548,
  [SMALL_STATE(21)] = 1634,
  [SMALL_STATE(22)] = 1720,
  [SMALL_STATE(23)] = 1806,
  [SMALL_STATE(24)] = 1892,
  [SMALL_STATE(25)] = 1978,
  [SMALL_STATE(26)] = 2064,
  [SMALL_STATE(27)] = 2150,
  [SMALL_STATE(28)] = 2236,
  [SMALL_STATE(29)] = 2322,
  [SMALL_STATE(30)] = 2405,
  [SMALL_STATE(31)] = 2488,
  [SMALL_STATE(32)] = 2571,
  [SMALL_STATE(33)] = 2654,
  [SMALL_STATE(34)] = 2737,
  [SMALL_STATE(35)] = 2820,
  [SMALL_STATE(36)] = 2903,
  [SMALL_STATE(37)] = 2986,
  [SMALL_STATE(38)] = 3069,
  [SMALL_STATE(39)] = 3113,
  [SMALL_STATE(40)] = 3191,
  [SMALL_STATE(41)] = 3269,
  [SMALL_STATE(42)] = 3347,
  [SMALL_STATE(43)] = 3425,
  [SMALL_STATE(44)] = 3503,
  [SMALL_STATE(45)] = 3547,
  [SMALL_STATE(46)] = 3625,
  [SMALL_STATE(47)] = 3703,
  [SMALL_STATE(48)] = 3747,
  [SMALL_STATE(49)] = 3791,
  [SMALL_STATE(50)] = 3835,
  [SMALL_STATE(51)] = 3879,
  [SMALL_STATE(52)] = 3957,
  [SMALL_STATE(53)] = 4001,
  [SMALL_STATE(54)] = 4045,
  [SMALL_STATE(55)] = 4089,
  [SMALL_STATE(56)] = 4167,
  [SMALL_STATE(57)] = 4211,
  [SMALL_STATE(58)] = 4255,
  [SMALL_STATE(59)] = 4299,
  [SMALL_STATE(60)] = 4343,
  [SMALL_STATE(61)] = 4387,
  [SMALL_STATE(62)] = 4431,
  [SMALL_STATE(63)] = 4509,
  [SMALL_STATE(64)] = 4552,
  [SMALL_STATE(65)] = 4595,
  [SMALL_STATE(66)] = 4634,
  [SMALL_STATE(67)] = 4673,
  [SMALL_STATE(68)] = 4718,
  [SMALL_STATE(69)] = 4757,
  [SMALL_STATE(70)] = 4800,
  [SMALL_STATE(71)] = 4843,
  [SMALL_STATE(72)] = 4886,
  [SMALL_STATE(73)] = 4929,
  [SMALL_STATE(74)] = 4971,
  [SMALL_STATE(75)] = 5013,
  [SMALL_STATE(76)] = 5055,
  [SMALL_STATE(77)] = 5097,
  [SMALL_STATE(78)] = 5139,
  [SMALL_STATE(79)] = 5181,
  [SMALL_STATE(80)] = 5223,
  [SMALL_STATE(81)] = 5265,
  [SMALL_STATE(82)] = 5307,
  [SMALL_STATE(83)] = 5344,
  [SMALL_STATE(84)] = 5381,
  [SMALL_STATE(85)] = 5418,
  [SMALL_STATE(86)] = 5455,
  [SMALL_STATE(87)] = 5492,
  [SMALL_STATE(88)] = 5529,
  [SMALL_STATE(89)] = 5566,
  [SMALL_STATE(90)] = 5603,
  [SMALL_STATE(91)] = 5640,
  [SMALL_STATE(92)] = 5677,
  [SMALL_STATE(93)] = 5714,
  [SMALL_STATE(94)] = 5751,
  [SMALL_STATE(95)] = 5788,
  [SMALL_STATE(96)] = 5825,
  [SMALL_STATE(97)] = 5862,
  [SMALL_STATE(98)] = 5903,
  [SMALL_STATE(99)] = 5940,
  [SMALL_STATE(100)] = 5977,
  [SMALL_STATE(101)] = 6018,
  [SMALL_STATE(102)] = 6059,
  [SMALL_STATE(103)] = 6100,
  [SMALL_STATE(104)] = 6137,
  [SMALL_STATE(105)] = 6174,
  [SMALL_STATE(106)] = 6211,
  [SMALL_STATE(107)] = 6248,
  [SMALL_STATE(108)] = 6289,
  [SMALL_STATE(109)] = 6353,
  [SMALL_STATE(110)] = 6401,
  [SMALL_STATE(111)] = 6437,
  [SMALL_STATE(112)] = 6479,
  [SMALL_STATE(113)] = 6515,
  [SMALL_STATE(114)] = 6551,
  [SMALL_STATE(115)] = 6613,
  [SMALL_STATE(116)] = 6673,
  [SMALL_STATE(117)] = 6713,
  [SMALL_STATE(118)] = 6753,
  [SMALL_STATE(119)] = 6811,
  [SMALL_STATE(120)] = 6847,
  [SMALL_STATE(121)] = 6903,
  [SMALL_STATE(122)] = 6957,
  [SMALL_STATE(123)] = 7009,
  [SMALL_STATE(124)] = 7045,
  [SMALL_STATE(125)] = 7081,
  [SMALL_STATE(126)] = 7117,
  [SMALL_STATE(127)] = 7163,
  [SMALL_STATE(128)] = 7203,
  [SMALL_STATE(129)] = 7239,
  [SMALL_STATE(130)] = 7277,
  [SMALL_STATE(131)] = 7319,
  [SMALL_STATE(132)] = 7363,
  [SMALL_STATE(133)] = 7402,
  [SMALL_STATE(134)] = 7441,
  [SMALL_STATE(135)] = 7482,
  [SMALL_STATE(136)] = 7521,
  [SMALL_STATE(137)] = 7562,
  [SMALL_STATE(138)] = 7596,
  [SMALL_STATE(139)] = 7630,
  [SMALL_STATE(140)] = 7664,
  [SMALL_STATE(141)] = 7698,
  [SMALL_STATE(142)] = 7732,
  [SMALL_STATE(143)] = 7766,
  [SMALL_STATE(144)] = 7800,
  [SMALL_STATE(145)] = 7833,
  [SMALL_STATE(146)] = 7894,
  [SMALL_STATE(147)] = 7927,
  [SMALL_STATE(148)] = 7960,
  [SMALL_STATE(149)] = 7993,
  [SMALL_STATE(150)] = 8032,
  [SMALL_STATE(151)] = 8065,
  [SMALL_STATE(152)] = 8100,
  [SMALL_STATE(153)] = 8141,
  [SMALL_STATE(154)] = 8174,
  [SMALL_STATE(155)] = 8217,
  [SMALL_STATE(156)] = 8264,
  [SMALL_STATE(157)] = 8313,
  [SMALL_STATE(158)] = 8346,
  [SMALL_STATE(159)] = 8399,
  [SMALL_STATE(160)] = 8454,
  [SMALL_STATE(161)] = 8511,
  [SMALL_STATE(162)] = 8568,
  [SMALL_STATE(163)] = 8627,
  [SMALL_STATE(164)] = 8659,
  [SMALL_STATE(165)] = 8709,
  [SMALL_STATE(166)] = 8761,
  [SMALL_STATE(167)] = 8815,
  [SMALL_STATE(168)] = 8871,
  [SMALL_STATE(169)] = 8931,
  [SMALL_STATE(170)] = 8963,
  [SMALL_STATE(171)] = 9017,
  [SMALL_STATE(172)] = 9049,
  [SMALL_STATE(173)] = 9081,
  [SMALL_STATE(174)] = 9121,
  [SMALL_STATE(175)] = 9157,
  [SMALL_STATE(176)] = 9199,
  [SMALL_STATE(177)] = 9243,
  [SMALL_STATE(178)] = 9277,
  [SMALL_STATE(179)] = 9309,
  [SMALL_STATE(180)] = 9341,
  [SMALL_STATE(181)] = 9377,
  [SMALL_STATE(182)] = 9409,
  [SMALL_STATE(183)] = 9447,
  [SMALL_STATE(184)] = 9499,
  [SMALL_STATE(185)] = 9547,
  [SMALL_STATE(186)] = 9605,
  [SMALL_STATE(187)] = 9637,
  [SMALL_STATE(188)] = 9687,
  [SMALL_STATE(189)] = 9735,
  [SMALL_STATE(190)] = 9767,
  [SMALL_STATE(191)] = 9811,
  [SMALL_STATE(192)] = 9845,
  [SMALL_STATE(193)] = 9877,
  [SMALL_STATE(194)] = 9909,
  [SMALL_STATE(195)] = 9947,
  [SMALL_STATE(196)] = 9979,
  [SMALL_STATE(197)] = 10011,
  [SMALL_STATE(198)] = 10051,
  [SMALL_STATE(199)] = 10111,
  [SMALL_STATE(200)] = 10153,
  [SMALL_STATE(201)] = 10211,
  [SMALL_STATE(202)] = 10267,
  [SMALL_STATE(203)] = 10299,
  [SMALL_STATE(204)] = 10359,
  [SMALL_STATE(205)] = 10419,
  [SMALL_STATE(206)] = 10479,
  [SMALL_STATE(207)] = 10539,
  [SMALL_STATE(208)] = 10599,
  [SMALL_STATE(209)] = 10659,
  [SMALL_STATE(210)] = 10719,
  [SMALL_STATE(211)] = 10779,
  [SMALL_STATE(212)] = 10839,
  [SMALL_STATE(213)] = 10899,
  [SMALL_STATE(214)] = 10959,
  [SMALL_STATE(215)] = 11019,
  [SMALL_STATE(216)] = 11079,
  [SMALL_STATE(217)] = 11139,
  [SMALL_STATE(218)] = 11199,
  [SMALL_STATE(219)] = 11259,
  [SMALL_STATE(220)] = 11319,
  [SMALL_STATE(221)] = 11350,
  [SMALL_STATE(222)] = 11379,
  [SMALL_STATE(223)] = 11422,
  [SMALL_STATE(224)] = 11465,
  [SMALL_STATE(225)] = 11508,
  [SMALL_STATE(226)] = 11551,
  [SMALL_STATE(227)] = 11594,
  [SMALL_STATE(228)] = 11637,
  [SMALL_STATE(229)] = 11680,
  [SMALL_STATE(230)] = 11723,
  [SMALL_STATE(231)] = 11766,
  [SMALL_STATE(232)] = 11809,
  [SMALL_STATE(233)] = 11852,
  [SMALL_STATE(234)] = 11895,
  [SMALL_STATE(235)] = 11932,
  [SMALL_STATE(236)] = 11969,
  [SMALL_STATE(237)] = 12006,
  [SMALL_STATE(238)] = 12043,
  [SMALL_STATE(239)] = 12080,
  [SMALL_STATE(240)] = 12117,
  [SMALL_STATE(241)] = 12154,
  [SMALL_STATE(242)] = 12191,
  [SMALL_STATE(243)] = 12228,
  [SMALL_STATE(244)] = 12265,
  [SMALL_STATE(245)] = 12302,
  [SMALL_STATE(246)] = 12339,
  [SMALL_STATE(247)] = 12376,
  [SMALL_STATE(248)] = 12413,
  [SMALL_STATE(249)] = 12450,
  [SMALL_STATE(250)] = 12487,
  [SMALL_STATE(251)] = 12524,
  [SMALL_STATE(252)] = 12561,
  [SMALL_STATE(253)] = 12598,
  [SMALL_STATE(254)] = 12635,
  [SMALL_STATE(255)] = 12672,
  [SMALL_STATE(256)] = 12709,
  [SMALL_STATE(257)] = 12746,
  [SMALL_STATE(258)] = 12783,
  [SMALL_STATE(259)] = 12820,
  [SMALL_STATE(260)] = 12857,
  [SMALL_STATE(261)] = 12894,
  [SMALL_STATE(262)] = 12931,
  [SMALL_STATE(263)] = 12968,
  [SMALL_STATE(264)] = 13005,
  [SMALL_STATE(265)] = 13042,
  [SMALL_STATE(266)] = 13079,
  [SMALL_STATE(267)] = 13116,
  [SMALL_STATE(268)] = 13153,
  [SMALL_STATE(269)] = 13190,
  [SMALL_STATE(270)] = 13227,
  [SMALL_STATE(271)] = 13264,
  [SMALL_STATE(272)] = 13301,
  [SMALL_STATE(273)] = 13338,
  [SMALL_STATE(274)] = 13375,
  [SMALL_STATE(275)] = 13412,
  [SMALL_STATE(276)] = 13449,
  [SMALL_STATE(277)] = 13486,
  [SMALL_STATE(278)] = 13523,
  [SMALL_STATE(279)] = 13560,
  [SMALL_STATE(280)] = 13597,
  [SMALL_STATE(281)] = 13634,
  [SMALL_STATE(282)] = 13671,
  [SMALL_STATE(283)] = 13708,
  [SMALL_STATE(284)] = 13745,
  [SMALL_STATE(285)] = 13782,
  [SMALL_STATE(286)] = 13819,
  [SMALL_STATE(287)] = 13856,
  [SMALL_STATE(288)] = 13893,
  [SMALL_STATE(289)] = 13930,
  [SMALL_STATE(290)] = 13967,
  [SMALL_STATE(291)] = 14004,
  [SMALL_STATE(292)] = 14041,
  [SMALL_STATE(293)] = 14078,
  [SMALL_STATE(294)] = 14115,
  [SMALL_STATE(295)] = 14152,
  [SMALL_STATE(296)] = 14189,
  [SMALL_STATE(297)] = 14226,
  [SMALL_STATE(298)] = 14263,
  [SMALL_STATE(299)] = 14300,
  [SMALL_STATE(300)] = 14337,
  [SMALL_STATE(301)] = 14374,
  [SMALL_STATE(302)] = 14411,
  [SMALL_STATE(303)] = 14448,
  [SMALL_STATE(304)] = 14485,
  [SMALL_STATE(305)] = 14522,
  [SMALL_STATE(306)] = 14559,
  [SMALL_STATE(307)] = 14597,
  [SMALL_STATE(308)] = 14637,
  [SMALL_STATE(309)] = 14677,
  [SMALL_STATE(310)] = 14715,
  [SMALL_STATE(311)] = 14750,
  [SMALL_STATE(312)] = 14785,
  [SMALL_STATE(313)] = 14822,
  [SMALL_STATE(314)] = 14859,
  [SMALL_STATE(315)] = 14897,
  [SMALL_STATE(316)] = 14935,
  [SMALL_STATE(317)] = 14970,
  [SMALL_STATE(318)] = 14993,
  [SMALL_STATE(319)] = 15028,
  [SMALL_STATE(320)] = 15051,
  [SMALL_STATE(321)] = 15074,
  [SMALL_STATE(322)] = 15109,
  [SMALL_STATE(323)] = 15132,
  [SMALL_STATE(324)] = 15167,
  [SMALL_STATE(325)] = 15202,
  [SMALL_STATE(326)] = 15225,
  [SMALL_STATE(327)] = 15248,
  [SMALL_STATE(328)] = 15271,
  [SMALL_STATE(329)] = 15294,
  [SMALL_STATE(330)] = 15317,
  [SMALL_STATE(331)] = 15340,
  [SMALL_STATE(332)] = 15372,
  [SMALL_STATE(333)] = 15404,
  [SMALL_STATE(334)] = 15436,
  [SMALL_STATE(335)] = 15468,
  [SMALL_STATE(336)] = 15490,
  [SMALL_STATE(337)] = 15518,
  [SMALL_STATE(338)] = 15550,
  [SMALL_STATE(339)] = 15582,
  [SMALL_STATE(340)] = 15612,
  [SMALL_STATE(341)] = 15634,
  [SMALL_STATE(342)] = 15666,
  [SMALL_STATE(343)] = 15698,
  [SMALL_STATE(344)] = 15720,
  [SMALL_STATE(345)] = 15752,
  [SMALL_STATE(346)] = 15784,
  [SMALL_STATE(347)] = 15802,
  [SMALL_STATE(348)] = 15832,
  [SMALL_STATE(349)] = 15862,
  [SMALL_STATE(350)] = 15880,
  [SMALL_STATE(351)] = 15912,
  [SMALL_STATE(352)] = 15940,
  [SMALL_STATE(353)] = 15962,
  [SMALL_STATE(354)] = 15994,
  [SMALL_STATE(355)] = 16022,
  [SMALL_STATE(356)] = 16054,
  [SMALL_STATE(357)] = 16085,
  [SMALL_STATE(358)] = 16104,
  [SMALL_STATE(359)] = 16135,
  [SMALL_STATE(360)] = 16166,
  [SMALL_STATE(361)] = 16197,
  [SMALL_STATE(362)] = 16228,
  [SMALL_STATE(363)] = 16259,
  [SMALL_STATE(364)] = 16290,
  [SMALL_STATE(365)] = 16311,
  [SMALL_STATE(366)] = 16342,
  [SMALL_STATE(367)] = 16371,
  [SMALL_STATE(368)] = 16400,
  [SMALL_STATE(369)] = 16431,
  [SMALL_STATE(370)] = 16462,
  [SMALL_STATE(371)] = 16491,
  [SMALL_STATE(372)] = 16522,
  [SMALL_STATE(373)] = 16553,
  [SMALL_STATE(374)] = 16574,
  [SMALL_STATE(375)] = 16605,
  [SMALL_STATE(376)] = 16636,
  [SMALL_STATE(377)] = 16667,
  [SMALL_STATE(378)] = 16698,
  [SMALL_STATE(379)] = 16729,
  [SMALL_STATE(380)] = 16760,
  [SMALL_STATE(381)] = 16791,
  [SMALL_STATE(382)] = 16822,
  [SMALL_STATE(383)] = 16853,
  [SMALL_STATE(384)] = 16884,
  [SMALL_STATE(385)] = 16915,
  [SMALL_STATE(386)] = 16946,
  [SMALL_STATE(387)] = 16977,
  [SMALL_STATE(388)] = 17008,
  [SMALL_STATE(389)] = 17039,
  [SMALL_STATE(390)] = 17070,
  [SMALL_STATE(391)] = 17101,
  [SMALL_STATE(392)] = 17132,
  [SMALL_STATE(393)] = 17163,
  [SMALL_STATE(394)] = 17194,
  [SMALL_STATE(395)] = 17225,
  [SMALL_STATE(396)] = 17256,
  [SMALL_STATE(397)] = 17277,
  [SMALL_STATE(398)] = 17308,
  [SMALL_STATE(399)] = 17339,
  [SMALL_STATE(400)] = 17370,
  [SMALL_STATE(401)] = 17401,
  [SMALL_STATE(402)] = 17432,
  [SMALL_STATE(403)] = 17463,
  [SMALL_STATE(404)] = 17494,
  [SMALL_STATE(405)] = 17525,
  [SMALL_STATE(406)] = 17556,
  [SMALL_STATE(407)] = 17587,
  [SMALL_STATE(408)] = 17618,
  [SMALL_STATE(409)] = 17649,
  [SMALL_STATE(410)] = 17680,
  [SMALL_STATE(411)] = 17701,
  [SMALL_STATE(412)] = 17722,
  [SMALL_STATE(413)] = 17743,
  [SMALL_STATE(414)] = 17764,
  [SMALL_STATE(415)] = 17785,
  [SMALL_STATE(416)] = 17806,
  [SMALL_STATE(417)] = 17827,
  [SMALL_STATE(418)] = 17848,
  [SMALL_STATE(419)] = 17869,
  [SMALL_STATE(420)] = 17890,
  [SMALL_STATE(421)] = 17921,
  [SMALL_STATE(422)] = 17940,
  [SMALL_STATE(423)] = 17959,
  [SMALL_STATE(424)] = 17987,
  [SMALL_STATE(425)] = 18015,
  [SMALL_STATE(426)] = 18043,
  [SMALL_STATE(427)] = 18071,
  [SMALL_STATE(428)] = 18099,
  [SMALL_STATE(429)] = 18127,
  [SMALL_STATE(430)] = 18155,
  [SMALL_STATE(431)] = 18175,
  [SMALL_STATE(432)] = 18203,
  [SMALL_STATE(433)] = 18231,
  [SMALL_STATE(434)] = 18259,
  [SMALL_STATE(435)] = 18287,
  [SMALL_STATE(436)] = 18315,
  [SMALL_STATE(437)] = 18343,
  [SMALL_STATE(438)] = 18371,
  [SMALL_STATE(439)] = 18399,
  [SMALL_STATE(440)] = 18427,
  [SMALL_STATE(441)] = 18455,
  [SMALL_STATE(442)] = 18471,
  [SMALL_STATE(443)] = 18491,
  [SMALL_STATE(444)] = 18519,
  [SMALL_STATE(445)] = 18547,
  [SMALL_STATE(446)] = 18563,
  [SMALL_STATE(447)] = 18591,
  [SMALL_STATE(448)] = 18607,
  [SMALL_STATE(449)] = 18635,
  [SMALL_STATE(450)] = 18663,
  [SMALL_STATE(451)] = 18691,
  [SMALL_STATE(452)] = 18719,
  [SMALL_STATE(453)] = 18747,
  [SMALL_STATE(454)] = 18763,
  [SMALL_STATE(455)] = 18791,
  [SMALL_STATE(456)] = 18819,
  [SMALL_STATE(457)] = 18835,
  [SMALL_STATE(458)] = 18863,
  [SMALL_STATE(459)] = 18891,
  [SMALL_STATE(460)] = 18919,
  [SMALL_STATE(461)] = 18947,
  [SMALL_STATE(462)] = 18975,
  [SMALL_STATE(463)] = 18991,
  [SMALL_STATE(464)] = 19019,
  [SMALL_STATE(465)] = 19035,
  [SMALL_STATE(466)] = 19051,
  [SMALL_STATE(467)] = 19067,
  [SMALL_STATE(468)] = 19095,
  [SMALL_STATE(469)] = 19123,
  [SMALL_STATE(470)] = 19151,
  [SMALL_STATE(471)] = 19179,
  [SMALL_STATE(472)] = 19207,
  [SMALL_STATE(473)] = 19235,
  [SMALL_STATE(474)] = 19251,
  [SMALL_STATE(475)] = 19279,
  [SMALL_STATE(476)] = 19307,
  [SMALL_STATE(477)] = 19323,
  [SMALL_STATE(478)] = 19351,
  [SMALL_STATE(479)] = 19379,
  [SMALL_STATE(480)] = 19407,
  [SMALL_STATE(481)] = 19435,
  [SMALL_STATE(482)] = 19451,
  [SMALL_STATE(483)] = 19479,
  [SMALL_STATE(484)] = 19499,
  [SMALL_STATE(485)] = 19527,
  [SMALL_STATE(486)] = 19555,
  [SMALL_STATE(487)] = 19583,
  [SMALL_STATE(488)] = 19611,
  [SMALL_STATE(489)] = 19639,
  [SMALL_STATE(490)] = 19655,
  [SMALL_STATE(491)] = 19683,
  [SMALL_STATE(492)] = 19699,
  [SMALL_STATE(493)] = 19715,
  [SMALL_STATE(494)] = 19743,
  [SMALL_STATE(495)] = 19771,
  [SMALL_STATE(496)] = 19799,
  [SMALL_STATE(497)] = 19827,
  [SMALL_STATE(498)] = 19855,
  [SMALL_STATE(499)] = 19875,
  [SMALL_STATE(500)] = 19903,
  [SMALL_STATE(501)] = 19931,
  [SMALL_STATE(502)] = 19951,
  [SMALL_STATE(503)] = 19979,
  [SMALL_STATE(504)] = 20007,
  [SMALL_STATE(505)] = 20027,
  [SMALL_STATE(506)] = 20047,
  [SMALL_STATE(507)] = 20063,
  [SMALL_STATE(508)] = 20083,
  [SMALL_STATE(509)] = 20103,
  [SMALL_STATE(510)] = 20122,
  [SMALL_STATE(511)] = 20141,
  [SMALL_STATE(512)] = 20154,
  [SMALL_STATE(513)] = 20169,
  [SMALL_STATE(514)] = 20188,
  [SMALL_STATE(515)] = 20207,
  [SMALL_STATE(516)] = 20220,
  [SMALL_STATE(517)] = 20235,
  [SMALL_STATE(518)] = 20254,
  [SMALL_STATE(519)] = 20269,
  [SMALL_STATE(520)] = 20282,
  [SMALL_STATE(521)] = 20297,
  [SMALL_STATE(522)] = 20316,
  [SMALL_STATE(523)] = 20331,
  [SMALL_STATE(524)] = 20344,
  [SMALL_STATE(525)] = 20359,
  [SMALL_STATE(526)] = 20374,
  [SMALL_STATE(527)] = 20393,
  [SMALL_STATE(528)] = 20406,
  [SMALL_STATE(529)] = 20419,
  [SMALL_STATE(530)] = 20438,
  [SMALL_STATE(531)] = 20452,
  [SMALL_STATE(532)] = 20470,
  [SMALL_STATE(533)] = 20488,
  [SMALL_STATE(534)] = 20502,
  [SMALL_STATE(535)] = 20516,
  [SMALL_STATE(536)] = 20530,
  [SMALL_STATE(537)] = 20544,
  [SMALL_STATE(538)] = 20558,
  [SMALL_STATE(539)] = 20582,
  [SMALL_STATE(540)] = 20606,
  [SMALL_STATE(541)] = 20620,
  [SMALL_STATE(542)] = 20634,
  [SMALL_STATE(543)] = 20658,
  [SMALL_STATE(544)] = 20672,
  [SMALL_STATE(545)] = 20696,
  [SMALL_STATE(546)] = 20710,
  [SMALL_STATE(547)] = 20724,
  [SMALL_STATE(548)] = 20742,
  [SMALL_STATE(549)] = 20756,
  [SMALL_STATE(550)] = 20780,
  [SMALL_STATE(551)] = 20804,
  [SMALL_STATE(552)] = 20818,
  [SMALL_STATE(553)] = 20832,
  [SMALL_STATE(554)] = 20856,
  [SMALL_STATE(555)] = 20880,
  [SMALL_STATE(556)] = 20904,
  [SMALL_STATE(557)] = 20928,
  [SMALL_STATE(558)] = 20941,
  [SMALL_STATE(559)] = 20954,
  [SMALL_STATE(560)] = 20975,
  [SMALL_STATE(561)] = 20990,
  [SMALL_STATE(562)] = 21005,
  [SMALL_STATE(563)] = 21024,
  [SMALL_STATE(564)] = 21037,
  [SMALL_STATE(565)] = 21052,
  [SMALL_STATE(566)] = 21065,
  [SMALL_STATE(567)] = 21080,
  [SMALL_STATE(568)] = 21099,
  [SMALL_STATE(569)] = 21120,
  [SMALL_STATE(570)] = 21133,
  [SMALL_STATE(571)] = 21154,
  [SMALL_STATE(572)] = 21173,
  [SMALL_STATE(573)] = 21192,
  [SMALL_STATE(574)] = 21211,
  [SMALL_STATE(575)] = 21230,
  [SMALL_STATE(576)] = 21251,
  [SMALL_STATE(577)] = 21270,
  [SMALL_STATE(578)] = 21289,
  [SMALL_STATE(579)] = 21308,
  [SMALL_STATE(580)] = 21329,
  [SMALL_STATE(581)] = 21350,
  [SMALL_STATE(582)] = 21369,
  [SMALL_STATE(583)] = 21390,
  [SMALL_STATE(584)] = 21409,
  [SMALL_STATE(585)] = 21422,
  [SMALL_STATE(586)] = 21435,
  [SMALL_STATE(587)] = 21448,
  [SMALL_STATE(588)] = 21469,
  [SMALL_STATE(589)] = 21490,
  [SMALL_STATE(590)] = 21509,
  [SMALL_STATE(591)] = 21530,
  [SMALL_STATE(592)] = 21543,
  [SMALL_STATE(593)] = 21564,
  [SMALL_STATE(594)] = 21583,
  [SMALL_STATE(595)] = 21604,
  [SMALL_STATE(596)] = 21625,
  [SMALL_STATE(597)] = 21644,
  [SMALL_STATE(598)] = 21663,
  [SMALL_STATE(599)] = 21684,
  [SMALL_STATE(600)] = 21703,
  [SMALL_STATE(601)] = 21716,
  [SMALL_STATE(602)] = 21735,
  [SMALL_STATE(603)] = 21754,
  [SMALL_STATE(604)] = 21767,
  [SMALL_STATE(605)] = 21780,
  [SMALL_STATE(606)] = 21793,
  [SMALL_STATE(607)] = 21806,
  [SMALL_STATE(608)] = 21819,
  [SMALL_STATE(609)] = 21834,
  [SMALL_STATE(610)] = 21847,
  [SMALL_STATE(611)] = 21860,
  [SMALL_STATE(612)] = 21873,
  [SMALL_STATE(613)] = 21894,
  [SMALL_STATE(614)] = 21913,
  [SMALL_STATE(615)] = 21932,
  [SMALL_STATE(616)] = 21953,
  [SMALL_STATE(617)] = 21972,
  [SMALL_STATE(618)] = 21993,
  [SMALL_STATE(619)] = 22011,
  [SMALL_STATE(620)] = 22023,
  [SMALL_STATE(621)] = 22035,
  [SMALL_STATE(622)] = 22047,
  [SMALL_STATE(623)] = 22059,
  [SMALL_STATE(624)] = 22071,
  [SMALL_STATE(625)] = 22083,
  [SMALL_STATE(626)] = 22099,
  [SMALL_STATE(627)] = 22113,
  [SMALL_STATE(628)] = 22125,
  [SMALL_STATE(629)] = 22137,
  [SMALL_STATE(630)] = 22149,
  [SMALL_STATE(631)] = 22163,
  [SMALL_STATE(632)] = 22175,
  [SMALL_STATE(633)] = 22187,
  [SMALL_STATE(634)] = 22199,
  [SMALL_STATE(635)] = 22211,
  [SMALL_STATE(636)] = 22223,
  [SMALL_STATE(637)] = 22235,
  [SMALL_STATE(638)] = 22247,
  [SMALL_STATE(639)] = 22259,
  [SMALL_STATE(640)] = 22271,
  [SMALL_STATE(641)] = 22287,
  [SMALL_STATE(642)] = 22299,
  [SMALL_STATE(643)] = 22316,
  [SMALL_STATE(644)] = 22333,
  [SMALL_STATE(645)] = 22350,
  [SMALL_STATE(646)] = 22367,
  [SMALL_STATE(647)] = 22378,
  [SMALL_STATE(648)] = 22395,
  [SMALL_STATE(649)] = 22412,
  [SMALL_STATE(650)] = 22423,
  [SMALL_STATE(651)] = 22440,
  [SMALL_STATE(652)] = 22451,
  [SMALL_STATE(653)] = 22468,
  [SMALL_STATE(654)] = 22482,
  [SMALL_STATE(655)] = 22498,
  [SMALL_STATE(656)] = 22512,
  [SMALL_STATE(657)] = 22526,
  [SMALL_STATE(658)] = 22542,
  [SMALL_STATE(659)] = 22558,
  [SMALL_STATE(660)] = 22566,
  [SMALL_STATE(661)] = 22582,
  [SMALL_STATE(662)] = 22590,
  [SMALL_STATE(663)] = 22606,
  [SMALL_STATE(664)] = 22616,
  [SMALL_STATE(665)] = 22632,
  [SMALL_STATE(666)] = 22646,
  [SMALL_STATE(667)] = 22654,
  [SMALL_STATE(668)] = 22668,
  [SMALL_STATE(669)] = 22676,
  [SMALL_STATE(670)] = 22692,
  [SMALL_STATE(671)] = 22702,
  [SMALL_STATE(672)] = 22716,
  [SMALL_STATE(673)] = 22732,
  [SMALL_STATE(674)] = 22748,
  [SMALL_STATE(675)] = 22764,
  [SMALL_STATE(676)] = 22780,
  [SMALL_STATE(677)] = 22796,
  [SMALL_STATE(678)] = 22810,
  [SMALL_STATE(679)] = 22826,
  [SMALL_STATE(680)] = 22842,
  [SMALL_STATE(681)] = 22858,
  [SMALL_STATE(682)] = 22874,
  [SMALL_STATE(683)] = 22890,
  [SMALL_STATE(684)] = 22906,
  [SMALL_STATE(685)] = 22922,
  [SMALL_STATE(686)] = 22938,
  [SMALL_STATE(687)] = 22954,
  [SMALL_STATE(688)] = 22968,
  [SMALL_STATE(689)] = 22984,
  [SMALL_STATE(690)] = 23000,
  [SMALL_STATE(691)] = 23014,
  [SMALL_STATE(692)] = 23028,
  [SMALL_STATE(693)] = 23044,
  [SMALL_STATE(694)] = 23060,
  [SMALL_STATE(695)] = 23070,
  [SMALL_STATE(696)] = 23086,
  [SMALL_STATE(697)] = 23102,
  [SMALL_STATE(698)] = 23116,
  [SMALL_STATE(699)] = 23126,
  [SMALL_STATE(700)] = 23142,
  [SMALL_STATE(701)] = 23156,
  [SMALL_STATE(702)] = 23172,
  [SMALL_STATE(703)] = 23188,
  [SMALL_STATE(704)] = 23201,
  [SMALL_STATE(705)] = 23214,
  [SMALL_STATE(706)] = 23227,
  [SMALL_STATE(707)] = 23240,
  [SMALL_STATE(708)] = 23253,
  [SMALL_STATE(709)] = 23266,
  [SMALL_STATE(710)] = 23279,
  [SMALL_STATE(711)] = 23292,
  [SMALL_STATE(712)] = 23305,
  [SMALL_STATE(713)] = 23318,
  [SMALL_STATE(714)] = 23331,
  [SMALL_STATE(715)] = 23344,
  [SMALL_STATE(716)] = 23354,
  [SMALL_STATE(717)] = 23362,
  [SMALL_STATE(718)] = 23370,
  [SMALL_STATE(719)] = 23378,
  [SMALL_STATE(720)] = 23388,
  [SMALL_STATE(721)] = 23396,
  [SMALL_STATE(722)] = 23406,
  [SMALL_STATE(723)] = 23414,
  [SMALL_STATE(724)] = 23422,
  [SMALL_STATE(725)] = 23430,
  [SMALL_STATE(726)] = 23440,
  [SMALL_STATE(727)] = 23448,
  [SMALL_STATE(728)] = 23456,
  [SMALL_STATE(729)] = 23464,
  [SMALL_STATE(730)] = 23472,
  [SMALL_STATE(731)] = 23480,
  [SMALL_STATE(732)] = 23488,
  [SMALL_STATE(733)] = 23496,
  [SMALL_STATE(734)] = 23506,
  [SMALL_STATE(735)] = 23514,
  [SMALL_STATE(736)] = 23522,
  [SMALL_STATE(737)] = 23530,
  [SMALL_STATE(738)] = 23538,
  [SMALL_STATE(739)] = 23546,
  [SMALL_STATE(740)] = 23554,
  [SMALL_STATE(741)] = 23562,
  [SMALL_STATE(742)] = 23570,
  [SMALL_STATE(743)] = 23578,
  [SMALL_STATE(744)] = 23586,
  [SMALL_STATE(745)] = 23594,
  [SMALL_STATE(746)] = 23602,
  [SMALL_STATE(747)] = 23610,
  [SMALL_STATE(748)] = 23618,
  [SMALL_STATE(749)] = 23626,
  [SMALL_STATE(750)] = 23634,
  [SMALL_STATE(751)] = 23642,
  [SMALL_STATE(752)] = 23650,
  [SMALL_STATE(753)] = 23658,
  [SMALL_STATE(754)] = 23666,
  [SMALL_STATE(755)] = 23674,
  [SMALL_STATE(756)] = 23682,
  [SMALL_STATE(757)] = 23692,
  [SMALL_STATE(758)] = 23702,
  [SMALL_STATE(759)] = 23712,
  [SMALL_STATE(760)] = 23720,
  [SMALL_STATE(761)] = 23728,
  [SMALL_STATE(762)] = 23734,
  [SMALL_STATE(763)] = 23742,
  [SMALL_STATE(764)] = 23752,
  [SMALL_STATE(765)] = 23760,
  [SMALL_STATE(766)] = 23768,
  [SMALL_STATE(767)] = 23778,
  [SMALL_STATE(768)] = 23788,
  [SMALL_STATE(769)] = 23796,
  [SMALL_STATE(770)] = 23804,
  [SMALL_STATE(771)] = 23812,
  [SMALL_STATE(772)] = 23820,
  [SMALL_STATE(773)] = 23830,
  [SMALL_STATE(774)] = 23838,
  [SMALL_STATE(775)] = 23846,
  [SMALL_STATE(776)] = 23856,
  [SMALL_STATE(777)] = 23866,
  [SMALL_STATE(778)] = 23874,
  [SMALL_STATE(779)] = 23882,
  [SMALL_STATE(780)] = 23892,
  [SMALL_STATE(781)] = 23902,
  [SMALL_STATE(782)] = 23910,
  [SMALL_STATE(783)] = 23920,
  [SMALL_STATE(784)] = 23928,
  [SMALL_STATE(785)] = 23936,
  [SMALL_STATE(786)] = 23944,
  [SMALL_STATE(787)] = 23952,
  [SMALL_STATE(788)] = 23962,
  [SMALL_STATE(789)] = 23970,
  [SMALL_STATE(790)] = 23978,
  [SMALL_STATE(791)] = 23986,
  [SMALL_STATE(792)] = 23992,
  [SMALL_STATE(793)] = 24000,
  [SMALL_STATE(794)] = 24008,
  [SMALL_STATE(795)] = 24016,
  [SMALL_STATE(796)] = 24022,
  [SMALL_STATE(797)] = 24030,
  [SMALL_STATE(798)] = 24038,
  [SMALL_STATE(799)] = 24046,
  [SMALL_STATE(800)] = 24054,
  [SMALL_STATE(801)] = 24058,
  [SMALL_STATE(802)] = 24062,
  [SMALL_STATE(803)] = 24066,
  [SMALL_STATE(804)] = 24070,
  [SMALL_STATE(805)] = 24074,
  [SMALL_STATE(806)] = 24078,
  [SMALL_STATE(807)] = 24082,
  [SMALL_STATE(808)] = 24086,
  [SMALL_STATE(809)] = 24090,
  [SMALL_STATE(810)] = 24094,
  [SMALL_STATE(811)] = 24098,
  [SMALL_STATE(812)] = 24102,
  [SMALL_STATE(813)] = 24106,
  [SMALL_STATE(814)] = 24110,
  [SMALL_STATE(815)] = 24114,
  [SMALL_STATE(816)] = 24118,
  [SMALL_STATE(817)] = 24122,
  [SMALL_STATE(818)] = 24126,
  [SMALL_STATE(819)] = 24130,
  [SMALL_STATE(820)] = 24134,
  [SMALL_STATE(821)] = 24138,
  [SMALL_STATE(822)] = 24142,
  [SMALL_STATE(823)] = 24146,
  [SMALL_STATE(824)] = 24150,
  [SMALL_STATE(825)] = 24154,
  [SMALL_STATE(826)] = 24158,
  [SMALL_STATE(827)] = 24162,
  [SMALL_STATE(828)] = 24166,
  [SMALL_STATE(829)] = 24170,
  [SMALL_STATE(830)] = 24174,
  [SMALL_STATE(831)] = 24178,
  [SMALL_STATE(832)] = 24182,
  [SMALL_STATE(833)] = 24186,
  [SMALL_STATE(834)] = 24190,
  [SMALL_STATE(835)] = 24194,
  [SMALL_STATE(836)] = 24198,
  [SMALL_STATE(837)] = 24202,
  [SMALL_STATE(838)] = 24206,
  [SMALL_STATE(839)] = 24210,
  [SMALL_STATE(840)] = 24214,
  [SMALL_STATE(841)] = 24218,
  [SMALL_STATE(842)] = 24222,
  [SMALL_STATE(843)] = 24226,
  [SMALL_STATE(844)] = 24230,
  [SMALL_STATE(845)] = 24234,
  [SMALL_STATE(846)] = 24238,
  [SMALL_STATE(847)] = 24242,
  [SMALL_STATE(848)] = 24246,
  [SMALL_STATE(849)] = 24250,
  [SMALL_STATE(850)] = 24254,
  [SMALL_STATE(851)] = 24258,
  [SMALL_STATE(852)] = 24262,
  [SMALL_STATE(853)] = 24266,
  [SMALL_STATE(854)] = 24270,
  [SMALL_STATE(855)] = 24274,
  [SMALL_STATE(856)] = 24278,
  [SMALL_STATE(857)] = 24282,
  [SMALL_STATE(858)] = 24286,
  [SMALL_STATE(859)] = 24290,
  [SMALL_STATE(860)] = 24294,
  [SMALL_STATE(861)] = 24298,
  [SMALL_STATE(862)] = 24302,
  [SMALL_STATE(863)] = 24306,
  [SMALL_STATE(864)] = 24310,
  [SMALL_STATE(865)] = 24314,
  [SMALL_STATE(866)] = 24318,
  [SMALL_STATE(867)] = 24322,
  [SMALL_STATE(868)] = 24326,
  [SMALL_STATE(869)] = 24330,
  [SMALL_STATE(870)] = 24334,
  [SMALL_STATE(871)] = 24338,
  [SMALL_STATE(872)] = 24342,
  [SMALL_STATE(873)] = 24346,
  [SMALL_STATE(874)] = 24350,
  [SMALL_STATE(875)] = 24354,
  [SMALL_STATE(876)] = 24358,
  [SMALL_STATE(877)] = 24362,
  [SMALL_STATE(878)] = 24366,
  [SMALL_STATE(879)] = 24370,
  [SMALL_STATE(880)] = 24374,
  [SMALL_STATE(881)] = 24378,
  [SMALL_STATE(882)] = 24382,
  [SMALL_STATE(883)] = 24386,
  [SMALL_STATE(884)] = 24390,
  [SMALL_STATE(885)] = 24394,
  [SMALL_STATE(886)] = 24398,
  [SMALL_STATE(887)] = 24402,
  [SMALL_STATE(888)] = 24406,
  [SMALL_STATE(889)] = 24410,
  [SMALL_STATE(890)] = 24414,
  [SMALL_STATE(891)] = 24418,
  [SMALL_STATE(892)] = 24422,
  [SMALL_STATE(893)] = 24426,
  [SMALL_STATE(894)] = 24430,
  [SMALL_STATE(895)] = 24434,
  [SMALL_STATE(896)] = 24438,
  [SMALL_STATE(897)] = 24442,
  [SMALL_STATE(898)] = 24446,
  [SMALL_STATE(899)] = 24450,
  [SMALL_STATE(900)] = 24454,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(662),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(767),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(714),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(562),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(743),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(725),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(502),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(706),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(634),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(404),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(614),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(628),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(632),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(685),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(585),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(669),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(586),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(518),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(657),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(695),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(603),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 3),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(777),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(689),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(633),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(584),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(600),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(688),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(635),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(638),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(624),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(565),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(524),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 4),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(696),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(675),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(672),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(660),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(701),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(679),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(683),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id, 1),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id, 1),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(830),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(517),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(890),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(721),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(472),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(703),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(602),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(827),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(810),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(806),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(811),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id, 2),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id, 2),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(896),
  [227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(838),
  [229] = {.entry = {.count = 1, .reusable = false}}, SHIFT(873),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id, 3),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id, 3),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(816),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(815),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_id_repeat1, 2),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2),
  [243] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(830),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(854),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(896),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(816),
  [254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(823),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_substitution, 4),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_substitution, 4),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__concat_word, 1),
  [266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__concat_word, 1),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(550),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_substitution, 2),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_substitution, 2),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__concat_word_repeat1, 2),
  [282] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(590),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [287] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(592),
  [290] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(580),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__concat_word, 2),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__concat_word, 2),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_index, 3),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_index, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_substitution, 5),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_substitution, 5),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_word, 2),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_word, 2),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_word, 3),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_word, 3),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_substitution, 3),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_substitution, 3),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command_substitution, 3),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command_substitution, 3),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(807),
  [325] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(807),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 1),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 1),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binop_expr, 3),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binop_expr, 3),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expr, 2),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expr, 2),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [372] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word_simple, 3),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word_simple, 3),
  [376] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternary_expr, 5),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expr, 5),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word_simple, 2),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word_simple, 2),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr, 3),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr, 3),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expr, 4),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expr, 4),
  [394] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(587),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(281),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(495),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [469] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [473] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [481] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [485] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(898),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(735),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__commands_repeat1, 2),
  [523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__commands_repeat1, 2),
  [525] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__commands_repeat1, 2), SHIFT_REPEAT(220),
  [528] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__commands_repeat1, 2), SHIFT_REPEAT(221),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(709),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(593),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [545] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [547] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(705),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(616),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [561] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [563] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [565] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(708),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(573),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [583] = {.entry = {.count = 1, .reusable = false}}, SHIFT(710),
  [585] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [587] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [589] = {.entry = {.count = 1, .reusable = false}}, SHIFT(583),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [595] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 2, .production_id = 2),
  [597] = {.entry = {.count = 1, .reusable = false}}, SHIFT(471),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command, 1, .production_id = 1),
  [601] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 1, .production_id = 1),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(432),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command, 2, .production_id = 2),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_word_list, 1),
  [609] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(422),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2),
  [614] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(471),
  [617] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(706),
  [620] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(5),
  [623] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(614),
  [626] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(46),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_word_list, 1),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_word_list_repeat1, 2),
  [633] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(364),
  [636] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(432),
  [639] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(714),
  [642] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(10),
  [645] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(562),
  [648] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(40),
  [651] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [655] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(868),
  [658] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(517),
  [661] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(474),
  [664] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(703),
  [667] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(16),
  [670] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(602),
  [673] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(517),
  [676] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_list_repeat1, 2), SHIFT_REPEAT(55),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(870),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(868),
  [683] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(870),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(711),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(637),
  [696] = {.entry = {.count = 1, .reusable = false}}, SHIFT(578),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [704] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2), SHIFT_REPEAT(532),
  [707] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2), SHIFT_REPEAT(711),
  [710] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2), SHIFT_REPEAT(350),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2),
  [715] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2), SHIFT_REPEAT(578),
  [718] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2), SHIFT_REPEAT(532),
  [721] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_braced_word_simple_repeat1, 2), SHIFT_REPEAT(62),
  [724] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(538),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global, 2),
  [730] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [732] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global, 2),
  [736] = {.entry = {.count = 1, .reusable = false}}, SHIFT(556),
  [738] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [740] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [742] = {.entry = {.count = 1, .reusable = false}}, SHIFT(620),
  [744] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global, 1),
  [748] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global, 1),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_global_repeat1, 2),
  [752] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(364),
  [755] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2),
  [757] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(714),
  [760] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(562),
  [763] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(40),
  [766] = {.entry = {.count = 1, .reusable = false}}, SHIFT(629),
  [768] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(422),
  [771] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(706),
  [774] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(614),
  [777] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(46),
  [780] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [782] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [784] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [786] = {.entry = {.count = 1, .reusable = false}}, SHIFT(469),
  [788] = {.entry = {.count = 1, .reusable = false}}, SHIFT(704),
  [790] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [792] = {.entry = {.count = 1, .reusable = false}}, SHIFT(597),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [796] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [800] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [802] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [806] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [808] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [810] = {.entry = {.count = 1, .reusable = false}}, SHIFT(437),
  [812] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [814] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(444),
  [820] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [822] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [824] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [828] = {.entry = {.count = 1, .reusable = false}}, SHIFT(439),
  [830] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [832] = {.entry = {.count = 1, .reusable = false}}, SHIFT(500),
  [834] = {.entry = {.count = 1, .reusable = false}}, SHIFT(448),
  [836] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [838] = {.entry = {.count = 1, .reusable = false}}, SHIFT(450),
  [840] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [842] = {.entry = {.count = 1, .reusable = false}}, SHIFT(452),
  [844] = {.entry = {.count = 1, .reusable = false}}, SHIFT(496),
  [846] = {.entry = {.count = 1, .reusable = false}}, SHIFT(454),
  [848] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [850] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [852] = {.entry = {.count = 1, .reusable = false}}, SHIFT(459),
  [854] = {.entry = {.count = 1, .reusable = false}}, SHIFT(457),
  [856] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [858] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [860] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [862] = {.entry = {.count = 1, .reusable = false}}, SHIFT(468),
  [864] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [866] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [868] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [870] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [872] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [874] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [876] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [878] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(594),
  [881] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(485),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [889] = {.entry = {.count = 1, .reusable = false}}, SHIFT(490),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(493),
  [893] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(497),
  [897] = {.entry = {.count = 1, .reusable = false}}, SHIFT(499),
  [899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [903] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [907] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(837),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(837),
  [912] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(801),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [917] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [919] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(612),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [924] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(517),
  [927] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(703),
  [930] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(602),
  [933] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(517),
  [936] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_global_repeat1, 2), SHIFT_REPEAT(55),
  [939] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [941] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [943] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [945] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [947] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(824),
  [951] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [953] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [955] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(824),
  [958] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(598),
  [961] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [963] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word, 5),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [967] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word, 4),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word, 4),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word, 6),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word, 6),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word, 3),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word, 3),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word, 5),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_word, 2),
  [985] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_word, 2),
  [987] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(595),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [992] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concat_word_repeat1, 2), SHIFT_REPEAT(575),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 5, .production_id = 5),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 5, .production_id = 5),
  [999] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(851),
  [1005] = {.entry = {.count = 1, .reusable = false}}, SHIFT(707),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(441),
  [1009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(571),
  [1011] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [1013] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_id_repeat1, 2), SHIFT_REPEAT(851),
  [1016] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_word_repeat1, 2), SHIFT_REPEAT(707),
  [1019] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_quoted_word_repeat1, 2),
  [1021] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_word_repeat1, 2), SHIFT_REPEAT(567),
  [1024] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_word_repeat1, 2), SHIFT_REPEAT(43),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 3, .production_id = 5),
  [1029] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 3, .production_id = 5),
  [1031] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [1033] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [1035] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [1037] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [1039] = {.entry = {.count = 1, .reusable = false}}, SHIFT(858),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [1043] = {.entry = {.count = 1, .reusable = false}}, SHIFT(576),
  [1045] = {.entry = {.count = 1, .reusable = false}}, SHIFT(855),
  [1047] = {.entry = {.count = 1, .reusable = false}}, SHIFT(572),
  [1049] = {.entry = {.count = 1, .reusable = false}}, SHIFT(591),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1053] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [1055] = {.entry = {.count = 1, .reusable = false}}, SHIFT(557),
  [1057] = {.entry = {.count = 1, .reusable = false}}, SHIFT(558),
  [1059] = {.entry = {.count = 1, .reusable = false}}, SHIFT(577),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 4, .production_id = 5),
  [1063] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 4, .production_id = 5),
  [1065] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1069] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [1071] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [1073] = {.entry = {.count = 1, .reusable = false}}, SHIFT(581),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1079] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [1081] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1085] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1089] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [1091] = {.entry = {.count = 1, .reusable = false}}, SHIFT(589),
  [1093] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1097] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [1103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(551),
  [1105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(596),
  [1107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(541),
  [1113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [1115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [1117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(599),
  [1119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(465),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [1125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(447),
  [1127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(613),
  [1129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [1131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(601),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(814),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(795),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 1),
  [1143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1),
  [1145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_conditional_repeat1, 2),
  [1147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_conditional_repeat1, 2),
  [1149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_conditional_repeat1, 2), SHIFT_REPEAT(223),
  [1152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(549),
  [1154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [1156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [1158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [1160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [1162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3),
  [1166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_conditional_repeat1, 2), SHIFT_REPEAT(233),
  [1169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 2),
  [1171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 2),
  [1173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(894),
  [1175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [1181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(863),
  [1183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [1185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 3),
  [1187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 3),
  [1189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(895),
  [1191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(877),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(761),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(846),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [1203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 6),
  [1205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 6),
  [1207] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_conditional_repeat1, 2), SHIFT_REPEAT(228),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [1214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(604),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [1222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [1224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [1230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif, 3, .production_id = 5),
  [1232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif, 3, .production_id = 5),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__commands_repeat2, 2),
  [1236] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__commands_repeat2, 2), SHIFT_REPEAT(36),
  [1239] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__commands_repeat2, 2), SHIFT_REPEAT(36),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 7),
  [1246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 7),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [1252] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif, 4, .production_id = 5),
  [1256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif, 4, .production_id = 5),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 8),
  [1260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 8),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1264] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1276] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1280] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1292] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [1294] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1298] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [1304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(622),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1308] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [1310] = {.entry = {.count = 1, .reusable = false}}, SHIFT(623),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1314] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(761),
  [1317] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(846),
  [1320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [1322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__commands_repeat2, 2), SHIFT_REPEAT(32),
  [1325] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__commands_repeat2, 2), SHIFT_REPEAT(32),
  [1328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__commands_repeat2, 2),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [1338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(609),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(872),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(876),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(842),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(834),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(885),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(866),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(874),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(880),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(820),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(852),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(883),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(886),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(812),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(889),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(821),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(900),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(899),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(848),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(849),
  [1416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_procedure, 4, .production_id = 6),
  [1418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_procedure, 4, .production_id = 6),
  [1420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 4),
  [1422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 4),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [1428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_procedure, 5, .production_id = 8),
  [1430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_procedure, 5, .production_id = 8),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [1436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 3),
  [1438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 3),
  [1440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_procedure, 6, .production_id = 11),
  [1442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_procedure, 6, .production_id = 11),
  [1444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 6, .production_id = 5),
  [1446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 6, .production_id = 5),
  [1448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else, 2),
  [1450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else, 2),
  [1452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while, 4),
  [1454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while, 4),
  [1456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_finally, 2),
  [1458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_finally, 2),
  [1460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else, 3),
  [1462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else, 3),
  [1464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch, 2),
  [1466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch, 2),
  [1468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command, 2, .production_id = 3),
  [1470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 2, .production_id = 3),
  [1472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while, 3),
  [1474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while, 3),
  [1476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach, 5),
  [1478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach, 5),
  [1480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_command, 3, .production_id = 4),
  [1482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_command, 3, .production_id = 4),
  [1484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch, 3),
  [1486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch, 3),
  [1488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set, 5),
  [1490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set, 5),
  [1492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_procedure, 5, .production_id = 9),
  [1494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_procedure, 5, .production_id = 9),
  [1496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr_cmd, 2),
  [1498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr_cmd, 2),
  [1500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace, 2),
  [1502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace, 2),
  [1504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1, .production_id = 1),
  [1506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_finally, 3),
  [1508] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_finally, 3),
  [1510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach, 4),
  [1512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach, 4),
  [1514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 4),
  [1516] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 4),
  [1518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_try, 9),
  [1520] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_try, 9),
  [1522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 4, .production_id = 10),
  [1524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 3, .production_id = 7),
  [1526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [1550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(829),
  [1584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(878),
  [1600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [1606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(891),
  [1608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(779),
  [1616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(865),
  [1620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1622] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(850),
  [1628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(835),
  [1634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(787),
  [1636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(802),
  [1640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(808),
  [1642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(817),
  [1646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(825),
  [1650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(775),
  [1656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(772),
  [1658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(757),
  [1662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(756),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_concat = 0,
  ts_external_token__ns_delim = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_concat] = sym_concat,
  [ts_external_token__ns_delim] = sym__ns_delim,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_concat] = true,
    [ts_external_token__ns_delim] = true,
  },
  [2] = {
    [ts_external_token_concat] = true,
  },
  [3] = {
    [ts_external_token__ns_delim] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_tcl_external_scanner_create(void);
void tree_sitter_tcl_external_scanner_destroy(void *);
bool tree_sitter_tcl_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_tcl_external_scanner_serialize(void *, char *);
void tree_sitter_tcl_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_tcl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_simple_word,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_tcl_external_scanner_create,
      tree_sitter_tcl_external_scanner_destroy,
      tree_sitter_tcl_external_scanner_scan,
      tree_sitter_tcl_external_scanner_serialize,
      tree_sitter_tcl_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
