#include <stdint.h>

struct unicode_range {
	uint32_t min;
	uint32_t max;
};

#define UCD_LEN_XID_START 666
static struct unicode_range ucd_table_xid_start[666] = {
    {0x00000041, 0x0000005a},
    {0x00000061, 0x0000007a},
    {0x000000aa, 0x000000aa},
    {0x000000b5, 0x000000b5},
    {0x000000ba, 0x000000ba},
    {0x000000c0, 0x000000d6},
    {0x000000d8, 0x000000f6},
    {0x000000f8, 0x000002c1},
    {0x000002c6, 0x000002d1},
    {0x000002e0, 0x000002e4},
    {0x000002ec, 0x000002ec},
    {0x000002ee, 0x000002ee},
    {0x00000370, 0x00000374},
    {0x00000376, 0x00000377},
    {0x0000037b, 0x0000037d},
    {0x0000037f, 0x0000037f},
    {0x00000386, 0x00000386},
    {0x00000388, 0x0000038a},
    {0x0000038c, 0x0000038c},
    {0x0000038e, 0x000003a1},
    {0x000003a3, 0x000003f5},
    {0x000003f7, 0x00000481},
    {0x0000048a, 0x0000052f},
    {0x00000531, 0x00000556},
    {0x00000559, 0x00000559},
    {0x00000560, 0x00000588},
    {0x000005d0, 0x000005ea},
    {0x000005ef, 0x000005f2},
    {0x00000620, 0x0000064a},
    {0x0000066e, 0x0000066f},
    {0x00000671, 0x000006d3},
    {0x000006d5, 0x000006d5},
    {0x000006e5, 0x000006e6},
    {0x000006ee, 0x000006ef},
    {0x000006fa, 0x000006fc},
    {0x000006ff, 0x000006ff},
    {0x00000710, 0x00000710},
    {0x00000712, 0x0000072f},
    {0x0000074d, 0x000007a5},
    {0x000007b1, 0x000007b1},
    {0x000007ca, 0x000007ea},
    {0x000007f4, 0x000007f5},
    {0x000007fa, 0x000007fa},
    {0x00000800, 0x00000815},
    {0x0000081a, 0x0000081a},
    {0x00000824, 0x00000824},
    {0x00000828, 0x00000828},
    {0x00000840, 0x00000858},
    {0x00000860, 0x0000086a},
    {0x00000870, 0x00000887},
    {0x00000889, 0x0000088e},
    {0x000008a0, 0x000008c9},
    {0x00000904, 0x00000939},
    {0x0000093d, 0x0000093d},
    {0x00000950, 0x00000950},
    {0x00000958, 0x00000961},
    {0x00000971, 0x00000980},
    {0x00000985, 0x0000098c},
    {0x0000098f, 0x00000990},
    {0x00000993, 0x000009a8},
    {0x000009aa, 0x000009b0},
    {0x000009b2, 0x000009b2},
    {0x000009b6, 0x000009b9},
    {0x000009bd, 0x000009bd},
    {0x000009ce, 0x000009ce},
    {0x000009dc, 0x000009dd},
    {0x000009df, 0x000009e1},
    {0x000009f0, 0x000009f1},
    {0x000009fc, 0x000009fc},
    {0x00000a05, 0x00000a0a},
    {0x00000a0f, 0x00000a10},
    {0x00000a13, 0x00000a28},
    {0x00000a2a, 0x00000a30},
    {0x00000a32, 0x00000a33},
    {0x00000a35, 0x00000a36},
    {0x00000a38, 0x00000a39},
    {0x00000a59, 0x00000a5c},
    {0x00000a5e, 0x00000a5e},
    {0x00000a72, 0x00000a74},
    {0x00000a85, 0x00000a8d},
    {0x00000a8f, 0x00000a91},
    {0x00000a93, 0x00000aa8},
    {0x00000aaa, 0x00000ab0},
    {0x00000ab2, 0x00000ab3},
    {0x00000ab5, 0x00000ab9},
    {0x00000abd, 0x00000abd},
    {0x00000ad0, 0x00000ad0},
    {0x00000ae0, 0x00000ae1},
    {0x00000af9, 0x00000af9},
    {0x00000b05, 0x00000b0c},
    {0x00000b0f, 0x00000b10},
    {0x00000b13, 0x00000b28},
    {0x00000b2a, 0x00000b30},
    {0x00000b32, 0x00000b33},
    {0x00000b35, 0x00000b39},
    {0x00000b3d, 0x00000b3d},
    {0x00000b5c, 0x00000b5d},
    {0x00000b5f, 0x00000b61},
    {0x00000b71, 0x00000b71},
    {0x00000b83, 0x00000b83},
    {0x00000b85, 0x00000b8a},
    {0x00000b8e, 0x00000b90},
    {0x00000b92, 0x00000b95},
    {0x00000b99, 0x00000b9a},
    {0x00000b9c, 0x00000b9c},
    {0x00000b9e, 0x00000b9f},
    {0x00000ba3, 0x00000ba4},
    {0x00000ba8, 0x00000baa},
    {0x00000bae, 0x00000bb9},
    {0x00000bd0, 0x00000bd0},
    {0x00000c05, 0x00000c0c},
    {0x00000c0e, 0x00000c10},
    {0x00000c12, 0x00000c28},
    {0x00000c2a, 0x00000c39},
    {0x00000c3d, 0x00000c3d},
    {0x00000c58, 0x00000c5a},
    {0x00000c5d, 0x00000c5d},
    {0x00000c60, 0x00000c61},
    {0x00000c80, 0x00000c80},
    {0x00000c85, 0x00000c8c},
    {0x00000c8e, 0x00000c90},
    {0x00000c92, 0x00000ca8},
    {0x00000caa, 0x00000cb3},
    {0x00000cb5, 0x00000cb9},
    {0x00000cbd, 0x00000cbd},
    {0x00000cdd, 0x00000cde},
    {0x00000ce0, 0x00000ce1},
    {0x00000cf1, 0x00000cf2},
    {0x00000d04, 0x00000d0c},
    {0x00000d0e, 0x00000d10},
    {0x00000d12, 0x00000d3a},
    {0x00000d3d, 0x00000d3d},
    {0x00000d4e, 0x00000d4e},
    {0x00000d54, 0x00000d56},
    {0x00000d5f, 0x00000d61},
    {0x00000d7a, 0x00000d7f},
    {0x00000d85, 0x00000d96},
    {0x00000d9a, 0x00000db1},
    {0x00000db3, 0x00000dbb},
    {0x00000dbd, 0x00000dbd},
    {0x00000dc0, 0x00000dc6},
    {0x00000e01, 0x00000e30},
    {0x00000e32, 0x00000e32},
    {0x00000e40, 0x00000e46},
    {0x00000e81, 0x00000e82},
    {0x00000e84, 0x00000e84},
    {0x00000e86, 0x00000e8a},
    {0x00000e8c, 0x00000ea3},
    {0x00000ea5, 0x00000ea5},
    {0x00000ea7, 0x00000eb0},
    {0x00000eb2, 0x00000eb2},
    {0x00000ebd, 0x00000ebd},
    {0x00000ec0, 0x00000ec4},
    {0x00000ec6, 0x00000ec6},
    {0x00000edc, 0x00000edf},
    {0x00000f00, 0x00000f00},
    {0x00000f40, 0x00000f47},
    {0x00000f49, 0x00000f6c},
    {0x00000f88, 0x00000f8c},
    {0x00001000, 0x0000102a},
    {0x0000103f, 0x0000103f},
    {0x00001050, 0x00001055},
    {0x0000105a, 0x0000105d},
    {0x00001061, 0x00001061},
    {0x00001065, 0x00001066},
    {0x0000106e, 0x00001070},
    {0x00001075, 0x00001081},
    {0x0000108e, 0x0000108e},
    {0x000010a0, 0x000010c5},
    {0x000010c7, 0x000010c7},
    {0x000010cd, 0x000010cd},
    {0x000010d0, 0x000010fa},
    {0x000010fc, 0x00001248},
    {0x0000124a, 0x0000124d},
    {0x00001250, 0x00001256},
    {0x00001258, 0x00001258},
    {0x0000125a, 0x0000125d},
    {0x00001260, 0x00001288},
    {0x0000128a, 0x0000128d},
    {0x00001290, 0x000012b0},
    {0x000012b2, 0x000012b5},
    {0x000012b8, 0x000012be},
    {0x000012c0, 0x000012c0},
    {0x000012c2, 0x000012c5},
    {0x000012c8, 0x000012d6},
    {0x000012d8, 0x00001310},
    {0x00001312, 0x00001315},
    {0x00001318, 0x0000135a},
    {0x00001380, 0x0000138f},
    {0x000013a0, 0x000013f5},
    {0x000013f8, 0x000013fd},
    {0x00001401, 0x0000166c},
    {0x0000166f, 0x0000167f},
    {0x00001681, 0x0000169a},
    {0x000016a0, 0x000016ea},
    {0x000016ee, 0x000016f8},
    {0x00001700, 0x00001711},
    {0x0000171f, 0x00001731},
    {0x00001740, 0x00001751},
    {0x00001760, 0x0000176c},
    {0x0000176e, 0x00001770},
    {0x00001780, 0x000017b3},
    {0x000017d7, 0x000017d7},
    {0x000017dc, 0x000017dc},
    {0x00001820, 0x00001878},
    {0x00001880, 0x000018a8},
    {0x000018aa, 0x000018aa},
    {0x000018b0, 0x000018f5},
    {0x00001900, 0x0000191e},
    {0x00001950, 0x0000196d},
    {0x00001970, 0x00001974},
    {0x00001980, 0x000019ab},
    {0x000019b0, 0x000019c9},
    {0x00001a00, 0x00001a16},
    {0x00001a20, 0x00001a54},
    {0x00001aa7, 0x00001aa7},
    {0x00001b05, 0x00001b33},
    {0x00001b45, 0x00001b4c},
    {0x00001b83, 0x00001ba0},
    {0x00001bae, 0x00001baf},
    {0x00001bba, 0x00001be5},
    {0x00001c00, 0x00001c23},
    {0x00001c4d, 0x00001c4f},
    {0x00001c5a, 0x00001c7d},
    {0x00001c80, 0x00001c88},
    {0x00001c90, 0x00001cba},
    {0x00001cbd, 0x00001cbf},
    {0x00001ce9, 0x00001cec},
    {0x00001cee, 0x00001cf3},
    {0x00001cf5, 0x00001cf6},
    {0x00001cfa, 0x00001cfa},
    {0x00001d00, 0x00001dbf},
    {0x00001e00, 0x00001f15},
    {0x00001f18, 0x00001f1d},
    {0x00001f20, 0x00001f45},
    {0x00001f48, 0x00001f4d},
    {0x00001f50, 0x00001f57},
    {0x00001f59, 0x00001f59},
    {0x00001f5b, 0x00001f5b},
    {0x00001f5d, 0x00001f5d},
    {0x00001f5f, 0x00001f7d},
    {0x00001f80, 0x00001fb4},
    {0x00001fb6, 0x00001fbc},
    {0x00001fbe, 0x00001fbe},
    {0x00001fc2, 0x00001fc4},
    {0x00001fc6, 0x00001fcc},
    {0x00001fd0, 0x00001fd3},
    {0x00001fd6, 0x00001fdb},
    {0x00001fe0, 0x00001fec},
    {0x00001ff2, 0x00001ff4},
    {0x00001ff6, 0x00001ffc},
    {0x00002071, 0x00002071},
    {0x0000207f, 0x0000207f},
    {0x00002090, 0x0000209c},
    {0x00002102, 0x00002102},
    {0x00002107, 0x00002107},
    {0x0000210a, 0x00002113},
    {0x00002115, 0x00002115},
    {0x00002118, 0x0000211d},
    {0x00002124, 0x00002124},
    {0x00002126, 0x00002126},
    {0x00002128, 0x00002128},
    {0x0000212a, 0x00002139},
    {0x0000213c, 0x0000213f},
    {0x00002145, 0x00002149},
    {0x0000214e, 0x0000214e},
    {0x00002160, 0x00002188},
    {0x00002c00, 0x00002ce4},
    {0x00002ceb, 0x00002cee},
    {0x00002cf2, 0x00002cf3},
    {0x00002d00, 0x00002d25},
    {0x00002d27, 0x00002d27},
    {0x00002d2d, 0x00002d2d},
    {0x00002d30, 0x00002d67},
    {0x00002d6f, 0x00002d6f},
    {0x00002d80, 0x00002d96},
    {0x00002da0, 0x00002da6},
    {0x00002da8, 0x00002dae},
    {0x00002db0, 0x00002db6},
    {0x00002db8, 0x00002dbe},
    {0x00002dc0, 0x00002dc6},
    {0x00002dc8, 0x00002dce},
    {0x00002dd0, 0x00002dd6},
    {0x00002dd8, 0x00002dde},
    {0x00003005, 0x00003007},
    {0x00003021, 0x00003029},
    {0x00003031, 0x00003035},
    {0x00003038, 0x0000303c},
    {0x00003041, 0x00003096},
    {0x0000309d, 0x0000309f},
    {0x000030a1, 0x000030fa},
    {0x000030fc, 0x000030ff},
    {0x00003105, 0x0000312f},
    {0x00003131, 0x0000318e},
    {0x000031a0, 0x000031bf},
    {0x000031f0, 0x000031ff},
    {0x00003400, 0x00004dbf},
    {0x00004e00, 0x0000a48c},
    {0x0000a4d0, 0x0000a4fd},
    {0x0000a500, 0x0000a60c},
    {0x0000a610, 0x0000a61f},
    {0x0000a62a, 0x0000a62b},
    {0x0000a640, 0x0000a66e},
    {0x0000a67f, 0x0000a69d},
    {0x0000a6a0, 0x0000a6ef},
    {0x0000a717, 0x0000a71f},
    {0x0000a722, 0x0000a788},
    {0x0000a78b, 0x0000a7ca},
    {0x0000a7d0, 0x0000a7d1},
    {0x0000a7d3, 0x0000a7d3},
    {0x0000a7d5, 0x0000a7d9},
    {0x0000a7f2, 0x0000a801},
    {0x0000a803, 0x0000a805},
    {0x0000a807, 0x0000a80a},
    {0x0000a80c, 0x0000a822},
    {0x0000a840, 0x0000a873},
    {0x0000a882, 0x0000a8b3},
    {0x0000a8f2, 0x0000a8f7},
    {0x0000a8fb, 0x0000a8fb},
    {0x0000a8fd, 0x0000a8fe},
    {0x0000a90a, 0x0000a925},
    {0x0000a930, 0x0000a946},
    {0x0000a960, 0x0000a97c},
    {0x0000a984, 0x0000a9b2},
    {0x0000a9cf, 0x0000a9cf},
    {0x0000a9e0, 0x0000a9e4},
    {0x0000a9e6, 0x0000a9ef},
    {0x0000a9fa, 0x0000a9fe},
    {0x0000aa00, 0x0000aa28},
    {0x0000aa40, 0x0000aa42},
    {0x0000aa44, 0x0000aa4b},
    {0x0000aa60, 0x0000aa76},
    {0x0000aa7a, 0x0000aa7a},
    {0x0000aa7e, 0x0000aaaf},
    {0x0000aab1, 0x0000aab1},
    {0x0000aab5, 0x0000aab6},
    {0x0000aab9, 0x0000aabd},
    {0x0000aac0, 0x0000aac0},
    {0x0000aac2, 0x0000aac2},
    {0x0000aadb, 0x0000aadd},
    {0x0000aae0, 0x0000aaea},
    {0x0000aaf2, 0x0000aaf4},
    {0x0000ab01, 0x0000ab06},
    {0x0000ab09, 0x0000ab0e},
    {0x0000ab11, 0x0000ab16},
    {0x0000ab20, 0x0000ab26},
    {0x0000ab28, 0x0000ab2e},
    {0x0000ab30, 0x0000ab5a},
    {0x0000ab5c, 0x0000ab69},
    {0x0000ab70, 0x0000abe2},
    {0x0000ac00, 0x0000d7a3},
    {0x0000d7b0, 0x0000d7c6},
    {0x0000d7cb, 0x0000d7fb},
    {0x0000f900, 0x0000fa6d},
    {0x0000fa70, 0x0000fad9},
    {0x0000fb00, 0x0000fb06},
    {0x0000fb13, 0x0000fb17},
    {0x0000fb1d, 0x0000fb1d},
    {0x0000fb1f, 0x0000fb28},
    {0x0000fb2a, 0x0000fb36},
    {0x0000fb38, 0x0000fb3c},
    {0x0000fb3e, 0x0000fb3e},
    {0x0000fb40, 0x0000fb41},
    {0x0000fb43, 0x0000fb44},
    {0x0000fb46, 0x0000fbb1},
    {0x0000fbd3, 0x0000fc5d},
    {0x0000fc64, 0x0000fd3d},
    {0x0000fd50, 0x0000fd8f},
    {0x0000fd92, 0x0000fdc7},
    {0x0000fdf0, 0x0000fdf9},
    {0x0000fe71, 0x0000fe71},
    {0x0000fe73, 0x0000fe73},
    {0x0000fe77, 0x0000fe77},
    {0x0000fe79, 0x0000fe79},
    {0x0000fe7b, 0x0000fe7b},
    {0x0000fe7d, 0x0000fe7d},
    {0x0000fe7f, 0x0000fefc},
    {0x0000ff21, 0x0000ff3a},
    {0x0000ff41, 0x0000ff5a},
    {0x0000ff66, 0x0000ff9d},
    {0x0000ffa0, 0x0000ffbe},
    {0x0000ffc2, 0x0000ffc7},
    {0x0000ffca, 0x0000ffcf},
    {0x0000ffd2, 0x0000ffd7},
    {0x0000ffda, 0x0000ffdc},
    {0x00010000, 0x0001000b},
    {0x0001000d, 0x00010026},
    {0x00010028, 0x0001003a},
    {0x0001003c, 0x0001003d},
    {0x0001003f, 0x0001004d},
    {0x00010050, 0x0001005d},
    {0x00010080, 0x000100fa},
    {0x00010140, 0x00010174},
    {0x00010280, 0x0001029c},
    {0x000102a0, 0x000102d0},
    {0x00010300, 0x0001031f},
    {0x0001032d, 0x0001034a},
    {0x00010350, 0x00010375},
    {0x00010380, 0x0001039d},
    {0x000103a0, 0x000103c3},
    {0x000103c8, 0x000103cf},
    {0x000103d1, 0x000103d5},
    {0x00010400, 0x0001049d},
    {0x000104b0, 0x000104d3},
    {0x000104d8, 0x000104fb},
    {0x00010500, 0x00010527},
    {0x00010530, 0x00010563},
    {0x00010570, 0x0001057a},
    {0x0001057c, 0x0001058a},
    {0x0001058c, 0x00010592},
    {0x00010594, 0x00010595},
    {0x00010597, 0x000105a1},
    {0x000105a3, 0x000105b1},
    {0x000105b3, 0x000105b9},
    {0x000105bb, 0x000105bc},
    {0x00010600, 0x00010736},
    {0x00010740, 0x00010755},
    {0x00010760, 0x00010767},
    {0x00010780, 0x00010785},
    {0x00010787, 0x000107b0},
    {0x000107b2, 0x000107ba},
    {0x00010800, 0x00010805},
    {0x00010808, 0x00010808},
    {0x0001080a, 0x00010835},
    {0x00010837, 0x00010838},
    {0x0001083c, 0x0001083c},
    {0x0001083f, 0x00010855},
    {0x00010860, 0x00010876},
    {0x00010880, 0x0001089e},
    {0x000108e0, 0x000108f2},
    {0x000108f4, 0x000108f5},
    {0x00010900, 0x00010915},
    {0x00010920, 0x00010939},
    {0x00010980, 0x000109b7},
    {0x000109be, 0x000109bf},
    {0x00010a00, 0x00010a00},
    {0x00010a10, 0x00010a13},
    {0x00010a15, 0x00010a17},
    {0x00010a19, 0x00010a35},
    {0x00010a60, 0x00010a7c},
    {0x00010a80, 0x00010a9c},
    {0x00010ac0, 0x00010ac7},
    {0x00010ac9, 0x00010ae4},
    {0x00010b00, 0x00010b35},
    {0x00010b40, 0x00010b55},
    {0x00010b60, 0x00010b72},
    {0x00010b80, 0x00010b91},
    {0x00010c00, 0x00010c48},
    {0x00010c80, 0x00010cb2},
    {0x00010cc0, 0x00010cf2},
    {0x00010d00, 0x00010d23},
    {0x00010e80, 0x00010ea9},
    {0x00010eb0, 0x00010eb1},
    {0x00010f00, 0x00010f1c},
    {0x00010f27, 0x00010f27},
    {0x00010f30, 0x00010f45},
    {0x00010f70, 0x00010f81},
    {0x00010fb0, 0x00010fc4},
    {0x00010fe0, 0x00010ff6},
    {0x00011003, 0x00011037},
    {0x00011071, 0x00011072},
    {0x00011075, 0x00011075},
    {0x00011083, 0x000110af},
    {0x000110d0, 0x000110e8},
    {0x00011103, 0x00011126},
    {0x00011144, 0x00011144},
    {0x00011147, 0x00011147},
    {0x00011150, 0x00011172},
    {0x00011176, 0x00011176},
    {0x00011183, 0x000111b2},
    {0x000111c1, 0x000111c4},
    {0x000111da, 0x000111da},
    {0x000111dc, 0x000111dc},
    {0x00011200, 0x00011211},
    {0x00011213, 0x0001122b},
    {0x0001123f, 0x00011240},
    {0x00011280, 0x00011286},
    {0x00011288, 0x00011288},
    {0x0001128a, 0x0001128d},
    {0x0001128f, 0x0001129d},
    {0x0001129f, 0x000112a8},
    {0x000112b0, 0x000112de},
    {0x00011305, 0x0001130c},
    {0x0001130f, 0x00011310},
    {0x00011313, 0x00011328},
    {0x0001132a, 0x00011330},
    {0x00011332, 0x00011333},
    {0x00011335, 0x00011339},
    {0x0001133d, 0x0001133d},
    {0x00011350, 0x00011350},
    {0x0001135d, 0x00011361},
    {0x00011400, 0x00011434},
    {0x00011447, 0x0001144a},
    {0x0001145f, 0x00011461},
    {0x00011480, 0x000114af},
    {0x000114c4, 0x000114c5},
    {0x000114c7, 0x000114c7},
    {0x00011580, 0x000115ae},
    {0x000115d8, 0x000115db},
    {0x00011600, 0x0001162f},
    {0x00011644, 0x00011644},
    {0x00011680, 0x000116aa},
    {0x000116b8, 0x000116b8},
    {0x00011700, 0x0001171a},
    {0x00011740, 0x00011746},
    {0x00011800, 0x0001182b},
    {0x000118a0, 0x000118df},
    {0x000118ff, 0x00011906},
    {0x00011909, 0x00011909},
    {0x0001190c, 0x00011913},
    {0x00011915, 0x00011916},
    {0x00011918, 0x0001192f},
    {0x0001193f, 0x0001193f},
    {0x00011941, 0x00011941},
    {0x000119a0, 0x000119a7},
    {0x000119aa, 0x000119d0},
    {0x000119e1, 0x000119e1},
    {0x000119e3, 0x000119e3},
    {0x00011a00, 0x00011a00},
    {0x00011a0b, 0x00011a32},
    {0x00011a3a, 0x00011a3a},
    {0x00011a50, 0x00011a50},
    {0x00011a5c, 0x00011a89},
    {0x00011a9d, 0x00011a9d},
    {0x00011ab0, 0x00011af8},
    {0x00011c00, 0x00011c08},
    {0x00011c0a, 0x00011c2e},
    {0x00011c40, 0x00011c40},
    {0x00011c72, 0x00011c8f},
    {0x00011d00, 0x00011d06},
    {0x00011d08, 0x00011d09},
    {0x00011d0b, 0x00011d30},
    {0x00011d46, 0x00011d46},
    {0x00011d60, 0x00011d65},
    {0x00011d67, 0x00011d68},
    {0x00011d6a, 0x00011d89},
    {0x00011d98, 0x00011d98},
    {0x00011ee0, 0x00011ef2},
    {0x00011f02, 0x00011f02},
    {0x00011f04, 0x00011f10},
    {0x00011f12, 0x00011f33},
    {0x00011fb0, 0x00011fb0},
    {0x00012000, 0x00012399},
    {0x00012400, 0x0001246e},
    {0x00012480, 0x00012543},
    {0x00012f90, 0x00012ff0},
    {0x00013000, 0x0001342f},
    {0x00013441, 0x00013446},
    {0x00014400, 0x00014646},
    {0x00016800, 0x00016a38},
    {0x00016a40, 0x00016a5e},
    {0x00016a70, 0x00016abe},
    {0x00016ad0, 0x00016aed},
    {0x00016b00, 0x00016b2f},
    {0x00016b40, 0x00016b43},
    {0x00016b63, 0x00016b77},
    {0x00016b7d, 0x00016b8f},
    {0x00016e40, 0x00016e7f},
    {0x00016f00, 0x00016f4a},
    {0x00016f50, 0x00016f50},
    {0x00016f93, 0x00016f9f},
    {0x00016fe0, 0x00016fe1},
    {0x00016fe3, 0x00016fe3},
    {0x00017000, 0x000187f7},
    {0x00018800, 0x00018cd5},
    {0x00018d00, 0x00018d08},
    {0x0001aff0, 0x0001aff3},
    {0x0001aff5, 0x0001affb},
    {0x0001affd, 0x0001affe},
    {0x0001b000, 0x0001b122},
    {0x0001b132, 0x0001b132},
    {0x0001b150, 0x0001b152},
    {0x0001b155, 0x0001b155},
    {0x0001b164, 0x0001b167},
    {0x0001b170, 0x0001b2fb},
    {0x0001bc00, 0x0001bc6a},
    {0x0001bc70, 0x0001bc7c},
    {0x0001bc80, 0x0001bc88},
    {0x0001bc90, 0x0001bc99},
    {0x0001d400, 0x0001d454},
    {0x0001d456, 0x0001d49c},
    {0x0001d49e, 0x0001d49f},
    {0x0001d4a2, 0x0001d4a2},
    {0x0001d4a5, 0x0001d4a6},
    {0x0001d4a9, 0x0001d4ac},
    {0x0001d4ae, 0x0001d4b9},
    {0x0001d4bb, 0x0001d4bb},
    {0x0001d4bd, 0x0001d4c3},
    {0x0001d4c5, 0x0001d505},
    {0x0001d507, 0x0001d50a},
    {0x0001d50d, 0x0001d514},
    {0x0001d516, 0x0001d51c},
    {0x0001d51e, 0x0001d539},
    {0x0001d53b, 0x0001d53e},
    {0x0001d540, 0x0001d544},
    {0x0001d546, 0x0001d546},
    {0x0001d54a, 0x0001d550},
    {0x0001d552, 0x0001d6a5},
    {0x0001d6a8, 0x0001d6c0},
    {0x0001d6c2, 0x0001d6da},
    {0x0001d6dc, 0x0001d6fa},
    {0x0001d6fc, 0x0001d714},
    {0x0001d716, 0x0001d734},
    {0x0001d736, 0x0001d74e},
    {0x0001d750, 0x0001d76e},
    {0x0001d770, 0x0001d788},
    {0x0001d78a, 0x0001d7a8},
    {0x0001d7aa, 0x0001d7c2},
    {0x0001d7c4, 0x0001d7cb},
    {0x0001df00, 0x0001df1e},
    {0x0001df25, 0x0001df2a},
    {0x0001e030, 0x0001e06d},
    {0x0001e100, 0x0001e12c},
    {0x0001e137, 0x0001e13d},
    {0x0001e14e, 0x0001e14e},
    {0x0001e290, 0x0001e2ad},
    {0x0001e2c0, 0x0001e2eb},
    {0x0001e4d0, 0x0001e4eb},
    {0x0001e7e0, 0x0001e7e6},
    {0x0001e7e8, 0x0001e7eb},
    {0x0001e7ed, 0x0001e7ee},
    {0x0001e7f0, 0x0001e7fe},
    {0x0001e800, 0x0001e8c4},
    {0x0001e900, 0x0001e943},
    {0x0001e94b, 0x0001e94b},
    {0x0001ee00, 0x0001ee03},
    {0x0001ee05, 0x0001ee1f},
    {0x0001ee21, 0x0001ee22},
    {0x0001ee24, 0x0001ee24},
    {0x0001ee27, 0x0001ee27},
    {0x0001ee29, 0x0001ee32},
    {0x0001ee34, 0x0001ee37},
    {0x0001ee39, 0x0001ee39},
    {0x0001ee3b, 0x0001ee3b},
    {0x0001ee42, 0x0001ee42},
    {0x0001ee47, 0x0001ee47},
    {0x0001ee49, 0x0001ee49},
    {0x0001ee4b, 0x0001ee4b},
    {0x0001ee4d, 0x0001ee4f},
    {0x0001ee51, 0x0001ee52},
    {0x0001ee54, 0x0001ee54},
    {0x0001ee57, 0x0001ee57},
    {0x0001ee59, 0x0001ee59},
    {0x0001ee5b, 0x0001ee5b},
    {0x0001ee5d, 0x0001ee5d},
    {0x0001ee5f, 0x0001ee5f},
    {0x0001ee61, 0x0001ee62},
    {0x0001ee64, 0x0001ee64},
    {0x0001ee67, 0x0001ee6a},
    {0x0001ee6c, 0x0001ee72},
    {0x0001ee74, 0x0001ee77},
    {0x0001ee79, 0x0001ee7c},
    {0x0001ee7e, 0x0001ee7e},
    {0x0001ee80, 0x0001ee89},
    {0x0001ee8b, 0x0001ee9b},
    {0x0001eea1, 0x0001eea3},
    {0x0001eea5, 0x0001eea9},
    {0x0001eeab, 0x0001eebb},
    {0x00020000, 0x0002a6df},
    {0x0002a700, 0x0002b739},
    {0x0002b740, 0x0002b81d},
    {0x0002b820, 0x0002cea1},
    {0x0002ceb0, 0x0002ebe0},
    {0x0002f800, 0x0002fa1d},
    {0x00030000, 0x0003134a},
    {0x00031350, 0x000323af},
};

#define UCD_LEN_XID_CONTINUE 775
static struct unicode_range ucd_table_xid_continue[775] = {
    {0x00000030, 0x00000039},
    {0x00000041, 0x0000005a},
    {0x0000005f, 0x0000005f},
    {0x00000061, 0x0000007a},
    {0x000000aa, 0x000000aa},
    {0x000000b5, 0x000000b5},
    {0x000000b7, 0x000000b7},
    {0x000000ba, 0x000000ba},
    {0x000000c0, 0x000000d6},
    {0x000000d8, 0x000000f6},
    {0x000000f8, 0x000002c1},
    {0x000002c6, 0x000002d1},
    {0x000002e0, 0x000002e4},
    {0x000002ec, 0x000002ec},
    {0x000002ee, 0x000002ee},
    {0x00000300, 0x00000374},
    {0x00000376, 0x00000377},
    {0x0000037b, 0x0000037d},
    {0x0000037f, 0x0000037f},
    {0x00000386, 0x0000038a},
    {0x0000038c, 0x0000038c},
    {0x0000038e, 0x000003a1},
    {0x000003a3, 0x000003f5},
    {0x000003f7, 0x00000481},
    {0x00000483, 0x00000487},
    {0x0000048a, 0x0000052f},
    {0x00000531, 0x00000556},
    {0x00000559, 0x00000559},
    {0x00000560, 0x00000588},
    {0x00000591, 0x000005bd},
    {0x000005bf, 0x000005bf},
    {0x000005c1, 0x000005c2},
    {0x000005c4, 0x000005c5},
    {0x000005c7, 0x000005c7},
    {0x000005d0, 0x000005ea},
    {0x000005ef, 0x000005f2},
    {0x00000610, 0x0000061a},
    {0x00000620, 0x00000669},
    {0x0000066e, 0x000006d3},
    {0x000006d5, 0x000006dc},
    {0x000006df, 0x000006e8},
    {0x000006ea, 0x000006fc},
    {0x000006ff, 0x000006ff},
    {0x00000710, 0x0000074a},
    {0x0000074d, 0x000007b1},
    {0x000007c0, 0x000007f5},
    {0x000007fa, 0x000007fa},
    {0x000007fd, 0x000007fd},
    {0x00000800, 0x0000082d},
    {0x00000840, 0x0000085b},
    {0x00000860, 0x0000086a},
    {0x00000870, 0x00000887},
    {0x00000889, 0x0000088e},
    {0x00000898, 0x000008e1},
    {0x000008e3, 0x00000963},
    {0x00000966, 0x0000096f},
    {0x00000971, 0x00000983},
    {0x00000985, 0x0000098c},
    {0x0000098f, 0x00000990},
    {0x00000993, 0x000009a8},
    {0x000009aa, 0x000009b0},
    {0x000009b2, 0x000009b2},
    {0x000009b6, 0x000009b9},
    {0x000009bc, 0x000009c4},
    {0x000009c7, 0x000009c8},
    {0x000009cb, 0x000009ce},
    {0x000009d7, 0x000009d7},
    {0x000009dc, 0x000009dd},
    {0x000009df, 0x000009e3},
    {0x000009e6, 0x000009f1},
    {0x000009fc, 0x000009fc},
    {0x000009fe, 0x000009fe},
    {0x00000a01, 0x00000a03},
    {0x00000a05, 0x00000a0a},
    {0x00000a0f, 0x00000a10},
    {0x00000a13, 0x00000a28},
    {0x00000a2a, 0x00000a30},
    {0x00000a32, 0x00000a33},
    {0x00000a35, 0x00000a36},
    {0x00000a38, 0x00000a39},
    {0x00000a3c, 0x00000a3c},
    {0x00000a3e, 0x00000a42},
    {0x00000a47, 0x00000a48},
    {0x00000a4b, 0x00000a4d},
    {0x00000a51, 0x00000a51},
    {0x00000a59, 0x00000a5c},
    {0x00000a5e, 0x00000a5e},
    {0x00000a66, 0x00000a75},
    {0x00000a81, 0x00000a83},
    {0x00000a85, 0x00000a8d},
    {0x00000a8f, 0x00000a91},
    {0x00000a93, 0x00000aa8},
    {0x00000aaa, 0x00000ab0},
    {0x00000ab2, 0x00000ab3},
    {0x00000ab5, 0x00000ab9},
    {0x00000abc, 0x00000ac5},
    {0x00000ac7, 0x00000ac9},
    {0x00000acb, 0x00000acd},
    {0x00000ad0, 0x00000ad0},
    {0x00000ae0, 0x00000ae3},
    {0x00000ae6, 0x00000aef},
    {0x00000af9, 0x00000aff},
    {0x00000b01, 0x00000b03},
    {0x00000b05, 0x00000b0c},
    {0x00000b0f, 0x00000b10},
    {0x00000b13, 0x00000b28},
    {0x00000b2a, 0x00000b30},
    {0x00000b32, 0x00000b33},
    {0x00000b35, 0x00000b39},
    {0x00000b3c, 0x00000b44},
    {0x00000b47, 0x00000b48},
    {0x00000b4b, 0x00000b4d},
    {0x00000b55, 0x00000b57},
    {0x00000b5c, 0x00000b5d},
    {0x00000b5f, 0x00000b63},
    {0x00000b66, 0x00000b6f},
    {0x00000b71, 0x00000b71},
    {0x00000b82, 0x00000b83},
    {0x00000b85, 0x00000b8a},
    {0x00000b8e, 0x00000b90},
    {0x00000b92, 0x00000b95},
    {0x00000b99, 0x00000b9a},
    {0x00000b9c, 0x00000b9c},
    {0x00000b9e, 0x00000b9f},
    {0x00000ba3, 0x00000ba4},
    {0x00000ba8, 0x00000baa},
    {0x00000bae, 0x00000bb9},
    {0x00000bbe, 0x00000bc2},
    {0x00000bc6, 0x00000bc8},
    {0x00000bca, 0x00000bcd},
    {0x00000bd0, 0x00000bd0},
    {0x00000bd7, 0x00000bd7},
    {0x00000be6, 0x00000bef},
    {0x00000c00, 0x00000c0c},
    {0x00000c0e, 0x00000c10},
    {0x00000c12, 0x00000c28},
    {0x00000c2a, 0x00000c39},
    {0x00000c3c, 0x00000c44},
    {0x00000c46, 0x00000c48},
    {0x00000c4a, 0x00000c4d},
    {0x00000c55, 0x00000c56},
    {0x00000c58, 0x00000c5a},
    {0x00000c5d, 0x00000c5d},
    {0x00000c60, 0x00000c63},
    {0x00000c66, 0x00000c6f},
    {0x00000c80, 0x00000c83},
    {0x00000c85, 0x00000c8c},
    {0x00000c8e, 0x00000c90},
    {0x00000c92, 0x00000ca8},
    {0x00000caa, 0x00000cb3},
    {0x00000cb5, 0x00000cb9},
    {0x00000cbc, 0x00000cc4},
    {0x00000cc6, 0x00000cc8},
    {0x00000cca, 0x00000ccd},
    {0x00000cd5, 0x00000cd6},
    {0x00000cdd, 0x00000cde},
    {0x00000ce0, 0x00000ce3},
    {0x00000ce6, 0x00000cef},
    {0x00000cf1, 0x00000cf3},
    {0x00000d00, 0x00000d0c},
    {0x00000d0e, 0x00000d10},
    {0x00000d12, 0x00000d44},
    {0x00000d46, 0x00000d48},
    {0x00000d4a, 0x00000d4e},
    {0x00000d54, 0x00000d57},
    {0x00000d5f, 0x00000d63},
    {0x00000d66, 0x00000d6f},
    {0x00000d7a, 0x00000d7f},
    {0x00000d81, 0x00000d83},
    {0x00000d85, 0x00000d96},
    {0x00000d9a, 0x00000db1},
    {0x00000db3, 0x00000dbb},
    {0x00000dbd, 0x00000dbd},
    {0x00000dc0, 0x00000dc6},
    {0x00000dca, 0x00000dca},
    {0x00000dcf, 0x00000dd4},
    {0x00000dd6, 0x00000dd6},
    {0x00000dd8, 0x00000ddf},
    {0x00000de6, 0x00000def},
    {0x00000df2, 0x00000df3},
    {0x00000e01, 0x00000e3a},
    {0x00000e40, 0x00000e4e},
    {0x00000e50, 0x00000e59},
    {0x00000e81, 0x00000e82},
    {0x00000e84, 0x00000e84},
    {0x00000e86, 0x00000e8a},
    {0x00000e8c, 0x00000ea3},
    {0x00000ea5, 0x00000ea5},
    {0x00000ea7, 0x00000ebd},
    {0x00000ec0, 0x00000ec4},
    {0x00000ec6, 0x00000ec6},
    {0x00000ec8, 0x00000ece},
    {0x00000ed0, 0x00000ed9},
    {0x00000edc, 0x00000edf},
    {0x00000f00, 0x00000f00},
    {0x00000f18, 0x00000f19},
    {0x00000f20, 0x00000f29},
    {0x00000f35, 0x00000f35},
    {0x00000f37, 0x00000f37},
    {0x00000f39, 0x00000f39},
    {0x00000f3e, 0x00000f47},
    {0x00000f49, 0x00000f6c},
    {0x00000f71, 0x00000f84},
    {0x00000f86, 0x00000f97},
    {0x00000f99, 0x00000fbc},
    {0x00000fc6, 0x00000fc6},
    {0x00001000, 0x00001049},
    {0x00001050, 0x0000109d},
    {0x000010a0, 0x000010c5},
    {0x000010c7, 0x000010c7},
    {0x000010cd, 0x000010cd},
    {0x000010d0, 0x000010fa},
    {0x000010fc, 0x00001248},
    {0x0000124a, 0x0000124d},
    {0x00001250, 0x00001256},
    {0x00001258, 0x00001258},
    {0x0000125a, 0x0000125d},
    {0x00001260, 0x00001288},
    {0x0000128a, 0x0000128d},
    {0x00001290, 0x000012b0},
    {0x000012b2, 0x000012b5},
    {0x000012b8, 0x000012be},
    {0x000012c0, 0x000012c0},
    {0x000012c2, 0x000012c5},
    {0x000012c8, 0x000012d6},
    {0x000012d8, 0x00001310},
    {0x00001312, 0x00001315},
    {0x00001318, 0x0000135a},
    {0x0000135d, 0x0000135f},
    {0x00001369, 0x00001371},
    {0x00001380, 0x0000138f},
    {0x000013a0, 0x000013f5},
    {0x000013f8, 0x000013fd},
    {0x00001401, 0x0000166c},
    {0x0000166f, 0x0000167f},
    {0x00001681, 0x0000169a},
    {0x000016a0, 0x000016ea},
    {0x000016ee, 0x000016f8},
    {0x00001700, 0x00001715},
    {0x0000171f, 0x00001734},
    {0x00001740, 0x00001753},
    {0x00001760, 0x0000176c},
    {0x0000176e, 0x00001770},
    {0x00001772, 0x00001773},
    {0x00001780, 0x000017d3},
    {0x000017d7, 0x000017d7},
    {0x000017dc, 0x000017dd},
    {0x000017e0, 0x000017e9},
    {0x0000180b, 0x0000180d},
    {0x0000180f, 0x00001819},
    {0x00001820, 0x00001878},
    {0x00001880, 0x000018aa},
    {0x000018b0, 0x000018f5},
    {0x00001900, 0x0000191e},
    {0x00001920, 0x0000192b},
    {0x00001930, 0x0000193b},
    {0x00001946, 0x0000196d},
    {0x00001970, 0x00001974},
    {0x00001980, 0x000019ab},
    {0x000019b0, 0x000019c9},
    {0x000019d0, 0x000019da},
    {0x00001a00, 0x00001a1b},
    {0x00001a20, 0x00001a5e},
    {0x00001a60, 0x00001a7c},
    {0x00001a7f, 0x00001a89},
    {0x00001a90, 0x00001a99},
    {0x00001aa7, 0x00001aa7},
    {0x00001ab0, 0x00001abd},
    {0x00001abf, 0x00001ace},
    {0x00001b00, 0x00001b4c},
    {0x00001b50, 0x00001b59},
    {0x00001b6b, 0x00001b73},
    {0x00001b80, 0x00001bf3},
    {0x00001c00, 0x00001c37},
    {0x00001c40, 0x00001c49},
    {0x00001c4d, 0x00001c7d},
    {0x00001c80, 0x00001c88},
    {0x00001c90, 0x00001cba},
    {0x00001cbd, 0x00001cbf},
    {0x00001cd0, 0x00001cd2},
    {0x00001cd4, 0x00001cfa},
    {0x00001d00, 0x00001f15},
    {0x00001f18, 0x00001f1d},
    {0x00001f20, 0x00001f45},
    {0x00001f48, 0x00001f4d},
    {0x00001f50, 0x00001f57},
    {0x00001f59, 0x00001f59},
    {0x00001f5b, 0x00001f5b},
    {0x00001f5d, 0x00001f5d},
    {0x00001f5f, 0x00001f7d},
    {0x00001f80, 0x00001fb4},
    {0x00001fb6, 0x00001fbc},
    {0x00001fbe, 0x00001fbe},
    {0x00001fc2, 0x00001fc4},
    {0x00001fc6, 0x00001fcc},
    {0x00001fd0, 0x00001fd3},
    {0x00001fd6, 0x00001fdb},
    {0x00001fe0, 0x00001fec},
    {0x00001ff2, 0x00001ff4},
    {0x00001ff6, 0x00001ffc},
    {0x0000203f, 0x00002040},
    {0x00002054, 0x00002054},
    {0x00002071, 0x00002071},
    {0x0000207f, 0x0000207f},
    {0x00002090, 0x0000209c},
    {0x000020d0, 0x000020dc},
    {0x000020e1, 0x000020e1},
    {0x000020e5, 0x000020f0},
    {0x00002102, 0x00002102},
    {0x00002107, 0x00002107},
    {0x0000210a, 0x00002113},
    {0x00002115, 0x00002115},
    {0x00002118, 0x0000211d},
    {0x00002124, 0x00002124},
    {0x00002126, 0x00002126},
    {0x00002128, 0x00002128},
    {0x0000212a, 0x00002139},
    {0x0000213c, 0x0000213f},
    {0x00002145, 0x00002149},
    {0x0000214e, 0x0000214e},
    {0x00002160, 0x00002188},
    {0x00002c00, 0x00002ce4},
    {0x00002ceb, 0x00002cf3},
    {0x00002d00, 0x00002d25},
    {0x00002d27, 0x00002d27},
    {0x00002d2d, 0x00002d2d},
    {0x00002d30, 0x00002d67},
    {0x00002d6f, 0x00002d6f},
    {0x00002d7f, 0x00002d96},
    {0x00002da0, 0x00002da6},
    {0x00002da8, 0x00002dae},
    {0x00002db0, 0x00002db6},
    {0x00002db8, 0x00002dbe},
    {0x00002dc0, 0x00002dc6},
    {0x00002dc8, 0x00002dce},
    {0x00002dd0, 0x00002dd6},
    {0x00002dd8, 0x00002dde},
    {0x00002de0, 0x00002dff},
    {0x00003005, 0x00003007},
    {0x00003021, 0x0000302f},
    {0x00003031, 0x00003035},
    {0x00003038, 0x0000303c},
    {0x00003041, 0x00003096},
    {0x00003099, 0x0000309a},
    {0x0000309d, 0x0000309f},
    {0x000030a1, 0x000030fa},
    {0x000030fc, 0x000030ff},
    {0x00003105, 0x0000312f},
    {0x00003131, 0x0000318e},
    {0x000031a0, 0x000031bf},
    {0x000031f0, 0x000031ff},
    {0x00003400, 0x00004dbf},
    {0x00004e00, 0x0000a48c},
    {0x0000a4d0, 0x0000a4fd},
    {0x0000a500, 0x0000a60c},
    {0x0000a610, 0x0000a62b},
    {0x0000a640, 0x0000a66f},
    {0x0000a674, 0x0000a67d},
    {0x0000a67f, 0x0000a6f1},
    {0x0000a717, 0x0000a71f},
    {0x0000a722, 0x0000a788},
    {0x0000a78b, 0x0000a7ca},
    {0x0000a7d0, 0x0000a7d1},
    {0x0000a7d3, 0x0000a7d3},
    {0x0000a7d5, 0x0000a7d9},
    {0x0000a7f2, 0x0000a827},
    {0x0000a82c, 0x0000a82c},
    {0x0000a840, 0x0000a873},
    {0x0000a880, 0x0000a8c5},
    {0x0000a8d0, 0x0000a8d9},
    {0x0000a8e0, 0x0000a8f7},
    {0x0000a8fb, 0x0000a8fb},
    {0x0000a8fd, 0x0000a92d},
    {0x0000a930, 0x0000a953},
    {0x0000a960, 0x0000a97c},
    {0x0000a980, 0x0000a9c0},
    {0x0000a9cf, 0x0000a9d9},
    {0x0000a9e0, 0x0000a9fe},
    {0x0000aa00, 0x0000aa36},
    {0x0000aa40, 0x0000aa4d},
    {0x0000aa50, 0x0000aa59},
    {0x0000aa60, 0x0000aa76},
    {0x0000aa7a, 0x0000aac2},
    {0x0000aadb, 0x0000aadd},
    {0x0000aae0, 0x0000aaef},
    {0x0000aaf2, 0x0000aaf6},
    {0x0000ab01, 0x0000ab06},
    {0x0000ab09, 0x0000ab0e},
    {0x0000ab11, 0x0000ab16},
    {0x0000ab20, 0x0000ab26},
    {0x0000ab28, 0x0000ab2e},
    {0x0000ab30, 0x0000ab5a},
    {0x0000ab5c, 0x0000ab69},
    {0x0000ab70, 0x0000abea},
    {0x0000abec, 0x0000abed},
    {0x0000abf0, 0x0000abf9},
    {0x0000ac00, 0x0000d7a3},
    {0x0000d7b0, 0x0000d7c6},
    {0x0000d7cb, 0x0000d7fb},
    {0x0000f900, 0x0000fa6d},
    {0x0000fa70, 0x0000fad9},
    {0x0000fb00, 0x0000fb06},
    {0x0000fb13, 0x0000fb17},
    {0x0000fb1d, 0x0000fb28},
    {0x0000fb2a, 0x0000fb36},
    {0x0000fb38, 0x0000fb3c},
    {0x0000fb3e, 0x0000fb3e},
    {0x0000fb40, 0x0000fb41},
    {0x0000fb43, 0x0000fb44},
    {0x0000fb46, 0x0000fbb1},
    {0x0000fbd3, 0x0000fc5d},
    {0x0000fc64, 0x0000fd3d},
    {0x0000fd50, 0x0000fd8f},
    {0x0000fd92, 0x0000fdc7},
    {0x0000fdf0, 0x0000fdf9},
    {0x0000fe00, 0x0000fe0f},
    {0x0000fe20, 0x0000fe2f},
    {0x0000fe33, 0x0000fe34},
    {0x0000fe4d, 0x0000fe4f},
    {0x0000fe71, 0x0000fe71},
    {0x0000fe73, 0x0000fe73},
    {0x0000fe77, 0x0000fe77},
    {0x0000fe79, 0x0000fe79},
    {0x0000fe7b, 0x0000fe7b},
    {0x0000fe7d, 0x0000fe7d},
    {0x0000fe7f, 0x0000fefc},
    {0x0000ff10, 0x0000ff19},
    {0x0000ff21, 0x0000ff3a},
    {0x0000ff3f, 0x0000ff3f},
    {0x0000ff41, 0x0000ff5a},
    {0x0000ff66, 0x0000ffbe},
    {0x0000ffc2, 0x0000ffc7},
    {0x0000ffca, 0x0000ffcf},
    {0x0000ffd2, 0x0000ffd7},
    {0x0000ffda, 0x0000ffdc},
    {0x00010000, 0x0001000b},
    {0x0001000d, 0x00010026},
    {0x00010028, 0x0001003a},
    {0x0001003c, 0x0001003d},
    {0x0001003f, 0x0001004d},
    {0x00010050, 0x0001005d},
    {0x00010080, 0x000100fa},
    {0x00010140, 0x00010174},
    {0x000101fd, 0x000101fd},
    {0x00010280, 0x0001029c},
    {0x000102a0, 0x000102d0},
    {0x000102e0, 0x000102e0},
    {0x00010300, 0x0001031f},
    {0x0001032d, 0x0001034a},
    {0x00010350, 0x0001037a},
    {0x00010380, 0x0001039d},
    {0x000103a0, 0x000103c3},
    {0x000103c8, 0x000103cf},
    {0x000103d1, 0x000103d5},
    {0x00010400, 0x0001049d},
    {0x000104a0, 0x000104a9},
    {0x000104b0, 0x000104d3},
    {0x000104d8, 0x000104fb},
    {0x00010500, 0x00010527},
    {0x00010530, 0x00010563},
    {0x00010570, 0x0001057a},
    {0x0001057c, 0x0001058a},
    {0x0001058c, 0x00010592},
    {0x00010594, 0x00010595},
    {0x00010597, 0x000105a1},
    {0x000105a3, 0x000105b1},
    {0x000105b3, 0x000105b9},
    {0x000105bb, 0x000105bc},
    {0x00010600, 0x00010736},
    {0x00010740, 0x00010755},
    {0x00010760, 0x00010767},
    {0x00010780, 0x00010785},
    {0x00010787, 0x000107b0},
    {0x000107b2, 0x000107ba},
    {0x00010800, 0x00010805},
    {0x00010808, 0x00010808},
    {0x0001080a, 0x00010835},
    {0x00010837, 0x00010838},
    {0x0001083c, 0x0001083c},
    {0x0001083f, 0x00010855},
    {0x00010860, 0x00010876},
    {0x00010880, 0x0001089e},
    {0x000108e0, 0x000108f2},
    {0x000108f4, 0x000108f5},
    {0x00010900, 0x00010915},
    {0x00010920, 0x00010939},
    {0x00010980, 0x000109b7},
    {0x000109be, 0x000109bf},
    {0x00010a00, 0x00010a03},
    {0x00010a05, 0x00010a06},
    {0x00010a0c, 0x00010a13},
    {0x00010a15, 0x00010a17},
    {0x00010a19, 0x00010a35},
    {0x00010a38, 0x00010a3a},
    {0x00010a3f, 0x00010a3f},
    {0x00010a60, 0x00010a7c},
    {0x00010a80, 0x00010a9c},
    {0x00010ac0, 0x00010ac7},
    {0x00010ac9, 0x00010ae6},
    {0x00010b00, 0x00010b35},
    {0x00010b40, 0x00010b55},
    {0x00010b60, 0x00010b72},
    {0x00010b80, 0x00010b91},
    {0x00010c00, 0x00010c48},
    {0x00010c80, 0x00010cb2},
    {0x00010cc0, 0x00010cf2},
    {0x00010d00, 0x00010d27},
    {0x00010d30, 0x00010d39},
    {0x00010e80, 0x00010ea9},
    {0x00010eab, 0x00010eac},
    {0x00010eb0, 0x00010eb1},
    {0x00010efd, 0x00010f1c},
    {0x00010f27, 0x00010f27},
    {0x00010f30, 0x00010f50},
    {0x00010f70, 0x00010f85},
    {0x00010fb0, 0x00010fc4},
    {0x00010fe0, 0x00010ff6},
    {0x00011000, 0x00011046},
    {0x00011066, 0x00011075},
    {0x0001107f, 0x000110ba},
    {0x000110c2, 0x000110c2},
    {0x000110d0, 0x000110e8},
    {0x000110f0, 0x000110f9},
    {0x00011100, 0x00011134},
    {0x00011136, 0x0001113f},
    {0x00011144, 0x00011147},
    {0x00011150, 0x00011173},
    {0x00011176, 0x00011176},
    {0x00011180, 0x000111c4},
    {0x000111c9, 0x000111cc},
    {0x000111ce, 0x000111da},
    {0x000111dc, 0x000111dc},
    {0x00011200, 0x00011211},
    {0x00011213, 0x00011237},
    {0x0001123e, 0x00011241},
    {0x00011280, 0x00011286},
    {0x00011288, 0x00011288},
    {0x0001128a, 0x0001128d},
    {0x0001128f, 0x0001129d},
    {0x0001129f, 0x000112a8},
    {0x000112b0, 0x000112ea},
    {0x000112f0, 0x000112f9},
    {0x00011300, 0x00011303},
    {0x00011305, 0x0001130c},
    {0x0001130f, 0x00011310},
    {0x00011313, 0x00011328},
    {0x0001132a, 0x00011330},
    {0x00011332, 0x00011333},
    {0x00011335, 0x00011339},
    {0x0001133b, 0x00011344},
    {0x00011347, 0x00011348},
    {0x0001134b, 0x0001134d},
    {0x00011350, 0x00011350},
    {0x00011357, 0x00011357},
    {0x0001135d, 0x00011363},
    {0x00011366, 0x0001136c},
    {0x00011370, 0x00011374},
    {0x00011400, 0x0001144a},
    {0x00011450, 0x00011459},
    {0x0001145e, 0x00011461},
    {0x00011480, 0x000114c5},
    {0x000114c7, 0x000114c7},
    {0x000114d0, 0x000114d9},
    {0x00011580, 0x000115b5},
    {0x000115b8, 0x000115c0},
    {0x000115d8, 0x000115dd},
    {0x00011600, 0x00011640},
    {0x00011644, 0x00011644},
    {0x00011650, 0x00011659},
    {0x00011680, 0x000116b8},
    {0x000116c0, 0x000116c9},
    {0x00011700, 0x0001171a},
    {0x0001171d, 0x0001172b},
    {0x00011730, 0x00011739},
    {0x00011740, 0x00011746},
    {0x00011800, 0x0001183a},
    {0x000118a0, 0x000118e9},
    {0x000118ff, 0x00011906},
    {0x00011909, 0x00011909},
    {0x0001190c, 0x00011913},
    {0x00011915, 0x00011916},
    {0x00011918, 0x00011935},
    {0x00011937, 0x00011938},
    {0x0001193b, 0x00011943},
    {0x00011950, 0x00011959},
    {0x000119a0, 0x000119a7},
    {0x000119aa, 0x000119d7},
    {0x000119da, 0x000119e1},
    {0x000119e3, 0x000119e4},
    {0x00011a00, 0x00011a3e},
    {0x00011a47, 0x00011a47},
    {0x00011a50, 0x00011a99},
    {0x00011a9d, 0x00011a9d},
    {0x00011ab0, 0x00011af8},
    {0x00011c00, 0x00011c08},
    {0x00011c0a, 0x00011c36},
    {0x00011c38, 0x00011c40},
    {0x00011c50, 0x00011c59},
    {0x00011c72, 0x00011c8f},
    {0x00011c92, 0x00011ca7},
    {0x00011ca9, 0x00011cb6},
    {0x00011d00, 0x00011d06},
    {0x00011d08, 0x00011d09},
    {0x00011d0b, 0x00011d36},
    {0x00011d3a, 0x00011d3a},
    {0x00011d3c, 0x00011d3d},
    {0x00011d3f, 0x00011d47},
    {0x00011d50, 0x00011d59},
    {0x00011d60, 0x00011d65},
    {0x00011d67, 0x00011d68},
    {0x00011d6a, 0x00011d8e},
    {0x00011d90, 0x00011d91},
    {0x00011d93, 0x00011d98},
    {0x00011da0, 0x00011da9},
    {0x00011ee0, 0x00011ef6},
    {0x00011f00, 0x00011f10},
    {0x00011f12, 0x00011f3a},
    {0x00011f3e, 0x00011f42},
    {0x00011f50, 0x00011f59},
    {0x00011fb0, 0x00011fb0},
    {0x00012000, 0x00012399},
    {0x00012400, 0x0001246e},
    {0x00012480, 0x00012543},
    {0x00012f90, 0x00012ff0},
    {0x00013000, 0x0001342f},
    {0x00013440, 0x00013455},
    {0x00014400, 0x00014646},
    {0x00016800, 0x00016a38},
    {0x00016a40, 0x00016a5e},
    {0x00016a60, 0x00016a69},
    {0x00016a70, 0x00016abe},
    {0x00016ac0, 0x00016ac9},
    {0x00016ad0, 0x00016aed},
    {0x00016af0, 0x00016af4},
    {0x00016b00, 0x00016b36},
    {0x00016b40, 0x00016b43},
    {0x00016b50, 0x00016b59},
    {0x00016b63, 0x00016b77},
    {0x00016b7d, 0x00016b8f},
    {0x00016e40, 0x00016e7f},
    {0x00016f00, 0x00016f4a},
    {0x00016f4f, 0x00016f87},
    {0x00016f8f, 0x00016f9f},
    {0x00016fe0, 0x00016fe1},
    {0x00016fe3, 0x00016fe4},
    {0x00016ff0, 0x00016ff1},
    {0x00017000, 0x000187f7},
    {0x00018800, 0x00018cd5},
    {0x00018d00, 0x00018d08},
    {0x0001aff0, 0x0001aff3},
    {0x0001aff5, 0x0001affb},
    {0x0001affd, 0x0001affe},
    {0x0001b000, 0x0001b122},
    {0x0001b132, 0x0001b132},
    {0x0001b150, 0x0001b152},
    {0x0001b155, 0x0001b155},
    {0x0001b164, 0x0001b167},
    {0x0001b170, 0x0001b2fb},
    {0x0001bc00, 0x0001bc6a},
    {0x0001bc70, 0x0001bc7c},
    {0x0001bc80, 0x0001bc88},
    {0x0001bc90, 0x0001bc99},
    {0x0001bc9d, 0x0001bc9e},
    {0x0001cf00, 0x0001cf2d},
    {0x0001cf30, 0x0001cf46},
    {0x0001d165, 0x0001d169},
    {0x0001d16d, 0x0001d172},
    {0x0001d17b, 0x0001d182},
    {0x0001d185, 0x0001d18b},
    {0x0001d1aa, 0x0001d1ad},
    {0x0001d242, 0x0001d244},
    {0x0001d400, 0x0001d454},
    {0x0001d456, 0x0001d49c},
    {0x0001d49e, 0x0001d49f},
    {0x0001d4a2, 0x0001d4a2},
    {0x0001d4a5, 0x0001d4a6},
    {0x0001d4a9, 0x0001d4ac},
    {0x0001d4ae, 0x0001d4b9},
    {0x0001d4bb, 0x0001d4bb},
    {0x0001d4bd, 0x0001d4c3},
    {0x0001d4c5, 0x0001d505},
    {0x0001d507, 0x0001d50a},
    {0x0001d50d, 0x0001d514},
    {0x0001d516, 0x0001d51c},
    {0x0001d51e, 0x0001d539},
    {0x0001d53b, 0x0001d53e},
    {0x0001d540, 0x0001d544},
    {0x0001d546, 0x0001d546},
    {0x0001d54a, 0x0001d550},
    {0x0001d552, 0x0001d6a5},
    {0x0001d6a8, 0x0001d6c0},
    {0x0001d6c2, 0x0001d6da},
    {0x0001d6dc, 0x0001d6fa},
    {0x0001d6fc, 0x0001d714},
    {0x0001d716, 0x0001d734},
    {0x0001d736, 0x0001d74e},
    {0x0001d750, 0x0001d76e},
    {0x0001d770, 0x0001d788},
    {0x0001d78a, 0x0001d7a8},
    {0x0001d7aa, 0x0001d7c2},
    {0x0001d7c4, 0x0001d7cb},
    {0x0001d7ce, 0x0001d7ff},
    {0x0001da00, 0x0001da36},
    {0x0001da3b, 0x0001da6c},
    {0x0001da75, 0x0001da75},
    {0x0001da84, 0x0001da84},
    {0x0001da9b, 0x0001da9f},
    {0x0001daa1, 0x0001daaf},
    {0x0001df00, 0x0001df1e},
    {0x0001df25, 0x0001df2a},
    {0x0001e000, 0x0001e006},
    {0x0001e008, 0x0001e018},
    {0x0001e01b, 0x0001e021},
    {0x0001e023, 0x0001e024},
    {0x0001e026, 0x0001e02a},
    {0x0001e030, 0x0001e06d},
    {0x0001e08f, 0x0001e08f},
    {0x0001e100, 0x0001e12c},
    {0x0001e130, 0x0001e13d},
    {0x0001e140, 0x0001e149},
    {0x0001e14e, 0x0001e14e},
    {0x0001e290, 0x0001e2ae},
    {0x0001e2c0, 0x0001e2f9},
    {0x0001e4d0, 0x0001e4f9},
    {0x0001e7e0, 0x0001e7e6},
    {0x0001e7e8, 0x0001e7eb},
    {0x0001e7ed, 0x0001e7ee},
    {0x0001e7f0, 0x0001e7fe},
    {0x0001e800, 0x0001e8c4},
    {0x0001e8d0, 0x0001e8d6},
    {0x0001e900, 0x0001e94b},
    {0x0001e950, 0x0001e959},
    {0x0001ee00, 0x0001ee03},
    {0x0001ee05, 0x0001ee1f},
    {0x0001ee21, 0x0001ee22},
    {0x0001ee24, 0x0001ee24},
    {0x0001ee27, 0x0001ee27},
    {0x0001ee29, 0x0001ee32},
    {0x0001ee34, 0x0001ee37},
    {0x0001ee39, 0x0001ee39},
    {0x0001ee3b, 0x0001ee3b},
    {0x0001ee42, 0x0001ee42},
    {0x0001ee47, 0x0001ee47},
    {0x0001ee49, 0x0001ee49},
    {0x0001ee4b, 0x0001ee4b},
    {0x0001ee4d, 0x0001ee4f},
    {0x0001ee51, 0x0001ee52},
    {0x0001ee54, 0x0001ee54},
    {0x0001ee57, 0x0001ee57},
    {0x0001ee59, 0x0001ee59},
    {0x0001ee5b, 0x0001ee5b},
    {0x0001ee5d, 0x0001ee5d},
    {0x0001ee5f, 0x0001ee5f},
    {0x0001ee61, 0x0001ee62},
    {0x0001ee64, 0x0001ee64},
    {0x0001ee67, 0x0001ee6a},
    {0x0001ee6c, 0x0001ee72},
    {0x0001ee74, 0x0001ee77},
    {0x0001ee79, 0x0001ee7c},
    {0x0001ee7e, 0x0001ee7e},
    {0x0001ee80, 0x0001ee89},
    {0x0001ee8b, 0x0001ee9b},
    {0x0001eea1, 0x0001eea3},
    {0x0001eea5, 0x0001eea9},
    {0x0001eeab, 0x0001eebb},
    {0x0001fbf0, 0x0001fbf9},
    {0x00020000, 0x0002a6df},
    {0x0002a700, 0x0002b739},
    {0x0002b740, 0x0002b81d},
    {0x0002b820, 0x0002cea1},
    {0x0002ceb0, 0x0002ebe0},
    {0x0002f800, 0x0002fa1d},
    {0x00030000, 0x0003134a},
    {0x00031350, 0x000323af},
    {0x000e0100, 0x000e01ef},
};

// Alphanumeric except Han, Hiragana, Katakana, Hangul
#define UCD_LEN_IN_WORD 776
static struct unicode_range ucd_table_in_word[776] = {
    {0x00000030, 0x00000039},
    {0x00000041, 0x0000005a},
    {0x00000061, 0x0000007a},
    {0x000000aa, 0x000000aa},
    {0x000000b2, 0x000000b3},
    {0x000000b5, 0x000000b5},
    {0x000000b9, 0x000000ba},
    {0x000000bc, 0x000000be},
    {0x000000c0, 0x000000d6},
    {0x000000d8, 0x000000f6},
    {0x000000f8, 0x000002c1},
    {0x000002c6, 0x000002d1},
    {0x000002e0, 0x000002e4},
    {0x000002ec, 0x000002ec},
    {0x000002ee, 0x000002ee},
    {0x00000345, 0x00000345},
    {0x00000370, 0x00000374},
    {0x00000376, 0x00000377},
    {0x0000037a, 0x0000037d},
    {0x0000037f, 0x0000037f},
    {0x00000386, 0x00000386},
    {0x00000388, 0x0000038a},
    {0x0000038c, 0x0000038c},
    {0x0000038e, 0x000003a1},
    {0x000003a3, 0x000003f5},
    {0x000003f7, 0x00000481},
    {0x0000048a, 0x0000052f},
    {0x00000531, 0x00000556},
    {0x00000559, 0x00000559},
    {0x00000560, 0x00000588},
    {0x000005b0, 0x000005bd},
    {0x000005bf, 0x000005bf},
    {0x000005c1, 0x000005c2},
    {0x000005c4, 0x000005c5},
    {0x000005c7, 0x000005c7},
    {0x000005d0, 0x000005ea},
    {0x000005ef, 0x000005f2},
    {0x00000610, 0x0000061a},
    {0x00000620, 0x00000657},
    {0x00000659, 0x00000669},
    {0x0000066e, 0x000006d3},
    {0x000006d5, 0x000006dc},
    {0x000006e1, 0x000006e8},
    {0x000006ed, 0x000006fc},
    {0x000006ff, 0x000006ff},
    {0x00000710, 0x0000073f},
    {0x0000074d, 0x000007b1},
    {0x000007c0, 0x000007ea},
    {0x000007f4, 0x000007f5},
    {0x000007fa, 0x000007fa},
    {0x00000800, 0x00000817},
    {0x0000081a, 0x0000082c},
    {0x00000840, 0x00000858},
    {0x00000860, 0x0000086a},
    {0x00000870, 0x00000887},
    {0x00000889, 0x0000088e},
    {0x000008a0, 0x000008c9},
    {0x000008d4, 0x000008df},
    {0x000008e3, 0x000008e9},
    {0x000008f0, 0x0000093b},
    {0x0000093d, 0x0000094c},
    {0x0000094e, 0x00000950},
    {0x00000955, 0x00000963},
    {0x00000966, 0x0000096f},
    {0x00000971, 0x00000983},
    {0x00000985, 0x0000098c},
    {0x0000098f, 0x00000990},
    {0x00000993, 0x000009a8},
    {0x000009aa, 0x000009b0},
    {0x000009b2, 0x000009b2},
    {0x000009b6, 0x000009b9},
    {0x000009bd, 0x000009c4},
    {0x000009c7, 0x000009c8},
    {0x000009cb, 0x000009cc},
    {0x000009ce, 0x000009ce},
    {0x000009d7, 0x000009d7},
    {0x000009dc, 0x000009dd},
    {0x000009df, 0x000009e3},
    {0x000009e6, 0x000009f1},
    {0x000009f4, 0x000009f9},
    {0x000009fc, 0x000009fc},
    {0x00000a01, 0x00000a03},
    {0x00000a05, 0x00000a0a},
    {0x00000a0f, 0x00000a10},
    {0x00000a13, 0x00000a28},
    {0x00000a2a, 0x00000a30},
    {0x00000a32, 0x00000a33},
    {0x00000a35, 0x00000a36},
    {0x00000a38, 0x00000a39},
    {0x00000a3e, 0x00000a42},
    {0x00000a47, 0x00000a48},
    {0x00000a4b, 0x00000a4c},
    {0x00000a51, 0x00000a51},
    {0x00000a59, 0x00000a5c},
    {0x00000a5e, 0x00000a5e},
    {0x00000a66, 0x00000a75},
    {0x00000a81, 0x00000a83},
    {0x00000a85, 0x00000a8d},
    {0x00000a8f, 0x00000a91},
    {0x00000a93, 0x00000aa8},
    {0x00000aaa, 0x00000ab0},
    {0x00000ab2, 0x00000ab3},
    {0x00000ab5, 0x00000ab9},
    {0x00000abd, 0x00000ac5},
    {0x00000ac7, 0x00000ac9},
    {0x00000acb, 0x00000acc},
    {0x00000ad0, 0x00000ad0},
    {0x00000ae0, 0x00000ae3},
    {0x00000ae6, 0x00000aef},
    {0x00000af9, 0x00000afc},
    {0x00000b01, 0x00000b03},
    {0x00000b05, 0x00000b0c},
    {0x00000b0f, 0x00000b10},
    {0x00000b13, 0x00000b28},
    {0x00000b2a, 0x00000b30},
    {0x00000b32, 0x00000b33},
    {0x00000b35, 0x00000b39},
    {0x00000b3d, 0x00000b44},
    {0x00000b47, 0x00000b48},
    {0x00000b4b, 0x00000b4c},
    {0x00000b56, 0x00000b57},
    {0x00000b5c, 0x00000b5d},
    {0x00000b5f, 0x00000b63},
    {0x00000b66, 0x00000b6f},
    {0x00000b71, 0x00000b77},
    {0x00000b82, 0x00000b83},
    {0x00000b85, 0x00000b8a},
    {0x00000b8e, 0x00000b90},
    {0x00000b92, 0x00000b95},
    {0x00000b99, 0x00000b9a},
    {0x00000b9c, 0x00000b9c},
    {0x00000b9e, 0x00000b9f},
    {0x00000ba3, 0x00000ba4},
    {0x00000ba8, 0x00000baa},
    {0x00000bae, 0x00000bb9},
    {0x00000bbe, 0x00000bc2},
    {0x00000bc6, 0x00000bc8},
    {0x00000bca, 0x00000bcc},
    {0x00000bd0, 0x00000bd0},
    {0x00000bd7, 0x00000bd7},
    {0x00000be6, 0x00000bf2},
    {0x00000c00, 0x00000c0c},
    {0x00000c0e, 0x00000c10},
    {0x00000c12, 0x00000c28},
    {0x00000c2a, 0x00000c39},
    {0x00000c3d, 0x00000c44},
    {0x00000c46, 0x00000c48},
    {0x00000c4a, 0x00000c4c},
    {0x00000c55, 0x00000c56},
    {0x00000c58, 0x00000c5a},
    {0x00000c5d, 0x00000c5d},
    {0x00000c60, 0x00000c63},
    {0x00000c66, 0x00000c6f},
    {0x00000c78, 0x00000c7e},
    {0x00000c80, 0x00000c83},
    {0x00000c85, 0x00000c8c},
    {0x00000c8e, 0x00000c90},
    {0x00000c92, 0x00000ca8},
    {0x00000caa, 0x00000cb3},
    {0x00000cb5, 0x00000cb9},
    {0x00000cbd, 0x00000cc4},
    {0x00000cc6, 0x00000cc8},
    {0x00000cca, 0x00000ccc},
    {0x00000cd5, 0x00000cd6},
    {0x00000cdd, 0x00000cde},
    {0x00000ce0, 0x00000ce3},
    {0x00000ce6, 0x00000cef},
    {0x00000cf1, 0x00000cf3},
    {0x00000d00, 0x00000d0c},
    {0x00000d0e, 0x00000d10},
    {0x00000d12, 0x00000d3a},
    {0x00000d3d, 0x00000d44},
    {0x00000d46, 0x00000d48},
    {0x00000d4a, 0x00000d4c},
    {0x00000d4e, 0x00000d4e},
    {0x00000d54, 0x00000d63},
    {0x00000d66, 0x00000d78},
    {0x00000d7a, 0x00000d7f},
    {0x00000d81, 0x00000d83},
    {0x00000d85, 0x00000d96},
    {0x00000d9a, 0x00000db1},
    {0x00000db3, 0x00000dbb},
    {0x00000dbd, 0x00000dbd},
    {0x00000dc0, 0x00000dc6},
    {0x00000dcf, 0x00000dd4},
    {0x00000dd6, 0x00000dd6},
    {0x00000dd8, 0x00000ddf},
    {0x00000de6, 0x00000def},
    {0x00000df2, 0x00000df3},
    {0x00000e01, 0x00000e3a},
    {0x00000e40, 0x00000e46},
    {0x00000e4d, 0x00000e4d},
    {0x00000e50, 0x00000e59},
    {0x00000e81, 0x00000e82},
    {0x00000e84, 0x00000e84},
    {0x00000e86, 0x00000e8a},
    {0x00000e8c, 0x00000ea3},
    {0x00000ea5, 0x00000ea5},
    {0x00000ea7, 0x00000eb9},
    {0x00000ebb, 0x00000ebd},
    {0x00000ec0, 0x00000ec4},
    {0x00000ec6, 0x00000ec6},
    {0x00000ecd, 0x00000ecd},
    {0x00000ed0, 0x00000ed9},
    {0x00000edc, 0x00000edf},
    {0x00000f00, 0x00000f00},
    {0x00000f20, 0x00000f33},
    {0x00000f40, 0x00000f47},
    {0x00000f49, 0x00000f6c},
    {0x00000f71, 0x00000f83},
    {0x00000f88, 0x00000f97},
    {0x00000f99, 0x00000fbc},
    {0x00001000, 0x00001036},
    {0x00001038, 0x00001038},
    {0x0000103b, 0x00001049},
    {0x00001050, 0x0000109d},
    {0x000010a0, 0x000010c5},
    {0x000010c7, 0x000010c7},
    {0x000010cd, 0x000010cd},
    {0x000010d0, 0x000010fa},
    {0x000010fc, 0x000010ff},
    {0x00001200, 0x00001248},
    {0x0000124a, 0x0000124d},
    {0x00001250, 0x00001256},
    {0x00001258, 0x00001258},
    {0x0000125a, 0x0000125d},
    {0x00001260, 0x00001288},
    {0x0000128a, 0x0000128d},
    {0x00001290, 0x000012b0},
    {0x000012b2, 0x000012b5},
    {0x000012b8, 0x000012be},
    {0x000012c0, 0x000012c0},
    {0x000012c2, 0x000012c5},
    {0x000012c8, 0x000012d6},
    {0x000012d8, 0x00001310},
    {0x00001312, 0x00001315},
    {0x00001318, 0x0000135a},
    {0x00001369, 0x0000137c},
    {0x00001380, 0x0000138f},
    {0x000013a0, 0x000013f5},
    {0x000013f8, 0x000013fd},
    {0x00001401, 0x0000166c},
    {0x0000166f, 0x0000167f},
    {0x00001681, 0x0000169a},
    {0x000016a0, 0x000016ea},
    {0x000016ee, 0x000016f8},
    {0x00001700, 0x00001713},
    {0x0000171f, 0x00001733},
    {0x00001740, 0x00001753},
    {0x00001760, 0x0000176c},
    {0x0000176e, 0x00001770},
    {0x00001772, 0x00001773},
    {0x00001780, 0x000017b3},
    {0x000017b6, 0x000017c8},
    {0x000017d7, 0x000017d7},
    {0x000017dc, 0x000017dc},
    {0x000017e0, 0x000017e9},
    {0x000017f0, 0x000017f9},
    {0x00001810, 0x00001819},
    {0x00001820, 0x00001878},
    {0x00001880, 0x000018aa},
    {0x000018b0, 0x000018f5},
    {0x00001900, 0x0000191e},
    {0x00001920, 0x0000192b},
    {0x00001930, 0x00001938},
    {0x00001946, 0x0000196d},
    {0x00001970, 0x00001974},
    {0x00001980, 0x000019ab},
    {0x000019b0, 0x000019c9},
    {0x000019d0, 0x000019da},
    {0x00001a00, 0x00001a1b},
    {0x00001a20, 0x00001a5e},
    {0x00001a61, 0x00001a74},
    {0x00001a80, 0x00001a89},
    {0x00001a90, 0x00001a99},
    {0x00001aa7, 0x00001aa7},
    {0x00001abf, 0x00001ac0},
    {0x00001acc, 0x00001ace},
    {0x00001b00, 0x00001b33},
    {0x00001b35, 0x00001b43},
    {0x00001b45, 0x00001b4c},
    {0x00001b50, 0x00001b59},
    {0x00001b80, 0x00001ba9},
    {0x00001bac, 0x00001be5},
    {0x00001be7, 0x00001bf1},
    {0x00001c00, 0x00001c36},
    {0x00001c40, 0x00001c49},
    {0x00001c4d, 0x00001c7d},
    {0x00001c80, 0x00001c88},
    {0x00001c90, 0x00001cba},
    {0x00001cbd, 0x00001cbf},
    {0x00001ce9, 0x00001cec},
    {0x00001cee, 0x00001cf3},
    {0x00001cf5, 0x00001cf6},
    {0x00001cfa, 0x00001cfa},
    {0x00001d00, 0x00001dbf},
    {0x00001de7, 0x00001df4},
    {0x00001e00, 0x00001f15},
    {0x00001f18, 0x00001f1d},
    {0x00001f20, 0x00001f45},
    {0x00001f48, 0x00001f4d},
    {0x00001f50, 0x00001f57},
    {0x00001f59, 0x00001f59},
    {0x00001f5b, 0x00001f5b},
    {0x00001f5d, 0x00001f5d},
    {0x00001f5f, 0x00001f7d},
    {0x00001f80, 0x00001fb4},
    {0x00001fb6, 0x00001fbc},
    {0x00001fbe, 0x00001fbe},
    {0x00001fc2, 0x00001fc4},
    {0x00001fc6, 0x00001fcc},
    {0x00001fd0, 0x00001fd3},
    {0x00001fd6, 0x00001fdb},
    {0x00001fe0, 0x00001fec},
    {0x00001ff2, 0x00001ff4},
    {0x00001ff6, 0x00001ffc},
    {0x00002070, 0x00002071},
    {0x00002074, 0x00002079},
    {0x0000207f, 0x00002089},
    {0x00002090, 0x0000209c},
    {0x00002102, 0x00002102},
    {0x00002107, 0x00002107},
    {0x0000210a, 0x00002113},
    {0x00002115, 0x00002115},
    {0x00002119, 0x0000211d},
    {0x00002124, 0x00002124},
    {0x00002126, 0x00002126},
    {0x00002128, 0x00002128},
    {0x0000212a, 0x0000212d},
    {0x0000212f, 0x00002139},
    {0x0000213c, 0x0000213f},
    {0x00002145, 0x00002149},
    {0x0000214e, 0x0000214e},
    {0x00002150, 0x00002189},
    {0x00002460, 0x0000249b},
    {0x000024b6, 0x000024ff},
    {0x00002776, 0x00002793},
    {0x00002c00, 0x00002ce4},
    {0x00002ceb, 0x00002cee},
    {0x00002cf2, 0x00002cf3},
    {0x00002cfd, 0x00002cfd},
    {0x00002d00, 0x00002d25},
    {0x00002d27, 0x00002d27},
    {0x00002d2d, 0x00002d2d},
    {0x00002d30, 0x00002d67},
    {0x00002d6f, 0x00002d6f},
    {0x00002d80, 0x00002d96},
    {0x00002da0, 0x00002da6},
    {0x00002da8, 0x00002dae},
    {0x00002db0, 0x00002db6},
    {0x00002db8, 0x00002dbe},
    {0x00002dc0, 0x00002dc6},
    {0x00002dc8, 0x00002dce},
    {0x00002dd0, 0x00002dd6},
    {0x00002dd8, 0x00002dde},
    {0x00002de0, 0x00002dff},
    {0x00002e2f, 0x00002e2f},
    {0x00003006, 0x00003006},
    {0x00003031, 0x00003035},
    {0x0000303c, 0x0000303c},
    {0x000030fc, 0x000030fc},
    {0x00003105, 0x0000312f},
    {0x00003192, 0x00003195},
    {0x000031a0, 0x000031bf},
    {0x00003220, 0x00003229},
    {0x00003248, 0x0000324f},
    {0x00003251, 0x0000325f},
    {0x00003280, 0x00003289},
    {0x000032b1, 0x000032bf},
    {0x0000a000, 0x0000a48c},
    {0x0000a4d0, 0x0000a4fd},
    {0x0000a500, 0x0000a60c},
    {0x0000a610, 0x0000a62b},
    {0x0000a640, 0x0000a66e},
    {0x0000a674, 0x0000a67b},
    {0x0000a67f, 0x0000a6ef},
    {0x0000a717, 0x0000a71f},
    {0x0000a722, 0x0000a788},
    {0x0000a78b, 0x0000a7ca},
    {0x0000a7d0, 0x0000a7d1},
    {0x0000a7d3, 0x0000a7d3},
    {0x0000a7d5, 0x0000a7d9},
    {0x0000a7f2, 0x0000a805},
    {0x0000a807, 0x0000a827},
    {0x0000a830, 0x0000a835},
    {0x0000a840, 0x0000a873},
    {0x0000a880, 0x0000a8c3},
    {0x0000a8c5, 0x0000a8c5},
    {0x0000a8d0, 0x0000a8d9},
    {0x0000a8f2, 0x0000a8f7},
    {0x0000a8fb, 0x0000a8fb},
    {0x0000a8fd, 0x0000a92a},
    {0x0000a930, 0x0000a952},
    {0x0000a980, 0x0000a9b2},
    {0x0000a9b4, 0x0000a9bf},
    {0x0000a9cf, 0x0000a9d9},
    {0x0000a9e0, 0x0000a9fe},
    {0x0000aa00, 0x0000aa36},
    {0x0000aa40, 0x0000aa4d},
    {0x0000aa50, 0x0000aa59},
    {0x0000aa60, 0x0000aa76},
    {0x0000aa7a, 0x0000aabe},
    {0x0000aac0, 0x0000aac0},
    {0x0000aac2, 0x0000aac2},
    {0x0000aadb, 0x0000aadd},
    {0x0000aae0, 0x0000aaef},
    {0x0000aaf2, 0x0000aaf5},
    {0x0000ab01, 0x0000ab06},
    {0x0000ab09, 0x0000ab0e},
    {0x0000ab11, 0x0000ab16},
    {0x0000ab20, 0x0000ab26},
    {0x0000ab28, 0x0000ab2e},
    {0x0000ab30, 0x0000ab5a},
    {0x0000ab5c, 0x0000ab69},
    {0x0000ab70, 0x0000abea},
    {0x0000abf0, 0x0000abf9},
    {0x0000fb00, 0x0000fb06},
    {0x0000fb13, 0x0000fb17},
    {0x0000fb1d, 0x0000fb28},
    {0x0000fb2a, 0x0000fb36},
    {0x0000fb38, 0x0000fb3c},
    {0x0000fb3e, 0x0000fb3e},
    {0x0000fb40, 0x0000fb41},
    {0x0000fb43, 0x0000fb44},
    {0x0000fb46, 0x0000fbb1},
    {0x0000fbd3, 0x0000fd3d},
    {0x0000fd50, 0x0000fd8f},
    {0x0000fd92, 0x0000fdc7},
    {0x0000fdf0, 0x0000fdfb},
    {0x0000fe70, 0x0000fe74},
    {0x0000fe76, 0x0000fefc},
    {0x0000ff10, 0x0000ff19},
    {0x0000ff21, 0x0000ff3a},
    {0x0000ff41, 0x0000ff5a},
    {0x0000ff70, 0x0000ff70},
    {0x0000ff9e, 0x0000ff9f},
    {0x00010000, 0x0001000b},
    {0x0001000d, 0x00010026},
    {0x00010028, 0x0001003a},
    {0x0001003c, 0x0001003d},
    {0x0001003f, 0x0001004d},
    {0x00010050, 0x0001005d},
    {0x00010080, 0x000100fa},
    {0x00010107, 0x00010133},
    {0x00010140, 0x00010178},
    {0x0001018a, 0x0001018b},
    {0x00010280, 0x0001029c},
    {0x000102a0, 0x000102d0},
    {0x000102e1, 0x000102fb},
    {0x00010300, 0x00010323},
    {0x0001032d, 0x0001034a},
    {0x00010350, 0x0001037a},
    {0x00010380, 0x0001039d},
    {0x000103a0, 0x000103c3},
    {0x000103c8, 0x000103cf},
    {0x000103d1, 0x000103d5},
    {0x00010400, 0x0001049d},
    {0x000104a0, 0x000104a9},
    {0x000104b0, 0x000104d3},
    {0x000104d8, 0x000104fb},
    {0x00010500, 0x00010527},
    {0x00010530, 0x00010563},
    {0x00010570, 0x0001057a},
    {0x0001057c, 0x0001058a},
    {0x0001058c, 0x00010592},
    {0x00010594, 0x00010595},
    {0x00010597, 0x000105a1},
    {0x000105a3, 0x000105b1},
    {0x000105b3, 0x000105b9},
    {0x000105bb, 0x000105bc},
    {0x00010600, 0x00010736},
    {0x00010740, 0x00010755},
    {0x00010760, 0x00010767},
    {0x00010780, 0x00010785},
    {0x00010787, 0x000107b0},
    {0x000107b2, 0x000107ba},
    {0x00010800, 0x00010805},
    {0x00010808, 0x00010808},
    {0x0001080a, 0x00010835},
    {0x00010837, 0x00010838},
    {0x0001083c, 0x0001083c},
    {0x0001083f, 0x00010855},
    {0x00010858, 0x00010876},
    {0x00010879, 0x0001089e},
    {0x000108a7, 0x000108af},
    {0x000108e0, 0x000108f2},
    {0x000108f4, 0x000108f5},
    {0x000108fb, 0x0001091b},
    {0x00010920, 0x00010939},
    {0x00010980, 0x000109b7},
    {0x000109bc, 0x000109cf},
    {0x000109d2, 0x00010a03},
    {0x00010a05, 0x00010a06},
    {0x00010a0c, 0x00010a13},
    {0x00010a15, 0x00010a17},
    {0x00010a19, 0x00010a35},
    {0x00010a40, 0x00010a48},
    {0x00010a60, 0x00010a7e},
    {0x00010a80, 0x00010a9f},
    {0x00010ac0, 0x00010ac7},
    {0x00010ac9, 0x00010ae4},
    {0x00010aeb, 0x00010aef},
    {0x00010b00, 0x00010b35},
    {0x00010b40, 0x00010b55},
    {0x00010b58, 0x00010b72},
    {0x00010b78, 0x00010b91},
    {0x00010ba9, 0x00010baf},
    {0x00010c00, 0x00010c48},
    {0x00010c80, 0x00010cb2},
    {0x00010cc0, 0x00010cf2},
    {0x00010cfa, 0x00010d27},
    {0x00010d30, 0x00010d39},
    {0x00010e60, 0x00010e7e},
    {0x00010e80, 0x00010ea9},
    {0x00010eab, 0x00010eac},
    {0x00010eb0, 0x00010eb1},
    {0x00010f00, 0x00010f27},
    {0x00010f30, 0x00010f45},
    {0x00010f51, 0x00010f54},
    {0x00010f70, 0x00010f81},
    {0x00010fb0, 0x00010fcb},
    {0x00010fe0, 0x00010ff6},
    {0x00011000, 0x00011045},
    {0x00011052, 0x0001106f},
    {0x00011071, 0x00011075},
    {0x00011080, 0x000110b8},
    {0x000110c2, 0x000110c2},
    {0x000110d0, 0x000110e8},
    {0x000110f0, 0x000110f9},
    {0x00011100, 0x00011132},
    {0x00011136, 0x0001113f},
    {0x00011144, 0x00011147},
    {0x00011150, 0x00011172},
    {0x00011176, 0x00011176},
    {0x00011180, 0x000111bf},
    {0x000111c1, 0x000111c4},
    {0x000111ce, 0x000111da},
    {0x000111dc, 0x000111dc},
    {0x000111e1, 0x000111f4},
    {0x00011200, 0x00011211},
    {0x00011213, 0x00011234},
    {0x00011237, 0x00011237},
    {0x0001123e, 0x00011241},
    {0x00011280, 0x00011286},
    {0x00011288, 0x00011288},
    {0x0001128a, 0x0001128d},
    {0x0001128f, 0x0001129d},
    {0x0001129f, 0x000112a8},
    {0x000112b0, 0x000112e8},
    {0x000112f0, 0x000112f9},
    {0x00011300, 0x00011303},
    {0x00011305, 0x0001130c},
    {0x0001130f, 0x00011310},
    {0x00011313, 0x00011328},
    {0x0001132a, 0x00011330},
    {0x00011332, 0x00011333},
    {0x00011335, 0x00011339},
    {0x0001133d, 0x00011344},
    {0x00011347, 0x00011348},
    {0x0001134b, 0x0001134c},
    {0x00011350, 0x00011350},
    {0x00011357, 0x00011357},
    {0x0001135d, 0x00011363},
    {0x00011400, 0x00011441},
    {0x00011443, 0x00011445},
    {0x00011447, 0x0001144a},
    {0x00011450, 0x00011459},
    {0x0001145f, 0x00011461},
    {0x00011480, 0x000114c1},
    {0x000114c4, 0x000114c5},
    {0x000114c7, 0x000114c7},
    {0x000114d0, 0x000114d9},
    {0x00011580, 0x000115b5},
    {0x000115b8, 0x000115be},
    {0x000115d8, 0x000115dd},
    {0x00011600, 0x0001163e},
    {0x00011640, 0x00011640},
    {0x00011644, 0x00011644},
    {0x00011650, 0x00011659},
    {0x00011680, 0x000116b5},
    {0x000116b8, 0x000116b8},
    {0x000116c0, 0x000116c9},
    {0x00011700, 0x0001171a},
    {0x0001171d, 0x0001172a},
    {0x00011730, 0x0001173b},
    {0x00011740, 0x00011746},
    {0x00011800, 0x00011838},
    {0x000118a0, 0x000118f2},
    {0x000118ff, 0x00011906},
    {0x00011909, 0x00011909},
    {0x0001190c, 0x00011913},
    {0x00011915, 0x00011916},
    {0x00011918, 0x00011935},
    {0x00011937, 0x00011938},
    {0x0001193b, 0x0001193c},
    {0x0001193f, 0x00011942},
    {0x00011950, 0x00011959},
    {0x000119a0, 0x000119a7},
    {0x000119aa, 0x000119d7},
    {0x000119da, 0x000119df},
    {0x000119e1, 0x000119e1},
    {0x000119e3, 0x000119e4},
    {0x00011a00, 0x00011a32},
    {0x00011a35, 0x00011a3e},
    {0x00011a50, 0x00011a97},
    {0x00011a9d, 0x00011a9d},
    {0x00011ab0, 0x00011af8},
    {0x00011c00, 0x00011c08},
    {0x00011c0a, 0x00011c36},
    {0x00011c38, 0x00011c3e},
    {0x00011c40, 0x00011c40},
    {0x00011c50, 0x00011c6c},
    {0x00011c72, 0x00011c8f},
    {0x00011c92, 0x00011ca7},
    {0x00011ca9, 0x00011cb6},
    {0x00011d00, 0x00011d06},
    {0x00011d08, 0x00011d09},
    {0x00011d0b, 0x00011d36},
    {0x00011d3a, 0x00011d3a},
    {0x00011d3c, 0x00011d3d},
    {0x00011d3f, 0x00011d41},
    {0x00011d43, 0x00011d43},
    {0x00011d46, 0x00011d47},
    {0x00011d50, 0x00011d59},
    {0x00011d60, 0x00011d65},
    {0x00011d67, 0x00011d68},
    {0x00011d6a, 0x00011d8e},
    {0x00011d90, 0x00011d91},
    {0x00011d93, 0x00011d96},
    {0x00011d98, 0x00011d98},
    {0x00011da0, 0x00011da9},
    {0x00011ee0, 0x00011ef6},
    {0x00011f00, 0x00011f10},
    {0x00011f12, 0x00011f3a},
    {0x00011f3e, 0x00011f40},
    {0x00011f50, 0x00011f59},
    {0x00011fb0, 0x00011fb0},
    {0x00011fc0, 0x00011fd4},
    {0x00012000, 0x00012399},
    {0x00012400, 0x0001246e},
    {0x00012480, 0x00012543},
    {0x00012f90, 0x00012ff0},
    {0x00013000, 0x0001342f},
    {0x00013441, 0x00013446},
    {0x00014400, 0x00014646},
    {0x00016800, 0x00016a38},
    {0x00016a40, 0x00016a5e},
    {0x00016a60, 0x00016a69},
    {0x00016a70, 0x00016abe},
    {0x00016ac0, 0x00016ac9},
    {0x00016ad0, 0x00016aed},
    {0x00016b00, 0x00016b2f},
    {0x00016b40, 0x00016b43},
    {0x00016b50, 0x00016b59},
    {0x00016b5b, 0x00016b61},
    {0x00016b63, 0x00016b77},
    {0x00016b7d, 0x00016b8f},
    {0x00016e40, 0x00016e96},
    {0x00016f00, 0x00016f4a},
    {0x00016f4f, 0x00016f87},
    {0x00016f8f, 0x00016f9f},
    {0x00016fe0, 0x00016fe1},
    {0x00017000, 0x000187f7},
    {0x00018800, 0x00018cd5},
    {0x00018d00, 0x00018d08},
    {0x0001b170, 0x0001b2fb},
    {0x0001bc00, 0x0001bc6a},
    {0x0001bc70, 0x0001bc7c},
    {0x0001bc80, 0x0001bc88},
    {0x0001bc90, 0x0001bc99},
    {0x0001bc9e, 0x0001bc9e},
    {0x0001d2c0, 0x0001d2d3},
    {0x0001d2e0, 0x0001d2f3},
    {0x0001d360, 0x0001d378},
    {0x0001d400, 0x0001d454},
    {0x0001d456, 0x0001d49c},
    {0x0001d49e, 0x0001d49f},
    {0x0001d4a2, 0x0001d4a2},
    {0x0001d4a5, 0x0001d4a6},
    {0x0001d4a9, 0x0001d4ac},
    {0x0001d4ae, 0x0001d4b9},
    {0x0001d4bb, 0x0001d4bb},
    {0x0001d4bd, 0x0001d4c3},
    {0x0001d4c5, 0x0001d505},
    {0x0001d507, 0x0001d50a},
    {0x0001d50d, 0x0001d514},
    {0x0001d516, 0x0001d51c},
    {0x0001d51e, 0x0001d539},
    {0x0001d53b, 0x0001d53e},
    {0x0001d540, 0x0001d544},
    {0x0001d546, 0x0001d546},
    {0x0001d54a, 0x0001d550},
    {0x0001d552, 0x0001d6a5},
    {0x0001d6a8, 0x0001d6c0},
    {0x0001d6c2, 0x0001d6da},
    {0x0001d6dc, 0x0001d6fa},
    {0x0001d6fc, 0x0001d714},
    {0x0001d716, 0x0001d734},
    {0x0001d736, 0x0001d74e},
    {0x0001d750, 0x0001d76e},
    {0x0001d770, 0x0001d788},
    {0x0001d78a, 0x0001d7a8},
    {0x0001d7aa, 0x0001d7c2},
    {0x0001d7c4, 0x0001d7cb},
    {0x0001d7ce, 0x0001d7ff},
    {0x0001df00, 0x0001df1e},
    {0x0001df25, 0x0001df2a},
    {0x0001e000, 0x0001e006},
    {0x0001e008, 0x0001e018},
    {0x0001e01b, 0x0001e021},
    {0x0001e023, 0x0001e024},
    {0x0001e026, 0x0001e02a},
    {0x0001e030, 0x0001e06d},
    {0x0001e08f, 0x0001e08f},
    {0x0001e100, 0x0001e12c},
    {0x0001e137, 0x0001e13d},
    {0x0001e140, 0x0001e149},
    {0x0001e14e, 0x0001e14e},
    {0x0001e290, 0x0001e2ad},
    {0x0001e2c0, 0x0001e2eb},
    {0x0001e2f0, 0x0001e2f9},
    {0x0001e4d0, 0x0001e4eb},
    {0x0001e4f0, 0x0001e4f9},
    {0x0001e7e0, 0x0001e7e6},
    {0x0001e7e8, 0x0001e7eb},
    {0x0001e7ed, 0x0001e7ee},
    {0x0001e7f0, 0x0001e7fe},
    {0x0001e800, 0x0001e8c4},
    {0x0001e8c7, 0x0001e8cf},
    {0x0001e900, 0x0001e943},
    {0x0001e947, 0x0001e947},
    {0x0001e94b, 0x0001e94b},
    {0x0001e950, 0x0001e959},
    {0x0001ec71, 0x0001ecab},
    {0x0001ecad, 0x0001ecaf},
    {0x0001ecb1, 0x0001ecb4},
    {0x0001ed01, 0x0001ed2d},
    {0x0001ed2f, 0x0001ed3d},
    {0x0001ee00, 0x0001ee03},
    {0x0001ee05, 0x0001ee1f},
    {0x0001ee21, 0x0001ee22},
    {0x0001ee24, 0x0001ee24},
    {0x0001ee27, 0x0001ee27},
    {0x0001ee29, 0x0001ee32},
    {0x0001ee34, 0x0001ee37},
    {0x0001ee39, 0x0001ee39},
    {0x0001ee3b, 0x0001ee3b},
    {0x0001ee42, 0x0001ee42},
    {0x0001ee47, 0x0001ee47},
    {0x0001ee49, 0x0001ee49},
    {0x0001ee4b, 0x0001ee4b},
    {0x0001ee4d, 0x0001ee4f},
    {0x0001ee51, 0x0001ee52},
    {0x0001ee54, 0x0001ee54},
    {0x0001ee57, 0x0001ee57},
    {0x0001ee59, 0x0001ee59},
    {0x0001ee5b, 0x0001ee5b},
    {0x0001ee5d, 0x0001ee5d},
    {0x0001ee5f, 0x0001ee5f},
    {0x0001ee61, 0x0001ee62},
    {0x0001ee64, 0x0001ee64},
    {0x0001ee67, 0x0001ee6a},
    {0x0001ee6c, 0x0001ee72},
    {0x0001ee74, 0x0001ee77},
    {0x0001ee79, 0x0001ee7c},
    {0x0001ee7e, 0x0001ee7e},
    {0x0001ee80, 0x0001ee89},
    {0x0001ee8b, 0x0001ee9b},
    {0x0001eea1, 0x0001eea3},
    {0x0001eea5, 0x0001eea9},
    {0x0001eeab, 0x0001eebb},
    {0x0001f100, 0x0001f10c},
    {0x0001f130, 0x0001f149},
    {0x0001f150, 0x0001f169},
    {0x0001f170, 0x0001f189},
    {0x0001fbf0, 0x0001fbf9},
};

