#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 412
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 115
#define ALIAS_COUNT 0
#define TOKEN_COUNT 61
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 2

enum ts_symbol_identifiers {
  anon_sym_LF = 1,
  anon_sym_build = 2,
  anon_sym_task = 3,
  anon_sym_LBRACE = 4,
  anon_sym_RBRACE = 5,
  anon_sym_run = 6,
  anon_sym_config = 7,
  anon_sym_EQ = 8,
  anon_sym_copy = 9,
  anon_sym_to = 10,
  anon_sym_default = 11,
  anon_sym_delete = 12,
  anon_sym_depfile = 13,
  anon_sym_env_DASHremove = 14,
  anon_sym_from = 15,
  anon_sym_info = 16,
  anon_sym_let = 17,
  anon_sym_env = 18,
  anon_sym_shell = 19,
  anon_sym_write = 20,
  anon_sym_LPAREN = 21,
  anon_sym_RPAREN = 22,
  anon_sym_LBRACK = 23,
  anon_sym_RBRACK = 24,
  anon_sym_error = 25,
  anon_sym_glob = 26,
  anon_sym_include = 27,
  anon_sym_PIPE = 28,
  anon_sym_read = 29,
  anon_sym_warn = 30,
  anon_sym_which = 31,
  anon_sym_dedup = 32,
  anon_sym_first = 33,
  anon_sym_flatten = 34,
  anon_sym_last = 35,
  anon_sym_len = 36,
  anon_sym_lines = 37,
  anon_sym_tail = 38,
  anon_sym_assert_DASHeq = 39,
  anon_sym_discard = 40,
  anon_sym_filter = 41,
  anon_sym_filter_DASHmatch = 42,
  anon_sym_join = 43,
  anon_sym_map = 44,
  anon_sym_match = 45,
  anon_sym_EQ_GT = 46,
  anon_sym_split = 47,
  sym_number = 48,
  anon_sym_COMMA = 49,
  anon_sym_DQUOTE = 50,
  aux_sym_string_token1 = 51,
  aux_sym_identifier_token1 = 52,
  sym_comment = 53,
  anon_sym_LT = 54,
  anon_sym_GT = 55,
  anon_sym_COLON = 56,
  aux_sym__interpolationBody_token1 = 57,
  aux_sym__interpolationBody_token2 = 58,
  sym_interpolationJoin = 59,
  sym__terminator = 60,
  sym_source_file = 61,
  sym__topLevelStatement = 62,
  sym_buildBlock = 63,
  sym_taskBlock = 64,
  sym_recipe = 65,
  sym__recipeStatement = 66,
  sym_run = 67,
  sym_runBlock = 68,
  sym__runStatement = 69,
  sym_build = 70,
  sym_config = 71,
  sym_copy = 72,
  sym_default = 73,
  sym_delete = 74,
  sym_depfile = 75,
  sym_envRemove = 76,
  sym_from = 77,
  sym_info = 78,
  sym_let = 79,
  sym_setEnv = 80,
  sym_shell = 81,
  sym_write = 82,
  sym_exp = 83,
  sym_access = 84,
  sym_error = 85,
  sym_getEnv = 86,
  sym_glob = 87,
  sym_include = 88,
  sym_pipe = 89,
  sym_read = 90,
  sym_warn = 91,
  sym_which = 92,
  sym_op = 93,
  sym_assertEq = 94,
  sym_discard = 95,
  sym_filter = 96,
  sym_filterMatch = 97,
  sym_join = 98,
  sym_map = 99,
  sym_match = 100,
  sym_matchArm = 101,
  sym_split = 102,
  sym__value = 103,
  sym_list = 104,
  sym_string = 105,
  sym_identifier = 106,
  sym_interpolation = 107,
  sym__interpolationBody = 108,
  aux_sym_source_file_repeat1 = 109,
  aux_sym_recipe_repeat1 = 110,
  aux_sym_runBlock_repeat1 = 111,
  aux_sym_match_repeat1 = 112,
  aux_sym_list_repeat1 = 113,
  aux_sym_string_repeat1 = 114,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_build] = "build",
  [anon_sym_task] = "task",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_run] = "run",
  [anon_sym_config] = "config",
  [anon_sym_EQ] = "=",
  [anon_sym_copy] = "copy",
  [anon_sym_to] = "to",
  [anon_sym_default] = "default",
  [anon_sym_delete] = "delete",
  [anon_sym_depfile] = "depfile",
  [anon_sym_env_DASHremove] = "env-remove",
  [anon_sym_from] = "from",
  [anon_sym_info] = "info",
  [anon_sym_let] = "let",
  [anon_sym_env] = "env",
  [anon_sym_shell] = "shell",
  [anon_sym_write] = "write",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_error] = "error",
  [anon_sym_glob] = "glob",
  [anon_sym_include] = "include",
  [anon_sym_PIPE] = "|",
  [anon_sym_read] = "read",
  [anon_sym_warn] = "warn",
  [anon_sym_which] = "which",
  [anon_sym_dedup] = "dedup",
  [anon_sym_first] = "first",
  [anon_sym_flatten] = "flatten",
  [anon_sym_last] = "last",
  [anon_sym_len] = "len",
  [anon_sym_lines] = "lines",
  [anon_sym_tail] = "tail",
  [anon_sym_assert_DASHeq] = "assert-eq",
  [anon_sym_discard] = "discard",
  [anon_sym_filter] = "filter",
  [anon_sym_filter_DASHmatch] = "filter-match",
  [anon_sym_join] = "join",
  [anon_sym_map] = "map",
  [anon_sym_match] = "match",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_split] = "split",
  [sym_number] = "number",
  [anon_sym_COMMA] = ",",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [aux_sym_identifier_token1] = "identifier_token1",
  [sym_comment] = "comment",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_COLON] = ":",
  [aux_sym__interpolationBody_token1] = "_interpolationBody_token1",
  [aux_sym__interpolationBody_token2] = "_interpolationBody_token2",
  [sym_interpolationJoin] = "interpolationJoin",
  [sym__terminator] = "_terminator",
  [sym_source_file] = "source_file",
  [sym__topLevelStatement] = "_topLevelStatement",
  [sym_buildBlock] = "buildBlock",
  [sym_taskBlock] = "taskBlock",
  [sym_recipe] = "recipe",
  [sym__recipeStatement] = "_recipeStatement",
  [sym_run] = "run",
  [sym_runBlock] = "runBlock",
  [sym__runStatement] = "_runStatement",
  [sym_build] = "build",
  [sym_config] = "config",
  [sym_copy] = "copy",
  [sym_default] = "default",
  [sym_delete] = "delete",
  [sym_depfile] = "depfile",
  [sym_envRemove] = "envRemove",
  [sym_from] = "from",
  [sym_info] = "info",
  [sym_let] = "let",
  [sym_setEnv] = "setEnv",
  [sym_shell] = "shell",
  [sym_write] = "write",
  [sym_exp] = "exp",
  [sym_access] = "access",
  [sym_error] = "error",
  [sym_getEnv] = "getEnv",
  [sym_glob] = "glob",
  [sym_include] = "include",
  [sym_pipe] = "pipe",
  [sym_read] = "read",
  [sym_warn] = "warn",
  [sym_which] = "which",
  [sym_op] = "op",
  [sym_assertEq] = "assertEq",
  [sym_discard] = "discard",
  [sym_filter] = "filter",
  [sym_filterMatch] = "filterMatch",
  [sym_join] = "join",
  [sym_map] = "map",
  [sym_match] = "match",
  [sym_matchArm] = "matchArm",
  [sym_split] = "split",
  [sym__value] = "_value",
  [sym_list] = "list",
  [sym_string] = "string",
  [sym_identifier] = "identifier",
  [sym_interpolation] = "interpolation",
  [sym__interpolationBody] = "_interpolationBody",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_recipe_repeat1] = "recipe_repeat1",
  [aux_sym_runBlock_repeat1] = "runBlock_repeat1",
  [aux_sym_match_repeat1] = "match_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_build] = anon_sym_build,
  [anon_sym_task] = anon_sym_task,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_run] = anon_sym_run,
  [anon_sym_config] = anon_sym_config,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_copy] = anon_sym_copy,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_depfile] = anon_sym_depfile,
  [anon_sym_env_DASHremove] = anon_sym_env_DASHremove,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_info] = anon_sym_info,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_env] = anon_sym_env,
  [anon_sym_shell] = anon_sym_shell,
  [anon_sym_write] = anon_sym_write,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_glob] = anon_sym_glob,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_read] = anon_sym_read,
  [anon_sym_warn] = anon_sym_warn,
  [anon_sym_which] = anon_sym_which,
  [anon_sym_dedup] = anon_sym_dedup,
  [anon_sym_first] = anon_sym_first,
  [anon_sym_flatten] = anon_sym_flatten,
  [anon_sym_last] = anon_sym_last,
  [anon_sym_len] = anon_sym_len,
  [anon_sym_lines] = anon_sym_lines,
  [anon_sym_tail] = anon_sym_tail,
  [anon_sym_assert_DASHeq] = anon_sym_assert_DASHeq,
  [anon_sym_discard] = anon_sym_discard,
  [anon_sym_filter] = anon_sym_filter,
  [anon_sym_filter_DASHmatch] = anon_sym_filter_DASHmatch,
  [anon_sym_join] = anon_sym_join,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_split] = anon_sym_split,
  [sym_number] = sym_number,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [sym_comment] = sym_comment,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__interpolationBody_token1] = aux_sym__interpolationBody_token1,
  [aux_sym__interpolationBody_token2] = aux_sym__interpolationBody_token2,
  [sym_interpolationJoin] = sym_interpolationJoin,
  [sym__terminator] = sym__terminator,
  [sym_source_file] = sym_source_file,
  [sym__topLevelStatement] = sym__topLevelStatement,
  [sym_buildBlock] = sym_buildBlock,
  [sym_taskBlock] = sym_taskBlock,
  [sym_recipe] = sym_recipe,
  [sym__recipeStatement] = sym__recipeStatement,
  [sym_run] = sym_run,
  [sym_runBlock] = sym_runBlock,
  [sym__runStatement] = sym__runStatement,
  [sym_build] = sym_build,
  [sym_config] = sym_config,
  [sym_copy] = sym_copy,
  [sym_default] = sym_default,
  [sym_delete] = sym_delete,
  [sym_depfile] = sym_depfile,
  [sym_envRemove] = sym_envRemove,
  [sym_from] = sym_from,
  [sym_info] = sym_info,
  [sym_let] = sym_let,
  [sym_setEnv] = sym_setEnv,
  [sym_shell] = sym_shell,
  [sym_write] = sym_write,
  [sym_exp] = sym_exp,
  [sym_access] = sym_access,
  [sym_error] = sym_error,
  [sym_getEnv] = sym_getEnv,
  [sym_glob] = sym_glob,
  [sym_include] = sym_include,
  [sym_pipe] = sym_pipe,
  [sym_read] = sym_read,
  [sym_warn] = sym_warn,
  [sym_which] = sym_which,
  [sym_op] = sym_op,
  [sym_assertEq] = sym_assertEq,
  [sym_discard] = sym_discard,
  [sym_filter] = sym_filter,
  [sym_filterMatch] = sym_filterMatch,
  [sym_join] = sym_join,
  [sym_map] = sym_map,
  [sym_match] = sym_match,
  [sym_matchArm] = sym_matchArm,
  [sym_split] = sym_split,
  [sym__value] = sym__value,
  [sym_list] = sym_list,
  [sym_string] = sym_string,
  [sym_identifier] = sym_identifier,
  [sym_interpolation] = sym_interpolation,
  [sym__interpolationBody] = sym__interpolationBody,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_recipe_repeat1] = aux_sym_recipe_repeat1,
  [aux_sym_runBlock_repeat1] = aux_sym_runBlock_repeat1,
  [aux_sym_match_repeat1] = aux_sym_match_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_build] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_task] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_run] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_config] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_copy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_depfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_env_DASHremove] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_info] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_env] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shell] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_write] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_glob] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_read] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_warn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_which] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dedup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_first] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_flatten] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_last] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_len] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lines] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert_DASHeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_discard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter_DASHmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_join] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_split] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__interpolationBody_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpolationBody_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_interpolationJoin] = {
    .visible = true,
    .named = true,
  },
  [sym__terminator] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__topLevelStatement] = {
    .visible = false,
    .named = true,
  },
  [sym_buildBlock] = {
    .visible = true,
    .named = true,
  },
  [sym_taskBlock] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe] = {
    .visible = true,
    .named = true,
  },
  [sym__recipeStatement] = {
    .visible = false,
    .named = true,
  },
  [sym_run] = {
    .visible = true,
    .named = true,
  },
  [sym_runBlock] = {
    .visible = true,
    .named = true,
  },
  [sym__runStatement] = {
    .visible = false,
    .named = true,
  },
  [sym_build] = {
    .visible = true,
    .named = true,
  },
  [sym_config] = {
    .visible = true,
    .named = true,
  },
  [sym_copy] = {
    .visible = true,
    .named = true,
  },
  [sym_default] = {
    .visible = true,
    .named = true,
  },
  [sym_delete] = {
    .visible = true,
    .named = true,
  },
  [sym_depfile] = {
    .visible = true,
    .named = true,
  },
  [sym_envRemove] = {
    .visible = true,
    .named = true,
  },
  [sym_from] = {
    .visible = true,
    .named = true,
  },
  [sym_info] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_setEnv] = {
    .visible = true,
    .named = true,
  },
  [sym_shell] = {
    .visible = true,
    .named = true,
  },
  [sym_write] = {
    .visible = true,
    .named = true,
  },
  [sym_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_access] = {
    .visible = true,
    .named = true,
  },
  [sym_error] = {
    .visible = true,
    .named = true,
  },
  [sym_getEnv] = {
    .visible = true,
    .named = true,
  },
  [sym_glob] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_read] = {
    .visible = true,
    .named = true,
  },
  [sym_warn] = {
    .visible = true,
    .named = true,
  },
  [sym_which] = {
    .visible = true,
    .named = true,
  },
  [sym_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assertEq] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_filterMatch] = {
    .visible = true,
    .named = true,
  },
  [sym_join] = {
    .visible = true,
    .named = true,
  },
  [sym_map] = {
    .visible = true,
    .named = true,
  },
  [sym_match] = {
    .visible = true,
    .named = true,
  },
  [sym_matchArm] = {
    .visible = true,
    .named = true,
  },
  [sym_split] = {
    .visible = true,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__interpolationBody] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_runBlock_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_name = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 12,
  [35] = 10,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 20,
  [41] = 21,
  [42] = 22,
  [43] = 23,
  [44] = 24,
  [45] = 25,
  [46] = 20,
  [47] = 21,
  [48] = 22,
  [49] = 23,
  [50] = 24,
  [51] = 25,
  [52] = 20,
  [53] = 21,
  [54] = 22,
  [55] = 23,
  [56] = 24,
  [57] = 25,
  [58] = 20,
  [59] = 21,
  [60] = 22,
  [61] = 23,
  [62] = 24,
  [63] = 25,
  [64] = 64,
  [65] = 12,
  [66] = 10,
  [67] = 36,
  [68] = 36,
  [69] = 37,
  [70] = 38,
  [71] = 39,
  [72] = 64,
  [73] = 12,
  [74] = 10,
  [75] = 37,
  [76] = 36,
  [77] = 37,
  [78] = 38,
  [79] = 39,
  [80] = 64,
  [81] = 12,
  [82] = 10,
  [83] = 64,
  [84] = 36,
  [85] = 37,
  [86] = 38,
  [87] = 39,
  [88] = 64,
  [89] = 38,
  [90] = 39,
  [91] = 11,
  [92] = 9,
  [93] = 93,
  [94] = 16,
  [95] = 31,
  [96] = 11,
  [97] = 9,
  [98] = 16,
  [99] = 31,
  [100] = 11,
  [101] = 9,
  [102] = 16,
  [103] = 31,
  [104] = 11,
  [105] = 9,
  [106] = 16,
  [107] = 31,
  [108] = 93,
  [109] = 109,
  [110] = 109,
  [111] = 109,
  [112] = 109,
  [113] = 109,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 120,
  [166] = 122,
  [167] = 148,
  [168] = 123,
  [169] = 149,
  [170] = 127,
  [171] = 128,
  [172] = 136,
  [173] = 124,
  [174] = 138,
  [175] = 139,
  [176] = 125,
  [177] = 129,
  [178] = 126,
  [179] = 141,
  [180] = 142,
  [181] = 143,
  [182] = 121,
  [183] = 144,
  [184] = 132,
  [185] = 133,
  [186] = 134,
  [187] = 130,
  [188] = 131,
  [189] = 140,
  [190] = 145,
  [191] = 135,
  [192] = 137,
  [193] = 146,
  [194] = 147,
  [195] = 195,
  [196] = 196,
  [197] = 158,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 140,
  [203] = 122,
  [204] = 131,
  [205] = 205,
  [206] = 205,
  [207] = 207,
  [208] = 207,
  [209] = 207,
  [210] = 205,
  [211] = 211,
  [212] = 205,
  [213] = 207,
  [214] = 207,
  [215] = 205,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 216,
  [220] = 217,
  [221] = 217,
  [222] = 217,
  [223] = 216,
  [224] = 216,
  [225] = 120,
  [226] = 120,
  [227] = 217,
  [228] = 122,
  [229] = 216,
  [230] = 124,
  [231] = 130,
  [232] = 141,
  [233] = 121,
  [234] = 142,
  [235] = 129,
  [236] = 130,
  [237] = 143,
  [238] = 144,
  [239] = 132,
  [240] = 133,
  [241] = 134,
  [242] = 135,
  [243] = 243,
  [244] = 132,
  [245] = 137,
  [246] = 133,
  [247] = 138,
  [248] = 139,
  [249] = 134,
  [250] = 141,
  [251] = 142,
  [252] = 143,
  [253] = 144,
  [254] = 135,
  [255] = 137,
  [256] = 138,
  [257] = 145,
  [258] = 146,
  [259] = 131,
  [260] = 147,
  [261] = 146,
  [262] = 148,
  [263] = 147,
  [264] = 123,
  [265] = 149,
  [266] = 148,
  [267] = 123,
  [268] = 127,
  [269] = 149,
  [270] = 127,
  [271] = 128,
  [272] = 136,
  [273] = 128,
  [274] = 125,
  [275] = 126,
  [276] = 121,
  [277] = 136,
  [278] = 124,
  [279] = 125,
  [280] = 126,
  [281] = 139,
  [282] = 140,
  [283] = 129,
  [284] = 145,
  [285] = 285,
  [286] = 286,
  [287] = 285,
  [288] = 288,
  [289] = 285,
  [290] = 290,
  [291] = 285,
  [292] = 285,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 296,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 298,
  [302] = 302,
  [303] = 296,
  [304] = 298,
  [305] = 120,
  [306] = 296,
  [307] = 122,
  [308] = 296,
  [309] = 299,
  [310] = 298,
  [311] = 299,
  [312] = 299,
  [313] = 298,
  [314] = 299,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 315,
  [323] = 323,
  [324] = 324,
  [325] = 324,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 328,
  [332] = 332,
  [333] = 333,
  [334] = 318,
  [335] = 335,
  [336] = 336,
  [337] = 315,
  [338] = 129,
  [339] = 324,
  [340] = 130,
  [341] = 341,
  [342] = 131,
  [343] = 132,
  [344] = 133,
  [345] = 134,
  [346] = 135,
  [347] = 137,
  [348] = 138,
  [349] = 139,
  [350] = 328,
  [351] = 140,
  [352] = 141,
  [353] = 318,
  [354] = 142,
  [355] = 143,
  [356] = 144,
  [357] = 315,
  [358] = 358,
  [359] = 359,
  [360] = 324,
  [361] = 315,
  [362] = 362,
  [363] = 328,
  [364] = 145,
  [365] = 146,
  [366] = 318,
  [367] = 147,
  [368] = 148,
  [369] = 123,
  [370] = 149,
  [371] = 127,
  [372] = 128,
  [373] = 324,
  [374] = 136,
  [375] = 124,
  [376] = 125,
  [377] = 126,
  [378] = 121,
  [379] = 318,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 320,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 326,
  [388] = 328,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 389,
  [393] = 393,
  [394] = 389,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 389,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 389,
  [405] = 405,
  [406] = 390,
  [407] = 400,
  [408] = 400,
  [409] = 400,
  [410] = 400,
  [411] = 411,
};

static TSCharacterRange aux_sym_identifier_token1_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'#', ';'}, {'=', '='}, {'?', 'Z'}, {'\\', '\\'}, {'^', 'z'},
  {'|', '|'}, {'~', 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(147);
      ADVANCE_MAP(
        '"', 214,
        '#', 1,
        '(', 172,
        ')', 174,
        ',', 212,
        '-', 10,
        '.', 145,
        ':', 248,
        '<', 245,
        '=', 157,
        '>', 246,
        '[', 175,
        ']', 177,
        'a', 120,
        'b', 136,
        'c', 98,
        'd', 40,
        'e', 89,
        'f', 66,
        'g', 81,
        'i', 90,
        'j', 103,
        'l', 24,
        'm', 17,
        'r', 49,
        's', 13,
        't', 18,
        'w', 20,
        '{', 151,
        '|', 184,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(2);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '<') ADVANCE(245);
      if (lookahead == '{') ADVANCE(151);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(216);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '*') ADVANCE(254);
      if (lookahead == ':') ADVANCE(249);
      if (lookahead == '=') ADVANCE(8);
      if (lookahead == '>') ADVANCE(247);
      if (lookahead == '[') ADVANCE(176);
      if (lookahead == '|') ADVANCE(185);
      if (lookahead == '}') ADVANCE(153);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(3);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 214,
        '(', 173,
        ',', 213,
        '-', 217,
        '.', 242,
        '[', 175,
        ']', 177,
        'e', 231,
        'g', 229,
        'i', 232,
        'r', 225,
        'w', 219,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(243);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '"', 214,
        '(', 173,
        '-', 217,
        '.', 242,
        '>', 246,
        '[', 175,
        'e', 231,
        'g', 229,
        'i', 232,
        'r', 225,
        'w', 219,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != ']' &&
          lookahead != '{') ADVANCE(243);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        ')', 174,
        ',', 212,
        '.', 16,
        '=', 156,
        '[', 175,
        ']', 177,
        'd', 52,
        's', 12,
        't', 99,
        '{', 151,
        '|', 184,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(253);
      if (lookahead == '>') ADVANCE(206);
      END_STATE();
    case 9:
      if (lookahead == '-') ADVANCE(45);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == '=') ADVANCE(11);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(16);
      END_STATE();
    case 12:
      if (lookahead == '/') ADVANCE(15);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == 'h') ADVANCE(51);
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 14:
      if (lookahead == '/') ADVANCE(252);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '/') ADVANCE(14);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(11);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(106);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(72);
      if (lookahead == 'o') ADVANCE(159);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(34);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(92);
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(118);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 28:
      if (lookahead == 'b') ADVANCE(180);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(63);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(65);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'f') ADVANCE(102);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(25);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(186);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(149);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(200);
      END_STATE();
    case 37:
      if (lookahead == 'd') ADVANCE(137);
      END_STATE();
    case 38:
      if (lookahead == 'd') ADVANCE(137);
      if (lookahead == 'f') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(57);
      if (lookahead == 'p') ADVANCE(60);
      END_STATE();
    case 39:
      if (lookahead == 'd') ADVANCE(44);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(57);
      if (lookahead == 'p') ADVANCE(60);
      END_STATE();
    case 59:
      if (lookahead == 'f') ADVANCE(67);
      END_STATE();
    case 60:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 61:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 62:
      if (lookahead == 'h') ADVANCE(51);
      END_STATE();
    case 63:
      if (lookahead == 'h') ADVANCE(205);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(190);
      END_STATE();
    case 65:
      if (lookahead == 'h') ADVANCE(202);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(76);
      if (lookahead == 'l') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(30);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(77);
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 75:
      if (lookahead == 'k') ADVANCE(150);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 77:
      if (lookahead == 'l') ADVANCE(198);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 81:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 86:
      if (lookahead == 'm') ADVANCE(164);
      END_STATE();
    case 87:
      if (lookahead == 'm') ADVANCE(104);
      END_STATE();
    case 88:
      if (lookahead == 'm') ADVANCE(27);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(141);
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(59);
      if (lookahead == 'p') ADVANCE(143);
      END_STATE();
    case 92:
      if (lookahead == 'n') ADVANCE(196);
      if (lookahead == 't') ADVANCE(167);
      END_STATE();
    case 93:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(188);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(194);
      END_STATE();
    case 97:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 98:
      if (lookahead == 'o') ADVANCE(91);
      END_STATE();
    case 99:
      if (lookahead == 'o') ADVANCE(159);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 101:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 102:
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 103:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 105:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 106:
      if (lookahead == 'p') ADVANCE(204);
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 107:
      if (lookahead == 'p') ADVANCE(192);
      END_STATE();
    case 108:
      if (lookahead == 'q') ADVANCE(199);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 112:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(105);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 115:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 117:
      if (lookahead == 's') ADVANCE(33);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 119:
      if (lookahead == 's') ADVANCE(197);
      END_STATE();
    case 120:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 123:
      if (lookahead == 's') ADVANCE(126);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(167);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(9);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 134:
      if (lookahead == 't') ADVANCE(55);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 137:
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 138:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 139:
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 140:
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 141:
      if (lookahead == 'v') ADVANCE(168);
      END_STATE();
    case 142:
      if (lookahead == 'v') ADVANCE(46);
      END_STATE();
    case 143:
      if (lookahead == 'y') ADVANCE(158);
      END_STATE();
    case 144:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(144);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 145:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      END_STATE();
    case 146:
      if (eof) ADVANCE(147);
      ADVANCE_MAP(
        '\n', 148,
        '"', 214,
        '#', 1,
        '[', 175,
        'b', 136,
        'c', 98,
        'd', 47,
        'e', 89,
        'f', 111,
        'i', 90,
        'l', 56,
        'r', 138,
        's', 62,
        't', 26,
        'w', 21,
        '|', 184,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_build);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_task);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_run);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_config);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(206);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_copy);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_depfile);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_env_DASHremove);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_info);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_info);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_env);
      if (lookahead == '-') ADVANCE(116);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_env);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_shell);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_write);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_error);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_glob);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_glob);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_include);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_read);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_read);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_warn);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_warn);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_which);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_which);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_dedup);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_first);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_flatten);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_last);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_len);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_lines);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_tail);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_assert_DASHeq);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_discard);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_filter);
      if (lookahead == '-') ADVANCE(88);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_filter_DASHmatch);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_join);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_split);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(223);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(238);
      if (lookahead == 'h') ADVANCE(228);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'b') ADVANCE(181);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(227);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(230);
      if (lookahead == 'f') ADVANCE(235);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'd') ADVANCE(187);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'd') ADVANCE(226);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(218);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(183);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(191);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(221);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(234);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(240);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(241);
      if (lookahead == 'r') ADVANCE(239);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(222);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(189);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(220);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(166);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(237);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(179);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(233);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(236);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(224);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'v') ADVANCE(169);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if ((!eof && set_contains(aux_sym_identifier_token1_character_set_1, 10, lookahead))) ADVANCE(243);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym__interpolationBody_token1);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == '=') ADVANCE(250);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym__interpolationBody_token1);
      if (lookahead == '=') ADVANCE(250);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(251);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(aux_sym__interpolationBody_token2);
      if (lookahead == '/') ADVANCE(252);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(14);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_interpolationJoin);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_interpolationJoin);
      if (lookahead == '*') ADVANCE(253);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 146},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 4},
  [4] = {.lex_state = 4},
  [5] = {.lex_state = 4},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 5},
  [13] = {.lex_state = 5},
  [14] = {.lex_state = 5},
  [15] = {.lex_state = 5},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 5},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 5},
  [20] = {.lex_state = 5},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 5},
  [23] = {.lex_state = 5},
  [24] = {.lex_state = 5},
  [25] = {.lex_state = 5},
  [26] = {.lex_state = 5},
  [27] = {.lex_state = 5},
  [28] = {.lex_state = 5},
  [29] = {.lex_state = 5},
  [30] = {.lex_state = 5},
  [31] = {.lex_state = 5},
  [32] = {.lex_state = 5},
  [33] = {.lex_state = 5},
  [34] = {.lex_state = 5},
  [35] = {.lex_state = 5},
  [36] = {.lex_state = 5},
  [37] = {.lex_state = 5},
  [38] = {.lex_state = 5},
  [39] = {.lex_state = 5},
  [40] = {.lex_state = 5},
  [41] = {.lex_state = 5},
  [42] = {.lex_state = 5},
  [43] = {.lex_state = 5},
  [44] = {.lex_state = 5},
  [45] = {.lex_state = 5},
  [46] = {.lex_state = 5},
  [47] = {.lex_state = 5},
  [48] = {.lex_state = 5},
  [49] = {.lex_state = 5},
  [50] = {.lex_state = 5},
  [51] = {.lex_state = 5},
  [52] = {.lex_state = 5},
  [53] = {.lex_state = 5},
  [54] = {.lex_state = 5},
  [55] = {.lex_state = 5},
  [56] = {.lex_state = 5},
  [57] = {.lex_state = 5},
  [58] = {.lex_state = 5},
  [59] = {.lex_state = 5},
  [60] = {.lex_state = 5},
  [61] = {.lex_state = 5},
  [62] = {.lex_state = 5},
  [63] = {.lex_state = 5},
  [64] = {.lex_state = 5},
  [65] = {.lex_state = 5},
  [66] = {.lex_state = 5},
  [67] = {.lex_state = 5},
  [68] = {.lex_state = 5},
  [69] = {.lex_state = 5},
  [70] = {.lex_state = 5},
  [71] = {.lex_state = 5},
  [72] = {.lex_state = 5},
  [73] = {.lex_state = 5},
  [74] = {.lex_state = 5},
  [75] = {.lex_state = 5},
  [76] = {.lex_state = 5},
  [77] = {.lex_state = 5},
  [78] = {.lex_state = 5},
  [79] = {.lex_state = 5},
  [80] = {.lex_state = 5},
  [81] = {.lex_state = 5},
  [82] = {.lex_state = 5},
  [83] = {.lex_state = 5},
  [84] = {.lex_state = 5},
  [85] = {.lex_state = 5},
  [86] = {.lex_state = 5},
  [87] = {.lex_state = 5},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 146},
  [115] = {.lex_state = 146},
  [116] = {.lex_state = 146},
  [117] = {.lex_state = 146},
  [118] = {.lex_state = 146},
  [119] = {.lex_state = 146},
  [120] = {.lex_state = 146},
  [121] = {.lex_state = 146},
  [122] = {.lex_state = 146},
  [123] = {.lex_state = 146},
  [124] = {.lex_state = 146},
  [125] = {.lex_state = 146},
  [126] = {.lex_state = 146},
  [127] = {.lex_state = 146},
  [128] = {.lex_state = 146},
  [129] = {.lex_state = 146},
  [130] = {.lex_state = 146},
  [131] = {.lex_state = 146},
  [132] = {.lex_state = 146},
  [133] = {.lex_state = 146},
  [134] = {.lex_state = 146},
  [135] = {.lex_state = 146},
  [136] = {.lex_state = 146},
  [137] = {.lex_state = 146},
  [138] = {.lex_state = 146},
  [139] = {.lex_state = 146},
  [140] = {.lex_state = 146},
  [141] = {.lex_state = 146},
  [142] = {.lex_state = 146},
  [143] = {.lex_state = 146},
  [144] = {.lex_state = 146},
  [145] = {.lex_state = 146},
  [146] = {.lex_state = 146},
  [147] = {.lex_state = 146},
  [148] = {.lex_state = 146},
  [149] = {.lex_state = 146},
  [150] = {.lex_state = 146},
  [151] = {.lex_state = 146},
  [152] = {.lex_state = 146},
  [153] = {.lex_state = 146},
  [154] = {.lex_state = 146},
  [155] = {.lex_state = 146},
  [156] = {.lex_state = 146},
  [157] = {.lex_state = 146},
  [158] = {.lex_state = 146},
  [159] = {.lex_state = 146},
  [160] = {.lex_state = 146},
  [161] = {.lex_state = 146},
  [162] = {.lex_state = 146},
  [163] = {.lex_state = 146},
  [164] = {.lex_state = 146},
  [165] = {.lex_state = 146},
  [166] = {.lex_state = 146},
  [167] = {.lex_state = 146},
  [168] = {.lex_state = 146},
  [169] = {.lex_state = 146},
  [170] = {.lex_state = 146},
  [171] = {.lex_state = 146},
  [172] = {.lex_state = 146},
  [173] = {.lex_state = 146},
  [174] = {.lex_state = 146},
  [175] = {.lex_state = 146},
  [176] = {.lex_state = 146},
  [177] = {.lex_state = 146},
  [178] = {.lex_state = 146},
  [179] = {.lex_state = 146},
  [180] = {.lex_state = 146},
  [181] = {.lex_state = 146},
  [182] = {.lex_state = 146},
  [183] = {.lex_state = 146},
  [184] = {.lex_state = 146},
  [185] = {.lex_state = 146},
  [186] = {.lex_state = 146},
  [187] = {.lex_state = 146},
  [188] = {.lex_state = 146},
  [189] = {.lex_state = 146},
  [190] = {.lex_state = 146},
  [191] = {.lex_state = 146},
  [192] = {.lex_state = 146},
  [193] = {.lex_state = 146},
  [194] = {.lex_state = 146},
  [195] = {.lex_state = 146},
  [196] = {.lex_state = 146},
  [197] = {.lex_state = 146},
  [198] = {.lex_state = 146},
  [199] = {.lex_state = 146},
  [200] = {.lex_state = 146},
  [201] = {.lex_state = 146},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 146},
  [206] = {.lex_state = 146},
  [207] = {.lex_state = 146},
  [208] = {.lex_state = 146},
  [209] = {.lex_state = 146},
  [210] = {.lex_state = 146},
  [211] = {.lex_state = 146},
  [212] = {.lex_state = 146},
  [213] = {.lex_state = 146},
  [214] = {.lex_state = 146},
  [215] = {.lex_state = 146},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 2},
  [220] = {.lex_state = 2},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 3},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 2},
  [228] = {.lex_state = 3},
  [229] = {.lex_state = 2},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 3},
  [232] = {.lex_state = 3},
  [233] = {.lex_state = 3},
  [234] = {.lex_state = 3},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 3},
  [238] = {.lex_state = 3},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 3},
  [244] = {.lex_state = 3},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 3},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 3},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 3},
  [255] = {.lex_state = 3},
  [256] = {.lex_state = 3},
  [257] = {.lex_state = 3},
  [258] = {.lex_state = 3},
  [259] = {.lex_state = 3},
  [260] = {.lex_state = 3},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 3},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 3},
  [265] = {.lex_state = 3},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 3},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 3},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 3},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 3},
  [280] = {.lex_state = 3},
  [281] = {.lex_state = 3},
  [282] = {.lex_state = 3},
  [283] = {.lex_state = 3},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 2},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 6},
  [295] = {.lex_state = 6},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0, .external_lex_state = 1},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0, .external_lex_state = 1},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0, .external_lex_state = 1},
  [318] = {.lex_state = 0, .external_lex_state = 1},
  [319] = {.lex_state = 0, .external_lex_state = 1},
  [320] = {.lex_state = 0, .external_lex_state = 1},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0, .external_lex_state = 1},
  [324] = {.lex_state = 0, .external_lex_state = 1},
  [325] = {.lex_state = 0, .external_lex_state = 1},
  [326] = {.lex_state = 144},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 144},
  [330] = {.lex_state = 144},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0, .external_lex_state = 1},
  [333] = {.lex_state = 0, .external_lex_state = 1},
  [334] = {.lex_state = 0, .external_lex_state = 1},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 144},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0, .external_lex_state = 1},
  [339] = {.lex_state = 0, .external_lex_state = 1},
  [340] = {.lex_state = 0, .external_lex_state = 1},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0, .external_lex_state = 1},
  [343] = {.lex_state = 0, .external_lex_state = 1},
  [344] = {.lex_state = 0, .external_lex_state = 1},
  [345] = {.lex_state = 0, .external_lex_state = 1},
  [346] = {.lex_state = 0, .external_lex_state = 1},
  [347] = {.lex_state = 0, .external_lex_state = 1},
  [348] = {.lex_state = 0, .external_lex_state = 1},
  [349] = {.lex_state = 0, .external_lex_state = 1},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0, .external_lex_state = 1},
  [352] = {.lex_state = 0, .external_lex_state = 1},
  [353] = {.lex_state = 0, .external_lex_state = 1},
  [354] = {.lex_state = 0, .external_lex_state = 1},
  [355] = {.lex_state = 0, .external_lex_state = 1},
  [356] = {.lex_state = 0, .external_lex_state = 1},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0, .external_lex_state = 1},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0, .external_lex_state = 1},
  [365] = {.lex_state = 0, .external_lex_state = 1},
  [366] = {.lex_state = 0, .external_lex_state = 1},
  [367] = {.lex_state = 0, .external_lex_state = 1},
  [368] = {.lex_state = 0, .external_lex_state = 1},
  [369] = {.lex_state = 0, .external_lex_state = 1},
  [370] = {.lex_state = 0, .external_lex_state = 1},
  [371] = {.lex_state = 0, .external_lex_state = 1},
  [372] = {.lex_state = 0, .external_lex_state = 1},
  [373] = {.lex_state = 0, .external_lex_state = 1},
  [374] = {.lex_state = 0, .external_lex_state = 1},
  [375] = {.lex_state = 0, .external_lex_state = 1},
  [376] = {.lex_state = 0, .external_lex_state = 1},
  [377] = {.lex_state = 0, .external_lex_state = 1},
  [378] = {.lex_state = 0, .external_lex_state = 1},
  [379] = {.lex_state = 0, .external_lex_state = 1},
  [380] = {.lex_state = 0, .external_lex_state = 1},
  [381] = {.lex_state = 0, .external_lex_state = 1},
  [382] = {.lex_state = 0, .external_lex_state = 1},
  [383] = {.lex_state = 0, .external_lex_state = 1},
  [384] = {.lex_state = 0, .external_lex_state = 1},
  [385] = {.lex_state = 0, .external_lex_state = 1},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 144},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 6},
  [391] = {.lex_state = 0, .external_lex_state = 1},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 6},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0, .external_lex_state = 1},
  [398] = {.lex_state = 0, .external_lex_state = 1},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 3},
  [401] = {.lex_state = 6},
  [402] = {.lex_state = 0, .external_lex_state = 1},
  [403] = {.lex_state = 0, .external_lex_state = 1},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 6},
  [406] = {.lex_state = 6},
  [407] = {.lex_state = 3},
  [408] = {.lex_state = 3},
  [409] = {.lex_state = 3},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_build] = ACTIONS(1),
    [anon_sym_task] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_run] = ACTIONS(1),
    [anon_sym_config] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_copy] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_depfile] = ACTIONS(1),
    [anon_sym_env_DASHremove] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_info] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_env] = ACTIONS(1),
    [anon_sym_shell] = ACTIONS(1),
    [anon_sym_write] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_glob] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_read] = ACTIONS(1),
    [anon_sym_warn] = ACTIONS(1),
    [anon_sym_which] = ACTIONS(1),
    [anon_sym_dedup] = ACTIONS(1),
    [anon_sym_first] = ACTIONS(1),
    [anon_sym_flatten] = ACTIONS(1),
    [anon_sym_last] = ACTIONS(1),
    [anon_sym_len] = ACTIONS(1),
    [anon_sym_lines] = ACTIONS(1),
    [anon_sym_tail] = ACTIONS(1),
    [anon_sym_assert_DASHeq] = ACTIONS(1),
    [anon_sym_discard] = ACTIONS(1),
    [anon_sym_filter] = ACTIONS(1),
    [anon_sym_filter_DASHmatch] = ACTIONS(1),
    [anon_sym_join] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_split] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [aux_sym__interpolationBody_token2] = ACTIONS(1),
    [sym__terminator] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(411),
    [sym__topLevelStatement] = STATE(153),
    [sym_buildBlock] = STATE(153),
    [sym_taskBlock] = STATE(153),
    [sym_config] = STATE(153),
    [sym_default] = STATE(153),
    [sym_let] = STATE(153),
    [sym_include] = STATE(153),
    [aux_sym_source_file_repeat1] = STATE(153),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_build] = ACTIONS(7),
    [anon_sym_task] = ACTIONS(9),
    [anon_sym_config] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(13),
    [anon_sym_let] = ACTIONS(15),
    [anon_sym_include] = ACTIONS(17),
    [sym_comment] = ACTIONS(19),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 19,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_RBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(289), 1,
      sym_exp,
    STATE(303), 1,
      aux_sym_list_repeat1,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [70] = 19,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    ACTIONS(51), 1,
      anon_sym_RBRACK,
    STATE(226), 1,
      sym_identifier,
    STATE(291), 1,
      sym_exp,
    STATE(306), 1,
      aux_sym_list_repeat1,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [140] = 19,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    ACTIONS(53), 1,
      anon_sym_RBRACK,
    STATE(226), 1,
      sym_identifier,
    STATE(285), 1,
      sym_exp,
    STATE(296), 1,
      aux_sym_list_repeat1,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [210] = 19,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    ACTIONS(55), 1,
      anon_sym_RBRACK,
    STATE(226), 1,
      sym_identifier,
    STATE(287), 1,
      sym_exp,
    STATE(297), 1,
      aux_sym_list_repeat1,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [280] = 19,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    ACTIONS(57), 1,
      anon_sym_RBRACK,
    STATE(226), 1,
      sym_identifier,
    STATE(292), 1,
      sym_exp,
    STATE(308), 1,
      aux_sym_list_repeat1,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [350] = 18,
    ACTIONS(59), 1,
      anon_sym_RBRACE,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(243), 1,
      sym_exp,
    STATE(395), 1,
      sym__interpolationBody,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [417] = 18,
    ACTIONS(59), 1,
      anon_sym_GT,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(243), 1,
      sym_exp,
    STATE(396), 1,
      sym__interpolationBody,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [484] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(379), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [545] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(185), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [606] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(328), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [667] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(184), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [728] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(381), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [789] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(382), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [850] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(293), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [911] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(361), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [972] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(380), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1033] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(384), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1094] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(385), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1155] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(194), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1216] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(167), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1277] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(168), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1338] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(170), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1399] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(171), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1460] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(172), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1521] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(316), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1582] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(317), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1643] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(319), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1704] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(321), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1765] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(323), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1826] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(325), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1887] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(332), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [1948] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(333), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2009] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(239), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2070] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(240), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2131] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(242), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2192] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(245), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2253] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(247), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2314] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(248), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2375] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(263), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2436] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(266), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2497] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(267), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2558] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(270), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2619] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(271), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2680] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(272), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2741] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(367), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2802] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(368), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2863] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(369), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2924] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(371), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [2985] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(372), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3046] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(374), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3107] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(260), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3168] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(262), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3229] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(264), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3290] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(268), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3351] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(273), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3412] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(277), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3473] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(147), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3534] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(148), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3595] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(123), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3656] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(127), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3717] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(128), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3778] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(136), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3839] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(236), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3900] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(343), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [3961] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(344), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4022] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(191), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4083] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(346), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4144] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(347), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4205] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(348), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4266] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(349), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4327] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(340), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4388] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(244), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4449] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(246), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4510] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(192), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4571] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(254), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4632] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(255), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4693] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(256), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4754] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(281), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4815] = 16,
    ACTIONS(61), 1,
      anon_sym_info,
    ACTIONS(63), 1,
      anon_sym_env,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_error,
    ACTIONS(71), 1,
      anon_sym_glob,
    ACTIONS(73), 1,
      anon_sym_include,
    ACTIONS(75), 1,
      anon_sym_read,
    ACTIONS(77), 1,
      anon_sym_warn,
    ACTIONS(79), 1,
      anon_sym_which,
    ACTIONS(81), 1,
      sym_number,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(85), 1,
      aux_sym_identifier_token1,
    STATE(225), 1,
      sym_identifier,
    STATE(231), 1,
      sym_exp,
    STATE(283), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4876] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(132), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4937] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(133), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [4998] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(187), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5059] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(135), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5120] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(137), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5181] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(138), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5242] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(139), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5303] = 16,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(139), 1,
      anon_sym_env,
    ACTIONS(141), 1,
      anon_sym_LPAREN,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(147), 1,
      anon_sym_glob,
    ACTIONS(149), 1,
      anon_sym_include,
    ACTIONS(151), 1,
      anon_sym_read,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(155), 1,
      anon_sym_which,
    ACTIONS(157), 1,
      sym_number,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      aux_sym_identifier_token1,
    STATE(120), 1,
      sym_identifier,
    STATE(130), 1,
      sym_exp,
    STATE(129), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5364] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(174), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5425] = 16,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(113), 1,
      anon_sym_info,
    ACTIONS(115), 1,
      anon_sym_env,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(119), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_error,
    ACTIONS(123), 1,
      anon_sym_glob,
    ACTIONS(125), 1,
      anon_sym_read,
    ACTIONS(127), 1,
      anon_sym_warn,
    ACTIONS(129), 1,
      anon_sym_which,
    ACTIONS(131), 1,
      sym_number,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(135), 1,
      aux_sym_identifier_token1,
    STATE(165), 1,
      sym_identifier,
    STATE(175), 1,
      sym_exp,
    STATE(177), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5486] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(388), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5547] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(318), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5608] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(320), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5669] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(322), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5730] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(324), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5791] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(331), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5852] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(334), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5913] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(337), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [5974] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(339), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6035] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(350), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6096] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(353), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6157] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(357), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6218] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(360), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6279] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(363), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6340] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(366), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6401] = 16,
    ACTIONS(21), 1,
      anon_sym_info,
    ACTIONS(23), 1,
      anon_sym_env,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(31), 1,
      anon_sym_error,
    ACTIONS(33), 1,
      anon_sym_glob,
    ACTIONS(35), 1,
      anon_sym_include,
    ACTIONS(37), 1,
      anon_sym_read,
    ACTIONS(39), 1,
      anon_sym_warn,
    ACTIONS(41), 1,
      anon_sym_which,
    ACTIONS(43), 1,
      sym_number,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      aux_sym_identifier_token1,
    STATE(226), 1,
      sym_identifier,
    STATE(315), 1,
      sym_exp,
    STATE(235), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6462] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(373), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6523] = 16,
    ACTIONS(87), 1,
      anon_sym_info,
    ACTIONS(89), 1,
      anon_sym_env,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_error,
    ACTIONS(97), 1,
      anon_sym_glob,
    ACTIONS(99), 1,
      anon_sym_include,
    ACTIONS(101), 1,
      anon_sym_read,
    ACTIONS(103), 1,
      anon_sym_warn,
    ACTIONS(105), 1,
      anon_sym_which,
    ACTIONS(107), 1,
      sym_number,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(111), 1,
      aux_sym_identifier_token1,
    STATE(305), 1,
      sym_identifier,
    STATE(383), 1,
      sym_exp,
    STATE(338), 13,
      sym_info,
      sym_access,
      sym_error,
      sym_getEnv,
      sym_glob,
      sym_include,
      sym_pipe,
      sym_read,
      sym_warn,
      sym_which,
      sym__value,
      sym_list,
      sym_string,
  [6584] = 12,
    ACTIONS(133), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      anon_sym_assert_DASHeq,
    ACTIONS(167), 1,
      anon_sym_discard,
    ACTIONS(169), 1,
      anon_sym_filter,
    ACTIONS(171), 1,
      anon_sym_filter_DASHmatch,
    ACTIONS(173), 1,
      anon_sym_join,
    ACTIONS(175), 1,
      anon_sym_map,
    ACTIONS(177), 1,
      anon_sym_match,
    ACTIONS(179), 1,
      anon_sym_split,
    STATE(190), 1,
      sym_op,
    ACTIONS(163), 7,
      anon_sym_dedup,
      anon_sym_first,
      anon_sym_flatten,
      anon_sym_last,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_tail,
    STATE(183), 9,
      sym_assertEq,
      sym_discard,
      sym_filter,
      sym_filterMatch,
      sym_join,
      sym_map,
      sym_match,
      sym_split,
      sym_string,
  [6635] = 12,
    ACTIONS(83), 1,
      anon_sym_DQUOTE,
    ACTIONS(183), 1,
      anon_sym_assert_DASHeq,
    ACTIONS(185), 1,
      anon_sym_discard,
    ACTIONS(187), 1,
      anon_sym_filter,
    ACTIONS(189), 1,
      anon_sym_filter_DASHmatch,
    ACTIONS(191), 1,
      anon_sym_join,
    ACTIONS(193), 1,
      anon_sym_map,
    ACTIONS(195), 1,
      anon_sym_match,
    ACTIONS(197), 1,
      anon_sym_split,
    STATE(257), 1,
      sym_op,
    ACTIONS(181), 7,
      anon_sym_dedup,
      anon_sym_first,
      anon_sym_flatten,
      anon_sym_last,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_tail,
    STATE(238), 9,
      sym_assertEq,
      sym_discard,
      sym_filter,
      sym_filterMatch,
      sym_join,
      sym_map,
      sym_match,
      sym_split,
      sym_string,
  [6686] = 12,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(201), 1,
      anon_sym_assert_DASHeq,
    ACTIONS(203), 1,
      anon_sym_discard,
    ACTIONS(205), 1,
      anon_sym_filter,
    ACTIONS(207), 1,
      anon_sym_filter_DASHmatch,
    ACTIONS(209), 1,
      anon_sym_join,
    ACTIONS(211), 1,
      anon_sym_map,
    ACTIONS(213), 1,
      anon_sym_match,
    ACTIONS(215), 1,
      anon_sym_split,
    STATE(145), 1,
      sym_op,
    ACTIONS(199), 7,
      anon_sym_dedup,
      anon_sym_first,
      anon_sym_flatten,
      anon_sym_last,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_tail,
    STATE(144), 9,
      sym_assertEq,
      sym_discard,
      sym_filter,
      sym_filterMatch,
      sym_join,
      sym_map,
      sym_match,
      sym_split,
      sym_string,
  [6737] = 12,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    ACTIONS(219), 1,
      anon_sym_assert_DASHeq,
    ACTIONS(221), 1,
      anon_sym_discard,
    ACTIONS(223), 1,
      anon_sym_filter,
    ACTIONS(225), 1,
      anon_sym_filter_DASHmatch,
    ACTIONS(227), 1,
      anon_sym_join,
    ACTIONS(229), 1,
      anon_sym_map,
    ACTIONS(231), 1,
      anon_sym_match,
    ACTIONS(233), 1,
      anon_sym_split,
    STATE(364), 1,
      sym_op,
    ACTIONS(217), 7,
      anon_sym_dedup,
      anon_sym_first,
      anon_sym_flatten,
      anon_sym_last,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_tail,
    STATE(356), 9,
      sym_assertEq,
      sym_discard,
      sym_filter,
      sym_filterMatch,
      sym_join,
      sym_map,
      sym_match,
      sym_split,
      sym_string,
  [6788] = 12,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    ACTIONS(237), 1,
      anon_sym_assert_DASHeq,
    ACTIONS(239), 1,
      anon_sym_discard,
    ACTIONS(241), 1,
      anon_sym_filter,
    ACTIONS(243), 1,
      anon_sym_filter_DASHmatch,
    ACTIONS(245), 1,
      anon_sym_join,
    ACTIONS(247), 1,
      anon_sym_map,
    ACTIONS(249), 1,
      anon_sym_match,
    ACTIONS(251), 1,
      anon_sym_split,
    STATE(284), 1,
      sym_op,
    ACTIONS(235), 7,
      anon_sym_dedup,
      anon_sym_first,
      anon_sym_flatten,
      anon_sym_last,
      anon_sym_len,
      anon_sym_lines,
      anon_sym_tail,
    STATE(253), 9,
      sym_assertEq,
      sym_discard,
      sym_filter,
      sym_filterMatch,
      sym_join,
      sym_map,
      sym_match,
      sym_split,
      sym_string,
  [6839] = 14,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(253), 1,
      anon_sym_LF,
    ACTIONS(255), 1,
      anon_sym_build,
    ACTIONS(257), 1,
      anon_sym_RBRACE,
    ACTIONS(259), 1,
      anon_sym_run,
    ACTIONS(261), 1,
      anon_sym_depfile,
    ACTIONS(263), 1,
      anon_sym_env_DASHremove,
    ACTIONS(265), 1,
      anon_sym_from,
    ACTIONS(267), 1,
      anon_sym_let,
    ACTIONS(269), 1,
      anon_sym_env,
    ACTIONS(271), 1,
      sym_comment,
    STATE(116), 12,
      sym__recipeStatement,
      sym_run,
      sym_build,
      sym_depfile,
      sym_envRemove,
      sym_from,
      sym_info,
      sym_let,
      sym_setEnv,
      sym_error,
      sym_warn,
      aux_sym_recipe_repeat1,
  [6893] = 14,
    ACTIONS(273), 1,
      anon_sym_LF,
    ACTIONS(276), 1,
      anon_sym_build,
    ACTIONS(279), 1,
      anon_sym_RBRACE,
    ACTIONS(281), 1,
      anon_sym_run,
    ACTIONS(284), 1,
      anon_sym_depfile,
    ACTIONS(287), 1,
      anon_sym_env_DASHremove,
    ACTIONS(290), 1,
      anon_sym_from,
    ACTIONS(293), 1,
      anon_sym_info,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(299), 1,
      anon_sym_env,
    ACTIONS(302), 1,
      anon_sym_error,
    ACTIONS(305), 1,
      anon_sym_warn,
    ACTIONS(308), 1,
      sym_comment,
    STATE(115), 12,
      sym__recipeStatement,
      sym_run,
      sym_build,
      sym_depfile,
      sym_envRemove,
      sym_from,
      sym_info,
      sym_let,
      sym_setEnv,
      sym_error,
      sym_warn,
      aux_sym_recipe_repeat1,
  [6947] = 14,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(255), 1,
      anon_sym_build,
    ACTIONS(259), 1,
      anon_sym_run,
    ACTIONS(261), 1,
      anon_sym_depfile,
    ACTIONS(263), 1,
      anon_sym_env_DASHremove,
    ACTIONS(265), 1,
      anon_sym_from,
    ACTIONS(267), 1,
      anon_sym_let,
    ACTIONS(269), 1,
      anon_sym_env,
    ACTIONS(311), 1,
      anon_sym_LF,
    ACTIONS(313), 1,
      anon_sym_RBRACE,
    ACTIONS(315), 1,
      sym_comment,
    STATE(115), 12,
      sym__recipeStatement,
      sym_run,
      sym_build,
      sym_depfile,
      sym_envRemove,
      sym_from,
      sym_info,
      sym_let,
      sym_setEnv,
      sym_error,
      sym_warn,
      aux_sym_recipe_repeat1,
  [7001] = 13,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(263), 1,
      anon_sym_env_DASHremove,
    ACTIONS(269), 1,
      anon_sym_env,
    ACTIONS(317), 1,
      anon_sym_LF,
    ACTIONS(319), 1,
      anon_sym_RBRACE,
    ACTIONS(321), 1,
      anon_sym_copy,
    ACTIONS(323), 1,
      anon_sym_delete,
    ACTIONS(325), 1,
      anon_sym_shell,
    ACTIONS(327), 1,
      anon_sym_write,
    ACTIONS(329), 1,
      sym_comment,
    STATE(119), 11,
      sym__runStatement,
      sym_copy,
      sym_delete,
      sym_envRemove,
      sym_info,
      sym_setEnv,
      sym_shell,
      sym_write,
      sym_error,
      sym_warn,
      aux_sym_runBlock_repeat1,
  [7051] = 13,
    ACTIONS(331), 1,
      anon_sym_LF,
    ACTIONS(334), 1,
      anon_sym_RBRACE,
    ACTIONS(336), 1,
      anon_sym_copy,
    ACTIONS(339), 1,
      anon_sym_delete,
    ACTIONS(342), 1,
      anon_sym_env_DASHremove,
    ACTIONS(345), 1,
      anon_sym_info,
    ACTIONS(348), 1,
      anon_sym_env,
    ACTIONS(351), 1,
      anon_sym_shell,
    ACTIONS(354), 1,
      anon_sym_write,
    ACTIONS(357), 1,
      anon_sym_error,
    ACTIONS(360), 1,
      anon_sym_warn,
    ACTIONS(363), 1,
      sym_comment,
    STATE(118), 11,
      sym__runStatement,
      sym_copy,
      sym_delete,
      sym_envRemove,
      sym_info,
      sym_setEnv,
      sym_shell,
      sym_write,
      sym_error,
      sym_warn,
      aux_sym_runBlock_repeat1,
  [7101] = 13,
    ACTIONS(137), 1,
      anon_sym_info,
    ACTIONS(145), 1,
      anon_sym_error,
    ACTIONS(153), 1,
      anon_sym_warn,
    ACTIONS(263), 1,
      anon_sym_env_DASHremove,
    ACTIONS(269), 1,
      anon_sym_env,
    ACTIONS(321), 1,
      anon_sym_copy,
    ACTIONS(323), 1,
      anon_sym_delete,
    ACTIONS(325), 1,
      anon_sym_shell,
    ACTIONS(327), 1,
      anon_sym_write,
    ACTIONS(366), 1,
      anon_sym_LF,
    ACTIONS(368), 1,
      anon_sym_RBRACE,
    ACTIONS(370), 1,
      sym_comment,
    STATE(118), 11,
      sym__runStatement,
      sym_copy,
      sym_delete,
      sym_envRemove,
      sym_info,
      sym_setEnv,
      sym_shell,
      sym_write,
      sym_error,
      sym_warn,
      aux_sym_runBlock_repeat1,
  [7151] = 3,
    ACTIONS(372), 1,
      anon_sym_LF,
    ACTIONS(376), 1,
      anon_sym_LBRACK,
    ACTIONS(374), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7177] = 2,
    ACTIONS(378), 1,
      anon_sym_LF,
    ACTIONS(380), 18,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      anon_sym_DQUOTE,
      sym_comment,
  [7201] = 2,
    ACTIONS(382), 1,
      anon_sym_LF,
    ACTIONS(384), 18,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_LBRACK,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7225] = 3,
    ACTIONS(386), 1,
      anon_sym_LF,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(388), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7250] = 2,
    ACTIONS(392), 1,
      anon_sym_LF,
    ACTIONS(394), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7273] = 2,
    ACTIONS(396), 1,
      anon_sym_LF,
    ACTIONS(398), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7296] = 2,
    ACTIONS(400), 1,
      anon_sym_LF,
    ACTIONS(402), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7319] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(404), 1,
      anon_sym_LF,
    ACTIONS(406), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7344] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(408), 1,
      anon_sym_LF,
    ACTIONS(410), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7369] = 2,
    ACTIONS(372), 1,
      anon_sym_LF,
    ACTIONS(374), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7392] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(412), 1,
      anon_sym_LF,
    ACTIONS(414), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7417] = 2,
    ACTIONS(416), 1,
      anon_sym_LF,
    ACTIONS(418), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7440] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(420), 1,
      anon_sym_LF,
    ACTIONS(422), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7465] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(424), 1,
      anon_sym_LF,
    ACTIONS(426), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7490] = 2,
    ACTIONS(428), 1,
      anon_sym_LF,
    ACTIONS(430), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7513] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(432), 1,
      anon_sym_LF,
    ACTIONS(434), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7538] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(436), 1,
      anon_sym_LF,
    ACTIONS(438), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7563] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(440), 1,
      anon_sym_LF,
    ACTIONS(442), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7588] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(444), 1,
      anon_sym_LF,
    ACTIONS(446), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7613] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(448), 1,
      anon_sym_LF,
    ACTIONS(450), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7638] = 2,
    ACTIONS(452), 1,
      anon_sym_LF,
    ACTIONS(454), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7661] = 2,
    ACTIONS(456), 1,
      anon_sym_LF,
    ACTIONS(458), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7684] = 2,
    ACTIONS(460), 1,
      anon_sym_LF,
    ACTIONS(462), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7707] = 2,
    ACTIONS(464), 1,
      anon_sym_LF,
    ACTIONS(466), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7730] = 2,
    ACTIONS(468), 1,
      anon_sym_LF,
    ACTIONS(470), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7753] = 2,
    ACTIONS(472), 1,
      anon_sym_LF,
    ACTIONS(474), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7776] = 2,
    ACTIONS(476), 1,
      anon_sym_LF,
    ACTIONS(478), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7799] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(480), 1,
      anon_sym_LF,
    ACTIONS(482), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7824] = 3,
    ACTIONS(390), 1,
      anon_sym_PIPE,
    ACTIONS(484), 1,
      anon_sym_LF,
    ACTIONS(486), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7849] = 2,
    ACTIONS(488), 1,
      anon_sym_LF,
    ACTIONS(490), 17,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_PIPE,
      anon_sym_warn,
      sym_comment,
  [7872] = 10,
    ACTIONS(492), 1,
      ts_builtin_sym_end,
    ACTIONS(494), 1,
      anon_sym_LF,
    ACTIONS(497), 1,
      anon_sym_build,
    ACTIONS(500), 1,
      anon_sym_task,
    ACTIONS(503), 1,
      anon_sym_config,
    ACTIONS(506), 1,
      anon_sym_default,
    ACTIONS(509), 1,
      anon_sym_let,
    ACTIONS(512), 1,
      anon_sym_include,
    ACTIONS(515), 1,
      sym_comment,
    STATE(150), 8,
      sym__topLevelStatement,
      sym_buildBlock,
      sym_taskBlock,
      sym_config,
      sym_default,
      sym_let,
      sym_include,
      aux_sym_source_file_repeat1,
  [7910] = 2,
    ACTIONS(518), 1,
      anon_sym_LF,
    ACTIONS(520), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7932] = 2,
    ACTIONS(522), 1,
      anon_sym_LF,
    ACTIONS(524), 16,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [7954] = 10,
    ACTIONS(7), 1,
      anon_sym_build,
    ACTIONS(9), 1,
      anon_sym_task,
    ACTIONS(11), 1,
      anon_sym_config,
    ACTIONS(13), 1,
      anon_sym_default,
    ACTIONS(15), 1,
      anon_sym_let,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(526), 1,
      ts_builtin_sym_end,
    ACTIONS(528), 1,
      anon_sym_LF,
    ACTIONS(530), 1,
      sym_comment,
    STATE(150), 8,
      sym__topLevelStatement,
      sym_buildBlock,
      sym_taskBlock,
      sym_config,
      sym_default,
      sym_let,
      sym_include,
      aux_sym_source_file_repeat1,
  [7992] = 2,
    ACTIONS(532), 1,
      anon_sym_LF,
    ACTIONS(534), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8010] = 2,
    ACTIONS(536), 1,
      anon_sym_LF,
    ACTIONS(538), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8028] = 2,
    ACTIONS(540), 1,
      anon_sym_LF,
    ACTIONS(542), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8046] = 2,
    ACTIONS(544), 1,
      anon_sym_LF,
    ACTIONS(546), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8064] = 2,
    ACTIONS(548), 1,
      anon_sym_LF,
    ACTIONS(550), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8082] = 2,
    ACTIONS(552), 1,
      anon_sym_LF,
    ACTIONS(554), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8100] = 2,
    ACTIONS(556), 1,
      anon_sym_LF,
    ACTIONS(558), 12,
      anon_sym_build,
      anon_sym_RBRACE,
      anon_sym_run,
      anon_sym_depfile,
      anon_sym_env_DASHremove,
      anon_sym_from,
      anon_sym_info,
      anon_sym_let,
      anon_sym_env,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8118] = 2,
    ACTIONS(560), 1,
      anon_sym_LF,
    ACTIONS(562), 11,
      anon_sym_RBRACE,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_env_DASHremove,
      anon_sym_info,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8135] = 2,
    ACTIONS(564), 1,
      anon_sym_LF,
    ACTIONS(566), 11,
      anon_sym_RBRACE,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_env_DASHremove,
      anon_sym_info,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8152] = 2,
    ACTIONS(568), 1,
      anon_sym_LF,
    ACTIONS(570), 11,
      anon_sym_RBRACE,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_env_DASHremove,
      anon_sym_info,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8169] = 2,
    ACTIONS(572), 1,
      anon_sym_LF,
    ACTIONS(574), 11,
      anon_sym_RBRACE,
      anon_sym_copy,
      anon_sym_delete,
      anon_sym_env_DASHremove,
      anon_sym_info,
      anon_sym_env,
      anon_sym_shell,
      anon_sym_write,
      anon_sym_error,
      anon_sym_warn,
      sym_comment,
  [8186] = 3,
    ACTIONS(576), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(374), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8204] = 2,
    ACTIONS(382), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(384), 9,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_LBRACK,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8220] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(484), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(486), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8237] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(386), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(388), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8254] = 2,
    ACTIONS(488), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(490), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8269] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(404), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(406), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8286] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(408), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(410), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8303] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(436), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(438), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8320] = 2,
    ACTIONS(392), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(394), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8335] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(444), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(446), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8352] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(448), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(450), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8369] = 2,
    ACTIONS(396), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(398), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8384] = 2,
    ACTIONS(372), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(374), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8399] = 2,
    ACTIONS(400), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(402), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8414] = 2,
    ACTIONS(456), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(458), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8429] = 2,
    ACTIONS(460), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(462), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8444] = 2,
    ACTIONS(464), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(466), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8459] = 2,
    ACTIONS(378), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(380), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8474] = 2,
    ACTIONS(468), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(470), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8489] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(420), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(422), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8506] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(424), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(426), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8523] = 2,
    ACTIONS(428), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(430), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8538] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(412), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(414), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8555] = 2,
    ACTIONS(416), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(418), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8570] = 2,
    ACTIONS(452), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(454), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8585] = 2,
    ACTIONS(472), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(474), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8600] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(432), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(434), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8617] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(440), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(442), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8634] = 2,
    ACTIONS(476), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(478), 8,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      anon_sym_PIPE,
      sym_comment,
  [8649] = 3,
    ACTIONS(578), 1,
      anon_sym_PIPE,
    ACTIONS(480), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(482), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8666] = 2,
    ACTIONS(580), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(582), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8680] = 2,
    ACTIONS(584), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(586), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8694] = 2,
    ACTIONS(548), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(550), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8708] = 2,
    ACTIONS(588), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(590), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8722] = 2,
    ACTIONS(592), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(594), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8736] = 2,
    ACTIONS(596), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(598), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8750] = 2,
    ACTIONS(600), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(602), 7,
      anon_sym_build,
      anon_sym_task,
      anon_sym_config,
      anon_sym_default,
      anon_sym_let,
      anon_sym_include,
      sym_comment,
  [8764] = 2,
    ACTIONS(454), 1,
      anon_sym_EQ,
    ACTIONS(452), 7,
      anon_sym_LBRACE,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
  [8777] = 1,
    ACTIONS(382), 8,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [8788] = 2,
    ACTIONS(418), 1,
      anon_sym_EQ,
    ACTIONS(416), 7,
      anon_sym_LBRACE,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
  [8801] = 6,
    ACTIONS(604), 1,
      anon_sym_LF,
    ACTIONS(606), 1,
      anon_sym_RBRACE,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(610), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(211), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8821] = 6,
    ACTIONS(604), 1,
      anon_sym_LF,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(610), 1,
      sym_comment,
    ACTIONS(612), 1,
      anon_sym_RBRACE,
    STATE(409), 1,
      sym_string,
    STATE(211), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8841] = 6,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(614), 1,
      anon_sym_LF,
    ACTIONS(616), 1,
      anon_sym_RBRACE,
    ACTIONS(618), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(206), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8861] = 6,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      anon_sym_LF,
    ACTIONS(622), 1,
      anon_sym_RBRACE,
    ACTIONS(624), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(205), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8881] = 6,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(626), 1,
      anon_sym_LF,
    ACTIONS(628), 1,
      anon_sym_RBRACE,
    ACTIONS(630), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(210), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8901] = 6,
    ACTIONS(604), 1,
      anon_sym_LF,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(610), 1,
      sym_comment,
    ACTIONS(632), 1,
      anon_sym_RBRACE,
    STATE(409), 1,
      sym_string,
    STATE(211), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8921] = 6,
    ACTIONS(634), 1,
      anon_sym_LF,
    ACTIONS(637), 1,
      anon_sym_RBRACE,
    ACTIONS(639), 1,
      anon_sym_DQUOTE,
    ACTIONS(642), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(211), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8941] = 6,
    ACTIONS(604), 1,
      anon_sym_LF,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(610), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_RBRACE,
    STATE(409), 1,
      sym_string,
    STATE(211), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8961] = 6,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(647), 1,
      anon_sym_LF,
    ACTIONS(649), 1,
      anon_sym_RBRACE,
    ACTIONS(651), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(212), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [8981] = 6,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(653), 1,
      anon_sym_LF,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    ACTIONS(657), 1,
      sym_comment,
    STATE(409), 1,
      sym_string,
    STATE(215), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [9001] = 6,
    ACTIONS(604), 1,
      anon_sym_LF,
    ACTIONS(608), 1,
      anon_sym_DQUOTE,
    ACTIONS(610), 1,
      sym_comment,
    ACTIONS(659), 1,
      anon_sym_RBRACE,
    STATE(409), 1,
      sym_string,
    STATE(211), 2,
      sym_matchArm,
      aux_sym_match_repeat1,
  [9021] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      anon_sym_DQUOTE,
    ACTIONS(665), 1,
      aux_sym_string_token1,
    ACTIONS(667), 1,
      anon_sym_LT,
    STATE(218), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9038] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(669), 1,
      anon_sym_DQUOTE,
    ACTIONS(671), 1,
      aux_sym_string_token1,
    STATE(216), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9055] = 5,
    ACTIONS(673), 1,
      anon_sym_LBRACE,
    ACTIONS(676), 1,
      anon_sym_DQUOTE,
    ACTIONS(678), 1,
      aux_sym_string_token1,
    ACTIONS(681), 1,
      anon_sym_LT,
    STATE(218), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9072] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(665), 1,
      aux_sym_string_token1,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(684), 1,
      anon_sym_DQUOTE,
    STATE(218), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9089] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(686), 1,
      anon_sym_DQUOTE,
    ACTIONS(688), 1,
      aux_sym_string_token1,
    STATE(223), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9106] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(690), 1,
      anon_sym_DQUOTE,
    ACTIONS(692), 1,
      aux_sym_string_token1,
    STATE(219), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9123] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(694), 1,
      anon_sym_DQUOTE,
    ACTIONS(696), 1,
      aux_sym_string_token1,
    STATE(229), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9140] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(665), 1,
      aux_sym_string_token1,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(698), 1,
      anon_sym_DQUOTE,
    STATE(218), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9157] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(665), 1,
      aux_sym_string_token1,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    STATE(218), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9174] = 3,
    ACTIONS(372), 1,
      sym_interpolationJoin,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(374), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9187] = 2,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9198] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(706), 1,
      anon_sym_DQUOTE,
    ACTIONS(708), 1,
      aux_sym_string_token1,
    STATE(224), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9215] = 2,
    ACTIONS(382), 1,
      sym_interpolationJoin,
    ACTIONS(384), 5,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9226] = 5,
    ACTIONS(661), 1,
      anon_sym_LBRACE,
    ACTIONS(665), 1,
      aux_sym_string_token1,
    ACTIONS(667), 1,
      anon_sym_LT,
    ACTIONS(710), 1,
      anon_sym_DQUOTE,
    STATE(218), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [9243] = 1,
    ACTIONS(392), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9251] = 3,
    ACTIONS(412), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(414), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9263] = 2,
    ACTIONS(456), 1,
      sym_interpolationJoin,
    ACTIONS(458), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9273] = 2,
    ACTIONS(378), 1,
      sym_interpolationJoin,
    ACTIONS(380), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9283] = 2,
    ACTIONS(460), 1,
      sym_interpolationJoin,
    ACTIONS(462), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9293] = 1,
    ACTIONS(372), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9301] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(412), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9311] = 2,
    ACTIONS(464), 1,
      sym_interpolationJoin,
    ACTIONS(466), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9321] = 2,
    ACTIONS(468), 1,
      sym_interpolationJoin,
    ACTIONS(470), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9331] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(420), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9341] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(424), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9351] = 1,
    ACTIONS(428), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9359] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(432), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9369] = 4,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(718), 1,
      anon_sym_COLON,
    ACTIONS(720), 1,
      sym_interpolationJoin,
    ACTIONS(716), 2,
      anon_sym_RBRACE,
      anon_sym_GT,
  [9383] = 3,
    ACTIONS(420), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(422), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9395] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(440), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9405] = 3,
    ACTIONS(424), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(426), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9417] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(444), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9427] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(448), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9437] = 2,
    ACTIONS(428), 1,
      sym_interpolationJoin,
    ACTIONS(430), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9447] = 1,
    ACTIONS(456), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9455] = 1,
    ACTIONS(460), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9463] = 1,
    ACTIONS(464), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9471] = 1,
    ACTIONS(468), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9479] = 3,
    ACTIONS(432), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(434), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9491] = 3,
    ACTIONS(440), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(442), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9503] = 3,
    ACTIONS(444), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(446), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9515] = 2,
    ACTIONS(472), 1,
      sym_interpolationJoin,
    ACTIONS(474), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9525] = 2,
    ACTIONS(476), 1,
      sym_interpolationJoin,
    ACTIONS(478), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9535] = 2,
    ACTIONS(416), 1,
      sym_interpolationJoin,
    ACTIONS(418), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9545] = 3,
    ACTIONS(480), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(482), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9557] = 1,
    ACTIONS(476), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9565] = 3,
    ACTIONS(484), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(486), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9577] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(480), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9587] = 3,
    ACTIONS(386), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(388), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9599] = 2,
    ACTIONS(488), 1,
      sym_interpolationJoin,
    ACTIONS(490), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9609] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(484), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9619] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(386), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9629] = 3,
    ACTIONS(404), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(406), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9641] = 1,
    ACTIONS(488), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9649] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(404), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9659] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(408), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9669] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(436), 4,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9679] = 3,
    ACTIONS(408), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(410), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9691] = 1,
    ACTIONS(396), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9699] = 1,
    ACTIONS(400), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9707] = 1,
    ACTIONS(378), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9715] = 3,
    ACTIONS(436), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(438), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9727] = 2,
    ACTIONS(392), 1,
      sym_interpolationJoin,
    ACTIONS(394), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9737] = 2,
    ACTIONS(396), 1,
      sym_interpolationJoin,
    ACTIONS(398), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9747] = 2,
    ACTIONS(400), 1,
      sym_interpolationJoin,
    ACTIONS(402), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9757] = 3,
    ACTIONS(448), 1,
      sym_interpolationJoin,
    ACTIONS(712), 1,
      anon_sym_PIPE,
    ACTIONS(450), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_COLON,
  [9769] = 2,
    ACTIONS(452), 1,
      sym_interpolationJoin,
    ACTIONS(454), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9779] = 2,
    ACTIONS(372), 1,
      sym_interpolationJoin,
    ACTIONS(374), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_GT,
      anon_sym_COLON,
  [9789] = 1,
    ACTIONS(472), 5,
      anon_sym_to,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_COMMA,
  [9797] = 4,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(722), 1,
      anon_sym_RBRACK,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    STATE(298), 1,
      aux_sym_list_repeat1,
  [9810] = 2,
    ACTIONS(728), 1,
      aux_sym_string_token1,
    ACTIONS(726), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LT,
  [9819] = 4,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(730), 1,
      anon_sym_RBRACK,
    STATE(304), 1,
      aux_sym_list_repeat1,
  [9832] = 2,
    ACTIONS(734), 1,
      aux_sym_string_token1,
    ACTIONS(732), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      anon_sym_LT,
  [9841] = 4,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(736), 1,
      anon_sym_RBRACK,
    STATE(301), 1,
      aux_sym_list_repeat1,
  [9854] = 3,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(156), 2,
      sym_runBlock,
      sym_string,
  [9865] = 4,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(740), 1,
      anon_sym_RBRACK,
    STATE(313), 1,
      aux_sym_list_repeat1,
  [9878] = 4,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(742), 1,
      anon_sym_RBRACK,
    STATE(310), 1,
      aux_sym_list_repeat1,
  [9891] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(744), 2,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [9899] = 1,
    ACTIONS(746), 3,
      anon_sym_dedup,
      aux_sym__interpolationBody_token1,
      aux_sym__interpolationBody_token2,
  [9905] = 1,
    ACTIONS(748), 3,
      anon_sym_dedup,
      aux_sym__interpolationBody_token1,
      aux_sym__interpolationBody_token2,
  [9911] = 3,
    ACTIONS(722), 1,
      anon_sym_RBRACK,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9921] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(730), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9931] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(750), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9941] = 3,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(149), 1,
      sym_matchArm,
    STATE(409), 1,
      sym_string,
  [9951] = 2,
    ACTIONS(754), 1,
      anon_sym_COLON,
    ACTIONS(752), 2,
      anon_sym_RBRACE,
      anon_sym_GT,
  [9959] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(756), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9969] = 3,
    ACTIONS(744), 1,
      anon_sym_RBRACK,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9979] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(736), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9989] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(761), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [9999] = 2,
    ACTIONS(763), 1,
      anon_sym_LBRACK,
    ACTIONS(372), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10007] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(740), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [10017] = 1,
    ACTIONS(382), 3,
      sym__terminator,
      anon_sym_LBRACK,
      anon_sym_PIPE,
  [10023] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(742), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [10033] = 3,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(269), 1,
      sym_matchArm,
    STATE(407), 1,
      sym_string,
  [10043] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(765), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [10053] = 3,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(265), 1,
      sym_matchArm,
    STATE(410), 1,
      sym_string,
  [10063] = 3,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(169), 1,
      sym_matchArm,
    STATE(400), 1,
      sym_string,
  [10073] = 3,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(767), 1,
      anon_sym_RBRACK,
    STATE(302), 1,
      aux_sym_list_repeat1,
  [10083] = 3,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(370), 1,
      sym_matchArm,
    STATE(408), 1,
      sym_string,
  [10093] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(769), 1,
      anon_sym_RBRACK,
  [10100] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(771), 1,
      anon_sym_to,
  [10107] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(775), 1,
      sym__terminator,
  [10114] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(777), 1,
      sym__terminator,
  [10121] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(779), 1,
      sym__terminator,
  [10128] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(781), 1,
      sym__terminator,
  [10135] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(783), 1,
      anon_sym_to,
  [10142] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(785), 1,
      anon_sym_RBRACK,
  [10149] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(787), 1,
      sym__terminator,
  [10156] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(789), 1,
      sym__terminator,
  [10163] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(791), 1,
      sym__terminator,
  [10170] = 2,
    ACTIONS(793), 1,
      aux_sym_identifier_token1,
    STATE(390), 1,
      sym_identifier,
  [10177] = 2,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(335), 1,
      sym_string,
  [10184] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(795), 1,
      anon_sym_RPAREN,
  [10191] = 2,
    ACTIONS(793), 1,
      aux_sym_identifier_token1,
    STATE(358), 1,
      sym_identifier,
  [10198] = 2,
    ACTIONS(793), 1,
      aux_sym_identifier_token1,
    STATE(393), 1,
      sym_identifier,
  [10205] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(797), 1,
      anon_sym_RPAREN,
  [10212] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(799), 1,
      sym__terminator,
  [10219] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(801), 1,
      sym__terminator,
  [10226] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(803), 1,
      sym__terminator,
  [10233] = 2,
    ACTIONS(805), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym_recipe,
  [10240] = 2,
    ACTIONS(793), 1,
      aux_sym_identifier_token1,
    STATE(405), 1,
      sym_identifier,
  [10247] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(807), 1,
      anon_sym_RBRACK,
  [10254] = 1,
    ACTIONS(372), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10259] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(809), 1,
      sym__terminator,
  [10266] = 2,
    ACTIONS(412), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10273] = 1,
    ACTIONS(811), 2,
      anon_sym_RBRACE,
      anon_sym_GT,
  [10278] = 1,
    ACTIONS(416), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10283] = 2,
    ACTIONS(420), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10290] = 2,
    ACTIONS(424), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10297] = 1,
    ACTIONS(428), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10302] = 2,
    ACTIONS(432), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10309] = 2,
    ACTIONS(440), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10316] = 2,
    ACTIONS(444), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10323] = 2,
    ACTIONS(448), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10330] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(813), 1,
      anon_sym_RPAREN,
  [10337] = 1,
    ACTIONS(452), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10342] = 1,
    ACTIONS(456), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10347] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(815), 1,
      sym__terminator,
  [10354] = 1,
    ACTIONS(460), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10359] = 1,
    ACTIONS(464), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10364] = 1,
    ACTIONS(468), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10369] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(817), 1,
      anon_sym_RBRACK,
  [10376] = 2,
    ACTIONS(805), 1,
      anon_sym_LBRACE,
    STATE(199), 1,
      sym_recipe,
  [10383] = 2,
    ACTIONS(109), 1,
      anon_sym_DQUOTE,
    STATE(398), 1,
      sym_string,
  [10390] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(819), 1,
      sym__terminator,
  [10397] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(821), 1,
      anon_sym_RBRACK,
  [10404] = 2,
    ACTIONS(47), 1,
      anon_sym_DQUOTE,
    STATE(401), 1,
      sym_string,
  [10411] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(823), 1,
      anon_sym_RPAREN,
  [10418] = 1,
    ACTIONS(472), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10423] = 1,
    ACTIONS(476), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10428] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(825), 1,
      sym__terminator,
  [10435] = 2,
    ACTIONS(480), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10442] = 2,
    ACTIONS(484), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10449] = 2,
    ACTIONS(386), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10456] = 1,
    ACTIONS(488), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10461] = 2,
    ACTIONS(404), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10468] = 2,
    ACTIONS(408), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10475] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(827), 1,
      sym__terminator,
  [10482] = 2,
    ACTIONS(436), 1,
      sym__terminator,
    ACTIONS(773), 1,
      anon_sym_PIPE,
  [10489] = 1,
    ACTIONS(392), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10494] = 1,
    ACTIONS(396), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10499] = 1,
    ACTIONS(400), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10504] = 1,
    ACTIONS(378), 2,
      sym__terminator,
      anon_sym_PIPE,
  [10509] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(829), 1,
      sym__terminator,
  [10516] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(831), 1,
      sym__terminator,
  [10523] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(833), 1,
      sym__terminator,
  [10530] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(835), 1,
      sym__terminator,
  [10537] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(837), 1,
      sym__terminator,
  [10544] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(839), 1,
      sym__terminator,
  [10551] = 2,
    ACTIONS(773), 1,
      anon_sym_PIPE,
    ACTIONS(841), 1,
      sym__terminator,
  [10558] = 1,
    ACTIONS(843), 2,
      anon_sym_RBRACE,
      anon_sym_GT,
  [10563] = 2,
    ACTIONS(793), 1,
      aux_sym_identifier_token1,
    STATE(406), 1,
      sym_identifier,
  [10570] = 2,
    ACTIONS(714), 1,
      anon_sym_PIPE,
    ACTIONS(845), 1,
      anon_sym_RPAREN,
  [10577] = 1,
    ACTIONS(847), 1,
      anon_sym_LBRACE,
  [10581] = 1,
    ACTIONS(849), 1,
      anon_sym_EQ,
  [10585] = 1,
    ACTIONS(851), 1,
      sym__terminator,
  [10589] = 1,
    ACTIONS(853), 1,
      anon_sym_LBRACE,
  [10593] = 1,
    ACTIONS(855), 1,
      anon_sym_EQ,
  [10597] = 1,
    ACTIONS(857), 1,
      anon_sym_LBRACE,
  [10601] = 1,
    ACTIONS(859), 1,
      anon_sym_RBRACE,
  [10605] = 1,
    ACTIONS(859), 1,
      anon_sym_GT,
  [10609] = 1,
    ACTIONS(861), 1,
      sym__terminator,
  [10613] = 1,
    ACTIONS(863), 1,
      sym__terminator,
  [10617] = 1,
    ACTIONS(865), 1,
      anon_sym_LBRACE,
  [10621] = 1,
    ACTIONS(867), 1,
      anon_sym_EQ_GT,
  [10625] = 1,
    ACTIONS(869), 1,
      anon_sym_EQ,
  [10629] = 1,
    ACTIONS(871), 1,
      sym__terminator,
  [10633] = 1,
    ACTIONS(873), 1,
      sym__terminator,
  [10637] = 1,
    ACTIONS(875), 1,
      anon_sym_LBRACE,
  [10641] = 1,
    ACTIONS(877), 1,
      anon_sym_EQ,
  [10645] = 1,
    ACTIONS(879), 1,
      anon_sym_EQ,
  [10649] = 1,
    ACTIONS(881), 1,
      anon_sym_EQ_GT,
  [10653] = 1,
    ACTIONS(883), 1,
      anon_sym_EQ_GT,
  [10657] = 1,
    ACTIONS(885), 1,
      anon_sym_EQ_GT,
  [10661] = 1,
    ACTIONS(887), 1,
      anon_sym_EQ_GT,
  [10665] = 1,
    ACTIONS(889), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 70,
  [SMALL_STATE(4)] = 140,
  [SMALL_STATE(5)] = 210,
  [SMALL_STATE(6)] = 280,
  [SMALL_STATE(7)] = 350,
  [SMALL_STATE(8)] = 417,
  [SMALL_STATE(9)] = 484,
  [SMALL_STATE(10)] = 545,
  [SMALL_STATE(11)] = 606,
  [SMALL_STATE(12)] = 667,
  [SMALL_STATE(13)] = 728,
  [SMALL_STATE(14)] = 789,
  [SMALL_STATE(15)] = 850,
  [SMALL_STATE(16)] = 911,
  [SMALL_STATE(17)] = 972,
  [SMALL_STATE(18)] = 1033,
  [SMALL_STATE(19)] = 1094,
  [SMALL_STATE(20)] = 1155,
  [SMALL_STATE(21)] = 1216,
  [SMALL_STATE(22)] = 1277,
  [SMALL_STATE(23)] = 1338,
  [SMALL_STATE(24)] = 1399,
  [SMALL_STATE(25)] = 1460,
  [SMALL_STATE(26)] = 1521,
  [SMALL_STATE(27)] = 1582,
  [SMALL_STATE(28)] = 1643,
  [SMALL_STATE(29)] = 1704,
  [SMALL_STATE(30)] = 1765,
  [SMALL_STATE(31)] = 1826,
  [SMALL_STATE(32)] = 1887,
  [SMALL_STATE(33)] = 1948,
  [SMALL_STATE(34)] = 2009,
  [SMALL_STATE(35)] = 2070,
  [SMALL_STATE(36)] = 2131,
  [SMALL_STATE(37)] = 2192,
  [SMALL_STATE(38)] = 2253,
  [SMALL_STATE(39)] = 2314,
  [SMALL_STATE(40)] = 2375,
  [SMALL_STATE(41)] = 2436,
  [SMALL_STATE(42)] = 2497,
  [SMALL_STATE(43)] = 2558,
  [SMALL_STATE(44)] = 2619,
  [SMALL_STATE(45)] = 2680,
  [SMALL_STATE(46)] = 2741,
  [SMALL_STATE(47)] = 2802,
  [SMALL_STATE(48)] = 2863,
  [SMALL_STATE(49)] = 2924,
  [SMALL_STATE(50)] = 2985,
  [SMALL_STATE(51)] = 3046,
  [SMALL_STATE(52)] = 3107,
  [SMALL_STATE(53)] = 3168,
  [SMALL_STATE(54)] = 3229,
  [SMALL_STATE(55)] = 3290,
  [SMALL_STATE(56)] = 3351,
  [SMALL_STATE(57)] = 3412,
  [SMALL_STATE(58)] = 3473,
  [SMALL_STATE(59)] = 3534,
  [SMALL_STATE(60)] = 3595,
  [SMALL_STATE(61)] = 3656,
  [SMALL_STATE(62)] = 3717,
  [SMALL_STATE(63)] = 3778,
  [SMALL_STATE(64)] = 3839,
  [SMALL_STATE(65)] = 3900,
  [SMALL_STATE(66)] = 3961,
  [SMALL_STATE(67)] = 4022,
  [SMALL_STATE(68)] = 4083,
  [SMALL_STATE(69)] = 4144,
  [SMALL_STATE(70)] = 4205,
  [SMALL_STATE(71)] = 4266,
  [SMALL_STATE(72)] = 4327,
  [SMALL_STATE(73)] = 4388,
  [SMALL_STATE(74)] = 4449,
  [SMALL_STATE(75)] = 4510,
  [SMALL_STATE(76)] = 4571,
  [SMALL_STATE(77)] = 4632,
  [SMALL_STATE(78)] = 4693,
  [SMALL_STATE(79)] = 4754,
  [SMALL_STATE(80)] = 4815,
  [SMALL_STATE(81)] = 4876,
  [SMALL_STATE(82)] = 4937,
  [SMALL_STATE(83)] = 4998,
  [SMALL_STATE(84)] = 5059,
  [SMALL_STATE(85)] = 5120,
  [SMALL_STATE(86)] = 5181,
  [SMALL_STATE(87)] = 5242,
  [SMALL_STATE(88)] = 5303,
  [SMALL_STATE(89)] = 5364,
  [SMALL_STATE(90)] = 5425,
  [SMALL_STATE(91)] = 5486,
  [SMALL_STATE(92)] = 5547,
  [SMALL_STATE(93)] = 5608,
  [SMALL_STATE(94)] = 5669,
  [SMALL_STATE(95)] = 5730,
  [SMALL_STATE(96)] = 5791,
  [SMALL_STATE(97)] = 5852,
  [SMALL_STATE(98)] = 5913,
  [SMALL_STATE(99)] = 5974,
  [SMALL_STATE(100)] = 6035,
  [SMALL_STATE(101)] = 6096,
  [SMALL_STATE(102)] = 6157,
  [SMALL_STATE(103)] = 6218,
  [SMALL_STATE(104)] = 6279,
  [SMALL_STATE(105)] = 6340,
  [SMALL_STATE(106)] = 6401,
  [SMALL_STATE(107)] = 6462,
  [SMALL_STATE(108)] = 6523,
  [SMALL_STATE(109)] = 6584,
  [SMALL_STATE(110)] = 6635,
  [SMALL_STATE(111)] = 6686,
  [SMALL_STATE(112)] = 6737,
  [SMALL_STATE(113)] = 6788,
  [SMALL_STATE(114)] = 6839,
  [SMALL_STATE(115)] = 6893,
  [SMALL_STATE(116)] = 6947,
  [SMALL_STATE(117)] = 7001,
  [SMALL_STATE(118)] = 7051,
  [SMALL_STATE(119)] = 7101,
  [SMALL_STATE(120)] = 7151,
  [SMALL_STATE(121)] = 7177,
  [SMALL_STATE(122)] = 7201,
  [SMALL_STATE(123)] = 7225,
  [SMALL_STATE(124)] = 7250,
  [SMALL_STATE(125)] = 7273,
  [SMALL_STATE(126)] = 7296,
  [SMALL_STATE(127)] = 7319,
  [SMALL_STATE(128)] = 7344,
  [SMALL_STATE(129)] = 7369,
  [SMALL_STATE(130)] = 7392,
  [SMALL_STATE(131)] = 7417,
  [SMALL_STATE(132)] = 7440,
  [SMALL_STATE(133)] = 7465,
  [SMALL_STATE(134)] = 7490,
  [SMALL_STATE(135)] = 7513,
  [SMALL_STATE(136)] = 7538,
  [SMALL_STATE(137)] = 7563,
  [SMALL_STATE(138)] = 7588,
  [SMALL_STATE(139)] = 7613,
  [SMALL_STATE(140)] = 7638,
  [SMALL_STATE(141)] = 7661,
  [SMALL_STATE(142)] = 7684,
  [SMALL_STATE(143)] = 7707,
  [SMALL_STATE(144)] = 7730,
  [SMALL_STATE(145)] = 7753,
  [SMALL_STATE(146)] = 7776,
  [SMALL_STATE(147)] = 7799,
  [SMALL_STATE(148)] = 7824,
  [SMALL_STATE(149)] = 7849,
  [SMALL_STATE(150)] = 7872,
  [SMALL_STATE(151)] = 7910,
  [SMALL_STATE(152)] = 7932,
  [SMALL_STATE(153)] = 7954,
  [SMALL_STATE(154)] = 7992,
  [SMALL_STATE(155)] = 8010,
  [SMALL_STATE(156)] = 8028,
  [SMALL_STATE(157)] = 8046,
  [SMALL_STATE(158)] = 8064,
  [SMALL_STATE(159)] = 8082,
  [SMALL_STATE(160)] = 8100,
  [SMALL_STATE(161)] = 8118,
  [SMALL_STATE(162)] = 8135,
  [SMALL_STATE(163)] = 8152,
  [SMALL_STATE(164)] = 8169,
  [SMALL_STATE(165)] = 8186,
  [SMALL_STATE(166)] = 8204,
  [SMALL_STATE(167)] = 8220,
  [SMALL_STATE(168)] = 8237,
  [SMALL_STATE(169)] = 8254,
  [SMALL_STATE(170)] = 8269,
  [SMALL_STATE(171)] = 8286,
  [SMALL_STATE(172)] = 8303,
  [SMALL_STATE(173)] = 8320,
  [SMALL_STATE(174)] = 8335,
  [SMALL_STATE(175)] = 8352,
  [SMALL_STATE(176)] = 8369,
  [SMALL_STATE(177)] = 8384,
  [SMALL_STATE(178)] = 8399,
  [SMALL_STATE(179)] = 8414,
  [SMALL_STATE(180)] = 8429,
  [SMALL_STATE(181)] = 8444,
  [SMALL_STATE(182)] = 8459,
  [SMALL_STATE(183)] = 8474,
  [SMALL_STATE(184)] = 8489,
  [SMALL_STATE(185)] = 8506,
  [SMALL_STATE(186)] = 8523,
  [SMALL_STATE(187)] = 8538,
  [SMALL_STATE(188)] = 8555,
  [SMALL_STATE(189)] = 8570,
  [SMALL_STATE(190)] = 8585,
  [SMALL_STATE(191)] = 8600,
  [SMALL_STATE(192)] = 8617,
  [SMALL_STATE(193)] = 8634,
  [SMALL_STATE(194)] = 8649,
  [SMALL_STATE(195)] = 8666,
  [SMALL_STATE(196)] = 8680,
  [SMALL_STATE(197)] = 8694,
  [SMALL_STATE(198)] = 8708,
  [SMALL_STATE(199)] = 8722,
  [SMALL_STATE(200)] = 8736,
  [SMALL_STATE(201)] = 8750,
  [SMALL_STATE(202)] = 8764,
  [SMALL_STATE(203)] = 8777,
  [SMALL_STATE(204)] = 8788,
  [SMALL_STATE(205)] = 8801,
  [SMALL_STATE(206)] = 8821,
  [SMALL_STATE(207)] = 8841,
  [SMALL_STATE(208)] = 8861,
  [SMALL_STATE(209)] = 8881,
  [SMALL_STATE(210)] = 8901,
  [SMALL_STATE(211)] = 8921,
  [SMALL_STATE(212)] = 8941,
  [SMALL_STATE(213)] = 8961,
  [SMALL_STATE(214)] = 8981,
  [SMALL_STATE(215)] = 9001,
  [SMALL_STATE(216)] = 9021,
  [SMALL_STATE(217)] = 9038,
  [SMALL_STATE(218)] = 9055,
  [SMALL_STATE(219)] = 9072,
  [SMALL_STATE(220)] = 9089,
  [SMALL_STATE(221)] = 9106,
  [SMALL_STATE(222)] = 9123,
  [SMALL_STATE(223)] = 9140,
  [SMALL_STATE(224)] = 9157,
  [SMALL_STATE(225)] = 9174,
  [SMALL_STATE(226)] = 9187,
  [SMALL_STATE(227)] = 9198,
  [SMALL_STATE(228)] = 9215,
  [SMALL_STATE(229)] = 9226,
  [SMALL_STATE(230)] = 9243,
  [SMALL_STATE(231)] = 9251,
  [SMALL_STATE(232)] = 9263,
  [SMALL_STATE(233)] = 9273,
  [SMALL_STATE(234)] = 9283,
  [SMALL_STATE(235)] = 9293,
  [SMALL_STATE(236)] = 9301,
  [SMALL_STATE(237)] = 9311,
  [SMALL_STATE(238)] = 9321,
  [SMALL_STATE(239)] = 9331,
  [SMALL_STATE(240)] = 9341,
  [SMALL_STATE(241)] = 9351,
  [SMALL_STATE(242)] = 9359,
  [SMALL_STATE(243)] = 9369,
  [SMALL_STATE(244)] = 9383,
  [SMALL_STATE(245)] = 9395,
  [SMALL_STATE(246)] = 9405,
  [SMALL_STATE(247)] = 9417,
  [SMALL_STATE(248)] = 9427,
  [SMALL_STATE(249)] = 9437,
  [SMALL_STATE(250)] = 9447,
  [SMALL_STATE(251)] = 9455,
  [SMALL_STATE(252)] = 9463,
  [SMALL_STATE(253)] = 9471,
  [SMALL_STATE(254)] = 9479,
  [SMALL_STATE(255)] = 9491,
  [SMALL_STATE(256)] = 9503,
  [SMALL_STATE(257)] = 9515,
  [SMALL_STATE(258)] = 9525,
  [SMALL_STATE(259)] = 9535,
  [SMALL_STATE(260)] = 9545,
  [SMALL_STATE(261)] = 9557,
  [SMALL_STATE(262)] = 9565,
  [SMALL_STATE(263)] = 9577,
  [SMALL_STATE(264)] = 9587,
  [SMALL_STATE(265)] = 9599,
  [SMALL_STATE(266)] = 9609,
  [SMALL_STATE(267)] = 9619,
  [SMALL_STATE(268)] = 9629,
  [SMALL_STATE(269)] = 9641,
  [SMALL_STATE(270)] = 9649,
  [SMALL_STATE(271)] = 9659,
  [SMALL_STATE(272)] = 9669,
  [SMALL_STATE(273)] = 9679,
  [SMALL_STATE(274)] = 9691,
  [SMALL_STATE(275)] = 9699,
  [SMALL_STATE(276)] = 9707,
  [SMALL_STATE(277)] = 9715,
  [SMALL_STATE(278)] = 9727,
  [SMALL_STATE(279)] = 9737,
  [SMALL_STATE(280)] = 9747,
  [SMALL_STATE(281)] = 9757,
  [SMALL_STATE(282)] = 9769,
  [SMALL_STATE(283)] = 9779,
  [SMALL_STATE(284)] = 9789,
  [SMALL_STATE(285)] = 9797,
  [SMALL_STATE(286)] = 9810,
  [SMALL_STATE(287)] = 9819,
  [SMALL_STATE(288)] = 9832,
  [SMALL_STATE(289)] = 9841,
  [SMALL_STATE(290)] = 9854,
  [SMALL_STATE(291)] = 9865,
  [SMALL_STATE(292)] = 9878,
  [SMALL_STATE(293)] = 9891,
  [SMALL_STATE(294)] = 9899,
  [SMALL_STATE(295)] = 9905,
  [SMALL_STATE(296)] = 9911,
  [SMALL_STATE(297)] = 9921,
  [SMALL_STATE(298)] = 9931,
  [SMALL_STATE(299)] = 9941,
  [SMALL_STATE(300)] = 9951,
  [SMALL_STATE(301)] = 9959,
  [SMALL_STATE(302)] = 9969,
  [SMALL_STATE(303)] = 9979,
  [SMALL_STATE(304)] = 9989,
  [SMALL_STATE(305)] = 9999,
  [SMALL_STATE(306)] = 10007,
  [SMALL_STATE(307)] = 10017,
  [SMALL_STATE(308)] = 10023,
  [SMALL_STATE(309)] = 10033,
  [SMALL_STATE(310)] = 10043,
  [SMALL_STATE(311)] = 10053,
  [SMALL_STATE(312)] = 10063,
  [SMALL_STATE(313)] = 10073,
  [SMALL_STATE(314)] = 10083,
  [SMALL_STATE(315)] = 10093,
  [SMALL_STATE(316)] = 10100,
  [SMALL_STATE(317)] = 10107,
  [SMALL_STATE(318)] = 10114,
  [SMALL_STATE(319)] = 10121,
  [SMALL_STATE(320)] = 10128,
  [SMALL_STATE(321)] = 10135,
  [SMALL_STATE(322)] = 10142,
  [SMALL_STATE(323)] = 10149,
  [SMALL_STATE(324)] = 10156,
  [SMALL_STATE(325)] = 10163,
  [SMALL_STATE(326)] = 10170,
  [SMALL_STATE(327)] = 10177,
  [SMALL_STATE(328)] = 10184,
  [SMALL_STATE(329)] = 10191,
  [SMALL_STATE(330)] = 10198,
  [SMALL_STATE(331)] = 10205,
  [SMALL_STATE(332)] = 10212,
  [SMALL_STATE(333)] = 10219,
  [SMALL_STATE(334)] = 10226,
  [SMALL_STATE(335)] = 10233,
  [SMALL_STATE(336)] = 10240,
  [SMALL_STATE(337)] = 10247,
  [SMALL_STATE(338)] = 10254,
  [SMALL_STATE(339)] = 10259,
  [SMALL_STATE(340)] = 10266,
  [SMALL_STATE(341)] = 10273,
  [SMALL_STATE(342)] = 10278,
  [SMALL_STATE(343)] = 10283,
  [SMALL_STATE(344)] = 10290,
  [SMALL_STATE(345)] = 10297,
  [SMALL_STATE(346)] = 10302,
  [SMALL_STATE(347)] = 10309,
  [SMALL_STATE(348)] = 10316,
  [SMALL_STATE(349)] = 10323,
  [SMALL_STATE(350)] = 10330,
  [SMALL_STATE(351)] = 10337,
  [SMALL_STATE(352)] = 10342,
  [SMALL_STATE(353)] = 10347,
  [SMALL_STATE(354)] = 10354,
  [SMALL_STATE(355)] = 10359,
  [SMALL_STATE(356)] = 10364,
  [SMALL_STATE(357)] = 10369,
  [SMALL_STATE(358)] = 10376,
  [SMALL_STATE(359)] = 10383,
  [SMALL_STATE(360)] = 10390,
  [SMALL_STATE(361)] = 10397,
  [SMALL_STATE(362)] = 10404,
  [SMALL_STATE(363)] = 10411,
  [SMALL_STATE(364)] = 10418,
  [SMALL_STATE(365)] = 10423,
  [SMALL_STATE(366)] = 10428,
  [SMALL_STATE(367)] = 10435,
  [SMALL_STATE(368)] = 10442,
  [SMALL_STATE(369)] = 10449,
  [SMALL_STATE(370)] = 10456,
  [SMALL_STATE(371)] = 10461,
  [SMALL_STATE(372)] = 10468,
  [SMALL_STATE(373)] = 10475,
  [SMALL_STATE(374)] = 10482,
  [SMALL_STATE(375)] = 10489,
  [SMALL_STATE(376)] = 10494,
  [SMALL_STATE(377)] = 10499,
  [SMALL_STATE(378)] = 10504,
  [SMALL_STATE(379)] = 10509,
  [SMALL_STATE(380)] = 10516,
  [SMALL_STATE(381)] = 10523,
  [SMALL_STATE(382)] = 10530,
  [SMALL_STATE(383)] = 10537,
  [SMALL_STATE(384)] = 10544,
  [SMALL_STATE(385)] = 10551,
  [SMALL_STATE(386)] = 10558,
  [SMALL_STATE(387)] = 10563,
  [SMALL_STATE(388)] = 10570,
  [SMALL_STATE(389)] = 10577,
  [SMALL_STATE(390)] = 10581,
  [SMALL_STATE(391)] = 10585,
  [SMALL_STATE(392)] = 10589,
  [SMALL_STATE(393)] = 10593,
  [SMALL_STATE(394)] = 10597,
  [SMALL_STATE(395)] = 10601,
  [SMALL_STATE(396)] = 10605,
  [SMALL_STATE(397)] = 10609,
  [SMALL_STATE(398)] = 10613,
  [SMALL_STATE(399)] = 10617,
  [SMALL_STATE(400)] = 10621,
  [SMALL_STATE(401)] = 10625,
  [SMALL_STATE(402)] = 10629,
  [SMALL_STATE(403)] = 10633,
  [SMALL_STATE(404)] = 10637,
  [SMALL_STATE(405)] = 10641,
  [SMALL_STATE(406)] = 10645,
  [SMALL_STATE(407)] = 10649,
  [SMALL_STATE(408)] = 10653,
  [SMALL_STATE(409)] = 10657,
  [SMALL_STATE(410)] = 10661,
  [SMALL_STATE(411)] = 10665,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [139] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [273] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(115),
  [276] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(17),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0),
  [281] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(290),
  [284] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(18),
  [287] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(359),
  [290] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(19),
  [293] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(81),
  [296] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(387),
  [299] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [302] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(84),
  [305] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(86),
  [308] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(115),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(391),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [323] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [331] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(118),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0),
  [336] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(26),
  [339] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(27),
  [342] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(359),
  [345] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(81),
  [348] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(362),
  [351] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(28),
  [354] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(29),
  [357] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(84),
  [360] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(86),
  [363] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_runBlock_repeat1, 2, 0, 0), SHIFT_REPEAT(118),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exp, 1, 0, 0),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exp, 1, 0, 0),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_matchArm, 4, 0, 0),
  [380] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_matchArm, 4, 0, 0),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1, 0, 0),
  [384] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1, 0, 0),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter, 2, 0, 0),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter, 2, 0, 0),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access, 4, 0, 0),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_access, 4, 0, 0),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match, 3, 0, 0),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match, 3, 0, 0),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match, 4, 0, 0),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match, 4, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_join, 2, 0, 0),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_join, 2, 0, 0),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 2, 0, 0),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 2, 0, 0),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include, 2, 0, 0),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include, 2, 0, 0),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_info, 2, 0, 0),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_info, 2, 0, 0),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_getEnv, 2, 0, 0),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_getEnv, 2, 0, 0),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2, 0, 0),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2, 0, 0),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error, 2, 0, 0),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_error, 2, 0, 0),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_split, 2, 0, 0),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_split, 2, 0, 0),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_glob, 2, 0, 0),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_glob, 2, 0, 0),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_warn, 2, 0, 0),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_warn, 2, 0, 0),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_which, 2, 0, 0),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_which, 2, 0, 0),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exp, 3, 0, 0),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exp, 3, 0, 0),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 0),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, 0, 0),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read, 3, 0, 0),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read, 3, 0, 0),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op, 1, 0, 0),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op, 1, 0, 0),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pipe, 3, 0, 0),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pipe, 3, 0, 0),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assertEq, 2, 0, 0),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assertEq, 2, 0, 0),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_discard, 2, 0, 0),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_discard, 2, 0, 0),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filterMatch, 2, 0, 0),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filterMatch, 2, 0, 0),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [494] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(150),
  [497] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [500] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(329),
  [503] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(330),
  [506] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(336),
  [509] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(326),
  [512] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(83),
  [515] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(150),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_envRemove, 3, 0, 0),
  [520] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_envRemove, 3, 0, 0),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setEnv, 5, 0, 0),
  [524] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setEnv, 5, 0, 0),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runBlock, 4, 0, 0),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runBlock, 4, 0, 0),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_depfile, 3, 0, 0),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_depfile, 3, 0, 0),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_run, 2, 0, 0),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_run, 2, 0, 0),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_build, 3, 0, 0),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_build, 3, 0, 0),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 5, 0, 0),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 5, 0, 0),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_from, 3, 0, 0),
  [554] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_from, 3, 0, 0),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runBlock, 3, 0, 0),
  [558] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runBlock, 3, 0, 0),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell, 3, 0, 0),
  [562] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell, 3, 0, 0),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_delete, 3, 0, 0),
  [566] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_delete, 3, 0, 0),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_copy, 5, 0, 0),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_copy, 5, 0, 0),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_write, 5, 0, 0),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_write, 5, 0, 0),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default, 5, 0, 0),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_default, 5, 0, 0),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 3, 0, 0),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 3, 0, 0),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 4, 0, 0),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 4, 0, 0),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_taskBlock, 3, 0, 1),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_taskBlock, 3, 0, 1),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_buildBlock, 3, 0, 1),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_buildBlock, 3, 0, 1),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_config, 5, 0, 0),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_config, 5, 0, 0),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [608] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [616] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [618] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [622] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [624] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [628] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [630] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [632] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [634] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_match_repeat1, 2, 0, 0), SHIFT_REPEAT(211),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_match_repeat1, 2, 0, 0),
  [639] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_match_repeat1, 2, 0, 0), SHIFT_REPEAT(221),
  [642] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_match_repeat1, 2, 0, 0), SHIFT_REPEAT(211),
  [645] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [649] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [651] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [657] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [663] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [667] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [673] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(7),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [678] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(218),
  [681] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(8),
  [684] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [686] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [706] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [710] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [712] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__interpolationBody, 1, 0, 0),
  [718] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [726] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 2, 0, 0),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 2, 0, 0),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [732] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3, 0, 0),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3, 0, 0),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__interpolationBody, 2, 0, 0),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [758] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(15),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__interpolationBody, 3, 0, 0),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__interpolationBody, 4, 0, 0),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [889] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__terminator = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__terminator] = sym__terminator,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__terminator] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_werk_external_scanner_create(void);
void tree_sitter_werk_external_scanner_destroy(void *);
bool tree_sitter_werk_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_werk_external_scanner_serialize(void *, char *);
void tree_sitter_werk_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_werk(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_werk_external_scanner_create,
      tree_sitter_werk_external_scanner_destroy,
      tree_sitter_werk_external_scanner_scan,
      tree_sitter_werk_external_scanner_serialize,
      tree_sitter_werk_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
