#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5895
#define LARGE_STATE_COUNT 1193
#define SYMBOL_COUNT 382
#define ALIAS_COUNT 7
#define TOKEN_COUNT 169
#define EXTERNAL_TOKEN_COUNT 11
#define FIELD_COUNT 43
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 344

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_with = 16,
  anon_sym_assert = 17,
  anon_sym_var = 18,
  anon_sym_let = 19,
  anon_sym_const = 20,
  anon_sym_BANG = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_switch = 24,
  anon_sym_for = 25,
  anon_sym_LPAREN = 26,
  anon_sym_SEMI = 27,
  anon_sym_RPAREN = 28,
  anon_sym_await = 29,
  anon_sym_in = 30,
  anon_sym_of = 31,
  anon_sym_while = 32,
  anon_sym_do = 33,
  anon_sym_try = 34,
  anon_sym_break = 35,
  anon_sym_continue = 36,
  anon_sym_debugger = 37,
  anon_sym_return = 38,
  anon_sym_throw = 39,
  anon_sym_COLON = 40,
  anon_sym_case = 41,
  anon_sym_catch = 42,
  anon_sym_finally = 43,
  anon_sym_yield = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  anon_sym_LT = 47,
  anon_sym_GT = 48,
  anon_sym_LT_SLASH = 49,
  anon_sym_DOT = 50,
  anon_sym_class = 51,
  anon_sym_async = 52,
  anon_sym_function = 53,
  anon_sym_EQ_GT = 54,
  anon_sym_QMARK_DOT = 55,
  anon_sym_new = 56,
  anon_sym_using = 57,
  anon_sym_PLUS_EQ = 58,
  anon_sym_DASH_EQ = 59,
  anon_sym_STAR_EQ = 60,
  anon_sym_SLASH_EQ = 61,
  anon_sym_PERCENT_EQ = 62,
  anon_sym_CARET_EQ = 63,
  anon_sym_AMP_EQ = 64,
  anon_sym_PIPE_EQ = 65,
  anon_sym_GT_GT_EQ = 66,
  anon_sym_GT_GT_GT_EQ = 67,
  anon_sym_LT_LT_EQ = 68,
  anon_sym_STAR_STAR_EQ = 69,
  anon_sym_AMP_AMP_EQ = 70,
  anon_sym_PIPE_PIPE_EQ = 71,
  anon_sym_QMARK_QMARK_EQ = 72,
  anon_sym_DOT_DOT_DOT = 73,
  anon_sym_AMP_AMP = 74,
  anon_sym_PIPE_PIPE = 75,
  anon_sym_GT_GT = 76,
  anon_sym_GT_GT_GT = 77,
  anon_sym_LT_LT = 78,
  anon_sym_AMP = 79,
  anon_sym_CARET = 80,
  anon_sym_PIPE = 81,
  anon_sym_PLUS = 82,
  anon_sym_DASH = 83,
  anon_sym_SLASH = 84,
  anon_sym_PERCENT = 85,
  anon_sym_STAR_STAR = 86,
  anon_sym_LT_EQ = 87,
  anon_sym_EQ_EQ = 88,
  anon_sym_EQ_EQ_EQ = 89,
  anon_sym_BANG_EQ = 90,
  anon_sym_BANG_EQ_EQ = 91,
  anon_sym_GT_EQ = 92,
  anon_sym_QMARK_QMARK = 93,
  anon_sym_instanceof = 94,
  anon_sym_TILDE = 95,
  anon_sym_void = 96,
  anon_sym_delete = 97,
  anon_sym_PLUS_PLUS = 98,
  anon_sym_DASH_DASH = 99,
  anon_sym_DQUOTE = 100,
  anon_sym_SQUOTE = 101,
  sym_unescaped_double_string_fragment = 102,
  sym_unescaped_single_string_fragment = 103,
  sym_escape_sequence = 104,
  sym_comment = 105,
  anon_sym_BQUOTE = 106,
  anon_sym_DOLLAR_LBRACE = 107,
  anon_sym_SLASH2 = 108,
  sym_regex_pattern = 109,
  sym_regex_flags = 110,
  sym_number = 111,
  sym_private_property_identifier = 112,
  anon_sym_target = 113,
  anon_sym_meta = 114,
  sym_this = 115,
  sym_super = 116,
  sym_true = 117,
  sym_false = 118,
  sym_null = 119,
  sym_undefined = 120,
  anon_sym_AT = 121,
  anon_sym_static = 122,
  anon_sym_readonly = 123,
  anon_sym_get = 124,
  anon_sym_set = 125,
  anon_sym_QMARK = 126,
  anon_sym_declare = 127,
  anon_sym_public = 128,
  anon_sym_private = 129,
  anon_sym_protected = 130,
  anon_sym_override = 131,
  anon_sym_module = 132,
  anon_sym_any = 133,
  anon_sym_number = 134,
  anon_sym_boolean = 135,
  anon_sym_string = 136,
  anon_sym_symbol = 137,
  anon_sym_object = 138,
  anon_sym_abstract = 139,
  anon_sym_accessor = 140,
  anon_sym_satisfies = 141,
  anon_sym_require = 142,
  anon_sym_extends = 143,
  anon_sym_implements = 144,
  anon_sym_global = 145,
  anon_sym_interface = 146,
  anon_sym_enum = 147,
  anon_sym_DASH_QMARK_COLON = 148,
  anon_sym_PLUS_QMARK_COLON = 149,
  anon_sym_QMARK_COLON = 150,
  anon_sym_asserts = 151,
  anon_sym_infer = 152,
  anon_sym_is = 153,
  anon_sym_keyof = 154,
  anon_sym_unique = 155,
  anon_sym_unknown = 156,
  anon_sym_never = 157,
  anon_sym_LBRACE_PIPE = 158,
  anon_sym_PIPE_RBRACE = 159,
  sym_glimmer_template_tag_name = 160,
  sym__automatic_semicolon = 161,
  sym__template_chars = 162,
  sym__ternary_qmark = 163,
  sym_html_comment = 164,
  sym_jsx_text = 165,
  sym__function_signature_automatic_semicolon = 166,
  sym___error_recovery = 167,
  sym_raw_text = 168,
  sym_program = 169,
  sym_export_statement = 170,
  sym_namespace_export = 171,
  sym_export_clause = 172,
  sym_export_specifier = 173,
  sym__module_export_name = 174,
  sym_declaration = 175,
  sym_import = 176,
  sym_import_statement = 177,
  sym_import_clause = 178,
  sym__from_clause = 179,
  sym_namespace_import = 180,
  sym_named_imports = 181,
  sym_import_specifier = 182,
  sym_import_attribute = 183,
  sym_statement = 184,
  sym_expression_statement = 185,
  sym_variable_declaration = 186,
  sym_lexical_declaration = 187,
  sym_variable_declarator = 188,
  sym_statement_block = 189,
  sym_else_clause = 190,
  sym_if_statement = 191,
  sym_switch_statement = 192,
  sym_for_statement = 193,
  sym_for_in_statement = 194,
  sym__for_header = 195,
  sym_while_statement = 196,
  sym_do_statement = 197,
  sym_try_statement = 198,
  sym_with_statement = 199,
  sym_break_statement = 200,
  sym_continue_statement = 201,
  sym_debugger_statement = 202,
  sym_return_statement = 203,
  sym_throw_statement = 204,
  sym_empty_statement = 205,
  sym_labeled_statement = 206,
  sym_switch_body = 207,
  sym_switch_case = 208,
  sym_switch_default = 209,
  sym_catch_clause = 210,
  sym_finally_clause = 211,
  sym_parenthesized_expression = 212,
  sym_expression = 213,
  sym_primary_expression = 214,
  sym_yield_expression = 215,
  sym_object = 216,
  sym_object_pattern = 217,
  sym_assignment_pattern = 218,
  sym_object_assignment_pattern = 219,
  sym_array = 220,
  sym_array_pattern = 221,
  sym_glimmer_template = 222,
  sym_glimmer_opening_tag = 223,
  sym_glimmer_closing_tag = 224,
  sym_nested_identifier = 225,
  sym_class = 226,
  sym_class_declaration = 227,
  sym_class_heritage = 228,
  sym_function_expression = 229,
  sym_function_declaration = 230,
  sym_generator_function = 231,
  sym_generator_function_declaration = 232,
  sym_arrow_function = 233,
  sym__call_signature = 234,
  sym__formal_parameter = 235,
  sym_optional_chain = 236,
  sym_call_expression = 237,
  sym_new_expression = 238,
  sym_await_expression = 239,
  sym_member_expression = 240,
  sym_subscript_expression = 241,
  sym_assignment_expression = 242,
  sym__augmented_assignment_lhs = 243,
  sym_augmented_assignment_expression = 244,
  sym__initializer = 245,
  sym__destructuring_pattern = 246,
  sym_spread_element = 247,
  sym_ternary_expression = 248,
  sym_binary_expression = 249,
  sym_unary_expression = 250,
  sym_update_expression = 251,
  sym_sequence_expression = 252,
  sym_string = 253,
  sym_template_string = 254,
  sym_template_substitution = 255,
  sym_regex = 256,
  sym_meta_property = 257,
  sym_arguments = 258,
  sym_decorator = 259,
  sym_decorator_member_expression = 260,
  sym_decorator_call_expression = 261,
  sym_class_body = 262,
  sym_formal_parameters = 263,
  sym_class_static_block = 264,
  sym_pattern = 265,
  sym_rest_pattern = 266,
  sym_method_definition = 267,
  sym_pair = 268,
  sym_pair_pattern = 269,
  sym__property_name = 270,
  sym_computed_property_name = 271,
  sym_public_field_definition = 272,
  sym__import_identifier = 273,
  sym_non_null_expression = 274,
  sym_method_signature = 275,
  sym_abstract_method_signature = 276,
  sym_function_signature = 277,
  sym_decorator_parenthesized_expression = 278,
  sym_type_assertion = 279,
  sym_as_expression = 280,
  sym_satisfies_expression = 281,
  sym_instantiation_expression = 282,
  sym_import_require_clause = 283,
  sym_extends_clause = 284,
  sym__extends_clause_single = 285,
  sym_implements_clause = 286,
  sym_ambient_declaration = 287,
  sym_abstract_class_declaration = 288,
  sym_module = 289,
  sym_internal_module = 290,
  sym__module = 291,
  sym_import_alias = 292,
  sym_nested_type_identifier = 293,
  sym_interface_declaration = 294,
  sym_extends_type_clause = 295,
  sym_enum_declaration = 296,
  sym_enum_body = 297,
  sym_enum_assignment = 298,
  sym_type_alias_declaration = 299,
  sym_accessibility_modifier = 300,
  sym_override_modifier = 301,
  sym_required_parameter = 302,
  sym_optional_parameter = 303,
  sym__parameter_name = 304,
  sym_omitting_type_annotation = 305,
  sym_adding_type_annotation = 306,
  sym_opting_type_annotation = 307,
  sym_type_annotation = 308,
  sym__type_query_member_expression_in_type_annotation = 309,
  sym__type_query_call_expression_in_type_annotation = 310,
  sym_asserts = 311,
  sym_asserts_annotation = 312,
  sym_type = 313,
  sym_tuple_parameter = 314,
  sym_optional_tuple_parameter = 315,
  sym_optional_type = 316,
  sym_rest_type = 317,
  sym__tuple_type_member = 318,
  sym_constructor_type = 319,
  sym_primary_type = 320,
  sym_template_type = 321,
  sym_template_literal_type = 322,
  sym_infer_type = 323,
  sym_conditional_type = 324,
  sym_generic_type = 325,
  sym_type_predicate = 326,
  sym_type_predicate_annotation = 327,
  sym__type_query_member_expression = 328,
  sym__type_query_subscript_expression = 329,
  sym__type_query_call_expression = 330,
  sym__type_query_instantiation_expression = 331,
  sym_type_query = 332,
  sym_index_type_query = 333,
  sym_lookup_type = 334,
  sym_mapped_type_clause = 335,
  sym_literal_type = 336,
  sym__number = 337,
  sym_existential_type = 338,
  sym_flow_maybe_type = 339,
  sym_parenthesized_type = 340,
  sym_predefined_type = 341,
  sym_type_arguments = 342,
  sym_object_type = 343,
  sym_call_signature = 344,
  sym_property_signature = 345,
  sym_type_parameters = 346,
  sym_type_parameter = 347,
  sym_default_type = 348,
  sym_constraint = 349,
  sym_construct_signature = 350,
  sym_index_signature = 351,
  sym_array_type = 352,
  sym_tuple_type = 353,
  sym_readonly_type = 354,
  sym_union_type = 355,
  sym_intersection_type = 356,
  sym_function_type = 357,
  aux_sym_program_repeat1 = 358,
  aux_sym_export_statement_repeat1 = 359,
  aux_sym_export_clause_repeat1 = 360,
  aux_sym_named_imports_repeat1 = 361,
  aux_sym_variable_declaration_repeat1 = 362,
  aux_sym_switch_body_repeat1 = 363,
  aux_sym_object_repeat1 = 364,
  aux_sym_object_pattern_repeat1 = 365,
  aux_sym_array_repeat1 = 366,
  aux_sym_array_pattern_repeat1 = 367,
  aux_sym_sequence_expression_repeat1 = 368,
  aux_sym_string_repeat1 = 369,
  aux_sym_string_repeat2 = 370,
  aux_sym_template_string_repeat1 = 371,
  aux_sym_class_body_repeat1 = 372,
  aux_sym_formal_parameters_repeat1 = 373,
  aux_sym_extends_clause_repeat1 = 374,
  aux_sym_implements_clause_repeat1 = 375,
  aux_sym_extends_type_clause_repeat1 = 376,
  aux_sym_enum_body_repeat1 = 377,
  aux_sym_template_literal_type_repeat1 = 378,
  aux_sym_object_type_repeat1 = 379,
  aux_sym_type_parameters_repeat1 = 380,
  aux_sym_tuple_type_repeat1 = 381,
  alias_sym_interface_body = 382,
  alias_sym_property_identifier = 383,
  alias_sym_shorthand_property_identifier = 384,
  alias_sym_shorthand_property_identifier_pattern = 385,
  alias_sym_statement_identifier = 386,
  alias_sym_this_type = 387,
  alias_sym_type_identifier = 388,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_assert] = "assert",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_using] = "using",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_object] = "object",
  [anon_sym_abstract] = "abstract",
  [anon_sym_accessor] = "accessor",
  [anon_sym_satisfies] = "satisfies",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_PLUS_QMARK_COLON] = "+\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unique] = "unique symbol",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym_glimmer_template_tag_name] = "glimmer_template_tag_name",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym___error_recovery] = "__error_recovery",
  [sym_raw_text] = "raw_text",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym__import_identifier] = "_import_identifier",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_decorator_parenthesized_expression] = "parenthesized_expression",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_satisfies_expression] = "satisfies_expression",
  [sym_instantiation_expression] = "instantiation_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym__extends_clause_single] = "_extends_clause_single",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_adding_type_annotation] = "adding_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym__type_query_member_expression_in_type_annotation] = "member_expression",
  [sym__type_query_call_expression_in_type_annotation] = "call_expression",
  [sym_asserts] = "asserts",
  [sym_asserts_annotation] = "asserts_annotation",
  [sym_type] = "type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym_primary_type] = "primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym__type_query_instantiation_expression] = "instantiation_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_accessor] = anon_sym_accessor,
  [anon_sym_satisfies] = anon_sym_satisfies,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_PLUS_QMARK_COLON] = anon_sym_PLUS_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym_glimmer_template_tag_name] = sym_glimmer_template_tag_name,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym___error_recovery] = sym___error_recovery,
  [sym_raw_text] = sym_raw_text,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym__import_identifier] = sym__import_identifier,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_decorator_parenthesized_expression] = sym_parenthesized_expression,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_satisfies_expression] = sym_satisfies_expression,
  [sym_instantiation_expression] = sym_instantiation_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym__extends_clause_single] = sym__extends_clause_single,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_adding_type_annotation] = sym_adding_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type_query_member_expression_in_type_annotation] = sym_member_expression,
  [sym__type_query_call_expression_in_type_annotation] = sym_call_expression,
  [sym_asserts] = sym_asserts,
  [sym_asserts_annotation] = sym_asserts_annotation,
  [sym_type] = sym_type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym_primary_type] = sym_primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym__type_query_instantiation_expression] = sym_instantiation_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accessor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_satisfies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_glimmer_template_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__import_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_satisfies_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__extends_clause_single] = {
    .visible = false,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_adding_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_close_tag = 6,
  field_condition = 7,
  field_consequence = 8,
  field_constraint = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_index_type = 19,
  field_initializer = 20,
  field_key = 21,
  field_kind = 22,
  field_label = 23,
  field_left = 24,
  field_module = 25,
  field_name = 26,
  field_object = 27,
  field_open_tag = 28,
  field_operator = 29,
  field_optional_chain = 30,
  field_parameter = 31,
  field_parameters = 32,
  field_pattern = 33,
  field_property = 34,
  field_return_type = 35,
  field_right = 36,
  field_sign = 37,
  field_source = 38,
  field_template = 39,
  field_type = 40,
  field_type_arguments = 41,
  field_type_parameters = 42,
  field_value = 43,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_template] = "template",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 1},
  [13] = {.index = 3, .length = 1},
  [15] = {.index = 12, .length = 2},
  [16] = {.index = 14, .length = 2},
  [17] = {.index = 16, .length = 2},
  [18] = {.index = 18, .length = 1},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 2},
  [23] = {.index = 26, .length = 2},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 32, .length = 1},
  [27] = {.index = 33, .length = 2},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 2},
  [34] = {.index = 41, .length = 1},
  [35] = {.index = 42, .length = 2},
  [36] = {.index = 44, .length = 2},
  [37] = {.index = 46, .length = 2},
  [38] = {.index = 48, .length = 1},
  [39] = {.index = 49, .length = 2},
  [40] = {.index = 51, .length = 2},
  [41] = {.index = 53, .length = 6},
  [42] = {.index = 59, .length = 1},
  [43] = {.index = 60, .length = 3},
  [44] = {.index = 63, .length = 3},
  [45] = {.index = 66, .length = 2},
  [46] = {.index = 68, .length = 2},
  [47] = {.index = 70, .length = 2},
  [48] = {.index = 72, .length = 2},
  [49] = {.index = 74, .length = 1},
  [50] = {.index = 75, .length = 3},
  [51] = {.index = 78, .length = 2},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 2},
  [54] = {.index = 84, .length = 2},
  [55] = {.index = 86, .length = 1},
  [56] = {.index = 87, .length = 2},
  [57] = {.index = 89, .length = 2},
  [58] = {.index = 91, .length = 2},
  [61] = {.index = 87, .length = 2},
  [62] = {.index = 93, .length = 4},
  [63] = {.index = 97, .length = 1},
  [64] = {.index = 98, .length = 2},
  [65] = {.index = 100, .length = 1},
  [66] = {.index = 101, .length = 2},
  [67] = {.index = 103, .length = 1},
  [68] = {.index = 104, .length = 2},
  [69] = {.index = 106, .length = 4},
  [70] = {.index = 110, .length = 2},
  [71] = {.index = 112, .length = 2},
  [72] = {.index = 33, .length = 2},
  [73] = {.index = 37, .length = 2},
  [74] = {.index = 114, .length = 3},
  [75] = {.index = 98, .length = 2},
  [76] = {.index = 98, .length = 2},
  [77] = {.index = 117, .length = 2},
  [78] = {.index = 117, .length = 2},
  [79] = {.index = 119, .length = 3},
  [80] = {.index = 119, .length = 3},
  [81] = {.index = 122, .length = 3},
  [82] = {.index = 125, .length = 2},
  [83] = {.index = 127, .length = 2},
  [84] = {.index = 129, .length = 4},
  [85] = {.index = 133, .length = 3},
  [86] = {.index = 136, .length = 2},
  [87] = {.index = 138, .length = 2},
  [88] = {.index = 140, .length = 1},
  [89] = {.index = 141, .length = 1},
  [90] = {.index = 86, .length = 1},
  [91] = {.index = 117, .length = 2},
  [92] = {.index = 33, .length = 2},
  [93] = {.index = 142, .length = 2},
  [94] = {.index = 144, .length = 5},
  [95] = {.index = 149, .length = 1},
  [96] = {.index = 150, .length = 1},
  [97] = {.index = 151, .length = 2},
  [98] = {.index = 153, .length = 3},
  [99] = {.index = 156, .length = 2},
  [100] = {.index = 158, .length = 3},
  [101] = {.index = 161, .length = 6},
  [102] = {.index = 167, .length = 1},
  [103] = {.index = 168, .length = 1},
  [104] = {.index = 169, .length = 3},
  [105] = {.index = 172, .length = 3},
  [106] = {.index = 175, .length = 4},
  [107] = {.index = 179, .length = 2},
  [108] = {.index = 181, .length = 2},
  [109] = {.index = 183, .length = 3},
  [110] = {.index = 186, .length = 1},
  [111] = {.index = 187, .length = 4},
  [112] = {.index = 191, .length = 2},
  [113] = {.index = 193, .length = 4},
  [114] = {.index = 197, .length = 4},
  [115] = {.index = 201, .length = 4},
  [116] = {.index = 205, .length = 2},
  [117] = {.index = 207, .length = 2},
  [118] = {.index = 209, .length = 2},
  [119] = {.index = 211, .length = 3},
  [120] = {.index = 214, .length = 2},
  [121] = {.index = 216, .length = 4},
  [122] = {.index = 216, .length = 4},
  [123] = {.index = 220, .length = 4},
  [124] = {.index = 220, .length = 4},
  [125] = {.index = 224, .length = 1},
  [126] = {.index = 225, .length = 2},
  [127] = {.index = 227, .length = 2},
  [128] = {.index = 229, .length = 4},
  [129] = {.index = 233, .length = 2},
  [130] = {.index = 235, .length = 3},
  [131] = {.index = 238, .length = 2},
  [132] = {.index = 240, .length = 4},
  [133] = {.index = 244, .length = 2},
  [134] = {.index = 246, .length = 2},
  [135] = {.index = 248, .length = 4},
  [136] = {.index = 246, .length = 2},
  [137] = {.index = 252, .length = 4},
  [138] = {.index = 256, .length = 4},
  [139] = {.index = 260, .length = 5},
  [140] = {.index = 265, .length = 3},
  [141] = {.index = 268, .length = 2},
  [142] = {.index = 268, .length = 2},
  [143] = {.index = 270, .length = 2},
  [144] = {.index = 156, .length = 2},
  [145] = {.index = 272, .length = 1},
  [146] = {.index = 272, .length = 1},
  [147] = {.index = 233, .length = 2},
  [148] = {.index = 235, .length = 3},
  [149] = {.index = 273, .length = 2},
  [150] = {.index = 275, .length = 3},
  [151] = {.index = 278, .length = 2},
  [152] = {.index = 280, .length = 3},
  [153] = {.index = 283, .length = 2},
  [154] = {.index = 285, .length = 3},
  [155] = {.index = 288, .length = 1},
  [156] = {.index = 289, .length = 2},
  [157] = {.index = 291, .length = 2},
  [158] = {.index = 293, .length = 5},
  [159] = {.index = 289, .length = 2},
  [160] = {.index = 298, .length = 1},
  [161] = {.index = 299, .length = 4},
  [162] = {.index = 303, .length = 2},
  [163] = {.index = 305, .length = 2},
  [164] = {.index = 307, .length = 2},
  [165] = {.index = 309, .length = 1},
  [166] = {.index = 310, .length = 2},
  [167] = {.index = 312, .length = 1},
  [168] = {.index = 313, .length = 4},
  [169] = {.index = 317, .length = 4},
  [170] = {.index = 317, .length = 4},
  [171] = {.index = 321, .length = 3},
  [172] = {.index = 324, .length = 2},
  [173] = {.index = 326, .length = 3},
  [174] = {.index = 329, .length = 2},
  [175] = {.index = 331, .length = 2},
  [176] = {.index = 333, .length = 2},
  [177] = {.index = 335, .length = 3},
  [178] = {.index = 338, .length = 3},
  [179] = {.index = 341, .length = 3},
  [180] = {.index = 344, .length = 4},
  [181] = {.index = 348, .length = 4},
  [182] = {.index = 352, .length = 4},
  [183] = {.index = 356, .length = 5},
  [184] = {.index = 361, .length = 2},
  [185] = {.index = 363, .length = 3},
  [186] = {.index = 366, .length = 2},
  [187] = {.index = 366, .length = 2},
  [188] = {.index = 341, .length = 3},
  [189] = {.index = 368, .length = 3},
  [190] = {.index = 371, .length = 3},
  [191] = {.index = 151, .length = 2},
  [192] = {.index = 374, .length = 2},
  [193] = {.index = 376, .length = 3},
  [194] = {.index = 379, .length = 4},
  [195] = {.index = 383, .length = 3},
  [196] = {.index = 386, .length = 3},
  [197] = {.index = 389, .length = 2},
  [198] = {.index = 391, .length = 3},
  [199] = {.index = 394, .length = 5},
  [200] = {.index = 389, .length = 2},
  [201] = {.index = 399, .length = 3},
  [202] = {.index = 399, .length = 3},
  [203] = {.index = 402, .length = 3},
  [204] = {.index = 405, .length = 2},
  [205] = {.index = 407, .length = 4},
  [206] = {.index = 151, .length = 2},
  [207] = {.index = 411, .length = 1},
  [208] = {.index = 412, .length = 3},
  [209] = {.index = 415, .length = 2},
  [210] = {.index = 417, .length = 2},
  [211] = {.index = 419, .length = 1},
  [212] = {.index = 420, .length = 2},
  [213] = {.index = 422, .length = 2},
  [214] = {.index = 424, .length = 4},
  [215] = {.index = 428, .length = 4},
  [216] = {.index = 432, .length = 4},
  [217] = {.index = 436, .length = 3},
  [218] = {.index = 439, .length = 2},
  [219] = {.index = 441, .length = 2},
  [220] = {.index = 443, .length = 2},
  [221] = {.index = 445, .length = 3},
  [222] = {.index = 448, .length = 3},
  [223] = {.index = 451, .length = 2},
  [224] = {.index = 453, .length = 3},
  [225] = {.index = 456, .length = 3},
  [226] = {.index = 459, .length = 3},
  [227] = {.index = 462, .length = 3},
  [228] = {.index = 465, .length = 4},
  [229] = {.index = 469, .length = 5},
  [230] = {.index = 474, .length = 3},
  [231] = {.index = 477, .length = 2},
  [232] = {.index = 479, .length = 2},
  [233] = {.index = 481, .length = 2},
  [234] = {.index = 483, .length = 1},
  [235] = {.index = 484, .length = 4},
  [236] = {.index = 488, .length = 3},
  [237] = {.index = 491, .length = 4},
  [238] = {.index = 495, .length = 5},
  [239] = {.index = 500, .length = 1},
  [240] = {.index = 501, .length = 2},
  [241] = {.index = 503, .length = 4},
  [242] = {.index = 507, .length = 4},
  [243] = {.index = 511, .length = 4},
  [244] = {.index = 515, .length = 3},
  [245] = {.index = 518, .length = 2},
  [246] = {.index = 520, .length = 4},
  [247] = {.index = 524, .length = 4},
  [248] = {.index = 528, .length = 2},
  [249] = {.index = 530, .length = 2},
  [250] = {.index = 532, .length = 1},
  [251] = {.index = 533, .length = 3},
  [252] = {.index = 536, .length = 1},
  [253] = {.index = 537, .length = 2},
  [254] = {.index = 539, .length = 4},
  [255] = {.index = 543, .length = 4},
  [256] = {.index = 547, .length = 4},
  [257] = {.index = 551, .length = 3},
  [258] = {.index = 554, .length = 2},
  [259] = {.index = 556, .length = 3},
  [260] = {.index = 559, .length = 3},
  [261] = {.index = 562, .length = 2},
  [262] = {.index = 564, .length = 3},
  [263] = {.index = 567, .length = 3},
  [264] = {.index = 570, .length = 3},
  [265] = {.index = 573, .length = 3},
  [266] = {.index = 576, .length = 4},
  [267] = {.index = 580, .length = 2},
  [268] = {.index = 582, .length = 4},
  [270] = {.index = 586, .length = 4},
  [271] = {.index = 590, .length = 5},
  [272] = {.index = 595, .length = 5},
  [273] = {.index = 600, .length = 5},
  [274] = {.index = 605, .length = 4},
  [275] = {.index = 609, .length = 5},
  [276] = {.index = 614, .length = 4},
  [277] = {.index = 618, .length = 4},
  [278] = {.index = 622, .length = 3},
  [279] = {.index = 625, .length = 3},
  [280] = {.index = 628, .length = 3},
  [281] = {.index = 625, .length = 3},
  [282] = {.index = 631, .length = 2},
  [283] = {.index = 633, .length = 4},
  [284] = {.index = 637, .length = 4},
  [285] = {.index = 641, .length = 2},
  [286] = {.index = 643, .length = 2},
  [287] = {.index = 645, .length = 4},
  [288] = {.index = 649, .length = 3},
  [289] = {.index = 652, .length = 2},
  [290] = {.index = 654, .length = 3},
  [291] = {.index = 657, .length = 2},
  [292] = {.index = 659, .length = 1},
  [293] = {.index = 660, .length = 3},
  [294] = {.index = 663, .length = 3},
  [295] = {.index = 666, .length = 4},
  [296] = {.index = 670, .length = 4},
  [297] = {.index = 674, .length = 3},
  [298] = {.index = 677, .length = 3},
  [299] = {.index = 680, .length = 2},
  [300] = {.index = 682, .length = 5},
  [301] = {.index = 687, .length = 5},
  [302] = {.index = 692, .length = 5},
  [303] = {.index = 697, .length = 4},
  [304] = {.index = 701, .length = 4},
  [305] = {.index = 705, .length = 3},
  [306] = {.index = 705, .length = 3},
  [307] = {.index = 708, .length = 2},
  [308] = {.index = 710, .length = 3},
  [309] = {.index = 713, .length = 2},
  [310] = {.index = 715, .length = 3},
  [311] = {.index = 718, .length = 2},
  [312] = {.index = 720, .length = 2},
  [313] = {.index = 722, .length = 4},
  [314] = {.index = 726, .length = 3},
  [315] = {.index = 729, .length = 3},
  [316] = {.index = 732, .length = 4},
  [317] = {.index = 736, .length = 3},
  [318] = {.index = 739, .length = 3},
  [319] = {.index = 742, .length = 2},
  [320] = {.index = 744, .length = 5},
  [321] = {.index = 749, .length = 5},
  [322] = {.index = 754, .length = 4},
  [323] = {.index = 754, .length = 4},
  [324] = {.index = 758, .length = 4},
  [325] = {.index = 762, .length = 4},
  [326] = {.index = 766, .length = 3},
  [327] = {.index = 769, .length = 2},
  [328] = {.index = 771, .length = 2},
  [329] = {.index = 773, .length = 3},
  [330] = {.index = 776, .length = 4},
  [331] = {.index = 780, .length = 3},
  [332] = {.index = 783, .length = 3},
  [333] = {.index = 786, .length = 4},
  [334] = {.index = 790, .length = 3},
  [335] = {.index = 793, .length = 3},
  [336] = {.index = 796, .length = 5},
  [337] = {.index = 801, .length = 4},
  [338] = {.index = 805, .length = 3},
  [339] = {.index = 808, .length = 4},
  [340] = {.index = 812, .length = 3},
  [341] = {.index = 815, .length = 3},
  [342] = {.index = 818, .length = 4},
  [343] = {.index = 822, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_pattern, 0},
  [9] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [14] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
  [16] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [18] =
    {field_constructor, 1},
  [19] =
    {field_arguments, 1},
    {field_function, 0},
  [21] =
    {field_argument, 0},
    {field_operator, 1},
  [23] =
    {field_type_arguments, 1},
  [24] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [26] =
    {field_parameters, 0},
    {field_return_type, 1},
  [28] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [30] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [32] =
    {field_declaration, 2},
  [33] =
    {field_left, 0},
    {field_right, 2},
  [35] =
    {field_body, 2},
    {field_label, 0},
  [37] =
    {field_body, 2},
    {field_parameter, 0},
  [39] =
    {field_body, 1},
    {field_name, 0},
  [41] =
    {field_source, 1},
  [42] =
    {field_body, 2},
    {field_object, 1},
  [44] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [46] =
    {field_name, 0},
    {field_type, 1},
  [48] =
    {field_kind, 0},
  [49] =
    {field_condition, 1},
    {field_consequence, 2},
  [51] =
    {field_body, 2},
    {field_value, 1},
  [53] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [59] =
    {field_pattern, 1},
  [60] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [63] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [66] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [68] =
    {field_body, 2},
    {field_condition, 1},
  [70] =
    {field_body, 1},
    {field_handler, 2},
  [72] =
    {field_body, 1},
    {field_finalizer, 2},
  [74] =
    {field_label, 1},
  [75] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [78] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [80] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [82] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [84] =
    {field_function, 1, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
  [86] =
    {field_name, 1},
  [87] =
    {field_name, 0},
    {field_type_arguments, 1},
  [89] =
    {field_name, 0},
    {field_value, 1},
  [91] =
    {field_constraint, 1},
    {field_name, 0},
  [93] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [97] =
    {field_template, 0},
  [98] =
    {field_body, 2},
    {field_name, 1},
  [100] =
    {field_value, 0},
  [101] =
    {field_type_arguments, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [103] =
    {field_body, 2},
  [104] =
    {field_body, 2},
    {field_type_parameters, 1},
  [106] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [110] =
    {field_arguments, 2},
    {field_constructor, 1},
  [112] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [114] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [117] =
    {field_object, 0},
    {field_property, 2},
  [119] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [122] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [125] =
    {field_arguments, 2},
    {field_function, 0},
  [127] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [129] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [133] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [136] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [138] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [140] =
    {field_source, 2, .inherited = true},
  [141] =
    {field_value, 2},
  [142] =
    {field_key, 0},
    {field_value, 2},
  [144] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [149] =
    {field_source, 2},
  [150] =
    {field_value, 1},
  [151] =
    {field_name, 0},
    {field_type, 2},
  [153] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [156] =
    {field_body, 3},
    {field_name, 2},
  [158] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [161] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [167] =
    {field_type, 2},
  [168] =
    {field_pattern, 2},
  [169] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [172] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [175] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [179] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [181] =
    {field_body, 1},
    {field_condition, 3},
  [183] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [186] =
    {field_parameters, 1},
  [187] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [191] =
    {field_function, 0},
    {field_type_arguments, 1},
  [193] =
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_type_arguments, 1},
  [197] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [201] =
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_type_arguments, 1},
  [205] =
    {field_name, 1},
    {field_value, 2},
  [207] =
    {field_constraint, 2},
    {field_name, 1},
  [209] =
    {field_module, 0},
    {field_name, 2},
  [211] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [214] =
    {field_parameters, 0},
    {field_return_type, 2},
  [216] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [220] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [224] =
    {field_decorator, 0, .inherited = true},
  [225] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
  [227] =
    {field_decorator, 1, .inherited = true},
    {field_template, 1, .inherited = true},
  [229] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
    {field_template, 0, .inherited = true},
    {field_template, 1, .inherited = true},
  [233] =
    {field_body, 3},
    {field_name, 1},
  [235] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [238] =
    {field_type_arguments, 1},
    {field_value, 0},
  [240] =
    {field_type_arguments, 1, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [244] =
    {field_body, 3},
    {field_type_parameters, 1},
  [246] =
    {field_body, 3},
    {field_parameter, 1},
  [248] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [252] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [256] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [260] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [265] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [268] =
    {field_left, 1},
    {field_right, 3},
  [270] =
    {field_flags, 3},
    {field_pattern, 1},
  [272] =
    {field_type, 1},
  [273] =
    {field_index, 2},
    {field_object, 0},
  [275] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [278] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [280] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [283] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [285] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [288] =
    {field_source, 3, .inherited = true},
  [289] =
    {field_alias, 2},
    {field_name, 0},
  [291] =
    {field_name, 1},
    {field_value, 3},
  [293] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [298] =
    {field_pattern, 3},
  [299] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [303] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [305] =
    {field_parameters, 1},
    {field_type, 2},
  [307] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [309] =
    {field_name, 2},
  [310] =
    {field_name, 1},
    {field_type, 2},
  [312] =
    {field_parameters, 2},
  [313] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [317] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [321] =
    {field_constraint, 2},
    {field_name, 1},
    {field_value, 3},
  [324] =
    {field_parameters, 1},
    {field_type, 3},
  [326] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [329] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [331] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [333] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [335] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [338] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
  [341] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [344] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [348] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [352] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [356] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [361] =
    {field_body, 4},
    {field_name, 2},
  [363] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [366] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [368] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [371] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [374] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [376] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [379] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [383] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [386] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [389] =
    {field_alias, 3},
    {field_name, 1},
  [391] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [394] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [399] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [402] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [405] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [407] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [411] =
    {field_type, 3},
  [412] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [415] =
    {field_name, 2},
    {field_type, 3},
  [417] =
    {field_name, 1},
    {field_type, 3},
  [419] =
    {field_name, 3},
  [420] =
    {field_parameters, 2},
    {field_type, 3},
  [422] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [424] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [428] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [432] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [436] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [439] =
    {field_parameters, 2},
    {field_type, 4},
  [441] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [443] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [445] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [448] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [451] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [453] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [456] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
  [459] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [462] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
  [465] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [469] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [474] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [477] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [479] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [481] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [483] =
    {field_name, 2, .inherited = true},
  [484] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [488] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [491] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [495] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [500] =
    {field_source, 4},
  [501] =
    {field_body, 3},
    {field_value, 1},
  [503] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [507] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [511] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [515] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [518] =
    {field_body, 4},
    {field_parameter, 2},
  [520] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [524] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [528] =
    {field_name, 2},
    {field_type, 4},
  [530] =
    {field_name, 3},
    {field_type, 4},
  [532] =
    {field_type, 4},
  [533] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [536] =
    {field_name, 4},
  [537] =
    {field_index, 3},
    {field_object, 0},
  [539] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [543] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [547] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [551] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [554] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [556] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [559] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [562] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [564] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [567] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
  [570] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [573] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
  [576] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [580] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
  [582] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [586] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [590] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [595] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [600] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [605] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [609] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [614] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [618] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [622] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [625] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [628] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [631] =
    {field_sign, 0},
    {field_type, 5},
  [633] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [637] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [641] =
    {field_name, 3},
    {field_type, 5},
  [643] =
    {field_name, 4},
    {field_type, 5},
  [645] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [649] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [652] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [654] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [657] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [659] =
    {field_name, 5},
  [660] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [663] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
  [666] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [670] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [674] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [677] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
  [680] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
  [682] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [687] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [692] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
  [697] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [701] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [705] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [708] =
    {field_name, 4},
    {field_type, 6},
  [710] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [713] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [715] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [718] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [720] =
    {field_name, 5},
    {field_type, 6},
  [722] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [726] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [729] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
  [732] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [736] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [739] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
  [742] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
  [744] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [749] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [754] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [758] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [762] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [766] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [769] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [771] =
    {field_name, 5},
    {field_type, 7},
  [773] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [776] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [780] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [783] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
  [786] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [790] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 7, .inherited = true},
  [793] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
  [796] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [801] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [805] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [808] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [812] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 8, .inherited = true},
  [815] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
  [818] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [822] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
    {field_value, 9, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [12] = {
    [0] = alias_sym_type_identifier,
  },
  [13] = {
    [0] = alias_sym_type_identifier,
  },
  [14] = {
    [0] = alias_sym_this_type,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [0] = alias_sym_statement_identifier,
  },
  [29] = {
    [0] = sym_identifier,
  },
  [31] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [32] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [33] = {
    [1] = sym_identifier,
  },
  [49] = {
    [1] = alias_sym_statement_identifier,
  },
  [55] = {
    [1] = alias_sym_type_identifier,
  },
  [56] = {
    [0] = alias_sym_type_identifier,
  },
  [57] = {
    [0] = alias_sym_type_identifier,
  },
  [58] = {
    [0] = alias_sym_type_identifier,
  },
  [59] = {
    [1] = alias_sym_type_identifier,
  },
  [60] = {
    [1] = anon_sym_unique,
  },
  [64] = {
    [1] = alias_sym_type_identifier,
  },
  [75] = {
    [1] = alias_sym_type_identifier,
    [2] = alias_sym_interface_body,
  },
  [77] = {
    [2] = alias_sym_property_identifier,
  },
  [79] = {
    [2] = alias_sym_property_identifier,
  },
  [91] = {
    [0] = sym_member_expression,
    [2] = alias_sym_property_identifier,
  },
  [92] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [116] = {
    [1] = alias_sym_type_identifier,
  },
  [117] = {
    [1] = alias_sym_type_identifier,
  },
  [118] = {
    [2] = alias_sym_type_identifier,
  },
  [119] = {
    [0] = alias_sym_type_identifier,
  },
  [121] = {
    [2] = alias_sym_property_identifier,
  },
  [123] = {
    [2] = alias_sym_property_identifier,
  },
  [129] = {
    [1] = alias_sym_type_identifier,
  },
  [130] = {
    [1] = alias_sym_type_identifier,
  },
  [134] = {
    [1] = sym_identifier,
  },
  [141] = {
    [1] = sym_identifier,
  },
  [144] = {
    [2] = alias_sym_type_identifier,
  },
  [145] = {
    [1] = alias_sym_type_identifier,
  },
  [147] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [148] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [152] = {
    [2] = alias_sym_type_identifier,
  },
  [157] = {
    [1] = alias_sym_type_identifier,
  },
  [159] = {
    [0] = sym_identifier,
  },
  [169] = {
    [2] = alias_sym_property_identifier,
  },
  [171] = {
    [1] = alias_sym_type_identifier,
  },
  [179] = {
    [1] = alias_sym_type_identifier,
  },
  [184] = {
    [2] = alias_sym_type_identifier,
  },
  [185] = {
    [2] = alias_sym_type_identifier,
  },
  [186] = {
    [1] = alias_sym_type_identifier,
  },
  [188] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_interface_body,
  },
  [191] = {
    [0] = sym_identifier,
  },
  [193] = {
    [2] = alias_sym_type_identifier,
  },
  [194] = {
    [2] = alias_sym_type_identifier,
  },
  [196] = {
    [3] = alias_sym_type_identifier,
  },
  [198] = {
    [1] = alias_sym_type_identifier,
  },
  [200] = {
    [1] = sym_identifier,
  },
  [201] = {
    [1] = sym_identifier,
  },
  [206] = {
    [0] = alias_sym_type_identifier,
  },
  [230] = {
    [2] = alias_sym_type_identifier,
  },
  [235] = {
    [2] = alias_sym_type_identifier,
  },
  [236] = {
    [3] = alias_sym_type_identifier,
  },
  [237] = {
    [3] = alias_sym_type_identifier,
  },
  [269] = {
    [3] = alias_sym_property_identifier,
  },
  [270] = {
    [3] = alias_sym_type_identifier,
  },
  [279] = {
    [1] = sym_identifier,
  },
  [280] = {
    [0] = alias_sym_type_identifier,
  },
  [305] = {
    [2] = sym_identifier,
  },
  [322] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_nested_identifier, 2,
    sym_nested_identifier,
    sym_member_expression,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  sym_object_type, 2,
    sym_object_type,
    alias_sym_interface_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 16,
  [19] = 16,
  [20] = 17,
  [21] = 21,
  [22] = 16,
  [23] = 17,
  [24] = 17,
  [25] = 16,
  [26] = 17,
  [27] = 16,
  [28] = 17,
  [29] = 17,
  [30] = 16,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 31,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 45,
  [47] = 33,
  [48] = 36,
  [49] = 44,
  [50] = 50,
  [51] = 32,
  [52] = 52,
  [53] = 34,
  [54] = 37,
  [55] = 38,
  [56] = 39,
  [57] = 40,
  [58] = 41,
  [59] = 42,
  [60] = 43,
  [61] = 50,
  [62] = 32,
  [63] = 32,
  [64] = 32,
  [65] = 32,
  [66] = 52,
  [67] = 32,
  [68] = 32,
  [69] = 32,
  [70] = 32,
  [71] = 71,
  [72] = 72,
  [73] = 72,
  [74] = 72,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 78,
  [83] = 80,
  [84] = 84,
  [85] = 78,
  [86] = 86,
  [87] = 86,
  [88] = 88,
  [89] = 86,
  [90] = 90,
  [91] = 86,
  [92] = 86,
  [93] = 93,
  [94] = 94,
  [95] = 93,
  [96] = 88,
  [97] = 97,
  [98] = 93,
  [99] = 99,
  [100] = 99,
  [101] = 93,
  [102] = 94,
  [103] = 94,
  [104] = 93,
  [105] = 97,
  [106] = 93,
  [107] = 93,
  [108] = 108,
  [109] = 94,
  [110] = 110,
  [111] = 93,
  [112] = 90,
  [113] = 113,
  [114] = 88,
  [115] = 115,
  [116] = 94,
  [117] = 93,
  [118] = 93,
  [119] = 99,
  [120] = 99,
  [121] = 121,
  [122] = 88,
  [123] = 94,
  [124] = 93,
  [125] = 93,
  [126] = 94,
  [127] = 93,
  [128] = 113,
  [129] = 110,
  [130] = 94,
  [131] = 94,
  [132] = 93,
  [133] = 93,
  [134] = 93,
  [135] = 93,
  [136] = 93,
  [137] = 137,
  [138] = 94,
  [139] = 137,
  [140] = 137,
  [141] = 137,
  [142] = 137,
  [143] = 137,
  [144] = 93,
  [145] = 137,
  [146] = 146,
  [147] = 137,
  [148] = 137,
  [149] = 137,
  [150] = 150,
  [151] = 151,
  [152] = 151,
  [153] = 153,
  [154] = 151,
  [155] = 151,
  [156] = 151,
  [157] = 157,
  [158] = 151,
  [159] = 151,
  [160] = 151,
  [161] = 151,
  [162] = 151,
  [163] = 163,
  [164] = 163,
  [165] = 163,
  [166] = 163,
  [167] = 163,
  [168] = 163,
  [169] = 163,
  [170] = 163,
  [171] = 163,
  [172] = 163,
  [173] = 173,
  [174] = 174,
  [175] = 173,
  [176] = 176,
  [177] = 174,
  [178] = 176,
  [179] = 173,
  [180] = 174,
  [181] = 176,
  [182] = 182,
  [183] = 173,
  [184] = 184,
  [185] = 184,
  [186] = 173,
  [187] = 184,
  [188] = 173,
  [189] = 173,
  [190] = 173,
  [191] = 173,
  [192] = 182,
  [193] = 173,
  [194] = 194,
  [195] = 194,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 198,
  [200] = 197,
  [201] = 196,
  [202] = 198,
  [203] = 197,
  [204] = 196,
  [205] = 205,
  [206] = 206,
  [207] = 205,
  [208] = 205,
  [209] = 205,
  [210] = 205,
  [211] = 205,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 215,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 215,
  [226] = 226,
  [227] = 227,
  [228] = 220,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 224,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 242,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 215,
  [256] = 215,
  [257] = 257,
  [258] = 215,
  [259] = 257,
  [260] = 257,
  [261] = 215,
  [262] = 257,
  [263] = 215,
  [264] = 215,
  [265] = 257,
  [266] = 215,
  [267] = 215,
  [268] = 257,
  [269] = 257,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 272,
  [274] = 272,
  [275] = 275,
  [276] = 272,
  [277] = 277,
  [278] = 278,
  [279] = 272,
  [280] = 280,
  [281] = 272,
  [282] = 282,
  [283] = 282,
  [284] = 277,
  [285] = 272,
  [286] = 272,
  [287] = 275,
  [288] = 288,
  [289] = 272,
  [290] = 272,
  [291] = 272,
  [292] = 272,
  [293] = 272,
  [294] = 272,
  [295] = 272,
  [296] = 272,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 300,
  [303] = 303,
  [304] = 301,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 307,
  [311] = 311,
  [312] = 308,
  [313] = 311,
  [314] = 306,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 315,
  [323] = 319,
  [324] = 324,
  [325] = 320,
  [326] = 315,
  [327] = 319,
  [328] = 328,
  [329] = 316,
  [330] = 324,
  [331] = 315,
  [332] = 319,
  [333] = 320,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 320,
  [339] = 328,
  [340] = 328,
  [341] = 316,
  [342] = 324,
  [343] = 315,
  [344] = 319,
  [345] = 320,
  [346] = 320,
  [347] = 328,
  [348] = 316,
  [349] = 328,
  [350] = 350,
  [351] = 328,
  [352] = 316,
  [353] = 324,
  [354] = 315,
  [355] = 319,
  [356] = 320,
  [357] = 316,
  [358] = 324,
  [359] = 324,
  [360] = 328,
  [361] = 328,
  [362] = 316,
  [363] = 324,
  [364] = 315,
  [365] = 319,
  [366] = 320,
  [367] = 367,
  [368] = 315,
  [369] = 369,
  [370] = 319,
  [371] = 320,
  [372] = 315,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 328,
  [379] = 379,
  [380] = 316,
  [381] = 316,
  [382] = 324,
  [383] = 321,
  [384] = 335,
  [385] = 315,
  [386] = 319,
  [387] = 320,
  [388] = 324,
  [389] = 389,
  [390] = 319,
  [391] = 328,
  [392] = 392,
  [393] = 316,
  [394] = 373,
  [395] = 324,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 398,
  [406] = 406,
  [407] = 398,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 401,
  [418] = 402,
  [419] = 419,
  [420] = 404,
  [421] = 421,
  [422] = 422,
  [423] = 397,
  [424] = 411,
  [425] = 399,
  [426] = 413,
  [427] = 400,
  [428] = 415,
  [429] = 429,
  [430] = 419,
  [431] = 403,
  [432] = 406,
  [433] = 397,
  [434] = 399,
  [435] = 400,
  [436] = 403,
  [437] = 406,
  [438] = 408,
  [439] = 412,
  [440] = 414,
  [441] = 422,
  [442] = 442,
  [443] = 408,
  [444] = 444,
  [445] = 445,
  [446] = 412,
  [447] = 414,
  [448] = 422,
  [449] = 442,
  [450] = 398,
  [451] = 442,
  [452] = 444,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 444,
  [458] = 398,
  [459] = 459,
  [460] = 460,
  [461] = 445,
  [462] = 401,
  [463] = 402,
  [464] = 404,
  [465] = 453,
  [466] = 411,
  [467] = 413,
  [468] = 454,
  [469] = 415,
  [470] = 419,
  [471] = 421,
  [472] = 397,
  [473] = 399,
  [474] = 400,
  [475] = 403,
  [476] = 406,
  [477] = 408,
  [478] = 412,
  [479] = 414,
  [480] = 422,
  [481] = 442,
  [482] = 444,
  [483] = 456,
  [484] = 484,
  [485] = 398,
  [486] = 486,
  [487] = 487,
  [488] = 453,
  [489] = 454,
  [490] = 459,
  [491] = 459,
  [492] = 396,
  [493] = 493,
  [494] = 398,
  [495] = 416,
  [496] = 402,
  [497] = 404,
  [498] = 493,
  [499] = 411,
  [500] = 500,
  [501] = 413,
  [502] = 502,
  [503] = 415,
  [504] = 429,
  [505] = 419,
  [506] = 397,
  [507] = 399,
  [508] = 400,
  [509] = 403,
  [510] = 406,
  [511] = 408,
  [512] = 412,
  [513] = 414,
  [514] = 422,
  [515] = 442,
  [516] = 444,
  [517] = 398,
  [518] = 518,
  [519] = 456,
  [520] = 453,
  [521] = 454,
  [522] = 459,
  [523] = 401,
  [524] = 402,
  [525] = 404,
  [526] = 411,
  [527] = 413,
  [528] = 415,
  [529] = 419,
  [530] = 397,
  [531] = 399,
  [532] = 400,
  [533] = 403,
  [534] = 406,
  [535] = 408,
  [536] = 412,
  [537] = 414,
  [538] = 422,
  [539] = 442,
  [540] = 444,
  [541] = 398,
  [542] = 396,
  [543] = 493,
  [544] = 459,
  [545] = 453,
  [546] = 454,
  [547] = 547,
  [548] = 459,
  [549] = 396,
  [550] = 493,
  [551] = 398,
  [552] = 416,
  [553] = 429,
  [554] = 402,
  [555] = 404,
  [556] = 411,
  [557] = 413,
  [558] = 415,
  [559] = 419,
  [560] = 397,
  [561] = 399,
  [562] = 400,
  [563] = 403,
  [564] = 406,
  [565] = 412,
  [566] = 414,
  [567] = 422,
  [568] = 442,
  [569] = 444,
  [570] = 453,
  [571] = 454,
  [572] = 572,
  [573] = 459,
  [574] = 396,
  [575] = 493,
  [576] = 398,
  [577] = 416,
  [578] = 429,
  [579] = 402,
  [580] = 404,
  [581] = 411,
  [582] = 413,
  [583] = 415,
  [584] = 419,
  [585] = 397,
  [586] = 399,
  [587] = 400,
  [588] = 403,
  [589] = 406,
  [590] = 408,
  [591] = 412,
  [592] = 414,
  [593] = 422,
  [594] = 442,
  [595] = 411,
  [596] = 444,
  [597] = 453,
  [598] = 454,
  [599] = 456,
  [600] = 459,
  [601] = 396,
  [602] = 493,
  [603] = 398,
  [604] = 416,
  [605] = 429,
  [606] = 606,
  [607] = 402,
  [608] = 404,
  [609] = 411,
  [610] = 413,
  [611] = 398,
  [612] = 415,
  [613] = 419,
  [614] = 397,
  [615] = 399,
  [616] = 400,
  [617] = 403,
  [618] = 406,
  [619] = 408,
  [620] = 412,
  [621] = 414,
  [622] = 422,
  [623] = 442,
  [624] = 444,
  [625] = 416,
  [626] = 453,
  [627] = 454,
  [628] = 628,
  [629] = 459,
  [630] = 396,
  [631] = 493,
  [632] = 416,
  [633] = 429,
  [634] = 402,
  [635] = 404,
  [636] = 411,
  [637] = 413,
  [638] = 415,
  [639] = 419,
  [640] = 397,
  [641] = 399,
  [642] = 400,
  [643] = 403,
  [644] = 406,
  [645] = 408,
  [646] = 412,
  [647] = 414,
  [648] = 422,
  [649] = 442,
  [650] = 444,
  [651] = 456,
  [652] = 453,
  [653] = 454,
  [654] = 401,
  [655] = 404,
  [656] = 459,
  [657] = 413,
  [658] = 396,
  [659] = 493,
  [660] = 416,
  [661] = 429,
  [662] = 398,
  [663] = 396,
  [664] = 493,
  [665] = 401,
  [666] = 415,
  [667] = 396,
  [668] = 429,
  [669] = 419,
  [670] = 401,
  [671] = 421,
  [672] = 398,
  [673] = 398,
  [674] = 402,
  [675] = 493,
  [676] = 453,
  [677] = 401,
  [678] = 454,
  [679] = 401,
  [680] = 401,
  [681] = 416,
  [682] = 455,
  [683] = 429,
  [684] = 416,
  [685] = 429,
  [686] = 408,
  [687] = 687,
  [688] = 687,
  [689] = 687,
  [690] = 690,
  [691] = 690,
  [692] = 690,
  [693] = 693,
  [694] = 693,
  [695] = 693,
  [696] = 696,
  [697] = 696,
  [698] = 698,
  [699] = 698,
  [700] = 698,
  [701] = 701,
  [702] = 702,
  [703] = 702,
  [704] = 701,
  [705] = 702,
  [706] = 701,
  [707] = 227,
  [708] = 230,
  [709] = 709,
  [710] = 709,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 716,
  [720] = 717,
  [721] = 718,
  [722] = 718,
  [723] = 716,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 726,
  [728] = 728,
  [729] = 724,
  [730] = 726,
  [731] = 728,
  [732] = 726,
  [733] = 726,
  [734] = 726,
  [735] = 725,
  [736] = 726,
  [737] = 737,
  [738] = 726,
  [739] = 726,
  [740] = 740,
  [741] = 724,
  [742] = 726,
  [743] = 743,
  [744] = 726,
  [745] = 745,
  [746] = 724,
  [747] = 726,
  [748] = 748,
  [749] = 229,
  [750] = 745,
  [751] = 745,
  [752] = 234,
  [753] = 753,
  [754] = 726,
  [755] = 253,
  [756] = 236,
  [757] = 726,
  [758] = 229,
  [759] = 237,
  [760] = 726,
  [761] = 726,
  [762] = 726,
  [763] = 726,
  [764] = 233,
  [765] = 725,
  [766] = 236,
  [767] = 233,
  [768] = 234,
  [769] = 740,
  [770] = 770,
  [771] = 771,
  [772] = 771,
  [773] = 726,
  [774] = 213,
  [775] = 771,
  [776] = 771,
  [777] = 771,
  [778] = 771,
  [779] = 771,
  [780] = 771,
  [781] = 214,
  [782] = 771,
  [783] = 771,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 231,
  [789] = 789,
  [790] = 786,
  [791] = 791,
  [792] = 217,
  [793] = 793,
  [794] = 232,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 786,
  [805] = 786,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 786,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 253,
  [819] = 819,
  [820] = 237,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 835,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 835,
  [843] = 836,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 835,
  [849] = 836,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 835,
  [859] = 836,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 836,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 243,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 239,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 948,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 948,
  [961] = 946,
  [962] = 962,
  [963] = 948,
  [964] = 964,
  [965] = 946,
  [966] = 948,
  [967] = 964,
  [968] = 796,
  [969] = 946,
  [970] = 948,
  [971] = 810,
  [972] = 948,
  [973] = 964,
  [974] = 946,
  [975] = 946,
  [976] = 946,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 979,
  [983] = 980,
  [984] = 980,
  [985] = 981,
  [986] = 981,
  [987] = 980,
  [988] = 979,
  [989] = 981,
  [990] = 990,
  [991] = 980,
  [992] = 981,
  [993] = 979,
  [994] = 979,
  [995] = 981,
  [996] = 980,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 998,
  [1018] = 1011,
  [1019] = 1013,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 998,
  [1027] = 1020,
  [1028] = 1006,
  [1029] = 1023,
  [1030] = 1024,
  [1031] = 1007,
  [1032] = 1006,
  [1033] = 1007,
  [1034] = 1008,
  [1035] = 1015,
  [1036] = 1036,
  [1037] = 1009,
  [1038] = 1036,
  [1039] = 1009,
  [1040] = 1010,
  [1041] = 998,
  [1042] = 1011,
  [1043] = 1020,
  [1044] = 1013,
  [1045] = 1023,
  [1046] = 1024,
  [1047] = 1014,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1036,
  [1054] = 999,
  [1055] = 1016,
  [1056] = 1010,
  [1057] = 1057,
  [1058] = 998,
  [1059] = 1020,
  [1060] = 1021,
  [1061] = 1061,
  [1062] = 1014,
  [1063] = 1022,
  [1064] = 1006,
  [1065] = 1007,
  [1066] = 1036,
  [1067] = 1061,
  [1068] = 1009,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1009,
  [1073] = 1023,
  [1074] = 1024,
  [1075] = 1020,
  [1076] = 1006,
  [1077] = 1011,
  [1078] = 1016,
  [1079] = 1061,
  [1080] = 1023,
  [1081] = 1024,
  [1082] = 1013,
  [1083] = 1007,
  [1084] = 1000,
  [1085] = 1008,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1023,
  [1090] = 1011,
  [1091] = 1013,
  [1092] = 999,
  [1093] = 1010,
  [1094] = 1014,
  [1095] = 1016,
  [1096] = 1021,
  [1097] = 1022,
  [1098] = 1008,
  [1099] = 1061,
  [1100] = 1021,
  [1101] = 1022,
  [1102] = 998,
  [1103] = 1103,
  [1104] = 1020,
  [1105] = 1008,
  [1106] = 1036,
  [1107] = 1011,
  [1108] = 1013,
  [1109] = 1009,
  [1110] = 1103,
  [1111] = 1012,
  [1112] = 998,
  [1113] = 1006,
  [1114] = 1020,
  [1115] = 1010,
  [1116] = 1061,
  [1117] = 1023,
  [1118] = 1024,
  [1119] = 1006,
  [1120] = 1007,
  [1121] = 1036,
  [1122] = 1009,
  [1123] = 1014,
  [1124] = 1016,
  [1125] = 1021,
  [1126] = 1010,
  [1127] = 1014,
  [1128] = 1016,
  [1129] = 1021,
  [1130] = 1022,
  [1131] = 1010,
  [1132] = 1014,
  [1133] = 1016,
  [1134] = 1021,
  [1135] = 1022,
  [1136] = 1022,
  [1137] = 1008,
  [1138] = 1025,
  [1139] = 1007,
  [1140] = 1036,
  [1141] = 1011,
  [1142] = 1013,
  [1143] = 1001,
  [1144] = 1061,
  [1145] = 999,
  [1146] = 1008,
  [1147] = 999,
  [1148] = 999,
  [1149] = 999,
  [1150] = 1024,
  [1151] = 1151,
  [1152] = 1151,
  [1153] = 1151,
  [1154] = 1151,
  [1155] = 1151,
  [1156] = 1151,
  [1157] = 1151,
  [1158] = 1151,
  [1159] = 1151,
  [1160] = 1151,
  [1161] = 1151,
  [1162] = 1151,
  [1163] = 1163,
  [1164] = 1163,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1166,
  [1169] = 1163,
  [1170] = 1166,
  [1171] = 1171,
  [1172] = 1171,
  [1173] = 1171,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1177,
  [1180] = 1178,
  [1181] = 1175,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1182,
  [1185] = 1185,
  [1186] = 1177,
  [1187] = 1177,
  [1188] = 1177,
  [1189] = 1183,
  [1190] = 1185,
  [1191] = 1176,
  [1192] = 1177,
  [1193] = 1193,
  [1194] = 1177,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1177,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1176,
  [1202] = 1195,
  [1203] = 1203,
  [1204] = 1195,
  [1205] = 1177,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1177,
  [1212] = 1212,
  [1213] = 1177,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1214,
  [1218] = 1177,
  [1219] = 1215,
  [1220] = 796,
  [1221] = 1215,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1176,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 810,
  [1228] = 1228,
  [1229] = 1225,
  [1230] = 1222,
  [1231] = 1214,
  [1232] = 1177,
  [1233] = 1223,
  [1234] = 1234,
  [1235] = 1225,
  [1236] = 1236,
  [1237] = 1177,
  [1238] = 1177,
  [1239] = 1177,
  [1240] = 1177,
  [1241] = 1177,
  [1242] = 1177,
  [1243] = 1175,
  [1244] = 1203,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1225,
  [1248] = 1225,
  [1249] = 1249,
  [1250] = 1246,
  [1251] = 1236,
  [1252] = 1249,
  [1253] = 1225,
  [1254] = 1246,
  [1255] = 1255,
  [1256] = 1177,
  [1257] = 1249,
  [1258] = 1258,
  [1259] = 1249,
  [1260] = 1249,
  [1261] = 1249,
  [1262] = 1262,
  [1263] = 1225,
  [1264] = 1264,
  [1265] = 1249,
  [1266] = 1266,
  [1267] = 1249,
  [1268] = 1268,
  [1269] = 1249,
  [1270] = 1236,
  [1271] = 1225,
  [1272] = 1272,
  [1273] = 1249,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1225,
  [1277] = 1208,
  [1278] = 1278,
  [1279] = 1262,
  [1280] = 1236,
  [1281] = 1225,
  [1282] = 1282,
  [1283] = 1206,
  [1284] = 1284,
  [1285] = 1236,
  [1286] = 1206,
  [1287] = 1208,
  [1288] = 1284,
  [1289] = 1225,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1290,
  [1293] = 1236,
  [1294] = 1294,
  [1295] = 1255,
  [1296] = 1296,
  [1297] = 1282,
  [1298] = 1262,
  [1299] = 1255,
  [1300] = 1225,
  [1301] = 1225,
  [1302] = 1302,
  [1303] = 1302,
  [1304] = 1225,
  [1305] = 1305,
  [1306] = 1236,
  [1307] = 1302,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1275,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1262,
  [1314] = 1309,
  [1315] = 1290,
  [1316] = 1274,
  [1317] = 1225,
  [1318] = 1268,
  [1319] = 1198,
  [1320] = 1302,
  [1321] = 1290,
  [1322] = 1311,
  [1323] = 1199,
  [1324] = 796,
  [1325] = 1209,
  [1326] = 1196,
  [1327] = 1226,
  [1328] = 1236,
  [1329] = 1302,
  [1330] = 810,
  [1331] = 1255,
  [1332] = 1290,
  [1333] = 1302,
  [1334] = 1193,
  [1335] = 1200,
  [1336] = 1290,
  [1337] = 1262,
  [1338] = 1236,
  [1339] = 1339,
  [1340] = 1236,
  [1341] = 1206,
  [1342] = 1225,
  [1343] = 1207,
  [1344] = 1262,
  [1345] = 1345,
  [1346] = 1208,
  [1347] = 1312,
  [1348] = 1226,
  [1349] = 1294,
  [1350] = 1275,
  [1351] = 1272,
  [1352] = 1352,
  [1353] = 1305,
  [1354] = 1354,
  [1355] = 1355,
  [1356] = 1290,
  [1357] = 1290,
  [1358] = 1358,
  [1359] = 1262,
  [1360] = 1360,
  [1361] = 1302,
  [1362] = 1206,
  [1363] = 1262,
  [1364] = 1226,
  [1365] = 1290,
  [1366] = 1226,
  [1367] = 1354,
  [1368] = 1206,
  [1369] = 1302,
  [1370] = 1208,
  [1371] = 1262,
  [1372] = 1236,
  [1373] = 1290,
  [1374] = 1262,
  [1375] = 1302,
  [1376] = 1302,
  [1377] = 1208,
  [1378] = 1274,
  [1379] = 1379,
  [1380] = 1275,
  [1381] = 1379,
  [1382] = 1305,
  [1383] = 1302,
  [1384] = 1384,
  [1385] = 1379,
  [1386] = 1226,
  [1387] = 1387,
  [1388] = 1290,
  [1389] = 1290,
  [1390] = 1206,
  [1391] = 1391,
  [1392] = 1262,
  [1393] = 1226,
  [1394] = 1274,
  [1395] = 1379,
  [1396] = 1208,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1379,
  [1400] = 1302,
  [1401] = 1379,
  [1402] = 1355,
  [1403] = 1268,
  [1404] = 1302,
  [1405] = 1302,
  [1406] = 1290,
  [1407] = 1302,
  [1408] = 1302,
  [1409] = 1302,
  [1410] = 1302,
  [1411] = 1352,
  [1412] = 1290,
  [1413] = 1290,
  [1414] = 1226,
  [1415] = 1305,
  [1416] = 1290,
  [1417] = 1290,
  [1418] = 1290,
  [1419] = 1226,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1420,
  [1429] = 1424,
  [1430] = 1425,
  [1431] = 1426,
  [1432] = 1425,
  [1433] = 1427,
  [1434] = 1420,
  [1435] = 1421,
  [1436] = 1423,
  [1437] = 1424,
  [1438] = 1425,
  [1439] = 1426,
  [1440] = 1427,
  [1441] = 1420,
  [1442] = 1421,
  [1443] = 1423,
  [1444] = 1426,
  [1445] = 1427,
  [1446] = 1420,
  [1447] = 1424,
  [1448] = 1421,
  [1449] = 1423,
  [1450] = 1427,
  [1451] = 1226,
  [1452] = 1424,
  [1453] = 1421,
  [1454] = 1421,
  [1455] = 1423,
  [1456] = 1423,
  [1457] = 1426,
  [1458] = 1421,
  [1459] = 1421,
  [1460] = 1423,
  [1461] = 1425,
  [1462] = 1426,
  [1463] = 1421,
  [1464] = 1423,
  [1465] = 1294,
  [1466] = 1391,
  [1467] = 1427,
  [1468] = 1421,
  [1469] = 1423,
  [1470] = 1423,
  [1471] = 1420,
  [1472] = 1226,
  [1473] = 1302,
  [1474] = 1290,
  [1475] = 1475,
  [1476] = 1475,
  [1477] = 1475,
  [1478] = 1475,
  [1479] = 1475,
  [1480] = 1475,
  [1481] = 1475,
  [1482] = 1475,
  [1483] = 1475,
  [1484] = 1475,
  [1485] = 1485,
  [1486] = 1485,
  [1487] = 1485,
  [1488] = 1485,
  [1489] = 1485,
  [1490] = 1490,
  [1491] = 1485,
  [1492] = 1492,
  [1493] = 1492,
  [1494] = 1492,
  [1495] = 1492,
  [1496] = 1492,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1498,
  [1500] = 1498,
  [1501] = 1498,
  [1502] = 1498,
  [1503] = 1498,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 230,
  [1508] = 1508,
  [1509] = 227,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 230,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 227,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 978,
  [1523] = 997,
  [1524] = 990,
  [1525] = 216,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 217,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1167,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 229,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 713,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 213,
  [1577] = 214,
  [1578] = 712,
  [1579] = 714,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 213,
  [1589] = 214,
  [1590] = 1590,
  [1591] = 217,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1165,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1174,
  [1625] = 1625,
  [1626] = 715,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 711,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 234,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1664,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1497,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 239,
  [1682] = 233,
  [1683] = 253,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1687,
  [1688] = 243,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1680,
  [1694] = 1680,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1680,
  [1712] = 1680,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 231,
  [1716] = 232,
  [1717] = 231,
  [1718] = 232,
  [1719] = 236,
  [1720] = 1720,
  [1721] = 237,
  [1722] = 1722,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1727,
  [1728] = 239,
  [1729] = 1505,
  [1730] = 243,
  [1731] = 1731,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 237,
  [1736] = 1736,
  [1737] = 229,
  [1738] = 1738,
  [1739] = 1702,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 236,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1740,
  [1749] = 1740,
  [1750] = 1750,
  [1751] = 1506,
  [1752] = 1750,
  [1753] = 1740,
  [1754] = 233,
  [1755] = 1750,
  [1756] = 1510,
  [1757] = 1740,
  [1758] = 1758,
  [1759] = 1695,
  [1760] = 1750,
  [1761] = 1511,
  [1762] = 1750,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 234,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 253,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1698,
  [1783] = 1771,
  [1784] = 1771,
  [1785] = 1774,
  [1786] = 1786,
  [1787] = 997,
  [1788] = 1779,
  [1789] = 1780,
  [1790] = 1781,
  [1791] = 1741,
  [1792] = 1773,
  [1793] = 1766,
  [1794] = 1733,
  [1795] = 1758,
  [1796] = 1742,
  [1797] = 1775,
  [1798] = 978,
  [1799] = 1769,
  [1800] = 1800,
  [1801] = 1733,
  [1802] = 1776,
  [1803] = 1803,
  [1804] = 1731,
  [1805] = 1746,
  [1806] = 1764,
  [1807] = 1765,
  [1808] = 1732,
  [1809] = 1809,
  [1810] = 1726,
  [1811] = 1776,
  [1812] = 1738,
  [1813] = 1519,
  [1814] = 1744,
  [1815] = 1736,
  [1816] = 1731,
  [1817] = 1746,
  [1818] = 1741,
  [1819] = 1742,
  [1820] = 1764,
  [1821] = 1767,
  [1822] = 1765,
  [1823] = 1823,
  [1824] = 1520,
  [1825] = 1514,
  [1826] = 1826,
  [1827] = 1725,
  [1828] = 1647,
  [1829] = 1758,
  [1830] = 1769,
  [1831] = 1725,
  [1832] = 1745,
  [1833] = 1515,
  [1834] = 1763,
  [1835] = 1518,
  [1836] = 1770,
  [1837] = 1647,
  [1838] = 1826,
  [1839] = 1839,
  [1840] = 1732,
  [1841] = 1774,
  [1842] = 1639,
  [1843] = 1726,
  [1844] = 1738,
  [1845] = 1526,
  [1846] = 1527,
  [1847] = 1773,
  [1848] = 1745,
  [1849] = 1849,
  [1850] = 1744,
  [1851] = 1775,
  [1852] = 1639,
  [1853] = 1826,
  [1854] = 1736,
  [1855] = 1855,
  [1856] = 1826,
  [1857] = 1768,
  [1858] = 1839,
  [1859] = 1766,
  [1860] = 1767,
  [1861] = 1768,
  [1862] = 1862,
  [1863] = 1779,
  [1864] = 1763,
  [1865] = 1777,
  [1866] = 1780,
  [1867] = 1513,
  [1868] = 1781,
  [1869] = 1698,
  [1870] = 1839,
  [1871] = 1517,
  [1872] = 1872,
  [1873] = 1770,
  [1874] = 1839,
  [1875] = 990,
  [1876] = 1702,
  [1877] = 1695,
  [1878] = 1826,
  [1879] = 1777,
  [1880] = 1548,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 216,
  [1884] = 1770,
  [1885] = 1885,
  [1886] = 1771,
  [1887] = 1800,
  [1888] = 1774,
  [1889] = 1607,
  [1890] = 1535,
  [1891] = 1528,
  [1892] = 1617,
  [1893] = 1618,
  [1894] = 1574,
  [1895] = 1625,
  [1896] = 1533,
  [1897] = 1775,
  [1898] = 1766,
  [1899] = 1767,
  [1900] = 1768,
  [1901] = 1901,
  [1902] = 1777,
  [1903] = 1903,
  [1904] = 713,
  [1905] = 1580,
  [1906] = 1619,
  [1907] = 1623,
  [1908] = 1908,
  [1909] = 1705,
  [1910] = 1885,
  [1911] = 1800,
  [1912] = 1630,
  [1913] = 1592,
  [1914] = 1529,
  [1915] = 1540,
  [1916] = 1556,
  [1917] = 1560,
  [1918] = 1561,
  [1919] = 1562,
  [1920] = 1568,
  [1921] = 1569,
  [1922] = 1582,
  [1923] = 1597,
  [1924] = 1598,
  [1925] = 1174,
  [1926] = 1779,
  [1927] = 1780,
  [1928] = 1781,
  [1929] = 1733,
  [1930] = 1534,
  [1931] = 1776,
  [1932] = 1731,
  [1933] = 1746,
  [1934] = 1764,
  [1935] = 1765,
  [1936] = 1732,
  [1937] = 1726,
  [1938] = 1738,
  [1939] = 1744,
  [1940] = 1736,
  [1941] = 1741,
  [1942] = 1742,
  [1943] = 715,
  [1944] = 1635,
  [1945] = 1640,
  [1946] = 1643,
  [1947] = 1530,
  [1948] = 1531,
  [1949] = 1532,
  [1950] = 1649,
  [1951] = 1614,
  [1952] = 1714,
  [1953] = 1628,
  [1954] = 1538,
  [1955] = 1542,
  [1956] = 1545,
  [1957] = 1551,
  [1958] = 1552,
  [1959] = 1554,
  [1960] = 1557,
  [1961] = 1558,
  [1962] = 1559,
  [1963] = 1563,
  [1964] = 1564,
  [1965] = 1565,
  [1966] = 1167,
  [1967] = 1570,
  [1968] = 1572,
  [1969] = 1573,
  [1970] = 1613,
  [1971] = 1758,
  [1972] = 1769,
  [1973] = 1725,
  [1974] = 1546,
  [1975] = 1547,
  [1976] = 1745,
  [1977] = 1763,
  [1978] = 1697,
  [1979] = 1872,
  [1980] = 714,
  [1981] = 1586,
  [1982] = 1587,
  [1983] = 1590,
  [1984] = 1650,
  [1985] = 1593,
  [1986] = 1594,
  [1987] = 1595,
  [1988] = 1596,
  [1989] = 1599,
  [1990] = 1600,
  [1991] = 1603,
  [1992] = 1604,
  [1993] = 1605,
  [1994] = 1609,
  [1995] = 1581,
  [1996] = 1612,
  [1997] = 1615,
  [1998] = 1620,
  [1999] = 1165,
  [2000] = 1621,
  [2001] = 1622,
  [2002] = 1627,
  [2003] = 1550,
  [2004] = 1773,
  [2005] = 711,
  [2006] = 1632,
  [2007] = 1633,
  [2008] = 1616,
  [2009] = 1636,
  [2010] = 1637,
  [2011] = 1638,
  [2012] = 1644,
  [2013] = 1645,
  [2014] = 1648,
  [2015] = 1543,
  [2016] = 1536,
  [2017] = 1537,
  [2018] = 1566,
  [2019] = 712,
  [2020] = 1606,
  [2021] = 1631,
  [2022] = 1544,
  [2023] = 1555,
  [2024] = 1575,
  [2025] = 1583,
  [2026] = 1584,
  [2027] = 1585,
  [2028] = 1602,
  [2029] = 1608,
  [2030] = 1611,
  [2031] = 1642,
  [2032] = 216,
  [2033] = 1901,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 1901,
  [2040] = 1610,
  [2041] = 1647,
  [2042] = 1649,
  [2043] = 1639,
  [2044] = 1614,
  [2045] = 1641,
  [2046] = 2046,
  [2047] = 1541,
  [2048] = 1553,
  [2049] = 2049,
  [2050] = 1647,
  [2051] = 1901,
  [2052] = 1639,
  [2053] = 1647,
  [2054] = 1639,
  [2055] = 1628,
  [2056] = 1581,
  [2057] = 2057,
  [2058] = 1901,
  [2059] = 1705,
  [2060] = 1647,
  [2061] = 1639,
  [2062] = 1714,
  [2063] = 1697,
  [2064] = 1616,
  [2065] = 2046,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 1698,
  [2071] = 1702,
  [2072] = 2072,
  [2073] = 1901,
  [2074] = 2074,
  [2075] = 1872,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2079,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 1695,
  [2083] = 1766,
  [2084] = 1767,
  [2085] = 1768,
  [2086] = 1777,
  [2087] = 1779,
  [2088] = 1780,
  [2089] = 1781,
  [2090] = 1733,
  [2091] = 1776,
  [2092] = 1731,
  [2093] = 1746,
  [2094] = 1764,
  [2095] = 1765,
  [2096] = 1732,
  [2097] = 1726,
  [2098] = 1738,
  [2099] = 1744,
  [2100] = 1736,
  [2101] = 1741,
  [2102] = 1742,
  [2103] = 1758,
  [2104] = 1769,
  [2105] = 1725,
  [2106] = 1745,
  [2107] = 1763,
  [2108] = 1773,
  [2109] = 1770,
  [2110] = 1771,
  [2111] = 1774,
  [2112] = 1775,
  [2113] = 1634,
  [2114] = 2114,
  [2115] = 2114,
  [2116] = 1699,
  [2117] = 251,
  [2118] = 1675,
  [2119] = 246,
  [2120] = 252,
  [2121] = 235,
  [2122] = 1714,
  [2123] = 2123,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 1704,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 1706,
  [2130] = 1700,
  [2131] = 1710,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2134,
  [2135] = 1701,
  [2136] = 1651,
  [2137] = 1705,
  [2138] = 2138,
  [2139] = 2139,
  [2140] = 1670,
  [2141] = 2141,
  [2142] = 1705,
  [2143] = 1649,
  [2144] = 1697,
  [2145] = 1823,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 1714,
  [2149] = 2149,
  [2150] = 1614,
  [2151] = 247,
  [2152] = 1714,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2139,
  [2156] = 1689,
  [2157] = 2141,
  [2158] = 2158,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 1647,
  [2162] = 1639,
  [2163] = 1628,
  [2164] = 1581,
  [2165] = 2158,
  [2166] = 2159,
  [2167] = 2160,
  [2168] = 2168,
  [2169] = 226,
  [2170] = 2170,
  [2171] = 221,
  [2172] = 1647,
  [2173] = 1639,
  [2174] = 2158,
  [2175] = 2159,
  [2176] = 2158,
  [2177] = 2159,
  [2178] = 2158,
  [2179] = 2159,
  [2180] = 222,
  [2181] = 1684,
  [2182] = 2182,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 1766,
  [2186] = 1767,
  [2187] = 1768,
  [2188] = 1777,
  [2189] = 1685,
  [2190] = 1669,
  [2191] = 2191,
  [2192] = 2192,
  [2193] = 1779,
  [2194] = 1780,
  [2195] = 1781,
  [2196] = 2168,
  [2197] = 1733,
  [2198] = 2146,
  [2199] = 1776,
  [2200] = 1731,
  [2201] = 1746,
  [2202] = 1764,
  [2203] = 1765,
  [2204] = 1732,
  [2205] = 1726,
  [2206] = 1738,
  [2207] = 1744,
  [2208] = 1736,
  [2209] = 1741,
  [2210] = 1742,
  [2211] = 1690,
  [2212] = 1713,
  [2213] = 1758,
  [2214] = 1769,
  [2215] = 1725,
  [2216] = 1745,
  [2217] = 1763,
  [2218] = 2218,
  [2219] = 1722,
  [2220] = 1723,
  [2221] = 1773,
  [2222] = 1691,
  [2223] = 1652,
  [2224] = 1653,
  [2225] = 1654,
  [2226] = 2226,
  [2227] = 1655,
  [2228] = 1656,
  [2229] = 2229,
  [2230] = 1786,
  [2231] = 2231,
  [2232] = 2218,
  [2233] = 1657,
  [2234] = 1658,
  [2235] = 1660,
  [2236] = 1661,
  [2237] = 2237,
  [2238] = 2168,
  [2239] = 1662,
  [2240] = 1663,
  [2241] = 1664,
  [2242] = 1665,
  [2243] = 2243,
  [2244] = 2168,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2168,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2168,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2168,
  [2258] = 1720,
  [2259] = 2259,
  [2260] = 2260,
  [2261] = 1770,
  [2262] = 1771,
  [2263] = 1774,
  [2264] = 1775,
  [2265] = 2265,
  [2266] = 2139,
  [2267] = 1724,
  [2268] = 2268,
  [2269] = 2139,
  [2270] = 2270,
  [2271] = 2141,
  [2272] = 1686,
  [2273] = 2273,
  [2274] = 2229,
  [2275] = 2183,
  [2276] = 2249,
  [2277] = 2277,
  [2278] = 2277,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 1687,
  [2287] = 244,
  [2288] = 2288,
  [2289] = 1667,
  [2290] = 1659,
  [2291] = 1666,
  [2292] = 1671,
  [2293] = 1672,
  [2294] = 1673,
  [2295] = 1674,
  [2296] = 1676,
  [2297] = 1677,
  [2298] = 2298,
  [2299] = 1616,
  [2300] = 1872,
  [2301] = 2279,
  [2302] = 1703,
  [2303] = 2280,
  [2304] = 2304,
  [2305] = 2139,
  [2306] = 2231,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 245,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2281,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2141,
  [2318] = 2182,
  [2319] = 2319,
  [2320] = 1678,
  [2321] = 1679,
  [2322] = 2322,
  [2323] = 2323,
  [2324] = 2324,
  [2325] = 2325,
  [2326] = 2326,
  [2327] = 2282,
  [2328] = 2283,
  [2329] = 2251,
  [2330] = 1800,
  [2331] = 226,
  [2332] = 1692,
  [2333] = 2141,
  [2334] = 1696,
  [2335] = 1707,
  [2336] = 1855,
  [2337] = 2337,
  [2338] = 1872,
  [2339] = 244,
  [2340] = 245,
  [2341] = 246,
  [2342] = 247,
  [2343] = 249,
  [2344] = 249,
  [2345] = 250,
  [2346] = 251,
  [2347] = 252,
  [2348] = 235,
  [2349] = 221,
  [2350] = 222,
  [2351] = 1708,
  [2352] = 1709,
  [2353] = 2139,
  [2354] = 250,
  [2355] = 2141,
  [2356] = 2356,
  [2357] = 1705,
  [2358] = 2358,
  [2359] = 2034,
  [2360] = 1855,
  [2361] = 1616,
  [2362] = 2362,
  [2363] = 1872,
  [2364] = 2364,
  [2365] = 2034,
  [2366] = 1647,
  [2367] = 1639,
  [2368] = 2368,
  [2369] = 2369,
  [2370] = 2370,
  [2371] = 2371,
  [2372] = 238,
  [2373] = 2373,
  [2374] = 2374,
  [2375] = 1855,
  [2376] = 1697,
  [2377] = 2377,
  [2378] = 2378,
  [2379] = 1616,
  [2380] = 1628,
  [2381] = 238,
  [2382] = 2382,
  [2383] = 1581,
  [2384] = 2384,
  [2385] = 2385,
  [2386] = 2373,
  [2387] = 2387,
  [2388] = 2388,
  [2389] = 2368,
  [2390] = 2382,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2393,
  [2394] = 1862,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 1766,
  [2398] = 1767,
  [2399] = 1768,
  [2400] = 1777,
  [2401] = 1779,
  [2402] = 1780,
  [2403] = 1781,
  [2404] = 1733,
  [2405] = 1776,
  [2406] = 1731,
  [2407] = 1746,
  [2408] = 1764,
  [2409] = 1765,
  [2410] = 1732,
  [2411] = 1726,
  [2412] = 1738,
  [2413] = 1744,
  [2414] = 1736,
  [2415] = 1741,
  [2416] = 1742,
  [2417] = 1758,
  [2418] = 1769,
  [2419] = 1725,
  [2420] = 1745,
  [2421] = 1763,
  [2422] = 1773,
  [2423] = 2423,
  [2424] = 2374,
  [2425] = 1766,
  [2426] = 1767,
  [2427] = 1768,
  [2428] = 1777,
  [2429] = 1779,
  [2430] = 1780,
  [2431] = 1781,
  [2432] = 1733,
  [2433] = 1776,
  [2434] = 1731,
  [2435] = 1746,
  [2436] = 1764,
  [2437] = 1765,
  [2438] = 1732,
  [2439] = 1726,
  [2440] = 1738,
  [2441] = 1744,
  [2442] = 1736,
  [2443] = 1741,
  [2444] = 1742,
  [2445] = 1758,
  [2446] = 1769,
  [2447] = 1725,
  [2448] = 1745,
  [2449] = 1872,
  [2450] = 1773,
  [2451] = 2451,
  [2452] = 2452,
  [2453] = 1823,
  [2454] = 2454,
  [2455] = 2243,
  [2456] = 2454,
  [2457] = 1628,
  [2458] = 2374,
  [2459] = 1581,
  [2460] = 2460,
  [2461] = 2387,
  [2462] = 2462,
  [2463] = 1695,
  [2464] = 1698,
  [2465] = 1702,
  [2466] = 2466,
  [2467] = 2374,
  [2468] = 2468,
  [2469] = 1770,
  [2470] = 1771,
  [2471] = 1774,
  [2472] = 1775,
  [2473] = 2473,
  [2474] = 1872,
  [2475] = 1770,
  [2476] = 1771,
  [2477] = 1774,
  [2478] = 1775,
  [2479] = 2034,
  [2480] = 2370,
  [2481] = 2481,
  [2482] = 1649,
  [2483] = 1614,
  [2484] = 2484,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 2374,
  [2488] = 1786,
  [2489] = 1872,
  [2490] = 2374,
  [2491] = 1705,
  [2492] = 1697,
  [2493] = 1714,
  [2494] = 2388,
  [2495] = 1698,
  [2496] = 2496,
  [2497] = 1766,
  [2498] = 1767,
  [2499] = 1768,
  [2500] = 1777,
  [2501] = 1779,
  [2502] = 1780,
  [2503] = 1781,
  [2504] = 1733,
  [2505] = 1776,
  [2506] = 1731,
  [2507] = 1746,
  [2508] = 1764,
  [2509] = 1765,
  [2510] = 1732,
  [2511] = 1726,
  [2512] = 1738,
  [2513] = 1744,
  [2514] = 1736,
  [2515] = 1741,
  [2516] = 1742,
  [2517] = 1758,
  [2518] = 1769,
  [2519] = 1725,
  [2520] = 1745,
  [2521] = 1763,
  [2522] = 1773,
  [2523] = 1770,
  [2524] = 1771,
  [2525] = 1774,
  [2526] = 1775,
  [2527] = 2527,
  [2528] = 1872,
  [2529] = 1616,
  [2530] = 1763,
  [2531] = 1697,
  [2532] = 1773,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2540,
  [2541] = 2535,
  [2542] = 2542,
  [2543] = 2535,
  [2544] = 1786,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2547,
  [2548] = 2535,
  [2549] = 2549,
  [2550] = 2550,
  [2551] = 1872,
  [2552] = 2539,
  [2553] = 2535,
  [2554] = 2535,
  [2555] = 1766,
  [2556] = 1616,
  [2557] = 1767,
  [2558] = 1768,
  [2559] = 1695,
  [2560] = 1698,
  [2561] = 1702,
  [2562] = 2562,
  [2563] = 2535,
  [2564] = 1777,
  [2565] = 1779,
  [2566] = 2566,
  [2567] = 990,
  [2568] = 2568,
  [2569] = 2569,
  [2570] = 978,
  [2571] = 1780,
  [2572] = 997,
  [2573] = 1781,
  [2574] = 1745,
  [2575] = 1763,
  [2576] = 1628,
  [2577] = 1581,
  [2578] = 2034,
  [2579] = 1733,
  [2580] = 1776,
  [2581] = 1731,
  [2582] = 1746,
  [2583] = 1764,
  [2584] = 2584,
  [2585] = 1765,
  [2586] = 1732,
  [2587] = 1726,
  [2588] = 2588,
  [2589] = 2589,
  [2590] = 1738,
  [2591] = 2591,
  [2592] = 2592,
  [2593] = 1744,
  [2594] = 2535,
  [2595] = 1736,
  [2596] = 2596,
  [2597] = 1770,
  [2598] = 1771,
  [2599] = 1774,
  [2600] = 1775,
  [2601] = 1741,
  [2602] = 1742,
  [2603] = 1758,
  [2604] = 1705,
  [2605] = 2605,
  [2606] = 1769,
  [2607] = 2607,
  [2608] = 2608,
  [2609] = 2609,
  [2610] = 2535,
  [2611] = 1714,
  [2612] = 2535,
  [2613] = 1725,
  [2614] = 1697,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2159,
  [2618] = 2618,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2158,
  [2623] = 2159,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 2627,
  [2628] = 2628,
  [2629] = 2629,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 2633,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 2158,
  [2637] = 2159,
  [2638] = 229,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 1855,
  [2642] = 2642,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2648,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2655,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 234,
  [2661] = 2158,
  [2662] = 2468,
  [2663] = 2159,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2666,
  [2667] = 2667,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 233,
  [2673] = 2673,
  [2674] = 229,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 236,
  [2678] = 2678,
  [2679] = 2679,
  [2680] = 2680,
  [2681] = 234,
  [2682] = 2682,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 2158,
  [2687] = 2159,
  [2688] = 2688,
  [2689] = 2689,
  [2690] = 2158,
  [2691] = 2159,
  [2692] = 2692,
  [2693] = 2693,
  [2694] = 2694,
  [2695] = 2695,
  [2696] = 2696,
  [2697] = 2669,
  [2698] = 2698,
  [2699] = 2699,
  [2700] = 2158,
  [2701] = 2701,
  [2702] = 1616,
  [2703] = 1616,
  [2704] = 1616,
  [2705] = 2705,
  [2706] = 2706,
  [2707] = 2707,
  [2708] = 233,
  [2709] = 2707,
  [2710] = 2707,
  [2711] = 1658,
  [2712] = 1613,
  [2713] = 236,
  [2714] = 2707,
  [2715] = 2715,
  [2716] = 2707,
  [2717] = 2707,
  [2718] = 1234,
  [2719] = 2707,
  [2720] = 2720,
  [2721] = 2707,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2707,
  [2725] = 2725,
  [2726] = 1701,
  [2727] = 1706,
  [2728] = 2728,
  [2729] = 2707,
  [2730] = 1610,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2605,
  [2734] = 2596,
  [2735] = 2735,
  [2736] = 2736,
  [2737] = 2737,
  [2738] = 2738,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2154,
  [2742] = 2742,
  [2743] = 2268,
  [2744] = 2128,
  [2745] = 1258,
  [2746] = 2746,
  [2747] = 2265,
  [2748] = 2748,
  [2749] = 2388,
  [2750] = 2387,
  [2751] = 2486,
  [2752] = 2484,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2484,
  [2756] = 2466,
  [2757] = 2391,
  [2758] = 2473,
  [2759] = 2759,
  [2760] = 2496,
  [2761] = 2473,
  [2762] = 2368,
  [2763] = 2753,
  [2764] = 2481,
  [2765] = 2765,
  [2766] = 2388,
  [2767] = 2462,
  [2768] = 2391,
  [2769] = 2387,
  [2770] = 2466,
  [2771] = 2771,
  [2772] = 2373,
  [2773] = 2773,
  [2774] = 1266,
  [2775] = 2423,
  [2776] = 2759,
  [2777] = 2368,
  [2778] = 2373,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2780,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2784,
  [2785] = 2784,
  [2786] = 2786,
  [2787] = 2786,
  [2788] = 2788,
  [2789] = 2782,
  [2790] = 2790,
  [2791] = 2790,
  [2792] = 2792,
  [2793] = 2779,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2795,
  [2798] = 2786,
  [2799] = 2799,
  [2800] = 2800,
  [2801] = 1345,
  [2802] = 2802,
  [2803] = 1308,
  [2804] = 2485,
  [2805] = 2805,
  [2806] = 1339,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2811,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 1278,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 1296,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2827,
  [2829] = 2829,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2832,
  [2833] = 2833,
  [2834] = 2834,
  [2835] = 2835,
  [2836] = 2836,
  [2837] = 2837,
  [2838] = 2838,
  [2839] = 2839,
  [2840] = 2840,
  [2841] = 2841,
  [2842] = 2830,
  [2843] = 2843,
  [2844] = 2844,
  [2845] = 2845,
  [2846] = 2846,
  [2847] = 2847,
  [2848] = 2848,
  [2849] = 2829,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2852,
  [2853] = 2853,
  [2854] = 2824,
  [2855] = 2855,
  [2856] = 2856,
  [2857] = 2857,
  [2858] = 2826,
  [2859] = 2859,
  [2860] = 2860,
  [2861] = 2861,
  [2862] = 2856,
  [2863] = 2863,
  [2864] = 2834,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2868,
  [2869] = 2831,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2876,
  [2877] = 2870,
  [2878] = 2840,
  [2879] = 2879,
  [2880] = 2839,
  [2881] = 2881,
  [2882] = 2835,
  [2883] = 2883,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 1511,
  [2887] = 1505,
  [2888] = 1506,
  [2889] = 1584,
  [2890] = 1599,
  [2891] = 1590,
  [2892] = 1603,
  [2893] = 1600,
  [2894] = 1644,
  [2895] = 1650,
  [2896] = 1636,
  [2897] = 1595,
  [2898] = 1631,
  [2899] = 1544,
  [2900] = 1555,
  [2901] = 1575,
  [2902] = 1583,
  [2903] = 1637,
  [2904] = 1609,
  [2905] = 1602,
  [2906] = 1608,
  [2907] = 1648,
  [2908] = 1596,
  [2909] = 1638,
  [2910] = 1587,
  [2911] = 1604,
  [2912] = 1594,
  [2913] = 1645,
  [2914] = 1605,
  [2915] = 1586,
  [2916] = 1632,
  [2917] = 1633,
  [2918] = 1634,
  [2919] = 1543,
  [2920] = 1606,
  [2921] = 1593,
  [2922] = 1585,
  [2923] = 230,
  [2924] = 227,
  [2925] = 1554,
  [2926] = 1551,
  [2927] = 1564,
  [2928] = 1548,
  [2929] = 1565,
  [2930] = 1552,
  [2931] = 1559,
  [2932] = 1563,
  [2933] = 1510,
  [2934] = 2934,
  [2935] = 1506,
  [2936] = 1511,
  [2937] = 1505,
  [2938] = 1635,
  [2939] = 1643,
  [2940] = 1531,
  [2941] = 1580,
  [2942] = 1619,
  [2943] = 1520,
  [2944] = 1582,
  [2945] = 1514,
  [2946] = 1598,
  [2947] = 1515,
  [2948] = 1517,
  [2949] = 1518,
  [2950] = 1617,
  [2951] = 1592,
  [2952] = 1569,
  [2953] = 1573,
  [2954] = 1597,
  [2955] = 1557,
  [2956] = 1641,
  [2957] = 1586,
  [2958] = 1587,
  [2959] = 1590,
  [2960] = 1650,
  [2961] = 1593,
  [2962] = 1594,
  [2963] = 1595,
  [2964] = 1596,
  [2965] = 1599,
  [2966] = 1600,
  [2967] = 1603,
  [2968] = 1604,
  [2969] = 1605,
  [2970] = 1609,
  [2971] = 1632,
  [2972] = 1633,
  [2973] = 1634,
  [2974] = 1636,
  [2975] = 1637,
  [2976] = 1638,
  [2977] = 1644,
  [2978] = 1645,
  [2979] = 1648,
  [2980] = 1543,
  [2981] = 1606,
  [2982] = 1631,
  [2983] = 1544,
  [2984] = 1555,
  [2985] = 1575,
  [2986] = 1583,
  [2987] = 1584,
  [2988] = 1585,
  [2989] = 1602,
  [2990] = 1608,
  [2991] = 2991,
  [2992] = 2992,
  [2993] = 1510,
  [2994] = 2994,
  [2995] = 2995,
  [2996] = 1612,
  [2997] = 1615,
  [2998] = 1621,
  [2999] = 1622,
  [3000] = 2991,
  [3001] = 2992,
  [3002] = 2994,
  [3003] = 2995,
  [3004] = 1545,
  [3005] = 1618,
  [3006] = 1640,
  [3007] = 1574,
  [3008] = 1530,
  [3009] = 1625,
  [3010] = 1532,
  [3011] = 2991,
  [3012] = 2992,
  [3013] = 2994,
  [3014] = 2995,
  [3015] = 3015,
  [3016] = 3015,
  [3017] = 2991,
  [3018] = 2992,
  [3019] = 2994,
  [3020] = 2995,
  [3021] = 1506,
  [3022] = 1511,
  [3023] = 1505,
  [3024] = 3015,
  [3025] = 2991,
  [3026] = 2992,
  [3027] = 2994,
  [3028] = 2995,
  [3029] = 1536,
  [3030] = 1537,
  [3031] = 1566,
  [3032] = 3015,
  [3033] = 1533,
  [3034] = 3015,
  [3035] = 3015,
  [3036] = 1623,
  [3037] = 3015,
  [3038] = 1607,
  [3039] = 1528,
  [3040] = 1538,
  [3041] = 1542,
  [3042] = 1570,
  [3043] = 1630,
  [3044] = 1535,
  [3045] = 3015,
  [3046] = 1540,
  [3047] = 1556,
  [3048] = 3015,
  [3049] = 1560,
  [3050] = 1611,
  [3051] = 1562,
  [3052] = 3015,
  [3053] = 3053,
  [3054] = 3054,
  [3055] = 3055,
  [3056] = 3056,
  [3057] = 3057,
  [3058] = 3058,
  [3059] = 3059,
  [3060] = 3060,
  [3061] = 3061,
  [3062] = 3062,
  [3063] = 3054,
  [3064] = 3064,
  [3065] = 3065,
  [3066] = 3066,
  [3067] = 3067,
  [3068] = 3068,
  [3069] = 3054,
  [3070] = 3054,
  [3071] = 3058,
  [3072] = 3054,
  [3073] = 1520,
  [3074] = 3058,
  [3075] = 1518,
  [3076] = 1519,
  [3077] = 1527,
  [3078] = 3058,
  [3079] = 1526,
  [3080] = 3080,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 3083,
  [3084] = 3054,
  [3085] = 3058,
  [3086] = 3086,
  [3087] = 3087,
  [3088] = 3088,
  [3089] = 3089,
  [3090] = 3090,
  [3091] = 3091,
  [3092] = 3092,
  [3093] = 3054,
  [3094] = 1627,
  [3095] = 1510,
  [3096] = 1635,
  [3097] = 1643,
  [3098] = 1531,
  [3099] = 1548,
  [3100] = 1551,
  [3101] = 1552,
  [3102] = 1554,
  [3103] = 1559,
  [3104] = 1563,
  [3105] = 1564,
  [3106] = 1565,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 990,
  [3110] = 1620,
  [3111] = 978,
  [3112] = 997,
  [3113] = 3113,
  [3114] = 1541,
  [3115] = 1553,
  [3116] = 1619,
  [3117] = 3117,
  [3118] = 3118,
  [3119] = 3119,
  [3120] = 3120,
  [3121] = 1517,
  [3122] = 3122,
  [3123] = 1586,
  [3124] = 1587,
  [3125] = 1590,
  [3126] = 1650,
  [3127] = 1593,
  [3128] = 1594,
  [3129] = 1595,
  [3130] = 1596,
  [3131] = 1599,
  [3132] = 1600,
  [3133] = 1603,
  [3134] = 1642,
  [3135] = 1605,
  [3136] = 1609,
  [3137] = 1632,
  [3138] = 1633,
  [3139] = 1634,
  [3140] = 1636,
  [3141] = 1637,
  [3142] = 1638,
  [3143] = 1644,
  [3144] = 1645,
  [3145] = 1648,
  [3146] = 1543,
  [3147] = 1606,
  [3148] = 1631,
  [3149] = 1544,
  [3150] = 1555,
  [3151] = 1575,
  [3152] = 1583,
  [3153] = 1584,
  [3154] = 1585,
  [3155] = 1602,
  [3156] = 1608,
  [3157] = 3157,
  [3158] = 3158,
  [3159] = 1529,
  [3160] = 3160,
  [3161] = 1572,
  [3162] = 1580,
  [3163] = 1561,
  [3164] = 1568,
  [3165] = 1558,
  [3166] = 1604,
  [3167] = 1518,
  [3168] = 3168,
  [3169] = 1526,
  [3170] = 1527,
  [3171] = 3171,
  [3172] = 3172,
  [3173] = 1174,
  [3174] = 3174,
  [3175] = 1598,
  [3176] = 3176,
  [3177] = 3177,
  [3178] = 3178,
  [3179] = 1167,
  [3180] = 3180,
  [3181] = 3181,
  [3182] = 3182,
  [3183] = 3183,
  [3184] = 3184,
  [3185] = 1165,
  [3186] = 3186,
  [3187] = 3187,
  [3188] = 3188,
  [3189] = 1520,
  [3190] = 3190,
  [3191] = 3191,
  [3192] = 3192,
  [3193] = 3193,
  [3194] = 3194,
  [3195] = 3195,
  [3196] = 1519,
  [3197] = 3197,
  [3198] = 3198,
  [3199] = 1617,
  [3200] = 3200,
  [3201] = 1514,
  [3202] = 3202,
  [3203] = 3203,
  [3204] = 3204,
  [3205] = 3205,
  [3206] = 1506,
  [3207] = 3207,
  [3208] = 1511,
  [3209] = 1505,
  [3210] = 3210,
  [3211] = 3211,
  [3212] = 3212,
  [3213] = 3213,
  [3214] = 3211,
  [3215] = 3215,
  [3216] = 1582,
  [3217] = 3217,
  [3218] = 3211,
  [3219] = 3211,
  [3220] = 3211,
  [3221] = 3221,
  [3222] = 3222,
  [3223] = 3223,
  [3224] = 1515,
  [3225] = 1618,
  [3226] = 990,
  [3227] = 3227,
  [3228] = 1635,
  [3229] = 1643,
  [3230] = 1607,
  [3231] = 1531,
  [3232] = 1641,
  [3233] = 1535,
  [3234] = 3234,
  [3235] = 1528,
  [3236] = 1548,
  [3237] = 1551,
  [3238] = 1552,
  [3239] = 1554,
  [3240] = 1559,
  [3241] = 1563,
  [3242] = 1564,
  [3243] = 1565,
  [3244] = 1538,
  [3245] = 1623,
  [3246] = 978,
  [3247] = 1574,
  [3248] = 1542,
  [3249] = 1545,
  [3250] = 1540,
  [3251] = 1556,
  [3252] = 1625,
  [3253] = 1560,
  [3254] = 1561,
  [3255] = 1557,
  [3256] = 1558,
  [3257] = 1562,
  [3258] = 1568,
  [3259] = 1569,
  [3260] = 1510,
  [3261] = 997,
  [3262] = 1533,
  [3263] = 1572,
  [3264] = 1573,
  [3265] = 715,
  [3266] = 714,
  [3267] = 1630,
  [3268] = 3268,
  [3269] = 1612,
  [3270] = 1615,
  [3271] = 1620,
  [3272] = 1621,
  [3273] = 1622,
  [3274] = 1627,
  [3275] = 711,
  [3276] = 1517,
  [3277] = 1640,
  [3278] = 1580,
  [3279] = 1619,
  [3280] = 1536,
  [3281] = 3281,
  [3282] = 3176,
  [3283] = 1592,
  [3284] = 1537,
  [3285] = 1566,
  [3286] = 1597,
  [3287] = 712,
  [3288] = 713,
  [3289] = 1541,
  [3290] = 1553,
  [3291] = 1530,
  [3292] = 1611,
  [3293] = 1529,
  [3294] = 1532,
  [3295] = 1642,
  [3296] = 1570,
  [3297] = 1526,
  [3298] = 1510,
  [3299] = 1617,
  [3300] = 3300,
  [3301] = 3301,
  [3302] = 1519,
  [3303] = 1527,
  [3304] = 3304,
  [3305] = 3305,
  [3306] = 3306,
  [3307] = 3300,
  [3308] = 3308,
  [3309] = 3309,
  [3310] = 3308,
  [3311] = 3311,
  [3312] = 3308,
  [3313] = 3309,
  [3314] = 1514,
  [3315] = 1582,
  [3316] = 1598,
  [3317] = 3317,
  [3318] = 3318,
  [3319] = 1518,
  [3320] = 3320,
  [3321] = 3321,
  [3322] = 3309,
  [3323] = 1515,
  [3324] = 3324,
  [3325] = 3325,
  [3326] = 3326,
  [3327] = 3321,
  [3328] = 1642,
  [3329] = 3329,
  [3330] = 3330,
  [3331] = 3331,
  [3332] = 3332,
  [3333] = 3333,
  [3334] = 3334,
  [3335] = 3335,
  [3336] = 3336,
  [3337] = 3337,
  [3338] = 3338,
  [3339] = 3339,
  [3340] = 3340,
  [3341] = 1641,
  [3342] = 3342,
  [3343] = 3343,
  [3344] = 3344,
  [3345] = 3345,
  [3346] = 3346,
  [3347] = 3211,
  [3348] = 3348,
  [3349] = 3349,
  [3350] = 3350,
  [3351] = 3351,
  [3352] = 3352,
  [3353] = 3353,
  [3354] = 3354,
  [3355] = 3355,
  [3356] = 3356,
  [3357] = 3357,
  [3358] = 1518,
  [3359] = 3359,
  [3360] = 3360,
  [3361] = 3361,
  [3362] = 3362,
  [3363] = 1607,
  [3364] = 1535,
  [3365] = 1528,
  [3366] = 3366,
  [3367] = 1618,
  [3368] = 1574,
  [3369] = 1625,
  [3370] = 1533,
  [3371] = 3211,
  [3372] = 3372,
  [3373] = 3326,
  [3374] = 3374,
  [3375] = 3375,
  [3376] = 3352,
  [3377] = 3318,
  [3378] = 713,
  [3379] = 3379,
  [3380] = 3380,
  [3381] = 3333,
  [3382] = 3382,
  [3383] = 1623,
  [3384] = 3384,
  [3385] = 1630,
  [3386] = 3386,
  [3387] = 1592,
  [3388] = 1529,
  [3389] = 1540,
  [3390] = 3382,
  [3391] = 1556,
  [3392] = 1560,
  [3393] = 1561,
  [3394] = 1562,
  [3395] = 1568,
  [3396] = 1569,
  [3397] = 1597,
  [3398] = 1174,
  [3399] = 3399,
  [3400] = 3400,
  [3401] = 3401,
  [3402] = 3334,
  [3403] = 3403,
  [3404] = 3404,
  [3405] = 715,
  [3406] = 1541,
  [3407] = 1640,
  [3408] = 1553,
  [3409] = 3409,
  [3410] = 1530,
  [3411] = 3411,
  [3412] = 1532,
  [3413] = 3413,
  [3414] = 3414,
  [3415] = 3415,
  [3416] = 3416,
  [3417] = 1520,
  [3418] = 1538,
  [3419] = 3419,
  [3420] = 3420,
  [3421] = 1542,
  [3422] = 1545,
  [3423] = 1557,
  [3424] = 1558,
  [3425] = 3425,
  [3426] = 3426,
  [3427] = 3427,
  [3428] = 3428,
  [3429] = 1167,
  [3430] = 1570,
  [3431] = 1572,
  [3432] = 1573,
  [3433] = 714,
  [3434] = 3434,
  [3435] = 3336,
  [3436] = 1612,
  [3437] = 1615,
  [3438] = 1620,
  [3439] = 1165,
  [3440] = 1621,
  [3441] = 1622,
  [3442] = 1627,
  [3443] = 3211,
  [3444] = 711,
  [3445] = 3333,
  [3446] = 3446,
  [3447] = 1536,
  [3448] = 1537,
  [3449] = 1566,
  [3450] = 712,
  [3451] = 3451,
  [3452] = 3452,
  [3453] = 3337,
  [3454] = 1611,
  [3455] = 227,
  [3456] = 3345,
  [3457] = 3457,
  [3458] = 1174,
  [3459] = 230,
  [3460] = 3325,
  [3461] = 3461,
  [3462] = 3462,
  [3463] = 1167,
  [3464] = 3211,
  [3465] = 1165,
  [3466] = 3211,
  [3467] = 3467,
  [3468] = 3211,
  [3469] = 3469,
  [3470] = 3361,
  [3471] = 3334,
  [3472] = 3472,
  [3473] = 3473,
  [3474] = 3474,
  [3475] = 3475,
  [3476] = 1517,
  [3477] = 3477,
  [3478] = 3475,
  [3479] = 3176,
  [3480] = 3480,
  [3481] = 1519,
  [3482] = 3480,
  [3483] = 213,
  [3484] = 3484,
  [3485] = 3485,
  [3486] = 3486,
  [3487] = 3475,
  [3488] = 3475,
  [3489] = 3480,
  [3490] = 3490,
  [3491] = 3491,
  [3492] = 3492,
  [3493] = 3480,
  [3494] = 3494,
  [3495] = 3480,
  [3496] = 3496,
  [3497] = 3475,
  [3498] = 1526,
  [3499] = 227,
  [3500] = 3500,
  [3501] = 3501,
  [3502] = 230,
  [3503] = 990,
  [3504] = 1527,
  [3505] = 3505,
  [3506] = 3475,
  [3507] = 978,
  [3508] = 997,
  [3509] = 3480,
  [3510] = 214,
  [3511] = 3484,
  [3512] = 3512,
  [3513] = 3480,
  [3514] = 3480,
  [3515] = 3318,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3518,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3521,
  [3522] = 3522,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3525,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 231,
  [3534] = 232,
  [3535] = 3535,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3542,
  [3543] = 3543,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 3549,
  [3550] = 3550,
  [3551] = 1541,
  [3552] = 1553,
  [3553] = 1572,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 3559,
  [3560] = 3560,
  [3561] = 3561,
  [3562] = 3562,
  [3563] = 3560,
  [3564] = 3560,
  [3565] = 3565,
  [3566] = 3566,
  [3567] = 3567,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 3571,
  [3572] = 3572,
  [3573] = 3573,
  [3574] = 3574,
  [3575] = 3575,
  [3576] = 3576,
  [3577] = 3532,
  [3578] = 3560,
  [3579] = 3579,
  [3580] = 3580,
  [3581] = 3581,
  [3582] = 3582,
  [3583] = 3527,
  [3584] = 3527,
  [3585] = 3585,
  [3586] = 3586,
  [3587] = 3587,
  [3588] = 3588,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 217,
  [3593] = 3593,
  [3594] = 3560,
  [3595] = 3595,
  [3596] = 3554,
  [3597] = 3597,
  [3598] = 3598,
  [3599] = 3599,
  [3600] = 3527,
  [3601] = 3379,
  [3602] = 3602,
  [3603] = 3603,
  [3604] = 3604,
  [3605] = 3605,
  [3606] = 3517,
  [3607] = 3607,
  [3608] = 3527,
  [3609] = 3609,
  [3610] = 3527,
  [3611] = 3611,
  [3612] = 3305,
  [3613] = 3613,
  [3614] = 3527,
  [3615] = 3457,
  [3616] = 3616,
  [3617] = 3617,
  [3618] = 3560,
  [3619] = 3619,
  [3620] = 1642,
  [3621] = 3621,
  [3622] = 3622,
  [3623] = 3623,
  [3624] = 3624,
  [3625] = 3625,
  [3626] = 3626,
  [3627] = 3627,
  [3628] = 3628,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3631,
  [3632] = 3632,
  [3633] = 3633,
  [3634] = 3634,
  [3635] = 1529,
  [3636] = 1561,
  [3637] = 1568,
  [3638] = 3638,
  [3639] = 3639,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3642,
  [3643] = 3643,
  [3644] = 3644,
  [3645] = 3645,
  [3646] = 3646,
  [3647] = 3613,
  [3648] = 3648,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3625,
  [3652] = 3652,
  [3653] = 3653,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3234,
  [3659] = 3659,
  [3660] = 3613,
  [3661] = 3661,
  [3662] = 3662,
  [3663] = 1519,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3666,
  [3667] = 1526,
  [3668] = 3668,
  [3669] = 3517,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3598,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 3674,
  [3677] = 3677,
  [3678] = 3678,
  [3679] = 3666,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3684,
  [3685] = 3685,
  [3686] = 3686,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 3690,
  [3691] = 3691,
  [3692] = 3692,
  [3693] = 3693,
  [3694] = 3560,
  [3695] = 3695,
  [3696] = 3696,
  [3697] = 3697,
  [3698] = 3698,
  [3699] = 3639,
  [3700] = 1527,
  [3701] = 3701,
  [3702] = 3619,
  [3703] = 3703,
  [3704] = 3704,
  [3705] = 3705,
  [3706] = 3531,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3709,
  [3710] = 3560,
  [3711] = 3711,
  [3712] = 3712,
  [3713] = 3713,
  [3714] = 3714,
  [3715] = 3666,
  [3716] = 3716,
  [3717] = 3717,
  [3718] = 3537,
  [3719] = 3400,
  [3720] = 3720,
  [3721] = 3721,
  [3722] = 3722,
  [3723] = 3621,
  [3724] = 3724,
  [3725] = 3725,
  [3726] = 3726,
  [3727] = 3727,
  [3728] = 3728,
  [3729] = 3619,
  [3730] = 3730,
  [3731] = 3731,
  [3732] = 3732,
  [3733] = 3733,
  [3734] = 3734,
  [3735] = 3735,
  [3736] = 3386,
  [3737] = 3737,
  [3738] = 1620,
  [3739] = 3739,
  [3740] = 3740,
  [3741] = 3717,
  [3742] = 3742,
  [3743] = 3743,
  [3744] = 3519,
  [3745] = 3344,
  [3746] = 3746,
  [3747] = 3716,
  [3748] = 3607,
  [3749] = 3749,
  [3750] = 3750,
  [3751] = 1558,
  [3752] = 3555,
  [3753] = 1627,
  [3754] = 3754,
  [3755] = 3755,
  [3756] = 3683,
  [3757] = 3689,
  [3758] = 3758,
  [3759] = 3759,
  [3760] = 3670,
  [3761] = 3761,
  [3762] = 3762,
  [3763] = 713,
  [3764] = 715,
  [3765] = 714,
  [3766] = 711,
  [3767] = 712,
  [3768] = 3768,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 3771,
  [3772] = 3772,
  [3773] = 3773,
  [3774] = 3771,
  [3775] = 3775,
  [3776] = 3776,
  [3777] = 3762,
  [3778] = 3778,
  [3779] = 3779,
  [3780] = 3780,
  [3781] = 3781,
  [3782] = 3782,
  [3783] = 3783,
  [3784] = 3784,
  [3785] = 3597,
  [3786] = 3786,
  [3787] = 3784,
  [3788] = 3788,
  [3789] = 3789,
  [3790] = 1558,
  [3791] = 1572,
  [3792] = 3776,
  [3793] = 3793,
  [3794] = 3794,
  [3795] = 1620,
  [3796] = 1627,
  [3797] = 3797,
  [3798] = 1541,
  [3799] = 1553,
  [3800] = 3800,
  [3801] = 3801,
  [3802] = 1642,
  [3803] = 3803,
  [3804] = 3804,
  [3805] = 3268,
  [3806] = 3806,
  [3807] = 3807,
  [3808] = 3808,
  [3809] = 3762,
  [3810] = 3783,
  [3811] = 3538,
  [3812] = 3545,
  [3813] = 3788,
  [3814] = 3789,
  [3815] = 3804,
  [3816] = 3549,
  [3817] = 3817,
  [3818] = 3794,
  [3819] = 3772,
  [3820] = 3778,
  [3821] = 3762,
  [3822] = 3783,
  [3823] = 3788,
  [3824] = 3789,
  [3825] = 3794,
  [3826] = 3762,
  [3827] = 3827,
  [3828] = 3783,
  [3829] = 3788,
  [3830] = 3789,
  [3831] = 3794,
  [3832] = 3762,
  [3833] = 3783,
  [3834] = 3788,
  [3835] = 3789,
  [3836] = 3836,
  [3837] = 3794,
  [3838] = 3794,
  [3839] = 3839,
  [3840] = 3840,
  [3841] = 3643,
  [3842] = 3326,
  [3843] = 3843,
  [3844] = 3806,
  [3845] = 3845,
  [3846] = 1529,
  [3847] = 1561,
  [3848] = 1568,
  [3849] = 3579,
  [3850] = 3845,
  [3851] = 3851,
  [3852] = 3852,
  [3853] = 3640,
  [3854] = 3817,
  [3855] = 3720,
  [3856] = 3797,
  [3857] = 3644,
  [3858] = 3858,
  [3859] = 3859,
  [3860] = 3742,
  [3861] = 3793,
  [3862] = 3722,
  [3863] = 3863,
  [3864] = 3731,
  [3865] = 3865,
  [3866] = 3803,
  [3867] = 3851,
  [3868] = 3868,
  [3869] = 3581,
  [3870] = 3680,
  [3871] = 3770,
  [3872] = 3586,
  [3873] = 3661,
  [3874] = 3874,
  [3875] = 3858,
  [3876] = 3876,
  [3877] = 3877,
  [3878] = 3852,
  [3879] = 3652,
  [3880] = 3693,
  [3881] = 3800,
  [3882] = 3724,
  [3883] = 3535,
  [3884] = 3884,
  [3885] = 3885,
  [3886] = 3886,
  [3887] = 3887,
  [3888] = 3888,
  [3889] = 3889,
  [3890] = 3890,
  [3891] = 3859,
  [3892] = 3892,
  [3893] = 3634,
  [3894] = 3894,
  [3895] = 3786,
  [3896] = 3788,
  [3897] = 3325,
  [3898] = 3769,
  [3899] = 3789,
  [3900] = 3900,
  [3901] = 3783,
  [3902] = 3665,
  [3903] = 3786,
  [3904] = 3769,
  [3905] = 3675,
  [3906] = 3801,
  [3907] = 3709,
  [3908] = 3746,
  [3909] = 3909,
  [3910] = 3884,
  [3911] = 3911,
  [3912] = 3912,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 3915,
  [3916] = 3916,
  [3917] = 3917,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3921,
  [3922] = 3917,
  [3923] = 3923,
  [3924] = 3924,
  [3925] = 3925,
  [3926] = 3926,
  [3927] = 3927,
  [3928] = 3928,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 3931,
  [3932] = 3932,
  [3933] = 3933,
  [3934] = 3934,
  [3935] = 3929,
  [3936] = 3936,
  [3937] = 3566,
  [3938] = 3570,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3943,
  [3944] = 3944,
  [3945] = 807,
  [3946] = 3946,
  [3947] = 3947,
  [3948] = 3948,
  [3949] = 3949,
  [3950] = 868,
  [3951] = 870,
  [3952] = 3952,
  [3953] = 3953,
  [3954] = 839,
  [3955] = 840,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 841,
  [3959] = 800,
  [3960] = 802,
  [3961] = 3961,
  [3962] = 3939,
  [3963] = 3963,
  [3964] = 3964,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 797,
  [3968] = 3968,
  [3969] = 3969,
  [3970] = 3970,
  [3971] = 3971,
  [3972] = 912,
  [3973] = 3973,
  [3974] = 3974,
  [3975] = 3975,
  [3976] = 844,
  [3977] = 845,
  [3978] = 3978,
  [3979] = 846,
  [3980] = 3980,
  [3981] = 847,
  [3982] = 3982,
  [3983] = 3983,
  [3984] = 3941,
  [3985] = 850,
  [3986] = 3986,
  [3987] = 852,
  [3988] = 853,
  [3989] = 854,
  [3990] = 793,
  [3991] = 806,
  [3992] = 808,
  [3993] = 857,
  [3994] = 3994,
  [3995] = 3995,
  [3996] = 3996,
  [3997] = 3997,
  [3998] = 3998,
  [3999] = 3999,
  [4000] = 4000,
  [4001] = 864,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 4004,
  [4005] = 4005,
  [4006] = 3944,
  [4007] = 1548,
  [4008] = 1554,
  [4009] = 3973,
  [4010] = 4010,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 3946,
  [4014] = 4014,
  [4015] = 3913,
  [4016] = 4002,
  [4017] = 4017,
  [4018] = 4018,
  [4019] = 4019,
  [4020] = 4011,
  [4021] = 4021,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 3939,
  [4025] = 4025,
  [4026] = 4026,
  [4027] = 4027,
  [4028] = 4028,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 4031,
  [4032] = 877,
  [4033] = 878,
  [4034] = 879,
  [4035] = 880,
  [4036] = 881,
  [4037] = 882,
  [4038] = 883,
  [4039] = 884,
  [4040] = 885,
  [4041] = 4041,
  [4042] = 4002,
  [4043] = 4043,
  [4044] = 4044,
  [4045] = 4045,
  [4046] = 886,
  [4047] = 887,
  [4048] = 4011,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 889,
  [4052] = 784,
  [4053] = 3728,
  [4054] = 3628,
  [4055] = 811,
  [4056] = 791,
  [4057] = 3934,
  [4058] = 890,
  [4059] = 4059,
  [4060] = 4060,
  [4061] = 4061,
  [4062] = 4062,
  [4063] = 4063,
  [4064] = 4064,
  [4065] = 4065,
  [4066] = 4066,
  [4067] = 4067,
  [4068] = 900,
  [4069] = 901,
  [4070] = 902,
  [4071] = 4002,
  [4072] = 4072,
  [4073] = 903,
  [4074] = 904,
  [4075] = 4075,
  [4076] = 905,
  [4077] = 4077,
  [4078] = 4078,
  [4079] = 906,
  [4080] = 4011,
  [4081] = 909,
  [4082] = 910,
  [4083] = 799,
  [4084] = 4084,
  [4085] = 4085,
  [4086] = 4086,
  [4087] = 928,
  [4088] = 4088,
  [4089] = 4089,
  [4090] = 4090,
  [4091] = 4091,
  [4092] = 4092,
  [4093] = 4093,
  [4094] = 4094,
  [4095] = 4095,
  [4096] = 4096,
  [4097] = 4097,
  [4098] = 917,
  [4099] = 918,
  [4100] = 919,
  [4101] = 920,
  [4102] = 922,
  [4103] = 4103,
  [4104] = 929,
  [4105] = 4105,
  [4106] = 4106,
  [4107] = 4107,
  [4108] = 4108,
  [4109] = 4109,
  [4110] = 930,
  [4111] = 4111,
  [4112] = 4112,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 4115,
  [4116] = 4116,
  [4117] = 4117,
  [4118] = 4118,
  [4119] = 4119,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 4122,
  [4123] = 4123,
  [4124] = 4124,
  [4125] = 4125,
  [4126] = 4126,
  [4127] = 4127,
  [4128] = 4128,
  [4129] = 4129,
  [4130] = 4130,
  [4131] = 3920,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 4134,
  [4135] = 4135,
  [4136] = 4136,
  [4137] = 4137,
  [4138] = 4138,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4142,
  [4143] = 3761,
  [4144] = 4144,
  [4145] = 4145,
  [4146] = 3913,
  [4147] = 4147,
  [4148] = 4148,
  [4149] = 4075,
  [4150] = 4150,
  [4151] = 4124,
  [4152] = 4152,
  [4153] = 4153,
  [4154] = 4154,
  [4155] = 4155,
  [4156] = 4156,
  [4157] = 4157,
  [4158] = 4158,
  [4159] = 3949,
  [4160] = 4142,
  [4161] = 4161,
  [4162] = 4162,
  [4163] = 4163,
  [4164] = 4158,
  [4165] = 4165,
  [4166] = 4166,
  [4167] = 4167,
  [4168] = 4168,
  [4169] = 4169,
  [4170] = 4170,
  [4171] = 4171,
  [4172] = 4172,
  [4173] = 3961,
  [4174] = 4174,
  [4175] = 4175,
  [4176] = 4176,
  [4177] = 4177,
  [4178] = 4178,
  [4179] = 4022,
  [4180] = 4180,
  [4181] = 4041,
  [4182] = 3925,
  [4183] = 4183,
  [4184] = 3971,
  [4185] = 4185,
  [4186] = 4186,
  [4187] = 3927,
  [4188] = 4188,
  [4189] = 3779,
  [4190] = 4190,
  [4191] = 3780,
  [4192] = 4192,
  [4193] = 3781,
  [4194] = 4194,
  [4195] = 4195,
  [4196] = 4196,
  [4197] = 3933,
  [4198] = 3982,
  [4199] = 4199,
  [4200] = 4200,
  [4201] = 4201,
  [4202] = 4202,
  [4203] = 4203,
  [4204] = 4165,
  [4205] = 4205,
  [4206] = 4002,
  [4207] = 4207,
  [4208] = 4208,
  [4209] = 4209,
  [4210] = 4210,
  [4211] = 4211,
  [4212] = 4212,
  [4213] = 4213,
  [4214] = 4214,
  [4215] = 4215,
  [4216] = 4216,
  [4217] = 4217,
  [4218] = 4218,
  [4219] = 4219,
  [4220] = 4220,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4223,
  [4224] = 4224,
  [4225] = 4225,
  [4226] = 3975,
  [4227] = 3920,
  [4228] = 827,
  [4229] = 4229,
  [4230] = 4230,
  [4231] = 4137,
  [4232] = 4232,
  [4233] = 4233,
  [4234] = 4075,
  [4235] = 4124,
  [4236] = 3961,
  [4237] = 4237,
  [4238] = 4238,
  [4239] = 4190,
  [4240] = 4240,
  [4241] = 4241,
  [4242] = 4242,
  [4243] = 4243,
  [4244] = 4244,
  [4245] = 4245,
  [4246] = 829,
  [4247] = 4119,
  [4248] = 4248,
  [4249] = 4249,
  [4250] = 4250,
  [4251] = 4251,
  [4252] = 4252,
  [4253] = 4253,
  [4254] = 4254,
  [4255] = 4255,
  [4256] = 4256,
  [4257] = 4257,
  [4258] = 4258,
  [4259] = 4259,
  [4260] = 4260,
  [4261] = 4261,
  [4262] = 4262,
  [4263] = 4263,
  [4264] = 4264,
  [4265] = 4265,
  [4266] = 4266,
  [4267] = 4267,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 911,
  [4271] = 4167,
  [4272] = 4168,
  [4273] = 4273,
  [4274] = 4274,
  [4275] = 4275,
  [4276] = 3964,
  [4277] = 934,
  [4278] = 4278,
  [4279] = 4279,
  [4280] = 935,
  [4281] = 4281,
  [4282] = 4282,
  [4283] = 936,
  [4284] = 4284,
  [4285] = 937,
  [4286] = 938,
  [4287] = 4287,
  [4288] = 4288,
  [4289] = 4289,
  [4290] = 4290,
  [4291] = 4291,
  [4292] = 4292,
  [4293] = 4293,
  [4294] = 4294,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4298,
  [4299] = 4299,
  [4300] = 789,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 4303,
  [4304] = 940,
  [4305] = 4305,
  [4306] = 4306,
  [4307] = 4307,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4310,
  [4311] = 4311,
  [4312] = 3966,
  [4313] = 4313,
  [4314] = 941,
  [4315] = 4315,
  [4316] = 942,
  [4317] = 4317,
  [4318] = 4318,
  [4319] = 4194,
  [4320] = 943,
  [4321] = 4321,
  [4322] = 4322,
  [4323] = 4323,
  [4324] = 4232,
  [4325] = 4229,
  [4326] = 4326,
  [4327] = 4327,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 4330,
  [4331] = 4331,
  [4332] = 4332,
  [4333] = 4176,
  [4334] = 4334,
  [4335] = 4335,
  [4336] = 4336,
  [4337] = 4337,
  [4338] = 3934,
  [4339] = 3929,
  [4340] = 4340,
  [4341] = 4005,
  [4342] = 4342,
  [4343] = 4343,
  [4344] = 3949,
  [4345] = 4345,
  [4346] = 4346,
  [4347] = 4347,
  [4348] = 4348,
  [4349] = 4349,
  [4350] = 4350,
  [4351] = 4351,
  [4352] = 243,
  [4353] = 4353,
  [4354] = 4354,
  [4355] = 4355,
  [4356] = 813,
  [4357] = 239,
  [4358] = 3743,
  [4359] = 4359,
  [4360] = 4331,
  [4361] = 4361,
  [4362] = 4362,
  [4363] = 933,
  [4364] = 939,
  [4365] = 4365,
  [4366] = 4366,
  [4367] = 4367,
  [4368] = 4368,
  [4369] = 4369,
  [4370] = 4370,
  [4371] = 4331,
  [4372] = 4372,
  [4373] = 4011,
  [4374] = 3968,
  [4375] = 819,
  [4376] = 821,
  [4377] = 4377,
  [4378] = 4138,
  [4379] = 4379,
  [4380] = 4380,
  [4381] = 4137,
  [4382] = 822,
  [4383] = 4383,
  [4384] = 4384,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4353,
  [4388] = 4388,
  [4389] = 3952,
  [4390] = 4390,
  [4391] = 4391,
  [4392] = 4392,
  [4393] = 4393,
  [4394] = 4394,
  [4395] = 4395,
  [4396] = 4396,
  [4397] = 4391,
  [4398] = 4398,
  [4399] = 4398,
  [4400] = 4400,
  [4401] = 4401,
  [4402] = 4400,
  [4403] = 4403,
  [4404] = 4404,
  [4405] = 4404,
  [4406] = 4398,
  [4407] = 3865,
  [4408] = 4408,
  [4409] = 4409,
  [4410] = 4410,
  [4411] = 4411,
  [4412] = 4396,
  [4413] = 4413,
  [4414] = 4414,
  [4415] = 4415,
  [4416] = 4400,
  [4417] = 4391,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4421,
  [4422] = 4422,
  [4423] = 4398,
  [4424] = 4424,
  [4425] = 4400,
  [4426] = 4426,
  [4427] = 4427,
  [4428] = 4396,
  [4429] = 4429,
  [4430] = 4391,
  [4431] = 4431,
  [4432] = 4404,
  [4433] = 4433,
  [4434] = 4434,
  [4435] = 3728,
  [4436] = 4410,
  [4437] = 4437,
  [4438] = 4398,
  [4439] = 4400,
  [4440] = 4404,
  [4441] = 4441,
  [4442] = 4442,
  [4443] = 4404,
  [4444] = 4390,
  [4445] = 4410,
  [4446] = 4446,
  [4447] = 4427,
  [4448] = 4403,
  [4449] = 4449,
  [4450] = 4434,
  [4451] = 3868,
  [4452] = 4437,
  [4453] = 4453,
  [4454] = 4390,
  [4455] = 4391,
  [4456] = 4456,
  [4457] = 4457,
  [4458] = 4458,
  [4459] = 4396,
  [4460] = 4398,
  [4461] = 4441,
  [4462] = 4462,
  [4463] = 4463,
  [4464] = 4446,
  [4465] = 4427,
  [4466] = 4427,
  [4467] = 4467,
  [4468] = 4468,
  [4469] = 4469,
  [4470] = 4470,
  [4471] = 4471,
  [4472] = 4458,
  [4473] = 4473,
  [4474] = 4474,
  [4475] = 4468,
  [4476] = 4476,
  [4477] = 4477,
  [4478] = 4463,
  [4479] = 4479,
  [4480] = 4480,
  [4481] = 4481,
  [4482] = 4482,
  [4483] = 4403,
  [4484] = 4410,
  [4485] = 4446,
  [4486] = 4400,
  [4487] = 4403,
  [4488] = 4488,
  [4489] = 4404,
  [4490] = 4410,
  [4491] = 4403,
  [4492] = 4492,
  [4493] = 4446,
  [4494] = 4427,
  [4495] = 4390,
  [4496] = 4424,
  [4497] = 4427,
  [4498] = 4446,
  [4499] = 4446,
  [4500] = 4390,
  [4501] = 4458,
  [4502] = 4502,
  [4503] = 4446,
  [4504] = 4504,
  [4505] = 4458,
  [4506] = 4506,
  [4507] = 4476,
  [4508] = 4458,
  [4509] = 4509,
  [4510] = 4477,
  [4511] = 4396,
  [4512] = 4398,
  [4513] = 4400,
  [4514] = 4396,
  [4515] = 4391,
  [4516] = 4480,
  [4517] = 4410,
  [4518] = 4391,
  [4519] = 4427,
  [4520] = 4458,
  [4521] = 4506,
  [4522] = 4394,
  [4523] = 4396,
  [4524] = 4458,
  [4525] = 4410,
  [4526] = 4526,
  [4527] = 4527,
  [4528] = 4528,
  [4529] = 4529,
  [4530] = 4530,
  [4531] = 4177,
  [4532] = 4532,
  [4533] = 4533,
  [4534] = 4534,
  [4535] = 4535,
  [4536] = 4536,
  [4537] = 4537,
  [4538] = 4538,
  [4539] = 4539,
  [4540] = 4540,
  [4541] = 4541,
  [4542] = 4542,
  [4543] = 4543,
  [4544] = 4544,
  [4545] = 4545,
  [4546] = 4546,
  [4547] = 3947,
  [4548] = 4548,
  [4549] = 4549,
  [4550] = 4550,
  [4551] = 4551,
  [4552] = 4552,
  [4553] = 4553,
  [4554] = 4554,
  [4555] = 4555,
  [4556] = 4556,
  [4557] = 4557,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 4560,
  [4561] = 4561,
  [4562] = 4562,
  [4563] = 4563,
  [4564] = 4564,
  [4565] = 4565,
  [4566] = 4566,
  [4567] = 4567,
  [4568] = 4568,
  [4569] = 4569,
  [4570] = 4570,
  [4571] = 4571,
  [4572] = 4572,
  [4573] = 4573,
  [4574] = 4574,
  [4575] = 4575,
  [4576] = 4576,
  [4577] = 4564,
  [4578] = 4578,
  [4579] = 4579,
  [4580] = 4580,
  [4581] = 4581,
  [4582] = 4582,
  [4583] = 4583,
  [4584] = 4584,
  [4585] = 4585,
  [4586] = 4586,
  [4587] = 4587,
  [4588] = 4565,
  [4589] = 4589,
  [4590] = 4590,
  [4591] = 4591,
  [4592] = 4592,
  [4593] = 4593,
  [4594] = 4594,
  [4595] = 4595,
  [4596] = 4596,
  [4597] = 4597,
  [4598] = 4598,
  [4599] = 4599,
  [4600] = 4600,
  [4601] = 4601,
  [4602] = 4567,
  [4603] = 4603,
  [4604] = 4553,
  [4605] = 4605,
  [4606] = 4606,
  [4607] = 4607,
  [4608] = 4608,
  [4609] = 4609,
  [4610] = 4564,
  [4611] = 4565,
  [4612] = 4567,
  [4613] = 4568,
  [4614] = 4569,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4620,
  [4621] = 4568,
  [4622] = 4622,
  [4623] = 4575,
  [4624] = 4569,
  [4625] = 4576,
  [4626] = 4626,
  [4627] = 4627,
  [4628] = 4628,
  [4629] = 4629,
  [4630] = 4630,
  [4631] = 4631,
  [4632] = 4632,
  [4633] = 4633,
  [4634] = 4634,
  [4635] = 4635,
  [4636] = 4575,
  [4637] = 4615,
  [4638] = 4638,
  [4639] = 4639,
  [4640] = 4640,
  [4641] = 4641,
  [4642] = 4642,
  [4643] = 4643,
  [4644] = 4644,
  [4645] = 4645,
  [4646] = 3680,
  [4647] = 4539,
  [4648] = 4648,
  [4649] = 4649,
  [4650] = 4650,
  [4651] = 4651,
  [4652] = 4652,
  [4653] = 4653,
  [4654] = 4567,
  [4655] = 4655,
  [4656] = 4568,
  [4657] = 4569,
  [4658] = 4658,
  [4659] = 4659,
  [4660] = 4660,
  [4661] = 4576,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4568,
  [4666] = 4569,
  [4667] = 4605,
  [4668] = 4668,
  [4669] = 4669,
  [4670] = 4670,
  [4671] = 4671,
  [4672] = 4568,
  [4673] = 4569,
  [4674] = 4576,
  [4675] = 4675,
  [4676] = 4676,
  [4677] = 4677,
  [4678] = 4542,
  [4679] = 4679,
  [4680] = 4680,
  [4681] = 4681,
  [4682] = 4682,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 4685,
  [4686] = 4686,
  [4687] = 4687,
  [4688] = 4688,
  [4689] = 4689,
  [4690] = 4690,
  [4691] = 4691,
  [4692] = 4692,
  [4693] = 4693,
  [4694] = 4694,
  [4695] = 4659,
  [4696] = 4696,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 4575,
  [4701] = 4701,
  [4702] = 4553,
  [4703] = 4551,
  [4704] = 4704,
  [4705] = 4705,
  [4706] = 4706,
  [4707] = 4707,
  [4708] = 4708,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 4711,
  [4712] = 4712,
  [4713] = 4713,
  [4714] = 801,
  [4715] = 4715,
  [4716] = 4716,
  [4717] = 4717,
  [4718] = 4718,
  [4719] = 4719,
  [4720] = 4199,
  [4721] = 4565,
  [4722] = 4722,
  [4723] = 4723,
  [4724] = 4724,
  [4725] = 4725,
  [4726] = 4726,
  [4727] = 4727,
  [4728] = 4576,
  [4729] = 4729,
  [4730] = 4730,
  [4731] = 4731,
  [4732] = 4565,
  [4733] = 4733,
  [4734] = 4734,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 4737,
  [4738] = 3643,
  [4739] = 4739,
  [4740] = 4740,
  [4741] = 4741,
  [4742] = 4742,
  [4743] = 4743,
  [4744] = 4558,
  [4745] = 4745,
  [4746] = 4746,
  [4747] = 4747,
  [4748] = 4748,
  [4749] = 4749,
  [4750] = 4750,
  [4751] = 4751,
  [4752] = 4752,
  [4753] = 4753,
  [4754] = 4754,
  [4755] = 4755,
  [4756] = 4756,
  [4757] = 4757,
  [4758] = 4758,
  [4759] = 4759,
  [4760] = 4760,
  [4761] = 4761,
  [4762] = 4762,
  [4763] = 4763,
  [4764] = 4764,
  [4765] = 4765,
  [4766] = 4766,
  [4767] = 4767,
  [4768] = 4768,
  [4769] = 4769,
  [4770] = 4770,
  [4771] = 4771,
  [4772] = 4772,
  [4773] = 4773,
  [4774] = 4774,
  [4775] = 4775,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4778,
  [4779] = 4596,
  [4780] = 4780,
  [4781] = 4781,
  [4782] = 4622,
  [4783] = 4783,
  [4784] = 4784,
  [4785] = 4785,
  [4786] = 4786,
  [4787] = 4787,
  [4788] = 4788,
  [4789] = 4789,
  [4790] = 4790,
  [4791] = 4791,
  [4792] = 4792,
  [4793] = 4793,
  [4794] = 4794,
  [4795] = 4795,
  [4796] = 4796,
  [4797] = 4797,
  [4798] = 4798,
  [4799] = 4799,
  [4800] = 4800,
  [4801] = 4801,
  [4802] = 4802,
  [4803] = 4803,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4808,
  [4809] = 4809,
  [4810] = 4810,
  [4811] = 4811,
  [4812] = 4812,
  [4813] = 1560,
  [4814] = 1597,
  [4815] = 4815,
  [4816] = 4816,
  [4817] = 4817,
  [4818] = 4818,
  [4819] = 4819,
  [4820] = 4820,
  [4821] = 4821,
  [4822] = 4822,
  [4823] = 4823,
  [4824] = 4553,
  [4825] = 4825,
  [4826] = 4559,
  [4827] = 4827,
  [4828] = 4768,
  [4829] = 4829,
  [4830] = 4771,
  [4831] = 4831,
  [4832] = 4832,
  [4833] = 4833,
  [4834] = 4834,
  [4835] = 4835,
  [4836] = 4554,
  [4837] = 4837,
  [4838] = 4838,
  [4839] = 4839,
  [4840] = 4840,
  [4841] = 4841,
  [4842] = 4842,
  [4843] = 4843,
  [4844] = 4844,
  [4845] = 4845,
  [4846] = 4846,
  [4847] = 4847,
  [4848] = 4848,
  [4849] = 4849,
  [4850] = 4850,
  [4851] = 4851,
  [4852] = 4852,
  [4853] = 4853,
  [4854] = 4854,
  [4855] = 4855,
  [4856] = 4856,
  [4857] = 4857,
  [4858] = 4858,
  [4859] = 4859,
  [4860] = 4860,
  [4861] = 4861,
  [4862] = 4537,
  [4863] = 4863,
  [4864] = 4538,
  [4865] = 4865,
  [4866] = 4866,
  [4867] = 4867,
  [4868] = 4868,
  [4869] = 4869,
  [4870] = 4870,
  [4871] = 4871,
  [4872] = 4872,
  [4873] = 4873,
  [4874] = 4874,
  [4875] = 4875,
  [4876] = 4876,
  [4877] = 4877,
  [4878] = 4878,
  [4879] = 4879,
  [4880] = 4880,
  [4881] = 4881,
  [4882] = 4882,
  [4883] = 4883,
  [4884] = 4773,
  [4885] = 4723,
  [4886] = 4886,
  [4887] = 4887,
  [4888] = 4888,
  [4889] = 4889,
  [4890] = 3865,
  [4891] = 4727,
  [4892] = 4717,
  [4893] = 4893,
  [4894] = 4894,
  [4895] = 4895,
  [4896] = 4896,
  [4897] = 4576,
  [4898] = 4898,
  [4899] = 4899,
  [4900] = 4900,
  [4901] = 4901,
  [4902] = 4902,
  [4903] = 4903,
  [4904] = 4904,
  [4905] = 4905,
  [4906] = 4906,
  [4907] = 4907,
  [4908] = 4908,
  [4909] = 4553,
  [4910] = 4910,
  [4911] = 4557,
  [4912] = 4912,
  [4913] = 4913,
  [4914] = 4914,
  [4915] = 4915,
  [4916] = 4916,
  [4917] = 4917,
  [4918] = 4918,
  [4919] = 4919,
  [4920] = 4920,
  [4921] = 4921,
  [4922] = 4659,
  [4923] = 4923,
  [4924] = 4924,
  [4925] = 4925,
  [4926] = 4926,
  [4927] = 4927,
  [4928] = 4928,
  [4929] = 4929,
  [4930] = 4930,
  [4931] = 4931,
  [4932] = 4932,
  [4933] = 4663,
  [4934] = 4664,
  [4935] = 4935,
  [4936] = 4936,
  [4937] = 4937,
  [4938] = 4938,
  [4939] = 4939,
  [4940] = 4940,
  [4941] = 4941,
  [4942] = 4942,
  [4943] = 4774,
  [4944] = 4944,
  [4945] = 4945,
  [4946] = 4946,
  [4947] = 4947,
  [4948] = 4948,
  [4949] = 4949,
  [4950] = 4950,
  [4951] = 4951,
  [4952] = 4952,
  [4953] = 4774,
  [4954] = 4954,
  [4955] = 4955,
  [4956] = 4956,
  [4957] = 4957,
  [4958] = 4596,
  [4959] = 4959,
  [4960] = 4960,
  [4961] = 4554,
  [4962] = 4962,
  [4963] = 4963,
  [4964] = 4964,
  [4965] = 4965,
  [4966] = 4966,
  [4967] = 3868,
  [4968] = 4968,
  [4969] = 4969,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4972,
  [4973] = 4973,
  [4974] = 4692,
  [4975] = 4975,
  [4976] = 4976,
  [4977] = 3742,
  [4978] = 4978,
  [4979] = 4979,
  [4980] = 4980,
  [4981] = 4981,
  [4982] = 4982,
  [4983] = 4553,
  [4984] = 4984,
  [4985] = 4985,
  [4986] = 4986,
  [4987] = 4987,
  [4988] = 4988,
  [4989] = 4989,
  [4990] = 4990,
  [4991] = 4991,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4994,
  [4995] = 3579,
  [4996] = 4996,
  [4997] = 4997,
  [4998] = 4998,
  [4999] = 4556,
  [5000] = 5000,
  [5001] = 4849,
  [5002] = 5002,
  [5003] = 4860,
  [5004] = 5004,
  [5005] = 4537,
  [5006] = 4542,
  [5007] = 5007,
  [5008] = 4556,
  [5009] = 4866,
  [5010] = 5010,
  [5011] = 5011,
  [5012] = 5012,
  [5013] = 4850,
  [5014] = 5014,
  [5015] = 5015,
  [5016] = 4868,
  [5017] = 5017,
  [5018] = 4693,
  [5019] = 5019,
  [5020] = 5020,
  [5021] = 5021,
  [5022] = 4564,
  [5023] = 5023,
  [5024] = 5024,
  [5025] = 5025,
  [5026] = 4565,
  [5027] = 5027,
  [5028] = 5028,
  [5029] = 5029,
  [5030] = 5030,
  [5031] = 5031,
  [5032] = 4701,
  [5033] = 4889,
  [5034] = 5034,
  [5035] = 4567,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 4565,
  [5039] = 5039,
  [5040] = 5040,
  [5041] = 5041,
  [5042] = 5042,
  [5043] = 5043,
  [5044] = 5044,
  [5045] = 5045,
  [5046] = 5046,
  [5047] = 5047,
  [5048] = 4568,
  [5049] = 4569,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 5052,
  [5053] = 4975,
  [5054] = 5054,
  [5055] = 5055,
  [5056] = 4617,
  [5057] = 4617,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 4618,
  [5061] = 4618,
  [5062] = 4619,
  [5063] = 4620,
  [5064] = 5064,
  [5065] = 4619,
  [5066] = 5066,
  [5067] = 5067,
  [5068] = 4620,
  [5069] = 5069,
  [5070] = 5070,
  [5071] = 5071,
  [5072] = 5072,
  [5073] = 5073,
  [5074] = 5074,
  [5075] = 5075,
  [5076] = 5076,
  [5077] = 5077,
  [5078] = 5078,
  [5079] = 5079,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 5083,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 4575,
  [5089] = 5089,
  [5090] = 5090,
  [5091] = 5091,
  [5092] = 5092,
  [5093] = 5093,
  [5094] = 5094,
  [5095] = 4576,
  [5096] = 5096,
  [5097] = 5097,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 5100,
  [5101] = 5101,
  [5102] = 5102,
  [5103] = 4683,
  [5104] = 5104,
  [5105] = 5105,
  [5106] = 5106,
  [5107] = 5107,
  [5108] = 5108,
  [5109] = 5109,
  [5110] = 4553,
  [5111] = 5111,
  [5112] = 5112,
  [5113] = 4567,
  [5114] = 5114,
  [5115] = 3728,
  [5116] = 5116,
  [5117] = 5117,
  [5118] = 5118,
  [5119] = 5119,
  [5120] = 5120,
  [5121] = 5121,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 5124,
  [5125] = 5125,
  [5126] = 5126,
  [5127] = 4564,
  [5128] = 5128,
  [5129] = 5129,
  [5130] = 5130,
  [5131] = 5131,
  [5132] = 5132,
  [5133] = 5133,
  [5134] = 5134,
  [5135] = 5135,
  [5136] = 5136,
  [5137] = 5137,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 2701,
  [5141] = 2620,
  [5142] = 5142,
  [5143] = 5143,
  [5144] = 5144,
  [5145] = 5145,
  [5146] = 2621,
  [5147] = 2671,
  [5148] = 5148,
  [5149] = 2676,
  [5150] = 5150,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 5153,
  [5154] = 5154,
  [5155] = 5155,
  [5156] = 5156,
  [5157] = 5157,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5160,
  [5161] = 5161,
  [5162] = 5162,
  [5163] = 5163,
  [5164] = 5164,
  [5165] = 2615,
  [5166] = 5166,
  [5167] = 5167,
  [5168] = 5168,
  [5169] = 5169,
  [5170] = 2625,
  [5171] = 5145,
  [5172] = 5172,
  [5173] = 5173,
  [5174] = 5174,
  [5175] = 5175,
  [5176] = 5176,
  [5177] = 5177,
  [5178] = 5143,
  [5179] = 5179,
  [5180] = 5180,
  [5181] = 5181,
  [5182] = 5182,
  [5183] = 5183,
  [5184] = 5184,
  [5185] = 5185,
  [5186] = 5186,
  [5187] = 5187,
  [5188] = 5188,
  [5189] = 5189,
  [5190] = 5148,
  [5191] = 5191,
  [5192] = 5192,
  [5193] = 5193,
  [5194] = 5194,
  [5195] = 5195,
  [5196] = 2639,
  [5197] = 5197,
  [5198] = 2642,
  [5199] = 2673,
  [5200] = 2652,
  [5201] = 5201,
  [5202] = 5181,
  [5203] = 5203,
  [5204] = 2679,
  [5205] = 5205,
  [5206] = 5206,
  [5207] = 5201,
  [5208] = 5208,
  [5209] = 5209,
  [5210] = 5185,
  [5211] = 5211,
  [5212] = 5212,
  [5213] = 5213,
  [5214] = 5214,
  [5215] = 5194,
  [5216] = 2689,
  [5217] = 5217,
  [5218] = 5218,
  [5219] = 5213,
  [5220] = 5220,
  [5221] = 5221,
  [5222] = 5222,
  [5223] = 5223,
  [5224] = 5224,
  [5225] = 5225,
  [5226] = 5226,
  [5227] = 5227,
  [5228] = 5228,
  [5229] = 5229,
  [5230] = 5213,
  [5231] = 5231,
  [5232] = 5144,
  [5233] = 5233,
  [5234] = 5222,
  [5235] = 5235,
  [5236] = 5236,
  [5237] = 2653,
  [5238] = 5164,
  [5239] = 5239,
  [5240] = 5179,
  [5241] = 5189,
  [5242] = 5242,
  [5243] = 5243,
  [5244] = 3779,
  [5245] = 5245,
  [5246] = 2643,
  [5247] = 3780,
  [5248] = 5182,
  [5249] = 5249,
  [5250] = 5250,
  [5251] = 3781,
  [5252] = 5252,
  [5253] = 5253,
  [5254] = 5254,
  [5255] = 5151,
  [5256] = 5175,
  [5257] = 5233,
  [5258] = 5258,
  [5259] = 5259,
  [5260] = 5185,
  [5261] = 5184,
  [5262] = 2634,
  [5263] = 5263,
  [5264] = 5188,
  [5265] = 5265,
  [5266] = 5164,
  [5267] = 5267,
  [5268] = 5179,
  [5269] = 5222,
  [5270] = 5189,
  [5271] = 5192,
  [5272] = 5272,
  [5273] = 5273,
  [5274] = 5243,
  [5275] = 5275,
  [5276] = 5276,
  [5277] = 5277,
  [5278] = 5277,
  [5279] = 5279,
  [5280] = 5263,
  [5281] = 5281,
  [5282] = 5282,
  [5283] = 5283,
  [5284] = 5164,
  [5285] = 5285,
  [5286] = 5286,
  [5287] = 5287,
  [5288] = 5288,
  [5289] = 5263,
  [5290] = 5290,
  [5291] = 5291,
  [5292] = 5242,
  [5293] = 5293,
  [5294] = 5294,
  [5295] = 5295,
  [5296] = 5296,
  [5297] = 5154,
  [5298] = 5298,
  [5299] = 5299,
  [5300] = 5300,
  [5301] = 5301,
  [5302] = 5302,
  [5303] = 5303,
  [5304] = 5304,
  [5305] = 5294,
  [5306] = 5306,
  [5307] = 5290,
  [5308] = 5308,
  [5309] = 5299,
  [5310] = 5310,
  [5311] = 5311,
  [5312] = 5155,
  [5313] = 5313,
  [5314] = 5314,
  [5315] = 5315,
  [5316] = 5316,
  [5317] = 5317,
  [5318] = 5318,
  [5319] = 5208,
  [5320] = 5176,
  [5321] = 5321,
  [5322] = 5217,
  [5323] = 1720,
  [5324] = 5324,
  [5325] = 5179,
  [5326] = 5235,
  [5327] = 2699,
  [5328] = 5218,
  [5329] = 5201,
  [5330] = 5313,
  [5331] = 5213,
  [5332] = 5332,
  [5333] = 5333,
  [5334] = 5334,
  [5335] = 5335,
  [5336] = 5222,
  [5337] = 5337,
  [5338] = 5338,
  [5339] = 5223,
  [5340] = 5291,
  [5341] = 5341,
  [5342] = 5342,
  [5343] = 5343,
  [5344] = 5279,
  [5345] = 5345,
  [5346] = 5156,
  [5347] = 5347,
  [5348] = 5348,
  [5349] = 5349,
  [5350] = 5350,
  [5351] = 5351,
  [5352] = 5253,
  [5353] = 5160,
  [5354] = 5354,
  [5355] = 5208,
  [5356] = 2675,
  [5357] = 5162,
  [5358] = 2678,
  [5359] = 5163,
  [5360] = 5360,
  [5361] = 5341,
  [5362] = 5283,
  [5363] = 5217,
  [5364] = 2680,
  [5365] = 5365,
  [5366] = 5366,
  [5367] = 5300,
  [5368] = 5368,
  [5369] = 5285,
  [5370] = 5185,
  [5371] = 5293,
  [5372] = 5372,
  [5373] = 5373,
  [5374] = 5321,
  [5375] = 5218,
  [5376] = 3761,
  [5377] = 5377,
  [5378] = 5164,
  [5379] = 5379,
  [5380] = 5380,
  [5381] = 5381,
  [5382] = 5343,
  [5383] = 5201,
  [5384] = 5384,
  [5385] = 5385,
  [5386] = 5167,
  [5387] = 5365,
  [5388] = 5223,
  [5389] = 5213,
  [5390] = 5189,
  [5391] = 5391,
  [5392] = 5392,
  [5393] = 5222,
  [5394] = 5394,
  [5395] = 5395,
  [5396] = 5185,
  [5397] = 5397,
  [5398] = 5179,
  [5399] = 5185,
  [5400] = 5400,
  [5401] = 5189,
  [5402] = 5226,
  [5403] = 5254,
  [5404] = 5277,
  [5405] = 5347,
  [5406] = 5174,
  [5407] = 5407,
  [5408] = 5408,
  [5409] = 5189,
  [5410] = 5392,
  [5411] = 5411,
  [5412] = 2682,
  [5413] = 5208,
  [5414] = 5208,
  [5415] = 5415,
  [5416] = 5354,
  [5417] = 5217,
  [5418] = 5217,
  [5419] = 5218,
  [5420] = 5223,
  [5421] = 5341,
  [5422] = 5218,
  [5423] = 5368,
  [5424] = 5223,
  [5425] = 5425,
  [5426] = 5201,
  [5427] = 5427,
  [5428] = 5427,
  [5429] = 5379,
  [5430] = 5394,
  [5431] = 5431,
  [5432] = 5432,
  [5433] = 5193,
  [5434] = 5434,
  [5435] = 5435,
  [5436] = 5185,
  [5437] = 5437,
  [5438] = 5152,
  [5439] = 5159,
  [5440] = 5290,
  [5441] = 5395,
  [5442] = 5176,
  [5443] = 1707,
  [5444] = 5444,
  [5445] = 5285,
  [5446] = 1708,
  [5447] = 5447,
  [5448] = 5448,
  [5449] = 5227,
  [5450] = 5450,
  [5451] = 5451,
  [5452] = 5164,
  [5453] = 5177,
  [5454] = 5183,
  [5455] = 5276,
  [5456] = 5456,
  [5457] = 5457,
  [5458] = 5324,
  [5459] = 5152,
  [5460] = 5177,
  [5461] = 5397,
  [5462] = 5195,
  [5463] = 2633,
  [5464] = 5197,
  [5465] = 5203,
  [5466] = 5466,
  [5467] = 5180,
  [5468] = 5206,
  [5469] = 5209,
  [5470] = 5164,
  [5471] = 5324,
  [5472] = 5179,
  [5473] = 5400,
  [5474] = 5397,
  [5475] = 5189,
  [5476] = 5179,
  [5477] = 5272,
  [5478] = 5478,
  [5479] = 5301,
  [5480] = 5480,
  [5481] = 5287,
  [5482] = 5482,
  [5483] = 5483,
  [5484] = 5484,
  [5485] = 5485,
  [5486] = 5486,
  [5487] = 5487,
  [5488] = 5488,
  [5489] = 5489,
  [5490] = 5490,
  [5491] = 5491,
  [5492] = 5492,
  [5493] = 5493,
  [5494] = 5494,
  [5495] = 5495,
  [5496] = 5496,
  [5497] = 5497,
  [5498] = 5498,
  [5499] = 5491,
  [5500] = 5490,
  [5501] = 5501,
  [5502] = 5502,
  [5503] = 5503,
  [5504] = 5504,
  [5505] = 5505,
  [5506] = 5506,
  [5507] = 5507,
  [5508] = 5508,
  [5509] = 5508,
  [5510] = 5510,
  [5511] = 5511,
  [5512] = 5512,
  [5513] = 5494,
  [5514] = 5491,
  [5515] = 5515,
  [5516] = 5516,
  [5517] = 5511,
  [5518] = 5518,
  [5519] = 5519,
  [5520] = 5520,
  [5521] = 5521,
  [5522] = 5522,
  [5523] = 5523,
  [5524] = 5524,
  [5525] = 5525,
  [5526] = 5526,
  [5527] = 5527,
  [5528] = 5502,
  [5529] = 5529,
  [5530] = 5530,
  [5531] = 5531,
  [5532] = 5497,
  [5533] = 5526,
  [5534] = 5520,
  [5535] = 5535,
  [5536] = 5488,
  [5537] = 5535,
  [5538] = 5538,
  [5539] = 5501,
  [5540] = 5498,
  [5541] = 5487,
  [5542] = 5542,
  [5543] = 5538,
  [5544] = 5544,
  [5545] = 5545,
  [5546] = 5522,
  [5547] = 5547,
  [5548] = 5547,
  [5549] = 5549,
  [5550] = 5508,
  [5551] = 5522,
  [5552] = 5491,
  [5553] = 5501,
  [5554] = 5502,
  [5555] = 5483,
  [5556] = 5504,
  [5557] = 5505,
  [5558] = 5506,
  [5559] = 5549,
  [5560] = 5512,
  [5561] = 5561,
  [5562] = 5562,
  [5563] = 5522,
  [5564] = 5547,
  [5565] = 5565,
  [5566] = 5491,
  [5567] = 5567,
  [5568] = 5518,
  [5569] = 5527,
  [5570] = 5570,
  [5571] = 5542,
  [5572] = 5572,
  [5573] = 5573,
  [5574] = 5574,
  [5575] = 5506,
  [5576] = 5561,
  [5577] = 5577,
  [5578] = 5578,
  [5579] = 5579,
  [5580] = 5491,
  [5581] = 5581,
  [5582] = 5522,
  [5583] = 5583,
  [5584] = 5561,
  [5585] = 5547,
  [5586] = 5527,
  [5587] = 5547,
  [5588] = 5588,
  [5589] = 5529,
  [5590] = 5549,
  [5591] = 5591,
  [5592] = 5592,
  [5593] = 5591,
  [5594] = 5594,
  [5595] = 5516,
  [5596] = 5526,
  [5597] = 5567,
  [5598] = 5598,
  [5599] = 5501,
  [5600] = 5502,
  [5601] = 5601,
  [5602] = 5602,
  [5603] = 5502,
  [5604] = 5604,
  [5605] = 5605,
  [5606] = 5606,
  [5607] = 5602,
  [5608] = 5497,
  [5609] = 5542,
  [5610] = 5610,
  [5611] = 5573,
  [5612] = 5605,
  [5613] = 5508,
  [5614] = 5501,
  [5615] = 5615,
  [5616] = 5531,
  [5617] = 5617,
  [5618] = 5502,
  [5619] = 5619,
  [5620] = 5518,
  [5621] = 5621,
  [5622] = 5610,
  [5623] = 5504,
  [5624] = 5624,
  [5625] = 5505,
  [5626] = 5626,
  [5627] = 5572,
  [5628] = 5628,
  [5629] = 5527,
  [5630] = 5506,
  [5631] = 5498,
  [5632] = 5483,
  [5633] = 5504,
  [5634] = 5526,
  [5635] = 5505,
  [5636] = 5506,
  [5637] = 5578,
  [5638] = 5535,
  [5639] = 5490,
  [5640] = 5498,
  [5641] = 5641,
  [5642] = 5588,
  [5643] = 5643,
  [5644] = 5644,
  [5645] = 5491,
  [5646] = 5501,
  [5647] = 5570,
  [5648] = 5648,
  [5649] = 5527,
  [5650] = 5491,
  [5651] = 5651,
  [5652] = 5494,
  [5653] = 5653,
  [5654] = 5654,
  [5655] = 5574,
  [5656] = 5487,
  [5657] = 5657,
  [5658] = 5658,
  [5659] = 5520,
  [5660] = 5508,
  [5661] = 5538,
  [5662] = 5535,
  [5663] = 5516,
  [5664] = 5502,
  [5665] = 5665,
  [5666] = 5529,
  [5667] = 5529,
  [5668] = 5498,
  [5669] = 5486,
  [5670] = 5510,
  [5671] = 5526,
  [5672] = 5605,
  [5673] = 5673,
  [5674] = 5674,
  [5675] = 5643,
  [5676] = 5535,
  [5677] = 5487,
  [5678] = 5547,
  [5679] = 5547,
  [5680] = 5542,
  [5681] = 5681,
  [5682] = 5682,
  [5683] = 5648,
  [5684] = 5496,
  [5685] = 5591,
  [5686] = 5602,
  [5687] = 5674,
  [5688] = 5610,
  [5689] = 5515,
  [5690] = 5674,
  [5691] = 5643,
  [5692] = 5641,
  [5693] = 5512,
  [5694] = 5694,
  [5695] = 5674,
  [5696] = 5643,
  [5697] = 5697,
  [5698] = 5698,
  [5699] = 5503,
  [5700] = 5583,
  [5701] = 5504,
  [5702] = 5487,
  [5703] = 5643,
  [5704] = 5704,
  [5705] = 5705,
  [5706] = 5706,
  [5707] = 5496,
  [5708] = 5505,
  [5709] = 5709,
  [5710] = 5710,
  [5711] = 5535,
  [5712] = 5712,
  [5713] = 5549,
  [5714] = 5601,
  [5715] = 5715,
  [5716] = 5716,
  [5717] = 5717,
  [5718] = 5718,
  [5719] = 5549,
  [5720] = 5484,
  [5721] = 5674,
  [5722] = 5698,
  [5723] = 5605,
  [5724] = 5724,
  [5725] = 5493,
  [5726] = 5506,
  [5727] = 5519,
  [5728] = 5516,
  [5729] = 5583,
  [5730] = 5501,
  [5731] = 5523,
  [5732] = 5583,
  [5733] = 5525,
  [5734] = 5487,
  [5735] = 5498,
  [5736] = 5573,
  [5737] = 5496,
  [5738] = 5706,
  [5739] = 5739,
  [5740] = 5526,
  [5741] = 5709,
  [5742] = 5715,
  [5743] = 5743,
  [5744] = 5510,
  [5745] = 5643,
  [5746] = 5717,
  [5747] = 5496,
  [5748] = 5718,
  [5749] = 5694,
  [5750] = 5484,
  [5751] = 5751,
  [5752] = 5493,
  [5753] = 5753,
  [5754] = 5598,
  [5755] = 5519,
  [5756] = 5756,
  [5757] = 5757,
  [5758] = 5758,
  [5759] = 5504,
  [5760] = 5760,
  [5761] = 5674,
  [5762] = 5643,
  [5763] = 5485,
  [5764] = 5605,
  [5765] = 5573,
  [5766] = 5523,
  [5767] = 5525,
  [5768] = 5768,
  [5769] = 5674,
  [5770] = 5770,
  [5771] = 5771,
  [5772] = 5501,
  [5773] = 5583,
  [5774] = 5583,
  [5775] = 5502,
  [5776] = 5496,
  [5777] = 5777,
  [5778] = 5644,
  [5779] = 5504,
  [5780] = 5497,
  [5781] = 5505,
  [5782] = 5483,
  [5783] = 5578,
  [5784] = 5506,
  [5785] = 5490,
  [5786] = 5628,
  [5787] = 5527,
  [5788] = 5788,
  [5789] = 5494,
  [5790] = 5529,
  [5791] = 5505,
  [5792] = 5495,
  [5793] = 5501,
  [5794] = 5520,
  [5795] = 5795,
  [5796] = 5502,
  [5797] = 5504,
  [5798] = 5605,
  [5799] = 5706,
  [5800] = 5538,
  [5801] = 5628,
  [5802] = 5504,
  [5803] = 5542,
  [5804] = 5505,
  [5805] = 5506,
  [5806] = 5709,
  [5807] = 5706,
  [5808] = 5606,
  [5809] = 5715,
  [5810] = 5516,
  [5811] = 5591,
  [5812] = 5717,
  [5813] = 5718,
  [5814] = 5491,
  [5815] = 5505,
  [5816] = 5484,
  [5817] = 5602,
  [5818] = 5493,
  [5819] = 5519,
  [5820] = 5573,
  [5821] = 5491,
  [5822] = 5822,
  [5823] = 5523,
  [5824] = 5525,
  [5825] = 5610,
  [5826] = 5518,
  [5827] = 5530,
  [5828] = 5605,
  [5829] = 5705,
  [5830] = 5628,
  [5831] = 5496,
  [5832] = 5510,
  [5833] = 5771,
  [5834] = 5834,
  [5835] = 5518,
  [5836] = 5498,
  [5837] = 5516,
  [5838] = 5706,
  [5839] = 5839,
  [5840] = 5605,
  [5841] = 5628,
  [5842] = 5506,
  [5843] = 5709,
  [5844] = 5715,
  [5845] = 5497,
  [5846] = 5709,
  [5847] = 5525,
  [5848] = 5605,
  [5849] = 5757,
  [5850] = 5578,
  [5851] = 5490,
  [5852] = 5605,
  [5853] = 5494,
  [5854] = 5715,
  [5855] = 5520,
  [5856] = 5717,
  [5857] = 5717,
  [5858] = 5718,
  [5859] = 5859,
  [5860] = 5538,
  [5861] = 5483,
  [5862] = 5862,
  [5863] = 5716,
  [5864] = 5770,
  [5865] = 5591,
  [5866] = 5602,
  [5867] = 5628,
  [5868] = 5527,
  [5869] = 5869,
  [5870] = 5484,
  [5871] = 5610,
  [5872] = 5768,
  [5873] = 5526,
  [5874] = 5594,
  [5875] = 5501,
  [5876] = 5502,
  [5877] = 5493,
  [5878] = 5561,
  [5879] = 5834,
  [5880] = 5592,
  [5881] = 5578,
  [5882] = 5882,
  [5883] = 5519,
  [5884] = 5653,
  [5885] = 5504,
  [5886] = 5598,
  [5887] = 5505,
  [5888] = 5506,
  [5889] = 5718,
  [5890] = 5628,
  [5891] = 5523,
  [5892] = 5651,
  [5893] = 5673,
  [5894] = 5583,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(77);
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 6,
        '$', 208,
        '%', 157,
        '&', 136,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 80,
        '+', 149,
        ',', 87,
        '-', 153,
        '.', 105,
        '/', 194,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 98,
        '=', 83,
        '>', 101,
        '?', 214,
        '@', 211,
        '[', 95,
        '\\', 34,
        ']', 96,
        '^', 139,
        '`', 192,
        '{', 86,
        '|', 142,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(74);
      if (lookahead > '@') ADVANCE(209);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '[') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(73);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(195);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 32,
        '%', 157,
        '&', 136,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 80,
        '+', 148,
        ',', 87,
        '-', 152,
        '.', 105,
        '/', 155,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 98,
        '=', 83,
        '>', 101,
        '?', 214,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '^', 139,
        '`', 192,
        '{', 86,
        '|', 142,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(2);
      if (lookahead > '#') ADVANCE(209);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 32,
        '%', 157,
        '&', 136,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 80,
        '+', 148,
        ',', 87,
        '-', 152,
        '.', 105,
        '/', 155,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 98,
        '=', 83,
        '>', 101,
        '?', 214,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '^', 139,
        '`', 192,
        '{', 85,
        '|', 141,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (lookahead > '#') ADVANCE(209);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 90,
        '%', 156,
        '&', 137,
        '(', 91,
        ')', 93,
        '*', 81,
        '+', 147,
        ',', 87,
        '-', 151,
        '.', 104,
        '/', 154,
        ':', 94,
        ';', 92,
        '<', 99,
        '=', 29,
        '>', 102,
        '?', 21,
        '[', 95,
        '\\', 36,
        ']', 96,
        '^', 138,
        '`', 192,
        '{', 85,
        '|', 143,
        '}', 88,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 90,
        '%', 156,
        '&', 137,
        '(', 91,
        ')', 93,
        '*', 81,
        '+', 147,
        ',', 87,
        '-', 151,
        '.', 104,
        '/', 154,
        ':', 94,
        ';', 92,
        '<', 99,
        '=', 29,
        '>', 102,
        '?', 21,
        '[', 95,
        '\\', 36,
        ']', 96,
        '^', 138,
        '`', 192,
        '{', 85,
        '|', 143,
        '}', 88,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(210);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 89,
        '"', 171,
        '#', 32,
        '&', 135,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 79,
        '+', 147,
        ',', 87,
        '-', 151,
        '.', 105,
        '/', 154,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 97,
        '=', 84,
        '>', 100,
        '?', 213,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '`', 192,
        '{', 85,
        '|', 145,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(209);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 89,
        '"', 171,
        '#', 32,
        '&', 135,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 79,
        '+', 147,
        ',', 87,
        '-', 151,
        '.', 105,
        '/', 154,
        '0', 199,
        '<', 97,
        '?', 212,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '`', 192,
        '{', 86,
        '|', 140,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 171,
        '#', 32,
        '&', 135,
        '\'', 172,
        '(', 91,
        '*', 79,
        '+', 146,
        ',', 87,
        '-', 150,
        '.', 20,
        '/', 17,
        '0', 199,
        ';', 92,
        '<', 97,
        '>', 100,
        '?', 212,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '`', 192,
        '{', 86,
        '|', 145,
        '}', 88,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 171,
        '#', 32,
        '\'', 172,
        '(', 91,
        '*', 79,
        '+', 146,
        ',', 87,
        '-', 150,
        '.', 20,
        '/', 17,
        '0', 199,
        ';', 92,
        '<', 97,
        '@', 211,
        '[', 95,
        '\\', 36,
        '{', 85,
        '|', 46,
        '}', 88,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(171);
      if (lookahead == '/') ADVANCE(17);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(171);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\\') ADVANCE(37);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(11);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(176);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '$', 38,
        '+', 30,
        '-', 31,
        '/', 17,
        ':', 94,
        '<', 25,
        '?', 28,
        '\\', 37,
        '`', 192,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '$', 38,
        '+', 30,
        '-', 31,
        '/', 17,
        ':', 94,
        '<', 25,
        '?', 28,
        '`', 192,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(172);
      if (lookahead == '/') ADVANCE(17);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(15);
      END_STATE();
    case 16:
      if (lookahead == '\'') ADVANCE(172);
      if (lookahead == '/') ADVANCE(179);
      if (lookahead == '\\') ADVANCE(37);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(15);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(182);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(191);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(190);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '?') ADVANCE(166);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(124);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(194);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 24:
      if (lookahead == '/') ADVANCE(17);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 25:
      if (lookahead == '/') ADVANCE(103);
      END_STATE();
    case 26:
      if (lookahead == ':') ADVANCE(217);
      END_STATE();
    case 27:
      if (lookahead == ':') ADVANCE(216);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(218);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 30:
      if (lookahead == '?') ADVANCE(26);
      END_STATE();
    case 31:
      if (lookahead == '?') ADVANCE(27);
      END_STATE();
    case 32:
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(210);
      END_STATE();
    case 33:
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(64);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(189);
      if (lookahead != 0) ADVANCE(185);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(42);
      if (lookahead == 'x') ADVANCE(64);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(189);
      if (lookahead != 0) ADVANCE(185);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(193);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 41:
      if (lookahead == '{') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(71);
      END_STATE();
    case 42:
      if (lookahead == '{') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 49:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(202);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(203);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 72:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(33);
      END_STATE();
    case 73:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(196);
      END_STATE();
    case 74:
      if (eof) ADVANCE(77);
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 6,
        '$', 208,
        '%', 157,
        '&', 136,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 80,
        '+', 149,
        ',', 87,
        '-', 153,
        '.', 105,
        '/', 155,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 98,
        '=', 83,
        '>', 101,
        '?', 214,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '^', 139,
        '`', 192,
        '{', 86,
        '|', 142,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(74);
      if (lookahead > '@') ADVANCE(209);
      END_STATE();
    case 75:
      if (eof) ADVANCE(77);
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 32,
        '%', 156,
        '&', 137,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 81,
        '+', 147,
        ',', 87,
        '-', 151,
        '.', 106,
        '/', 154,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 99,
        '=', 82,
        '>', 102,
        '?', 215,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '^', 138,
        '`', 192,
        '{', 85,
        '|', 144,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(75);
      if (lookahead > '#') ADVANCE(209);
      END_STATE();
    case 76:
      if (eof) ADVANCE(77);
      ADVANCE_MAP(
        '!', 89,
        '"', 171,
        '#', 6,
        '&', 135,
        '\'', 172,
        '(', 91,
        ')', 93,
        '*', 79,
        '+', 147,
        ',', 87,
        '-', 151,
        '.', 105,
        '/', 154,
        '0', 199,
        ':', 94,
        ';', 92,
        '<', 97,
        '=', 84,
        '>', 100,
        '?', 212,
        '@', 211,
        '[', 95,
        '\\', 36,
        ']', 96,
        '`', 192,
        '{', 85,
        '|', 145,
        '}', 88,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(76);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(209);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(159);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(158);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(161);
      if (lookahead == '>') ADVANCE(107);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(107);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(219);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(163);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(165);
      if (lookahead == '>') ADVANCE(129);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(165);
      if (lookahead == '>') ADVANCE(130);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(117);
      if (lookahead == '>') ADVANCE(132);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(126);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(125);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(116);
      if (lookahead == '|') ADVANCE(128);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(116);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(127);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(169);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(169);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(169);
      if (lookahead == '=') ADVANCE(109);
      if (lookahead == '?') ADVANCE(26);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(170);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '?') ADVANCE(27);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(191);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(164);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(175);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(173);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(181);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(180);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(179);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(36);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(185);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(188);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(24);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '[') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(73);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(195);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 207,
        '0', 201,
        '_', 53,
        'n', 198,
        'B', 49,
        'b', 49,
        'E', 48,
        'e', 48,
        'O', 50,
        'o', 50,
        'X', 58,
        'x', 58,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(207);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(198);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(198);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(58);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '{') ADVANCE(193);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(36);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(108);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '?') ADVANCE(167);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '?') ADVANCE(166);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_PLUS_QMARK_COLON);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'k', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'o', 13,
        'p', 14,
        'r', 15,
        's', 16,
        't', 17,
        'u', 18,
        'v', 19,
        'w', 20,
        'y', 21,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(44);
      if (lookahead == 'm') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'h') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(70);
      if (lookahead == 'y') ADVANCE(71);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(72);
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(74);
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(76);
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(80);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(81);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(82);
      if (lookahead == 'y') ADVANCE(83);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(84);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(87);
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(89);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 32:
      if (lookahead == 'b') ADVANCE(91);
      if (lookahead == 'c') ADVANCE(92);
      if (lookahead == 'f') ADVANCE(93);
      if (lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(95);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(96);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(100);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(101);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(106);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(107);
      if (lookahead == 's') ADVANCE(108);
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(110);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(113);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 53:
      if (lookahead == 'v') ADVANCE(115);
      if (lookahead == 'w') ADVANCE(116);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(117);
      if (lookahead == 'm') ADVANCE(118);
      END_STATE();
    case 55:
      if (lookahead == 'j') ADVANCE(119);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(121);
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(123);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(124);
      if (lookahead == 'q') ADVANCE(125);
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(128);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(129);
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(132);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(133);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 68:
      if (lookahead == 'm') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'u') ADVANCE(138);
      if (lookahead == 'y') ADVANCE(139);
      END_STATE();
    case 71:
      if (lookahead == 'p') ADVANCE(140);
      END_STATE();
    case 72:
      if (lookahead == 'd') ADVANCE(141);
      if (lookahead == 'i') ADVANCE(142);
      if (lookahead == 'k') ADVANCE(143);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(147);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(150);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(153);
      END_STATE();
    case 84:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(155);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(156);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(159);
      END_STATE();
    case 90:
      if (lookahead == 's') ADVANCE(160);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 91:
      if (lookahead == 'u') ADVANCE(162);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(163);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(164);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 96:
      if (lookahead == 'm') ADVANCE(167);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 99:
      if (lookahead == 's') ADVANCE(170);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 102:
      if (lookahead == 'm') ADVANCE(172);
      END_STATE();
    case 103:
      if (lookahead == 'c') ADVANCE(173);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 105:
      if (lookahead == 'b') ADVANCE(174);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(175);
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 110:
      if (lookahead == 'o') ADVANCE(180);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(181);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(182);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 118:
      if (lookahead == 'b') ADVANCE(186);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 120:
      if (lookahead == 'r') ADVANCE(188);
      END_STATE();
    case 121:
      if (lookahead == 'v') ADVANCE(189);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(190);
      END_STATE();
    case 123:
      if (lookahead == 'l') ADVANCE(191);
      END_STATE();
    case 124:
      if (lookahead == 'd') ADVANCE(192);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(193);
      END_STATE();
    case 126:
      if (lookahead == 'u') ADVANCE(194);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 130:
      if (lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 133:
      if (lookahead == 'b') ADVANCE(200);
      END_STATE();
    case 134:
      if (lookahead == 'g') ADVANCE(201);
      END_STATE();
    case 135:
      if (lookahead == 'p') ADVANCE(202);
      END_STATE();
    case 136:
      if (lookahead == 's') ADVANCE(203);
      END_STATE();
    case 137:
      if (lookahead == 'o') ADVANCE(204);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 140:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 141:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 142:
      if (lookahead == 'q') ADVANCE(208);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(209);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(210);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 146:
      if (lookahead == 'd') ADVANCE(211);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 148:
      if (lookahead == 'h') ADVANCE(213);
      END_STATE();
    case 149:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(215);
      END_STATE();
    case 151:
      if (lookahead == 's') ADVANCE(216);
      END_STATE();
    case 152:
      if (lookahead == 'r') ADVANCE(217);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(218);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 156:
      if (lookahead == 'k') ADVANCE(221);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 158:
      if (lookahead == 'h') ADVANCE(222);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 162:
      if (lookahead == 'g') ADVANCE(226);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(227);
      END_STATE();
    case 164:
      if (lookahead == 'u') ADVANCE(228);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 168:
      if (lookahead == 'r') ADVANCE(230);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 170:
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 171:
      if (lookahead == 'l') ADVANCE(233);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(234);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(235);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(236);
      END_STATE();
    case 176:
      if (lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 178:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 179:
      if (lookahead == 'r') ADVANCE(240);
      END_STATE();
    case 180:
      if (lookahead == 'f') ADVANCE(241);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 182:
      if (lookahead == 'l') ADVANCE(242);
      END_STATE();
    case 183:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(245);
      END_STATE();
    case 187:
      if (lookahead == 'c') ADVANCE(246);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(247);
      END_STATE();
    case 189:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(249);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(250);
      END_STATE();
    case 192:
      if (lookahead == 'o') ADVANCE(251);
      END_STATE();
    case 193:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 194:
      if (lookahead == 'r') ADVANCE(253);
      END_STATE();
    case 195:
      if (lookahead == 's') ADVANCE(254);
      END_STATE();
    case 196:
      if (lookahead == 'i') ADVANCE(255);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(256);
      END_STATE();
    case 198:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 199:
      if (lookahead == 'c') ADVANCE(258);
      END_STATE();
    case 200:
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 202:
      if (lookahead == 'l') ADVANCE(261);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 204:
      if (lookahead == 'w') ADVANCE(262);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(263);
      END_STATE();
    case 207:
      if (lookahead == 'f') ADVANCE(264);
      END_STATE();
    case 208:
      if (lookahead == 'u') ADVANCE(265);
      END_STATE();
    case 209:
      if (lookahead == 'o') ADVANCE(266);
      END_STATE();
    case 210:
      if (lookahead == 'g') ADVANCE(267);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 212:
      if (lookahead == 'e') ADVANCE(268);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 214:
      if (lookahead == 'd') ADVANCE(269);
      END_STATE();
    case 215:
      if (lookahead == 'a') ADVANCE(270);
      END_STATE();
    case 216:
      if (lookahead == 's') ADVANCE(271);
      END_STATE();
    case 217:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 220:
      if (lookahead == 'a') ADVANCE(273);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 225:
      if (lookahead == 'n') ADVANCE(274);
      END_STATE();
    case 226:
      if (lookahead == 'g') ADVANCE(275);
      END_STATE();
    case 227:
      if (lookahead == 'r') ADVANCE(276);
      END_STATE();
    case 228:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(279);
      END_STATE();
    case 231:
      if (lookahead == 'd') ADVANCE(280);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 233:
      if (lookahead == 'l') ADVANCE(281);
      END_STATE();
    case 234:
      if (lookahead == 'i') ADVANCE(282);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(283);
      END_STATE();
    case 236:
      if (lookahead == 'm') ADVANCE(284);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 239:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 240:
      if (lookahead == 'f') ADVANCE(287);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 243:
      if (lookahead == 'p') ADVANCE(289);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 245:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 246:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 247:
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 249:
      if (lookahead == 'c') ADVANCE(294);
      END_STATE();
    case 250:
      if (lookahead == 'c') ADVANCE(295);
      END_STATE();
    case 251:
      if (lookahead == 'n') ADVANCE(296);
      END_STATE();
    case 252:
      if (lookahead == 'r') ADVANCE(297);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 254:
      if (lookahead == 'f') ADVANCE(299);
      END_STATE();
    case 255:
      if (lookahead == 'c') ADVANCE(300);
      END_STATE();
    case 256:
      if (lookahead == 'g') ADVANCE(301);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 258:
      if (lookahead == 'h') ADVANCE(302);
      END_STATE();
    case 259:
      if (lookahead == 'l') ADVANCE(303);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 261:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 263:
      if (lookahead == 'f') ADVANCE(306);
      END_STATE();
    case 264:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(308);
      END_STATE();
    case 266:
      if (lookahead == 'w') ADVANCE(309);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 270:
      if (lookahead == 'c') ADVANCE(310);
      END_STATE();
    case 271:
      if (lookahead == 'o') ADVANCE(311);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 273:
      if (lookahead == 'n') ADVANCE(313);
      END_STATE();
    case 274:
      if (lookahead == 'u') ADVANCE(314);
      END_STATE();
    case 275:
      if (lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 276:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 277:
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 280:
      if (lookahead == 's') ADVANCE(318);
      END_STATE();
    case 281:
      if (lookahead == 'y') ADVANCE(319);
      END_STATE();
    case 282:
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 284:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 286:
      if (lookahead == 'c') ADVANCE(322);
      END_STATE();
    case 287:
      if (lookahead == 'a') ADVANCE(323);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 289:
      if (lookahead == 'a') ADVANCE(324);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 292:
      if (lookahead == 'd') ADVANCE(325);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(326);
      END_STATE();
    case 294:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 296:
      if (lookahead == 'l') ADVANCE(328);
      END_STATE();
    case 297:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 299:
      if (lookahead == 'i') ADVANCE(330);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(331);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 309:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 310:
      if (lookahead == 't') ADVANCE(334);
      END_STATE();
    case 311:
      if (lookahead == 'r') ADVANCE(335);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 314:
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 315:
      if (lookahead == 'r') ADVANCE(337);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 320:
      if (lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 321:
      if (lookahead == 'n') ADVANCE(339);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 323:
      if (lookahead == 'c') ADVANCE(341);
      END_STATE();
    case 324:
      if (lookahead == 'c') ADVANCE(342);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(343);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 327:
      if (lookahead == 'e') ADVANCE(344);
      END_STATE();
    case 328:
      if (lookahead == 'y') ADVANCE(345);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 330:
      if (lookahead == 'e') ADVANCE(346);
      END_STATE();
    case 331:
      if (lookahead == 'e') ADVANCE(347);
      END_STATE();
    case 332:
      if (lookahead == 'e') ADVANCE(348);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_accessor);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 339:
      if (lookahead == 't') ADVANCE(349);
      END_STATE();
    case 340:
      if (lookahead == 'o') ADVANCE(350);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(351);
      END_STATE();
    case 342:
      if (lookahead == 'e') ADVANCE(352);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 344:
      if (lookahead == 'd') ADVANCE(353);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 346:
      if (lookahead == 's') ADVANCE(354);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_glimmer_template_tag_name);
      END_STATE();
    case 348:
      if (lookahead == 'd') ADVANCE(355);
      END_STATE();
    case 349:
      if (lookahead == 's') ADVANCE(356);
      END_STATE();
    case 350:
      if (lookahead == 'f') ADVANCE(357);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_satisfies);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 76, .external_lex_state = 2},
  [2] = {.lex_state = 2, .external_lex_state = 3},
  [3] = {.lex_state = 2, .external_lex_state = 3},
  [4] = {.lex_state = 76, .external_lex_state = 2},
  [5] = {.lex_state = 76, .external_lex_state = 2},
  [6] = {.lex_state = 76, .external_lex_state = 2},
  [7] = {.lex_state = 76, .external_lex_state = 2},
  [8] = {.lex_state = 76, .external_lex_state = 2},
  [9] = {.lex_state = 76, .external_lex_state = 2},
  [10] = {.lex_state = 76, .external_lex_state = 2},
  [11] = {.lex_state = 76, .external_lex_state = 2},
  [12] = {.lex_state = 76, .external_lex_state = 2},
  [13] = {.lex_state = 76, .external_lex_state = 2},
  [14] = {.lex_state = 76, .external_lex_state = 2},
  [15] = {.lex_state = 76, .external_lex_state = 2},
  [16] = {.lex_state = 76, .external_lex_state = 2},
  [17] = {.lex_state = 76, .external_lex_state = 2},
  [18] = {.lex_state = 76, .external_lex_state = 2},
  [19] = {.lex_state = 76, .external_lex_state = 2},
  [20] = {.lex_state = 76, .external_lex_state = 2},
  [21] = {.lex_state = 76, .external_lex_state = 2},
  [22] = {.lex_state = 76, .external_lex_state = 2},
  [23] = {.lex_state = 76, .external_lex_state = 2},
  [24] = {.lex_state = 76, .external_lex_state = 2},
  [25] = {.lex_state = 76, .external_lex_state = 2},
  [26] = {.lex_state = 76, .external_lex_state = 2},
  [27] = {.lex_state = 76, .external_lex_state = 2},
  [28] = {.lex_state = 76, .external_lex_state = 2},
  [29] = {.lex_state = 76, .external_lex_state = 2},
  [30] = {.lex_state = 76, .external_lex_state = 2},
  [31] = {.lex_state = 76, .external_lex_state = 2},
  [32] = {.lex_state = 8, .external_lex_state = 2},
  [33] = {.lex_state = 76, .external_lex_state = 2},
  [34] = {.lex_state = 76, .external_lex_state = 2},
  [35] = {.lex_state = 76, .external_lex_state = 2},
  [36] = {.lex_state = 76, .external_lex_state = 2},
  [37] = {.lex_state = 76, .external_lex_state = 2},
  [38] = {.lex_state = 76, .external_lex_state = 2},
  [39] = {.lex_state = 76, .external_lex_state = 2},
  [40] = {.lex_state = 76, .external_lex_state = 2},
  [41] = {.lex_state = 76, .external_lex_state = 2},
  [42] = {.lex_state = 76, .external_lex_state = 2},
  [43] = {.lex_state = 76, .external_lex_state = 2},
  [44] = {.lex_state = 76, .external_lex_state = 2},
  [45] = {.lex_state = 76, .external_lex_state = 2},
  [46] = {.lex_state = 76, .external_lex_state = 2},
  [47] = {.lex_state = 76, .external_lex_state = 2},
  [48] = {.lex_state = 76, .external_lex_state = 2},
  [49] = {.lex_state = 76, .external_lex_state = 2},
  [50] = {.lex_state = 76, .external_lex_state = 2},
  [51] = {.lex_state = 8, .external_lex_state = 2},
  [52] = {.lex_state = 76, .external_lex_state = 2},
  [53] = {.lex_state = 76, .external_lex_state = 2},
  [54] = {.lex_state = 76, .external_lex_state = 2},
  [55] = {.lex_state = 76, .external_lex_state = 2},
  [56] = {.lex_state = 76, .external_lex_state = 2},
  [57] = {.lex_state = 76, .external_lex_state = 2},
  [58] = {.lex_state = 76, .external_lex_state = 2},
  [59] = {.lex_state = 76, .external_lex_state = 2},
  [60] = {.lex_state = 76, .external_lex_state = 2},
  [61] = {.lex_state = 76, .external_lex_state = 2},
  [62] = {.lex_state = 8, .external_lex_state = 2},
  [63] = {.lex_state = 8, .external_lex_state = 2},
  [64] = {.lex_state = 8, .external_lex_state = 2},
  [65] = {.lex_state = 8, .external_lex_state = 2},
  [66] = {.lex_state = 76, .external_lex_state = 2},
  [67] = {.lex_state = 8, .external_lex_state = 2},
  [68] = {.lex_state = 8, .external_lex_state = 2},
  [69] = {.lex_state = 8, .external_lex_state = 2},
  [70] = {.lex_state = 8, .external_lex_state = 2},
  [71] = {.lex_state = 76, .external_lex_state = 2},
  [72] = {.lex_state = 3, .external_lex_state = 4},
  [73] = {.lex_state = 3, .external_lex_state = 4},
  [74] = {.lex_state = 3, .external_lex_state = 4},
  [75] = {.lex_state = 3, .external_lex_state = 3},
  [76] = {.lex_state = 3, .external_lex_state = 3},
  [77] = {.lex_state = 3, .external_lex_state = 3},
  [78] = {.lex_state = 8, .external_lex_state = 2},
  [79] = {.lex_state = 3, .external_lex_state = 3},
  [80] = {.lex_state = 3, .external_lex_state = 3},
  [81] = {.lex_state = 3, .external_lex_state = 3},
  [82] = {.lex_state = 8, .external_lex_state = 2},
  [83] = {.lex_state = 3, .external_lex_state = 3},
  [84] = {.lex_state = 3, .external_lex_state = 3},
  [85] = {.lex_state = 8, .external_lex_state = 2},
  [86] = {.lex_state = 8, .external_lex_state = 2},
  [87] = {.lex_state = 8, .external_lex_state = 2},
  [88] = {.lex_state = 3, .external_lex_state = 3},
  [89] = {.lex_state = 8, .external_lex_state = 2},
  [90] = {.lex_state = 3, .external_lex_state = 3},
  [91] = {.lex_state = 8, .external_lex_state = 2},
  [92] = {.lex_state = 8, .external_lex_state = 2},
  [93] = {.lex_state = 3, .external_lex_state = 3},
  [94] = {.lex_state = 3, .external_lex_state = 3},
  [95] = {.lex_state = 3, .external_lex_state = 3},
  [96] = {.lex_state = 3, .external_lex_state = 3},
  [97] = {.lex_state = 3, .external_lex_state = 4},
  [98] = {.lex_state = 3, .external_lex_state = 4},
  [99] = {.lex_state = 3, .external_lex_state = 3},
  [100] = {.lex_state = 3, .external_lex_state = 3},
  [101] = {.lex_state = 3, .external_lex_state = 4},
  [102] = {.lex_state = 3, .external_lex_state = 4},
  [103] = {.lex_state = 3, .external_lex_state = 4},
  [104] = {.lex_state = 3, .external_lex_state = 4},
  [105] = {.lex_state = 3, .external_lex_state = 4},
  [106] = {.lex_state = 3, .external_lex_state = 4},
  [107] = {.lex_state = 3, .external_lex_state = 3},
  [108] = {.lex_state = 3, .external_lex_state = 3},
  [109] = {.lex_state = 3, .external_lex_state = 3},
  [110] = {.lex_state = 3, .external_lex_state = 3},
  [111] = {.lex_state = 3, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 3},
  [113] = {.lex_state = 3, .external_lex_state = 3},
  [114] = {.lex_state = 3, .external_lex_state = 3},
  [115] = {.lex_state = 3, .external_lex_state = 3},
  [116] = {.lex_state = 3, .external_lex_state = 4},
  [117] = {.lex_state = 3, .external_lex_state = 4},
  [118] = {.lex_state = 3, .external_lex_state = 4},
  [119] = {.lex_state = 3, .external_lex_state = 3},
  [120] = {.lex_state = 3, .external_lex_state = 3},
  [121] = {.lex_state = 3, .external_lex_state = 3},
  [122] = {.lex_state = 3, .external_lex_state = 3},
  [123] = {.lex_state = 3, .external_lex_state = 3},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 3},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 3},
  [129] = {.lex_state = 3, .external_lex_state = 3},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 3, .external_lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 3},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 3, .external_lex_state = 3},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 3},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 3, .external_lex_state = 3},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 3},
  [146] = {.lex_state = 8, .external_lex_state = 2},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 3},
  [150] = {.lex_state = 8, .external_lex_state = 2},
  [151] = {.lex_state = 8, .external_lex_state = 2},
  [152] = {.lex_state = 8, .external_lex_state = 2},
  [153] = {.lex_state = 8, .external_lex_state = 2},
  [154] = {.lex_state = 8, .external_lex_state = 2},
  [155] = {.lex_state = 8, .external_lex_state = 2},
  [156] = {.lex_state = 8, .external_lex_state = 2},
  [157] = {.lex_state = 8, .external_lex_state = 2},
  [158] = {.lex_state = 8, .external_lex_state = 2},
  [159] = {.lex_state = 8, .external_lex_state = 2},
  [160] = {.lex_state = 8, .external_lex_state = 2},
  [161] = {.lex_state = 8, .external_lex_state = 2},
  [162] = {.lex_state = 8, .external_lex_state = 2},
  [163] = {.lex_state = 75, .external_lex_state = 3},
  [164] = {.lex_state = 75, .external_lex_state = 4},
  [165] = {.lex_state = 75, .external_lex_state = 4},
  [166] = {.lex_state = 75, .external_lex_state = 3},
  [167] = {.lex_state = 75, .external_lex_state = 3},
  [168] = {.lex_state = 75, .external_lex_state = 4},
  [169] = {.lex_state = 75, .external_lex_state = 3},
  [170] = {.lex_state = 75, .external_lex_state = 3},
  [171] = {.lex_state = 75, .external_lex_state = 3},
  [172] = {.lex_state = 75, .external_lex_state = 3},
  [173] = {.lex_state = 2, .external_lex_state = 3},
  [174] = {.lex_state = 76, .external_lex_state = 2},
  [175] = {.lex_state = 2, .external_lex_state = 4},
  [176] = {.lex_state = 76, .external_lex_state = 2},
  [177] = {.lex_state = 76, .external_lex_state = 2},
  [178] = {.lex_state = 76, .external_lex_state = 2},
  [179] = {.lex_state = 2, .external_lex_state = 4},
  [180] = {.lex_state = 76, .external_lex_state = 2},
  [181] = {.lex_state = 76, .external_lex_state = 2},
  [182] = {.lex_state = 2, .external_lex_state = 3},
  [183] = {.lex_state = 2, .external_lex_state = 3},
  [184] = {.lex_state = 2, .external_lex_state = 3},
  [185] = {.lex_state = 2, .external_lex_state = 3},
  [186] = {.lex_state = 2, .external_lex_state = 3},
  [187] = {.lex_state = 2, .external_lex_state = 3},
  [188] = {.lex_state = 2, .external_lex_state = 4},
  [189] = {.lex_state = 2, .external_lex_state = 3},
  [190] = {.lex_state = 2, .external_lex_state = 3},
  [191] = {.lex_state = 2, .external_lex_state = 3},
  [192] = {.lex_state = 2, .external_lex_state = 3},
  [193] = {.lex_state = 2, .external_lex_state = 3},
  [194] = {.lex_state = 76, .external_lex_state = 2},
  [195] = {.lex_state = 76, .external_lex_state = 2},
  [196] = {.lex_state = 76, .external_lex_state = 2},
  [197] = {.lex_state = 76, .external_lex_state = 2},
  [198] = {.lex_state = 76, .external_lex_state = 2},
  [199] = {.lex_state = 76, .external_lex_state = 2},
  [200] = {.lex_state = 76, .external_lex_state = 2},
  [201] = {.lex_state = 76, .external_lex_state = 2},
  [202] = {.lex_state = 76, .external_lex_state = 2},
  [203] = {.lex_state = 76, .external_lex_state = 2},
  [204] = {.lex_state = 76, .external_lex_state = 2},
  [205] = {.lex_state = 76, .external_lex_state = 2},
  [206] = {.lex_state = 76, .external_lex_state = 2},
  [207] = {.lex_state = 76, .external_lex_state = 2},
  [208] = {.lex_state = 76, .external_lex_state = 2},
  [209] = {.lex_state = 76, .external_lex_state = 2},
  [210] = {.lex_state = 76, .external_lex_state = 2},
  [211] = {.lex_state = 76, .external_lex_state = 2},
  [212] = {.lex_state = 76, .external_lex_state = 2},
  [213] = {.lex_state = 75, .external_lex_state = 4},
  [214] = {.lex_state = 75, .external_lex_state = 4},
  [215] = {.lex_state = 76, .external_lex_state = 5},
  [216] = {.lex_state = 75, .external_lex_state = 4},
  [217] = {.lex_state = 75, .external_lex_state = 4},
  [218] = {.lex_state = 76, .external_lex_state = 2},
  [219] = {.lex_state = 76, .external_lex_state = 2},
  [220] = {.lex_state = 76, .external_lex_state = 2},
  [221] = {.lex_state = 75, .external_lex_state = 4},
  [222] = {.lex_state = 75, .external_lex_state = 4},
  [223] = {.lex_state = 76, .external_lex_state = 2},
  [224] = {.lex_state = 76, .external_lex_state = 2},
  [225] = {.lex_state = 76, .external_lex_state = 2},
  [226] = {.lex_state = 75, .external_lex_state = 4},
  [227] = {.lex_state = 75, .external_lex_state = 4},
  [228] = {.lex_state = 76, .external_lex_state = 2},
  [229] = {.lex_state = 75, .external_lex_state = 4},
  [230] = {.lex_state = 75, .external_lex_state = 4},
  [231] = {.lex_state = 75, .external_lex_state = 4},
  [232] = {.lex_state = 75, .external_lex_state = 4},
  [233] = {.lex_state = 75, .external_lex_state = 4},
  [234] = {.lex_state = 75, .external_lex_state = 4},
  [235] = {.lex_state = 75, .external_lex_state = 4},
  [236] = {.lex_state = 75, .external_lex_state = 4},
  [237] = {.lex_state = 75, .external_lex_state = 4},
  [238] = {.lex_state = 75, .external_lex_state = 4},
  [239] = {.lex_state = 75, .external_lex_state = 4},
  [240] = {.lex_state = 76, .external_lex_state = 2},
  [241] = {.lex_state = 76, .external_lex_state = 2},
  [242] = {.lex_state = 76, .external_lex_state = 2},
  [243] = {.lex_state = 75, .external_lex_state = 4},
  [244] = {.lex_state = 75, .external_lex_state = 4},
  [245] = {.lex_state = 75, .external_lex_state = 4},
  [246] = {.lex_state = 75, .external_lex_state = 4},
  [247] = {.lex_state = 75, .external_lex_state = 4},
  [248] = {.lex_state = 76, .external_lex_state = 2},
  [249] = {.lex_state = 75, .external_lex_state = 4},
  [250] = {.lex_state = 75, .external_lex_state = 4},
  [251] = {.lex_state = 75, .external_lex_state = 4},
  [252] = {.lex_state = 75, .external_lex_state = 4},
  [253] = {.lex_state = 75, .external_lex_state = 4},
  [254] = {.lex_state = 76, .external_lex_state = 2},
  [255] = {.lex_state = 76, .external_lex_state = 2},
  [256] = {.lex_state = 76, .external_lex_state = 2},
  [257] = {.lex_state = 76, .external_lex_state = 2},
  [258] = {.lex_state = 76, .external_lex_state = 2},
  [259] = {.lex_state = 76, .external_lex_state = 2},
  [260] = {.lex_state = 76, .external_lex_state = 2},
  [261] = {.lex_state = 76, .external_lex_state = 2},
  [262] = {.lex_state = 76, .external_lex_state = 2},
  [263] = {.lex_state = 76, .external_lex_state = 2},
  [264] = {.lex_state = 76, .external_lex_state = 2},
  [265] = {.lex_state = 76, .external_lex_state = 2},
  [266] = {.lex_state = 76, .external_lex_state = 2},
  [267] = {.lex_state = 76, .external_lex_state = 2},
  [268] = {.lex_state = 76, .external_lex_state = 2},
  [269] = {.lex_state = 76, .external_lex_state = 2},
  [270] = {.lex_state = 76, .external_lex_state = 2},
  [271] = {.lex_state = 76, .external_lex_state = 2},
  [272] = {.lex_state = 76, .external_lex_state = 2},
  [273] = {.lex_state = 76, .external_lex_state = 2},
  [274] = {.lex_state = 76, .external_lex_state = 2},
  [275] = {.lex_state = 3, .external_lex_state = 3},
  [276] = {.lex_state = 76, .external_lex_state = 2},
  [277] = {.lex_state = 76, .external_lex_state = 2},
  [278] = {.lex_state = 76, .external_lex_state = 2},
  [279] = {.lex_state = 76, .external_lex_state = 2},
  [280] = {.lex_state = 76, .external_lex_state = 2},
  [281] = {.lex_state = 76, .external_lex_state = 2},
  [282] = {.lex_state = 3, .external_lex_state = 3},
  [283] = {.lex_state = 3, .external_lex_state = 3},
  [284] = {.lex_state = 76, .external_lex_state = 2},
  [285] = {.lex_state = 76, .external_lex_state = 2},
  [286] = {.lex_state = 76, .external_lex_state = 2},
  [287] = {.lex_state = 3, .external_lex_state = 3},
  [288] = {.lex_state = 76, .external_lex_state = 2},
  [289] = {.lex_state = 76, .external_lex_state = 2},
  [290] = {.lex_state = 76, .external_lex_state = 2},
  [291] = {.lex_state = 76, .external_lex_state = 2},
  [292] = {.lex_state = 76, .external_lex_state = 2},
  [293] = {.lex_state = 76, .external_lex_state = 2},
  [294] = {.lex_state = 76, .external_lex_state = 2},
  [295] = {.lex_state = 76, .external_lex_state = 2},
  [296] = {.lex_state = 76, .external_lex_state = 2},
  [297] = {.lex_state = 76, .external_lex_state = 2},
  [298] = {.lex_state = 76, .external_lex_state = 2},
  [299] = {.lex_state = 76, .external_lex_state = 2},
  [300] = {.lex_state = 76, .external_lex_state = 2},
  [301] = {.lex_state = 76, .external_lex_state = 2},
  [302] = {.lex_state = 76, .external_lex_state = 2},
  [303] = {.lex_state = 76, .external_lex_state = 5},
  [304] = {.lex_state = 76, .external_lex_state = 2},
  [305] = {.lex_state = 76, .external_lex_state = 2},
  [306] = {.lex_state = 76, .external_lex_state = 2},
  [307] = {.lex_state = 76, .external_lex_state = 2},
  [308] = {.lex_state = 76, .external_lex_state = 2},
  [309] = {.lex_state = 76, .external_lex_state = 2},
  [310] = {.lex_state = 76, .external_lex_state = 2},
  [311] = {.lex_state = 76, .external_lex_state = 2},
  [312] = {.lex_state = 76, .external_lex_state = 2},
  [313] = {.lex_state = 76, .external_lex_state = 2},
  [314] = {.lex_state = 76, .external_lex_state = 2},
  [315] = {.lex_state = 76, .external_lex_state = 2},
  [316] = {.lex_state = 76, .external_lex_state = 2},
  [317] = {.lex_state = 76, .external_lex_state = 2},
  [318] = {.lex_state = 76, .external_lex_state = 2},
  [319] = {.lex_state = 76, .external_lex_state = 2},
  [320] = {.lex_state = 76, .external_lex_state = 2},
  [321] = {.lex_state = 76, .external_lex_state = 2},
  [322] = {.lex_state = 76, .external_lex_state = 2},
  [323] = {.lex_state = 76, .external_lex_state = 2},
  [324] = {.lex_state = 76, .external_lex_state = 2},
  [325] = {.lex_state = 76, .external_lex_state = 2},
  [326] = {.lex_state = 76, .external_lex_state = 2},
  [327] = {.lex_state = 76, .external_lex_state = 2},
  [328] = {.lex_state = 76, .external_lex_state = 2},
  [329] = {.lex_state = 76, .external_lex_state = 2},
  [330] = {.lex_state = 76, .external_lex_state = 2},
  [331] = {.lex_state = 76, .external_lex_state = 2},
  [332] = {.lex_state = 76, .external_lex_state = 2},
  [333] = {.lex_state = 76, .external_lex_state = 2},
  [334] = {.lex_state = 76, .external_lex_state = 2},
  [335] = {.lex_state = 76, .external_lex_state = 2},
  [336] = {.lex_state = 76, .external_lex_state = 2},
  [337] = {.lex_state = 76, .external_lex_state = 2},
  [338] = {.lex_state = 76, .external_lex_state = 2},
  [339] = {.lex_state = 76, .external_lex_state = 2},
  [340] = {.lex_state = 76, .external_lex_state = 2},
  [341] = {.lex_state = 76, .external_lex_state = 2},
  [342] = {.lex_state = 76, .external_lex_state = 2},
  [343] = {.lex_state = 76, .external_lex_state = 2},
  [344] = {.lex_state = 76, .external_lex_state = 2},
  [345] = {.lex_state = 76, .external_lex_state = 2},
  [346] = {.lex_state = 76, .external_lex_state = 2},
  [347] = {.lex_state = 76, .external_lex_state = 2},
  [348] = {.lex_state = 76, .external_lex_state = 2},
  [349] = {.lex_state = 76, .external_lex_state = 2},
  [350] = {.lex_state = 76, .external_lex_state = 2},
  [351] = {.lex_state = 76, .external_lex_state = 2},
  [352] = {.lex_state = 76, .external_lex_state = 2},
  [353] = {.lex_state = 76, .external_lex_state = 2},
  [354] = {.lex_state = 76, .external_lex_state = 2},
  [355] = {.lex_state = 76, .external_lex_state = 2},
  [356] = {.lex_state = 76, .external_lex_state = 2},
  [357] = {.lex_state = 76, .external_lex_state = 2},
  [358] = {.lex_state = 76, .external_lex_state = 2},
  [359] = {.lex_state = 76, .external_lex_state = 2},
  [360] = {.lex_state = 76, .external_lex_state = 2},
  [361] = {.lex_state = 76, .external_lex_state = 2},
  [362] = {.lex_state = 76, .external_lex_state = 2},
  [363] = {.lex_state = 76, .external_lex_state = 2},
  [364] = {.lex_state = 76, .external_lex_state = 2},
  [365] = {.lex_state = 76, .external_lex_state = 2},
  [366] = {.lex_state = 76, .external_lex_state = 2},
  [367] = {.lex_state = 76, .external_lex_state = 2},
  [368] = {.lex_state = 76, .external_lex_state = 2},
  [369] = {.lex_state = 76, .external_lex_state = 2},
  [370] = {.lex_state = 76, .external_lex_state = 2},
  [371] = {.lex_state = 76, .external_lex_state = 2},
  [372] = {.lex_state = 76, .external_lex_state = 2},
  [373] = {.lex_state = 76, .external_lex_state = 2},
  [374] = {.lex_state = 76, .external_lex_state = 2},
  [375] = {.lex_state = 76, .external_lex_state = 2},
  [376] = {.lex_state = 76, .external_lex_state = 2},
  [377] = {.lex_state = 76, .external_lex_state = 2},
  [378] = {.lex_state = 76, .external_lex_state = 2},
  [379] = {.lex_state = 76, .external_lex_state = 2},
  [380] = {.lex_state = 76, .external_lex_state = 2},
  [381] = {.lex_state = 76, .external_lex_state = 2},
  [382] = {.lex_state = 76, .external_lex_state = 2},
  [383] = {.lex_state = 76, .external_lex_state = 2},
  [384] = {.lex_state = 76, .external_lex_state = 2},
  [385] = {.lex_state = 76, .external_lex_state = 2},
  [386] = {.lex_state = 76, .external_lex_state = 2},
  [387] = {.lex_state = 76, .external_lex_state = 2},
  [388] = {.lex_state = 76, .external_lex_state = 2},
  [389] = {.lex_state = 76, .external_lex_state = 2},
  [390] = {.lex_state = 76, .external_lex_state = 2},
  [391] = {.lex_state = 76, .external_lex_state = 2},
  [392] = {.lex_state = 76, .external_lex_state = 2},
  [393] = {.lex_state = 76, .external_lex_state = 2},
  [394] = {.lex_state = 76, .external_lex_state = 2},
  [395] = {.lex_state = 76, .external_lex_state = 2},
  [396] = {.lex_state = 76, .external_lex_state = 2},
  [397] = {.lex_state = 76, .external_lex_state = 2},
  [398] = {.lex_state = 76, .external_lex_state = 2},
  [399] = {.lex_state = 76, .external_lex_state = 2},
  [400] = {.lex_state = 76, .external_lex_state = 2},
  [401] = {.lex_state = 76, .external_lex_state = 2},
  [402] = {.lex_state = 76, .external_lex_state = 2},
  [403] = {.lex_state = 76, .external_lex_state = 2},
  [404] = {.lex_state = 76, .external_lex_state = 2},
  [405] = {.lex_state = 76, .external_lex_state = 2},
  [406] = {.lex_state = 76, .external_lex_state = 2},
  [407] = {.lex_state = 76, .external_lex_state = 2},
  [408] = {.lex_state = 76, .external_lex_state = 2},
  [409] = {.lex_state = 76, .external_lex_state = 2},
  [410] = {.lex_state = 76, .external_lex_state = 2},
  [411] = {.lex_state = 76, .external_lex_state = 2},
  [412] = {.lex_state = 76, .external_lex_state = 2},
  [413] = {.lex_state = 76, .external_lex_state = 2},
  [414] = {.lex_state = 76, .external_lex_state = 2},
  [415] = {.lex_state = 76, .external_lex_state = 2},
  [416] = {.lex_state = 76, .external_lex_state = 2},
  [417] = {.lex_state = 76, .external_lex_state = 2},
  [418] = {.lex_state = 76, .external_lex_state = 2},
  [419] = {.lex_state = 76, .external_lex_state = 2},
  [420] = {.lex_state = 76, .external_lex_state = 2},
  [421] = {.lex_state = 76, .external_lex_state = 2},
  [422] = {.lex_state = 76, .external_lex_state = 2},
  [423] = {.lex_state = 76, .external_lex_state = 2},
  [424] = {.lex_state = 76, .external_lex_state = 2},
  [425] = {.lex_state = 76, .external_lex_state = 2},
  [426] = {.lex_state = 76, .external_lex_state = 2},
  [427] = {.lex_state = 76, .external_lex_state = 2},
  [428] = {.lex_state = 76, .external_lex_state = 2},
  [429] = {.lex_state = 76, .external_lex_state = 2},
  [430] = {.lex_state = 76, .external_lex_state = 2},
  [431] = {.lex_state = 76, .external_lex_state = 2},
  [432] = {.lex_state = 76, .external_lex_state = 2},
  [433] = {.lex_state = 76, .external_lex_state = 2},
  [434] = {.lex_state = 76, .external_lex_state = 2},
  [435] = {.lex_state = 76, .external_lex_state = 2},
  [436] = {.lex_state = 76, .external_lex_state = 2},
  [437] = {.lex_state = 76, .external_lex_state = 2},
  [438] = {.lex_state = 76, .external_lex_state = 2},
  [439] = {.lex_state = 76, .external_lex_state = 2},
  [440] = {.lex_state = 76, .external_lex_state = 2},
  [441] = {.lex_state = 76, .external_lex_state = 2},
  [442] = {.lex_state = 76, .external_lex_state = 2},
  [443] = {.lex_state = 76, .external_lex_state = 2},
  [444] = {.lex_state = 76, .external_lex_state = 2},
  [445] = {.lex_state = 76, .external_lex_state = 2},
  [446] = {.lex_state = 76, .external_lex_state = 2},
  [447] = {.lex_state = 76, .external_lex_state = 2},
  [448] = {.lex_state = 76, .external_lex_state = 2},
  [449] = {.lex_state = 76, .external_lex_state = 2},
  [450] = {.lex_state = 76, .external_lex_state = 2},
  [451] = {.lex_state = 76, .external_lex_state = 2},
  [452] = {.lex_state = 76, .external_lex_state = 2},
  [453] = {.lex_state = 76, .external_lex_state = 2},
  [454] = {.lex_state = 76, .external_lex_state = 2},
  [455] = {.lex_state = 76, .external_lex_state = 2},
  [456] = {.lex_state = 76, .external_lex_state = 2},
  [457] = {.lex_state = 76, .external_lex_state = 2},
  [458] = {.lex_state = 76, .external_lex_state = 2},
  [459] = {.lex_state = 76, .external_lex_state = 2},
  [460] = {.lex_state = 76, .external_lex_state = 2},
  [461] = {.lex_state = 76, .external_lex_state = 2},
  [462] = {.lex_state = 76, .external_lex_state = 2},
  [463] = {.lex_state = 76, .external_lex_state = 2},
  [464] = {.lex_state = 76, .external_lex_state = 2},
  [465] = {.lex_state = 76, .external_lex_state = 2},
  [466] = {.lex_state = 76, .external_lex_state = 2},
  [467] = {.lex_state = 76, .external_lex_state = 2},
  [468] = {.lex_state = 76, .external_lex_state = 2},
  [469] = {.lex_state = 76, .external_lex_state = 2},
  [470] = {.lex_state = 76, .external_lex_state = 2},
  [471] = {.lex_state = 76, .external_lex_state = 2},
  [472] = {.lex_state = 76, .external_lex_state = 2},
  [473] = {.lex_state = 76, .external_lex_state = 2},
  [474] = {.lex_state = 76, .external_lex_state = 2},
  [475] = {.lex_state = 76, .external_lex_state = 2},
  [476] = {.lex_state = 76, .external_lex_state = 2},
  [477] = {.lex_state = 76, .external_lex_state = 2},
  [478] = {.lex_state = 76, .external_lex_state = 2},
  [479] = {.lex_state = 76, .external_lex_state = 2},
  [480] = {.lex_state = 76, .external_lex_state = 2},
  [481] = {.lex_state = 76, .external_lex_state = 2},
  [482] = {.lex_state = 76, .external_lex_state = 2},
  [483] = {.lex_state = 76, .external_lex_state = 2},
  [484] = {.lex_state = 76, .external_lex_state = 2},
  [485] = {.lex_state = 76, .external_lex_state = 2},
  [486] = {.lex_state = 76, .external_lex_state = 2},
  [487] = {.lex_state = 76, .external_lex_state = 2},
  [488] = {.lex_state = 76, .external_lex_state = 2},
  [489] = {.lex_state = 76, .external_lex_state = 2},
  [490] = {.lex_state = 76, .external_lex_state = 2},
  [491] = {.lex_state = 76, .external_lex_state = 2},
  [492] = {.lex_state = 76, .external_lex_state = 2},
  [493] = {.lex_state = 76, .external_lex_state = 2},
  [494] = {.lex_state = 76, .external_lex_state = 2},
  [495] = {.lex_state = 76, .external_lex_state = 2},
  [496] = {.lex_state = 76, .external_lex_state = 2},
  [497] = {.lex_state = 76, .external_lex_state = 2},
  [498] = {.lex_state = 76, .external_lex_state = 2},
  [499] = {.lex_state = 76, .external_lex_state = 2},
  [500] = {.lex_state = 76, .external_lex_state = 2},
  [501] = {.lex_state = 76, .external_lex_state = 2},
  [502] = {.lex_state = 76, .external_lex_state = 2},
  [503] = {.lex_state = 76, .external_lex_state = 2},
  [504] = {.lex_state = 76, .external_lex_state = 2},
  [505] = {.lex_state = 76, .external_lex_state = 2},
  [506] = {.lex_state = 76, .external_lex_state = 2},
  [507] = {.lex_state = 76, .external_lex_state = 2},
  [508] = {.lex_state = 76, .external_lex_state = 2},
  [509] = {.lex_state = 76, .external_lex_state = 2},
  [510] = {.lex_state = 76, .external_lex_state = 2},
  [511] = {.lex_state = 76, .external_lex_state = 2},
  [512] = {.lex_state = 76, .external_lex_state = 2},
  [513] = {.lex_state = 76, .external_lex_state = 2},
  [514] = {.lex_state = 76, .external_lex_state = 2},
  [515] = {.lex_state = 76, .external_lex_state = 2},
  [516] = {.lex_state = 76, .external_lex_state = 2},
  [517] = {.lex_state = 76, .external_lex_state = 2},
  [518] = {.lex_state = 76, .external_lex_state = 2},
  [519] = {.lex_state = 76, .external_lex_state = 2},
  [520] = {.lex_state = 76, .external_lex_state = 2},
  [521] = {.lex_state = 76, .external_lex_state = 2},
  [522] = {.lex_state = 76, .external_lex_state = 2},
  [523] = {.lex_state = 76, .external_lex_state = 2},
  [524] = {.lex_state = 76, .external_lex_state = 2},
  [525] = {.lex_state = 76, .external_lex_state = 2},
  [526] = {.lex_state = 76, .external_lex_state = 2},
  [527] = {.lex_state = 76, .external_lex_state = 2},
  [528] = {.lex_state = 76, .external_lex_state = 2},
  [529] = {.lex_state = 76, .external_lex_state = 2},
  [530] = {.lex_state = 76, .external_lex_state = 2},
  [531] = {.lex_state = 76, .external_lex_state = 2},
  [532] = {.lex_state = 76, .external_lex_state = 2},
  [533] = {.lex_state = 76, .external_lex_state = 2},
  [534] = {.lex_state = 76, .external_lex_state = 2},
  [535] = {.lex_state = 76, .external_lex_state = 2},
  [536] = {.lex_state = 76, .external_lex_state = 2},
  [537] = {.lex_state = 76, .external_lex_state = 2},
  [538] = {.lex_state = 76, .external_lex_state = 2},
  [539] = {.lex_state = 76, .external_lex_state = 2},
  [540] = {.lex_state = 76, .external_lex_state = 2},
  [541] = {.lex_state = 76, .external_lex_state = 2},
  [542] = {.lex_state = 76, .external_lex_state = 2},
  [543] = {.lex_state = 76, .external_lex_state = 2},
  [544] = {.lex_state = 76, .external_lex_state = 2},
  [545] = {.lex_state = 76, .external_lex_state = 2},
  [546] = {.lex_state = 76, .external_lex_state = 2},
  [547] = {.lex_state = 76, .external_lex_state = 2},
  [548] = {.lex_state = 76, .external_lex_state = 2},
  [549] = {.lex_state = 76, .external_lex_state = 2},
  [550] = {.lex_state = 76, .external_lex_state = 2},
  [551] = {.lex_state = 76, .external_lex_state = 2},
  [552] = {.lex_state = 76, .external_lex_state = 2},
  [553] = {.lex_state = 76, .external_lex_state = 2},
  [554] = {.lex_state = 76, .external_lex_state = 2},
  [555] = {.lex_state = 76, .external_lex_state = 2},
  [556] = {.lex_state = 76, .external_lex_state = 2},
  [557] = {.lex_state = 76, .external_lex_state = 2},
  [558] = {.lex_state = 76, .external_lex_state = 2},
  [559] = {.lex_state = 76, .external_lex_state = 2},
  [560] = {.lex_state = 76, .external_lex_state = 2},
  [561] = {.lex_state = 76, .external_lex_state = 2},
  [562] = {.lex_state = 76, .external_lex_state = 2},
  [563] = {.lex_state = 76, .external_lex_state = 2},
  [564] = {.lex_state = 76, .external_lex_state = 2},
  [565] = {.lex_state = 76, .external_lex_state = 2},
  [566] = {.lex_state = 76, .external_lex_state = 2},
  [567] = {.lex_state = 76, .external_lex_state = 2},
  [568] = {.lex_state = 76, .external_lex_state = 2},
  [569] = {.lex_state = 76, .external_lex_state = 2},
  [570] = {.lex_state = 76, .external_lex_state = 2},
  [571] = {.lex_state = 76, .external_lex_state = 2},
  [572] = {.lex_state = 76, .external_lex_state = 2},
  [573] = {.lex_state = 76, .external_lex_state = 2},
  [574] = {.lex_state = 76, .external_lex_state = 2},
  [575] = {.lex_state = 76, .external_lex_state = 2},
  [576] = {.lex_state = 76, .external_lex_state = 2},
  [577] = {.lex_state = 76, .external_lex_state = 2},
  [578] = {.lex_state = 76, .external_lex_state = 2},
  [579] = {.lex_state = 76, .external_lex_state = 2},
  [580] = {.lex_state = 76, .external_lex_state = 2},
  [581] = {.lex_state = 76, .external_lex_state = 2},
  [582] = {.lex_state = 76, .external_lex_state = 2},
  [583] = {.lex_state = 76, .external_lex_state = 2},
  [584] = {.lex_state = 76, .external_lex_state = 2},
  [585] = {.lex_state = 76, .external_lex_state = 2},
  [586] = {.lex_state = 76, .external_lex_state = 2},
  [587] = {.lex_state = 76, .external_lex_state = 2},
  [588] = {.lex_state = 76, .external_lex_state = 2},
  [589] = {.lex_state = 76, .external_lex_state = 2},
  [590] = {.lex_state = 76, .external_lex_state = 2},
  [591] = {.lex_state = 76, .external_lex_state = 2},
  [592] = {.lex_state = 76, .external_lex_state = 2},
  [593] = {.lex_state = 76, .external_lex_state = 2},
  [594] = {.lex_state = 76, .external_lex_state = 2},
  [595] = {.lex_state = 76, .external_lex_state = 2},
  [596] = {.lex_state = 76, .external_lex_state = 2},
  [597] = {.lex_state = 76, .external_lex_state = 2},
  [598] = {.lex_state = 76, .external_lex_state = 2},
  [599] = {.lex_state = 76, .external_lex_state = 2},
  [600] = {.lex_state = 76, .external_lex_state = 2},
  [601] = {.lex_state = 76, .external_lex_state = 2},
  [602] = {.lex_state = 76, .external_lex_state = 2},
  [603] = {.lex_state = 76, .external_lex_state = 2},
  [604] = {.lex_state = 76, .external_lex_state = 2},
  [605] = {.lex_state = 76, .external_lex_state = 2},
  [606] = {.lex_state = 76, .external_lex_state = 2},
  [607] = {.lex_state = 76, .external_lex_state = 2},
  [608] = {.lex_state = 76, .external_lex_state = 2},
  [609] = {.lex_state = 76, .external_lex_state = 2},
  [610] = {.lex_state = 76, .external_lex_state = 2},
  [611] = {.lex_state = 76, .external_lex_state = 2},
  [612] = {.lex_state = 76, .external_lex_state = 2},
  [613] = {.lex_state = 76, .external_lex_state = 2},
  [614] = {.lex_state = 76, .external_lex_state = 2},
  [615] = {.lex_state = 76, .external_lex_state = 2},
  [616] = {.lex_state = 76, .external_lex_state = 2},
  [617] = {.lex_state = 76, .external_lex_state = 2},
  [618] = {.lex_state = 76, .external_lex_state = 2},
  [619] = {.lex_state = 76, .external_lex_state = 2},
  [620] = {.lex_state = 76, .external_lex_state = 2},
  [621] = {.lex_state = 76, .external_lex_state = 2},
  [622] = {.lex_state = 76, .external_lex_state = 2},
  [623] = {.lex_state = 76, .external_lex_state = 2},
  [624] = {.lex_state = 76, .external_lex_state = 2},
  [625] = {.lex_state = 76, .external_lex_state = 2},
  [626] = {.lex_state = 76, .external_lex_state = 2},
  [627] = {.lex_state = 76, .external_lex_state = 2},
  [628] = {.lex_state = 76, .external_lex_state = 2},
  [629] = {.lex_state = 76, .external_lex_state = 2},
  [630] = {.lex_state = 76, .external_lex_state = 2},
  [631] = {.lex_state = 76, .external_lex_state = 2},
  [632] = {.lex_state = 76, .external_lex_state = 2},
  [633] = {.lex_state = 76, .external_lex_state = 2},
  [634] = {.lex_state = 76, .external_lex_state = 2},
  [635] = {.lex_state = 76, .external_lex_state = 2},
  [636] = {.lex_state = 76, .external_lex_state = 2},
  [637] = {.lex_state = 76, .external_lex_state = 2},
  [638] = {.lex_state = 76, .external_lex_state = 2},
  [639] = {.lex_state = 76, .external_lex_state = 2},
  [640] = {.lex_state = 76, .external_lex_state = 2},
  [641] = {.lex_state = 76, .external_lex_state = 2},
  [642] = {.lex_state = 76, .external_lex_state = 2},
  [643] = {.lex_state = 76, .external_lex_state = 2},
  [644] = {.lex_state = 76, .external_lex_state = 2},
  [645] = {.lex_state = 76, .external_lex_state = 2},
  [646] = {.lex_state = 76, .external_lex_state = 2},
  [647] = {.lex_state = 76, .external_lex_state = 2},
  [648] = {.lex_state = 76, .external_lex_state = 2},
  [649] = {.lex_state = 76, .external_lex_state = 2},
  [650] = {.lex_state = 76, .external_lex_state = 2},
  [651] = {.lex_state = 76, .external_lex_state = 2},
  [652] = {.lex_state = 76, .external_lex_state = 2},
  [653] = {.lex_state = 76, .external_lex_state = 2},
  [654] = {.lex_state = 76, .external_lex_state = 2},
  [655] = {.lex_state = 76, .external_lex_state = 2},
  [656] = {.lex_state = 76, .external_lex_state = 2},
  [657] = {.lex_state = 76, .external_lex_state = 2},
  [658] = {.lex_state = 76, .external_lex_state = 2},
  [659] = {.lex_state = 76, .external_lex_state = 2},
  [660] = {.lex_state = 76, .external_lex_state = 2},
  [661] = {.lex_state = 76, .external_lex_state = 2},
  [662] = {.lex_state = 76, .external_lex_state = 2},
  [663] = {.lex_state = 76, .external_lex_state = 2},
  [664] = {.lex_state = 76, .external_lex_state = 2},
  [665] = {.lex_state = 76, .external_lex_state = 2},
  [666] = {.lex_state = 76, .external_lex_state = 2},
  [667] = {.lex_state = 76, .external_lex_state = 2},
  [668] = {.lex_state = 76, .external_lex_state = 2},
  [669] = {.lex_state = 76, .external_lex_state = 2},
  [670] = {.lex_state = 76, .external_lex_state = 2},
  [671] = {.lex_state = 76, .external_lex_state = 2},
  [672] = {.lex_state = 76, .external_lex_state = 2},
  [673] = {.lex_state = 76, .external_lex_state = 2},
  [674] = {.lex_state = 76, .external_lex_state = 2},
  [675] = {.lex_state = 76, .external_lex_state = 2},
  [676] = {.lex_state = 76, .external_lex_state = 2},
  [677] = {.lex_state = 76, .external_lex_state = 2},
  [678] = {.lex_state = 76, .external_lex_state = 2},
  [679] = {.lex_state = 76, .external_lex_state = 2},
  [680] = {.lex_state = 76, .external_lex_state = 2},
  [681] = {.lex_state = 76, .external_lex_state = 2},
  [682] = {.lex_state = 76, .external_lex_state = 2},
  [683] = {.lex_state = 76, .external_lex_state = 2},
  [684] = {.lex_state = 76, .external_lex_state = 2},
  [685] = {.lex_state = 76, .external_lex_state = 2},
  [686] = {.lex_state = 76, .external_lex_state = 2},
  [687] = {.lex_state = 3, .external_lex_state = 4},
  [688] = {.lex_state = 3, .external_lex_state = 4},
  [689] = {.lex_state = 3, .external_lex_state = 4},
  [690] = {.lex_state = 2, .external_lex_state = 4},
  [691] = {.lex_state = 2, .external_lex_state = 4},
  [692] = {.lex_state = 2, .external_lex_state = 4},
  [693] = {.lex_state = 2, .external_lex_state = 4},
  [694] = {.lex_state = 2, .external_lex_state = 4},
  [695] = {.lex_state = 2, .external_lex_state = 4},
  [696] = {.lex_state = 3, .external_lex_state = 4},
  [697] = {.lex_state = 3, .external_lex_state = 4},
  [698] = {.lex_state = 2, .external_lex_state = 4},
  [699] = {.lex_state = 2, .external_lex_state = 4},
  [700] = {.lex_state = 2, .external_lex_state = 4},
  [701] = {.lex_state = 2, .external_lex_state = 4},
  [702] = {.lex_state = 2, .external_lex_state = 4},
  [703] = {.lex_state = 2, .external_lex_state = 4},
  [704] = {.lex_state = 2, .external_lex_state = 4},
  [705] = {.lex_state = 2, .external_lex_state = 4},
  [706] = {.lex_state = 2, .external_lex_state = 4},
  [707] = {.lex_state = 76, .external_lex_state = 2},
  [708] = {.lex_state = 76, .external_lex_state = 2},
  [709] = {.lex_state = 2, .external_lex_state = 4},
  [710] = {.lex_state = 2, .external_lex_state = 4},
  [711] = {.lex_state = 76, .external_lex_state = 2},
  [712] = {.lex_state = 76, .external_lex_state = 2},
  [713] = {.lex_state = 76, .external_lex_state = 2},
  [714] = {.lex_state = 76, .external_lex_state = 2},
  [715] = {.lex_state = 76, .external_lex_state = 2},
  [716] = {.lex_state = 2, .external_lex_state = 4},
  [717] = {.lex_state = 2, .external_lex_state = 4},
  [718] = {.lex_state = 2, .external_lex_state = 4},
  [719] = {.lex_state = 2, .external_lex_state = 4},
  [720] = {.lex_state = 2, .external_lex_state = 4},
  [721] = {.lex_state = 2, .external_lex_state = 4},
  [722] = {.lex_state = 2, .external_lex_state = 4},
  [723] = {.lex_state = 2, .external_lex_state = 4},
  [724] = {.lex_state = 2, .external_lex_state = 3},
  [725] = {.lex_state = 2, .external_lex_state = 3},
  [726] = {.lex_state = 2, .external_lex_state = 3},
  [727] = {.lex_state = 2, .external_lex_state = 3},
  [728] = {.lex_state = 2, .external_lex_state = 4},
  [729] = {.lex_state = 2, .external_lex_state = 3},
  [730] = {.lex_state = 2, .external_lex_state = 4},
  [731] = {.lex_state = 2, .external_lex_state = 4},
  [732] = {.lex_state = 2, .external_lex_state = 4},
  [733] = {.lex_state = 2, .external_lex_state = 4},
  [734] = {.lex_state = 2, .external_lex_state = 4},
  [735] = {.lex_state = 2, .external_lex_state = 3},
  [736] = {.lex_state = 3, .external_lex_state = 3},
  [737] = {.lex_state = 2, .external_lex_state = 3},
  [738] = {.lex_state = 2, .external_lex_state = 3},
  [739] = {.lex_state = 2, .external_lex_state = 3},
  [740] = {.lex_state = 2, .external_lex_state = 3},
  [741] = {.lex_state = 2, .external_lex_state = 3},
  [742] = {.lex_state = 3, .external_lex_state = 3},
  [743] = {.lex_state = 76, .external_lex_state = 2},
  [744] = {.lex_state = 2, .external_lex_state = 4},
  [745] = {.lex_state = 2, .external_lex_state = 4},
  [746] = {.lex_state = 2, .external_lex_state = 3},
  [747] = {.lex_state = 2, .external_lex_state = 4},
  [748] = {.lex_state = 2, .external_lex_state = 3},
  [749] = {.lex_state = 76, .external_lex_state = 5},
  [750] = {.lex_state = 2, .external_lex_state = 4},
  [751] = {.lex_state = 2, .external_lex_state = 4},
  [752] = {.lex_state = 76, .external_lex_state = 5},
  [753] = {.lex_state = 2, .external_lex_state = 3},
  [754] = {.lex_state = 2, .external_lex_state = 3},
  [755] = {.lex_state = 76, .external_lex_state = 5},
  [756] = {.lex_state = 76, .external_lex_state = 5},
  [757] = {.lex_state = 2, .external_lex_state = 3},
  [758] = {.lex_state = 76, .external_lex_state = 5},
  [759] = {.lex_state = 76, .external_lex_state = 5},
  [760] = {.lex_state = 2, .external_lex_state = 3},
  [761] = {.lex_state = 2, .external_lex_state = 3},
  [762] = {.lex_state = 2, .external_lex_state = 3},
  [763] = {.lex_state = 2, .external_lex_state = 3},
  [764] = {.lex_state = 76, .external_lex_state = 5},
  [765] = {.lex_state = 2, .external_lex_state = 3},
  [766] = {.lex_state = 76, .external_lex_state = 2},
  [767] = {.lex_state = 76, .external_lex_state = 2},
  [768] = {.lex_state = 76, .external_lex_state = 5},
  [769] = {.lex_state = 2, .external_lex_state = 3},
  [770] = {.lex_state = 76, .external_lex_state = 2},
  [771] = {.lex_state = 2, .external_lex_state = 3},
  [772] = {.lex_state = 2, .external_lex_state = 3},
  [773] = {.lex_state = 2, .external_lex_state = 3},
  [774] = {.lex_state = 76, .external_lex_state = 2},
  [775] = {.lex_state = 2, .external_lex_state = 3},
  [776] = {.lex_state = 2, .external_lex_state = 3},
  [777] = {.lex_state = 2, .external_lex_state = 3},
  [778] = {.lex_state = 2, .external_lex_state = 3},
  [779] = {.lex_state = 2, .external_lex_state = 3},
  [780] = {.lex_state = 2, .external_lex_state = 3},
  [781] = {.lex_state = 76, .external_lex_state = 2},
  [782] = {.lex_state = 2, .external_lex_state = 3},
  [783] = {.lex_state = 2, .external_lex_state = 3},
  [784] = {.lex_state = 76, .external_lex_state = 5},
  [785] = {.lex_state = 76, .external_lex_state = 5},
  [786] = {.lex_state = 9, .external_lex_state = 2},
  [787] = {.lex_state = 76, .external_lex_state = 2},
  [788] = {.lex_state = 76, .external_lex_state = 2},
  [789] = {.lex_state = 76, .external_lex_state = 5},
  [790] = {.lex_state = 9, .external_lex_state = 2},
  [791] = {.lex_state = 76, .external_lex_state = 5},
  [792] = {.lex_state = 76, .external_lex_state = 2},
  [793] = {.lex_state = 76, .external_lex_state = 5},
  [794] = {.lex_state = 76, .external_lex_state = 2},
  [795] = {.lex_state = 76, .external_lex_state = 2},
  [796] = {.lex_state = 76, .external_lex_state = 5},
  [797] = {.lex_state = 76, .external_lex_state = 5},
  [798] = {.lex_state = 76, .external_lex_state = 2},
  [799] = {.lex_state = 76, .external_lex_state = 5},
  [800] = {.lex_state = 76, .external_lex_state = 5},
  [801] = {.lex_state = 76, .external_lex_state = 2},
  [802] = {.lex_state = 76, .external_lex_state = 5},
  [803] = {.lex_state = 76, .external_lex_state = 2},
  [804] = {.lex_state = 9, .external_lex_state = 2},
  [805] = {.lex_state = 9, .external_lex_state = 2},
  [806] = {.lex_state = 76, .external_lex_state = 5},
  [807] = {.lex_state = 76, .external_lex_state = 5},
  [808] = {.lex_state = 76, .external_lex_state = 5},
  [809] = {.lex_state = 9, .external_lex_state = 2},
  [810] = {.lex_state = 76, .external_lex_state = 5},
  [811] = {.lex_state = 76, .external_lex_state = 5},
  [812] = {.lex_state = 76, .external_lex_state = 2},
  [813] = {.lex_state = 76, .external_lex_state = 2},
  [814] = {.lex_state = 76, .external_lex_state = 2},
  [815] = {.lex_state = 76, .external_lex_state = 2},
  [816] = {.lex_state = 76, .external_lex_state = 2},
  [817] = {.lex_state = 76, .external_lex_state = 2},
  [818] = {.lex_state = 76, .external_lex_state = 2},
  [819] = {.lex_state = 76, .external_lex_state = 2},
  [820] = {.lex_state = 76, .external_lex_state = 2},
  [821] = {.lex_state = 76, .external_lex_state = 2},
  [822] = {.lex_state = 76, .external_lex_state = 2},
  [823] = {.lex_state = 76, .external_lex_state = 2},
  [824] = {.lex_state = 76, .external_lex_state = 2},
  [825] = {.lex_state = 76, .external_lex_state = 2},
  [826] = {.lex_state = 76, .external_lex_state = 2},
  [827] = {.lex_state = 76, .external_lex_state = 2},
  [828] = {.lex_state = 76, .external_lex_state = 2},
  [829] = {.lex_state = 76, .external_lex_state = 2},
  [830] = {.lex_state = 76, .external_lex_state = 2},
  [831] = {.lex_state = 76, .external_lex_state = 2},
  [832] = {.lex_state = 76, .external_lex_state = 2},
  [833] = {.lex_state = 76, .external_lex_state = 2},
  [834] = {.lex_state = 76, .external_lex_state = 2},
  [835] = {.lex_state = 9, .external_lex_state = 2},
  [836] = {.lex_state = 9, .external_lex_state = 2},
  [837] = {.lex_state = 9, .external_lex_state = 2},
  [838] = {.lex_state = 76, .external_lex_state = 2},
  [839] = {.lex_state = 76, .external_lex_state = 2},
  [840] = {.lex_state = 76, .external_lex_state = 2},
  [841] = {.lex_state = 76, .external_lex_state = 2},
  [842] = {.lex_state = 9, .external_lex_state = 2},
  [843] = {.lex_state = 9, .external_lex_state = 2},
  [844] = {.lex_state = 76, .external_lex_state = 2},
  [845] = {.lex_state = 76, .external_lex_state = 2},
  [846] = {.lex_state = 76, .external_lex_state = 2},
  [847] = {.lex_state = 76, .external_lex_state = 2},
  [848] = {.lex_state = 9, .external_lex_state = 2},
  [849] = {.lex_state = 9, .external_lex_state = 2},
  [850] = {.lex_state = 76, .external_lex_state = 2},
  [851] = {.lex_state = 76, .external_lex_state = 2},
  [852] = {.lex_state = 76, .external_lex_state = 2},
  [853] = {.lex_state = 76, .external_lex_state = 2},
  [854] = {.lex_state = 76, .external_lex_state = 2},
  [855] = {.lex_state = 76, .external_lex_state = 2},
  [856] = {.lex_state = 76, .external_lex_state = 2},
  [857] = {.lex_state = 76, .external_lex_state = 2},
  [858] = {.lex_state = 9, .external_lex_state = 2},
  [859] = {.lex_state = 9, .external_lex_state = 2},
  [860] = {.lex_state = 76, .external_lex_state = 2},
  [861] = {.lex_state = 76, .external_lex_state = 2},
  [862] = {.lex_state = 76, .external_lex_state = 2},
  [863] = {.lex_state = 76, .external_lex_state = 2},
  [864] = {.lex_state = 76, .external_lex_state = 2},
  [865] = {.lex_state = 76, .external_lex_state = 2},
  [866] = {.lex_state = 76, .external_lex_state = 2},
  [867] = {.lex_state = 76, .external_lex_state = 2},
  [868] = {.lex_state = 76, .external_lex_state = 2},
  [869] = {.lex_state = 76, .external_lex_state = 2},
  [870] = {.lex_state = 76, .external_lex_state = 2},
  [871] = {.lex_state = 76, .external_lex_state = 2},
  [872] = {.lex_state = 76, .external_lex_state = 2},
  [873] = {.lex_state = 9, .external_lex_state = 2},
  [874] = {.lex_state = 76, .external_lex_state = 2},
  [875] = {.lex_state = 76, .external_lex_state = 2},
  [876] = {.lex_state = 76, .external_lex_state = 2},
  [877] = {.lex_state = 76, .external_lex_state = 2},
  [878] = {.lex_state = 76, .external_lex_state = 2},
  [879] = {.lex_state = 76, .external_lex_state = 2},
  [880] = {.lex_state = 76, .external_lex_state = 2},
  [881] = {.lex_state = 76, .external_lex_state = 2},
  [882] = {.lex_state = 76, .external_lex_state = 2},
  [883] = {.lex_state = 76, .external_lex_state = 2},
  [884] = {.lex_state = 76, .external_lex_state = 2},
  [885] = {.lex_state = 76, .external_lex_state = 2},
  [886] = {.lex_state = 76, .external_lex_state = 2},
  [887] = {.lex_state = 76, .external_lex_state = 2},
  [888] = {.lex_state = 76, .external_lex_state = 2},
  [889] = {.lex_state = 76, .external_lex_state = 2},
  [890] = {.lex_state = 76, .external_lex_state = 2},
  [891] = {.lex_state = 76, .external_lex_state = 2},
  [892] = {.lex_state = 76, .external_lex_state = 2},
  [893] = {.lex_state = 76, .external_lex_state = 2},
  [894] = {.lex_state = 76, .external_lex_state = 2},
  [895] = {.lex_state = 76, .external_lex_state = 2},
  [896] = {.lex_state = 76, .external_lex_state = 2},
  [897] = {.lex_state = 76, .external_lex_state = 2},
  [898] = {.lex_state = 76, .external_lex_state = 2},
  [899] = {.lex_state = 76, .external_lex_state = 2},
  [900] = {.lex_state = 76, .external_lex_state = 2},
  [901] = {.lex_state = 76, .external_lex_state = 2},
  [902] = {.lex_state = 76, .external_lex_state = 2},
  [903] = {.lex_state = 76, .external_lex_state = 2},
  [904] = {.lex_state = 76, .external_lex_state = 2},
  [905] = {.lex_state = 76, .external_lex_state = 2},
  [906] = {.lex_state = 76, .external_lex_state = 2},
  [907] = {.lex_state = 76, .external_lex_state = 2},
  [908] = {.lex_state = 76, .external_lex_state = 2},
  [909] = {.lex_state = 76, .external_lex_state = 2},
  [910] = {.lex_state = 76, .external_lex_state = 2},
  [911] = {.lex_state = 76, .external_lex_state = 2},
  [912] = {.lex_state = 76, .external_lex_state = 2},
  [913] = {.lex_state = 76, .external_lex_state = 2},
  [914] = {.lex_state = 76, .external_lex_state = 2},
  [915] = {.lex_state = 76, .external_lex_state = 2},
  [916] = {.lex_state = 76, .external_lex_state = 2},
  [917] = {.lex_state = 76, .external_lex_state = 2},
  [918] = {.lex_state = 76, .external_lex_state = 2},
  [919] = {.lex_state = 76, .external_lex_state = 2},
  [920] = {.lex_state = 76, .external_lex_state = 2},
  [921] = {.lex_state = 76, .external_lex_state = 2},
  [922] = {.lex_state = 76, .external_lex_state = 2},
  [923] = {.lex_state = 76, .external_lex_state = 2},
  [924] = {.lex_state = 76, .external_lex_state = 2},
  [925] = {.lex_state = 76, .external_lex_state = 2},
  [926] = {.lex_state = 76, .external_lex_state = 2},
  [927] = {.lex_state = 76, .external_lex_state = 2},
  [928] = {.lex_state = 76, .external_lex_state = 2},
  [929] = {.lex_state = 76, .external_lex_state = 2},
  [930] = {.lex_state = 76, .external_lex_state = 2},
  [931] = {.lex_state = 76, .external_lex_state = 2},
  [932] = {.lex_state = 76, .external_lex_state = 2},
  [933] = {.lex_state = 76, .external_lex_state = 2},
  [934] = {.lex_state = 76, .external_lex_state = 2},
  [935] = {.lex_state = 76, .external_lex_state = 2},
  [936] = {.lex_state = 76, .external_lex_state = 2},
  [937] = {.lex_state = 76, .external_lex_state = 2},
  [938] = {.lex_state = 76, .external_lex_state = 2},
  [939] = {.lex_state = 76, .external_lex_state = 2},
  [940] = {.lex_state = 76, .external_lex_state = 2},
  [941] = {.lex_state = 76, .external_lex_state = 2},
  [942] = {.lex_state = 76, .external_lex_state = 2},
  [943] = {.lex_state = 76, .external_lex_state = 2},
  [944] = {.lex_state = 76, .external_lex_state = 2},
  [945] = {.lex_state = 9, .external_lex_state = 2},
  [946] = {.lex_state = 9, .external_lex_state = 2},
  [947] = {.lex_state = 76, .external_lex_state = 2},
  [948] = {.lex_state = 9, .external_lex_state = 2},
  [949] = {.lex_state = 9, .external_lex_state = 2},
  [950] = {.lex_state = 76, .external_lex_state = 2},
  [951] = {.lex_state = 76, .external_lex_state = 2},
  [952] = {.lex_state = 76, .external_lex_state = 2},
  [953] = {.lex_state = 76, .external_lex_state = 2},
  [954] = {.lex_state = 76, .external_lex_state = 2},
  [955] = {.lex_state = 76, .external_lex_state = 2},
  [956] = {.lex_state = 76, .external_lex_state = 2},
  [957] = {.lex_state = 76, .external_lex_state = 2},
  [958] = {.lex_state = 76, .external_lex_state = 2},
  [959] = {.lex_state = 76, .external_lex_state = 2},
  [960] = {.lex_state = 9, .external_lex_state = 2},
  [961] = {.lex_state = 9, .external_lex_state = 2},
  [962] = {.lex_state = 76, .external_lex_state = 2},
  [963] = {.lex_state = 9, .external_lex_state = 2},
  [964] = {.lex_state = 9, .external_lex_state = 2},
  [965] = {.lex_state = 9, .external_lex_state = 2},
  [966] = {.lex_state = 9, .external_lex_state = 2},
  [967] = {.lex_state = 9, .external_lex_state = 2},
  [968] = {.lex_state = 76, .external_lex_state = 2},
  [969] = {.lex_state = 9, .external_lex_state = 2},
  [970] = {.lex_state = 9, .external_lex_state = 2},
  [971] = {.lex_state = 76, .external_lex_state = 2},
  [972] = {.lex_state = 9, .external_lex_state = 2},
  [973] = {.lex_state = 9, .external_lex_state = 2},
  [974] = {.lex_state = 9, .external_lex_state = 2},
  [975] = {.lex_state = 9, .external_lex_state = 2},
  [976] = {.lex_state = 9, .external_lex_state = 2},
  [977] = {.lex_state = 9, .external_lex_state = 2},
  [978] = {.lex_state = 7, .external_lex_state = 2},
  [979] = {.lex_state = 9, .external_lex_state = 2},
  [980] = {.lex_state = 9, .external_lex_state = 2},
  [981] = {.lex_state = 9, .external_lex_state = 2},
  [982] = {.lex_state = 9, .external_lex_state = 2},
  [983] = {.lex_state = 9, .external_lex_state = 2},
  [984] = {.lex_state = 9, .external_lex_state = 2},
  [985] = {.lex_state = 9, .external_lex_state = 2},
  [986] = {.lex_state = 9, .external_lex_state = 2},
  [987] = {.lex_state = 9, .external_lex_state = 2},
  [988] = {.lex_state = 9, .external_lex_state = 2},
  [989] = {.lex_state = 9, .external_lex_state = 2},
  [990] = {.lex_state = 7, .external_lex_state = 2},
  [991] = {.lex_state = 9, .external_lex_state = 2},
  [992] = {.lex_state = 9, .external_lex_state = 2},
  [993] = {.lex_state = 9, .external_lex_state = 2},
  [994] = {.lex_state = 9, .external_lex_state = 2},
  [995] = {.lex_state = 9, .external_lex_state = 2},
  [996] = {.lex_state = 9, .external_lex_state = 2},
  [997] = {.lex_state = 7, .external_lex_state = 2},
  [998] = {.lex_state = 9, .external_lex_state = 2},
  [999] = {.lex_state = 9, .external_lex_state = 2},
  [1000] = {.lex_state = 9, .external_lex_state = 2},
  [1001] = {.lex_state = 9, .external_lex_state = 2},
  [1002] = {.lex_state = 9, .external_lex_state = 2},
  [1003] = {.lex_state = 9, .external_lex_state = 2},
  [1004] = {.lex_state = 9, .external_lex_state = 2},
  [1005] = {.lex_state = 9, .external_lex_state = 2},
  [1006] = {.lex_state = 9, .external_lex_state = 2},
  [1007] = {.lex_state = 9, .external_lex_state = 2},
  [1008] = {.lex_state = 9, .external_lex_state = 2},
  [1009] = {.lex_state = 9, .external_lex_state = 2},
  [1010] = {.lex_state = 9, .external_lex_state = 2},
  [1011] = {.lex_state = 9, .external_lex_state = 2},
  [1012] = {.lex_state = 9, .external_lex_state = 2},
  [1013] = {.lex_state = 9, .external_lex_state = 2},
  [1014] = {.lex_state = 9, .external_lex_state = 2},
  [1015] = {.lex_state = 9, .external_lex_state = 2},
  [1016] = {.lex_state = 9, .external_lex_state = 2},
  [1017] = {.lex_state = 9, .external_lex_state = 2},
  [1018] = {.lex_state = 9, .external_lex_state = 2},
  [1019] = {.lex_state = 9, .external_lex_state = 2},
  [1020] = {.lex_state = 9, .external_lex_state = 2},
  [1021] = {.lex_state = 9, .external_lex_state = 2},
  [1022] = {.lex_state = 9, .external_lex_state = 2},
  [1023] = {.lex_state = 9, .external_lex_state = 2},
  [1024] = {.lex_state = 9, .external_lex_state = 2},
  [1025] = {.lex_state = 9, .external_lex_state = 2},
  [1026] = {.lex_state = 9, .external_lex_state = 2},
  [1027] = {.lex_state = 9, .external_lex_state = 2},
  [1028] = {.lex_state = 9, .external_lex_state = 2},
  [1029] = {.lex_state = 9, .external_lex_state = 2},
  [1030] = {.lex_state = 9, .external_lex_state = 2},
  [1031] = {.lex_state = 9, .external_lex_state = 2},
  [1032] = {.lex_state = 9, .external_lex_state = 2},
  [1033] = {.lex_state = 9, .external_lex_state = 2},
  [1034] = {.lex_state = 9, .external_lex_state = 2},
  [1035] = {.lex_state = 9, .external_lex_state = 2},
  [1036] = {.lex_state = 9, .external_lex_state = 2},
  [1037] = {.lex_state = 9, .external_lex_state = 2},
  [1038] = {.lex_state = 9, .external_lex_state = 2},
  [1039] = {.lex_state = 9, .external_lex_state = 2},
  [1040] = {.lex_state = 9, .external_lex_state = 2},
  [1041] = {.lex_state = 9, .external_lex_state = 2},
  [1042] = {.lex_state = 9, .external_lex_state = 2},
  [1043] = {.lex_state = 9, .external_lex_state = 2},
  [1044] = {.lex_state = 9, .external_lex_state = 2},
  [1045] = {.lex_state = 9, .external_lex_state = 2},
  [1046] = {.lex_state = 9, .external_lex_state = 2},
  [1047] = {.lex_state = 9, .external_lex_state = 2},
  [1048] = {.lex_state = 9, .external_lex_state = 2},
  [1049] = {.lex_state = 9, .external_lex_state = 2},
  [1050] = {.lex_state = 9, .external_lex_state = 2},
  [1051] = {.lex_state = 9, .external_lex_state = 2},
  [1052] = {.lex_state = 9, .external_lex_state = 2},
  [1053] = {.lex_state = 9, .external_lex_state = 2},
  [1054] = {.lex_state = 9, .external_lex_state = 2},
  [1055] = {.lex_state = 9, .external_lex_state = 2},
  [1056] = {.lex_state = 9, .external_lex_state = 2},
  [1057] = {.lex_state = 9, .external_lex_state = 2},
  [1058] = {.lex_state = 9, .external_lex_state = 2},
  [1059] = {.lex_state = 9, .external_lex_state = 2},
  [1060] = {.lex_state = 9, .external_lex_state = 2},
  [1061] = {.lex_state = 9, .external_lex_state = 2},
  [1062] = {.lex_state = 9, .external_lex_state = 2},
  [1063] = {.lex_state = 9, .external_lex_state = 2},
  [1064] = {.lex_state = 9, .external_lex_state = 2},
  [1065] = {.lex_state = 9, .external_lex_state = 2},
  [1066] = {.lex_state = 9, .external_lex_state = 2},
  [1067] = {.lex_state = 9, .external_lex_state = 2},
  [1068] = {.lex_state = 9, .external_lex_state = 2},
  [1069] = {.lex_state = 9, .external_lex_state = 2},
  [1070] = {.lex_state = 9, .external_lex_state = 2},
  [1071] = {.lex_state = 9, .external_lex_state = 2},
  [1072] = {.lex_state = 9, .external_lex_state = 2},
  [1073] = {.lex_state = 9, .external_lex_state = 2},
  [1074] = {.lex_state = 9, .external_lex_state = 2},
  [1075] = {.lex_state = 9, .external_lex_state = 2},
  [1076] = {.lex_state = 9, .external_lex_state = 2},
  [1077] = {.lex_state = 9, .external_lex_state = 2},
  [1078] = {.lex_state = 9, .external_lex_state = 2},
  [1079] = {.lex_state = 9, .external_lex_state = 2},
  [1080] = {.lex_state = 9, .external_lex_state = 2},
  [1081] = {.lex_state = 9, .external_lex_state = 2},
  [1082] = {.lex_state = 9, .external_lex_state = 2},
  [1083] = {.lex_state = 9, .external_lex_state = 2},
  [1084] = {.lex_state = 9, .external_lex_state = 2},
  [1085] = {.lex_state = 9, .external_lex_state = 2},
  [1086] = {.lex_state = 9, .external_lex_state = 2},
  [1087] = {.lex_state = 9, .external_lex_state = 2},
  [1088] = {.lex_state = 9, .external_lex_state = 2},
  [1089] = {.lex_state = 9, .external_lex_state = 2},
  [1090] = {.lex_state = 9, .external_lex_state = 2},
  [1091] = {.lex_state = 9, .external_lex_state = 2},
  [1092] = {.lex_state = 9, .external_lex_state = 2},
  [1093] = {.lex_state = 9, .external_lex_state = 2},
  [1094] = {.lex_state = 9, .external_lex_state = 2},
  [1095] = {.lex_state = 9, .external_lex_state = 2},
  [1096] = {.lex_state = 9, .external_lex_state = 2},
  [1097] = {.lex_state = 9, .external_lex_state = 2},
  [1098] = {.lex_state = 9, .external_lex_state = 2},
  [1099] = {.lex_state = 9, .external_lex_state = 2},
  [1100] = {.lex_state = 9, .external_lex_state = 2},
  [1101] = {.lex_state = 9, .external_lex_state = 2},
  [1102] = {.lex_state = 9, .external_lex_state = 2},
  [1103] = {.lex_state = 9, .external_lex_state = 2},
  [1104] = {.lex_state = 9, .external_lex_state = 2},
  [1105] = {.lex_state = 9, .external_lex_state = 2},
  [1106] = {.lex_state = 9, .external_lex_state = 2},
  [1107] = {.lex_state = 9, .external_lex_state = 2},
  [1108] = {.lex_state = 9, .external_lex_state = 2},
  [1109] = {.lex_state = 9, .external_lex_state = 2},
  [1110] = {.lex_state = 9, .external_lex_state = 2},
  [1111] = {.lex_state = 9, .external_lex_state = 2},
  [1112] = {.lex_state = 9, .external_lex_state = 2},
  [1113] = {.lex_state = 9, .external_lex_state = 2},
  [1114] = {.lex_state = 9, .external_lex_state = 2},
  [1115] = {.lex_state = 9, .external_lex_state = 2},
  [1116] = {.lex_state = 9, .external_lex_state = 2},
  [1117] = {.lex_state = 9, .external_lex_state = 2},
  [1118] = {.lex_state = 9, .external_lex_state = 2},
  [1119] = {.lex_state = 9, .external_lex_state = 2},
  [1120] = {.lex_state = 9, .external_lex_state = 2},
  [1121] = {.lex_state = 9, .external_lex_state = 2},
  [1122] = {.lex_state = 9, .external_lex_state = 2},
  [1123] = {.lex_state = 9, .external_lex_state = 2},
  [1124] = {.lex_state = 9, .external_lex_state = 2},
  [1125] = {.lex_state = 9, .external_lex_state = 2},
  [1126] = {.lex_state = 9, .external_lex_state = 2},
  [1127] = {.lex_state = 9, .external_lex_state = 2},
  [1128] = {.lex_state = 9, .external_lex_state = 2},
  [1129] = {.lex_state = 9, .external_lex_state = 2},
  [1130] = {.lex_state = 9, .external_lex_state = 2},
  [1131] = {.lex_state = 9, .external_lex_state = 2},
  [1132] = {.lex_state = 9, .external_lex_state = 2},
  [1133] = {.lex_state = 9, .external_lex_state = 2},
  [1134] = {.lex_state = 9, .external_lex_state = 2},
  [1135] = {.lex_state = 9, .external_lex_state = 2},
  [1136] = {.lex_state = 9, .external_lex_state = 2},
  [1137] = {.lex_state = 9, .external_lex_state = 2},
  [1138] = {.lex_state = 9, .external_lex_state = 2},
  [1139] = {.lex_state = 9, .external_lex_state = 2},
  [1140] = {.lex_state = 9, .external_lex_state = 2},
  [1141] = {.lex_state = 9, .external_lex_state = 2},
  [1142] = {.lex_state = 9, .external_lex_state = 2},
  [1143] = {.lex_state = 9, .external_lex_state = 2},
  [1144] = {.lex_state = 9, .external_lex_state = 2},
  [1145] = {.lex_state = 9, .external_lex_state = 2},
  [1146] = {.lex_state = 9, .external_lex_state = 2},
  [1147] = {.lex_state = 9, .external_lex_state = 2},
  [1148] = {.lex_state = 9, .external_lex_state = 2},
  [1149] = {.lex_state = 9, .external_lex_state = 2},
  [1150] = {.lex_state = 9, .external_lex_state = 2},
  [1151] = {.lex_state = 10, .external_lex_state = 2},
  [1152] = {.lex_state = 10, .external_lex_state = 2},
  [1153] = {.lex_state = 10, .external_lex_state = 2},
  [1154] = {.lex_state = 10, .external_lex_state = 2},
  [1155] = {.lex_state = 10, .external_lex_state = 2},
  [1156] = {.lex_state = 10, .external_lex_state = 2},
  [1157] = {.lex_state = 10, .external_lex_state = 2},
  [1158] = {.lex_state = 10, .external_lex_state = 2},
  [1159] = {.lex_state = 10, .external_lex_state = 2},
  [1160] = {.lex_state = 10, .external_lex_state = 2},
  [1161] = {.lex_state = 10, .external_lex_state = 2},
  [1162] = {.lex_state = 10, .external_lex_state = 2},
  [1163] = {.lex_state = 2, .external_lex_state = 4},
  [1164] = {.lex_state = 2, .external_lex_state = 4},
  [1165] = {.lex_state = 76, .external_lex_state = 2},
  [1166] = {.lex_state = 2, .external_lex_state = 4},
  [1167] = {.lex_state = 76, .external_lex_state = 2},
  [1168] = {.lex_state = 2, .external_lex_state = 4},
  [1169] = {.lex_state = 2, .external_lex_state = 4},
  [1170] = {.lex_state = 2, .external_lex_state = 4},
  [1171] = {.lex_state = 3, .external_lex_state = 4},
  [1172] = {.lex_state = 3, .external_lex_state = 4},
  [1173] = {.lex_state = 3, .external_lex_state = 4},
  [1174] = {.lex_state = 76, .external_lex_state = 2},
  [1175] = {.lex_state = 2, .external_lex_state = 3},
  [1176] = {.lex_state = 2, .external_lex_state = 3},
  [1177] = {.lex_state = 2, .external_lex_state = 3},
  [1178] = {.lex_state = 10, .external_lex_state = 2},
  [1179] = {.lex_state = 2, .external_lex_state = 3},
  [1180] = {.lex_state = 10, .external_lex_state = 2},
  [1181] = {.lex_state = 2, .external_lex_state = 3},
  [1182] = {.lex_state = 3, .external_lex_state = 4},
  [1183] = {.lex_state = 2, .external_lex_state = 4},
  [1184] = {.lex_state = 3, .external_lex_state = 4},
  [1185] = {.lex_state = 2, .external_lex_state = 4},
  [1186] = {.lex_state = 2, .external_lex_state = 4},
  [1187] = {.lex_state = 2, .external_lex_state = 4},
  [1188] = {.lex_state = 2, .external_lex_state = 4},
  [1189] = {.lex_state = 2, .external_lex_state = 4},
  [1190] = {.lex_state = 2, .external_lex_state = 4},
  [1191] = {.lex_state = 2, .external_lex_state = 3},
  [1192] = {.lex_state = 2, .external_lex_state = 4},
  [1193] = {.lex_state = 3, .external_lex_state = 3},
  [1194] = {.lex_state = 3, .external_lex_state = 3},
  [1195] = {.lex_state = 2, .external_lex_state = 4},
  [1196] = {.lex_state = 3, .external_lex_state = 3},
  [1197] = {.lex_state = 3, .external_lex_state = 3},
  [1198] = {.lex_state = 3, .external_lex_state = 3},
  [1199] = {.lex_state = 3, .external_lex_state = 3},
  [1200] = {.lex_state = 3, .external_lex_state = 3},
  [1201] = {.lex_state = 2, .external_lex_state = 3},
  [1202] = {.lex_state = 2, .external_lex_state = 4},
  [1203] = {.lex_state = 2, .external_lex_state = 3},
  [1204] = {.lex_state = 2, .external_lex_state = 4},
  [1205] = {.lex_state = 2, .external_lex_state = 3},
  [1206] = {.lex_state = 3, .external_lex_state = 3},
  [1207] = {.lex_state = 3, .external_lex_state = 3},
  [1208] = {.lex_state = 3, .external_lex_state = 3},
  [1209] = {.lex_state = 3, .external_lex_state = 3},
  [1210] = {.lex_state = 3, .external_lex_state = 3},
  [1211] = {.lex_state = 2, .external_lex_state = 3},
  [1212] = {.lex_state = 2, .external_lex_state = 3},
  [1213] = {.lex_state = 2, .external_lex_state = 4},
  [1214] = {.lex_state = 2, .external_lex_state = 4},
  [1215] = {.lex_state = 2, .external_lex_state = 4},
  [1216] = {.lex_state = 2, .external_lex_state = 3},
  [1217] = {.lex_state = 2, .external_lex_state = 4},
  [1218] = {.lex_state = 2, .external_lex_state = 4},
  [1219] = {.lex_state = 2, .external_lex_state = 4},
  [1220] = {.lex_state = 3, .external_lex_state = 3},
  [1221] = {.lex_state = 2, .external_lex_state = 4},
  [1222] = {.lex_state = 2, .external_lex_state = 4},
  [1223] = {.lex_state = 3, .external_lex_state = 4},
  [1224] = {.lex_state = 2, .external_lex_state = 3},
  [1225] = {.lex_state = 2, .external_lex_state = 3},
  [1226] = {.lex_state = 3, .external_lex_state = 3},
  [1227] = {.lex_state = 3, .external_lex_state = 3},
  [1228] = {.lex_state = 2, .external_lex_state = 3},
  [1229] = {.lex_state = 2, .external_lex_state = 4},
  [1230] = {.lex_state = 2, .external_lex_state = 4},
  [1231] = {.lex_state = 2, .external_lex_state = 4},
  [1232] = {.lex_state = 2, .external_lex_state = 4},
  [1233] = {.lex_state = 3, .external_lex_state = 4},
  [1234] = {.lex_state = 76, .external_lex_state = 2},
  [1235] = {.lex_state = 2, .external_lex_state = 4},
  [1236] = {.lex_state = 2, .external_lex_state = 3},
  [1237] = {.lex_state = 2, .external_lex_state = 3},
  [1238] = {.lex_state = 2, .external_lex_state = 3},
  [1239] = {.lex_state = 2, .external_lex_state = 3},
  [1240] = {.lex_state = 2, .external_lex_state = 3},
  [1241] = {.lex_state = 2, .external_lex_state = 3},
  [1242] = {.lex_state = 2, .external_lex_state = 3},
  [1243] = {.lex_state = 2, .external_lex_state = 3},
  [1244] = {.lex_state = 2, .external_lex_state = 3},
  [1245] = {.lex_state = 2, .external_lex_state = 3},
  [1246] = {.lex_state = 2, .external_lex_state = 4},
  [1247] = {.lex_state = 2, .external_lex_state = 4},
  [1248] = {.lex_state = 3, .external_lex_state = 3},
  [1249] = {.lex_state = 2, .external_lex_state = 3},
  [1250] = {.lex_state = 2, .external_lex_state = 3},
  [1251] = {.lex_state = 2, .external_lex_state = 4},
  [1252] = {.lex_state = 2, .external_lex_state = 3},
  [1253] = {.lex_state = 2, .external_lex_state = 3},
  [1254] = {.lex_state = 2, .external_lex_state = 3},
  [1255] = {.lex_state = 2, .external_lex_state = 4},
  [1256] = {.lex_state = 2, .external_lex_state = 3},
  [1257] = {.lex_state = 2, .external_lex_state = 3},
  [1258] = {.lex_state = 76, .external_lex_state = 2},
  [1259] = {.lex_state = 2, .external_lex_state = 3},
  [1260] = {.lex_state = 2, .external_lex_state = 3},
  [1261] = {.lex_state = 2, .external_lex_state = 3},
  [1262] = {.lex_state = 2, .external_lex_state = 3},
  [1263] = {.lex_state = 2, .external_lex_state = 4},
  [1264] = {.lex_state = 3, .external_lex_state = 3},
  [1265] = {.lex_state = 2, .external_lex_state = 3},
  [1266] = {.lex_state = 76, .external_lex_state = 2},
  [1267] = {.lex_state = 2, .external_lex_state = 3},
  [1268] = {.lex_state = 2, .external_lex_state = 3},
  [1269] = {.lex_state = 2, .external_lex_state = 3},
  [1270] = {.lex_state = 2, .external_lex_state = 4},
  [1271] = {.lex_state = 2, .external_lex_state = 3},
  [1272] = {.lex_state = 2, .external_lex_state = 3},
  [1273] = {.lex_state = 2, .external_lex_state = 3},
  [1274] = {.lex_state = 2, .external_lex_state = 3},
  [1275] = {.lex_state = 2, .external_lex_state = 3},
  [1276] = {.lex_state = 2, .external_lex_state = 3},
  [1277] = {.lex_state = 2, .external_lex_state = 4},
  [1278] = {.lex_state = 76, .external_lex_state = 2},
  [1279] = {.lex_state = 2, .external_lex_state = 4},
  [1280] = {.lex_state = 2, .external_lex_state = 3},
  [1281] = {.lex_state = 2, .external_lex_state = 3},
  [1282] = {.lex_state = 2, .external_lex_state = 3},
  [1283] = {.lex_state = 2, .external_lex_state = 4},
  [1284] = {.lex_state = 2, .external_lex_state = 4},
  [1285] = {.lex_state = 2, .external_lex_state = 4},
  [1286] = {.lex_state = 2, .external_lex_state = 4},
  [1287] = {.lex_state = 2, .external_lex_state = 4},
  [1288] = {.lex_state = 2, .external_lex_state = 4},
  [1289] = {.lex_state = 2, .external_lex_state = 3},
  [1290] = {.lex_state = 2, .external_lex_state = 3},
  [1291] = {.lex_state = 76, .external_lex_state = 2},
  [1292] = {.lex_state = 2, .external_lex_state = 3},
  [1293] = {.lex_state = 3, .external_lex_state = 3},
  [1294] = {.lex_state = 2, .external_lex_state = 3},
  [1295] = {.lex_state = 2, .external_lex_state = 3},
  [1296] = {.lex_state = 76, .external_lex_state = 2},
  [1297] = {.lex_state = 2, .external_lex_state = 3},
  [1298] = {.lex_state = 2, .external_lex_state = 4},
  [1299] = {.lex_state = 2, .external_lex_state = 3},
  [1300] = {.lex_state = 2, .external_lex_state = 3},
  [1301] = {.lex_state = 2, .external_lex_state = 3},
  [1302] = {.lex_state = 2, .external_lex_state = 3},
  [1303] = {.lex_state = 2, .external_lex_state = 3},
  [1304] = {.lex_state = 2, .external_lex_state = 3},
  [1305] = {.lex_state = 2, .external_lex_state = 3},
  [1306] = {.lex_state = 2, .external_lex_state = 3},
  [1307] = {.lex_state = 2, .external_lex_state = 4},
  [1308] = {.lex_state = 76, .external_lex_state = 2},
  [1309] = {.lex_state = 2, .external_lex_state = 4},
  [1310] = {.lex_state = 2, .external_lex_state = 3},
  [1311] = {.lex_state = 2, .external_lex_state = 3},
  [1312] = {.lex_state = 2, .external_lex_state = 4},
  [1313] = {.lex_state = 3, .external_lex_state = 3},
  [1314] = {.lex_state = 2, .external_lex_state = 4},
  [1315] = {.lex_state = 2, .external_lex_state = 4},
  [1316] = {.lex_state = 2, .external_lex_state = 3},
  [1317] = {.lex_state = 2, .external_lex_state = 3},
  [1318] = {.lex_state = 2, .external_lex_state = 3},
  [1319] = {.lex_state = 2, .external_lex_state = 4},
  [1320] = {.lex_state = 2, .external_lex_state = 4},
  [1321] = {.lex_state = 2, .external_lex_state = 4},
  [1322] = {.lex_state = 2, .external_lex_state = 3},
  [1323] = {.lex_state = 2, .external_lex_state = 4},
  [1324] = {.lex_state = 2, .external_lex_state = 4},
  [1325] = {.lex_state = 2, .external_lex_state = 4},
  [1326] = {.lex_state = 2, .external_lex_state = 4},
  [1327] = {.lex_state = 2, .external_lex_state = 3},
  [1328] = {.lex_state = 2, .external_lex_state = 3},
  [1329] = {.lex_state = 2, .external_lex_state = 4},
  [1330] = {.lex_state = 2, .external_lex_state = 4},
  [1331] = {.lex_state = 2, .external_lex_state = 3},
  [1332] = {.lex_state = 2, .external_lex_state = 4},
  [1333] = {.lex_state = 2, .external_lex_state = 4},
  [1334] = {.lex_state = 2, .external_lex_state = 4},
  [1335] = {.lex_state = 2, .external_lex_state = 4},
  [1336] = {.lex_state = 2, .external_lex_state = 4},
  [1337] = {.lex_state = 2, .external_lex_state = 4},
  [1338] = {.lex_state = 2, .external_lex_state = 3},
  [1339] = {.lex_state = 76, .external_lex_state = 2},
  [1340] = {.lex_state = 2, .external_lex_state = 3},
  [1341] = {.lex_state = 2, .external_lex_state = 3},
  [1342] = {.lex_state = 2, .external_lex_state = 3},
  [1343] = {.lex_state = 2, .external_lex_state = 4},
  [1344] = {.lex_state = 2, .external_lex_state = 3},
  [1345] = {.lex_state = 76, .external_lex_state = 2},
  [1346] = {.lex_state = 2, .external_lex_state = 3},
  [1347] = {.lex_state = 2, .external_lex_state = 4},
  [1348] = {.lex_state = 2, .external_lex_state = 4},
  [1349] = {.lex_state = 2, .external_lex_state = 3},
  [1350] = {.lex_state = 2, .external_lex_state = 3},
  [1351] = {.lex_state = 2, .external_lex_state = 3},
  [1352] = {.lex_state = 2, .external_lex_state = 3},
  [1353] = {.lex_state = 2, .external_lex_state = 3},
  [1354] = {.lex_state = 2, .external_lex_state = 4},
  [1355] = {.lex_state = 2, .external_lex_state = 3},
  [1356] = {.lex_state = 3, .external_lex_state = 3},
  [1357] = {.lex_state = 3, .external_lex_state = 3},
  [1358] = {.lex_state = 2, .external_lex_state = 3},
  [1359] = {.lex_state = 2, .external_lex_state = 3},
  [1360] = {.lex_state = 2, .external_lex_state = 3},
  [1361] = {.lex_state = 2, .external_lex_state = 3},
  [1362] = {.lex_state = 2, .external_lex_state = 3},
  [1363] = {.lex_state = 2, .external_lex_state = 3},
  [1364] = {.lex_state = 2, .external_lex_state = 4},
  [1365] = {.lex_state = 2, .external_lex_state = 3},
  [1366] = {.lex_state = 2, .external_lex_state = 4},
  [1367] = {.lex_state = 2, .external_lex_state = 4},
  [1368] = {.lex_state = 2, .external_lex_state = 4},
  [1369] = {.lex_state = 2, .external_lex_state = 3},
  [1370] = {.lex_state = 2, .external_lex_state = 3},
  [1371] = {.lex_state = 2, .external_lex_state = 3},
  [1372] = {.lex_state = 2, .external_lex_state = 3},
  [1373] = {.lex_state = 2, .external_lex_state = 3},
  [1374] = {.lex_state = 2, .external_lex_state = 3},
  [1375] = {.lex_state = 3, .external_lex_state = 3},
  [1376] = {.lex_state = 3, .external_lex_state = 3},
  [1377] = {.lex_state = 2, .external_lex_state = 4},
  [1378] = {.lex_state = 2, .external_lex_state = 3},
  [1379] = {.lex_state = 9, .external_lex_state = 2},
  [1380] = {.lex_state = 2, .external_lex_state = 3},
  [1381] = {.lex_state = 9, .external_lex_state = 2},
  [1382] = {.lex_state = 2, .external_lex_state = 3},
  [1383] = {.lex_state = 2, .external_lex_state = 4},
  [1384] = {.lex_state = 2, .external_lex_state = 3},
  [1385] = {.lex_state = 9, .external_lex_state = 2},
  [1386] = {.lex_state = 2, .external_lex_state = 3},
  [1387] = {.lex_state = 2, .external_lex_state = 3},
  [1388] = {.lex_state = 2, .external_lex_state = 4},
  [1389] = {.lex_state = 2, .external_lex_state = 4},
  [1390] = {.lex_state = 2, .external_lex_state = 3},
  [1391] = {.lex_state = 2, .external_lex_state = 3},
  [1392] = {.lex_state = 2, .external_lex_state = 3},
  [1393] = {.lex_state = 3, .external_lex_state = 3},
  [1394] = {.lex_state = 2, .external_lex_state = 3},
  [1395] = {.lex_state = 9, .external_lex_state = 2},
  [1396] = {.lex_state = 2, .external_lex_state = 3},
  [1397] = {.lex_state = 2, .external_lex_state = 3},
  [1398] = {.lex_state = 2, .external_lex_state = 3},
  [1399] = {.lex_state = 9, .external_lex_state = 2},
  [1400] = {.lex_state = 2, .external_lex_state = 4},
  [1401] = {.lex_state = 9, .external_lex_state = 2},
  [1402] = {.lex_state = 2, .external_lex_state = 3},
  [1403] = {.lex_state = 2, .external_lex_state = 3},
  [1404] = {.lex_state = 2, .external_lex_state = 3},
  [1405] = {.lex_state = 2, .external_lex_state = 3},
  [1406] = {.lex_state = 2, .external_lex_state = 3},
  [1407] = {.lex_state = 2, .external_lex_state = 3},
  [1408] = {.lex_state = 2, .external_lex_state = 3},
  [1409] = {.lex_state = 2, .external_lex_state = 3},
  [1410] = {.lex_state = 2, .external_lex_state = 3},
  [1411] = {.lex_state = 2, .external_lex_state = 3},
  [1412] = {.lex_state = 2, .external_lex_state = 3},
  [1413] = {.lex_state = 2, .external_lex_state = 3},
  [1414] = {.lex_state = 2, .external_lex_state = 4},
  [1415] = {.lex_state = 2, .external_lex_state = 3},
  [1416] = {.lex_state = 2, .external_lex_state = 3},
  [1417] = {.lex_state = 2, .external_lex_state = 3},
  [1418] = {.lex_state = 2, .external_lex_state = 3},
  [1419] = {.lex_state = 2, .external_lex_state = 3},
  [1420] = {.lex_state = 9, .external_lex_state = 2},
  [1421] = {.lex_state = 2, .external_lex_state = 3},
  [1422] = {.lex_state = 9, .external_lex_state = 2},
  [1423] = {.lex_state = 2, .external_lex_state = 3},
  [1424] = {.lex_state = 9, .external_lex_state = 2},
  [1425] = {.lex_state = 9, .external_lex_state = 2},
  [1426] = {.lex_state = 9, .external_lex_state = 2},
  [1427] = {.lex_state = 9, .external_lex_state = 2},
  [1428] = {.lex_state = 9, .external_lex_state = 2},
  [1429] = {.lex_state = 9, .external_lex_state = 2},
  [1430] = {.lex_state = 9, .external_lex_state = 2},
  [1431] = {.lex_state = 9, .external_lex_state = 2},
  [1432] = {.lex_state = 9, .external_lex_state = 2},
  [1433] = {.lex_state = 9, .external_lex_state = 2},
  [1434] = {.lex_state = 9, .external_lex_state = 2},
  [1435] = {.lex_state = 2, .external_lex_state = 3},
  [1436] = {.lex_state = 2, .external_lex_state = 3},
  [1437] = {.lex_state = 9, .external_lex_state = 2},
  [1438] = {.lex_state = 9, .external_lex_state = 2},
  [1439] = {.lex_state = 9, .external_lex_state = 2},
  [1440] = {.lex_state = 9, .external_lex_state = 2},
  [1441] = {.lex_state = 9, .external_lex_state = 2},
  [1442] = {.lex_state = 2, .external_lex_state = 3},
  [1443] = {.lex_state = 2, .external_lex_state = 3},
  [1444] = {.lex_state = 9, .external_lex_state = 2},
  [1445] = {.lex_state = 9, .external_lex_state = 2},
  [1446] = {.lex_state = 9, .external_lex_state = 2},
  [1447] = {.lex_state = 9, .external_lex_state = 2},
  [1448] = {.lex_state = 2, .external_lex_state = 3},
  [1449] = {.lex_state = 2, .external_lex_state = 3},
  [1450] = {.lex_state = 9, .external_lex_state = 2},
  [1451] = {.lex_state = 2, .external_lex_state = 3},
  [1452] = {.lex_state = 9, .external_lex_state = 2},
  [1453] = {.lex_state = 2, .external_lex_state = 3},
  [1454] = {.lex_state = 2, .external_lex_state = 3},
  [1455] = {.lex_state = 2, .external_lex_state = 3},
  [1456] = {.lex_state = 2, .external_lex_state = 3},
  [1457] = {.lex_state = 9, .external_lex_state = 2},
  [1458] = {.lex_state = 2, .external_lex_state = 3},
  [1459] = {.lex_state = 2, .external_lex_state = 3},
  [1460] = {.lex_state = 2, .external_lex_state = 3},
  [1461] = {.lex_state = 9, .external_lex_state = 2},
  [1462] = {.lex_state = 9, .external_lex_state = 2},
  [1463] = {.lex_state = 2, .external_lex_state = 3},
  [1464] = {.lex_state = 2, .external_lex_state = 3},
  [1465] = {.lex_state = 2, .external_lex_state = 3},
  [1466] = {.lex_state = 2, .external_lex_state = 3},
  [1467] = {.lex_state = 9, .external_lex_state = 2},
  [1468] = {.lex_state = 2, .external_lex_state = 3},
  [1469] = {.lex_state = 2, .external_lex_state = 3},
  [1470] = {.lex_state = 2, .external_lex_state = 3},
  [1471] = {.lex_state = 9, .external_lex_state = 2},
  [1472] = {.lex_state = 2, .external_lex_state = 3},
  [1473] = {.lex_state = 2, .external_lex_state = 3},
  [1474] = {.lex_state = 2, .external_lex_state = 3},
  [1475] = {.lex_state = 2, .external_lex_state = 3},
  [1476] = {.lex_state = 2, .external_lex_state = 3},
  [1477] = {.lex_state = 2, .external_lex_state = 3},
  [1478] = {.lex_state = 2, .external_lex_state = 3},
  [1479] = {.lex_state = 2, .external_lex_state = 3},
  [1480] = {.lex_state = 2, .external_lex_state = 3},
  [1481] = {.lex_state = 2, .external_lex_state = 3},
  [1482] = {.lex_state = 2, .external_lex_state = 3},
  [1483] = {.lex_state = 2, .external_lex_state = 3},
  [1484] = {.lex_state = 2, .external_lex_state = 3},
  [1485] = {.lex_state = 9, .external_lex_state = 2},
  [1486] = {.lex_state = 9, .external_lex_state = 2},
  [1487] = {.lex_state = 9, .external_lex_state = 2},
  [1488] = {.lex_state = 9, .external_lex_state = 2},
  [1489] = {.lex_state = 9, .external_lex_state = 2},
  [1490] = {.lex_state = 9, .external_lex_state = 2},
  [1491] = {.lex_state = 9, .external_lex_state = 2},
  [1492] = {.lex_state = 76, .external_lex_state = 5},
  [1493] = {.lex_state = 76, .external_lex_state = 5},
  [1494] = {.lex_state = 76, .external_lex_state = 5},
  [1495] = {.lex_state = 76, .external_lex_state = 5},
  [1496] = {.lex_state = 76, .external_lex_state = 5},
  [1497] = {.lex_state = 75, .external_lex_state = 3},
  [1498] = {.lex_state = 76, .external_lex_state = 2},
  [1499] = {.lex_state = 76, .external_lex_state = 2},
  [1500] = {.lex_state = 76, .external_lex_state = 2},
  [1501] = {.lex_state = 76, .external_lex_state = 2},
  [1502] = {.lex_state = 76, .external_lex_state = 2},
  [1503] = {.lex_state = 76, .external_lex_state = 2},
  [1504] = {.lex_state = 76, .external_lex_state = 5},
  [1505] = {.lex_state = 75, .external_lex_state = 3},
  [1506] = {.lex_state = 75, .external_lex_state = 3},
  [1507] = {.lex_state = 75, .external_lex_state = 4},
  [1508] = {.lex_state = 76, .external_lex_state = 5},
  [1509] = {.lex_state = 75, .external_lex_state = 4},
  [1510] = {.lex_state = 75, .external_lex_state = 3},
  [1511] = {.lex_state = 75, .external_lex_state = 3},
  [1512] = {.lex_state = 75, .external_lex_state = 3},
  [1513] = {.lex_state = 75, .external_lex_state = 3},
  [1514] = {.lex_state = 75, .external_lex_state = 3},
  [1515] = {.lex_state = 75, .external_lex_state = 3},
  [1516] = {.lex_state = 75, .external_lex_state = 3},
  [1517] = {.lex_state = 75, .external_lex_state = 3},
  [1518] = {.lex_state = 75, .external_lex_state = 3},
  [1519] = {.lex_state = 75, .external_lex_state = 3},
  [1520] = {.lex_state = 75, .external_lex_state = 3},
  [1521] = {.lex_state = 76, .external_lex_state = 2},
  [1522] = {.lex_state = 75, .external_lex_state = 3},
  [1523] = {.lex_state = 75, .external_lex_state = 3},
  [1524] = {.lex_state = 75, .external_lex_state = 3},
  [1525] = {.lex_state = 75, .external_lex_state = 4},
  [1526] = {.lex_state = 75, .external_lex_state = 3},
  [1527] = {.lex_state = 75, .external_lex_state = 3},
  [1528] = {.lex_state = 75, .external_lex_state = 3},
  [1529] = {.lex_state = 75, .external_lex_state = 3},
  [1530] = {.lex_state = 75, .external_lex_state = 3},
  [1531] = {.lex_state = 75, .external_lex_state = 3},
  [1532] = {.lex_state = 75, .external_lex_state = 3},
  [1533] = {.lex_state = 75, .external_lex_state = 3},
  [1534] = {.lex_state = 75, .external_lex_state = 3},
  [1535] = {.lex_state = 75, .external_lex_state = 3},
  [1536] = {.lex_state = 75, .external_lex_state = 3},
  [1537] = {.lex_state = 75, .external_lex_state = 3},
  [1538] = {.lex_state = 75, .external_lex_state = 3},
  [1539] = {.lex_state = 75, .external_lex_state = 3},
  [1540] = {.lex_state = 75, .external_lex_state = 3},
  [1541] = {.lex_state = 75, .external_lex_state = 3},
  [1542] = {.lex_state = 75, .external_lex_state = 3},
  [1543] = {.lex_state = 75, .external_lex_state = 3},
  [1544] = {.lex_state = 75, .external_lex_state = 3},
  [1545] = {.lex_state = 75, .external_lex_state = 3},
  [1546] = {.lex_state = 75, .external_lex_state = 3},
  [1547] = {.lex_state = 75, .external_lex_state = 3},
  [1548] = {.lex_state = 75, .external_lex_state = 3},
  [1549] = {.lex_state = 75, .external_lex_state = 3},
  [1550] = {.lex_state = 75, .external_lex_state = 3},
  [1551] = {.lex_state = 75, .external_lex_state = 3},
  [1552] = {.lex_state = 75, .external_lex_state = 3},
  [1553] = {.lex_state = 75, .external_lex_state = 3},
  [1554] = {.lex_state = 75, .external_lex_state = 3},
  [1555] = {.lex_state = 75, .external_lex_state = 3},
  [1556] = {.lex_state = 75, .external_lex_state = 3},
  [1557] = {.lex_state = 75, .external_lex_state = 3},
  [1558] = {.lex_state = 75, .external_lex_state = 3},
  [1559] = {.lex_state = 75, .external_lex_state = 3},
  [1560] = {.lex_state = 75, .external_lex_state = 3},
  [1561] = {.lex_state = 75, .external_lex_state = 3},
  [1562] = {.lex_state = 75, .external_lex_state = 3},
  [1563] = {.lex_state = 75, .external_lex_state = 3},
  [1564] = {.lex_state = 75, .external_lex_state = 3},
  [1565] = {.lex_state = 75, .external_lex_state = 3},
  [1566] = {.lex_state = 75, .external_lex_state = 3},
  [1567] = {.lex_state = 75, .external_lex_state = 4},
  [1568] = {.lex_state = 75, .external_lex_state = 3},
  [1569] = {.lex_state = 75, .external_lex_state = 3},
  [1570] = {.lex_state = 75, .external_lex_state = 3},
  [1571] = {.lex_state = 75, .external_lex_state = 3},
  [1572] = {.lex_state = 75, .external_lex_state = 3},
  [1573] = {.lex_state = 75, .external_lex_state = 3},
  [1574] = {.lex_state = 75, .external_lex_state = 3},
  [1575] = {.lex_state = 75, .external_lex_state = 3},
  [1576] = {.lex_state = 75, .external_lex_state = 3},
  [1577] = {.lex_state = 75, .external_lex_state = 3},
  [1578] = {.lex_state = 75, .external_lex_state = 3},
  [1579] = {.lex_state = 75, .external_lex_state = 3},
  [1580] = {.lex_state = 75, .external_lex_state = 3},
  [1581] = {.lex_state = 75, .external_lex_state = 3},
  [1582] = {.lex_state = 75, .external_lex_state = 3},
  [1583] = {.lex_state = 75, .external_lex_state = 3},
  [1584] = {.lex_state = 75, .external_lex_state = 3},
  [1585] = {.lex_state = 75, .external_lex_state = 3},
  [1586] = {.lex_state = 75, .external_lex_state = 3},
  [1587] = {.lex_state = 75, .external_lex_state = 3},
  [1588] = {.lex_state = 75, .external_lex_state = 4},
  [1589] = {.lex_state = 75, .external_lex_state = 4},
  [1590] = {.lex_state = 75, .external_lex_state = 3},
  [1591] = {.lex_state = 75, .external_lex_state = 4},
  [1592] = {.lex_state = 75, .external_lex_state = 3},
  [1593] = {.lex_state = 75, .external_lex_state = 3},
  [1594] = {.lex_state = 75, .external_lex_state = 3},
  [1595] = {.lex_state = 75, .external_lex_state = 3},
  [1596] = {.lex_state = 75, .external_lex_state = 3},
  [1597] = {.lex_state = 75, .external_lex_state = 3},
  [1598] = {.lex_state = 75, .external_lex_state = 3},
  [1599] = {.lex_state = 75, .external_lex_state = 3},
  [1600] = {.lex_state = 75, .external_lex_state = 3},
  [1601] = {.lex_state = 75, .external_lex_state = 3},
  [1602] = {.lex_state = 75, .external_lex_state = 3},
  [1603] = {.lex_state = 75, .external_lex_state = 3},
  [1604] = {.lex_state = 75, .external_lex_state = 3},
  [1605] = {.lex_state = 75, .external_lex_state = 3},
  [1606] = {.lex_state = 75, .external_lex_state = 3},
  [1607] = {.lex_state = 75, .external_lex_state = 3},
  [1608] = {.lex_state = 75, .external_lex_state = 3},
  [1609] = {.lex_state = 75, .external_lex_state = 3},
  [1610] = {.lex_state = 75, .external_lex_state = 3},
  [1611] = {.lex_state = 75, .external_lex_state = 3},
  [1612] = {.lex_state = 75, .external_lex_state = 3},
  [1613] = {.lex_state = 75, .external_lex_state = 3},
  [1614] = {.lex_state = 75, .external_lex_state = 3},
  [1615] = {.lex_state = 75, .external_lex_state = 3},
  [1616] = {.lex_state = 75, .external_lex_state = 3},
  [1617] = {.lex_state = 75, .external_lex_state = 3},
  [1618] = {.lex_state = 75, .external_lex_state = 3},
  [1619] = {.lex_state = 75, .external_lex_state = 3},
  [1620] = {.lex_state = 75, .external_lex_state = 3},
  [1621] = {.lex_state = 75, .external_lex_state = 3},
  [1622] = {.lex_state = 75, .external_lex_state = 3},
  [1623] = {.lex_state = 75, .external_lex_state = 3},
  [1624] = {.lex_state = 75, .external_lex_state = 3},
  [1625] = {.lex_state = 75, .external_lex_state = 3},
  [1626] = {.lex_state = 75, .external_lex_state = 3},
  [1627] = {.lex_state = 75, .external_lex_state = 3},
  [1628] = {.lex_state = 75, .external_lex_state = 3},
  [1629] = {.lex_state = 75, .external_lex_state = 3},
  [1630] = {.lex_state = 75, .external_lex_state = 3},
  [1631] = {.lex_state = 75, .external_lex_state = 3},
  [1632] = {.lex_state = 75, .external_lex_state = 3},
  [1633] = {.lex_state = 75, .external_lex_state = 3},
  [1634] = {.lex_state = 75, .external_lex_state = 3},
  [1635] = {.lex_state = 75, .external_lex_state = 3},
  [1636] = {.lex_state = 75, .external_lex_state = 3},
  [1637] = {.lex_state = 75, .external_lex_state = 3},
  [1638] = {.lex_state = 75, .external_lex_state = 3},
  [1639] = {.lex_state = 75, .external_lex_state = 3},
  [1640] = {.lex_state = 75, .external_lex_state = 3},
  [1641] = {.lex_state = 75, .external_lex_state = 3},
  [1642] = {.lex_state = 75, .external_lex_state = 3},
  [1643] = {.lex_state = 75, .external_lex_state = 3},
  [1644] = {.lex_state = 75, .external_lex_state = 3},
  [1645] = {.lex_state = 75, .external_lex_state = 3},
  [1646] = {.lex_state = 75, .external_lex_state = 4},
  [1647] = {.lex_state = 75, .external_lex_state = 3},
  [1648] = {.lex_state = 75, .external_lex_state = 3},
  [1649] = {.lex_state = 75, .external_lex_state = 3},
  [1650] = {.lex_state = 75, .external_lex_state = 3},
  [1651] = {.lex_state = 75, .external_lex_state = 3},
  [1652] = {.lex_state = 75, .external_lex_state = 3},
  [1653] = {.lex_state = 75, .external_lex_state = 3},
  [1654] = {.lex_state = 75, .external_lex_state = 3},
  [1655] = {.lex_state = 75, .external_lex_state = 3},
  [1656] = {.lex_state = 75, .external_lex_state = 3},
  [1657] = {.lex_state = 75, .external_lex_state = 3},
  [1658] = {.lex_state = 75, .external_lex_state = 3},
  [1659] = {.lex_state = 75, .external_lex_state = 3},
  [1660] = {.lex_state = 75, .external_lex_state = 3},
  [1661] = {.lex_state = 75, .external_lex_state = 3},
  [1662] = {.lex_state = 75, .external_lex_state = 3},
  [1663] = {.lex_state = 75, .external_lex_state = 3},
  [1664] = {.lex_state = 75, .external_lex_state = 3},
  [1665] = {.lex_state = 75, .external_lex_state = 3},
  [1666] = {.lex_state = 75, .external_lex_state = 3},
  [1667] = {.lex_state = 75, .external_lex_state = 3},
  [1668] = {.lex_state = 75, .external_lex_state = 4},
  [1669] = {.lex_state = 75, .external_lex_state = 3},
  [1670] = {.lex_state = 75, .external_lex_state = 3},
  [1671] = {.lex_state = 75, .external_lex_state = 3},
  [1672] = {.lex_state = 75, .external_lex_state = 3},
  [1673] = {.lex_state = 75, .external_lex_state = 3},
  [1674] = {.lex_state = 75, .external_lex_state = 3},
  [1675] = {.lex_state = 75, .external_lex_state = 3},
  [1676] = {.lex_state = 75, .external_lex_state = 3},
  [1677] = {.lex_state = 75, .external_lex_state = 3},
  [1678] = {.lex_state = 75, .external_lex_state = 3},
  [1679] = {.lex_state = 75, .external_lex_state = 3},
  [1680] = {.lex_state = 76, .external_lex_state = 5},
  [1681] = {.lex_state = 75, .external_lex_state = 3},
  [1682] = {.lex_state = 75, .external_lex_state = 3},
  [1683] = {.lex_state = 75, .external_lex_state = 3},
  [1684] = {.lex_state = 75, .external_lex_state = 3},
  [1685] = {.lex_state = 75, .external_lex_state = 3},
  [1686] = {.lex_state = 75, .external_lex_state = 3},
  [1687] = {.lex_state = 75, .external_lex_state = 3},
  [1688] = {.lex_state = 75, .external_lex_state = 3},
  [1689] = {.lex_state = 75, .external_lex_state = 3},
  [1690] = {.lex_state = 75, .external_lex_state = 3},
  [1691] = {.lex_state = 75, .external_lex_state = 3},
  [1692] = {.lex_state = 75, .external_lex_state = 3},
  [1693] = {.lex_state = 76, .external_lex_state = 5},
  [1694] = {.lex_state = 76, .external_lex_state = 5},
  [1695] = {.lex_state = 75, .external_lex_state = 3},
  [1696] = {.lex_state = 75, .external_lex_state = 3},
  [1697] = {.lex_state = 75, .external_lex_state = 3},
  [1698] = {.lex_state = 75, .external_lex_state = 3},
  [1699] = {.lex_state = 75, .external_lex_state = 3},
  [1700] = {.lex_state = 75, .external_lex_state = 3},
  [1701] = {.lex_state = 75, .external_lex_state = 3},
  [1702] = {.lex_state = 75, .external_lex_state = 3},
  [1703] = {.lex_state = 75, .external_lex_state = 3},
  [1704] = {.lex_state = 75, .external_lex_state = 3},
  [1705] = {.lex_state = 75, .external_lex_state = 3},
  [1706] = {.lex_state = 75, .external_lex_state = 3},
  [1707] = {.lex_state = 75, .external_lex_state = 3},
  [1708] = {.lex_state = 75, .external_lex_state = 3},
  [1709] = {.lex_state = 75, .external_lex_state = 3},
  [1710] = {.lex_state = 75, .external_lex_state = 3},
  [1711] = {.lex_state = 76, .external_lex_state = 5},
  [1712] = {.lex_state = 76, .external_lex_state = 5},
  [1713] = {.lex_state = 75, .external_lex_state = 3},
  [1714] = {.lex_state = 75, .external_lex_state = 3},
  [1715] = {.lex_state = 75, .external_lex_state = 4},
  [1716] = {.lex_state = 75, .external_lex_state = 4},
  [1717] = {.lex_state = 75, .external_lex_state = 3},
  [1718] = {.lex_state = 75, .external_lex_state = 3},
  [1719] = {.lex_state = 75, .external_lex_state = 3},
  [1720] = {.lex_state = 75, .external_lex_state = 3},
  [1721] = {.lex_state = 75, .external_lex_state = 3},
  [1722] = {.lex_state = 75, .external_lex_state = 3},
  [1723] = {.lex_state = 75, .external_lex_state = 3},
  [1724] = {.lex_state = 75, .external_lex_state = 3},
  [1725] = {.lex_state = 75, .external_lex_state = 3},
  [1726] = {.lex_state = 75, .external_lex_state = 3},
  [1727] = {.lex_state = 76, .external_lex_state = 5},
  [1728] = {.lex_state = 75, .external_lex_state = 4},
  [1729] = {.lex_state = 75, .external_lex_state = 4},
  [1730] = {.lex_state = 75, .external_lex_state = 4},
  [1731] = {.lex_state = 75, .external_lex_state = 3},
  [1732] = {.lex_state = 75, .external_lex_state = 3},
  [1733] = {.lex_state = 75, .external_lex_state = 3},
  [1734] = {.lex_state = 76, .external_lex_state = 5},
  [1735] = {.lex_state = 75, .external_lex_state = 4},
  [1736] = {.lex_state = 75, .external_lex_state = 3},
  [1737] = {.lex_state = 75, .external_lex_state = 4},
  [1738] = {.lex_state = 75, .external_lex_state = 3},
  [1739] = {.lex_state = 75, .external_lex_state = 3},
  [1740] = {.lex_state = 76, .external_lex_state = 5},
  [1741] = {.lex_state = 75, .external_lex_state = 3},
  [1742] = {.lex_state = 75, .external_lex_state = 3},
  [1743] = {.lex_state = 75, .external_lex_state = 4},
  [1744] = {.lex_state = 75, .external_lex_state = 3},
  [1745] = {.lex_state = 75, .external_lex_state = 3},
  [1746] = {.lex_state = 75, .external_lex_state = 3},
  [1747] = {.lex_state = 76, .external_lex_state = 5},
  [1748] = {.lex_state = 76, .external_lex_state = 5},
  [1749] = {.lex_state = 76, .external_lex_state = 5},
  [1750] = {.lex_state = 76, .external_lex_state = 5},
  [1751] = {.lex_state = 75, .external_lex_state = 4},
  [1752] = {.lex_state = 76, .external_lex_state = 5},
  [1753] = {.lex_state = 76, .external_lex_state = 5},
  [1754] = {.lex_state = 75, .external_lex_state = 4},
  [1755] = {.lex_state = 76, .external_lex_state = 5},
  [1756] = {.lex_state = 75, .external_lex_state = 4},
  [1757] = {.lex_state = 76, .external_lex_state = 5},
  [1758] = {.lex_state = 75, .external_lex_state = 3},
  [1759] = {.lex_state = 75, .external_lex_state = 3},
  [1760] = {.lex_state = 76, .external_lex_state = 5},
  [1761] = {.lex_state = 75, .external_lex_state = 4},
  [1762] = {.lex_state = 76, .external_lex_state = 5},
  [1763] = {.lex_state = 75, .external_lex_state = 3},
  [1764] = {.lex_state = 75, .external_lex_state = 3},
  [1765] = {.lex_state = 75, .external_lex_state = 3},
  [1766] = {.lex_state = 75, .external_lex_state = 3},
  [1767] = {.lex_state = 75, .external_lex_state = 3},
  [1768] = {.lex_state = 75, .external_lex_state = 3},
  [1769] = {.lex_state = 75, .external_lex_state = 3},
  [1770] = {.lex_state = 75, .external_lex_state = 3},
  [1771] = {.lex_state = 75, .external_lex_state = 3},
  [1772] = {.lex_state = 75, .external_lex_state = 4},
  [1773] = {.lex_state = 75, .external_lex_state = 3},
  [1774] = {.lex_state = 75, .external_lex_state = 3},
  [1775] = {.lex_state = 75, .external_lex_state = 3},
  [1776] = {.lex_state = 75, .external_lex_state = 3},
  [1777] = {.lex_state = 75, .external_lex_state = 3},
  [1778] = {.lex_state = 75, .external_lex_state = 4},
  [1779] = {.lex_state = 75, .external_lex_state = 3},
  [1780] = {.lex_state = 75, .external_lex_state = 3},
  [1781] = {.lex_state = 75, .external_lex_state = 3},
  [1782] = {.lex_state = 75, .external_lex_state = 3},
  [1783] = {.lex_state = 75, .external_lex_state = 4},
  [1784] = {.lex_state = 75, .external_lex_state = 4},
  [1785] = {.lex_state = 75, .external_lex_state = 4},
  [1786] = {.lex_state = 75, .external_lex_state = 3},
  [1787] = {.lex_state = 75, .external_lex_state = 4},
  [1788] = {.lex_state = 75, .external_lex_state = 4},
  [1789] = {.lex_state = 75, .external_lex_state = 4},
  [1790] = {.lex_state = 75, .external_lex_state = 4},
  [1791] = {.lex_state = 75, .external_lex_state = 4},
  [1792] = {.lex_state = 75, .external_lex_state = 4},
  [1793] = {.lex_state = 75, .external_lex_state = 4},
  [1794] = {.lex_state = 75, .external_lex_state = 4},
  [1795] = {.lex_state = 75, .external_lex_state = 4},
  [1796] = {.lex_state = 75, .external_lex_state = 4},
  [1797] = {.lex_state = 75, .external_lex_state = 4},
  [1798] = {.lex_state = 75, .external_lex_state = 4},
  [1799] = {.lex_state = 75, .external_lex_state = 4},
  [1800] = {.lex_state = 75, .external_lex_state = 4},
  [1801] = {.lex_state = 75, .external_lex_state = 4},
  [1802] = {.lex_state = 75, .external_lex_state = 4},
  [1803] = {.lex_state = 76, .external_lex_state = 5},
  [1804] = {.lex_state = 75, .external_lex_state = 4},
  [1805] = {.lex_state = 75, .external_lex_state = 4},
  [1806] = {.lex_state = 75, .external_lex_state = 4},
  [1807] = {.lex_state = 75, .external_lex_state = 4},
  [1808] = {.lex_state = 75, .external_lex_state = 4},
  [1809] = {.lex_state = 76, .external_lex_state = 5},
  [1810] = {.lex_state = 75, .external_lex_state = 4},
  [1811] = {.lex_state = 75, .external_lex_state = 4},
  [1812] = {.lex_state = 75, .external_lex_state = 4},
  [1813] = {.lex_state = 75, .external_lex_state = 4},
  [1814] = {.lex_state = 75, .external_lex_state = 4},
  [1815] = {.lex_state = 75, .external_lex_state = 4},
  [1816] = {.lex_state = 75, .external_lex_state = 4},
  [1817] = {.lex_state = 75, .external_lex_state = 4},
  [1818] = {.lex_state = 75, .external_lex_state = 4},
  [1819] = {.lex_state = 75, .external_lex_state = 4},
  [1820] = {.lex_state = 75, .external_lex_state = 4},
  [1821] = {.lex_state = 75, .external_lex_state = 4},
  [1822] = {.lex_state = 75, .external_lex_state = 4},
  [1823] = {.lex_state = 75, .external_lex_state = 3},
  [1824] = {.lex_state = 75, .external_lex_state = 4},
  [1825] = {.lex_state = 75, .external_lex_state = 4},
  [1826] = {.lex_state = 76, .external_lex_state = 5},
  [1827] = {.lex_state = 75, .external_lex_state = 4},
  [1828] = {.lex_state = 75, .external_lex_state = 4},
  [1829] = {.lex_state = 75, .external_lex_state = 4},
  [1830] = {.lex_state = 75, .external_lex_state = 4},
  [1831] = {.lex_state = 75, .external_lex_state = 4},
  [1832] = {.lex_state = 75, .external_lex_state = 4},
  [1833] = {.lex_state = 75, .external_lex_state = 4},
  [1834] = {.lex_state = 75, .external_lex_state = 4},
  [1835] = {.lex_state = 75, .external_lex_state = 4},
  [1836] = {.lex_state = 75, .external_lex_state = 4},
  [1837] = {.lex_state = 75, .external_lex_state = 4},
  [1838] = {.lex_state = 76, .external_lex_state = 5},
  [1839] = {.lex_state = 75, .external_lex_state = 3},
  [1840] = {.lex_state = 75, .external_lex_state = 4},
  [1841] = {.lex_state = 75, .external_lex_state = 4},
  [1842] = {.lex_state = 75, .external_lex_state = 4},
  [1843] = {.lex_state = 75, .external_lex_state = 4},
  [1844] = {.lex_state = 75, .external_lex_state = 4},
  [1845] = {.lex_state = 75, .external_lex_state = 4},
  [1846] = {.lex_state = 75, .external_lex_state = 4},
  [1847] = {.lex_state = 75, .external_lex_state = 4},
  [1848] = {.lex_state = 75, .external_lex_state = 4},
  [1849] = {.lex_state = 76, .external_lex_state = 5},
  [1850] = {.lex_state = 75, .external_lex_state = 4},
  [1851] = {.lex_state = 75, .external_lex_state = 4},
  [1852] = {.lex_state = 75, .external_lex_state = 4},
  [1853] = {.lex_state = 76, .external_lex_state = 5},
  [1854] = {.lex_state = 75, .external_lex_state = 4},
  [1855] = {.lex_state = 4, .external_lex_state = 3},
  [1856] = {.lex_state = 76, .external_lex_state = 5},
  [1857] = {.lex_state = 75, .external_lex_state = 4},
  [1858] = {.lex_state = 75, .external_lex_state = 3},
  [1859] = {.lex_state = 75, .external_lex_state = 4},
  [1860] = {.lex_state = 75, .external_lex_state = 4},
  [1861] = {.lex_state = 75, .external_lex_state = 4},
  [1862] = {.lex_state = 75, .external_lex_state = 3},
  [1863] = {.lex_state = 75, .external_lex_state = 4},
  [1864] = {.lex_state = 75, .external_lex_state = 4},
  [1865] = {.lex_state = 75, .external_lex_state = 4},
  [1866] = {.lex_state = 75, .external_lex_state = 4},
  [1867] = {.lex_state = 75, .external_lex_state = 4},
  [1868] = {.lex_state = 75, .external_lex_state = 4},
  [1869] = {.lex_state = 75, .external_lex_state = 3},
  [1870] = {.lex_state = 75, .external_lex_state = 3},
  [1871] = {.lex_state = 75, .external_lex_state = 4},
  [1872] = {.lex_state = 75, .external_lex_state = 3},
  [1873] = {.lex_state = 75, .external_lex_state = 4},
  [1874] = {.lex_state = 75, .external_lex_state = 3},
  [1875] = {.lex_state = 75, .external_lex_state = 4},
  [1876] = {.lex_state = 75, .external_lex_state = 3},
  [1877] = {.lex_state = 75, .external_lex_state = 3},
  [1878] = {.lex_state = 76, .external_lex_state = 5},
  [1879] = {.lex_state = 75, .external_lex_state = 4},
  [1880] = {.lex_state = 75, .external_lex_state = 4},
  [1881] = {.lex_state = 76, .external_lex_state = 5},
  [1882] = {.lex_state = 76, .external_lex_state = 5},
  [1883] = {.lex_state = 75, .external_lex_state = 4},
  [1884] = {.lex_state = 75, .external_lex_state = 3},
  [1885] = {.lex_state = 75, .external_lex_state = 3},
  [1886] = {.lex_state = 75, .external_lex_state = 3},
  [1887] = {.lex_state = 75, .external_lex_state = 3},
  [1888] = {.lex_state = 75, .external_lex_state = 3},
  [1889] = {.lex_state = 75, .external_lex_state = 4},
  [1890] = {.lex_state = 75, .external_lex_state = 4},
  [1891] = {.lex_state = 75, .external_lex_state = 4},
  [1892] = {.lex_state = 75, .external_lex_state = 4},
  [1893] = {.lex_state = 75, .external_lex_state = 4},
  [1894] = {.lex_state = 75, .external_lex_state = 4},
  [1895] = {.lex_state = 75, .external_lex_state = 4},
  [1896] = {.lex_state = 75, .external_lex_state = 4},
  [1897] = {.lex_state = 75, .external_lex_state = 3},
  [1898] = {.lex_state = 75, .external_lex_state = 3},
  [1899] = {.lex_state = 75, .external_lex_state = 3},
  [1900] = {.lex_state = 75, .external_lex_state = 3},
  [1901] = {.lex_state = 76, .external_lex_state = 2},
  [1902] = {.lex_state = 75, .external_lex_state = 3},
  [1903] = {.lex_state = 75, .external_lex_state = 4},
  [1904] = {.lex_state = 75, .external_lex_state = 4},
  [1905] = {.lex_state = 75, .external_lex_state = 4},
  [1906] = {.lex_state = 75, .external_lex_state = 4},
  [1907] = {.lex_state = 75, .external_lex_state = 4},
  [1908] = {.lex_state = 76, .external_lex_state = 5},
  [1909] = {.lex_state = 75, .external_lex_state = 4},
  [1910] = {.lex_state = 75, .external_lex_state = 3},
  [1911] = {.lex_state = 75, .external_lex_state = 3},
  [1912] = {.lex_state = 75, .external_lex_state = 4},
  [1913] = {.lex_state = 75, .external_lex_state = 4},
  [1914] = {.lex_state = 75, .external_lex_state = 4},
  [1915] = {.lex_state = 75, .external_lex_state = 4},
  [1916] = {.lex_state = 75, .external_lex_state = 4},
  [1917] = {.lex_state = 75, .external_lex_state = 4},
  [1918] = {.lex_state = 75, .external_lex_state = 4},
  [1919] = {.lex_state = 75, .external_lex_state = 4},
  [1920] = {.lex_state = 75, .external_lex_state = 4},
  [1921] = {.lex_state = 75, .external_lex_state = 4},
  [1922] = {.lex_state = 75, .external_lex_state = 4},
  [1923] = {.lex_state = 75, .external_lex_state = 4},
  [1924] = {.lex_state = 75, .external_lex_state = 4},
  [1925] = {.lex_state = 75, .external_lex_state = 4},
  [1926] = {.lex_state = 75, .external_lex_state = 3},
  [1927] = {.lex_state = 75, .external_lex_state = 3},
  [1928] = {.lex_state = 75, .external_lex_state = 3},
  [1929] = {.lex_state = 75, .external_lex_state = 3},
  [1930] = {.lex_state = 75, .external_lex_state = 4},
  [1931] = {.lex_state = 75, .external_lex_state = 3},
  [1932] = {.lex_state = 75, .external_lex_state = 3},
  [1933] = {.lex_state = 75, .external_lex_state = 3},
  [1934] = {.lex_state = 75, .external_lex_state = 3},
  [1935] = {.lex_state = 75, .external_lex_state = 3},
  [1936] = {.lex_state = 75, .external_lex_state = 3},
  [1937] = {.lex_state = 75, .external_lex_state = 3},
  [1938] = {.lex_state = 75, .external_lex_state = 3},
  [1939] = {.lex_state = 75, .external_lex_state = 3},
  [1940] = {.lex_state = 75, .external_lex_state = 3},
  [1941] = {.lex_state = 75, .external_lex_state = 3},
  [1942] = {.lex_state = 75, .external_lex_state = 3},
  [1943] = {.lex_state = 75, .external_lex_state = 4},
  [1944] = {.lex_state = 75, .external_lex_state = 4},
  [1945] = {.lex_state = 75, .external_lex_state = 4},
  [1946] = {.lex_state = 75, .external_lex_state = 4},
  [1947] = {.lex_state = 75, .external_lex_state = 4},
  [1948] = {.lex_state = 75, .external_lex_state = 4},
  [1949] = {.lex_state = 75, .external_lex_state = 4},
  [1950] = {.lex_state = 75, .external_lex_state = 4},
  [1951] = {.lex_state = 75, .external_lex_state = 4},
  [1952] = {.lex_state = 75, .external_lex_state = 4},
  [1953] = {.lex_state = 75, .external_lex_state = 4},
  [1954] = {.lex_state = 75, .external_lex_state = 4},
  [1955] = {.lex_state = 75, .external_lex_state = 4},
  [1956] = {.lex_state = 75, .external_lex_state = 4},
  [1957] = {.lex_state = 75, .external_lex_state = 4},
  [1958] = {.lex_state = 75, .external_lex_state = 4},
  [1959] = {.lex_state = 75, .external_lex_state = 4},
  [1960] = {.lex_state = 75, .external_lex_state = 4},
  [1961] = {.lex_state = 75, .external_lex_state = 4},
  [1962] = {.lex_state = 75, .external_lex_state = 4},
  [1963] = {.lex_state = 75, .external_lex_state = 4},
  [1964] = {.lex_state = 75, .external_lex_state = 4},
  [1965] = {.lex_state = 75, .external_lex_state = 4},
  [1966] = {.lex_state = 75, .external_lex_state = 4},
  [1967] = {.lex_state = 75, .external_lex_state = 4},
  [1968] = {.lex_state = 75, .external_lex_state = 4},
  [1969] = {.lex_state = 75, .external_lex_state = 4},
  [1970] = {.lex_state = 75, .external_lex_state = 4},
  [1971] = {.lex_state = 75, .external_lex_state = 3},
  [1972] = {.lex_state = 75, .external_lex_state = 3},
  [1973] = {.lex_state = 75, .external_lex_state = 3},
  [1974] = {.lex_state = 75, .external_lex_state = 4},
  [1975] = {.lex_state = 75, .external_lex_state = 4},
  [1976] = {.lex_state = 75, .external_lex_state = 3},
  [1977] = {.lex_state = 75, .external_lex_state = 3},
  [1978] = {.lex_state = 75, .external_lex_state = 4},
  [1979] = {.lex_state = 75, .external_lex_state = 4},
  [1980] = {.lex_state = 75, .external_lex_state = 4},
  [1981] = {.lex_state = 75, .external_lex_state = 4},
  [1982] = {.lex_state = 75, .external_lex_state = 4},
  [1983] = {.lex_state = 75, .external_lex_state = 4},
  [1984] = {.lex_state = 75, .external_lex_state = 4},
  [1985] = {.lex_state = 75, .external_lex_state = 4},
  [1986] = {.lex_state = 75, .external_lex_state = 4},
  [1987] = {.lex_state = 75, .external_lex_state = 4},
  [1988] = {.lex_state = 75, .external_lex_state = 4},
  [1989] = {.lex_state = 75, .external_lex_state = 4},
  [1990] = {.lex_state = 75, .external_lex_state = 4},
  [1991] = {.lex_state = 75, .external_lex_state = 4},
  [1992] = {.lex_state = 75, .external_lex_state = 4},
  [1993] = {.lex_state = 75, .external_lex_state = 4},
  [1994] = {.lex_state = 75, .external_lex_state = 4},
  [1995] = {.lex_state = 75, .external_lex_state = 4},
  [1996] = {.lex_state = 75, .external_lex_state = 4},
  [1997] = {.lex_state = 75, .external_lex_state = 4},
  [1998] = {.lex_state = 75, .external_lex_state = 4},
  [1999] = {.lex_state = 75, .external_lex_state = 4},
  [2000] = {.lex_state = 75, .external_lex_state = 4},
  [2001] = {.lex_state = 75, .external_lex_state = 4},
  [2002] = {.lex_state = 75, .external_lex_state = 4},
  [2003] = {.lex_state = 75, .external_lex_state = 4},
  [2004] = {.lex_state = 75, .external_lex_state = 3},
  [2005] = {.lex_state = 75, .external_lex_state = 4},
  [2006] = {.lex_state = 75, .external_lex_state = 4},
  [2007] = {.lex_state = 75, .external_lex_state = 4},
  [2008] = {.lex_state = 75, .external_lex_state = 3},
  [2009] = {.lex_state = 75, .external_lex_state = 4},
  [2010] = {.lex_state = 75, .external_lex_state = 4},
  [2011] = {.lex_state = 75, .external_lex_state = 4},
  [2012] = {.lex_state = 75, .external_lex_state = 4},
  [2013] = {.lex_state = 75, .external_lex_state = 4},
  [2014] = {.lex_state = 75, .external_lex_state = 4},
  [2015] = {.lex_state = 75, .external_lex_state = 4},
  [2016] = {.lex_state = 75, .external_lex_state = 4},
  [2017] = {.lex_state = 75, .external_lex_state = 4},
  [2018] = {.lex_state = 75, .external_lex_state = 4},
  [2019] = {.lex_state = 75, .external_lex_state = 4},
  [2020] = {.lex_state = 75, .external_lex_state = 4},
  [2021] = {.lex_state = 75, .external_lex_state = 4},
  [2022] = {.lex_state = 75, .external_lex_state = 4},
  [2023] = {.lex_state = 75, .external_lex_state = 4},
  [2024] = {.lex_state = 75, .external_lex_state = 4},
  [2025] = {.lex_state = 75, .external_lex_state = 4},
  [2026] = {.lex_state = 75, .external_lex_state = 4},
  [2027] = {.lex_state = 75, .external_lex_state = 4},
  [2028] = {.lex_state = 75, .external_lex_state = 4},
  [2029] = {.lex_state = 75, .external_lex_state = 4},
  [2030] = {.lex_state = 75, .external_lex_state = 4},
  [2031] = {.lex_state = 75, .external_lex_state = 4},
  [2032] = {.lex_state = 75, .external_lex_state = 4},
  [2033] = {.lex_state = 76, .external_lex_state = 2},
  [2034] = {.lex_state = 75, .external_lex_state = 4},
  [2035] = {.lex_state = 75, .external_lex_state = 4},
  [2036] = {.lex_state = 75, .external_lex_state = 4},
  [2037] = {.lex_state = 75, .external_lex_state = 4},
  [2038] = {.lex_state = 75, .external_lex_state = 4},
  [2039] = {.lex_state = 76, .external_lex_state = 2},
  [2040] = {.lex_state = 75, .external_lex_state = 4},
  [2041] = {.lex_state = 75, .external_lex_state = 3},
  [2042] = {.lex_state = 75, .external_lex_state = 4},
  [2043] = {.lex_state = 75, .external_lex_state = 3},
  [2044] = {.lex_state = 75, .external_lex_state = 4},
  [2045] = {.lex_state = 75, .external_lex_state = 4},
  [2046] = {.lex_state = 76, .external_lex_state = 2},
  [2047] = {.lex_state = 75, .external_lex_state = 4},
  [2048] = {.lex_state = 75, .external_lex_state = 4},
  [2049] = {.lex_state = 76, .external_lex_state = 5},
  [2050] = {.lex_state = 75, .external_lex_state = 3},
  [2051] = {.lex_state = 76, .external_lex_state = 2},
  [2052] = {.lex_state = 75, .external_lex_state = 3},
  [2053] = {.lex_state = 75, .external_lex_state = 3},
  [2054] = {.lex_state = 75, .external_lex_state = 3},
  [2055] = {.lex_state = 75, .external_lex_state = 4},
  [2056] = {.lex_state = 75, .external_lex_state = 4},
  [2057] = {.lex_state = 75, .external_lex_state = 3},
  [2058] = {.lex_state = 76, .external_lex_state = 2},
  [2059] = {.lex_state = 75, .external_lex_state = 4},
  [2060] = {.lex_state = 75, .external_lex_state = 3},
  [2061] = {.lex_state = 75, .external_lex_state = 3},
  [2062] = {.lex_state = 75, .external_lex_state = 4},
  [2063] = {.lex_state = 75, .external_lex_state = 4},
  [2064] = {.lex_state = 75, .external_lex_state = 4},
  [2065] = {.lex_state = 76, .external_lex_state = 2},
  [2066] = {.lex_state = 76, .external_lex_state = 5},
  [2067] = {.lex_state = 76, .external_lex_state = 5},
  [2068] = {.lex_state = 76, .external_lex_state = 5},
  [2069] = {.lex_state = 76, .external_lex_state = 5},
  [2070] = {.lex_state = 75, .external_lex_state = 4},
  [2071] = {.lex_state = 75, .external_lex_state = 4},
  [2072] = {.lex_state = 76, .external_lex_state = 5},
  [2073] = {.lex_state = 76, .external_lex_state = 2},
  [2074] = {.lex_state = 76, .external_lex_state = 5},
  [2075] = {.lex_state = 75, .external_lex_state = 4},
  [2076] = {.lex_state = 76, .external_lex_state = 5},
  [2077] = {.lex_state = 76, .external_lex_state = 5},
  [2078] = {.lex_state = 76, .external_lex_state = 5},
  [2079] = {.lex_state = 75, .external_lex_state = 4},
  [2080] = {.lex_state = 75, .external_lex_state = 4},
  [2081] = {.lex_state = 75, .external_lex_state = 4},
  [2082] = {.lex_state = 75, .external_lex_state = 4},
  [2083] = {.lex_state = 75, .external_lex_state = 3},
  [2084] = {.lex_state = 75, .external_lex_state = 3},
  [2085] = {.lex_state = 75, .external_lex_state = 3},
  [2086] = {.lex_state = 75, .external_lex_state = 3},
  [2087] = {.lex_state = 75, .external_lex_state = 3},
  [2088] = {.lex_state = 75, .external_lex_state = 3},
  [2089] = {.lex_state = 75, .external_lex_state = 3},
  [2090] = {.lex_state = 75, .external_lex_state = 3},
  [2091] = {.lex_state = 75, .external_lex_state = 3},
  [2092] = {.lex_state = 75, .external_lex_state = 3},
  [2093] = {.lex_state = 75, .external_lex_state = 3},
  [2094] = {.lex_state = 75, .external_lex_state = 3},
  [2095] = {.lex_state = 75, .external_lex_state = 3},
  [2096] = {.lex_state = 75, .external_lex_state = 3},
  [2097] = {.lex_state = 75, .external_lex_state = 3},
  [2098] = {.lex_state = 75, .external_lex_state = 3},
  [2099] = {.lex_state = 75, .external_lex_state = 3},
  [2100] = {.lex_state = 75, .external_lex_state = 3},
  [2101] = {.lex_state = 75, .external_lex_state = 3},
  [2102] = {.lex_state = 75, .external_lex_state = 3},
  [2103] = {.lex_state = 75, .external_lex_state = 3},
  [2104] = {.lex_state = 75, .external_lex_state = 3},
  [2105] = {.lex_state = 75, .external_lex_state = 3},
  [2106] = {.lex_state = 75, .external_lex_state = 3},
  [2107] = {.lex_state = 75, .external_lex_state = 3},
  [2108] = {.lex_state = 75, .external_lex_state = 3},
  [2109] = {.lex_state = 75, .external_lex_state = 3},
  [2110] = {.lex_state = 75, .external_lex_state = 3},
  [2111] = {.lex_state = 75, .external_lex_state = 3},
  [2112] = {.lex_state = 75, .external_lex_state = 3},
  [2113] = {.lex_state = 75, .external_lex_state = 4},
  [2114] = {.lex_state = 75, .external_lex_state = 3},
  [2115] = {.lex_state = 75, .external_lex_state = 3},
  [2116] = {.lex_state = 75, .external_lex_state = 4},
  [2117] = {.lex_state = 75, .external_lex_state = 4},
  [2118] = {.lex_state = 75, .external_lex_state = 4},
  [2119] = {.lex_state = 75, .external_lex_state = 4},
  [2120] = {.lex_state = 75, .external_lex_state = 4},
  [2121] = {.lex_state = 75, .external_lex_state = 4},
  [2122] = {.lex_state = 75, .external_lex_state = 3},
  [2123] = {.lex_state = 75, .external_lex_state = 3},
  [2124] = {.lex_state = 75, .external_lex_state = 3},
  [2125] = {.lex_state = 75, .external_lex_state = 3},
  [2126] = {.lex_state = 75, .external_lex_state = 4},
  [2127] = {.lex_state = 75, .external_lex_state = 3},
  [2128] = {.lex_state = 76, .external_lex_state = 5},
  [2129] = {.lex_state = 75, .external_lex_state = 4},
  [2130] = {.lex_state = 75, .external_lex_state = 4},
  [2131] = {.lex_state = 75, .external_lex_state = 4},
  [2132] = {.lex_state = 75, .external_lex_state = 3},
  [2133] = {.lex_state = 76, .external_lex_state = 5},
  [2134] = {.lex_state = 76, .external_lex_state = 5},
  [2135] = {.lex_state = 75, .external_lex_state = 4},
  [2136] = {.lex_state = 75, .external_lex_state = 4},
  [2137] = {.lex_state = 75, .external_lex_state = 3},
  [2138] = {.lex_state = 76, .external_lex_state = 5},
  [2139] = {.lex_state = 76, .external_lex_state = 2},
  [2140] = {.lex_state = 75, .external_lex_state = 4},
  [2141] = {.lex_state = 76, .external_lex_state = 2},
  [2142] = {.lex_state = 75, .external_lex_state = 3},
  [2143] = {.lex_state = 75, .external_lex_state = 3},
  [2144] = {.lex_state = 75, .external_lex_state = 3},
  [2145] = {.lex_state = 75, .external_lex_state = 4},
  [2146] = {.lex_state = 75, .external_lex_state = 3},
  [2147] = {.lex_state = 76, .external_lex_state = 5},
  [2148] = {.lex_state = 75, .external_lex_state = 3},
  [2149] = {.lex_state = 76, .external_lex_state = 5},
  [2150] = {.lex_state = 75, .external_lex_state = 3},
  [2151] = {.lex_state = 75, .external_lex_state = 4},
  [2152] = {.lex_state = 75, .external_lex_state = 3},
  [2153] = {.lex_state = 75, .external_lex_state = 4},
  [2154] = {.lex_state = 76, .external_lex_state = 5},
  [2155] = {.lex_state = 76, .external_lex_state = 2},
  [2156] = {.lex_state = 75, .external_lex_state = 4},
  [2157] = {.lex_state = 76, .external_lex_state = 2},
  [2158] = {.lex_state = 76, .external_lex_state = 5},
  [2159] = {.lex_state = 76, .external_lex_state = 5},
  [2160] = {.lex_state = 75, .external_lex_state = 3},
  [2161] = {.lex_state = 75, .external_lex_state = 3},
  [2162] = {.lex_state = 75, .external_lex_state = 3},
  [2163] = {.lex_state = 75, .external_lex_state = 3},
  [2164] = {.lex_state = 75, .external_lex_state = 3},
  [2165] = {.lex_state = 76, .external_lex_state = 5},
  [2166] = {.lex_state = 76, .external_lex_state = 5},
  [2167] = {.lex_state = 75, .external_lex_state = 3},
  [2168] = {.lex_state = 75, .external_lex_state = 3},
  [2169] = {.lex_state = 75, .external_lex_state = 4},
  [2170] = {.lex_state = 75, .external_lex_state = 3},
  [2171] = {.lex_state = 75, .external_lex_state = 4},
  [2172] = {.lex_state = 75, .external_lex_state = 4},
  [2173] = {.lex_state = 75, .external_lex_state = 4},
  [2174] = {.lex_state = 76, .external_lex_state = 5},
  [2175] = {.lex_state = 76, .external_lex_state = 5},
  [2176] = {.lex_state = 76, .external_lex_state = 5},
  [2177] = {.lex_state = 76, .external_lex_state = 5},
  [2178] = {.lex_state = 76, .external_lex_state = 5},
  [2179] = {.lex_state = 76, .external_lex_state = 5},
  [2180] = {.lex_state = 75, .external_lex_state = 4},
  [2181] = {.lex_state = 75, .external_lex_state = 4},
  [2182] = {.lex_state = 75, .external_lex_state = 3},
  [2183] = {.lex_state = 76, .external_lex_state = 5},
  [2184] = {.lex_state = 76, .external_lex_state = 5},
  [2185] = {.lex_state = 75, .external_lex_state = 4},
  [2186] = {.lex_state = 75, .external_lex_state = 4},
  [2187] = {.lex_state = 75, .external_lex_state = 4},
  [2188] = {.lex_state = 75, .external_lex_state = 4},
  [2189] = {.lex_state = 75, .external_lex_state = 4},
  [2190] = {.lex_state = 75, .external_lex_state = 4},
  [2191] = {.lex_state = 76, .external_lex_state = 5},
  [2192] = {.lex_state = 75, .external_lex_state = 3},
  [2193] = {.lex_state = 75, .external_lex_state = 4},
  [2194] = {.lex_state = 75, .external_lex_state = 4},
  [2195] = {.lex_state = 75, .external_lex_state = 4},
  [2196] = {.lex_state = 75, .external_lex_state = 3},
  [2197] = {.lex_state = 75, .external_lex_state = 4},
  [2198] = {.lex_state = 75, .external_lex_state = 3},
  [2199] = {.lex_state = 75, .external_lex_state = 4},
  [2200] = {.lex_state = 75, .external_lex_state = 4},
  [2201] = {.lex_state = 75, .external_lex_state = 4},
  [2202] = {.lex_state = 75, .external_lex_state = 4},
  [2203] = {.lex_state = 75, .external_lex_state = 4},
  [2204] = {.lex_state = 75, .external_lex_state = 4},
  [2205] = {.lex_state = 75, .external_lex_state = 4},
  [2206] = {.lex_state = 75, .external_lex_state = 4},
  [2207] = {.lex_state = 75, .external_lex_state = 4},
  [2208] = {.lex_state = 75, .external_lex_state = 4},
  [2209] = {.lex_state = 75, .external_lex_state = 4},
  [2210] = {.lex_state = 75, .external_lex_state = 4},
  [2211] = {.lex_state = 75, .external_lex_state = 4},
  [2212] = {.lex_state = 75, .external_lex_state = 4},
  [2213] = {.lex_state = 75, .external_lex_state = 4},
  [2214] = {.lex_state = 75, .external_lex_state = 4},
  [2215] = {.lex_state = 75, .external_lex_state = 4},
  [2216] = {.lex_state = 75, .external_lex_state = 4},
  [2217] = {.lex_state = 75, .external_lex_state = 4},
  [2218] = {.lex_state = 75, .external_lex_state = 3},
  [2219] = {.lex_state = 75, .external_lex_state = 4},
  [2220] = {.lex_state = 75, .external_lex_state = 4},
  [2221] = {.lex_state = 75, .external_lex_state = 4},
  [2222] = {.lex_state = 75, .external_lex_state = 4},
  [2223] = {.lex_state = 75, .external_lex_state = 4},
  [2224] = {.lex_state = 75, .external_lex_state = 4},
  [2225] = {.lex_state = 75, .external_lex_state = 4},
  [2226] = {.lex_state = 75, .external_lex_state = 4},
  [2227] = {.lex_state = 75, .external_lex_state = 4},
  [2228] = {.lex_state = 75, .external_lex_state = 4},
  [2229] = {.lex_state = 75, .external_lex_state = 3},
  [2230] = {.lex_state = 75, .external_lex_state = 3},
  [2231] = {.lex_state = 75, .external_lex_state = 3},
  [2232] = {.lex_state = 75, .external_lex_state = 3},
  [2233] = {.lex_state = 75, .external_lex_state = 4},
  [2234] = {.lex_state = 75, .external_lex_state = 4},
  [2235] = {.lex_state = 75, .external_lex_state = 4},
  [2236] = {.lex_state = 75, .external_lex_state = 4},
  [2237] = {.lex_state = 75, .external_lex_state = 3},
  [2238] = {.lex_state = 75, .external_lex_state = 3},
  [2239] = {.lex_state = 75, .external_lex_state = 4},
  [2240] = {.lex_state = 75, .external_lex_state = 4},
  [2241] = {.lex_state = 75, .external_lex_state = 4},
  [2242] = {.lex_state = 75, .external_lex_state = 4},
  [2243] = {.lex_state = 75, .external_lex_state = 3},
  [2244] = {.lex_state = 75, .external_lex_state = 3},
  [2245] = {.lex_state = 75, .external_lex_state = 3},
  [2246] = {.lex_state = 75, .external_lex_state = 3},
  [2247] = {.lex_state = 75, .external_lex_state = 3},
  [2248] = {.lex_state = 75, .external_lex_state = 3},
  [2249] = {.lex_state = 75, .external_lex_state = 3},
  [2250] = {.lex_state = 76, .external_lex_state = 5},
  [2251] = {.lex_state = 75, .external_lex_state = 3},
  [2252] = {.lex_state = 75, .external_lex_state = 3},
  [2253] = {.lex_state = 75, .external_lex_state = 3},
  [2254] = {.lex_state = 75, .external_lex_state = 3},
  [2255] = {.lex_state = 75, .external_lex_state = 3},
  [2256] = {.lex_state = 75, .external_lex_state = 3},
  [2257] = {.lex_state = 75, .external_lex_state = 3},
  [2258] = {.lex_state = 75, .external_lex_state = 4},
  [2259] = {.lex_state = 76, .external_lex_state = 5},
  [2260] = {.lex_state = 76, .external_lex_state = 5},
  [2261] = {.lex_state = 75, .external_lex_state = 4},
  [2262] = {.lex_state = 75, .external_lex_state = 4},
  [2263] = {.lex_state = 75, .external_lex_state = 4},
  [2264] = {.lex_state = 75, .external_lex_state = 4},
  [2265] = {.lex_state = 76, .external_lex_state = 5},
  [2266] = {.lex_state = 76, .external_lex_state = 2},
  [2267] = {.lex_state = 75, .external_lex_state = 4},
  [2268] = {.lex_state = 76, .external_lex_state = 5},
  [2269] = {.lex_state = 76, .external_lex_state = 2},
  [2270] = {.lex_state = 76, .external_lex_state = 5},
  [2271] = {.lex_state = 76, .external_lex_state = 2},
  [2272] = {.lex_state = 75, .external_lex_state = 4},
  [2273] = {.lex_state = 76, .external_lex_state = 5},
  [2274] = {.lex_state = 75, .external_lex_state = 3},
  [2275] = {.lex_state = 76, .external_lex_state = 5},
  [2276] = {.lex_state = 75, .external_lex_state = 3},
  [2277] = {.lex_state = 76, .external_lex_state = 5},
  [2278] = {.lex_state = 76, .external_lex_state = 5},
  [2279] = {.lex_state = 75, .external_lex_state = 3},
  [2280] = {.lex_state = 75, .external_lex_state = 3},
  [2281] = {.lex_state = 76, .external_lex_state = 5},
  [2282] = {.lex_state = 75, .external_lex_state = 3},
  [2283] = {.lex_state = 76, .external_lex_state = 5},
  [2284] = {.lex_state = 76, .external_lex_state = 5},
  [2285] = {.lex_state = 76, .external_lex_state = 5},
  [2286] = {.lex_state = 75, .external_lex_state = 4},
  [2287] = {.lex_state = 75, .external_lex_state = 4},
  [2288] = {.lex_state = 76, .external_lex_state = 5},
  [2289] = {.lex_state = 75, .external_lex_state = 4},
  [2290] = {.lex_state = 75, .external_lex_state = 4},
  [2291] = {.lex_state = 75, .external_lex_state = 4},
  [2292] = {.lex_state = 75, .external_lex_state = 4},
  [2293] = {.lex_state = 75, .external_lex_state = 4},
  [2294] = {.lex_state = 75, .external_lex_state = 4},
  [2295] = {.lex_state = 75, .external_lex_state = 4},
  [2296] = {.lex_state = 75, .external_lex_state = 4},
  [2297] = {.lex_state = 75, .external_lex_state = 4},
  [2298] = {.lex_state = 75, .external_lex_state = 3},
  [2299] = {.lex_state = 75, .external_lex_state = 4},
  [2300] = {.lex_state = 75, .external_lex_state = 3},
  [2301] = {.lex_state = 75, .external_lex_state = 3},
  [2302] = {.lex_state = 75, .external_lex_state = 4},
  [2303] = {.lex_state = 75, .external_lex_state = 3},
  [2304] = {.lex_state = 75, .external_lex_state = 3},
  [2305] = {.lex_state = 76, .external_lex_state = 2},
  [2306] = {.lex_state = 75, .external_lex_state = 3},
  [2307] = {.lex_state = 76, .external_lex_state = 5},
  [2308] = {.lex_state = 76, .external_lex_state = 5},
  [2309] = {.lex_state = 75, .external_lex_state = 4},
  [2310] = {.lex_state = 76, .external_lex_state = 5},
  [2311] = {.lex_state = 75, .external_lex_state = 3},
  [2312] = {.lex_state = 76, .external_lex_state = 5},
  [2313] = {.lex_state = 76, .external_lex_state = 5},
  [2314] = {.lex_state = 76, .external_lex_state = 5},
  [2315] = {.lex_state = 76, .external_lex_state = 5},
  [2316] = {.lex_state = 76, .external_lex_state = 5},
  [2317] = {.lex_state = 76, .external_lex_state = 2},
  [2318] = {.lex_state = 75, .external_lex_state = 3},
  [2319] = {.lex_state = 75, .external_lex_state = 3},
  [2320] = {.lex_state = 75, .external_lex_state = 4},
  [2321] = {.lex_state = 75, .external_lex_state = 4},
  [2322] = {.lex_state = 75, .external_lex_state = 3},
  [2323] = {.lex_state = 75, .external_lex_state = 3},
  [2324] = {.lex_state = 75, .external_lex_state = 3},
  [2325] = {.lex_state = 75, .external_lex_state = 3},
  [2326] = {.lex_state = 75, .external_lex_state = 3},
  [2327] = {.lex_state = 75, .external_lex_state = 3},
  [2328] = {.lex_state = 76, .external_lex_state = 5},
  [2329] = {.lex_state = 75, .external_lex_state = 3},
  [2330] = {.lex_state = 75, .external_lex_state = 3},
  [2331] = {.lex_state = 75, .external_lex_state = 4},
  [2332] = {.lex_state = 75, .external_lex_state = 4},
  [2333] = {.lex_state = 76, .external_lex_state = 2},
  [2334] = {.lex_state = 75, .external_lex_state = 4},
  [2335] = {.lex_state = 75, .external_lex_state = 4},
  [2336] = {.lex_state = 4, .external_lex_state = 4},
  [2337] = {.lex_state = 75, .external_lex_state = 4},
  [2338] = {.lex_state = 75, .external_lex_state = 3},
  [2339] = {.lex_state = 75, .external_lex_state = 4},
  [2340] = {.lex_state = 75, .external_lex_state = 4},
  [2341] = {.lex_state = 75, .external_lex_state = 4},
  [2342] = {.lex_state = 75, .external_lex_state = 4},
  [2343] = {.lex_state = 75, .external_lex_state = 4},
  [2344] = {.lex_state = 75, .external_lex_state = 4},
  [2345] = {.lex_state = 75, .external_lex_state = 4},
  [2346] = {.lex_state = 75, .external_lex_state = 4},
  [2347] = {.lex_state = 75, .external_lex_state = 4},
  [2348] = {.lex_state = 75, .external_lex_state = 4},
  [2349] = {.lex_state = 75, .external_lex_state = 4},
  [2350] = {.lex_state = 75, .external_lex_state = 4},
  [2351] = {.lex_state = 75, .external_lex_state = 4},
  [2352] = {.lex_state = 75, .external_lex_state = 4},
  [2353] = {.lex_state = 76, .external_lex_state = 2},
  [2354] = {.lex_state = 75, .external_lex_state = 4},
  [2355] = {.lex_state = 76, .external_lex_state = 2},
  [2356] = {.lex_state = 76, .external_lex_state = 5},
  [2357] = {.lex_state = 75, .external_lex_state = 3},
  [2358] = {.lex_state = 76, .external_lex_state = 2},
  [2359] = {.lex_state = 75, .external_lex_state = 4},
  [2360] = {.lex_state = 4, .external_lex_state = 4},
  [2361] = {.lex_state = 75, .external_lex_state = 4},
  [2362] = {.lex_state = 76, .external_lex_state = 5},
  [2363] = {.lex_state = 75, .external_lex_state = 4},
  [2364] = {.lex_state = 76, .external_lex_state = 2},
  [2365] = {.lex_state = 75, .external_lex_state = 3},
  [2366] = {.lex_state = 75, .external_lex_state = 3},
  [2367] = {.lex_state = 75, .external_lex_state = 3},
  [2368] = {.lex_state = 76, .external_lex_state = 5},
  [2369] = {.lex_state = 76, .external_lex_state = 5},
  [2370] = {.lex_state = 75, .external_lex_state = 4},
  [2371] = {.lex_state = 76, .external_lex_state = 5},
  [2372] = {.lex_state = 75, .external_lex_state = 4},
  [2373] = {.lex_state = 76, .external_lex_state = 5},
  [2374] = {.lex_state = 76, .external_lex_state = 2},
  [2375] = {.lex_state = 4, .external_lex_state = 3},
  [2376] = {.lex_state = 75, .external_lex_state = 3},
  [2377] = {.lex_state = 76, .external_lex_state = 5},
  [2378] = {.lex_state = 76, .external_lex_state = 5},
  [2379] = {.lex_state = 75, .external_lex_state = 3},
  [2380] = {.lex_state = 75, .external_lex_state = 3},
  [2381] = {.lex_state = 75, .external_lex_state = 4},
  [2382] = {.lex_state = 75, .external_lex_state = 4},
  [2383] = {.lex_state = 75, .external_lex_state = 3},
  [2384] = {.lex_state = 76, .external_lex_state = 2},
  [2385] = {.lex_state = 76, .external_lex_state = 2},
  [2386] = {.lex_state = 76, .external_lex_state = 5},
  [2387] = {.lex_state = 76, .external_lex_state = 5},
  [2388] = {.lex_state = 76, .external_lex_state = 5},
  [2389] = {.lex_state = 76, .external_lex_state = 5},
  [2390] = {.lex_state = 75, .external_lex_state = 4},
  [2391] = {.lex_state = 76, .external_lex_state = 5},
  [2392] = {.lex_state = 75, .external_lex_state = 3},
  [2393] = {.lex_state = 75, .external_lex_state = 3},
  [2394] = {.lex_state = 75, .external_lex_state = 3},
  [2395] = {.lex_state = 75, .external_lex_state = 3},
  [2396] = {.lex_state = 76, .external_lex_state = 2},
  [2397] = {.lex_state = 75, .external_lex_state = 3},
  [2398] = {.lex_state = 75, .external_lex_state = 3},
  [2399] = {.lex_state = 75, .external_lex_state = 3},
  [2400] = {.lex_state = 75, .external_lex_state = 3},
  [2401] = {.lex_state = 75, .external_lex_state = 3},
  [2402] = {.lex_state = 75, .external_lex_state = 3},
  [2403] = {.lex_state = 75, .external_lex_state = 3},
  [2404] = {.lex_state = 75, .external_lex_state = 3},
  [2405] = {.lex_state = 75, .external_lex_state = 3},
  [2406] = {.lex_state = 75, .external_lex_state = 3},
  [2407] = {.lex_state = 75, .external_lex_state = 3},
  [2408] = {.lex_state = 75, .external_lex_state = 3},
  [2409] = {.lex_state = 75, .external_lex_state = 3},
  [2410] = {.lex_state = 75, .external_lex_state = 3},
  [2411] = {.lex_state = 75, .external_lex_state = 3},
  [2412] = {.lex_state = 75, .external_lex_state = 3},
  [2413] = {.lex_state = 75, .external_lex_state = 3},
  [2414] = {.lex_state = 75, .external_lex_state = 3},
  [2415] = {.lex_state = 75, .external_lex_state = 3},
  [2416] = {.lex_state = 75, .external_lex_state = 3},
  [2417] = {.lex_state = 75, .external_lex_state = 3},
  [2418] = {.lex_state = 75, .external_lex_state = 3},
  [2419] = {.lex_state = 75, .external_lex_state = 3},
  [2420] = {.lex_state = 75, .external_lex_state = 3},
  [2421] = {.lex_state = 75, .external_lex_state = 3},
  [2422] = {.lex_state = 75, .external_lex_state = 3},
  [2423] = {.lex_state = 76, .external_lex_state = 5},
  [2424] = {.lex_state = 76, .external_lex_state = 2},
  [2425] = {.lex_state = 75, .external_lex_state = 3},
  [2426] = {.lex_state = 75, .external_lex_state = 3},
  [2427] = {.lex_state = 75, .external_lex_state = 3},
  [2428] = {.lex_state = 75, .external_lex_state = 3},
  [2429] = {.lex_state = 75, .external_lex_state = 3},
  [2430] = {.lex_state = 75, .external_lex_state = 3},
  [2431] = {.lex_state = 75, .external_lex_state = 3},
  [2432] = {.lex_state = 75, .external_lex_state = 3},
  [2433] = {.lex_state = 75, .external_lex_state = 3},
  [2434] = {.lex_state = 75, .external_lex_state = 3},
  [2435] = {.lex_state = 75, .external_lex_state = 3},
  [2436] = {.lex_state = 75, .external_lex_state = 3},
  [2437] = {.lex_state = 75, .external_lex_state = 3},
  [2438] = {.lex_state = 75, .external_lex_state = 3},
  [2439] = {.lex_state = 75, .external_lex_state = 3},
  [2440] = {.lex_state = 75, .external_lex_state = 3},
  [2441] = {.lex_state = 75, .external_lex_state = 3},
  [2442] = {.lex_state = 75, .external_lex_state = 3},
  [2443] = {.lex_state = 75, .external_lex_state = 3},
  [2444] = {.lex_state = 75, .external_lex_state = 3},
  [2445] = {.lex_state = 75, .external_lex_state = 3},
  [2446] = {.lex_state = 75, .external_lex_state = 3},
  [2447] = {.lex_state = 75, .external_lex_state = 3},
  [2448] = {.lex_state = 75, .external_lex_state = 3},
  [2449] = {.lex_state = 75, .external_lex_state = 3},
  [2450] = {.lex_state = 75, .external_lex_state = 3},
  [2451] = {.lex_state = 76, .external_lex_state = 2},
  [2452] = {.lex_state = 75, .external_lex_state = 4},
  [2453] = {.lex_state = 75, .external_lex_state = 3},
  [2454] = {.lex_state = 75, .external_lex_state = 3},
  [2455] = {.lex_state = 75, .external_lex_state = 3},
  [2456] = {.lex_state = 75, .external_lex_state = 3},
  [2457] = {.lex_state = 75, .external_lex_state = 4},
  [2458] = {.lex_state = 76, .external_lex_state = 2},
  [2459] = {.lex_state = 75, .external_lex_state = 4},
  [2460] = {.lex_state = 76, .external_lex_state = 5},
  [2461] = {.lex_state = 76, .external_lex_state = 5},
  [2462] = {.lex_state = 76, .external_lex_state = 5},
  [2463] = {.lex_state = 75, .external_lex_state = 3},
  [2464] = {.lex_state = 75, .external_lex_state = 3},
  [2465] = {.lex_state = 75, .external_lex_state = 3},
  [2466] = {.lex_state = 76, .external_lex_state = 5},
  [2467] = {.lex_state = 76, .external_lex_state = 2},
  [2468] = {.lex_state = 75, .external_lex_state = 3},
  [2469] = {.lex_state = 75, .external_lex_state = 3},
  [2470] = {.lex_state = 75, .external_lex_state = 3},
  [2471] = {.lex_state = 75, .external_lex_state = 3},
  [2472] = {.lex_state = 75, .external_lex_state = 3},
  [2473] = {.lex_state = 76, .external_lex_state = 5},
  [2474] = {.lex_state = 75, .external_lex_state = 3},
  [2475] = {.lex_state = 75, .external_lex_state = 3},
  [2476] = {.lex_state = 75, .external_lex_state = 3},
  [2477] = {.lex_state = 75, .external_lex_state = 3},
  [2478] = {.lex_state = 75, .external_lex_state = 3},
  [2479] = {.lex_state = 75, .external_lex_state = 3},
  [2480] = {.lex_state = 75, .external_lex_state = 4},
  [2481] = {.lex_state = 76, .external_lex_state = 5},
  [2482] = {.lex_state = 75, .external_lex_state = 3},
  [2483] = {.lex_state = 75, .external_lex_state = 3},
  [2484] = {.lex_state = 76, .external_lex_state = 5},
  [2485] = {.lex_state = 76, .external_lex_state = 5},
  [2486] = {.lex_state = 76, .external_lex_state = 5},
  [2487] = {.lex_state = 76, .external_lex_state = 2},
  [2488] = {.lex_state = 75, .external_lex_state = 3},
  [2489] = {.lex_state = 75, .external_lex_state = 3},
  [2490] = {.lex_state = 76, .external_lex_state = 2},
  [2491] = {.lex_state = 75, .external_lex_state = 4},
  [2492] = {.lex_state = 75, .external_lex_state = 4},
  [2493] = {.lex_state = 75, .external_lex_state = 4},
  [2494] = {.lex_state = 76, .external_lex_state = 5},
  [2495] = {.lex_state = 75, .external_lex_state = 3},
  [2496] = {.lex_state = 76, .external_lex_state = 5},
  [2497] = {.lex_state = 75, .external_lex_state = 3},
  [2498] = {.lex_state = 75, .external_lex_state = 3},
  [2499] = {.lex_state = 75, .external_lex_state = 3},
  [2500] = {.lex_state = 75, .external_lex_state = 3},
  [2501] = {.lex_state = 75, .external_lex_state = 3},
  [2502] = {.lex_state = 75, .external_lex_state = 3},
  [2503] = {.lex_state = 75, .external_lex_state = 3},
  [2504] = {.lex_state = 75, .external_lex_state = 3},
  [2505] = {.lex_state = 75, .external_lex_state = 3},
  [2506] = {.lex_state = 75, .external_lex_state = 3},
  [2507] = {.lex_state = 75, .external_lex_state = 3},
  [2508] = {.lex_state = 75, .external_lex_state = 3},
  [2509] = {.lex_state = 75, .external_lex_state = 3},
  [2510] = {.lex_state = 75, .external_lex_state = 3},
  [2511] = {.lex_state = 75, .external_lex_state = 3},
  [2512] = {.lex_state = 75, .external_lex_state = 3},
  [2513] = {.lex_state = 75, .external_lex_state = 3},
  [2514] = {.lex_state = 75, .external_lex_state = 3},
  [2515] = {.lex_state = 75, .external_lex_state = 3},
  [2516] = {.lex_state = 75, .external_lex_state = 3},
  [2517] = {.lex_state = 75, .external_lex_state = 3},
  [2518] = {.lex_state = 75, .external_lex_state = 3},
  [2519] = {.lex_state = 75, .external_lex_state = 3},
  [2520] = {.lex_state = 75, .external_lex_state = 3},
  [2521] = {.lex_state = 75, .external_lex_state = 3},
  [2522] = {.lex_state = 75, .external_lex_state = 3},
  [2523] = {.lex_state = 75, .external_lex_state = 3},
  [2524] = {.lex_state = 75, .external_lex_state = 3},
  [2525] = {.lex_state = 75, .external_lex_state = 3},
  [2526] = {.lex_state = 75, .external_lex_state = 3},
  [2527] = {.lex_state = 76, .external_lex_state = 5},
  [2528] = {.lex_state = 75, .external_lex_state = 3},
  [2529] = {.lex_state = 75, .external_lex_state = 3},
  [2530] = {.lex_state = 75, .external_lex_state = 3},
  [2531] = {.lex_state = 75, .external_lex_state = 3},
  [2532] = {.lex_state = 75, .external_lex_state = 3},
  [2533] = {.lex_state = 76, .external_lex_state = 2},
  [2534] = {.lex_state = 76, .external_lex_state = 5},
  [2535] = {.lex_state = 75, .external_lex_state = 3},
  [2536] = {.lex_state = 76, .external_lex_state = 2},
  [2537] = {.lex_state = 76, .external_lex_state = 2},
  [2538] = {.lex_state = 76, .external_lex_state = 2},
  [2539] = {.lex_state = 75, .external_lex_state = 3},
  [2540] = {.lex_state = 76, .external_lex_state = 2},
  [2541] = {.lex_state = 75, .external_lex_state = 3},
  [2542] = {.lex_state = 76, .external_lex_state = 5},
  [2543] = {.lex_state = 75, .external_lex_state = 3},
  [2544] = {.lex_state = 75, .external_lex_state = 3},
  [2545] = {.lex_state = 75, .external_lex_state = 3},
  [2546] = {.lex_state = 76, .external_lex_state = 5},
  [2547] = {.lex_state = 76, .external_lex_state = 5},
  [2548] = {.lex_state = 75, .external_lex_state = 3},
  [2549] = {.lex_state = 76, .external_lex_state = 5},
  [2550] = {.lex_state = 76, .external_lex_state = 5},
  [2551] = {.lex_state = 75, .external_lex_state = 3},
  [2552] = {.lex_state = 75, .external_lex_state = 3},
  [2553] = {.lex_state = 75, .external_lex_state = 3},
  [2554] = {.lex_state = 75, .external_lex_state = 3},
  [2555] = {.lex_state = 75, .external_lex_state = 3},
  [2556] = {.lex_state = 75, .external_lex_state = 4},
  [2557] = {.lex_state = 75, .external_lex_state = 3},
  [2558] = {.lex_state = 75, .external_lex_state = 3},
  [2559] = {.lex_state = 75, .external_lex_state = 3},
  [2560] = {.lex_state = 75, .external_lex_state = 3},
  [2561] = {.lex_state = 75, .external_lex_state = 3},
  [2562] = {.lex_state = 75, .external_lex_state = 3},
  [2563] = {.lex_state = 75, .external_lex_state = 3},
  [2564] = {.lex_state = 75, .external_lex_state = 3},
  [2565] = {.lex_state = 75, .external_lex_state = 3},
  [2566] = {.lex_state = 75, .external_lex_state = 3},
  [2567] = {.lex_state = 76, .external_lex_state = 2},
  [2568] = {.lex_state = 75, .external_lex_state = 3},
  [2569] = {.lex_state = 75, .external_lex_state = 3},
  [2570] = {.lex_state = 76, .external_lex_state = 2},
  [2571] = {.lex_state = 75, .external_lex_state = 3},
  [2572] = {.lex_state = 76, .external_lex_state = 2},
  [2573] = {.lex_state = 75, .external_lex_state = 3},
  [2574] = {.lex_state = 75, .external_lex_state = 3},
  [2575] = {.lex_state = 75, .external_lex_state = 3},
  [2576] = {.lex_state = 75, .external_lex_state = 3},
  [2577] = {.lex_state = 75, .external_lex_state = 3},
  [2578] = {.lex_state = 75, .external_lex_state = 3},
  [2579] = {.lex_state = 75, .external_lex_state = 3},
  [2580] = {.lex_state = 75, .external_lex_state = 3},
  [2581] = {.lex_state = 75, .external_lex_state = 3},
  [2582] = {.lex_state = 75, .external_lex_state = 3},
  [2583] = {.lex_state = 75, .external_lex_state = 3},
  [2584] = {.lex_state = 75, .external_lex_state = 3},
  [2585] = {.lex_state = 75, .external_lex_state = 3},
  [2586] = {.lex_state = 75, .external_lex_state = 3},
  [2587] = {.lex_state = 75, .external_lex_state = 3},
  [2588] = {.lex_state = 76, .external_lex_state = 5},
  [2589] = {.lex_state = 76, .external_lex_state = 5},
  [2590] = {.lex_state = 75, .external_lex_state = 3},
  [2591] = {.lex_state = 76, .external_lex_state = 5},
  [2592] = {.lex_state = 76, .external_lex_state = 5},
  [2593] = {.lex_state = 75, .external_lex_state = 3},
  [2594] = {.lex_state = 75, .external_lex_state = 3},
  [2595] = {.lex_state = 75, .external_lex_state = 3},
  [2596] = {.lex_state = 76, .external_lex_state = 5},
  [2597] = {.lex_state = 75, .external_lex_state = 3},
  [2598] = {.lex_state = 75, .external_lex_state = 3},
  [2599] = {.lex_state = 75, .external_lex_state = 3},
  [2600] = {.lex_state = 75, .external_lex_state = 3},
  [2601] = {.lex_state = 75, .external_lex_state = 3},
  [2602] = {.lex_state = 75, .external_lex_state = 3},
  [2603] = {.lex_state = 75, .external_lex_state = 3},
  [2604] = {.lex_state = 75, .external_lex_state = 3},
  [2605] = {.lex_state = 76, .external_lex_state = 5},
  [2606] = {.lex_state = 75, .external_lex_state = 3},
  [2607] = {.lex_state = 75, .external_lex_state = 3},
  [2608] = {.lex_state = 75, .external_lex_state = 3},
  [2609] = {.lex_state = 75, .external_lex_state = 3},
  [2610] = {.lex_state = 75, .external_lex_state = 3},
  [2611] = {.lex_state = 75, .external_lex_state = 3},
  [2612] = {.lex_state = 75, .external_lex_state = 3},
  [2613] = {.lex_state = 75, .external_lex_state = 3},
  [2614] = {.lex_state = 75, .external_lex_state = 3},
  [2615] = {.lex_state = 9, .external_lex_state = 5},
  [2616] = {.lex_state = 76, .external_lex_state = 5},
  [2617] = {.lex_state = 76, .external_lex_state = 2},
  [2618] = {.lex_state = 9, .external_lex_state = 5},
  [2619] = {.lex_state = 76, .external_lex_state = 5},
  [2620] = {.lex_state = 9, .external_lex_state = 5},
  [2621] = {.lex_state = 9, .external_lex_state = 5},
  [2622] = {.lex_state = 76, .external_lex_state = 2},
  [2623] = {.lex_state = 76, .external_lex_state = 2},
  [2624] = {.lex_state = 9, .external_lex_state = 5},
  [2625] = {.lex_state = 9, .external_lex_state = 5},
  [2626] = {.lex_state = 76, .external_lex_state = 5},
  [2627] = {.lex_state = 9, .external_lex_state = 5},
  [2628] = {.lex_state = 76, .external_lex_state = 5},
  [2629] = {.lex_state = 76, .external_lex_state = 5},
  [2630] = {.lex_state = 9, .external_lex_state = 5},
  [2631] = {.lex_state = 9, .external_lex_state = 5},
  [2632] = {.lex_state = 9, .external_lex_state = 5},
  [2633] = {.lex_state = 9, .external_lex_state = 5},
  [2634] = {.lex_state = 9, .external_lex_state = 5},
  [2635] = {.lex_state = 9, .external_lex_state = 5},
  [2636] = {.lex_state = 76, .external_lex_state = 2},
  [2637] = {.lex_state = 76, .external_lex_state = 2},
  [2638] = {.lex_state = 9, .external_lex_state = 5},
  [2639] = {.lex_state = 9, .external_lex_state = 5},
  [2640] = {.lex_state = 9, .external_lex_state = 5},
  [2641] = {.lex_state = 4, .external_lex_state = 3},
  [2642] = {.lex_state = 9, .external_lex_state = 5},
  [2643] = {.lex_state = 9, .external_lex_state = 5},
  [2644] = {.lex_state = 76, .external_lex_state = 5},
  [2645] = {.lex_state = 76, .external_lex_state = 5},
  [2646] = {.lex_state = 76, .external_lex_state = 5},
  [2647] = {.lex_state = 9, .external_lex_state = 5},
  [2648] = {.lex_state = 9, .external_lex_state = 5},
  [2649] = {.lex_state = 76, .external_lex_state = 5},
  [2650] = {.lex_state = 76, .external_lex_state = 2},
  [2651] = {.lex_state = 76, .external_lex_state = 5},
  [2652] = {.lex_state = 9, .external_lex_state = 5},
  [2653] = {.lex_state = 9, .external_lex_state = 5},
  [2654] = {.lex_state = 76, .external_lex_state = 5},
  [2655] = {.lex_state = 76, .external_lex_state = 2},
  [2656] = {.lex_state = 9, .external_lex_state = 5},
  [2657] = {.lex_state = 9, .external_lex_state = 5},
  [2658] = {.lex_state = 76, .external_lex_state = 5},
  [2659] = {.lex_state = 76, .external_lex_state = 5},
  [2660] = {.lex_state = 9, .external_lex_state = 5},
  [2661] = {.lex_state = 76, .external_lex_state = 2},
  [2662] = {.lex_state = 75, .external_lex_state = 3},
  [2663] = {.lex_state = 76, .external_lex_state = 2},
  [2664] = {.lex_state = 76, .external_lex_state = 5},
  [2665] = {.lex_state = 9, .external_lex_state = 5},
  [2666] = {.lex_state = 76, .external_lex_state = 2},
  [2667] = {.lex_state = 9, .external_lex_state = 5},
  [2668] = {.lex_state = 9, .external_lex_state = 5},
  [2669] = {.lex_state = 75, .external_lex_state = 3},
  [2670] = {.lex_state = 9, .external_lex_state = 5},
  [2671] = {.lex_state = 9, .external_lex_state = 5},
  [2672] = {.lex_state = 9, .external_lex_state = 5},
  [2673] = {.lex_state = 9, .external_lex_state = 5},
  [2674] = {.lex_state = 9, .external_lex_state = 5},
  [2675] = {.lex_state = 9, .external_lex_state = 5},
  [2676] = {.lex_state = 9, .external_lex_state = 5},
  [2677] = {.lex_state = 9, .external_lex_state = 5},
  [2678] = {.lex_state = 9, .external_lex_state = 5},
  [2679] = {.lex_state = 9, .external_lex_state = 5},
  [2680] = {.lex_state = 9, .external_lex_state = 5},
  [2681] = {.lex_state = 9, .external_lex_state = 5},
  [2682] = {.lex_state = 9, .external_lex_state = 5},
  [2683] = {.lex_state = 76, .external_lex_state = 2},
  [2684] = {.lex_state = 9, .external_lex_state = 5},
  [2685] = {.lex_state = 9, .external_lex_state = 5},
  [2686] = {.lex_state = 76, .external_lex_state = 2},
  [2687] = {.lex_state = 76, .external_lex_state = 2},
  [2688] = {.lex_state = 76, .external_lex_state = 5},
  [2689] = {.lex_state = 9, .external_lex_state = 5},
  [2690] = {.lex_state = 76, .external_lex_state = 2},
  [2691] = {.lex_state = 76, .external_lex_state = 2},
  [2692] = {.lex_state = 9, .external_lex_state = 5},
  [2693] = {.lex_state = 9, .external_lex_state = 5},
  [2694] = {.lex_state = 76, .external_lex_state = 5},
  [2695] = {.lex_state = 9, .external_lex_state = 5},
  [2696] = {.lex_state = 9, .external_lex_state = 5},
  [2697] = {.lex_state = 75, .external_lex_state = 3},
  [2698] = {.lex_state = 9, .external_lex_state = 5},
  [2699] = {.lex_state = 9, .external_lex_state = 5},
  [2700] = {.lex_state = 76, .external_lex_state = 2},
  [2701] = {.lex_state = 9, .external_lex_state = 5},
  [2702] = {.lex_state = 75, .external_lex_state = 3},
  [2703] = {.lex_state = 75, .external_lex_state = 3},
  [2704] = {.lex_state = 75, .external_lex_state = 3},
  [2705] = {.lex_state = 9, .external_lex_state = 5},
  [2706] = {.lex_state = 76, .external_lex_state = 2},
  [2707] = {.lex_state = 75, .external_lex_state = 3},
  [2708] = {.lex_state = 9, .external_lex_state = 2},
  [2709] = {.lex_state = 75, .external_lex_state = 3},
  [2710] = {.lex_state = 75, .external_lex_state = 3},
  [2711] = {.lex_state = 9, .external_lex_state = 2},
  [2712] = {.lex_state = 75, .external_lex_state = 3},
  [2713] = {.lex_state = 9, .external_lex_state = 2},
  [2714] = {.lex_state = 75, .external_lex_state = 3},
  [2715] = {.lex_state = 9, .external_lex_state = 2},
  [2716] = {.lex_state = 75, .external_lex_state = 3},
  [2717] = {.lex_state = 75, .external_lex_state = 3},
  [2718] = {.lex_state = 76, .external_lex_state = 2},
  [2719] = {.lex_state = 75, .external_lex_state = 3},
  [2720] = {.lex_state = 9, .external_lex_state = 2},
  [2721] = {.lex_state = 75, .external_lex_state = 3},
  [2722] = {.lex_state = 9, .external_lex_state = 2},
  [2723] = {.lex_state = 9, .external_lex_state = 2},
  [2724] = {.lex_state = 75, .external_lex_state = 3},
  [2725] = {.lex_state = 9, .external_lex_state = 2},
  [2726] = {.lex_state = 9, .external_lex_state = 2},
  [2727] = {.lex_state = 9, .external_lex_state = 2},
  [2728] = {.lex_state = 9, .external_lex_state = 2},
  [2729] = {.lex_state = 75, .external_lex_state = 3},
  [2730] = {.lex_state = 75, .external_lex_state = 3},
  [2731] = {.lex_state = 76, .external_lex_state = 2},
  [2732] = {.lex_state = 76, .external_lex_state = 2},
  [2733] = {.lex_state = 76, .external_lex_state = 2},
  [2734] = {.lex_state = 76, .external_lex_state = 2},
  [2735] = {.lex_state = 76, .external_lex_state = 2},
  [2736] = {.lex_state = 76, .external_lex_state = 2},
  [2737] = {.lex_state = 76, .external_lex_state = 2},
  [2738] = {.lex_state = 76, .external_lex_state = 2},
  [2739] = {.lex_state = 76, .external_lex_state = 2},
  [2740] = {.lex_state = 76, .external_lex_state = 2},
  [2741] = {.lex_state = 76, .external_lex_state = 2},
  [2742] = {.lex_state = 76, .external_lex_state = 2},
  [2743] = {.lex_state = 76, .external_lex_state = 2},
  [2744] = {.lex_state = 76, .external_lex_state = 2},
  [2745] = {.lex_state = 76, .external_lex_state = 2},
  [2746] = {.lex_state = 76, .external_lex_state = 2},
  [2747] = {.lex_state = 76, .external_lex_state = 2},
  [2748] = {.lex_state = 76, .external_lex_state = 2},
  [2749] = {.lex_state = 76, .external_lex_state = 2},
  [2750] = {.lex_state = 76, .external_lex_state = 2},
  [2751] = {.lex_state = 76, .external_lex_state = 2},
  [2752] = {.lex_state = 76, .external_lex_state = 2},
  [2753] = {.lex_state = 76, .external_lex_state = 2},
  [2754] = {.lex_state = 76, .external_lex_state = 2},
  [2755] = {.lex_state = 76, .external_lex_state = 2},
  [2756] = {.lex_state = 76, .external_lex_state = 2},
  [2757] = {.lex_state = 76, .external_lex_state = 2},
  [2758] = {.lex_state = 76, .external_lex_state = 2},
  [2759] = {.lex_state = 76, .external_lex_state = 2},
  [2760] = {.lex_state = 76, .external_lex_state = 2},
  [2761] = {.lex_state = 76, .external_lex_state = 2},
  [2762] = {.lex_state = 76, .external_lex_state = 2},
  [2763] = {.lex_state = 76, .external_lex_state = 2},
  [2764] = {.lex_state = 76, .external_lex_state = 2},
  [2765] = {.lex_state = 76, .external_lex_state = 2},
  [2766] = {.lex_state = 76, .external_lex_state = 2},
  [2767] = {.lex_state = 76, .external_lex_state = 2},
  [2768] = {.lex_state = 76, .external_lex_state = 2},
  [2769] = {.lex_state = 76, .external_lex_state = 2},
  [2770] = {.lex_state = 76, .external_lex_state = 2},
  [2771] = {.lex_state = 76, .external_lex_state = 2},
  [2772] = {.lex_state = 76, .external_lex_state = 2},
  [2773] = {.lex_state = 76, .external_lex_state = 2},
  [2774] = {.lex_state = 76, .external_lex_state = 2},
  [2775] = {.lex_state = 76, .external_lex_state = 2},
  [2776] = {.lex_state = 76, .external_lex_state = 2},
  [2777] = {.lex_state = 76, .external_lex_state = 2},
  [2778] = {.lex_state = 76, .external_lex_state = 2},
  [2779] = {.lex_state = 76, .external_lex_state = 2},
  [2780] = {.lex_state = 76, .external_lex_state = 2},
  [2781] = {.lex_state = 76, .external_lex_state = 2},
  [2782] = {.lex_state = 76, .external_lex_state = 2},
  [2783] = {.lex_state = 76, .external_lex_state = 2},
  [2784] = {.lex_state = 76, .external_lex_state = 2},
  [2785] = {.lex_state = 76, .external_lex_state = 2},
  [2786] = {.lex_state = 76, .external_lex_state = 2},
  [2787] = {.lex_state = 76, .external_lex_state = 2},
  [2788] = {.lex_state = 76, .external_lex_state = 2},
  [2789] = {.lex_state = 76, .external_lex_state = 2},
  [2790] = {.lex_state = 76, .external_lex_state = 2},
  [2791] = {.lex_state = 76, .external_lex_state = 2},
  [2792] = {.lex_state = 76, .external_lex_state = 2},
  [2793] = {.lex_state = 76, .external_lex_state = 2},
  [2794] = {.lex_state = 76, .external_lex_state = 2},
  [2795] = {.lex_state = 76, .external_lex_state = 2},
  [2796] = {.lex_state = 76, .external_lex_state = 2},
  [2797] = {.lex_state = 76, .external_lex_state = 2},
  [2798] = {.lex_state = 76, .external_lex_state = 2},
  [2799] = {.lex_state = 76, .external_lex_state = 2},
  [2800] = {.lex_state = 76, .external_lex_state = 2},
  [2801] = {.lex_state = 76, .external_lex_state = 2},
  [2802] = {.lex_state = 76, .external_lex_state = 2},
  [2803] = {.lex_state = 76, .external_lex_state = 2},
  [2804] = {.lex_state = 76, .external_lex_state = 2},
  [2805] = {.lex_state = 76, .external_lex_state = 2},
  [2806] = {.lex_state = 76, .external_lex_state = 2},
  [2807] = {.lex_state = 76, .external_lex_state = 2},
  [2808] = {.lex_state = 76, .external_lex_state = 2},
  [2809] = {.lex_state = 76, .external_lex_state = 2},
  [2810] = {.lex_state = 76, .external_lex_state = 2},
  [2811] = {.lex_state = 76, .external_lex_state = 2},
  [2812] = {.lex_state = 76, .external_lex_state = 2},
  [2813] = {.lex_state = 76, .external_lex_state = 2},
  [2814] = {.lex_state = 76, .external_lex_state = 2},
  [2815] = {.lex_state = 76, .external_lex_state = 2},
  [2816] = {.lex_state = 76, .external_lex_state = 2},
  [2817] = {.lex_state = 76, .external_lex_state = 2},
  [2818] = {.lex_state = 76, .external_lex_state = 2},
  [2819] = {.lex_state = 76, .external_lex_state = 2},
  [2820] = {.lex_state = 76, .external_lex_state = 2},
  [2821] = {.lex_state = 76, .external_lex_state = 2},
  [2822] = {.lex_state = 76, .external_lex_state = 2},
  [2823] = {.lex_state = 76, .external_lex_state = 2},
  [2824] = {.lex_state = 76, .external_lex_state = 2},
  [2825] = {.lex_state = 76, .external_lex_state = 2},
  [2826] = {.lex_state = 76, .external_lex_state = 2},
  [2827] = {.lex_state = 76, .external_lex_state = 2},
  [2828] = {.lex_state = 76, .external_lex_state = 2},
  [2829] = {.lex_state = 76, .external_lex_state = 2},
  [2830] = {.lex_state = 76, .external_lex_state = 2},
  [2831] = {.lex_state = 76, .external_lex_state = 2},
  [2832] = {.lex_state = 76, .external_lex_state = 2},
  [2833] = {.lex_state = 76, .external_lex_state = 2},
  [2834] = {.lex_state = 76, .external_lex_state = 2},
  [2835] = {.lex_state = 76, .external_lex_state = 2},
  [2836] = {.lex_state = 76, .external_lex_state = 2},
  [2837] = {.lex_state = 76, .external_lex_state = 2},
  [2838] = {.lex_state = 76, .external_lex_state = 2},
  [2839] = {.lex_state = 76, .external_lex_state = 2},
  [2840] = {.lex_state = 76, .external_lex_state = 2},
  [2841] = {.lex_state = 76, .external_lex_state = 2},
  [2842] = {.lex_state = 76, .external_lex_state = 2},
  [2843] = {.lex_state = 76, .external_lex_state = 2},
  [2844] = {.lex_state = 76, .external_lex_state = 2},
  [2845] = {.lex_state = 76, .external_lex_state = 2},
  [2846] = {.lex_state = 76, .external_lex_state = 2},
  [2847] = {.lex_state = 76, .external_lex_state = 2},
  [2848] = {.lex_state = 76, .external_lex_state = 2},
  [2849] = {.lex_state = 76, .external_lex_state = 2},
  [2850] = {.lex_state = 76, .external_lex_state = 2},
  [2851] = {.lex_state = 76, .external_lex_state = 2},
  [2852] = {.lex_state = 76, .external_lex_state = 2},
  [2853] = {.lex_state = 76, .external_lex_state = 2},
  [2854] = {.lex_state = 76, .external_lex_state = 2},
  [2855] = {.lex_state = 76, .external_lex_state = 2},
  [2856] = {.lex_state = 76, .external_lex_state = 2},
  [2857] = {.lex_state = 76, .external_lex_state = 2},
  [2858] = {.lex_state = 76, .external_lex_state = 2},
  [2859] = {.lex_state = 76, .external_lex_state = 2},
  [2860] = {.lex_state = 76, .external_lex_state = 2},
  [2861] = {.lex_state = 76, .external_lex_state = 2},
  [2862] = {.lex_state = 76, .external_lex_state = 2},
  [2863] = {.lex_state = 76, .external_lex_state = 2},
  [2864] = {.lex_state = 76, .external_lex_state = 2},
  [2865] = {.lex_state = 76, .external_lex_state = 2},
  [2866] = {.lex_state = 76, .external_lex_state = 2},
  [2867] = {.lex_state = 76, .external_lex_state = 2},
  [2868] = {.lex_state = 76, .external_lex_state = 2},
  [2869] = {.lex_state = 76, .external_lex_state = 2},
  [2870] = {.lex_state = 76, .external_lex_state = 2},
  [2871] = {.lex_state = 76, .external_lex_state = 2},
  [2872] = {.lex_state = 76, .external_lex_state = 2},
  [2873] = {.lex_state = 76, .external_lex_state = 2},
  [2874] = {.lex_state = 76, .external_lex_state = 2},
  [2875] = {.lex_state = 76, .external_lex_state = 2},
  [2876] = {.lex_state = 76, .external_lex_state = 2},
  [2877] = {.lex_state = 76, .external_lex_state = 2},
  [2878] = {.lex_state = 76, .external_lex_state = 2},
  [2879] = {.lex_state = 76, .external_lex_state = 2},
  [2880] = {.lex_state = 76, .external_lex_state = 2},
  [2881] = {.lex_state = 76, .external_lex_state = 2},
  [2882] = {.lex_state = 76, .external_lex_state = 2},
  [2883] = {.lex_state = 76, .external_lex_state = 2},
  [2884] = {.lex_state = 76, .external_lex_state = 2},
  [2885] = {.lex_state = 76, .external_lex_state = 2},
  [2886] = {.lex_state = 7, .external_lex_state = 2},
  [2887] = {.lex_state = 7, .external_lex_state = 2},
  [2888] = {.lex_state = 7, .external_lex_state = 2},
  [2889] = {.lex_state = 7, .external_lex_state = 2},
  [2890] = {.lex_state = 7, .external_lex_state = 2},
  [2891] = {.lex_state = 7, .external_lex_state = 2},
  [2892] = {.lex_state = 7, .external_lex_state = 2},
  [2893] = {.lex_state = 7, .external_lex_state = 2},
  [2894] = {.lex_state = 7, .external_lex_state = 2},
  [2895] = {.lex_state = 7, .external_lex_state = 2},
  [2896] = {.lex_state = 7, .external_lex_state = 2},
  [2897] = {.lex_state = 7, .external_lex_state = 2},
  [2898] = {.lex_state = 7, .external_lex_state = 2},
  [2899] = {.lex_state = 7, .external_lex_state = 2},
  [2900] = {.lex_state = 7, .external_lex_state = 2},
  [2901] = {.lex_state = 7, .external_lex_state = 2},
  [2902] = {.lex_state = 7, .external_lex_state = 2},
  [2903] = {.lex_state = 7, .external_lex_state = 2},
  [2904] = {.lex_state = 7, .external_lex_state = 2},
  [2905] = {.lex_state = 7, .external_lex_state = 2},
  [2906] = {.lex_state = 7, .external_lex_state = 2},
  [2907] = {.lex_state = 7, .external_lex_state = 2},
  [2908] = {.lex_state = 7, .external_lex_state = 2},
  [2909] = {.lex_state = 7, .external_lex_state = 2},
  [2910] = {.lex_state = 7, .external_lex_state = 2},
  [2911] = {.lex_state = 7, .external_lex_state = 2},
  [2912] = {.lex_state = 7, .external_lex_state = 2},
  [2913] = {.lex_state = 7, .external_lex_state = 2},
  [2914] = {.lex_state = 7, .external_lex_state = 2},
  [2915] = {.lex_state = 7, .external_lex_state = 2},
  [2916] = {.lex_state = 7, .external_lex_state = 2},
  [2917] = {.lex_state = 7, .external_lex_state = 2},
  [2918] = {.lex_state = 7, .external_lex_state = 2},
  [2919] = {.lex_state = 7, .external_lex_state = 2},
  [2920] = {.lex_state = 7, .external_lex_state = 2},
  [2921] = {.lex_state = 7, .external_lex_state = 2},
  [2922] = {.lex_state = 7, .external_lex_state = 2},
  [2923] = {.lex_state = 76, .external_lex_state = 5},
  [2924] = {.lex_state = 76, .external_lex_state = 5},
  [2925] = {.lex_state = 76, .external_lex_state = 2},
  [2926] = {.lex_state = 76, .external_lex_state = 2},
  [2927] = {.lex_state = 76, .external_lex_state = 2},
  [2928] = {.lex_state = 76, .external_lex_state = 2},
  [2929] = {.lex_state = 76, .external_lex_state = 2},
  [2930] = {.lex_state = 76, .external_lex_state = 2},
  [2931] = {.lex_state = 76, .external_lex_state = 2},
  [2932] = {.lex_state = 76, .external_lex_state = 2},
  [2933] = {.lex_state = 76, .external_lex_state = 2},
  [2934] = {.lex_state = 7, .external_lex_state = 2},
  [2935] = {.lex_state = 7, .external_lex_state = 5},
  [2936] = {.lex_state = 7, .external_lex_state = 5},
  [2937] = {.lex_state = 7, .external_lex_state = 5},
  [2938] = {.lex_state = 7, .external_lex_state = 2},
  [2939] = {.lex_state = 7, .external_lex_state = 2},
  [2940] = {.lex_state = 7, .external_lex_state = 2},
  [2941] = {.lex_state = 7, .external_lex_state = 2},
  [2942] = {.lex_state = 7, .external_lex_state = 2},
  [2943] = {.lex_state = 76, .external_lex_state = 2},
  [2944] = {.lex_state = 76, .external_lex_state = 2},
  [2945] = {.lex_state = 76, .external_lex_state = 2},
  [2946] = {.lex_state = 76, .external_lex_state = 2},
  [2947] = {.lex_state = 76, .external_lex_state = 2},
  [2948] = {.lex_state = 76, .external_lex_state = 2},
  [2949] = {.lex_state = 76, .external_lex_state = 2},
  [2950] = {.lex_state = 76, .external_lex_state = 2},
  [2951] = {.lex_state = 76, .external_lex_state = 2},
  [2952] = {.lex_state = 76, .external_lex_state = 2},
  [2953] = {.lex_state = 76, .external_lex_state = 2},
  [2954] = {.lex_state = 76, .external_lex_state = 2},
  [2955] = {.lex_state = 76, .external_lex_state = 2},
  [2956] = {.lex_state = 76, .external_lex_state = 2},
  [2957] = {.lex_state = 7, .external_lex_state = 5},
  [2958] = {.lex_state = 7, .external_lex_state = 5},
  [2959] = {.lex_state = 7, .external_lex_state = 5},
  [2960] = {.lex_state = 7, .external_lex_state = 5},
  [2961] = {.lex_state = 7, .external_lex_state = 5},
  [2962] = {.lex_state = 7, .external_lex_state = 5},
  [2963] = {.lex_state = 7, .external_lex_state = 5},
  [2964] = {.lex_state = 7, .external_lex_state = 5},
  [2965] = {.lex_state = 7, .external_lex_state = 5},
  [2966] = {.lex_state = 7, .external_lex_state = 5},
  [2967] = {.lex_state = 7, .external_lex_state = 5},
  [2968] = {.lex_state = 7, .external_lex_state = 5},
  [2969] = {.lex_state = 7, .external_lex_state = 5},
  [2970] = {.lex_state = 7, .external_lex_state = 5},
  [2971] = {.lex_state = 7, .external_lex_state = 5},
  [2972] = {.lex_state = 7, .external_lex_state = 5},
  [2973] = {.lex_state = 7, .external_lex_state = 5},
  [2974] = {.lex_state = 7, .external_lex_state = 5},
  [2975] = {.lex_state = 7, .external_lex_state = 5},
  [2976] = {.lex_state = 7, .external_lex_state = 5},
  [2977] = {.lex_state = 7, .external_lex_state = 5},
  [2978] = {.lex_state = 7, .external_lex_state = 5},
  [2979] = {.lex_state = 7, .external_lex_state = 5},
  [2980] = {.lex_state = 7, .external_lex_state = 5},
  [2981] = {.lex_state = 7, .external_lex_state = 5},
  [2982] = {.lex_state = 7, .external_lex_state = 5},
  [2983] = {.lex_state = 7, .external_lex_state = 5},
  [2984] = {.lex_state = 7, .external_lex_state = 5},
  [2985] = {.lex_state = 7, .external_lex_state = 5},
  [2986] = {.lex_state = 7, .external_lex_state = 5},
  [2987] = {.lex_state = 7, .external_lex_state = 5},
  [2988] = {.lex_state = 7, .external_lex_state = 5},
  [2989] = {.lex_state = 7, .external_lex_state = 5},
  [2990] = {.lex_state = 7, .external_lex_state = 5},
  [2991] = {.lex_state = 76, .external_lex_state = 2},
  [2992] = {.lex_state = 76, .external_lex_state = 2},
  [2993] = {.lex_state = 76, .external_lex_state = 5},
  [2994] = {.lex_state = 76, .external_lex_state = 2},
  [2995] = {.lex_state = 76, .external_lex_state = 2},
  [2996] = {.lex_state = 76, .external_lex_state = 2},
  [2997] = {.lex_state = 76, .external_lex_state = 2},
  [2998] = {.lex_state = 76, .external_lex_state = 2},
  [2999] = {.lex_state = 76, .external_lex_state = 2},
  [3000] = {.lex_state = 76, .external_lex_state = 2},
  [3001] = {.lex_state = 76, .external_lex_state = 2},
  [3002] = {.lex_state = 76, .external_lex_state = 2},
  [3003] = {.lex_state = 76, .external_lex_state = 2},
  [3004] = {.lex_state = 76, .external_lex_state = 2},
  [3005] = {.lex_state = 76, .external_lex_state = 2},
  [3006] = {.lex_state = 76, .external_lex_state = 2},
  [3007] = {.lex_state = 76, .external_lex_state = 2},
  [3008] = {.lex_state = 76, .external_lex_state = 2},
  [3009] = {.lex_state = 76, .external_lex_state = 2},
  [3010] = {.lex_state = 76, .external_lex_state = 2},
  [3011] = {.lex_state = 76, .external_lex_state = 2},
  [3012] = {.lex_state = 76, .external_lex_state = 2},
  [3013] = {.lex_state = 76, .external_lex_state = 2},
  [3014] = {.lex_state = 76, .external_lex_state = 2},
  [3015] = {.lex_state = 2, .external_lex_state = 2},
  [3016] = {.lex_state = 2, .external_lex_state = 2},
  [3017] = {.lex_state = 76, .external_lex_state = 2},
  [3018] = {.lex_state = 76, .external_lex_state = 2},
  [3019] = {.lex_state = 76, .external_lex_state = 2},
  [3020] = {.lex_state = 76, .external_lex_state = 2},
  [3021] = {.lex_state = 7, .external_lex_state = 6},
  [3022] = {.lex_state = 7, .external_lex_state = 6},
  [3023] = {.lex_state = 7, .external_lex_state = 6},
  [3024] = {.lex_state = 2, .external_lex_state = 2},
  [3025] = {.lex_state = 76, .external_lex_state = 2},
  [3026] = {.lex_state = 76, .external_lex_state = 2},
  [3027] = {.lex_state = 76, .external_lex_state = 2},
  [3028] = {.lex_state = 76, .external_lex_state = 2},
  [3029] = {.lex_state = 76, .external_lex_state = 2},
  [3030] = {.lex_state = 76, .external_lex_state = 2},
  [3031] = {.lex_state = 76, .external_lex_state = 2},
  [3032] = {.lex_state = 2, .external_lex_state = 2},
  [3033] = {.lex_state = 76, .external_lex_state = 2},
  [3034] = {.lex_state = 2, .external_lex_state = 2},
  [3035] = {.lex_state = 2, .external_lex_state = 2},
  [3036] = {.lex_state = 76, .external_lex_state = 2},
  [3037] = {.lex_state = 2, .external_lex_state = 2},
  [3038] = {.lex_state = 76, .external_lex_state = 2},
  [3039] = {.lex_state = 76, .external_lex_state = 2},
  [3040] = {.lex_state = 76, .external_lex_state = 2},
  [3041] = {.lex_state = 76, .external_lex_state = 2},
  [3042] = {.lex_state = 76, .external_lex_state = 2},
  [3043] = {.lex_state = 76, .external_lex_state = 2},
  [3044] = {.lex_state = 76, .external_lex_state = 2},
  [3045] = {.lex_state = 2, .external_lex_state = 2},
  [3046] = {.lex_state = 76, .external_lex_state = 2},
  [3047] = {.lex_state = 76, .external_lex_state = 2},
  [3048] = {.lex_state = 2, .external_lex_state = 2},
  [3049] = {.lex_state = 76, .external_lex_state = 2},
  [3050] = {.lex_state = 76, .external_lex_state = 2},
  [3051] = {.lex_state = 76, .external_lex_state = 2},
  [3052] = {.lex_state = 2, .external_lex_state = 2},
  [3053] = {.lex_state = 76, .external_lex_state = 5},
  [3054] = {.lex_state = 76, .external_lex_state = 2},
  [3055] = {.lex_state = 76, .external_lex_state = 5},
  [3056] = {.lex_state = 76, .external_lex_state = 5},
  [3057] = {.lex_state = 76, .external_lex_state = 2},
  [3058] = {.lex_state = 76, .external_lex_state = 5},
  [3059] = {.lex_state = 76, .external_lex_state = 5},
  [3060] = {.lex_state = 76, .external_lex_state = 5},
  [3061] = {.lex_state = 76, .external_lex_state = 5},
  [3062] = {.lex_state = 76, .external_lex_state = 5},
  [3063] = {.lex_state = 76, .external_lex_state = 2},
  [3064] = {.lex_state = 76, .external_lex_state = 5},
  [3065] = {.lex_state = 76, .external_lex_state = 5},
  [3066] = {.lex_state = 76, .external_lex_state = 5},
  [3067] = {.lex_state = 76, .external_lex_state = 5},
  [3068] = {.lex_state = 76, .external_lex_state = 5},
  [3069] = {.lex_state = 76, .external_lex_state = 2},
  [3070] = {.lex_state = 76, .external_lex_state = 2},
  [3071] = {.lex_state = 76, .external_lex_state = 5},
  [3072] = {.lex_state = 76, .external_lex_state = 2},
  [3073] = {.lex_state = 76, .external_lex_state = 5},
  [3074] = {.lex_state = 76, .external_lex_state = 5},
  [3075] = {.lex_state = 76, .external_lex_state = 5},
  [3076] = {.lex_state = 76, .external_lex_state = 2},
  [3077] = {.lex_state = 76, .external_lex_state = 2},
  [3078] = {.lex_state = 76, .external_lex_state = 5},
  [3079] = {.lex_state = 76, .external_lex_state = 2},
  [3080] = {.lex_state = 76, .external_lex_state = 5},
  [3081] = {.lex_state = 76, .external_lex_state = 5},
  [3082] = {.lex_state = 76, .external_lex_state = 5},
  [3083] = {.lex_state = 76, .external_lex_state = 5},
  [3084] = {.lex_state = 76, .external_lex_state = 2},
  [3085] = {.lex_state = 76, .external_lex_state = 5},
  [3086] = {.lex_state = 76, .external_lex_state = 5},
  [3087] = {.lex_state = 76, .external_lex_state = 5},
  [3088] = {.lex_state = 76, .external_lex_state = 5},
  [3089] = {.lex_state = 76, .external_lex_state = 5},
  [3090] = {.lex_state = 76, .external_lex_state = 5},
  [3091] = {.lex_state = 76, .external_lex_state = 5},
  [3092] = {.lex_state = 76, .external_lex_state = 5},
  [3093] = {.lex_state = 76, .external_lex_state = 2},
  [3094] = {.lex_state = 76, .external_lex_state = 2},
  [3095] = {.lex_state = 76, .external_lex_state = 6},
  [3096] = {.lex_state = 7, .external_lex_state = 5},
  [3097] = {.lex_state = 7, .external_lex_state = 5},
  [3098] = {.lex_state = 7, .external_lex_state = 5},
  [3099] = {.lex_state = 76, .external_lex_state = 5},
  [3100] = {.lex_state = 76, .external_lex_state = 5},
  [3101] = {.lex_state = 76, .external_lex_state = 5},
  [3102] = {.lex_state = 76, .external_lex_state = 5},
  [3103] = {.lex_state = 76, .external_lex_state = 5},
  [3104] = {.lex_state = 76, .external_lex_state = 5},
  [3105] = {.lex_state = 76, .external_lex_state = 5},
  [3106] = {.lex_state = 76, .external_lex_state = 5},
  [3107] = {.lex_state = 76, .external_lex_state = 5},
  [3108] = {.lex_state = 76, .external_lex_state = 5},
  [3109] = {.lex_state = 7, .external_lex_state = 5},
  [3110] = {.lex_state = 76, .external_lex_state = 2},
  [3111] = {.lex_state = 7, .external_lex_state = 5},
  [3112] = {.lex_state = 7, .external_lex_state = 5},
  [3113] = {.lex_state = 76, .external_lex_state = 5},
  [3114] = {.lex_state = 76, .external_lex_state = 2},
  [3115] = {.lex_state = 76, .external_lex_state = 2},
  [3116] = {.lex_state = 7, .external_lex_state = 5},
  [3117] = {.lex_state = 76, .external_lex_state = 5},
  [3118] = {.lex_state = 76, .external_lex_state = 5},
  [3119] = {.lex_state = 76, .external_lex_state = 5},
  [3120] = {.lex_state = 76, .external_lex_state = 5},
  [3121] = {.lex_state = 76, .external_lex_state = 5},
  [3122] = {.lex_state = 76, .external_lex_state = 5},
  [3123] = {.lex_state = 7, .external_lex_state = 6},
  [3124] = {.lex_state = 7, .external_lex_state = 6},
  [3125] = {.lex_state = 7, .external_lex_state = 6},
  [3126] = {.lex_state = 7, .external_lex_state = 6},
  [3127] = {.lex_state = 7, .external_lex_state = 6},
  [3128] = {.lex_state = 7, .external_lex_state = 6},
  [3129] = {.lex_state = 7, .external_lex_state = 6},
  [3130] = {.lex_state = 7, .external_lex_state = 6},
  [3131] = {.lex_state = 7, .external_lex_state = 6},
  [3132] = {.lex_state = 7, .external_lex_state = 6},
  [3133] = {.lex_state = 7, .external_lex_state = 6},
  [3134] = {.lex_state = 76, .external_lex_state = 2},
  [3135] = {.lex_state = 7, .external_lex_state = 6},
  [3136] = {.lex_state = 7, .external_lex_state = 6},
  [3137] = {.lex_state = 7, .external_lex_state = 6},
  [3138] = {.lex_state = 7, .external_lex_state = 6},
  [3139] = {.lex_state = 7, .external_lex_state = 6},
  [3140] = {.lex_state = 7, .external_lex_state = 6},
  [3141] = {.lex_state = 7, .external_lex_state = 6},
  [3142] = {.lex_state = 7, .external_lex_state = 6},
  [3143] = {.lex_state = 7, .external_lex_state = 6},
  [3144] = {.lex_state = 7, .external_lex_state = 6},
  [3145] = {.lex_state = 7, .external_lex_state = 6},
  [3146] = {.lex_state = 7, .external_lex_state = 6},
  [3147] = {.lex_state = 7, .external_lex_state = 6},
  [3148] = {.lex_state = 7, .external_lex_state = 6},
  [3149] = {.lex_state = 7, .external_lex_state = 6},
  [3150] = {.lex_state = 7, .external_lex_state = 6},
  [3151] = {.lex_state = 7, .external_lex_state = 6},
  [3152] = {.lex_state = 7, .external_lex_state = 6},
  [3153] = {.lex_state = 7, .external_lex_state = 6},
  [3154] = {.lex_state = 7, .external_lex_state = 6},
  [3155] = {.lex_state = 7, .external_lex_state = 6},
  [3156] = {.lex_state = 7, .external_lex_state = 6},
  [3157] = {.lex_state = 76, .external_lex_state = 2},
  [3158] = {.lex_state = 76, .external_lex_state = 5},
  [3159] = {.lex_state = 76, .external_lex_state = 2},
  [3160] = {.lex_state = 76, .external_lex_state = 5},
  [3161] = {.lex_state = 76, .external_lex_state = 2},
  [3162] = {.lex_state = 7, .external_lex_state = 5},
  [3163] = {.lex_state = 76, .external_lex_state = 2},
  [3164] = {.lex_state = 76, .external_lex_state = 2},
  [3165] = {.lex_state = 76, .external_lex_state = 2},
  [3166] = {.lex_state = 7, .external_lex_state = 6},
  [3167] = {.lex_state = 76, .external_lex_state = 6},
  [3168] = {.lex_state = 76, .external_lex_state = 5},
  [3169] = {.lex_state = 76, .external_lex_state = 5},
  [3170] = {.lex_state = 76, .external_lex_state = 5},
  [3171] = {.lex_state = 76, .external_lex_state = 5},
  [3172] = {.lex_state = 76, .external_lex_state = 2},
  [3173] = {.lex_state = 76, .external_lex_state = 5},
  [3174] = {.lex_state = 76, .external_lex_state = 5},
  [3175] = {.lex_state = 76, .external_lex_state = 5},
  [3176] = {.lex_state = 76, .external_lex_state = 2},
  [3177] = {.lex_state = 76, .external_lex_state = 5},
  [3178] = {.lex_state = 76, .external_lex_state = 5},
  [3179] = {.lex_state = 76, .external_lex_state = 5},
  [3180] = {.lex_state = 76, .external_lex_state = 5},
  [3181] = {.lex_state = 76, .external_lex_state = 5},
  [3182] = {.lex_state = 76, .external_lex_state = 5},
  [3183] = {.lex_state = 76, .external_lex_state = 5},
  [3184] = {.lex_state = 76, .external_lex_state = 5},
  [3185] = {.lex_state = 76, .external_lex_state = 5},
  [3186] = {.lex_state = 76, .external_lex_state = 5},
  [3187] = {.lex_state = 76, .external_lex_state = 5},
  [3188] = {.lex_state = 76, .external_lex_state = 5},
  [3189] = {.lex_state = 76, .external_lex_state = 6},
  [3190] = {.lex_state = 76, .external_lex_state = 5},
  [3191] = {.lex_state = 76, .external_lex_state = 5},
  [3192] = {.lex_state = 76, .external_lex_state = 5},
  [3193] = {.lex_state = 76, .external_lex_state = 5},
  [3194] = {.lex_state = 76, .external_lex_state = 5},
  [3195] = {.lex_state = 76, .external_lex_state = 5},
  [3196] = {.lex_state = 76, .external_lex_state = 5},
  [3197] = {.lex_state = 76, .external_lex_state = 5},
  [3198] = {.lex_state = 76, .external_lex_state = 5},
  [3199] = {.lex_state = 76, .external_lex_state = 5},
  [3200] = {.lex_state = 76, .external_lex_state = 5},
  [3201] = {.lex_state = 76, .external_lex_state = 5},
  [3202] = {.lex_state = 76, .external_lex_state = 5},
  [3203] = {.lex_state = 76, .external_lex_state = 5},
  [3204] = {.lex_state = 76, .external_lex_state = 5},
  [3205] = {.lex_state = 76, .external_lex_state = 5},
  [3206] = {.lex_state = 7, .external_lex_state = 2},
  [3207] = {.lex_state = 76, .external_lex_state = 5},
  [3208] = {.lex_state = 7, .external_lex_state = 2},
  [3209] = {.lex_state = 7, .external_lex_state = 2},
  [3210] = {.lex_state = 76, .external_lex_state = 5},
  [3211] = {.lex_state = 76, .external_lex_state = 5},
  [3212] = {.lex_state = 76, .external_lex_state = 5},
  [3213] = {.lex_state = 76, .external_lex_state = 2},
  [3214] = {.lex_state = 76, .external_lex_state = 5},
  [3215] = {.lex_state = 76, .external_lex_state = 5},
  [3216] = {.lex_state = 76, .external_lex_state = 5},
  [3217] = {.lex_state = 76, .external_lex_state = 5},
  [3218] = {.lex_state = 76, .external_lex_state = 5},
  [3219] = {.lex_state = 76, .external_lex_state = 5},
  [3220] = {.lex_state = 76, .external_lex_state = 5},
  [3221] = {.lex_state = 76, .external_lex_state = 5},
  [3222] = {.lex_state = 76, .external_lex_state = 5},
  [3223] = {.lex_state = 76, .external_lex_state = 5},
  [3224] = {.lex_state = 76, .external_lex_state = 5},
  [3225] = {.lex_state = 76, .external_lex_state = 5},
  [3226] = {.lex_state = 7, .external_lex_state = 6},
  [3227] = {.lex_state = 76, .external_lex_state = 2},
  [3228] = {.lex_state = 7, .external_lex_state = 6},
  [3229] = {.lex_state = 7, .external_lex_state = 6},
  [3230] = {.lex_state = 76, .external_lex_state = 5},
  [3231] = {.lex_state = 7, .external_lex_state = 6},
  [3232] = {.lex_state = 76, .external_lex_state = 5},
  [3233] = {.lex_state = 76, .external_lex_state = 5},
  [3234] = {.lex_state = 76, .external_lex_state = 5},
  [3235] = {.lex_state = 76, .external_lex_state = 5},
  [3236] = {.lex_state = 76, .external_lex_state = 6},
  [3237] = {.lex_state = 76, .external_lex_state = 6},
  [3238] = {.lex_state = 76, .external_lex_state = 6},
  [3239] = {.lex_state = 76, .external_lex_state = 6},
  [3240] = {.lex_state = 76, .external_lex_state = 6},
  [3241] = {.lex_state = 76, .external_lex_state = 6},
  [3242] = {.lex_state = 76, .external_lex_state = 6},
  [3243] = {.lex_state = 76, .external_lex_state = 6},
  [3244] = {.lex_state = 76, .external_lex_state = 5},
  [3245] = {.lex_state = 76, .external_lex_state = 5},
  [3246] = {.lex_state = 7, .external_lex_state = 6},
  [3247] = {.lex_state = 76, .external_lex_state = 5},
  [3248] = {.lex_state = 76, .external_lex_state = 5},
  [3249] = {.lex_state = 76, .external_lex_state = 5},
  [3250] = {.lex_state = 76, .external_lex_state = 5},
  [3251] = {.lex_state = 76, .external_lex_state = 5},
  [3252] = {.lex_state = 76, .external_lex_state = 5},
  [3253] = {.lex_state = 76, .external_lex_state = 5},
  [3254] = {.lex_state = 76, .external_lex_state = 5},
  [3255] = {.lex_state = 76, .external_lex_state = 5},
  [3256] = {.lex_state = 76, .external_lex_state = 5},
  [3257] = {.lex_state = 76, .external_lex_state = 5},
  [3258] = {.lex_state = 76, .external_lex_state = 5},
  [3259] = {.lex_state = 76, .external_lex_state = 5},
  [3260] = {.lex_state = 76, .external_lex_state = 2},
  [3261] = {.lex_state = 7, .external_lex_state = 6},
  [3262] = {.lex_state = 76, .external_lex_state = 5},
  [3263] = {.lex_state = 76, .external_lex_state = 5},
  [3264] = {.lex_state = 76, .external_lex_state = 5},
  [3265] = {.lex_state = 76, .external_lex_state = 5},
  [3266] = {.lex_state = 76, .external_lex_state = 5},
  [3267] = {.lex_state = 76, .external_lex_state = 5},
  [3268] = {.lex_state = 76, .external_lex_state = 5},
  [3269] = {.lex_state = 76, .external_lex_state = 5},
  [3270] = {.lex_state = 76, .external_lex_state = 5},
  [3271] = {.lex_state = 76, .external_lex_state = 5},
  [3272] = {.lex_state = 76, .external_lex_state = 5},
  [3273] = {.lex_state = 76, .external_lex_state = 5},
  [3274] = {.lex_state = 76, .external_lex_state = 5},
  [3275] = {.lex_state = 76, .external_lex_state = 5},
  [3276] = {.lex_state = 76, .external_lex_state = 6},
  [3277] = {.lex_state = 76, .external_lex_state = 5},
  [3278] = {.lex_state = 7, .external_lex_state = 6},
  [3279] = {.lex_state = 7, .external_lex_state = 6},
  [3280] = {.lex_state = 76, .external_lex_state = 5},
  [3281] = {.lex_state = 76, .external_lex_state = 5},
  [3282] = {.lex_state = 76, .external_lex_state = 5},
  [3283] = {.lex_state = 76, .external_lex_state = 5},
  [3284] = {.lex_state = 76, .external_lex_state = 5},
  [3285] = {.lex_state = 76, .external_lex_state = 5},
  [3286] = {.lex_state = 76, .external_lex_state = 5},
  [3287] = {.lex_state = 76, .external_lex_state = 5},
  [3288] = {.lex_state = 76, .external_lex_state = 5},
  [3289] = {.lex_state = 76, .external_lex_state = 5},
  [3290] = {.lex_state = 76, .external_lex_state = 5},
  [3291] = {.lex_state = 76, .external_lex_state = 5},
  [3292] = {.lex_state = 76, .external_lex_state = 5},
  [3293] = {.lex_state = 76, .external_lex_state = 5},
  [3294] = {.lex_state = 76, .external_lex_state = 5},
  [3295] = {.lex_state = 76, .external_lex_state = 5},
  [3296] = {.lex_state = 76, .external_lex_state = 5},
  [3297] = {.lex_state = 76, .external_lex_state = 6},
  [3298] = {.lex_state = 76, .external_lex_state = 2},
  [3299] = {.lex_state = 76, .external_lex_state = 6},
  [3300] = {.lex_state = 76, .external_lex_state = 2},
  [3301] = {.lex_state = 76, .external_lex_state = 5},
  [3302] = {.lex_state = 76, .external_lex_state = 6},
  [3303] = {.lex_state = 76, .external_lex_state = 6},
  [3304] = {.lex_state = 76, .external_lex_state = 5},
  [3305] = {.lex_state = 76, .external_lex_state = 5},
  [3306] = {.lex_state = 76, .external_lex_state = 2},
  [3307] = {.lex_state = 76, .external_lex_state = 2},
  [3308] = {.lex_state = 76, .external_lex_state = 2},
  [3309] = {.lex_state = 76, .external_lex_state = 2},
  [3310] = {.lex_state = 76, .external_lex_state = 2},
  [3311] = {.lex_state = 76, .external_lex_state = 2},
  [3312] = {.lex_state = 76, .external_lex_state = 2},
  [3313] = {.lex_state = 76, .external_lex_state = 2},
  [3314] = {.lex_state = 76, .external_lex_state = 6},
  [3315] = {.lex_state = 76, .external_lex_state = 6},
  [3316] = {.lex_state = 76, .external_lex_state = 6},
  [3317] = {.lex_state = 76, .external_lex_state = 2},
  [3318] = {.lex_state = 76, .external_lex_state = 5},
  [3319] = {.lex_state = 76, .external_lex_state = 2},
  [3320] = {.lex_state = 76, .external_lex_state = 2},
  [3321] = {.lex_state = 76, .external_lex_state = 2},
  [3322] = {.lex_state = 76, .external_lex_state = 2},
  [3323] = {.lex_state = 76, .external_lex_state = 6},
  [3324] = {.lex_state = 76, .external_lex_state = 2},
  [3325] = {.lex_state = 76, .external_lex_state = 5},
  [3326] = {.lex_state = 76, .external_lex_state = 5},
  [3327] = {.lex_state = 76, .external_lex_state = 2},
  [3328] = {.lex_state = 76, .external_lex_state = 6},
  [3329] = {.lex_state = 76, .external_lex_state = 5},
  [3330] = {.lex_state = 76, .external_lex_state = 5},
  [3331] = {.lex_state = 76, .external_lex_state = 5},
  [3332] = {.lex_state = 76, .external_lex_state = 5},
  [3333] = {.lex_state = 76, .external_lex_state = 2},
  [3334] = {.lex_state = 76, .external_lex_state = 2},
  [3335] = {.lex_state = 76, .external_lex_state = 5},
  [3336] = {.lex_state = 76, .external_lex_state = 2},
  [3337] = {.lex_state = 76, .external_lex_state = 2},
  [3338] = {.lex_state = 76, .external_lex_state = 5},
  [3339] = {.lex_state = 76, .external_lex_state = 2},
  [3340] = {.lex_state = 76, .external_lex_state = 5},
  [3341] = {.lex_state = 76, .external_lex_state = 6},
  [3342] = {.lex_state = 76, .external_lex_state = 5},
  [3343] = {.lex_state = 76, .external_lex_state = 5},
  [3344] = {.lex_state = 76, .external_lex_state = 2},
  [3345] = {.lex_state = 76, .external_lex_state = 2},
  [3346] = {.lex_state = 76, .external_lex_state = 5},
  [3347] = {.lex_state = 76, .external_lex_state = 2},
  [3348] = {.lex_state = 76, .external_lex_state = 5},
  [3349] = {.lex_state = 76, .external_lex_state = 5},
  [3350] = {.lex_state = 76, .external_lex_state = 5},
  [3351] = {.lex_state = 76, .external_lex_state = 5},
  [3352] = {.lex_state = 76, .external_lex_state = 2},
  [3353] = {.lex_state = 76, .external_lex_state = 5},
  [3354] = {.lex_state = 76, .external_lex_state = 5},
  [3355] = {.lex_state = 76, .external_lex_state = 5},
  [3356] = {.lex_state = 76, .external_lex_state = 5},
  [3357] = {.lex_state = 76, .external_lex_state = 5},
  [3358] = {.lex_state = 76, .external_lex_state = 2},
  [3359] = {.lex_state = 76, .external_lex_state = 5},
  [3360] = {.lex_state = 76, .external_lex_state = 5},
  [3361] = {.lex_state = 76, .external_lex_state = 2},
  [3362] = {.lex_state = 76, .external_lex_state = 5},
  [3363] = {.lex_state = 76, .external_lex_state = 6},
  [3364] = {.lex_state = 76, .external_lex_state = 6},
  [3365] = {.lex_state = 76, .external_lex_state = 6},
  [3366] = {.lex_state = 76, .external_lex_state = 2},
  [3367] = {.lex_state = 76, .external_lex_state = 6},
  [3368] = {.lex_state = 76, .external_lex_state = 6},
  [3369] = {.lex_state = 76, .external_lex_state = 6},
  [3370] = {.lex_state = 76, .external_lex_state = 6},
  [3371] = {.lex_state = 76, .external_lex_state = 2},
  [3372] = {.lex_state = 76, .external_lex_state = 5},
  [3373] = {.lex_state = 76, .external_lex_state = 6},
  [3374] = {.lex_state = 76, .external_lex_state = 5},
  [3375] = {.lex_state = 76, .external_lex_state = 5},
  [3376] = {.lex_state = 76, .external_lex_state = 2},
  [3377] = {.lex_state = 76, .external_lex_state = 2},
  [3378] = {.lex_state = 76, .external_lex_state = 6},
  [3379] = {.lex_state = 76, .external_lex_state = 2},
  [3380] = {.lex_state = 76, .external_lex_state = 5},
  [3381] = {.lex_state = 76, .external_lex_state = 2},
  [3382] = {.lex_state = 76, .external_lex_state = 2},
  [3383] = {.lex_state = 76, .external_lex_state = 6},
  [3384] = {.lex_state = 76, .external_lex_state = 5},
  [3385] = {.lex_state = 76, .external_lex_state = 6},
  [3386] = {.lex_state = 76, .external_lex_state = 2},
  [3387] = {.lex_state = 76, .external_lex_state = 6},
  [3388] = {.lex_state = 76, .external_lex_state = 6},
  [3389] = {.lex_state = 76, .external_lex_state = 6},
  [3390] = {.lex_state = 76, .external_lex_state = 2},
  [3391] = {.lex_state = 76, .external_lex_state = 6},
  [3392] = {.lex_state = 76, .external_lex_state = 6},
  [3393] = {.lex_state = 76, .external_lex_state = 6},
  [3394] = {.lex_state = 76, .external_lex_state = 6},
  [3395] = {.lex_state = 76, .external_lex_state = 6},
  [3396] = {.lex_state = 76, .external_lex_state = 6},
  [3397] = {.lex_state = 76, .external_lex_state = 6},
  [3398] = {.lex_state = 8, .external_lex_state = 2},
  [3399] = {.lex_state = 76, .external_lex_state = 5},
  [3400] = {.lex_state = 76, .external_lex_state = 2},
  [3401] = {.lex_state = 76, .external_lex_state = 5},
  [3402] = {.lex_state = 76, .external_lex_state = 2},
  [3403] = {.lex_state = 76, .external_lex_state = 5},
  [3404] = {.lex_state = 76, .external_lex_state = 5},
  [3405] = {.lex_state = 76, .external_lex_state = 6},
  [3406] = {.lex_state = 76, .external_lex_state = 6},
  [3407] = {.lex_state = 76, .external_lex_state = 6},
  [3408] = {.lex_state = 76, .external_lex_state = 6},
  [3409] = {.lex_state = 76, .external_lex_state = 5},
  [3410] = {.lex_state = 76, .external_lex_state = 6},
  [3411] = {.lex_state = 76, .external_lex_state = 5},
  [3412] = {.lex_state = 76, .external_lex_state = 6},
  [3413] = {.lex_state = 76, .external_lex_state = 5},
  [3414] = {.lex_state = 76, .external_lex_state = 5},
  [3415] = {.lex_state = 76, .external_lex_state = 5},
  [3416] = {.lex_state = 76, .external_lex_state = 5},
  [3417] = {.lex_state = 76, .external_lex_state = 2},
  [3418] = {.lex_state = 76, .external_lex_state = 6},
  [3419] = {.lex_state = 76, .external_lex_state = 5},
  [3420] = {.lex_state = 76, .external_lex_state = 5},
  [3421] = {.lex_state = 76, .external_lex_state = 6},
  [3422] = {.lex_state = 76, .external_lex_state = 6},
  [3423] = {.lex_state = 76, .external_lex_state = 6},
  [3424] = {.lex_state = 76, .external_lex_state = 6},
  [3425] = {.lex_state = 76, .external_lex_state = 5},
  [3426] = {.lex_state = 76, .external_lex_state = 5},
  [3427] = {.lex_state = 76, .external_lex_state = 5},
  [3428] = {.lex_state = 76, .external_lex_state = 5},
  [3429] = {.lex_state = 8, .external_lex_state = 2},
  [3430] = {.lex_state = 76, .external_lex_state = 6},
  [3431] = {.lex_state = 76, .external_lex_state = 6},
  [3432] = {.lex_state = 76, .external_lex_state = 6},
  [3433] = {.lex_state = 76, .external_lex_state = 6},
  [3434] = {.lex_state = 76, .external_lex_state = 5},
  [3435] = {.lex_state = 76, .external_lex_state = 2},
  [3436] = {.lex_state = 76, .external_lex_state = 6},
  [3437] = {.lex_state = 76, .external_lex_state = 6},
  [3438] = {.lex_state = 76, .external_lex_state = 6},
  [3439] = {.lex_state = 8, .external_lex_state = 2},
  [3440] = {.lex_state = 76, .external_lex_state = 6},
  [3441] = {.lex_state = 76, .external_lex_state = 6},
  [3442] = {.lex_state = 76, .external_lex_state = 6},
  [3443] = {.lex_state = 76, .external_lex_state = 2},
  [3444] = {.lex_state = 76, .external_lex_state = 6},
  [3445] = {.lex_state = 76, .external_lex_state = 2},
  [3446] = {.lex_state = 76, .external_lex_state = 2},
  [3447] = {.lex_state = 76, .external_lex_state = 6},
  [3448] = {.lex_state = 76, .external_lex_state = 6},
  [3449] = {.lex_state = 76, .external_lex_state = 6},
  [3450] = {.lex_state = 76, .external_lex_state = 6},
  [3451] = {.lex_state = 76, .external_lex_state = 5},
  [3452] = {.lex_state = 76, .external_lex_state = 5},
  [3453] = {.lex_state = 76, .external_lex_state = 2},
  [3454] = {.lex_state = 76, .external_lex_state = 6},
  [3455] = {.lex_state = 76, .external_lex_state = 6},
  [3456] = {.lex_state = 76, .external_lex_state = 2},
  [3457] = {.lex_state = 76, .external_lex_state = 2},
  [3458] = {.lex_state = 76, .external_lex_state = 6},
  [3459] = {.lex_state = 76, .external_lex_state = 6},
  [3460] = {.lex_state = 76, .external_lex_state = 6},
  [3461] = {.lex_state = 76, .external_lex_state = 2},
  [3462] = {.lex_state = 76, .external_lex_state = 5},
  [3463] = {.lex_state = 76, .external_lex_state = 6},
  [3464] = {.lex_state = 76, .external_lex_state = 2},
  [3465] = {.lex_state = 76, .external_lex_state = 6},
  [3466] = {.lex_state = 76, .external_lex_state = 2},
  [3467] = {.lex_state = 76, .external_lex_state = 5},
  [3468] = {.lex_state = 76, .external_lex_state = 2},
  [3469] = {.lex_state = 76, .external_lex_state = 5},
  [3470] = {.lex_state = 76, .external_lex_state = 2},
  [3471] = {.lex_state = 76, .external_lex_state = 2},
  [3472] = {.lex_state = 76, .external_lex_state = 5},
  [3473] = {.lex_state = 76, .external_lex_state = 5},
  [3474] = {.lex_state = 76, .external_lex_state = 5},
  [3475] = {.lex_state = 76, .external_lex_state = 2},
  [3476] = {.lex_state = 76, .external_lex_state = 2},
  [3477] = {.lex_state = 13, .external_lex_state = 2},
  [3478] = {.lex_state = 76, .external_lex_state = 2},
  [3479] = {.lex_state = 76, .external_lex_state = 2},
  [3480] = {.lex_state = 13, .external_lex_state = 7},
  [3481] = {.lex_state = 76, .external_lex_state = 2},
  [3482] = {.lex_state = 13, .external_lex_state = 7},
  [3483] = {.lex_state = 76, .external_lex_state = 5},
  [3484] = {.lex_state = 76, .external_lex_state = 2},
  [3485] = {.lex_state = 13, .external_lex_state = 2},
  [3486] = {.lex_state = 76, .external_lex_state = 2},
  [3487] = {.lex_state = 76, .external_lex_state = 2},
  [3488] = {.lex_state = 76, .external_lex_state = 2},
  [3489] = {.lex_state = 13, .external_lex_state = 7},
  [3490] = {.lex_state = 13, .external_lex_state = 2},
  [3491] = {.lex_state = 13, .external_lex_state = 2},
  [3492] = {.lex_state = 76, .external_lex_state = 5},
  [3493] = {.lex_state = 13, .external_lex_state = 7},
  [3494] = {.lex_state = 13, .external_lex_state = 2},
  [3495] = {.lex_state = 13, .external_lex_state = 7},
  [3496] = {.lex_state = 13, .external_lex_state = 2},
  [3497] = {.lex_state = 76, .external_lex_state = 2},
  [3498] = {.lex_state = 76, .external_lex_state = 2},
  [3499] = {.lex_state = 76, .external_lex_state = 2},
  [3500] = {.lex_state = 13, .external_lex_state = 2},
  [3501] = {.lex_state = 13, .external_lex_state = 2},
  [3502] = {.lex_state = 76, .external_lex_state = 2},
  [3503] = {.lex_state = 7, .external_lex_state = 2},
  [3504] = {.lex_state = 76, .external_lex_state = 2},
  [3505] = {.lex_state = 13, .external_lex_state = 2},
  [3506] = {.lex_state = 76, .external_lex_state = 2},
  [3507] = {.lex_state = 7, .external_lex_state = 2},
  [3508] = {.lex_state = 7, .external_lex_state = 2},
  [3509] = {.lex_state = 13, .external_lex_state = 7},
  [3510] = {.lex_state = 76, .external_lex_state = 5},
  [3511] = {.lex_state = 76, .external_lex_state = 2},
  [3512] = {.lex_state = 76, .external_lex_state = 5},
  [3513] = {.lex_state = 13, .external_lex_state = 7},
  [3514] = {.lex_state = 13, .external_lex_state = 7},
  [3515] = {.lex_state = 76, .external_lex_state = 6},
  [3516] = {.lex_state = 76, .external_lex_state = 5},
  [3517] = {.lex_state = 76, .external_lex_state = 2},
  [3518] = {.lex_state = 76, .external_lex_state = 5},
  [3519] = {.lex_state = 76, .external_lex_state = 2},
  [3520] = {.lex_state = 76, .external_lex_state = 5},
  [3521] = {.lex_state = 76, .external_lex_state = 5},
  [3522] = {.lex_state = 76, .external_lex_state = 5},
  [3523] = {.lex_state = 76, .external_lex_state = 5},
  [3524] = {.lex_state = 76, .external_lex_state = 5},
  [3525] = {.lex_state = 76, .external_lex_state = 5},
  [3526] = {.lex_state = 76, .external_lex_state = 5},
  [3527] = {.lex_state = 7, .external_lex_state = 2},
  [3528] = {.lex_state = 76, .external_lex_state = 5},
  [3529] = {.lex_state = 76, .external_lex_state = 5},
  [3530] = {.lex_state = 76, .external_lex_state = 5},
  [3531] = {.lex_state = 76, .external_lex_state = 2},
  [3532] = {.lex_state = 76, .external_lex_state = 2},
  [3533] = {.lex_state = 76, .external_lex_state = 5},
  [3534] = {.lex_state = 76, .external_lex_state = 5},
  [3535] = {.lex_state = 76, .external_lex_state = 5},
  [3536] = {.lex_state = 76, .external_lex_state = 5},
  [3537] = {.lex_state = 76, .external_lex_state = 2},
  [3538] = {.lex_state = 76, .external_lex_state = 5},
  [3539] = {.lex_state = 76, .external_lex_state = 5},
  [3540] = {.lex_state = 76, .external_lex_state = 5},
  [3541] = {.lex_state = 76, .external_lex_state = 5},
  [3542] = {.lex_state = 76, .external_lex_state = 5},
  [3543] = {.lex_state = 76, .external_lex_state = 5},
  [3544] = {.lex_state = 76, .external_lex_state = 5},
  [3545] = {.lex_state = 76, .external_lex_state = 5},
  [3546] = {.lex_state = 76, .external_lex_state = 5},
  [3547] = {.lex_state = 76, .external_lex_state = 5},
  [3548] = {.lex_state = 76, .external_lex_state = 2},
  [3549] = {.lex_state = 76, .external_lex_state = 5},
  [3550] = {.lex_state = 76, .external_lex_state = 5},
  [3551] = {.lex_state = 76, .external_lex_state = 2},
  [3552] = {.lex_state = 76, .external_lex_state = 2},
  [3553] = {.lex_state = 76, .external_lex_state = 2},
  [3554] = {.lex_state = 76, .external_lex_state = 2},
  [3555] = {.lex_state = 76, .external_lex_state = 2},
  [3556] = {.lex_state = 76, .external_lex_state = 5},
  [3557] = {.lex_state = 76, .external_lex_state = 5},
  [3558] = {.lex_state = 76, .external_lex_state = 5},
  [3559] = {.lex_state = 76, .external_lex_state = 5},
  [3560] = {.lex_state = 7, .external_lex_state = 2},
  [3561] = {.lex_state = 76, .external_lex_state = 2},
  [3562] = {.lex_state = 76, .external_lex_state = 5},
  [3563] = {.lex_state = 7, .external_lex_state = 2},
  [3564] = {.lex_state = 7, .external_lex_state = 2},
  [3565] = {.lex_state = 76, .external_lex_state = 5},
  [3566] = {.lex_state = 76, .external_lex_state = 5},
  [3567] = {.lex_state = 76, .external_lex_state = 5},
  [3568] = {.lex_state = 76, .external_lex_state = 5},
  [3569] = {.lex_state = 76, .external_lex_state = 5},
  [3570] = {.lex_state = 76, .external_lex_state = 5},
  [3571] = {.lex_state = 76, .external_lex_state = 5},
  [3572] = {.lex_state = 76, .external_lex_state = 5},
  [3573] = {.lex_state = 76, .external_lex_state = 5},
  [3574] = {.lex_state = 76, .external_lex_state = 5},
  [3575] = {.lex_state = 76, .external_lex_state = 2},
  [3576] = {.lex_state = 76, .external_lex_state = 5},
  [3577] = {.lex_state = 76, .external_lex_state = 2},
  [3578] = {.lex_state = 7, .external_lex_state = 2},
  [3579] = {.lex_state = 76, .external_lex_state = 5},
  [3580] = {.lex_state = 76, .external_lex_state = 5},
  [3581] = {.lex_state = 76, .external_lex_state = 5},
  [3582] = {.lex_state = 76, .external_lex_state = 5},
  [3583] = {.lex_state = 7, .external_lex_state = 2},
  [3584] = {.lex_state = 7, .external_lex_state = 2},
  [3585] = {.lex_state = 76, .external_lex_state = 5},
  [3586] = {.lex_state = 76, .external_lex_state = 5},
  [3587] = {.lex_state = 76, .external_lex_state = 2},
  [3588] = {.lex_state = 76, .external_lex_state = 5},
  [3589] = {.lex_state = 76, .external_lex_state = 5},
  [3590] = {.lex_state = 76, .external_lex_state = 5},
  [3591] = {.lex_state = 76, .external_lex_state = 5},
  [3592] = {.lex_state = 76, .external_lex_state = 5},
  [3593] = {.lex_state = 76, .external_lex_state = 5},
  [3594] = {.lex_state = 7, .external_lex_state = 2},
  [3595] = {.lex_state = 76, .external_lex_state = 5},
  [3596] = {.lex_state = 76, .external_lex_state = 2},
  [3597] = {.lex_state = 76, .external_lex_state = 5},
  [3598] = {.lex_state = 76, .external_lex_state = 2},
  [3599] = {.lex_state = 76, .external_lex_state = 5},
  [3600] = {.lex_state = 7, .external_lex_state = 2},
  [3601] = {.lex_state = 76, .external_lex_state = 5},
  [3602] = {.lex_state = 76, .external_lex_state = 5},
  [3603] = {.lex_state = 76, .external_lex_state = 5},
  [3604] = {.lex_state = 76, .external_lex_state = 5},
  [3605] = {.lex_state = 76, .external_lex_state = 2},
  [3606] = {.lex_state = 76, .external_lex_state = 2},
  [3607] = {.lex_state = 76, .external_lex_state = 2},
  [3608] = {.lex_state = 7, .external_lex_state = 2},
  [3609] = {.lex_state = 76, .external_lex_state = 5},
  [3610] = {.lex_state = 7, .external_lex_state = 2},
  [3611] = {.lex_state = 76, .external_lex_state = 5},
  [3612] = {.lex_state = 76, .external_lex_state = 2},
  [3613] = {.lex_state = 76, .external_lex_state = 2},
  [3614] = {.lex_state = 7, .external_lex_state = 2},
  [3615] = {.lex_state = 76, .external_lex_state = 5},
  [3616] = {.lex_state = 76, .external_lex_state = 5},
  [3617] = {.lex_state = 76, .external_lex_state = 2},
  [3618] = {.lex_state = 7, .external_lex_state = 2},
  [3619] = {.lex_state = 76, .external_lex_state = 2},
  [3620] = {.lex_state = 76, .external_lex_state = 2},
  [3621] = {.lex_state = 76, .external_lex_state = 2},
  [3622] = {.lex_state = 76, .external_lex_state = 2},
  [3623] = {.lex_state = 76, .external_lex_state = 2},
  [3624] = {.lex_state = 76, .external_lex_state = 2},
  [3625] = {.lex_state = 76, .external_lex_state = 2},
  [3626] = {.lex_state = 76, .external_lex_state = 5},
  [3627] = {.lex_state = 76, .external_lex_state = 5},
  [3628] = {.lex_state = 76, .external_lex_state = 2},
  [3629] = {.lex_state = 76, .external_lex_state = 5},
  [3630] = {.lex_state = 76, .external_lex_state = 2},
  [3631] = {.lex_state = 76, .external_lex_state = 2},
  [3632] = {.lex_state = 76, .external_lex_state = 5},
  [3633] = {.lex_state = 76, .external_lex_state = 5},
  [3634] = {.lex_state = 76, .external_lex_state = 5},
  [3635] = {.lex_state = 76, .external_lex_state = 2},
  [3636] = {.lex_state = 76, .external_lex_state = 2},
  [3637] = {.lex_state = 76, .external_lex_state = 2},
  [3638] = {.lex_state = 76, .external_lex_state = 5},
  [3639] = {.lex_state = 76, .external_lex_state = 2},
  [3640] = {.lex_state = 76, .external_lex_state = 5},
  [3641] = {.lex_state = 8, .external_lex_state = 2},
  [3642] = {.lex_state = 76, .external_lex_state = 5},
  [3643] = {.lex_state = 76, .external_lex_state = 5},
  [3644] = {.lex_state = 76, .external_lex_state = 5},
  [3645] = {.lex_state = 76, .external_lex_state = 5},
  [3646] = {.lex_state = 76, .external_lex_state = 5},
  [3647] = {.lex_state = 76, .external_lex_state = 2},
  [3648] = {.lex_state = 76, .external_lex_state = 5},
  [3649] = {.lex_state = 76, .external_lex_state = 5},
  [3650] = {.lex_state = 76, .external_lex_state = 5},
  [3651] = {.lex_state = 76, .external_lex_state = 2},
  [3652] = {.lex_state = 76, .external_lex_state = 5},
  [3653] = {.lex_state = 76, .external_lex_state = 5},
  [3654] = {.lex_state = 76, .external_lex_state = 5},
  [3655] = {.lex_state = 76, .external_lex_state = 5},
  [3656] = {.lex_state = 76, .external_lex_state = 5},
  [3657] = {.lex_state = 76, .external_lex_state = 5},
  [3658] = {.lex_state = 76, .external_lex_state = 2},
  [3659] = {.lex_state = 76, .external_lex_state = 5},
  [3660] = {.lex_state = 76, .external_lex_state = 2},
  [3661] = {.lex_state = 76, .external_lex_state = 5},
  [3662] = {.lex_state = 76, .external_lex_state = 5},
  [3663] = {.lex_state = 76, .external_lex_state = 2},
  [3664] = {.lex_state = 76, .external_lex_state = 5},
  [3665] = {.lex_state = 76, .external_lex_state = 5},
  [3666] = {.lex_state = 76, .external_lex_state = 2},
  [3667] = {.lex_state = 76, .external_lex_state = 2},
  [3668] = {.lex_state = 76, .external_lex_state = 2},
  [3669] = {.lex_state = 76, .external_lex_state = 2},
  [3670] = {.lex_state = 76, .external_lex_state = 5},
  [3671] = {.lex_state = 76, .external_lex_state = 5},
  [3672] = {.lex_state = 76, .external_lex_state = 2},
  [3673] = {.lex_state = 76, .external_lex_state = 5},
  [3674] = {.lex_state = 76, .external_lex_state = 2},
  [3675] = {.lex_state = 76, .external_lex_state = 5},
  [3676] = {.lex_state = 76, .external_lex_state = 2},
  [3677] = {.lex_state = 76, .external_lex_state = 5},
  [3678] = {.lex_state = 76, .external_lex_state = 5},
  [3679] = {.lex_state = 76, .external_lex_state = 2},
  [3680] = {.lex_state = 76, .external_lex_state = 5},
  [3681] = {.lex_state = 76, .external_lex_state = 5},
  [3682] = {.lex_state = 76, .external_lex_state = 5},
  [3683] = {.lex_state = 76, .external_lex_state = 2},
  [3684] = {.lex_state = 76, .external_lex_state = 5},
  [3685] = {.lex_state = 76, .external_lex_state = 5},
  [3686] = {.lex_state = 76, .external_lex_state = 5},
  [3687] = {.lex_state = 76, .external_lex_state = 5},
  [3688] = {.lex_state = 76, .external_lex_state = 5},
  [3689] = {.lex_state = 7, .external_lex_state = 2},
  [3690] = {.lex_state = 76, .external_lex_state = 5},
  [3691] = {.lex_state = 76, .external_lex_state = 5},
  [3692] = {.lex_state = 76, .external_lex_state = 5},
  [3693] = {.lex_state = 76, .external_lex_state = 5},
  [3694] = {.lex_state = 7, .external_lex_state = 2},
  [3695] = {.lex_state = 76, .external_lex_state = 5},
  [3696] = {.lex_state = 76, .external_lex_state = 5},
  [3697] = {.lex_state = 76, .external_lex_state = 5},
  [3698] = {.lex_state = 76, .external_lex_state = 5},
  [3699] = {.lex_state = 76, .external_lex_state = 2},
  [3700] = {.lex_state = 76, .external_lex_state = 2},
  [3701] = {.lex_state = 76, .external_lex_state = 5},
  [3702] = {.lex_state = 76, .external_lex_state = 2},
  [3703] = {.lex_state = 76, .external_lex_state = 5},
  [3704] = {.lex_state = 76, .external_lex_state = 5},
  [3705] = {.lex_state = 76, .external_lex_state = 2},
  [3706] = {.lex_state = 76, .external_lex_state = 2},
  [3707] = {.lex_state = 76, .external_lex_state = 5},
  [3708] = {.lex_state = 76, .external_lex_state = 5},
  [3709] = {.lex_state = 76, .external_lex_state = 5},
  [3710] = {.lex_state = 7, .external_lex_state = 2},
  [3711] = {.lex_state = 76, .external_lex_state = 5},
  [3712] = {.lex_state = 76, .external_lex_state = 2},
  [3713] = {.lex_state = 76, .external_lex_state = 5},
  [3714] = {.lex_state = 76, .external_lex_state = 5},
  [3715] = {.lex_state = 76, .external_lex_state = 2},
  [3716] = {.lex_state = 8, .external_lex_state = 2},
  [3717] = {.lex_state = 76, .external_lex_state = 2},
  [3718] = {.lex_state = 76, .external_lex_state = 2},
  [3719] = {.lex_state = 76, .external_lex_state = 5},
  [3720] = {.lex_state = 76, .external_lex_state = 5},
  [3721] = {.lex_state = 76, .external_lex_state = 5},
  [3722] = {.lex_state = 76, .external_lex_state = 5},
  [3723] = {.lex_state = 76, .external_lex_state = 2},
  [3724] = {.lex_state = 76, .external_lex_state = 5},
  [3725] = {.lex_state = 76, .external_lex_state = 5},
  [3726] = {.lex_state = 76, .external_lex_state = 5},
  [3727] = {.lex_state = 76, .external_lex_state = 5},
  [3728] = {.lex_state = 76, .external_lex_state = 2},
  [3729] = {.lex_state = 76, .external_lex_state = 2},
  [3730] = {.lex_state = 76, .external_lex_state = 5},
  [3731] = {.lex_state = 76, .external_lex_state = 5},
  [3732] = {.lex_state = 76, .external_lex_state = 5},
  [3733] = {.lex_state = 76, .external_lex_state = 5},
  [3734] = {.lex_state = 76, .external_lex_state = 5},
  [3735] = {.lex_state = 76, .external_lex_state = 5},
  [3736] = {.lex_state = 76, .external_lex_state = 5},
  [3737] = {.lex_state = 76, .external_lex_state = 5},
  [3738] = {.lex_state = 76, .external_lex_state = 2},
  [3739] = {.lex_state = 76, .external_lex_state = 5},
  [3740] = {.lex_state = 76, .external_lex_state = 5},
  [3741] = {.lex_state = 76, .external_lex_state = 2},
  [3742] = {.lex_state = 76, .external_lex_state = 5},
  [3743] = {.lex_state = 76, .external_lex_state = 5},
  [3744] = {.lex_state = 76, .external_lex_state = 2},
  [3745] = {.lex_state = 76, .external_lex_state = 5},
  [3746] = {.lex_state = 76, .external_lex_state = 5},
  [3747] = {.lex_state = 8, .external_lex_state = 2},
  [3748] = {.lex_state = 76, .external_lex_state = 2},
  [3749] = {.lex_state = 76, .external_lex_state = 5},
  [3750] = {.lex_state = 76, .external_lex_state = 5},
  [3751] = {.lex_state = 76, .external_lex_state = 2},
  [3752] = {.lex_state = 76, .external_lex_state = 2},
  [3753] = {.lex_state = 76, .external_lex_state = 2},
  [3754] = {.lex_state = 76, .external_lex_state = 5},
  [3755] = {.lex_state = 76, .external_lex_state = 5},
  [3756] = {.lex_state = 76, .external_lex_state = 2},
  [3757] = {.lex_state = 7, .external_lex_state = 2},
  [3758] = {.lex_state = 76, .external_lex_state = 5},
  [3759] = {.lex_state = 76, .external_lex_state = 5},
  [3760] = {.lex_state = 76, .external_lex_state = 6},
  [3761] = {.lex_state = 76, .external_lex_state = 5},
  [3762] = {.lex_state = 76, .external_lex_state = 2},
  [3763] = {.lex_state = 76, .external_lex_state = 2},
  [3764] = {.lex_state = 76, .external_lex_state = 2},
  [3765] = {.lex_state = 76, .external_lex_state = 2},
  [3766] = {.lex_state = 76, .external_lex_state = 2},
  [3767] = {.lex_state = 76, .external_lex_state = 2},
  [3768] = {.lex_state = 76, .external_lex_state = 2},
  [3769] = {.lex_state = 76, .external_lex_state = 2},
  [3770] = {.lex_state = 13, .external_lex_state = 7},
  [3771] = {.lex_state = 76, .external_lex_state = 2},
  [3772] = {.lex_state = 76, .external_lex_state = 2},
  [3773] = {.lex_state = 76, .external_lex_state = 2},
  [3774] = {.lex_state = 76, .external_lex_state = 2},
  [3775] = {.lex_state = 76, .external_lex_state = 2},
  [3776] = {.lex_state = 76, .external_lex_state = 2},
  [3777] = {.lex_state = 76, .external_lex_state = 2},
  [3778] = {.lex_state = 13, .external_lex_state = 7},
  [3779] = {.lex_state = 76, .external_lex_state = 5},
  [3780] = {.lex_state = 76, .external_lex_state = 5},
  [3781] = {.lex_state = 76, .external_lex_state = 5},
  [3782] = {.lex_state = 13, .external_lex_state = 7},
  [3783] = {.lex_state = 76, .external_lex_state = 5},
  [3784] = {.lex_state = 76, .external_lex_state = 2},
  [3785] = {.lex_state = 76, .external_lex_state = 6},
  [3786] = {.lex_state = 76, .external_lex_state = 2},
  [3787] = {.lex_state = 76, .external_lex_state = 2},
  [3788] = {.lex_state = 76, .external_lex_state = 5},
  [3789] = {.lex_state = 76, .external_lex_state = 5},
  [3790] = {.lex_state = 76, .external_lex_state = 2},
  [3791] = {.lex_state = 76, .external_lex_state = 2},
  [3792] = {.lex_state = 76, .external_lex_state = 2},
  [3793] = {.lex_state = 76, .external_lex_state = 2},
  [3794] = {.lex_state = 76, .external_lex_state = 5},
  [3795] = {.lex_state = 76, .external_lex_state = 2},
  [3796] = {.lex_state = 76, .external_lex_state = 2},
  [3797] = {.lex_state = 76, .external_lex_state = 2},
  [3798] = {.lex_state = 76, .external_lex_state = 2},
  [3799] = {.lex_state = 76, .external_lex_state = 2},
  [3800] = {.lex_state = 76, .external_lex_state = 2},
  [3801] = {.lex_state = 76, .external_lex_state = 2},
  [3802] = {.lex_state = 76, .external_lex_state = 2},
  [3803] = {.lex_state = 76, .external_lex_state = 2},
  [3804] = {.lex_state = 76, .external_lex_state = 2},
  [3805] = {.lex_state = 76, .external_lex_state = 2},
  [3806] = {.lex_state = 76, .external_lex_state = 2},
  [3807] = {.lex_state = 8, .external_lex_state = 2},
  [3808] = {.lex_state = 76, .external_lex_state = 2},
  [3809] = {.lex_state = 76, .external_lex_state = 2},
  [3810] = {.lex_state = 76, .external_lex_state = 5},
  [3811] = {.lex_state = 76, .external_lex_state = 6},
  [3812] = {.lex_state = 76, .external_lex_state = 6},
  [3813] = {.lex_state = 76, .external_lex_state = 5},
  [3814] = {.lex_state = 76, .external_lex_state = 5},
  [3815] = {.lex_state = 76, .external_lex_state = 2},
  [3816] = {.lex_state = 76, .external_lex_state = 6},
  [3817] = {.lex_state = 76, .external_lex_state = 2},
  [3818] = {.lex_state = 76, .external_lex_state = 5},
  [3819] = {.lex_state = 76, .external_lex_state = 2},
  [3820] = {.lex_state = 13, .external_lex_state = 7},
  [3821] = {.lex_state = 76, .external_lex_state = 2},
  [3822] = {.lex_state = 76, .external_lex_state = 5},
  [3823] = {.lex_state = 76, .external_lex_state = 5},
  [3824] = {.lex_state = 76, .external_lex_state = 5},
  [3825] = {.lex_state = 76, .external_lex_state = 5},
  [3826] = {.lex_state = 76, .external_lex_state = 2},
  [3827] = {.lex_state = 76, .external_lex_state = 2},
  [3828] = {.lex_state = 76, .external_lex_state = 5},
  [3829] = {.lex_state = 76, .external_lex_state = 5},
  [3830] = {.lex_state = 76, .external_lex_state = 5},
  [3831] = {.lex_state = 76, .external_lex_state = 5},
  [3832] = {.lex_state = 76, .external_lex_state = 2},
  [3833] = {.lex_state = 76, .external_lex_state = 5},
  [3834] = {.lex_state = 76, .external_lex_state = 5},
  [3835] = {.lex_state = 76, .external_lex_state = 5},
  [3836] = {.lex_state = 76, .external_lex_state = 2},
  [3837] = {.lex_state = 76, .external_lex_state = 5},
  [3838] = {.lex_state = 76, .external_lex_state = 5},
  [3839] = {.lex_state = 76, .external_lex_state = 2},
  [3840] = {.lex_state = 76, .external_lex_state = 2},
  [3841] = {.lex_state = 76, .external_lex_state = 6},
  [3842] = {.lex_state = 76, .external_lex_state = 2},
  [3843] = {.lex_state = 76, .external_lex_state = 5},
  [3844] = {.lex_state = 76, .external_lex_state = 2},
  [3845] = {.lex_state = 76, .external_lex_state = 2},
  [3846] = {.lex_state = 76, .external_lex_state = 2},
  [3847] = {.lex_state = 76, .external_lex_state = 2},
  [3848] = {.lex_state = 76, .external_lex_state = 2},
  [3849] = {.lex_state = 76, .external_lex_state = 6},
  [3850] = {.lex_state = 76, .external_lex_state = 2},
  [3851] = {.lex_state = 76, .external_lex_state = 2},
  [3852] = {.lex_state = 76, .external_lex_state = 2},
  [3853] = {.lex_state = 76, .external_lex_state = 6},
  [3854] = {.lex_state = 76, .external_lex_state = 2},
  [3855] = {.lex_state = 76, .external_lex_state = 6},
  [3856] = {.lex_state = 76, .external_lex_state = 2},
  [3857] = {.lex_state = 76, .external_lex_state = 6},
  [3858] = {.lex_state = 76, .external_lex_state = 2},
  [3859] = {.lex_state = 76, .external_lex_state = 2},
  [3860] = {.lex_state = 76, .external_lex_state = 6},
  [3861] = {.lex_state = 76, .external_lex_state = 2},
  [3862] = {.lex_state = 76, .external_lex_state = 6},
  [3863] = {.lex_state = 76, .external_lex_state = 2},
  [3864] = {.lex_state = 76, .external_lex_state = 6},
  [3865] = {.lex_state = 76, .external_lex_state = 2},
  [3866] = {.lex_state = 76, .external_lex_state = 2},
  [3867] = {.lex_state = 76, .external_lex_state = 2},
  [3868] = {.lex_state = 76, .external_lex_state = 2},
  [3869] = {.lex_state = 76, .external_lex_state = 6},
  [3870] = {.lex_state = 76, .external_lex_state = 6},
  [3871] = {.lex_state = 13, .external_lex_state = 7},
  [3872] = {.lex_state = 76, .external_lex_state = 6},
  [3873] = {.lex_state = 76, .external_lex_state = 6},
  [3874] = {.lex_state = 76, .external_lex_state = 2},
  [3875] = {.lex_state = 76, .external_lex_state = 2},
  [3876] = {.lex_state = 76, .external_lex_state = 2},
  [3877] = {.lex_state = 76, .external_lex_state = 2},
  [3878] = {.lex_state = 76, .external_lex_state = 2},
  [3879] = {.lex_state = 76, .external_lex_state = 6},
  [3880] = {.lex_state = 76, .external_lex_state = 6},
  [3881] = {.lex_state = 76, .external_lex_state = 2},
  [3882] = {.lex_state = 76, .external_lex_state = 6},
  [3883] = {.lex_state = 76, .external_lex_state = 6},
  [3884] = {.lex_state = 76, .external_lex_state = 2},
  [3885] = {.lex_state = 76, .external_lex_state = 2},
  [3886] = {.lex_state = 76, .external_lex_state = 2},
  [3887] = {.lex_state = 76, .external_lex_state = 2},
  [3888] = {.lex_state = 76, .external_lex_state = 2},
  [3889] = {.lex_state = 8, .external_lex_state = 2},
  [3890] = {.lex_state = 76, .external_lex_state = 2},
  [3891] = {.lex_state = 76, .external_lex_state = 2},
  [3892] = {.lex_state = 76, .external_lex_state = 2},
  [3893] = {.lex_state = 76, .external_lex_state = 6},
  [3894] = {.lex_state = 76, .external_lex_state = 2},
  [3895] = {.lex_state = 76, .external_lex_state = 2},
  [3896] = {.lex_state = 76, .external_lex_state = 5},
  [3897] = {.lex_state = 76, .external_lex_state = 2},
  [3898] = {.lex_state = 76, .external_lex_state = 2},
  [3899] = {.lex_state = 76, .external_lex_state = 5},
  [3900] = {.lex_state = 76, .external_lex_state = 2},
  [3901] = {.lex_state = 76, .external_lex_state = 5},
  [3902] = {.lex_state = 76, .external_lex_state = 6},
  [3903] = {.lex_state = 76, .external_lex_state = 2},
  [3904] = {.lex_state = 76, .external_lex_state = 2},
  [3905] = {.lex_state = 76, .external_lex_state = 6},
  [3906] = {.lex_state = 76, .external_lex_state = 2},
  [3907] = {.lex_state = 76, .external_lex_state = 6},
  [3908] = {.lex_state = 76, .external_lex_state = 6},
  [3909] = {.lex_state = 76, .external_lex_state = 2},
  [3910] = {.lex_state = 76, .external_lex_state = 2},
  [3911] = {.lex_state = 76, .external_lex_state = 2},
  [3912] = {.lex_state = 76, .external_lex_state = 5},
  [3913] = {.lex_state = 76, .external_lex_state = 6},
  [3914] = {.lex_state = 76, .external_lex_state = 5},
  [3915] = {.lex_state = 76, .external_lex_state = 5},
  [3916] = {.lex_state = 76, .external_lex_state = 5},
  [3917] = {.lex_state = 2, .external_lex_state = 2},
  [3918] = {.lex_state = 76, .external_lex_state = 5},
  [3919] = {.lex_state = 76, .external_lex_state = 5},
  [3920] = {.lex_state = 76, .external_lex_state = 2},
  [3921] = {.lex_state = 76, .external_lex_state = 5},
  [3922] = {.lex_state = 2, .external_lex_state = 2},
  [3923] = {.lex_state = 76, .external_lex_state = 5},
  [3924] = {.lex_state = 76, .external_lex_state = 5},
  [3925] = {.lex_state = 76, .external_lex_state = 6},
  [3926] = {.lex_state = 76, .external_lex_state = 5},
  [3927] = {.lex_state = 76, .external_lex_state = 5},
  [3928] = {.lex_state = 76, .external_lex_state = 5},
  [3929] = {.lex_state = 76, .external_lex_state = 2},
  [3930] = {.lex_state = 76, .external_lex_state = 5},
  [3931] = {.lex_state = 76, .external_lex_state = 5},
  [3932] = {.lex_state = 76, .external_lex_state = 5},
  [3933] = {.lex_state = 76, .external_lex_state = 2},
  [3934] = {.lex_state = 76, .external_lex_state = 2},
  [3935] = {.lex_state = 76, .external_lex_state = 2},
  [3936] = {.lex_state = 76, .external_lex_state = 5},
  [3937] = {.lex_state = 76, .external_lex_state = 2},
  [3938] = {.lex_state = 76, .external_lex_state = 2},
  [3939] = {.lex_state = 76, .external_lex_state = 6},
  [3940] = {.lex_state = 76, .external_lex_state = 5},
  [3941] = {.lex_state = 76, .external_lex_state = 2},
  [3942] = {.lex_state = 76, .external_lex_state = 5},
  [3943] = {.lex_state = 76, .external_lex_state = 5},
  [3944] = {.lex_state = 76, .external_lex_state = 6},
  [3945] = {.lex_state = 76, .external_lex_state = 5},
  [3946] = {.lex_state = 76, .external_lex_state = 5},
  [3947] = {.lex_state = 76, .external_lex_state = 2},
  [3948] = {.lex_state = 76, .external_lex_state = 5},
  [3949] = {.lex_state = 76, .external_lex_state = 2},
  [3950] = {.lex_state = 76, .external_lex_state = 5},
  [3951] = {.lex_state = 76, .external_lex_state = 5},
  [3952] = {.lex_state = 76, .external_lex_state = 2},
  [3953] = {.lex_state = 76, .external_lex_state = 5},
  [3954] = {.lex_state = 76, .external_lex_state = 5},
  [3955] = {.lex_state = 76, .external_lex_state = 5},
  [3956] = {.lex_state = 76, .external_lex_state = 5},
  [3957] = {.lex_state = 76, .external_lex_state = 2},
  [3958] = {.lex_state = 76, .external_lex_state = 5},
  [3959] = {.lex_state = 76, .external_lex_state = 5},
  [3960] = {.lex_state = 76, .external_lex_state = 5},
  [3961] = {.lex_state = 76, .external_lex_state = 2},
  [3962] = {.lex_state = 76, .external_lex_state = 6},
  [3963] = {.lex_state = 76, .external_lex_state = 5},
  [3964] = {.lex_state = 76, .external_lex_state = 2},
  [3965] = {.lex_state = 76, .external_lex_state = 5},
  [3966] = {.lex_state = 76, .external_lex_state = 5},
  [3967] = {.lex_state = 76, .external_lex_state = 5},
  [3968] = {.lex_state = 76, .external_lex_state = 2},
  [3969] = {.lex_state = 76, .external_lex_state = 5},
  [3970] = {.lex_state = 76, .external_lex_state = 5},
  [3971] = {.lex_state = 76, .external_lex_state = 2},
  [3972] = {.lex_state = 76, .external_lex_state = 5},
  [3973] = {.lex_state = 76, .external_lex_state = 2},
  [3974] = {.lex_state = 76, .external_lex_state = 5},
  [3975] = {.lex_state = 76, .external_lex_state = 2},
  [3976] = {.lex_state = 76, .external_lex_state = 5},
  [3977] = {.lex_state = 76, .external_lex_state = 5},
  [3978] = {.lex_state = 76, .external_lex_state = 2},
  [3979] = {.lex_state = 76, .external_lex_state = 5},
  [3980] = {.lex_state = 76, .external_lex_state = 5},
  [3981] = {.lex_state = 76, .external_lex_state = 5},
  [3982] = {.lex_state = 76, .external_lex_state = 2},
  [3983] = {.lex_state = 76, .external_lex_state = 5},
  [3984] = {.lex_state = 76, .external_lex_state = 2},
  [3985] = {.lex_state = 76, .external_lex_state = 5},
  [3986] = {.lex_state = 76, .external_lex_state = 5},
  [3987] = {.lex_state = 76, .external_lex_state = 5},
  [3988] = {.lex_state = 76, .external_lex_state = 5},
  [3989] = {.lex_state = 76, .external_lex_state = 5},
  [3990] = {.lex_state = 76, .external_lex_state = 5},
  [3991] = {.lex_state = 76, .external_lex_state = 5},
  [3992] = {.lex_state = 76, .external_lex_state = 5},
  [3993] = {.lex_state = 76, .external_lex_state = 5},
  [3994] = {.lex_state = 76, .external_lex_state = 2},
  [3995] = {.lex_state = 76, .external_lex_state = 5},
  [3996] = {.lex_state = 76, .external_lex_state = 5},
  [3997] = {.lex_state = 76, .external_lex_state = 5},
  [3998] = {.lex_state = 76, .external_lex_state = 5},
  [3999] = {.lex_state = 76, .external_lex_state = 2},
  [4000] = {.lex_state = 76, .external_lex_state = 5},
  [4001] = {.lex_state = 76, .external_lex_state = 5},
  [4002] = {.lex_state = 13, .external_lex_state = 8},
  [4003] = {.lex_state = 76, .external_lex_state = 5},
  [4004] = {.lex_state = 76, .external_lex_state = 5},
  [4005] = {.lex_state = 76, .external_lex_state = 2},
  [4006] = {.lex_state = 76, .external_lex_state = 6},
  [4007] = {.lex_state = 8, .external_lex_state = 2},
  [4008] = {.lex_state = 8, .external_lex_state = 2},
  [4009] = {.lex_state = 76, .external_lex_state = 2},
  [4010] = {.lex_state = 76, .external_lex_state = 5},
  [4011] = {.lex_state = 13, .external_lex_state = 8},
  [4012] = {.lex_state = 76, .external_lex_state = 5},
  [4013] = {.lex_state = 76, .external_lex_state = 5},
  [4014] = {.lex_state = 76, .external_lex_state = 5},
  [4015] = {.lex_state = 76, .external_lex_state = 6},
  [4016] = {.lex_state = 13, .external_lex_state = 8},
  [4017] = {.lex_state = 76, .external_lex_state = 5},
  [4018] = {.lex_state = 76, .external_lex_state = 5},
  [4019] = {.lex_state = 76, .external_lex_state = 5},
  [4020] = {.lex_state = 13, .external_lex_state = 8},
  [4021] = {.lex_state = 76, .external_lex_state = 5},
  [4022] = {.lex_state = 76, .external_lex_state = 2},
  [4023] = {.lex_state = 76, .external_lex_state = 5},
  [4024] = {.lex_state = 76, .external_lex_state = 6},
  [4025] = {.lex_state = 76, .external_lex_state = 5},
  [4026] = {.lex_state = 76, .external_lex_state = 5},
  [4027] = {.lex_state = 76, .external_lex_state = 5},
  [4028] = {.lex_state = 76, .external_lex_state = 5},
  [4029] = {.lex_state = 76, .external_lex_state = 5},
  [4030] = {.lex_state = 76, .external_lex_state = 5},
  [4031] = {.lex_state = 76, .external_lex_state = 5},
  [4032] = {.lex_state = 76, .external_lex_state = 5},
  [4033] = {.lex_state = 76, .external_lex_state = 5},
  [4034] = {.lex_state = 76, .external_lex_state = 5},
  [4035] = {.lex_state = 76, .external_lex_state = 5},
  [4036] = {.lex_state = 76, .external_lex_state = 5},
  [4037] = {.lex_state = 76, .external_lex_state = 5},
  [4038] = {.lex_state = 76, .external_lex_state = 5},
  [4039] = {.lex_state = 76, .external_lex_state = 5},
  [4040] = {.lex_state = 76, .external_lex_state = 5},
  [4041] = {.lex_state = 76, .external_lex_state = 2},
  [4042] = {.lex_state = 13, .external_lex_state = 8},
  [4043] = {.lex_state = 76, .external_lex_state = 5},
  [4044] = {.lex_state = 76, .external_lex_state = 5},
  [4045] = {.lex_state = 76, .external_lex_state = 5},
  [4046] = {.lex_state = 76, .external_lex_state = 5},
  [4047] = {.lex_state = 76, .external_lex_state = 5},
  [4048] = {.lex_state = 13, .external_lex_state = 8},
  [4049] = {.lex_state = 76, .external_lex_state = 5},
  [4050] = {.lex_state = 76, .external_lex_state = 2},
  [4051] = {.lex_state = 76, .external_lex_state = 5},
  [4052] = {.lex_state = 76, .external_lex_state = 5},
  [4053] = {.lex_state = 76, .external_lex_state = 2},
  [4054] = {.lex_state = 76, .external_lex_state = 2},
  [4055] = {.lex_state = 76, .external_lex_state = 5},
  [4056] = {.lex_state = 76, .external_lex_state = 5},
  [4057] = {.lex_state = 76, .external_lex_state = 2},
  [4058] = {.lex_state = 76, .external_lex_state = 5},
  [4059] = {.lex_state = 76, .external_lex_state = 5},
  [4060] = {.lex_state = 76, .external_lex_state = 5},
  [4061] = {.lex_state = 76, .external_lex_state = 5},
  [4062] = {.lex_state = 76, .external_lex_state = 5},
  [4063] = {.lex_state = 76, .external_lex_state = 5},
  [4064] = {.lex_state = 76, .external_lex_state = 5},
  [4065] = {.lex_state = 76, .external_lex_state = 5},
  [4066] = {.lex_state = 76, .external_lex_state = 5},
  [4067] = {.lex_state = 76, .external_lex_state = 5},
  [4068] = {.lex_state = 76, .external_lex_state = 5},
  [4069] = {.lex_state = 76, .external_lex_state = 5},
  [4070] = {.lex_state = 76, .external_lex_state = 5},
  [4071] = {.lex_state = 13, .external_lex_state = 8},
  [4072] = {.lex_state = 76, .external_lex_state = 5},
  [4073] = {.lex_state = 76, .external_lex_state = 5},
  [4074] = {.lex_state = 76, .external_lex_state = 5},
  [4075] = {.lex_state = 76, .external_lex_state = 2},
  [4076] = {.lex_state = 76, .external_lex_state = 5},
  [4077] = {.lex_state = 76, .external_lex_state = 5},
  [4078] = {.lex_state = 76, .external_lex_state = 5},
  [4079] = {.lex_state = 76, .external_lex_state = 5},
  [4080] = {.lex_state = 13, .external_lex_state = 8},
  [4081] = {.lex_state = 76, .external_lex_state = 5},
  [4082] = {.lex_state = 76, .external_lex_state = 5},
  [4083] = {.lex_state = 76, .external_lex_state = 5},
  [4084] = {.lex_state = 76, .external_lex_state = 5},
  [4085] = {.lex_state = 76, .external_lex_state = 5},
  [4086] = {.lex_state = 76, .external_lex_state = 5},
  [4087] = {.lex_state = 76, .external_lex_state = 5},
  [4088] = {.lex_state = 76, .external_lex_state = 5},
  [4089] = {.lex_state = 76, .external_lex_state = 5},
  [4090] = {.lex_state = 76, .external_lex_state = 5},
  [4091] = {.lex_state = 76, .external_lex_state = 5},
  [4092] = {.lex_state = 76, .external_lex_state = 5},
  [4093] = {.lex_state = 76, .external_lex_state = 5},
  [4094] = {.lex_state = 76, .external_lex_state = 2},
  [4095] = {.lex_state = 76, .external_lex_state = 5},
  [4096] = {.lex_state = 76, .external_lex_state = 5},
  [4097] = {.lex_state = 76, .external_lex_state = 5},
  [4098] = {.lex_state = 76, .external_lex_state = 5},
  [4099] = {.lex_state = 76, .external_lex_state = 5},
  [4100] = {.lex_state = 76, .external_lex_state = 5},
  [4101] = {.lex_state = 76, .external_lex_state = 5},
  [4102] = {.lex_state = 76, .external_lex_state = 5},
  [4103] = {.lex_state = 76, .external_lex_state = 5},
  [4104] = {.lex_state = 76, .external_lex_state = 5},
  [4105] = {.lex_state = 76, .external_lex_state = 2},
  [4106] = {.lex_state = 76, .external_lex_state = 2},
  [4107] = {.lex_state = 76, .external_lex_state = 5},
  [4108] = {.lex_state = 76, .external_lex_state = 5},
  [4109] = {.lex_state = 76, .external_lex_state = 2},
  [4110] = {.lex_state = 76, .external_lex_state = 5},
  [4111] = {.lex_state = 76, .external_lex_state = 5},
  [4112] = {.lex_state = 76, .external_lex_state = 2},
  [4113] = {.lex_state = 76, .external_lex_state = 2},
  [4114] = {.lex_state = 76, .external_lex_state = 2},
  [4115] = {.lex_state = 76, .external_lex_state = 5},
  [4116] = {.lex_state = 76, .external_lex_state = 5},
  [4117] = {.lex_state = 76, .external_lex_state = 2},
  [4118] = {.lex_state = 76, .external_lex_state = 5},
  [4119] = {.lex_state = 76, .external_lex_state = 2},
  [4120] = {.lex_state = 76, .external_lex_state = 5},
  [4121] = {.lex_state = 76, .external_lex_state = 2},
  [4122] = {.lex_state = 76, .external_lex_state = 5},
  [4123] = {.lex_state = 76, .external_lex_state = 5},
  [4124] = {.lex_state = 76, .external_lex_state = 2},
  [4125] = {.lex_state = 76, .external_lex_state = 5},
  [4126] = {.lex_state = 76, .external_lex_state = 5},
  [4127] = {.lex_state = 76, .external_lex_state = 5},
  [4128] = {.lex_state = 76, .external_lex_state = 5},
  [4129] = {.lex_state = 76, .external_lex_state = 5},
  [4130] = {.lex_state = 13, .external_lex_state = 8},
  [4131] = {.lex_state = 76, .external_lex_state = 2},
  [4132] = {.lex_state = 76, .external_lex_state = 5},
  [4133] = {.lex_state = 76, .external_lex_state = 5},
  [4134] = {.lex_state = 76, .external_lex_state = 5},
  [4135] = {.lex_state = 76, .external_lex_state = 5},
  [4136] = {.lex_state = 76, .external_lex_state = 5},
  [4137] = {.lex_state = 76, .external_lex_state = 2},
  [4138] = {.lex_state = 76, .external_lex_state = 2},
  [4139] = {.lex_state = 76, .external_lex_state = 5},
  [4140] = {.lex_state = 76, .external_lex_state = 5},
  [4141] = {.lex_state = 76, .external_lex_state = 2},
  [4142] = {.lex_state = 76, .external_lex_state = 2},
  [4143] = {.lex_state = 76, .external_lex_state = 6},
  [4144] = {.lex_state = 76, .external_lex_state = 5},
  [4145] = {.lex_state = 76, .external_lex_state = 5},
  [4146] = {.lex_state = 76, .external_lex_state = 6},
  [4147] = {.lex_state = 76, .external_lex_state = 5},
  [4148] = {.lex_state = 76, .external_lex_state = 2},
  [4149] = {.lex_state = 76, .external_lex_state = 2},
  [4150] = {.lex_state = 76, .external_lex_state = 5},
  [4151] = {.lex_state = 76, .external_lex_state = 2},
  [4152] = {.lex_state = 76, .external_lex_state = 5},
  [4153] = {.lex_state = 76, .external_lex_state = 5},
  [4154] = {.lex_state = 76, .external_lex_state = 5},
  [4155] = {.lex_state = 76, .external_lex_state = 5},
  [4156] = {.lex_state = 76, .external_lex_state = 5},
  [4157] = {.lex_state = 76, .external_lex_state = 5},
  [4158] = {.lex_state = 76, .external_lex_state = 2},
  [4159] = {.lex_state = 76, .external_lex_state = 2},
  [4160] = {.lex_state = 76, .external_lex_state = 2},
  [4161] = {.lex_state = 76, .external_lex_state = 5},
  [4162] = {.lex_state = 76, .external_lex_state = 5},
  [4163] = {.lex_state = 76, .external_lex_state = 5},
  [4164] = {.lex_state = 76, .external_lex_state = 2},
  [4165] = {.lex_state = 76, .external_lex_state = 2},
  [4166] = {.lex_state = 76, .external_lex_state = 5},
  [4167] = {.lex_state = 76, .external_lex_state = 2},
  [4168] = {.lex_state = 76, .external_lex_state = 2},
  [4169] = {.lex_state = 76, .external_lex_state = 5},
  [4170] = {.lex_state = 76, .external_lex_state = 5},
  [4171] = {.lex_state = 76, .external_lex_state = 2},
  [4172] = {.lex_state = 76, .external_lex_state = 5},
  [4173] = {.lex_state = 76, .external_lex_state = 2},
  [4174] = {.lex_state = 76, .external_lex_state = 5},
  [4175] = {.lex_state = 76, .external_lex_state = 5},
  [4176] = {.lex_state = 76, .external_lex_state = 2},
  [4177] = {.lex_state = 76, .external_lex_state = 2},
  [4178] = {.lex_state = 76, .external_lex_state = 5},
  [4179] = {.lex_state = 76, .external_lex_state = 2},
  [4180] = {.lex_state = 76, .external_lex_state = 5},
  [4181] = {.lex_state = 76, .external_lex_state = 2},
  [4182] = {.lex_state = 76, .external_lex_state = 6},
  [4183] = {.lex_state = 76, .external_lex_state = 5},
  [4184] = {.lex_state = 76, .external_lex_state = 2},
  [4185] = {.lex_state = 76, .external_lex_state = 5},
  [4186] = {.lex_state = 76, .external_lex_state = 5},
  [4187] = {.lex_state = 76, .external_lex_state = 5},
  [4188] = {.lex_state = 76, .external_lex_state = 5},
  [4189] = {.lex_state = 76, .external_lex_state = 6},
  [4190] = {.lex_state = 76, .external_lex_state = 2},
  [4191] = {.lex_state = 76, .external_lex_state = 6},
  [4192] = {.lex_state = 76, .external_lex_state = 5},
  [4193] = {.lex_state = 76, .external_lex_state = 6},
  [4194] = {.lex_state = 76, .external_lex_state = 2},
  [4195] = {.lex_state = 76, .external_lex_state = 5},
  [4196] = {.lex_state = 76, .external_lex_state = 5},
  [4197] = {.lex_state = 76, .external_lex_state = 2},
  [4198] = {.lex_state = 76, .external_lex_state = 2},
  [4199] = {.lex_state = 76, .external_lex_state = 2},
  [4200] = {.lex_state = 76, .external_lex_state = 5},
  [4201] = {.lex_state = 76, .external_lex_state = 5},
  [4202] = {.lex_state = 76, .external_lex_state = 5},
  [4203] = {.lex_state = 76, .external_lex_state = 5},
  [4204] = {.lex_state = 76, .external_lex_state = 2},
  [4205] = {.lex_state = 76, .external_lex_state = 5},
  [4206] = {.lex_state = 13, .external_lex_state = 8},
  [4207] = {.lex_state = 76, .external_lex_state = 5},
  [4208] = {.lex_state = 76, .external_lex_state = 5},
  [4209] = {.lex_state = 76, .external_lex_state = 5},
  [4210] = {.lex_state = 76, .external_lex_state = 5},
  [4211] = {.lex_state = 76, .external_lex_state = 5},
  [4212] = {.lex_state = 76, .external_lex_state = 5},
  [4213] = {.lex_state = 76, .external_lex_state = 5},
  [4214] = {.lex_state = 76, .external_lex_state = 5},
  [4215] = {.lex_state = 76, .external_lex_state = 5},
  [4216] = {.lex_state = 76, .external_lex_state = 5},
  [4217] = {.lex_state = 76, .external_lex_state = 5},
  [4218] = {.lex_state = 76, .external_lex_state = 5},
  [4219] = {.lex_state = 76, .external_lex_state = 5},
  [4220] = {.lex_state = 76, .external_lex_state = 2},
  [4221] = {.lex_state = 76, .external_lex_state = 5},
  [4222] = {.lex_state = 76, .external_lex_state = 5},
  [4223] = {.lex_state = 76, .external_lex_state = 5},
  [4224] = {.lex_state = 76, .external_lex_state = 5},
  [4225] = {.lex_state = 76, .external_lex_state = 5},
  [4226] = {.lex_state = 76, .external_lex_state = 2},
  [4227] = {.lex_state = 76, .external_lex_state = 2},
  [4228] = {.lex_state = 76, .external_lex_state = 5},
  [4229] = {.lex_state = 76, .external_lex_state = 2},
  [4230] = {.lex_state = 76, .external_lex_state = 5},
  [4231] = {.lex_state = 76, .external_lex_state = 2},
  [4232] = {.lex_state = 76, .external_lex_state = 2},
  [4233] = {.lex_state = 76, .external_lex_state = 5},
  [4234] = {.lex_state = 76, .external_lex_state = 2},
  [4235] = {.lex_state = 76, .external_lex_state = 2},
  [4236] = {.lex_state = 76, .external_lex_state = 2},
  [4237] = {.lex_state = 76, .external_lex_state = 5},
  [4238] = {.lex_state = 76, .external_lex_state = 5},
  [4239] = {.lex_state = 76, .external_lex_state = 2},
  [4240] = {.lex_state = 76, .external_lex_state = 5},
  [4241] = {.lex_state = 76, .external_lex_state = 5},
  [4242] = {.lex_state = 76, .external_lex_state = 5},
  [4243] = {.lex_state = 76, .external_lex_state = 5},
  [4244] = {.lex_state = 76, .external_lex_state = 5},
  [4245] = {.lex_state = 76, .external_lex_state = 5},
  [4246] = {.lex_state = 76, .external_lex_state = 5},
  [4247] = {.lex_state = 76, .external_lex_state = 2},
  [4248] = {.lex_state = 76, .external_lex_state = 5},
  [4249] = {.lex_state = 76, .external_lex_state = 5},
  [4250] = {.lex_state = 76, .external_lex_state = 5},
  [4251] = {.lex_state = 76, .external_lex_state = 5},
  [4252] = {.lex_state = 76, .external_lex_state = 2},
  [4253] = {.lex_state = 76, .external_lex_state = 5},
  [4254] = {.lex_state = 76, .external_lex_state = 5},
  [4255] = {.lex_state = 76, .external_lex_state = 2},
  [4256] = {.lex_state = 76, .external_lex_state = 5},
  [4257] = {.lex_state = 76, .external_lex_state = 5},
  [4258] = {.lex_state = 76, .external_lex_state = 5},
  [4259] = {.lex_state = 76, .external_lex_state = 2},
  [4260] = {.lex_state = 76, .external_lex_state = 5},
  [4261] = {.lex_state = 76, .external_lex_state = 5},
  [4262] = {.lex_state = 76, .external_lex_state = 5},
  [4263] = {.lex_state = 76, .external_lex_state = 5},
  [4264] = {.lex_state = 76, .external_lex_state = 5},
  [4265] = {.lex_state = 76, .external_lex_state = 5},
  [4266] = {.lex_state = 76, .external_lex_state = 5},
  [4267] = {.lex_state = 76, .external_lex_state = 5},
  [4268] = {.lex_state = 76, .external_lex_state = 5},
  [4269] = {.lex_state = 76, .external_lex_state = 5},
  [4270] = {.lex_state = 76, .external_lex_state = 5},
  [4271] = {.lex_state = 76, .external_lex_state = 2},
  [4272] = {.lex_state = 76, .external_lex_state = 2},
  [4273] = {.lex_state = 76, .external_lex_state = 5},
  [4274] = {.lex_state = 76, .external_lex_state = 5},
  [4275] = {.lex_state = 76, .external_lex_state = 5},
  [4276] = {.lex_state = 76, .external_lex_state = 2},
  [4277] = {.lex_state = 76, .external_lex_state = 5},
  [4278] = {.lex_state = 76, .external_lex_state = 5},
  [4279] = {.lex_state = 76, .external_lex_state = 5},
  [4280] = {.lex_state = 76, .external_lex_state = 5},
  [4281] = {.lex_state = 76, .external_lex_state = 5},
  [4282] = {.lex_state = 76, .external_lex_state = 5},
  [4283] = {.lex_state = 76, .external_lex_state = 5},
  [4284] = {.lex_state = 76, .external_lex_state = 2},
  [4285] = {.lex_state = 76, .external_lex_state = 5},
  [4286] = {.lex_state = 76, .external_lex_state = 5},
  [4287] = {.lex_state = 76, .external_lex_state = 5},
  [4288] = {.lex_state = 76, .external_lex_state = 5},
  [4289] = {.lex_state = 76, .external_lex_state = 5},
  [4290] = {.lex_state = 76, .external_lex_state = 5},
  [4291] = {.lex_state = 76, .external_lex_state = 5},
  [4292] = {.lex_state = 76, .external_lex_state = 5},
  [4293] = {.lex_state = 76, .external_lex_state = 5},
  [4294] = {.lex_state = 76, .external_lex_state = 5},
  [4295] = {.lex_state = 76, .external_lex_state = 5},
  [4296] = {.lex_state = 76, .external_lex_state = 5},
  [4297] = {.lex_state = 76, .external_lex_state = 5},
  [4298] = {.lex_state = 76, .external_lex_state = 5},
  [4299] = {.lex_state = 76, .external_lex_state = 5},
  [4300] = {.lex_state = 76, .external_lex_state = 5},
  [4301] = {.lex_state = 76, .external_lex_state = 5},
  [4302] = {.lex_state = 76, .external_lex_state = 5},
  [4303] = {.lex_state = 76, .external_lex_state = 5},
  [4304] = {.lex_state = 76, .external_lex_state = 5},
  [4305] = {.lex_state = 76, .external_lex_state = 5},
  [4306] = {.lex_state = 76, .external_lex_state = 5},
  [4307] = {.lex_state = 76, .external_lex_state = 2},
  [4308] = {.lex_state = 76, .external_lex_state = 5},
  [4309] = {.lex_state = 76, .external_lex_state = 5},
  [4310] = {.lex_state = 76, .external_lex_state = 5},
  [4311] = {.lex_state = 76, .external_lex_state = 2},
  [4312] = {.lex_state = 76, .external_lex_state = 5},
  [4313] = {.lex_state = 76, .external_lex_state = 2},
  [4314] = {.lex_state = 76, .external_lex_state = 5},
  [4315] = {.lex_state = 8, .external_lex_state = 2},
  [4316] = {.lex_state = 76, .external_lex_state = 5},
  [4317] = {.lex_state = 76, .external_lex_state = 2},
  [4318] = {.lex_state = 76, .external_lex_state = 2},
  [4319] = {.lex_state = 76, .external_lex_state = 2},
  [4320] = {.lex_state = 76, .external_lex_state = 5},
  [4321] = {.lex_state = 76, .external_lex_state = 5},
  [4322] = {.lex_state = 76, .external_lex_state = 5},
  [4323] = {.lex_state = 76, .external_lex_state = 5},
  [4324] = {.lex_state = 76, .external_lex_state = 2},
  [4325] = {.lex_state = 76, .external_lex_state = 2},
  [4326] = {.lex_state = 76, .external_lex_state = 5},
  [4327] = {.lex_state = 76, .external_lex_state = 5},
  [4328] = {.lex_state = 76, .external_lex_state = 5},
  [4329] = {.lex_state = 76, .external_lex_state = 5},
  [4330] = {.lex_state = 76, .external_lex_state = 5},
  [4331] = {.lex_state = 76, .external_lex_state = 2},
  [4332] = {.lex_state = 76, .external_lex_state = 5},
  [4333] = {.lex_state = 76, .external_lex_state = 2},
  [4334] = {.lex_state = 76, .external_lex_state = 2},
  [4335] = {.lex_state = 76, .external_lex_state = 5},
  [4336] = {.lex_state = 76, .external_lex_state = 2},
  [4337] = {.lex_state = 76, .external_lex_state = 5},
  [4338] = {.lex_state = 76, .external_lex_state = 2},
  [4339] = {.lex_state = 76, .external_lex_state = 2},
  [4340] = {.lex_state = 76, .external_lex_state = 5},
  [4341] = {.lex_state = 76, .external_lex_state = 2},
  [4342] = {.lex_state = 76, .external_lex_state = 5},
  [4343] = {.lex_state = 76, .external_lex_state = 5},
  [4344] = {.lex_state = 76, .external_lex_state = 2},
  [4345] = {.lex_state = 76, .external_lex_state = 5},
  [4346] = {.lex_state = 76, .external_lex_state = 5},
  [4347] = {.lex_state = 76, .external_lex_state = 5},
  [4348] = {.lex_state = 76, .external_lex_state = 5},
  [4349] = {.lex_state = 76, .external_lex_state = 5},
  [4350] = {.lex_state = 76, .external_lex_state = 5},
  [4351] = {.lex_state = 76, .external_lex_state = 5},
  [4352] = {.lex_state = 76, .external_lex_state = 5},
  [4353] = {.lex_state = 7, .external_lex_state = 2},
  [4354] = {.lex_state = 76, .external_lex_state = 5},
  [4355] = {.lex_state = 76, .external_lex_state = 5},
  [4356] = {.lex_state = 76, .external_lex_state = 5},
  [4357] = {.lex_state = 76, .external_lex_state = 5},
  [4358] = {.lex_state = 76, .external_lex_state = 2},
  [4359] = {.lex_state = 76, .external_lex_state = 5},
  [4360] = {.lex_state = 76, .external_lex_state = 2},
  [4361] = {.lex_state = 76, .external_lex_state = 2},
  [4362] = {.lex_state = 76, .external_lex_state = 5},
  [4363] = {.lex_state = 76, .external_lex_state = 5},
  [4364] = {.lex_state = 76, .external_lex_state = 5},
  [4365] = {.lex_state = 76, .external_lex_state = 5},
  [4366] = {.lex_state = 76, .external_lex_state = 5},
  [4367] = {.lex_state = 76, .external_lex_state = 5},
  [4368] = {.lex_state = 76, .external_lex_state = 5},
  [4369] = {.lex_state = 76, .external_lex_state = 5},
  [4370] = {.lex_state = 76, .external_lex_state = 5},
  [4371] = {.lex_state = 76, .external_lex_state = 2},
  [4372] = {.lex_state = 76, .external_lex_state = 5},
  [4373] = {.lex_state = 13, .external_lex_state = 8},
  [4374] = {.lex_state = 76, .external_lex_state = 2},
  [4375] = {.lex_state = 76, .external_lex_state = 5},
  [4376] = {.lex_state = 76, .external_lex_state = 5},
  [4377] = {.lex_state = 76, .external_lex_state = 5},
  [4378] = {.lex_state = 76, .external_lex_state = 2},
  [4379] = {.lex_state = 76, .external_lex_state = 5},
  [4380] = {.lex_state = 76, .external_lex_state = 5},
  [4381] = {.lex_state = 76, .external_lex_state = 2},
  [4382] = {.lex_state = 76, .external_lex_state = 5},
  [4383] = {.lex_state = 76, .external_lex_state = 5},
  [4384] = {.lex_state = 76, .external_lex_state = 5},
  [4385] = {.lex_state = 76, .external_lex_state = 2},
  [4386] = {.lex_state = 76, .external_lex_state = 5},
  [4387] = {.lex_state = 7, .external_lex_state = 2},
  [4388] = {.lex_state = 76, .external_lex_state = 5},
  [4389] = {.lex_state = 76, .external_lex_state = 2},
  [4390] = {.lex_state = 76, .external_lex_state = 2},
  [4391] = {.lex_state = 16, .external_lex_state = 9},
  [4392] = {.lex_state = 16, .external_lex_state = 9},
  [4393] = {.lex_state = 76, .external_lex_state = 2},
  [4394] = {.lex_state = 76, .external_lex_state = 5},
  [4395] = {.lex_state = 76, .external_lex_state = 2},
  [4396] = {.lex_state = 12, .external_lex_state = 9},
  [4397] = {.lex_state = 16, .external_lex_state = 9},
  [4398] = {.lex_state = 12, .external_lex_state = 9},
  [4399] = {.lex_state = 12, .external_lex_state = 9},
  [4400] = {.lex_state = 16, .external_lex_state = 9},
  [4401] = {.lex_state = 76, .external_lex_state = 2},
  [4402] = {.lex_state = 16, .external_lex_state = 9},
  [4403] = {.lex_state = 76, .external_lex_state = 2},
  [4404] = {.lex_state = 76, .external_lex_state = 2},
  [4405] = {.lex_state = 76, .external_lex_state = 2},
  [4406] = {.lex_state = 12, .external_lex_state = 9},
  [4407] = {.lex_state = 76, .external_lex_state = 5},
  [4408] = {.lex_state = 76, .external_lex_state = 2},
  [4409] = {.lex_state = 2, .external_lex_state = 2},
  [4410] = {.lex_state = 76, .external_lex_state = 2},
  [4411] = {.lex_state = 76, .external_lex_state = 2},
  [4412] = {.lex_state = 12, .external_lex_state = 9},
  [4413] = {.lex_state = 13, .external_lex_state = 7},
  [4414] = {.lex_state = 2, .external_lex_state = 2},
  [4415] = {.lex_state = 2, .external_lex_state = 2},
  [4416] = {.lex_state = 16, .external_lex_state = 9},
  [4417] = {.lex_state = 16, .external_lex_state = 9},
  [4418] = {.lex_state = 76, .external_lex_state = 2},
  [4419] = {.lex_state = 2, .external_lex_state = 2},
  [4420] = {.lex_state = 76, .external_lex_state = 2},
  [4421] = {.lex_state = 13, .external_lex_state = 7},
  [4422] = {.lex_state = 76, .external_lex_state = 2},
  [4423] = {.lex_state = 12, .external_lex_state = 9},
  [4424] = {.lex_state = 76, .external_lex_state = 2},
  [4425] = {.lex_state = 16, .external_lex_state = 9},
  [4426] = {.lex_state = 76, .external_lex_state = 2},
  [4427] = {.lex_state = 76, .external_lex_state = 2},
  [4428] = {.lex_state = 12, .external_lex_state = 9},
  [4429] = {.lex_state = 12, .external_lex_state = 9},
  [4430] = {.lex_state = 16, .external_lex_state = 9},
  [4431] = {.lex_state = 76, .external_lex_state = 2},
  [4432] = {.lex_state = 76, .external_lex_state = 2},
  [4433] = {.lex_state = 76, .external_lex_state = 5},
  [4434] = {.lex_state = 76, .external_lex_state = 5},
  [4435] = {.lex_state = 76, .external_lex_state = 2},
  [4436] = {.lex_state = 76, .external_lex_state = 2},
  [4437] = {.lex_state = 76, .external_lex_state = 5},
  [4438] = {.lex_state = 12, .external_lex_state = 9},
  [4439] = {.lex_state = 16, .external_lex_state = 9},
  [4440] = {.lex_state = 76, .external_lex_state = 2},
  [4441] = {.lex_state = 76, .external_lex_state = 5},
  [4442] = {.lex_state = 76, .external_lex_state = 6},
  [4443] = {.lex_state = 76, .external_lex_state = 2},
  [4444] = {.lex_state = 76, .external_lex_state = 2},
  [4445] = {.lex_state = 76, .external_lex_state = 2},
  [4446] = {.lex_state = 76, .external_lex_state = 2},
  [4447] = {.lex_state = 76, .external_lex_state = 2},
  [4448] = {.lex_state = 76, .external_lex_state = 2},
  [4449] = {.lex_state = 76, .external_lex_state = 2},
  [4450] = {.lex_state = 76, .external_lex_state = 5},
  [4451] = {.lex_state = 76, .external_lex_state = 5},
  [4452] = {.lex_state = 76, .external_lex_state = 5},
  [4453] = {.lex_state = 76, .external_lex_state = 2},
  [4454] = {.lex_state = 76, .external_lex_state = 2},
  [4455] = {.lex_state = 16, .external_lex_state = 9},
  [4456] = {.lex_state = 76, .external_lex_state = 2},
  [4457] = {.lex_state = 76, .external_lex_state = 2},
  [4458] = {.lex_state = 76, .external_lex_state = 2},
  [4459] = {.lex_state = 12, .external_lex_state = 9},
  [4460] = {.lex_state = 12, .external_lex_state = 9},
  [4461] = {.lex_state = 76, .external_lex_state = 5},
  [4462] = {.lex_state = 76, .external_lex_state = 5},
  [4463] = {.lex_state = 7, .external_lex_state = 2},
  [4464] = {.lex_state = 76, .external_lex_state = 2},
  [4465] = {.lex_state = 76, .external_lex_state = 2},
  [4466] = {.lex_state = 76, .external_lex_state = 2},
  [4467] = {.lex_state = 76, .external_lex_state = 2},
  [4468] = {.lex_state = 76, .external_lex_state = 5},
  [4469] = {.lex_state = 76, .external_lex_state = 2},
  [4470] = {.lex_state = 76, .external_lex_state = 2},
  [4471] = {.lex_state = 76, .external_lex_state = 2},
  [4472] = {.lex_state = 76, .external_lex_state = 2},
  [4473] = {.lex_state = 76, .external_lex_state = 2},
  [4474] = {.lex_state = 76, .external_lex_state = 2},
  [4475] = {.lex_state = 76, .external_lex_state = 5},
  [4476] = {.lex_state = 76, .external_lex_state = 2},
  [4477] = {.lex_state = 76, .external_lex_state = 5},
  [4478] = {.lex_state = 7, .external_lex_state = 2},
  [4479] = {.lex_state = 76, .external_lex_state = 2},
  [4480] = {.lex_state = 76, .external_lex_state = 2},
  [4481] = {.lex_state = 76, .external_lex_state = 2},
  [4482] = {.lex_state = 76, .external_lex_state = 5},
  [4483] = {.lex_state = 76, .external_lex_state = 2},
  [4484] = {.lex_state = 76, .external_lex_state = 2},
  [4485] = {.lex_state = 76, .external_lex_state = 2},
  [4486] = {.lex_state = 16, .external_lex_state = 9},
  [4487] = {.lex_state = 76, .external_lex_state = 2},
  [4488] = {.lex_state = 76, .external_lex_state = 2},
  [4489] = {.lex_state = 76, .external_lex_state = 2},
  [4490] = {.lex_state = 76, .external_lex_state = 2},
  [4491] = {.lex_state = 76, .external_lex_state = 2},
  [4492] = {.lex_state = 76, .external_lex_state = 2},
  [4493] = {.lex_state = 76, .external_lex_state = 2},
  [4494] = {.lex_state = 76, .external_lex_state = 2},
  [4495] = {.lex_state = 76, .external_lex_state = 2},
  [4496] = {.lex_state = 76, .external_lex_state = 2},
  [4497] = {.lex_state = 76, .external_lex_state = 2},
  [4498] = {.lex_state = 76, .external_lex_state = 2},
  [4499] = {.lex_state = 76, .external_lex_state = 2},
  [4500] = {.lex_state = 76, .external_lex_state = 2},
  [4501] = {.lex_state = 76, .external_lex_state = 2},
  [4502] = {.lex_state = 2, .external_lex_state = 2},
  [4503] = {.lex_state = 76, .external_lex_state = 2},
  [4504] = {.lex_state = 76, .external_lex_state = 2},
  [4505] = {.lex_state = 76, .external_lex_state = 2},
  [4506] = {.lex_state = 76, .external_lex_state = 2},
  [4507] = {.lex_state = 76, .external_lex_state = 2},
  [4508] = {.lex_state = 76, .external_lex_state = 2},
  [4509] = {.lex_state = 76, .external_lex_state = 2},
  [4510] = {.lex_state = 76, .external_lex_state = 5},
  [4511] = {.lex_state = 12, .external_lex_state = 9},
  [4512] = {.lex_state = 12, .external_lex_state = 9},
  [4513] = {.lex_state = 16, .external_lex_state = 9},
  [4514] = {.lex_state = 12, .external_lex_state = 9},
  [4515] = {.lex_state = 16, .external_lex_state = 9},
  [4516] = {.lex_state = 76, .external_lex_state = 2},
  [4517] = {.lex_state = 76, .external_lex_state = 2},
  [4518] = {.lex_state = 16, .external_lex_state = 9},
  [4519] = {.lex_state = 76, .external_lex_state = 2},
  [4520] = {.lex_state = 76, .external_lex_state = 2},
  [4521] = {.lex_state = 76, .external_lex_state = 2},
  [4522] = {.lex_state = 76, .external_lex_state = 5},
  [4523] = {.lex_state = 12, .external_lex_state = 9},
  [4524] = {.lex_state = 76, .external_lex_state = 2},
  [4525] = {.lex_state = 76, .external_lex_state = 2},
  [4526] = {.lex_state = 76, .external_lex_state = 5},
  [4527] = {.lex_state = 76, .external_lex_state = 5},
  [4528] = {.lex_state = 76, .external_lex_state = 5},
  [4529] = {.lex_state = 76, .external_lex_state = 5},
  [4530] = {.lex_state = 76, .external_lex_state = 5},
  [4531] = {.lex_state = 2, .external_lex_state = 2},
  [4532] = {.lex_state = 76, .external_lex_state = 5},
  [4533] = {.lex_state = 76, .external_lex_state = 5},
  [4534] = {.lex_state = 76, .external_lex_state = 5},
  [4535] = {.lex_state = 76, .external_lex_state = 5},
  [4536] = {.lex_state = 76, .external_lex_state = 5},
  [4537] = {.lex_state = 76, .external_lex_state = 2},
  [4538] = {.lex_state = 76, .external_lex_state = 2},
  [4539] = {.lex_state = 76, .external_lex_state = 2},
  [4540] = {.lex_state = 76, .external_lex_state = 5},
  [4541] = {.lex_state = 76, .external_lex_state = 5},
  [4542] = {.lex_state = 76, .external_lex_state = 2},
  [4543] = {.lex_state = 76, .external_lex_state = 5},
  [4544] = {.lex_state = 76, .external_lex_state = 5},
  [4545] = {.lex_state = 76, .external_lex_state = 5},
  [4546] = {.lex_state = 76, .external_lex_state = 5},
  [4547] = {.lex_state = 2, .external_lex_state = 2},
  [4548] = {.lex_state = 76, .external_lex_state = 5},
  [4549] = {.lex_state = 76, .external_lex_state = 5},
  [4550] = {.lex_state = 76, .external_lex_state = 5},
  [4551] = {.lex_state = 76, .external_lex_state = 2},
  [4552] = {.lex_state = 76, .external_lex_state = 5},
  [4553] = {.lex_state = 76, .external_lex_state = 2},
  [4554] = {.lex_state = 76, .external_lex_state = 2},
  [4555] = {.lex_state = 76, .external_lex_state = 5},
  [4556] = {.lex_state = 76, .external_lex_state = 2},
  [4557] = {.lex_state = 76, .external_lex_state = 2},
  [4558] = {.lex_state = 76, .external_lex_state = 2},
  [4559] = {.lex_state = 76, .external_lex_state = 2},
  [4560] = {.lex_state = 76, .external_lex_state = 2},
  [4561] = {.lex_state = 76, .external_lex_state = 5},
  [4562] = {.lex_state = 76, .external_lex_state = 5},
  [4563] = {.lex_state = 76, .external_lex_state = 5},
  [4564] = {.lex_state = 76, .external_lex_state = 2},
  [4565] = {.lex_state = 76, .external_lex_state = 2},
  [4566] = {.lex_state = 76, .external_lex_state = 2},
  [4567] = {.lex_state = 76, .external_lex_state = 2},
  [4568] = {.lex_state = 76, .external_lex_state = 2},
  [4569] = {.lex_state = 76, .external_lex_state = 2},
  [4570] = {.lex_state = 76, .external_lex_state = 2},
  [4571] = {.lex_state = 76, .external_lex_state = 2},
  [4572] = {.lex_state = 76, .external_lex_state = 5},
  [4573] = {.lex_state = 76, .external_lex_state = 5},
  [4574] = {.lex_state = 76, .external_lex_state = 2},
  [4575] = {.lex_state = 76, .external_lex_state = 2},
  [4576] = {.lex_state = 76, .external_lex_state = 2},
  [4577] = {.lex_state = 76, .external_lex_state = 2},
  [4578] = {.lex_state = 76, .external_lex_state = 5},
  [4579] = {.lex_state = 76, .external_lex_state = 5},
  [4580] = {.lex_state = 76, .external_lex_state = 5},
  [4581] = {.lex_state = 76, .external_lex_state = 5},
  [4582] = {.lex_state = 76, .external_lex_state = 5},
  [4583] = {.lex_state = 76, .external_lex_state = 5},
  [4584] = {.lex_state = 76, .external_lex_state = 5},
  [4585] = {.lex_state = 76, .external_lex_state = 5},
  [4586] = {.lex_state = 76, .external_lex_state = 5},
  [4587] = {.lex_state = 76, .external_lex_state = 5},
  [4588] = {.lex_state = 76, .external_lex_state = 2},
  [4589] = {.lex_state = 76, .external_lex_state = 5},
  [4590] = {.lex_state = 76, .external_lex_state = 5},
  [4591] = {.lex_state = 76, .external_lex_state = 5},
  [4592] = {.lex_state = 76, .external_lex_state = 5},
  [4593] = {.lex_state = 76, .external_lex_state = 5},
  [4594] = {.lex_state = 76, .external_lex_state = 5},
  [4595] = {.lex_state = 76, .external_lex_state = 5},
  [4596] = {.lex_state = 76, .external_lex_state = 2},
  [4597] = {.lex_state = 76, .external_lex_state = 5},
  [4598] = {.lex_state = 76, .external_lex_state = 5},
  [4599] = {.lex_state = 76, .external_lex_state = 5},
  [4600] = {.lex_state = 76, .external_lex_state = 5},
  [4601] = {.lex_state = 76, .external_lex_state = 5},
  [4602] = {.lex_state = 76, .external_lex_state = 2},
  [4603] = {.lex_state = 76, .external_lex_state = 5},
  [4604] = {.lex_state = 76, .external_lex_state = 2},
  [4605] = {.lex_state = 76, .external_lex_state = 2},
  [4606] = {.lex_state = 76, .external_lex_state = 5},
  [4607] = {.lex_state = 76, .external_lex_state = 2},
  [4608] = {.lex_state = 76, .external_lex_state = 5},
  [4609] = {.lex_state = 76, .external_lex_state = 5},
  [4610] = {.lex_state = 76, .external_lex_state = 2},
  [4611] = {.lex_state = 76, .external_lex_state = 2},
  [4612] = {.lex_state = 76, .external_lex_state = 2},
  [4613] = {.lex_state = 76, .external_lex_state = 2},
  [4614] = {.lex_state = 76, .external_lex_state = 2},
  [4615] = {.lex_state = 2, .external_lex_state = 2},
  [4616] = {.lex_state = 76, .external_lex_state = 5},
  [4617] = {.lex_state = 76, .external_lex_state = 2},
  [4618] = {.lex_state = 76, .external_lex_state = 2},
  [4619] = {.lex_state = 76, .external_lex_state = 2},
  [4620] = {.lex_state = 76, .external_lex_state = 2},
  [4621] = {.lex_state = 76, .external_lex_state = 2},
  [4622] = {.lex_state = 76, .external_lex_state = 2},
  [4623] = {.lex_state = 76, .external_lex_state = 2},
  [4624] = {.lex_state = 76, .external_lex_state = 2},
  [4625] = {.lex_state = 76, .external_lex_state = 2},
  [4626] = {.lex_state = 76, .external_lex_state = 5},
  [4627] = {.lex_state = 76, .external_lex_state = 5},
  [4628] = {.lex_state = 76, .external_lex_state = 5},
  [4629] = {.lex_state = 76, .external_lex_state = 5},
  [4630] = {.lex_state = 76, .external_lex_state = 5},
  [4631] = {.lex_state = 76, .external_lex_state = 5},
  [4632] = {.lex_state = 76, .external_lex_state = 5},
  [4633] = {.lex_state = 76, .external_lex_state = 5},
  [4634] = {.lex_state = 76, .external_lex_state = 2},
  [4635] = {.lex_state = 76, .external_lex_state = 5},
  [4636] = {.lex_state = 76, .external_lex_state = 2},
  [4637] = {.lex_state = 2, .external_lex_state = 2},
  [4638] = {.lex_state = 76, .external_lex_state = 5},
  [4639] = {.lex_state = 76, .external_lex_state = 5},
  [4640] = {.lex_state = 76, .external_lex_state = 5},
  [4641] = {.lex_state = 76, .external_lex_state = 5},
  [4642] = {.lex_state = 76, .external_lex_state = 5},
  [4643] = {.lex_state = 76, .external_lex_state = 5},
  [4644] = {.lex_state = 76, .external_lex_state = 5},
  [4645] = {.lex_state = 76, .external_lex_state = 5},
  [4646] = {.lex_state = 76, .external_lex_state = 2},
  [4647] = {.lex_state = 76, .external_lex_state = 2},
  [4648] = {.lex_state = 76, .external_lex_state = 5},
  [4649] = {.lex_state = 76, .external_lex_state = 5},
  [4650] = {.lex_state = 76, .external_lex_state = 5},
  [4651] = {.lex_state = 76, .external_lex_state = 5},
  [4652] = {.lex_state = 76, .external_lex_state = 5},
  [4653] = {.lex_state = 76, .external_lex_state = 5},
  [4654] = {.lex_state = 76, .external_lex_state = 2},
  [4655] = {.lex_state = 76, .external_lex_state = 5},
  [4656] = {.lex_state = 76, .external_lex_state = 2},
  [4657] = {.lex_state = 76, .external_lex_state = 2},
  [4658] = {.lex_state = 76, .external_lex_state = 5},
  [4659] = {.lex_state = 13, .external_lex_state = 10},
  [4660] = {.lex_state = 76, .external_lex_state = 5},
  [4661] = {.lex_state = 76, .external_lex_state = 2},
  [4662] = {.lex_state = 76, .external_lex_state = 5},
  [4663] = {.lex_state = 76, .external_lex_state = 5},
  [4664] = {.lex_state = 76, .external_lex_state = 5},
  [4665] = {.lex_state = 76, .external_lex_state = 2},
  [4666] = {.lex_state = 76, .external_lex_state = 2},
  [4667] = {.lex_state = 76, .external_lex_state = 2},
  [4668] = {.lex_state = 76, .external_lex_state = 5},
  [4669] = {.lex_state = 76, .external_lex_state = 5},
  [4670] = {.lex_state = 76, .external_lex_state = 5},
  [4671] = {.lex_state = 76, .external_lex_state = 5},
  [4672] = {.lex_state = 76, .external_lex_state = 2},
  [4673] = {.lex_state = 76, .external_lex_state = 2},
  [4674] = {.lex_state = 76, .external_lex_state = 2},
  [4675] = {.lex_state = 76, .external_lex_state = 2},
  [4676] = {.lex_state = 76, .external_lex_state = 5},
  [4677] = {.lex_state = 76, .external_lex_state = 5},
  [4678] = {.lex_state = 76, .external_lex_state = 2},
  [4679] = {.lex_state = 76, .external_lex_state = 5},
  [4680] = {.lex_state = 76, .external_lex_state = 2},
  [4681] = {.lex_state = 76, .external_lex_state = 5},
  [4682] = {.lex_state = 76, .external_lex_state = 5},
  [4683] = {.lex_state = 76, .external_lex_state = 2},
  [4684] = {.lex_state = 76, .external_lex_state = 5},
  [4685] = {.lex_state = 76, .external_lex_state = 5},
  [4686] = {.lex_state = 76, .external_lex_state = 5},
  [4687] = {.lex_state = 76, .external_lex_state = 5},
  [4688] = {.lex_state = 76, .external_lex_state = 5},
  [4689] = {.lex_state = 76, .external_lex_state = 5},
  [4690] = {.lex_state = 76, .external_lex_state = 5},
  [4691] = {.lex_state = 76, .external_lex_state = 5},
  [4692] = {.lex_state = 76, .external_lex_state = 2},
  [4693] = {.lex_state = 76, .external_lex_state = 2},
  [4694] = {.lex_state = 76, .external_lex_state = 5},
  [4695] = {.lex_state = 13, .external_lex_state = 10},
  [4696] = {.lex_state = 76, .external_lex_state = 5},
  [4697] = {.lex_state = 76, .external_lex_state = 2},
  [4698] = {.lex_state = 76, .external_lex_state = 2},
  [4699] = {.lex_state = 76, .external_lex_state = 5},
  [4700] = {.lex_state = 76, .external_lex_state = 2},
  [4701] = {.lex_state = 76, .external_lex_state = 2},
  [4702] = {.lex_state = 76, .external_lex_state = 2},
  [4703] = {.lex_state = 76, .external_lex_state = 2},
  [4704] = {.lex_state = 76, .external_lex_state = 5},
  [4705] = {.lex_state = 76, .external_lex_state = 5},
  [4706] = {.lex_state = 76, .external_lex_state = 5},
  [4707] = {.lex_state = 76, .external_lex_state = 5},
  [4708] = {.lex_state = 76, .external_lex_state = 5},
  [4709] = {.lex_state = 76, .external_lex_state = 5},
  [4710] = {.lex_state = 76, .external_lex_state = 5},
  [4711] = {.lex_state = 76, .external_lex_state = 5},
  [4712] = {.lex_state = 76, .external_lex_state = 5},
  [4713] = {.lex_state = 76, .external_lex_state = 5},
  [4714] = {.lex_state = 76, .external_lex_state = 2},
  [4715] = {.lex_state = 76, .external_lex_state = 5},
  [4716] = {.lex_state = 76, .external_lex_state = 2},
  [4717] = {.lex_state = 76, .external_lex_state = 2},
  [4718] = {.lex_state = 76, .external_lex_state = 5},
  [4719] = {.lex_state = 76, .external_lex_state = 2},
  [4720] = {.lex_state = 2, .external_lex_state = 2},
  [4721] = {.lex_state = 76, .external_lex_state = 2},
  [4722] = {.lex_state = 76, .external_lex_state = 5},
  [4723] = {.lex_state = 2, .external_lex_state = 2},
  [4724] = {.lex_state = 76, .external_lex_state = 5},
  [4725] = {.lex_state = 76, .external_lex_state = 5},
  [4726] = {.lex_state = 76, .external_lex_state = 5},
  [4727] = {.lex_state = 76, .external_lex_state = 2},
  [4728] = {.lex_state = 76, .external_lex_state = 2},
  [4729] = {.lex_state = 76, .external_lex_state = 5},
  [4730] = {.lex_state = 76, .external_lex_state = 5},
  [4731] = {.lex_state = 76, .external_lex_state = 5},
  [4732] = {.lex_state = 76, .external_lex_state = 2},
  [4733] = {.lex_state = 76, .external_lex_state = 5},
  [4734] = {.lex_state = 76, .external_lex_state = 5},
  [4735] = {.lex_state = 76, .external_lex_state = 5},
  [4736] = {.lex_state = 76, .external_lex_state = 5},
  [4737] = {.lex_state = 76, .external_lex_state = 5},
  [4738] = {.lex_state = 76, .external_lex_state = 2},
  [4739] = {.lex_state = 76, .external_lex_state = 5},
  [4740] = {.lex_state = 76, .external_lex_state = 5},
  [4741] = {.lex_state = 76, .external_lex_state = 5},
  [4742] = {.lex_state = 76, .external_lex_state = 5},
  [4743] = {.lex_state = 76, .external_lex_state = 2},
  [4744] = {.lex_state = 76, .external_lex_state = 2},
  [4745] = {.lex_state = 76, .external_lex_state = 5},
  [4746] = {.lex_state = 76, .external_lex_state = 2},
  [4747] = {.lex_state = 13, .external_lex_state = 8},
  [4748] = {.lex_state = 76, .external_lex_state = 2},
  [4749] = {.lex_state = 76, .external_lex_state = 5},
  [4750] = {.lex_state = 76, .external_lex_state = 5},
  [4751] = {.lex_state = 76, .external_lex_state = 5},
  [4752] = {.lex_state = 76, .external_lex_state = 5},
  [4753] = {.lex_state = 76, .external_lex_state = 5},
  [4754] = {.lex_state = 76, .external_lex_state = 2},
  [4755] = {.lex_state = 76, .external_lex_state = 5},
  [4756] = {.lex_state = 76, .external_lex_state = 5},
  [4757] = {.lex_state = 76, .external_lex_state = 5},
  [4758] = {.lex_state = 76, .external_lex_state = 5},
  [4759] = {.lex_state = 76, .external_lex_state = 2},
  [4760] = {.lex_state = 76, .external_lex_state = 5},
  [4761] = {.lex_state = 76, .external_lex_state = 5},
  [4762] = {.lex_state = 76, .external_lex_state = 5},
  [4763] = {.lex_state = 76, .external_lex_state = 5},
  [4764] = {.lex_state = 76, .external_lex_state = 5},
  [4765] = {.lex_state = 76, .external_lex_state = 5},
  [4766] = {.lex_state = 76, .external_lex_state = 5},
  [4767] = {.lex_state = 76, .external_lex_state = 2},
  [4768] = {.lex_state = 76, .external_lex_state = 2},
  [4769] = {.lex_state = 76, .external_lex_state = 5},
  [4770] = {.lex_state = 76, .external_lex_state = 5},
  [4771] = {.lex_state = 76, .external_lex_state = 2},
  [4772] = {.lex_state = 76, .external_lex_state = 5},
  [4773] = {.lex_state = 76, .external_lex_state = 2},
  [4774] = {.lex_state = 76, .external_lex_state = 2},
  [4775] = {.lex_state = 76, .external_lex_state = 5},
  [4776] = {.lex_state = 76, .external_lex_state = 5},
  [4777] = {.lex_state = 76, .external_lex_state = 5},
  [4778] = {.lex_state = 76, .external_lex_state = 5},
  [4779] = {.lex_state = 76, .external_lex_state = 2},
  [4780] = {.lex_state = 76, .external_lex_state = 5},
  [4781] = {.lex_state = 76, .external_lex_state = 5},
  [4782] = {.lex_state = 76, .external_lex_state = 2},
  [4783] = {.lex_state = 76, .external_lex_state = 5},
  [4784] = {.lex_state = 76, .external_lex_state = 5},
  [4785] = {.lex_state = 76, .external_lex_state = 5},
  [4786] = {.lex_state = 76, .external_lex_state = 5},
  [4787] = {.lex_state = 76, .external_lex_state = 5},
  [4788] = {.lex_state = 76, .external_lex_state = 5},
  [4789] = {.lex_state = 76, .external_lex_state = 5},
  [4790] = {.lex_state = 76, .external_lex_state = 5},
  [4791] = {.lex_state = 76, .external_lex_state = 5},
  [4792] = {.lex_state = 76, .external_lex_state = 5},
  [4793] = {.lex_state = 76, .external_lex_state = 5},
  [4794] = {.lex_state = 76, .external_lex_state = 5},
  [4795] = {.lex_state = 76, .external_lex_state = 5},
  [4796] = {.lex_state = 76, .external_lex_state = 5},
  [4797] = {.lex_state = 76, .external_lex_state = 5},
  [4798] = {.lex_state = 76, .external_lex_state = 5},
  [4799] = {.lex_state = 76, .external_lex_state = 5},
  [4800] = {.lex_state = 76, .external_lex_state = 5},
  [4801] = {.lex_state = 76, .external_lex_state = 5},
  [4802] = {.lex_state = 76, .external_lex_state = 5},
  [4803] = {.lex_state = 76, .external_lex_state = 5},
  [4804] = {.lex_state = 76, .external_lex_state = 5},
  [4805] = {.lex_state = 76, .external_lex_state = 5},
  [4806] = {.lex_state = 76, .external_lex_state = 5},
  [4807] = {.lex_state = 76, .external_lex_state = 5},
  [4808] = {.lex_state = 76, .external_lex_state = 5},
  [4809] = {.lex_state = 76, .external_lex_state = 5},
  [4810] = {.lex_state = 76, .external_lex_state = 5},
  [4811] = {.lex_state = 76, .external_lex_state = 2},
  [4812] = {.lex_state = 76, .external_lex_state = 5},
  [4813] = {.lex_state = 2, .external_lex_state = 2},
  [4814] = {.lex_state = 2, .external_lex_state = 2},
  [4815] = {.lex_state = 76, .external_lex_state = 5},
  [4816] = {.lex_state = 76, .external_lex_state = 2},
  [4817] = {.lex_state = 76, .external_lex_state = 5},
  [4818] = {.lex_state = 76, .external_lex_state = 5},
  [4819] = {.lex_state = 76, .external_lex_state = 2},
  [4820] = {.lex_state = 76, .external_lex_state = 5},
  [4821] = {.lex_state = 76, .external_lex_state = 2},
  [4822] = {.lex_state = 76, .external_lex_state = 5},
  [4823] = {.lex_state = 76, .external_lex_state = 5},
  [4824] = {.lex_state = 76, .external_lex_state = 2},
  [4825] = {.lex_state = 76, .external_lex_state = 5},
  [4826] = {.lex_state = 76, .external_lex_state = 2},
  [4827] = {.lex_state = 76, .external_lex_state = 5},
  [4828] = {.lex_state = 76, .external_lex_state = 2},
  [4829] = {.lex_state = 76, .external_lex_state = 5},
  [4830] = {.lex_state = 76, .external_lex_state = 2},
  [4831] = {.lex_state = 76, .external_lex_state = 5},
  [4832] = {.lex_state = 76, .external_lex_state = 5},
  [4833] = {.lex_state = 76, .external_lex_state = 5},
  [4834] = {.lex_state = 76, .external_lex_state = 5},
  [4835] = {.lex_state = 76, .external_lex_state = 5},
  [4836] = {.lex_state = 76, .external_lex_state = 2},
  [4837] = {.lex_state = 76, .external_lex_state = 5},
  [4838] = {.lex_state = 76, .external_lex_state = 5},
  [4839] = {.lex_state = 76, .external_lex_state = 5},
  [4840] = {.lex_state = 76, .external_lex_state = 5},
  [4841] = {.lex_state = 76, .external_lex_state = 5},
  [4842] = {.lex_state = 76, .external_lex_state = 5},
  [4843] = {.lex_state = 76, .external_lex_state = 5},
  [4844] = {.lex_state = 76, .external_lex_state = 5},
  [4845] = {.lex_state = 76, .external_lex_state = 5},
  [4846] = {.lex_state = 76, .external_lex_state = 5},
  [4847] = {.lex_state = 76, .external_lex_state = 5},
  [4848] = {.lex_state = 76, .external_lex_state = 5},
  [4849] = {.lex_state = 76, .external_lex_state = 2},
  [4850] = {.lex_state = 76, .external_lex_state = 2},
  [4851] = {.lex_state = 76, .external_lex_state = 5},
  [4852] = {.lex_state = 76, .external_lex_state = 5},
  [4853] = {.lex_state = 76, .external_lex_state = 5},
  [4854] = {.lex_state = 76, .external_lex_state = 5},
  [4855] = {.lex_state = 76, .external_lex_state = 5},
  [4856] = {.lex_state = 76, .external_lex_state = 5},
  [4857] = {.lex_state = 76, .external_lex_state = 5},
  [4858] = {.lex_state = 76, .external_lex_state = 5},
  [4859] = {.lex_state = 76, .external_lex_state = 5},
  [4860] = {.lex_state = 76, .external_lex_state = 2},
  [4861] = {.lex_state = 76, .external_lex_state = 5},
  [4862] = {.lex_state = 76, .external_lex_state = 2},
  [4863] = {.lex_state = 76, .external_lex_state = 5},
  [4864] = {.lex_state = 76, .external_lex_state = 2},
  [4865] = {.lex_state = 76, .external_lex_state = 5},
  [4866] = {.lex_state = 76, .external_lex_state = 2},
  [4867] = {.lex_state = 76, .external_lex_state = 5},
  [4868] = {.lex_state = 76, .external_lex_state = 2},
  [4869] = {.lex_state = 76, .external_lex_state = 5},
  [4870] = {.lex_state = 76, .external_lex_state = 5},
  [4871] = {.lex_state = 76, .external_lex_state = 5},
  [4872] = {.lex_state = 76, .external_lex_state = 5},
  [4873] = {.lex_state = 76, .external_lex_state = 5},
  [4874] = {.lex_state = 76, .external_lex_state = 5},
  [4875] = {.lex_state = 76, .external_lex_state = 5},
  [4876] = {.lex_state = 76, .external_lex_state = 5},
  [4877] = {.lex_state = 76, .external_lex_state = 5},
  [4878] = {.lex_state = 76, .external_lex_state = 5},
  [4879] = {.lex_state = 76, .external_lex_state = 5},
  [4880] = {.lex_state = 76, .external_lex_state = 5},
  [4881] = {.lex_state = 76, .external_lex_state = 5},
  [4882] = {.lex_state = 76, .external_lex_state = 5},
  [4883] = {.lex_state = 76, .external_lex_state = 5},
  [4884] = {.lex_state = 76, .external_lex_state = 2},
  [4885] = {.lex_state = 2, .external_lex_state = 2},
  [4886] = {.lex_state = 76, .external_lex_state = 5},
  [4887] = {.lex_state = 76, .external_lex_state = 5},
  [4888] = {.lex_state = 76, .external_lex_state = 5},
  [4889] = {.lex_state = 76, .external_lex_state = 2},
  [4890] = {.lex_state = 76, .external_lex_state = 2},
  [4891] = {.lex_state = 76, .external_lex_state = 2},
  [4892] = {.lex_state = 76, .external_lex_state = 2},
  [4893] = {.lex_state = 76, .external_lex_state = 2},
  [4894] = {.lex_state = 76, .external_lex_state = 5},
  [4895] = {.lex_state = 76, .external_lex_state = 5},
  [4896] = {.lex_state = 76, .external_lex_state = 5},
  [4897] = {.lex_state = 76, .external_lex_state = 2},
  [4898] = {.lex_state = 76, .external_lex_state = 2},
  [4899] = {.lex_state = 76, .external_lex_state = 5},
  [4900] = {.lex_state = 76, .external_lex_state = 5},
  [4901] = {.lex_state = 76, .external_lex_state = 5},
  [4902] = {.lex_state = 76, .external_lex_state = 5},
  [4903] = {.lex_state = 76, .external_lex_state = 5},
  [4904] = {.lex_state = 76, .external_lex_state = 5},
  [4905] = {.lex_state = 76, .external_lex_state = 2},
  [4906] = {.lex_state = 76, .external_lex_state = 5},
  [4907] = {.lex_state = 76, .external_lex_state = 5},
  [4908] = {.lex_state = 76, .external_lex_state = 5},
  [4909] = {.lex_state = 76, .external_lex_state = 2},
  [4910] = {.lex_state = 76, .external_lex_state = 5},
  [4911] = {.lex_state = 76, .external_lex_state = 2},
  [4912] = {.lex_state = 76, .external_lex_state = 5},
  [4913] = {.lex_state = 76, .external_lex_state = 2},
  [4914] = {.lex_state = 76, .external_lex_state = 5},
  [4915] = {.lex_state = 76, .external_lex_state = 5},
  [4916] = {.lex_state = 76, .external_lex_state = 2},
  [4917] = {.lex_state = 76, .external_lex_state = 5},
  [4918] = {.lex_state = 76, .external_lex_state = 5},
  [4919] = {.lex_state = 76, .external_lex_state = 5},
  [4920] = {.lex_state = 76, .external_lex_state = 5},
  [4921] = {.lex_state = 76, .external_lex_state = 5},
  [4922] = {.lex_state = 13, .external_lex_state = 10},
  [4923] = {.lex_state = 76, .external_lex_state = 5},
  [4924] = {.lex_state = 76, .external_lex_state = 5},
  [4925] = {.lex_state = 76, .external_lex_state = 5},
  [4926] = {.lex_state = 76, .external_lex_state = 5},
  [4927] = {.lex_state = 76, .external_lex_state = 5},
  [4928] = {.lex_state = 76, .external_lex_state = 5},
  [4929] = {.lex_state = 76, .external_lex_state = 2},
  [4930] = {.lex_state = 76, .external_lex_state = 5},
  [4931] = {.lex_state = 76, .external_lex_state = 5},
  [4932] = {.lex_state = 76, .external_lex_state = 2},
  [4933] = {.lex_state = 76, .external_lex_state = 5},
  [4934] = {.lex_state = 76, .external_lex_state = 5},
  [4935] = {.lex_state = 76, .external_lex_state = 5},
  [4936] = {.lex_state = 76, .external_lex_state = 5},
  [4937] = {.lex_state = 76, .external_lex_state = 5},
  [4938] = {.lex_state = 76, .external_lex_state = 5},
  [4939] = {.lex_state = 76, .external_lex_state = 5},
  [4940] = {.lex_state = 76, .external_lex_state = 5},
  [4941] = {.lex_state = 76, .external_lex_state = 5},
  [4942] = {.lex_state = 76, .external_lex_state = 5},
  [4943] = {.lex_state = 76, .external_lex_state = 2},
  [4944] = {.lex_state = 76, .external_lex_state = 5},
  [4945] = {.lex_state = 76, .external_lex_state = 5},
  [4946] = {.lex_state = 76, .external_lex_state = 5},
  [4947] = {.lex_state = 76, .external_lex_state = 5},
  [4948] = {.lex_state = 76, .external_lex_state = 5},
  [4949] = {.lex_state = 76, .external_lex_state = 5},
  [4950] = {.lex_state = 76, .external_lex_state = 5},
  [4951] = {.lex_state = 76, .external_lex_state = 5},
  [4952] = {.lex_state = 76, .external_lex_state = 5},
  [4953] = {.lex_state = 76, .external_lex_state = 2},
  [4954] = {.lex_state = 76, .external_lex_state = 2},
  [4955] = {.lex_state = 76, .external_lex_state = 5},
  [4956] = {.lex_state = 76, .external_lex_state = 5},
  [4957] = {.lex_state = 76, .external_lex_state = 5},
  [4958] = {.lex_state = 76, .external_lex_state = 2},
  [4959] = {.lex_state = 76, .external_lex_state = 5},
  [4960] = {.lex_state = 76, .external_lex_state = 2},
  [4961] = {.lex_state = 76, .external_lex_state = 2},
  [4962] = {.lex_state = 76, .external_lex_state = 5},
  [4963] = {.lex_state = 76, .external_lex_state = 5},
  [4964] = {.lex_state = 76, .external_lex_state = 5},
  [4965] = {.lex_state = 76, .external_lex_state = 5},
  [4966] = {.lex_state = 76, .external_lex_state = 5},
  [4967] = {.lex_state = 76, .external_lex_state = 2},
  [4968] = {.lex_state = 76, .external_lex_state = 5},
  [4969] = {.lex_state = 76, .external_lex_state = 5},
  [4970] = {.lex_state = 76, .external_lex_state = 5},
  [4971] = {.lex_state = 76, .external_lex_state = 5},
  [4972] = {.lex_state = 76, .external_lex_state = 5},
  [4973] = {.lex_state = 76, .external_lex_state = 5},
  [4974] = {.lex_state = 76, .external_lex_state = 2},
  [4975] = {.lex_state = 76, .external_lex_state = 2},
  [4976] = {.lex_state = 76, .external_lex_state = 5},
  [4977] = {.lex_state = 76, .external_lex_state = 2},
  [4978] = {.lex_state = 76, .external_lex_state = 5},
  [4979] = {.lex_state = 76, .external_lex_state = 5},
  [4980] = {.lex_state = 76, .external_lex_state = 5},
  [4981] = {.lex_state = 76, .external_lex_state = 5},
  [4982] = {.lex_state = 76, .external_lex_state = 5},
  [4983] = {.lex_state = 76, .external_lex_state = 2},
  [4984] = {.lex_state = 76, .external_lex_state = 2},
  [4985] = {.lex_state = 76, .external_lex_state = 5},
  [4986] = {.lex_state = 76, .external_lex_state = 5},
  [4987] = {.lex_state = 76, .external_lex_state = 5},
  [4988] = {.lex_state = 76, .external_lex_state = 5},
  [4989] = {.lex_state = 76, .external_lex_state = 5},
  [4990] = {.lex_state = 76, .external_lex_state = 5},
  [4991] = {.lex_state = 76, .external_lex_state = 5},
  [4992] = {.lex_state = 76, .external_lex_state = 5},
  [4993] = {.lex_state = 76, .external_lex_state = 5},
  [4994] = {.lex_state = 76, .external_lex_state = 5},
  [4995] = {.lex_state = 76, .external_lex_state = 2},
  [4996] = {.lex_state = 76, .external_lex_state = 5},
  [4997] = {.lex_state = 76, .external_lex_state = 5},
  [4998] = {.lex_state = 2, .external_lex_state = 2},
  [4999] = {.lex_state = 76, .external_lex_state = 2},
  [5000] = {.lex_state = 76, .external_lex_state = 5},
  [5001] = {.lex_state = 76, .external_lex_state = 2},
  [5002] = {.lex_state = 76, .external_lex_state = 2},
  [5003] = {.lex_state = 76, .external_lex_state = 2},
  [5004] = {.lex_state = 76, .external_lex_state = 5},
  [5005] = {.lex_state = 76, .external_lex_state = 2},
  [5006] = {.lex_state = 76, .external_lex_state = 2},
  [5007] = {.lex_state = 76, .external_lex_state = 5},
  [5008] = {.lex_state = 76, .external_lex_state = 2},
  [5009] = {.lex_state = 76, .external_lex_state = 2},
  [5010] = {.lex_state = 76, .external_lex_state = 2},
  [5011] = {.lex_state = 76, .external_lex_state = 5},
  [5012] = {.lex_state = 76, .external_lex_state = 5},
  [5013] = {.lex_state = 76, .external_lex_state = 2},
  [5014] = {.lex_state = 76, .external_lex_state = 5},
  [5015] = {.lex_state = 76, .external_lex_state = 5},
  [5016] = {.lex_state = 76, .external_lex_state = 2},
  [5017] = {.lex_state = 76, .external_lex_state = 5},
  [5018] = {.lex_state = 76, .external_lex_state = 2},
  [5019] = {.lex_state = 76, .external_lex_state = 5},
  [5020] = {.lex_state = 76, .external_lex_state = 5},
  [5021] = {.lex_state = 76, .external_lex_state = 5},
  [5022] = {.lex_state = 76, .external_lex_state = 2},
  [5023] = {.lex_state = 76, .external_lex_state = 2},
  [5024] = {.lex_state = 76, .external_lex_state = 2},
  [5025] = {.lex_state = 76, .external_lex_state = 5},
  [5026] = {.lex_state = 76, .external_lex_state = 2},
  [5027] = {.lex_state = 76, .external_lex_state = 5},
  [5028] = {.lex_state = 76, .external_lex_state = 5},
  [5029] = {.lex_state = 76, .external_lex_state = 5},
  [5030] = {.lex_state = 76, .external_lex_state = 5},
  [5031] = {.lex_state = 76, .external_lex_state = 5},
  [5032] = {.lex_state = 76, .external_lex_state = 2},
  [5033] = {.lex_state = 76, .external_lex_state = 2},
  [5034] = {.lex_state = 76, .external_lex_state = 5},
  [5035] = {.lex_state = 76, .external_lex_state = 2},
  [5036] = {.lex_state = 76, .external_lex_state = 5},
  [5037] = {.lex_state = 76, .external_lex_state = 5},
  [5038] = {.lex_state = 76, .external_lex_state = 2},
  [5039] = {.lex_state = 76, .external_lex_state = 5},
  [5040] = {.lex_state = 76, .external_lex_state = 5},
  [5041] = {.lex_state = 76, .external_lex_state = 5},
  [5042] = {.lex_state = 76, .external_lex_state = 5},
  [5043] = {.lex_state = 76, .external_lex_state = 5},
  [5044] = {.lex_state = 76, .external_lex_state = 5},
  [5045] = {.lex_state = 76, .external_lex_state = 5},
  [5046] = {.lex_state = 76, .external_lex_state = 5},
  [5047] = {.lex_state = 76, .external_lex_state = 5},
  [5048] = {.lex_state = 76, .external_lex_state = 2},
  [5049] = {.lex_state = 76, .external_lex_state = 2},
  [5050] = {.lex_state = 76, .external_lex_state = 5},
  [5051] = {.lex_state = 76, .external_lex_state = 5},
  [5052] = {.lex_state = 76, .external_lex_state = 5},
  [5053] = {.lex_state = 76, .external_lex_state = 2},
  [5054] = {.lex_state = 76, .external_lex_state = 5},
  [5055] = {.lex_state = 76, .external_lex_state = 5},
  [5056] = {.lex_state = 76, .external_lex_state = 2},
  [5057] = {.lex_state = 76, .external_lex_state = 2},
  [5058] = {.lex_state = 76, .external_lex_state = 5},
  [5059] = {.lex_state = 76, .external_lex_state = 5},
  [5060] = {.lex_state = 76, .external_lex_state = 2},
  [5061] = {.lex_state = 76, .external_lex_state = 2},
  [5062] = {.lex_state = 76, .external_lex_state = 2},
  [5063] = {.lex_state = 76, .external_lex_state = 2},
  [5064] = {.lex_state = 76, .external_lex_state = 5},
  [5065] = {.lex_state = 76, .external_lex_state = 2},
  [5066] = {.lex_state = 76, .external_lex_state = 5},
  [5067] = {.lex_state = 76, .external_lex_state = 5},
  [5068] = {.lex_state = 76, .external_lex_state = 2},
  [5069] = {.lex_state = 76, .external_lex_state = 5},
  [5070] = {.lex_state = 76, .external_lex_state = 2},
  [5071] = {.lex_state = 76, .external_lex_state = 5},
  [5072] = {.lex_state = 76, .external_lex_state = 5},
  [5073] = {.lex_state = 76, .external_lex_state = 5},
  [5074] = {.lex_state = 76, .external_lex_state = 5},
  [5075] = {.lex_state = 76, .external_lex_state = 5},
  [5076] = {.lex_state = 76, .external_lex_state = 5},
  [5077] = {.lex_state = 76, .external_lex_state = 5},
  [5078] = {.lex_state = 76, .external_lex_state = 5},
  [5079] = {.lex_state = 76, .external_lex_state = 5},
  [5080] = {.lex_state = 76, .external_lex_state = 5},
  [5081] = {.lex_state = 76, .external_lex_state = 5},
  [5082] = {.lex_state = 76, .external_lex_state = 5},
  [5083] = {.lex_state = 76, .external_lex_state = 5},
  [5084] = {.lex_state = 76, .external_lex_state = 5},
  [5085] = {.lex_state = 76, .external_lex_state = 5},
  [5086] = {.lex_state = 76, .external_lex_state = 5},
  [5087] = {.lex_state = 76, .external_lex_state = 5},
  [5088] = {.lex_state = 76, .external_lex_state = 2},
  [5089] = {.lex_state = 76, .external_lex_state = 5},
  [5090] = {.lex_state = 76, .external_lex_state = 5},
  [5091] = {.lex_state = 76, .external_lex_state = 5},
  [5092] = {.lex_state = 76, .external_lex_state = 5},
  [5093] = {.lex_state = 76, .external_lex_state = 5},
  [5094] = {.lex_state = 76, .external_lex_state = 5},
  [5095] = {.lex_state = 76, .external_lex_state = 2},
  [5096] = {.lex_state = 76, .external_lex_state = 5},
  [5097] = {.lex_state = 76, .external_lex_state = 5},
  [5098] = {.lex_state = 76, .external_lex_state = 5},
  [5099] = {.lex_state = 76, .external_lex_state = 5},
  [5100] = {.lex_state = 76, .external_lex_state = 5},
  [5101] = {.lex_state = 76, .external_lex_state = 5},
  [5102] = {.lex_state = 76, .external_lex_state = 5},
  [5103] = {.lex_state = 76, .external_lex_state = 2},
  [5104] = {.lex_state = 76, .external_lex_state = 5},
  [5105] = {.lex_state = 76, .external_lex_state = 5},
  [5106] = {.lex_state = 76, .external_lex_state = 5},
  [5107] = {.lex_state = 76, .external_lex_state = 5},
  [5108] = {.lex_state = 76, .external_lex_state = 5},
  [5109] = {.lex_state = 76, .external_lex_state = 5},
  [5110] = {.lex_state = 76, .external_lex_state = 2},
  [5111] = {.lex_state = 76, .external_lex_state = 5},
  [5112] = {.lex_state = 76, .external_lex_state = 5},
  [5113] = {.lex_state = 76, .external_lex_state = 2},
  [5114] = {.lex_state = 76, .external_lex_state = 5},
  [5115] = {.lex_state = 76, .external_lex_state = 2},
  [5116] = {.lex_state = 76, .external_lex_state = 5},
  [5117] = {.lex_state = 76, .external_lex_state = 5},
  [5118] = {.lex_state = 76, .external_lex_state = 5},
  [5119] = {.lex_state = 76, .external_lex_state = 5},
  [5120] = {.lex_state = 76, .external_lex_state = 5},
  [5121] = {.lex_state = 76, .external_lex_state = 5},
  [5122] = {.lex_state = 76, .external_lex_state = 5},
  [5123] = {.lex_state = 76, .external_lex_state = 5},
  [5124] = {.lex_state = 76, .external_lex_state = 5},
  [5125] = {.lex_state = 76, .external_lex_state = 5},
  [5126] = {.lex_state = 76, .external_lex_state = 5},
  [5127] = {.lex_state = 76, .external_lex_state = 2},
  [5128] = {.lex_state = 76, .external_lex_state = 5},
  [5129] = {.lex_state = 76, .external_lex_state = 5},
  [5130] = {.lex_state = 76, .external_lex_state = 5},
  [5131] = {.lex_state = 76, .external_lex_state = 5},
  [5132] = {.lex_state = 76, .external_lex_state = 5},
  [5133] = {.lex_state = 76, .external_lex_state = 5},
  [5134] = {.lex_state = 76, .external_lex_state = 5},
  [5135] = {.lex_state = 76, .external_lex_state = 5},
  [5136] = {.lex_state = 76, .external_lex_state = 5},
  [5137] = {.lex_state = 76, .external_lex_state = 5},
  [5138] = {.lex_state = 76, .external_lex_state = 5},
  [5139] = {.lex_state = 76, .external_lex_state = 2},
  [5140] = {.lex_state = 76, .external_lex_state = 2},
  [5141] = {.lex_state = 76, .external_lex_state = 2},
  [5142] = {.lex_state = 76, .external_lex_state = 2},
  [5143] = {.lex_state = 76, .external_lex_state = 2},
  [5144] = {.lex_state = 76, .external_lex_state = 2},
  [5145] = {.lex_state = 76, .external_lex_state = 2},
  [5146] = {.lex_state = 76, .external_lex_state = 2},
  [5147] = {.lex_state = 76, .external_lex_state = 2},
  [5148] = {.lex_state = 76, .external_lex_state = 2},
  [5149] = {.lex_state = 76, .external_lex_state = 2},
  [5150] = {.lex_state = 76, .external_lex_state = 2},
  [5151] = {.lex_state = 76, .external_lex_state = 2},
  [5152] = {.lex_state = 76, .external_lex_state = 2},
  [5153] = {.lex_state = 76, .external_lex_state = 2},
  [5154] = {.lex_state = 76, .external_lex_state = 5},
  [5155] = {.lex_state = 76, .external_lex_state = 5},
  [5156] = {.lex_state = 76, .external_lex_state = 2},
  [5157] = {.lex_state = 76, .external_lex_state = 2},
  [5158] = {.lex_state = 76, .external_lex_state = 2},
  [5159] = {.lex_state = 76, .external_lex_state = 2},
  [5160] = {.lex_state = 76, .external_lex_state = 2},
  [5161] = {.lex_state = 76, .external_lex_state = 2},
  [5162] = {.lex_state = 76, .external_lex_state = 2},
  [5163] = {.lex_state = 76, .external_lex_state = 2},
  [5164] = {.lex_state = 76, .external_lex_state = 2},
  [5165] = {.lex_state = 76, .external_lex_state = 2},
  [5166] = {.lex_state = 76, .external_lex_state = 2},
  [5167] = {.lex_state = 76, .external_lex_state = 2},
  [5168] = {.lex_state = 76, .external_lex_state = 5},
  [5169] = {.lex_state = 76, .external_lex_state = 2},
  [5170] = {.lex_state = 76, .external_lex_state = 2},
  [5171] = {.lex_state = 76, .external_lex_state = 2},
  [5172] = {.lex_state = 76, .external_lex_state = 2},
  [5173] = {.lex_state = 76, .external_lex_state = 5},
  [5174] = {.lex_state = 76, .external_lex_state = 2},
  [5175] = {.lex_state = 76, .external_lex_state = 2},
  [5176] = {.lex_state = 76, .external_lex_state = 2},
  [5177] = {.lex_state = 76, .external_lex_state = 2},
  [5178] = {.lex_state = 76, .external_lex_state = 2},
  [5179] = {.lex_state = 76, .external_lex_state = 2},
  [5180] = {.lex_state = 76, .external_lex_state = 2},
  [5181] = {.lex_state = 76, .external_lex_state = 2},
  [5182] = {.lex_state = 76, .external_lex_state = 2},
  [5183] = {.lex_state = 76, .external_lex_state = 2},
  [5184] = {.lex_state = 76, .external_lex_state = 2},
  [5185] = {.lex_state = 76, .external_lex_state = 2},
  [5186] = {.lex_state = 76, .external_lex_state = 2},
  [5187] = {.lex_state = 76, .external_lex_state = 2},
  [5188] = {.lex_state = 76, .external_lex_state = 2},
  [5189] = {.lex_state = 76, .external_lex_state = 2},
  [5190] = {.lex_state = 76, .external_lex_state = 2},
  [5191] = {.lex_state = 76, .external_lex_state = 2},
  [5192] = {.lex_state = 76, .external_lex_state = 2},
  [5193] = {.lex_state = 76, .external_lex_state = 2},
  [5194] = {.lex_state = 76, .external_lex_state = 2},
  [5195] = {.lex_state = 76, .external_lex_state = 2},
  [5196] = {.lex_state = 76, .external_lex_state = 2},
  [5197] = {.lex_state = 76, .external_lex_state = 2},
  [5198] = {.lex_state = 76, .external_lex_state = 2},
  [5199] = {.lex_state = 76, .external_lex_state = 2},
  [5200] = {.lex_state = 76, .external_lex_state = 2},
  [5201] = {.lex_state = 76, .external_lex_state = 2},
  [5202] = {.lex_state = 76, .external_lex_state = 2},
  [5203] = {.lex_state = 76, .external_lex_state = 2},
  [5204] = {.lex_state = 76, .external_lex_state = 2},
  [5205] = {.lex_state = 76, .external_lex_state = 2},
  [5206] = {.lex_state = 76, .external_lex_state = 2},
  [5207] = {.lex_state = 76, .external_lex_state = 2},
  [5208] = {.lex_state = 76, .external_lex_state = 2},
  [5209] = {.lex_state = 76, .external_lex_state = 2},
  [5210] = {.lex_state = 76, .external_lex_state = 2},
  [5211] = {.lex_state = 76, .external_lex_state = 2},
  [5212] = {.lex_state = 76, .external_lex_state = 2},
  [5213] = {.lex_state = 76, .external_lex_state = 2},
  [5214] = {.lex_state = 76, .external_lex_state = 5},
  [5215] = {.lex_state = 76, .external_lex_state = 2},
  [5216] = {.lex_state = 76, .external_lex_state = 2},
  [5217] = {.lex_state = 76, .external_lex_state = 2},
  [5218] = {.lex_state = 76, .external_lex_state = 2},
  [5219] = {.lex_state = 76, .external_lex_state = 2},
  [5220] = {.lex_state = 76, .external_lex_state = 5},
  [5221] = {.lex_state = 76, .external_lex_state = 5},
  [5222] = {.lex_state = 76, .external_lex_state = 2},
  [5223] = {.lex_state = 76, .external_lex_state = 2},
  [5224] = {.lex_state = 76, .external_lex_state = 5},
  [5225] = {.lex_state = 76, .external_lex_state = 2},
  [5226] = {.lex_state = 76, .external_lex_state = 2},
  [5227] = {.lex_state = 76, .external_lex_state = 2},
  [5228] = {.lex_state = 76, .external_lex_state = 5},
  [5229] = {.lex_state = 76, .external_lex_state = 2},
  [5230] = {.lex_state = 76, .external_lex_state = 2},
  [5231] = {.lex_state = 76, .external_lex_state = 2},
  [5232] = {.lex_state = 76, .external_lex_state = 2},
  [5233] = {.lex_state = 76, .external_lex_state = 2},
  [5234] = {.lex_state = 76, .external_lex_state = 2},
  [5235] = {.lex_state = 76, .external_lex_state = 2},
  [5236] = {.lex_state = 76, .external_lex_state = 2},
  [5237] = {.lex_state = 76, .external_lex_state = 2},
  [5238] = {.lex_state = 76, .external_lex_state = 2},
  [5239] = {.lex_state = 76, .external_lex_state = 2},
  [5240] = {.lex_state = 76, .external_lex_state = 2},
  [5241] = {.lex_state = 76, .external_lex_state = 2},
  [5242] = {.lex_state = 76, .external_lex_state = 2},
  [5243] = {.lex_state = 76, .external_lex_state = 2},
  [5244] = {.lex_state = 76, .external_lex_state = 2},
  [5245] = {.lex_state = 76, .external_lex_state = 2},
  [5246] = {.lex_state = 76, .external_lex_state = 2},
  [5247] = {.lex_state = 76, .external_lex_state = 2},
  [5248] = {.lex_state = 76, .external_lex_state = 2},
  [5249] = {.lex_state = 76, .external_lex_state = 5},
  [5250] = {.lex_state = 76, .external_lex_state = 2},
  [5251] = {.lex_state = 76, .external_lex_state = 2},
  [5252] = {.lex_state = 76, .external_lex_state = 2},
  [5253] = {.lex_state = 76, .external_lex_state = 2},
  [5254] = {.lex_state = 76, .external_lex_state = 2},
  [5255] = {.lex_state = 76, .external_lex_state = 2},
  [5256] = {.lex_state = 76, .external_lex_state = 2},
  [5257] = {.lex_state = 76, .external_lex_state = 2},
  [5258] = {.lex_state = 76, .external_lex_state = 2},
  [5259] = {.lex_state = 76, .external_lex_state = 2},
  [5260] = {.lex_state = 76, .external_lex_state = 2},
  [5261] = {.lex_state = 76, .external_lex_state = 2},
  [5262] = {.lex_state = 76, .external_lex_state = 2},
  [5263] = {.lex_state = 76, .external_lex_state = 2},
  [5264] = {.lex_state = 76, .external_lex_state = 2},
  [5265] = {.lex_state = 76, .external_lex_state = 2},
  [5266] = {.lex_state = 76, .external_lex_state = 2},
  [5267] = {.lex_state = 76, .external_lex_state = 2},
  [5268] = {.lex_state = 76, .external_lex_state = 2},
  [5269] = {.lex_state = 76, .external_lex_state = 2},
  [5270] = {.lex_state = 76, .external_lex_state = 2},
  [5271] = {.lex_state = 76, .external_lex_state = 2},
  [5272] = {.lex_state = 76, .external_lex_state = 5},
  [5273] = {.lex_state = 76, .external_lex_state = 5},
  [5274] = {.lex_state = 76, .external_lex_state = 2},
  [5275] = {.lex_state = 76, .external_lex_state = 5},
  [5276] = {.lex_state = 76, .external_lex_state = 2},
  [5277] = {.lex_state = 76, .external_lex_state = 2},
  [5278] = {.lex_state = 76, .external_lex_state = 2},
  [5279] = {.lex_state = 76, .external_lex_state = 2},
  [5280] = {.lex_state = 76, .external_lex_state = 2},
  [5281] = {.lex_state = 76, .external_lex_state = 2},
  [5282] = {.lex_state = 76, .external_lex_state = 2},
  [5283] = {.lex_state = 76, .external_lex_state = 2},
  [5284] = {.lex_state = 76, .external_lex_state = 2},
  [5285] = {.lex_state = 76, .external_lex_state = 2},
  [5286] = {.lex_state = 76, .external_lex_state = 2},
  [5287] = {.lex_state = 76, .external_lex_state = 5},
  [5288] = {.lex_state = 76, .external_lex_state = 2},
  [5289] = {.lex_state = 76, .external_lex_state = 2},
  [5290] = {.lex_state = 76, .external_lex_state = 2},
  [5291] = {.lex_state = 76, .external_lex_state = 2},
  [5292] = {.lex_state = 76, .external_lex_state = 2},
  [5293] = {.lex_state = 76, .external_lex_state = 2},
  [5294] = {.lex_state = 76, .external_lex_state = 2},
  [5295] = {.lex_state = 76, .external_lex_state = 5},
  [5296] = {.lex_state = 76, .external_lex_state = 5},
  [5297] = {.lex_state = 76, .external_lex_state = 5},
  [5298] = {.lex_state = 76, .external_lex_state = 2},
  [5299] = {.lex_state = 76, .external_lex_state = 2},
  [5300] = {.lex_state = 76, .external_lex_state = 2},
  [5301] = {.lex_state = 76, .external_lex_state = 2},
  [5302] = {.lex_state = 76, .external_lex_state = 2},
  [5303] = {.lex_state = 76, .external_lex_state = 2},
  [5304] = {.lex_state = 76, .external_lex_state = 2},
  [5305] = {.lex_state = 76, .external_lex_state = 2},
  [5306] = {.lex_state = 76, .external_lex_state = 2},
  [5307] = {.lex_state = 76, .external_lex_state = 2},
  [5308] = {.lex_state = 76, .external_lex_state = 2},
  [5309] = {.lex_state = 76, .external_lex_state = 2},
  [5310] = {.lex_state = 76, .external_lex_state = 2},
  [5311] = {.lex_state = 76, .external_lex_state = 2},
  [5312] = {.lex_state = 76, .external_lex_state = 5},
  [5313] = {.lex_state = 76, .external_lex_state = 2},
  [5314] = {.lex_state = 76, .external_lex_state = 2},
  [5315] = {.lex_state = 76, .external_lex_state = 2},
  [5316] = {.lex_state = 76, .external_lex_state = 2},
  [5317] = {.lex_state = 76, .external_lex_state = 2},
  [5318] = {.lex_state = 76, .external_lex_state = 2},
  [5319] = {.lex_state = 76, .external_lex_state = 2},
  [5320] = {.lex_state = 76, .external_lex_state = 2},
  [5321] = {.lex_state = 76, .external_lex_state = 2},
  [5322] = {.lex_state = 76, .external_lex_state = 2},
  [5323] = {.lex_state = 76, .external_lex_state = 5},
  [5324] = {.lex_state = 76, .external_lex_state = 2},
  [5325] = {.lex_state = 76, .external_lex_state = 2},
  [5326] = {.lex_state = 76, .external_lex_state = 2},
  [5327] = {.lex_state = 76, .external_lex_state = 2},
  [5328] = {.lex_state = 76, .external_lex_state = 2},
  [5329] = {.lex_state = 76, .external_lex_state = 2},
  [5330] = {.lex_state = 76, .external_lex_state = 2},
  [5331] = {.lex_state = 76, .external_lex_state = 2},
  [5332] = {.lex_state = 76, .external_lex_state = 2},
  [5333] = {.lex_state = 76, .external_lex_state = 2},
  [5334] = {.lex_state = 76, .external_lex_state = 2},
  [5335] = {.lex_state = 76, .external_lex_state = 2},
  [5336] = {.lex_state = 76, .external_lex_state = 2},
  [5337] = {.lex_state = 76, .external_lex_state = 2},
  [5338] = {.lex_state = 76, .external_lex_state = 2},
  [5339] = {.lex_state = 76, .external_lex_state = 2},
  [5340] = {.lex_state = 76, .external_lex_state = 2},
  [5341] = {.lex_state = 13, .external_lex_state = 2},
  [5342] = {.lex_state = 76, .external_lex_state = 2},
  [5343] = {.lex_state = 76, .external_lex_state = 2},
  [5344] = {.lex_state = 76, .external_lex_state = 2},
  [5345] = {.lex_state = 76, .external_lex_state = 2},
  [5346] = {.lex_state = 76, .external_lex_state = 2},
  [5347] = {.lex_state = 76, .external_lex_state = 2},
  [5348] = {.lex_state = 76, .external_lex_state = 2},
  [5349] = {.lex_state = 76, .external_lex_state = 2},
  [5350] = {.lex_state = 76, .external_lex_state = 2},
  [5351] = {.lex_state = 76, .external_lex_state = 2},
  [5352] = {.lex_state = 76, .external_lex_state = 2},
  [5353] = {.lex_state = 76, .external_lex_state = 2},
  [5354] = {.lex_state = 76, .external_lex_state = 2},
  [5355] = {.lex_state = 76, .external_lex_state = 2},
  [5356] = {.lex_state = 76, .external_lex_state = 2},
  [5357] = {.lex_state = 76, .external_lex_state = 2},
  [5358] = {.lex_state = 76, .external_lex_state = 2},
  [5359] = {.lex_state = 76, .external_lex_state = 2},
  [5360] = {.lex_state = 76, .external_lex_state = 5},
  [5361] = {.lex_state = 13, .external_lex_state = 2},
  [5362] = {.lex_state = 76, .external_lex_state = 2},
  [5363] = {.lex_state = 76, .external_lex_state = 2},
  [5364] = {.lex_state = 76, .external_lex_state = 2},
  [5365] = {.lex_state = 76, .external_lex_state = 2},
  [5366] = {.lex_state = 76, .external_lex_state = 2},
  [5367] = {.lex_state = 76, .external_lex_state = 2},
  [5368] = {.lex_state = 76, .external_lex_state = 2},
  [5369] = {.lex_state = 76, .external_lex_state = 2},
  [5370] = {.lex_state = 76, .external_lex_state = 2},
  [5371] = {.lex_state = 76, .external_lex_state = 2},
  [5372] = {.lex_state = 76, .external_lex_state = 2},
  [5373] = {.lex_state = 76, .external_lex_state = 2},
  [5374] = {.lex_state = 76, .external_lex_state = 2},
  [5375] = {.lex_state = 76, .external_lex_state = 2},
  [5376] = {.lex_state = 76, .external_lex_state = 2},
  [5377] = {.lex_state = 76, .external_lex_state = 2},
  [5378] = {.lex_state = 76, .external_lex_state = 2},
  [5379] = {.lex_state = 76, .external_lex_state = 2},
  [5380] = {.lex_state = 76, .external_lex_state = 2},
  [5381] = {.lex_state = 76, .external_lex_state = 2},
  [5382] = {.lex_state = 76, .external_lex_state = 2},
  [5383] = {.lex_state = 76, .external_lex_state = 2},
  [5384] = {.lex_state = 76, .external_lex_state = 2},
  [5385] = {.lex_state = 76, .external_lex_state = 2},
  [5386] = {.lex_state = 76, .external_lex_state = 2},
  [5387] = {.lex_state = 76, .external_lex_state = 2},
  [5388] = {.lex_state = 76, .external_lex_state = 2},
  [5389] = {.lex_state = 76, .external_lex_state = 2},
  [5390] = {.lex_state = 76, .external_lex_state = 2},
  [5391] = {.lex_state = 76, .external_lex_state = 2},
  [5392] = {.lex_state = 76, .external_lex_state = 2},
  [5393] = {.lex_state = 76, .external_lex_state = 2},
  [5394] = {.lex_state = 76, .external_lex_state = 2},
  [5395] = {.lex_state = 76, .external_lex_state = 2},
  [5396] = {.lex_state = 76, .external_lex_state = 2},
  [5397] = {.lex_state = 76, .external_lex_state = 2},
  [5398] = {.lex_state = 76, .external_lex_state = 2},
  [5399] = {.lex_state = 76, .external_lex_state = 2},
  [5400] = {.lex_state = 76, .external_lex_state = 2},
  [5401] = {.lex_state = 76, .external_lex_state = 2},
  [5402] = {.lex_state = 76, .external_lex_state = 2},
  [5403] = {.lex_state = 76, .external_lex_state = 2},
  [5404] = {.lex_state = 76, .external_lex_state = 2},
  [5405] = {.lex_state = 76, .external_lex_state = 2},
  [5406] = {.lex_state = 76, .external_lex_state = 2},
  [5407] = {.lex_state = 76, .external_lex_state = 2},
  [5408] = {.lex_state = 76, .external_lex_state = 2},
  [5409] = {.lex_state = 76, .external_lex_state = 2},
  [5410] = {.lex_state = 76, .external_lex_state = 2},
  [5411] = {.lex_state = 76, .external_lex_state = 2},
  [5412] = {.lex_state = 76, .external_lex_state = 2},
  [5413] = {.lex_state = 76, .external_lex_state = 2},
  [5414] = {.lex_state = 76, .external_lex_state = 2},
  [5415] = {.lex_state = 13, .external_lex_state = 10},
  [5416] = {.lex_state = 76, .external_lex_state = 2},
  [5417] = {.lex_state = 76, .external_lex_state = 2},
  [5418] = {.lex_state = 76, .external_lex_state = 2},
  [5419] = {.lex_state = 76, .external_lex_state = 2},
  [5420] = {.lex_state = 76, .external_lex_state = 2},
  [5421] = {.lex_state = 13, .external_lex_state = 2},
  [5422] = {.lex_state = 76, .external_lex_state = 2},
  [5423] = {.lex_state = 76, .external_lex_state = 2},
  [5424] = {.lex_state = 76, .external_lex_state = 2},
  [5425] = {.lex_state = 76, .external_lex_state = 2},
  [5426] = {.lex_state = 76, .external_lex_state = 2},
  [5427] = {.lex_state = 76, .external_lex_state = 5},
  [5428] = {.lex_state = 76, .external_lex_state = 5},
  [5429] = {.lex_state = 76, .external_lex_state = 2},
  [5430] = {.lex_state = 76, .external_lex_state = 2},
  [5431] = {.lex_state = 76, .external_lex_state = 5},
  [5432] = {.lex_state = 76, .external_lex_state = 2},
  [5433] = {.lex_state = 76, .external_lex_state = 2},
  [5434] = {.lex_state = 76, .external_lex_state = 2},
  [5435] = {.lex_state = 76, .external_lex_state = 2},
  [5436] = {.lex_state = 76, .external_lex_state = 2},
  [5437] = {.lex_state = 76, .external_lex_state = 2},
  [5438] = {.lex_state = 76, .external_lex_state = 2},
  [5439] = {.lex_state = 76, .external_lex_state = 2},
  [5440] = {.lex_state = 76, .external_lex_state = 2},
  [5441] = {.lex_state = 76, .external_lex_state = 2},
  [5442] = {.lex_state = 76, .external_lex_state = 2},
  [5443] = {.lex_state = 76, .external_lex_state = 5},
  [5444] = {.lex_state = 76, .external_lex_state = 2},
  [5445] = {.lex_state = 76, .external_lex_state = 2},
  [5446] = {.lex_state = 76, .external_lex_state = 5},
  [5447] = {.lex_state = 76, .external_lex_state = 5},
  [5448] = {.lex_state = 76, .external_lex_state = 2},
  [5449] = {.lex_state = 76, .external_lex_state = 2},
  [5450] = {.lex_state = 76, .external_lex_state = 2},
  [5451] = {.lex_state = 76, .external_lex_state = 2},
  [5452] = {.lex_state = 76, .external_lex_state = 2},
  [5453] = {.lex_state = 76, .external_lex_state = 2},
  [5454] = {.lex_state = 76, .external_lex_state = 2},
  [5455] = {.lex_state = 76, .external_lex_state = 2},
  [5456] = {.lex_state = 76, .external_lex_state = 2},
  [5457] = {.lex_state = 76, .external_lex_state = 2},
  [5458] = {.lex_state = 76, .external_lex_state = 2},
  [5459] = {.lex_state = 76, .external_lex_state = 2},
  [5460] = {.lex_state = 76, .external_lex_state = 2},
  [5461] = {.lex_state = 76, .external_lex_state = 2},
  [5462] = {.lex_state = 76, .external_lex_state = 2},
  [5463] = {.lex_state = 76, .external_lex_state = 2},
  [5464] = {.lex_state = 76, .external_lex_state = 2},
  [5465] = {.lex_state = 76, .external_lex_state = 2},
  [5466] = {.lex_state = 76, .external_lex_state = 2},
  [5467] = {.lex_state = 76, .external_lex_state = 2},
  [5468] = {.lex_state = 76, .external_lex_state = 2},
  [5469] = {.lex_state = 76, .external_lex_state = 2},
  [5470] = {.lex_state = 76, .external_lex_state = 2},
  [5471] = {.lex_state = 76, .external_lex_state = 2},
  [5472] = {.lex_state = 76, .external_lex_state = 2},
  [5473] = {.lex_state = 76, .external_lex_state = 2},
  [5474] = {.lex_state = 76, .external_lex_state = 2},
  [5475] = {.lex_state = 76, .external_lex_state = 2},
  [5476] = {.lex_state = 76, .external_lex_state = 2},
  [5477] = {.lex_state = 76, .external_lex_state = 5},
  [5478] = {.lex_state = 76, .external_lex_state = 2},
  [5479] = {.lex_state = 76, .external_lex_state = 2},
  [5480] = {.lex_state = 76, .external_lex_state = 2},
  [5481] = {.lex_state = 76, .external_lex_state = 5},
  [5482] = {.lex_state = 76, .external_lex_state = 2},
  [5483] = {.lex_state = 76, .external_lex_state = 2},
  [5484] = {.lex_state = 76, .external_lex_state = 2},
  [5485] = {.lex_state = 76, .external_lex_state = 2},
  [5486] = {.lex_state = 76, .external_lex_state = 2},
  [5487] = {.lex_state = 76, .external_lex_state = 2},
  [5488] = {.lex_state = 76, .external_lex_state = 2},
  [5489] = {.lex_state = 76, .external_lex_state = 2},
  [5490] = {.lex_state = 76, .external_lex_state = 2},
  [5491] = {.lex_state = 76, .external_lex_state = 2},
  [5492] = {.lex_state = 76, .external_lex_state = 2},
  [5493] = {.lex_state = 76, .external_lex_state = 2},
  [5494] = {.lex_state = 76, .external_lex_state = 2},
  [5495] = {.lex_state = 76, .external_lex_state = 2},
  [5496] = {.lex_state = 76, .external_lex_state = 2},
  [5497] = {.lex_state = 76, .external_lex_state = 2},
  [5498] = {.lex_state = 76, .external_lex_state = 2},
  [5499] = {.lex_state = 76, .external_lex_state = 2},
  [5500] = {.lex_state = 76, .external_lex_state = 2},
  [5501] = {.lex_state = 76, .external_lex_state = 2},
  [5502] = {.lex_state = 76, .external_lex_state = 2},
  [5503] = {.lex_state = 76, .external_lex_state = 2},
  [5504] = {.lex_state = 76, .external_lex_state = 2},
  [5505] = {.lex_state = 76, .external_lex_state = 2},
  [5506] = {.lex_state = 76, .external_lex_state = 2},
  [5507] = {.lex_state = 76, .external_lex_state = 2},
  [5508] = {.lex_state = 1, .external_lex_state = 11},
  [5509] = {.lex_state = 1, .external_lex_state = 11},
  [5510] = {.lex_state = 76, .external_lex_state = 2},
  [5511] = {.lex_state = 76, .external_lex_state = 2},
  [5512] = {.lex_state = 76, .external_lex_state = 2},
  [5513] = {.lex_state = 76, .external_lex_state = 2},
  [5514] = {.lex_state = 76, .external_lex_state = 2},
  [5515] = {.lex_state = 76, .external_lex_state = 2},
  [5516] = {.lex_state = 76, .external_lex_state = 2},
  [5517] = {.lex_state = 76, .external_lex_state = 2},
  [5518] = {.lex_state = 76, .external_lex_state = 2},
  [5519] = {.lex_state = 76, .external_lex_state = 2},
  [5520] = {.lex_state = 76, .external_lex_state = 2},
  [5521] = {.lex_state = 76, .external_lex_state = 2},
  [5522] = {.lex_state = 76, .external_lex_state = 2},
  [5523] = {.lex_state = 76, .external_lex_state = 2},
  [5524] = {.lex_state = 76, .external_lex_state = 2},
  [5525] = {.lex_state = 76, .external_lex_state = 2},
  [5526] = {.lex_state = 76, .external_lex_state = 2},
  [5527] = {.lex_state = 76, .external_lex_state = 2},
  [5528] = {.lex_state = 76, .external_lex_state = 2},
  [5529] = {.lex_state = 76, .external_lex_state = 2},
  [5530] = {.lex_state = 76, .external_lex_state = 2},
  [5531] = {.lex_state = 76, .external_lex_state = 2},
  [5532] = {.lex_state = 76, .external_lex_state = 2},
  [5533] = {.lex_state = 76, .external_lex_state = 2},
  [5534] = {.lex_state = 76, .external_lex_state = 2},
  [5535] = {.lex_state = 76, .external_lex_state = 2},
  [5536] = {.lex_state = 76, .external_lex_state = 2},
  [5537] = {.lex_state = 76, .external_lex_state = 2},
  [5538] = {.lex_state = 76, .external_lex_state = 2},
  [5539] = {.lex_state = 76, .external_lex_state = 2},
  [5540] = {.lex_state = 76, .external_lex_state = 2},
  [5541] = {.lex_state = 76, .external_lex_state = 2},
  [5542] = {.lex_state = 76, .external_lex_state = 2},
  [5543] = {.lex_state = 76, .external_lex_state = 2},
  [5544] = {.lex_state = 76, .external_lex_state = 2},
  [5545] = {.lex_state = 76, .external_lex_state = 2},
  [5546] = {.lex_state = 76, .external_lex_state = 2},
  [5547] = {.lex_state = 76, .external_lex_state = 2},
  [5548] = {.lex_state = 76, .external_lex_state = 2},
  [5549] = {.lex_state = 23, .external_lex_state = 2},
  [5550] = {.lex_state = 1, .external_lex_state = 11},
  [5551] = {.lex_state = 76, .external_lex_state = 2},
  [5552] = {.lex_state = 76, .external_lex_state = 2},
  [5553] = {.lex_state = 76, .external_lex_state = 2},
  [5554] = {.lex_state = 76, .external_lex_state = 2},
  [5555] = {.lex_state = 76, .external_lex_state = 2},
  [5556] = {.lex_state = 76, .external_lex_state = 2},
  [5557] = {.lex_state = 76, .external_lex_state = 2},
  [5558] = {.lex_state = 76, .external_lex_state = 2},
  [5559] = {.lex_state = 23, .external_lex_state = 2},
  [5560] = {.lex_state = 76, .external_lex_state = 2},
  [5561] = {.lex_state = 76, .external_lex_state = 2},
  [5562] = {.lex_state = 76, .external_lex_state = 2},
  [5563] = {.lex_state = 76, .external_lex_state = 2},
  [5564] = {.lex_state = 76, .external_lex_state = 2},
  [5565] = {.lex_state = 76, .external_lex_state = 2},
  [5566] = {.lex_state = 76, .external_lex_state = 2},
  [5567] = {.lex_state = 76, .external_lex_state = 2},
  [5568] = {.lex_state = 76, .external_lex_state = 2},
  [5569] = {.lex_state = 76, .external_lex_state = 2},
  [5570] = {.lex_state = 76, .external_lex_state = 2},
  [5571] = {.lex_state = 76, .external_lex_state = 2},
  [5572] = {.lex_state = 76, .external_lex_state = 2},
  [5573] = {.lex_state = 76, .external_lex_state = 2},
  [5574] = {.lex_state = 76, .external_lex_state = 2},
  [5575] = {.lex_state = 76, .external_lex_state = 2},
  [5576] = {.lex_state = 76, .external_lex_state = 2},
  [5577] = {.lex_state = 76, .external_lex_state = 2},
  [5578] = {.lex_state = 76, .external_lex_state = 2},
  [5579] = {.lex_state = 76, .external_lex_state = 2},
  [5580] = {.lex_state = 76, .external_lex_state = 2},
  [5581] = {.lex_state = 76, .external_lex_state = 2},
  [5582] = {.lex_state = 76, .external_lex_state = 2},
  [5583] = {.lex_state = 76, .external_lex_state = 2},
  [5584] = {.lex_state = 76, .external_lex_state = 2},
  [5585] = {.lex_state = 76, .external_lex_state = 2},
  [5586] = {.lex_state = 76, .external_lex_state = 2},
  [5587] = {.lex_state = 76, .external_lex_state = 2},
  [5588] = {.lex_state = 76, .external_lex_state = 2},
  [5589] = {.lex_state = 76, .external_lex_state = 2},
  [5590] = {.lex_state = 23, .external_lex_state = 2},
  [5591] = {.lex_state = 76, .external_lex_state = 2},
  [5592] = {.lex_state = 76, .external_lex_state = 2},
  [5593] = {.lex_state = 76, .external_lex_state = 2},
  [5594] = {.lex_state = 76, .external_lex_state = 2},
  [5595] = {.lex_state = 76, .external_lex_state = 2},
  [5596] = {.lex_state = 76, .external_lex_state = 2},
  [5597] = {.lex_state = 76, .external_lex_state = 2},
  [5598] = {.lex_state = 76, .external_lex_state = 2},
  [5599] = {.lex_state = 76, .external_lex_state = 2},
  [5600] = {.lex_state = 76, .external_lex_state = 2},
  [5601] = {.lex_state = 76, .external_lex_state = 2},
  [5602] = {.lex_state = 76, .external_lex_state = 2},
  [5603] = {.lex_state = 76, .external_lex_state = 2},
  [5604] = {.lex_state = 76, .external_lex_state = 2},
  [5605] = {.lex_state = 76, .external_lex_state = 2},
  [5606] = {.lex_state = 76, .external_lex_state = 2},
  [5607] = {.lex_state = 76, .external_lex_state = 2},
  [5608] = {.lex_state = 76, .external_lex_state = 2},
  [5609] = {.lex_state = 76, .external_lex_state = 2},
  [5610] = {.lex_state = 76, .external_lex_state = 2},
  [5611] = {.lex_state = 76, .external_lex_state = 2},
  [5612] = {.lex_state = 76, .external_lex_state = 2},
  [5613] = {.lex_state = 1, .external_lex_state = 11},
  [5614] = {.lex_state = 76, .external_lex_state = 2},
  [5615] = {.lex_state = 76, .external_lex_state = 2},
  [5616] = {.lex_state = 76, .external_lex_state = 2},
  [5617] = {.lex_state = 76, .external_lex_state = 2},
  [5618] = {.lex_state = 76, .external_lex_state = 2},
  [5619] = {.lex_state = 76, .external_lex_state = 2},
  [5620] = {.lex_state = 76, .external_lex_state = 2},
  [5621] = {.lex_state = 76, .external_lex_state = 2},
  [5622] = {.lex_state = 76, .external_lex_state = 2},
  [5623] = {.lex_state = 76, .external_lex_state = 2},
  [5624] = {.lex_state = 76, .external_lex_state = 2},
  [5625] = {.lex_state = 76, .external_lex_state = 2},
  [5626] = {.lex_state = 76, .external_lex_state = 2},
  [5627] = {.lex_state = 76, .external_lex_state = 2},
  [5628] = {.lex_state = 76, .external_lex_state = 2},
  [5629] = {.lex_state = 76, .external_lex_state = 2},
  [5630] = {.lex_state = 76, .external_lex_state = 2},
  [5631] = {.lex_state = 76, .external_lex_state = 2},
  [5632] = {.lex_state = 76, .external_lex_state = 2},
  [5633] = {.lex_state = 76, .external_lex_state = 2},
  [5634] = {.lex_state = 76, .external_lex_state = 2},
  [5635] = {.lex_state = 76, .external_lex_state = 2},
  [5636] = {.lex_state = 76, .external_lex_state = 2},
  [5637] = {.lex_state = 76, .external_lex_state = 2},
  [5638] = {.lex_state = 76, .external_lex_state = 2},
  [5639] = {.lex_state = 76, .external_lex_state = 2},
  [5640] = {.lex_state = 76, .external_lex_state = 2},
  [5641] = {.lex_state = 76, .external_lex_state = 2},
  [5642] = {.lex_state = 76, .external_lex_state = 2},
  [5643] = {.lex_state = 76, .external_lex_state = 2},
  [5644] = {.lex_state = 76, .external_lex_state = 2},
  [5645] = {.lex_state = 76, .external_lex_state = 2},
  [5646] = {.lex_state = 76, .external_lex_state = 2},
  [5647] = {.lex_state = 76, .external_lex_state = 2},
  [5648] = {.lex_state = 76, .external_lex_state = 2},
  [5649] = {.lex_state = 76, .external_lex_state = 2},
  [5650] = {.lex_state = 76, .external_lex_state = 2},
  [5651] = {.lex_state = 76, .external_lex_state = 2},
  [5652] = {.lex_state = 76, .external_lex_state = 2},
  [5653] = {.lex_state = 76, .external_lex_state = 2},
  [5654] = {.lex_state = 76, .external_lex_state = 2},
  [5655] = {.lex_state = 76, .external_lex_state = 2},
  [5656] = {.lex_state = 76, .external_lex_state = 2},
  [5657] = {.lex_state = 76, .external_lex_state = 2},
  [5658] = {.lex_state = 76, .external_lex_state = 2},
  [5659] = {.lex_state = 76, .external_lex_state = 2},
  [5660] = {.lex_state = 1, .external_lex_state = 11},
  [5661] = {.lex_state = 76, .external_lex_state = 2},
  [5662] = {.lex_state = 76, .external_lex_state = 2},
  [5663] = {.lex_state = 76, .external_lex_state = 2},
  [5664] = {.lex_state = 76, .external_lex_state = 2},
  [5665] = {.lex_state = 76, .external_lex_state = 2},
  [5666] = {.lex_state = 76, .external_lex_state = 2},
  [5667] = {.lex_state = 76, .external_lex_state = 2},
  [5668] = {.lex_state = 76, .external_lex_state = 2},
  [5669] = {.lex_state = 76, .external_lex_state = 2},
  [5670] = {.lex_state = 76, .external_lex_state = 2},
  [5671] = {.lex_state = 76, .external_lex_state = 2},
  [5672] = {.lex_state = 76, .external_lex_state = 2},
  [5673] = {.lex_state = 76, .external_lex_state = 2},
  [5674] = {.lex_state = 76, .external_lex_state = 2},
  [5675] = {.lex_state = 76, .external_lex_state = 2},
  [5676] = {.lex_state = 76, .external_lex_state = 2},
  [5677] = {.lex_state = 76, .external_lex_state = 2},
  [5678] = {.lex_state = 76, .external_lex_state = 2},
  [5679] = {.lex_state = 76, .external_lex_state = 2},
  [5680] = {.lex_state = 76, .external_lex_state = 2},
  [5681] = {.lex_state = 76, .external_lex_state = 2},
  [5682] = {.lex_state = 76, .external_lex_state = 2},
  [5683] = {.lex_state = 76, .external_lex_state = 2},
  [5684] = {.lex_state = 76, .external_lex_state = 2},
  [5685] = {.lex_state = 76, .external_lex_state = 2},
  [5686] = {.lex_state = 76, .external_lex_state = 2},
  [5687] = {.lex_state = 76, .external_lex_state = 2},
  [5688] = {.lex_state = 76, .external_lex_state = 2},
  [5689] = {.lex_state = 76, .external_lex_state = 2},
  [5690] = {.lex_state = 76, .external_lex_state = 2},
  [5691] = {.lex_state = 76, .external_lex_state = 2},
  [5692] = {.lex_state = 76, .external_lex_state = 2},
  [5693] = {.lex_state = 76, .external_lex_state = 2},
  [5694] = {.lex_state = 76, .external_lex_state = 2},
  [5695] = {.lex_state = 76, .external_lex_state = 2},
  [5696] = {.lex_state = 76, .external_lex_state = 2},
  [5697] = {.lex_state = 76, .external_lex_state = 2},
  [5698] = {.lex_state = 76, .external_lex_state = 2},
  [5699] = {.lex_state = 76, .external_lex_state = 2},
  [5700] = {.lex_state = 76, .external_lex_state = 2},
  [5701] = {.lex_state = 76, .external_lex_state = 2},
  [5702] = {.lex_state = 76, .external_lex_state = 2},
  [5703] = {.lex_state = 76, .external_lex_state = 2},
  [5704] = {.lex_state = 76, .external_lex_state = 2},
  [5705] = {.lex_state = 76, .external_lex_state = 2},
  [5706] = {.lex_state = 76, .external_lex_state = 2},
  [5707] = {.lex_state = 76, .external_lex_state = 2},
  [5708] = {.lex_state = 76, .external_lex_state = 2},
  [5709] = {.lex_state = 76, .external_lex_state = 2},
  [5710] = {.lex_state = 76, .external_lex_state = 2},
  [5711] = {.lex_state = 76, .external_lex_state = 2},
  [5712] = {.lex_state = 76, .external_lex_state = 2},
  [5713] = {.lex_state = 23, .external_lex_state = 2},
  [5714] = {.lex_state = 76, .external_lex_state = 2},
  [5715] = {.lex_state = 76, .external_lex_state = 2},
  [5716] = {.lex_state = 76, .external_lex_state = 2},
  [5717] = {.lex_state = 76, .external_lex_state = 2},
  [5718] = {.lex_state = 76, .external_lex_state = 2},
  [5719] = {.lex_state = 23, .external_lex_state = 2},
  [5720] = {.lex_state = 76, .external_lex_state = 2},
  [5721] = {.lex_state = 76, .external_lex_state = 2},
  [5722] = {.lex_state = 76, .external_lex_state = 2},
  [5723] = {.lex_state = 76, .external_lex_state = 2},
  [5724] = {.lex_state = 76, .external_lex_state = 2},
  [5725] = {.lex_state = 76, .external_lex_state = 2},
  [5726] = {.lex_state = 76, .external_lex_state = 2},
  [5727] = {.lex_state = 76, .external_lex_state = 2},
  [5728] = {.lex_state = 76, .external_lex_state = 2},
  [5729] = {.lex_state = 76, .external_lex_state = 2},
  [5730] = {.lex_state = 76, .external_lex_state = 2},
  [5731] = {.lex_state = 76, .external_lex_state = 2},
  [5732] = {.lex_state = 76, .external_lex_state = 2},
  [5733] = {.lex_state = 76, .external_lex_state = 2},
  [5734] = {.lex_state = 76, .external_lex_state = 2},
  [5735] = {.lex_state = 76, .external_lex_state = 2},
  [5736] = {.lex_state = 76, .external_lex_state = 2},
  [5737] = {.lex_state = 76, .external_lex_state = 2},
  [5738] = {.lex_state = 76, .external_lex_state = 2},
  [5739] = {.lex_state = 76, .external_lex_state = 2},
  [5740] = {.lex_state = 76, .external_lex_state = 2},
  [5741] = {.lex_state = 76, .external_lex_state = 2},
  [5742] = {.lex_state = 76, .external_lex_state = 2},
  [5743] = {.lex_state = 76, .external_lex_state = 2},
  [5744] = {.lex_state = 76, .external_lex_state = 2},
  [5745] = {.lex_state = 76, .external_lex_state = 2},
  [5746] = {.lex_state = 76, .external_lex_state = 2},
  [5747] = {.lex_state = 76, .external_lex_state = 2},
  [5748] = {.lex_state = 76, .external_lex_state = 2},
  [5749] = {.lex_state = 76, .external_lex_state = 2},
  [5750] = {.lex_state = 76, .external_lex_state = 2},
  [5751] = {.lex_state = 76, .external_lex_state = 2},
  [5752] = {.lex_state = 76, .external_lex_state = 2},
  [5753] = {.lex_state = 76, .external_lex_state = 2},
  [5754] = {.lex_state = 76, .external_lex_state = 2},
  [5755] = {.lex_state = 76, .external_lex_state = 2},
  [5756] = {.lex_state = 76, .external_lex_state = 2},
  [5757] = {.lex_state = 76, .external_lex_state = 2},
  [5758] = {.lex_state = 76, .external_lex_state = 2},
  [5759] = {.lex_state = 76, .external_lex_state = 2},
  [5760] = {.lex_state = 76, .external_lex_state = 2},
  [5761] = {.lex_state = 76, .external_lex_state = 2},
  [5762] = {.lex_state = 76, .external_lex_state = 2},
  [5763] = {.lex_state = 76, .external_lex_state = 2},
  [5764] = {.lex_state = 76, .external_lex_state = 2},
  [5765] = {.lex_state = 76, .external_lex_state = 2},
  [5766] = {.lex_state = 76, .external_lex_state = 2},
  [5767] = {.lex_state = 76, .external_lex_state = 2},
  [5768] = {.lex_state = 76, .external_lex_state = 2},
  [5769] = {.lex_state = 76, .external_lex_state = 2},
  [5770] = {.lex_state = 76, .external_lex_state = 2},
  [5771] = {.lex_state = 76, .external_lex_state = 2},
  [5772] = {.lex_state = 76, .external_lex_state = 2},
  [5773] = {.lex_state = 76, .external_lex_state = 2},
  [5774] = {.lex_state = 76, .external_lex_state = 2},
  [5775] = {.lex_state = 76, .external_lex_state = 2},
  [5776] = {.lex_state = 76, .external_lex_state = 2},
  [5777] = {.lex_state = 76, .external_lex_state = 2},
  [5778] = {.lex_state = 76, .external_lex_state = 2},
  [5779] = {.lex_state = 76, .external_lex_state = 2},
  [5780] = {.lex_state = 76, .external_lex_state = 2},
  [5781] = {.lex_state = 76, .external_lex_state = 2},
  [5782] = {.lex_state = 76, .external_lex_state = 2},
  [5783] = {.lex_state = 76, .external_lex_state = 2},
  [5784] = {.lex_state = 76, .external_lex_state = 2},
  [5785] = {.lex_state = 76, .external_lex_state = 2},
  [5786] = {.lex_state = 76, .external_lex_state = 2},
  [5787] = {.lex_state = 76, .external_lex_state = 2},
  [5788] = {.lex_state = 76, .external_lex_state = 2},
  [5789] = {.lex_state = 76, .external_lex_state = 2},
  [5790] = {.lex_state = 76, .external_lex_state = 2},
  [5791] = {.lex_state = 76, .external_lex_state = 2},
  [5792] = {.lex_state = 76, .external_lex_state = 2},
  [5793] = {.lex_state = 76, .external_lex_state = 2},
  [5794] = {.lex_state = 76, .external_lex_state = 2},
  [5795] = {.lex_state = 76, .external_lex_state = 2},
  [5796] = {.lex_state = 76, .external_lex_state = 2},
  [5797] = {.lex_state = 76, .external_lex_state = 2},
  [5798] = {.lex_state = 76, .external_lex_state = 2},
  [5799] = {.lex_state = 76, .external_lex_state = 2},
  [5800] = {.lex_state = 76, .external_lex_state = 2},
  [5801] = {.lex_state = 76, .external_lex_state = 2},
  [5802] = {.lex_state = 76, .external_lex_state = 2},
  [5803] = {.lex_state = 76, .external_lex_state = 2},
  [5804] = {.lex_state = 76, .external_lex_state = 2},
  [5805] = {.lex_state = 76, .external_lex_state = 2},
  [5806] = {.lex_state = 76, .external_lex_state = 2},
  [5807] = {.lex_state = 76, .external_lex_state = 2},
  [5808] = {.lex_state = 76, .external_lex_state = 2},
  [5809] = {.lex_state = 76, .external_lex_state = 2},
  [5810] = {.lex_state = 76, .external_lex_state = 2},
  [5811] = {.lex_state = 76, .external_lex_state = 2},
  [5812] = {.lex_state = 76, .external_lex_state = 2},
  [5813] = {.lex_state = 76, .external_lex_state = 2},
  [5814] = {.lex_state = 76, .external_lex_state = 2},
  [5815] = {.lex_state = 76, .external_lex_state = 2},
  [5816] = {.lex_state = 76, .external_lex_state = 2},
  [5817] = {.lex_state = 76, .external_lex_state = 2},
  [5818] = {.lex_state = 76, .external_lex_state = 2},
  [5819] = {.lex_state = 76, .external_lex_state = 2},
  [5820] = {.lex_state = 76, .external_lex_state = 2},
  [5821] = {.lex_state = 76, .external_lex_state = 2},
  [5822] = {.lex_state = 76, .external_lex_state = 2},
  [5823] = {.lex_state = 76, .external_lex_state = 2},
  [5824] = {.lex_state = 76, .external_lex_state = 2},
  [5825] = {.lex_state = 76, .external_lex_state = 2},
  [5826] = {.lex_state = 76, .external_lex_state = 2},
  [5827] = {.lex_state = 76, .external_lex_state = 2},
  [5828] = {.lex_state = 76, .external_lex_state = 2},
  [5829] = {.lex_state = 76, .external_lex_state = 2},
  [5830] = {.lex_state = 76, .external_lex_state = 2},
  [5831] = {.lex_state = 76, .external_lex_state = 2},
  [5832] = {.lex_state = 76, .external_lex_state = 2},
  [5833] = {.lex_state = 76, .external_lex_state = 2},
  [5834] = {.lex_state = 76, .external_lex_state = 2},
  [5835] = {.lex_state = 76, .external_lex_state = 2},
  [5836] = {.lex_state = 76, .external_lex_state = 2},
  [5837] = {.lex_state = 76, .external_lex_state = 2},
  [5838] = {.lex_state = 76, .external_lex_state = 2},
  [5839] = {.lex_state = 76, .external_lex_state = 2},
  [5840] = {.lex_state = 76, .external_lex_state = 2},
  [5841] = {.lex_state = 76, .external_lex_state = 2},
  [5842] = {.lex_state = 76, .external_lex_state = 2},
  [5843] = {.lex_state = 76, .external_lex_state = 2},
  [5844] = {.lex_state = 76, .external_lex_state = 2},
  [5845] = {.lex_state = 76, .external_lex_state = 2},
  [5846] = {.lex_state = 76, .external_lex_state = 2},
  [5847] = {.lex_state = 76, .external_lex_state = 2},
  [5848] = {.lex_state = 76, .external_lex_state = 2},
  [5849] = {.lex_state = 76, .external_lex_state = 2},
  [5850] = {.lex_state = 76, .external_lex_state = 2},
  [5851] = {.lex_state = 76, .external_lex_state = 2},
  [5852] = {.lex_state = 76, .external_lex_state = 2},
  [5853] = {.lex_state = 76, .external_lex_state = 2},
  [5854] = {.lex_state = 76, .external_lex_state = 2},
  [5855] = {.lex_state = 76, .external_lex_state = 2},
  [5856] = {.lex_state = 76, .external_lex_state = 2},
  [5857] = {.lex_state = 76, .external_lex_state = 2},
  [5858] = {.lex_state = 76, .external_lex_state = 2},
  [5859] = {.lex_state = 76, .external_lex_state = 2},
  [5860] = {.lex_state = 76, .external_lex_state = 2},
  [5861] = {.lex_state = 76, .external_lex_state = 2},
  [5862] = {.lex_state = 76, .external_lex_state = 2},
  [5863] = {.lex_state = 76, .external_lex_state = 2},
  [5864] = {.lex_state = 76, .external_lex_state = 2},
  [5865] = {.lex_state = 76, .external_lex_state = 2},
  [5866] = {.lex_state = 76, .external_lex_state = 2},
  [5867] = {.lex_state = 76, .external_lex_state = 2},
  [5868] = {.lex_state = 76, .external_lex_state = 2},
  [5869] = {.lex_state = 76, .external_lex_state = 2},
  [5870] = {.lex_state = 76, .external_lex_state = 2},
  [5871] = {.lex_state = 76, .external_lex_state = 2},
  [5872] = {.lex_state = 76, .external_lex_state = 2},
  [5873] = {.lex_state = 76, .external_lex_state = 2},
  [5874] = {.lex_state = 76, .external_lex_state = 2},
  [5875] = {.lex_state = 76, .external_lex_state = 2},
  [5876] = {.lex_state = 76, .external_lex_state = 2},
  [5877] = {.lex_state = 76, .external_lex_state = 2},
  [5878] = {.lex_state = 76, .external_lex_state = 2},
  [5879] = {.lex_state = 76, .external_lex_state = 2},
  [5880] = {.lex_state = 76, .external_lex_state = 2},
  [5881] = {.lex_state = 76, .external_lex_state = 2},
  [5882] = {.lex_state = 76, .external_lex_state = 2},
  [5883] = {.lex_state = 76, .external_lex_state = 2},
  [5884] = {.lex_state = 76, .external_lex_state = 2},
  [5885] = {.lex_state = 76, .external_lex_state = 2},
  [5886] = {.lex_state = 76, .external_lex_state = 2},
  [5887] = {.lex_state = 76, .external_lex_state = 2},
  [5888] = {.lex_state = 76, .external_lex_state = 2},
  [5889] = {.lex_state = 76, .external_lex_state = 2},
  [5890] = {.lex_state = 76, .external_lex_state = 2},
  [5891] = {.lex_state = 76, .external_lex_state = 2},
  [5892] = {.lex_state = 76, .external_lex_state = 2},
  [5893] = {.lex_state = 76, .external_lex_state = 2},
  [5894] = {.lex_state = 76, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_accessor] = ACTIONS(1),
    [anon_sym_satisfies] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_PLUS_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym_glimmer_template_tag_name] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5657),
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_import] = STATE(3694),
    [sym_parenthesized_expression] = STATE(1226),
    [sym_expression] = STATE(2697),
    [sym_primary_expression] = STATE(1513),
    [sym_yield_expression] = STATE(1675),
    [sym_object] = STATE(1666),
    [sym_object_pattern] = STATE(3728),
    [sym_array] = STATE(1666),
    [sym_array_pattern] = STATE(3728),
    [sym_glimmer_template] = STATE(1675),
    [sym_glimmer_opening_tag] = STATE(4695),
    [sym_nested_identifier] = STATE(5810),
    [sym_class] = STATE(1666),
    [sym_function_expression] = STATE(1666),
    [sym_generator_function] = STATE(1666),
    [sym_arrow_function] = STATE(1666),
    [sym__call_signature] = STATE(5876),
    [sym_call_expression] = STATE(1666),
    [sym_new_expression] = STATE(1613),
    [sym_await_expression] = STATE(1675),
    [sym_member_expression] = STATE(1305),
    [sym_subscript_expression] = STATE(1305),
    [sym_assignment_expression] = STATE(1675),
    [sym__augmented_assignment_lhs] = STATE(3015),
    [sym_augmented_assignment_expression] = STATE(1675),
    [sym__destructuring_pattern] = STATE(3728),
    [sym_ternary_expression] = STATE(1675),
    [sym_binary_expression] = STATE(1675),
    [sym_unary_expression] = STATE(1675),
    [sym_update_expression] = STATE(1675),
    [sym_string] = STATE(2137),
    [sym_template_string] = STATE(1666),
    [sym_regex] = STATE(1666),
    [sym_meta_property] = STATE(1666),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(4371),
    [sym_pattern] = STATE(4311),
    [sym_rest_pattern] = STATE(3605),
    [sym_non_null_expression] = STATE(1305),
    [sym_type_assertion] = STATE(1675),
    [sym_as_expression] = STATE(1675),
    [sym_satisfies_expression] = STATE(1675),
    [sym_instantiation_expression] = STATE(1675),
    [sym_internal_module] = STATE(1675),
    [sym_nested_type_identifier] = STATE(2948),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2949),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2950),
    [sym_type] = STATE(3163),
    [sym_constructor_type] = STATE(3005),
    [sym_primary_type] = STATE(3007),
    [sym_template_literal_type] = STATE(3009),
    [sym_infer_type] = STATE(3005),
    [sym_conditional_type] = STATE(3009),
    [sym_generic_type] = STATE(3009),
    [sym_type_query] = STATE(3009),
    [sym_index_type_query] = STATE(3009),
    [sym_lookup_type] = STATE(3009),
    [sym_literal_type] = STATE(3009),
    [sym__number] = STATE(3033),
    [sym_existential_type] = STATE(3009),
    [sym_flow_maybe_type] = STATE(3009),
    [sym_parenthesized_type] = STATE(3009),
    [sym_predefined_type] = STATE(3009),
    [sym_type_arguments] = STATE(524),
    [sym_object_type] = STATE(3009),
    [sym_type_parameters] = STATE(5458),
    [sym_array_type] = STATE(3009),
    [sym_tuple_type] = STATE(3009),
    [sym_readonly_type] = STATE(3005),
    [sym_union_type] = STATE(3009),
    [sym_intersection_type] = STATE(3009),
    [sym_function_type] = STATE(3005),
    [aux_sym_export_statement_repeat1] = STATE(4480),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_export] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(117),
    [anon_sym_as] = ACTIONS(120),
    [anon_sym_namespace] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(126),
    [anon_sym_typeof] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(113),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_RPAREN] = ACTIONS(126),
    [anon_sym_await] = ACTIONS(140),
    [anon_sym_in] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(126),
    [anon_sym_yield] = ACTIONS(142),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_GT] = ACTIONS(120),
    [anon_sym_DOT] = ACTIONS(120),
    [anon_sym_class] = ACTIONS(148),
    [anon_sym_async] = ACTIONS(150),
    [anon_sym_function] = ACTIONS(152),
    [anon_sym_EQ_GT] = ACTIONS(154),
    [anon_sym_QMARK_DOT] = ACTIONS(156),
    [anon_sym_new] = ACTIONS(158),
    [anon_sym_using] = ACTIONS(160),
    [anon_sym_PLUS_EQ] = ACTIONS(162),
    [anon_sym_DASH_EQ] = ACTIONS(162),
    [anon_sym_STAR_EQ] = ACTIONS(162),
    [anon_sym_SLASH_EQ] = ACTIONS(162),
    [anon_sym_PERCENT_EQ] = ACTIONS(162),
    [anon_sym_CARET_EQ] = ACTIONS(162),
    [anon_sym_AMP_EQ] = ACTIONS(162),
    [anon_sym_PIPE_EQ] = ACTIONS(162),
    [anon_sym_GT_GT_EQ] = ACTIONS(162),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(162),
    [anon_sym_LT_LT_EQ] = ACTIONS(162),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(162),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(162),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(162),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(162),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(164),
    [anon_sym_AMP_AMP] = ACTIONS(120),
    [anon_sym_PIPE_PIPE] = ACTIONS(120),
    [anon_sym_GT_GT] = ACTIONS(120),
    [anon_sym_GT_GT_GT] = ACTIONS(120),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_AMP] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(120),
    [anon_sym_PIPE] = ACTIONS(168),
    [anon_sym_PLUS] = ACTIONS(170),
    [anon_sym_DASH] = ACTIONS(170),
    [anon_sym_SLASH] = ACTIONS(172),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_STAR_STAR] = ACTIONS(120),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(156),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_QMARK_QMARK] = ACTIONS(120),
    [anon_sym_instanceof] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_void] = ACTIONS(177),
    [anon_sym_delete] = ACTIONS(179),
    [anon_sym_PLUS_PLUS] = ACTIONS(181),
    [anon_sym_DASH_DASH] = ACTIONS(181),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(192),
    [sym_this] = ACTIONS(194),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(113),
    [anon_sym_readonly] = ACTIONS(202),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(204),
    [anon_sym_declare] = ACTIONS(113),
    [anon_sym_public] = ACTIONS(113),
    [anon_sym_private] = ACTIONS(113),
    [anon_sym_protected] = ACTIONS(113),
    [anon_sym_override] = ACTIONS(113),
    [anon_sym_module] = ACTIONS(113),
    [anon_sym_any] = ACTIONS(206),
    [anon_sym_number] = ACTIONS(206),
    [anon_sym_boolean] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_symbol] = ACTIONS(206),
    [anon_sym_object] = ACTIONS(206),
    [anon_sym_abstract] = ACTIONS(208),
    [anon_sym_satisfies] = ACTIONS(120),
    [anon_sym_infer] = ACTIONS(210),
    [anon_sym_keyof] = ACTIONS(212),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym__ternary_qmark] = ACTIONS(156),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_import] = STATE(3694),
    [sym_parenthesized_expression] = STATE(1226),
    [sym_expression] = STATE(2697),
    [sym_primary_expression] = STATE(1513),
    [sym_yield_expression] = STATE(1675),
    [sym_object] = STATE(1666),
    [sym_object_pattern] = STATE(3728),
    [sym_array] = STATE(1666),
    [sym_array_pattern] = STATE(3728),
    [sym_glimmer_template] = STATE(1675),
    [sym_glimmer_opening_tag] = STATE(4695),
    [sym_nested_identifier] = STATE(5810),
    [sym_class] = STATE(1666),
    [sym_function_expression] = STATE(1666),
    [sym_generator_function] = STATE(1666),
    [sym_arrow_function] = STATE(1666),
    [sym__call_signature] = STATE(5876),
    [sym_call_expression] = STATE(1666),
    [sym_new_expression] = STATE(1613),
    [sym_await_expression] = STATE(1675),
    [sym_member_expression] = STATE(1305),
    [sym_subscript_expression] = STATE(1305),
    [sym_assignment_expression] = STATE(1675),
    [sym__augmented_assignment_lhs] = STATE(3015),
    [sym_augmented_assignment_expression] = STATE(1675),
    [sym__destructuring_pattern] = STATE(3728),
    [sym_ternary_expression] = STATE(1675),
    [sym_binary_expression] = STATE(1675),
    [sym_unary_expression] = STATE(1675),
    [sym_update_expression] = STATE(1675),
    [sym_string] = STATE(2137),
    [sym_template_string] = STATE(1666),
    [sym_regex] = STATE(1666),
    [sym_meta_property] = STATE(1666),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(4371),
    [sym_pattern] = STATE(4311),
    [sym_rest_pattern] = STATE(3605),
    [sym_non_null_expression] = STATE(1305),
    [sym_type_assertion] = STATE(1675),
    [sym_as_expression] = STATE(1675),
    [sym_satisfies_expression] = STATE(1675),
    [sym_instantiation_expression] = STATE(1675),
    [sym_internal_module] = STATE(1675),
    [sym_nested_type_identifier] = STATE(2948),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2949),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2950),
    [sym_type] = STATE(3163),
    [sym_constructor_type] = STATE(3005),
    [sym_primary_type] = STATE(3007),
    [sym_template_literal_type] = STATE(3009),
    [sym_infer_type] = STATE(3005),
    [sym_conditional_type] = STATE(3009),
    [sym_generic_type] = STATE(3009),
    [sym_type_query] = STATE(3009),
    [sym_index_type_query] = STATE(3009),
    [sym_lookup_type] = STATE(3009),
    [sym_literal_type] = STATE(3009),
    [sym__number] = STATE(3033),
    [sym_existential_type] = STATE(3009),
    [sym_flow_maybe_type] = STATE(3009),
    [sym_parenthesized_type] = STATE(3009),
    [sym_predefined_type] = STATE(3009),
    [sym_type_arguments] = STATE(524),
    [sym_object_type] = STATE(3009),
    [sym_type_parameters] = STATE(5458),
    [sym_array_type] = STATE(3009),
    [sym_tuple_type] = STATE(3009),
    [sym_readonly_type] = STATE(3005),
    [sym_union_type] = STATE(3009),
    [sym_intersection_type] = STATE(3009),
    [sym_function_type] = STATE(3005),
    [aux_sym_export_statement_repeat1] = STATE(4480),
    [sym_identifier] = ACTIONS(111),
    [anon_sym_export] = ACTIONS(113),
    [anon_sym_STAR] = ACTIONS(115),
    [anon_sym_type] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(220),
    [anon_sym_as] = ACTIONS(120),
    [anon_sym_namespace] = ACTIONS(122),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_typeof] = ACTIONS(129),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(113),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_await] = ACTIONS(140),
    [anon_sym_in] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(223),
    [anon_sym_yield] = ACTIONS(142),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_GT] = ACTIONS(120),
    [anon_sym_DOT] = ACTIONS(120),
    [anon_sym_class] = ACTIONS(148),
    [anon_sym_async] = ACTIONS(150),
    [anon_sym_function] = ACTIONS(152),
    [anon_sym_EQ_GT] = ACTIONS(225),
    [anon_sym_QMARK_DOT] = ACTIONS(156),
    [anon_sym_new] = ACTIONS(158),
    [anon_sym_using] = ACTIONS(160),
    [anon_sym_PLUS_EQ] = ACTIONS(162),
    [anon_sym_DASH_EQ] = ACTIONS(162),
    [anon_sym_STAR_EQ] = ACTIONS(162),
    [anon_sym_SLASH_EQ] = ACTIONS(162),
    [anon_sym_PERCENT_EQ] = ACTIONS(162),
    [anon_sym_CARET_EQ] = ACTIONS(162),
    [anon_sym_AMP_EQ] = ACTIONS(162),
    [anon_sym_PIPE_EQ] = ACTIONS(162),
    [anon_sym_GT_GT_EQ] = ACTIONS(162),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(162),
    [anon_sym_LT_LT_EQ] = ACTIONS(162),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(162),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(162),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(162),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(162),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(164),
    [anon_sym_AMP_AMP] = ACTIONS(120),
    [anon_sym_PIPE_PIPE] = ACTIONS(120),
    [anon_sym_GT_GT] = ACTIONS(120),
    [anon_sym_GT_GT_GT] = ACTIONS(120),
    [anon_sym_LT_LT] = ACTIONS(120),
    [anon_sym_AMP] = ACTIONS(166),
    [anon_sym_CARET] = ACTIONS(120),
    [anon_sym_PIPE] = ACTIONS(168),
    [anon_sym_PLUS] = ACTIONS(170),
    [anon_sym_DASH] = ACTIONS(170),
    [anon_sym_SLASH] = ACTIONS(172),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_STAR_STAR] = ACTIONS(120),
    [anon_sym_LT_EQ] = ACTIONS(156),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(156),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(156),
    [anon_sym_GT_EQ] = ACTIONS(156),
    [anon_sym_QMARK_QMARK] = ACTIONS(120),
    [anon_sym_instanceof] = ACTIONS(120),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_void] = ACTIONS(177),
    [anon_sym_delete] = ACTIONS(179),
    [anon_sym_PLUS_PLUS] = ACTIONS(181),
    [anon_sym_DASH_DASH] = ACTIONS(181),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(192),
    [sym_this] = ACTIONS(194),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(200),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(113),
    [anon_sym_readonly] = ACTIONS(202),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
    [anon_sym_QMARK] = ACTIONS(204),
    [anon_sym_declare] = ACTIONS(113),
    [anon_sym_public] = ACTIONS(113),
    [anon_sym_private] = ACTIONS(113),
    [anon_sym_protected] = ACTIONS(113),
    [anon_sym_override] = ACTIONS(113),
    [anon_sym_module] = ACTIONS(113),
    [anon_sym_any] = ACTIONS(206),
    [anon_sym_number] = ACTIONS(206),
    [anon_sym_boolean] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_symbol] = ACTIONS(206),
    [anon_sym_object] = ACTIONS(206),
    [anon_sym_abstract] = ACTIONS(208),
    [anon_sym_satisfies] = ACTIONS(120),
    [anon_sym_infer] = ACTIONS(210),
    [anon_sym_keyof] = ACTIONS(212),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym__ternary_qmark] = ACTIONS(156),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5604),
    [sym_object_assignment_pattern] = STATE(4884),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5604),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5604),
    [sym_spread_element] = STATE(4943),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2226),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_rest_pattern] = STATE(4884),
    [sym_method_definition] = STATE(4943),
    [sym_pair] = STATE(4943),
    [sym_pair_pattern] = STATE(4884),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_accessibility_modifier] = STATE(2788),
    [sym_override_modifier] = STATE(2820),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [aux_sym_object_repeat1] = STATE(4596),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5604),
    [sym_object_assignment_pattern] = STATE(4884),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5604),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5604),
    [sym_spread_element] = STATE(4943),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2226),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_rest_pattern] = STATE(4884),
    [sym_method_definition] = STATE(4943),
    [sym_pair] = STATE(4943),
    [sym_pair_pattern] = STATE(4884),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_accessibility_modifier] = STATE(2788),
    [sym_override_modifier] = STATE(2820),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [aux_sym_object_repeat1] = STATE(4596),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5604),
    [sym_object_assignment_pattern] = STATE(4884),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5604),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5604),
    [sym_spread_element] = STATE(4774),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2226),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_rest_pattern] = STATE(4884),
    [sym_method_definition] = STATE(4774),
    [sym_pair] = STATE(4774),
    [sym_pair_pattern] = STATE(4884),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_accessibility_modifier] = STATE(2788),
    [sym_override_modifier] = STATE(2820),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [aux_sym_object_repeat1] = STATE(4779),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(273),
    [anon_sym_export] = ACTIONS(275),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(277),
    [anon_sym_namespace] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(283),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(285),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(287),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(289),
    [anon_sym_readonly] = ACTIONS(291),
    [anon_sym_get] = ACTIONS(293),
    [anon_sym_set] = ACTIONS(293),
    [anon_sym_declare] = ACTIONS(295),
    [anon_sym_public] = ACTIONS(297),
    [anon_sym_private] = ACTIONS(297),
    [anon_sym_protected] = ACTIONS(297),
    [anon_sym_override] = ACTIONS(299),
    [anon_sym_module] = ACTIONS(301),
    [anon_sym_any] = ACTIONS(303),
    [anon_sym_number] = ACTIONS(303),
    [anon_sym_boolean] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_symbol] = ACTIONS(303),
    [anon_sym_object] = ACTIONS(303),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5604),
    [sym_object_assignment_pattern] = STATE(4884),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5604),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5604),
    [sym_spread_element] = STATE(4943),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2226),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_rest_pattern] = STATE(4884),
    [sym_method_definition] = STATE(4943),
    [sym_pair] = STATE(4943),
    [sym_pair_pattern] = STATE(4884),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_accessibility_modifier] = STATE(2788),
    [sym_override_modifier] = STATE(2820),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [aux_sym_object_repeat1] = STATE(4596),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(227),
    [anon_sym_export] = ACTIONS(229),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(233),
    [anon_sym_namespace] = ACTIONS(235),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(305),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(241),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(245),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(247),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(269),
    [anon_sym_number] = ACTIONS(269),
    [anon_sym_boolean] = ACTIONS(269),
    [anon_sym_string] = ACTIONS(269),
    [anon_sym_symbol] = ACTIONS(269),
    [anon_sym_object] = ACTIONS(269),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5604),
    [sym_object_assignment_pattern] = STATE(4884),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5604),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5604),
    [sym_spread_element] = STATE(4774),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2226),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_rest_pattern] = STATE(4884),
    [sym_method_definition] = STATE(4774),
    [sym_pair] = STATE(4774),
    [sym_pair_pattern] = STATE(4884),
    [sym__property_name] = STATE(3705),
    [sym_computed_property_name] = STATE(3705),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_accessibility_modifier] = STATE(2788),
    [sym_override_modifier] = STATE(2820),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [aux_sym_object_repeat1] = STATE(4779),
    [aux_sym_object_pattern_repeat1] = STATE(4622),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_export] = ACTIONS(309),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_type] = ACTIONS(311),
    [anon_sym_namespace] = ACTIONS(313),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(315),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(243),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(317),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(319),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(251),
    [sym_private_property_identifier] = ACTIONS(253),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(321),
    [anon_sym_readonly] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(325),
    [anon_sym_set] = ACTIONS(325),
    [anon_sym_declare] = ACTIONS(327),
    [anon_sym_public] = ACTIONS(329),
    [anon_sym_private] = ACTIONS(329),
    [anon_sym_protected] = ACTIONS(329),
    [anon_sym_override] = ACTIONS(331),
    [anon_sym_module] = ACTIONS(333),
    [anon_sym_any] = ACTIONS(335),
    [anon_sym_number] = ACTIONS(335),
    [anon_sym_boolean] = ACTIONS(335),
    [anon_sym_string] = ACTIONS(335),
    [anon_sym_symbol] = ACTIONS(335),
    [anon_sym_object] = ACTIONS(335),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [ts_builtin_sym_end] = ACTIONS(337),
    [sym_identifier] = ACTIONS(339),
    [anon_sym_export] = ACTIONS(342),
    [anon_sym_default] = ACTIONS(345),
    [anon_sym_type] = ACTIONS(347),
    [anon_sym_namespace] = ACTIONS(350),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_typeof] = ACTIONS(356),
    [anon_sym_import] = ACTIONS(359),
    [anon_sym_with] = ACTIONS(362),
    [anon_sym_var] = ACTIONS(365),
    [anon_sym_let] = ACTIONS(368),
    [anon_sym_const] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_switch] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_await] = ACTIONS(392),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_do] = ACTIONS(398),
    [anon_sym_try] = ACTIONS(401),
    [anon_sym_break] = ACTIONS(404),
    [anon_sym_continue] = ACTIONS(407),
    [anon_sym_debugger] = ACTIONS(410),
    [anon_sym_return] = ACTIONS(413),
    [anon_sym_throw] = ACTIONS(416),
    [anon_sym_case] = ACTIONS(345),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_LT] = ACTIONS(425),
    [anon_sym_class] = ACTIONS(428),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(437),
    [anon_sym_using] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(356),
    [anon_sym_DASH] = ACTIONS(356),
    [anon_sym_SLASH] = ACTIONS(443),
    [anon_sym_TILDE] = ACTIONS(374),
    [anon_sym_void] = ACTIONS(356),
    [anon_sym_delete] = ACTIONS(356),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(452),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [sym_number] = ACTIONS(458),
    [sym_private_property_identifier] = ACTIONS(461),
    [sym_this] = ACTIONS(464),
    [sym_super] = ACTIONS(464),
    [sym_true] = ACTIONS(464),
    [sym_false] = ACTIONS(464),
    [sym_null] = ACTIONS(464),
    [sym_undefined] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_readonly] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [anon_sym_declare] = ACTIONS(476),
    [anon_sym_public] = ACTIONS(473),
    [anon_sym_private] = ACTIONS(473),
    [anon_sym_protected] = ACTIONS(473),
    [anon_sym_override] = ACTIONS(473),
    [anon_sym_module] = ACTIONS(479),
    [anon_sym_any] = ACTIONS(473),
    [anon_sym_number] = ACTIONS(473),
    [anon_sym_boolean] = ACTIONS(473),
    [anon_sym_string] = ACTIONS(473),
    [anon_sym_symbol] = ACTIONS(473),
    [anon_sym_object] = ACTIONS(473),
    [anon_sym_abstract] = ACTIONS(482),
    [anon_sym_interface] = ACTIONS(485),
    [anon_sym_enum] = ACTIONS(488),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(491),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(491),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(10),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(495),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(499),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(503),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(503),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [ts_builtin_sym_end] = ACTIONS(507),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(25),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(30),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(30),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(27),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(27),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(4714),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_import] = STATE(3710),
    [sym_parenthesized_expression] = STATE(1327),
    [sym_expression] = STATE(2182),
    [sym_primary_expression] = STATE(1513),
    [sym_yield_expression] = STATE(1675),
    [sym_object] = STATE(1666),
    [sym_object_pattern] = STATE(4435),
    [sym_assignment_pattern] = STATE(5001),
    [sym_array] = STATE(1666),
    [sym_array_pattern] = STATE(4435),
    [sym_glimmer_template] = STATE(1675),
    [sym_glimmer_opening_tag] = STATE(4695),
    [sym_nested_identifier] = STATE(5810),
    [sym_class] = STATE(1666),
    [sym_function_expression] = STATE(1666),
    [sym_generator_function] = STATE(1666),
    [sym_arrow_function] = STATE(1666),
    [sym__call_signature] = STATE(5664),
    [sym_call_expression] = STATE(1666),
    [sym_new_expression] = STATE(1613),
    [sym_await_expression] = STATE(1675),
    [sym_member_expression] = STATE(1382),
    [sym_subscript_expression] = STATE(1382),
    [sym_assignment_expression] = STATE(1675),
    [sym__augmented_assignment_lhs] = STATE(3052),
    [sym_augmented_assignment_expression] = STATE(1675),
    [sym__destructuring_pattern] = STATE(4435),
    [sym_spread_element] = STATE(4860),
    [sym_ternary_expression] = STATE(1675),
    [sym_binary_expression] = STATE(1675),
    [sym_unary_expression] = STATE(1675),
    [sym_update_expression] = STATE(1675),
    [sym_string] = STATE(2137),
    [sym_template_string] = STATE(1666),
    [sym_regex] = STATE(1666),
    [sym_meta_property] = STATE(1666),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(4331),
    [sym_pattern] = STATE(4424),
    [sym_rest_pattern] = STATE(4171),
    [sym_non_null_expression] = STATE(1382),
    [sym_type_assertion] = STATE(1675),
    [sym_as_expression] = STATE(1675),
    [sym_satisfies_expression] = STATE(1675),
    [sym_instantiation_expression] = STATE(1675),
    [sym_internal_module] = STATE(1675),
    [sym_nested_type_identifier] = STATE(2948),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3319),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2950),
    [sym_type] = STATE(3909),
    [sym_tuple_parameter] = STATE(5022),
    [sym_optional_tuple_parameter] = STATE(5022),
    [sym_optional_type] = STATE(5022),
    [sym_rest_type] = STATE(5022),
    [sym__tuple_type_member] = STATE(5022),
    [sym_constructor_type] = STATE(3005),
    [sym_primary_type] = STATE(3007),
    [sym_template_literal_type] = STATE(3009),
    [sym_infer_type] = STATE(3005),
    [sym_conditional_type] = STATE(3009),
    [sym_generic_type] = STATE(3009),
    [sym_type_query] = STATE(3009),
    [sym_index_type_query] = STATE(3009),
    [sym_lookup_type] = STATE(3009),
    [sym_literal_type] = STATE(3009),
    [sym__number] = STATE(3033),
    [sym_existential_type] = STATE(3009),
    [sym_flow_maybe_type] = STATE(3009),
    [sym_parenthesized_type] = STATE(3009),
    [sym_predefined_type] = STATE(3009),
    [sym_type_arguments] = STATE(463),
    [sym_object_type] = STATE(3009),
    [sym_type_parameters] = STATE(5471),
    [sym_array_type] = STATE(3009),
    [sym_tuple_type] = STATE(3009),
    [sym_readonly_type] = STATE(3005),
    [sym_union_type] = STATE(3009),
    [sym_intersection_type] = STATE(3009),
    [sym_function_type] = STATE(3005),
    [aux_sym_export_statement_repeat1] = STATE(4480),
    [aux_sym_array_repeat1] = STATE(4866),
    [aux_sym_array_pattern_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(573),
    [anon_sym_export] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(577),
    [anon_sym_type] = ACTIONS(575),
    [anon_sym_namespace] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(583),
    [anon_sym_typeof] = ACTIONS(585),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(575),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(587),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(589),
    [anon_sym_yield] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(593),
    [anon_sym_RBRACK] = ACTIONS(595),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(148),
    [anon_sym_async] = ACTIONS(597),
    [anon_sym_function] = ACTIONS(152),
    [anon_sym_new] = ACTIONS(599),
    [anon_sym_using] = ACTIONS(601),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(603),
    [anon_sym_AMP] = ACTIONS(605),
    [anon_sym_PIPE] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(609),
    [anon_sym_SLASH] = ACTIONS(611),
    [anon_sym_TILDE] = ACTIONS(587),
    [anon_sym_void] = ACTIONS(613),
    [anon_sym_delete] = ACTIONS(615),
    [anon_sym_PLUS_PLUS] = ACTIONS(617),
    [anon_sym_DASH_DASH] = ACTIONS(617),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(619),
    [sym_this] = ACTIONS(621),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(575),
    [anon_sym_readonly] = ACTIONS(625),
    [anon_sym_get] = ACTIONS(575),
    [anon_sym_set] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(627),
    [anon_sym_declare] = ACTIONS(575),
    [anon_sym_public] = ACTIONS(575),
    [anon_sym_private] = ACTIONS(575),
    [anon_sym_protected] = ACTIONS(575),
    [anon_sym_override] = ACTIONS(575),
    [anon_sym_module] = ACTIONS(575),
    [anon_sym_any] = ACTIONS(629),
    [anon_sym_number] = ACTIONS(629),
    [anon_sym_boolean] = ACTIONS(629),
    [anon_sym_string] = ACTIONS(629),
    [anon_sym_symbol] = ACTIONS(629),
    [anon_sym_object] = ACTIONS(629),
    [anon_sym_abstract] = ACTIONS(631),
    [anon_sym_infer] = ACTIONS(633),
    [anon_sym_keyof] = ACTIONS(635),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(856),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(898),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(801),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(875),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(913),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(914),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(915),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(923),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(924),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(925),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(926),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(812),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(828),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(828),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(856),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(875),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(812),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(825),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_import] = STATE(3710),
    [sym_parenthesized_expression] = STATE(1327),
    [sym_expression] = STATE(2318),
    [sym_primary_expression] = STATE(1513),
    [sym_yield_expression] = STATE(1675),
    [sym_object] = STATE(1666),
    [sym_object_pattern] = STATE(4435),
    [sym_assignment_pattern] = STATE(5001),
    [sym_array] = STATE(1666),
    [sym_array_pattern] = STATE(4435),
    [sym_glimmer_template] = STATE(1675),
    [sym_glimmer_opening_tag] = STATE(4695),
    [sym_nested_identifier] = STATE(5810),
    [sym_class] = STATE(1666),
    [sym_function_expression] = STATE(1666),
    [sym_generator_function] = STATE(1666),
    [sym_arrow_function] = STATE(1666),
    [sym__call_signature] = STATE(5664),
    [sym_call_expression] = STATE(1666),
    [sym_new_expression] = STATE(1613),
    [sym_await_expression] = STATE(1675),
    [sym_member_expression] = STATE(1382),
    [sym_subscript_expression] = STATE(1382),
    [sym_assignment_expression] = STATE(1675),
    [sym__augmented_assignment_lhs] = STATE(3052),
    [sym_augmented_assignment_expression] = STATE(1675),
    [sym__destructuring_pattern] = STATE(4435),
    [sym_spread_element] = STATE(5003),
    [sym_ternary_expression] = STATE(1675),
    [sym_binary_expression] = STATE(1675),
    [sym_unary_expression] = STATE(1675),
    [sym_update_expression] = STATE(1675),
    [sym_string] = STATE(2137),
    [sym_template_string] = STATE(1666),
    [sym_regex] = STATE(1666),
    [sym_meta_property] = STATE(1666),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(4331),
    [sym_pattern] = STATE(4424),
    [sym_rest_pattern] = STATE(4171),
    [sym_non_null_expression] = STATE(1382),
    [sym_type_assertion] = STATE(1675),
    [sym_as_expression] = STATE(1675),
    [sym_satisfies_expression] = STATE(1675),
    [sym_instantiation_expression] = STATE(1675),
    [sym_internal_module] = STATE(1675),
    [sym_nested_type_identifier] = STATE(2948),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3319),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2950),
    [sym_type] = STATE(3909),
    [sym_tuple_parameter] = STATE(5127),
    [sym_optional_tuple_parameter] = STATE(5127),
    [sym_optional_type] = STATE(5127),
    [sym_rest_type] = STATE(5127),
    [sym__tuple_type_member] = STATE(5127),
    [sym_constructor_type] = STATE(3005),
    [sym_primary_type] = STATE(3007),
    [sym_template_literal_type] = STATE(3009),
    [sym_infer_type] = STATE(3005),
    [sym_conditional_type] = STATE(3009),
    [sym_generic_type] = STATE(3009),
    [sym_type_query] = STATE(3009),
    [sym_index_type_query] = STATE(3009),
    [sym_lookup_type] = STATE(3009),
    [sym_literal_type] = STATE(3009),
    [sym__number] = STATE(3033),
    [sym_existential_type] = STATE(3009),
    [sym_flow_maybe_type] = STATE(3009),
    [sym_parenthesized_type] = STATE(3009),
    [sym_predefined_type] = STATE(3009),
    [sym_type_arguments] = STATE(463),
    [sym_object_type] = STATE(3009),
    [sym_type_parameters] = STATE(5471),
    [sym_array_type] = STATE(3009),
    [sym_tuple_type] = STATE(3009),
    [sym_readonly_type] = STATE(3005),
    [sym_union_type] = STATE(3009),
    [sym_intersection_type] = STATE(3009),
    [sym_function_type] = STATE(3005),
    [aux_sym_export_statement_repeat1] = STATE(4480),
    [aux_sym_array_repeat1] = STATE(5009),
    [aux_sym_array_pattern_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(573),
    [anon_sym_export] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(577),
    [anon_sym_type] = ACTIONS(575),
    [anon_sym_namespace] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(637),
    [anon_sym_typeof] = ACTIONS(585),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(575),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(587),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(589),
    [anon_sym_yield] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(593),
    [anon_sym_RBRACK] = ACTIONS(639),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(148),
    [anon_sym_async] = ACTIONS(597),
    [anon_sym_function] = ACTIONS(152),
    [anon_sym_new] = ACTIONS(599),
    [anon_sym_using] = ACTIONS(601),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(603),
    [anon_sym_AMP] = ACTIONS(605),
    [anon_sym_PIPE] = ACTIONS(607),
    [anon_sym_PLUS] = ACTIONS(609),
    [anon_sym_DASH] = ACTIONS(609),
    [anon_sym_SLASH] = ACTIONS(611),
    [anon_sym_TILDE] = ACTIONS(587),
    [anon_sym_void] = ACTIONS(613),
    [anon_sym_delete] = ACTIONS(615),
    [anon_sym_PLUS_PLUS] = ACTIONS(617),
    [anon_sym_DASH_DASH] = ACTIONS(617),
    [anon_sym_DQUOTE] = ACTIONS(184),
    [anon_sym_SQUOTE] = ACTIONS(186),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(188),
    [sym_number] = ACTIONS(190),
    [sym_private_property_identifier] = ACTIONS(619),
    [sym_this] = ACTIONS(621),
    [sym_super] = ACTIONS(196),
    [sym_true] = ACTIONS(198),
    [sym_false] = ACTIONS(198),
    [sym_null] = ACTIONS(198),
    [sym_undefined] = ACTIONS(623),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(575),
    [anon_sym_readonly] = ACTIONS(625),
    [anon_sym_get] = ACTIONS(575),
    [anon_sym_set] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(627),
    [anon_sym_declare] = ACTIONS(575),
    [anon_sym_public] = ACTIONS(575),
    [anon_sym_private] = ACTIONS(575),
    [anon_sym_protected] = ACTIONS(575),
    [anon_sym_override] = ACTIONS(575),
    [anon_sym_module] = ACTIONS(575),
    [anon_sym_any] = ACTIONS(629),
    [anon_sym_number] = ACTIONS(629),
    [anon_sym_boolean] = ACTIONS(629),
    [anon_sym_string] = ACTIONS(629),
    [anon_sym_symbol] = ACTIONS(629),
    [anon_sym_object] = ACTIONS(629),
    [anon_sym_abstract] = ACTIONS(631),
    [anon_sym_infer] = ACTIONS(633),
    [anon_sym_keyof] = ACTIONS(635),
    [anon_sym_unique] = ACTIONS(214),
    [anon_sym_unknown] = ACTIONS(216),
    [anon_sym_never] = ACTIONS(216),
    [anon_sym_LBRACE_PIPE] = ACTIONS(218),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(867),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(898),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(913),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(914),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(915),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(923),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [58] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(924),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [59] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(925),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [60] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(926),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(2381),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3910),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(541),
    [anon_sym_type] = ACTIONS(543),
    [anon_sym_namespace] = ACTIONS(545),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(551),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(553),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(557),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(561),
    [anon_sym_function] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(565),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(567),
    [anon_sym_readonly] = ACTIONS(567),
    [anon_sym_get] = ACTIONS(567),
    [anon_sym_set] = ACTIONS(567),
    [anon_sym_declare] = ACTIONS(569),
    [anon_sym_public] = ACTIONS(567),
    [anon_sym_private] = ACTIONS(567),
    [anon_sym_protected] = ACTIONS(567),
    [anon_sym_override] = ACTIONS(567),
    [anon_sym_module] = ACTIONS(571),
    [anon_sym_any] = ACTIONS(567),
    [anon_sym_number] = ACTIONS(567),
    [anon_sym_boolean] = ACTIONS(567),
    [anon_sym_string] = ACTIONS(567),
    [anon_sym_symbol] = ACTIONS(567),
    [anon_sym_object] = ACTIONS(567),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [61] = {
    [sym_export_statement] = STATE(932),
    [sym_declaration] = STATE(932),
    [sym_import] = STATE(3689),
    [sym_import_statement] = STATE(932),
    [sym_statement] = STATE(825),
    [sym_expression_statement] = STATE(932),
    [sym_variable_declaration] = STATE(813),
    [sym_lexical_declaration] = STATE(813),
    [sym_statement_block] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_switch_statement] = STATE(932),
    [sym_for_statement] = STATE(932),
    [sym_for_in_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_do_statement] = STATE(932),
    [sym_try_statement] = STATE(932),
    [sym_with_statement] = STATE(932),
    [sym_break_statement] = STATE(932),
    [sym_continue_statement] = STATE(932),
    [sym_debugger_statement] = STATE(932),
    [sym_return_statement] = STATE(932),
    [sym_throw_statement] = STATE(932),
    [sym_empty_statement] = STATE(932),
    [sym_labeled_statement] = STATE(932),
    [sym_parenthesized_expression] = STATE(1364),
    [sym_expression] = STATE(1903),
    [sym_primary_expression] = STATE(1867),
    [sym_yield_expression] = STATE(2118),
    [sym_object] = STATE(2291),
    [sym_object_pattern] = STATE(5612),
    [sym_array] = STATE(2291),
    [sym_array_pattern] = STATE(5612),
    [sym_glimmer_template] = STATE(2118),
    [sym_glimmer_opening_tag] = STATE(4659),
    [sym_class] = STATE(2291),
    [sym_class_declaration] = STATE(813),
    [sym_function_expression] = STATE(2291),
    [sym_function_declaration] = STATE(813),
    [sym_generator_function] = STATE(2291),
    [sym_generator_function_declaration] = STATE(813),
    [sym_arrow_function] = STATE(2291),
    [sym__call_signature] = STATE(5528),
    [sym_call_expression] = STATE(2291),
    [sym_new_expression] = STATE(1970),
    [sym_await_expression] = STATE(2118),
    [sym_member_expression] = STATE(1364),
    [sym_subscript_expression] = STATE(1364),
    [sym_assignment_expression] = STATE(2118),
    [sym__augmented_assignment_lhs] = STATE(3016),
    [sym_augmented_assignment_expression] = STATE(2118),
    [sym__destructuring_pattern] = STATE(5612),
    [sym_ternary_expression] = STATE(2118),
    [sym_binary_expression] = STATE(2118),
    [sym_unary_expression] = STATE(2118),
    [sym_update_expression] = STATE(2118),
    [sym_sequence_expression] = STATE(5431),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2291),
    [sym_regex] = STATE(2291),
    [sym_meta_property] = STATE(2291),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(3842),
    [sym_non_null_expression] = STATE(1364),
    [sym_function_signature] = STATE(813),
    [sym_type_assertion] = STATE(2118),
    [sym_as_expression] = STATE(2118),
    [sym_satisfies_expression] = STATE(2118),
    [sym_instantiation_expression] = STATE(2118),
    [sym_ambient_declaration] = STATE(813),
    [sym_abstract_class_declaration] = STATE(813),
    [sym_module] = STATE(813),
    [sym_internal_module] = STATE(238),
    [sym_import_alias] = STATE(813),
    [sym_interface_declaration] = STATE(813),
    [sym_enum_declaration] = STATE(813),
    [sym_type_alias_declaration] = STATE(813),
    [sym_type_arguments] = STATE(674),
    [sym_type_parameters] = STATE(5263),
    [aux_sym_export_statement_repeat1] = STATE(3884),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_using] = ACTIONS(77),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_DQUOTE] = ACTIONS(83),
    [anon_sym_SQUOTE] = ACTIONS(85),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(87),
    [sym_number] = ACTIONS(89),
    [sym_private_property_identifier] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(93),
    [sym_true] = ACTIONS(93),
    [sym_false] = ACTIONS(93),
    [sym_null] = ACTIONS(93),
    [sym_undefined] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_static] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(99),
    [anon_sym_get] = ACTIONS(99),
    [anon_sym_set] = ACTIONS(99),
    [anon_sym_declare] = ACTIONS(101),
    [anon_sym_public] = ACTIONS(99),
    [anon_sym_private] = ACTIONS(99),
    [anon_sym_protected] = ACTIONS(99),
    [anon_sym_override] = ACTIONS(99),
    [anon_sym_module] = ACTIONS(103),
    [anon_sym_any] = ACTIONS(99),
    [anon_sym_number] = ACTIONS(99),
    [anon_sym_boolean] = ACTIONS(99),
    [anon_sym_string] = ACTIONS(99),
    [anon_sym_symbol] = ACTIONS(99),
    [anon_sym_object] = ACTIONS(99),
    [anon_sym_abstract] = ACTIONS(105),
    [anon_sym_interface] = ACTIONS(107),
    [anon_sym_enum] = ACTIONS(109),
    [sym_html_comment] = ACTIONS(5),
  },
  [62] = {
    [sym_import] = STATE(3710),
    [sym_parenthesized_expression] = STATE(1327),
    [sym_expression] = STATE(2182),
    [sym_primary_expression] = STATE(1513),
    [sym_yield_expression] = STATE(1675),
    [sym_object] = STATE(1666),
    [sym_object_pattern] = STATE(4435),
    [sym_assignment_pattern] = STATE(5001),
    [sym_array] = STATE(1666),
    [sym_array_pattern] = STATE(4435),
    [sym_glimmer_template] = STATE(1675),
    [sym_glimmer_opening_tag] = STATE(4695),
    [sym_nested_identifier] = STATE(5810),
    [sym_class] = STATE(1666),
    [sym_function_expression] = STATE(1666),
    [sym_generator_function] = STATE(1666),
    [sym_arrow_function] = STATE(1666),
    [sym__call_signature] = STATE(5664),
    [sym_call_expression] = STATE(1666),
    [sym_new_expression] = STATE(1613),
    [sym_await_expression] = STATE(1675),
    [sym_member_expression] = STATE(1382),
    [sym_subscript_expression] = STATE(1382),
    [sym_assignment_expression] = STATE(1675),
    [sym__augmented_assignment_lhs] = STATE(3052),
    [sym_augmented_assignment_expression] = STATE(1675),
    [sym__destructuring_pattern] = STATE(4435),
    [sym_spread_element] = STATE(4860),
    [sym_ternary_expression] = STATE(1675),
    [sym_binary_expression] = STATE(1675),
    [sym_unary_expression] = STATE(1675),
    [sym_update_expression] = STATE(1675),
    [sym_string] = STATE(2137),
    [sym_template_string] = STATE(1666),
    [sym_regex] = STATE(1666),
    [sym_meta_property] = STATE(1666),
    [sym_decorator] = STATE(1339),
    [sym_formal_parameters] = STATE(4331),
    [sym_pattern] = STATE(4424),
    [sym_rest_pattern] = STATE(4171),
    [sym_non_null_expression] = STATE(1382),
    [sym_type_assertion] = STATE(1675),
    [sym_as_expression] = STATE(1675),
    [sym_satisfies_expression] = STATE(1675),
    [sym_instantiation_expression] = STATE(1675),
    [sym_internal_module] = STATE(1675),
    [sym_nested_type_identifier] = STATE(2948),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3319),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2950),
    [sym_type] = STATE(3909),
    [sym_tuple_parameter] = STATE(5127),
    [sym_optional_tuple_parameter] = STATE(5127),
    [sym_optional_type] = STATE(5127),
    [sym_rest_type] = STATE(5127),
    [sym__tuple_type_member] = STATE(5127),
    [sym_constructor_type] = STATE(3005),
    [sym_primary_type] = STATE(3007),
    [sym_template_literal_type] = STATE(3009),
    [sym_infer_type] = STATE(3005),
    [sym_conditional_type] = STATE(3009),
    [sym_generic_type] = STATE(3009),
    [sym_type_query] = STATE(3009),
    [sym_index_type_query] = STATE(3009),
    [sym_lookup_type] = STATE(3009),
    [sym_literal_type] = STATE(3009),
    [sym__number] = STATE(3033),
    [sym_existential_type] = STATE(3009),
    [sym_flow_maybe_type] = STATE(3009),
    [sym_parenthesized_type] = STATE(3009),
    [sym_predefined_type] = STATE(3009),
    [sym_type_arguments] = STATE(463),
    [sym_object_type] = STATE(3009),
    [sym_type_parameters] = STATE(5471),
    [sym_array_type] = STATE(3009),
    [sym_tuple_type] = STATE(3009),
    [sym_readonly_type] = STATE(3005),
    [sym_union_type] = STATE(3009),
    [sym_intersection_type] = STATE(3009),
    [sym_function_type] = STATE(3005),
    [aux_sym_export_statement_repeat1] = STATE(4480),
    [aux_sym_array_repeat1] = STATE(4866),
    [aux_sym_array_pattern_repeat1] = STATE(5016),
    [sym_identifier] = ACTIONS(573),
    [anon_sym_export] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(577),
    [anon_sym_type] = ACTIONS(575),
    [anon_sym_namespace] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(637),
    [anon_sym_typeof] = ACTIONS(585),
    [anon_sym_import] = ACTIONS(131),
    [anon_sym_let] = ACTIONS(575),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(587),
    [anon_sym_LPAREN] = ACTIONS(138),
    [anon_sym_await] = ACTIONS(589),
    [anon_sym_yield] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(593),
    [anon_sym_RBRACK] = ACTIONS