#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1985
#define LARGE_STATE_COUNT 349
#define SYMBOL_COUNT 393
#define ALIAS_COUNT 0
#define TOKEN_COUNT 214
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 12
#define PRODUCTION_ID_COUNT 27

enum {
  sym_comment = 1,
  sym_decimal_integer_literal = 2,
  sym_hexadecimal_integer_literal = 3,
  sym_real_literal = 4,
  aux_sym_expandable_string_literal_token1 = 5,
  aux_sym_expandable_string_literal_token2 = 6,
  aux_sym_expandable_string_literal_token3 = 7,
  aux_sym_expandable_string_literal_token4 = 8,
  anon_sym_DQUOTE_DQUOTE = 9,
  anon_sym_DOLLAR = 10,
  aux_sym_expandable_string_literal_token5 = 11,
  aux_sym_expandable_here_string_literal_token1 = 12,
  aux_sym_expandable_here_string_literal_token2 = 13,
  aux_sym_expandable_here_string_literal_token3 = 14,
  aux_sym_expandable_here_string_literal_token4 = 15,
  aux_sym_expandable_here_string_literal_token5 = 16,
  sym_verbatim_string_characters = 17,
  sym_verbatim_here_string_characters = 18,
  sym_simple_name = 19,
  sym_type_identifier = 20,
  anon_sym_DOT = 21,
  anon_sym_LBRACK = 22,
  anon_sym_EQ = 23,
  anon_sym_BANG_EQ = 24,
  anon_sym_PLUS_EQ = 25,
  anon_sym_STAR_EQ = 26,
  anon_sym_SLASH_EQ = 27,
  anon_sym_PERCENT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_GT_GT = 30,
  anon_sym_2_GT = 31,
  anon_sym_2_GT_GT = 32,
  anon_sym_3_GT = 33,
  anon_sym_3_GT_GT = 34,
  anon_sym_4_GT = 35,
  anon_sym_4_GT_GT = 36,
  anon_sym_5_GT = 37,
  anon_sym_5_GT_GT = 38,
  anon_sym_6_GT = 39,
  anon_sym_6_GT_GT = 40,
  anon_sym_STAR_GT = 41,
  anon_sym_STAR_GT_GT = 42,
  anon_sym_LT = 43,
  anon_sym_STAR_GT_AMP1 = 44,
  anon_sym_2_GT_AMP1 = 45,
  anon_sym_3_GT_AMP1 = 46,
  anon_sym_4_GT_AMP1 = 47,
  anon_sym_5_GT_AMP1 = 48,
  anon_sym_6_GT_AMP1 = 49,
  anon_sym_STAR_GT_AMP2 = 50,
  anon_sym_1_GT_AMP2 = 51,
  anon_sym_3_GT_AMP2 = 52,
  anon_sym_4_GT_AMP2 = 53,
  anon_sym_5_GT_AMP2 = 54,
  anon_sym_6_GT_AMP2 = 55,
  anon_sym_DASHas = 56,
  anon_sym_DASHccontains = 57,
  anon_sym_DASHceq = 58,
  anon_sym_DASHcge = 59,
  anon_sym_DASHcgt = 60,
  anon_sym_DASHcle = 61,
  anon_sym_DASHclike = 62,
  anon_sym_DASHclt = 63,
  anon_sym_DASHcmatch = 64,
  anon_sym_DASHcne = 65,
  anon_sym_DASHcnotcontains = 66,
  anon_sym_DASHcnotlike = 67,
  anon_sym_DASHcnotmatch = 68,
  anon_sym_DASHcontains = 69,
  anon_sym_DASHcreplace = 70,
  anon_sym_DASHcsplit = 71,
  anon_sym_DASHeq = 72,
  anon_sym_DASHge = 73,
  anon_sym_DASHgt = 74,
  anon_sym_DASHicontains = 75,
  anon_sym_DASHieq = 76,
  anon_sym_DASHige = 77,
  anon_sym_DASHigt = 78,
  anon_sym_DASHile = 79,
  anon_sym_DASHilike = 80,
  anon_sym_DASHilt = 81,
  anon_sym_DASHimatch = 82,
  anon_sym_DASHin = 83,
  anon_sym_DASHine = 84,
  anon_sym_DASHinotcontains = 85,
  anon_sym_DASHinotlike = 86,
  anon_sym_DASHinotmatch = 87,
  anon_sym_DASHireplace = 88,
  anon_sym_DASHis = 89,
  anon_sym_DASHisnot = 90,
  anon_sym_DASHisplit = 91,
  anon_sym_DASHjoin = 92,
  anon_sym_DASHle = 93,
  anon_sym_DASHlike = 94,
  anon_sym_DASHlt = 95,
  anon_sym_DASHmatch = 96,
  anon_sym_DASHne = 97,
  anon_sym_DASHnotcontains = 98,
  anon_sym_DASHnotin = 99,
  anon_sym_DASHnotlike = 100,
  anon_sym_DASHnotmatch = 101,
  anon_sym_DASHreplace = 102,
  anon_sym_DASHshl = 103,
  anon_sym_DASHshr = 104,
  anon_sym_DASHsplit = 105,
  sym_format_operator = 106,
  anon_sym_DOLLAR_DOLLAR = 107,
  anon_sym_DOLLAR_CARET = 108,
  anon_sym_DOLLAR_QMARK = 109,
  anon_sym_DOLLAR_ = 110,
  aux_sym_variable_token1 = 111,
  aux_sym_variable_token2 = 112,
  sym_braced_variable = 113,
  sym_generic_token = 114,
  sym__command_token = 115,
  sym_command_parameter = 116,
  aux_sym__verbatim_command_argument_chars_token1 = 117,
  aux_sym__verbatim_command_argument_chars_token2 = 118,
  aux_sym__verbatim_command_argument_chars_token3 = 119,
  anon_sym_SEMI = 120,
  anon_sym_param = 121,
  anon_sym_LPAREN = 122,
  anon_sym_RPAREN = 123,
  anon_sym_COMMA = 124,
  anon_sym_dynamicparam = 125,
  anon_sym_begin = 126,
  anon_sym_process = 127,
  anon_sym_end = 128,
  anon_sym_LBRACE = 129,
  anon_sym_RBRACE = 130,
  anon_sym_if = 131,
  anon_sym_elseif = 132,
  anon_sym_else = 133,
  anon_sym_switch = 134,
  anon_sym_DASHregex = 135,
  anon_sym_DASHwildcard = 136,
  anon_sym_DASHexact = 137,
  anon_sym_DASHcasesensitive = 138,
  anon_sym_DASHparallel = 139,
  anon_sym_DASHfile = 140,
  anon_sym_foreach = 141,
  anon_sym_in = 142,
  anon_sym_for = 143,
  anon_sym_LF = 144,
  anon_sym_while = 145,
  anon_sym_do = 146,
  anon_sym_until = 147,
  anon_sym_function = 148,
  anon_sym_filter = 149,
  anon_sym_workflow = 150,
  anon_sym_break = 151,
  anon_sym_continue = 152,
  anon_sym_throw = 153,
  anon_sym_return = 154,
  anon_sym_exit = 155,
  sym_label = 156,
  anon_sym_trap = 157,
  anon_sym_try = 158,
  anon_sym_catch = 159,
  anon_sym_finally = 160,
  anon_sym_data = 161,
  anon_sym_DASHsupportedcommand = 162,
  anon_sym_inlinescript = 163,
  anon_sym_parallel = 164,
  anon_sym_sequence = 165,
  anon_sym_PIPE = 166,
  anon_sym_AMP = 167,
  aux_sym__expandable_string_literal_immediate_token1 = 168,
  aux_sym__expandable_string_literal_immediate_token2 = 169,
  aux_sym__expandable_string_literal_immediate_token3 = 170,
  anon_sym_DQUOTE_DQUOTE2 = 171,
  anon_sym_DOLLAR2 = 172,
  anon_sym_DQUOTE = 173,
  aux_sym_command_name_token1 = 174,
  aux_sym_command_name_token2 = 175,
  anon_sym_DQUOTE2 = 176,
  anon_sym_SQUOTE_SQUOTE = 177,
  sym_path_command_name_token = 178,
  sym_stop_parsing = 179,
  anon_sym_ = 180,
  anon_sym_COLON = 181,
  anon_sym_PERCENT = 182,
  anon_sym_foreach_DASHobject = 183,
  anon_sym_DASH_DASH_PERCENT = 184,
  anon_sym_hidden = 185,
  anon_sym_static = 186,
  anon_sym_class = 187,
  anon_sym_enum = 188,
  anon_sym_DASHand = 189,
  anon_sym_DASHor = 190,
  anon_sym_DASHxor = 191,
  anon_sym_DASHband = 192,
  anon_sym_DASHbor = 193,
  anon_sym_DASHbxor = 194,
  anon_sym_PLUS = 195,
  anon_sym_DASH = 196,
  anon_sym_SLASH = 197,
  anon_sym_BSLASH = 198,
  anon_sym_STAR = 199,
  anon_sym_DOT_DOT = 200,
  anon_sym_DASHnot = 201,
  anon_sym_BANG = 202,
  anon_sym_DASHbnot = 203,
  anon_sym_PLUS_PLUS = 204,
  anon_sym_DASH_DASH = 205,
  anon_sym_DOLLAR_LPAREN = 206,
  anon_sym_AT_LPAREN = 207,
  anon_sym_AT_LBRACE = 208,
  anon_sym_DOT2 = 209,
  anon_sym_COLON_COLON = 210,
  anon_sym_RBRACK = 211,
  anon_sym_DOTforeach = 212,
  sym__statement_terminator = 213,
  sym_program = 214,
  sym__literal = 215,
  sym_integer_literal = 216,
  sym_string_literal = 217,
  sym_expandable_string_literal = 218,
  sym_expandable_here_string_literal = 219,
  sym_type_name = 220,
  sym_array_type_name = 221,
  sym_generic_type_name = 222,
  sym_assignement_operator = 223,
  sym_file_redirection_operator = 224,
  sym_merging_redirection_operator = 225,
  sym_comparison_operator = 226,
  sym_variable = 227,
  aux_sym__verbatim_command_argument_chars = 228,
  sym_script_block = 229,
  sym_param_block = 230,
  sym_parameter_list = 231,
  sym_script_parameter = 232,
  sym_script_parameter_default = 233,
  sym_script_block_body = 234,
  sym_named_block_list = 235,
  sym_named_block = 236,
  sym_block_name = 237,
  sym_statement_block = 238,
  sym_statement_list = 239,
  sym__statement = 240,
  sym_empty_statement = 241,
  sym_if_statement = 242,
  sym_elseif_clauses = 243,
  sym_elseif_clause = 244,
  sym_else_clause = 245,
  sym__labeled_statement = 246,
  sym_switch_statement = 247,
  sym_switch_parameters = 248,
  sym_switch_parameter = 249,
  sym_switch_condition = 250,
  sym_switch_filename = 251,
  sym_switch_body = 252,
  sym_switch_clauses = 253,
  sym_switch_clause = 254,
  sym_switch_clause_condition = 255,
  sym_foreach_statement = 256,
  sym_foreach_parameter = 257,
  sym_for_statement = 258,
  sym_for_initializer = 259,
  sym_for_condition = 260,
  sym_for_iterator = 261,
  sym_while_statement = 262,
  sym_while_condition = 263,
  sym_do_statement = 264,
  sym_function_statement = 265,
  sym_function_name = 266,
  sym_function_parameter_declaration = 267,
  sym_flow_control_statement = 268,
  sym_label_expression = 269,
  sym_trap_statement = 270,
  sym_try_statement = 271,
  sym_catch_clauses = 272,
  sym_catch_clause = 273,
  sym_catch_type_list = 274,
  sym_finally_clause = 275,
  sym_data_statement = 276,
  sym_data_name = 277,
  sym_data_commands_allowed = 278,
  sym_data_commands_list = 279,
  sym_data_command = 280,
  sym_inlinescript_statement = 281,
  sym_parallel_statement = 282,
  sym_sequence_statement = 283,
  sym_pipeline = 284,
  sym_left_assignment_expression = 285,
  sym_assignment_expression = 286,
  aux_sym__pipeline_tail = 287,
  sym_command = 288,
  sym_command_invokation_operator = 289,
  sym__expandable_string_literal_immediate = 290,
  sym_command_name = 291,
  sym_path_command_name = 292,
  sym_command_name_expr = 293,
  sym_command_elements = 294,
  sym__command_element = 295,
  sym_command_argument_sep = 296,
  sym__command_argument = 297,
  sym_foreach_command = 298,
  sym_verbatim_command_argument = 299,
  sym_redirections = 300,
  sym_redirection = 301,
  sym_redirected_file_name = 302,
  sym_class_attribute = 303,
  sym_class_property_definition = 304,
  sym_class_method_parameter = 305,
  sym_class_method_parameter_list = 306,
  sym_class_method_definition = 307,
  sym_class_statement = 308,
  sym_enum_statement = 309,
  sym_enum_member = 310,
  sym__expression = 311,
  sym_logical_expression = 312,
  sym_bitwise_expression = 313,
  sym_comparison_expression = 314,
  sym_additive_expression = 315,
  sym_multiplicative_expression = 316,
  sym_format_expression = 317,
  sym_range_expression = 318,
  sym_array_literal_expression = 319,
  sym_unary_expression = 320,
  sym_expression_with_unary_operator = 321,
  sym_pre_increment_expression = 322,
  sym_pre_decrement_expression = 323,
  sym_cast_expression = 324,
  sym__primary_expression = 325,
  sym__value = 326,
  sym_parenthesized_expression = 327,
  sym_sub_expression = 328,
  sym_array_expression = 329,
  sym_script_block_expression = 330,
  sym_hash_literal_expression = 331,
  sym_hash_literal_body = 332,
  sym_hash_entry = 333,
  sym_key_expression = 334,
  sym_post_increment_expression = 335,
  sym_post_decrement_expression = 336,
  sym_member_access = 337,
  sym_member_name = 338,
  sym_element_access = 339,
  sym_invokation_expression = 340,
  sym_invokation_foreach_expression = 341,
  sym_argument_list = 342,
  sym_argument_expression_list = 343,
  sym_argument_expression = 344,
  sym_logical_argument_expression = 345,
  sym_bitwise_argument_expression = 346,
  sym_comparison_argument_expression = 347,
  sym_additive_argument_expression = 348,
  sym_multiplicative_argument_expression = 349,
  sym_format_argument_expression = 350,
  sym_range_argument_expression = 351,
  sym_type_literal = 352,
  sym_type_spec = 353,
  sym_dimension = 354,
  sym_generic_type_arguments = 355,
  sym_attribute_list = 356,
  sym_attribute = 357,
  sym_attribute_name = 358,
  sym_attribute_arguments = 359,
  sym_attribute_argument = 360,
  aux_sym_expandable_string_literal_repeat1 = 361,
  aux_sym_expandable_string_literal_repeat2 = 362,
  aux_sym_expandable_here_string_literal_repeat1 = 363,
  aux_sym_script_block_repeat1 = 364,
  aux_sym_parameter_list_repeat1 = 365,
  aux_sym_named_block_list_repeat1 = 366,
  aux_sym_statement_list_repeat1 = 367,
  aux_sym_elseif_clauses_repeat1 = 368,
  aux_sym_switch_parameters_repeat1 = 369,
  aux_sym_switch_clauses_repeat1 = 370,
  aux_sym_catch_clauses_repeat1 = 371,
  aux_sym_catch_type_list_repeat1 = 372,
  aux_sym_data_commands_list_repeat1 = 373,
  aux_sym__expandable_string_literal_immediate_repeat1 = 374,
  aux_sym__expandable_string_literal_immediate_repeat2 = 375,
  aux_sym_command_name_repeat1 = 376,
  aux_sym_path_command_name_repeat1 = 377,
  aux_sym_command_elements_repeat1 = 378,
  aux_sym_command_argument_sep_repeat1 = 379,
  aux_sym_foreach_command_repeat1 = 380,
  aux_sym_redirections_repeat1 = 381,
  aux_sym_class_property_definition_repeat1 = 382,
  aux_sym_class_method_parameter_list_repeat1 = 383,
  aux_sym_class_statement_repeat1 = 384,
  aux_sym_class_statement_repeat2 = 385,
  aux_sym_enum_statement_repeat1 = 386,
  aux_sym_hash_literal_body_repeat1 = 387,
  aux_sym_argument_expression_list_repeat1 = 388,
  aux_sym_dimension_repeat1 = 389,
  aux_sym_generic_type_arguments_repeat1 = 390,
  aux_sym_attribute_list_repeat1 = 391,
  aux_sym_attribute_arguments_repeat1 = 392,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hexadecimal_integer_literal] = "hexadecimal_integer_literal",
  [sym_real_literal] = "real_literal",
  [aux_sym_expandable_string_literal_token1] = "expandable_string_literal_token1",
  [aux_sym_expandable_string_literal_token2] = "expandable_string_literal_token2",
  [aux_sym_expandable_string_literal_token3] = "expandable_string_literal_token3",
  [aux_sym_expandable_string_literal_token4] = "expandable_string_literal_token4",
  [anon_sym_DQUOTE_DQUOTE] = "\"\"",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_expandable_string_literal_token5] = "expandable_string_literal_token5",
  [aux_sym_expandable_here_string_literal_token1] = "expandable_here_string_literal_token1",
  [aux_sym_expandable_here_string_literal_token2] = "expandable_here_string_literal_token2",
  [aux_sym_expandable_here_string_literal_token3] = "expandable_here_string_literal_token3",
  [aux_sym_expandable_here_string_literal_token4] = "expandable_here_string_literal_token4",
  [aux_sym_expandable_here_string_literal_token5] = "expandable_here_string_literal_token5",
  [sym_verbatim_string_characters] = "verbatim_string_characters",
  [sym_verbatim_here_string_characters] = "verbatim_here_string_characters",
  [sym_simple_name] = "simple_name",
  [sym_type_identifier] = "type_identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_2_GT] = "2>",
  [anon_sym_2_GT_GT] = "2>>",
  [anon_sym_3_GT] = "3>",
  [anon_sym_3_GT_GT] = "3>>",
  [anon_sym_4_GT] = "4>",
  [anon_sym_4_GT_GT] = "4>>",
  [anon_sym_5_GT] = "5>",
  [anon_sym_5_GT_GT] = "5>>",
  [anon_sym_6_GT] = "6>",
  [anon_sym_6_GT_GT] = "6>>",
  [anon_sym_STAR_GT] = "*>",
  [anon_sym_STAR_GT_GT] = "*>>",
  [anon_sym_LT] = "<",
  [anon_sym_STAR_GT_AMP1] = "*>&1",
  [anon_sym_2_GT_AMP1] = "2>&1",
  [anon_sym_3_GT_AMP1] = "3>&1",
  [anon_sym_4_GT_AMP1] = "4>&1",
  [anon_sym_5_GT_AMP1] = "5>&1",
  [anon_sym_6_GT_AMP1] = "6>&1",
  [anon_sym_STAR_GT_AMP2] = "*>&2",
  [anon_sym_1_GT_AMP2] = "1>&2",
  [anon_sym_3_GT_AMP2] = "3>&2",
  [anon_sym_4_GT_AMP2] = "4>&2",
  [anon_sym_5_GT_AMP2] = "5>&2",
  [anon_sym_6_GT_AMP2] = "6>&2",
  [anon_sym_DASHas] = "-as",
  [anon_sym_DASHccontains] = "-ccontains",
  [anon_sym_DASHceq] = "-ceq",
  [anon_sym_DASHcge] = "-cge",
  [anon_sym_DASHcgt] = "-cgt",
  [anon_sym_DASHcle] = "-cle",
  [anon_sym_DASHclike] = "-clike",
  [anon_sym_DASHclt] = "-clt",
  [anon_sym_DASHcmatch] = "-cmatch",
  [anon_sym_DASHcne] = "-cne",
  [anon_sym_DASHcnotcontains] = "-cnotcontains",
  [anon_sym_DASHcnotlike] = "-cnotlike",
  [anon_sym_DASHcnotmatch] = "-cnotmatch",
  [anon_sym_DASHcontains] = "-contains",
  [anon_sym_DASHcreplace] = "-creplace",
  [anon_sym_DASHcsplit] = "-csplit",
  [anon_sym_DASHeq] = "-eq",
  [anon_sym_DASHge] = "-ge",
  [anon_sym_DASHgt] = "-gt",
  [anon_sym_DASHicontains] = "-icontains",
  [anon_sym_DASHieq] = "-ieq",
  [anon_sym_DASHige] = "-ige",
  [anon_sym_DASHigt] = "-igt",
  [anon_sym_DASHile] = "-ile",
  [anon_sym_DASHilike] = "-ilike",
  [anon_sym_DASHilt] = "-ilt",
  [anon_sym_DASHimatch] = "-imatch",
  [anon_sym_DASHin] = "-in",
  [anon_sym_DASHine] = "-ine",
  [anon_sym_DASHinotcontains] = "-inotcontains",
  [anon_sym_DASHinotlike] = "-inotlike",
  [anon_sym_DASHinotmatch] = "-inotmatch",
  [anon_sym_DASHireplace] = "-ireplace",
  [anon_sym_DASHis] = "-is",
  [anon_sym_DASHisnot] = "-isnot",
  [anon_sym_DASHisplit] = "-isplit",
  [anon_sym_DASHjoin] = "-join",
  [anon_sym_DASHle] = "-le",
  [anon_sym_DASHlike] = "-like",
  [anon_sym_DASHlt] = "-lt",
  [anon_sym_DASHmatch] = "-match",
  [anon_sym_DASHne] = "-ne",
  [anon_sym_DASHnotcontains] = "-notcontains",
  [anon_sym_DASHnotin] = "-notin",
  [anon_sym_DASHnotlike] = "-notlike",
  [anon_sym_DASHnotmatch] = "-notmatch",
  [anon_sym_DASHreplace] = "-replace",
  [anon_sym_DASHshl] = "-shl",
  [anon_sym_DASHshr] = "-shr",
  [anon_sym_DASHsplit] = "-split",
  [sym_format_operator] = "format_operator",
  [anon_sym_DOLLAR_DOLLAR] = "$$",
  [anon_sym_DOLLAR_CARET] = "$^",
  [anon_sym_DOLLAR_QMARK] = "$\?",
  [anon_sym_DOLLAR_] = "$_",
  [aux_sym_variable_token1] = "variable_token1",
  [aux_sym_variable_token2] = "variable_token2",
  [sym_braced_variable] = "braced_variable",
  [sym_generic_token] = "generic_token",
  [sym__command_token] = "_command_token",
  [sym_command_parameter] = "command_parameter",
  [aux_sym__verbatim_command_argument_chars_token1] = "_verbatim_command_argument_chars_token1",
  [aux_sym__verbatim_command_argument_chars_token2] = "_verbatim_command_argument_chars_token2",
  [aux_sym__verbatim_command_argument_chars_token3] = "_verbatim_command_argument_chars_token3",
  [anon_sym_SEMI] = ";",
  [anon_sym_param] = "param",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_dynamicparam] = "dynamicparam",
  [anon_sym_begin] = "begin",
  [anon_sym_process] = "process",
  [anon_sym_end] = "end",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_if] = "if",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_DASHregex] = "-regex",
  [anon_sym_DASHwildcard] = "-wildcard",
  [anon_sym_DASHexact] = "-exact",
  [anon_sym_DASHcasesensitive] = "-casesensitive",
  [anon_sym_DASHparallel] = "-parallel",
  [anon_sym_DASHfile] = "-file",
  [anon_sym_foreach] = "foreach",
  [anon_sym_in] = "in",
  [anon_sym_for] = "for",
  [anon_sym_LF] = "\n",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_until] = "until",
  [anon_sym_function] = "function",
  [anon_sym_filter] = "filter",
  [anon_sym_workflow] = "workflow",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_throw] = "throw",
  [anon_sym_return] = "return",
  [anon_sym_exit] = "exit",
  [sym_label] = "label",
  [anon_sym_trap] = "trap",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_data] = "data",
  [anon_sym_DASHsupportedcommand] = "-supportedcommand",
  [anon_sym_inlinescript] = "inlinescript",
  [anon_sym_parallel] = "parallel",
  [anon_sym_sequence] = "sequence",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [aux_sym__expandable_string_literal_immediate_token1] = "_expandable_string_literal_immediate_token1",
  [aux_sym__expandable_string_literal_immediate_token2] = "_expandable_string_literal_immediate_token2",
  [aux_sym__expandable_string_literal_immediate_token3] = "_expandable_string_literal_immediate_token3",
  [anon_sym_DQUOTE_DQUOTE2] = "\"\"",
  [anon_sym_DOLLAR2] = "$",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_command_name_token1] = "command_name_token1",
  [aux_sym_command_name_token2] = "command_name_token2",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_SQUOTE_SQUOTE] = "''",
  [sym_path_command_name_token] = "path_command_name_token",
  [sym_stop_parsing] = "stop_parsing",
  [anon_sym_] = " ",
  [anon_sym_COLON] = ":",
  [anon_sym_PERCENT] = "%",
  [anon_sym_foreach_DASHobject] = "foreach-object",
  [anon_sym_DASH_DASH_PERCENT] = "--%",
  [anon_sym_hidden] = "hidden",
  [anon_sym_static] = "static",
  [anon_sym_class] = "class",
  [anon_sym_enum] = "enum",
  [anon_sym_DASHand] = "-and",
  [anon_sym_DASHor] = "-or",
  [anon_sym_DASHxor] = "-xor",
  [anon_sym_DASHband] = "-band",
  [anon_sym_DASHbor] = "-bor",
  [anon_sym_DASHbxor] = "-bxor",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_STAR] = "*",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_DASHnot] = "-not",
  [anon_sym_BANG] = "!",
  [anon_sym_DASHbnot] = "-bnot",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_AT_LPAREN] = "@(",
  [anon_sym_AT_LBRACE] = "@{",
  [anon_sym_DOT2] = ".",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOTforeach] = ".foreach",
  [sym__statement_terminator] = "_statement_terminator",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_integer_literal] = "integer_literal",
  [sym_string_literal] = "string_literal",
  [sym_expandable_string_literal] = "expandable_string_literal",
  [sym_expandable_here_string_literal] = "expandable_here_string_literal",
  [sym_type_name] = "type_name",
  [sym_array_type_name] = "array_type_name",
  [sym_generic_type_name] = "generic_type_name",
  [sym_assignement_operator] = "assignement_operator",
  [sym_file_redirection_operator] = "file_redirection_operator",
  [sym_merging_redirection_operator] = "merging_redirection_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_variable] = "variable",
  [aux_sym__verbatim_command_argument_chars] = "_verbatim_command_argument_chars",
  [sym_script_block] = "script_block",
  [sym_param_block] = "param_block",
  [sym_parameter_list] = "parameter_list",
  [sym_script_parameter] = "script_parameter",
  [sym_script_parameter_default] = "script_parameter_default",
  [sym_script_block_body] = "script_block_body",
  [sym_named_block_list] = "named_block_list",
  [sym_named_block] = "named_block",
  [sym_block_name] = "block_name",
  [sym_statement_block] = "statement_block",
  [sym_statement_list] = "statement_list",
  [sym__statement] = "_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_clauses] = "elseif_clauses",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym__labeled_statement] = "_labeled_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_parameters] = "switch_parameters",
  [sym_switch_parameter] = "switch_parameter",
  [sym_switch_condition] = "switch_condition",
  [sym_switch_filename] = "switch_filename",
  [sym_switch_body] = "switch_body",
  [sym_switch_clauses] = "switch_clauses",
  [sym_switch_clause] = "switch_clause",
  [sym_switch_clause_condition] = "switch_clause_condition",
  [sym_foreach_statement] = "foreach_statement",
  [sym_foreach_parameter] = "foreach_parameter",
  [sym_for_statement] = "for_statement",
  [sym_for_initializer] = "for_initializer",
  [sym_for_condition] = "for_condition",
  [sym_for_iterator] = "for_iterator",
  [sym_while_statement] = "while_statement",
  [sym_while_condition] = "while_condition",
  [sym_do_statement] = "do_statement",
  [sym_function_statement] = "function_statement",
  [sym_function_name] = "function_name",
  [sym_function_parameter_declaration] = "function_parameter_declaration",
  [sym_flow_control_statement] = "flow_control_statement",
  [sym_label_expression] = "label_expression",
  [sym_trap_statement] = "trap_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clauses] = "catch_clauses",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_type_list] = "catch_type_list",
  [sym_finally_clause] = "finally_clause",
  [sym_data_statement] = "data_statement",
  [sym_data_name] = "data_name",
  [sym_data_commands_allowed] = "data_commands_allowed",
  [sym_data_commands_list] = "data_commands_list",
  [sym_data_command] = "data_command",
  [sym_inlinescript_statement] = "inlinescript_statement",
  [sym_parallel_statement] = "parallel_statement",
  [sym_sequence_statement] = "sequence_statement",
  [sym_pipeline] = "pipeline",
  [sym_left_assignment_expression] = "left_assignment_expression",
  [sym_assignment_expression] = "assignment_expression",
  [aux_sym__pipeline_tail] = "_pipeline_tail",
  [sym_command] = "command",
  [sym_command_invokation_operator] = "command_invokation_operator",
  [sym__expandable_string_literal_immediate] = "_expandable_string_literal_immediate",
  [sym_command_name] = "command_name",
  [sym_path_command_name] = "path_command_name",
  [sym_command_name_expr] = "command_name_expr",
  [sym_command_elements] = "command_elements",
  [sym__command_element] = "_command_element",
  [sym_command_argument_sep] = "command_argument_sep",
  [sym__command_argument] = "_command_argument",
  [sym_foreach_command] = "foreach_command",
  [sym_verbatim_command_argument] = "verbatim_command_argument",
  [sym_redirections] = "redirections",
  [sym_redirection] = "redirection",
  [sym_redirected_file_name] = "redirected_file_name",
  [sym_class_attribute] = "class_attribute",
  [sym_class_property_definition] = "class_property_definition",
  [sym_class_method_parameter] = "class_method_parameter",
  [sym_class_method_parameter_list] = "class_method_parameter_list",
  [sym_class_method_definition] = "class_method_definition",
  [sym_class_statement] = "class_statement",
  [sym_enum_statement] = "enum_statement",
  [sym_enum_member] = "enum_member",
  [sym__expression] = "_expression",
  [sym_logical_expression] = "logical_expression",
  [sym_bitwise_expression] = "bitwise_expression",
  [sym_comparison_expression] = "comparison_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_format_expression] = "format_expression",
  [sym_range_expression] = "range_expression",
  [sym_array_literal_expression] = "array_literal_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_expression_with_unary_operator] = "expression_with_unary_operator",
  [sym_pre_increment_expression] = "pre_increment_expression",
  [sym_pre_decrement_expression] = "pre_decrement_expression",
  [sym_cast_expression] = "cast_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym__value] = "_value",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_sub_expression] = "sub_expression",
  [sym_array_expression] = "array_expression",
  [sym_script_block_expression] = "script_block_expression",
  [sym_hash_literal_expression] = "hash_literal_expression",
  [sym_hash_literal_body] = "hash_literal_body",
  [sym_hash_entry] = "hash_entry",
  [sym_key_expression] = "key_expression",
  [sym_post_increment_expression] = "post_increment_expression",
  [sym_post_decrement_expression] = "post_decrement_expression",
  [sym_member_access] = "member_access",
  [sym_member_name] = "member_name",
  [sym_element_access] = "element_access",
  [sym_invokation_expression] = "invokation_expression",
  [sym_invokation_foreach_expression] = "invokation_foreach_expression",
  [sym_argument_list] = "argument_list",
  [sym_argument_expression_list] = "argument_expression_list",
  [sym_argument_expression] = "argument_expression",
  [sym_logical_argument_expression] = "logical_argument_expression",
  [sym_bitwise_argument_expression] = "bitwise_argument_expression",
  [sym_comparison_argument_expression] = "comparison_argument_expression",
  [sym_additive_argument_expression] = "additive_argument_expression",
  [sym_multiplicative_argument_expression] = "multiplicative_argument_expression",
  [sym_format_argument_expression] = "format_argument_expression",
  [sym_range_argument_expression] = "range_argument_expression",
  [sym_type_literal] = "type_literal",
  [sym_type_spec] = "type_spec",
  [sym_dimension] = "dimension",
  [sym_generic_type_arguments] = "generic_type_arguments",
  [sym_attribute_list] = "attribute_list",
  [sym_attribute] = "attribute",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_arguments] = "attribute_arguments",
  [sym_attribute_argument] = "attribute_argument",
  [aux_sym_expandable_string_literal_repeat1] = "expandable_string_literal_repeat1",
  [aux_sym_expandable_string_literal_repeat2] = "expandable_string_literal_repeat2",
  [aux_sym_expandable_here_string_literal_repeat1] = "expandable_here_string_literal_repeat1",
  [aux_sym_script_block_repeat1] = "script_block_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_named_block_list_repeat1] = "named_block_list_repeat1",
  [aux_sym_statement_list_repeat1] = "statement_list_repeat1",
  [aux_sym_elseif_clauses_repeat1] = "elseif_clauses_repeat1",
  [aux_sym_switch_parameters_repeat1] = "switch_parameters_repeat1",
  [aux_sym_switch_clauses_repeat1] = "switch_clauses_repeat1",
  [aux_sym_catch_clauses_repeat1] = "catch_clauses_repeat1",
  [aux_sym_catch_type_list_repeat1] = "catch_type_list_repeat1",
  [aux_sym_data_commands_list_repeat1] = "data_commands_list_repeat1",
  [aux_sym__expandable_string_literal_immediate_repeat1] = "_expandable_string_literal_immediate_repeat1",
  [aux_sym__expandable_string_literal_immediate_repeat2] = "_expandable_string_literal_immediate_repeat2",
  [aux_sym_command_name_repeat1] = "command_name_repeat1",
  [aux_sym_path_command_name_repeat1] = "path_command_name_repeat1",
  [aux_sym_command_elements_repeat1] = "command_elements_repeat1",
  [aux_sym_command_argument_sep_repeat1] = "command_argument_sep_repeat1",
  [aux_sym_foreach_command_repeat1] = "foreach_command_repeat1",
  [aux_sym_redirections_repeat1] = "redirections_repeat1",
  [aux_sym_class_property_definition_repeat1] = "class_property_definition_repeat1",
  [aux_sym_class_method_parameter_list_repeat1] = "class_method_parameter_list_repeat1",
  [aux_sym_class_statement_repeat1] = "class_statement_repeat1",
  [aux_sym_class_statement_repeat2] = "class_statement_repeat2",
  [aux_sym_enum_statement_repeat1] = "enum_statement_repeat1",
  [aux_sym_hash_literal_body_repeat1] = "hash_literal_body_repeat1",
  [aux_sym_argument_expression_list_repeat1] = "argument_expression_list_repeat1",
  [aux_sym_dimension_repeat1] = "dimension_repeat1",
  [aux_sym_generic_type_arguments_repeat1] = "generic_type_arguments_repeat1",
  [aux_sym_attribute_list_repeat1] = "attribute_list_repeat1",
  [aux_sym_attribute_arguments_repeat1] = "attribute_arguments_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hexadecimal_integer_literal] = sym_hexadecimal_integer_literal,
  [sym_real_literal] = sym_real_literal,
  [aux_sym_expandable_string_literal_token1] = aux_sym_expandable_string_literal_token1,
  [aux_sym_expandable_string_literal_token2] = aux_sym_expandable_string_literal_token2,
  [aux_sym_expandable_string_literal_token3] = aux_sym_expandable_string_literal_token3,
  [aux_sym_expandable_string_literal_token4] = aux_sym_expandable_string_literal_token4,
  [anon_sym_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_expandable_string_literal_token5] = aux_sym_expandable_string_literal_token5,
  [aux_sym_expandable_here_string_literal_token1] = aux_sym_expandable_here_string_literal_token1,
  [aux_sym_expandable_here_string_literal_token2] = aux_sym_expandable_here_string_literal_token2,
  [aux_sym_expandable_here_string_literal_token3] = aux_sym_expandable_here_string_literal_token3,
  [aux_sym_expandable_here_string_literal_token4] = aux_sym_expandable_here_string_literal_token4,
  [aux_sym_expandable_here_string_literal_token5] = aux_sym_expandable_here_string_literal_token5,
  [sym_verbatim_string_characters] = sym_verbatim_string_characters,
  [sym_verbatim_here_string_characters] = sym_verbatim_here_string_characters,
  [sym_simple_name] = sym_simple_name,
  [sym_type_identifier] = sym_type_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_2_GT] = anon_sym_2_GT,
  [anon_sym_2_GT_GT] = anon_sym_2_GT_GT,
  [anon_sym_3_GT] = anon_sym_3_GT,
  [anon_sym_3_GT_GT] = anon_sym_3_GT_GT,
  [anon_sym_4_GT] = anon_sym_4_GT,
  [anon_sym_4_GT_GT] = anon_sym_4_GT_GT,
  [anon_sym_5_GT] = anon_sym_5_GT,
  [anon_sym_5_GT_GT] = anon_sym_5_GT_GT,
  [anon_sym_6_GT] = anon_sym_6_GT,
  [anon_sym_6_GT_GT] = anon_sym_6_GT_GT,
  [anon_sym_STAR_GT] = anon_sym_STAR_GT,
  [anon_sym_STAR_GT_GT] = anon_sym_STAR_GT_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_STAR_GT_AMP1] = anon_sym_STAR_GT_AMP1,
  [anon_sym_2_GT_AMP1] = anon_sym_2_GT_AMP1,
  [anon_sym_3_GT_AMP1] = anon_sym_3_GT_AMP1,
  [anon_sym_4_GT_AMP1] = anon_sym_4_GT_AMP1,
  [anon_sym_5_GT_AMP1] = anon_sym_5_GT_AMP1,
  [anon_sym_6_GT_AMP1] = anon_sym_6_GT_AMP1,
  [anon_sym_STAR_GT_AMP2] = anon_sym_STAR_GT_AMP2,
  [anon_sym_1_GT_AMP2] = anon_sym_1_GT_AMP2,
  [anon_sym_3_GT_AMP2] = anon_sym_3_GT_AMP2,
  [anon_sym_4_GT_AMP2] = anon_sym_4_GT_AMP2,
  [anon_sym_5_GT_AMP2] = anon_sym_5_GT_AMP2,
  [anon_sym_6_GT_AMP2] = anon_sym_6_GT_AMP2,
  [anon_sym_DASHas] = anon_sym_DASHas,
  [anon_sym_DASHccontains] = anon_sym_DASHccontains,
  [anon_sym_DASHceq] = anon_sym_DASHceq,
  [anon_sym_DASHcge] = anon_sym_DASHcge,
  [anon_sym_DASHcgt] = anon_sym_DASHcgt,
  [anon_sym_DASHcle] = anon_sym_DASHcle,
  [anon_sym_DASHclike] = anon_sym_DASHclike,
  [anon_sym_DASHclt] = anon_sym_DASHclt,
  [anon_sym_DASHcmatch] = anon_sym_DASHcmatch,
  [anon_sym_DASHcne] = anon_sym_DASHcne,
  [anon_sym_DASHcnotcontains] = anon_sym_DASHcnotcontains,
  [anon_sym_DASHcnotlike] = anon_sym_DASHcnotlike,
  [anon_sym_DASHcnotmatch] = anon_sym_DASHcnotmatch,
  [anon_sym_DASHcontains] = anon_sym_DASHcontains,
  [anon_sym_DASHcreplace] = anon_sym_DASHcreplace,
  [anon_sym_DASHcsplit] = anon_sym_DASHcsplit,
  [anon_sym_DASHeq] = anon_sym_DASHeq,
  [anon_sym_DASHge] = anon_sym_DASHge,
  [anon_sym_DASHgt] = anon_sym_DASHgt,
  [anon_sym_DASHicontains] = anon_sym_DASHicontains,
  [anon_sym_DASHieq] = anon_sym_DASHieq,
  [anon_sym_DASHige] = anon_sym_DASHige,
  [anon_sym_DASHigt] = anon_sym_DASHigt,
  [anon_sym_DASHile] = anon_sym_DASHile,
  [anon_sym_DASHilike] = anon_sym_DASHilike,
  [anon_sym_DASHilt] = anon_sym_DASHilt,
  [anon_sym_DASHimatch] = anon_sym_DASHimatch,
  [anon_sym_DASHin] = anon_sym_DASHin,
  [anon_sym_DASHine] = anon_sym_DASHine,
  [anon_sym_DASHinotcontains] = anon_sym_DASHinotcontains,
  [anon_sym_DASHinotlike] = anon_sym_DASHinotlike,
  [anon_sym_DASHinotmatch] = anon_sym_DASHinotmatch,
  [anon_sym_DASHireplace] = anon_sym_DASHireplace,
  [anon_sym_DASHis] = anon_sym_DASHis,
  [anon_sym_DASHisnot] = anon_sym_DASHisnot,
  [anon_sym_DASHisplit] = anon_sym_DASHisplit,
  [anon_sym_DASHjoin] = anon_sym_DASHjoin,
  [anon_sym_DASHle] = anon_sym_DASHle,
  [anon_sym_DASHlike] = anon_sym_DASHlike,
  [anon_sym_DASHlt] = anon_sym_DASHlt,
  [anon_sym_DASHmatch] = anon_sym_DASHmatch,
  [anon_sym_DASHne] = anon_sym_DASHne,
  [anon_sym_DASHnotcontains] = anon_sym_DASHnotcontains,
  [anon_sym_DASHnotin] = anon_sym_DASHnotin,
  [anon_sym_DASHnotlike] = anon_sym_DASHnotlike,
  [anon_sym_DASHnotmatch] = anon_sym_DASHnotmatch,
  [anon_sym_DASHreplace] = anon_sym_DASHreplace,
  [anon_sym_DASHshl] = anon_sym_DASHshl,
  [anon_sym_DASHshr] = anon_sym_DASHshr,
  [anon_sym_DASHsplit] = anon_sym_DASHsplit,
  [sym_format_operator] = sym_format_operator,
  [anon_sym_DOLLAR_DOLLAR] = anon_sym_DOLLAR_DOLLAR,
  [anon_sym_DOLLAR_CARET] = anon_sym_DOLLAR_CARET,
  [anon_sym_DOLLAR_QMARK] = anon_sym_DOLLAR_QMARK,
  [anon_sym_DOLLAR_] = anon_sym_DOLLAR_,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [aux_sym_variable_token2] = aux_sym_variable_token2,
  [sym_braced_variable] = sym_braced_variable,
  [sym_generic_token] = sym_generic_token,
  [sym__command_token] = sym__command_token,
  [sym_command_parameter] = sym_command_parameter,
  [aux_sym__verbatim_command_argument_chars_token1] = aux_sym__verbatim_command_argument_chars_token1,
  [aux_sym__verbatim_command_argument_chars_token2] = aux_sym__verbatim_command_argument_chars_token2,
  [aux_sym__verbatim_command_argument_chars_token3] = aux_sym__verbatim_command_argument_chars_token3,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_dynamicparam] = anon_sym_dynamicparam,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_process] = anon_sym_process,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_DASHregex] = anon_sym_DASHregex,
  [anon_sym_DASHwildcard] = anon_sym_DASHwildcard,
  [anon_sym_DASHexact] = anon_sym_DASHexact,
  [anon_sym_DASHcasesensitive] = anon_sym_DASHcasesensitive,
  [anon_sym_DASHparallel] = anon_sym_DASHparallel,
  [anon_sym_DASHfile] = anon_sym_DASHfile,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_filter] = anon_sym_filter,
  [anon_sym_workflow] = anon_sym_workflow,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_exit] = anon_sym_exit,
  [sym_label] = sym_label,
  [anon_sym_trap] = anon_sym_trap,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_data] = anon_sym_data,
  [anon_sym_DASHsupportedcommand] = anon_sym_DASHsupportedcommand,
  [anon_sym_inlinescript] = anon_sym_inlinescript,
  [anon_sym_parallel] = anon_sym_parallel,
  [anon_sym_sequence] = anon_sym_sequence,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [aux_sym__expandable_string_literal_immediate_token1] = aux_sym__expandable_string_literal_immediate_token1,
  [aux_sym__expandable_string_literal_immediate_token2] = aux_sym__expandable_string_literal_immediate_token2,
  [aux_sym__expandable_string_literal_immediate_token3] = aux_sym__expandable_string_literal_immediate_token3,
  [anon_sym_DQUOTE_DQUOTE2] = anon_sym_DQUOTE_DQUOTE,
  [anon_sym_DOLLAR2] = anon_sym_DOLLAR,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_command_name_token1] = aux_sym_command_name_token1,
  [aux_sym_command_name_token2] = aux_sym_command_name_token2,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE,
  [sym_path_command_name_token] = sym_path_command_name_token,
  [sym_stop_parsing] = sym_stop_parsing,
  [anon_sym_] = anon_sym_,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_foreach_DASHobject] = anon_sym_foreach_DASHobject,
  [anon_sym_DASH_DASH_PERCENT] = anon_sym_DASH_DASH_PERCENT,
  [anon_sym_hidden] = anon_sym_hidden,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASHand] = anon_sym_DASHand,
  [anon_sym_DASHor] = anon_sym_DASHor,
  [anon_sym_DASHxor] = anon_sym_DASHxor,
  [anon_sym_DASHband] = anon_sym_DASHband,
  [anon_sym_DASHbor] = anon_sym_DASHbor,
  [anon_sym_DASHbxor] = anon_sym_DASHbxor,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_DASHnot] = anon_sym_DASHnot,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASHbnot] = anon_sym_DASHbnot,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_AT_LPAREN] = anon_sym_AT_LPAREN,
  [anon_sym_AT_LBRACE] = anon_sym_AT_LBRACE,
  [anon_sym_DOT2] = anon_sym_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOTforeach] = anon_sym_DOTforeach,
  [sym__statement_terminator] = sym__statement_terminator,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_integer_literal] = sym_integer_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_expandable_string_literal] = sym_expandable_string_literal,
  [sym_expandable_here_string_literal] = sym_expandable_here_string_literal,
  [sym_type_name] = sym_type_name,
  [sym_array_type_name] = sym_array_type_name,
  [sym_generic_type_name] = sym_generic_type_name,
  [sym_assignement_operator] = sym_assignement_operator,
  [sym_file_redirection_operator] = sym_file_redirection_operator,
  [sym_merging_redirection_operator] = sym_merging_redirection_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_variable] = sym_variable,
  [aux_sym__verbatim_command_argument_chars] = aux_sym__verbatim_command_argument_chars,
  [sym_script_block] = sym_script_block,
  [sym_param_block] = sym_param_block,
  [sym_parameter_list] = sym_parameter_list,
  [sym_script_parameter] = sym_script_parameter,
  [sym_script_parameter_default] = sym_script_parameter_default,
  [sym_script_block_body] = sym_script_block_body,
  [sym_named_block_list] = sym_named_block_list,
  [sym_named_block] = sym_named_block,
  [sym_block_name] = sym_block_name,
  [sym_statement_block] = sym_statement_block,
  [sym_statement_list] = sym_statement_list,
  [sym__statement] = sym__statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_clauses] = sym_elseif_clauses,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym__labeled_statement] = sym__labeled_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_parameters] = sym_switch_parameters,
  [sym_switch_parameter] = sym_switch_parameter,
  [sym_switch_condition] = sym_switch_condition,
  [sym_switch_filename] = sym_switch_filename,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_clauses] = sym_switch_clauses,
  [sym_switch_clause] = sym_switch_clause,
  [sym_switch_clause_condition] = sym_switch_clause_condition,
  [sym_foreach_statement] = sym_foreach_statement,
  [sym_foreach_parameter] = sym_foreach_parameter,
  [sym_for_statement] = sym_for_statement,
  [sym_for_initializer] = sym_for_initializer,
  [sym_for_condition] = sym_for_condition,
  [sym_for_iterator] = sym_for_iterator,
  [sym_while_statement] = sym_while_statement,
  [sym_while_condition] = sym_while_condition,
  [sym_do_statement] = sym_do_statement,
  [sym_function_statement] = sym_function_statement,
  [sym_function_name] = sym_function_name,
  [sym_function_parameter_declaration] = sym_function_parameter_declaration,
  [sym_flow_control_statement] = sym_flow_control_statement,
  [sym_label_expression] = sym_label_expression,
  [sym_trap_statement] = sym_trap_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clauses] = sym_catch_clauses,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_type_list] = sym_catch_type_list,
  [sym_finally_clause] = sym_finally_clause,
  [sym_data_statement] = sym_data_statement,
  [sym_data_name] = sym_data_name,
  [sym_data_commands_allowed] = sym_data_commands_allowed,
  [sym_data_commands_list] = sym_data_commands_list,
  [sym_data_command] = sym_data_command,
  [sym_inlinescript_statement] = sym_inlinescript_statement,
  [sym_parallel_statement] = sym_parallel_statement,
  [sym_sequence_statement] = sym_sequence_statement,
  [sym_pipeline] = sym_pipeline,
  [sym_left_assignment_expression] = sym_left_assignment_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [aux_sym__pipeline_tail] = aux_sym__pipeline_tail,
  [sym_command] = sym_command,
  [sym_command_invokation_operator] = sym_command_invokation_operator,
  [sym__expandable_string_literal_immediate] = sym__expandable_string_literal_immediate,
  [sym_command_name] = sym_command_name,
  [sym_path_command_name] = sym_path_command_name,
  [sym_command_name_expr] = sym_command_name_expr,
  [sym_command_elements] = sym_command_elements,
  [sym__command_element] = sym__command_element,
  [sym_command_argument_sep] = sym_command_argument_sep,
  [sym__command_argument] = sym__command_argument,
  [sym_foreach_command] = sym_foreach_command,
  [sym_verbatim_command_argument] = sym_verbatim_command_argument,
  [sym_redirections] = sym_redirections,
  [sym_redirection] = sym_redirection,
  [sym_redirected_file_name] = sym_redirected_file_name,
  [sym_class_attribute] = sym_class_attribute,
  [sym_class_property_definition] = sym_class_property_definition,
  [sym_class_method_parameter] = sym_class_method_parameter,
  [sym_class_method_parameter_list] = sym_class_method_parameter_list,
  [sym_class_method_definition] = sym_class_method_definition,
  [sym_class_statement] = sym_class_statement,
  [sym_enum_statement] = sym_enum_statement,
  [sym_enum_member] = sym_enum_member,
  [sym__expression] = sym__expression,
  [sym_logical_expression] = sym_logical_expression,
  [sym_bitwise_expression] = sym_bitwise_expression,
  [sym_comparison_expression] = sym_comparison_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_format_expression] = sym_format_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_array_literal_expression] = sym_array_literal_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_expression_with_unary_operator] = sym_expression_with_unary_operator,
  [sym_pre_increment_expression] = sym_pre_increment_expression,
  [sym_pre_decrement_expression] = sym_pre_decrement_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym__value] = sym__value,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_sub_expression] = sym_sub_expression,
  [sym_array_expression] = sym_array_expression,
  [sym_script_block_expression] = sym_script_block_expression,
  [sym_hash_literal_expression] = sym_hash_literal_expression,
  [sym_hash_literal_body] = sym_hash_literal_body,
  [sym_hash_entry] = sym_hash_entry,
  [sym_key_expression] = sym_key_expression,
  [sym_post_increment_expression] = sym_post_increment_expression,
  [sym_post_decrement_expression] = sym_post_decrement_expression,
  [sym_member_access] = sym_member_access,
  [sym_member_name] = sym_member_name,
  [sym_element_access] = sym_element_access,
  [sym_invokation_expression] = sym_invokation_expression,
  [sym_invokation_foreach_expression] = sym_invokation_foreach_expression,
  [sym_argument_list] = sym_argument_list,
  [sym_argument_expression_list] = sym_argument_expression_list,
  [sym_argument_expression] = sym_argument_expression,
  [sym_logical_argument_expression] = sym_logical_argument_expression,
  [sym_bitwise_argument_expression] = sym_bitwise_argument_expression,
  [sym_comparison_argument_expression] = sym_comparison_argument_expression,
  [sym_additive_argument_expression] = sym_additive_argument_expression,
  [sym_multiplicative_argument_expression] = sym_multiplicative_argument_expression,
  [sym_format_argument_expression] = sym_format_argument_expression,
  [sym_range_argument_expression] = sym_range_argument_expression,
  [sym_type_literal] = sym_type_literal,
  [sym_type_spec] = sym_type_spec,
  [sym_dimension] = sym_dimension,
  [sym_generic_type_arguments] = sym_generic_type_arguments,
  [sym_attribute_list] = sym_attribute_list,
  [sym_attribute] = sym_attribute,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_arguments] = sym_attribute_arguments,
  [sym_attribute_argument] = sym_attribute_argument,
  [aux_sym_expandable_string_literal_repeat1] = aux_sym_expandable_string_literal_repeat1,
  [aux_sym_expandable_string_literal_repeat2] = aux_sym_expandable_string_literal_repeat2,
  [aux_sym_expandable_here_string_literal_repeat1] = aux_sym_expandable_here_string_literal_repeat1,
  [aux_sym_script_block_repeat1] = aux_sym_script_block_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_named_block_list_repeat1] = aux_sym_named_block_list_repeat1,
  [aux_sym_statement_list_repeat1] = aux_sym_statement_list_repeat1,
  [aux_sym_elseif_clauses_repeat1] = aux_sym_elseif_clauses_repeat1,
  [aux_sym_switch_parameters_repeat1] = aux_sym_switch_parameters_repeat1,
  [aux_sym_switch_clauses_repeat1] = aux_sym_switch_clauses_repeat1,
  [aux_sym_catch_clauses_repeat1] = aux_sym_catch_clauses_repeat1,
  [aux_sym_catch_type_list_repeat1] = aux_sym_catch_type_list_repeat1,
  [aux_sym_data_commands_list_repeat1] = aux_sym_data_commands_list_repeat1,
  [aux_sym__expandable_string_literal_immediate_repeat1] = aux_sym__expandable_string_literal_immediate_repeat1,
  [aux_sym__expandable_string_literal_immediate_repeat2] = aux_sym__expandable_string_literal_immediate_repeat2,
  [aux_sym_command_name_repeat1] = aux_sym_command_name_repeat1,
  [aux_sym_path_command_name_repeat1] = aux_sym_path_command_name_repeat1,
  [aux_sym_command_elements_repeat1] = aux_sym_command_elements_repeat1,
  [aux_sym_command_argument_sep_repeat1] = aux_sym_command_argument_sep_repeat1,
  [aux_sym_foreach_command_repeat1] = aux_sym_foreach_command_repeat1,
  [aux_sym_redirections_repeat1] = aux_sym_redirections_repeat1,
  [aux_sym_class_property_definition_repeat1] = aux_sym_class_property_definition_repeat1,
  [aux_sym_class_method_parameter_list_repeat1] = aux_sym_class_method_parameter_list_repeat1,
  [aux_sym_class_statement_repeat1] = aux_sym_class_statement_repeat1,
  [aux_sym_class_statement_repeat2] = aux_sym_class_statement_repeat2,
  [aux_sym_enum_statement_repeat1] = aux_sym_enum_statement_repeat1,
  [aux_sym_hash_literal_body_repeat1] = aux_sym_hash_literal_body_repeat1,
  [aux_sym_argument_expression_list_repeat1] = aux_sym_argument_expression_list_repeat1,
  [aux_sym_dimension_repeat1] = aux_sym_dimension_repeat1,
  [aux_sym_generic_type_arguments_repeat1] = aux_sym_generic_type_arguments_repeat1,
  [aux_sym_attribute_list_repeat1] = aux_sym_attribute_list_repeat1,
  [aux_sym_attribute_arguments_repeat1] = aux_sym_attribute_arguments_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hexadecimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_real_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_expandable_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_string_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_string_literal_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_expandable_string_literal_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_here_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_here_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_here_string_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_here_string_literal_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_here_string_literal_token5] = {
    .visible = false,
    .named = false,
  },
  [sym_verbatim_string_characters] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_here_string_characters] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_GT_AMP1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2_GT_AMP1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3_GT_AMP1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4_GT_AMP1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5_GT_AMP1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6_GT_AMP1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_GT_AMP2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_1_GT_AMP2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3_GT_AMP2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4_GT_AMP2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5_GT_AMP2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6_GT_AMP2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHccontains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHclike] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHclt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcne] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcnotcontains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcnotlike] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcnotmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcontains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcreplace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcsplit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHicontains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHieq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHige] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHigt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHilike] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHilt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHimatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHinotcontains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHinotlike] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHinotmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHireplace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHis] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHisnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHisplit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHjoin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHlike] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHlt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHne] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHnotcontains] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHnotlike] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHnotmatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHreplace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHshl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHshr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHsplit] = {
    .visible = true,
    .named = false,
  },
  [sym_format_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_braced_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_token] = {
    .visible = true,
    .named = true,
  },
  [sym__command_token] = {
    .visible = false,
    .named = true,
  },
  [sym_command_parameter] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__verbatim_command_argument_chars_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__verbatim_command_argument_chars_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__verbatim_command_argument_chars_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamicparam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_process] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHregex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHwildcard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHexact] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHcasesensitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHparallel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_workflow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exit] = {
    .visible = true,
    .named = false,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_trap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_data] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHsupportedcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlinescript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parallel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sequence] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__expandable_string_literal_immediate_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expandable_string_literal_immediate_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expandable_string_literal_immediate_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_command_name_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_name_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_path_command_name_token] = {
    .visible = true,
    .named = true,
  },
  [sym_stop_parsing] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hidden] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHxor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHband] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHbor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHbxor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASHbnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTforeach] = {
    .visible = true,
    .named = false,
  },
  [sym__statement_terminator] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_expandable_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_expandable_here_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_assignement_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirection_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_merging_redirection_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__verbatim_command_argument_chars] = {
    .visible = false,
    .named = false,
  },
  [sym_script_block] = {
    .visible = true,
    .named = true,
  },
  [sym_param_block] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_script_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_script_parameter_default] = {
    .visible = true,
    .named = true,
  },
  [sym_script_block_body] = {
    .visible = true,
    .named = true,
  },
  [sym_named_block_list] = {
    .visible = true,
    .named = true,
  },
  [sym_named_block] = {
    .visible = true,
    .named = true,
  },
  [sym_block_name] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_list] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_filename] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_clause_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_for_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_for_iterator] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_control_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_label_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_trap_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_data_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_data_name] = {
    .visible = true,
    .named = true,
  },
  [sym_data_commands_allowed] = {
    .visible = true,
    .named = true,
  },
  [sym_data_commands_list] = {
    .visible = true,
    .named = true,
  },
  [sym_data_command] = {
    .visible = true,
    .named = true,
  },
  [sym_inlinescript_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_left_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__pipeline_tail] = {
    .visible = false,
    .named = false,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_invokation_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__expandable_string_literal_immediate] = {
    .visible = false,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_path_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_command_elements] = {
    .visible = true,
    .named = true,
  },
  [sym__command_element] = {
    .visible = false,
    .named = true,
  },
  [sym_command_argument_sep] = {
    .visible = true,
    .named = true,
  },
  [sym__command_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_foreach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_command_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_redirections] = {
    .visible = true,
    .named = true,
  },
  [sym_redirection] = {
    .visible = true,
    .named = true,
  },
  [sym_redirected_file_name] = {
    .visible = true,
    .named = true,
  },
  [sym_class_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class_property_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_method_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_class_method_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_logical_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_with_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_pre_increment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pre_decrement_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sub_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_script_block_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_literal_body] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_key_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_post_increment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_post_decrement_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_access] = {
    .visible = true,
    .named = true,
  },
  [sym_member_name] = {
    .visible = true,
    .named = true,
  },
  [sym_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_invokation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_invokation_foreach_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_format_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_argument_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_dimension] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_argument] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_expandable_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expandable_here_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_script_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_block_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elseif_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_commands_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expandable_string_literal_immediate_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expandable_string_literal_immediate_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_path_command_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_argument_sep_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_foreach_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_redirections_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_property_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_method_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hash_literal_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimension_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_argument_expression_list = 1,
  field_command_elements = 2,
  field_command_name = 3,
  field_condition = 4,
  field_else_clause = 5,
  field_elseif_clauses = 6,
  field_for_condition = 7,
  field_for_initializer = 8,
  field_for_iterator = 9,
  field_named_block_list = 10,
  field_script_block_body = 11,
  field_statement_list = 12,
  field_statements = 13,
  field_value = 14,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument_expression_list] = "argument_expression_list",
  [field_command_elements] = "command_elements",
  [field_command_name] = "command_name",
  [field_condition] = "condition",
  [field_else_clause] = "else_clause",
  [field_elseif_clauses] = "elseif_clauses",
  [field_for_condition] = "for_condition",
  [field_for_initializer] = "for_initializer",
  [field_for_iterator] = "for_iterator",
  [field_named_block_list] = "named_block_list",
  [field_script_block_body] = "script_block_body",
  [field_statement_list] = "statement_list",
  [field_statements] = "statements",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 1},
  [9] = {.index = 9, .length = 1},
  [10] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 14, .length = 1},
  [14] = {.index = 15, .length = 1},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 18, .length = 2},
  [17] = {.index = 20, .length = 1},
  [18] = {.index = 21, .length = 1},
  [19] = {.index = 22, .length = 1},
  [20] = {.index = 23, .length = 3},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 2},
  [24] = {.index = 30, .length = 2},
  [25] = {.index = 32, .length = 2},
  [26] = {.index = 34, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_command_name, 0},
  [1] =
    {field_script_block_body, 0},
  [2] =
    {field_named_block_list, 0},
  [3] =
    {field_statement_list, 0},
  [4] =
    {field_command_elements, 1},
  [5] =
    {field_command_name, 1},
  [6] =
    {field_command_elements, 1},
    {field_command_name, 0},
  [8] =
    {field_statements, 1},
  [9] =
    {field_value, 2},
  [10] =
    {field_command_elements, 2},
    {field_command_name, 1},
  [12] =
    {field_script_block_body, 2},
  [13] =
    {field_statement_list, 1},
  [14] =
    {field_script_block_body, 3},
  [15] =
    {field_condition, 2},
  [16] =
    {field_condition, 2},
    {field_elseif_clauses, 5},
  [18] =
    {field_condition, 2},
    {field_else_clause, 5},
  [20] =
    {field_for_initializer, 2},
  [21] =
    {field_condition, 4},
  [22] =
    {field_argument_expression_list, 1},
  [23] =
    {field_condition, 2},
    {field_else_clause, 6},
    {field_elseif_clauses, 5},
  [26] =
    {field_for_condition, 3},
  [27] =
    {field_for_iterator, 4},
  [28] =
    {field_for_condition, 5},
    {field_for_initializer, 2},
  [30] =
    {field_for_condition, 3},
    {field_for_iterator, 6},
  [32] =
    {field_for_initializer, 2},
    {field_for_iterator, 6},
  [34] =
    {field_for_condition, 5},
    {field_for_initializer, 2},
    {field_for_iterator, 8},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 3,
  [5] = 3,
  [6] = 3,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 9,
  [12] = 10,
  [13] = 13,
  [14] = 13,
  [15] = 13,
  [16] = 9,
  [17] = 13,
  [18] = 10,
  [19] = 13,
  [20] = 9,
  [21] = 21,
  [22] = 13,
  [23] = 13,
  [24] = 13,
  [25] = 25,
  [26] = 10,
  [27] = 13,
  [28] = 13,
  [29] = 29,
  [30] = 30,
  [31] = 30,
  [32] = 30,
  [33] = 30,
  [34] = 30,
  [35] = 30,
  [36] = 30,
  [37] = 30,
  [38] = 30,
  [39] = 30,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 42,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 45,
  [48] = 44,
  [49] = 46,
  [50] = 46,
  [51] = 45,
  [52] = 44,
  [53] = 46,
  [54] = 45,
  [55] = 44,
  [56] = 45,
  [57] = 45,
  [58] = 46,
  [59] = 44,
  [60] = 60,
  [61] = 45,
  [62] = 45,
  [63] = 46,
  [64] = 46,
  [65] = 44,
  [66] = 45,
  [67] = 45,
  [68] = 44,
  [69] = 69,
  [70] = 44,
  [71] = 45,
  [72] = 46,
  [73] = 69,
  [74] = 60,
  [75] = 75,
  [76] = 3,
  [77] = 3,
  [78] = 78,
  [79] = 3,
  [80] = 3,
  [81] = 78,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 83,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 83,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 84,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 83,
  [118] = 118,
  [119] = 119,
  [120] = 86,
  [121] = 121,
  [122] = 92,
  [123] = 113,
  [124] = 115,
  [125] = 91,
  [126] = 97,
  [127] = 101,
  [128] = 128,
  [129] = 99,
  [130] = 121,
  [131] = 110,
  [132] = 111,
  [133] = 106,
  [134] = 107,
  [135] = 89,
  [136] = 88,
  [137] = 128,
  [138] = 100,
  [139] = 93,
  [140] = 90,
  [141] = 114,
  [142] = 98,
  [143] = 119,
  [144] = 87,
  [145] = 104,
  [146] = 109,
  [147] = 108,
  [148] = 105,
  [149] = 94,
  [150] = 95,
  [151] = 116,
  [152] = 102,
  [153] = 118,
  [154] = 103,
  [155] = 128,
  [156] = 128,
  [157] = 90,
  [158] = 118,
  [159] = 97,
  [160] = 119,
  [161] = 161,
  [162] = 100,
  [163] = 89,
  [164] = 164,
  [165] = 164,
  [166] = 161,
  [167] = 167,
  [168] = 97,
  [169] = 167,
  [170] = 170,
  [171] = 89,
  [172] = 100,
  [173] = 119,
  [174] = 118,
  [175] = 170,
  [176] = 90,
  [177] = 177,
  [178] = 178,
  [179] = 178,
  [180] = 177,
  [181] = 181,
  [182] = 181,
  [183] = 183,
  [184] = 183,
  [185] = 185,
  [186] = 185,
  [187] = 187,
  [188] = 187,
  [189] = 42,
  [190] = 42,
  [191] = 191,
  [192] = 191,
  [193] = 193,
  [194] = 193,
  [195] = 195,
  [196] = 3,
  [197] = 3,
  [198] = 198,
  [199] = 198,
  [200] = 195,
  [201] = 3,
  [202] = 3,
  [203] = 3,
  [204] = 3,
  [205] = 205,
  [206] = 206,
  [207] = 206,
  [208] = 205,
  [209] = 206,
  [210] = 206,
  [211] = 211,
  [212] = 211,
  [213] = 205,
  [214] = 214,
  [215] = 214,
  [216] = 205,
  [217] = 214,
  [218] = 214,
  [219] = 211,
  [220] = 211,
  [221] = 221,
  [222] = 222,
  [223] = 222,
  [224] = 222,
  [225] = 225,
  [226] = 225,
  [227] = 221,
  [228] = 221,
  [229] = 225,
  [230] = 221,
  [231] = 222,
  [232] = 225,
  [233] = 233,
  [234] = 234,
  [235] = 234,
  [236] = 236,
  [237] = 236,
  [238] = 238,
  [239] = 233,
  [240] = 234,
  [241] = 238,
  [242] = 236,
  [243] = 233,
  [244] = 233,
  [245] = 236,
  [246] = 234,
  [247] = 238,
  [248] = 238,
  [249] = 249,
  [250] = 249,
  [251] = 251,
  [252] = 249,
  [253] = 251,
  [254] = 254,
  [255] = 251,
  [256] = 251,
  [257] = 249,
  [258] = 258,
  [259] = 259,
  [260] = 259,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 262,
  [265] = 261,
  [266] = 263,
  [267] = 262,
  [268] = 259,
  [269] = 259,
  [270] = 258,
  [271] = 262,
  [272] = 261,
  [273] = 261,
  [274] = 258,
  [275] = 275,
  [276] = 258,
  [277] = 258,
  [278] = 263,
  [279] = 263,
  [280] = 258,
  [281] = 258,
  [282] = 258,
  [283] = 128,
  [284] = 128,
  [285] = 128,
  [286] = 128,
  [287] = 287,
  [288] = 287,
  [289] = 42,
  [290] = 290,
  [291] = 291,
  [292] = 42,
  [293] = 177,
  [294] = 170,
  [295] = 42,
  [296] = 291,
  [297] = 167,
  [298] = 167,
  [299] = 290,
  [300] = 167,
  [301] = 178,
  [302] = 170,
  [303] = 303,
  [304] = 42,
  [305] = 170,
  [306] = 306,
  [307] = 178,
  [308] = 308,
  [309] = 306,
  [310] = 306,
  [311] = 311,
  [312] = 306,
  [313] = 313,
  [314] = 181,
  [315] = 177,
  [316] = 316,
  [317] = 177,
  [318] = 318,
  [319] = 319,
  [320] = 178,
  [321] = 321,
  [322] = 322,
  [323] = 183,
  [324] = 324,
  [325] = 325,
  [326] = 324,
  [327] = 327,
  [328] = 328,
  [329] = 319,
  [330] = 330,
  [331] = 322,
  [332] = 181,
  [333] = 324,
  [334] = 185,
  [335] = 324,
  [336] = 324,
  [337] = 337,
  [338] = 187,
  [339] = 183,
  [340] = 340,
  [341] = 324,
  [342] = 321,
  [343] = 183,
  [344] = 313,
  [345] = 324,
  [346] = 346,
  [347] = 181,
  [348] = 324,
  [349] = 349,
  [350] = 349,
  [351] = 185,
  [352] = 352,
  [353] = 353,
  [354] = 352,
  [355] = 355,
  [356] = 356,
  [357] = 187,
  [358] = 358,
  [359] = 359,
  [360] = 187,
  [361] = 361,
  [362] = 185,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 352,
  [369] = 369,
  [370] = 359,
  [371] = 361,
  [372] = 367,
  [373] = 349,
  [374] = 42,
  [375] = 367,
  [376] = 353,
  [377] = 42,
  [378] = 367,
  [379] = 366,
  [380] = 352,
  [381] = 349,
  [382] = 367,
  [383] = 363,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 87,
  [395] = 393,
  [396] = 392,
  [397] = 349,
  [398] = 393,
  [399] = 399,
  [400] = 387,
  [401] = 401,
  [402] = 352,
  [403] = 403,
  [404] = 387,
  [405] = 405,
  [406] = 406,
  [407] = 83,
  [408] = 393,
  [409] = 387,
  [410] = 393,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 387,
  [415] = 83,
  [416] = 416,
  [417] = 387,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 387,
  [426] = 426,
  [427] = 427,
  [428] = 387,
  [429] = 429,
  [430] = 430,
  [431] = 87,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 104,
  [457] = 390,
  [458] = 392,
  [459] = 94,
  [460] = 95,
  [461] = 427,
  [462] = 439,
  [463] = 83,
  [464] = 453,
  [465] = 87,
  [466] = 405,
  [467] = 450,
  [468] = 448,
  [469] = 445,
  [470] = 92,
  [471] = 84,
  [472] = 193,
  [473] = 97,
  [474] = 443,
  [475] = 416,
  [476] = 476,
  [477] = 432,
  [478] = 115,
  [479] = 118,
  [480] = 119,
  [481] = 92,
  [482] = 90,
  [483] = 102,
  [484] = 418,
  [485] = 420,
  [486] = 385,
  [487] = 430,
  [488] = 426,
  [489] = 100,
  [490] = 89,
  [491] = 403,
  [492] = 455,
  [493] = 87,
  [494] = 454,
  [495] = 42,
  [496] = 83,
  [497] = 429,
  [498] = 109,
  [499] = 91,
  [500] = 98,
  [501] = 88,
  [502] = 105,
  [503] = 103,
  [504] = 106,
  [505] = 452,
  [506] = 107,
  [507] = 86,
  [508] = 110,
  [509] = 111,
  [510] = 421,
  [511] = 108,
  [512] = 128,
  [513] = 116,
  [514] = 101,
  [515] = 86,
  [516] = 87,
  [517] = 451,
  [518] = 449,
  [519] = 447,
  [520] = 113,
  [521] = 446,
  [522] = 401,
  [523] = 352,
  [524] = 114,
  [525] = 406,
  [526] = 413,
  [527] = 434,
  [528] = 391,
  [529] = 93,
  [530] = 530,
  [531] = 389,
  [532] = 87,
  [533] = 388,
  [534] = 440,
  [535] = 442,
  [536] = 121,
  [537] = 99,
  [538] = 84,
  [539] = 109,
  [540] = 42,
  [541] = 441,
  [542] = 104,
  [543] = 102,
  [544] = 544,
  [545] = 89,
  [546] = 99,
  [547] = 547,
  [548] = 121,
  [549] = 438,
  [550] = 437,
  [551] = 435,
  [552] = 114,
  [553] = 95,
  [554] = 94,
  [555] = 113,
  [556] = 556,
  [557] = 100,
  [558] = 111,
  [559] = 559,
  [560] = 530,
  [561] = 433,
  [562] = 547,
  [563] = 423,
  [564] = 436,
  [565] = 349,
  [566] = 90,
  [567] = 547,
  [568] = 93,
  [569] = 119,
  [570] = 570,
  [571] = 110,
  [572] = 118,
  [573] = 91,
  [574] = 115,
  [575] = 105,
  [576] = 576,
  [577] = 103,
  [578] = 108,
  [579] = 128,
  [580] = 559,
  [581] = 547,
  [582] = 424,
  [583] = 191,
  [584] = 584,
  [585] = 107,
  [586] = 106,
  [587] = 88,
  [588] = 544,
  [589] = 98,
  [590] = 116,
  [591] = 547,
  [592] = 570,
  [593] = 412,
  [594] = 101,
  [595] = 392,
  [596] = 584,
  [597] = 411,
  [598] = 444,
  [599] = 576,
  [600] = 97,
  [601] = 399,
  [602] = 602,
  [603] = 103,
  [604] = 308,
  [605] = 602,
  [606] = 89,
  [607] = 98,
  [608] = 88,
  [609] = 570,
  [610] = 100,
  [611] = 3,
  [612] = 193,
  [613] = 106,
  [614] = 107,
  [615] = 42,
  [616] = 121,
  [617] = 576,
  [618] = 544,
  [619] = 95,
  [620] = 193,
  [621] = 3,
  [622] = 118,
  [623] = 98,
  [624] = 119,
  [625] = 115,
  [626] = 90,
  [627] = 110,
  [628] = 544,
  [629] = 88,
  [630] = 106,
  [631] = 3,
  [632] = 3,
  [633] = 86,
  [634] = 570,
  [635] = 104,
  [636] = 94,
  [637] = 102,
  [638] = 93,
  [639] = 191,
  [640] = 92,
  [641] = 576,
  [642] = 113,
  [643] = 114,
  [644] = 119,
  [645] = 645,
  [646] = 91,
  [647] = 584,
  [648] = 109,
  [649] = 84,
  [650] = 650,
  [651] = 121,
  [652] = 118,
  [653] = 195,
  [654] = 654,
  [655] = 99,
  [656] = 87,
  [657] = 42,
  [658] = 654,
  [659] = 602,
  [660] = 109,
  [661] = 602,
  [662] = 104,
  [663] = 102,
  [664] = 530,
  [665] = 198,
  [666] = 584,
  [667] = 559,
  [668] = 95,
  [669] = 311,
  [670] = 94,
  [671] = 93,
  [672] = 91,
  [673] = 107,
  [674] = 97,
  [675] = 105,
  [676] = 101,
  [677] = 99,
  [678] = 678,
  [679] = 100,
  [680] = 87,
  [681] = 105,
  [682] = 92,
  [683] = 89,
  [684] = 103,
  [685] = 191,
  [686] = 602,
  [687] = 84,
  [688] = 108,
  [689] = 128,
  [690] = 530,
  [691] = 116,
  [692] = 318,
  [693] = 111,
  [694] = 694,
  [695] = 110,
  [696] = 111,
  [697] = 650,
  [698] = 90,
  [699] = 694,
  [700] = 113,
  [701] = 114,
  [702] = 97,
  [703] = 101,
  [704] = 86,
  [705] = 116,
  [706] = 108,
  [707] = 559,
  [708] = 128,
  [709] = 115,
  [710] = 654,
  [711] = 650,
  [712] = 712,
  [713] = 198,
  [714] = 714,
  [715] = 694,
  [716] = 712,
  [717] = 195,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 198,
  [722] = 712,
  [723] = 654,
  [724] = 712,
  [725] = 650,
  [726] = 714,
  [727] = 195,
  [728] = 694,
  [729] = 719,
  [730] = 712,
  [731] = 731,
  [732] = 732,
  [733] = 732,
  [734] = 719,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 732,
  [739] = 739,
  [740] = 732,
  [741] = 714,
  [742] = 737,
  [743] = 714,
  [744] = 736,
  [745] = 732,
  [746] = 719,
  [747] = 747,
  [748] = 748,
  [749] = 748,
  [750] = 748,
  [751] = 736,
  [752] = 752,
  [753] = 87,
  [754] = 754,
  [755] = 748,
  [756] = 756,
  [757] = 757,
  [758] = 748,
  [759] = 756,
  [760] = 87,
  [761] = 737,
  [762] = 754,
  [763] = 736,
  [764] = 737,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 87,
  [770] = 768,
  [771] = 766,
  [772] = 767,
  [773] = 768,
  [774] = 766,
  [775] = 768,
  [776] = 767,
  [777] = 754,
  [778] = 768,
  [779] = 756,
  [780] = 767,
  [781] = 781,
  [782] = 782,
  [783] = 766,
  [784] = 766,
  [785] = 781,
  [786] = 766,
  [787] = 767,
  [788] = 766,
  [789] = 768,
  [790] = 767,
  [791] = 766,
  [792] = 766,
  [793] = 767,
  [794] = 766,
  [795] = 766,
  [796] = 768,
  [797] = 767,
  [798] = 765,
  [799] = 766,
  [800] = 800,
  [801] = 767,
  [802] = 802,
  [803] = 768,
  [804] = 766,
  [805] = 767,
  [806] = 768,
  [807] = 768,
  [808] = 768,
  [809] = 767,
  [810] = 767,
  [811] = 766,
  [812] = 782,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 768,
  [817] = 766,
  [818] = 768,
  [819] = 767,
  [820] = 766,
  [821] = 814,
  [822] = 767,
  [823] = 813,
  [824] = 766,
  [825] = 767,
  [826] = 813,
  [827] = 768,
  [828] = 768,
  [829] = 767,
  [830] = 87,
  [831] = 754,
  [832] = 768,
  [833] = 767,
  [834] = 800,
  [835] = 768,
  [836] = 756,
  [837] = 815,
  [838] = 813,
  [839] = 768,
  [840] = 766,
  [841] = 767,
  [842] = 814,
  [843] = 782,
  [844] = 800,
  [845] = 800,
  [846] = 781,
  [847] = 781,
  [848] = 782,
  [849] = 765,
  [850] = 765,
  [851] = 815,
  [852] = 815,
  [853] = 814,
  [854] = 854,
  [855] = 854,
  [856] = 854,
  [857] = 854,
  [858] = 854,
  [859] = 854,
  [860] = 854,
  [861] = 854,
  [862] = 854,
  [863] = 854,
  [864] = 854,
  [865] = 854,
  [866] = 854,
  [867] = 854,
  [868] = 854,
  [869] = 854,
  [870] = 854,
  [871] = 854,
  [872] = 854,
  [873] = 854,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 876,
  [878] = 876,
  [879] = 876,
  [880] = 876,
  [881] = 876,
  [882] = 882,
  [883] = 883,
  [884] = 882,
  [885] = 882,
  [886] = 883,
  [887] = 882,
  [888] = 883,
  [889] = 883,
  [890] = 890,
  [891] = 42,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 894,
  [897] = 897,
  [898] = 897,
  [899] = 895,
  [900] = 83,
  [901] = 83,
  [902] = 116,
  [903] = 86,
  [904] = 119,
  [905] = 118,
  [906] = 84,
  [907] = 88,
  [908] = 100,
  [909] = 115,
  [910] = 91,
  [911] = 93,
  [912] = 105,
  [913] = 92,
  [914] = 103,
  [915] = 106,
  [916] = 107,
  [917] = 97,
  [918] = 108,
  [919] = 90,
  [920] = 114,
  [921] = 110,
  [922] = 101,
  [923] = 89,
  [924] = 94,
  [925] = 95,
  [926] = 111,
  [927] = 121,
  [928] = 102,
  [929] = 104,
  [930] = 98,
  [931] = 113,
  [932] = 109,
  [933] = 87,
  [934] = 99,
  [935] = 935,
  [936] = 935,
  [937] = 42,
  [938] = 83,
  [939] = 83,
  [940] = 113,
  [941] = 93,
  [942] = 90,
  [943] = 86,
  [944] = 110,
  [945] = 91,
  [946] = 102,
  [947] = 111,
  [948] = 115,
  [949] = 100,
  [950] = 118,
  [951] = 89,
  [952] = 94,
  [953] = 119,
  [954] = 128,
  [955] = 105,
  [956] = 103,
  [957] = 108,
  [958] = 107,
  [959] = 95,
  [960] = 87,
  [961] = 116,
  [962] = 92,
  [963] = 128,
  [964] = 99,
  [965] = 114,
  [966] = 88,
  [967] = 109,
  [968] = 84,
  [969] = 97,
  [970] = 98,
  [971] = 101,
  [972] = 106,
  [973] = 121,
  [974] = 104,
  [975] = 530,
  [976] = 42,
  [977] = 530,
  [978] = 316,
  [979] = 42,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 982,
  [985] = 983,
  [986] = 736,
  [987] = 736,
  [988] = 737,
  [989] = 737,
  [990] = 754,
  [991] = 754,
  [992] = 992,
  [993] = 756,
  [994] = 756,
  [995] = 781,
  [996] = 815,
  [997] = 814,
  [998] = 814,
  [999] = 815,
  [1000] = 765,
  [1001] = 782,
  [1002] = 781,
  [1003] = 765,
  [1004] = 782,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 316,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1010,
  [1016] = 1014,
  [1017] = 1010,
  [1018] = 1011,
  [1019] = 1013,
  [1020] = 1014,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1022,
  [1024] = 1013,
  [1025] = 1021,
  [1026] = 1010,
  [1027] = 1021,
  [1028] = 1022,
  [1029] = 1013,
  [1030] = 1011,
  [1031] = 1022,
  [1032] = 1021,
  [1033] = 1014,
  [1034] = 1011,
  [1035] = 1035,
  [1036] = 1035,
  [1037] = 1035,
  [1038] = 1035,
  [1039] = 1035,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1041,
  [1043] = 1043,
  [1044] = 1040,
  [1045] = 1041,
  [1046] = 1040,
  [1047] = 1040,
  [1048] = 1040,
  [1049] = 1040,
  [1050] = 1043,
  [1051] = 1041,
  [1052] = 1043,
  [1053] = 1040,
  [1054] = 1040,
  [1055] = 1041,
  [1056] = 1041,
  [1057] = 1041,
  [1058] = 1041,
  [1059] = 1043,
  [1060] = 1043,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1061,
  [1064] = 1064,
  [1065] = 1061,
  [1066] = 1062,
  [1067] = 1062,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1061,
  [1071] = 1062,
  [1072] = 1061,
  [1073] = 1061,
  [1074] = 1062,
  [1075] = 1062,
  [1076] = 1062,
  [1077] = 1061,
  [1078] = 1061,
  [1079] = 1062,
  [1080] = 392,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 87,
  [1084] = 1084,
  [1085] = 1084,
  [1086] = 1084,
  [1087] = 1082,
  [1088] = 1082,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 316,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 87,
  [1097] = 92,
  [1098] = 87,
  [1099] = 115,
  [1100] = 1100,
  [1101] = 115,
  [1102] = 92,
  [1103] = 87,
  [1104] = 115,
  [1105] = 92,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 719,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 349,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 714,
  [1123] = 352,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1126,
  [1128] = 1125,
  [1129] = 1126,
  [1130] = 1130,
  [1131] = 1125,
  [1132] = 1132,
  [1133] = 1126,
  [1134] = 1125,
  [1135] = 1135,
  [1136] = 128,
  [1137] = 87,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1130,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1141,
  [1145] = 1124,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 128,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1149,
  [1152] = 1147,
  [1153] = 894,
  [1154] = 897,
  [1155] = 1149,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1147,
  [1159] = 576,
  [1160] = 1147,
  [1161] = 1161,
  [1162] = 1149,
  [1163] = 128,
  [1164] = 894,
  [1165] = 570,
  [1166] = 1166,
  [1167] = 544,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 897,
  [1171] = 291,
  [1172] = 128,
  [1173] = 290,
  [1174] = 291,
  [1175] = 897,
  [1176] = 894,
  [1177] = 290,
  [1178] = 559,
  [1179] = 1169,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 650,
  [1186] = 694,
  [1187] = 1183,
  [1188] = 1181,
  [1189] = 1189,
  [1190] = 1182,
  [1191] = 1184,
  [1192] = 654,
  [1193] = 1189,
  [1194] = 1194,
  [1195] = 1184,
  [1196] = 1196,
  [1197] = 1196,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 319,
  [1202] = 313,
  [1203] = 1203,
  [1204] = 352,
  [1205] = 1198,
  [1206] = 1206,
  [1207] = 1199,
  [1208] = 1189,
  [1209] = 1198,
  [1210] = 1199,
  [1211] = 1198,
  [1212] = 1183,
  [1213] = 1189,
  [1214] = 935,
  [1215] = 1198,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1198,
  [1219] = 322,
  [1220] = 1198,
  [1221] = 1198,
  [1222] = 1198,
  [1223] = 1223,
  [1224] = 1198,
  [1225] = 1225,
  [1226] = 321,
  [1227] = 313,
  [1228] = 1183,
  [1229] = 1198,
  [1230] = 1198,
  [1231] = 1198,
  [1232] = 321,
  [1233] = 1198,
  [1234] = 319,
  [1235] = 1199,
  [1236] = 1198,
  [1237] = 1198,
  [1238] = 1198,
  [1239] = 322,
  [1240] = 1198,
  [1241] = 349,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1247,
  [1250] = 1250,
  [1251] = 1247,
  [1252] = 935,
  [1253] = 84,
  [1254] = 1247,
  [1255] = 1244,
  [1256] = 1245,
  [1257] = 1257,
  [1258] = 86,
  [1259] = 84,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1243,
  [1263] = 1263,
  [1264] = 1244,
  [1265] = 86,
  [1266] = 1248,
  [1267] = 1248,
  [1268] = 935,
  [1269] = 1248,
  [1270] = 1244,
  [1271] = 1243,
  [1272] = 1243,
  [1273] = 1273,
  [1274] = 361,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1276,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1280,
  [1286] = 1284,
  [1287] = 1287,
  [1288] = 1283,
  [1289] = 1289,
  [1290] = 1289,
  [1291] = 1287,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1276,
  [1297] = 1293,
  [1298] = 1298,
  [1299] = 1292,
  [1300] = 353,
  [1301] = 1293,
  [1302] = 1293,
  [1303] = 1303,
  [1304] = 1292,
  [1305] = 1295,
  [1306] = 1292,
  [1307] = 1307,
  [1308] = 353,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1287,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1289,
  [1317] = 1309,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1320,
  [1321] = 1277,
  [1322] = 1322,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1283,
  [1329] = 366,
  [1330] = 1298,
  [1331] = 1331,
  [1332] = 1298,
  [1333] = 1333,
  [1334] = 363,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1277,
  [1339] = 1339,
  [1340] = 1276,
  [1341] = 1283,
  [1342] = 1342,
  [1343] = 1276,
  [1344] = 1283,
  [1345] = 359,
  [1346] = 1289,
  [1347] = 1339,
  [1348] = 1298,
  [1349] = 1333,
  [1350] = 1292,
  [1351] = 1351,
  [1352] = 1331,
  [1353] = 1283,
  [1354] = 1309,
  [1355] = 1355,
  [1356] = 1356,
  [1357] = 1336,
  [1358] = 366,
  [1359] = 361,
  [1360] = 1298,
  [1361] = 1292,
  [1362] = 1362,
  [1363] = 363,
  [1364] = 1292,
  [1365] = 1336,
  [1366] = 1283,
  [1367] = 359,
  [1368] = 1339,
  [1369] = 1331,
  [1370] = 1339,
  [1371] = 1371,
  [1372] = 1318,
  [1373] = 1333,
  [1374] = 1277,
  [1375] = 1331,
  [1376] = 1283,
  [1377] = 1377,
  [1378] = 1333,
  [1379] = 1379,
  [1380] = 1292,
  [1381] = 1377,
  [1382] = 1382,
  [1383] = 1336,
  [1384] = 1382,
  [1385] = 1385,
  [1386] = 1309,
  [1387] = 1387,
  [1388] = 1287,
  [1389] = 1362,
  [1390] = 1390,
  [1391] = 1391,
  [1392] = 1392,
  [1393] = 1393,
  [1394] = 1394,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1390,
  [1411] = 1411,
  [1412] = 1401,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1390,
  [1420] = 1390,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1422,
  [1425] = 1425,
  [1426] = 1414,
  [1427] = 1427,
  [1428] = 1428,
  [1429] = 1429,
  [1430] = 1430,
  [1431] = 1431,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1408,
  [1436] = 1431,
  [1437] = 1423,
  [1438] = 1438,
  [1439] = 1392,
  [1440] = 1433,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1415,
  [1444] = 1416,
  [1445] = 1413,
  [1446] = 1446,
  [1447] = 1406,
  [1448] = 1448,
  [1449] = 1398,
  [1450] = 1417,
  [1451] = 1421,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1422,
  [1455] = 1393,
  [1456] = 1431,
  [1457] = 1423,
  [1458] = 1391,
  [1459] = 1434,
  [1460] = 1460,
  [1461] = 1446,
  [1462] = 1394,
  [1463] = 1395,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1401,
  [1467] = 1422,
  [1468] = 1468,
  [1469] = 1465,
  [1470] = 1401,
  [1471] = 1464,
  [1472] = 1446,
  [1473] = 1396,
  [1474] = 1452,
  [1475] = 1448,
  [1476] = 1460,
  [1477] = 1422,
  [1478] = 1404,
  [1479] = 1438,
  [1480] = 1397,
  [1481] = 1398,
  [1482] = 1482,
  [1483] = 1404,
  [1484] = 1423,
  [1485] = 1431,
  [1486] = 1486,
  [1487] = 1448,
  [1488] = 1422,
  [1489] = 1452,
  [1490] = 1421,
  [1491] = 1417,
  [1492] = 1416,
  [1493] = 1415,
  [1494] = 1397,
  [1495] = 1421,
  [1496] = 1414,
  [1497] = 1408,
  [1498] = 1438,
  [1499] = 1392,
  [1500] = 1417,
  [1501] = 1393,
  [1502] = 1394,
  [1503] = 1395,
  [1504] = 1396,
  [1505] = 1397,
  [1506] = 1398,
  [1507] = 1416,
  [1508] = 1415,
  [1509] = 1509,
  [1510] = 1404,
  [1511] = 1511,
  [1512] = 1448,
  [1513] = 1407,
  [1514] = 1514,
  [1515] = 1452,
  [1516] = 1396,
  [1517] = 1432,
  [1518] = 1395,
  [1519] = 1394,
  [1520] = 1520,
  [1521] = 1432,
  [1522] = 1522,
  [1523] = 1391,
  [1524] = 1430,
  [1525] = 1429,
  [1526] = 1428,
  [1527] = 1434,
  [1528] = 1427,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1407,
  [1532] = 1432,
  [1533] = 1446,
  [1534] = 1406,
  [1535] = 1407,
  [1536] = 1393,
  [1537] = 1413,
  [1538] = 1427,
  [1539] = 1428,
  [1540] = 1429,
  [1541] = 1430,
  [1542] = 1542,
  [1543] = 1442,
  [1544] = 1422,
  [1545] = 1433,
  [1546] = 1460,
  [1547] = 1414,
  [1548] = 1464,
  [1549] = 1408,
  [1550] = 1438,
  [1551] = 1413,
  [1552] = 1392,
  [1553] = 1406,
  [1554] = 1465,
  [1555] = 1430,
  [1556] = 1434,
  [1557] = 1422,
  [1558] = 1429,
  [1559] = 1391,
  [1560] = 1428,
  [1561] = 1460,
  [1562] = 1427,
  [1563] = 1563,
  [1564] = 1464,
  [1565] = 1465,
  [1566] = 800,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 445,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1572,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1583,
  [1588] = 1580,
  [1589] = 1578,
  [1590] = 1577,
  [1591] = 1573,
  [1592] = 1585,
  [1593] = 1584,
  [1594] = 1594,
  [1595] = 1582,
  [1596] = 1576,
  [1597] = 1575,
  [1598] = 1574,
  [1599] = 1579,
  [1600] = 1571,
  [1601] = 1571,
  [1602] = 1582,
  [1603] = 1584,
  [1604] = 1585,
  [1605] = 1605,
  [1606] = 1586,
  [1607] = 1583,
  [1608] = 1580,
  [1609] = 1609,
  [1610] = 1578,
  [1611] = 1577,
  [1612] = 1573,
  [1613] = 1594,
  [1614] = 1576,
  [1615] = 1575,
  [1616] = 1574,
  [1617] = 1579,
  [1618] = 1572,
  [1619] = 1619,
  [1620] = 1619,
  [1621] = 1619,
  [1622] = 1619,
  [1623] = 1619,
  [1624] = 1619,
  [1625] = 1619,
  [1626] = 1619,
  [1627] = 1619,
  [1628] = 1619,
  [1629] = 1572,
  [1630] = 1579,
  [1631] = 1619,
  [1632] = 1619,
  [1633] = 1574,
  [1634] = 1575,
  [1635] = 1576,
  [1636] = 1619,
  [1637] = 1619,
  [1638] = 1573,
  [1639] = 1577,
  [1640] = 1619,
  [1641] = 433,
  [1642] = 1578,
  [1643] = 435,
  [1644] = 1582,
  [1645] = 437,
  [1646] = 438,
  [1647] = 441,
  [1648] = 442,
  [1649] = 446,
  [1650] = 447,
  [1651] = 449,
  [1652] = 451,
  [1653] = 452,
  [1654] = 1572,
  [1655] = 1579,
  [1656] = 454,
  [1657] = 1574,
  [1658] = 1575,
  [1659] = 1576,
  [1660] = 455,
  [1661] = 426,
  [1662] = 1573,
  [1663] = 1577,
  [1664] = 1578,
  [1665] = 1582,
  [1666] = 430,
  [1667] = 385,
  [1668] = 432,
  [1669] = 448,
  [1670] = 450,
  [1671] = 453,
  [1672] = 427,
  [1673] = 434,
  [1674] = 436,
  [1675] = 1572,
  [1676] = 1579,
  [1677] = 444,
  [1678] = 1574,
  [1679] = 1575,
  [1680] = 1576,
  [1681] = 429,
  [1682] = 439,
  [1683] = 1573,
  [1684] = 1577,
  [1685] = 1578,
  [1686] = 1582,
  [1687] = 443,
  [1688] = 424,
  [1689] = 423,
  [1690] = 421,
  [1691] = 420,
  [1692] = 418,
  [1693] = 416,
  [1694] = 413,
  [1695] = 412,
  [1696] = 1572,
  [1697] = 1579,
  [1698] = 411,
  [1699] = 1574,
  [1700] = 1575,
  [1701] = 1576,
  [1702] = 406,
  [1703] = 405,
  [1704] = 1573,
  [1705] = 1577,
  [1706] = 1578,
  [1707] = 1582,
  [1708] = 403,
  [1709] = 401,
  [1710] = 1579,
  [1711] = 1574,
  [1712] = 1573,
  [1713] = 441,
  [1714] = 440,
  [1715] = 1579,
  [1716] = 1574,
  [1717] = 1573,
  [1718] = 388,
  [1719] = 389,
  [1720] = 1574,
  [1721] = 390,
  [1722] = 391,
  [1723] = 399,
  [1724] = 433,
  [1725] = 435,
  [1726] = 437,
  [1727] = 438,
  [1728] = 1619,
  [1729] = 1729,
  [1730] = 442,
  [1731] = 446,
  [1732] = 447,
  [1733] = 449,
  [1734] = 451,
  [1735] = 452,
  [1736] = 454,
  [1737] = 455,
  [1738] = 426,
  [1739] = 430,
  [1740] = 385,
  [1741] = 432,
  [1742] = 445,
  [1743] = 448,
  [1744] = 450,
  [1745] = 453,
  [1746] = 427,
  [1747] = 308,
  [1748] = 434,
  [1749] = 436,
  [1750] = 444,
  [1751] = 1751,
  [1752] = 429,
  [1753] = 1753,
  [1754] = 439,
  [1755] = 1755,
  [1756] = 443,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 424,
  [1760] = 1760,
  [1761] = 423,
  [1762] = 421,
  [1763] = 420,
  [1764] = 418,
  [1765] = 1765,
  [1766] = 416,
  [1767] = 413,
  [1768] = 412,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 411,
  [1772] = 318,
  [1773] = 406,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 405,
  [1778] = 1778,
  [1779] = 403,
  [1780] = 401,
  [1781] = 311,
  [1782] = 1782,
  [1783] = 440,
  [1784] = 388,
  [1785] = 389,
  [1786] = 390,
  [1787] = 391,
  [1788] = 399,
  [1789] = 1789,
  [1790] = 1619,
  [1791] = 1729,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1778,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1801,
  [1802] = 1751,
  [1803] = 1803,
  [1804] = 1753,
  [1805] = 1755,
  [1806] = 1806,
  [1807] = 1757,
  [1808] = 1758,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1776,
  [1813] = 1765,
  [1814] = 1775,
  [1815] = 1774,
  [1816] = 1816,
  [1817] = 1769,
  [1818] = 1770,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1774,
  [1823] = 1775,
  [1824] = 1776,
  [1825] = 1825,
  [1826] = 1778,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1833,
  [1834] = 1770,
  [1835] = 1769,
  [1836] = 1836,
  [1837] = 1582,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1584,
  [1841] = 1841,
  [1842] = 1585,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1765,
  [1846] = 1846,
  [1847] = 1751,
  [1848] = 1848,
  [1849] = 1755,
  [1850] = 1605,
  [1851] = 1757,
  [1852] = 1758,
  [1853] = 1586,
  [1854] = 1854,
  [1855] = 1855,
  [1856] = 1578,
  [1857] = 1765,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1583,
  [1861] = 1769,
  [1862] = 1770,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1774,
  [1867] = 1775,
  [1868] = 1776,
  [1869] = 1869,
  [1870] = 1778,
  [1871] = 1871,
  [1872] = 1580,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1875,
  [1876] = 1760,
  [1877] = 1609,
  [1878] = 1753,
  [1879] = 1782,
  [1880] = 1880,
  [1881] = 1758,
  [1882] = 1882,
  [1883] = 1577,
  [1884] = 1884,
  [1885] = 1757,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1888,
  [1889] = 1889,
  [1890] = 1890,
  [1891] = 1891,
  [1892] = 1892,
  [1893] = 1755,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 1573,
  [1900] = 1887,
  [1901] = 1882,
  [1902] = 1880,
  [1903] = 1594,
  [1904] = 1869,
  [1905] = 1619,
  [1906] = 1844,
  [1907] = 1833,
  [1908] = 1908,
  [1909] = 1827,
  [1910] = 1825,
  [1911] = 1803,
  [1912] = 1912,
  [1913] = 1729,
  [1914] = 1914,
  [1915] = 1892,
  [1916] = 1916,
  [1917] = 1894,
  [1918] = 1895,
  [1919] = 1896,
  [1920] = 1576,
  [1921] = 1921,
  [1922] = 1887,
  [1923] = 1882,
  [1924] = 1880,
  [1925] = 1575,
  [1926] = 1869,
  [1927] = 1574,
  [1928] = 1844,
  [1929] = 1833,
  [1930] = 1751,
  [1931] = 1827,
  [1932] = 1825,
  [1933] = 1803,
  [1934] = 1892,
  [1935] = 1935,
  [1936] = 1894,
  [1937] = 1895,
  [1938] = 1938,
  [1939] = 1939,
  [1940] = 1887,
  [1941] = 1882,
  [1942] = 1880,
  [1943] = 1943,
  [1944] = 1869,
  [1945] = 1945,
  [1946] = 1844,
  [1947] = 1833,
  [1948] = 1948,
  [1949] = 1827,
  [1950] = 1825,
  [1951] = 1803,
  [1952] = 1952,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1888,
  [1956] = 1871,
  [1957] = 1836,
  [1958] = 1952,
  [1959] = 1953,
  [1960] = 1579,
  [1961] = 1888,
  [1962] = 1871,
  [1963] = 1836,
  [1964] = 1952,
  [1965] = 1953,
  [1966] = 1966,
  [1967] = 1888,
  [1968] = 1871,
  [1969] = 1836,
  [1970] = 1572,
  [1971] = 1897,
  [1972] = 1896,
  [1973] = 1792,
  [1974] = 1571,
  [1975] = 1975,
  [1976] = 1976,
  [1977] = 1895,
  [1978] = 1894,
  [1979] = 1953,
  [1980] = 1939,
  [1981] = 1892,
  [1982] = 1939,
  [1983] = 1952,
  [1984] = 1939,
};

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= '"' || (c < '/'
        ? (c >= '$' && c <= '-')
        : c <= '/')))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '@'
        : c <= '[')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '$'
        ? (c >= ' ' && c <= '"')
        : c <= '/')))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '@'
        : c <= '[')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_2(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= '"' || (c < '/'
        ? (c >= '$' && c <= '-')
        : c <= '/')))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '@'
        : c <= '[')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_3(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= '"' || (c < '/'
        ? (c >= '$' && c <= ',')
        : c <= '/')))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '@'
        : c <= '[')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_4(int32_t c) {
  return (c < '/'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '$'
        ? (c >= ' ' && c <= '"')
        : c <= '-')))
    : (c <= '/' || (c < ']'
      ? (c < '@'
        ? (c >= ';' && c <= '<')
        : c <= '[')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_5(int32_t c) {
  return (c < '@'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < ';'
        ? (c >= ' ' && c <= '/')
        : c <= '<')))
    : (c <= '@' || (c < '`'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_6(int32_t c) {
  return (c < '@'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c >= ' ' && c <= '<')))
    : (c <= '@' || (c < '`'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool aux_sym_command_name_token1_character_set_7(int32_t c) {
  return (c < '@'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < ';'
        ? (c >= ' ' && c <= '/')
        : c <= '<')))
    : (c <= '@' || (c < '`'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool aux_sym_command_name_token2_character_set_1(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '"' || (c < ';'
      ? (c < ','
        ? (c >= '&' && c <= ')')
        : c <= ',')
      : (c <= ';' || (c >= '{' && c <= '}')))));
}

static inline bool aux_sym_command_name_token2_character_set_2(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '"' || (c < ';'
      ? (c < ','
        ? (c >= '\'' && c <= ')')
        : c <= ',')
      : (c <= ';' || (c >= '{' && c <= '}')))));
}

static inline bool aux_sym_command_name_token2_character_set_3(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= '"' || (c < ';'
      ? (c < ','
        ? (c >= '&' && c <= ')')
        : c <= ',')
      : (c <= ';' || (c >= '|' && c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1660);
      if (lookahead == '"') ADVANCE(1584);
      if (lookahead == '#') ADVANCE(544);
      if (lookahead == '$') ADVANCE(687);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(119);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1643);
      if (lookahead == '.') ADVANCE(1681);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(527)
      if (lookahead == 'b') ADVANCE(242);
      if (lookahead == 'c') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == 'f') ADVANCE(309);
      if (lookahead == 'h') ADVANCE(310);
      if (lookahead == 'i') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(163);
      if (lookahead == 'r') ADVANCE(271);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 't') ADVANCE(306);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'w') ADVANCE(308);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(534)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(76);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(77)
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(691);
      if (lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(37);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(5);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(5);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead == '\'') ADVANCE(37);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(85)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(86)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(90)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(13)
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(1286);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(12)
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1347);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1512);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(84)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(67)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(73)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(95)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(70)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(102)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(74)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(114)
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(1340);
      if (lookahead != 0) ADVANCE(1339);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(683);
      if (lookahead != 0) ADVANCE(683);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(24);
      if (lookahead == '"') ADVANCE(154);
      if (lookahead == '#') ADVANCE(737);
      if (lookahead == '$') ADVANCE(735);
      if (lookahead == '<') ADVANCE(734);
      if (lookahead == '@') ADVANCE(736);
      if (lookahead == '`') ADVANCE(733);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(733);
      if (lookahead != 0) ADVANCE(733);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(24);
      if (lookahead == '#') ADVANCE(730);
      if (lookahead == '$') ADVANCE(687);
      if (lookahead == '<') ADVANCE(693);
      if (lookahead == '@') ADVANCE(728);
      if (lookahead == '`') ADVANCE(23);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(692);
      if (lookahead != 0) ADVANCE(732);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(105)
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(103)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(113)
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(107)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(30)
      if (lookahead == '"') ADVANCE(1239);
      if (lookahead == '#') ADVANCE(546);
      if (lookahead == '&') ADVANCE(1235);
      if (lookahead == ')') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(1244);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1237);
      if (lookahead != 0) ADVANCE(1244);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(106)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(32)
      if (lookahead == '"') ADVANCE(1239);
      if (lookahead == '#') ADVANCE(546);
      if (lookahead == '&') ADVANCE(1235);
      if (lookahead == '<') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(1244);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1238);
      if (lookahead != 0) ADVANCE(1244);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(109)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 35:
      if (lookahead == '\n') ADVANCE(1287);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(34)
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(35)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(108)
      END_STATE();
    case 37:
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '@') ADVANCE(744);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(79)
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(89)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(54)
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(80)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(59)
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(82)
      END_STATE();
    case 45:
      if (lookahead == '\n') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(153);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 46:
      if (lookahead == '\n') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(152);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(75)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(56)
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(69)
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(87)
      END_STATE();
    case 54:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1647);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(40)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 55:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1647);
      if (lookahead == '.') ADVANCE(1680);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(40)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 56:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1648);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(50)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 57:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1648);
      if (lookahead == '.') ADVANCE(1680);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(50)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 58:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1591);
      if (lookahead == '.') ADVANCE(1677);
      if (lookahead == '0') ADVANCE(576);
      if (lookahead == '1') ADVANCE(570);
      if (lookahead == '2') ADVANCE(571);
      if (lookahead == '3') ADVANCE(572);
      if (lookahead == '4') ADVANCE(573);
      if (lookahead == '5') ADVANCE(574);
      if (lookahead == '6') ADVANCE(575);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(42)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 59:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1591);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '0') ADVANCE(576);
      if (lookahead == '1') ADVANCE(570);
      if (lookahead == '2') ADVANCE(571);
      if (lookahead == '3') ADVANCE(572);
      if (lookahead == '4') ADVANCE(573);
      if (lookahead == '5') ADVANCE(574);
      if (lookahead == '6') ADVANCE(575);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(42)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 60:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(124);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(43)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(60)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 61:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(124);
      if (lookahead == '.') ADVANCE(1680);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(43)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(60)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 62:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(126);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(47)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 63:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(126);
      if (lookahead == '.') ADVANCE(1680);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(47)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(62)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 64:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1595);
      if (lookahead == '.') ADVANCE(1677);
      if (lookahead == '0') ADVANCE(576);
      if (lookahead == '1') ADVANCE(570);
      if (lookahead == '2') ADVANCE(571);
      if (lookahead == '3') ADVANCE(572);
      if (lookahead == '4') ADVANCE(573);
      if (lookahead == '5') ADVANCE(574);
      if (lookahead == '6') ADVANCE(575);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(51)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(65)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 65:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1595);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '0') ADVANCE(576);
      if (lookahead == '1') ADVANCE(570);
      if (lookahead == '2') ADVANCE(571);
      if (lookahead == '3') ADVANCE(572);
      if (lookahead == '4') ADVANCE(573);
      if (lookahead == '5') ADVANCE(574);
      if (lookahead == '6') ADVANCE(575);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(51)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(65)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 66:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(125);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1615);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(11)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(66)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 67:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1592);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '0') ADVANCE(576);
      if (lookahead == '1') ADVANCE(570);
      if (lookahead == '2') ADVANCE(571);
      if (lookahead == '3') ADVANCE(572);
      if (lookahead == '4') ADVANCE(573);
      if (lookahead == '5') ADVANCE(574);
      if (lookahead == '6') ADVANCE(575);
      if (lookahead == ':') ADVANCE(1615);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(15)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(67)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 68:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1596);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '0') ADVANCE(576);
      if (lookahead == '1') ADVANCE(570);
      if (lookahead == '2') ADVANCE(571);
      if (lookahead == '3') ADVANCE(572);
      if (lookahead == '4') ADVANCE(573);
      if (lookahead == '5') ADVANCE(574);
      if (lookahead == '6') ADVANCE(575);
      if (lookahead == ':') ADVANCE(1615);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(48)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(68)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 69:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1615);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(52)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(69)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 70:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == ':') ADVANCE(1615);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(18)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(70)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 71:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(1586);
      if (lookahead == '#') ADVANCE(1577);
      if (lookahead == '$') ADVANCE(1520);
      if (lookahead == '\'') ADVANCE(119);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1567);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1524);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '0') ADVANCE(1533);
      if (lookahead == '1') ADVANCE(1527);
      if (lookahead == '2') ADVANCE(1528);
      if (lookahead == '3') ADVANCE(1529);
      if (lookahead == '4') ADVANCE(1530);
      if (lookahead == '5') ADVANCE(1531);
      if (lookahead == '6') ADVANCE(1532);
      if (lookahead == ':') ADVANCE(1617);
      if (lookahead == '<') ADVANCE(814);
      if (lookahead == '>') ADVANCE(772);
      if (lookahead == '@') ADVANCE(1513);
      if (lookahead == '[') ADVANCE(762);
      if (lookahead == '`') ADVANCE(1583);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(66)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1514);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != ';' &&
          lookahead != '}') ADVANCE(1583);
      END_STATE();
    case 72:
      if (lookahead == ' ') ADVANCE(1611);
      if (lookahead == '"') ADVANCE(1586);
      if (lookahead == '#') ADVANCE(1577);
      if (lookahead == '$') ADVANCE(1520);
      if (lookahead == '\'') ADVANCE(119);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1567);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1526);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '0') ADVANCE(1533);
      if (lookahead == '1') ADVANCE(1527);
      if (lookahead == '2') ADVANCE(1528);
      if (lookahead == '3') ADVANCE(1529);
      if (lookahead == '4') ADVANCE(1530);
      if (lookahead == '5') ADVANCE(1531);
      if (lookahead == '6') ADVANCE(1532);
      if (lookahead == ':') ADVANCE(1617);
      if (lookahead == '<') ADVANCE(814);
      if (lookahead == '>') ADVANCE(772);
      if (lookahead == '@') ADVANCE(1513);
      if (lookahead == '[') ADVANCE(762);
      if (lookahead == '`') ADVANCE(1583);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(69)
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1515);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != ';' &&
          lookahead != '}') ADVANCE(1583);
      END_STATE();
    case 73:
      if (lookahead == ' ') ADVANCE(1612);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == ',') ADVANCE(1252);
      if (lookahead == '-') ADVANCE(125);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '0') ADVANCE(584);
      if (lookahead == '1') ADVANCE(578);
      if (lookahead == '2') ADVANCE(579);
      if (lookahead == '3') ADVANCE(580);
      if (lookahead == '4') ADVANCE(581);
      if (lookahead == '5') ADVANCE(582);
      if (lookahead == '6') ADVANCE(583);
      if (lookahead == ':') ADVANCE(1618);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(16)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1144);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 74:
      if (lookahead == ' ') ADVANCE(1613);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == '1') ADVANCE(1169);
      if (lookahead == '2') ADVANCE(1170);
      if (lookahead == '3') ADVANCE(1171);
      if (lookahead == '4') ADVANCE(1172);
      if (lookahead == '5') ADVANCE(1173);
      if (lookahead == '6') ADVANCE(1174);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '`') SKIP(20)
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1145);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '(' &&
          lookahead != '-' &&
          lookahead != '@' &&
          lookahead != '[' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(1189);
      END_STATE();
    case 75:
      if (lookahead == ' ') ADVANCE(1614);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == ',') ADVANCE(1252);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '0') ADVANCE(584);
      if (lookahead == '1') ADVANCE(578);
      if (lookahead == '2') ADVANCE(579);
      if (lookahead == '3') ADVANCE(580);
      if (lookahead == '4') ADVANCE(581);
      if (lookahead == '5') ADVANCE(582);
      if (lookahead == '6') ADVANCE(583);
      if (lookahead == ':') ADVANCE(1618);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(49)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1146);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 76:
      if (lookahead == '!') ADVANCE(1660);
      if (lookahead == '"') ADVANCE(1345);
      if (lookahead == '#') ADVANCE(544);
      if (lookahead == '$') ADVANCE(1344);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1643);
      if (lookahead == '.') ADVANCE(758);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(1)
      if (lookahead == 'b') ADVANCE(242);
      if (lookahead == 'c') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == 'f') ADVANCE(309);
      if (lookahead == 'h') ADVANCE(310);
      if (lookahead == 'i') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(163);
      if (lookahead == 'r') ADVANCE(271);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 't') ADVANCE(306);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'w') ADVANCE(308);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(77)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(76);
      END_STATE();
    case 77:
      if (lookahead == '!') ADVANCE(1660);
      if (lookahead == '"') ADVANCE(1345);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(1344);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1643);
      if (lookahead == '.') ADVANCE(758);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(1)
      if (lookahead == 'b') ADVANCE(242);
      if (lookahead == 'c') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == 'f') ADVANCE(309);
      if (lookahead == 'h') ADVANCE(310);
      if (lookahead == 'i') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(163);
      if (lookahead == 'r') ADVANCE(271);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 't') ADVANCE(306);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'w') ADVANCE(308);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(77)
      END_STATE();
    case 78:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1653);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1644);
      if (lookahead == '.') ADVANCE(1676);
      if (lookahead == '/') ADVANCE(1650);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(38)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(79)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 79:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1653);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1644);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(1650);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == ':') ADVANCE(138);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(38)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(79)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 80:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(41)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(80)
      END_STATE();
    case 81:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(1680);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(41)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(80)
      END_STATE();
    case 82:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(44)
      if (lookahead == 'h') ADVANCE(750);
      if (lookahead == 's') ADVANCE(753);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(82)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 83:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(1680);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(44)
      if (lookahead == 'h') ADVANCE(750);
      if (lookahead == 's') ADVANCE(753);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(82)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 84:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(14)
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(84)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1512);
      END_STATE();
    case 85:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(8)
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1376);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1348);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(85)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < ')' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1512);
      END_STATE();
    case 86:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(9)
      if (lookahead == 'b') ADVANCE(1403);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1367);
      if (lookahead == 'e') ADVANCE(1458);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1375);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1354);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(86)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < ')' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 87:
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(53)
      if (lookahead == 'b') ADVANCE(1403);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1367);
      if (lookahead == 'e') ADVANCE(1458);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1384);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1355);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(87)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < ')' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 88:
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '"') ADVANCE(1345);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(1342);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1645);
      if (lookahead == '.') ADVANCE(1675);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '1') ADVANCE(143);
      if (lookahead == '2') ADVANCE(144);
      if (lookahead == '3') ADVANCE(145);
      if (lookahead == '4') ADVANCE(146);
      if (lookahead == '5') ADVANCE(147);
      if (lookahead == '6') ADVANCE(148);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(39)
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(89)
      END_STATE();
    case 89:
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '"') ADVANCE(1345);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(1342);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1645);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '1') ADVANCE(143);
      if (lookahead == '2') ADVANCE(144);
      if (lookahead == '3') ADVANCE(145);
      if (lookahead == '4') ADVANCE(146);
      if (lookahead == '5') ADVANCE(147);
      if (lookahead == '6') ADVANCE(148);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(39)
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(89)
      END_STATE();
    case 90:
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1642);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1649);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '1') ADVANCE(143);
      if (lookahead == '2') ADVANCE(144);
      if (lookahead == '3') ADVANCE(145);
      if (lookahead == '4') ADVANCE(146);
      if (lookahead == '5') ADVANCE(147);
      if (lookahead == '6') ADVANCE(148);
      if (lookahead == ':') ADVANCE(1615);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(10)
      if (lookahead == 'h') ADVANCE(750);
      if (lookahead == 's') ADVANCE(753);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(90)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 91:
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '\'') ADVANCE(3);
      if (lookahead == '(') ADVANCE(1672);
      if (lookahead == '?') ADVANCE(1009);
      if (lookahead == 'g') ADVANCE(1054);
      if (lookahead == 'l') ADVANCE(1060);
      if (lookahead == 'p') ADVANCE(1062);
      if (lookahead == 's') ADVANCE(1045);
      if (lookahead == 'u') ADVANCE(1065);
      if (lookahead == 'w') ADVANCE(1059);
      if (lookahead == '{') ADVANCE(1673);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 92:
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '#') ADVANCE(544);
      if (lookahead == '$') ADVANCE(685);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(33)
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(109)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(93);
      END_STATE();
    case 93:
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '#') ADVANCE(544);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(33)
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(109)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(93);
      END_STATE();
    case 94:
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '#') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(94);
      END_STATE();
    case 95:
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.') ADVANCE(1363);
      if (lookahead == '0') ADVANCE(556);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(17)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1357);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(95)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(557);
      if (('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          (lookahead < '!' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1512);
      END_STATE();
    case 96:
      if (lookahead == '"') ADVANCE(637);
      if (lookahead == '#') ADVANCE(547);
      if (lookahead == '$') ADVANCE(1198);
      if (lookahead == '\'') ADVANCE(1199);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == '.') ADVANCE(1209);
      if (lookahead == '0') ADVANCE(586);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(1195);
      if (lookahead == '@') ADVANCE(1193);
      if (lookahead == '[') ADVANCE(763);
      if (lookahead == '`') ADVANCE(1212);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1192);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(96)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(587);
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(1212);
      END_STATE();
    case 97:
      if (lookahead == '"') ADVANCE(1346);
      if (lookahead == '#') ADVANCE(545);
      if (lookahead == '$') ADVANCE(1343);
      if (lookahead == '<') ADVANCE(1330);
      if (lookahead == '@') ADVANCE(1334);
      if (lookahead == '`') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1329);
      if (lookahead != 0) ADVANCE(1336);
      END_STATE();
    case 98:
      if (lookahead == '"') ADVANCE(689);
      if (lookahead == '#') ADVANCE(639);
      if (lookahead == '$') ADVANCE(686);
      if (lookahead == '<') ADVANCE(643);
      if (lookahead == '@') ADVANCE(678);
      if (lookahead == '`') ADVANCE(23);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(642);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(641);
      if (lookahead != 0) ADVANCE(681);
      END_STATE();
    case 99:
      if (lookahead == '"') ADVANCE(1585);
      if (lookahead == '#') ADVANCE(1577);
      if (lookahead == '\'') ADVANCE(121);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '<') ADVANCE(1517);
      if (lookahead == '`') ADVANCE(1583);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1516);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(107)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1583);
      END_STATE();
    case 100:
      if (lookahead == '"') ADVANCE(1233);
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 101:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(1679);
      if (lookahead == '1') ADVANCE(143);
      if (lookahead == '2') ADVANCE(144);
      if (lookahead == '3') ADVANCE(145);
      if (lookahead == '4') ADVANCE(146);
      if (lookahead == '5') ADVANCE(147);
      if (lookahead == '6') ADVANCE(148);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(19)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(102)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 102:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(142);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '1') ADVANCE(143);
      if (lookahead == '2') ADVANCE(144);
      if (lookahead == '3') ADVANCE(145);
      if (lookahead == '4') ADVANCE(146);
      if (lookahead == '5') ADVANCE(147);
      if (lookahead == '6') ADVANCE(148);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(19)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(102)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 103:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1594);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '`') SKIP(27)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(103)
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 104:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1593);
      if (lookahead == '.') ADVANCE(1678);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(26)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(105)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 105:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '+') ADVANCE(122);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1593);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(149);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(26)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(105)
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('?' <= lookahead && lookahead <= '\\') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 106:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '.') ADVANCE(757);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(31)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(106)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(756);
      END_STATE();
    case 107:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(29)
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(107)
      END_STATE();
    case 108:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '0') ADVANCE(593);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(36)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(108)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(594);
      END_STATE();
    case 109:
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(33)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(109)
      END_STATE();
    case 110:
      if (lookahead == '#') ADVANCE(112);
      END_STATE();
    case 111:
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '>') ADVANCE(543);
      if (lookahead != 0) ADVANCE(112);
      END_STATE();
    case 112:
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '`') ADVANCE(525);
      if (lookahead != 0) ADVANCE(112);
      END_STATE();
    case 113:
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '.') ADVANCE(760);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '`') SKIP(28)
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1358);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(113)
      if (lookahead != 0 &&
          (lookahead < '!' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 114:
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == '1') ADVANCE(1169);
      if (lookahead == '2') ADVANCE(1170);
      if (lookahead == '3') ADVANCE(1171);
      if (lookahead == '4') ADVANCE(1172);
      if (lookahead == '5') ADVANCE(1173);
      if (lookahead == '6') ADVANCE(1174);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '`') SKIP(21)
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1148);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '(' &&
          lookahead != '-' &&
          lookahead != '@' &&
          lookahead != '[' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(1189);
      END_STATE();
    case 115:
      if (lookahead == '#') ADVANCE(547);
      if (lookahead == '<') ADVANCE(1195);
      if (lookahead == '`') ADVANCE(1212);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 116:
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 117:
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 118:
      if (lookahead == '&') ADVANCE(136);
      END_STATE();
    case 119:
      if (lookahead == '\'') ADVANCE(1588);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 120:
      if (lookahead == '\'') ADVANCE(742);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 121:
      if (lookahead == '\'') ADVANCE(1587);
      END_STATE();
    case 122:
      if (lookahead == '+') ADVANCE(1663);
      END_STATE();
    case 123:
      if (lookahead == '-') ADVANCE(1664);
      if (lookahead == 'c') ADVANCE(173);
      if (lookahead == 'e') ADVANCE(517);
      if (lookahead == 'f') ADVANCE(311);
      if (lookahead == 'p') ADVANCE(176);
      if (lookahead == 'r') ADVANCE(270);
      if (lookahead == 's') ADVANCE(508);
      if (lookahead == 'w') ADVANCE(313);
      END_STATE();
    case 124:
      if (lookahead == '-') ADVANCE(1666);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 125:
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 126:
      if (lookahead == '-') ADVANCE(1668);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 127:
      if (lookahead == '-') ADVANCE(1215);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 128:
      if (lookahead == '.') ADVANCE(1655);
      END_STATE();
    case 129:
      if (lookahead == '.') ADVANCE(1655);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 130:
      if (lookahead == '1') ADVANCE(816);
      if (lookahead == '2') ADVANCE(828);
      END_STATE();
    case 131:
      if (lookahead == '1') ADVANCE(818);
      END_STATE();
    case 132:
      if (lookahead == '1') ADVANCE(820);
      if (lookahead == '2') ADVANCE(832);
      END_STATE();
    case 133:
      if (lookahead == '1') ADVANCE(822);
      if (lookahead == '2') ADVANCE(834);
      END_STATE();
    case 134:
      if (lookahead == '1') ADVANCE(824);
      if (lookahead == '2') ADVANCE(836);
      END_STATE();
    case 135:
      if (lookahead == '1') ADVANCE(826);
      if (lookahead == '2') ADVANCE(838);
      END_STATE();
    case 136:
      if (lookahead == '2') ADVANCE(830);
      END_STATE();
    case 137:
      if (lookahead == ':') ADVANCE(1682);
      END_STATE();
    case 138:
      if (lookahead == ':') ADVANCE(1682);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1310);
      END_STATE();
    case 139:
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == '?') ADVANCE(910);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1004);
      END_STATE();
    case 140:
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == '?') ADVANCE(1009);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1134);
      END_STATE();
    case 141:
      if (lookahead == '=') ADVANCE(766);
      END_STATE();
    case 142:
      if (lookahead == '>') ADVANCE(807);
      END_STATE();
    case 143:
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 144:
      if (lookahead == '>') ADVANCE(777);
      END_STATE();
    case 145:
      if (lookahead == '>') ADVANCE(783);
      END_STATE();
    case 146:
      if (lookahead == '>') ADVANCE(789);
      END_STATE();
    case 147:
      if (lookahead == '>') ADVANCE(795);
      END_STATE();
    case 148:
      if (lookahead == '>') ADVANCE(801);
      END_STATE();
    case 149:
      if (lookahead == '?') ADVANCE(1009);
      if (lookahead == 'g') ADVANCE(1054);
      if (lookahead == 'l') ADVANCE(1060);
      if (lookahead == 'p') ADVANCE(1062);
      if (lookahead == 's') ADVANCE(1045);
      if (lookahead == 'u') ADVANCE(1065);
      if (lookahead == 'w') ADVANCE(1059);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 150:
      if (lookahead == '?') ADVANCE(1009);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1134);
      END_STATE();
    case 151:
      if (lookahead == '?') ADVANCE(910);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1004);
      END_STATE();
    case 152:
      if (lookahead == '@') ADVANCE(743);
      END_STATE();
    case 153:
      if (lookahead == '@') ADVANCE(743);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 154:
      if (lookahead == '@') ADVANCE(739);
      if (lookahead != 0) ADVANCE(738);
      END_STATE();
    case 155:
      if (lookahead == '`') ADVANCE(1338);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1337);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(472);
      END_STATE();
    case 157:
      if (lookahead == 'a') ADVANCE(472);
      if (lookahead == 'l') ADVANCE(161);
      if (lookahead == 'o') ADVANCE(389);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(1319);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(364);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(486);
      if (lookahead == 'o') ADVANCE(1290);
      if (lookahead == 'y') ADVANCE(391);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(466);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(374);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(450);
      if (lookahead == 'r') ADVANCE(410);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(427);
      if (lookahead == 'y') ADVANCE(1313);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(340);
      END_STATE();
    case 166:
      if (lookahead == 'a') ADVANCE(372);
      END_STATE();
    case 167:
      if (lookahead == 'a') ADVANCE(387);
      if (lookahead == 'n') ADVANCE(416);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'x') ADVANCE(415);
      END_STATE();
    case 168:
      if (lookahead == 'a') ADVANCE(387);
      if (lookahead == 'o') ADVANCE(443);
      if (lookahead == 'x') ADVANCE(415);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(358);
      END_STATE();
    case 170:
      if (lookahead == 'a') ADVANCE(371);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(366);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(449);
      END_STATE();
    case 173:
      if (lookahead == 'a') ADVANCE(469);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(469);
      if (lookahead == 'c') ADVANCE(422);
      if (lookahead == 'e') ADVANCE(438);
      if (lookahead == 'g') ADVANCE(249);
      if (lookahead == 'l') ADVANCE(250);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(251);
      if (lookahead == 'o') ADVANCE(399);
      if (lookahead == 'r') ADVANCE(280);
      if (lookahead == 's') ADVANCE(433);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(216);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 177:
      if (lookahead == 'a') ADVANCE(221);
      END_STATE();
    case 178:
      if (lookahead == 'a') ADVANCE(395);
      END_STATE();
    case 179:
      if (lookahead == 'a') ADVANCE(488);
      END_STATE();
    case 180:
      if (lookahead == 'a') ADVANCE(322);
      END_STATE();
    case 181:
      if (lookahead == 'a') ADVANCE(453);
      END_STATE();
    case 182:
      if (lookahead == 'a') ADVANCE(325);
      END_STATE();
    case 183:
      if (lookahead == 'a') ADVANCE(454);
      if (lookahead == 'r') ADVANCE(410);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(223);
      END_STATE();
    case 185:
      if (lookahead == 'a') ADVANCE(327);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(328);
      END_STATE();
    case 188:
      if (lookahead == 'a') ADVANCE(211);
      END_STATE();
    case 189:
      if (lookahead == 'a') ADVANCE(329);
      END_STATE();
    case 190:
      if (lookahead == 'a') ADVANCE(330);
      END_STATE();
    case 191:
      if (lookahead == 'a') ADVANCE(217);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(219);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(494);
      END_STATE();
    case 194:
      if (lookahead == 'a') ADVANCE(497);
      END_STATE();
    case 195:
      if (lookahead == 'a') ADVANCE(498);
      END_STATE();
    case 196:
      if (lookahead == 'a') ADVANCE(499);
      END_STATE();
    case 197:
      if (lookahead == 'a') ADVANCE(500);
      END_STATE();
    case 198:
      if (lookahead == 'a') ADVANCE(501);
      END_STATE();
    case 199:
      if (lookahead == 'b') ADVANCE(555);
      END_STATE();
    case 200:
      if (lookahead == 'b') ADVANCE(617);
      END_STATE();
    case 201:
      if (lookahead == 'b') ADVANCE(599);
      END_STATE();
    case 202:
      if (lookahead == 'b') ADVANCE(338);
      END_STATE();
    case 203:
      if (lookahead == 'c') ADVANCE(295);
      END_STATE();
    case 204:
      if (lookahead == 'c') ADVANCE(1628);
      END_STATE();
    case 205:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(297);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(298);
      END_STATE();
    case 208:
      if (lookahead == 'c') ADVANCE(422);
      if (lookahead == 'e') ADVANCE(438);
      if (lookahead == 'g') ADVANCE(249);
      if (lookahead == 'l') ADVANCE(250);
      if (lookahead == 'm') ADVANCE(194);
      if (lookahead == 'n') ADVANCE(251);
      if (lookahead == 'o') ADVANCE(399);
      if (lookahead == 'r') ADVANCE(280);
      if (lookahead == 's') ADVANCE(433);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(432);
      END_STATE();
    case 210:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 211:
      if (lookahead == 'c') ADVANCE(300);
      END_STATE();
    case 212:
      if (lookahead == 'c') ADVANCE(301);
      END_STATE();
    case 213:
      if (lookahead == 'c') ADVANCE(302);
      END_STATE();
    case 214:
      if (lookahead == 'c') ADVANCE(303);
      END_STATE();
    case 215:
      if (lookahead == 'c') ADVANCE(412);
      END_STATE();
    case 216:
      if (lookahead == 'c') ADVANCE(478);
      END_STATE();
    case 217:
      if (lookahead == 'c') ADVANCE(304);
      END_STATE();
    case 218:
      if (lookahead == 'c') ADVANCE(281);
      END_STATE();
    case 219:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 220:
      if (lookahead == 'c') ADVANCE(483);
      END_STATE();
    case 221:
      if (lookahead == 'c') ADVANCE(262);
      END_STATE();
    case 222:
      if (lookahead == 'c') ADVANCE(264);
      END_STATE();
    case 223:
      if (lookahead == 'c') ADVANCE(266);
      END_STATE();
    case 224:
      if (lookahead == 'c') ADVANCE(268);
      END_STATE();
    case 225:
      if (lookahead == 'c') ADVANCE(172);
      END_STATE();
    case 226:
      if (lookahead == 'c') ADVANCE(490);
      END_STATE();
    case 227:
      if (lookahead == 'c') ADVANCE(423);
      if (lookahead == 'e') ADVANCE(439);
      if (lookahead == 'g') ADVANCE(252);
      if (lookahead == 'l') ADVANCE(253);
      if (lookahead == 'm') ADVANCE(195);
      if (lookahead == 'n') ADVANCE(867);
      if (lookahead == 'r') ADVANCE(286);
      if (lookahead == 's') ADVANCE(873);
      END_STATE();
    case 228:
      if (lookahead == 'c') ADVANCE(424);
      if (lookahead == 'i') ADVANCE(379);
      if (lookahead == 'l') ADVANCE(333);
      if (lookahead == 'm') ADVANCE(196);
      END_STATE();
    case 229:
      if (lookahead == 'c') ADVANCE(425);
      if (lookahead == 'l') ADVANCE(335);
      if (lookahead == 'm') ADVANCE(197);
      END_STATE();
    case 230:
      if (lookahead == 'c') ADVANCE(426);
      if (lookahead == 'l') ADVANCE(336);
      if (lookahead == 'm') ADVANCE(198);
      END_STATE();
    case 231:
      if (lookahead == 'd') ADVANCE(1259);
      END_STATE();
    case 232:
      if (lookahead == 'd') ADVANCE(1259);
      if (lookahead == 'u') ADVANCE(370);
      END_STATE();
    case 233:
      if (lookahead == 'd') ADVANCE(1634);
      END_STATE();
    case 234:
      if (lookahead == 'd') ADVANCE(1637);
      END_STATE();
    case 235:
      if (lookahead == 'd') ADVANCE(1274);
      END_STATE();
    case 236:
      if (lookahead == 'd') ADVANCE(1321);
      END_STATE();
    case 237:
      if (lookahead == 'd') ADVANCE(240);
      END_STATE();
    case 238:
      if (lookahead == 'd') ADVANCE(225);
      END_STATE();
    case 239:
      if (lookahead == 'd') ADVANCE(215);
      END_STATE();
    case 240:
      if (lookahead == 'd') ADVANCE(274);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(440);
      if (lookahead == 't') ADVANCE(179);
      if (lookahead == 'w') ADVANCE(337);
      END_STATE();
    case 244:
      if (lookahead == 'e') ADVANCE(857);
      if (lookahead == 't') ADVANCE(858);
      END_STATE();
    case 245:
      if (lookahead == 'e') ADVANCE(878);
      if (lookahead == 'i') ADVANCE(341);
      if (lookahead == 't') ADVANCE(880);
      END_STATE();
    case 246:
      if (lookahead == 'e') ADVANCE(882);
      if (lookahead == 'o') ADVANCE(474);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(882);
      if (lookahead == 'o') ADVANCE(485);
      END_STATE();
    case 248:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(843);
      if (lookahead == 't') ADVANCE(844);
      END_STATE();
    case 250:
      if (lookahead == 'e') ADVANCE(845);
      if (lookahead == 'i') ADVANCE(342);
      if (lookahead == 't') ADVANCE(847);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(849);
      if (lookahead == 'o') ADVANCE(477);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(861);
      if (lookahead == 't') ADVANCE(862);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(863);
      if (lookahead == 'i') ADVANCE(343);
      if (lookahead == 't') ADVANCE(865);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(1268);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(1278);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(879);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(516);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(1288);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(846);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(864);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(885);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(887);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(1301);
      END_STATE();
    case 264:
      if (lookahead == 'e') ADVANCE(1325);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(851);
      END_STATE();
    case 266:
      if (lookahead == 'e') ADVANCE(854);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(870);
      END_STATE();
    case 268:
      if (lookahead == 'e') ADVANCE(872);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(1276);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(473);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 273:
      if (lookahead == 'e') ADVANCE(239);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(380);
      END_STATE();
    case 275:
      if (lookahead == 'e') ADVANCE(446);
      END_STATE();
    case 276:
      if (lookahead == 'e') ADVANCE(352);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(401);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 279:
      if (lookahead == 'e') ADVANCE(388);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(434);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(467);
      END_STATE();
    case 282:
      if (lookahead == 'e') ADVANCE(470);
      END_STATE();
    case 283:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 284:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 286:
      if (lookahead == 'e') ADVANCE(435);
      END_STATE();
    case 287:
      if (lookahead == 'f') ADVANCE(1264);
      if (lookahead == 'n') ADVANCE(1282);
      END_STATE();
    case 288:
      if (lookahead == 'f') ADVANCE(1266);
      END_STATE();
    case 289:
      if (lookahead == 'f') ADVANCE(356);
      END_STATE();
    case 290:
      if (lookahead == 'g') ADVANCE(316);
      END_STATE();
    case 291:
      if (lookahead == 'g') ADVANCE(257);
      END_STATE();
    case 292:
      if (lookahead == 'g') ADVANCE(257);
      if (lookahead == 'p') ADVANCE(359);
      END_STATE();
    case 293:
      if (lookahead == 'h') ADVANCE(349);
      if (lookahead == 'p') ADVANCE(363);
      END_STATE();
    case 294:
      if (lookahead == 'h') ADVANCE(349);
      if (lookahead == 'p') ADVANCE(363);
      if (lookahead == 'u') ADVANCE(429);
      END_STATE();
    case 295:
      if (lookahead == 'h') ADVANCE(1315);
      END_STATE();
    case 296:
      if (lookahead == 'h') ADVANCE(881);
      END_STATE();
    case 297:
      if (lookahead == 'h') ADVANCE(1271);
      END_STATE();
    case 298:
      if (lookahead == 'h') ADVANCE(848);
      END_STATE();
    case 299:
      if (lookahead == 'h') ADVANCE(866);
      END_STATE();
    case 300:
      if (lookahead == 'h') ADVANCE(1280);
      END_STATE();
    case 301:
      if (lookahead == 'h') ADVANCE(886);
      END_STATE();
    case 302:
      if (lookahead == 'h') ADVANCE(852);
      END_STATE();
    case 303:
      if (lookahead == 'h') ADVANCE(871);
      END_STATE();
    case 304:
      if (lookahead == 'h') ADVANCE(1279);
      END_STATE();
    case 305:
      if (lookahead == 'h') ADVANCE(1684);
      END_STATE();
    case 306:
      if (lookahead == 'h') ADVANCE(448);
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 307:
      if (lookahead == 'h') ADVANCE(331);
      END_STATE();
    case 308:
      if (lookahead == 'h') ADVANCE(331);
      if (lookahead == 'o') ADVANCE(447);
      END_STATE();
    case 309:
      if (lookahead == 'i') ADVANCE(357);
      if (lookahead == 'o') ADVANCE(442);
      if (lookahead == 'u') ADVANCE(384);
      END_STATE();
    case 310:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(355);
      END_STATE();
    case 312:
      if (lookahead == 'i') ADVANCE(512);
      END_STATE();
    case 313:
      if (lookahead == 'i') ADVANCE(354);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(377);
      END_STATE();
    case 315:
      if (lookahead == 'i') ADVANCE(204);
      END_STATE();
    case 316:
      if (lookahead == 'i') ADVANCE(378);
      END_STATE();
    case 317:
      if (lookahead == 'i') ADVANCE(350);
      END_STATE();
    case 318:
      if (lookahead == 'i') ADVANCE(209);
      END_STATE();
    case 319:
      if (lookahead == 'i') ADVANCE(420);
      END_STATE();
    case 320:
      if (lookahead == 'i') ADVANCE(475);
      END_STATE();
    case 321:
      if (lookahead == 'i') ADVANCE(400);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(390);
      END_STATE();
    case 323:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 324:
      if (lookahead == 'i') ADVANCE(481);
      END_STATE();
    case 325:
      if (lookahead == 'i') ADVANCE(392);
      END_STATE();
    case 326:
      if (lookahead == 'i') ADVANCE(482);
      END_STATE();
    case 327:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 328:
      if (lookahead == 'i') ADVANCE(396);
      END_STATE();
    case 329:
      if (lookahead == 'i') ADVANCE(397);
      END_STATE();
    case 330:
      if (lookahead == 'i') ADVANCE(398);
      END_STATE();
    case 331:
      if (lookahead == 'i') ADVANCE(360);
      END_STATE();
    case 332:
      if (lookahead == 'i') ADVANCE(393);
      if (lookahead == 'o') ADVANCE(457);
      END_STATE();
    case 333:
      if (lookahead == 'i') ADVANCE(344);
      END_STATE();
    case 334:
      if (lookahead == 'i') ADVANCE(492);
      END_STATE();
    case 335:
      if (lookahead == 'i') ADVANCE(345);
      END_STATE();
    case 336:
      if (lookahead == 'i') ADVANCE(346);
      END_STATE();
    case 337:
      if (lookahead == 'i') ADVANCE(496);
      END_STATE();
    case 338:
      if (lookahead == 'j') ADVANCE(283);
      END_STATE();
    case 339:
      if (lookahead == 'k') ADVANCE(289);
      END_STATE();
    case 340:
      if (lookahead == 'k') ADVANCE(1299);
      END_STATE();
    case 341:
      if (lookahead == 'k') ADVANCE(256);
      END_STATE();
    case 342:
      if (lookahead == 'k') ADVANCE(259);
      END_STATE();
    case 343:
      if (lookahead == 'k') ADVANCE(260);
      END_STATE();
    case 344:
      if (lookahead == 'k') ADVANCE(261);
      END_STATE();
    case 345:
      if (lookahead == 'k') ADVANCE(265);
      END_STATE();
    case 346:
      if (lookahead == 'k') ADVANCE(267);
      END_STATE();
    case 347:
      if (lookahead == 'l') ADVANCE(468);
      if (lookahead == 'n') ADVANCE(232);
      if (lookahead == 'x') ADVANCE(320);
      END_STATE();
    case 348:
      if (lookahead == 'l') ADVANCE(468);
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 349:
      if (lookahead == 'l') ADVANCE(888);
      if (lookahead == 'r') ADVANCE(889);
      END_STATE();
    case 350:
      if (lookahead == 'l') ADVANCE(1292);
      END_STATE();
    case 351:
      if (lookahead == 'l') ADVANCE(518);
      END_STATE();
    case 352:
      if (lookahead == 'l') ADVANCE(1323);
      END_STATE();
    case 353:
      if (lookahead == 'l') ADVANCE(1277);
      END_STATE();
    case 354:
      if (lookahead == 'l') ADVANCE(238);
      END_STATE();
    case 355:
      if (lookahead == 'l') ADVANCE(255);
      END_STATE();
    case 356:
      if (lookahead == 'l') ADVANCE(409);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(489);
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 358:
      if (lookahead == 'l') ADVANCE(351);
      END_STATE();
    case 359:
      if (lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 360:
      if (lookahead == 'l') ADVANCE(258);
      END_STATE();
    case 361:
      if (lookahead == 'l') ADVANCE(276);
      END_STATE();
    case 362:
      if (lookahead == 'l') ADVANCE(278);
      END_STATE();
    case 363:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 364:
      if (lookahead == 'l') ADVANCE(361);
      if (lookahead == 'm') ADVANCE(1246);
      END_STATE();
    case 365:
      if (lookahead == 'l') ADVANCE(324);
      END_STATE();
    case 366:
      if (lookahead == 'l') ADVANCE(362);
      END_STATE();
    case 367:
      if (lookahead == 'l') ADVANCE(326);
      END_STATE();
    case 368:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 369:
      if (lookahead == 'l') ADVANCE(186);
      END_STATE();
    case 370:
      if (lookahead == 'm') ADVANCE(1632);
      END_STATE();
    case 371:
      if (lookahead == 'm') ADVANCE(1246);
      END_STATE();
    case 372:
      if (lookahead == 'm') ADVANCE(1253);
      END_STATE();
    case 373:
      if (lookahead == 'm') ADVANCE(375);
      END_STATE();
    case 374:
      if (lookahead == 'm') ADVANCE(318);
      END_STATE();
    case 375:
      if (lookahead == 'm') ADVANCE(178);
      END_STATE();
    case 376:
      if (lookahead == 'n') ADVANCE(1282);
      END_STATE();
    case 377:
      if (lookahead == 'n') ADVANCE(876);
      END_STATE();
    case 378:
      if (lookahead == 'n') ADVANCE(1255);
      END_STATE();
    case 379:
      if (lookahead == 'n') ADVANCE(884);
      END_STATE();
    case 380:
      if (lookahead == 'n') ADVANCE(1626);
      END_STATE();
    case 381:
      if (lookahead == 'n') ADVANCE(1305);
      END_STATE();
    case 382:
      if (lookahead == 'n') ADVANCE(1293);
      END_STATE();
    case 383:
      if (lookahead == 'n') ADVANCE(233);
      if (lookahead == 's') ADVANCE(840);
      END_STATE();
    case 384:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(416);
      END_STATE();
    case 386:
      if (lookahead == 'n') ADVANCE(495);
      END_STATE();
    case 387:
      if (lookahead == 'n') ADVANCE(234);
      END_STATE();
    case 388:
      if (lookahead == 'n') ADVANCE(471);
      END_STATE();
    case 389:
      if (lookahead == 'n') ADVANCE(487);
      END_STATE();
    case 390:
      if (lookahead == 'n') ADVANCE(460);
      END_STATE();
    case 391:
      if (lookahead == 'n') ADVANCE(162);
      END_STATE();
    case 392:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 393:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 394:
      if (lookahead == 'n') ADVANCE(462);
      END_STATE();
    case 395:
      if (lookahead == 'n') ADVANCE(236);
      END_STATE();
    case 396:
      if (lookahead == 'n') ADVANCE(463);
      END_STATE();
    case 397:
      if (lookahead == 'n') ADVANCE(464);
      END_STATE();
    case 398:
      if (lookahead == 'n') ADVANCE(465);
      END_STATE();
    case 399:
      if (lookahead == 'n') ADVANCE(491);
      END_STATE();
    case 400:
      if (lookahead == 'n') ADVANCE(511);
      END_STATE();
    case 401:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 402:
      if (lookahead == 'n') ADVANCE(502);
      END_STATE();
    case 403:
      if (lookahead == 'n') ADVANCE(503);
      END_STATE();
    case 404:
      if (lookahead == 'n') ADVANCE(504);
      END_STATE();
    case 405:
      if (lookahead == 'n') ADVANCE(505);
      END_STATE();
    case 406:
      if (lookahead == 'n') ADVANCE(506);
      END_STATE();
    case 407:
      if (lookahead == 'o') ADVANCE(1290);
      if (lookahead == 'y') ADVANCE(391);
      END_STATE();
    case 408:
      if (lookahead == 'o') ADVANCE(513);
      END_STATE();
    case 409:
      if (lookahead == 'o') ADVANCE(514);
      END_STATE();
    case 410:
      if (lookahead == 'o') ADVANCE(218);
      END_STATE();
    case 411:
      if (lookahead == 'o') ADVANCE(202);
      END_STATE();
    case 412:
      if (lookahead == 'o') ADVANCE(373);
      END_STATE();
    case 413:
      if (lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 414:
      if (lookahead == 'o') ADVANCE(444);
      END_STATE();
    case 415:
      if (lookahead == 'o') ADVANCE(445);
      END_STATE();
    case 416:
      if (lookahead == 'o') ADVANCE(476);
      END_STATE();
    case 417:
      if (lookahead == 'o') ADVANCE(456);
      END_STATE();
    case 418:
      if (lookahead == 'o') ADVANCE(479);
      END_STATE();
    case 419:
      if (lookahead == 'o') ADVANCE(455);
      END_STATE();
    case 420:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 421:
      if (lookahead == 'o') ADVANCE(484);
      END_STATE();
    case 422:
      if (lookahead == 'o') ADVANCE(402);
      END_STATE();
    case 423:
      if (lookahead == 'o') ADVANCE(403);
      END_STATE();
    case 424:
      if (lookahead == 'o') ADVANCE(404);
      END_STATE();
    case 425:
      if (lookahead == 'o') ADVANCE(405);
      END_STATE();
    case 426:
      if (lookahead == 'o') ADVANCE(406);
      END_STATE();
    case 427:
      if (lookahead == 'p') ADVANCE(1311);
      END_STATE();
    case 428:
      if (lookahead == 'p') ADVANCE(363);
      END_STATE();
    case 429:
      if (lookahead == 'p') ADVANCE(431);
      END_STATE();
    case 430:
      if (lookahead == 'p') ADVANCE(359);
      END_STATE();
    case 431:
      if (lookahead == 'p') ADVANCE(417);
      END_STATE();
    case 432:
      if (lookahead == 'p') ADVANCE(181);
      END_STATE();
    case 433:
      if (lookahead == 'p') ADVANCE(365);
      END_STATE();
    case 434:
      if (lookahead == 'p') ADVANCE(368);
      END_STATE();
    case 435:
      if (lookahead == 'p') ADVANCE(369);
      END_STATE();
    case 436:
      if (lookahead == 'q') ADVANCE(856);
      END_STATE();
    case 437:
      if (lookahead == 'q') ADVANCE(856);
      if (lookahead == 'x') ADVANCE(175);
      END_STATE();
    case 438:
      if (lookahead == 'q') ADVANCE(842);
      END_STATE();
    case 439:
      if (lookahead == 'q') ADVANCE(860);
      END_STATE();
    case 440:
      if (lookahead == 'q') ADVANCE(510);
      END_STATE();
    case 441:
      if (lookahead == 'r') ADVANCE(1635);
      END_STATE();
    case 442:
      if (lookahead == 'r') ADVANCE(1284);
      END_STATE();
    case 443:
      if (lookahead == 'r') ADVANCE(1638);
      END_STATE();
    case 444:
      if (lookahead == 'r') ADVANCE(1636);
      END_STATE();
    case 445:
      if (lookahead == 'r') ADVANCE(1639);
      END_STATE();
    case 446:
      if (lookahead == 'r') ADVANCE(1295);
      END_STATE();
    case 447:
      if (lookahead == 'r') ADVANCE(339);
      END_STATE();
    case 448:
      if (lookahead == 'r') ADVANCE(408);
      END_STATE();
    case 449:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 450:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 451:
      if (lookahead == 'r') ADVANCE(381);
      END_STATE();
    case 452:
      if (lookahead == 'r') ADVANCE(171);
      END_STATE();
    case 453:
      if (lookahead == 'r') ADVANCE(166);
      END_STATE();
    case 454:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 455:
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 456:
      if (lookahead == 'r') ADVANCE(493);
      END_STATE();
    case 457:
      if (lookahead == 'r') ADVANCE(1285);
      END_STATE();
    case 458:
      if (lookahead == 's') ADVANCE(1630);
      END_STATE();
    case 459:
      if (lookahead == 's') ADVANCE(1257);
      END_STATE();
    case 460:
      if (lookahead == 's') ADVANCE(853);
      END_STATE();
    case 461:
      if (lookahead == 's') ADVANCE(841);
      END_STATE();
    case 462:
      if (lookahead == 's') ADVANCE(859);
      END_STATE();
    case 463:
      if (lookahead == 's') ADVANCE(883);
      END_STATE();
    case 464:
      if (lookahead == 's') ADVANCE(850);
      END_STATE();
    case 465:
      if (lookahead == 's') ADVANCE(869);
      END_STATE();
    case 466:
      if (lookahead == 's') ADVANCE(458);
      END_STATE();
    case 467:
      if (lookahead == 's') ADVANCE(459);
      END_STATE();
    case 468:
      if (lookahead == 's') ADVANCE(254);
      END_STATE();
    case 469:
      if (lookahead == 's') ADVANCE(282);
      END_STATE();
    case 470:
      if (lookahead == 's') ADVANCE(279);
      END_STATE();
    case 471:
      if (lookahead == 's') ADVANCE(334);
      END_STATE();
    case 472:
      if (lookahead == 't') ADVANCE(203);
      END_STATE();
    case 473:
      if (lookahead == 't') ADVANCE(509);
      END_STATE();
    case 474:
      if (lookahead == 't') ADVANCE(1657);
      END_STATE();
    case 475:
      if (lookahead == 't') ADVANCE(1307);
      END_STATE();
    case 476:
      if (lookahead == 't') ADVANCE(1661);
      END_STATE();
    case 477:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 478:
      if (lookahead == 't') ADVANCE(1275);
      END_STATE();
    case 479:
      if (lookahead == 't') ADVANCE(874);
      END_STATE();
    case 480:
      if (lookahead == 't') ADVANCE(890);
      END_STATE();
    case 481:
      if (lookahead == 't') ADVANCE(855);
      END_STATE();
    case 482:
      if (lookahead == 't') ADVANCE(875);
      END_STATE();
    case 483:
      if (lookahead == 't') ADVANCE(1621);
      END_STATE();
    case 484:
      if (lookahead == 't') ADVANCE(1656);
      END_STATE();
    case 485:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 486:
      if (lookahead == 't') ADVANCE(158);
      END_STATE();
    case 487:
      if (lookahead == 't') ADVANCE(321);
      END_STATE();
    case 488:
      if (lookahead == 't') ADVANCE(315);
      END_STATE();
    case 489:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 490:
      if (lookahead == 't') ADVANCE(319);
      END_STATE();
    case 491:
      if (lookahead == 't') ADVANCE(180);
      END_STATE();
    case 492:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 493:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 494:
      if (lookahead == 't') ADVANCE(205);
      END_STATE();
    case 495:
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 496:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 497:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 498:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 499:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 500:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 501:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 502:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 503:
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 504:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 505:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 506:
      if (lookahead == 't') ADVANCE(190);
      END_STATE();
    case 507:
      if (lookahead == 't') ADVANCE(230);
      END_STATE();
    case 508:
      if (lookahead == 'u') ADVANCE(429);
      END_STATE();
    case 509:
      if (lookahead == 'u') ADVANCE(451);
      END_STATE();
    case 510:
      if (lookahead == 'u') ADVANCE(277);
      END_STATE();
    case 511:
      if (lookahead == 'u') ADVANCE(263);
      END_STATE();
    case 512:
      if (lookahead == 'v') ADVANCE(269);
      END_STATE();
    case 513:
      if (lookahead == 'w') ADVANCE(1303);
      END_STATE();
    case 514:
      if (lookahead == 'w') ADVANCE(1297);
      END_STATE();
    case 515:
      if (lookahead == 'w') ADVANCE(337);
      END_STATE();
    case 516:
      if (lookahead == 'x') ADVANCE(1273);
      END_STATE();
    case 517:
      if (lookahead == 'x') ADVANCE(175);
      END_STATE();
    case 518:
      if (lookahead == 'y') ADVANCE(1317);
      END_STATE();
    case 519:
      if (lookahead == '}') ADVANCE(1141);
      if (lookahead != 0) ADVANCE(519);
      END_STATE();
    case 520:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(626);
      END_STATE();
    case 521:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 522:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(626);
      END_STATE();
    case 523:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(603);
      END_STATE();
    case 524:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(519);
      END_STATE();
    case 525:
      if (lookahead != 0) ADVANCE(112);
      END_STATE();
    case 526:
      if (lookahead != 0) ADVANCE(682);
      END_STATE();
    case 527:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(534)
      END_STATE();
    case 528:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(537)
      END_STATE();
    case 529:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(536)
      END_STATE();
    case 530:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(538)
      END_STATE();
    case 531:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(539)
      END_STATE();
    case 532:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(540)
      END_STATE();
    case 533:
      if (eof) ADVANCE(542);
      if (lookahead == '\n') SKIP(541)
      END_STATE();
    case 534:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1660);
      if (lookahead == '"') ADVANCE(1345);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(1344);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1643);
      if (lookahead == '.') ADVANCE(758);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(1616);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(527)
      if (lookahead == 'b') ADVANCE(242);
      if (lookahead == 'c') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == 'f') ADVANCE(309);
      if (lookahead == 'h') ADVANCE(310);
      if (lookahead == 'i') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(163);
      if (lookahead == 'r') ADVANCE(271);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 't') ADVANCE(306);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'w') ADVANCE(308);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(534)
      END_STATE();
    case 535:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1660);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1644);
      if (lookahead == '.') ADVANCE(1676);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(529)
      if (lookahead == 'b') ADVANCE(241);
      if (lookahead == 'c') ADVANCE(156);
      if (lookahead == 'd') ADVANCE(407);
      if (lookahead == 'e') ADVANCE(348);
      if (lookahead == 'f') ADVANCE(332);
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == 'p') ADVANCE(183);
      if (lookahead == 's') ADVANCE(515);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'w') ADVANCE(307);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(536)
      END_STATE();
    case 536:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1660);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(554);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1620);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '*') ADVANCE(1654);
      if (lookahead == '+') ADVANCE(1641);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1644);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(1651);
      if (lookahead == '0') ADVANCE(566);
      if (lookahead == '1') ADVANCE(560);
      if (lookahead == '2') ADVANCE(561);
      if (lookahead == '3') ADVANCE(562);
      if (lookahead == '4') ADVANCE(563);
      if (lookahead == '5') ADVANCE(564);
      if (lookahead == '6') ADVANCE(565);
      if (lookahead == ':') ADVANCE(137);
      if (lookahead == '<') ADVANCE(813);
      if (lookahead == '=') ADVANCE(765);
      if (lookahead == '>') ADVANCE(771);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '\\') ADVANCE(1652);
      if (lookahead == ']') ADVANCE(1683);
      if (lookahead == '`') SKIP(529)
      if (lookahead == 'b') ADVANCE(241);
      if (lookahead == 'c') ADVANCE(156);
      if (lookahead == 'd') ADVANCE(407);
      if (lookahead == 'e') ADVANCE(348);
      if (lookahead == 'f') ADVANCE(332);
      if (lookahead == 'i') ADVANCE(376);
      if (lookahead == 'p') ADVANCE(183);
      if (lookahead == 's') ADVANCE(515);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == 'w') ADVANCE(307);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '|') ADVANCE(1327);
      if (lookahead == '}') ADVANCE(1263);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(567);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(536)
      END_STATE();
    case 537:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(528)
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1349);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(537)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 538:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(530)
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1444);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1351);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(538)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 539:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(531)
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1382);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1425);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1353);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(539)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 540:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(532)
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1425);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1350);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(540)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 541:
      if (eof) ADVANCE(542);
      if (lookahead == '!') ADVANCE(1659);
      if (lookahead == '"') ADVANCE(635);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '%') ADVANCE(1619);
      if (lookahead == '&') ADVANCE(1328);
      if (lookahead == '\'') ADVANCE(120);
      if (lookahead == '(') ADVANCE(1248);
      if (lookahead == ')') ADVANCE(1249);
      if (lookahead == '+') ADVANCE(1640);
      if (lookahead == ',') ADVANCE(1251);
      if (lookahead == '-') ADVANCE(1646);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == ';') ADVANCE(1245);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead == '[') ADVANCE(761);
      if (lookahead == '`') SKIP(533)
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1450);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == '{') ADVANCE(1261);
      if (lookahead == '}') ADVANCE(1263);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1352);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(541)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (lookahead != 0 &&
          (lookahead < '*' || '/' < lookahead) &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(1512);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(94);
      if (lookahead == '"') ADVANCE(690);
      if (lookahead == '#') ADVANCE(544);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(544);
      if (lookahead != 0) ADVANCE(554);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(1336);
      if (lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '`') ADVANCE(554);
      if (lookahead != 0) ADVANCE(545);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '|') ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(546);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(547);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(548);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_comment);
      if (sym_comment_character_set_1(lookahead)) ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(549);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(554);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.') ADVANCE(1363);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(558);
      if (lookahead == 'e') ADVANCE(1359);
      if (lookahead == 'g') ADVANCE(1360);
      if (lookahead == 'k') ADVANCE(1360);
      if (lookahead == 'm') ADVANCE(1360);
      if (lookahead == 'p') ADVANCE(1360);
      if (lookahead == 't') ADVANCE(1360);
      if (lookahead == 'x') ADVANCE(1364);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(557);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.') ADVANCE(1363);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(558);
      if (lookahead == 'e') ADVANCE(1359);
      if (lookahead == 'g') ADVANCE(1360);
      if (lookahead == 'k') ADVANCE(1360);
      if (lookahead == 'm') ADVANCE(1360);
      if (lookahead == 'p') ADVANCE(1360);
      if (lookahead == 't') ADVANCE(1360);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(557);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'g') ADVANCE(1360);
      if (lookahead == 'k') ADVANCE(1360);
      if (lookahead == 'm') ADVANCE(1360);
      if (lookahead == 'p') ADVANCE(1360);
      if (lookahead == 't') ADVANCE(1360);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '>') ADVANCE(777);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '>') ADVANCE(783);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '>') ADVANCE(789);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '>') ADVANCE(795);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == '>') ADVANCE(801);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (lookahead == 'x') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(521);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(567);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1509);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(589);
      if (lookahead == 'e') ADVANCE(1508);
      if (lookahead == 'g') ADVANCE(1386);
      if (lookahead == 'k') ADVANCE(1386);
      if (lookahead == 'm') ADVANCE(1386);
      if (lookahead == 'p') ADVANCE(1386);
      if (lookahead == 't') ADVANCE(1386);
      if (lookahead == 'x') ADVANCE(1510);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_1(lookahead)) ADVANCE(1512);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1509);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(589);
      if (lookahead == 'e') ADVANCE(1508);
      if (lookahead == 'g') ADVANCE(1386);
      if (lookahead == 'k') ADVANCE(1386);
      if (lookahead == 'm') ADVANCE(1386);
      if (lookahead == 'p') ADVANCE(1386);
      if (lookahead == 't') ADVANCE(1386);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_1(lookahead)) ADVANCE(1512);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '>') ADVANCE(777);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '>') ADVANCE(783);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '>') ADVANCE(789);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '>') ADVANCE(795);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == '>') ADVANCE(801);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (lookahead == 'x') ADVANCE(1608);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1606);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(590);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(577);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '>') ADVANCE(1154);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '>') ADVANCE(779);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '>') ADVANCE(785);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '>') ADVANCE(791);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '>') ADVANCE(797);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '>') ADVANCE(803);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead == 'x') ADVANCE(1187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(591);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1209);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(592);
      if (lookahead == 'e') ADVANCE(1207);
      if (lookahead == 'g') ADVANCE(1204);
      if (lookahead == 'k') ADVANCE(1204);
      if (lookahead == 'm') ADVANCE(1204);
      if (lookahead == 'p') ADVANCE(1204);
      if (lookahead == 't') ADVANCE(1204);
      if (lookahead == 'x') ADVANCE(1211);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(587);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(1209);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(592);
      if (lookahead == 'e') ADVANCE(1207);
      if (lookahead == 'g') ADVANCE(1204);
      if (lookahead == 'k') ADVANCE(1204);
      if (lookahead == 'm') ADVANCE(1204);
      if (lookahead == 'p') ADVANCE(1204);
      if (lookahead == 't') ADVANCE(1204);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(587);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1386);
      if (lookahead == 'k') ADVANCE(1386);
      if (lookahead == 'm') ADVANCE(1386);
      if (lookahead == 'p') ADVANCE(1386);
      if (lookahead == 't') ADVANCE(1386);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1598);
      if (lookahead == 'k') ADVANCE(1598);
      if (lookahead == 'm') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1598);
      if (lookahead == 't') ADVANCE(1598);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1177);
      if (lookahead == 'k') ADVANCE(1177);
      if (lookahead == 'm') ADVANCE(1177);
      if (lookahead == 'p') ADVANCE(1177);
      if (lookahead == 't') ADVANCE(1177);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1204);
      if (lookahead == 'k') ADVANCE(1204);
      if (lookahead == 'm') ADVANCE(1204);
      if (lookahead == 'p') ADVANCE(1204);
      if (lookahead == 't') ADVANCE(1204);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (lookahead == 'x') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(594);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(588);
      if (lookahead == 'g') ADVANCE(199);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 'm') ADVANCE(199);
      if (lookahead == 'p') ADVANCE(199);
      if (lookahead == 't') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(594);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'g') ADVANCE(1362);
      if (lookahead == 'k') ADVANCE(1362);
      if (lookahead == 'l') ADVANCE(601);
      if (lookahead == 'm') ADVANCE(1362);
      if (lookahead == 'p') ADVANCE(1362);
      if (lookahead == 't') ADVANCE(1362);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(600);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'g') ADVANCE(1362);
      if (lookahead == 'k') ADVANCE(1362);
      if (lookahead == 'm') ADVANCE(1362);
      if (lookahead == 'p') ADVANCE(1362);
      if (lookahead == 't') ADVANCE(1362);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(201);
      if (lookahead == 'k') ADVANCE(201);
      if (lookahead == 'l') ADVANCE(604);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'p') ADVANCE(201);
      if (lookahead == 't') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(603);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(201);
      if (lookahead == 'k') ADVANCE(201);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'p') ADVANCE(201);
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1388);
      if (lookahead == 'k') ADVANCE(1388);
      if (lookahead == 'l') ADVANCE(606);
      if (lookahead == 'm') ADVANCE(1388);
      if (lookahead == 'p') ADVANCE(1388);
      if (lookahead == 't') ADVANCE(1388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(605);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1388);
      if (lookahead == 'k') ADVANCE(1388);
      if (lookahead == 'm') ADVANCE(1388);
      if (lookahead == 'p') ADVANCE(1388);
      if (lookahead == 't') ADVANCE(1388);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1600);
      if (lookahead == 'k') ADVANCE(1600);
      if (lookahead == 'l') ADVANCE(608);
      if (lookahead == 'm') ADVANCE(1600);
      if (lookahead == 'p') ADVANCE(1600);
      if (lookahead == 't') ADVANCE(1600);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(607);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1600);
      if (lookahead == 'k') ADVANCE(1600);
      if (lookahead == 'm') ADVANCE(1600);
      if (lookahead == 'p') ADVANCE(1600);
      if (lookahead == 't') ADVANCE(1600);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1179);
      if (lookahead == 'k') ADVANCE(1179);
      if (lookahead == 'l') ADVANCE(610);
      if (lookahead == 'm') ADVANCE(1179);
      if (lookahead == 'p') ADVANCE(1179);
      if (lookahead == 't') ADVANCE(1179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(609);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1179);
      if (lookahead == 'k') ADVANCE(1179);
      if (lookahead == 'm') ADVANCE(1179);
      if (lookahead == 'p') ADVANCE(1179);
      if (lookahead == 't') ADVANCE(1179);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1206);
      if (lookahead == 'k') ADVANCE(1206);
      if (lookahead == 'l') ADVANCE(612);
      if (lookahead == 'm') ADVANCE(1206);
      if (lookahead == 'p') ADVANCE(1206);
      if (lookahead == 't') ADVANCE(1206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(611);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == 'g') ADVANCE(1206);
      if (lookahead == 'k') ADVANCE(1206);
      if (lookahead == 'm') ADVANCE(1206);
      if (lookahead == 'p') ADVANCE(1206);
      if (lookahead == 't') ADVANCE(1206);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_hexadecimal_integer_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_real_literal);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'e') ADVANCE(1359);
      if (lookahead == 'g') ADVANCE(1361);
      if (lookahead == 'k') ADVANCE(1361);
      if (lookahead == 'm') ADVANCE(1361);
      if (lookahead == 'p') ADVANCE(1361);
      if (lookahead == 't') ADVANCE(1361);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(618);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'g') ADVANCE(1361);
      if (lookahead == 'k') ADVANCE(1361);
      if (lookahead == 'm') ADVANCE(1361);
      if (lookahead == 'p') ADVANCE(1361);
      if (lookahead == 't') ADVANCE(1361);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(619);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'e') ADVANCE(520);
      if (lookahead == 'g') ADVANCE(200);
      if (lookahead == 'k') ADVANCE(200);
      if (lookahead == 'm') ADVANCE(200);
      if (lookahead == 'p') ADVANCE(200);
      if (lookahead == 't') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'e') ADVANCE(1508);
      if (lookahead == 'g') ADVANCE(1387);
      if (lookahead == 'k') ADVANCE(1387);
      if (lookahead == 'm') ADVANCE(1387);
      if (lookahead == 'p') ADVANCE(1387);
      if (lookahead == 't') ADVANCE(1387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(622);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'e') ADVANCE(1590);
      if (lookahead == 'g') ADVANCE(1599);
      if (lookahead == 'k') ADVANCE(1599);
      if (lookahead == 'm') ADVANCE(1599);
      if (lookahead == 'p') ADVANCE(1599);
      if (lookahead == 't') ADVANCE(1599);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(623);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'e') ADVANCE(1181);
      if (lookahead == 'g') ADVANCE(1178);
      if (lookahead == 'k') ADVANCE(1178);
      if (lookahead == 'm') ADVANCE(1178);
      if (lookahead == 'p') ADVANCE(1178);
      if (lookahead == 't') ADVANCE(1178);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(624);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'e') ADVANCE(1207);
      if (lookahead == 'g') ADVANCE(1205);
      if (lookahead == 'k') ADVANCE(1205);
      if (lookahead == 'm') ADVANCE(1205);
      if (lookahead == 'p') ADVANCE(1205);
      if (lookahead == 't') ADVANCE(1205);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(625);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'g') ADVANCE(200);
      if (lookahead == 'k') ADVANCE(200);
      if (lookahead == 'm') ADVANCE(200);
      if (lookahead == 'p') ADVANCE(200);
      if (lookahead == 't') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(626);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'g') ADVANCE(1387);
      if (lookahead == 'k') ADVANCE(1387);
      if (lookahead == 'm') ADVANCE(1387);
      if (lookahead == 'p') ADVANCE(1387);
      if (lookahead == 't') ADVANCE(1387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(627);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'g') ADVANCE(1599);
      if (lookahead == 'k') ADVANCE(1599);
      if (lookahead == 'm') ADVANCE(1599);
      if (lookahead == 'p') ADVANCE(1599);
      if (lookahead == 't') ADVANCE(1599);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(628);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'g') ADVANCE(1178);
      if (lookahead == 'k') ADVANCE(1178);
      if (lookahead == 'm') ADVANCE(1178);
      if (lookahead == 'p') ADVANCE(1178);
      if (lookahead == 't') ADVANCE(1178);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(629);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'g') ADVANCE(1205);
      if (lookahead == 'k') ADVANCE(1205);
      if (lookahead == 'm') ADVANCE(1205);
      if (lookahead == 'p') ADVANCE(1205);
      if (lookahead == 't') ADVANCE(1205);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(630);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_real_literal);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token1);
      if (lookahead == '#') ADVANCE(635);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(635);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token1);
      if (lookahead == '#') ADVANCE(636);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(635);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token1);
      if (lookahead == '#') ADVANCE(637);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(635);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '\n') ADVANCE(681);
      if (lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '`') ADVANCE(554);
      if (lookahead != 0) ADVANCE(638);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '\n') ADVANCE(640);
      if (lookahead == '"') ADVANCE(690);
      if (lookahead == '#') ADVANCE(639);
      if (lookahead == '$' ||
          lookahead == '`') ADVANCE(554);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(639);
      if (lookahead != 0) ADVANCE(638);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '"') ADVANCE(688);
      if (lookahead == '#') ADVANCE(640);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(640);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '#') ADVANCE(639);
      if (lookahead == '<') ADVANCE(643);
      if (lookahead == '@') ADVANCE(678);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(642);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(641);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '#') ADVANCE(638);
      if (lookahead == '<') ADVANCE(643);
      if (lookahead == '@') ADVANCE(678);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(642);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '#') ADVANCE(645);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '#') ADVANCE(644);
      if (lookahead == '>') ADVANCE(681);
      if (('"' <= lookahead && lookahead <= '$') ||
          lookahead == '`') ADVANCE(112);
      if (lookahead != 0) ADVANCE(645);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '#') ADVANCE(644);
      if (lookahead == '`') ADVANCE(525);
      if (('"' <= lookahead && lookahead <= '$')) ADVANCE(112);
      if (lookahead != 0) ADVANCE(645);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == '?') ADVANCE(681);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(680);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'a') ADVANCE(672);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'a') ADVANCE(659);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'b') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'c') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'c') ADVANCE(670);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'e') ADVANCE(677);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'f') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'g') ADVANCE(677);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'i') ADVANCE(674);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'i') ADVANCE(662);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'i') ADVANCE(667);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'k') ADVANCE(653);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'l') ADVANCE(677);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'l') ADVANCE(663);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'l') ADVANCE(664);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'n') ADVANCE(654);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'o') ADVANCE(649);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'o') ADVANCE(675);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'o') ADVANCE(669);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'o') ADVANCE(650);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'p') ADVANCE(673);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'r') ADVANCE(655);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'r') ADVANCE(658);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'r') ADVANCE(657);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 's') ADVANCE(656);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 't') ADVANCE(652);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 't') ADVANCE(677);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'v') ADVANCE(647);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (lookahead == 'w') ADVANCE(677);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(679);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == ':') ADVANCE(646);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '?') ADVANCE(681);
      if (lookahead == 'g') ADVANCE(660);
      if (lookahead == 'l') ADVANCE(666);
      if (lookahead == 'p') ADVANCE(668);
      if (lookahead == 's') ADVANCE(651);
      if (lookahead == 'u') ADVANCE(671);
      if (lookahead == 'w') ADVANCE(665);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(676);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead == '?') ADVANCE(681);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(680);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(680);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(681);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token3);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token4);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == '`') ADVANCE(526);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '\\') ADVANCE(682);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token5);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token5);
      if (lookahead == '"') ADVANCE(684);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(aux_sym_expandable_string_literal_token5);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(554);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token1);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '#') ADVANCE(730);
      if (lookahead == '<') ADVANCE(693);
      if (lookahead == '@') ADVANCE(728);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(692);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '#') ADVANCE(695);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '#') ADVANCE(694);
      if (lookahead == '>') ADVANCE(732);
      if (lookahead == '\n' ||
          lookahead == '$' ||
          lookahead == '`') ADVANCE(112);
      if (lookahead != 0) ADVANCE(695);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '#') ADVANCE(694);
      if (lookahead == '`') ADVANCE(525);
      if (lookahead == '\n' ||
          lookahead == '$') ADVANCE(112);
      if (lookahead != 0) ADVANCE(695);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == '?') ADVANCE(732);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(731);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'a') ADVANCE(722);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'a') ADVANCE(709);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'b') ADVANCE(698);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'c') ADVANCE(698);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'c') ADVANCE(720);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'e') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'f') ADVANCE(711);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'g') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'i') ADVANCE(724);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'i') ADVANCE(712);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'i') ADVANCE(717);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'k') ADVANCE(703);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'l') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'l') ADVANCE(713);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'l') ADVANCE(714);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'n') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(699);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(719);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'o') ADVANCE(700);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'p') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'r') ADVANCE(705);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'r') ADVANCE(708);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'r') ADVANCE(707);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 's') ADVANCE(706);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 't') ADVANCE(702);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 't') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'v') ADVANCE(697);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (lookahead == 'w') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(729);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == ':') ADVANCE(696);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '?') ADVANCE(732);
      if (lookahead == 'g') ADVANCE(710);
      if (lookahead == 'l') ADVANCE(716);
      if (lookahead == 'p') ADVANCE(718);
      if (lookahead == 's') ADVANCE(701);
      if (lookahead == 'u') ADVANCE(721);
      if (lookahead == 'w') ADVANCE(715);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(726);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '?') ADVANCE(732);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(731);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead == '$' ||
          lookahead == '`') ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(730);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(731);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(732);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token3);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token3);
      if (lookahead == '#') ADVANCE(112);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token3);
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token3);
      if (lookahead == '?') ADVANCE(1009);
      if (lookahead == 'g') ADVANCE(1054);
      if (lookahead == 'l') ADVANCE(1060);
      if (lookahead == 'p') ADVANCE(1062);
      if (lookahead == 's') ADVANCE(1045);
      if (lookahead == 'u') ADVANCE(1065);
      if (lookahead == 'w') ADVANCE(1059);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token3);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(554);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token4);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(aux_sym_expandable_here_string_literal_token5);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_verbatim_string_characters);
      if (lookahead == '\'') ADVANCE(1155);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_verbatim_string_characters);
      if (lookahead == '\'') ADVANCE(1199);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_verbatim_string_characters);
      if (lookahead == '\'') ADVANCE(120);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_verbatim_here_string_characters);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_verbatim_here_string_characters);
      if (lookahead == '\n') ADVANCE(45);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'a') ADVANCE(754);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'c') ADVANCE(1629);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'd') ADVANCE(749);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'd') ADVANCE(747);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'e') ADVANCE(752);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'i') ADVANCE(748);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'i') ADVANCE(746);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 'n') ADVANCE(1627);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 't') ADVANCE(745);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_simple_name);
      if (lookahead == 't') ADVANCE(751);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_simple_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_type_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(756);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(622);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(774);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(775);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(776);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(anon_sym_2_GT);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '>') ADVANCE(780);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(anon_sym_2_GT);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '>') ADVANCE(781);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(anon_sym_2_GT);
      if (lookahead == '&') ADVANCE(1160);
      if (lookahead == '>') ADVANCE(782);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(anon_sym_2_GT_GT);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(anon_sym_2_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(anon_sym_2_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(anon_sym_3_GT);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '>') ADVANCE(786);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(anon_sym_3_GT);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '>') ADVANCE(787);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(anon_sym_3_GT);
      if (lookahead == '&') ADVANCE(1161);
      if (lookahead == '>') ADVANCE(788);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(anon_sym_3_GT_GT);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(anon_sym_3_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(anon_sym_3_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(anon_sym_4_GT);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '>') ADVANCE(792);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(anon_sym_4_GT);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '>') ADVANCE(793);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(anon_sym_4_GT);
      if (lookahead == '&') ADVANCE(1162);
      if (lookahead == '>') ADVANCE(794);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(anon_sym_4_GT_GT);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(anon_sym_4_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(anon_sym_4_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(anon_sym_5_GT);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '>') ADVANCE(798);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(anon_sym_5_GT);
      if (lookahead == '&') ADVANCE(134);
      if (lookahead == '>') ADVANCE(799);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(anon_sym_5_GT);
      if (lookahead == '&') ADVANCE(1163);
      if (lookahead == '>') ADVANCE(800);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(anon_sym_5_GT_GT);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(anon_sym_5_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(anon_sym_5_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(anon_sym_6_GT);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '>') ADVANCE(804);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(anon_sym_6_GT);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '>') ADVANCE(805);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(anon_sym_6_GT);
      if (lookahead == '&') ADVANCE(1164);
      if (lookahead == '>') ADVANCE(806);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(anon_sym_6_GT_GT);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(anon_sym_6_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(anon_sym_6_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(anon_sym_STAR_GT);
      if (lookahead == '&') ADVANCE(130);
      if (lookahead == '>') ADVANCE(810);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(anon_sym_STAR_GT);
      if (lookahead == '&') ADVANCE(130);
      if (lookahead == '>') ADVANCE(811);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(anon_sym_STAR_GT);
      if (lookahead == '&') ADVANCE(1159);
      if (lookahead == '>') ADVANCE(812);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(anon_sym_STAR_GT_GT);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(anon_sym_STAR_GT_GT);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(anon_sym_STAR_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '#') ADVANCE(112);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '#') ADVANCE(1519);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '#') ADVANCE(1150);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(anon_sym_STAR_GT_AMP1);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(anon_sym_STAR_GT_AMP1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(anon_sym_2_GT_AMP1);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(anon_sym_2_GT_AMP1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(anon_sym_3_GT_AMP1);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(anon_sym_3_GT_AMP1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(anon_sym_4_GT_AMP1);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(anon_sym_4_GT_AMP1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(anon_sym_5_GT_AMP1);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(anon_sym_5_GT_AMP1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(anon_sym_6_GT_AMP1);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(anon_sym_6_GT_AMP1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(anon_sym_STAR_GT_AMP2);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(anon_sym_STAR_GT_AMP2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(anon_sym_1_GT_AMP2);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(anon_sym_1_GT_AMP2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(anon_sym_3_GT_AMP2);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(anon_sym_3_GT_AMP2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(anon_sym_4_GT_AMP2);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(anon_sym_4_GT_AMP2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(anon_sym_5_GT_AMP2);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(anon_sym_5_GT_AMP2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(anon_sym_6_GT_AMP2);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(anon_sym_6_GT_AMP2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(anon_sym_DASHas);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(anon_sym_DASHccontains);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(anon_sym_DASHceq);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(anon_sym_DASHcge);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(anon_sym_DASHcgt);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(anon_sym_DASHcle);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(anon_sym_DASHclike);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(anon_sym_DASHclt);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(anon_sym_DASHcmatch);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(anon_sym_DASHcne);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(anon_sym_DASHcnotcontains);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(anon_sym_DASHcnotlike);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(anon_sym_DASHcnotmatch);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(anon_sym_DASHcontains);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(anon_sym_DASHcreplace);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(anon_sym_DASHcsplit);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(anon_sym_DASHeq);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(anon_sym_DASHge);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(anon_sym_DASHgt);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(anon_sym_DASHicontains);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(anon_sym_DASHieq);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(anon_sym_DASHige);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(anon_sym_DASHigt);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(anon_sym_DASHile);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(anon_sym_DASHilike);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(anon_sym_DASHilt);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(anon_sym_DASHimatch);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(anon_sym_DASHin);
      if (lookahead == 'e') ADVANCE(868);
      if (lookahead == 'o') ADVANCE(507);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(anon_sym_DASHine);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(anon_sym_DASHinotcontains);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(anon_sym_DASHinotlike);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(anon_sym_DASHinotmatch);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(anon_sym_DASHireplace);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(anon_sym_DASHis);
      if (lookahead == 'n') ADVANCE(418);
      if (lookahead == 'p') ADVANCE(367);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(anon_sym_DASHisnot);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(anon_sym_DASHisplit);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(anon_sym_DASHjoin);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(anon_sym_DASHjoin);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(anon_sym_DASHle);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(anon_sym_DASHlike);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(anon_sym_DASHlt);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(anon_sym_DASHmatch);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(anon_sym_DASHne);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(anon_sym_DASHnotcontains);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(anon_sym_DASHnotin);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(anon_sym_DASHnotlike);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(anon_sym_DASHnotmatch);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(anon_sym_DASHreplace);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(anon_sym_DASHshl);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(anon_sym_DASHshr);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(anon_sym_DASHsplit);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(anon_sym_DASHsplit);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_format_operator);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_format_operator);
      if (lookahead == 'i') ADVANCE(355);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_DOLLAR_CARET);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(anon_sym_DOLLAR_CARET);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(anon_sym_DOLLAR_CARET);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(anon_sym_DOLLAR_CARET);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_DOLLAR_QMARK);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_DOLLAR_QMARK);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_DOLLAR_QMARK);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(anon_sym_DOLLAR_QMARK);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_DOLLAR_);
      if (lookahead == ':') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_DOLLAR_);
      if (lookahead == ':') ADVANCE(1568);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(anon_sym_DOLLAR_);
      if (lookahead == ':') ADVANCE(1176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(anon_sym_DOLLAR_);
      if (lookahead == ':') ADVANCE(1203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'a') ADVANCE(936);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'a') ADVANCE(923);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'b') ADVANCE(912);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'c') ADVANCE(912);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'c') ADVANCE(934);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'e') ADVANCE(941);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'f') ADVANCE(925);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'g') ADVANCE(941);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'i') ADVANCE(938);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'i') ADVANCE(926);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'i') ADVANCE(931);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'k') ADVANCE(917);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'l') ADVANCE(941);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'l') ADVANCE(927);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'l') ADVANCE(928);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'n') ADVANCE(918);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'o') ADVANCE(913);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'o') ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'o') ADVANCE(933);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'o') ADVANCE(914);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'p') ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'r') ADVANCE(919);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'r') ADVANCE(922);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'r') ADVANCE(921);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 's') ADVANCE(920);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 't') ADVANCE(916);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 't') ADVANCE(941);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'v') ADVANCE(911);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (lookahead == 'w') ADVANCE(941);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'a') ADVANCE(967);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'a') ADVANCE(954);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'b') ADVANCE(943);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'c') ADVANCE(943);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'c') ADVANCE(965);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'e') ADVANCE(972);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'f') ADVANCE(956);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'g') ADVANCE(972);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'i') ADVANCE(969);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'i') ADVANCE(957);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'i') ADVANCE(962);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'k') ADVANCE(948);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(972);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(958);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'l') ADVANCE(959);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'n') ADVANCE(949);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'o') ADVANCE(944);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'o') ADVANCE(970);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'o') ADVANCE(964);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'o') ADVANCE(945);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'p') ADVANCE(968);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'r') ADVANCE(950);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'r') ADVANCE(953);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'r') ADVANCE(952);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 's') ADVANCE(951);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 't') ADVANCE(947);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 't') ADVANCE(972);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'v') ADVANCE(942);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == 'w') ADVANCE(972);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'a') ADVANCE(998);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'a') ADVANCE(985);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'b') ADVANCE(974);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'c') ADVANCE(974);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'c') ADVANCE(996);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'e') ADVANCE(1003);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'f') ADVANCE(987);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'g') ADVANCE(1003);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'i') ADVANCE(1000);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'i') ADVANCE(988);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'i') ADVANCE(993);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'k') ADVANCE(979);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'l') ADVANCE(1003);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'l') ADVANCE(989);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'l') ADVANCE(990);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'n') ADVANCE(980);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(975);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(1001);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(995);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'o') ADVANCE(976);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'p') ADVANCE(999);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'r') ADVANCE(981);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'r') ADVANCE(984);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'r') ADVANCE(983);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 's') ADVANCE(982);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 't') ADVANCE(978);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 't') ADVANCE(1003);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'v') ADVANCE(973);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == 'w') ADVANCE(1003);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead == ':') ADVANCE(1200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1004);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1005);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1006);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'a') ADVANCE(1035);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'a') ADVANCE(1022);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'b') ADVANCE(1011);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'c') ADVANCE(1011);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'c') ADVANCE(1033);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'e') ADVANCE(1040);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'f') ADVANCE(1024);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'g') ADVANCE(1040);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'i') ADVANCE(1037);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'i') ADVANCE(1025);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'i') ADVANCE(1030);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'k') ADVANCE(1016);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'l') ADVANCE(1040);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'l') ADVANCE(1026);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'l') ADVANCE(1027);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'n') ADVANCE(1017);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'o') ADVANCE(1012);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'o') ADVANCE(1038);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'o') ADVANCE(1032);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'o') ADVANCE(1013);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'p') ADVANCE(1036);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'r') ADVANCE(1018);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'r') ADVANCE(1021);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'r') ADVANCE(1020);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 's') ADVANCE(1019);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 't') ADVANCE(1015);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 't') ADVANCE(1040);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'v') ADVANCE(1010);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == 'w') ADVANCE(1040);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1333);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'a') ADVANCE(1066);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'a') ADVANCE(1053);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'b') ADVANCE(1042);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'c') ADVANCE(1042);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'c') ADVANCE(1064);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'e') ADVANCE(1071);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'f') ADVANCE(1055);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'g') ADVANCE(1071);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'i') ADVANCE(1068);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'i') ADVANCE(1056);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'i') ADVANCE(1061);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'k') ADVANCE(1047);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(1071);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(1057);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'l') ADVANCE(1058);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'n') ADVANCE(1048);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'o') ADVANCE(1043);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'o') ADVANCE(1069);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'o') ADVANCE(1063);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'o') ADVANCE(1044);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'p') ADVANCE(1067);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'r') ADVANCE(1049);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'r') ADVANCE(1052);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'r') ADVANCE(1051);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 's') ADVANCE(1050);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 't') ADVANCE(1046);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 't') ADVANCE(1071);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'v') ADVANCE(1041);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (lookahead == 'w') ADVANCE(1071);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1070);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'a') ADVANCE(1097);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'a') ADVANCE(1084);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'b') ADVANCE(1073);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'c') ADVANCE(1073);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'c') ADVANCE(1095);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'e') ADVANCE(1102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'f') ADVANCE(1086);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'g') ADVANCE(1102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'i') ADVANCE(1099);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'i') ADVANCE(1087);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'i') ADVANCE(1092);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'k') ADVANCE(1078);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'l') ADVANCE(1102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'l') ADVANCE(1088);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'l') ADVANCE(1089);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'n') ADVANCE(1079);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'o') ADVANCE(1074);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'o') ADVANCE(1100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'o') ADVANCE(1094);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'o') ADVANCE(1075);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'p') ADVANCE(1098);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'r') ADVANCE(1080);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'r') ADVANCE(1083);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'r') ADVANCE(1082);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 's') ADVANCE(1081);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 't') ADVANCE(1077);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 't') ADVANCE(1102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'v') ADVANCE(1072);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == 'w') ADVANCE(1102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'a') ADVANCE(1128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'a') ADVANCE(1115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'b') ADVANCE(1104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'c') ADVANCE(1104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'c') ADVANCE(1126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'e') ADVANCE(1133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'f') ADVANCE(1117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'g') ADVANCE(1133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'i') ADVANCE(1130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'i') ADVANCE(1118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'i') ADVANCE(1123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'k') ADVANCE(1109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'l') ADVANCE(1133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'l') ADVANCE(1119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'l') ADVANCE(1120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'n') ADVANCE(1110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'o') ADVANCE(1105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'o') ADVANCE(1131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'o') ADVANCE(1125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'o') ADVANCE(1106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'p') ADVANCE(1129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'r') ADVANCE(1111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'r') ADVANCE(1114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'r') ADVANCE(1113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 's') ADVANCE(1112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 't') ADVANCE(1108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 't') ADVANCE(1133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'v') ADVANCE(1103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == 'w') ADVANCE(1133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead == ':') ADVANCE(1201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1134);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1135);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1137);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(aux_sym_variable_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(sym_braced_variable);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '\n') ADVANCE(691);
      if (lookahead == ' ') ADVANCE(2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '\n') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(3);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == ' ') ADVANCE(1612);
      if (lookahead == '"') ADVANCE(636);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == '$') ADVANCE(1151);
      if (lookahead == '\'') ADVANCE(1155);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == ',') ADVANCE(1252);
      if (lookahead == '-') ADVANCE(1156);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '0') ADVANCE(584);
      if (lookahead == '1') ADVANCE(578);
      if (lookahead == '2') ADVANCE(579);
      if (lookahead == '3') ADVANCE(580);
      if (lookahead == '4') ADVANCE(581);
      if (lookahead == '5') ADVANCE(582);
      if (lookahead == '6') ADVANCE(583);
      if (lookahead == ':') ADVANCE(1618);
      if (lookahead == ';') ADVANCE(1189);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '@') ADVANCE(1147);
      if (lookahead == '[') ADVANCE(764);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == '{') ADVANCE(1262);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1144);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1144);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == ' ') ADVANCE(1613);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == '1') ADVANCE(1169);
      if (lookahead == '2') ADVANCE(1170);
      if (lookahead == '3') ADVANCE(1171);
      if (lookahead == '4') ADVANCE(1172);
      if (lookahead == '5') ADVANCE(1173);
      if (lookahead == '6') ADVANCE(1174);
      if (lookahead == ';') ADVANCE(1189);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1145);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1145);
      if (('"' <= lookahead && lookahead <= '$') ||
          lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '@' ||
          lookahead == '[' ||
          lookahead == '{') ADVANCE(1189);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == ' ') ADVANCE(1614);
      if (lookahead == '"') ADVANCE(636);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == '$') ADVANCE(1151);
      if (lookahead == '\'') ADVANCE(1155);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == ',') ADVANCE(1252);
      if (lookahead == '-') ADVANCE(1158);
      if (lookahead == '.') ADVANCE(1185);
      if (lookahead == '0') ADVANCE(584);
      if (lookahead == '1') ADVANCE(578);
      if (lookahead == '2') ADVANCE(579);
      if (lookahead == '3') ADVANCE(580);
      if (lookahead == '4') ADVANCE(581);
      if (lookahead == '5') ADVANCE(582);
      if (lookahead == '6') ADVANCE(583);
      if (lookahead == ':') ADVANCE(1618);
      if (lookahead == ';') ADVANCE(1189);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '@') ADVANCE(1147);
      if (lookahead == '[') ADVANCE(764);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == '{') ADVANCE(1262);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1146);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(585);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1146);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '"') ADVANCE(1142);
      if (lookahead == '\'') ADVANCE(1143);
      if (lookahead == '(') ADVANCE(1672);
      if (lookahead == '?') ADVANCE(1139);
      if (lookahead == 'g') ADVANCE(1085);
      if (lookahead == 'l') ADVANCE(1091);
      if (lookahead == 'p') ADVANCE(1093);
      if (lookahead == 's') ADVANCE(1076);
      if (lookahead == 'u') ADVANCE(1096);
      if (lookahead == 'w') ADVANCE(1090);
      if (lookahead == '{') ADVANCE(1674);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '#') ADVANCE(548);
      if (lookahead == '*') ADVANCE(1168);
      if (lookahead == '1') ADVANCE(1169);
      if (lookahead == '2') ADVANCE(1170);
      if (lookahead == '3') ADVANCE(1171);
      if (lookahead == '4') ADVANCE(1172);
      if (lookahead == '5') ADVANCE(1173);
      if (lookahead == '6') ADVANCE(1174);
      if (lookahead == ';') ADVANCE(1189);
      if (lookahead == '<') ADVANCE(815);
      if (lookahead == '>') ADVANCE(773);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1148);
      if (('"' <= lookahead && lookahead <= '$') ||
          lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '@' ||
          lookahead == '[' ||
          lookahead == '{') ADVANCE(1189);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '#') ADVANCE(1149);
      if (lookahead == '>') ADVANCE(551);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1150);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '#') ADVANCE(1149);
      if (lookahead == '`') ADVANCE(1184);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1150);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '$') ADVANCE(897);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(905);
      if (lookahead == '^') ADVANCE(901);
      if (lookahead == '_') ADVANCE(908);
      if (lookahead == 'g') ADVANCE(955);
      if (lookahead == 'l') ADVANCE(961);
      if (lookahead == 'p') ADVANCE(963);
      if (lookahead == 's') ADVANCE(946);
      if (lookahead == 'u') ADVANCE(966);
      if (lookahead == 'w') ADVANCE(960);
      if (lookahead == '{') ADVANCE(1183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '%') ADVANCE(1623);
      if (lookahead == '-') ADVANCE(1157);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '%') ADVANCE(1182);
      if (lookahead == '-') ADVANCE(1157);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '&') ADVANCE(1165);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '\'') ADVANCE(740);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(120);
      if (lookahead != 0) ADVANCE(1155);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '-') ADVANCE(1152);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '-') ADVANCE(1157);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '-') ADVANCE(1153);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '1') ADVANCE(817);
      if (lookahead == '2') ADVANCE(829);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '1') ADVANCE(819);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '1') ADVANCE(821);
      if (lookahead == '2') ADVANCE(833);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '1') ADVANCE(823);
      if (lookahead == '2') ADVANCE(835);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '1') ADVANCE(825);
      if (lookahead == '2') ADVANCE(837);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '1') ADVANCE(827);
      if (lookahead == '2') ADVANCE(839);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '2') ADVANCE(831);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == ':') ADVANCE(1176);
      if (lookahead == '?') ADVANCE(1008);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1005);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == ':') ADVANCE(1175);
      if (lookahead == '?') ADVANCE(1139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1135);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(809);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(1154);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(779);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(785);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(791);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(797);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '>') ADVANCE(803);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '?') ADVANCE(1139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1135);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '?') ADVANCE(1008);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1005);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == 'b') ADVANCE(598);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == 'b') ADVANCE(634);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == 'b') ADVANCE(616);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '}') ADVANCE(1141);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|') ADVANCE(519);
      if (lookahead != 0) ADVANCE(1180);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(629);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(1610);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1182);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|') ADVANCE(519);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(1180);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1150);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(sym_generic_token);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(624);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(sym_generic_token);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(629);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(sym_generic_token);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(609);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(sym_generic_token);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '\n') ADVANCE(691);
      if (lookahead == ' ') ADVANCE(2);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '\n') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(3);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '"') ADVANCE(637);
      if (lookahead == '#') ADVANCE(547);
      if (lookahead == '$') ADVANCE(1198);
      if (lookahead == '\'') ADVANCE(1199);
      if (lookahead == '.') ADVANCE(1209);
      if (lookahead == '0') ADVANCE(586);
      if (lookahead == '<') ADVANCE(1195);
      if (lookahead == '@') ADVANCE(1193);
      if (lookahead == '[') ADVANCE(763);
      if (lookahead == '`') ADVANCE(1212);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1192);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(587);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '"') ADVANCE(1190);
      if (lookahead == '\'') ADVANCE(1191);
      if (lookahead == '(') ADVANCE(1672);
      if (lookahead == '?') ADVANCE(1138);
      if (lookahead == 'g') ADVANCE(1116);
      if (lookahead == 'l') ADVANCE(1122);
      if (lookahead == 'p') ADVANCE(1124);
      if (lookahead == 's') ADVANCE(1107);
      if (lookahead == 'u') ADVANCE(1127);
      if (lookahead == 'w') ADVANCE(1121);
      if (lookahead == '{') ADVANCE(1673);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '#') ADVANCE(547);
      if (lookahead == '<') ADVANCE(1195);
      if (lookahead == '`') ADVANCE(1212);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1194);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '#') ADVANCE(1197);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '#') ADVANCE(1196);
      if (lookahead == '>') ADVANCE(550);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1197);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '#') ADVANCE(1196);
      if (lookahead == '`') ADVANCE(1208);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1197);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '$') ADVANCE(896);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(904);
      if (lookahead == '^') ADVANCE(900);
      if (lookahead == '_') ADVANCE(909);
      if (lookahead == 'g') ADVANCE(986);
      if (lookahead == 'l') ADVANCE(992);
      if (lookahead == 'p') ADVANCE(994);
      if (lookahead == 's') ADVANCE(977);
      if (lookahead == 'u') ADVANCE(997);
      if (lookahead == 'w') ADVANCE(991);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1002);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '\'') ADVANCE(741);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(120);
      if (lookahead != 0) ADVANCE(1199);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == ':') ADVANCE(1203);
      if (lookahead == '?') ADVANCE(1007);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1006);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == ':') ADVANCE(1202);
      if (lookahead == '?') ADVANCE(1138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '?') ADVANCE(1138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1136);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '?') ADVANCE(1007);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1006);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == 'b') ADVANCE(597);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == 'b') ADVANCE(633);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == 'b') ADVANCE(615);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1210);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(630);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1197);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(sym__command_token);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(625);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(sym__command_token);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(630);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(sym__command_token);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(611);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(sym__command_token);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(1212);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '%') ADVANCE(1625);
      if (lookahead == '-') ADVANCE(1217);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '%') ADVANCE(1625);
      if (lookahead == '-') ADVANCE(1218);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '%') ADVANCE(1610);
      if (lookahead == '-') ADVANCE(1217);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '%') ADVANCE(1610);
      if (lookahead == '-') ADVANCE(1218);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '-') ADVANCE(1217);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '-') ADVANCE(1218);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'i') ADVANCE(1223);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'i') ADVANCE(1231);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'l') ADVANCE(1221);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'n') ADVANCE(877);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'n') ADVANCE(1227);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'o') ADVANCE(1220);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'o') ADVANCE(1229);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'o') ADVANCE(1230);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 'p') ADVANCE(1222);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 't') ADVANCE(1658);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 't') ADVANCE(1662);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == 't') ADVANCE(891);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(sym_command_parameter);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token1);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token2);
      if (lookahead == '&') ADVANCE(1244);
      if (lookahead == '\n' ||
          lookahead == '|') ADVANCE(1236);
      if (lookahead != 0) ADVANCE(1235);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token2);
      if (lookahead != 0 &&
          lookahead != '&') ADVANCE(1236);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '"') ADVANCE(1239);
      if (lookahead == '#') ADVANCE(546);
      if (lookahead == '&') ADVANCE(1235);
      if (lookahead == ')') ADVANCE(1250);
      if (lookahead == '<') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(1244);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1237);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '"') ADVANCE(1239);
      if (lookahead == '#') ADVANCE(546);
      if (lookahead == '&') ADVANCE(1235);
      if (lookahead == '<') ADVANCE(1240);
      if (lookahead == '`') ADVANCE(1244);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1238);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '"') ADVANCE(1234);
      if (lookahead == '\n' ||
          lookahead == '|') ADVANCE(100);
      if (lookahead != 0) ADVANCE(1239);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '#') ADVANCE(1242);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '#') ADVANCE(1241);
      if (lookahead == '>') ADVANCE(553);
      if (lookahead == '\n' ||
          lookahead == '|') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1242);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '#') ADVANCE(1241);
      if (lookahead == '`') ADVANCE(1243);
      if (lookahead == '\n' ||
          lookahead == '|') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1242);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead == '\n' ||
          lookahead == '|') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1242);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(aux_sym__verbatim_command_argument_chars_token3);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(anon_sym_param);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '|') ADVANCE(1244);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(anon_sym_dynamicparam);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(anon_sym_dynamicparam);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(anon_sym_begin);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(anon_sym_process);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(anon_sym_process);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(anon_sym_end);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(anon_sym_if);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(anon_sym_elseif);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(1415);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(anon_sym_else);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(anon_sym_switch);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(anon_sym_DASHregex);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(anon_sym_DASHwildcard);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(anon_sym_DASHexact);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(anon_sym_DASHcasesensitive);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(anon_sym_DASHparallel);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(anon_sym_DASHfile);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(anon_sym_foreach);
      if (lookahead == '-') ADVANCE(411);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(anon_sym_foreach);
      if (lookahead == '-') ADVANCE(411);
      if (!aux_sym_command_name_token1_character_set_3(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'e') ADVANCE(1378);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(1286);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1347);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(1287);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(anon_sym_while);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(anon_sym_do);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(anon_sym_function);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(anon_sym_filter);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(anon_sym_filter);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(anon_sym_workflow);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(anon_sym_workflow);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(anon_sym_break);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(anon_sym_continue);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(anon_sym_throw);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(anon_sym_return);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(anon_sym_exit);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(anon_sym_exit);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(sym_label);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1309);
      if (!aux_sym_command_name_token1_character_set_4(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(sym_label);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1310);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(anon_sym_trap);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(anon_sym_trap);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(anon_sym_try);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(anon_sym_catch);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(anon_sym_finally);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(anon_sym_data);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(anon_sym_data);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(anon_sym_DASHsupportedcommand);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(anon_sym_inlinescript);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(anon_sym_parallel);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(anon_sym_parallel);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(anon_sym_sequence);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(anon_sym_sequence);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == '#') ADVANCE(545);
      if (lookahead == '<') ADVANCE(1330);
      if (lookahead == '@') ADVANCE(1334);
      if (lookahead == '`') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1329);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(1336);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == '#') ADVANCE(1332);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == '#') ADVANCE(1331);
      if (lookahead == '>') ADVANCE(552);
      if (('"' <= lookahead && lookahead <= '$') ||
          lookahead == '`') ADVANCE(112);
      if (lookahead != 0) ADVANCE(1332);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == '#') ADVANCE(1331);
      if (lookahead == '`') ADVANCE(525);
      if (('"' <= lookahead && lookahead <= '$')) ADVANCE(112);
      if (lookahead != 0) ADVANCE(1332);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == ':') ADVANCE(1335);
      if (lookahead == '?') ADVANCE(1140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1137);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == '?') ADVANCE(1140);
      if (lookahead == 'g') ADVANCE(1023);
      if (lookahead == 'l') ADVANCE(1029);
      if (lookahead == 'p') ADVANCE(1031);
      if (lookahead == 's') ADVANCE(1014);
      if (lookahead == 'u') ADVANCE(1034);
      if (lookahead == 'w') ADVANCE(1028);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1039);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead == '?') ADVANCE(1140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1137);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(1336);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token2);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token2);
      if (lookahead == '\n') ADVANCE(1337);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token3);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(aux_sym__expandable_string_literal_immediate_token3);
      if (lookahead == '`') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1329);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE2);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(anon_sym_DOLLAR2);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(anon_sym_DOLLAR2);
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == '`') ADVANCE(155);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(anon_sym_DOLLAR2);
      if (lookahead == '$') ADVANCE(894);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(902);
      if (lookahead == '^') ADVANCE(898);
      if (lookahead == '_') ADVANCE(906);
      if (lookahead == 'g') ADVANCE(924);
      if (lookahead == 'l') ADVANCE(930);
      if (lookahead == 'p') ADVANCE(932);
      if (lookahead == 's') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(935);
      if (lookahead == 'w') ADVANCE(929);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(940);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(1341);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '\n') ADVANCE(1286);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1347);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_5(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1376);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1348);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1349);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1425);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1350);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1444);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1351);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1450);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1352);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1478);
      if (lookahead == 'c') ADVANCE(1382);
      if (lookahead == 'd') ADVANCE(1368);
      if (lookahead == 'e') ADVANCE(1454);
      if (lookahead == 'f') ADVANCE(1425);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1385);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1353);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1403);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1367);
      if (lookahead == 'e') ADVANCE(1458);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1375);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1354);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == ':') ADVANCE(1511);
      if (lookahead == 'b') ADVANCE(1403);
      if (lookahead == 'c') ADVANCE(1439);
      if (lookahead == 'd') ADVANCE(1367);
      if (lookahead == 'e') ADVANCE(1458);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'i') ADVANCE(1414);
      if (lookahead == 'p') ADVANCE(1384);
      if (lookahead == 'r') ADVANCE(1406);
      if (lookahead == 's') ADVANCE(1399);
      if (lookahead == 't') ADVANCE(1423);
      if (lookahead == 'w') ADVANCE(1422);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1355);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_6(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(759);
      if (lookahead == '0') ADVANCE(568);
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1356);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(569);
      if (!aux_sym_command_name_token1_character_set_7(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(1363);
      if (lookahead == '0') ADVANCE(556);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1357);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(557);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '#') ADVANCE(549);
      if (lookahead == '.') ADVANCE(760);
      if (lookahead == 'f') ADVANCE(1469);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1358);
      if (!aux_sym_command_name_token1_character_set_7(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '+') ADVANCE(522);
      if (lookahead == '-') ADVANCE(1607);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(619);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'b') ADVANCE(559);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'b') ADVANCE(620);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == 'b') ADVANCE(602);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(1609);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(618);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(1609);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(600);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(1609);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1365);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < '$' || '/' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '@' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(1512);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '-') ADVANCE(411);
      if (!aux_sym_command_name_token1_character_set_3(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1497);
      if (lookahead == 'o') ADVANCE(1291);
      if (lookahead == 'y') ADVANCE(1463);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1497);
      if (lookahead == 'o') ADVANCE(1291);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1487);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1470);
      if (lookahead == 'y') ADVANCE(1314);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1320);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1448);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1453);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1436);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1479);
      if (lookahead == 'r') ADVANCE(1468);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1479);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1452);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1390);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1449);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1446);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1381:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1392);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1382:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1500);
      if (lookahead == 'l') ADVANCE(1369);
      if (lookahead == 'o') ADVANCE(1460);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1383:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1482);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1384:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1483);
      if (lookahead == 'r') ADVANCE(1468);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1385:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'a') ADVANCE(1483);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1386:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'b') ADVANCE(596);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1387:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'b') ADVANCE(632);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1388:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'b') ADVANCE(614);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1389:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1418);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1390:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1419);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1391:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1472);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1392:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1420);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1393:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1421);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1394:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1481);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1395:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1402);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1396:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1413);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1397:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'c') ADVANCE(1499);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1398:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'd') ADVANCE(1260);
      if (lookahead == 'u') ADVANCE(1451);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1399:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1473);
      if (lookahead == 'w') ADVANCE(1432);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1400:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1289);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1401:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1302);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1402:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1326);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1403:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1417);
      if (lookahead == 'r') ADVANCE(1407);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1404:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1269);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1405:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1270);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1406:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1494);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1407:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1374);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1408:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1489);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1409:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1437);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1410:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1461);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1411:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1477);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1412:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1381);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1413:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'e') ADVANCE(1488);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1414:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'f') ADVANCE(1265);
      if (lookahead == 'n') ADVANCE(1440);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1415:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'f') ADVANCE(1267);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1416:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'f') ADVANCE(1447);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1417:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'g') ADVANCE(1434);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1418:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'h') ADVANCE(1272);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1419:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'h') ADVANCE(1281);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1420:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'h') ADVANCE(1366);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1421:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'h') ADVANCE(1316);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1422:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'h') ADVANCE(1429);
      if (lookahead == 'o') ADVANCE(1476);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1423:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'h') ADVANCE(1475);
      if (lookahead == 'r') ADVANCE(1370);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1424:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1443);
      if (lookahead == 'o') ADVANCE(1474);
      if (lookahead == 'u') ADVANCE(1455);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1425:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1442);
      if (lookahead == 'o') ADVANCE(1474);
      if (lookahead == 'u') ADVANCE(1455);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1426:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1467);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1427:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1471);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1428:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1462);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1429:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1441);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1430:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1464);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1431:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1492);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1432:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1495);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1433:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1391);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1434:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'i') ADVANCE(1459);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1435:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'k') ADVANCE(1416);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1436:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'k') ADVANCE(1300);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1437:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1324);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1438:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1507);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1439:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1369);
      if (lookahead == 'o') ADVANCE(1460);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1440:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1428);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1441:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1400);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1442:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1496);
      if (lookahead == 'n') ADVANCE(1380);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1443:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1496);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1444:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1490);
      if (lookahead == 'n') ADVANCE(1501);
      if (lookahead == 'x') ADVANCE(1431);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1445:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1409);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1446:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1438);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1447:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1466);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1448:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1445);
      if (lookahead == 'm') ADVANCE(1247);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1449:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1445);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1450:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'l') ADVANCE(1491);
      if (lookahead == 'n') ADVANCE(1501);
      if (lookahead == 'x') ADVANCE(1431);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1451:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'm') ADVANCE(1633);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1452:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'm') ADVANCE(1254);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1453:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'm') ADVANCE(1433);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1454:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1501);
      if (lookahead == 'x') ADVANCE(1431);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1455:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1397);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1456:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1306);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1457:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1294);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1458:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1398);
      if (lookahead == 'x') ADVANCE(1431);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1459:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1256);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1460:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1498);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1461:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1395);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1462:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1408);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1463:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1373);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1464:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'n') ADVANCE(1504);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1465:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'o') ADVANCE(1505);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1466:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'o') ADVANCE(1506);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1467:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'o') ADVANCE(1457);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1468:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'o') ADVANCE(1396);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1469:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'o') ADVANCE(1484);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1470:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'p') ADVANCE(1312);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1471:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'p') ADVANCE(1493);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1472:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'p') ADVANCE(1383);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1473:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'q') ADVANCE(1502);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1474:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1283);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1475:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1465);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1476:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1435);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1477:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1296);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1478:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1407);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1479:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1372);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1480:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1456);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1481:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1427);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1482:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1377);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1483:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1379);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1484:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'r') ADVANCE(1412);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1485:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1631);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1486:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1258);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1487:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1485);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1488:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1486);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1489:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1394);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1490:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1404);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1491:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 's') ADVANCE(1405);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1492:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1308);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1493:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1322);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1494:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1503);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1495:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1389);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1496:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1411);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1497:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1371);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1498:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1430);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1499:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1426);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1500:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 't') ADVANCE(1393);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1501:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'u') ADVANCE(1451);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1502:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'u') ADVANCE(1410);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1503:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'u') ADVANCE(1480);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1504:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'u') ADVANCE(1401);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1505:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'w') ADVANCE(1304);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1506:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'w') ADVANCE(1298);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1507:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == 'y') ADVANCE(1318);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1508:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(627);
      if (!aux_sym_command_name_token1_character_set_3(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1509:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(622);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1510:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(605);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1511:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1309);
      if (!aux_sym_command_name_token1_character_set_4(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1512:
      ACCEPT_TOKEN(aux_sym_command_name_token1);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1513:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '\'') ADVANCE(3);
      if (lookahead == '(') ADVANCE(1672);
      if (lookahead == '?') ADVANCE(1583);
      if (lookahead == 'g') ADVANCE(1549);
      if (lookahead == 'l') ADVANCE(1555);
      if (lookahead == 'p') ADVANCE(1557);
      if (lookahead == 's') ADVANCE(1540);
      if (lookahead == 'u') ADVANCE(1560);
      if (lookahead == 'w') ADVANCE(1554);
      if (lookahead == '{') ADVANCE(1673);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1583);
      END_STATE();
    case 1514:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '#') ADVANCE(1577);
      if (lookahead == '$') ADVANCE(1520);
      if (lookahead == '*') ADVANCE(1567);
      if (lookahead == '-') ADVANCE(1524);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '0') ADVANCE(1533);
      if (lookahead == '1') ADVANCE(1527);
      if (lookahead == '2') ADVANCE(1528);
      if (lookahead == '3') ADVANCE(1529);
      if (lookahead == '4') ADVANCE(1530);
      if (lookahead == '5') ADVANCE(1531);
      if (lookahead == '6') ADVANCE(1532);
      if (lookahead == ':') ADVANCE(1617);
      if (lookahead == '<') ADVANCE(814);
      if (lookahead == '>') ADVANCE(772);
      if (lookahead == '@') ADVANCE(1513);
      if (lookahead == '[') ADVANCE(762);
      if (lookahead == '`') ADVANCE(1583);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1514);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1515:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '#') ADVANCE(1577);
      if (lookahead == '$') ADVANCE(1520);
      if (lookahead == '*') ADVANCE(1567);
      if (lookahead == '-') ADVANCE(1526);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '0') ADVANCE(1533);
      if (lookahead == '1') ADVANCE(1527);
      if (lookahead == '2') ADVANCE(1528);
      if (lookahead == '3') ADVANCE(1529);
      if (lookahead == '4') ADVANCE(1530);
      if (lookahead == '5') ADVANCE(1531);
      if (lookahead == '6') ADVANCE(1532);
      if (lookahead == ':') ADVANCE(1617);
      if (lookahead == '<') ADVANCE(814);
      if (lookahead == '>') ADVANCE(772);
      if (lookahead == '@') ADVANCE(1513);
      if (lookahead == '[') ADVANCE(762);
      if (lookahead == '`') ADVANCE(1583);
      if (('7' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1515);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1516:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '#') ADVANCE(1577);
      if (lookahead == '<') ADVANCE(1517);
      if (lookahead == '`') ADVANCE(1583);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1516);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1517:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '#') ADVANCE(1519);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1518:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '#') ADVANCE(1518);
      if (lookahead == '>') ADVANCE(1583);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == ';' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(112);
      if (lookahead != 0) ADVANCE(1519);
      END_STATE();
    case 1519:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '#') ADVANCE(1518);
      if (lookahead == '`') ADVANCE(1579);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == ';' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(112);
      if (lookahead != 0) ADVANCE(1519);
      END_STATE();
    case 1520:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '$') ADVANCE(895);
      if (lookahead == '(') ADVANCE(1671);
      if (lookahead == '?') ADVANCE(903);
      if (lookahead == '^') ADVANCE(899);
      if (lookahead == '_') ADVANCE(907);
      if (lookahead == 'g') ADVANCE(1549);
      if (lookahead == 'l') ADVANCE(1555);
      if (lookahead == 'p') ADVANCE(1557);
      if (lookahead == 's') ADVANCE(1540);
      if (lookahead == 'u') ADVANCE(1560);
      if (lookahead == 'w') ADVANCE(1554);
      if (lookahead == '{') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_3(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1521:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '%') ADVANCE(1624);
      if (lookahead == '-') ADVANCE(1525);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1581);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1522:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '%') ADVANCE(1578);
      if (lookahead == '-') ADVANCE(1525);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1581);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1523:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '&') ADVANCE(136);
      if (!aux_sym_command_name_token2_character_set_2(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1524:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '-') ADVANCE(1521);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1581);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1525:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '-') ADVANCE(1525);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1581);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1526:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '-') ADVANCE(1522);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1581);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1527:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '>') ADVANCE(1523);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1528:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '>') ADVANCE(778);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1529:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '>') ADVANCE(784);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1530:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '>') ADVANCE(790);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1531:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '>') ADVANCE(796);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1532:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1533:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (lookahead == 'x') ADVANCE(1580);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1534:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '.') ADVANCE(1575);
      if (lookahead == 'd' ||
          lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1534);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1535:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == '?') ADVANCE(1583);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1582);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1536:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'a') ADVANCE(1561);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1537:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'a') ADVANCE(1548);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1538:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'b') ADVANCE(1537);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1539:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'c') ADVANCE(1537);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1540:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'c') ADVANCE(1559);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1541:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'e') ADVANCE(1566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1542:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'f') ADVANCE(1550);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1543:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'g') ADVANCE(1566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1544:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'i') ADVANCE(1563);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1545:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'i') ADVANCE(1551);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1546:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'i') ADVANCE(1556);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1547:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'k') ADVANCE(1542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1548:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'l') ADVANCE(1566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1549:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'l') ADVANCE(1552);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1550:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'l') ADVANCE(1553);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1551:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'n') ADVANCE(1543);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1552:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'o') ADVANCE(1538);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1553:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'o') ADVANCE(1564);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1554:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'o') ADVANCE(1558);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1555:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'o') ADVANCE(1539);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1556:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'p') ADVANCE(1562);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1557:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'r') ADVANCE(1544);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1558:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'r') ADVANCE(1547);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1559:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'r') ADVANCE(1546);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1560:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 's') ADVANCE(1545);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1561:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 't') ADVANCE(1541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1562:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 't') ADVANCE(1566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1563:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'v') ADVANCE(1536);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1564:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (lookahead == 'w') ADVANCE(1566);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1565:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1568);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1566:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == ':') ADVANCE(1535);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1565);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1567:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '>') ADVANCE(808);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1568:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '?') ADVANCE(1583);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1582);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1569:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == 'b') ADVANCE(1583);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1570:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1571:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'l') ADVANCE(1573);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1571);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1572:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1572);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1573:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == 'g') ADVANCE(1569);
      if (lookahead == 'k') ADVANCE(1569);
      if (lookahead == 'm') ADVANCE(1569);
      if (lookahead == 'p') ADVANCE(1569);
      if (lookahead == 't') ADVANCE(1569);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1574:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1576);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1572);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1575:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1570);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1576:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1572);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1577:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == ';' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(554);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1577);
      END_STATE();
    case 1578:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == ';' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(1610);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1578);
      END_STATE();
    case 1579:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == ';' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(112);
      if (lookahead != 0) ADVANCE(1519);
      END_STATE();
    case 1580:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1571);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1581:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1581);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1582:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1582);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1583:
      ACCEPT_TOKEN(aux_sym_command_name_token2);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1584:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 1585:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      if (lookahead == '"') ADVANCE(684);
      END_STATE();
    case 1586:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      if (lookahead == '"') ADVANCE(684);
      if (lookahead == '#') ADVANCE(635);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(635);
      END_STATE();
    case 1587:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      END_STATE();
    case 1588:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE);
      if (lookahead == '\'') ADVANCE(120);
      END_STATE();
    case 1589:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '%') ADVANCE(1622);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1590:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '+') ADVANCE(522);
      if (lookahead == '-') ADVANCE(1607);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(628);
      if (lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1591:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-') ADVANCE(1667);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1592:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1593:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-') ADVANCE(1670);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1594:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-') ADVANCE(1589);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1595:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-') ADVANCE(1669);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1596:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-') ADVANCE(1216);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1597:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'a') ADVANCE(1601);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1598:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'b') ADVANCE(595);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1599:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'b') ADVANCE(631);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1600:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'b') ADVANCE(613);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1601:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'c') ADVANCE(1603);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1602:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'e') ADVANCE(1597);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1603:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'h') ADVANCE(1685);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1604:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'o') ADVANCE(1605);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1605:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == 'r') ADVANCE(1602);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1606:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(623);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1607:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(628);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1608:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(607);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1609:
      ACCEPT_TOKEN(sym_path_command_name_token);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1610:
      ACCEPT_TOKEN(sym_stop_parsing);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1610);
      END_STATE();
    case 1611:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == ' ') ADVANCE(1611);
      END_STATE();
    case 1612:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == ' ') ADVANCE(1612);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1144);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1144);
      END_STATE();
    case 1613:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == ' ') ADVANCE(1613);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1145);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1145);
      END_STATE();
    case 1614:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == ' ') ADVANCE(1614);
      if (lookahead == '`') ADVANCE(1189);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') ADVANCE(1146);
      if (lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(1146);
      END_STATE();
    case 1615:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 1616:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(1682);
      END_STATE();
    case 1617:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!aux_sym_command_name_token2_character_set_1(lookahead)) ADVANCE(1583);
      END_STATE();
    case 1618:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1619:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 1620:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(770);
      END_STATE();
    case 1621:
      ACCEPT_TOKEN(anon_sym_foreach_DASHobject);
      END_STATE();
    case 1622:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_PERCENT);
      END_STATE();
    case 1623:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_PERCENT);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '}') ADVANCE(1610);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1182);
      END_STATE();
    case 1624:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_PERCENT);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == ';' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(1610);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1578);
      END_STATE();
    case 1625:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_PERCENT);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1610);
      END_STATE();
    case 1626:
      ACCEPT_TOKEN(anon_sym_hidden);
      END_STATE();
    case 1627:
      ACCEPT_TOKEN(anon_sym_hidden);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 1628:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 1629:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(755);
      END_STATE();
    case 1630:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 1631:
      ACCEPT_TOKEN(anon_sym_class);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1632:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 1633:
      ACCEPT_TOKEN(anon_sym_enum);
      if (!aux_sym_command_name_token1_character_set_2(lookahead)) ADVANCE(1512);
      END_STATE();
    case 1634:
      ACCEPT_TOKEN(anon_sym_DASHand);
      END_STATE();
    case 1635:
      ACCEPT_TOKEN(anon_sym_DASHor);
      END_STATE();
    case 1636:
      ACCEPT_TOKEN(anon_sym_DASHxor);
      END_STATE();
    case 1637:
      ACCEPT_TOKEN(anon_sym_DASHband);
      END_STATE();
    case 1638:
      ACCEPT_TOKEN(anon_sym_DASHbor);
      END_STATE();
    case 1639:
      ACCEPT_TOKEN(anon_sym_DASHbxor);
      END_STATE();
    case 1640:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(1663);
      END_STATE();
    case 1641:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(1663);
      if (lookahead == '=') ADVANCE(767);
      END_STATE();
    case 1642:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(767);
      END_STATE();
    case 1643:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1665);
      if (lookahead == 'a') ADVANCE(383);
      if (lookahead == 'b') ADVANCE(167);
      if (lookahead == 'c') ADVANCE(174);
      if (lookahead == 'e') ADVANCE(437);
      if (lookahead == 'f') ADVANCE(893);
      if (lookahead == 'g') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 'j') ADVANCE(413);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(193);
      if (lookahead == 'n') ADVANCE(246);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'p') ADVANCE(176);
      if (lookahead == 'r') ADVANCE(248);
      if (lookahead == 's') ADVANCE(294);
      if (lookahead == 'w') ADVANCE(313);
      if (lookahead == 'x') ADVANCE(414);
      END_STATE();
    case 1644:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1664);
      if (lookahead == 'a') ADVANCE(383);
      if (lookahead == 'b') ADVANCE(167);
      if (lookahead == 'c') ADVANCE(208);
      if (lookahead == 'e') ADVANCE(436);
      if (lookahead == 'f') ADVANCE(892);
      if (lookahead == 'g') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 'j') ADVANCE(413);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(193);
      if (lookahead == 'n') ADVANCE(246);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'r') ADVANCE(285);
      if (lookahead == 's') ADVANCE(293);
      if (lookahead == 'x') ADVANCE(414);
      END_STATE();
    case 1645:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1664);
      if (lookahead == 'a') ADVANCE(383);
      if (lookahead == 'b') ADVANCE(168);
      if (lookahead == 'c') ADVANCE(208);
      if (lookahead == 'e') ADVANCE(436);
      if (lookahead == 'f') ADVANCE(892);
      if (lookahead == 'g') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 'j') ADVANCE(413);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(193);
      if (lookahead == 'n') ADVANCE(247);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'r') ADVANCE(285);
      if (lookahead == 's') ADVANCE(293);
      if (lookahead == 'x') ADVANCE(414);
      END_STATE();
    case 1646:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1664);
      if (lookahead == 'b') ADVANCE(385);
      if (lookahead == 'j') ADVANCE(413);
      if (lookahead == 'n') ADVANCE(421);
      if (lookahead == 's') ADVANCE(428);
      END_STATE();
    case 1647:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1666);
      if (lookahead == 'b') ADVANCE(1224);
      if (lookahead == 'j') ADVANCE(1225);
      if (lookahead == 'n') ADVANCE(1226);
      if (lookahead == 's') ADVANCE(1228);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1648:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(1668);
      if (lookahead == 'b') ADVANCE(1224);
      if (lookahead == 'j') ADVANCE(1225);
      if (lookahead == 'n') ADVANCE(1226);
      if (lookahead == 's') ADVANCE(1228);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1649:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == 'a') ADVANCE(383);
      if (lookahead == 'b') ADVANCE(168);
      if (lookahead == 'c') ADVANCE(208);
      if (lookahead == 'e') ADVANCE(436);
      if (lookahead == 'f') ADVANCE(892);
      if (lookahead == 'g') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(227);
      if (lookahead == 'j') ADVANCE(413);
      if (lookahead == 'l') ADVANCE(245);
      if (lookahead == 'm') ADVANCE(193);
      if (lookahead == 'n') ADVANCE(247);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 'r') ADVANCE(285);
      if (lookahead == 's') ADVANCE(293);
      if (lookahead == 'x') ADVANCE(414);
      END_STATE();
    case 1650:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 1651:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(769);
      END_STATE();
    case 1652:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 1653:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 1654:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(768);
      if (lookahead == '>') ADVANCE(807);
      END_STATE();
    case 1655:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 1656:
      ACCEPT_TOKEN(anon_sym_DASHnot);
      END_STATE();
    case 1657:
      ACCEPT_TOKEN(anon_sym_DASHnot);
      if (lookahead == 'c') ADVANCE(424);
      if (lookahead == 'i') ADVANCE(379);
      if (lookahead == 'l') ADVANCE(333);
      if (lookahead == 'm') ADVANCE(196);
      END_STATE();
    case 1658:
      ACCEPT_TOKEN(anon_sym_DASHnot);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1659:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 1660:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(766);
      END_STATE();
    case 1661:
      ACCEPT_TOKEN(anon_sym_DASHbnot);
      END_STATE();
    case 1662:
      ACCEPT_TOKEN(anon_sym_DASHbnot);
      if (lookahead == '-' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1663:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 1664:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 1665:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '%') ADVANCE(1625);
      END_STATE();
    case 1666:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '%') ADVANCE(1625);
      if (lookahead == '-') ADVANCE(1217);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1667:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '%') ADVANCE(1625);
      if (lookahead == '-') ADVANCE(1218);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1668:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '%') ADVANCE(1610);
      if (lookahead == '-') ADVANCE(1217);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1232);
      END_STATE();
    case 1669:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '%') ADVANCE(1610);
      if (lookahead == '-') ADVANCE(1218);
      if (lookahead == '`') ADVANCE(1232);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '\\') ADVANCE(1609);
      if (lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(1219);
      END_STATE();
    case 1670:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1671:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 1672:
      ACCEPT_TOKEN(anon_sym_AT_LPAREN);
      END_STATE();
    case 1673:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      END_STATE();
    case 1674:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(1189);
      END_STATE();
    case 1675:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == '.') ADVANCE(1655);
      if (lookahead == 'f') ADVANCE(419);
      END_STATE();
    case 1676:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == '.') ADVANCE(1655);
      if (lookahead == 'f') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 1677:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == 'f') ADVANCE(1604);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(623);
      if (lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1678:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == 'f') ADVANCE(1604);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    case 1679:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == 'f') ADVANCE(419);
      END_STATE();
    case 1680:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == 'f') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 1681:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(621);
      END_STATE();
    case 1682:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 1683:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 1684:
      ACCEPT_TOKEN(anon_sym_DOTforeach);
      END_STATE();
    case 1685:
      ACCEPT_TOKEN(anon_sym_DOTforeach);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '\\' ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1609);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 85},
  [2] = {.lex_state = 535, .external_lex_state = 1},
  [3] = {.lex_state = 535, .external_lex_state = 1},
  [4] = {.lex_state = 535},
  [5] = {.lex_state = 535},
  [6] = {.lex_state = 535, .external_lex_state = 1},
  [7] = {.lex_state = 86},
  [8] = {.lex_state = 86},
  [9] = {.lex_state = 86},
  [10] = {.lex_state = 86},
  [11] = {.lex_state = 86},
  [12] = {.lex_state = 86},
  [13] = {.lex_state = 86, .external_lex_state = 1},
  [14] = {.lex_state = 86, .external_lex_state = 1},
  [15] = {.lex_state = 86, .external_lex_state = 1},
  [16] = {.lex_state = 86},
  [17] = {.lex_state = 86, .external_lex_state = 1},
  [18] = {.lex_state = 86},
  [19] = {.lex_state = 86, .external_lex_state = 1},
  [20] = {.lex_state = 86},
  [21] = {.lex_state = 86},
  [22] = {.lex_state = 86, .external_lex_state = 1},
  [23] = {.lex_state = 86, .external_lex_state = 1},
  [24] = {.lex_state = 86, .external_lex_state = 1},
  [25] = {.lex_state = 86},
  [26] = {.lex_state = 86},
  [27] = {.lex_state = 86, .external_lex_state = 1},
  [28] = {.lex_state = 86, .external_lex_state = 1},
  [29] = {.lex_state = 86},
  [30] = {.lex_state = 86},
  [31] = {.lex_state = 86},
  [32] = {.lex_state = 86},
  [33] = {.lex_state = 86},
  [34] = {.lex_state = 86},
  [35] = {.lex_state = 86},
  [36] = {.lex_state = 86},
  [37] = {.lex_state = 86},
  [38] = {.lex_state = 86},
  [39] = {.lex_state = 86},
  [40] = {.lex_state = 87},
  [41] = {.lex_state = 87},
  [42] = {.lex_state = 535, .external_lex_state = 1},
  [43] = {.lex_state = 535},
  [44] = {.lex_state = 537},
  [45] = {.lex_state = 537},
  [46] = {.lex_state = 537},
  [47] = {.lex_state = 537},
  [48] = {.lex_state = 537},
  [49] = {.lex_state = 537},
  [50] = {.lex_state = 537},
  [51] = {.lex_state = 537},
  [52] = {.lex_state = 537},
  [53] = {.lex_state = 537},
  [54] = {.lex_state = 537},
  [55] = {.lex_state = 537},
  [56] = {.lex_state = 537},
  [57] = {.lex_state = 537},
  [58] = {.lex_state = 537},
  [59] = {.lex_state = 537},
  [60] = {.lex_state = 537},
  [61] = {.lex_state = 537},
  [62] = {.lex_state = 537},
  [63] = {.lex_state = 537},
  [64] = {.lex_state = 537},
  [65] = {.lex_state = 537},
  [66] = {.lex_state = 537},
  [67] = {.lex_state = 537},
  [68] = {.lex_state = 537},
  [69] = {.lex_state = 537},
  [70] = {.lex_state = 537},
  [71] = {.lex_state = 537},
  [72] = {.lex_state = 537},
  [73] = {.lex_state = 537},
  [74] = {.lex_state = 537},
  [75] = {.lex_state = 537},
  [76] = {.lex_state = 78},
  [77] = {.lex_state = 78},
  [78] = {.lex_state = 537},
  [79] = {.lex_state = 78, .external_lex_state = 1},
  [80] = {.lex_state = 78, .external_lex_state = 1},
  [81] = {.lex_state = 537},
  [82] = {.lex_state = 537},
  [83] = {.lex_state = 88},
  [84] = {.lex_state = 88},
  [85] = {.lex_state = 88},
  [86] = {.lex_state = 88},
  [87] = {.lex_state = 88},
  [88] = {.lex_state = 88},
  [89] = {.lex_state = 88},
  [90] = {.lex_state = 88},
  [91] = {.lex_state = 88},
  [92] = {.lex_state = 88},
  [93] = {.lex_state = 88},
  [94] = {.lex_state = 88},
  [95] = {.lex_state = 88},
  [96] = {.lex_state = 88, .external_lex_state = 1},
  [97] = {.lex_state = 88},
  [98] = {.lex_state = 88},
  [99] = {.lex_state = 88},
  [100] = {.lex_state = 88},
  [101] = {.lex_state = 88},
  [102] = {.lex_state = 88},
  [103] = {.lex_state = 88},
  [104] = {.lex_state = 88},
  [105] = {.lex_state = 88},
  [106] = {.lex_state = 88},
  [107] = {.lex_state = 88},
  [108] = {.lex_state = 88},
  [109] = {.lex_state = 88},
  [110] = {.lex_state = 88},
  [111] = {.lex_state = 88},
  [112] = {.lex_state = 88, .external_lex_state = 1},
  [113] = {.lex_state = 88},
  [114] = {.lex_state = 88},
  [115] = {.lex_state = 88},
  [116] = {.lex_state = 88},
  [117] = {.lex_state = 88, .external_lex_state = 1},
  [118] = {.lex_state = 88},
  [119] = {.lex_state = 88},
  [120] = {.lex_state = 88, .external_lex_state = 1},
  [121] = {.lex_state = 88},
  [122] = {.lex_state = 88, .external_lex_state = 1},
  [123] = {.lex_state = 88, .external_lex_state = 1},
  [124] = {.lex_state = 88, .external_lex_state = 1},
  [125] = {.lex_state = 88, .external_lex_state = 1},
  [126] = {.lex_state = 88, .external_lex_state = 1},
  [127] = {.lex_state = 88, .external_lex_state = 1},
  [128] = {.lex_state = 88, .external_lex_state = 1},
  [129] = {.lex_state = 88, .external_lex_state = 1},
  [130] = {.lex_state = 88, .external_lex_state = 1},
  [131] = {.lex_state = 88, .external_lex_state = 1},
  [132] = {.lex_state = 88, .external_lex_state = 1},
  [133] = {.lex_state = 88, .external_lex_state = 1},
  [134] = {.lex_state = 88, .external_lex_state = 1},
  [135] = {.lex_state = 88, .external_lex_state = 1},
  [136] = {.lex_state = 88, .external_lex_state = 1},
  [137] = {.lex_state = 88},
  [138] = {.lex_state = 88, .external_lex_state = 1},
  [139] = {.lex_state = 88, .external_lex_state = 1},
  [140] = {.lex_state = 88, .external_lex_state = 1},
  [141] = {.lex_state = 88, .external_lex_state = 1},
  [142] = {.lex_state = 88, .external_lex_state = 1},
  [143] = {.lex_state = 88, .external_lex_state = 1},
  [144] = {.lex_state = 88, .external_lex_state = 1},
  [145] = {.lex_state = 88, .external_lex_state = 1},
  [146] = {.lex_state = 88, .external_lex_state = 1},
  [147] = {.lex_state = 88, .external_lex_state = 1},
  [148] = {.lex_state = 88, .external_lex_state = 1},
  [149] = {.lex_state = 88, .external_lex_state = 1},
  [150] = {.lex_state = 88, .external_lex_state = 1},
  [151] = {.lex_state = 88, .external_lex_state = 1},
  [152] = {.lex_state = 88, .external_lex_state = 1},
  [153] = {.lex_state = 88, .external_lex_state = 1},
  [154] = {.lex_state = 88, .external_lex_state = 1},
  [155] = {.lex_state = 88},
  [156] = {.lex_state = 88, .external_lex_state = 1},
  [157] = {.lex_state = 90},
  [158] = {.lex_state = 90},
  [159] = {.lex_state = 90},
  [160] = {.lex_state = 90},
  [161] = {.lex_state = 90},
  [162] = {.lex_state = 90},
  [163] = {.lex_state = 90},
  [164] = {.lex_state = 90},
  [165] = {.lex_state = 90, .external_lex_state = 1},
  [166] = {.lex_state = 90, .external_lex_state = 1},
  [167] = {.lex_state = 90, .external_lex_state = 1},
  [168] = {.lex_state = 90, .external_lex_state = 1},
  [169] = {.lex_state = 90},
  [170] = {.lex_state = 90},
  [171] = {.lex_state = 90, .external_lex_state = 1},
  [172] = {.lex_state = 90, .external_lex_state = 1},
  [173] = {.lex_state = 90, .external_lex_state = 1},
  [174] = {.lex_state = 90, .external_lex_state = 1},
  [175] = {.lex_state = 90, .external_lex_state = 1},
  [176] = {.lex_state = 90, .external_lex_state = 1},
  [177] = {.lex_state = 90},
  [178] = {.lex_state = 90, .external_lex_state = 1},
  [179] = {.lex_state = 90},
  [180] = {.lex_state = 90, .external_lex_state = 1},
  [181] = {.lex_state = 90},
  [182] = {.lex_state = 90, .external_lex_state = 1},
  [183] = {.lex_state = 90},
  [184] = {.lex_state = 90, .external_lex_state = 1},
  [185] = {.lex_state = 90},
  [186] = {.lex_state = 90, .external_lex_state = 1},
  [187] = {.lex_state = 90, .external_lex_state = 1},
  [188] = {.lex_state = 90},
  [189] = {.lex_state = 78},
  [190] = {.lex_state = 78, .external_lex_state = 1},
  [191] = {.lex_state = 90, .external_lex_state = 1},
  [192] = {.lex_state = 90},
  [193] = {.lex_state = 90},
  [194] = {.lex_state = 90, .external_lex_state = 1},
  [195] = {.lex_state = 535, .external_lex_state = 1},
  [196] = {.lex_state = 55},
  [197] = {.lex_state = 55, .external_lex_state = 1},
  [198] = {.lex_state = 535},
  [199] = {.lex_state = 535, .external_lex_state = 1},
  [200] = {.lex_state = 535},
  [201] = {.lex_state = 57, .external_lex_state = 1},
  [202] = {.lex_state = 57},
  [203] = {.lex_state = 81},
  [204] = {.lex_state = 81, .external_lex_state = 1},
  [205] = {.lex_state = 66},
  [206] = {.lex_state = 66, .external_lex_state = 1},
  [207] = {.lex_state = 66},
  [208] = {.lex_state = 66, .external_lex_state = 1},
  [209] = {.lex_state = 69},
  [210] = {.lex_state = 69, .external_lex_state = 1},
  [211] = {.lex_state = 66},
  [212] = {.lex_state = 66, .external_lex_state = 1},
  [213] = {.lex_state = 69, .external_lex_state = 1},
  [214] = {.lex_state = 66},
  [215] = {.lex_state = 66, .external_lex_state = 1},
  [216] = {.lex_state = 69},
  [217] = {.lex_state = 69},
  [218] = {.lex_state = 69, .external_lex_state = 1},
  [219] = {.lex_state = 69, .external_lex_state = 1},
  [220] = {.lex_state = 69},
  [221] = {.lex_state = 13},
  [222] = {.lex_state = 13},
  [223] = {.lex_state = 13},
  [224] = {.lex_state = 13},
  [225] = {.lex_state = 13},
  [226] = {.lex_state = 13},
  [227] = {.lex_state = 13},
  [228] = {.lex_state = 13},
  [229] = {.lex_state = 13},
  [230] = {.lex_state = 13},
  [231] = {.lex_state = 13},
  [232] = {.lex_state = 13},
  [233] = {.lex_state = 84},
  [234] = {.lex_state = 84},
  [235] = {.lex_state = 84},
  [236] = {.lex_state = 84},
  [237] = {.lex_state = 84},
  [238] = {.lex_state = 84},
  [239] = {.lex_state = 84},
  [240] = {.lex_state = 84},
  [241] = {.lex_state = 84},
  [242] = {.lex_state = 84},
  [243] = {.lex_state = 84},
  [244] = {.lex_state = 84},
  [245] = {.lex_state = 84},
  [246] = {.lex_state = 84},
  [247] = {.lex_state = 84},
  [248] = {.lex_state = 84},
  [249] = {.lex_state = 84},
  [250] = {.lex_state = 84},
  [251] = {.lex_state = 84},
  [252] = {.lex_state = 84},
  [253] = {.lex_state = 84},
  [254] = {.lex_state = 84, .external_lex_state = 1},
  [255] = {.lex_state = 84},
  [256] = {.lex_state = 84},
  [257] = {.lex_state = 84},
  [258] = {.lex_state = 84},
  [259] = {.lex_state = 84},
  [260] = {.lex_state = 84},
  [261] = {.lex_state = 84},
  [262] = {.lex_state = 84},
  [263] = {.lex_state = 84},
  [264] = {.lex_state = 84},
  [265] = {.lex_state = 84},
  [266] = {.lex_state = 84},
  [267] = {.lex_state = 84},
  [268] = {.lex_state = 84},
  [269] = {.lex_state = 84},
  [270] = {.lex_state = 84},
  [271] = {.lex_state = 84},
  [272] = {.lex_state = 84},
  [273] = {.lex_state = 84},
  [274] = {.lex_state = 84},
  [275] = {.lex_state = 84},
  [276] = {.lex_state = 84},
  [277] = {.lex_state = 84},
  [278] = {.lex_state = 84},
  [279] = {.lex_state = 84},
  [280] = {.lex_state = 84},
  [281] = {.lex_state = 84},
  [282] = {.lex_state = 84},
  [283] = {.lex_state = 88},
  [284] = {.lex_state = 88},
  [285] = {.lex_state = 88, .external_lex_state = 1},
  [286] = {.lex_state = 88, .external_lex_state = 1},
  [287] = {.lex_state = 78},
  [288] = {.lex_state = 78},
  [289] = {.lex_state = 55},
  [290] = {.lex_state = 538},
  [291] = {.lex_state = 539},
  [292] = {.lex_state = 55, .external_lex_state = 1},
  [293] = {.lex_state = 90},
  [294] = {.lex_state = 90, .external_lex_state = 1},
  [295] = {.lex_state = 57},
  [296] = {.lex_state = 539},
  [297] = {.lex_state = 90},
  [298] = {.lex_state = 90, .external_lex_state = 1},
  [299] = {.lex_state = 538},
  [300] = {.lex_state = 90},
  [301] = {.lex_state = 90},
  [302] = {.lex_state = 90},
  [303] = {.lex_state = 78},
  [304] = {.lex_state = 57, .external_lex_state = 1},
  [305] = {.lex_state = 90},
  [306] = {.lex_state = 78},
  [307] = {.lex_state = 90, .external_lex_state = 1},
  [308] = {.lex_state = 86, .external_lex_state = 1},
  [309] = {.lex_state = 78},
  [310] = {.lex_state = 78},
  [311] = {.lex_state = 86, .external_lex_state = 1},
  [312] = {.lex_state = 78},
  [313] = {.lex_state = 539},
  [314] = {.lex_state = 90},
  [315] = {.lex_state = 90},
  [316] = {.lex_state = 87},
  [317] = {.lex_state = 90, .external_lex_state = 1},
  [318] = {.lex_state = 86, .external_lex_state = 1},
  [319] = {.lex_state = 538},
  [320] = {.lex_state = 90},
  [321] = {.lex_state = 538},
  [322] = {.lex_state = 539},
  [323] = {.lex_state = 90},
  [324] = {.lex_state = 78},
  [325] = {.lex_state = 78},
  [326] = {.lex_state = 78},
  [327] = {.lex_state = 87},
  [328] = {.lex_state = 78},
  [329] = {.lex_state = 538},
  [330] = {.lex_state = 78},
  [331] = {.lex_state = 539},
  [332] = {.lex_state = 90},
  [333] = {.lex_state = 78},
  [334] = {.lex_state = 90},
  [335] = {.lex_state = 78},
  [336] = {.lex_state = 78},
  [337] = {.lex_state = 78},
  [338] = {.lex_state = 90},
  [339] = {.lex_state = 90},
  [340] = {.lex_state = 78},
  [341] = {.lex_state = 78},
  [342] = {.lex_state = 538},
  [343] = {.lex_state = 90, .external_lex_state = 1},
  [344] = {.lex_state = 539},
  [345] = {.lex_state = 78},
  [346] = {.lex_state = 78},
  [347] = {.lex_state = 90, .external_lex_state = 1},
  [348] = {.lex_state = 78},
  [349] = {.lex_state = 539},
  [350] = {.lex_state = 538},
  [351] = {.lex_state = 90, .external_lex_state = 1},
  [352] = {.lex_state = 538},
  [353] = {.lex_state = 538},
  [354] = {.lex_state = 539},
  [355] = {.lex_state = 90},
  [356] = {.lex_state = 90},
  [357] = {.lex_state = 90},
  [358] = {.lex_state = 90},
  [359] = {.lex_state = 540},
  [360] = {.lex_state = 90, .external_lex_state = 1},
  [361] = {.lex_state = 539},
  [362] = {.lex_state = 90},
  [363] = {.lex_state = 539},
  [364] = {.lex_state = 78},
  [365] = {.lex_state = 90},
  [366] = {.lex_state = 541},
  [367] = {.lex_state = 78},
  [368] = {.lex_state = 539},
  [369] = {.lex_state = 90},
  [370] = {.lex_state = 540},
  [371] = {.lex_state = 539},
  [372] = {.lex_state = 78},
  [373] = {.lex_state = 538},
  [374] = {.lex_state = 81},
  [375] = {.lex_state = 78},
  [376] = {.lex_state = 538},
  [377] = {.lex_state = 81, .external_lex_state = 1},
  [378] = {.lex_state = 78},
  [379] = {.lex_state = 541},
  [380] = {.lex_state = 538},
  [381] = {.lex_state = 539},
  [382] = {.lex_state = 78},
  [383] = {.lex_state = 539},
  [384] = {.lex_state = 90},
  [385] = {.lex_state = 537},
  [386] = {.lex_state = 78},
  [387] = {.lex_state = 78},
  [388] = {.lex_state = 537},
  [389] = {.lex_state = 537},
  [390] = {.lex_state = 537},
  [391] = {.lex_state = 537},
  [392] = {.lex_state = 58},
  [393] = {.lex_state = 78},
  [394] = {.lex_state = 58},
  [395] = {.lex_state = 78},
  [396] = {.lex_state = 58, .external_lex_state = 1},
  [397] = {.lex_state = 537},
  [398] = {.lex_state = 78},
  [399] = {.lex_state = 537},
  [400] = {.lex_state = 78},
  [401] = {.lex_state = 537},
  [402] = {.lex_state = 537},
  [403] = {.lex_state = 537},
  [404] = {.lex_state = 78},
  [405] = {.lex_state = 537},
  [406] = {.lex_state = 537},
  [407] = {.lex_state = 61, .external_lex_state = 1},
  [408] = {.lex_state = 78},
  [409] = {.lex_state = 78},
  [410] = {.lex_state = 78},
  [411] = {.lex_state = 537},
  [412] = {.lex_state = 537},
  [413] = {.lex_state = 537},
  [414] = {.lex_state = 78},
  [415] = {.lex_state = 61},
  [416] = {.lex_state = 537},
  [417] = {.lex_state = 78},
  [418] = {.lex_state = 537},
  [419] = {.lex_state = 90},
  [420] = {.lex_state = 537},
  [421] = {.lex_state = 537},
  [422] = {.lex_state = 90},
  [423] = {.lex_state = 537},
  [424] = {.lex_state = 537},
  [425] = {.lex_state = 78},
  [426] = {.lex_state = 537},
  [427] = {.lex_state = 537},
  [428] = {.lex_state = 78},
  [429] = {.lex_state = 537},
  [430] = {.lex_state = 537},
  [431] = {.lex_state = 58, .external_lex_state = 1},
  [432] = {.lex_state = 537},
  [433] = {.lex_state = 537},
  [434] = {.lex_state = 537},
  [435] = {.lex_state = 537},
  [436] = {.lex_state = 537},
  [437] = {.lex_state = 537},
  [438] = {.lex_state = 537},
  [439] = {.lex_state = 537},
  [440] = {.lex_state = 537},
  [441] = {.lex_state = 537},
  [442] = {.lex_state = 537},
  [443] = {.lex_state = 537},
  [444] = {.lex_state = 537},
  [445] = {.lex_state = 537},
  [446] = {.lex_state = 537},
  [447] = {.lex_state = 537},
  [448] = {.lex_state = 537},
  [449] = {.lex_state = 537},
  [450] = {.lex_state = 537},
  [451] = {.lex_state = 537},
  [452] = {.lex_state = 537},
  [453] = {.lex_state = 537},
  [454] = {.lex_state = 537},
  [455] = {.lex_state = 537},
  [456] = {.lex_state = 61, .external_lex_state = 1},
  [457] = {.lex_state = 537},
  [458] = {.lex_state = 64},
  [459] = {.lex_state = 61, .external_lex_state = 1},
  [460] = {.lex_state = 61, .external_lex_state = 1},
  [461] = {.lex_state = 537},
  [462] = {.lex_state = 537},
  [463] = {.lex_state = 63, .external_lex_state = 1},
  [464] = {.lex_state = 537},
  [465] = {.lex_state = 64, .external_lex_state = 1},
  [466] = {.lex_state = 537},
  [467] = {.lex_state = 537},
  [468] = {.lex_state = 537},
  [469] = {.lex_state = 537},
  [470] = {.lex_state = 61, .external_lex_state = 1},
  [471] = {.lex_state = 61},
  [472] = {.lex_state = 90},
  [473] = {.lex_state = 61, .external_lex_state = 1},
  [474] = {.lex_state = 537},
  [475] = {.lex_state = 537},
  [476] = {.lex_state = 78},
  [477] = {.lex_state = 537},
  [478] = {.lex_state = 61, .external_lex_state = 1},
  [479] = {.lex_state = 61, .external_lex_state = 1},
  [480] = {.lex_state = 61, .external_lex_state = 1},
  [481] = {.lex_state = 61},
  [482] = {.lex_state = 61, .external_lex_state = 1},
  [483] = {.lex_state = 61, .external_lex_state = 1},
  [484] = {.lex_state = 537},
  [485] = {.lex_state = 537},
  [486] = {.lex_state = 537},
  [487] = {.lex_state = 537},
  [488] = {.lex_state = 537},
  [489] = {.lex_state = 61, .external_lex_state = 1},
  [490] = {.lex_state = 61, .external_lex_state = 1},
  [491] = {.lex_state = 537},
  [492] = {.lex_state = 537},
  [493] = {.lex_state = 61},
  [494] = {.lex_state = 537},
  [495] = {.lex_state = 61, .external_lex_state = 1},
  [496] = {.lex_state = 63},
  [497] = {.lex_state = 537},
  [498] = {.lex_state = 61, .external_lex_state = 1},
  [499] = {.lex_state = 61, .external_lex_state = 1},
  [500] = {.lex_state = 61},
  [501] = {.lex_state = 61},
  [502] = {.lex_state = 61, .external_lex_state = 1},
  [503] = {.lex_state = 61, .external_lex_state = 1},
  [504] = {.lex_state = 61},
  [505] = {.lex_state = 537},
  [506] = {.lex_state = 61},
  [507] = {.lex_state = 61, .external_lex_state = 1},
  [508] = {.lex_state = 61},
  [509] = {.lex_state = 61},
  [510] = {.lex_state = 537},
  [511] = {.lex_state = 61, .external_lex_state = 1},
  [512] = {.lex_state = 61, .external_lex_state = 1},
  [513] = {.lex_state = 61, .external_lex_state = 1},
  [514] = {.lex_state = 61, .external_lex_state = 1},
  [515] = {.lex_state = 61},
  [516] = {.lex_state = 61, .external_lex_state = 1},
  [517] = {.lex_state = 537},
  [518] = {.lex_state = 537},
  [519] = {.lex_state = 537},
  [520] = {.lex_state = 61},
  [521] = {.lex_state = 537},
  [522] = {.lex_state = 537},
  [523] = {.lex_state = 537},
  [524] = {.lex_state = 61},
  [525] = {.lex_state = 537},
  [526] = {.lex_state = 537},
  [527] = {.lex_state = 537},
  [528] = {.lex_state = 537},
  [529] = {.lex_state = 61, .external_lex_state = 1},
  [530] = {.lex_state = 61, .external_lex_state = 1},
  [531] = {.lex_state = 537},
  [532] = {.lex_state = 64},
  [533] = {.lex_state = 537},
  [534] = {.lex_state = 537},
  [535] = {.lex_state = 537},
  [536] = {.lex_state = 61},
  [537] = {.lex_state = 61},
  [538] = {.lex_state = 61, .external_lex_state = 1},
  [539] = {.lex_state = 61},
  [540] = {.lex_state = 61},
  [541] = {.lex_state = 537},
  [542] = {.lex_state = 61},
  [543] = {.lex_state = 61},
  [544] = {.lex_state = 71, .external_lex_state = 1},
  [545] = {.lex_state = 61},
  [546] = {.lex_state = 61, .external_lex_state = 1},
  [547] = {.lex_state = 78},
  [548] = {.lex_state = 61, .external_lex_state = 1},
  [549] = {.lex_state = 537},
  [550] = {.lex_state = 537},
  [551] = {.lex_state = 537},
  [552] = {.lex_state = 61, .external_lex_state = 1},
  [553] = {.lex_state = 61},
  [554] = {.lex_state = 61},
  [555] = {.lex_state = 61, .external_lex_state = 1},
  [556] = {.lex_state = 78},
  [557] = {.lex_state = 61},
  [558] = {.lex_state = 61, .external_lex_state = 1},
  [559] = {.lex_state = 71},
  [560] = {.lex_state = 61},
  [561] = {.lex_state = 537},
  [562] = {.lex_state = 78},
  [563] = {.lex_state = 537},
  [564] = {.lex_state = 537},
  [565] = {.lex_state = 537},
  [566] = {.lex_state = 61},
  [567] = {.lex_state = 78},
  [568] = {.lex_state = 61},
  [569] = {.lex_state = 61},
  [570] = {.lex_state = 71},
  [571] = {.lex_state = 61, .external_lex_state = 1},
  [572] = {.lex_state = 61},
  [573] = {.lex_state = 61},
  [574] = {.lex_state = 61},
  [575] = {.lex_state = 61},
  [576] = {.lex_state = 61, .external_lex_state = 1},
  [577] = {.lex_state = 61},
  [578] = {.lex_state = 61},
  [579] = {.lex_state = 61},
  [580] = {.lex_state = 71, .external_lex_state = 1},
  [581] = {.lex_state = 78},
  [582] = {.lex_state = 537},
  [583] = {.lex_state = 90},
  [584] = {.lex_state = 61},
  [585] = {.lex_state = 61, .external_lex_state = 1},
  [586] = {.lex_state = 61, .external_lex_state = 1},
  [587] = {.lex_state = 61, .external_lex_state = 1},
  [588] = {.lex_state = 71},
  [589] = {.lex_state = 61, .external_lex_state = 1},
  [590] = {.lex_state = 61},
  [591] = {.lex_state = 78},
  [592] = {.lex_state = 71, .external_lex_state = 1},
  [593] = {.lex_state = 537},
  [594] = {.lex_state = 61},
  [595] = {.lex_state = 64, .external_lex_state = 1},
  [596] = {.lex_state = 61, .external_lex_state = 1},
  [597] = {.lex_state = 537},
  [598] = {.lex_state = 537},
  [599] = {.lex_state = 61},
  [600] = {.lex_state = 61},
  [601] = {.lex_state = 537},
  [602] = {.lex_state = 78},
  [603] = {.lex_state = 63, .external_lex_state = 1},
  [604] = {.lex_state = 537},
  [605] = {.lex_state = 78},
  [606] = {.lex_state = 63, .external_lex_state = 1},
  [607] = {.lex_state = 63, .external_lex_state = 1},
  [608] = {.lex_state = 63, .external_lex_state = 1},
  [609] = {.lex_state = 72},
  [610] = {.lex_state = 63, .external_lex_state = 1},
  [611] = {.lex_state = 83},
  [612] = {.lex_state = 90, .external_lex_state = 1},
  [613] = {.lex_state = 63, .external_lex_state = 1},
  [614] = {.lex_state = 63, .external_lex_state = 1},
  [615] = {.lex_state = 63},
  [616] = {.lex_state = 63},
  [617] = {.lex_state = 63},
  [618] = {.lex_state = 72, .external_lex_state = 1},
  [619] = {.lex_state = 63},
  [620] = {.lex_state = 90},
  [621] = {.lex_state = 83},
  [622] = {.lex_state = 63},
  [623] = {.lex_state = 63},
  [624] = {.lex_state = 63},
  [625] = {.lex_state = 63},
  [626] = {.lex_state = 63},
  [627] = {.lex_state = 63, .external_lex_state = 1},
  [628] = {.lex_state = 72},
  [629] = {.lex_state = 63},
  [630] = {.lex_state = 63},
  [631] = {.lex_state = 83, .external_lex_state = 1},
  [632] = {.lex_state = 83, .external_lex_state = 1},
  [633] = {.lex_state = 63},
  [634] = {.lex_state = 72, .external_lex_state = 1},
  [635] = {.lex_state = 63},
  [636] = {.lex_state = 63},
  [637] = {.lex_state = 63},
  [638] = {.lex_state = 63},
  [639] = {.lex_state = 90, .external_lex_state = 1},
  [640] = {.lex_state = 63, .external_lex_state = 1},
  [641] = {.lex_state = 63, .external_lex_state = 1},
  [642] = {.lex_state = 63, .external_lex_state = 1},
  [643] = {.lex_state = 63, .external_lex_state = 1},
  [644] = {.lex_state = 63, .external_lex_state = 1},
  [645] = {.lex_state = 537},
  [646] = {.lex_state = 63},
  [647] = {.lex_state = 63},
  [648] = {.lex_state = 63},
  [649] = {.lex_state = 63},
  [650] = {.lex_state = 71, .external_lex_state = 1},
  [651] = {.lex_state = 63, .external_lex_state = 1},
  [652] = {.lex_state = 63, .external_lex_state = 1},
  [653] = {.lex_state = 535},
  [654] = {.lex_state = 71},
  [655] = {.lex_state = 63, .external_lex_state = 1},
  [656] = {.lex_state = 63},
  [657] = {.lex_state = 63, .external_lex_state = 1},
  [658] = {.lex_state = 71, .external_lex_state = 1},
  [659] = {.lex_state = 78},
  [660] = {.lex_state = 63, .external_lex_state = 1},
  [661] = {.lex_state = 78},
  [662] = {.lex_state = 63, .external_lex_state = 1},
  [663] = {.lex_state = 63, .external_lex_state = 1},
  [664] = {.lex_state = 63, .external_lex_state = 1},
  [665] = {.lex_state = 535},
  [666] = {.lex_state = 63, .external_lex_state = 1},
  [667] = {.lex_state = 72},
  [668] = {.lex_state = 63, .external_lex_state = 1},
  [669] = {.lex_state = 537},
  [670] = {.lex_state = 63, .external_lex_state = 1},
  [671] = {.lex_state = 63, .external_lex_state = 1},
  [672] = {.lex_state = 63, .external_lex_state = 1},
  [673] = {.lex_state = 63},
  [674] = {.lex_state = 63, .external_lex_state = 1},
  [675] = {.lex_state = 63, .external_lex_state = 1},
  [676] = {.lex_state = 63},
  [677] = {.lex_state = 63},
  [678] = {.lex_state = 78},
  [679] = {.lex_state = 63},
  [680] = {.lex_state = 63, .external_lex_state = 1},
  [681] = {.lex_state = 63},
  [682] = {.lex_state = 63},
  [683] = {.lex_state = 63},
  [684] = {.lex_state = 63},
  [685] = {.lex_state = 90},
  [686] = {.lex_state = 78},
  [687] = {.lex_state = 63, .external_lex_state = 1},
  [688] = {.lex_state = 63},
  [689] = {.lex_state = 63},
  [690] = {.lex_state = 63},
  [691] = {.lex_state = 63},
  [692] = {.lex_state = 537},
  [693] = {.lex_state = 63, .external_lex_state = 1},
  [694] = {.lex_state = 71, .external_lex_state = 1},
  [695] = {.lex_state = 63},
  [696] = {.lex_state = 63},
  [697] = {.lex_state = 71},
  [698] = {.lex_state = 63, .external_lex_state = 1},
  [699] = {.lex_state = 71},
  [700] = {.lex_state = 63},
  [701] = {.lex_state = 63},
  [702] = {.lex_state = 63},
  [703] = {.lex_state = 63, .external_lex_state = 1},
  [704] = {.lex_state = 63, .external_lex_state = 1},
  [705] = {.lex_state = 63, .external_lex_state = 1},
  [706] = {.lex_state = 63, .external_lex_state = 1},
  [707] = {.lex_state = 72, .external_lex_state = 1},
  [708] = {.lex_state = 63, .external_lex_state = 1},
  [709] = {.lex_state = 63, .external_lex_state = 1},
  [710] = {.lex_state = 72},
  [711] = {.lex_state = 72},
  [712] = {.lex_state = 78},
  [713] = {.lex_state = 535, .external_lex_state = 1},
  [714] = {.lex_state = 67},
  [715] = {.lex_state = 72},
  [716] = {.lex_state = 78},
  [717] = {.lex_state = 535},
  [718] = {.lex_state = 78, .external_lex_state = 1},
  [719] = {.lex_state = 67, .external_lex_state = 1},
  [720] = {.lex_state = 78},
  [721] = {.lex_state = 535},
  [722] = {.lex_state = 78},
  [723] = {.lex_state = 72, .external_lex_state = 1},
  [724] = {.lex_state = 78},
  [725] = {.lex_state = 72, .external_lex_state = 1},
  [726] = {.lex_state = 67, .external_lex_state = 1},
  [727] = {.lex_state = 535, .external_lex_state = 1},
  [728] = {.lex_state = 72, .external_lex_state = 1},
  [729] = {.lex_state = 67},
  [730] = {.lex_state = 78},
  [731] = {.lex_state = 90},
  [732] = {.lex_state = 78},
  [733] = {.lex_state = 78},
  [734] = {.lex_state = 68},
  [735] = {.lex_state = 90},
  [736] = {.lex_state = 73, .external_lex_state = 1},
  [737] = {.lex_state = 73, .external_lex_state = 1},
  [738] = {.lex_state = 78},
  [739] = {.lex_state = 78},
  [740] = {.lex_state = 78},
  [741] = {.lex_state = 68, .external_lex_state = 1},
  [742] = {.lex_state = 73},
  [743] = {.lex_state = 68},
  [744] = {.lex_state = 73},
  [745] = {.lex_state = 78},
  [746] = {.lex_state = 68, .external_lex_state = 1},
  [747] = {.lex_state = 535},
  [748] = {.lex_state = 78},
  [749] = {.lex_state = 78},
  [750] = {.lex_state = 78},
  [751] = {.lex_state = 75, .external_lex_state = 1},
  [752] = {.lex_state = 535},
  [753] = {.lex_state = 67, .external_lex_state = 1},
  [754] = {.lex_state = 73},
  [755] = {.lex_state = 78},
  [756] = {.lex_state = 73},
  [757] = {.lex_state = 78},
  [758] = {.lex_state = 78},
  [759] = {.lex_state = 73, .external_lex_state = 1},
  [760] = {.lex_state = 67},
  [761] = {.lex_state = 75},
  [762] = {.lex_state = 73, .external_lex_state = 1},
  [763] = {.lex_state = 75},
  [764] = {.lex_state = 75, .external_lex_state = 1},
  [765] = {.lex_state = 66},
  [766] = {.lex_state = 78},
  [767] = {.lex_state = 78},
  [768] = {.lex_state = 78},
  [769] = {.lex_state = 68, .external_lex_state = 1},
  [770] = {.lex_state = 78},
  [771] = {.lex_state = 78},
  [772] = {.lex_state = 78},
  [773] = {.lex_state = 78},
  [774] = {.lex_state = 78},
  [775] = {.lex_state = 78},
  [776] = {.lex_state = 78},
  [777] = {.lex_state = 75, .external_lex_state = 1},
  [778] = {.lex_state = 78},
  [779] = {.lex_state = 75, .external_lex_state = 1},
  [780] = {.lex_state = 78},
  [781] = {.lex_state = 66, .external_lex_state = 1},
  [782] = {.lex_state = 66},
  [783] = {.lex_state = 78},
  [784] = {.lex_state = 78},
  [785] = {.lex_state = 66},
  [786] = {.lex_state = 78},
  [787] = {.lex_state = 78},
  [788] = {.lex_state = 78},
  [789] = {.lex_state = 78},
  [790] = {.lex_state = 78},
  [791] = {.lex_state = 78},
  [792] = {.lex_state = 78},
  [793] = {.lex_state = 78},
  [794] = {.lex_state = 78},
  [795] = {.lex_state = 78},
  [796] = {.lex_state = 78},
  [797] = {.lex_state = 78},
  [798] = {.lex_state = 66, .external_lex_state = 1},
  [799] = {.lex_state = 78},
  [800] = {.lex_state = 66},
  [801] = {.lex_state = 78},
  [802] = {.lex_state = 78},
  [803] = {.lex_state = 78},
  [804] = {.lex_state = 78},
  [805] = {.lex_state = 78},
  [806] = {.lex_state = 78},
  [807] = {.lex_state = 78},
  [808] = {.lex_state = 78},
  [809] = {.lex_state = 78},
  [810] = {.lex_state = 78},
  [811] = {.lex_state = 78},
  [812] = {.lex_state = 66, .external_lex_state = 1},
  [813] = {.lex_state = 78},
  [814] = {.lex_state = 66},
  [815] = {.lex_state = 66},
  [816] = {.lex_state = 78},
  [817] = {.lex_state = 78},
  [818] = {.lex_state = 78},
  [819] = {.lex_state = 78},
  [820] = {.lex_state = 78},
  [821] = {.lex_state = 66, .external_lex_state = 1},
  [822] = {.lex_state = 78},
  [823] = {.lex_state = 78},
  [824] = {.lex_state = 78},
  [825] = {.lex_state = 78},
  [826] = {.lex_state = 78},
  [827] = {.lex_state = 78},
  [828] = {.lex_state = 78},
  [829] = {.lex_state = 78},
  [830] = {.lex_state = 68},
  [831] = {.lex_state = 75},
  [832] = {.lex_state = 78},
  [833] = {.lex_state = 78},
  [834] = {.lex_state = 66, .external_lex_state = 1},
  [835] = {.lex_state = 78},
  [836] = {.lex_state = 75},
  [837] = {.lex_state = 66, .external_lex_state = 1},
  [838] = {.lex_state = 78},
  [839] = {.lex_state = 78},
  [840] = {.lex_state = 78},
  [841] = {.lex_state = 78},
  [842] = {.lex_state = 69},
  [843] = {.lex_state = 69},
  [844] = {.lex_state = 69, .external_lex_state = 1},
  [845] = {.lex_state = 69},
  [846] = {.lex_state = 69},
  [847] = {.lex_state = 69, .external_lex_state = 1},
  [848] = {.lex_state = 69, .external_lex_state = 1},
  [849] = {.lex_state = 69, .external_lex_state = 1},
  [850] = {.lex_state = 69},
  [851] = {.lex_state = 69, .external_lex_state = 1},
  [852] = {.lex_state = 69},
  [853] = {.lex_state = 69, .external_lex_state = 1},
  [854] = {.lex_state = 78},
  [855] = {.lex_state = 78},
  [856] = {.lex_state = 78},
  [857] = {.lex_state = 78},
  [858] = {.lex_state = 78},
  [859] = {.lex_state = 78},
  [860] = {.lex_state = 78},
  [861] = {.lex_state = 78},
  [862] = {.lex_state = 78},
  [863] = {.lex_state = 78},
  [864] = {.lex_state = 78},
  [865] = {.lex_state = 78},
  [866] = {.lex_state = 78},
  [867] = {.lex_state = 78},
  [868] = {.lex_state = 78},
  [869] = {.lex_state = 78},
  [870] = {.lex_state = 78},
  [871] = {.lex_state = 78},
  [872] = {.lex_state = 78},
  [873] = {.lex_state = 78},
  [874] = {.lex_state = 95},
  [875] = {.lex_state = 95},
  [876] = {.lex_state = 70},
  [877] = {.lex_state = 70},
  [878] = {.lex_state = 70},
  [879] = {.lex_state = 70},
  [880] = {.lex_state = 70},
  [881] = {.lex_state = 70},
  [882] = {.lex_state = 96},
  [883] = {.lex_state = 95},
  [884] = {.lex_state = 96},
  [885] = {.lex_state = 96},
  [886] = {.lex_state = 95},
  [887] = {.lex_state = 96},
  [888] = {.lex_state = 95},
  [889] = {.lex_state = 95},
  [890] = {.lex_state = 96},
  [891] = {.lex_state = 101},
  [892] = {.lex_state = 96},
  [893] = {.lex_state = 96},
  [894] = {.lex_state = 535},
  [895] = {.lex_state = 535, .external_lex_state = 1},
  [896] = {.lex_state = 535, .external_lex_state = 1},
  [897] = {.lex_state = 535, .external_lex_state = 1},
  [898] = {.lex_state = 535},
  [899] = {.lex_state = 535},
  [900] = {.lex_state = 101},
  [901] = {.lex_state = 101},
  [902] = {.lex_state = 101},
  [903] = {.lex_state = 101},
  [904] = {.lex_state = 101},
  [905] = {.lex_state = 101},
  [906] = {.lex_state = 101},
  [907] = {.lex_state = 101},
  [908] = {.lex_state = 101},
  [909] = {.lex_state = 101},
  [910] = {.lex_state = 101},
  [911] = {.lex_state = 101},
  [912] = {.lex_state = 101},
  [913] = {.lex_state = 101},
  [914] = {.lex_state = 101},
  [915] = {.lex_state = 101},
  [916] = {.lex_state = 101},
  [917] = {.lex_state = 101},
  [918] = {.lex_state = 101},
  [919] = {.lex_state = 101},
  [920] = {.lex_state = 101},
  [921] = {.lex_state = 101},
  [922] = {.lex_state = 101},
  [923] = {.lex_state = 101},
  [924] = {.lex_state = 101},
  [925] = {.lex_state = 101},
  [926] = {.lex_state = 101},
  [927] = {.lex_state = 101},
  [928] = {.lex_state = 101},
  [929] = {.lex_state = 101},
  [930] = {.lex_state = 101},
  [931] = {.lex_state = 101},
  [932] = {.lex_state = 101},
  [933] = {.lex_state = 101},
  [934] = {.lex_state = 101},
  [935] = {.lex_state = 535, .external_lex_state = 1},
  [936] = {.lex_state = 535},
  [937] = {.lex_state = 83},
  [938] = {.lex_state = 101, .external_lex_state = 1},
  [939] = {.lex_state = 101, .external_lex_state = 1},
  [940] = {.lex_state = 101, .external_lex_state = 1},
  [941] = {.lex_state = 101, .external_lex_state = 1},
  [942] = {.lex_state = 101, .external_lex_state = 1},
  [943] = {.lex_state = 101, .external_lex_state = 1},
  [944] = {.lex_state = 101, .external_lex_state = 1},
  [945] = {.lex_state = 101, .external_lex_state = 1},
  [946] = {.lex_state = 101, .external_lex_state = 1},
  [947] = {.lex_state = 101, .external_lex_state = 1},
  [948] = {.lex_state = 101, .external_lex_state = 1},
  [949] = {.lex_state = 101, .external_lex_state = 1},
  [950] = {.lex_state = 101, .external_lex_state = 1},
  [951] = {.lex_state = 101, .external_lex_state = 1},
  [952] = {.lex_state = 101, .external_lex_state = 1},
  [953] = {.lex_state = 101, .external_lex_state = 1},
  [954] = {.lex_state = 101},
  [955] = {.lex_state = 101, .external_lex_state = 1},
  [956] = {.lex_state = 101, .external_lex_state = 1},
  [957] = {.lex_state = 101, .external_lex_state = 1},
  [958] = {.lex_state = 101, .external_lex_state = 1},
  [959] = {.lex_state = 101, .external_lex_state = 1},
  [960] = {.lex_state = 101, .external_lex_state = 1},
  [961] = {.lex_state = 101, .external_lex_state = 1},
  [962] = {.lex_state = 101, .external_lex_state = 1},
  [963] = {.lex_state = 101, .external_lex_state = 1},
  [964] = {.lex_state = 101, .external_lex_state = 1},
  [965] = {.lex_state = 101, .external_lex_state = 1},
  [966] = {.lex_state = 101, .external_lex_state = 1},
  [967] = {.lex_state = 101, .external_lex_state = 1},
  [968] = {.lex_state = 101, .external_lex_state = 1},
  [969] = {.lex_state = 101, .external_lex_state = 1},
  [970] = {.lex_state = 101, .external_lex_state = 1},
  [971] = {.lex_state = 101, .external_lex_state = 1},
  [972] = {.lex_state = 101, .external_lex_state = 1},
  [973] = {.lex_state = 101, .external_lex_state = 1},
  [974] = {.lex_state = 101, .external_lex_state = 1},
  [975] = {.lex_state = 101, .external_lex_state = 1},
  [976] = {.lex_state = 101, .external_lex_state = 1},
  [977] = {.lex_state = 101},
  [978] = {.lex_state = 78},
  [979] = {.lex_state = 83, .external_lex_state = 1},
  [980] = {.lex_state = 78},
  [981] = {.lex_state = 78},
  [982] = {.lex_state = 535, .external_lex_state = 1},
  [983] = {.lex_state = 535, .external_lex_state = 1},
  [984] = {.lex_state = 535},
  [985] = {.lex_state = 535},
  [986] = {.lex_state = 74},
  [987] = {.lex_state = 74, .external_lex_state = 1},
  [988] = {.lex_state = 74},
  [989] = {.lex_state = 74, .external_lex_state = 1},
  [990] = {.lex_state = 114, .external_lex_state = 1},
  [991] = {.lex_state = 114},
  [992] = {.lex_state = 78},
  [993] = {.lex_state = 114, .external_lex_state = 1},
  [994] = {.lex_state = 114},
  [995] = {.lex_state = 535},
  [996] = {.lex_state = 535, .external_lex_state = 1},
  [997] = {.lex_state = 535, .external_lex_state = 1},
  [998] = {.lex_state = 535},
  [999] = {.lex_state = 535},
  [1000] = {.lex_state = 535, .external_lex_state = 1},
  [1001] = {.lex_state = 535, .external_lex_state = 1},
  [1002] = {.lex_state = 535, .external_lex_state = 1},
  [1003] = {.lex_state = 535},
  [1004] = {.lex_state = 535},
  [1005] = {.lex_state = 96},
  [1006] = {.lex_state = 96},
  [1007] = {.lex_state = 96},
  [1008] = {.lex_state = 70},
  [1009] = {.lex_state = 95},
  [1010] = {.lex_state = 90},
  [1011] = {.lex_state = 90},
  [1012] = {.lex_state = 90},
  [1013] = {.lex_state = 90},
  [1014] = {.lex_state = 90},
  [1015] = {.lex_state = 90},
  [1016] = {.lex_state = 90},
  [1017] = {.lex_state = 90},
  [1018] = {.lex_state = 90},
  [1019] = {.lex_state = 90},
  [1020] = {.lex_state = 90},
  [1021] = {.lex_state = 90},
  [1022] = {.lex_state = 90},
  [1023] = {.lex_state = 90},
  [1024] = {.lex_state = 90},
  [1025] = {.lex_state = 90},
  [1026] = {.lex_state = 90},
  [1027] = {.lex_state = 90},
  [1028] = {.lex_state = 90},
  [1029] = {.lex_state = 90},
  [1030] = {.lex_state = 90},
  [1031] = {.lex_state = 90},
  [1032] = {.lex_state = 90},
  [1033] = {.lex_state = 90},
  [1034] = {.lex_state = 90},
  [1035] = {.lex_state = 97},
  [1036] = {.lex_state = 97},
  [1037] = {.lex_state = 97},
  [1038] = {.lex_state = 97},
  [1039] = {.lex_state = 97},
  [1040] = {.lex_state = 98},
  [1041] = {.lex_state = 98},
  [1042] = {.lex_state = 98},
  [1043] = {.lex_state = 97},
  [1044] = {.lex_state = 98},
  [1045] = {.lex_state = 98},
  [1046] = {.lex_state = 98},
  [1047] = {.lex_state = 98},
  [1048] = {.lex_state = 98},
  [1049] = {.lex_state = 98},
  [1050] = {.lex_state = 97},
  [1051] = {.lex_state = 98},
  [1052] = {.lex_state = 97},
  [1053] = {.lex_state = 98},
  [1054] = {.lex_state = 98},
  [1055] = {.lex_state = 98},
  [1056] = {.lex_state = 98},
  [1057] = {.lex_state = 98},
  [1058] = {.lex_state = 98},
  [1059] = {.lex_state = 97},
  [1060] = {.lex_state = 97},
  [1061] = {.lex_state = 25},
  [1062] = {.lex_state = 25},
  [1063] = {.lex_state = 25},
  [1064] = {.lex_state = 25},
  [1065] = {.lex_state = 25},
  [1066] = {.lex_state = 25},
  [1067] = {.lex_state = 25},
  [1068] = {.lex_state = 97},
  [1069] = {.lex_state = 98},
  [1070] = {.lex_state = 25},
  [1071] = {.lex_state = 25},
  [1072] = {.lex_state = 25},
  [1073] = {.lex_state = 25},
  [1074] = {.lex_state = 25},
  [1075] = {.lex_state = 25},
  [1076] = {.lex_state = 25},
  [1077] = {.lex_state = 25},
  [1078] = {.lex_state = 25},
  [1079] = {.lex_state = 25},
  [1080] = {.lex_state = 104},
  [1081] = {.lex_state = 535},
  [1082] = {.lex_state = 535},
  [1083] = {.lex_state = 104},
  [1084] = {.lex_state = 535},
  [1085] = {.lex_state = 535},
  [1086] = {.lex_state = 535},
  [1087] = {.lex_state = 535},
  [1088] = {.lex_state = 535},
  [1089] = {.lex_state = 90},
  [1090] = {.lex_state = 90},
  [1091] = {.lex_state = 90},
  [1092] = {.lex_state = 90},
  [1093] = {.lex_state = 90},
  [1094] = {.lex_state = 535},
  [1095] = {.lex_state = 98},
  [1096] = {.lex_state = 98},
  [1097] = {.lex_state = 97},
  [1098] = {.lex_state = 97},
  [1099] = {.lex_state = 97},
  [1100] = {.lex_state = 90},
  [1101] = {.lex_state = 25},
  [1102] = {.lex_state = 25},
  [1103] = {.lex_state = 25},
  [1104] = {.lex_state = 98},
  [1105] = {.lex_state = 98},
  [1106] = {.lex_state = 90},
  [1107] = {.lex_state = 535},
  [1108] = {.lex_state = 535},
  [1109] = {.lex_state = 535},
  [1110] = {.lex_state = 535},
  [1111] = {.lex_state = 103},
  [1112] = {.lex_state = 90},
  [1113] = {.lex_state = 90},
  [1114] = {.lex_state = 535},
  [1115] = {.lex_state = 90},
  [1116] = {.lex_state = 535},
  [1117] = {.lex_state = 90},
  [1118] = {.lex_state = 90},
  [1119] = {.lex_state = 90},
  [1120] = {.lex_state = 535},
  [1121] = {.lex_state = 90},
  [1122] = {.lex_state = 103},
  [1123] = {.lex_state = 535},
  [1124] = {.lex_state = 90},
  [1125] = {.lex_state = 101},
  [1126] = {.lex_state = 535},
  [1127] = {.lex_state = 535},
  [1128] = {.lex_state = 101},
  [1129] = {.lex_state = 535},
  [1130] = {.lex_state = 90},
  [1131] = {.lex_state = 101},
  [1132] = {.lex_state = 535},
  [1133] = {.lex_state = 535},
  [1134] = {.lex_state = 101},
  [1135] = {.lex_state = 90},
  [1136] = {.lex_state = 101},
  [1137] = {.lex_state = 103},
  [1138] = {.lex_state = 101},
  [1139] = {.lex_state = 535},
  [1140] = {.lex_state = 535},
  [1141] = {.lex_state = 113},
  [1142] = {.lex_state = 78},
  [1143] = {.lex_state = 78},
  [1144] = {.lex_state = 113},
  [1145] = {.lex_state = 535},
  [1146] = {.lex_state = 101},
  [1147] = {.lex_state = 535},
  [1148] = {.lex_state = 101, .external_lex_state = 1},
  [1149] = {.lex_state = 535},
  [1150] = {.lex_state = 535},
  [1151] = {.lex_state = 535},
  [1152] = {.lex_state = 535},
  [1153] = {.lex_state = 535},
  [1154] = {.lex_state = 535},
  [1155] = {.lex_state = 535},
  [1156] = {.lex_state = 535},
  [1157] = {.lex_state = 535},
  [1158] = {.lex_state = 535},
  [1159] = {.lex_state = 101},
  [1160] = {.lex_state = 535},
  [1161] = {.lex_state = 535},
  [1162] = {.lex_state = 535},
  [1163] = {.lex_state = 101},
  [1164] = {.lex_state = 535, .external_lex_state = 1},
  [1165] = {.lex_state = 99},
  [1166] = {.lex_state = 101},
  [1167] = {.lex_state = 99},
  [1168] = {.lex_state = 101},
  [1169] = {.lex_state = 535},
  [1170] = {.lex_state = 535, .external_lex_state = 1},
  [1171] = {.lex_state = 535},
  [1172] = {.lex_state = 101, .external_lex_state = 1},
  [1173] = {.lex_state = 535},
  [1174] = {.lex_state = 535, .external_lex_state = 1},
  [1175] = {.lex_state = 535},
  [1176] = {.lex_state = 535},
  [1177] = {.lex_state = 535, .external_lex_state = 1},
  [1178] = {.lex_state = 99},
  [1179] = {.lex_state = 535},
  [1180] = {.lex_state = 101},
  [1181] = {.lex_state = 30},
  [1182] = {.lex_state = 30},
  [1183] = {.lex_state = 103, .external_lex_state = 1},
  [1184] = {.lex_state = 106},
  [1185] = {.lex_state = 99},
  [1186] = {.lex_state = 99},
  [1187] = {.lex_state = 103},
  [1188] = {.lex_state = 32, .external_lex_state = 1},
  [1189] = {.lex_state = 103, .external_lex_state = 1},
  [1190] = {.lex_state = 32, .external_lex_state = 1},
  [1191] = {.lex_state = 106},
  [1192] = {.lex_state = 99},
  [1193] = {.lex_state = 103},
  [1194] = {.lex_state = 106},
  [1195] = {.lex_state = 106},
  [1196] = {.lex_state = 103},
  [1197] = {.lex_state = 103, .external_lex_state = 1},
  [1198] = {.lex_state = 106},
  [1199] = {.lex_state = 535},
  [1200] = {.lex_state = 535},
  [1201] = {.lex_state = 535, .external_lex_state = 1},
  [1202] = {.lex_state = 535},
  [1203] = {.lex_state = 106},
  [1204] = {.lex_state = 535, .external_lex_state = 1},
  [1205] = {.lex_state = 106},
  [1206] = {.lex_state = 106},
  [1207] = {.lex_state = 535},
  [1208] = {.lex_state = 535, .external_lex_state = 1},
  [1209] = {.lex_state = 106},
  [1210] = {.lex_state = 535},
  [1211] = {.lex_state = 106},
  [1212] = {.lex_state = 535, .external_lex_state = 1},
  [1213] = {.lex_state = 535},
  [1214] = {.lex_state = 535},
  [1215] = {.lex_state = 106},
  [1216] = {.lex_state = 106},
  [1217] = {.lex_state = 106},
  [1218] = {.lex_state = 106},
  [1219] = {.lex_state = 535},
  [1220] = {.lex_state = 106},
  [1221] = {.lex_state = 106},
  [1222] = {.lex_state = 106},
  [1223] = {.lex_state = 535},
  [1224] = {.lex_state = 106},
  [1225] = {.lex_state = 535},
  [1226] = {.lex_state = 535},
  [1227] = {.lex_state = 535, .external_lex_state = 1},
  [1228] = {.lex_state = 535},
  [1229] = {.lex_state = 106},
  [1230] = {.lex_state = 106},
  [1231] = {.lex_state = 106},
  [1232] = {.lex_state = 535, .external_lex_state = 1},
  [1233] = {.lex_state = 106},
  [1234] = {.lex_state = 535},
  [1235] = {.lex_state = 535},
  [1236] = {.lex_state = 106},
  [1237] = {.lex_state = 106},
  [1238] = {.lex_state = 106},
  [1239] = {.lex_state = 535, .external_lex_state = 1},
  [1240] = {.lex_state = 106},
  [1241] = {.lex_state = 535, .external_lex_state = 1},
  [1242] = {.lex_state = 535},
  [1243] = {.lex_state = 535},
  [1244] = {.lex_state = 78},
  [1245] = {.lex_state = 32},
  [1246] = {.lex_state = 78},
  [1247] = {.lex_state = 78},
  [1248] = {.lex_state = 101},
  [1249] = {.lex_state = 78},
  [1250] = {.lex_state = 535},
  [1251] = {.lex_state = 78},
  [1252] = {.lex_state = 535},
  [1253] = {.lex_state = 103},
  [1254] = {.lex_state = 78},
  [1255] = {.lex_state = 78},
  [1256] = {.lex_state = 32},
  [1257] = {.lex_state = 535},
  [1258] = {.lex_state = 103},
  [1259] = {.lex_state = 103, .external_lex_state = 1},
  [1260] = {.lex_state = 78},
  [1261] = {.lex_state = 78},
  [1262] = {.lex_state = 535},
  [1263] = {.lex_state = 535},
  [1264] = {.lex_state = 78},
  [1265] = {.lex_state = 103, .external_lex_state = 1},
  [1266] = {.lex_state = 101},
  [1267] = {.lex_state = 101},
  [1268] = {.lex_state = 535, .external_lex_state = 1},
  [1269] = {.lex_state = 101},
  [1270] = {.lex_state = 78},
  [1271] = {.lex_state = 535},
  [1272] = {.lex_state = 535},
  [1273] = {.lex_state = 535},
  [1274] = {.lex_state = 535},
  [1275] = {.lex_state = 535},
  [1276] = {.lex_state = 88},
  [1277] = {.lex_state = 535},
  [1278] = {.lex_state = 535},
  [1279] = {.lex_state = 535},
  [1280] = {.lex_state = 103},
  [1281] = {.lex_state = 88},
  [1282] = {.lex_state = 535},
  [1283] = {.lex_state = 92},
  [1284] = {.lex_state = 535},
  [1285] = {.lex_state = 103, .external_lex_state = 1},
  [1286] = {.lex_state = 535, .external_lex_state = 1},
  [1287] = {.lex_state = 535},
  [1288] = {.lex_state = 92},
  [1289] = {.lex_state = 35},
  [1290] = {.lex_state = 35},
  [1291] = {.lex_state = 535},
  [1292] = {.lex_state = 92},
  [1293] = {.lex_state = 101},
  [1294] = {.lex_state = 535},
  [1295] = {.lex_state = 535, .external_lex_state = 1},
  [1296] = {.lex_state = 88},
  [1297] = {.lex_state = 101},
  [1298] = {.lex_state = 88},
  [1299] = {.lex_state = 92},
  [1300] = {.lex_state = 535},
  [1301] = {.lex_state = 101},
  [1302] = {.lex_state = 101},
  [1303] = {.lex_state = 535},
  [1304] = {.lex_state = 92},
  [1305] = {.lex_state = 535},
  [1306] = {.lex_state = 92},
  [1307] = {.lex_state = 535},
  [1308] = {.lex_state = 535, .external_lex_state = 1},
  [1309] = {.lex_state = 35},
  [1310] = {.lex_state = 535},
  [1311] = {.lex_state = 535},
  [1312] = {.lex_state = 535},
  [1313] = {.lex_state = 535},
  [1314] = {.lex_state = 535},
  [1315] = {.lex_state = 535},
  [1316] = {.lex_state = 35},
  [1317] = {.lex_state = 35},
  [1318] = {.lex_state = 103, .external_lex_state = 1},
  [1319] = {.lex_state = 535},
  [1320] = {.lex_state = 535},
  [1321] = {.lex_state = 535},
  [1322] = {.lex_state = 535},
  [1323] = {.lex_state = 535},
  [1324] = {.lex_state = 535},
  [1325] = {.lex_state = 106},
  [1326] = {.lex_state = 535},
  [1327] = {.lex_state = 535},
  [1328] = {.lex_state = 92},
  [1329] = {.lex_state = 535, .external_lex_state = 1},
  [1330] = {.lex_state = 88},
  [1331] = {.lex_state = 101},
  [1332] = {.lex_state = 88},
  [1333] = {.lex_state = 535},
  [1334] = {.lex_state = 535, .external_lex_state = 1},
  [1335] = {.lex_state = 92},
  [1336] = {.lex_state = 535},
  [1337] = {.lex_state = 108},
  [1338] = {.lex_state = 535},
  [1339] = {.lex_state = 35},
  [1340] = {.lex_state = 88},
  [1341] = {.lex_state = 92},
  [1342] = {.lex_state = 535},
  [1343] = {.lex_state = 88},
  [1344] = {.lex_state = 92},
  [1345] = {.lex_state = 535, .external_lex_state = 1},
  [1346] = {.lex_state = 35},
  [1347] = {.lex_state = 35},
  [1348] = {.lex_state = 88},
  [1349] = {.lex_state = 535},
  [1350] = {.lex_state = 92},
  [1351] = {.lex_state = 88},
  [1352] = {.lex_state = 101},
  [1353] = {.lex_state = 92},
  [1354] = {.lex_state = 35},
  [1355] = {.lex_state = 535},
  [1356] = {.lex_state = 535},
  [1357] = {.lex_state = 535},
  [1358] = {.lex_state = 535},
  [1359] = {.lex_state = 535, .external_lex_state = 1},
  [1360] = {.lex_state = 88},
  [1361] = {.lex_state = 92},
  [1362] = {.lex_state = 103},
  [1363] = {.lex_state = 535},
  [1364] = {.lex_state = 92},
  [1365] = {.lex_state = 535},
  [1366] = {.lex_state = 92},
  [1367] = {.lex_state = 535},
  [1368] = {.lex_state = 35},
  [1369] = {.lex_state = 101},
  [1370] = {.lex_state = 35},
  [1371] = {.lex_state = 535},
  [1372] = {.lex_state = 103},
  [1373] = {.lex_state = 535},
  [1374] = {.lex_state = 535},
  [1375] = {.lex_state = 101},
  [1376] = {.lex_state = 92},
  [1377] = {.lex_state = 535},
  [1378] = {.lex_state = 535},
  [1379] = {.lex_state = 535},
  [1380] = {.lex_state = 92},
  [1381] = {.lex_state = 535, .external_lex_state = 1},
  [1382] = {.lex_state = 535},
  [1383] = {.lex_state = 535},
  [1384] = {.lex_state = 535, .external_lex_state = 1},
  [1385] = {.lex_state = 535},
  [1386] = {.lex_state = 35},
  [1387] = {.lex_state = 535},
  [1388] = {.lex_state = 535},
  [1389] = {.lex_state = 103, .external_lex_state = 1},
  [1390] = {.lex_state = 535},
  [1391] = {.lex_state = 535},
  [1392] = {.lex_state = 535},
  [1393] = {.lex_state = 535},
  [1394] = {.lex_state = 535},
  [1395] = {.lex_state = 535},
  [1396] = {.lex_state = 535},
  [1397] = {.lex_state = 535},
  [1398] = {.lex_state = 535},
  [1399] = {.lex_state = 535, .external_lex_state = 1},
  [1400] = {.lex_state = 535},
  [1401] = {.lex_state = 90},
  [1402] = {.lex_state = 535},
  [1403] = {.lex_state = 535},
  [1404] = {.lex_state = 535},
  [1405] = {.lex_state = 101},
  [1406] = {.lex_state = 535},
  [1407] = {.lex_state = 115},
  [1408] = {.lex_state = 535},
  [1409] = {.lex_state = 535},
  [1410] = {.lex_state = 535},
  [1411] = {.lex_state = 535},
  [1412] = {.lex_state = 90},
  [1413] = {.lex_state = 535},
  [1414] = {.lex_state = 535},
  [1415] = {.lex_state = 535},
  [1416] = {.lex_state = 535},
  [1417] = {.lex_state = 535},
  [1418] = {.lex_state = 535},
  [1419] = {.lex_state = 535},
  [1420] = {.lex_state = 535},
  [1421] = {.lex_state = 535},
  [1422] = {.lex_state = 535},
  [1423] = {.lex_state = 535},
  [1424] = {.lex_state = 535},
  [1425] = {.lex_state = 535, .external_lex_state = 1},
  [1426] = {.lex_state = 535},
  [1427] = {.lex_state = 535},
  [1428] = {.lex_state = 535},
  [1429] = {.lex_state = 535},
  [1430] = {.lex_state = 535},
  [1431] = {.lex_state = 535},
  [1432] = {.lex_state = 535},
  [1433] = {.lex_state = 535},
  [1434] = {.lex_state = 78},
  [1435] = {.lex_state = 535},
  [1436] = {.lex_state = 535},
  [1437] = {.lex_state = 535},
  [1438] = {.lex_state = 535},
  [1439] = {.lex_state = 535},
  [1440] = {.lex_state = 535},
  [1441] = {.lex_state = 535},
  [1442] = {.lex_state = 535, .external_lex_state = 1},
  [1443] = {.lex_state = 535},
  [1444] = {.lex_state = 535},
  [1445] = {.lex_state = 535},
  [1446] = {.lex_state = 535},
  [1447] = {.lex_state = 535},
  [1448] = {.lex_state = 535},
  [1449] = {.lex_state = 535},
  [1450] = {.lex_state = 535},
  [1451] = {.lex_state = 535},
  [1452] = {.lex_state = 535},
  [1453] = {.lex_state = 535, .external_lex_state = 1},
  [1454] = {.lex_state = 535},
  [1455] = {.lex_state = 535},
  [1456] = {.lex_state = 535},
  [1457] = {.lex_state = 535},
  [1458] = {.lex_state = 535},
  [1459] = {.lex_state = 78},
  [1460] = {.lex_state = 535},
  [1461] = {.lex_state = 535},
  [1462] = {.lex_state = 535},
  [1463] = {.lex_state = 535},
  [1464] = {.lex_state = 535},
  [1465] = {.lex_state = 535},
  [1466] = {.lex_state = 90},
  [1467] = {.lex_state = 535},
  [1468] = {.lex_state = 535},
  [1469] = {.lex_state = 535},
  [1470] = {.lex_state = 90},
  [1471] = {.lex_state = 535},
  [1472] = {.lex_state = 535},
  [1473] = {.lex_state = 535},
  [1474] = {.lex_state = 535},
  [1475] = {.lex_state = 535},
  [1476] = {.lex_state = 535},
  [1477] = {.lex_state = 535},
  [1478] = {.lex_state = 535},
  [1479] = {.lex_state = 535},
  [1480] = {.lex_state = 535},
  [1481] = {.lex_state = 535},
  [1482] = {.lex_state = 535},
  [1483] = {.lex_state = 535},
  [1484] = {.lex_state = 535},
  [1485] = {.lex_state = 535},
  [1486] = {.lex_state = 535},
  [1487] = {.lex_state = 535},
  [1488] = {.lex_state = 535},
  [1489] = {.lex_state = 535},
  [1490] = {.lex_state = 535},
  [1491] = {.lex_state = 535},
  [1492] = {.lex_state = 535},
  [1493] = {.lex_state = 535},
  [1494] = {.lex_state = 535},
  [1495] = {.lex_state = 535},
  [1496] = {.lex_state = 535},
  [1497] = {.lex_state = 535},
  [1498] = {.lex_state = 535},
  [1499] = {.lex_state = 535},
  [1500] = {.lex_state = 535},
  [1501] = {.lex_state = 535},
  [1502] = {.lex_state = 535},
  [1503] = {.lex_state = 535},
  [1504] = {.lex_state = 535},
  [1505] = {.lex_state = 535},
  [1506] = {.lex_state = 535},
  [1507] = {.lex_state = 535},
  [1508] = {.lex_state = 535},
  [1509] = {.lex_state = 535},
  [1510] = {.lex_state = 535},
  [1511] = {.lex_state = 535},
  [1512] = {.lex_state = 535},
  [1513] = {.lex_state = 115},
  [1514] = {.lex_state = 535},
  [1515] = {.lex_state = 535},
  [1516] = {.lex_state = 535},
  [1517] = {.lex_state = 535},
  [1518] = {.lex_state = 535},
  [1519] = {.lex_state = 535},
  [1520] = {.lex_state = 535},
  [1521] = {.lex_state = 535},
  [1522] = {.lex_state = 535, .external_lex_state = 1},
  [1523] = {.lex_state = 535},
  [1524] = {.lex_state = 535},
  [1525] = {.lex_state = 535},
  [1526] = {.lex_state = 535},
  [1527] = {.lex_state = 78},
  [1528] = {.lex_state = 535},
  [1529] = {.lex_state = 535},
  [1530] = {.lex_state = 535},
  [1531] = {.lex_state = 115},
  [1532] = {.lex_state = 535},
  [1533] = {.lex_state = 535},
  [1534] = {.lex_state = 535},
  [1535] = {.lex_state = 115},
  [1536] = {.lex_state = 535},
  [1537] = {.lex_state = 535},
  [1538] = {.lex_state = 535},
  [1539] = {.lex_state = 535},
  [1540] = {.lex_state = 535},
  [1541] = {.lex_state = 535},
  [1542] = {.lex_state = 535},
  [1543] = {.lex_state = 535},
  [1544] = {.lex_state = 535},
  [1545] = {.lex_state = 535},
  [1546] = {.lex_state = 535},
  [1547] = {.lex_state = 535},
  [1548] = {.lex_state = 535},
  [1549] = {.lex_state = 535},
  [1550] = {.lex_state = 535},
  [1551] = {.lex_state = 535},
  [1552] = {.lex_state = 535},
  [1553] = {.lex_state = 535},
  [1554] = {.lex_state = 535},
  [1555] = {.lex_state = 535},
  [1556] = {.lex_state = 78},
  [1557] = {.lex_state = 535},
  [1558] = {.lex_state = 535},
  [1559] = {.lex_state = 535},
  [1560] = {.lex_state = 535},
  [1561] = {.lex_state = 535},
  [1562] = {.lex_state = 535},
  [1563] = {.lex_state = 535},
  [1564] = {.lex_state = 535},
  [1565] = {.lex_state = 535},
  [1566] = {.lex_state = 535},
  [1567] = {.lex_state = 535},
  [1568] = {.lex_state = 535, .external_lex_state = 1},
  [1569] = {.lex_state = 535},
  [1570] = {.lex_state = 535},
  [1571] = {.lex_state = 535, .external_lex_state = 1},
  [1572] = {.lex_state = 535},
  [1573] = {.lex_state = 535},
  [1574] = {.lex_state = 535},
  [1575] = {.lex_state = 535},
  [1576] = {.lex_state = 535},
  [1577] = {.lex_state = 535},
  [1578] = {.lex_state = 535},
  [1579] = {.lex_state = 535},
  [1580] = {.lex_state = 535},
  [1581] = {.lex_state = 535},
  [1582] = {.lex_state = 535},
  [1583] = {.lex_state = 535},
  [1584] = {.lex_state = 535},
  [1585] = {.lex_state = 535},
  [1586] = {.lex_state = 535},
  [1587] = {.lex_state = 535},
  [1588] = {.lex_state = 535},
  [1589] = {.lex_state = 535},
  [1590] = {.lex_state = 535},
  [1591] = {.lex_state = 535},
  [1592] = {.lex_state = 535},
  [1593] = {.lex_state = 535},
  [1594] = {.lex_state = 535},
  [1595] = {.lex_state = 535},
  [1596] = {.lex_state = 535},
  [1597] = {.lex_state = 535},
  [1598] = {.lex_state = 535},
  [1599] = {.lex_state = 535},
  [1600] = {.lex_state = 535, .external_lex_state = 1},
  [1601] = {.lex_state = 535, .external_lex_state = 1},
  [1602] = {.lex_state = 535},
  [1603] = {.lex_state = 535},
  [1604] = {.lex_state = 535},
  [1605] = {.lex_state = 535},
  [1606] = {.lex_state = 535},
  [1607] = {.lex_state = 535},
  [1608] = {.lex_state = 535},
  [1609] = {.lex_state = 535},
  [1610] = {.lex_state = 535},
  [1611] = {.lex_state = 535},
  [1612] = {.lex_state = 535},
  [1613] = {.lex_state = 535},
  [1614] = {.lex_state = 535},
  [1615] = {.lex_state = 535},
  [1616] = {.lex_state = 535},
  [1617] = {.lex_state = 535},
  [1618] = {.lex_state = 535},
  [1619] = {.lex_state = 535},
  [1620] = {.lex_state = 535},
  [1621] = {.lex_state = 535},
  [1622] = {.lex_state = 535},
  [1623] = {.lex_state = 535},
  [1624] = {.lex_state = 535},
  [1625] = {.lex_state = 535},
  [1626] = {.lex_state = 535},
  [1627] = {.lex_state = 535},
  [1628] = {.lex_state = 535},
  [1629] = {.lex_state = 535},
  [1630] = {.lex_state = 535},
  [1631] = {.lex_state = 535},
  [1632] = {.lex_state = 535},
  [1633] = {.lex_state = 535},
  [1634] = {.lex_state = 535},
  [1635] = {.lex_state = 535},
  [1636] = {.lex_state = 535},
  [1637] = {.lex_state = 535},
  [1638] = {.lex_state = 535},
  [1639] = {.lex_state = 535},
  [1640] = {.lex_state = 535},
  [1641] = {.lex_state = 535},
  [1642] = {.lex_state = 535},
  [1643] = {.lex_state = 535},
  [1644] = {.lex_state = 535},
  [1645] = {.lex_state = 535},
  [1646] = {.lex_state = 535},
  [1647] = {.lex_state = 535},
  [1648] = {.lex_state = 535},
  [1649] = {.lex_state = 535},
  [1650] = {.lex_state = 535},
  [1651] = {.lex_state = 535},
  [1652] = {.lex_state = 535},
  [1653] = {.lex_state = 535},
  [1654] = {.lex_state = 535},
  [1655] = {.lex_state = 535},
  [1656] = {.lex_state = 535},
  [1657] = {.lex_state = 535},
  [1658] = {.lex_state = 535},
  [1659] = {.lex_state = 535},
  [1660] = {.lex_state = 535},
  [1661] = {.lex_state = 535},
  [1662] = {.lex_state = 535},
  [1663] = {.lex_state = 535},
  [1664] = {.lex_state = 535},
  [1665] = {.lex_state = 535},
  [1666] = {.lex_state = 535},
  [1667] = {.lex_state = 535},
  [1668] = {.lex_state = 535},
  [1669] = {.lex_state = 535},
  [1670] = {.lex_state = 535},
  [1671] = {.lex_state = 535},
  [1672] = {.lex_state = 535},
  [1673] = {.lex_state = 535},
  [1674] = {.lex_state = 535},
  [1675] = {.lex_state = 535},
  [1676] = {.lex_state = 535},
  [1677] = {.lex_state = 535},
  [1678] = {.lex_state = 535},
  [1679] = {.lex_state = 535},
  [1680] = {.lex_state = 535},
  [1681] = {.lex_state = 535},
  [1682] = {.lex_state = 535},
  [1683] = {.lex_state = 535},
  [1684] = {.lex_state = 535},
  [1685] = {.lex_state = 535},
  [1686] = {.lex_state = 535},
  [1687] = {.lex_state = 535},
  [1688] = {.lex_state = 535},
  [1689] = {.lex_state = 535},
  [1690] = {.lex_state = 535},
  [1691] = {.lex_state = 535},
  [1692] = {.lex_state = 535},
  [1693] = {.lex_state = 535},
  [1694] = {.lex_state = 535},
  [1695] = {.lex_state = 535},
  [1696] = {.lex_state = 535},
  [1697] = {.lex_state = 535},
  [1698] = {.lex_state = 535},
  [1699] = {.lex_state = 535},
  [1700] = {.lex_state = 535},
  [1701] = {.lex_state = 535},
  [1702] = {.lex_state = 535},
  [1703] = {.lex_state = 535},
  [1704] = {.lex_state = 535},
  [1705] = {.lex_state = 535},
  [1706] = {.lex_state = 535},
  [1707] = {.lex_state = 535},
  [1708] = {.lex_state = 535},
  [1709] = {.lex_state = 535},
  [1710] = {.lex_state = 535},
  [1711] = {.lex_state = 535},
  [1712] = {.lex_state = 535},
  [1713] = {.lex_state = 535, .external_lex_state = 1},
  [1714] = {.lex_state = 535},
  [1715] = {.lex_state = 535},
  [1716] = {.lex_state = 535},
  [1717] = {.lex_state = 535},
  [1718] = {.lex_state = 535},
  [1719] = {.lex_state = 535},
  [1720] = {.lex_state = 535},
  [1721] = {.lex_state = 535},
  [1722] = {.lex_state = 535},
  [1723] = {.lex_state = 535},
  [1724] = {.lex_state = 535, .external_lex_state = 1},
  [1725] = {.lex_state = 535, .external_lex_state = 1},
  [1726] = {.lex_state = 535, .external_lex_state = 1},
  [1727] = {.lex_state = 535, .external_lex_state = 1},
  [1728] = {.lex_state = 535},
  [1729] = {.lex_state = 535},
  [1730] = {.lex_state = 535, .external_lex_state = 1},
  [1731] = {.lex_state = 535, .external_lex_state = 1},
  [1732] = {.lex_state = 535, .external_lex_state = 1},
  [1733] = {.lex_state = 535, .external_lex_state = 1},
  [1734] = {.lex_state = 535, .external_lex_state = 1},
  [1735] = {.lex_state = 535, .external_lex_state = 1},
  [1736] = {.lex_state = 535, .external_lex_state = 1},
  [1737] = {.lex_state = 535, .external_lex_state = 1},
  [1738] = {.lex_state = 535, .external_lex_state = 1},
  [1739] = {.lex_state = 535, .external_lex_state = 1},
  [1740] = {.lex_state = 535, .external_lex_state = 1},
  [1741] = {.lex_state = 535, .external_lex_state = 1},
  [1742] = {.lex_state = 535, .external_lex_state = 1},
  [1743] = {.lex_state = 535, .external_lex_state = 1},
  [1744] = {.lex_state = 535, .external_lex_state = 1},
  [1745] = {.lex_state = 535, .external_lex_state = 1},
  [1746] = {.lex_state = 535, .external_lex_state = 1},
  [1747] = {.lex_state = 535, .external_lex_state = 1},
  [1748] = {.lex_state = 535, .external_lex_state = 1},
  [1749] = {.lex_state = 535, .external_lex_state = 1},
  [1750] = {.lex_state = 535, .external_lex_state = 1},
  [1751] = {.lex_state = 535},
  [1752] = {.lex_state = 535, .external_lex_state = 1},
  [1753] = {.lex_state = 535},
  [1754] = {.lex_state = 535, .external_lex_state = 1},
  [1755] = {.lex_state = 535},
  [1756] = {.lex_state = 535, .external_lex_state = 1},
  [1757] = {.lex_state = 535},
  [1758] = {.lex_state = 535},
  [1759] = {.lex_state = 535, .external_lex_state = 1},
  [1760] = {.lex_state = 535},
  [1761] = {.lex_state = 535, .external_lex_state = 1},
  [1762] = {.lex_state = 535, .external_lex_state = 1},
  [1763] = {.lex_state = 535, .external_lex_state = 1},
  [1764] = {.lex_state = 535, .external_lex_state = 1},
  [1765] = {.lex_state = 535},
  [1766] = {.lex_state = 535, .external_lex_state = 1},
  [1767] = {.lex_state = 535, .external_lex_state = 1},
  [1768] = {.lex_state = 535, .external_lex_state = 1},
  [1769] = {.lex_state = 535},
  [1770] = {.lex_state = 535},
  [1771] = {.lex_state = 535, .external_lex_state = 1},
  [1772] = {.lex_state = 535, .external_lex_state = 1},
  [1773] = {.lex_state = 535, .external_lex_state = 1},
  [1774] = {.lex_state = 535},
  [1775] = {.lex_state = 535},
  [1776] = {.lex_state = 535},
  [1777] = {.lex_state = 535, .external_lex_state = 1},
  [1778] = {.lex_state = 535},
  [1779] = {.lex_state = 535, .external_lex_state = 1},
  [1780] = {.lex_state = 535, .external_lex_state = 1},
  [1781] = {.lex_state = 535, .external_lex_state = 1},
  [1782] = {.lex_state = 535},
  [1783] = {.lex_state = 535, .external_lex_state = 1},
  [1784] = {.lex_state = 535, .external_lex_state = 1},
  [1785] = {.lex_state = 535, .external_lex_state = 1},
  [1786] = {.lex_state = 535, .external_lex_state = 1},
  [1787] = {.lex_state = 535, .external_lex_state = 1},
  [1788] = {.lex_state = 535, .external_lex_state = 1},
  [1789] = {.lex_state = 535},
  [1790] = {.lex_state = 535},
  [1791] = {.lex_state = 535},
  [1792] = {.lex_state = 535},
  [1793] = {.lex_state = 535},
  [1794] = {.lex_state = 535},
  [1795] = {.lex_state = 535},
  [1796] = {.lex_state = 535},
  [1797] = {.lex_state = 535},
  [1798] = {.lex_state = 535, .external_lex_state = 1},
  [1799] = {.lex_state = 535},
  [1800] = {.lex_state = 535},
  [1801] = {.lex_state = 535},
  [1802] = {.lex_state = 535},
  [1803] = {.lex_state = 535, .external_lex_state = 1},
  [1804] = {.lex_state = 535},
  [1805] = {.lex_state = 535},
  [1806] = {.lex_state = 535, .external_lex_state = 1},
  [1807] = {.lex_state = 535},
  [1808] = {.lex_state = 535},
  [1809] = {.lex_state = 535},
  [1810] = {.lex_state = 535},
  [1811] = {.lex_state = 535},
  [1812] = {.lex_state = 535},
  [1813] = {.lex_state = 535},
  [1814] = {.lex_state = 535},
  [1815] = {.lex_state = 535},
  [1816] = {.lex_state = 535},
  [1817] = {.lex_state = 535},
  [1818] = {.lex_state = 535},
  [1819] = {.lex_state = 535, .external_lex_state = 1},
  [1820] = {.lex_state = 535},
  [1821] = {.lex_state = 535},
  [1822] = {.lex_state = 535},
  [1823] = {.lex_state = 535},
  [1824] = {.lex_state = 535},
  [1825] = {.lex_state = 535, .external_lex_state = 1},
  [1826] = {.lex_state = 535},
  [1827] = {.lex_state = 535, .external_lex_state = 1},
  [1828] = {.lex_state = 535, .external_lex_state = 1},
  [1829] = {.lex_state = 535},
  [1830] = {.lex_state = 535, .external_lex_state = 1},
  [1831] = {.lex_state = 535},
  [1832] = {.lex_state = 535},
  [1833] = {.lex_state = 535, .external_lex_state = 1},
  [1834] = {.lex_state = 535},
  [1835] = {.lex_state = 535},
  [1836] = {.lex_state = 535},
  [1837] = {.lex_state = 535},
  [1838] = {.lex_state = 78},
  [1839] = {.lex_state = 535, .external_lex_state = 1},
  [1840] = {.lex_state = 535},
  [1841] = {.lex_state = 535},
  [1842] = {.lex_state = 535},
  [1843] = {.lex_state = 535, .external_lex_state = 1},
  [1844] = {.lex_state = 535, .external_lex_state = 1},
  [1845] = {.lex_state = 535},
  [1846] = {.lex_state = 535, .external_lex_state = 1},
  [1847] = {.lex_state = 535},
  [1848] = {.lex_state = 535},
  [1849] = {.lex_state = 535},
  [1850] = {.lex_state = 535},
  [1851] = {.lex_state = 535},
  [1852] = {.lex_state = 535},
  [1853] = {.lex_state = 535},
  [1854] = {.lex_state = 535, .external_lex_state = 1},
  [1855] = {.lex_state = 535, .external_lex_state = 1},
  [1856] = {.lex_state = 535},
  [1857] = {.lex_state = 535},
  [1858] = {.lex_state = 535},
  [1859] = {.lex_state = 535},
  [1860] = {.lex_state = 535},
  [1861] = {.lex_state = 535},
  [1862] = {.lex_state = 535},
  [1863] = {.lex_state = 535},
  [1864] = {.lex_state = 535},
  [1865] = {.lex_state = 535, .external_lex_state = 1},
  [1866] = {.lex_state = 535},
  [1867] = {.lex_state = 535},
  [1868] = {.lex_state = 535},
  [1869] = {.lex_state = 535, .external_lex_state = 1},
  [1870] = {.lex_state = 535},
  [1871] = {.lex_state = 535},
  [1872] = {.lex_state = 535},
  [1873] = {.lex_state = 535},
  [1874] = {.lex_state = 535},
  [1875] = {.lex_state = 535},
  [1876] = {.lex_state = 535},
  [1877] = {.lex_state = 535},
  [1878] = {.lex_state = 535},
  [1879] = {.lex_state = 535, .external_lex_state = 1},
  [1880] = {.lex_state = 78},
  [1881] = {.lex_state = 535},
  [1882] = {.lex_state = 535},
  [1883] = {.lex_state = 535},
  [1884] = {.lex_state = 535},
  [1885] = {.lex_state = 535},
  [1886] = {.lex_state = 535, .external_lex_state = 1},
  [1887] = {.lex_state = 535, .external_lex_state = 1},
  [1888] = {.lex_state = 535},
  [1889] = {.lex_state = 535},
  [1890] = {.lex_state = 535},
  [1891] = {.lex_state = 535},
  [1892] = {.lex_state = 535},
  [1893] = {.lex_state = 535},
  [1894] = {.lex_state = 78},
  [1895] = {.lex_state = 78},
  [1896] = {.lex_state = 535},
  [1897] = {.lex_state = 535},
  [1898] = {.lex_state = 535, .external_lex_state = 1},
  [1899] = {.lex_state = 535},
  [1900] = {.lex_state = 535, .external_lex_state = 1},
  [1901] = {.lex_state = 535},
  [1902] = {.lex_state = 78},
  [1903] = {.lex_state = 535},
  [1904] = {.lex_state = 535, .external_lex_state = 1},
  [1905] = {.lex_state = 535},
  [1906] = {.lex_state = 535, .external_lex_state = 1},
  [1907] = {.lex_state = 535, .external_lex_state = 1},
  [1908] = {.lex_state = 535},
  [1909] = {.lex_state = 535, .external_lex_state = 1},
  [1910] = {.lex_state = 535, .external_lex_state = 1},
  [1911] = {.lex_state = 535, .external_lex_state = 1},
  [1912] = {.lex_state = 106},
  [1913] = {.lex_state = 535},
  [1914] = {.lex_state = 535},
  [1915] = {.lex_state = 535},
  [1916] = {.lex_state = 535},
  [1917] = {.lex_state = 78},
  [1918] = {.lex_state = 78},
  [1919] = {.lex_state = 535},
  [1920] = {.lex_state = 535},
  [1921] = {.lex_state = 535},
  [1922] = {.lex_state = 535, .external_lex_state = 1},
  [1923] = {.lex_state = 535},
  [1924] = {.lex_state = 78},
  [1925] = {.lex_state = 535},
  [1926] = {.lex_state = 535, .external_lex_state = 1},
  [1927] = {.lex_state = 535},
  [1928] = {.lex_state = 535, .external_lex_state = 1},
  [1929] = {.lex_state = 535, .external_lex_state = 1},
  [1930] = {.lex_state = 535},
  [1931] = {.lex_state = 535, .external_lex_state = 1},
  [1932] = {.lex_state = 535, .external_lex_state = 1},
  [1933] = {.lex_state = 535, .external_lex_state = 1},
  [1934] = {.lex_state = 535},
  [1935] = {.lex_state = 535, .external_lex_state = 1},
  [1936] = {.lex_state = 78},
  [1937] = {.lex_state = 78},
  [1938] = {.lex_state = 535, .external_lex_state = 1},
  [1939] = {.lex_state = 535},
  [1940] = {.lex_state = 535, .external_lex_state = 1},
  [1941] = {.lex_state = 535},
  [1942] = {.lex_state = 78},
  [1943] = {.lex_state = 535},
  [1944] = {.lex_state = 535, .external_lex_state = 1},
  [1945] = {.lex_state = 535},
  [1946] = {.lex_state = 535, .external_lex_state = 1},
  [1947] = {.lex_state = 535, .external_lex_state = 1},
  [1948] = {.lex_state = 535},
  [1949] = {.lex_state = 535, .external_lex_state = 1},
  [1950] = {.lex_state = 535, .external_lex_state = 1},
  [1951] = {.lex_state = 535, .external_lex_state = 1},
  [1952] = {.lex_state = 535},
  [1953] = {.lex_state = 535},
  [1954] = {.lex_state = 535},
  [1955] = {.lex_state = 535},
  [1956] = {.lex_state = 535},
  [1957] = {.lex_state = 535},
  [1958] = {.lex_state = 535},
  [1959] = {.lex_state = 535},
  [1960] = {.lex_state = 535},
  [1961] = {.lex_state = 535},
  [1962] = {.lex_state = 535},
  [1963] = {.lex_state = 535},
  [1964] = {.lex_state = 535},
  [1965] = {.lex_state = 535},
  [1966] = {.lex_state = 535},
  [1967] = {.lex_state = 535},
  [1968] = {.lex_state = 535},
  [1969] = {.lex_state = 535},
  [1970] = {.lex_state = 535},
  [1971] = {.lex_state = 535},
  [1972] = {.lex_state = 535},
  [1973] = {.lex_state = 535, .external_lex_state = 1},
  [1974] = {.lex_state = 535, .external_lex_state = 1},
  [1975] = {.lex_state = 535},
  [1976] = {.lex_state = 535},
  [1977] = {.lex_state = 78},
  [1978] = {.lex_state = 78},
  [1979] = {.lex_state = 535},
  [1980] = {.lex_state = 535},
  [1981] = {.lex_state = 535},
  [1982] = {.lex_state = 535},
  [1983] = {.lex_state = 535},
  [1984] = {.lex_state = 535},
};

enum {
  ts_external_token__statement_terminator = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__statement_terminator] = sym__statement_terminator,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__statement_terminator] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hexadecimal_integer_literal] = ACTIONS(1),
    [sym_real_literal] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_expandable_string_literal_token5] = ACTIONS(1),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(1),
    [sym_verbatim_string_characters] = ACTIONS(1),
    [sym_verbatim_here_string_characters] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_2_GT] = ACTIONS(1),
    [anon_sym_2_GT_GT] = ACTIONS(1),
    [anon_sym_3_GT] = ACTIONS(1),
    [anon_sym_3_GT_GT] = ACTIONS(1),
    [anon_sym_4_GT] = ACTIONS(1),
    [anon_sym_4_GT_GT] = ACTIONS(1),
    [anon_sym_5_GT] = ACTIONS(1),
    [anon_sym_5_GT_GT] = ACTIONS(1),
    [anon_sym_6_GT] = ACTIONS(1),
    [anon_sym_6_GT_GT] = ACTIONS(1),
    [anon_sym_STAR_GT] = ACTIONS(1),
    [anon_sym_STAR_GT_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_STAR_GT_AMP1] = ACTIONS(1),
    [anon_sym_2_GT_AMP1] = ACTIONS(1),
    [anon_sym_3_GT_AMP1] = ACTIONS(1),
    [anon_sym_4_GT_AMP1] = ACTIONS(1),
    [anon_sym_5_GT_AMP1] = ACTIONS(1),
    [anon_sym_6_GT_AMP1] = ACTIONS(1),
    [anon_sym_STAR_GT_AMP2] = ACTIONS(1),
    [anon_sym_1_GT_AMP2] = ACTIONS(1),
    [anon_sym_3_GT_AMP2] = ACTIONS(1),
    [anon_sym_4_GT_AMP2] = ACTIONS(1),
    [anon_sym_5_GT_AMP2] = ACTIONS(1),
    [anon_sym_6_GT_AMP2] = ACTIONS(1),
    [anon_sym_DASHas] = ACTIONS(1),
    [anon_sym_DASHccontains] = ACTIONS(1),
    [anon_sym_DASHceq] = ACTIONS(1),
    [anon_sym_DASHcge] = ACTIONS(1),
    [anon_sym_DASHcgt] = ACTIONS(1),
    [anon_sym_DASHcle] = ACTIONS(1),
    [anon_sym_DASHclike] = ACTIONS(1),
    [anon_sym_DASHclt] = ACTIONS(1),
    [anon_sym_DASHcmatch] = ACTIONS(1),
    [anon_sym_DASHcne] = ACTIONS(1),
    [anon_sym_DASHcnotcontains] = ACTIONS(1),
    [anon_sym_DASHcnotlike] = ACTIONS(1),
    [anon_sym_DASHcnotmatch] = ACTIONS(1),
    [anon_sym_DASHcontains] = ACTIONS(1),
    [anon_sym_DASHcreplace] = ACTIONS(1),
    [anon_sym_DASHcsplit] = ACTIONS(1),
    [anon_sym_DASHeq] = ACTIONS(1),
    [anon_sym_DASHge] = ACTIONS(1),
    [anon_sym_DASHgt] = ACTIONS(1),
    [anon_sym_DASHicontains] = ACTIONS(1),
    [anon_sym_DASHieq] = ACTIONS(1),
    [anon_sym_DASHige] = ACTIONS(1),
    [anon_sym_DASHigt] = ACTIONS(1),
    [anon_sym_DASHile] = ACTIONS(1),
    [anon_sym_DASHilike] = ACTIONS(1),
    [anon_sym_DASHilt] = ACTIONS(1),
    [anon_sym_DASHimatch] = ACTIONS(1),
    [anon_sym_DASHin] = ACTIONS(1),
    [anon_sym_DASHine] = ACTIONS(1),
    [anon_sym_DASHinotcontains] = ACTIONS(1),
    [anon_sym_DASHinotlike] = ACTIONS(1),
    [anon_sym_DASHinotmatch] = ACTIONS(1),
    [anon_sym_DASHireplace] = ACTIONS(1),
    [anon_sym_DASHis] = ACTIONS(1),
    [anon_sym_DASHisnot] = ACTIONS(1),
    [anon_sym_DASHisplit] = ACTIONS(1),
    [anon_sym_DASHjoin] = ACTIONS(1),
    [anon_sym_DASHle] = ACTIONS(1),
    [anon_sym_DASHlike] = ACTIONS(1),
    [anon_sym_DASHlt] = ACTIONS(1),
    [anon_sym_DASHmatch] = ACTIONS(1),
    [anon_sym_DASHne] = ACTIONS(1),
    [anon_sym_DASHnotcontains] = ACTIONS(1),
    [anon_sym_DASHnotin] = ACTIONS(1),
    [anon_sym_DASHnotlike] = ACTIONS(1),
    [anon_sym_DASHnotmatch] = ACTIONS(1),
    [anon_sym_DASHreplace] = ACTIONS(1),
    [anon_sym_DASHshl] = ACTIONS(1),
    [anon_sym_DASHshr] = ACTIONS(1),
    [anon_sym_DASHsplit] = ACTIONS(1),
    [sym_format_operator] = ACTIONS(1),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(1),
    [anon_sym_DOLLAR_CARET] = ACTIONS(1),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(1),
    [anon_sym_DOLLAR_] = ACTIONS(1),
    [aux_sym_variable_token1] = ACTIONS(1),
    [aux_sym_variable_token2] = ACTIONS(1),
    [sym_braced_variable] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_dynamicparam] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_process] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_DASHregex] = ACTIONS(1),
    [anon_sym_DASHwildcard] = ACTIONS(1),
    [anon_sym_DASHexact] = ACTIONS(1),
    [anon_sym_DASHcasesensitive] = ACTIONS(1),
    [anon_sym_DASHparallel] = ACTIONS(1),
    [anon_sym_DASHfile] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_filter] = ACTIONS(1),
    [anon_sym_workflow] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_exit] = ACTIONS(1),
    [anon_sym_trap] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_data] = ACTIONS(1),
    [anon_sym_DASHsupportedcommand] = ACTIONS(1),
    [anon_sym_parallel] = ACTIONS(1),
    [anon_sym_sequence] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_DOLLAR2] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE] = ACTIONS(1),
    [sym_stop_parsing] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_foreach_DASHobject] = ACTIONS(1),
    [anon_sym_DASH_DASH_PERCENT] = ACTIONS(1),
    [anon_sym_hidden] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASHand] = ACTIONS(1),
    [anon_sym_DASHor] = ACTIONS(1),
    [anon_sym_DASHxor] = ACTIONS(1),
    [anon_sym_DASHband] = ACTIONS(1),
    [anon_sym_DASHbor] = ACTIONS(1),
    [anon_sym_DASHbxor] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_DASHnot] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASHbnot] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_AT_LPAREN] = ACTIONS(1),
    [anon_sym_AT_LBRACE] = ACTIONS(1),
    [anon_sym_DOT2] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym__statement_terminator] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1976),
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_param_block] = STATE(75),
    [sym_statement_list] = STATE(1975),
    [sym__statement] = STATE(73),
    [sym_empty_statement] = STATE(73),
    [sym_if_statement] = STATE(73),
    [sym__labeled_statement] = STATE(73),
    [sym_switch_statement] = STATE(73),
    [sym_foreach_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_do_statement] = STATE(73),
    [sym_function_statement] = STATE(73),
    [sym_flow_control_statement] = STATE(1974),
    [sym_trap_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_data_statement] = STATE(73),
    [sym_inlinescript_statement] = STATE(73),
    [sym_parallel_statement] = STATE(73),
    [sym_sequence_statement] = STATE(73),
    [sym_pipeline] = STATE(1974),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(73),
    [sym_enum_statement] = STATE(73),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1972),
    [sym_attribute] = STATE(1120),
    [aux_sym_statement_list_repeat1] = STATE(73),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(23),
    [anon_sym_param] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_foreach] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_function] = ACTIONS(43),
    [anon_sym_filter] = ACTIONS(43),
    [anon_sym_workflow] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(49),
    [anon_sym_trap] = ACTIONS(51),
    [anon_sym_try] = ACTIONS(53),
    [anon_sym_data] = ACTIONS(55),
    [anon_sym_inlinescript] = ACTIONS(57),
    [anon_sym_parallel] = ACTIONS(59),
    [anon_sym_sequence] = ACTIONS(61),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_enum] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [2] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_unary_expression] = STATE(168),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(6),
    [sym_comment] = ACTIONS(81),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(83),
    [sym_real_literal] = ACTIONS(85),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(87),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(89),
    [sym_verbatim_string_characters] = ACTIONS(91),
    [sym_verbatim_here_string_characters] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_PLUS_EQ] = ACTIONS(95),
    [anon_sym_STAR_EQ] = ACTIONS(95),
    [anon_sym_SLASH_EQ] = ACTIONS(95),
    [anon_sym_PERCENT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_GT] = ACTIONS(95),
    [anon_sym_2_GT] = ACTIONS(97),
    [anon_sym_2_GT_GT] = ACTIONS(95),
    [anon_sym_3_GT] = ACTIONS(97),
    [anon_sym_3_GT_GT] = ACTIONS(95),
    [anon_sym_4_GT] = ACTIONS(97),
    [anon_sym_4_GT_GT] = ACTIONS(95),
    [anon_sym_5_GT] = ACTIONS(97),
    [anon_sym_5_GT_GT] = ACTIONS(95),
    [anon_sym_6_GT] = ACTIONS(97),
    [anon_sym_6_GT_GT] = ACTIONS(95),
    [anon_sym_STAR_GT] = ACTIONS(97),
    [anon_sym_STAR_GT_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_STAR_GT_AMP1] = ACTIONS(95),
    [anon_sym_2_GT_AMP1] = ACTIONS(95),
    [anon_sym_3_GT_AMP1] = ACTIONS(95),
    [anon_sym_4_GT_AMP1] = ACTIONS(95),
    [anon_sym_5_GT_AMP1] = ACTIONS(95),
    [anon_sym_6_GT_AMP1] = ACTIONS(95),
    [anon_sym_STAR_GT_AMP2] = ACTIONS(95),
    [anon_sym_1_GT_AMP2] = ACTIONS(95),
    [anon_sym_3_GT_AMP2] = ACTIONS(95),
    [anon_sym_4_GT_AMP2] = ACTIONS(95),
    [anon_sym_5_GT_AMP2] = ACTIONS(95),
    [anon_sym_6_GT_AMP2] = ACTIONS(95),
    [anon_sym_DASHas] = ACTIONS(95),
    [anon_sym_DASHccontains] = ACTIONS(95),
    [anon_sym_DASHceq] = ACTIONS(95),
    [anon_sym_DASHcge] = ACTIONS(95),
    [anon_sym_DASHcgt] = ACTIONS(95),
    [anon_sym_DASHcle] = ACTIONS(95),
    [anon_sym_DASHclike] = ACTIONS(95),
    [anon_sym_DASHclt] = ACTIONS(95),
    [anon_sym_DASHcmatch] = ACTIONS(95),
    [anon_sym_DASHcne] = ACTIONS(95),
    [anon_sym_DASHcnotcontains] = ACTIONS(95),
    [anon_sym_DASHcnotlike] = ACTIONS(95),
    [anon_sym_DASHcnotmatch] = ACTIONS(95),
    [anon_sym_DASHcontains] = ACTIONS(95),
    [anon_sym_DASHcreplace] = ACTIONS(95),
    [anon_sym_DASHcsplit] = ACTIONS(95),
    [anon_sym_DASHeq] = ACTIONS(95),
    [anon_sym_DASHge] = ACTIONS(95),
    [anon_sym_DASHgt] = ACTIONS(95),
    [anon_sym_DASHicontains] = ACTIONS(95),
    [anon_sym_DASHieq] = ACTIONS(95),
    [anon_sym_DASHige] = ACTIONS(95),
    [anon_sym_DASHigt] = ACTIONS(95),
    [anon_sym_DASHile] = ACTIONS(95),
    [anon_sym_DASHilike] = ACTIONS(95),
    [anon_sym_DASHilt] = ACTIONS(95),
    [anon_sym_DASHimatch] = ACTIONS(95),
    [anon_sym_DASHin] = ACTIONS(97),
    [anon_sym_DASHine] = ACTIONS(95),
    [anon_sym_DASHinotcontains] = ACTIONS(95),
    [anon_sym_DASHinotlike] = ACTIONS(95),
    [anon_sym_DASHinotmatch] = ACTIONS(95),
    [anon_sym_DASHireplace] = ACTIONS(95),
    [anon_sym_DASHis] = ACTIONS(97),
    [anon_sym_DASHisnot] = ACTIONS(95),
    [anon_sym_DASHisplit] = ACTIONS(95),
    [anon_sym_DASHjoin] = ACTIONS(99),
    [anon_sym_DASHle] = ACTIONS(95),
    [anon_sym_DASHlike] = ACTIONS(95),
    [anon_sym_DASHlt] = ACTIONS(95),
    [anon_sym_DASHmatch] = ACTIONS(95),
    [anon_sym_DASHne] = ACTIONS(95),
    [anon_sym_DASHnotcontains] = ACTIONS(95),
    [anon_sym_DASHnotin] = ACTIONS(95),
    [anon_sym_DASHnotlike] = ACTIONS(95),
    [anon_sym_DASHnotmatch] = ACTIONS(95),
    [anon_sym_DASHreplace] = ACTIONS(95),
    [anon_sym_DASHshl] = ACTIONS(95),
    [anon_sym_DASHshr] = ACTIONS(95),
    [anon_sym_DASHsplit] = ACTIONS(99),
    [sym_format_operator] = ACTIONS(95),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(101),
    [anon_sym_DOLLAR_CARET] = ACTIONS(101),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(101),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(101),
    [sym_braced_variable] = ACTIONS(101),
    [anon_sym_param] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(107),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(97),
    [anon_sym_DASHand] = ACTIONS(95),
    [anon_sym_DASHor] = ACTIONS(95),
    [anon_sym_DASHxor] = ACTIONS(95),
    [anon_sym_DASHband] = ACTIONS(95),
    [anon_sym_DASHbor] = ACTIONS(95),
    [anon_sym_DASHbxor] = ACTIONS(95),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_SLASH] = ACTIONS(97),
    [anon_sym_BSLASH] = ACTIONS(95),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_DOT_DOT] = ACTIONS(95),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(99),
    [anon_sym_PLUS_PLUS] = ACTIONS(109),
    [anon_sym_DASH_DASH] = ACTIONS(111),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(113),
    [anon_sym_AT_LPAREN] = ACTIONS(115),
    [anon_sym_AT_LBRACE] = ACTIONS(117),
    [anon_sym_DOT2] = ACTIONS(97),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_DOTforeach] = ACTIONS(95),
    [sym__statement_terminator] = ACTIONS(95),
  },
  [3] = {
    [sym__literal] = STATE(128),
    [sym_integer_literal] = STATE(128),
    [sym_string_literal] = STATE(128),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(128),
    [sym_unary_expression] = STATE(126),
    [sym_expression_with_unary_operator] = STATE(135),
    [sym_pre_increment_expression] = STATE(138),
    [sym_pre_decrement_expression] = STATE(138),
    [sym_cast_expression] = STATE(138),
    [sym__primary_expression] = STATE(128),
    [sym__value] = STATE(128),
    [sym_parenthesized_expression] = STATE(128),
    [sym_sub_expression] = STATE(128),
    [sym_array_expression] = STATE(128),
    [sym_script_block_expression] = STATE(128),
    [sym_hash_literal_expression] = STATE(128),
    [sym_post_increment_expression] = STATE(128),
    [sym_post_decrement_expression] = STATE(128),
    [sym_member_access] = STATE(128),
    [sym_element_access] = STATE(128),
    [sym_invokation_expression] = STATE(128),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(3),
    [sym_comment] = ACTIONS(81),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(83),
    [sym_real_literal] = ACTIONS(119),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(87),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(89),
    [sym_verbatim_string_characters] = ACTIONS(91),
    [sym_verbatim_here_string_characters] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_PLUS_EQ] = ACTIONS(95),
    [anon_sym_STAR_EQ] = ACTIONS(95),
    [anon_sym_SLASH_EQ] = ACTIONS(95),
    [anon_sym_PERCENT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_GT] = ACTIONS(95),
    [anon_sym_2_GT] = ACTIONS(97),
    [anon_sym_2_GT_GT] = ACTIONS(95),
    [anon_sym_3_GT] = ACTIONS(97),
    [anon_sym_3_GT_GT] = ACTIONS(95),
    [anon_sym_4_GT] = ACTIONS(97),
    [anon_sym_4_GT_GT] = ACTIONS(95),
    [anon_sym_5_GT] = ACTIONS(97),
    [anon_sym_5_GT_GT] = ACTIONS(95),
    [anon_sym_6_GT] = ACTIONS(97),
    [anon_sym_6_GT_GT] = ACTIONS(95),
    [anon_sym_STAR_GT] = ACTIONS(97),
    [anon_sym_STAR_GT_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_STAR_GT_AMP1] = ACTIONS(95),
    [anon_sym_2_GT_AMP1] = ACTIONS(95),
    [anon_sym_3_GT_AMP1] = ACTIONS(95),
    [anon_sym_4_GT_AMP1] = ACTIONS(95),
    [anon_sym_5_GT_AMP1] = ACTIONS(95),
    [anon_sym_6_GT_AMP1] = ACTIONS(95),
    [anon_sym_STAR_GT_AMP2] = ACTIONS(95),
    [anon_sym_1_GT_AMP2] = ACTIONS(95),
    [anon_sym_3_GT_AMP2] = ACTIONS(95),
    [anon_sym_4_GT_AMP2] = ACTIONS(95),
    [anon_sym_5_GT_AMP2] = ACTIONS(95),
    [anon_sym_6_GT_AMP2] = ACTIONS(95),
    [anon_sym_DASHas] = ACTIONS(95),
    [anon_sym_DASHccontains] = ACTIONS(95),
    [anon_sym_DASHceq] = ACTIONS(95),
    [anon_sym_DASHcge] = ACTIONS(95),
    [anon_sym_DASHcgt] = ACTIONS(95),
    [anon_sym_DASHcle] = ACTIONS(95),
    [anon_sym_DASHclike] = ACTIONS(95),
    [anon_sym_DASHclt] = ACTIONS(95),
    [anon_sym_DASHcmatch] = ACTIONS(95),
    [anon_sym_DASHcne] = ACTIONS(95),
    [anon_sym_DASHcnotcontains] = ACTIONS(95),
    [anon_sym_DASHcnotlike] = ACTIONS(95),
    [anon_sym_DASHcnotmatch] = ACTIONS(95),
    [anon_sym_DASHcontains] = ACTIONS(95),
    [anon_sym_DASHcreplace] = ACTIONS(95),
    [anon_sym_DASHcsplit] = ACTIONS(95),
    [anon_sym_DASHeq] = ACTIONS(95),
    [anon_sym_DASHge] = ACTIONS(95),
    [anon_sym_DASHgt] = ACTIONS(95),
    [anon_sym_DASHicontains] = ACTIONS(95),
    [anon_sym_DASHieq] = ACTIONS(95),
    [anon_sym_DASHige] = ACTIONS(95),
    [anon_sym_DASHigt] = ACTIONS(95),
    [anon_sym_DASHile] = ACTIONS(95),
    [anon_sym_DASHilike] = ACTIONS(95),
    [anon_sym_DASHilt] = ACTIONS(95),
    [anon_sym_DASHimatch] = ACTIONS(95),
    [anon_sym_DASHin] = ACTIONS(97),
    [anon_sym_DASHine] = ACTIONS(95),
    [anon_sym_DASHinotcontains] = ACTIONS(95),
    [anon_sym_DASHinotlike] = ACTIONS(95),
    [anon_sym_DASHinotmatch] = ACTIONS(95),
    [anon_sym_DASHireplace] = ACTIONS(95),
    [anon_sym_DASHis] = ACTIONS(97),
    [anon_sym_DASHisnot] = ACTIONS(95),
    [anon_sym_DASHisplit] = ACTIONS(95),
    [anon_sym_DASHjoin] = ACTIONS(121),
    [anon_sym_DASHle] = ACTIONS(95),
    [anon_sym_DASHlike] = ACTIONS(95),
    [anon_sym_DASHlt] = ACTIONS(95),
    [anon_sym_DASHmatch] = ACTIONS(95),
    [anon_sym_DASHne] = ACTIONS(95),
    [anon_sym_DASHnotcontains] = ACTIONS(95),
    [anon_sym_DASHnotin] = ACTIONS(95),
    [anon_sym_DASHnotlike] = ACTIONS(95),
    [anon_sym_DASHnotmatch] = ACTIONS(95),
    [anon_sym_DASHreplace] = ACTIONS(95),
    [anon_sym_DASHshl] = ACTIONS(95),
    [anon_sym_DASHshr] = ACTIONS(95),
    [anon_sym_DASHsplit] = ACTIONS(121),
    [sym_format_operator] = ACTIONS(95),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(101),
    [anon_sym_DOLLAR_CARET] = ACTIONS(101),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(101),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(101),
    [sym_braced_variable] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(107),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(97),
    [anon_sym_DASHand] = ACTIONS(95),
    [anon_sym_DASHor] = ACTIONS(95),
    [anon_sym_DASHxor] = ACTIONS(95),
    [anon_sym_DASHband] = ACTIONS(95),
    [anon_sym_DASHbor] = ACTIONS(95),
    [anon_sym_DASHbxor] = ACTIONS(95),
    [anon_sym_PLUS] = ACTIONS(123),
    [anon_sym_DASH] = ACTIONS(123),
    [anon_sym_SLASH] = ACTIONS(97),
    [anon_sym_BSLASH] = ACTIONS(95),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_DOT_DOT] = ACTIONS(95),
    [anon_sym_DASHnot] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(123),
    [anon_sym_DASHbnot] = ACTIONS(121),
    [anon_sym_PLUS_PLUS] = ACTIONS(125),
    [anon_sym_DASH_DASH] = ACTIONS(127),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(113),
    [anon_sym_AT_LPAREN] = ACTIONS(115),
    [anon_sym_AT_LBRACE] = ACTIONS(117),
    [anon_sym_DOT2] = ACTIONS(97),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_DOTforeach] = ACTIONS(95),
    [sym__statement_terminator] = ACTIONS(95),
  },
  [4] = {
    [sym__literal] = STATE(137),
    [sym_integer_literal] = STATE(137),
    [sym_string_literal] = STATE(137),
    [sym_expandable_string_literal] = STATE(116),
    [sym_expandable_here_string_literal] = STATE(116),
    [sym_variable] = STATE(137),
    [sym_unary_expression] = STATE(97),
    [sym_expression_with_unary_operator] = STATE(89),
    [sym_pre_increment_expression] = STATE(100),
    [sym_pre_decrement_expression] = STATE(100),
    [sym_cast_expression] = STATE(100),
    [sym__primary_expression] = STATE(137),
    [sym__value] = STATE(137),
    [sym_parenthesized_expression] = STATE(137),
    [sym_sub_expression] = STATE(137),
    [sym_array_expression] = STATE(137),
    [sym_script_block_expression] = STATE(137),
    [sym_hash_literal_expression] = STATE(137),
    [sym_post_increment_expression] = STATE(137),
    [sym_post_decrement_expression] = STATE(137),
    [sym_member_access] = STATE(137),
    [sym_element_access] = STATE(137),
    [sym_invokation_expression] = STATE(137),
    [sym_invokation_foreach_expression] = STATE(108),
    [sym_type_literal] = STATE(4),
    [sym_comment] = ACTIONS(81),
    [sym_decimal_integer_literal] = ACTIONS(129),
    [sym_hexadecimal_integer_literal] = ACTIONS(131),
    [sym_real_literal] = ACTIONS(133),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(135),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(137),
    [sym_verbatim_string_characters] = ACTIONS(139),
    [sym_verbatim_here_string_characters] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_PLUS_EQ] = ACTIONS(95),
    [anon_sym_STAR_EQ] = ACTIONS(95),
    [anon_sym_SLASH_EQ] = ACTIONS(95),
    [anon_sym_PERCENT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_GT] = ACTIONS(95),
    [anon_sym_2_GT] = ACTIONS(97),
    [anon_sym_2_GT_GT] = ACTIONS(95),
    [anon_sym_3_GT] = ACTIONS(97),
    [anon_sym_3_GT_GT] = ACTIONS(95),
    [anon_sym_4_GT] = ACTIONS(97),
    [anon_sym_4_GT_GT] = ACTIONS(95),
    [anon_sym_5_GT] = ACTIONS(97),
    [anon_sym_5_GT_GT] = ACTIONS(95),
    [anon_sym_6_GT] = ACTIONS(97),
    [anon_sym_6_GT_GT] = ACTIONS(95),
    [anon_sym_STAR_GT] = ACTIONS(97),
    [anon_sym_STAR_GT_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_STAR_GT_AMP1] = ACTIONS(95),
    [anon_sym_2_GT_AMP1] = ACTIONS(95),
    [anon_sym_3_GT_AMP1] = ACTIONS(95),
    [anon_sym_4_GT_AMP1] = ACTIONS(95),
    [anon_sym_5_GT_AMP1] = ACTIONS(95),
    [anon_sym_6_GT_AMP1] = ACTIONS(95),
    [anon_sym_STAR_GT_AMP2] = ACTIONS(95),
    [anon_sym_1_GT_AMP2] = ACTIONS(95),
    [anon_sym_3_GT_AMP2] = ACTIONS(95),
    [anon_sym_4_GT_AMP2] = ACTIONS(95),
    [anon_sym_5_GT_AMP2] = ACTIONS(95),
    [anon_sym_6_GT_AMP2] = ACTIONS(95),
    [anon_sym_DASHas] = ACTIONS(95),
    [anon_sym_DASHccontains] = ACTIONS(95),
    [anon_sym_DASHceq] = ACTIONS(95),
    [anon_sym_DASHcge] = ACTIONS(95),
    [anon_sym_DASHcgt] = ACTIONS(95),
    [anon_sym_DASHcle] = ACTIONS(95),
    [anon_sym_DASHclike] = ACTIONS(95),
    [anon_sym_DASHclt] = ACTIONS(95),
    [anon_sym_DASHcmatch] = ACTIONS(95),
    [anon_sym_DASHcne] = ACTIONS(95),
    [anon_sym_DASHcnotcontains] = ACTIONS(95),
    [anon_sym_DASHcnotlike] = ACTIONS(95),
    [anon_sym_DASHcnotmatch] = ACTIONS(95),
    [anon_sym_DASHcontains] = ACTIONS(95),
    [anon_sym_DASHcreplace] = ACTIONS(95),
    [anon_sym_DASHcsplit] = ACTIONS(95),
    [anon_sym_DASHeq] = ACTIONS(95),
    [anon_sym_DASHge] = ACTIONS(95),
    [anon_sym_DASHgt] = ACTIONS(95),
    [anon_sym_DASHicontains] = ACTIONS(95),
    [anon_sym_DASHieq] = ACTIONS(95),
    [anon_sym_DASHige] = ACTIONS(95),
    [anon_sym_DASHigt] = ACTIONS(95),
    [anon_sym_DASHile] = ACTIONS(95),
    [anon_sym_DASHilike] = ACTIONS(95),
    [anon_sym_DASHilt] = ACTIONS(95),
    [anon_sym_DASHimatch] = ACTIONS(95),
    [anon_sym_DASHin] = ACTIONS(97),
    [anon_sym_DASHine] = ACTIONS(95),
    [anon_sym_DASHinotcontains] = ACTIONS(95),
    [anon_sym_DASHinotlike] = ACTIONS(95),
    [anon_sym_DASHinotmatch] = ACTIONS(95),
    [anon_sym_DASHireplace] = ACTIONS(95),
    [anon_sym_DASHis] = ACTIONS(97),
    [anon_sym_DASHisnot] = ACTIONS(95),
    [anon_sym_DASHisplit] = ACTIONS(95),
    [anon_sym_DASHjoin] = ACTIONS(143),
    [anon_sym_DASHle] = ACTIONS(95),
    [anon_sym_DASHlike] = ACTIONS(95),
    [anon_sym_DASHlt] = ACTIONS(95),
    [anon_sym_DASHmatch] = ACTIONS(95),
    [anon_sym_DASHne] = ACTIONS(95),
    [anon_sym_DASHnotcontains] = ACTIONS(95),
    [anon_sym_DASHnotin] = ACTIONS(95),
    [anon_sym_DASHnotlike] = ACTIONS(95),
    [anon_sym_DASHnotmatch] = ACTIONS(95),
    [anon_sym_DASHreplace] = ACTIONS(95),
    [anon_sym_DASHshl] = ACTIONS(95),
    [anon_sym_DASHshr] = ACTIONS(95),
    [anon_sym_DASHsplit] = ACTIONS(143),
    [sym_format_operator] = ACTIONS(95),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(145),
    [anon_sym_DOLLAR_CARET] = ACTIONS(145),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(145),
    [anon_sym_DOLLAR_] = ACTIONS(147),
    [aux_sym_variable_token1] = ACTIONS(147),
    [aux_sym_variable_token2] = ACTIONS(145),
    [sym_braced_variable] = ACTIONS(145),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(95),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(97),
    [anon_sym_DASHand] = ACTIONS(95),
    [anon_sym_DASHor] = ACTIONS(95),
    [anon_sym_DASHxor] = ACTIONS(95),
    [anon_sym_DASHband] = ACTIONS(95),
    [anon_sym_DASHbor] = ACTIONS(95),
    [anon_sym_DASHbxor] = ACTIONS(95),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(97),
    [anon_sym_BSLASH] = ACTIONS(95),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_DOT_DOT] = ACTIONS(95),
    [anon_sym_DASHnot] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_DASHbnot] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(155),
    [anon_sym_DASH_DASH] = ACTIONS(157),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(159),
    [anon_sym_AT_LPAREN] = ACTIONS(161),
    [anon_sym_AT_LBRACE] = ACTIONS(163),
    [anon_sym_DOT2] = ACTIONS(97),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_DOTforeach] = ACTIONS(95),
  },
  [5] = {
    [sym__literal] = STATE(155),
    [sym_integer_literal] = STATE(155),
    [sym_string_literal] = STATE(155),
    [sym_expandable_string_literal] = STATE(116),
    [sym_expandable_here_string_literal] = STATE(116),
    [sym_variable] = STATE(155),
    [sym_unary_expression] = STATE(159),
    [sym_expression_with_unary_operator] = STATE(163),
    [sym_pre_increment_expression] = STATE(162),
    [sym_pre_decrement_expression] = STATE(162),
    [sym_cast_expression] = STATE(162),
    [sym__primary_expression] = STATE(155),
    [sym__value] = STATE(155),
    [sym_parenthesized_expression] = STATE(155),
    [sym_sub_expression] = STATE(155),
    [sym_array_expression] = STATE(155),
    [sym_script_block_expression] = STATE(155),
    [sym_hash_literal_expression] = STATE(155),
    [sym_post_increment_expression] = STATE(155),
    [sym_post_decrement_expression] = STATE(155),
    [sym_member_access] = STATE(155),
    [sym_element_access] = STATE(155),
    [sym_invokation_expression] = STATE(155),
    [sym_invokation_foreach_expression] = STATE(108),
    [sym_type_literal] = STATE(5),
    [sym_comment] = ACTIONS(81),
    [sym_decimal_integer_literal] = ACTIONS(129),
    [sym_hexadecimal_integer_literal] = ACTIONS(131),
    [sym_real_literal] = ACTIONS(165),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(135),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(137),
    [sym_verbatim_string_characters] = ACTIONS(139),
    [sym_verbatim_here_string_characters] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(141),
    [anon_sym_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_PLUS_EQ] = ACTIONS(95),
    [anon_sym_STAR_EQ] = ACTIONS(95),
    [anon_sym_SLASH_EQ] = ACTIONS(95),
    [anon_sym_PERCENT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_GT] = ACTIONS(95),
    [anon_sym_2_GT] = ACTIONS(97),
    [anon_sym_2_GT_GT] = ACTIONS(95),
    [anon_sym_3_GT] = ACTIONS(97),
    [anon_sym_3_GT_GT] = ACTIONS(95),
    [anon_sym_4_GT] = ACTIONS(97),
    [anon_sym_4_GT_GT] = ACTIONS(95),
    [anon_sym_5_GT] = ACTIONS(97),
    [anon_sym_5_GT_GT] = ACTIONS(95),
    [anon_sym_6_GT] = ACTIONS(97),
    [anon_sym_6_GT_GT] = ACTIONS(95),
    [anon_sym_STAR_GT] = ACTIONS(97),
    [anon_sym_STAR_GT_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_STAR_GT_AMP1] = ACTIONS(95),
    [anon_sym_2_GT_AMP1] = ACTIONS(95),
    [anon_sym_3_GT_AMP1] = ACTIONS(95),
    [anon_sym_4_GT_AMP1] = ACTIONS(95),
    [anon_sym_5_GT_AMP1] = ACTIONS(95),
    [anon_sym_6_GT_AMP1] = ACTIONS(95),
    [anon_sym_STAR_GT_AMP2] = ACTIONS(95),
    [anon_sym_1_GT_AMP2] = ACTIONS(95),
    [anon_sym_3_GT_AMP2] = ACTIONS(95),
    [anon_sym_4_GT_AMP2] = ACTIONS(95),
    [anon_sym_5_GT_AMP2] = ACTIONS(95),
    [anon_sym_6_GT_AMP2] = ACTIONS(95),
    [anon_sym_DASHas] = ACTIONS(95),
    [anon_sym_DASHccontains] = ACTIONS(95),
    [anon_sym_DASHceq] = ACTIONS(95),
    [anon_sym_DASHcge] = ACTIONS(95),
    [anon_sym_DASHcgt] = ACTIONS(95),
    [anon_sym_DASHcle] = ACTIONS(95),
    [anon_sym_DASHclike] = ACTIONS(95),
    [anon_sym_DASHclt] = ACTIONS(95),
    [anon_sym_DASHcmatch] = ACTIONS(95),
    [anon_sym_DASHcne] = ACTIONS(95),
    [anon_sym_DASHcnotcontains] = ACTIONS(95),
    [anon_sym_DASHcnotlike] = ACTIONS(95),
    [anon_sym_DASHcnotmatch] = ACTIONS(95),
    [anon_sym_DASHcontains] = ACTIONS(95),
    [anon_sym_DASHcreplace] = ACTIONS(95),
    [anon_sym_DASHcsplit] = ACTIONS(95),
    [anon_sym_DASHeq] = ACTIONS(95),
    [anon_sym_DASHge] = ACTIONS(95),
    [anon_sym_DASHgt] = ACTIONS(95),
    [anon_sym_DASHicontains] = ACTIONS(95),
    [anon_sym_DASHieq] = ACTIONS(95),
    [anon_sym_DASHige] = ACTIONS(95),
    [anon_sym_DASHigt] = ACTIONS(95),
    [anon_sym_DASHile] = ACTIONS(95),
    [anon_sym_DASHilike] = ACTIONS(95),
    [anon_sym_DASHilt] = ACTIONS(95),
    [anon_sym_DASHimatch] = ACTIONS(95),
    [anon_sym_DASHin] = ACTIONS(97),
    [anon_sym_DASHine] = ACTIONS(95),
    [anon_sym_DASHinotcontains] = ACTIONS(95),
    [anon_sym_DASHinotlike] = ACTIONS(95),
    [anon_sym_DASHinotmatch] = ACTIONS(95),
    [anon_sym_DASHireplace] = ACTIONS(95),
    [anon_sym_DASHis] = ACTIONS(97),
    [anon_sym_DASHisnot] = ACTIONS(95),
    [anon_sym_DASHisplit] = ACTIONS(95),
    [anon_sym_DASHjoin] = ACTIONS(167),
    [anon_sym_DASHle] = ACTIONS(95),
    [anon_sym_DASHlike] = ACTIONS(95),
    [anon_sym_DASHlt] = ACTIONS(95),
    [anon_sym_DASHmatch] = ACTIONS(95),
    [anon_sym_DASHne] = ACTIONS(95),
    [anon_sym_DASHnotcontains] = ACTIONS(95),
    [anon_sym_DASHnotin] = ACTIONS(95),
    [anon_sym_DASHnotlike] = ACTIONS(95),
    [anon_sym_DASHnotmatch] = ACTIONS(95),
    [anon_sym_DASHreplace] = ACTIONS(95),
    [anon_sym_DASHshl] = ACTIONS(95),
    [anon_sym_DASHshr] = ACTIONS(95),
    [anon_sym_DASHsplit] = ACTIONS(167),
    [sym_format_operator] = ACTIONS(95),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(145),
    [anon_sym_DOLLAR_CARET] = ACTIONS(145),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(145),
    [anon_sym_DOLLAR_] = ACTIONS(147),
    [aux_sym_variable_token1] = ACTIONS(147),
    [aux_sym_variable_token2] = ACTIONS(145),
    [sym_braced_variable] = ACTIONS(145),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(95),
    [anon_sym_COMMA] = ACTIONS(167),
    [anon_sym_LBRACE] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(97),
    [anon_sym_DASHand] = ACTIONS(95),
    [anon_sym_DASHor] = ACTIONS(95),
    [anon_sym_DASHxor] = ACTIONS(95),
    [anon_sym_DASHband] = ACTIONS(95),
    [anon_sym_DASHbor] = ACTIONS(95),
    [anon_sym_DASHbxor] = ACTIONS(95),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_SLASH] = ACTIONS(97),
    [anon_sym_BSLASH] = ACTIONS(95),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_DOT_DOT] = ACTIONS(95),
    [anon_sym_DASHnot] = ACTIONS(169),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_DASHbnot] = ACTIONS(167),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(173),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(159),
    [anon_sym_AT_LPAREN] = ACTIONS(161),
    [anon_sym_AT_LBRACE] = ACTIONS(163),
    [anon_sym_DOT2] = ACTIONS(97),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_DOTforeach] = ACTIONS(95),
  },
  [6] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_unary_expression] = STATE(168),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(6),
    [sym_comment] = ACTIONS(81),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(83),
    [sym_real_literal] = ACTIONS(85),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(87),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(89),
    [sym_verbatim_string_characters] = ACTIONS(91),
    [sym_verbatim_here_string_characters] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_EQ] = ACTIONS(95),
    [anon_sym_BANG_EQ] = ACTIONS(95),
    [anon_sym_PLUS_EQ] = ACTIONS(95),
    [anon_sym_STAR_EQ] = ACTIONS(95),
    [anon_sym_SLASH_EQ] = ACTIONS(95),
    [anon_sym_PERCENT_EQ] = ACTIONS(95),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_GT] = ACTIONS(95),
    [anon_sym_2_GT] = ACTIONS(97),
    [anon_sym_2_GT_GT] = ACTIONS(95),
    [anon_sym_3_GT] = ACTIONS(97),
    [anon_sym_3_GT_GT] = ACTIONS(95),
    [anon_sym_4_GT] = ACTIONS(97),
    [anon_sym_4_GT_GT] = ACTIONS(95),
    [anon_sym_5_GT] = ACTIONS(97),
    [anon_sym_5_GT_GT] = ACTIONS(95),
    [anon_sym_6_GT] = ACTIONS(97),
    [anon_sym_6_GT_GT] = ACTIONS(95),
    [anon_sym_STAR_GT] = ACTIONS(97),
    [anon_sym_STAR_GT_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_STAR_GT_AMP1] = ACTIONS(95),
    [anon_sym_2_GT_AMP1] = ACTIONS(95),
    [anon_sym_3_GT_AMP1] = ACTIONS(95),
    [anon_sym_4_GT_AMP1] = ACTIONS(95),
    [anon_sym_5_GT_AMP1] = ACTIONS(95),
    [anon_sym_6_GT_AMP1] = ACTIONS(95),
    [anon_sym_STAR_GT_AMP2] = ACTIONS(95),
    [anon_sym_1_GT_AMP2] = ACTIONS(95),
    [anon_sym_3_GT_AMP2] = ACTIONS(95),
    [anon_sym_4_GT_AMP2] = ACTIONS(95),
    [anon_sym_5_GT_AMP2] = ACTIONS(95),
    [anon_sym_6_GT_AMP2] = ACTIONS(95),
    [anon_sym_DASHas] = ACTIONS(95),
    [anon_sym_DASHccontains] = ACTIONS(95),
    [anon_sym_DASHceq] = ACTIONS(95),
    [anon_sym_DASHcge] = ACTIONS(95),
    [anon_sym_DASHcgt] = ACTIONS(95),
    [anon_sym_DASHcle] = ACTIONS(95),
    [anon_sym_DASHclike] = ACTIONS(95),
    [anon_sym_DASHclt] = ACTIONS(95),
    [anon_sym_DASHcmatch] = ACTIONS(95),
    [anon_sym_DASHcne] = ACTIONS(95),
    [anon_sym_DASHcnotcontains] = ACTIONS(95),
    [anon_sym_DASHcnotlike] = ACTIONS(95),
    [anon_sym_DASHcnotmatch] = ACTIONS(95),
    [anon_sym_DASHcontains] = ACTIONS(95),
    [anon_sym_DASHcreplace] = ACTIONS(95),
    [anon_sym_DASHcsplit] = ACTIONS(95),
    [anon_sym_DASHeq] = ACTIONS(95),
    [anon_sym_DASHge] = ACTIONS(95),
    [anon_sym_DASHgt] = ACTIONS(95),
    [anon_sym_DASHicontains] = ACTIONS(95),
    [anon_sym_DASHieq] = ACTIONS(95),
    [anon_sym_DASHige] = ACTIONS(95),
    [anon_sym_DASHigt] = ACTIONS(95),
    [anon_sym_DASHile] = ACTIONS(95),
    [anon_sym_DASHilike] = ACTIONS(95),
    [anon_sym_DASHilt] = ACTIONS(95),
    [anon_sym_DASHimatch] = ACTIONS(95),
    [anon_sym_DASHin] = ACTIONS(97),
    [anon_sym_DASHine] = ACTIONS(95),
    [anon_sym_DASHinotcontains] = ACTIONS(95),
    [anon_sym_DASHinotlike] = ACTIONS(95),
    [anon_sym_DASHinotmatch] = ACTIONS(95),
    [anon_sym_DASHireplace] = ACTIONS(95),
    [anon_sym_DASHis] = ACTIONS(97),
    [anon_sym_DASHisnot] = ACTIONS(95),
    [anon_sym_DASHisplit] = ACTIONS(95),
    [anon_sym_DASHjoin] = ACTIONS(99),
    [anon_sym_DASHle] = ACTIONS(95),
    [anon_sym_DASHlike] = ACTIONS(95),
    [anon_sym_DASHlt] = ACTIONS(95),
    [anon_sym_DASHmatch] = ACTIONS(95),
    [anon_sym_DASHne] = ACTIONS(95),
    [anon_sym_DASHnotcontains] = ACTIONS(95),
    [anon_sym_DASHnotin] = ACTIONS(95),
    [anon_sym_DASHnotlike] = ACTIONS(95),
    [anon_sym_DASHnotmatch] = ACTIONS(95),
    [anon_sym_DASHreplace] = ACTIONS(95),
    [anon_sym_DASHshl] = ACTIONS(95),
    [anon_sym_DASHshr] = ACTIONS(95),
    [anon_sym_DASHsplit] = ACTIONS(99),
    [sym_format_operator] = ACTIONS(95),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(101),
    [anon_sym_DOLLAR_CARET] = ACTIONS(101),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(101),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(101),
    [sym_braced_variable] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LBRACE] = ACTIONS(107),
    [anon_sym_PIPE] = ACTIONS(95),
    [anon_sym_PERCENT] = ACTIONS(97),
    [anon_sym_DASHand] = ACTIONS(95),
    [anon_sym_DASHor] = ACTIONS(95),
    [anon_sym_DASHxor] = ACTIONS(95),
    [anon_sym_DASHband] = ACTIONS(95),
    [anon_sym_DASHbor] = ACTIONS(95),
    [anon_sym_DASHbxor] = ACTIONS(95),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_SLASH] = ACTIONS(97),
    [anon_sym_BSLASH] = ACTIONS(95),
    [anon_sym_STAR] = ACTIONS(97),
    [anon_sym_DOT_DOT] = ACTIONS(95),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(99),
    [anon_sym_PLUS_PLUS] = ACTIONS(109),
    [anon_sym_DASH_DASH] = ACTIONS(111),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(113),
    [anon_sym_AT_LPAREN] = ACTIONS(115),
    [anon_sym_AT_LBRACE] = ACTIONS(117),
    [anon_sym_DOT2] = ACTIONS(97),
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_DOTforeach] = ACTIONS(95),
    [sym__statement_terminator] = ACTIONS(95),
  },
  [7] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1801),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [8] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1793),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(215),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [9] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1860),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(217),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [10] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1593),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [11] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1607),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [12] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1584),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [13] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1899),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [14] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1662),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [15] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1717),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [16] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1587),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [17] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1712),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [18] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1603),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [19] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1612),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [20] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1583),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(231),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [21] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1789),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(233),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [22] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1573),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [23] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1704),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [24] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1683),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [25] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1796),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(235),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [26] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1840),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(237),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [27] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1638),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [28] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1591),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
    [sym__statement_terminator] = ACTIONS(225),
  },
  [29] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1794),
    [sym_param_block] = STATE(1898),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1919),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [30] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1710),
    [sym_param_block] = STATE(17),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [31] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1697),
    [sym_param_block] = STATE(23),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [32] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1617),
    [sym_param_block] = STATE(19),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [33] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1630),
    [sym_param_block] = STATE(27),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [34] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1960),
    [sym_param_block] = STATE(13),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [35] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1715),
    [sym_param_block] = STATE(15),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [36] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1579),
    [sym_param_block] = STATE(22),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [37] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1599),
    [sym_param_block] = STATE(28),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [38] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1676),
    [sym_param_block] = STATE(24),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [39] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block] = STATE(1655),
    [sym_param_block] = STATE(14),
    [sym_script_block_body] = STATE(1954),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_statement] = STATE(69),
    [sym_flow_control_statement] = STATE(1601),
    [sym_trap_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_data_statement] = STATE(69),
    [sym_inlinescript_statement] = STATE(69),
    [sym_parallel_statement] = STATE(69),
    [sym_sequence_statement] = STATE(69),
    [sym_pipeline] = STATE(1601),
    [sym_left_assignment_expression] = STATE(1169),
    [sym_assignment_expression] = STATE(1973),
    [sym_command] = STATE(1197),
    [sym_command_invokation_operator] = STATE(888),
    [sym_command_name] = STATE(206),
    [sym_foreach_command] = STATE(1318),
    [sym_class_statement] = STATE(69),
    [sym_enum_statement] = STATE(69),
    [sym__expression] = STATE(895),
    [sym_logical_expression] = STATE(935),
    [sym_bitwise_expression] = STATE(896),
    [sym_comparison_expression] = STATE(199),
    [sym_additive_expression] = STATE(194),
    [sym_multiplicative_expression] = STATE(187),
    [sym_format_expression] = STATE(184),
    [sym_range_expression] = STATE(180),
    [sym_array_literal_expression] = STATE(167),
    [sym_unary_expression] = STATE(165),
    [sym_expression_with_unary_operator] = STATE(171),
    [sym_pre_increment_expression] = STATE(172),
    [sym_pre_decrement_expression] = STATE(172),
    [sym_cast_expression] = STATE(172),
    [sym__primary_expression] = STATE(156),
    [sym__value] = STATE(156),
    [sym_parenthesized_expression] = STATE(156),
    [sym_sub_expression] = STATE(156),
    [sym_array_expression] = STATE(156),
    [sym_script_block_expression] = STATE(156),
    [sym_hash_literal_expression] = STATE(156),
    [sym_post_increment_expression] = STATE(156),
    [sym_post_decrement_expression] = STATE(156),
    [sym_member_access] = STATE(156),
    [sym_element_access] = STATE(156),
    [sym_invokation_expression] = STATE(156),
    [sym_invokation_foreach_expression] = STATE(147),
    [sym_type_literal] = STATE(2),
    [sym_attribute_list] = STATE(1896),
    [sym_attribute] = STATE(1120),
    [aux_sym_named_block_list_repeat1] = STATE(1157),
    [aux_sym_statement_list_repeat1] = STATE(69),
    [aux_sym_attribute_list_repeat1] = STATE(1120),
    [sym_comment] = ACTIONS(3),
    [sym_decimal_integer_literal] = ACTIONS(5),
    [sym_hexadecimal_integer_literal] = ACTIONS(5),
    [sym_real_literal] = ACTIONS(7),
    [aux_sym_expandable_string_literal_token1] = ACTIONS(9),
    [aux_sym_expandable_here_string_literal_token1] = ACTIONS(11),
    [sym_verbatim_string_characters] = ACTIONS(13),
    [sym_verbatim_here_string_characters] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_DASHjoin] = ACTIONS(19),
    [anon_sym_DASHsplit] = ACTIONS(19),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(21),
    [anon_sym_DOLLAR_CARET] = ACTIONS(21),
    [anon_sym_DOLLAR_QMARK] = ACTIONS(21),
    [anon_sym_DOLLAR_] = ACTIONS(21),
    [aux_sym_variable_token1] = ACTIONS(21),
    [aux_sym_variable_token2] = ACTIONS(21),
    [sym_braced_variable] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(175),
    [anon_sym_param] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_COMMA] = ACTIONS(19),
    [anon_sym_dynamicparam] = ACTIONS(179),
    [anon_sym_begin] = ACTIONS(179),
    [anon_sym_process] = ACTIONS(179),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(185),
    [anon_sym_foreach] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_while] = ACTIONS(191),
    [anon_sym_do] = ACTIONS(193),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_filter] = ACTIONS(195),
    [anon_sym_workflow] = ACTIONS(195),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(47),
    [anon_sym_exit] = ACTIONS(47),
    [sym_label] = ACTIONS(197),
    [anon_sym_trap] = ACTIONS(199),
    [anon_sym_try] = ACTIONS(201),
    [anon_sym_data] = ACTIONS(203),
    [anon_sym_inlinescript] = ACTIONS(205),
    [anon_sym_parallel] = ACTIONS(207),
    [anon_sym_sequence] = ACTIONS(209),
    [anon_sym_AMP] = ACTIONS(15),
    [aux_sym_command_name_token1] = ACTIONS(63),
    [anon_sym_PERCENT] = ACTIONS(65),
    [anon_sym_foreach_DASHobject] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(211),
    [anon_sym_enum] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_DASHnot] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_DASHbnot] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(75),
    [anon_sym_AT_LPAREN] = ACTIONS(77),
    [anon_sym_AT_LBRACE] = ACTIONS(79),
  },
  [40] = {
    [sym__literal] = STATE(156),
    [sym_integer_literal] = STATE(156),
    [sym_string_literal] = STATE(156),
    [sym_expandable_string_literal] = STATE(151),
    [sym_expandable_here_string_literal] = STATE(151),
    [sym_variable] = STATE(156),
    [sym_script_block_body] = STATE(1875),
    [sym_named_block_list] = STATE(1948),
    [sym_named_block] = STATE(1157),
    [sym_block_name] = STATE(1418),
    [sym_statement_list] = STATE(1945),
    [sym__statement] = STATE(69),
    [sym_empty_statement] = STATE(69),
    [sym_if_statement] = STATE(69),
    [sym__labeled_statement] = STATE(69),
    [sym_switch_statement] = STATE(69),
    [sym_foreach_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_do_statement] = STATE(69),
    [sym_function_