#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 579
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 116
#define ALIAS_COUNT 0
#define TOKEN_COUNT 66
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 30
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 38

enum {
  sym_keyword = 1,
  anon_sym_module = 2,
  anon_sym_SEMI = 3,
  anon_sym_import = 4,
  anon_sym_as = 5,
  anon_sym_include = 6,
  anon_sym_def = 7,
  anon_sym_COLON = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_PIPE = 11,
  anon_sym_reduce = 12,
  anon_sym_foreach = 13,
  anon_sym_if = 14,
  anon_sym_then = 15,
  anon_sym_end = 16,
  anon_sym_try = 17,
  anon_sym_label = 18,
  anon_sym_QMARK = 19,
  anon_sym_COMMA = 20,
  anon_sym_SLASH_SLASH = 21,
  anon_sym_or = 22,
  anon_sym_and = 23,
  anon_sym_QMARK_SLASH_SLASH = 24,
  anon_sym_LBRACK = 25,
  anon_sym_RBRACK = 26,
  anon_sym_LBRACE = 27,
  anon_sym_RBRACE = 28,
  anon_sym_DOT = 29,
  anon_sym_DOT_DOT = 30,
  anon_sym_null = 31,
  anon_sym_true = 32,
  anon_sym_false = 33,
  anon_sym_PLUS = 34,
  anon_sym_DASH = 35,
  anon_sym_break = 36,
  anon_sym_elif = 37,
  anon_sym_else = 38,
  anon_sym_catch = 39,
  aux_sym_identifier_token1 = 40,
  sym_variable = 41,
  anon_sym_STAR = 42,
  anon_sym_SLASH = 43,
  anon_sym_PERCENT = 44,
  anon_sym_PIPE_EQ = 45,
  anon_sym_PLUS_EQ = 46,
  anon_sym_DASH_EQ = 47,
  anon_sym_STAR_EQ = 48,
  anon_sym_SLASH_EQ = 49,
  anon_sym_SLASH_SLASH_EQ = 50,
  anon_sym_PERCENT_EQ = 51,
  anon_sym_EQ = 52,
  anon_sym_EQ_EQ = 53,
  anon_sym_BANG_EQ = 54,
  anon_sym_GT_EQ = 55,
  anon_sym_LT_EQ = 56,
  anon_sym_GT = 57,
  anon_sym_LT = 58,
  sym_format = 59,
  sym_number = 60,
  anon_sym_DQUOTE = 61,
  anon_sym_BSLASH_LPAREN = 62,
  aux_sym__string_content_token1 = 63,
  sym__escape_sequence = 64,
  sym_comment = 65,
  sym_program = 66,
  sym_moduleheader = 67,
  sym_programbody = 68,
  sym_import_ = 69,
  sym_funcdef = 70,
  sym_funcdefargs = 71,
  sym__tokIdentVariable = 72,
  sym_query = 73,
  sym_binding = 74,
  sym__bindpatterns = 75,
  sym__pattern = 76,
  sym_arraypatterns = 77,
  sym_objectpatterns = 78,
  sym_objectpattern = 79,
  sym__term = 80,
  sym_funcname = 81,
  sym_suffix = 82,
  sym_args = 83,
  sym_elif = 84,
  sym_else = 85,
  sym_catch = 86,
  sym_objectkeyvals = 87,
  sym_objectkeyval = 88,
  sym_objectkey = 89,
  sym_objectval = 90,
  sym_constterm = 91,
  sym_constobject = 92,
  sym_constobjectkeyval = 93,
  sym_constarray = 94,
  sym_string = 95,
  sym_identifier = 96,
  sym__tokMathLow = 97,
  sym__tokMathHigh = 98,
  sym__tokUpdateOp = 99,
  sym__tokCompareOp = 100,
  sym_index = 101,
  sym__QQSTRING = 102,
  aux_sym__inner_string = 103,
  aux_sym__string_content = 104,
  sym__IDENT = 105,
  aux_sym_programbody_repeat1 = 106,
  aux_sym_programbody_repeat2 = 107,
  aux_sym_funcdefargs_repeat1 = 108,
  aux_sym_query_repeat1 = 109,
  aux_sym__bindpatterns_repeat1 = 110,
  aux_sym_arraypatterns_repeat1 = 111,
  aux_sym_objectpatterns_repeat1 = 112,
  aux_sym_objectval_repeat1 = 113,
  aux_sym_constobject_repeat1 = 114,
  aux_sym_constarray_repeat1 = 115,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [anon_sym_module] = "module",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_as] = "as",
  [anon_sym_include] = "include",
  [anon_sym_def] = "def",
  [anon_sym_COLON] = ":",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PIPE] = "|",
  [anon_sym_reduce] = "reduce",
  [anon_sym_foreach] = "foreach",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_end] = "end",
  [anon_sym_try] = "try",
  [anon_sym_label] = "label",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COMMA] = ",",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_QMARK_SLASH_SLASH] = "\?//",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_DOT] = "recurse",
  [anon_sym_null] = "null",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_break] = "break",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_catch] = "catch",
  [aux_sym_identifier_token1] = "identifier_token1",
  [sym_variable] = "variable",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_EQ] = "=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [sym_format] = "format",
  [sym_number] = "number",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [aux_sym__string_content_token1] = "_string_content_token1",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_comment] = "comment",
  [sym_program] = "program",
  [sym_moduleheader] = "moduleheader",
  [sym_programbody] = "programbody",
  [sym_import_] = "import_",
  [sym_funcdef] = "funcdef",
  [sym_funcdefargs] = "funcdefargs",
  [sym__tokIdentVariable] = "_tokIdentVariable",
  [sym_query] = "query",
  [sym_binding] = "binding",
  [sym__bindpatterns] = "_bindpatterns",
  [sym__pattern] = "_pattern",
  [sym_arraypatterns] = "arraypatterns",
  [sym_objectpatterns] = "objectpatterns",
  [sym_objectpattern] = "objectpattern",
  [sym__term] = "_term",
  [sym_funcname] = "funcname",
  [sym_suffix] = "suffix",
  [sym_args] = "args",
  [sym_elif] = "elif",
  [sym_else] = "else",
  [sym_catch] = "catch",
  [sym_objectkeyvals] = "objectkeyvals",
  [sym_objectkeyval] = "objectkeyval",
  [sym_objectkey] = "objectkey",
  [sym_objectval] = "objectval",
  [sym_constterm] = "constterm",
  [sym_constobject] = "constobject",
  [sym_constobjectkeyval] = "constobjectkeyval",
  [sym_constarray] = "constarray",
  [sym_string] = "string",
  [sym_identifier] = "identifier",
  [sym__tokMathLow] = "_tokMathLow",
  [sym__tokMathHigh] = "_tokMathHigh",
  [sym__tokUpdateOp] = "_tokUpdateOp",
  [sym__tokCompareOp] = "_tokCompareOp",
  [sym_index] = "index",
  [sym__QQSTRING] = "_QQSTRING",
  [aux_sym__inner_string] = "_inner_string",
  [aux_sym__string_content] = "_string_content",
  [sym__IDENT] = "_IDENT",
  [aux_sym_programbody_repeat1] = "programbody_repeat1",
  [aux_sym_programbody_repeat2] = "programbody_repeat2",
  [aux_sym_funcdefargs_repeat1] = "funcdefargs_repeat1",
  [aux_sym_query_repeat1] = "query_repeat1",
  [aux_sym__bindpatterns_repeat1] = "_bindpatterns_repeat1",
  [aux_sym_arraypatterns_repeat1] = "arraypatterns_repeat1",
  [aux_sym_objectpatterns_repeat1] = "objectpatterns_repeat1",
  [aux_sym_objectval_repeat1] = "objectval_repeat1",
  [aux_sym_constobject_repeat1] = "constobject_repeat1",
  [aux_sym_constarray_repeat1] = "constarray_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_reduce] = anon_sym_reduce,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_label] = anon_sym_label,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_QMARK_SLASH_SLASH] = anon_sym_QMARK_SLASH_SLASH,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_catch] = anon_sym_catch,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [sym_variable] = sym_variable,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [sym_format] = sym_format,
  [sym_number] = sym_number,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [aux_sym__string_content_token1] = aux_sym__string_content_token1,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_comment] = sym_comment,
  [sym_program] = sym_program,
  [sym_moduleheader] = sym_moduleheader,
  [sym_programbody] = sym_programbody,
  [sym_import_] = sym_import_,
  [sym_funcdef] = sym_funcdef,
  [sym_funcdefargs] = sym_funcdefargs,
  [sym__tokIdentVariable] = sym__tokIdentVariable,
  [sym_query] = sym_query,
  [sym_binding] = sym_binding,
  [sym__bindpatterns] = sym__bindpatterns,
  [sym__pattern] = sym__pattern,
  [sym_arraypatterns] = sym_arraypatterns,
  [sym_objectpatterns] = sym_objectpatterns,
  [sym_objectpattern] = sym_objectpattern,
  [sym__term] = sym__term,
  [sym_funcname] = sym_funcname,
  [sym_suffix] = sym_suffix,
  [sym_args] = sym_args,
  [sym_elif] = sym_elif,
  [sym_else] = sym_else,
  [sym_catch] = sym_catch,
  [sym_objectkeyvals] = sym_objectkeyvals,
  [sym_objectkeyval] = sym_objectkeyval,
  [sym_objectkey] = sym_objectkey,
  [sym_objectval] = sym_objectval,
  [sym_constterm] = sym_constterm,
  [sym_constobject] = sym_constobject,
  [sym_constobjectkeyval] = sym_constobjectkeyval,
  [sym_constarray] = sym_constarray,
  [sym_string] = sym_string,
  [sym_identifier] = sym_identifier,
  [sym__tokMathLow] = sym__tokMathLow,
  [sym__tokMathHigh] = sym__tokMathHigh,
  [sym__tokUpdateOp] = sym__tokUpdateOp,
  [sym__tokCompareOp] = sym__tokCompareOp,
  [sym_index] = sym_index,
  [sym__QQSTRING] = sym__QQSTRING,
  [aux_sym__inner_string] = aux_sym__inner_string,
  [aux_sym__string_content] = aux_sym__string_content,
  [sym__IDENT] = sym__IDENT,
  [aux_sym_programbody_repeat1] = aux_sym_programbody_repeat1,
  [aux_sym_programbody_repeat2] = aux_sym_programbody_repeat2,
  [aux_sym_funcdefargs_repeat1] = aux_sym_funcdefargs_repeat1,
  [aux_sym_query_repeat1] = aux_sym_query_repeat1,
  [aux_sym__bindpatterns_repeat1] = aux_sym__bindpatterns_repeat1,
  [aux_sym_arraypatterns_repeat1] = aux_sym_arraypatterns_repeat1,
  [aux_sym_objectpatterns_repeat1] = aux_sym_objectpatterns_repeat1,
  [aux_sym_objectval_repeat1] = aux_sym_objectval_repeat1,
  [aux_sym_constobject_repeat1] = aux_sym_constobject_repeat1,
  [aux_sym_constarray_repeat1] = aux_sym_constarray_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reduce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_label] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_format] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleheader] = {
    .visible = true,
    .named = true,
  },
  [sym_programbody] = {
    .visible = true,
    .named = true,
  },
  [sym_import_] = {
    .visible = true,
    .named = true,
  },
  [sym_funcdef] = {
    .visible = true,
    .named = true,
  },
  [sym_funcdefargs] = {
    .visible = true,
    .named = true,
  },
  [sym__tokIdentVariable] = {
    .visible = false,
    .named = true,
  },
  [sym_query] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym__bindpatterns] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_arraypatterns] = {
    .visible = true,
    .named = true,
  },
  [sym_objectpatterns] = {
    .visible = true,
    .named = true,
  },
  [sym_objectpattern] = {
    .visible = true,
    .named = true,
  },
  [sym__term] = {
    .visible = false,
    .named = true,
  },
  [sym_funcname] = {
    .visible = true,
    .named = true,
  },
  [sym_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_args] = {
    .visible = true,
    .named = true,
  },
  [sym_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_catch] = {
    .visible = true,
    .named = true,
  },
  [sym_objectkeyvals] = {
    .visible = true,
    .named = true,
  },
  [sym_objectkeyval] = {
    .visible = true,
    .named = true,
  },
  [sym_objectkey] = {
    .visible = true,
    .named = true,
  },
  [sym_objectval] = {
    .visible = true,
    .named = true,
  },
  [sym_constterm] = {
    .visible = true,
    .named = true,
  },
  [sym_constobject] = {
    .visible = true,
    .named = true,
  },
  [sym_constobjectkeyval] = {
    .visible = true,
    .named = true,
  },
  [sym_constarray] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__tokMathLow] = {
    .visible = false,
    .named = true,
  },
  [sym__tokMathHigh] = {
    .visible = false,
    .named = true,
  },
  [sym__tokUpdateOp] = {
    .visible = false,
    .named = true,
  },
  [sym__tokCompareOp] = {
    .visible = false,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym__QQSTRING] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inner_string] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_content] = {
    .visible = false,
    .named = false,
  },
  [sym__IDENT] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_programbody_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_programbody_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_funcdefargs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_query_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bindpatterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arraypatterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_objectpatterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_objectval_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constobject_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constarray_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_array = 2,
  field_array_access = 3,
  field_boolean_and = 4,
  field_boolean_or = 5,
  field_break_statement = 6,
  field_chained_binding = 7,
  field_chained_query = 8,
  field_comma_sep_query = 9,
  field_compare = 10,
  field_empty_array = 11,
  field_empty_object = 12,
  field_foreach_1 = 13,
  field_foreach_2 = 14,
  field_function = 15,
  field_if_statement = 16,
  field_label = 17,
  field_math = 18,
  field_object = 19,
  field_object_2 = 20,
  field_object_param = 21,
  field_optional = 22,
  field_query_within_parens = 23,
  field_reduce = 24,
  field_term = 25,
  field_term_with_object_access = 26,
  field_try_catch = 27,
  field_unary_minus = 28,
  field_unary_plus = 29,
  field_update = 30,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_array] = "array",
  [field_array_access] = "array_access",
  [field_boolean_and] = "boolean_and",
  [field_boolean_or] = "boolean_or",
  [field_break_statement] = "break_statement",
  [field_chained_binding] = "chained_binding",
  [field_chained_query] = "chained_query",
  [field_comma_sep_query] = "comma_sep_query",
  [field_compare] = "compare",
  [field_empty_array] = "empty_array",
  [field_empty_object] = "empty_object",
  [field_foreach_1] = "foreach_1",
  [field_foreach_2] = "foreach_2",
  [field_function] = "function",
  [field_if_statement] = "if_statement",
  [field_label] = "label",
  [field_math] = "math",
  [field_object] = "object",
  [field_object_2] = "object_2",
  [field_object_param] = "object_param",
  [field_optional] = "optional",
  [field_query_within_parens] = "query_within_parens",
  [field_reduce] = "reduce",
  [field_term] = "term",
  [field_term_with_object_access] = "term_with_object_access",
  [field_try_catch] = "try_catch",
  [field_unary_minus] = "unary_minus",
  [field_unary_plus] = "unary_plus",
  [field_update] = "update",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 14},
  [2] = {.index = 14, .length = 1},
  [3] = {.index = 15, .length = 2},
  [4] = {.index = 17, .length = 2},
  [5] = {.index = 19, .length = 2},
  [6] = {.index = 21, .length = 2},
  [7] = {.index = 23, .length = 2},
  [8] = {.index = 25, .length = 15},
  [9] = {.index = 40, .length = 15},
  [10] = {.index = 55, .length = 2},
  [11] = {.index = 57, .length = 2},
  [12] = {.index = 59, .length = 13},
  [13] = {.index = 72, .length = 15},
  [14] = {.index = 87, .length = 3},
  [15] = {.index = 90, .length = 3},
  [16] = {.index = 93, .length = 3},
  [17] = {.index = 96, .length = 3},
  [18] = {.index = 99, .length = 3},
  [19] = {.index = 102, .length = 3},
  [20] = {.index = 105, .length = 3},
  [21] = {.index = 108, .length = 3},
  [22] = {.index = 111, .length = 3},
  [23] = {.index = 114, .length = 3},
  [24] = {.index = 117, .length = 3},
  [25] = {.index = 120, .length = 3},
  [26] = {.index = 123, .length = 3},
  [27] = {.index = 126, .length = 4},
  [28] = {.index = 130, .length = 4},
  [29] = {.index = 134, .length = 4},
  [30] = {.index = 138, .length = 5},
  [31] = {.index = 143, .length = 26},
  [32] = {.index = 169, .length = 6},
  [33] = {.index = 175, .length = 13},
  [34] = {.index = 188, .length = 7},
  [35] = {.index = 195, .length = 22},
  [36] = {.index = 217, .length = 22},
  [37] = {.index = 239, .length = 24},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_array, 0, .inherited = true},
    {field_array_access, 0, .inherited = true},
    {field_break_statement, 0, .inherited = true},
    {field_empty_array, 0, .inherited = true},
    {field_empty_object, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_object_2, 0, .inherited = true},
    {field_object_param, 0, .inherited = true},
    {field_query_within_parens, 0, .inherited = true},
    {field_term, 0},
    {field_term_with_object_access, 0, .inherited = true},
    {field_unary_minus, 0, .inherited = true},
    {field_unary_plus, 0, .inherited = true},
  [14] =
    {field_function, 0},
  [15] =
    {field_try_catch, 0},
    {field_try_catch, 1},
  [17] =
    {field_empty_array, 0},
    {field_empty_array, 1},
  [19] =
    {field_empty_object, 0},
    {field_empty_object, 1},
  [21] =
    {field_array_access, 0},
    {field_array_access, 1},
  [23] =
    {field_object_param, 0},
    {field_object_param, 1},
  [25] =
    {field_array, 1, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_function, 1, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 0},
    {field_unary_plus, 1},
    {field_unary_plus, 1, .inherited = true},
  [40] =
    {field_array, 1, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_function, 1, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 0},
    {field_unary_minus, 1},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 1, .inherited = true},
  [55] =
    {field_break_statement, 0},
    {field_break_statement, 1},
  [57] =
    {field_optional, 0},
    {field_optional, 1},
  [59] =
    {field_array, 0, .inherited = true},
    {field_array_access, 0, .inherited = true},
    {field_break_statement, 0, .inherited = true},
    {field_empty_array, 0, .inherited = true},
    {field_empty_object, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_object_2, 0, .inherited = true},
    {field_object_param, 0, .inherited = true},
    {field_query_within_parens, 0, .inherited = true},
    {field_term_with_object_access, 0, .inherited = true},
    {field_unary_minus, 0, .inherited = true},
    {field_unary_plus, 0, .inherited = true},
  [72] =
    {field_array, 0, .inherited = true},
    {field_array_access, 0, .inherited = true},
    {field_break_statement, 0, .inherited = true},
    {field_empty_array, 0, .inherited = true},
    {field_empty_object, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_object_2, 0, .inherited = true},
    {field_object_param, 0, .inherited = true},
    {field_query_within_parens, 0, .inherited = true},
    {field_term_with_object_access, 0},
    {field_term_with_object_access, 0, .inherited = true},
    {field_term_with_object_access, 1},
    {field_unary_minus, 0, .inherited = true},
    {field_unary_plus, 0, .inherited = true},
  [87] =
    {field_query_within_parens, 0},
    {field_query_within_parens, 1},
    {field_query_within_parens, 2},
  [90] =
    {field_try_catch, 0},
    {field_try_catch, 1},
    {field_try_catch, 2},
  [93] =
    {field_array, 0},
    {field_array, 1},
    {field_array, 2},
  [96] =
    {field_object, 0},
    {field_object, 1},
    {field_object, 2},
  [99] =
    {field_chained_query, 0},
    {field_chained_query, 1},
    {field_chained_query, 2},
  [102] =
    {field_comma_sep_query, 0},
    {field_comma_sep_query, 1},
    {field_comma_sep_query, 2},
  [105] =
    {field_alternative, 0},
    {field_alternative, 1},
    {field_alternative, 2},
  [108] =
    {field_boolean_or, 0},
    {field_boolean_or, 1},
    {field_boolean_or, 2},
  [111] =
    {field_boolean_and, 0},
    {field_boolean_and, 1},
    {field_boolean_and, 2},
  [114] =
    {field_math, 0},
    {field_math, 1},
    {field_math, 2},
  [117] =
    {field_update, 0},
    {field_update, 1},
    {field_update, 2},
  [120] =
    {field_compare, 0},
    {field_compare, 1},
    {field_compare, 2},
  [123] =
    {field_chained_binding, 0},
    {field_chained_binding, 1},
    {field_chained_binding, 2},
  [126] =
    {field_label, 0},
    {field_label, 1},
    {field_label, 2},
    {field_label, 3},
  [130] =
    {field_object_2, 0},
    {field_object_2, 1},
    {field_object_2, 2},
    {field_object_2, 3},
  [134] =
    {field_function, 0},
    {field_function, 1},
    {field_function, 2},
    {field_function, 3},
  [138] =
    {field_if_statement, 0},
    {field_if_statement, 1},
    {field_if_statement, 2},
    {field_if_statement, 3},
    {field_if_statement, 4},
  [143] =
    {field_array, 0, .inherited = true},
    {field_array, 1, .inherited = true},
    {field_array_access, 0, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 0, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 0, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 0, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_function, 1, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 0, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 0, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 0, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_term_with_object_access, 0, .inherited = true},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 0, .inherited = true},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 0, .inherited = true},
    {field_unary_plus, 1, .inherited = true},
  [169] =
    {field_if_statement, 0},
    {field_if_statement, 1},
    {field_if_statement, 2},
    {field_if_statement, 3},
    {field_if_statement, 4},
    {field_if_statement, 5},
  [175] =
    {field_array, 1, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_function, 1, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 1, .inherited = true},
  [188] =
    {field_if_statement, 0},
    {field_if_statement, 1},
    {field_if_statement, 2},
    {field_if_statement, 3},
    {field_if_statement, 4},
    {field_if_statement, 5},
    {field_if_statement, 6},
  [195] =
    {field_array, 1, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_function, 1, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_reduce, 0},
    {field_reduce, 1},
    {field_reduce, 2},
    {field_reduce, 3},
    {field_reduce, 4},
    {field_reduce, 5},
    {field_reduce, 6},
    {field_reduce, 7},
    {field_reduce, 8},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 1, .inherited = true},
  [217] =
    {field_array, 1, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_foreach_1, 0},
    {field_foreach_1, 1},
    {field_foreach_1, 2},
    {field_foreach_1, 3},
    {field_foreach_1, 4},
    {field_foreach_1, 5},
    {field_foreach_1, 6},
    {field_foreach_1, 7},
    {field_foreach_1, 8},
    {field_function, 1, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 1, .inherited = true},
  [239] =
    {field_array, 1, .inherited = true},
    {field_array_access, 1, .inherited = true},
    {field_break_statement, 1, .inherited = true},
    {field_empty_array, 1, .inherited = true},
    {field_empty_object, 1, .inherited = true},
    {field_foreach_2, 0},
    {field_foreach_2, 1},
    {field_foreach_2, 2},
    {field_foreach_2, 3},
    {field_foreach_2, 4},
    {field_foreach_2, 5},
    {field_foreach_2, 6},
    {field_foreach_2, 7},
    {field_foreach_2, 8},
    {field_foreach_2, 9},
    {field_foreach_2, 10},
    {field_function, 1, .inherited = true},
    {field_object, 1, .inherited = true},
    {field_object_2, 1, .inherited = true},
    {field_object_param, 1, .inherited = true},
    {field_query_within_parens, 1, .inherited = true},
    {field_term_with_object_access, 1, .inherited = true},
    {field_unary_minus, 1, .inherited = true},
    {field_unary_plus, 1, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(10);
      if (lookahead == '"') ADVANCE(193);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '$') ADVANCE(75);
      if (lookahead == '%') ADVANCE(175);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '+') ADVANCE(105);
      if (lookahead == ',') ADVANCE(88);
      if (lookahead == '-') ADVANCE(107);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == ';') ADVANCE(81);
      if (lookahead == '<') ADVANCE(189);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '[') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == ']') ADVANCE(92);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(151);
      if (lookahead == 'b') ADVANCE(160);
      if (lookahead == 'c') ADVANCE(113);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'f') ADVANCE(116);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(114);
      if (lookahead == 'm') ADVANCE(153);
      if (lookahead == 'n') ADVANCE(165);
      if (lookahead == 'o') ADVANCE(158);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == 't') ADVANCE(139);
      if (lookahead == '{') ADVANCE(93);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(77)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(195);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(193);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '$') ADVANCE(75);
      if (lookahead == ',') ADVANCE(88);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '[') ADVANCE(91);
      if (lookahead == '|') ADVANCE(85);
      if (lookahead == '}') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(193);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ',') ADVANCE(88);
      if (lookahead == '?') ADVANCE(8);
      if (lookahead == '[') ADVANCE(91);
      if (lookahead == ']') ADVANCE(92);
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 't') ADVANCE(61);
      if (lookahead == '{') ADVANCE(93);
      if (lookahead == '|') ADVANCE(85);
      if (lookahead == '}') ADVANCE(94);
      if (('+' <= lookahead && lookahead <= '-')) ADVANCE(73);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(76);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '(') ADVANCE(194);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(90);
      END_STATE();
    case 8:
      if (lookahead == '/') ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == ':') ADVANCE(74);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 11:
      if (lookahead == '_') ADVANCE(47);
      END_STATE();
    case 12:
      if (lookahead == '_') ADVANCE(108);
      END_STATE();
    case 13:
      if (lookahead == '_') ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(19);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(20);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 19:
      if (lookahead == 'b') ADVANCE(34);
      END_STATE();
    case 20:
      if (lookahead == 'c') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(13);
      END_STATE();
    case 22:
      if (lookahead == 'c') ADVANCE(48);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(108);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(66);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(68);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(28);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(16);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(17);
      END_STATE();
    case 37:
      if (lookahead == 'f') ADVANCE(108);
      END_STATE();
    case 38:
      if (lookahead == 'f') ADVANCE(108);
      if (lookahead == 'm') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 39:
      if (lookahead == 'h') ADVANCE(108);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 42:
      if (lookahead == 'k') ADVANCE(108);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(67);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(28);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 57:
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 66:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 68:
      if (lookahead == 'u') ADVANCE(23);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 70:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 71:
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 72:
      if (lookahead == '"' ||
          lookahead == '/' ||
          lookahead == '\\' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'u') ADVANCE(197);
      if (lookahead == '(') ADVANCE(194);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 74:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 75:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(172);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(190);
      END_STATE();
    case 77:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(10);
      if (lookahead == '"') ADVANCE(193);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '$') ADVANCE(75);
      if (lookahead == '%') ADVANCE(175);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '+') ADVANCE(105);
      if (lookahead == ',') ADVANCE(88);
      if (lookahead == '-') ADVANCE(107);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == ';') ADVANCE(81);
      if (lookahead == '<') ADVANCE(189);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '[') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == ']') ADVANCE(92);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(151);
      if (lookahead == 'b') ADVANCE(160);
      if (lookahead == 'c') ADVANCE(113);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'f') ADVANCE(116);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(114);
      if (lookahead == 'm') ADVANCE(153);
      if (lookahead == 'n') ADVANCE(165);
      if (lookahead == 'o') ADVANCE(158);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == 't') ADVANCE(139);
      if (lookahead == '{') ADVANCE(93);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(77)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 78:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(10);
      if (lookahead == '"') ADVANCE(193);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '$') ADVANCE(75);
      if (lookahead == '%') ADVANCE(175);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '+') ADVANCE(104);
      if (lookahead == ',') ADVANCE(88);
      if (lookahead == '-') ADVANCE(106);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == ';') ADVANCE(81);
      if (lookahead == '<') ADVANCE(189);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '[') ADVANCE(91);
      if (lookahead == ']') ADVANCE(92);
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 'a') ADVANCE(151);
      if (lookahead == 'b') ADVANCE(160);
      if (lookahead == 'c') ADVANCE(113);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'f') ADVANCE(156);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'l') ADVANCE(114);
      if (lookahead == 'm') ADVANCE(153);
      if (lookahead == 'o') ADVANCE(158);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == 't') ADVANCE(140);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(78)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 79:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(10);
      if (lookahead == '"') ADVANCE(192);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '%') ADVANCE(175);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '+') ADVANCE(104);
      if (lookahead == ',') ADVANCE(88);
      if (lookahead == '-') ADVANCE(106);
      if (lookahead == '.') ADVANCE(95);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == ';') ADVANCE(81);
      if (lookahead == '<') ADVANCE(189);
      if (lookahead == '=') ADVANCE(183);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '?') ADVANCE(87);
      if (lookahead == '[') ADVANCE(91);
      if (lookahead == ']') ADVANCE(92);
      if (lookahead == '_') ADVANCE(11);
      if (lookahead == 'a') ADVANCE(51);
      if (lookahead == 'b') ADVANCE(60);
      if (lookahead == 'c') ADVANCE(14);
      if (lookahead == 'd') ADVANCE(29);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'o') ADVANCE(58);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 't') ADVANCE(40);
      if (lookahead == '{') ADVANCE(93);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      END_STATE();
    case 80:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(176);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(181);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_QMARK_SLASH_SLASH);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(97);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_null);
      if (lookahead == ':') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == ':') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == ':') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(177);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(178);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == ':') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == '_') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == '_') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == '_') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'a') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'a') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'a') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'a') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'a') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'b') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'c') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'c') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'c') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'c') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'd') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'd') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'd') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'd') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(109);
      if (lookahead == 'm') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'h') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'h') ADVANCE(129);
      if (lookahead == 'r') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'h') ADVANCE(129);
      if (lookahead == 'r') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'i') ADVANCE(137);
      if (lookahead == 's') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'k') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(141);
      if (lookahead == 'n') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(123);
      if (lookahead == 's') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'r') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'r') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'r') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'r') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 's') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 't') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 't') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'u') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'u') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'u') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'u') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'u') ADVANCE(130);
      if (lookahead == 'y') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == 'y') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == ':') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(179);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead == '=') ADVANCE(180);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(182);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(186);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(187);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_format);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '@') ADVANCE(4);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym__string_content_token1);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(195);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__escape_sequence);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(198);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(15);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(17);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'm') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(24);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 13:
      if (lookahead == 'd') ADVANCE(30);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 16:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(33);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(34);
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(36);
      END_STATE();
    case 20:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(38);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(39);
      END_STATE();
    case 24:
      if (lookahead == 'b') ADVANCE(40);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(41);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 29:
      if (lookahead == 'y') ADVANCE(44);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(46);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 34:
      if (lookahead == 'f') ADVANCE(47);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 41:
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 43:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 45:
      if (lookahead == 'k') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 'h') ADVANCE(57);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 51:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(63);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 60:
      if (lookahead == 'd') ADVANCE(66);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_label);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(69);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_reduce);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 79},
  [3] = {.lex_state = 79},
  [4] = {.lex_state = 79},
  [5] = {.lex_state = 79},
  [6] = {.lex_state = 79},
  [7] = {.lex_state = 79},
  [8] = {.lex_state = 79},
  [9] = {.lex_state = 79},
  [10] = {.lex_state = 79},
  [11] = {.lex_state = 79},
  [12] = {.lex_state = 79},
  [13] = {.lex_state = 78},
  [14] = {.lex_state = 79},
  [15] = {.lex_state = 79},
  [16] = {.lex_state = 79},
  [17] = {.lex_state = 78},
  [18] = {.lex_state = 79},
  [19] = {.lex_state = 79},
  [20] = {.lex_state = 79},
  [21] = {.lex_state = 79},
  [22] = {.lex_state = 78},
  [23] = {.lex_state = 79},
  [24] = {.lex_state = 79},
  [25] = {.lex_state = 79},
  [26] = {.lex_state = 79},
  [27] = {.lex_state = 79},
  [28] = {.lex_state = 79},
  [29] = {.lex_state = 79},
  [30] = {.lex_state = 79},
  [31] = {.lex_state = 79},
  [32] = {.lex_state = 79},
  [33] = {.lex_state = 79},
  [34] = {.lex_state = 79},
  [35] = {.lex_state = 79},
  [36] = {.lex_state = 78},
  [37] = {.lex_state = 78},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 78},
  [40] = {.lex_state = 78},
  [41] = {.lex_state = 78},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 78},
  [44] = {.lex_state = 78},
  [45] = {.lex_state = 79},
  [46] = {.lex_state = 79},
  [47] = {.lex_state = 79},
  [48] = {.lex_state = 79},
  [49] = {.lex_state = 79},
  [50] = {.lex_state = 79},
  [51] = {.lex_state = 79},
  [52] = {.lex_state = 79},
  [53] = {.lex_state = 79},
  [54] = {.lex_state = 79},
  [55] = {.lex_state = 79},
  [56] = {.lex_state = 79},
  [57] = {.lex_state = 79},
  [58] = {.lex_state = 79},
  [59] = {.lex_state = 79},
  [60] = {.lex_state = 79},
  [61] = {.lex_state = 79},
  [62] = {.lex_state = 79},
  [63] = {.lex_state = 79},
  [64] = {.lex_state = 79},
  [65] = {.lex_state = 79},
  [66] = {.lex_state = 79},
  [67] = {.lex_state = 79},
  [68] = {.lex_state = 79},
  [69] = {.lex_state = 79},
  [70] = {.lex_state = 79},
  [71] = {.lex_state = 79},
  [72] = {.lex_state = 79},
  [73] = {.lex_state = 79},
  [74] = {.lex_state = 79},
  [75] = {.lex_state = 79},
  [76] = {.lex_state = 79},
  [77] = {.lex_state = 79},
  [78] = {.lex_state = 79},
  [79] = {.lex_state = 79},
  [80] = {.lex_state = 79},
  [81] = {.lex_state = 79},
  [82] = {.lex_state = 79},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 79},
  [85] = {.lex_state = 79},
  [86] = {.lex_state = 79},
  [87] = {.lex_state = 79},
  [88] = {.lex_state = 79},
  [89] = {.lex_state = 79},
  [90] = {.lex_state = 79},
  [91] = {.lex_state = 79},
  [92] = {.lex_state = 79},
  [93] = {.lex_state = 79},
  [94] = {.lex_state = 79},
  [95] = {.lex_state = 79},
  [96] = {.lex_state = 79},
  [97] = {.lex_state = 79},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 79},
  [100] = {.lex_state = 79},
  [101] = {.lex_state = 79},
  [102] = {.lex_state = 79},
  [103] = {.lex_state = 79},
  [104] = {.lex_state = 79},
  [105] = {.lex_state = 79},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 79},
  [108] = {.lex_state = 79},
  [109] = {.lex_state = 79},
  [110] = {.lex_state = 79},
  [111] = {.lex_state = 79},
  [112] = {.lex_state = 79},
  [113] = {.lex_state = 79},
  [114] = {.lex_state = 79},
  [115] = {.lex_state = 79},
  [116] = {.lex_state = 79},
  [117] = {.lex_state = 79},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 79},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 79},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 79},
  [134] = {.lex_state = 79},
  [135] = {.lex_state = 79},
  [136] = {.lex_state = 79},
  [137] = {.lex_state = 79},
  [138] = {.lex_state = 79},
  [139] = {.lex_state = 79},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 79},
  [142] = {.lex_state = 79},
  [143] = {.lex_state = 79},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 79},
  [146] = {.lex_state = 79},
  [147] = {.lex_state = 79},
  [148] = {.lex_state = 79},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 0},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 79},
  [196] = {.lex_state = 79},
  [197] = {.lex_state = 79},
  [198] = {.lex_state = 79},
  [199] = {.lex_state = 79},
  [200] = {.lex_state = 79},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 79},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 79},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 79},
  [221] = {.lex_state = 79},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 79},
  [224] = {.lex_state = 79},
  [225] = {.lex_state = 79},
  [226] = {.lex_state = 79},
  [227] = {.lex_state = 79},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 79},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 79},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 79},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 79},
  [251] = {.lex_state = 79},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 79},
  [266] = {.lex_state = 79},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 79},
  [303] = {.lex_state = 79},
  [304] = {.lex_state = 79},
  [305] = {.lex_state = 79},
  [306] = {.lex_state = 79},
  [307] = {.lex_state = 79},
  [308] = {.lex_state = 79},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 79},
  [328] = {.lex_state = 79},
  [329] = {.lex_state = 79},
  [330] = {.lex_state = 79},
  [331] = {.lex_state = 79},
  [332] = {.lex_state = 79},
  [333] = {.lex_state = 79},
  [334] = {.lex_state = 79},
  [335] = {.lex_state = 79},
  [336] = {.lex_state = 79},
  [337] = {.lex_state = 79},
  [338] = {.lex_state = 79},
  [339] = {.lex_state = 79},
  [340] = {.lex_state = 79},
  [341] = {.lex_state = 79},
  [342] = {.lex_state = 79},
  [343] = {.lex_state = 79},
  [344] = {.lex_state = 79},
  [345] = {.lex_state = 79},
  [346] = {.lex_state = 79},
  [347] = {.lex_state = 79},
  [348] = {.lex_state = 79},
  [349] = {.lex_state = 79},
  [350] = {.lex_state = 79},
  [351] = {.lex_state = 79},
  [352] = {.lex_state = 79},
  [353] = {.lex_state = 79},
  [354] = {.lex_state = 79},
  [355] = {.lex_state = 79},
  [356] = {.lex_state = 79},
  [357] = {.lex_state = 79},
  [358] = {.lex_state = 79},
  [359] = {.lex_state = 79},
  [360] = {.lex_state = 79},
  [361] = {.lex_state = 79},
  [362] = {.lex_state = 79},
  [363] = {.lex_state = 79},
  [364] = {.lex_state = 79},
  [365] = {.lex_state = 79},
  [366] = {.lex_state = 79},
  [367] = {.lex_state = 79},
  [368] = {.lex_state = 79},
  [369] = {.lex_state = 79},
  [370] = {.lex_state = 79},
  [371] = {.lex_state = 79},
  [372] = {.lex_state = 79},
  [373] = {.lex_state = 79},
  [374] = {.lex_state = 79},
  [375] = {.lex_state = 79},
  [376] = {.lex_state = 79},
  [377] = {.lex_state = 79},
  [378] = {.lex_state = 79},
  [379] = {.lex_state = 79},
  [380] = {.lex_state = 79},
  [381] = {.lex_state = 79},
  [382] = {.lex_state = 79},
  [383] = {.lex_state = 79},
  [384] = {.lex_state = 79},
  [385] = {.lex_state = 79},
  [386] = {.lex_state = 79},
  [387] = {.lex_state = 79},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 3},
  [428] = {.lex_state = 3},
  [429] = {.lex_state = 78},
  [430] = {.lex_state = 3},
  [431] = {.lex_state = 2},
  [432] = {.lex_state = 78},
  [433] = {.lex_state = 78},
  [434] = {.lex_state = 78},
  [435] = {.lex_state = 78},
  [436] = {.lex_state = 79},
  [437] = {.lex_state = 78},
  [438] = {.lex_state = 79},
  [439] = {.lex_state = 2},
  [440] = {.lex_state = 78},
  [441] = {.lex_state = 79},
  [442] = {.lex_state = 79},
  [443] = {.lex_state = 79},
  [444] = {.lex_state = 3},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 1},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 79},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 79},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 2},
  [466] = {.lex_state = 79},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 79},
  [470] = {.lex_state = 2},
  [471] = {.lex_state = 2},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 3},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 3},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 2},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 2},
  [506] = {.lex_state = 2},
  [507] = {.lex_state = 79},
  [508] = {.lex_state = 79},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 79},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 3},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 79},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 79},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 79},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_reduce] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_label] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [sym_variable] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_format] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(1),
    [sym__escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(552),
    [sym_moduleheader] = STATE(38),
    [sym_programbody] = STATE(551),
    [sym_import_] = STATE(42),
    [sym_funcdef] = STATE(120),
    [sym_query] = STATE(341),
    [sym_binding] = STATE(532),
    [sym__term] = STATE(11),
    [sym_funcname] = STATE(6),
    [sym_string] = STATE(11),
    [sym_index] = STATE(11),
    [sym__QQSTRING] = STATE(7),
    [sym__IDENT] = STATE(9),
    [aux_sym_programbody_repeat1] = STATE(42),
    [aux_sym_programbody_repeat2] = STATE(469),
    [anon_sym_module] = ACTIONS(5),
    [anon_sym_import] = ACTIONS(7),
    [anon_sym_include] = ACTIONS(9),
    [anon_sym_def] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_reduce] = ACTIONS(15),
    [anon_sym_foreach] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_try] = ACTIONS(21),
    [anon_sym_label] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_DOT] = ACTIONS(29),
    [anon_sym_DOT_DOT] = ACTIONS(31),
    [anon_sym_null] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(33),
    [anon_sym_false] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [aux_sym_identifier_token1] = ACTIONS(41),
    [sym_variable] = ACTIONS(31),
    [sym_format] = ACTIONS(43),
    [sym_number] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    STATE(8), 1,
      sym__QQSTRING,
    ACTIONS(49), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(47), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [53] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
    ACTIONS(55), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(53), 27,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [110] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
    ACTIONS(63), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(61), 27,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(65), 31,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [216] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(69), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [266] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(75), 30,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [314] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(79), 30,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [362] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(85), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(83), 30,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(87), 30,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [458] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    ACTIONS(93), 1,
      anon_sym_as,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
    ACTIONS(95), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(91), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(97), 30,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [564] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(49), 14,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_catch,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(47), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(105), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(109), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(113), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [769] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 14,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(49), 17,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_end,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
  [832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(117), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(121), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(125), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(125), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1020] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(49), 13,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(47), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(129), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(133), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(137), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(117), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(141), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(145), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1365] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(151), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(149), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(155), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(153), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(157), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1506] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(161), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1553] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(165), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(169), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(173), 29,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [1694] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 14,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(49), 16,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_end,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
  [1756] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 14,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(49), 15,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_catch,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
  [1817] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_import,
    ACTIONS(9), 1,
      anon_sym_include,
    ACTIONS(11), 1,
      anon_sym_def,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(120), 1,
      sym_funcdef,
    STATE(341), 1,
      sym_query,
    STATE(469), 1,
      aux_sym_programbody_repeat2,
    STATE(532), 1,
      sym_binding,
    STATE(560), 1,
      sym_programbody,
    STATE(42), 2,
      sym_import_,
      aux_sym_programbody_repeat1,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [1918] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 14,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(49), 15,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_end,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_catch,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
  [1979] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(49), 14,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_catch,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(47), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2040] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(49), 13,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(47), 15,
      ts_builtin_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2100] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_import,
    ACTIONS(9), 1,
      anon_sym_include,
    ACTIONS(11), 1,
      anon_sym_def,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(120), 1,
      sym_funcdef,
    STATE(381), 1,
      sym_query,
    STATE(462), 1,
      aux_sym_programbody_repeat2,
    STATE(532), 1,
      sym_binding,
    STATE(388), 2,
      sym_import_,
      aux_sym_programbody_repeat1,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [2198] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 14,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(49), 14,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_end,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
  [2258] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 14,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(49), 14,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_SLASH_SLASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
  [2318] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_and,
    ACTIONS(193), 1,
      anon_sym_catch,
    ACTIONS(199), 1,
      anon_sym_EQ,
    STATE(47), 1,
      sym_catch,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(203), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(177), 4,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(201), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(197), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [2395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(205), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(209), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(213), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(217), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2567] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(223), 1,
      anon_sym_end,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    ACTIONS(231), 1,
      anon_sym_and,
    ACTIONS(235), 1,
      anon_sym_elif,
    ACTIONS(237), 1,
      anon_sym_else,
    ACTIONS(243), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    STATE(529), 1,
      sym_else,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(247), 2,
      anon_sym_GT,
      anon_sym_LT,
    STATE(443), 2,
      sym_elif,
      aux_sym_query_repeat1,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(241), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [2648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(249), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(253), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2734] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(259), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(257), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2777] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_and,
    ACTIONS(199), 1,
      anon_sym_EQ,
    ACTIONS(261), 1,
      anon_sym_catch,
    STATE(47), 1,
      sym_catch,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(203), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(177), 4,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(201), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(197), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [2854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(265), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(263), 25,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_then,
      anon_sym_end,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2897] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 19,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [2951] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 19,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3003] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 19,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3055] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 19,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3111] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(279), 17,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3175] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    ACTIONS(291), 1,
      anon_sym_and,
    ACTIONS(295), 1,
      anon_sym_catch,
    ACTIONS(301), 1,
      anon_sym_EQ,
    STATE(47), 1,
      sym_catch,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(177), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(299), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [3251] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3311] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 19,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3363] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(315), 17,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3427] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_and,
    ACTIONS(199), 1,
      anon_sym_EQ,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(203), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(201), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(319), 5,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_catch,
    ACTIONS(197), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [3499] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_and,
    ACTIONS(199), 1,
      anon_sym_EQ,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(203), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(201), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(321), 5,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_catch,
    ACTIONS(197), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [3571] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_and,
    ACTIONS(199), 1,
      anon_sym_EQ,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(203), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(201), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(323), 5,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_catch,
    ACTIONS(197), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [3643] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_PIPE,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(183), 1,
      anon_sym_COMMA,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    ACTIONS(189), 1,
      anon_sym_and,
    ACTIONS(199), 1,
      anon_sym_EQ,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(203), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(201), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(325), 5,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_catch,
    ACTIONS(197), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [3715] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    ACTIONS(291), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_EQ,
    ACTIONS(327), 1,
      anon_sym_catch,
    STATE(47), 1,
      sym_catch,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(177), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(299), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [3791] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(185), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(290), 1,
      sym__tokCompareOp,
    STATE(291), 1,
      sym__tokUpdateOp,
    STATE(292), 1,
      sym__tokMathHigh,
    STATE(293), 1,
      sym__tokMathLow,
    ACTIONS(191), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(195), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3851] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 16,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3914] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 18,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [3965] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    ACTIONS(291), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_EQ,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(323), 4,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
    ACTIONS(299), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [4036] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4087] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4138] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4189] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4242] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 18,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4297] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 18,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4348] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    ACTIONS(291), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_EQ,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(319), 4,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
    ACTIONS(299), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [4419] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    ACTIONS(291), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_EQ,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(321), 4,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
    ACTIONS(299), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [4490] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 18,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4541] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(347), 1,
      anon_sym_COLON,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(353), 1,
      anon_sym_RBRACK,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(216), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [4632] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 17,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4691] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 18,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4744] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    ACTIONS(291), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_EQ,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(325), 4,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
    ACTIONS(299), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [4815] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 18,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4870] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 16,
      anon_sym_end,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4933] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [4992] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5051] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(283), 1,
      anon_sym_PIPE,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_or,
    STATE(123), 1,
      sym__tokMathHigh,
    STATE(185), 1,
      sym__tokCompareOp,
    STATE(188), 1,
      sym__tokUpdateOp,
    STATE(189), 1,
      sym__tokMathLow,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(297), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(315), 16,
      anon_sym_end,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5114] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 16,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5177] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(319), 4,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5248] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(321), 4,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5319] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(323), 4,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5390] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(325), 4,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5461] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 17,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_RBRACK,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5520] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(134), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(510), 1,
      sym_args,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [5608] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    ACTIONS(231), 1,
      anon_sym_and,
    ACTIONS(243), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(247), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(325), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(241), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5678] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      anon_sym_then,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    ACTIONS(379), 1,
      anon_sym_and,
    ACTIONS(383), 1,
      anon_sym_catch,
    ACTIONS(389), 1,
      anon_sym_EQ,
    STATE(47), 1,
      sym_catch,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(393), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(391), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(387), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5752] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5802] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    ACTIONS(231), 1,
      anon_sym_and,
    ACTIONS(243), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(247), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(323), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(241), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5872] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    ACTIONS(231), 1,
      anon_sym_and,
    ACTIONS(243), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(247), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(321), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(241), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [5942] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    ACTIONS(231), 1,
      anon_sym_and,
    ACTIONS(243), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(247), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(319), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(241), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6012] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      anon_sym_then,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    ACTIONS(379), 1,
      anon_sym_and,
    ACTIONS(389), 1,
      anon_sym_EQ,
    ACTIONS(395), 1,
      anon_sym_catch,
    STATE(47), 1,
      sym_catch,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(393), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(391), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(387), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6086] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    ACTIONS(397), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(353), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [6174] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    ACTIONS(231), 1,
      anon_sym_and,
    ACTIONS(243), 1,
      anon_sym_EQ,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(247), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(399), 3,
      anon_sym_end,
      anon_sym_elif,
      anon_sym_else,
    ACTIONS(245), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(241), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6244] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6302] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6352] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6410] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6460] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6512] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 17,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6566] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(279), 15,
      anon_sym_end,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6628] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(221), 1,
      anon_sym_PIPE,
    ACTIONS(225), 1,
      anon_sym_COMMA,
    ACTIONS(227), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(229), 1,
      anon_sym_or,
    STATE(207), 1,
      sym__tokCompareOp,
    STATE(208), 1,
      sym__tokUpdateOp,
    STATE(209), 1,
      sym__tokMathHigh,
    STATE(210), 1,
      sym__tokMathLow,
    ACTIONS(233), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(239), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(315), 15,
      anon_sym_end,
      anon_sym_and,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6690] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      ts_builtin_sym_end,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    ACTIONS(409), 1,
      anon_sym_and,
    ACTIONS(413), 1,
      anon_sym_catch,
    ACTIONS(419), 1,
      anon_sym_EQ,
    STATE(47), 1,
      sym_catch,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(417), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6764] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      ts_builtin_sym_end,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    ACTIONS(409), 1,
      anon_sym_and,
    ACTIONS(419), 1,
      anon_sym_EQ,
    ACTIONS(425), 1,
      anon_sym_catch,
    STATE(47), 1,
      sym_catch,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(417), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [6838] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    ACTIONS(427), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(345), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [6926] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      anon_sym_end,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    ACTIONS(437), 1,
      anon_sym_and,
    ACTIONS(441), 1,
      anon_sym_catch,
    ACTIONS(447), 1,
      anon_sym_EQ,
    STATE(47), 1,
      sym_catch,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(451), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(449), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(445), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [7000] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(453), 1,
      ts_builtin_sym_end,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(387), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7088] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      anon_sym_end,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    ACTIONS(437), 1,
      anon_sym_and,
    ACTIONS(447), 1,
      anon_sym_EQ,
    ACTIONS(455), 1,
      anon_sym_catch,
    STATE(47), 1,
      sym_catch,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(451), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(449), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(445), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [7162] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(108), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7247] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(72), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7332] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(369), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7417] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(367), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7502] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(119), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7587] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(61), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7672] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(105), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7757] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(54), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7842] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(337), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [7927] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(335), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [8012] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(117), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [8097] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8146] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(517), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8215] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8264] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8313] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8364] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 16,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8417] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 14,
      anon_sym_end,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8478] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(139), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [8563] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    ACTIONS(437), 1,
      anon_sym_and,
    ACTIONS(447), 1,
      anon_sym_EQ,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(319), 2,
      anon_sym_end,
      anon_sym_catch,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(451), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(449), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(445), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8632] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    ACTIONS(437), 1,
      anon_sym_and,
    ACTIONS(447), 1,
      anon_sym_EQ,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(321), 2,
      anon_sym_end,
      anon_sym_catch,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(451), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(449), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(445), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8701] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    ACTIONS(437), 1,
      anon_sym_and,
    ACTIONS(447), 1,
      anon_sym_EQ,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(323), 2,
      anon_sym_end,
      anon_sym_catch,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(451), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(449), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(445), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8770] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(342), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [8855] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    ACTIONS(437), 1,
      anon_sym_and,
    ACTIONS(447), 1,
      anon_sym_EQ,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(325), 2,
      anon_sym_end,
      anon_sym_catch,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(451), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(449), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(445), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [8924] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [8981] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [9038] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(429), 1,
      anon_sym_PIPE,
    ACTIONS(431), 1,
      anon_sym_COMMA,
    ACTIONS(433), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(435), 1,
      anon_sym_or,
    STATE(152), 1,
      sym__tokCompareOp,
    STATE(153), 1,
      sym__tokUpdateOp,
    STATE(154), 1,
      sym__tokMathHigh,
    STATE(155), 1,
      sym__tokMathLow,
    ACTIONS(439), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(443), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 14,
      anon_sym_end,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [9099] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(141), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9184] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(133), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9269] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(135), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9354] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(142), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9439] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(143), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9524] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(136), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9609] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(137), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9694] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(145), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9779] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(138), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9864] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(146), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [9949] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(147), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10034] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(140), 1,
      sym_funcdef,
    STATE(148), 1,
      sym_query,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10119] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(346), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10204] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(349), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10289] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(350), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10374] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(116), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10459] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(357), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10544] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(333), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10629] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(380), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10714] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(204), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10799] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(377), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10884] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(334), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [10969] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(336), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11054] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(370), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11139] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(360), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11224] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(328), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11309] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(359), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11394] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(338), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11479] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(339), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11564] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(340), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11649] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(88), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11734] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(80), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11819] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(79), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11904] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(82), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [11989] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(352), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12074] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(354), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12159] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(81), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12244] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(355), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12329] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(529), 1,
      anon_sym_try,
    ACTIONS(531), 1,
      anon_sym_label,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(165), 1,
      sym_funcdef,
    STATE(356), 1,
      sym_query,
    STATE(538), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12414] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(73), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12499] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(85), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12584] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(86), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12669] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(87), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12754] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(89), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12839] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(90), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [12924] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(91), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13009] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 16,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13058] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 16,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13107] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 16,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13156] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 16,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13207] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 16,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13260] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 14,
      anon_sym_then,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [13321] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(114), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13406] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(71), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13491] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(104), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13576] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(539), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [13645] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(109), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13730] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(101), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13815] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(103), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13900] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(102), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [13985] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(111), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14070] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(112), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14155] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(99), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14240] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(113), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14325] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(110), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14410] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(115), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14495] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(384), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14580] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(541), 1,
      anon_sym_COLON,
    ACTIONS(543), 1,
      anon_sym_RBRACK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [14651] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(327), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14736] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(200), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14821] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(477), 1,
      anon_sym_try,
    ACTIONS(479), 1,
      anon_sym_label,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(121), 1,
      sym_query,
    STATE(140), 1,
      sym_funcdef,
    STATE(546), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [14906] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    ACTIONS(379), 1,
      anon_sym_and,
    ACTIONS(389), 1,
      anon_sym_EQ,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(319), 2,
      anon_sym_then,
      anon_sym_catch,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(393), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(391), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(387), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [14975] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    ACTIONS(379), 1,
      anon_sym_and,
    ACTIONS(389), 1,
      anon_sym_EQ,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(321), 2,
      anon_sym_then,
      anon_sym_catch,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(393), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(391), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(387), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [15044] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(330), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15129] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    ACTIONS(379), 1,
      anon_sym_and,
    ACTIONS(389), 1,
      anon_sym_EQ,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(323), 2,
      anon_sym_then,
      anon_sym_catch,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(393), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(391), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(387), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [15198] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    ACTIONS(379), 1,
      anon_sym_and,
    ACTIONS(389), 1,
      anon_sym_EQ,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(325), 2,
      anon_sym_then,
      anon_sym_catch,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(393), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(391), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(387), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [15267] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [15324] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [15381] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(371), 1,
      anon_sym_PIPE,
    ACTIONS(373), 1,
      anon_sym_COMMA,
    ACTIONS(375), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(377), 1,
      anon_sym_or,
    STATE(231), 1,
      sym__tokCompareOp,
    STATE(235), 1,
      sym__tokUpdateOp,
    STATE(236), 1,
      sym__tokMathHigh,
    STATE(237), 1,
      sym__tokMathLow,
    ACTIONS(381), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(385), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 14,
      anon_sym_then,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [15442] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(220), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15527] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(195), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15612] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(196), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15697] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(221), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15782] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(383), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15867] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(241), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [15952] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(107), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16037] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(223), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16122] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(197), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16207] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(198), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16292] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(224), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16377] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(199), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16462] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(225), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16547] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(545), 1,
      anon_sym_SEMI,
    ACTIONS(547), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [16618] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(226), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16703] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(218), 1,
      sym_funcdef,
    STATE(227), 1,
      sym_query,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16788] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [16837] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(385), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [16922] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(344), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17007] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [17056] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(347), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17141] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(457), 1,
      anon_sym_try,
    ACTIONS(459), 1,
      anon_sym_label,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(50), 1,
      sym_query,
    STATE(201), 1,
      sym_funcdef,
    STATE(578), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17226] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [17275] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [17326] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(387), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17411] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(92), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17496] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(84), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17581] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(97), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17666] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(78), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17751] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(96), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17836] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(77), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [17921] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(76), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18006] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(95), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18091] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(94), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18176] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(75), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18261] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(74), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18346] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(93), 1,
      sym_query,
    STATE(202), 1,
      sym_funcdef,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18431] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18484] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 14,
      ts_builtin_sym_end,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [18545] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(60), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18630] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(467), 1,
      anon_sym_try,
    ACTIONS(469), 1,
      anon_sym_label,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(69), 1,
      sym_query,
    STATE(179), 1,
      sym_funcdef,
    STATE(577), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18715] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(349), 1,
      anon_sym_try,
    ACTIONS(351), 1,
      anon_sym_label,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(202), 1,
      sym_funcdef,
    STATE(351), 1,
      sym_query,
    STATE(550), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18800] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(332), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18885] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(331), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [18970] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(329), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19055] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(348), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19140] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(386), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19225] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(65), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19310] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(63), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19395] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(379), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19480] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(378), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19565] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(382), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19650] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(363), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19735] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(376), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19820] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(364), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19905] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(365), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [19990] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(375), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20075] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(374), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20160] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(366), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20245] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(368), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20330] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(373), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20415] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(57), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20500] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(66), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20585] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(67), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20670] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(58), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20755] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(56), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20840] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(68), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [20925] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(59), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21010] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(70), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21095] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(62), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21180] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(64), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21265] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(343), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21350] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(266), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21435] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(487), 1,
      anon_sym_try,
    ACTIONS(489), 1,
      anon_sym_label,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(100), 1,
      sym_query,
    STATE(218), 1,
      sym_funcdef,
    STATE(534), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [21520] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    ACTIONS(409), 1,
      anon_sym_and,
    ACTIONS(419), 1,
      anon_sym_EQ,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(319), 2,
      ts_builtin_sym_end,
      anon_sym_catch,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(417), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [21589] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    ACTIONS(409), 1,
      anon_sym_and,
    ACTIONS(419), 1,
      anon_sym_EQ,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(321), 2,
      ts_builtin_sym_end,
      anon_sym_catch,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(417), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [21658] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    ACTIONS(409), 1,
      anon_sym_and,
    ACTIONS(419), 1,
      anon_sym_EQ,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(323), 2,
      ts_builtin_sym_end,
      anon_sym_catch,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(417), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [21727] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    ACTIONS(409), 1,
      anon_sym_and,
    ACTIONS(419), 1,
      anon_sym_EQ,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(325), 2,
      ts_builtin_sym_end,
      anon_sym_catch,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(421), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(417), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [21796] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [21853] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [21910] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(401), 1,
      anon_sym_PIPE,
    ACTIONS(403), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(407), 1,
      anon_sym_or,
    STATE(312), 1,
      sym__tokCompareOp,
    STATE(313), 1,
      sym__tokUpdateOp,
    STATE(314), 1,
      sym__tokMathHigh,
    STATE(315), 1,
      sym__tokMathLow,
    ACTIONS(411), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(415), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 14,
      ts_builtin_sym_end,
      anon_sym_and,
      anon_sym_catch,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [21971] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(302), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22056] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(244), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22141] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(247), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22226] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(303), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22311] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(304), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22396] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(250), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22481] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(251), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22566] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(305), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22651] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(265), 1,
      sym_query,
    STATE(300), 1,
      sym_funcdef,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22736] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(306), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22821] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(307), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22906] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(507), 1,
      anon_sym_try,
    ACTIONS(509), 1,
      anon_sym_label,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(300), 1,
      sym_funcdef,
    STATE(308), 1,
      sym_query,
    STATE(559), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [22991] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(358), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [23076] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(361), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [23161] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(371), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [23246] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_try,
    ACTIONS(23), 1,
      anon_sym_label,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(252), 1,
      sym_funcdef,
    STATE(372), 1,
      sym_query,
    STATE(532), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [23331] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(497), 1,
      anon_sym_try,
    ACTIONS(499), 1,
      anon_sym_label,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(45), 1,
      sym_query,
    STATE(267), 1,
      sym_funcdef,
    STATE(544), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [23416] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_reduce,
    ACTIONS(17), 1,
      anon_sym_foreach,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(345), 1,
      anon_sym_def,
    ACTIONS(519), 1,
      anon_sym_try,
    ACTIONS(521), 1,
      anon_sym_label,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(326), 1,
      sym_funcdef,
    STATE(362), 1,
      sym_query,
    STATE(573), 1,
      sym_binding,
    ACTIONS(31), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(33), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(11), 3,
      sym__term,
      sym_string,
      sym_index,
  [23501] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(549), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [23569] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(325), 1,
      anon_sym_end,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    ACTIONS(559), 1,
      anon_sym_and,
    ACTIONS(567), 1,
      anon_sym_EQ,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(571), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(569), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(565), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [23637] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [23693] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(427), 1,
      anon_sym_RBRACK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [23761] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [23817] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 13,
      ts_builtin_sym_end,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [23877] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(319), 1,
      anon_sym_end,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    ACTIONS(559), 1,
      anon_sym_and,
    ACTIONS(567), 1,
      anon_sym_EQ,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(571), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(569), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(565), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [23945] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(321), 1,
      anon_sym_end,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    ACTIONS(559), 1,
      anon_sym_and,
    ACTIONS(567), 1,
      anon_sym_EQ,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(571), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(569), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(565), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24013] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(585), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24081] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(323), 1,
      anon_sym_end,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    ACTIONS(559), 1,
      anon_sym_and,
    ACTIONS(567), 1,
      anon_sym_EQ,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(571), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(569), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(565), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24149] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(587), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24217] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 14,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24273] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 14,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24329] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 13,
      anon_sym_end,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24389] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    ACTIONS(589), 1,
      ts_builtin_sym_end,
    ACTIONS(591), 1,
      anon_sym_and,
    ACTIONS(595), 1,
      anon_sym_EQ,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(599), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(597), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(593), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24457] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(601), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24525] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24575] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(319), 1,
      ts_builtin_sym_end,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_and,
    ACTIONS(595), 1,
      anon_sym_EQ,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(599), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(597), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(593), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24643] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(603), 1,
      anon_sym_RBRACK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24711] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(605), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24779] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24827] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [24879] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(607), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [24947] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(611), 1,
      anon_sym_then,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    ACTIONS(619), 1,
      anon_sym_and,
    ACTIONS(627), 1,
      anon_sym_EQ,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(631), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(625), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25015] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(633), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25083] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(635), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25151] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(637), 1,
      anon_sym_RBRACK,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25219] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(639), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25287] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    ACTIONS(619), 1,
      anon_sym_and,
    ACTIONS(627), 1,
      anon_sym_EQ,
    ACTIONS(641), 1,
      anon_sym_then,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(631), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(625), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25355] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    ACTIONS(559), 1,
      anon_sym_and,
    ACTIONS(567), 1,
      anon_sym_EQ,
    ACTIONS(643), 1,
      anon_sym_end,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(571), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(569), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(565), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25423] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(551), 1,
      anon_sym_PIPE,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(557), 1,
      anon_sym_or,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 13,
      anon_sym_end,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25483] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25531] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(561), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25583] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(563), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25633] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(323), 1,
      ts_builtin_sym_end,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_and,
    ACTIONS(595), 1,
      anon_sym_EQ,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(599), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(597), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(593), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [25701] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 13,
      anon_sym_then,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25761] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(277), 5,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(275), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25813] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(269), 7,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25863] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25911] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [25959] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(645), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26027] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 15,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26075] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(647), 1,
      anon_sym_SEMI,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26143] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(269), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(267), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26191] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(321), 1,
      ts_builtin_sym_end,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_and,
    ACTIONS(595), 1,
      anon_sym_EQ,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(599), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(597), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(593), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26259] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 15,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26307] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(319), 1,
      anon_sym_then,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    ACTIONS(619), 1,
      anon_sym_and,
    ACTIONS(627), 1,
      anon_sym_EQ,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(631), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(625), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26375] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(321), 1,
      anon_sym_then,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    ACTIONS(619), 1,
      anon_sym_and,
    ACTIONS(627), 1,
      anon_sym_EQ,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(631), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(625), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26443] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(323), 1,
      anon_sym_then,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    ACTIONS(619), 1,
      anon_sym_and,
    ACTIONS(627), 1,
      anon_sym_EQ,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(631), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(625), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26511] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(325), 1,
      anon_sym_then,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    ACTIONS(619), 1,
      anon_sym_and,
    ACTIONS(627), 1,
      anon_sym_EQ,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(631), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(625), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26579] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(273), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(271), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26627] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(309), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(307), 14,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26683] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_COMMA,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(317), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(315), 13,
      anon_sym_then,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26743] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    STATE(170), 1,
      sym__tokCompareOp,
    STATE(171), 1,
      sym__tokUpdateOp,
    STATE(172), 1,
      sym__tokMathHigh,
    STATE(173), 1,
      sym__tokMathLow,
    ACTIONS(313), 10,
      anon_sym_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(311), 15,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_or,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26791] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_and,
    ACTIONS(595), 1,
      anon_sym_EQ,
    ACTIONS(649), 1,
      ts_builtin_sym_end,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(599), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(597), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(593), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26859] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(615), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(617), 1,
      anon_sym_or,
    STATE(282), 1,
      sym__tokMathLow,
    STATE(283), 1,
      sym__tokMathHigh,
    STATE(284), 1,
      sym__tokUpdateOp,
    STATE(285), 1,
      sym__tokCompareOp,
    ACTIONS(621), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(623), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(331), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(329), 14,
      anon_sym_then,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [26915] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(651), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [26983] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(653), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [27051] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(333), 1,
      anon_sym_PIPE,
    ACTIONS(335), 1,
      anon_sym_COMMA,
    ACTIONS(337), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(339), 1,
      anon_sym_or,
    ACTIONS(361), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_EQ,
    ACTIONS(655), 1,
      anon_sym_RPAREN,
    STATE(258), 1,
      sym__tokMathLow,
    STATE(259), 1,
      sym__tokMathHigh,
    STATE(260), 1,
      sym__tokUpdateOp,
    STATE(261), 1,
      sym__tokCompareOp,
    ACTIONS(341), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(369), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(343), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(367), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(363), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [27119] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(325), 1,
      ts_builtin_sym_end,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_and,
    ACTIONS(595), 1,
      anon_sym_EQ,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(599), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(597), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(593), 7,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
  [27187] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      anon_sym_QMARK,
    ACTIONS(573), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(575), 1,
      anon_sym_or,
    ACTIONS(581), 1,
      anon_sym_PIPE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    STATE(299), 1,
      sym__tokMathLow,
    STATE(321), 1,
      sym__tokMathHigh,
    STATE(322), 1,
      sym__tokUpdateOp,
    STATE(323), 1,
      sym__tokCompareOp,
    ACTIONS(577), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(281), 3,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(579), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(279), 13,
      ts_builtin_sym_end,
      anon_sym_and,
      anon_sym_PIPE_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [27247] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 1,
      anon_sym_import,
    ACTIONS(660), 1,
      anon_sym_include,
    STATE(388), 2,
      sym_import_,
      aux_sym_programbody_repeat1,
    ACTIONS(665), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(663), 15,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27287] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(667), 17,
      anon_sym_import,
      anon_sym_include,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(671), 17,
      anon_sym_import,
      anon_sym_include,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(675), 17,
      anon_sym_import,
      anon_sym_include,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(679), 17,
      anon_sym_import,
      anon_sym_include,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27415] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(683), 17,
      anon_sym_import,
      anon_sym_include,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27447] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(689), 15,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27478] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      anon_sym_DOT,
    ACTIONS(697), 1,
      anon_sym_PLUS,
    ACTIONS(699), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(517), 1,
      sym_objectval,
    ACTIONS(693), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(695), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(436), 3,
      sym__term,
      sym_string,
      sym_index,
  [27539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(703), 15,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27570] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      anon_sym_DOT,
    ACTIONS(697), 1,
      anon_sym_PLUS,
    ACTIONS(699), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    STATE(523), 1,
      sym_objectval,
    ACTIONS(693), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(695), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(436), 3,
      sym__term,
      sym_string,
      sym_index,
  [27631] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [27689] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [27747] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [27805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(689), 15,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27835] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [27893] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_PLUS,
    ACTIONS(359), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [27951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_format,
      sym_number,
    ACTIONS(703), 15,
      anon_sym_def,
      anon_sym_reduce,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_try,
      anon_sym_label,
      anon_sym_DOT,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_break,
      aux_sym_identifier_token1,
      anon_sym_DQUOTE,
  [27981] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(461), 1,
      anon_sym_DOT,
    ACTIONS(463), 1,
      anon_sym_PLUS,
    ACTIONS(465), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28039] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      anon_sym_DOT,
    ACTIONS(697), 1,
      anon_sym_PLUS,
    ACTIONS(699), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28097] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(493), 1,
      anon_sym_PLUS,
    ACTIONS(495), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28155] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28213] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28271] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      anon_sym_DOT,
    ACTIONS(719), 1,
      anon_sym_PLUS,
    ACTIONS(721), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(715), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(717), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(442), 3,
      sym__term,
      sym_string,
      sym_index,
  [28329] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      anon_sym_DOT,
    ACTIONS(697), 1,
      anon_sym_PLUS,
    ACTIONS(699), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(723), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(725), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(438), 3,
      sym__term,
      sym_string,
      sym_index,
  [28387] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      anon_sym_DOT,
    ACTIONS(719), 1,
      anon_sym_PLUS,
    ACTIONS(721), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(727), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(729), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(441), 3,
      sym__term,
      sym_string,
      sym_index,
  [28445] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(481), 1,
      anon_sym_DOT,
    ACTIONS(483), 1,
      anon_sym_PLUS,
    ACTIONS(485), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28503] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(691), 1,
      anon_sym_DOT,
    ACTIONS(697), 1,
      anon_sym_PLUS,
    ACTIONS(699), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28561] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(471), 1,
      anon_sym_DOT,
    ACTIONS(473), 1,
      anon_sym_PLUS,
    ACTIONS(475), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28619] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      anon_sym_DOT,
    ACTIONS(719), 1,
      anon_sym_PLUS,
    ACTIONS(721), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28677] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      anon_sym_DOT,
    ACTIONS(719), 1,
      anon_sym_PLUS,
    ACTIONS(721), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28735] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28793] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28851] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(533), 1,
      anon_sym_DOT,
    ACTIONS(535), 1,
      anon_sym_PLUS,
    ACTIONS(537), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [28909] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [28967] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(503), 1,
      anon_sym_PLUS,
    ACTIONS(505), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [29025] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [29083] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(525), 1,
      anon_sym_PLUS,
    ACTIONS(527), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(705), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(707), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(3), 3,
      sym__term,
      sym_string,
      sym_index,
  [29141] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_PLUS,
    ACTIONS(37), 1,
      anon_sym_DASH,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [29199] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_break,
    ACTIONS(41), 1,
      aux_sym_identifier_token1,
    ACTIONS(43), 1,
      sym_format,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(513), 1,
      anon_sym_PLUS,
    ACTIONS(515), 1,
      anon_sym_DASH,
    STATE(6), 1,
      sym_funcname,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(9), 1,
      sym__IDENT,
    ACTIONS(709), 3,
      anon_sym_DOT_DOT,
      sym_variable,
      sym_number,
    ACTIONS(711), 3,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
    STATE(4), 3,
      sym__term,
      sym_string,
      sym_index,
  [29257] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(731), 1,
      anon_sym_LBRACK,
    ACTIONS(733), 1,
      anon_sym_RBRACK,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(482), 1,
      sym_constterm,
    STATE(500), 3,
      sym_constobject,
      sym_constarray,
      sym_string,
    ACTIONS(737), 4,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_number,
  [29293] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(731), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(511), 1,
      sym_constterm,
    STATE(500), 3,
      sym_constobject,
      sym_constarray,
      sym_string,
    ACTIONS(737), 4,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_number,
  [29326] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(739), 1,
      sym_keyword,
    ACTIONS(741), 1,
      anon_sym_LPAREN,
    ACTIONS(743), 1,
      anon_sym_RBRACE,
    ACTIONS(745), 1,
      sym_variable,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(476), 1,
      sym_identifier,
    STATE(519), 1,
      sym_objectkeyval,
    STATE(522), 1,
      sym_objectkeyvals,
    STATE(487), 2,
      sym_objectkey,
      sym_string,
  [29367] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(731), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(514), 1,
      sym_constterm,
    STATE(500), 3,
      sym_constobject,
      sym_constarray,
      sym_string,
    ACTIONS(737), 4,
      anon_sym_null,
      anon_sym_true,
      anon_sym_false,
      sym_number,
  [29400] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 5,
      anon_sym_PIPE,
      anon_sym_QMARK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
  [29435] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(739), 1,
      sym_keyword,
    ACTIONS(741), 1,
      anon_sym_LPAREN,
    ACTIONS(745), 1,
      sym_variable,
    ACTIONS(749), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(476), 1,
      sym_identifier,
    STATE(504), 1,
      sym_objectkeyval,
    STATE(487), 2,
      sym_objectkey,
      sym_string,
  [29473] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(739), 1,
      sym_keyword,
    ACTIONS(751), 1,
      anon_sym_LPAREN,
    ACTIONS(753), 1,
      sym_variable,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(476), 1,
      sym_identifier,
    STATE(492), 1,
      sym_objectpattern,
    STATE(526), 1,
      sym_objectpatterns,
    STATE(564), 2,
      sym_objectkey,
      sym_string,
  [29511] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(739), 1,
      sym_keyword,
    ACTIONS(751), 1,
      anon_sym_LPAREN,
    ACTIONS(753), 1,
      sym_variable,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(476), 1,
      sym_identifier,
    STATE(515), 1,
      sym_objectpattern,
    STATE(564), 2,
      sym_objectkey,
      sym_string,
  [29546] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(49), 1,
      anon_sym_as,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(23), 1,
      sym_string,
    STATE(24), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
    ACTIONS(47), 2,
      anon_sym_QMARK,
      anon_sym_DOT,
  [29581] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    ACTIONS(755), 1,
      anon_sym_PIPE,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
    STATE(460), 1,
      aux_sym_objectval_repeat1,
    ACTIONS(759), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [29610] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(761), 1,
      sym_keyword,
    ACTIONS(763), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(475), 1,
      sym_constobjectkeyval,
    STATE(575), 2,
      sym_string,
      sym_identifier,
  [29639] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
    ACTIONS(765), 3,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [29663] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(18), 1,
      sym_string,
    STATE(26), 1,
      sym_suffix,
    STATE(31), 1,
      sym_identifier,
  [29691] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(101), 1,
      aux_sym_identifier_token1,
    ACTIONS(103), 1,
      sym_format,
    ACTIONS(761), 1,
      sym_keyword,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(513), 1,
      sym_constobjectkeyval,
    STATE(575), 2,
      sym_string,
      sym_identifier,
  [29717] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(767), 1,
      anon_sym_as,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
  [29739] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_DOT,
    ACTIONS(757), 1,
      anon_sym_QMARK,
    ACTIONS(769), 1,
      anon_sym_as,
    STATE(19), 1,
      sym_index,
    STATE(20), 1,
      sym_suffix,
  [29761] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_elif,
    ACTIONS(237), 1,
      anon_sym_else,
    ACTIONS(771), 1,
      anon_sym_end,
    STATE(541), 1,
      sym_else,
    STATE(452), 2,
      sym_elif,
      aux_sym_query_repeat1,
  [29781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 6,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_COMMA,
      anon_sym_QMARK_SLASH_SLASH,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [29793] = 6,
    ACTIONS(775), 1,
      anon_sym_DQUOTE,
    ACTIONS(777), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(783), 1,
      sym_comment,
    STATE(445), 1,
      aux_sym__inner_string,
    STATE(448), 1,
      aux_sym__string_content,
    ACTIONS(780), 2,
      aux_sym__string_content_token1,
      sym__escape_sequence,
  [29813] = 6,
    ACTIONS(783), 1,
      sym_comment,
    ACTIONS(785), 1,
      anon_sym_DQUOTE,
    ACTIONS(787), 1,
      anon_sym_BSLASH_LPAREN,
    STATE(447), 1,
      aux_sym__inner_string,
    STATE(448), 1,
      aux_sym__string_content,
    ACTIONS(789), 2,
      aux_sym__string_content_token1,
      sym__escape_sequence,
  [29833] = 6,
    ACTIONS(783), 1,
      sym_comment,
    ACTIONS(787), 1,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(791), 1,
      anon_sym_DQUOTE,
    STATE(445), 1,
      aux_sym__inner_string,
    STATE(448), 1,
      aux_sym__string_content,
    ACTIONS(789), 2,
      aux_sym__string_content_token1,
      sym__escape_sequence,
  [29853] = 4,
    ACTIONS(783), 1,
      sym_comment,
    STATE(451), 1,
      aux_sym__string_content,
    ACTIONS(793), 2,
      anon_sym_DQUOTE,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(795), 2,
      aux_sym__string_content_token1,
      sym__escape_sequence,
  [29868] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(801), 1,
      sym_variable,
    STATE(496), 1,
      sym__pattern,
    STATE(547), 1,
      sym_arraypatterns,
  [29887] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(803), 1,
      sym_variable,
    STATE(477), 1,
      sym__pattern,
    STATE(558), 1,
      sym__bindpatterns,
  [29906] = 4,
    ACTIONS(783), 1,
      sym_comment,
    STATE(451), 1,
      aux_sym__string_content,
    ACTIONS(805), 2,
      anon_sym_DQUOTE,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(807), 2,
      aux_sym__string_content_token1,
      sym__escape_sequence,
  [29921] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      anon_sym_elif,
    ACTIONS(810), 2,
      anon_sym_end,
      anon_sym_else,
    STATE(452), 2,
      sym_elif,
      aux_sym_query_repeat1,
  [29936] = 3,
    ACTIONS(783), 1,
      sym_comment,
    ACTIONS(815), 2,
      anon_sym_DQUOTE,
      anon_sym_BSLASH_LPAREN,
    ACTIONS(817), 2,
      aux_sym__string_content_token1,
      sym__escape_sequence,
  [29948] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      anon_sym_PIPE,
    STATE(454), 1,
      aux_sym_objectval_repeat1,
    ACTIONS(822), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [29962] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(824), 1,
      sym_variable,
    STATE(509), 1,
      sym__pattern,
  [29978] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(826), 1,
      sym_variable,
    STATE(512), 1,
      sym__pattern,
  [29994] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(828), 1,
      sym_variable,
    STATE(516), 1,
      sym__pattern,
  [30010] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(553), 1,
      sym_string,
  [30026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30036] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 1,
      anon_sym_PIPE,
    STATE(454), 1,
      aux_sym_objectval_repeat1,
    ACTIONS(832), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30050] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30060] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 1,
      ts_builtin_sym_end,
    ACTIONS(836), 1,
      anon_sym_def,
    STATE(466), 2,
      sym_funcdef,
      aux_sym_programbody_repeat2,
  [30074] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym_format,
    STATE(7), 1,
      sym__QQSTRING,
    STATE(491), 1,
      sym_string,
  [30090] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(838), 1,
      sym_variable,
    STATE(524), 1,
      sym__pattern,
  [30106] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    ACTIONS(840), 1,
      sym_variable,
    STATE(481), 2,
      sym__tokIdentVariable,
      sym_identifier,
  [30120] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      ts_builtin_sym_end,
    ACTIONS(844), 1,
      anon_sym_def,
    STATE(466), 2,
      sym_funcdef,
      aux_sym_programbody_repeat2,
  [30134] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30144] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(849), 1,
      sym_variable,
    STATE(536), 1,
      sym__pattern,
  [30160] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(589), 1,
      ts_builtin_sym_end,
    ACTIONS(836), 1,
      anon_sym_def,
    STATE(466), 2,
      sym_funcdef,
      aux_sym_programbody_repeat2,
  [30174] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    ACTIONS(851), 1,
      sym_variable,
    STATE(486), 2,
      sym__tokIdentVariable,
      sym_identifier,
  [30188] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    ACTIONS(853), 1,
      sym_variable,
    STATE(521), 2,
      sym__tokIdentVariable,
      sym_identifier,
  [30202] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      anon_sym_LBRACK,
    ACTIONS(799), 1,
      anon_sym_LBRACE,
    ACTIONS(855), 1,
      sym_variable,
    STATE(535), 1,
      sym__pattern,
  [30218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(857), 1,
      anon_sym_SEMI,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
    STATE(473), 1,
      aux_sym_funcdefargs_repeat1,
  [30231] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_COLON,
    ACTIONS(864), 1,
      anon_sym_LPAREN,
    STATE(574), 1,
      sym_funcdefargs,
  [30244] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(868), 1,
      anon_sym_RBRACE,
    STATE(489), 1,
      aux_sym_constobject_repeat1,
  [30257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 3,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30266] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_QMARK_SLASH_SLASH,
    STATE(483), 1,
      aux_sym__bindpatterns_repeat1,
  [30279] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 1,
      anon_sym_COMMA,
    ACTIONS(879), 1,
      anon_sym_RBRACE,
    STATE(478), 1,
      aux_sym_constobject_repeat1,
  [30292] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      anon_sym_SEMI,
    ACTIONS(883), 1,
      anon_sym_RPAREN,
    STATE(473), 1,
      aux_sym_funcdefargs_repeat1,
  [30305] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(885), 1,
      anon_sym_COMMA,
    ACTIONS(887), 1,
      anon_sym_RBRACE,
    STATE(493), 1,
      aux_sym_objectpatterns_repeat1,
  [30318] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    ACTIONS(889), 1,
      anon_sym_SEMI,
    STATE(540), 1,
      sym_constobject,
  [30331] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 1,
      anon_sym_COMMA,
    ACTIONS(893), 1,
      anon_sym_RBRACK,
    STATE(499), 1,
      aux_sym_constarray_repeat1,
  [30344] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 1,
      anon_sym_QMARK_SLASH_SLASH,
    ACTIONS(895), 1,
      anon_sym_PIPE,
    STATE(485), 1,
      aux_sym__bindpatterns_repeat1,
  [30357] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 3,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30366] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 1,
      anon_sym_PIPE,
    ACTIONS(901), 1,
      anon_sym_QMARK_SLASH_SLASH,
    STATE(485), 1,
      aux_sym__bindpatterns_repeat1,
  [30379] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 1,
      anon_sym_SEMI,
    ACTIONS(904), 1,
      anon_sym_RPAREN,
    STATE(479), 1,
      aux_sym_funcdefargs_repeat1,
  [30392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 1,
      anon_sym_COLON,
    ACTIONS(908), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30403] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 1,
      anon_sym_COMMA,
    ACTIONS(913), 1,
      anon_sym_RBRACK,
    STATE(488), 1,
      aux_sym_arraypatterns_repeat1,
  [30416] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(915), 1,
      anon_sym_RBRACE,
    STATE(478), 1,
      aux_sym_constobject_repeat1,
  [30429] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(920), 1,
      anon_sym_RBRACK,
    STATE(490), 1,
      aux_sym_constarray_repeat1,
  [30442] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    ACTIONS(922), 1,
      anon_sym_SEMI,
    STATE(561), 1,
      sym_constobject,
  [30455] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(885), 1,
      anon_sym_COMMA,
    ACTIONS(924), 1,
      anon_sym_RBRACE,
    STATE(480), 1,
      aux_sym_objectpatterns_repeat1,
  [30468] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 1,
      anon_sym_COMMA,
    ACTIONS(929), 1,
      anon_sym_RBRACE,
    STATE(493), 1,
      aux_sym_objectpatterns_repeat1,
  [30481] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_LPAREN,
    ACTIONS(931), 1,
      anon_sym_COLON,
    STATE(557), 1,
      sym_funcdefargs,
  [30494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      anon_sym_COLON,
    ACTIONS(933), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30505] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(937), 1,
      anon_sym_RBRACK,
    STATE(497), 1,
      aux_sym_arraypatterns_repeat1,
  [30518] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(939), 1,
      anon_sym_RBRACK,
    STATE(488), 1,
      aux_sym_arraypatterns_repeat1,
  [30531] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 3,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30540] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 1,
      anon_sym_COMMA,
    ACTIONS(943), 1,
      anon_sym_RBRACK,
    STATE(490), 1,
      aux_sym_constarray_repeat1,
  [30553] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 3,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 3,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30571] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      anon_sym_LPAREN,
    ACTIONS(949), 1,
      anon_sym_COLON,
    STATE(576), 1,
      sym_funcdefargs,
  [30584] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    STATE(494), 1,
      sym_identifier,
  [30594] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30602] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    STATE(502), 1,
      sym_identifier,
  [30612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 1,
      aux_sym_identifier_token1,
    STATE(474), 1,
      sym_identifier,
  [30622] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 2,
      ts_builtin_sym_end,
      anon_sym_def,
  [30630] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 2,
      ts_builtin_sym_end,
      anon_sym_def,
  [30638] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      anon_sym_SEMI,
    ACTIONS(957), 1,
      anon_sym_RPAREN,
  [30656] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [30664] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(959), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30672] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30680] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(961), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30688] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30696] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [30704] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(963), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30712] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_LBRACE,
    STATE(528), 1,
      sym_constobject,
  [30722] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30730] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    STATE(8), 1,
      sym__QQSTRING,
  [30740] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [30748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(967), 1,
      anon_sym_COMMA,
    ACTIONS(969), 1,
      anon_sym_RBRACE,
  [30758] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [30766] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 2,
      anon_sym_PIPE,
      anon_sym_QMARK_SLASH_SLASH,
  [30774] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(973), 1,
      anon_sym_PIPE,
  [30781] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_RBRACE,
  [30788] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      sym_variable,
  [30795] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 1,
      anon_sym_SEMI,
  [30802] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(771), 1,
      anon_sym_end,
  [30809] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      anon_sym_PIPE,
  [30816] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 1,
      anon_sym_COLON,
  [30823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 1,
      anon_sym_PIPE,
  [30830] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(987), 1,
      anon_sym_PIPE,
  [30837] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_PIPE,
  [30844] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_LPAREN,
  [30851] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(993), 1,
      anon_sym_LPAREN,
  [30858] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(995), 1,
      anon_sym_PIPE,
  [30865] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(997), 1,
      anon_sym_PIPE,
  [30872] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(999), 1,
      anon_sym_COLON,
  [30879] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_SEMI,
  [30886] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_end,
  [30893] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      anon_sym_PIPE,
  [30900] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      anon_sym_COLON,
  [30907] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      anon_sym_PIPE,
  [30914] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1011), 1,
      anon_sym_PIPE,
  [30921] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 1,
      anon_sym_PIPE,
  [30928] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_RBRACK,
  [30935] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_PIPE,
  [30942] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_COLON,
  [30949] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_PIPE,
  [30956] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 1,
      ts_builtin_sym_end,
  [30963] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 1,
      ts_builtin_sym_end,
  [30970] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_as,
  [30977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_PIPE,
  [30984] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_PIPE,
  [30991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 1,
      sym_variable,
  [30998] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1033), 1,
      anon_sym_COLON,
  [31005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 1,
      anon_sym_PIPE,
  [31012] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_PIPE,
  [31019] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1039), 1,
      ts_builtin_sym_end,
  [31026] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      anon_sym_SEMI,
  [31033] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 1,
      sym_variable,
  [31040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 1,
      sym_variable,
  [31047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_COLON,
  [31054] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      anon_sym_PIPE,
  [31061] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      sym_variable,
  [31068] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      sym_variable,
  [31075] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 1,
      sym_variable,
  [31082] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1057), 1,
      sym_variable,
  [31089] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 1,
      sym_variable,
  [31096] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1061), 1,
      sym_variable,
  [31103] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      sym_variable,
  [31110] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1065), 1,
      anon_sym_PIPE,
  [31117] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_COLON,
  [31124] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1069), 1,
      anon_sym_COLON,
  [31131] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      anon_sym_COLON,
  [31138] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1073), 1,
      anon_sym_PIPE,
  [31145] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_PIPE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 53,
  [SMALL_STATE(4)] = 110,
  [SMALL_STATE(5)] = 167,
  [SMALL_STATE(6)] = 216,
  [SMALL_STATE(7)] = 266,
  [SMALL_STATE(8)] = 314,
  [SMALL_STATE(9)] = 362,
  [SMALL_STATE(10)] = 410,
  [SMALL_STATE(11)] = 458,
  [SMALL_STATE(12)] = 516,
  [SMALL_STATE(13)] = 564,
  [SMALL_STATE(14)] = 628,
  [SMALL_STATE(15)] = 675,
  [SMALL_STATE(16)] = 722,
  [SMALL_STATE(17)] = 769,
  [SMALL_STATE(18)] = 832,
  [SMALL_STATE(19)] = 879,
  [SMALL_STATE(20)] = 926,
  [SMALL_STATE(21)] = 973,
  [SMALL_STATE(22)] = 1020,
  [SMALL_STATE(23)] = 1083,
  [SMALL_STATE(24)] = 1130,
  [SMALL_STATE(25)] = 1177,
  [SMALL_STATE(26)] = 1224,
  [SMALL_STATE(27)] = 1271,
  [SMALL_STATE(28)] = 1318,
  [SMALL_STATE(29)] = 1365,
  [SMALL_STATE(30)] = 1412,
  [SMALL_STATE(31)] = 1459,
  [SMALL_STATE(32)] = 1506,
  [SMALL_STATE(33)] = 1553,
  [SMALL_STATE(34)] = 1600,
  [SMALL_STATE(35)] = 1647,
  [SMALL_STATE(36)] = 1694,
  [SMALL_STATE(37)] = 1756,
  [SMALL_STATE(38)] = 1817,
  [SMALL_STATE(39)] = 1918,
  [SMALL_STATE(40)] = 1979,
  [SMALL_STATE(41)] = 2040,
  [SMALL_STATE(42)] = 2100,
  [SMALL_STATE(43)] = 2198,
  [SMALL_STATE(44)] = 2258,
  [SMALL_STATE(45)] = 2318,
  [SMALL_STATE(46)] = 2395,
  [SMALL_STATE(47)] = 2438,
  [SMALL_STATE(48)] = 2481,
  [SMALL_STATE(49)] = 2524,
  [SMALL_STATE(50)] = 2567,
  [SMALL_STATE(51)] = 2648,
  [SMALL_STATE(52)] = 2691,
  [SMALL_STATE(53)] = 2734,
  [SMALL_STATE(54)] = 2777,
  [SMALL_STATE(55)] = 2854,
  [SMALL_STATE(56)] = 2897,
  [SMALL_STATE(57)] = 2951,
  [SMALL_STATE(58)] = 3003,
  [SMALL_STATE(59)] = 3055,
  [SMALL_STATE(60)] = 3111,
  [SMALL_STATE(61)] = 3175,
  [SMALL_STATE(62)] = 3251,
  [SMALL_STATE(63)] = 3311,
  [SMALL_STATE(64)] = 3363,
  [SMALL_STATE(65)] = 3427,
  [SMALL_STATE(66)] = 3499,
  [SMALL_STATE(67)] = 3571,
  [SMALL_STATE(68)] = 3643,
  [SMALL_STATE(69)] = 3715,
  [SMALL_STATE(70)] = 3791,
  [SMALL_STATE(71)] = 3851,
  [SMALL_STATE(72)] = 3914,
  [SMALL_STATE(73)] = 3965,
  [SMALL_STATE(74)] = 4036,
  [SMALL_STATE(75)] = 4087,
  [SMALL_STATE(76)] = 4138,
  [SMALL_STATE(77)] = 4189,
  [SMALL_STATE(78)] = 4242,
  [SMALL_STATE(79)] = 4297,
  [SMALL_STATE(80)] = 4348,
  [SMALL_STATE(81)] = 4419,
  [SMALL_STATE(82)] = 4490,
  [SMALL_STATE(83)] = 4541,
  [SMALL_STATE(84)] = 4632,
  [SMALL_STATE(85)] = 4691,
  [SMALL_STATE(86)] = 4744,
  [SMALL_STATE(87)] = 4815,
  [SMALL_STATE(88)] = 4870,
  [SMALL_STATE(89)] = 4933,
  [SMALL_STATE(90)] = 4992,
  [SMALL_STATE(91)] = 5051,
  [SMALL_STATE(92)] = 5114,
  [SMALL_STATE(93)] = 5177,
  [SMALL_STATE(94)] = 5248,
  [SMALL_STATE(95)] = 5319,
  [SMALL_STATE(96)] = 5390,
  [SMALL_STATE(97)] = 5461,
  [SMALL_STATE(98)] = 5520,
  [SMALL_STATE(99)] = 5608,
  [SMALL_STATE(100)] = 5678,
  [SMALL_STATE(101)] = 5752,
  [SMALL_STATE(102)] = 5802,
  [SMALL_STATE(103)] = 5872,
  [SMALL_STATE(104)] = 5942,
  [SMALL_STATE(105)] = 6012,
  [SMALL_STATE(106)] = 6086,
  [SMALL_STATE(107)] = 6174,
  [SMALL_STATE(108)] = 6244,
  [SMALL_STATE(109)] = 6302,
  [SMALL_STATE(110)] = 6352,
  [SMALL_STATE(111)] = 6410,
  [SMALL_STATE(112)] = 6460,
  [SMALL_STATE(113)] = 6512,
  [SMALL_STATE(114)] = 6566,
  [SMALL_STATE(115)] = 6628,
  [SMALL_STATE(116)] = 6690,
  [SMALL_STATE(117)] = 6764,
  [SMALL_STATE(118)] = 6838,
  [SMALL_STATE(119)] = 6926,
  [SMALL_STATE(120)] = 7000,
  [SMALL_STATE(121)] = 7088,
  [SMALL_STATE(122)] = 7162,
  [SMALL_STATE(123)] = 7247,
  [SMALL_STATE(124)] = 7332,
  [SMALL_STATE(125)] = 7417,
  [SMALL_STATE(126)] = 7502,
  [SMALL_STATE(127)] = 7587,
  [SMALL_STATE(128)] = 7672,
  [SMALL_STATE(129)] = 7757,
  [SMALL_STATE(130)] = 7842,
  [SMALL_STATE(131)] = 7927,
  [SMALL_STATE(132)] = 8012,
  [SMALL_STATE(133)] = 8097,
  [SMALL_STATE(134)] = 8146,
  [SMALL_STATE(135)] = 8215,
  [SMALL_STATE(136)] = 8264,
  [SMALL_STATE(137)] = 8313,
  [SMALL_STATE(138)] = 8364,
  [SMALL_STATE(139)] = 8417,
  [SMALL_STATE(140)] = 8478,
  [SMALL_STATE(141)] = 8563,
  [SMALL_STATE(142)] = 8632,
  [SMALL_STATE(143)] = 8701,
  [SMALL_STATE(144)] = 8770,
  [SMALL_STATE(145)] = 8855,
  [SMALL_STATE(146)] = 8924,
  [SMALL_STATE(147)] = 8981,
  [SMALL_STATE(148)] = 9038,
  [SMALL_STATE(149)] = 9099,
  [SMALL_STATE(150)] = 9184,
  [SMALL_STATE(151)] = 9269,
  [SMALL_STATE(152)] = 9354,
  [SMALL_STATE(153)] = 9439,
  [SMALL_STATE(154)] = 9524,
  [SMALL_STATE(155)] = 9609,
  [SMALL_STATE(156)] = 9694,
  [SMALL_STATE(157)] = 9779,
  [SMALL_STATE(158)] = 9864,
  [SMALL_STATE(159)] = 9949,
  [SMALL_STATE(160)] = 10034,
  [SMALL_STATE(161)] = 10119,
  [SMALL_STATE(162)] = 10204,
  [SMALL_STATE(163)] = 10289,
  [SMALL_STATE(164)] = 10374,
  [SMALL_STATE(165)] = 10459,
  [SMALL_STATE(166)] = 10544,
  [SMALL_STATE(167)] = 10629,
  [SMALL_STATE(168)] = 10714,
  [SMALL_STATE(169)] = 10799,
  [SMALL_STATE(170)] = 10884,
  [SMALL_STATE(171)] = 10969,
  [SMALL_STATE(172)] = 11054,
  [SMALL_STATE(173)] = 11139,
  [SMALL_STATE(174)] = 11224,
  [SMALL_STATE(175)] = 11309,
  [SMALL_STATE(176)] = 11394,
  [SMALL_STATE(177)] = 11479,
  [SMALL_STATE(178)] = 11564,
  [SMALL_STATE(179)] = 11649,
  [SMALL_STATE(180)] = 11734,
  [SMALL_STATE(181)] = 11819,
  [SMALL_STATE(182)] = 11904,
  [SMALL_STATE(183)] = 11989,
  [SMALL_STATE(184)] = 12074,
  [SMALL_STATE(185)] = 12159,
  [SMALL_STATE(186)] = 12244,
  [SMALL_STATE(187)] = 12329,
  [SMALL_STATE(188)] = 12414,
  [SMALL_STATE(189)] = 12499,
  [SMALL_STATE(190)] = 12584,
  [SMALL_STATE(191)] = 12669,
  [SMALL_STATE(192)] = 12754,
  [SMALL_STATE(193)] = 12839,
  [SMALL_STATE(194)] = 12924,
  [SMALL_STATE(195)] = 13009,
  [SMALL_STATE(196)] = 13058,
  [SMALL_STATE(197)] = 13107,
  [SMALL_STATE(198)] = 13156,
  [SMALL_STATE(199)] = 13207,
  [SMALL_STATE(200)] = 13260,
  [SMALL_STATE(201)] = 13321,
  [SMALL_STATE(202)] = 13406,
  [SMALL_STATE(203)] = 13491,
  [SMALL_STATE(204)] = 13576,
  [SMALL_STATE(205)] = 13645,
  [SMALL_STATE(206)] = 13730,
  [SMALL_STATE(207)] = 13815,
  [SMALL_STATE(208)] = 13900,
  [SMALL_STATE(209)] = 13985,
  [SMALL_STATE(210)] = 14070,
  [SMALL_STATE(211)] = 14155,
  [SMALL_STATE(212)] = 14240,
  [SMALL_STATE(213)] = 14325,
  [SMALL_STATE(214)] = 14410,
  [SMALL_STATE(215)] = 14495,
  [SMALL_STATE(216)] = 14580,
  [SMALL_STATE(217)] = 14651,
  [SMALL_STATE(218)] = 14736,
  [SMALL_STATE(219)] = 14821,
  [SMALL_STATE(220)] = 14906,
  [SMALL_STATE(221)] = 14975,
  [SMALL_STATE(222)] = 15044,
  [SMALL_STATE(223)] = 15129,
  [SMALL_STATE(224)] = 15198,
  [SMALL_STATE(225)] = 15267,
  [SMALL_STATE(226)] = 15324,
  [SMALL_STATE(227)] = 15381,
  [SMALL_STATE(228)] = 15442,
  [SMALL_STATE(229)] = 15527,
  [SMALL_STATE(230)] = 15612,
  [SMALL_STATE(231)] = 15697,
  [SMALL_STATE(232)] = 15782,
  [SMALL_STATE(233)] = 15867,
  [SMALL_STATE(234)] = 15952,
  [SMALL_STATE(235)] = 16037,
  [SMALL_STATE(236)] = 16122,
  [SMALL_STATE(237)] = 16207,
  [SMALL_STATE(238)] = 16292,
  [SMALL_STATE(239)] = 16377,
  [SMALL_STATE(240)] = 16462,
  [SMALL_STATE(241)] = 16547,
  [SMALL_STATE(242)] = 16618,
  [SMALL_STATE(243)] = 16703,
  [SMALL_STATE(244)] = 16788,
  [SMALL_STATE(245)] = 16837,
  [SMALL_STATE(246)] = 16922,
  [SMALL_STATE(247)] = 17007,
  [SMALL_STATE(248)] = 17056,
  [SMALL_STATE(249)] = 17141,
  [SMALL_STATE(250)] = 17226,
  [SMALL_STATE(251)] = 17275,
  [SMALL_STATE(252)] = 17326,
  [SMALL_STATE(253)] = 17411,
  [SMALL_STATE(254)] = 17496,
  [SMALL_STATE(255)] = 17581,
  [SMALL_STATE(256)] = 17666,
  [SMALL_STATE(257)] = 17751,
  [SMALL_STATE(258)] = 17836,
  [SMALL_STATE(259)] = 17921,
  [SMALL_STATE(260)] = 18006,
  [SMALL_STATE(261)] = 18091,
  [SMALL_STATE(262)] = 18176,
  [SMALL_STATE(263)] = 18261,
  [SMALL_STATE(264)] = 18346,
  [SMALL_STATE(265)] = 18431,
  [SMALL_STATE(266)] = 18484,
  [SMALL_STATE(267)] = 18545,
  [SMALL_STATE(268)] = 18630,
  [SMALL_STATE(269)] = 18715,
  [SMALL_STATE(270)] = 18800,
  [SMALL_STATE(271)] = 18885,
  [SMALL_STATE(272)] = 18970,
  [SMALL_STATE(273)] = 19055,
  [SMALL_STATE(274)] = 19140,
  [SMALL_STATE(275)] = 19225,
  [SMALL_STATE(276)] = 19310,
  [SMALL_STATE(277)] = 19395,
  [SMALL_STATE(278)] = 19480,
  [SMALL_STATE(279)] = 19565,
  [SMALL_STATE(280)] = 19650,
  [SMALL_STATE(281)] = 19735,
  [SMALL_STATE(282)] = 19820,
  [SMALL_STATE(283)] = 19905,
  [SMALL_STATE(284)] = 19990,
  [SMALL_STATE(285)] = 20075,
  [SMALL_STATE(286)] = 20160,
  [SMALL_STATE(287)] = 20245,
  [SMALL_STATE(288)] = 20330,
  [SMALL_STATE(289)] = 20415,
  [SMALL_STATE(290)] = 20500,
  [SMALL_STATE(291)] = 20585,
  [SMALL_STATE(292)] = 20670,
  [SMALL_STATE(293)] = 20755,
  [SMALL_STATE(294)] = 20840,
  [SMALL_STATE(295)] = 20925,
  [SMALL_STATE(296)] = 21010,
  [SMALL_STATE(297)] = 21095,
  [SMALL_STATE(298)] = 21180,
  [SMALL_STATE(299)] = 21265,
  [SMALL_STATE(300)] = 21350,
  [SMALL_STATE(301)] = 21435,
  [SMALL_STATE(302)] = 21520,
  [SMALL_STATE(303)] = 21589,
  [SMALL_STATE(304)] = 21658,
  [SMALL_STATE(305)] = 21727,
  [SMALL_STATE(306)] = 21796,
  [SMALL_STATE(307)] = 21853,
  [SMALL_STATE(308)] = 21910,
  [SMALL_STATE(309)] = 21971,
  [SMALL_STATE(310)] = 22056,
  [SMALL_STATE(311)] = 22141,
  [SMALL_STATE(312)] = 22226,
  [SMALL_STATE(313)] = 22311,
  [SMALL_STATE(314)] = 22396,
  [SMALL_STATE(315)] = 22481,
  [SMALL_STATE(316)] = 22566,
  [SMALL_STATE(317)] = 22651,
  [SMALL_STATE(318)] = 22736,
  [SMALL_STATE(319)] = 22821,
  [SMALL_STATE(320)] = 22906,
  [SMALL_STATE(321)] = 22991,
  [SMALL_STATE(322)] = 23076,
  [SMALL_STATE(323)] = 23161,
  [SMALL_STATE(324)] = 23246,
  [SMALL_STATE(325)] = 23331,
  [SMALL_STATE(326)] = 23416,
  [SMALL_STATE(327)] = 23501,
  [SMALL_STATE(328)] = 23569,
  [SMALL_STATE(329)] = 23637,
  [SMALL_STATE(330)] = 23693,
  [SMALL_STATE(331)] = 23761,
  [SMALL_STATE(332)] = 23817,
  [SMALL_STATE(333)] = 23877,
  [SMALL_STATE(334)] = 23945,
  [SMALL_STATE(335)] = 24013,
  [SMALL_STATE(336)] = 24081,
  [SMALL_STATE(337)] = 24149,
  [SMALL_STATE(338)] = 24217,
  [SMALL_STATE(339)] = 24273,
  [SMALL_STATE(340)] = 24329,
  [SMALL_STATE(341)] = 24389,
  [SMALL_STATE(342)] = 24457,
  [SMALL_STATE(343)] = 24525,
  [SMALL_STATE(344)] = 24575,
  [SMALL_STATE(345)] = 24643,
  [SMALL_STATE(346)] = 24711,
  [SMALL_STATE(347)] = 24779,
  [SMALL_STATE(348)] = 24827,
  [SMALL_STATE(349)] = 24879,
  [SMALL_STATE(350)] = 24947,
  [SMALL_STATE(351)] = 25015,
  [SMALL_STATE(352)] = 25083,
  [SMALL_STATE(353)] = 25151,
  [SMALL_STATE(354)] = 25219,
  [SMALL_STATE(355)] = 25287,
  [SMALL_STATE(356)] = 25355,
  [SMALL_STATE(357)] = 25423,
  [SMALL_STATE(358)] = 25483,
  [SMALL_STATE(359)] = 25531,
  [SMALL_STATE(360)] = 25583,
  [SMALL_STATE(361)] = 25633,
  [SMALL_STATE(362)] = 25701,
  [SMALL_STATE(363)] = 25761,
  [SMALL_STATE(364)] = 25813,
  [SMALL_STATE(365)] = 25863,
  [SMALL_STATE(366)] = 25911,
  [SMALL_STATE(367)] = 25959,
  [SMALL_STATE(368)] = 26027,
  [SMALL_STATE(369)] = 26075,
  [SMALL_STATE(370)] = 26143,
  [SMALL_STATE(371)] = 26191,
  [SMALL_STATE(372)] = 26259,
  [SMALL_STATE(373)] = 26307,
  [SMALL_STATE(374)] = 26375,
  [SMALL_STATE(375)] = 26443,
  [SMALL_STATE(376)] = 26511,
  [SMALL_STATE(377)] = 26579,
  [SMALL_STATE(378)] = 26627,
  [SMALL_STATE(379)] = 26683,
  [SMALL_STATE(380)] = 26743,
  [SMALL_STATE(381)] = 26791,
  [SMALL_STATE(382)] = 26859,
  [SMALL_STATE(383)] = 26915,
  [SMALL_STATE(384)] = 26983,
  [SMALL_STATE(385)] = 27051,
  [SMALL_STATE(386)] = 27119,
  [SMALL_STATE(387)] = 27187,
  [SMALL_STATE(388)] = 27247,
  [SMALL_STATE(389)] = 27287,
  [SMALL_STATE(390)] = 27319,
  [SMALL_STATE(391)] = 27351,
  [SMALL_STATE(392)] = 27383,
  [SMALL_STATE(393)] = 27415,
  [SMALL_STATE(394)] = 27447,
  [SMALL_STATE(395)] = 27478,
  [SMALL_STATE(396)] = 27539,
  [SMALL_STATE(397)] = 27570,
  [SMALL_STATE(398)] = 27631,
  [SMALL_STATE(399)] = 27689,
  [SMALL_STATE(400)] = 27747,
  [SMALL_STATE(401)] = 27805,
  [SMALL_STATE(402)] = 27835,
  [SMALL_STATE(403)] = 27893,
  [SMALL_STATE(404)] = 27951,
  [SMALL_STATE(405)] = 27981,
  [SMALL_STATE(406)] = 28039,
  [SMALL_STATE(407)] = 28097,
  [SMALL_STATE(408)] = 28155,
  [SMALL_STATE(409)] = 28213,
  [SMALL_STATE(410)] = 28271,
  [SMALL_STATE(411)] = 28329,
  [SMALL_STATE(412)] = 28387,
  [SMALL_STATE(413)] = 28445,
  [SMALL_STATE(414)] = 28503,
  [SMALL_STATE(415)] = 28561,
  [SMALL_STATE(416)] = 28619,
  [SMALL_STATE(417)] = 28677,
  [SMALL_STATE(418)] = 28735,
  [SMALL_STATE(419)] = 28793,
  [SMALL_STATE(420)] = 28851,
  [SMALL_STATE(421)] = 28909,
  [SMALL_STATE(422)] = 28967,
  [SMALL_STATE(423)] = 29025,
  [SMALL_STATE(424)] = 29083,
  [SMALL_STATE(425)] = 29141,
  [SMALL_STATE(426)] = 29199,
  [SMALL_STATE(427)] = 29257,
  [SMALL_STATE(428)] = 29293,
  [SMALL_STATE(429)] = 29326,
  [SMALL_STATE(430)] = 29367,
  [SMALL_STATE(431)] = 29400,
  [SMALL_STATE(432)] = 29435,
  [SMALL_STATE(433)] = 29473,
  [SMALL_STATE(434)] = 29511,
  [SMALL_STATE(435)] = 29546,
  [SMALL_STATE(436)] = 29581,
  [SMALL_STATE(437)] = 29610,
  [SMALL_STATE(438)] = 29639,
  [SMALL_STATE(439)] = 29663,
  [SMALL_STATE(440)] = 29691,
  [SMALL_STATE(441)] = 29717,
  [SMALL_STATE(442)] = 29739,
  [SMALL_STATE(443)] = 29761,
  [SMALL_STATE(444)] = 29781,
  [SMALL_STATE(445)] = 29793,
  [SMALL_STATE(446)] = 29813,
  [SMALL_STATE(447)] = 29833,
  [SMALL_STATE(448)] = 29853,
  [SMALL_STATE(449)] = 29868,
  [SMALL_STATE(450)] = 29887,
  [SMALL_STATE(451)] = 29906,
  [SMALL_STATE(452)] = 29921,
  [SMALL_STATE(453)] = 29936,
  [SMALL_STATE(454)] = 29948,
  [SMALL_STATE(455)] = 29962,
  [SMALL_STATE(456)] = 29978,
  [SMALL_STATE(457)] = 29994,
  [SMALL_STATE(458)] = 30010,
  [SMALL_STATE(459)] = 30026,
  [SMALL_STATE(460)] = 30036,
  [SMALL_STATE(461)] = 30050,
  [SMALL_STATE(462)] = 30060,
  [SMALL_STATE(463)] = 30074,
  [SMALL_STATE(464)] = 30090,
  [SMALL_STATE(465)] = 30106,
  [SMALL_STATE(466)] = 30120,
  [SMALL_STATE(467)] = 30134,
  [SMALL_STATE(468)] = 30144,
  [SMALL_STATE(469)] = 30160,
  [SMALL_STATE(470)] = 30174,
  [SMALL_STATE(471)] = 30188,
  [SMALL_STATE(472)] = 30202,
  [SMALL_STATE(473)] = 30218,
  [SMALL_STATE(474)] = 30231,
  [SMALL_STATE(475)] = 30244,
  [SMALL_STATE(476)] = 30257,
  [SMALL_STATE(477)] = 30266,
  [SMALL_STATE(478)] = 30279,
  [SMALL_STATE(479)] = 30292,
  [SMALL_STATE(480)] = 30305,
  [SMALL_STATE(481)] = 30318,
  [SMALL_STATE(482)] = 30331,
  [SMALL_STATE(483)] = 30344,
  [SMALL_STATE(484)] = 30357,
  [SMALL_STATE(485)] = 30366,
  [SMALL_STATE(486)] = 30379,
  [SMALL_STATE(487)] = 30392,
  [SMALL_STATE(488)] = 30403,
  [SMALL_STATE(489)] = 30416,
  [SMALL_STATE(490)] = 30429,
  [SMALL_STATE(491)] = 30442,
  [SMALL_STATE(492)] = 30455,
  [SMALL_STATE(493)] = 30468,
  [SMALL_STATE(494)] = 30481,
  [SMALL_STATE(495)] = 30494,
  [SMALL_STATE(496)] = 30505,
  [SMALL_STATE(497)] = 30518,
  [SMALL_STATE(498)] = 30531,
  [SMALL_STATE(499)] = 30540,
  [SMALL_STATE(500)] = 30553,
  [SMALL_STATE(501)] = 30562,
  [SMALL_STATE(502)] = 30571,
  [SMALL_STATE(503)] = 30584,
  [SMALL_STATE(504)] = 30594,
  [SMALL_STATE(505)] = 30602,
  [SMALL_STATE(506)] = 30612,
  [SMALL_STATE(507)] = 30622,
  [SMALL_STATE(508)] = 30630,
  [SMALL_STATE(509)] = 30638,
  [SMALL_STATE(510)] = 30646,
  [SMALL_STATE(511)] = 30656,
  [SMALL_STATE(512)] = 30664,
  [SMALL_STATE(513)] = 30672,
  [SMALL_STATE(514)] = 30680,
  [SMALL_STATE(515)] = 30688,
  [SMALL_STATE(516)] = 30696,
  [SMALL_STATE(517)] = 30704,
  [SMALL_STATE(518)] = 30712,
  [SMALL_STATE(519)] = 30722,
  [SMALL_STATE(520)] = 30730,
  [SMALL_STATE(521)] = 30740,
  [SMALL_STATE(522)] = 30748,
  [SMALL_STATE(523)] = 30758,
  [SMALL_STATE(524)] = 30766,
  [SMALL_STATE(525)] = 30774,
  [SMALL_STATE(526)] = 30781,
  [SMALL_STATE(527)] = 30788,
  [SMALL_STATE(528)] = 30795,
  [SMALL_STATE(529)] = 30802,
  [SMALL_STATE(530)] = 30809,
  [SMALL_STATE(531)] = 30816,
  [SMALL_STATE(532)] = 30823,
  [SMALL_STATE(533)] = 30830,
  [SMALL_STATE(534)] = 30837,
  [SMALL_STATE(535)] = 30844,
  [SMALL_STATE(536)] = 30851,
  [SMALL_STATE(537)] = 30858,
  [SMALL_STATE(538)] = 30865,
  [SMALL_STATE(539)] = 30872,
  [SMALL_STATE(540)] = 30879,
  [SMALL_STATE(541)] = 30886,
  [SMALL_STATE(542)] = 30893,
  [SMALL_STATE(543)] = 30900,
  [SMALL_STATE(544)] = 30907,
  [SMALL_STATE(545)] = 30914,
  [SMALL_STATE(546)] = 30921,
  [SMALL_STATE(547)] = 30928,
  [SMALL_STATE(548)] = 30935,
  [SMALL_STATE(549)] = 30942,
  [SMALL_STATE(550)] = 30949,
  [SMALL_STATE(551)] = 30956,
  [SMALL_STATE(552)] = 30963,
  [SMALL_STATE(553)] = 30970,
  [SMALL_STATE(554)] = 30977,
  [SMALL_STATE(555)] = 30984,
  [SMALL_STATE(556)] = 30991,
  [SMALL_STATE(557)] = 30998,
  [SMALL_STATE(558)] = 31005,
  [SMALL_STATE(559)] = 31012,
  [SMALL_STATE(560)] = 31019,
  [SMALL_STATE(561)] = 31026,
  [SMALL_STATE(562)] = 31033,
  [SMALL_STATE(563)] = 31040,
  [SMALL_STATE(564)] = 31047,
  [SMALL_STATE(565)] = 31054,
  [SMALL_STATE(566)] = 31061,
  [SMALL_STATE(567)] = 31068,
  [SMALL_STATE(568)] = 31075,
  [SMALL_STATE(569)] = 31082,
  [SMALL_STATE(570)] = 31089,
  [SMALL_STATE(571)] = 31096,
  [SMALL_STATE(572)] = 31103,
  [SMALL_STATE(573)] = 31110,
  [SMALL_STATE(574)] = 31117,
  [SMALL_STATE(575)] = 31124,
  [SMALL_STATE(576)] = 31131,
  [SMALL_STATE(577)] = 31138,
  [SMALL_STATE(578)] = 31145,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(518),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(562),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 1),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 1),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [53] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 9),
  [55] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 9),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 8),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 8),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 1, .production_id = 2),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 1, .production_id = 2),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_funcname, 1),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_funcname, 1),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__QQSTRING, 3),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__QQSTRING, 3),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 1, .production_id = 1),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 1, .production_id = 1),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__QQSTRING, 2),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__QQSTRING, 2),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 5),
  [107] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 5),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_suffix, 3),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_suffix, 3),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 3, .production_id = 14),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 3, .production_id = 14),
  [117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 3, .production_id = 12),
  [119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 3, .production_id = 12),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 13),
  [123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 13),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 12),
  [127] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 12),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 7),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 7),
  [133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 6),
  [135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 6),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 3, .production_id = 16),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 3, .production_id = 16),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 3, .production_id = 17),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 3, .production_id = 17),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_suffix, 4),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_suffix, 4),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_suffix, 5),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_suffix, 5),
  [153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 4, .production_id = 29),
  [155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 4, .production_id = 29),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 2),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index, 2),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 10),
  [163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 10),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_suffix, 2),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_suffix, 2),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 4, .production_id = 28),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 4, .production_id = 28),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__term, 2, .production_id = 4),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__term, 2, .production_id = 4),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 2, .production_id = 3),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 9, .production_id = 35),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 9, .production_id = 35),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 15),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 15),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 9, .production_id = 36),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 9, .production_id = 36),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 11, .production_id = 37),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 11, .production_id = 37),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 7, .production_id = 34),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 7, .production_id = 34),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 2, .production_id = 11),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 2, .production_id = 11),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 6, .production_id = 32),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 6, .production_id = 32),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 5, .production_id = 30),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 5, .production_id = 30),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 23),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 23),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 26),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 26),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 21),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 21),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 2),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 2),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 19),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 19),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_catch, 2),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_catch, 2),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 18),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 18),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 4, .production_id = 27),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 25),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 24),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 22),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 3, .production_id = 20),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 3, .production_id = 20),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [337] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(556),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(400),
  [359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [385] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elif, 4),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(313),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [429] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_programbody_repeat2, 1),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(569),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [469] = {.entry = {.count = 1, .reusable = false}}, SHIFT(570),
  [471] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [473] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(572),
  [481] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [485] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [487] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(568),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [493] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [501] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(566),
  [511] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 1),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(571),
  [533] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_args, 3),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [561] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [563] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [571] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [577] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [589] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_programbody, 1),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [609] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [621] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [631] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else, 2),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_programbody, 2),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [657] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_programbody_repeat1, 2), SHIFT_REPEAT(458),
  [660] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_programbody_repeat1, 2), SHIFT_REPEAT(463),
  [663] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_programbody_repeat1, 2),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_programbody_repeat1, 2),
  [667] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_, 3),
  [669] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_, 3),
  [671] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_, 5),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_, 5),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_, 6),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_, 6),
  [679] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_, 4),
  [681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_, 4),
  [683] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_moduleheader, 3),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_moduleheader, 3),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_funcdef, 5),
  [689] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_funcdef, 5),
  [691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [695] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [699] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_funcdef, 6),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_funcdef, 6),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [707] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(442),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [721] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(441),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(476),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectval, 1, .production_id = 12),
  [761] = {.entry = {.count = 1, .reusable = false}}, SHIFT(575),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_objectval_repeat1, 2, .production_id = 33),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 3),
  [775] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__inner_string, 2),
  [777] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__inner_string, 2), SHIFT_REPEAT(217),
  [780] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__inner_string, 2), SHIFT_REPEAT(448),
  [783] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [785] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [787] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [791] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__inner_string, 1),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [805] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_content, 2),
  [807] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__string_content, 2), SHIFT_REPEAT(451),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2),
  [812] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(186),
  [815] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__inner_string, 3),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__inner_string, 3),
  [819] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_objectval_repeat1, 2, .production_id = 31), SHIFT_REPEAT(411),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_objectval_repeat1, 2, .production_id = 31),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constobject, 3),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectval, 2, .production_id = 31),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constobject, 2),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_programbody_repeat2, 2),
  [844] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_programbody_repeat2, 2), SHIFT_REPEAT(505),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constobject, 4),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [857] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_funcdefargs_repeat1, 2), SHIFT_REPEAT(471),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_funcdefargs_repeat1, 2),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectkey, 1),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bindpatterns, 1),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [876] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constobject_repeat1, 2), SHIFT_REPEAT(440),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constobject_repeat1, 2),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectpatterns, 2),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [895] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bindpatterns, 2),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constarray, 2),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bindpatterns_repeat1, 2),
  [901] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bindpatterns_repeat1, 2), SHIFT_REPEAT(464),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectkeyval, 1),
  [910] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arraypatterns_repeat1, 2), SHIFT_REPEAT(457),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arraypatterns_repeat1, 2),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [917] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constarray_repeat1, 2), SHIFT_REPEAT(428),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constarray_repeat1, 2),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectpatterns, 1),
  [926] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_objectpatterns_repeat1, 2), SHIFT_REPEAT(434),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_objectpatterns_repeat1, 2),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectpattern, 1),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arraypatterns, 1),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arraypatterns, 2),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constarray, 3),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constterm, 1),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constarray, 4),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectkeyvals, 3),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectpattern, 5),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectpattern, 3),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constobjectkeyval, 3),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectkeyval, 5),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectkeyvals, 1),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectkeyval, 3),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [999] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_funcdefargs, 4),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_funcdefargs, 3),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [1023] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binding, 3, .production_id = 12),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 2),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_jq(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_keyword,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
