#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 628
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 152
#define ALIAS_COUNT 10
#define TOKEN_COUNT 77
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 21

enum ts_symbol_identifiers {
  anon_sym_ATimport = 1,
  anon_sym_COMMA = 2,
  anon_sym_SEMI = 3,
  anon_sym_ATmedia = 4,
  anon_sym_ATcharset = 5,
  anon_sym_ATnamespace = 6,
  anon_sym_ATkeyframes = 7,
  aux_sym_keyframes_statement_token1 = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  sym_from = 11,
  sym_to = 12,
  anon_sym_ATsupports = 13,
  sym_nesting_selector = 14,
  anon_sym_STAR = 15,
  anon_sym_DOT = 16,
  anon_sym_COLON_COLON = 17,
  anon_sym_POUND = 18,
  anon_sym_LBRACK = 19,
  anon_sym_EQ = 20,
  anon_sym_TILDE_EQ = 21,
  anon_sym_CARET_EQ = 22,
  anon_sym_PIPE_EQ = 23,
  anon_sym_STAR_EQ = 24,
  anon_sym_DOLLAR_EQ = 25,
  anon_sym_RBRACK = 26,
  anon_sym_GT = 27,
  anon_sym_TILDE = 28,
  anon_sym_PLUS = 29,
  anon_sym_PIPE = 30,
  anon_sym_LPAREN = 31,
  anon_sym_RPAREN = 32,
  anon_sym_COLON = 33,
  sym_important = 34,
  anon_sym_LPAREN2 = 35,
  anon_sym_and = 36,
  anon_sym_or = 37,
  anon_sym_not = 38,
  anon_sym_only = 39,
  anon_sym_selector = 40,
  aux_sym_color_value_token1 = 41,
  anon_sym_SQUOTE = 42,
  aux_sym_string_value_token1 = 43,
  anon_sym_DQUOTE = 44,
  aux_sym_string_value_token2 = 45,
  aux_sym_integer_value_token1 = 46,
  aux_sym_float_value_token1 = 47,
  sym_unit = 48,
  anon_sym_DASH = 49,
  anon_sym_SLASH = 50,
  anon_sym_EQ_EQ = 51,
  anon_sym_LT = 52,
  anon_sym_BANG_EQ = 53,
  anon_sym_LT_EQ = 54,
  anon_sym_GT_EQ = 55,
  sym_identifier = 56,
  sym_at_keyword = 57,
  sym_js_comment = 58,
  sym_comment = 59,
  sym_plain_value = 60,
  anon_sym_DOT_DOT_DOT = 61,
  anon_sym_each = 62,
  anon_sym_COLONextend = 63,
  anon_sym_ATplugin = 64,
  anon_sym_when = 65,
  anon_sym_AT_LBRACE = 66,
  anon_sym_DASH2 = 67,
  anon_sym_DOLLAR = 68,
  anon_sym_DOLLAR_LBRACE = 69,
  anon_sym_AT_AT = 70,
  sym_variable = 71,
  anon_sym_PLUS_ = 72,
  sym__descendant_operator = 73,
  sym__pseudo_class_selector_colon = 74,
  sym___error_recovery = 75,
  sym__concat = 76,
  sym_stylesheet = 77,
  sym_import_statement = 78,
  sym_media_statement = 79,
  sym_charset_statement = 80,
  sym_namespace_statement = 81,
  sym_keyframes_statement = 82,
  sym_keyframe_block_list = 83,
  sym_keyframe_block = 84,
  sym_supports_statement = 85,
  sym_postcss_statement = 86,
  sym_at_rule = 87,
  sym_rule_set = 88,
  sym_selectors = 89,
  sym_block = 90,
  sym__selector = 91,
  sym_universal_selector = 92,
  sym_class_selector = 93,
  sym_pseudo_class_selector = 94,
  sym_pseudo_element_selector = 95,
  sym_id_selector = 96,
  sym_attribute_selector = 97,
  sym_child_selector = 98,
  sym_descendant_selector = 99,
  sym_sibling_selector = 100,
  sym_adjacent_sibling_selector = 101,
  sym_namespace_selector = 102,
  sym_pseudo_class_arguments = 103,
  sym_pseudo_element_arguments = 104,
  sym_declaration = 105,
  sym_last_declaration = 106,
  sym__query = 107,
  sym_feature_query = 108,
  sym_parenthesized_query = 109,
  sym_binary_query = 110,
  sym_unary_query = 111,
  sym_selector_query = 112,
  sym__value = 113,
  sym_parenthesized_value = 114,
  sym_color_value = 115,
  sym_string_value = 116,
  sym_integer_value = 117,
  sym_float_value = 118,
  sym_grid_value = 119,
  sym_call_expression = 120,
  sym_binary_expression = 121,
  sym_arguments = 122,
  sym_mixin_definition = 123,
  sym_parameters = 124,
  sym_parameter = 125,
  sym_rest_parameter = 126,
  sym_each_statement = 127,
  sym_mixin_statement = 128,
  sym_extend_statement = 129,
  sym_plugin_statement = 130,
  sym_when_condition = 131,
  sym_list_value = 132,
  sym_interpolation = 133,
  sym__concatenated_identifier = 134,
  sym__extend_arguments = 135,
  sym__mixin_name = 136,
  sym_property_value = 137,
  sym_value_value = 138,
  sym_merge_identifier = 139,
  aux_sym_stylesheet_repeat1 = 140,
  aux_sym_import_statement_repeat1 = 141,
  aux_sym_keyframe_block_list_repeat1 = 142,
  aux_sym_postcss_statement_repeat1 = 143,
  aux_sym_selectors_repeat1 = 144,
  aux_sym_block_repeat1 = 145,
  aux_sym_pseudo_class_arguments_repeat1 = 146,
  aux_sym_declaration_repeat1 = 147,
  aux_sym_grid_value_repeat1 = 148,
  aux_sym_arguments_repeat1 = 149,
  aux_sym_parameters_repeat1 = 150,
  aux_sym__concatenated_identifier_repeat1 = 151,
  alias_sym_attribute_name = 152,
  alias_sym_class_name = 153,
  alias_sym_feature_name = 154,
  alias_sym_function_name = 155,
  alias_sym_id_name = 156,
  alias_sym_keyframes_name = 157,
  alias_sym_keyword_query = 158,
  alias_sym_namespace_name = 159,
  alias_sym_property_name = 160,
  alias_sym_tag_name = 161,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_ATimport] = "@import",
  [anon_sym_COMMA] = ",",
  [anon_sym_SEMI] = ";",
  [anon_sym_ATmedia] = "@media",
  [anon_sym_ATcharset] = "@charset",
  [anon_sym_ATnamespace] = "@namespace",
  [anon_sym_ATkeyframes] = "@keyframes",
  [aux_sym_keyframes_statement_token1] = "at_keyword",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_from] = "from",
  [sym_to] = "to",
  [anon_sym_ATsupports] = "@supports",
  [sym_nesting_selector] = "nesting_selector",
  [anon_sym_STAR] = "*",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_EQ] = "=",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_DOLLAR_EQ] = "$=",
  [anon_sym_RBRACK] = "]",
  [anon_sym_GT] = ">",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE] = "|",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [sym_important] = "important",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_not] = "not",
  [anon_sym_only] = "only",
  [anon_sym_selector] = "selector",
  [aux_sym_color_value_token1] = "color_value_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_value_token1] = "string_value_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_value_token2] = "string_value_token2",
  [aux_sym_integer_value_token1] = "integer_value_token1",
  [aux_sym_float_value_token1] = "float_value_token1",
  [sym_unit] = "unit",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_LT] = "<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [sym_identifier] = "identifier",
  [sym_at_keyword] = "at_keyword",
  [sym_js_comment] = "js_comment",
  [sym_comment] = "comment",
  [sym_plain_value] = "plain_value",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_each] = "each",
  [anon_sym_COLONextend] = ":extend",
  [anon_sym_ATplugin] = "@plugin",
  [anon_sym_when] = "when",
  [anon_sym_AT_LBRACE] = "@{",
  [anon_sym_DASH2] = "identifier",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_AT_AT] = "@@",
  [sym_variable] = "variable",
  [anon_sym_PLUS_] = "+_",
  [sym__descendant_operator] = "_descendant_operator",
  [sym__pseudo_class_selector_colon] = ":",
  [sym___error_recovery] = "__error_recovery",
  [sym__concat] = "_concat",
  [sym_stylesheet] = "stylesheet",
  [sym_import_statement] = "import_statement",
  [sym_media_statement] = "media_statement",
  [sym_charset_statement] = "charset_statement",
  [sym_namespace_statement] = "namespace_statement",
  [sym_keyframes_statement] = "keyframes_statement",
  [sym_keyframe_block_list] = "keyframe_block_list",
  [sym_keyframe_block] = "keyframe_block",
  [sym_supports_statement] = "supports_statement",
  [sym_postcss_statement] = "postcss_statement",
  [sym_at_rule] = "at_rule",
  [sym_rule_set] = "rule_set",
  [sym_selectors] = "selectors",
  [sym_block] = "block",
  [sym__selector] = "_selector",
  [sym_universal_selector] = "universal_selector",
  [sym_class_selector] = "class_selector",
  [sym_pseudo_class_selector] = "pseudo_class_selector",
  [sym_pseudo_element_selector] = "pseudo_element_selector",
  [sym_id_selector] = "id_selector",
  [sym_attribute_selector] = "attribute_selector",
  [sym_child_selector] = "child_selector",
  [sym_descendant_selector] = "descendant_selector",
  [sym_sibling_selector] = "sibling_selector",
  [sym_adjacent_sibling_selector] = "adjacent_sibling_selector",
  [sym_namespace_selector] = "namespace_selector",
  [sym_pseudo_class_arguments] = "arguments",
  [sym_pseudo_element_arguments] = "arguments",
  [sym_declaration] = "declaration",
  [sym_last_declaration] = "declaration",
  [sym__query] = "_query",
  [sym_feature_query] = "feature_query",
  [sym_parenthesized_query] = "parenthesized_query",
  [sym_binary_query] = "binary_query",
  [sym_unary_query] = "unary_query",
  [sym_selector_query] = "selector_query",
  [sym__value] = "_value",
  [sym_parenthesized_value] = "parenthesized_value",
  [sym_color_value] = "color_value",
  [sym_string_value] = "string_value",
  [sym_integer_value] = "integer_value",
  [sym_float_value] = "float_value",
  [sym_grid_value] = "grid_value",
  [sym_call_expression] = "call_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_arguments] = "arguments",
  [sym_mixin_definition] = "mixin_definition",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym_rest_parameter] = "rest_parameter",
  [sym_each_statement] = "each_statement",
  [sym_mixin_statement] = "mixin_statement",
  [sym_extend_statement] = "extend_statement",
  [sym_plugin_statement] = "plugin_statement",
  [sym_when_condition] = "when_condition",
  [sym_list_value] = "list_value",
  [sym_interpolation] = "interpolation",
  [sym__concatenated_identifier] = "_concatenated_identifier",
  [sym__extend_arguments] = "arguments",
  [sym__mixin_name] = "_mixin_name",
  [sym_property_value] = "property_value",
  [sym_value_value] = "value_value",
  [sym_merge_identifier] = "merge_identifier",
  [aux_sym_stylesheet_repeat1] = "stylesheet_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_keyframe_block_list_repeat1] = "keyframe_block_list_repeat1",
  [aux_sym_postcss_statement_repeat1] = "postcss_statement_repeat1",
  [aux_sym_selectors_repeat1] = "selectors_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_pseudo_class_arguments_repeat1] = "pseudo_class_arguments_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_grid_value_repeat1] = "grid_value_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym__concatenated_identifier_repeat1] = "_concatenated_identifier_repeat1",
  [alias_sym_attribute_name] = "attribute_name",
  [alias_sym_class_name] = "class_name",
  [alias_sym_feature_name] = "feature_name",
  [alias_sym_function_name] = "function_name",
  [alias_sym_id_name] = "id_name",
  [alias_sym_keyframes_name] = "keyframes_name",
  [alias_sym_keyword_query] = "keyword_query",
  [alias_sym_namespace_name] = "namespace_name",
  [alias_sym_property_name] = "property_name",
  [alias_sym_tag_name] = "tag_name",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_ATimport] = anon_sym_ATimport,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_ATmedia] = anon_sym_ATmedia,
  [anon_sym_ATcharset] = anon_sym_ATcharset,
  [anon_sym_ATnamespace] = anon_sym_ATnamespace,
  [anon_sym_ATkeyframes] = anon_sym_ATkeyframes,
  [aux_sym_keyframes_statement_token1] = sym_at_keyword,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_from] = sym_from,
  [sym_to] = sym_to,
  [anon_sym_ATsupports] = anon_sym_ATsupports,
  [sym_nesting_selector] = sym_nesting_selector,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_DOLLAR_EQ] = anon_sym_DOLLAR_EQ,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_important] = sym_important,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_only] = anon_sym_only,
  [anon_sym_selector] = anon_sym_selector,
  [aux_sym_color_value_token1] = aux_sym_color_value_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_value_token1] = aux_sym_string_value_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_value_token2] = aux_sym_string_value_token2,
  [aux_sym_integer_value_token1] = aux_sym_integer_value_token1,
  [aux_sym_float_value_token1] = aux_sym_float_value_token1,
  [sym_unit] = sym_unit,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [sym_identifier] = sym_identifier,
  [sym_at_keyword] = sym_at_keyword,
  [sym_js_comment] = sym_js_comment,
  [sym_comment] = sym_comment,
  [sym_plain_value] = sym_plain_value,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_COLONextend] = anon_sym_COLONextend,
  [anon_sym_ATplugin] = anon_sym_ATplugin,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_AT_LBRACE] = anon_sym_AT_LBRACE,
  [anon_sym_DASH2] = sym_identifier,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [sym_variable] = sym_variable,
  [anon_sym_PLUS_] = anon_sym_PLUS_,
  [sym__descendant_operator] = sym__descendant_operator,
  [sym__pseudo_class_selector_colon] = anon_sym_COLON,
  [sym___error_recovery] = sym___error_recovery,
  [sym__concat] = sym__concat,
  [sym_stylesheet] = sym_stylesheet,
  [sym_import_statement] = sym_import_statement,
  [sym_media_statement] = sym_media_statement,
  [sym_charset_statement] = sym_charset_statement,
  [sym_namespace_statement] = sym_namespace_statement,
  [sym_keyframes_statement] = sym_keyframes_statement,
  [sym_keyframe_block_list] = sym_keyframe_block_list,
  [sym_keyframe_block] = sym_keyframe_block,
  [sym_supports_statement] = sym_supports_statement,
  [sym_postcss_statement] = sym_postcss_statement,
  [sym_at_rule] = sym_at_rule,
  [sym_rule_set] = sym_rule_set,
  [sym_selectors] = sym_selectors,
  [sym_block] = sym_block,
  [sym__selector] = sym__selector,
  [sym_universal_selector] = sym_universal_selector,
  [sym_class_selector] = sym_class_selector,
  [sym_pseudo_class_selector] = sym_pseudo_class_selector,
  [sym_pseudo_element_selector] = sym_pseudo_element_selector,
  [sym_id_selector] = sym_id_selector,
  [sym_attribute_selector] = sym_attribute_selector,
  [sym_child_selector] = sym_child_selector,
  [sym_descendant_selector] = sym_descendant_selector,
  [sym_sibling_selector] = sym_sibling_selector,
  [sym_adjacent_sibling_selector] = sym_adjacent_sibling_selector,
  [sym_namespace_selector] = sym_namespace_selector,
  [sym_pseudo_class_arguments] = sym_arguments,
  [sym_pseudo_element_arguments] = sym_arguments,
  [sym_declaration] = sym_declaration,
  [sym_last_declaration] = sym_declaration,
  [sym__query] = sym__query,
  [sym_feature_query] = sym_feature_query,
  [sym_parenthesized_query] = sym_parenthesized_query,
  [sym_binary_query] = sym_binary_query,
  [sym_unary_query] = sym_unary_query,
  [sym_selector_query] = sym_selector_query,
  [sym__value] = sym__value,
  [sym_parenthesized_value] = sym_parenthesized_value,
  [sym_color_value] = sym_color_value,
  [sym_string_value] = sym_string_value,
  [sym_integer_value] = sym_integer_value,
  [sym_float_value] = sym_float_value,
  [sym_grid_value] = sym_grid_value,
  [sym_call_expression] = sym_call_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_arguments] = sym_arguments,
  [sym_mixin_definition] = sym_mixin_definition,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym_rest_parameter] = sym_rest_parameter,
  [sym_each_statement] = sym_each_statement,
  [sym_mixin_statement] = sym_mixin_statement,
  [sym_extend_statement] = sym_extend_statement,
  [sym_plugin_statement] = sym_plugin_statement,
  [sym_when_condition] = sym_when_condition,
  [sym_list_value] = sym_list_value,
  [sym_interpolation] = sym_interpolation,
  [sym__concatenated_identifier] = sym__concatenated_identifier,
  [sym__extend_arguments] = sym_arguments,
  [sym__mixin_name] = sym__mixin_name,
  [sym_property_value] = sym_property_value,
  [sym_value_value] = sym_value_value,
  [sym_merge_identifier] = sym_merge_identifier,
  [aux_sym_stylesheet_repeat1] = aux_sym_stylesheet_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_keyframe_block_list_repeat1] = aux_sym_keyframe_block_list_repeat1,
  [aux_sym_postcss_statement_repeat1] = aux_sym_postcss_statement_repeat1,
  [aux_sym_selectors_repeat1] = aux_sym_selectors_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_pseudo_class_arguments_repeat1] = aux_sym_pseudo_class_arguments_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_grid_value_repeat1] = aux_sym_grid_value_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym__concatenated_identifier_repeat1] = aux_sym__concatenated_identifier_repeat1,
  [alias_sym_attribute_name] = alias_sym_attribute_name,
  [alias_sym_class_name] = alias_sym_class_name,
  [alias_sym_feature_name] = alias_sym_feature_name,
  [alias_sym_function_name] = alias_sym_function_name,
  [alias_sym_id_name] = alias_sym_id_name,
  [alias_sym_keyframes_name] = alias_sym_keyframes_name,
  [alias_sym_keyword_query] = alias_sym_keyword_query,
  [alias_sym_namespace_name] = alias_sym_namespace_name,
  [alias_sym_property_name] = alias_sym_property_name,
  [alias_sym_tag_name] = alias_sym_tag_name,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_ATimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATmedia] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATcharset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATnamespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATkeyframes] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_keyframes_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_from] = {
    .visible = true,
    .named = true,
  },
  [sym_to] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsupports] = {
    .visible = true,
    .named = false,
  },
  [sym_nesting_selector] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_important] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_only] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selector] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_color_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_value_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_float_value_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_at_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_js_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_plain_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONextend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATplugin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS_] = {
    .visible = true,
    .named = false,
  },
  [sym__descendant_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__pseudo_class_selector_colon] = {
    .visible = true,
    .named = false,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_stylesheet] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_media_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_charset_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_keyframes_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_keyframe_block_list] = {
    .visible = true,
    .named = true,
  },
  [sym_keyframe_block] = {
    .visible = true,
    .named = true,
  },
  [sym_supports_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_postcss_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_at_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_set] = {
    .visible = true,
    .named = true,
  },
  [sym_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__selector] = {
    .visible = false,
    .named = true,
  },
  [sym_universal_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_class_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_class_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_element_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_id_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_child_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_descendant_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_sibling_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_adjacent_sibling_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_class_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_element_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_last_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__query] = {
    .visible = false,
    .named = true,
  },
  [sym_feature_query] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_query] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_query] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_query] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_query] = {
    .visible = true,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_value] = {
    .visible = true,
    .named = true,
  },
  [sym_color_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string_value] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_value] = {
    .visible = true,
    .named = true,
  },
  [sym_float_value] = {
    .visible = true,
    .named = true,
  },
  [sym_grid_value] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_extend_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_plugin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_when_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_list_value] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__concatenated_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__extend_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__mixin_name] = {
    .visible = false,
    .named = true,
  },
  [sym_property_value] = {
    .visible = true,
    .named = true,
  },
  [sym_value_value] = {
    .visible = true,
    .named = true,
  },
  [sym_merge_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_stylesheet_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyframe_block_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_postcss_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pseudo_class_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grid_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__concatenated_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_class_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_feature_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_id_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_keyframes_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_keyword_query] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_tag_name] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_default = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_default] = "default",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [19] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_default, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_tag_name,
  },
  [2] = {
    [1] = alias_sym_class_name,
  },
  [3] = {
    [0] = sym_plain_value,
  },
  [4] = {
    [0] = alias_sym_keyword_query,
  },
  [5] = {
    [1] = alias_sym_tag_name,
  },
  [6] = {
    [1] = alias_sym_id_name,
  },
  [7] = {
    [0] = alias_sym_function_name,
  },
  [8] = {
    [1] = alias_sym_property_name,
  },
  [9] = {
    [1] = alias_sym_keyframes_name,
  },
  [10] = {
    [1] = alias_sym_attribute_name,
  },
  [11] = {
    [2] = alias_sym_class_name,
  },
  [12] = {
    [2] = alias_sym_tag_name,
  },
  [13] = {
    [2] = alias_sym_id_name,
  },
  [14] = {
    [1] = alias_sym_namespace_name,
  },
  [15] = {
    [1] = alias_sym_id_name,
    [3] = alias_sym_class_name,
  },
  [16] = {
    [0] = alias_sym_property_name,
  },
  [17] = {
    [2] = alias_sym_attribute_name,
  },
  [18] = {
    [1] = alias_sym_id_name,
    [4] = alias_sym_class_name,
  },
  [20] = {
    [1] = alias_sym_feature_name,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_namespace_selector, 2,
    sym_namespace_selector,
    alias_sym_attribute_name,
  sym__concatenated_identifier, 4,
    sym__concatenated_identifier,
    alias_sym_class_name,
    alias_sym_property_name,
    alias_sym_tag_name,
  sym__mixin_name, 2,
    sym__mixin_name,
    alias_sym_function_name,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 2,
  [7] = 3,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 11,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 17,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 20,
  [23] = 21,
  [24] = 24,
  [25] = 24,
  [26] = 24,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 33,
  [35] = 35,
  [36] = 33,
  [37] = 37,
  [38] = 33,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 42,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 54,
  [56] = 56,
  [57] = 53,
  [58] = 58,
  [59] = 28,
  [60] = 60,
  [61] = 32,
  [62] = 62,
  [63] = 63,
  [64] = 58,
  [65] = 29,
  [66] = 30,
  [67] = 58,
  [68] = 28,
  [69] = 60,
  [70] = 58,
  [71] = 30,
  [72] = 29,
  [73] = 32,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 37,
  [79] = 32,
  [80] = 37,
  [81] = 76,
  [82] = 82,
  [83] = 77,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 90,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 90,
  [104] = 100,
  [105] = 99,
  [106] = 102,
  [107] = 97,
  [108] = 101,
  [109] = 94,
  [110] = 110,
  [111] = 98,
  [112] = 112,
  [113] = 113,
  [114] = 95,
  [115] = 115,
  [116] = 41,
  [117] = 117,
  [118] = 118,
  [119] = 90,
  [120] = 94,
  [121] = 121,
  [122] = 90,
  [123] = 89,
  [124] = 90,
  [125] = 90,
  [126] = 41,
  [127] = 91,
  [128] = 94,
  [129] = 129,
  [130] = 130,
  [131] = 90,
  [132] = 132,
  [133] = 96,
  [134] = 134,
  [135] = 86,
  [136] = 129,
  [137] = 87,
  [138] = 115,
  [139] = 90,
  [140] = 140,
  [141] = 88,
  [142] = 132,
  [143] = 84,
  [144] = 129,
  [145] = 117,
  [146] = 140,
  [147] = 90,
  [148] = 90,
  [149] = 149,
  [150] = 150,
  [151] = 85,
  [152] = 113,
  [153] = 132,
  [154] = 112,
  [155] = 110,
  [156] = 132,
  [157] = 129,
  [158] = 90,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 166,
  [168] = 164,
  [169] = 165,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 30,
  [184] = 29,
  [185] = 28,
  [186] = 31,
  [187] = 187,
  [188] = 37,
  [189] = 32,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 193,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 194,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 196,
  [212] = 212,
  [213] = 192,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 204,
  [219] = 219,
  [220] = 206,
  [221] = 209,
  [222] = 210,
  [223] = 216,
  [224] = 224,
  [225] = 212,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 214,
  [230] = 230,
  [231] = 197,
  [232] = 215,
  [233] = 233,
  [234] = 195,
  [235] = 191,
  [236] = 236,
  [237] = 217,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 190,
  [242] = 35,
  [243] = 224,
  [244] = 244,
  [245] = 202,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 198,
  [252] = 238,
  [253] = 246,
  [254] = 205,
  [255] = 240,
  [256] = 187,
  [257] = 219,
  [258] = 226,
  [259] = 248,
  [260] = 236,
  [261] = 30,
  [262] = 29,
  [263] = 28,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 56,
  [270] = 270,
  [271] = 41,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 37,
  [285] = 285,
  [286] = 32,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 32,
  [294] = 42,
  [295] = 41,
  [296] = 43,
  [297] = 47,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 42,
  [303] = 303,
  [304] = 60,
  [305] = 29,
  [306] = 306,
  [307] = 28,
  [308] = 32,
  [309] = 309,
  [310] = 30,
  [311] = 76,
  [312] = 28,
  [313] = 77,
  [314] = 29,
  [315] = 315,
  [316] = 30,
  [317] = 76,
  [318] = 37,
  [319] = 28,
  [320] = 60,
  [321] = 29,
  [322] = 32,
  [323] = 30,
  [324] = 309,
  [325] = 325,
  [326] = 115,
  [327] = 113,
  [328] = 99,
  [329] = 115,
  [330] = 100,
  [331] = 102,
  [332] = 32,
  [333] = 101,
  [334] = 101,
  [335] = 37,
  [336] = 98,
  [337] = 77,
  [338] = 338,
  [339] = 112,
  [340] = 84,
  [341] = 88,
  [342] = 30,
  [343] = 29,
  [344] = 87,
  [345] = 86,
  [346] = 96,
  [347] = 110,
  [348] = 37,
  [349] = 41,
  [350] = 28,
  [351] = 97,
  [352] = 87,
  [353] = 113,
  [354] = 32,
  [355] = 41,
  [356] = 96,
  [357] = 88,
  [358] = 84,
  [359] = 100,
  [360] = 37,
  [361] = 99,
  [362] = 301,
  [363] = 338,
  [364] = 102,
  [365] = 86,
  [366] = 110,
  [367] = 112,
  [368] = 97,
  [369] = 98,
  [370] = 56,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 378,
  [383] = 383,
  [384] = 376,
  [385] = 385,
  [386] = 378,
  [387] = 383,
  [388] = 388,
  [389] = 383,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 388,
  [394] = 394,
  [395] = 378,
  [396] = 380,
  [397] = 383,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 402,
  [405] = 402,
  [406] = 402,
  [407] = 402,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 402,
  [412] = 412,
  [413] = 412,
  [414] = 414,
  [415] = 402,
  [416] = 402,
  [417] = 402,
  [418] = 402,
  [419] = 403,
  [420] = 402,
  [421] = 414,
  [422] = 402,
  [423] = 423,
  [424] = 424,
  [425] = 424,
  [426] = 426,
  [427] = 427,
  [428] = 426,
  [429] = 429,
  [430] = 430,
  [431] = 430,
  [432] = 427,
  [433] = 433,
  [434] = 433,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 32,
  [442] = 442,
  [443] = 438,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 212,
  [448] = 215,
  [449] = 449,
  [450] = 450,
  [451] = 195,
  [452] = 450,
  [453] = 449,
  [454] = 446,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 458,
  [465] = 465,
  [466] = 462,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 461,
  [472] = 461,
  [473] = 461,
  [474] = 461,
  [475] = 455,
  [476] = 460,
  [477] = 461,
  [478] = 478,
  [479] = 461,
  [480] = 461,
  [481] = 481,
  [482] = 455,
  [483] = 483,
  [484] = 461,
  [485] = 467,
  [486] = 456,
  [487] = 487,
  [488] = 455,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 494,
  [498] = 498,
  [499] = 492,
  [500] = 500,
  [501] = 501,
  [502] = 492,
  [503] = 493,
  [504] = 492,
  [505] = 505,
  [506] = 493,
  [507] = 507,
  [508] = 493,
  [509] = 509,
  [510] = 505,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 517,
  [520] = 520,
  [521] = 521,
  [522] = 521,
  [523] = 523,
  [524] = 524,
  [525] = 516,
  [526] = 526,
  [527] = 527,
  [528] = 520,
  [529] = 529,
  [530] = 514,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 536,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 534,
  [545] = 535,
  [546] = 534,
  [547] = 547,
  [548] = 540,
  [549] = 536,
  [550] = 536,
  [551] = 551,
  [552] = 552,
  [553] = 469,
  [554] = 534,
  [555] = 535,
  [556] = 556,
  [557] = 535,
  [558] = 534,
  [559] = 535,
  [560] = 534,
  [561] = 561,
  [562] = 534,
  [563] = 535,
  [564] = 470,
  [565] = 565,
  [566] = 538,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 543,
  [573] = 573,
  [574] = 574,
  [575] = 542,
  [576] = 576,
  [577] = 543,
  [578] = 578,
  [579] = 543,
  [580] = 580,
  [581] = 542,
  [582] = 541,
  [583] = 542,
  [584] = 541,
  [585] = 574,
  [586] = 541,
  [587] = 587,
  [588] = 459,
  [589] = 587,
  [590] = 590,
  [591] = 591,
  [592] = 565,
  [593] = 571,
  [594] = 533,
  [595] = 580,
  [596] = 596,
  [597] = 540,
  [598] = 598,
  [599] = 574,
  [600] = 600,
  [601] = 533,
  [602] = 580,
  [603] = 552,
  [604] = 580,
  [605] = 533,
  [606] = 574,
  [607] = 533,
  [608] = 580,
  [609] = 578,
  [610] = 533,
  [611] = 580,
  [612] = 612,
  [613] = 533,
  [614] = 580,
  [615] = 615,
  [616] = 535,
  [617] = 617,
  [618] = 618,
  [619] = 576,
  [620] = 590,
  [621] = 612,
  [622] = 561,
  [623] = 556,
  [624] = 547,
  [625] = 570,
  [626] = 538,
  [627] = 598,
};

static inline bool sym_js_comment_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < 11
        ? c == '\t'
        : c <= '\r')
      : (c <= '!' || (c < ','
        ? (c >= '(' && c <= '*')
        : c <= ',')))
    : (c <= ';' || (c < '{'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_plain_value_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= '!' || (c < ','
        ? (c >= '(' && c <= ')')
        : c <= ',')))
    : (c <= ';' || (c < '{'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_plain_value_character_set_2(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : c <= '\r')
      : (c <= '!' || (c < ','
        ? (c >= '(' && c <= '*')
        : c <= ',')))
    : (c <= ';' || (c < '{'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(99);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(396);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(146);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(125);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(55);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == 'a') ADVANCE(257);
      if (lookahead == 'e') ADVANCE(255);
      if (lookahead == 'f') ADVANCE(258);
      if (lookahead == 'n') ADVANCE(279);
      if (lookahead == 'o') ADVANCE(277);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(280);
      if (lookahead == 'w') ADVANCE(272);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(96)
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'd')) ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(229);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(236);
      if (lookahead == 'o') ADVANCE(235);
      if (lookahead == 's') ADVANCE(232);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(229);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(120);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(134);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'a') ADVANCE(296);
      if (lookahead == 'o') ADVANCE(300);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(295);
      if (lookahead == 's') ADVANCE(292);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(120);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(134);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'a') ADVANCE(296);
      if (lookahead == 'o') ADVANCE(300);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(295);
      if (lookahead == 's') ADVANCE(292);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(145);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11)
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(145);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(65);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(45);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(120);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(65);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '+') ADVANCE(45);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(43);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(65);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(398);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == ':') ADVANCE(144);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '@') ADVANCE(56);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == 'n') ADVANCE(297);
      if (lookahead == 'o') ADVANCE(295);
      if (lookahead == 's') ADVANCE(292);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(262);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(51);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(125);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '~') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(51);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(125);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '~') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '_') ADVANCE(325);
      if (lookahead == 'n') ADVANCE(222);
      if (lookahead == 'o') ADVANCE(221);
      if (lookahead == 's') ADVANCE(218);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == 'a') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(314);
      if (lookahead == 's') ADVANCE(311);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(315);
      if (lookahead == 's') ADVANCE(311);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == 'a') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(314);
      if (lookahead == 's') ADVANCE(311);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(315);
      if (lookahead == 's') ADVANCE(311);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(144);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '}') ADVANCE(109);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23)
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(144);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '}') ADVANCE(109);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(23)
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(244);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(396);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(146);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(26)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 26:
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(146);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(26)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 27:
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == '_') ADVANCE(305);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(28)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 28:
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == '_') ADVANCE(305);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(28)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 29:
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(51);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(52);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == '=') ADVANCE(124);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '~') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(51);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(52);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == '=') ADVANCE(124);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '~') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 31:
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(145);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == 'a') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 'w') ADVANCE(64);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(145);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 'w') ADVANCE(64);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32)
      END_STATE();
    case 33:
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(145);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(315);
      if (lookahead == 's') ADVANCE(311);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 34:
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(89);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == 'f') ADVANCE(79);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == '}') ADVANCE(109);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 35:
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == '/') ADVANCE(382);
      END_STATE();
    case 36:
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == '/') ADVANCE(379);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(46);
      END_STATE();
    case 37:
      if (lookahead == '*') ADVANCE(37);
      if (lookahead == '/') ADVANCE(383);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(37);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 39:
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '/') ADVANCE(35);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(40)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(323);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '/') ADVANCE(35);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(40)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(215);
      END_STATE();
    case 42:
      if (lookahead == '.') ADVANCE(44);
      END_STATE();
    case 43:
      if (lookahead == '.') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 44:
      if (lookahead == '.') ADVANCE(389);
      END_STATE();
    case 45:
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 46:
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(387);
      END_STATE();
    case 47:
      if (lookahead == ':') ADVANCE(121);
      END_STATE();
    case 48:
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 49:
      if (lookahead == '=') ADVANCE(252);
      END_STATE();
    case 50:
      if (lookahead == '=') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 51:
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 52:
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 53:
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 54:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 55:
      if (lookahead == '@') ADVANCE(400);
      if (lookahead == 'c') ADVANCE(345);
      if (lookahead == 'i') ADVANCE(349);
      if (lookahead == 'k') ADVANCE(334);
      if (lookahead == 'm') ADVANCE(335);
      if (lookahead == 'n') ADVANCE(329);
      if (lookahead == 'p') ADVANCE(348);
      if (lookahead == 's') ADVANCE(374);
      if (lookahead == '{') ADVANCE(395);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 56:
      if (lookahead == '@') ADVANCE(400);
      if (lookahead == '{') ADVANCE(395);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(401);
      END_STATE();
    case 57:
      if (lookahead == '@') ADVANCE(93);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 59:
      if (lookahead == 'c') ADVANCE(345);
      if (lookahead == 'i') ADVANCE(349);
      if (lookahead == 'k') ADVANCE(334);
      if (lookahead == 'm') ADVANCE(335);
      if (lookahead == 'n') ADVANCE(329);
      if (lookahead == 'p') ADVANCE(348);
      if (lookahead == 's') ADVANCE(374);
      if (lookahead == '{') ADVANCE(395);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 60:
      if (lookahead == 'd') ADVANCE(391);
      END_STATE();
    case 61:
      if (lookahead == 'd') ADVANCE(149);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(63);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(76);
      END_STATE();
    case 67:
      if (lookahead == 'm') ADVANCE(110);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(393);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(61);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 73:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(112);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 76:
      if (lookahead == 'p') ADVANCE(73);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 83:
      if (lookahead == 'x') ADVANCE(80);
      END_STATE();
    case 84:
      if (lookahead == '{') ADVANCE(395);
      END_STATE();
    case 85:
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(305);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 86:
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(305);
      if (lookahead == '/') ADVANCE(94);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(215);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(189);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 92:
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 93:
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(401);
      END_STATE();
    case 94:
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(46);
      END_STATE();
    case 95:
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(387);
      END_STATE();
    case 96:
      if (eof) ADVANCE(99);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead == '+') ADVANCE(139);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '.') ADVANCE(119);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(146);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(125);
      if (lookahead == '>') ADVANCE(133);
      if (lookahead == '@') ADVANCE(55);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == 'a') ADVANCE(276);
      if (lookahead == 'e') ADVANCE(264);
      if (lookahead == 'f') ADVANCE(284);
      if (lookahead == 'n') ADVANCE(279);
      if (lookahead == 'o') ADVANCE(277);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead == 't') ADVANCE(280);
      if (lookahead == 'w') ADVANCE(272);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(135);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(96)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 97:
      if (eof) ADVANCE(99);
      if (lookahead == '!') ADVANCE(65);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(142);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(59);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == 'e') ADVANCE(264);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(98)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 98:
      if (eof) ADVANCE(99);
      if (lookahead == '!') ADVANCE(65);
      if (lookahead == '"') ADVANCE(201);
      if (lookahead == '#') ADVANCE(122);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(143);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '+') ADVANCE(136);
      if (lookahead == ',') ADVANCE(101);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '/') ADVANCE(35);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(102);
      if (lookahead == '>') ADVANCE(132);
      if (lookahead == '@') ADVANCE(59);
      if (lookahead == '[') ADVANCE(123);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == 'e') ADVANCE(264);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(109);
      if (lookahead == '~') ADVANCE(134);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(98)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_ATimport);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_ATmedia);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_ATcharset);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_ATnamespace);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_ATkeyframes);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_keyframes_statement_token1);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_from);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_from);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_to);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_to);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_ATsupports);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_nesting_selector);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(44);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DOLLAR_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(254);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '_') ADVANCE(402);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '_') ADVANCE(402);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(121);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_important);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'h') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(177);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(180);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(174);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(175);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(177);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(190);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(187);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '\n') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '*') ADVANCE(195);
      if (lookahead == '/') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(200);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(197);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '*') ADVANCE(194);
      if (lookahead == '/') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(199);
      if (lookahead == '\n' ||
          lookahead == '\'') ADVANCE(38);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '*') ADVANCE(194);
      if (lookahead == '\\') ADVANCE(199);
      if (lookahead == '\n' ||
          lookahead == '\'') ADVANCE(38);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead == '\\') ADVANCE(200);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '\\') ADVANCE(200);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead == '\\') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '\\') ADVANCE(195);
      if (lookahead == '*') ADVANCE(194);
      if (lookahead == '\\') ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(aux_sym_string_value_token1);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(208);
      if (lookahead == '\\') ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '*') ADVANCE(205);
      if (lookahead == '/') ADVANCE(208);
      if (lookahead == '\\') ADVANCE(210);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(207);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '*') ADVANCE(204);
      if (lookahead == '/') ADVANCE(207);
      if (lookahead == '\\') ADVANCE(209);
      if (lookahead == '\n' ||
          lookahead == '"') ADVANCE(38);
      if (lookahead != 0) ADVANCE(205);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '*') ADVANCE(204);
      if (lookahead == '\\') ADVANCE(209);
      if (lookahead == '\n' ||
          lookahead == '"') ADVANCE(38);
      if (lookahead != 0) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '/') ADVANCE(203);
      if (lookahead == '\\') ADVANCE(210);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(206);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(207);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '\\') ADVANCE(210);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead == '\\') ADVANCE(202);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead != 0 &&
          lookahead != '*' &&
          lookahead != '\\') ADVANCE(205);
      if (lookahead == '*') ADVANCE(204);
      if (lookahead == '\\') ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_string_value_token2);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(207);
      if (lookahead == '\\') ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_integer_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_integer_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'c') ADVANCE(226);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'e') ADVANCE(216);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'e') ADVANCE(220);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'l') ADVANCE(227);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'l') ADVANCE(217);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'n') ADVANCE(219);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'o') ADVANCE(225);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'o') ADVANCE(224);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'r') ADVANCE(167);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 't') ADVANCE(157);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 't') ADVANCE(223);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == 'y') ADVANCE(162);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(244);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'c') ADVANCE(240);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'e') ADVANCE(230);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'e') ADVANCE(234);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(241);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(231);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'n') ADVANCE(233);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'o') ADVANCE(239);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'o') ADVANCE(238);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'r') ADVANCE(168);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 't') ADVANCE(158);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 't') ADVANCE(237);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (lookahead == 'y') ADVANCE(163);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(304);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(242);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(244);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(305);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(38);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == '/') ADVANCE(379);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(46);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'a') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(260);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'c') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(260);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(260);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(324);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(260);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(325);
      if (lookahead == '.') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '_') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'a') ADVANCE(265);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'c') ADVANCE(271);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'c') ADVANCE(286);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'd') ADVANCE(150);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'e') ADVANCE(274);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'e') ADVANCE(278);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'e') ADVANCE(266);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'h') ADVANCE(390);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'h') ADVANCE(269);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'l') ADVANCE(287);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'l') ADVANCE(270);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'm') ADVANCE(111);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(267);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(154);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(394);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(285);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(113);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(275);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(283);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(169);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(281);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 't') ADVANCE(159);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 't') ADVANCE(282);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'y') ADVANCE(164);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'c') ADVANCE(302);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'd') ADVANCE(151);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'e') ADVANCE(289);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'e') ADVANCE(294);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(303);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'l') ADVANCE(291);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(293);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(290);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'o') ADVANCE(301);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'o') ADVANCE(299);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'r') ADVANCE(170);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'r') ADVANCE(155);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 't') ADVANCE(160);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 't') ADVANCE(298);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'y') ADVANCE(165);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(384);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(307);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(321);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(152);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(308);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(313);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(322);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(310);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(312);
      if (lookahead == 'r') ADVANCE(156);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(312);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(309);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(320);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(319);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(171);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(161);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(318);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(166);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(324);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(188);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(360);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(332);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(350);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(351);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(352);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'c') ADVANCE(336);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'd') ADVANCE(347);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(375);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(333);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(105);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(368);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(371);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(366);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(367);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(376);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'f') ADVANCE(363);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'f') ADVANCE(364);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'g') ADVANCE(346);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'h') ADVANCE(326);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'i') ADVANCE(353);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'i') ADVANCE(327);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'l') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'm') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'm') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'm') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'm') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'n') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'o') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'o') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'p') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'p') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'p') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'p') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 's') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 's') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 's') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 's') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 's') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 't') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 't') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 't') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'u') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'u') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'y') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (lookahead == 'y') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_at_keyword);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(378);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_js_comment);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(379);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(388);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(382);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_js_comment);
      if (sym_js_comment_character_set_1(lookahead)) ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(379);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_js_comment);
      if (sym_js_comment_character_set_1(lookahead)) ADVANCE(382);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(388);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_js_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(382);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '@') ADVANCE(385);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(386);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(386);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(387);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(381);
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(388);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_each);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_COLONextend);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_ATplugin);
      if (lookahead == 'k') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(401);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(377);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(378);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_when);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(325);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(288);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_DASH2);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(325);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '{') ADVANCE(399);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(399);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_PLUS_);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 97, .external_lex_state = 2},
  [2] = {.lex_state = 97, .external_lex_state = 2},
  [3] = {.lex_state = 97, .external_lex_state = 2},
  [4] = {.lex_state = 97, .external_lex_state = 2},
  [5] = {.lex_state = 97, .external_lex_state = 2},
  [6] = {.lex_state = 97, .external_lex_state = 2},
  [7] = {.lex_state = 97, .external_lex_state = 2},
  [8] = {.lex_state = 97, .external_lex_state = 2},
  [9] = {.lex_state = 97, .external_lex_state = 2},
  [10] = {.lex_state = 97, .external_lex_state = 2},
  [11] = {.lex_state = 9},
  [12] = {.lex_state = 9},
  [13] = {.lex_state = 12, .external_lex_state = 2},
  [14] = {.lex_state = 12, .external_lex_state = 2},
  [15] = {.lex_state = 14},
  [16] = {.lex_state = 12, .external_lex_state = 2},
  [17] = {.lex_state = 12, .external_lex_state = 2},
  [18] = {.lex_state = 12, .external_lex_state = 2},
  [19] = {.lex_state = 7},
  [20] = {.lex_state = 7},
  [21] = {.lex_state = 7},
  [22] = {.lex_state = 7},
  [23] = {.lex_state = 7},
  [24] = {.lex_state = 14},
  [25] = {.lex_state = 14},
  [26] = {.lex_state = 14},
  [27] = {.lex_state = 3, .external_lex_state = 3},
  [28] = {.lex_state = 7, .external_lex_state = 3},
  [29] = {.lex_state = 7, .external_lex_state = 3},
  [30] = {.lex_state = 7, .external_lex_state = 3},
  [31] = {.lex_state = 7, .external_lex_state = 4},
  [32] = {.lex_state = 7, .external_lex_state = 3},
  [33] = {.lex_state = 12},
  [34] = {.lex_state = 12},
  [35] = {.lex_state = 4, .external_lex_state = 5},
  [36] = {.lex_state = 12},
  [37] = {.lex_state = 7, .external_lex_state = 3},
  [38] = {.lex_state = 12},
  [39] = {.lex_state = 12},
  [40] = {.lex_state = 12},
  [41] = {.lex_state = 7, .external_lex_state = 4},
  [42] = {.lex_state = 3, .external_lex_state = 5},
  [43] = {.lex_state = 7, .external_lex_state = 4},
  [44] = {.lex_state = 12},
  [45] = {.lex_state = 5, .external_lex_state = 5},
  [46] = {.lex_state = 12},
  [47] = {.lex_state = 7, .external_lex_state = 4},
  [48] = {.lex_state = 13},
  [49] = {.lex_state = 12},
  [50] = {.lex_state = 12},
  [51] = {.lex_state = 13},
  [52] = {.lex_state = 12},
  [53] = {.lex_state = 12},
  [54] = {.lex_state = 12},
  [55] = {.lex_state = 12},
  [56] = {.lex_state = 8, .external_lex_state = 5},
  [57] = {.lex_state = 12},
  [58] = {.lex_state = 12},
  [59] = {.lex_state = 9, .external_lex_state = 5},
  [60] = {.lex_state = 5},
  [61] = {.lex_state = 8, .external_lex_state = 5},
  [62] = {.lex_state = 12},
  [63] = {.lex_state = 12},
  [64] = {.lex_state = 12},
  [65] = {.lex_state = 9, .external_lex_state = 5},
  [66] = {.lex_state = 9, .external_lex_state = 5},
  [67] = {.lex_state = 12},
  [68] = {.lex_state = 7, .external_lex_state = 5},
  [69] = {.lex_state = 3},
  [70] = {.lex_state = 12},
  [71] = {.lex_state = 7, .external_lex_state = 5},
  [72] = {.lex_state = 7, .external_lex_state = 5},
  [73] = {.lex_state = 9, .external_lex_state = 5},
  [74] = {.lex_state = 12},
  [75] = {.lex_state = 12},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 7, .external_lex_state = 5},
  [79] = {.lex_state = 7, .external_lex_state = 5},
  [80] = {.lex_state = 9, .external_lex_state = 5},
  [81] = {.lex_state = 2},
  [82] = {.lex_state = 15, .external_lex_state = 3},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 7},
  [85] = {.lex_state = 12},
  [86] = {.lex_state = 7},
  [87] = {.lex_state = 7},
  [88] = {.lex_state = 7},
  [89] = {.lex_state = 12},
  [90] = {.lex_state = 12},
  [91] = {.lex_state = 12},
  [92] = {.lex_state = 12},
  [93] = {.lex_state = 12},
  [94] = {.lex_state = 12},
  [95] = {.lex_state = 12},
  [96] = {.lex_state = 7},
  [97] = {.lex_state = 7},
  [98] = {.lex_state = 9},
  [99] = {.lex_state = 7},
  [100] = {.lex_state = 7},
  [101] = {.lex_state = 9},
  [102] = {.lex_state = 9},
  [103] = {.lex_state = 12},
  [104] = {.lex_state = 9},
  [105] = {.lex_state = 9},
  [106] = {.lex_state = 7},
  [107] = {.lex_state = 9},
  [108] = {.lex_state = 7},
  [109] = {.lex_state = 12},
  [110] = {.lex_state = 7},
  [111] = {.lex_state = 7},
  [112] = {.lex_state = 7},
  [113] = {.lex_state = 7},
  [114] = {.lex_state = 12},
  [115] = {.lex_state = 7},
  [116] = {.lex_state = 7},
  [117] = {.lex_state = 12},
  [118] = {.lex_state = 12},
  [119] = {.lex_state = 12},
  [120] = {.lex_state = 12},
  [121] = {.lex_state = 12},
  [122] = {.lex_state = 12},
  [123] = {.lex_state = 12},
  [124] = {.lex_state = 12},
  [125] = {.lex_state = 12},
  [126] = {.lex_state = 9},
  [127] = {.lex_state = 12},
  [128] = {.lex_state = 12},
  [129] = {.lex_state = 12},
  [130] = {.lex_state = 12},
  [131] = {.lex_state = 12},
  [132] = {.lex_state = 12},
  [133] = {.lex_state = 9},
  [134] = {.lex_state = 12},
  [135] = {.lex_state = 9},
  [136] = {.lex_state = 12},
  [137] = {.lex_state = 9},
  [138] = {.lex_state = 9},
  [139] = {.lex_state = 12},
  [140] = {.lex_state = 12},
  [141] = {.lex_state = 9},
  [142] = {.lex_state = 12},
  [143] = {.lex_state = 9},
  [144] = {.lex_state = 12},
  [145] = {.lex_state = 12},
  [146] = {.lex_state = 12},
  [147] = {.lex_state = 12},
  [148] = {.lex_state = 12},
  [149] = {.lex_state = 12},
  [150] = {.lex_state = 12},
  [151] = {.lex_state = 12},
  [152] = {.lex_state = 9},
  [153] = {.lex_state = 12},
  [154] = {.lex_state = 9},
  [155] = {.lex_state = 9},
  [156] = {.lex_state = 12},
  [157] = {.lex_state = 12},
  [158] = {.lex_state = 12},
  [159] = {.lex_state = 7},
  [160] = {.lex_state = 7},
  [161] = {.lex_state = 7},
  [162] = {.lex_state = 7},
  [163] = {.lex_state = 7},
  [164] = {.lex_state = 7},
  [165] = {.lex_state = 7},
  [166] = {.lex_state = 7},
  [167] = {.lex_state = 7},
  [168] = {.lex_state = 7},
  [169] = {.lex_state = 7},
  [170] = {.lex_state = 25, .external_lex_state = 2},
  [171] = {.lex_state = 25, .external_lex_state = 2},
  [172] = {.lex_state = 29, .external_lex_state = 4},
  [173] = {.lex_state = 25, .external_lex_state = 2},
  [174] = {.lex_state = 25, .external_lex_state = 2},
  [175] = {.lex_state = 25, .external_lex_state = 2},
  [176] = {.lex_state = 29, .external_lex_state = 3},
  [177] = {.lex_state = 25, .external_lex_state = 2},
  [178] = {.lex_state = 25, .external_lex_state = 2},
  [179] = {.lex_state = 25, .external_lex_state = 2},
  [180] = {.lex_state = 29, .external_lex_state = 3},
  [181] = {.lex_state = 25, .external_lex_state = 2},
  [182] = {.lex_state = 25, .external_lex_state = 2},
  [183] = {.lex_state = 29, .external_lex_state = 3},
  [184] = {.lex_state = 29, .external_lex_state = 3},
  [185] = {.lex_state = 29, .external_lex_state = 3},
  [186] = {.lex_state = 17, .external_lex_state = 4},
  [187] = {.lex_state = 97, .external_lex_state = 2},
  [188] = {.lex_state = 29, .external_lex_state = 3},
  [189] = {.lex_state = 29, .external_lex_state = 3},
  [190] = {.lex_state = 97, .external_lex_state = 2},
  [191] = {.lex_state = 97, .external_lex_state = 2},
  [192] = {.lex_state = 97, .external_lex_state = 2},
  [193] = {.lex_state = 97, .external_lex_state = 2},
  [194] = {.lex_state = 97, .external_lex_state = 2},
  [195] = {.lex_state = 97, .external_lex_state = 2},
  [196] = {.lex_state = 97, .external_lex_state = 2},
  [197] = {.lex_state = 97, .external_lex_state = 2},
  [198] = {.lex_state = 97, .external_lex_state = 2},
  [199] = {.lex_state = 29, .external_lex_state = 4},
  [200] = {.lex_state = 29, .external_lex_state = 3},
  [201] = {.lex_state = 29, .external_lex_state = 4},
  [202] = {.lex_state = 22},
  [203] = {.lex_state = 97, .external_lex_state = 2},
  [204] = {.lex_state = 97, .external_lex_state = 2},
  [205] = {.lex_state = 97, .external_lex_state = 2},
  [206] = {.lex_state = 97, .external_lex_state = 2},
  [207] = {.lex_state = 97, .external_lex_state = 2},
  [208] = {.lex_state = 97, .external_lex_state = 2},
  [209] = {.lex_state = 97, .external_lex_state = 2},
  [210] = {.lex_state = 97, .external_lex_state = 2},
  [211] = {.lex_state = 97, .external_lex_state = 2},
  [212] = {.lex_state = 97, .external_lex_state = 2},
  [213] = {.lex_state = 97, .external_lex_state = 2},
  [214] = {.lex_state = 97, .external_lex_state = 2},
  [215] = {.lex_state = 97, .external_lex_state = 2},
  [216] = {.lex_state = 97, .external_lex_state = 2},
  [217] = {.lex_state = 97, .external_lex_state = 2},
  [218] = {.lex_state = 97, .external_lex_state = 2},
  [219] = {.lex_state = 97, .external_lex_state = 2},
  [220] = {.lex_state = 97, .external_lex_state = 2},
  [221] = {.lex_state = 97, .external_lex_state = 2},
  [222] = {.lex_state = 97, .external_lex_state = 2},
  [223] = {.lex_state = 97, .external_lex_state = 2},
  [224] = {.lex_state = 97, .external_lex_state = 2},
  [225] = {.lex_state = 97, .external_lex_state = 2},
  [226] = {.lex_state = 97, .external_lex_state = 2},
  [227] = {.lex_state = 97, .external_lex_state = 2},
  [228] = {.lex_state = 97, .external_lex_state = 2},
  [229] = {.lex_state = 97, .external_lex_state = 2},
  [230] = {.lex_state = 97, .external_lex_state = 2},
  [231] = {.lex_state = 97, .external_lex_state = 2},
  [232] = {.lex_state = 97, .external_lex_state = 2},
  [233] = {.lex_state = 97, .external_lex_state = 2},
  [234] = {.lex_state = 97, .external_lex_state = 2},
  [235] = {.lex_state = 97, .external_lex_state = 2},
  [236] = {.lex_state = 97, .external_lex_state = 2},
  [237] = {.lex_state = 97, .external_lex_state = 2},
  [238] = {.lex_state = 97, .external_lex_state = 2},
  [239] = {.lex_state = 97, .external_lex_state = 2},
  [240] = {.lex_state = 97, .external_lex_state = 2},
  [241] = {.lex_state = 97, .external_lex_state = 2},
  [242] = {.lex_state = 19, .external_lex_state = 5},
  [243] = {.lex_state = 97, .external_lex_state = 2},
  [244] = {.lex_state = 29, .external_lex_state = 3},
  [245] = {.lex_state = 22},
  [246] = {.lex_state = 97, .external_lex_state = 2},
  [247] = {.lex_state = 29, .external_lex_state = 4},
  [248] = {.lex_state = 97, .external_lex_state = 2},
  [249] = {.lex_state = 29, .external_lex_state = 3},
  [250] = {.lex_state = 29, .external_lex_state = 4},
  [251] = {.lex_state = 97, .external_lex_state = 2},
  [252] = {.lex_state = 97, .external_lex_state = 2},
  [253] = {.lex_state = 97, .external_lex_state = 2},
  [254] = {.lex_state = 97, .external_lex_state = 2},
  [255] = {.lex_state = 97, .external_lex_state = 2},
  [256] = {.lex_state = 97, .external_lex_state = 2},
  [257] = {.lex_state = 97, .external_lex_state = 2},
  [258] = {.lex_state = 97, .external_lex_state = 2},
  [259] = {.lex_state = 97, .external_lex_state = 2},
  [260] = {.lex_state = 97, .external_lex_state = 2},
  [261] = {.lex_state = 10, .external_lex_state = 3},
  [262] = {.lex_state = 10, .external_lex_state = 3},
  [263] = {.lex_state = 10, .external_lex_state = 3},
  [264] = {.lex_state = 29, .external_lex_state = 4},
  [265] = {.lex_state = 29, .external_lex_state = 4},
  [266] = {.lex_state = 29, .external_lex_state = 4},
  [267] = {.lex_state = 29, .external_lex_state = 4},
  [268] = {.lex_state = 29, .external_lex_state = 4},
  [269] = {.lex_state = 21, .external_lex_state = 5},
  [270] = {.lex_state = 29, .external_lex_state = 4},
  [271] = {.lex_state = 29, .external_lex_state = 4},
  [272] = {.lex_state = 29, .external_lex_state = 4},
  [273] = {.lex_state = 29, .external_lex_state = 4},
  [274] = {.lex_state = 29, .external_lex_state = 4},
  [275] = {.lex_state = 29, .external_lex_state = 4},
  [276] = {.lex_state = 29, .external_lex_state = 4},
  [277] = {.lex_state = 29, .external_lex_state = 4},
  [278] = {.lex_state = 29, .external_lex_state = 4},
  [279] = {.lex_state = 29, .external_lex_state = 4},
  [280] = {.lex_state = 29, .external_lex_state = 4},
  [281] = {.lex_state = 29, .external_lex_state = 4},
  [282] = {.lex_state = 29, .external_lex_state = 4},
  [283] = {.lex_state = 29, .external_lex_state = 4},
  [284] = {.lex_state = 10, .external_lex_state = 3},
  [285] = {.lex_state = 29, .external_lex_state = 4},
  [286] = {.lex_state = 10, .external_lex_state = 3},
  [287] = {.lex_state = 29, .external_lex_state = 4},
  [288] = {.lex_state = 29, .external_lex_state = 4},
  [289] = {.lex_state = 29, .external_lex_state = 4},
  [290] = {.lex_state = 29, .external_lex_state = 4},
  [291] = {.lex_state = 29, .external_lex_state = 4},
  [292] = {.lex_state = 29, .external_lex_state = 4},
  [293] = {.lex_state = 21, .external_lex_state = 5},
  [294] = {.lex_state = 20, .external_lex_state = 5},
  [295] = {.lex_state = 10, .external_lex_state = 4},
  [296] = {.lex_state = 10, .external_lex_state = 4},
  [297] = {.lex_state = 10, .external_lex_state = 4},
  [298] = {.lex_state = 29, .external_lex_state = 3},
  [299] = {.lex_state = 33},
  [300] = {.lex_state = 29, .external_lex_state = 3},
  [301] = {.lex_state = 97, .external_lex_state = 3},
  [302] = {.lex_state = 10, .external_lex_state = 5},
  [303] = {.lex_state = 25, .external_lex_state = 3},
  [304] = {.lex_state = 20},
  [305] = {.lex_state = 22, .external_lex_state = 5},
  [306] = {.lex_state = 10, .external_lex_state = 5},
  [307] = {.lex_state = 22, .external_lex_state = 5},
  [308] = {.lex_state = 10, .external_lex_state = 5},
  [309] = {.lex_state = 25, .external_lex_state = 3},
  [310] = {.lex_state = 22, .external_lex_state = 5},
  [311] = {.lex_state = 18},
  [312] = {.lex_state = 25, .external_lex_state = 3},
  [313] = {.lex_state = 18},
  [314] = {.lex_state = 25, .external_lex_state = 3},
  [315] = {.lex_state = 29, .external_lex_state = 4},
  [316] = {.lex_state = 25, .external_lex_state = 3},
  [317] = {.lex_state = 24},
  [318] = {.lex_state = 22, .external_lex_state = 5},
  [319] = {.lex_state = 10, .external_lex_state = 5},
  [320] = {.lex_state = 10},
  [321] = {.lex_state = 10, .external_lex_state = 5},
  [322] = {.lex_state = 22, .external_lex_state = 5},
  [323] = {.lex_state = 10, .external_lex_state = 5},
  [324] = {.lex_state = 33, .external_lex_state = 3},
  [325] = {.lex_state = 29, .external_lex_state = 4},
  [326] = {.lex_state = 22},
  [327] = {.lex_state = 10},
  [328] = {.lex_state = 22},
  [329] = {.lex_state = 10},
  [330] = {.lex_state = 22},
  [331] = {.lex_state = 22},
  [332] = {.lex_state = 25, .external_lex_state = 3},
  [333] = {.lex_state = 10},
  [334] = {.lex_state = 22},
  [335] = {.lex_state = 25, .external_lex_state = 3},
  [336] = {.lex_state = 22},
  [337] = {.lex_state = 24},
  [338] = {.lex_state = 25, .external_lex_state = 4},
  [339] = {.lex_state = 22},
  [340] = {.lex_state = 22},
  [341] = {.lex_state = 22},
  [342] = {.lex_state = 33, .external_lex_state = 3},
  [343] = {.lex_state = 33, .external_lex_state = 3},
  [344] = {.lex_state = 22},
  [345] = {.lex_state = 22},
  [346] = {.lex_state = 22},
  [347] = {.lex_state = 22},
  [348] = {.lex_state = 10, .external_lex_state = 5},
  [349] = {.lex_state = 22},
  [350] = {.lex_state = 33, .external_lex_state = 3},
  [351] = {.lex_state = 22},
  [352] = {.lex_state = 10},
  [353] = {.lex_state = 22},
  [354] = {.lex_state = 33, .external_lex_state = 3},
  [355] = {.lex_state = 10},
  [356] = {.lex_state = 10},
  [357] = {.lex_state = 10},
  [358] = {.lex_state = 10},
  [359] = {.lex_state = 10},
  [360] = {.lex_state = 33, .external_lex_state = 3},
  [361] = {.lex_state = 10},
  [362] = {.lex_state = 31, .external_lex_state = 3},
  [363] = {.lex_state = 33, .external_lex_state = 4},
  [364] = {.lex_state = 10},
  [365] = {.lex_state = 10},
  [366] = {.lex_state = 10},
  [367] = {.lex_state = 10},
  [368] = {.lex_state = 10},
  [369] = {.lex_state = 10},
  [370] = {.lex_state = 10, .external_lex_state = 5},
  [371] = {.lex_state = 97, .external_lex_state = 4},
  [372] = {.lex_state = 97, .external_lex_state = 4},
  [373] = {.lex_state = 97, .external_lex_state = 4},
  [374] = {.lex_state = 24},
  [375] = {.lex_state = 97, .external_lex_state = 4},
  [376] = {.lex_state = 97, .external_lex_state = 4},
  [377] = {.lex_state = 33},
  [378] = {.lex_state = 10},
  [379] = {.lex_state = 10},
  [380] = {.lex_state = 33},
  [381] = {.lex_state = 97, .external_lex_state = 4},
  [382] = {.lex_state = 10},
  [383] = {.lex_state = 10},
  [384] = {.lex_state = 97, .external_lex_state = 4},
  [385] = {.lex_state = 10},
  [386] = {.lex_state = 10},
  [387] = {.lex_state = 10},
  [388] = {.lex_state = 33},
  [389] = {.lex_state = 10},
  [390] = {.lex_state = 33},
  [391] = {.lex_state = 97, .external_lex_state = 4},
  [392] = {.lex_state = 33},
  [393] = {.lex_state = 33},
  [394] = {.lex_state = 33},
  [395] = {.lex_state = 10},
  [396] = {.lex_state = 33},
  [397] = {.lex_state = 10},
  [398] = {.lex_state = 97, .external_lex_state = 4},
  [399] = {.lex_state = 10},
  [400] = {.lex_state = 97, .external_lex_state = 4},
  [401] = {.lex_state = 10},
  [402] = {.lex_state = 10},
  [403] = {.lex_state = 10},
  [404] = {.lex_state = 10},
  [405] = {.lex_state = 10},
  [406] = {.lex_state = 10},
  [407] = {.lex_state = 10},
  [408] = {.lex_state = 97, .external_lex_state = 4},
  [409] = {.lex_state = 10},
  [410] = {.lex_state = 10},
  [411] = {.lex_state = 10},
  [412] = {.lex_state = 10},
  [413] = {.lex_state = 10},
  [414] = {.lex_state = 10},
  [415] = {.lex_state = 10},
  [416] = {.lex_state = 10},
  [417] = {.lex_state = 10},
  [418] = {.lex_state = 10},
  [419] = {.lex_state = 10},
  [420] = {.lex_state = 10},
  [421] = {.lex_state = 10},
  [422] = {.lex_state = 10},
  [423] = {.lex_state = 10},
  [424] = {.lex_state = 27},
  [425] = {.lex_state = 27},
  [426] = {.lex_state = 34},
  [427] = {.lex_state = 34},
  [428] = {.lex_state = 34},
  [429] = {.lex_state = 34},
  [430] = {.lex_state = 31},
  [431] = {.lex_state = 31},
  [432] = {.lex_state = 34},
  [433] = {.lex_state = 31},
  [434] = {.lex_state = 31},
  [435] = {.lex_state = 31},
  [436] = {.lex_state = 31},
  [437] = {.lex_state = 97},
  [438] = {.lex_state = 27},
  [439] = {.lex_state = 31},
  [440] = {.lex_state = 31},
  [441] = {.lex_state = 31},
  [442] = {.lex_state = 31},
  [443] = {.lex_state = 27},
  [444] = {.lex_state = 31},
  [445] = {.lex_state = 31},
  [446] = {.lex_state = 31},
  [447] = {.lex_state = 34},
  [448] = {.lex_state = 34},
  [449] = {.lex_state = 31},
  [450] = {.lex_state = 97},
  [451] = {.lex_state = 34},
  [452] = {.lex_state = 97},
  [453] = {.lex_state = 31},
  [454] = {.lex_state = 31},
  [455] = {.lex_state = 97},
  [456] = {.lex_state = 97},
  [457] = {.lex_state = 97},
  [458] = {.lex_state = 33},
  [459] = {.lex_state = 97},
  [460] = {.lex_state = 31},
  [461] = {.lex_state = 25},
  [462] = {.lex_state = 25},
  [463] = {.lex_state = 25},
  [464] = {.lex_state = 33},
  [465] = {.lex_state = 97},
  [466] = {.lex_state = 25},
  [467] = {.lex_state = 31},
  [468] = {.lex_state = 25},
  [469] = {.lex_state = 97},
  [470] = {.lex_state = 97},
  [471] = {.lex_state = 25},
  [472] = {.lex_state = 25},
  [473] = {.lex_state = 25},
  [474] = {.lex_state = 25},
  [475] = {.lex_state = 97},
  [476] = {.lex_state = 31},
  [477] = {.lex_state = 25},
  [478] = {.lex_state = 34},
  [479] = {.lex_state = 25},
  [480] = {.lex_state = 25},
  [481] = {.lex_state = 25},
  [482] = {.lex_state = 97},
  [483] = {.lex_state = 25},
  [484] = {.lex_state = 25},
  [485] = {.lex_state = 31},
  [486] = {.lex_state = 97},
  [487] = {.lex_state = 97},
  [488] = {.lex_state = 97},
  [489] = {.lex_state = 31},
  [490] = {.lex_state = 31},
  [491] = {.lex_state = 97},
  [492] = {.lex_state = 97},
  [493] = {.lex_state = 97},
  [494] = {.lex_state = 97},
  [495] = {.lex_state = 97},
  [496] = {.lex_state = 97},
  [497] = {.lex_state = 97},
  [498] = {.lex_state = 97},
  [499] = {.lex_state = 97},
  [500] = {.lex_state = 97},
  [501] = {.lex_state = 97},
  [502] = {.lex_state = 97},
  [503] = {.lex_state = 97},
  [504] = {.lex_state = 97},
  [505] = {.lex_state = 97},
  [506] = {.lex_state = 97},
  [507] = {.lex_state = 97},
  [508] = {.lex_state = 97},
  [509] = {.lex_state = 97},
  [510] = {.lex_state = 97},
  [511] = {.lex_state = 25},
  [512] = {.lex_state = 25},
  [513] = {.lex_state = 31},
  [514] = {.lex_state = 97},
  [515] = {.lex_state = 31},
  [516] = {.lex_state = 97},
  [517] = {.lex_state = 39},
  [518] = {.lex_state = 97},
  [519] = {.lex_state = 39},
  [520] = {.lex_state = 97},
  [521] = {.lex_state = 97},
  [522] = {.lex_state = 97},
  [523] = {.lex_state = 97},
  [524] = {.lex_state = 97},
  [525] = {.lex_state = 97},
  [526] = {.lex_state = 97},
  [527] = {.lex_state = 31},
  [528] = {.lex_state = 97},
  [529] = {.lex_state = 97},
  [530] = {.lex_state = 97},
  [531] = {.lex_state = 97},
  [532] = {.lex_state = 97},
  [533] = {.lex_state = 196},
  [534] = {.lex_state = 97},
  [535] = {.lex_state = 97},
  [536] = {.lex_state = 97},
  [537] = {.lex_state = 97},
  [538] = {.lex_state = 97},
  [539] = {.lex_state = 25},
  [540] = {.lex_state = 97},
  [541] = {.lex_state = 31},
  [542] = {.lex_state = 25},
  [543] = {.lex_state = 25},
  [544] = {.lex_state = 97},
  [545] = {.lex_state = 97},
  [546] = {.lex_state = 97},
  [547] = {.lex_state = 97},
  [548] = {.lex_state = 97},
  [549] = {.lex_state = 97},
  [550] = {.lex_state = 97},
  [551] = {.lex_state = 97},
  [552] = {.lex_state = 25},
  [553] = {.lex_state = 25},
  [554] = {.lex_state = 97},
  [555] = {.lex_state = 97},
  [556] = {.lex_state = 33},
  [557] = {.lex_state = 97},
  [558] = {.lex_state = 97},
  [559] = {.lex_state = 97},
  [560] = {.lex_state = 97},
  [561] = {.lex_state = 25},
  [562] = {.lex_state = 97},
  [563] = {.lex_state = 97},
  [564] = {.lex_state = 25},
  [565] = {.lex_state = 97},
  [566] = {.lex_state = 97},
  [567] = {.lex_state = 33},
  [568] = {.lex_state = 97},
  [569] = {.lex_state = 25},
  [570] = {.lex_state = 25},
  [571] = {.lex_state = 97},
  [572] = {.lex_state = 25},
  [573] = {.lex_state = 25},
  [574] = {.lex_state = 25},
  [575] = {.lex_state = 25},
  [576] = {.lex_state = 25},
  [577] = {.lex_state = 25},
  [578] = {.lex_state = 97},
  [579] = {.lex_state = 25},
  [580] = {.lex_state = 206},
  [581] = {.lex_state = 25},
  [582] = {.lex_state = 31},
  [583] = {.lex_state = 25},
  [584] = {.lex_state = 31},
  [585] = {.lex_state = 25},
  [586] = {.lex_state = 31},
  [587] = {.lex_state = 97},
  [588] = {.lex_state = 25},
  [589] = {.lex_state = 97},
  [590] = {.lex_state = 97},
  [591] = {.lex_state = 97},
  [592] = {.lex_state = 97},
  [593] = {.lex_state = 97},
  [594] = {.lex_state = 196},
  [595] = {.lex_state = 206},
  [596] = {.lex_state = 97},
  [597] = {.lex_state = 97},
  [598] = {.lex_state = 25},
  [599] = {.lex_state = 25},
  [600] = {.lex_state = 97},
  [601] = {.lex_state = 196},
  [602] = {.lex_state = 206},
  [603] = {.lex_state = 25},
  [604] = {.lex_state = 206},
  [605] = {.lex_state = 196},
  [606] = {.lex_state = 25},
  [607] = {.lex_state = 196},
  [608] = {.lex_state = 206},
  [609] = {.lex_state = 97},
  [610] = {.lex_state = 196},
  [611] = {.lex_state = 206},
  [612] = {.lex_state = 25},
  [613] = {.lex_state = 196},
  [614] = {.lex_state = 206},
  [615] = {.lex_state = 25},
  [616] = {.lex_state = 97},
  [617] = {.lex_state = 25},
  [618] = {.lex_state = 25},
  [619] = {.lex_state = 25},
  [620] = {.lex_state = 97},
  [621] = {.lex_state = 25},
  [622] = {.lex_state = 25},
  [623] = {.lex_state = 33},
  [624] = {.lex_state = 97},
  [625] = {.lex_state = 25},
  [626] = {.lex_state = 97},
  [627] = {.lex_state = 25},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_ATimport] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_ATmedia] = ACTIONS(1),
    [anon_sym_ATcharset] = ACTIONS(1),
    [anon_sym_ATnamespace] = ACTIONS(1),
    [anon_sym_ATkeyframes] = ACTIONS(1),
    [aux_sym_keyframes_statement_token1] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_from] = ACTIONS(1),
    [sym_to] = ACTIONS(1),
    [anon_sym_ATsupports] = ACTIONS(1),
    [sym_nesting_selector] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_DOLLAR_EQ] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_important] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_only] = ACTIONS(1),
    [anon_sym_selector] = ACTIONS(1),
    [aux_sym_color_value_token1] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_at_keyword] = ACTIONS(1),
    [sym_js_comment] = ACTIONS(3),
    [sym_comment] = ACTIONS(5),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_COLONextend] = ACTIONS(1),
    [anon_sym_ATplugin] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_AT_LBRACE] = ACTIONS(1),
    [anon_sym_DASH2] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [sym_variable] = ACTIONS(1),
    [anon_sym_PLUS_] = ACTIONS(1),
    [sym__descendant_operator] = ACTIONS(1),
    [sym__pseudo_class_selector_colon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
  },
  [1] = {
    [sym_stylesheet] = STATE(596),
    [sym_import_statement] = STATE(10),
    [sym_media_statement] = STATE(10),
    [sym_charset_statement] = STATE(10),
    [sym_namespace_statement] = STATE(10),
    [sym_keyframes_statement] = STATE(10),
    [sym_supports_statement] = STATE(10),
    [sym_at_rule] = STATE(10),
    [sym_rule_set] = STATE(10),
    [sym_selectors] = STATE(521),
    [sym__selector] = STATE(375),
    [sym_universal_selector] = STATE(375),
    [sym_class_selector] = STATE(375),
    [sym_pseudo_class_selector] = STATE(375),
    [sym_pseudo_element_selector] = STATE(375),
    [sym_id_selector] = STATE(375),
    [sym_attribute_selector] = STATE(375),
    [sym_child_selector] = STATE(375),
    [sym_descendant_selector] = STATE(375),
    [sym_sibling_selector] = STATE(375),
    [sym_adjacent_sibling_selector] = STATE(375),
    [sym_namespace_selector] = STATE(375),
    [sym_declaration] = STATE(10),
    [sym_string_value] = STATE(375),
    [sym_mixin_definition] = STATE(10),
    [sym_each_statement] = STATE(10),
    [sym_plugin_statement] = STATE(10),
    [sym_interpolation] = STATE(342),
    [sym__concatenated_identifier] = STATE(363),
    [sym__mixin_name] = STATE(511),
    [aux_sym_stylesheet_repeat1] = STATE(10),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_ATimport] = ACTIONS(9),
    [anon_sym_ATmedia] = ACTIONS(11),
    [anon_sym_ATcharset] = ACTIONS(13),
    [anon_sym_ATnamespace] = ACTIONS(15),
    [anon_sym_ATkeyframes] = ACTIONS(17),
    [aux_sym_keyframes_statement_token1] = ACTIONS(17),
    [anon_sym_ATsupports] = ACTIONS(19),
    [sym_nesting_selector] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(23),
    [anon_sym_DOT] = ACTIONS(25),
    [anon_sym_COLON_COLON] = ACTIONS(27),
    [anon_sym_POUND] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_SQUOTE] = ACTIONS(35),
    [anon_sym_DQUOTE] = ACTIONS(37),
    [sym_identifier] = ACTIONS(39),
    [sym_at_keyword] = ACTIONS(41),
    [sym_js_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_each] = ACTIONS(43),
    [anon_sym_ATplugin] = ACTIONS(45),
    [anon_sym_AT_LBRACE] = ACTIONS(47),
    [sym_variable] = ACTIONS(49),
    [sym__pseudo_class_selector_colon] = ACTIONS(51),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 31,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(53), 1,
      anon_sym_ATimport,
    ACTIONS(55), 1,
      anon_sym_ATmedia,
    ACTIONS(57), 1,
      anon_sym_ATcharset,
    ACTIONS(59), 1,
      anon_sym_ATnamespace,
    ACTIONS(63), 1,
      anon_sym_RBRACE,
    ACTIONS(65), 1,
      anon_sym_ATsupports,
    ACTIONS(67), 1,
      anon_sym_DOT,
    ACTIONS(69), 1,
      anon_sym_POUND,
    ACTIONS(71), 1,
      anon_sym_GT,
    ACTIONS(73), 1,
      sym_identifier,
    ACTIONS(75), 1,
      sym_at_keyword,
    ACTIONS(77), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_ATplugin,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(83), 1,
      sym_variable,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    STATE(597), 1,
      sym_last_declaration,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(8), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [123] = 31,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(53), 1,
      anon_sym_ATimport,
    ACTIONS(55), 1,
      anon_sym_ATmedia,
    ACTIONS(57), 1,
      anon_sym_ATcharset,
    ACTIONS(59), 1,
      anon_sym_ATnamespace,
    ACTIONS(65), 1,
      anon_sym_ATsupports,
    ACTIONS(67), 1,
      anon_sym_DOT,
    ACTIONS(69), 1,
      anon_sym_POUND,
    ACTIONS(71), 1,
      anon_sym_GT,
    ACTIONS(73), 1,
      sym_identifier,
    ACTIONS(75), 1,
      sym_at_keyword,
    ACTIONS(77), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_ATplugin,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(83), 1,
      sym_variable,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    STATE(566), 1,
      sym_last_declaration,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(6), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [246] = 31,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(53), 1,
      anon_sym_ATimport,
    ACTIONS(55), 1,
      anon_sym_ATmedia,
    ACTIONS(57), 1,
      anon_sym_ATcharset,
    ACTIONS(59), 1,
      anon_sym_ATnamespace,
    ACTIONS(65), 1,
      anon_sym_ATsupports,
    ACTIONS(67), 1,
      anon_sym_DOT,
    ACTIONS(69), 1,
      anon_sym_POUND,
    ACTIONS(71), 1,
      anon_sym_GT,
    ACTIONS(73), 1,
      sym_identifier,
    ACTIONS(75), 1,
      sym_at_keyword,
    ACTIONS(77), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_ATplugin,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(83), 1,
      sym_variable,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    STATE(540), 1,
      sym_last_declaration,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(8), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [369] = 31,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(53), 1,
      anon_sym_ATimport,
    ACTIONS(55), 1,
      anon_sym_ATmedia,
    ACTIONS(57), 1,
      anon_sym_ATcharset,
    ACTIONS(59), 1,
      anon_sym_ATnamespace,
    ACTIONS(65), 1,
      anon_sym_ATsupports,
    ACTIONS(67), 1,
      anon_sym_DOT,
    ACTIONS(69), 1,
      anon_sym_POUND,
    ACTIONS(71), 1,
      anon_sym_GT,
    ACTIONS(73), 1,
      sym_identifier,
    ACTIONS(75), 1,
      sym_at_keyword,
    ACTIONS(77), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_ATplugin,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(83), 1,
      sym_variable,
    ACTIONS(89), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    STATE(538), 1,
      sym_last_declaration,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(4), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [492] = 31,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(53), 1,
      anon_sym_ATimport,
    ACTIONS(55), 1,
      anon_sym_ATmedia,
    ACTIONS(57), 1,
      anon_sym_ATcharset,
    ACTIONS(59), 1,
      anon_sym_ATnamespace,
    ACTIONS(65), 1,
      anon_sym_ATsupports,
    ACTIONS(67), 1,
      anon_sym_DOT,
    ACTIONS(69), 1,
      anon_sym_POUND,
    ACTIONS(71), 1,
      anon_sym_GT,
    ACTIONS(73), 1,
      sym_identifier,
    ACTIONS(75), 1,
      sym_at_keyword,
    ACTIONS(77), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_ATplugin,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(83), 1,
      sym_variable,
    ACTIONS(91), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    STATE(548), 1,
      sym_last_declaration,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(8), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [615] = 31,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(53), 1,
      anon_sym_ATimport,
    ACTIONS(55), 1,
      anon_sym_ATmedia,
    ACTIONS(57), 1,
      anon_sym_ATcharset,
    ACTIONS(59), 1,
      anon_sym_ATnamespace,
    ACTIONS(65), 1,
      anon_sym_ATsupports,
    ACTIONS(67), 1,
      anon_sym_DOT,
    ACTIONS(69), 1,
      anon_sym_POUND,
    ACTIONS(71), 1,
      anon_sym_GT,
    ACTIONS(73), 1,
      sym_identifier,
    ACTIONS(75), 1,
      sym_at_keyword,
    ACTIONS(77), 1,
      anon_sym_each,
    ACTIONS(79), 1,
      anon_sym_ATplugin,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(83), 1,
      sym_variable,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    STATE(626), 1,
      sym_last_declaration,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(2), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [738] = 30,
    ACTIONS(95), 1,
      anon_sym_ATimport,
    ACTIONS(98), 1,
      anon_sym_ATmedia,
    ACTIONS(101), 1,
      anon_sym_ATcharset,
    ACTIONS(104), 1,
      anon_sym_ATnamespace,
    ACTIONS(110), 1,
      anon_sym_RBRACE,
    ACTIONS(112), 1,
      anon_sym_ATsupports,
    ACTIONS(115), 1,
      sym_nesting_selector,
    ACTIONS(118), 1,
      anon_sym_STAR,
    ACTIONS(121), 1,
      anon_sym_DOT,
    ACTIONS(124), 1,
      anon_sym_COLON_COLON,
    ACTIONS(127), 1,
      anon_sym_POUND,
    ACTIONS(130), 1,
      anon_sym_LBRACK,
    ACTIONS(133), 1,
      anon_sym_GT,
    ACTIONS(136), 1,
      anon_sym_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_DQUOTE,
    ACTIONS(142), 1,
      sym_identifier,
    ACTIONS(145), 1,
      sym_at_keyword,
    ACTIONS(148), 1,
      anon_sym_each,
    ACTIONS(151), 1,
      anon_sym_ATplugin,
    ACTIONS(154), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(157), 1,
      sym_variable,
    ACTIONS(160), 1,
      sym__pseudo_class_selector_colon,
    STATE(316), 1,
      sym_interpolation,
    STATE(338), 1,
      sym__concatenated_identifier,
    STATE(437), 1,
      sym__mixin_name,
    STATE(522), 1,
      sym_selectors,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(107), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(371), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
    STATE(8), 16,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_postcss_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_mixin_statement,
      sym_extend_statement,
      sym_plugin_statement,
      aux_sym_block_repeat1,
  [858] = 30,
    ACTIONS(163), 1,
      ts_builtin_sym_end,
    ACTIONS(165), 1,
      anon_sym_ATimport,
    ACTIONS(168), 1,
      anon_sym_ATmedia,
    ACTIONS(171), 1,
      anon_sym_ATcharset,
    ACTIONS(174), 1,
      anon_sym_ATnamespace,
    ACTIONS(180), 1,
      anon_sym_ATsupports,
    ACTIONS(183), 1,
      sym_nesting_selector,
    ACTIONS(186), 1,
      anon_sym_STAR,
    ACTIONS(189), 1,
      anon_sym_DOT,
    ACTIONS(192), 1,
      anon_sym_COLON_COLON,
    ACTIONS(195), 1,
      anon_sym_POUND,
    ACTIONS(198), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_GT,
    ACTIONS(204), 1,
      anon_sym_SQUOTE,
    ACTIONS(207), 1,
      anon_sym_DQUOTE,
    ACTIONS(210), 1,
      sym_identifier,
    ACTIONS(213), 1,
      sym_at_keyword,
    ACTIONS(216), 1,
      anon_sym_each,
    ACTIONS(219), 1,
      anon_sym_ATplugin,
    ACTIONS(222), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(225), 1,
      sym_variable,
    ACTIONS(228), 1,
      sym__pseudo_class_selector_colon,
    STATE(342), 1,
      sym_interpolation,
    STATE(363), 1,
      sym__concatenated_identifier,
    STATE(511), 1,
      sym__mixin_name,
    STATE(521), 1,
      sym_selectors,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(177), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(9), 13,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_plugin_statement,
      aux_sym_stylesheet_repeat1,
    STATE(375), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [975] = 30,
    ACTIONS(9), 1,
      anon_sym_ATimport,
    ACTIONS(11), 1,
      anon_sym_ATmedia,
    ACTIONS(13), 1,
      anon_sym_ATcharset,
    ACTIONS(15), 1,
      anon_sym_ATnamespace,
    ACTIONS(19), 1,
      anon_sym_ATsupports,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(25), 1,
      anon_sym_DOT,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(29), 1,
      anon_sym_POUND,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_GT,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      sym_at_keyword,
    ACTIONS(43), 1,
      anon_sym_each,
    ACTIONS(45), 1,
      anon_sym_ATplugin,
    ACTIONS(47), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(49), 1,
      sym_variable,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(231), 1,
      ts_builtin_sym_end,
    STATE(342), 1,
      sym_interpolation,
    STATE(363), 1,
      sym__concatenated_identifier,
    STATE(511), 1,
      sym__mixin_name,
    STATE(521), 1,
      sym_selectors,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(17), 2,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
    STATE(9), 13,
      sym_import_statement,
      sym_media_statement,
      sym_charset_statement,
      sym_namespace_statement,
      sym_keyframes_statement,
      sym_supports_statement,
      sym_at_rule,
      sym_rule_set,
      sym_declaration,
      sym_mixin_definition,
      sym_each_statement,
      sym_plugin_statement,
      aux_sym_stylesheet_repeat1,
    STATE(375), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [1092] = 25,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(233), 1,
      anon_sym_SEMI,
    ACTIONS(239), 1,
      anon_sym_POUND,
    ACTIONS(241), 1,
      anon_sym_LBRACK,
    ACTIONS(245), 1,
      anon_sym_LPAREN2,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(251), 1,
      anon_sym_SQUOTE,
    ACTIONS(253), 1,
      anon_sym_DQUOTE,
    ACTIONS(255), 1,
      aux_sym_integer_value_token1,
    ACTIONS(257), 1,
      aux_sym_float_value_token1,
    ACTIONS(259), 1,
      sym_identifier,
    ACTIONS(261), 1,
      sym_plain_value,
    ACTIONS(263), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(265), 1,
      anon_sym_DOLLAR,
    ACTIONS(267), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(269), 1,
      anon_sym_AT_AT,
    ACTIONS(271), 1,
      sym_variable,
    STATE(269), 1,
      sym_interpolation,
    ACTIONS(235), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(237), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(243), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(449), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
    STATE(245), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [1195] = 25,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_POUND,
    ACTIONS(241), 1,
      anon_sym_LBRACK,
    ACTIONS(245), 1,
      anon_sym_LPAREN2,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(251), 1,
      anon_sym_SQUOTE,
    ACTIONS(253), 1,
      anon_sym_DQUOTE,
    ACTIONS(255), 1,
      aux_sym_integer_value_token1,
    ACTIONS(257), 1,
      aux_sym_float_value_token1,
    ACTIONS(259), 1,
      sym_identifier,
    ACTIONS(261), 1,
      sym_plain_value,
    ACTIONS(263), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(265), 1,
      anon_sym_DOLLAR,
    ACTIONS(267), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(269), 1,
      anon_sym_AT_AT,
    ACTIONS(273), 1,
      anon_sym_SEMI,
    ACTIONS(277), 1,
      sym_variable,
    STATE(269), 1,
      sym_interpolation,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(275), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(237), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(243), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(453), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
    STATE(202), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [1298] = 29,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(279), 1,
      sym_nesting_selector,
    ACTIONS(281), 1,
      anon_sym_DOT,
    ACTIONS(283), 1,
      anon_sym_POUND,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(287), 1,
      anon_sym_RPAREN,
    ACTIONS(289), 1,
      sym_important,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(293), 1,
      anon_sym_SQUOTE,
    ACTIONS(295), 1,
      anon_sym_DQUOTE,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(305), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    STATE(30), 1,
      sym_interpolation,
    STATE(43), 1,
      sym__concatenated_identifier,
    STATE(47), 1,
      sym_string_value,
    STATE(49), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(160), 11,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym_property_value,
      sym_value_value,
    STATE(373), 12,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
  [1407] = 29,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(279), 1,
      sym_nesting_selector,
    ACTIONS(281), 1,
      anon_sym_DOT,
    ACTIONS(283), 1,
      anon_sym_POUND,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      sym_important,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(293), 1,
      anon_sym_SQUOTE,
    ACTIONS(295), 1,
      anon_sym_DQUOTE,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(305), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(315), 1,
      anon_sym_RPAREN,
    STATE(30), 1,
      sym_interpolation,
    STATE(39), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(43), 1,
      sym__concatenated_identifier,
    STATE(47), 1,
      sym_string_value,
    STATE(160), 11,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym_property_value,
      sym_value_value,
    STATE(372), 12,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
  [1516] = 30,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(317), 1,
      anon_sym_SEMI,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(327), 1,
      anon_sym_COLON,
    ACTIONS(329), 1,
      anon_sym_LPAREN2,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(335), 1,
      sym_identifier,
    ACTIONS(337), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    STATE(56), 1,
      sym_interpolation,
    STATE(62), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(197), 1,
      sym_block,
    STATE(623), 1,
      sym_merge_identifier,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(430), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [1626] = 28,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(279), 1,
      sym_nesting_selector,
    ACTIONS(281), 1,
      anon_sym_DOT,
    ACTIONS(283), 1,
      anon_sym_POUND,
    ACTIONS(285), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      sym_important,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(293), 1,
      anon_sym_SQUOTE,
    ACTIONS(295), 1,
      anon_sym_DQUOTE,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(305), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    STATE(30), 1,
      sym_interpolation,
    STATE(43), 1,
      sym__concatenated_identifier,
    STATE(47), 1,
      sym_string_value,
    STATE(52), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(160), 11,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym_property_value,
      sym_value_value,
    STATE(381), 12,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
  [1732] = 28,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(281), 1,
      anon_sym_DOT,
    ACTIONS(341), 1,
      sym_nesting_selector,
    ACTIONS(343), 1,
      anon_sym_POUND,
    ACTIONS(345), 1,
      anon_sym_LBRACK,
    ACTIONS(347), 1,
      sym_important,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(351), 1,
      anon_sym_SQUOTE,
    ACTIONS(353), 1,
      anon_sym_DQUOTE,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(359), 1,
      sym_identifier,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(363), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(371), 1,
      sym_variable,
    STATE(261), 1,
      sym_interpolation,
    STATE(296), 1,
      sym__concatenated_identifier,
    STATE(297), 1,
      sym_string_value,
    STATE(315), 1,
      sym_namespace_selector,
    STATE(382), 11,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym_property_value,
      sym_value_value,
    STATE(408), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [1837] = 28,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(281), 1,
      anon_sym_DOT,
    ACTIONS(341), 1,
      sym_nesting_selector,
    ACTIONS(343), 1,
      anon_sym_POUND,
    ACTIONS(345), 1,
      anon_sym_LBRACK,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(351), 1,
      anon_sym_SQUOTE,
    ACTIONS(353), 1,
      anon_sym_DQUOTE,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(359), 1,
      sym_identifier,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(363), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(373), 1,
      sym_important,
    ACTIONS(375), 1,
      sym_variable,
    STATE(261), 1,
      sym_interpolation,
    STATE(296), 1,
      sym__concatenated_identifier,
    STATE(297), 1,
      sym_string_value,
    STATE(315), 1,
      sym_namespace_selector,
    STATE(395), 11,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym_property_value,
      sym_value_value,
    STATE(408), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [1942] = 26,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(379), 1,
      anon_sym_SEMI,
    ACTIONS(381), 1,
      anon_sym_RBRACE,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(389), 1,
      sym_important,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    STATE(44), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2041] = 25,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(397), 1,
      anon_sym_SEMI,
    ACTIONS(399), 1,
      sym_important,
    STATE(55), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2137] = 25,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(379), 1,
      anon_sym_SEMI,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(401), 1,
      sym_important,
    STATE(57), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2233] = 25,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(403), 1,
      anon_sym_SEMI,
    ACTIONS(405), 1,
      sym_important,
    STATE(54), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2329] = 25,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(407), 1,
      anon_sym_SEMI,
    ACTIONS(409), 1,
      sym_important,
    STATE(53), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2425] = 22,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(417), 1,
      anon_sym_LPAREN2,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_identifier,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(427), 1,
      sym_variable,
    STATE(370), 1,
      sym_interpolation,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(411), 2,
      sym_nesting_selector,
      sym_important,
    STATE(490), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
    STATE(397), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2511] = 22,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(417), 1,
      anon_sym_LPAREN2,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_identifier,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(431), 1,
      sym_variable,
    STATE(370), 1,
      sym_interpolation,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(429), 2,
      sym_nesting_selector,
      sym_important,
    STATE(490), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
    STATE(383), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2597] = 22,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(417), 1,
      anon_sym_LPAREN2,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(423), 1,
      sym_identifier,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(435), 1,
      sym_variable,
    STATE(370), 1,
      sym_interpolation,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(433), 2,
      sym_nesting_selector,
      sym_important,
    STATE(490), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
    STATE(389), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [2683] = 10,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(443), 1,
      anon_sym_LPAREN,
    ACTIONS(447), 1,
      sym__concat,
    STATE(29), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(100), 1,
      sym_arguments,
    ACTIONS(441), 3,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(437), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
    ACTIONS(445), 10,
      anon_sym_LPAREN2,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(439), 11,
      anon_sym_STAR,
      sym_important,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [2744] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym__concat,
    STATE(28), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(451), 12,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(449), 22,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [2795] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__concat,
    STATE(28), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(458), 12,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(456), 22,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [2846] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__concat,
    STATE(29), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(462), 12,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(460), 22,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [2897] = 10,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(472), 1,
      sym_identifier,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    STATE(183), 1,
      sym_interpolation,
    STATE(274), 1,
      sym__concatenated_identifier,
    ACTIONS(468), 3,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(470), 8,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(464), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
    ACTIONS(466), 11,
      anon_sym_STAR,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [2956] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 12,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(476), 23,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [3002] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(482), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(455), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3086] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(484), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(475), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3170] = 10,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(443), 1,
      anon_sym_LPAREN,
    ACTIONS(490), 1,
      sym__concat,
    STATE(72), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(100), 1,
      sym_arguments,
    ACTIONS(488), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(486), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
    ACTIONS(445), 12,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(439), 14,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [3228] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(492), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(488), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3312] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(451), 12,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(449), 23,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [3358] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(494), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(482), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3442] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    ACTIONS(498), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(496), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3525] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(500), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3604] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(504), 12,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(502), 22,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [3649] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(443), 1,
      anon_sym_LPAREN,
    ACTIONS(490), 1,
      sym__concat,
    STATE(72), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(100), 1,
      sym_arguments,
    ACTIONS(445), 12,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(439), 18,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [3702] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(441), 3,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(470), 9,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(437), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
    ACTIONS(466), 12,
      anon_sym_STAR,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [3751] = 24,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(397), 1,
      anon_sym_SEMI,
    ACTIONS(506), 1,
      anon_sym_RBRACE,
    ACTIONS(508), 1,
      sym_important,
    STATE(46), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3836] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(510), 1,
      anon_sym_LPAREN,
    ACTIONS(512), 1,
      sym__concat,
    STATE(65), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(104), 1,
      sym_arguments,
    ACTIONS(439), 15,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
    ACTIONS(445), 15,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
  [3889] = 22,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(514), 1,
      anon_sym_COMMA,
    ACTIONS(522), 1,
      anon_sym_POUND,
    ACTIONS(525), 1,
      anon_sym_LBRACK,
    ACTIONS(528), 1,
      anon_sym_LPAREN2,
    ACTIONS(531), 1,
      anon_sym_SQUOTE,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    ACTIONS(537), 1,
      aux_sym_integer_value_token1,
    ACTIONS(540), 1,
      aux_sym_float_value_token1,
    ACTIONS(543), 1,
      sym_identifier,
    ACTIONS(546), 1,
      sym_plain_value,
    ACTIONS(549), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(552), 1,
      anon_sym_DOLLAR,
    ACTIONS(555), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(558), 1,
      anon_sym_AT_AT,
    ACTIONS(561), 1,
      sym_variable,
    STATE(46), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(517), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(519), 2,
      sym_nesting_selector,
      sym_important,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [3970] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(468), 3,
      anon_sym_DOT,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(470), 9,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(464), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_RPAREN,
    ACTIONS(466), 12,
      anon_sym_STAR,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [4019] = 22,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(566), 1,
      anon_sym_RPAREN,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(570), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(572), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(564), 2,
      sym_nesting_selector,
      sym_important,
    STATE(509), 2,
      sym_parameter,
      sym_rest_parameter,
    STATE(385), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4100] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    ACTIONS(574), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(495), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4183] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(581), 1,
      anon_sym_POUND,
    ACTIONS(584), 1,
      anon_sym_LBRACK,
    ACTIONS(587), 1,
      anon_sym_LPAREN2,
    ACTIONS(590), 1,
      anon_sym_SQUOTE,
    ACTIONS(593), 1,
      anon_sym_DQUOTE,
    ACTIONS(596), 1,
      aux_sym_integer_value_token1,
    ACTIONS(599), 1,
      aux_sym_float_value_token1,
    ACTIONS(602), 1,
      sym_identifier,
    ACTIONS(605), 1,
      sym_plain_value,
    ACTIONS(608), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(611), 1,
      anon_sym_DOLLAR,
    ACTIONS(614), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(617), 1,
      anon_sym_AT_AT,
    ACTIONS(620), 1,
      sym_variable,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(578), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(576), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4262] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(570), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(572), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(564), 2,
      sym_nesting_selector,
      sym_important,
    STATE(526), 2,
      sym_parameter,
      sym_rest_parameter,
    STATE(385), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4340] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    ACTIONS(623), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4418] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(403), 1,
      anon_sym_SEMI,
    ACTIONS(405), 1,
      sym_important,
    STATE(46), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4500] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(625), 1,
      anon_sym_SEMI,
    ACTIONS(627), 1,
      sym_important,
    STATE(46), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4582] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(629), 1,
      anon_sym_SEMI,
    ACTIONS(631), 1,
      sym_important,
    STATE(46), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4664] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(490), 1,
      sym__concat,
    STATE(72), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(633), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
    ACTIONS(635), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(462), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(460), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [4716] = 23,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(377), 1,
      anon_sym_COMMA,
    ACTIONS(383), 1,
      sym_nesting_selector,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(395), 1,
      sym_variable,
    ACTIONS(397), 1,
      anon_sym_SEMI,
    ACTIONS(399), 1,
      sym_important,
    STATE(46), 1,
      aux_sym_declaration_repeat1,
    STATE(71), 1,
      sym_interpolation,
    STATE(161), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4798] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(637), 1,
      anon_sym_RPAREN,
    STATE(34), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [4875] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(639), 1,
      sym__concat,
    STATE(59), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(451), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(449), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [4922] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(510), 1,
      anon_sym_LPAREN,
    STATE(104), 1,
      sym_arguments,
    ACTIONS(466), 15,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
    ACTIONS(470), 15,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
  [4969] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 13,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_and,
      anon_sym_or,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(476), 19,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5012] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(642), 1,
      anon_sym_SEMI,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5089] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(644), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5166] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(646), 1,
      anon_sym_RPAREN,
    STATE(36), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5243] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__concat,
    STATE(59), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(458), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(456), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5290] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(512), 1,
      sym__concat,
    STATE(65), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(462), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(460), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5337] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(648), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5414] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(650), 1,
      sym__concat,
    STATE(68), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(451), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(449), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5461] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(443), 1,
      anon_sym_LPAREN,
    STATE(100), 1,
      sym_arguments,
    ACTIONS(470), 12,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 18,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5508] = 21,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(653), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5585] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(490), 1,
      sym__concat,
    STATE(72), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(462), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(460), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5632] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(490), 1,
      sym__concat,
    STATE(68), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(458), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(456), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5679] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(476), 17,
      sym__concat,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5721] = 20,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    STATE(40), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5795] = 20,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(313), 1,
      sym_variable,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    STATE(63), 1,
      aux_sym_postcss_statement_repeat1,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(289), 2,
      sym_nesting_selector,
      sym_important,
    STATE(160), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [5869] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(659), 1,
      sym_unit,
    ACTIONS(657), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(655), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5913] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(665), 1,
      sym_unit,
    ACTIONS(663), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(661), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5957] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(451), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(449), 20,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [5999] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(476), 20,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6041] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(451), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(449), 17,
      sym__concat,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6083] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(667), 1,
      sym_unit,
    ACTIONS(657), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(655), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6127] = 13,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(669), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_RBRACK,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      sym__concat,
    STATE(262), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(441), 3,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(445), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(671), 5,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
    ACTIONS(439), 6,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(437), 8,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_PLUS,
  [6187] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(679), 1,
      sym_unit,
    ACTIONS(663), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(661), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6231] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(683), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(681), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6272] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(687), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(685), 2,
      sym_nesting_selector,
      sym_important,
    STATE(412), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6343] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(691), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(689), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6384] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(695), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(693), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6425] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(699), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(697), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [6466] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_POUND,
    ACTIONS(705), 1,
      anon_sym_LBRACK,
    ACTIONS(707), 1,
      anon_sym_LPAREN2,
    ACTIONS(709), 1,
      anon_sym_SQUOTE,
    ACTIONS(711), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      aux_sym_integer_value_token1,
    ACTIONS(715), 1,
      aux_sym_float_value_token1,
    ACTIONS(717), 1,
      sym_identifier,
    ACTIONS(719), 1,
      sym_plain_value,
    ACTIONS(721), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(725), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(727), 1,
      anon_sym_AT_AT,
    ACTIONS(729), 1,
      sym_variable,
    STATE(66), 1,
      sym_interpolation,
    ACTIONS(701), 2,
      sym_nesting_selector,
      sym_important,
    STATE(11), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6537] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(733), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(731), 2,
      sym_nesting_selector,
      sym_important,
    STATE(406), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6608] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(737), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(735), 2,
      sym_nesting_selector,
      sym_important,
    STATE(421), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6679] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(741), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(739), 2,
      sym_nesting_selector,
      sym_important,
    STATE(405), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6750] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(745), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(743), 2,
      sym_nesting_selector,
      sym_important,
    STATE(159), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6821] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(749), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(747), 2,
      sym_nesting_selector,
      sym_important,
    STATE(96), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6892] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(753), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(751), 2,
      sym_nesting_selector,
      sym_important,
    STATE(403), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [6963] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(757), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(755), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7004] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(761), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(759), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7045] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(765), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(763), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7086] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(769), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(767), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7127] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(773), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(771), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7168] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(777), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(775), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7209] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(781), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(779), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7250] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(785), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(783), 2,
      sym_nesting_selector,
      sym_important,
    STATE(416), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [7321] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(773), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(771), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7362] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(769), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(767), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7403] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(781), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(779), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7444] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(761), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(759), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7485] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(777), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(775), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7526] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_POUND,
    ACTIONS(705), 1,
      anon_sym_LBRACK,
    ACTIONS(707), 1,
      anon_sym_LPAREN2,
    ACTIONS(709), 1,
      anon_sym_SQUOTE,
    ACTIONS(711), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      aux_sym_integer_value_token1,
    ACTIONS(715), 1,
      aux_sym_float_value_token1,
    ACTIONS(717), 1,
      sym_identifier,
    ACTIONS(719), 1,
      sym_plain_value,
    ACTIONS(721), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(725), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(727), 1,
      anon_sym_AT_AT,
    ACTIONS(789), 1,
      sym_variable,
    STATE(66), 1,
      sym_interpolation,
    ACTIONS(787), 2,
      sym_nesting_selector,
      sym_important,
    STATE(133), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [7597] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(793), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(791), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7638] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(765), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(763), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7679] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(797), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(795), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7720] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(801), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(799), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7761] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(805), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(803), 2,
      sym_nesting_selector,
      sym_important,
    STATE(419), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [7832] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(809), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(807), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7873] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(504), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(502), 19,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [7914] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(813), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(811), 2,
      sym_nesting_selector,
      sym_important,
    STATE(23), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [7985] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(817), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(815), 2,
      sym_nesting_selector,
      sym_important,
    STATE(399), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8056] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(821), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(819), 2,
      sym_nesting_selector,
      sym_important,
    STATE(404), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8127] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_POUND,
    ACTIONS(241), 1,
      anon_sym_LBRACK,
    ACTIONS(251), 1,
      anon_sym_SQUOTE,
    ACTIONS(253), 1,
      anon_sym_DQUOTE,
    ACTIONS(255), 1,
      aux_sym_integer_value_token1,
    ACTIONS(257), 1,
      aux_sym_float_value_token1,
    ACTIONS(261), 1,
      sym_plain_value,
    ACTIONS(265), 1,
      anon_sym_DOLLAR,
    ACTIONS(267), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(269), 1,
      anon_sym_AT_AT,
    ACTIONS(825), 1,
      anon_sym_LPAREN2,
    ACTIONS(827), 1,
      sym_identifier,
    ACTIONS(829), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(831), 1,
      sym_variable,
    STATE(310), 1,
      sym_interpolation,
    ACTIONS(823), 2,
      sym_nesting_selector,
      sym_important,
    STATE(346), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8198] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(835), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(833), 2,
      sym_nesting_selector,
      sym_important,
    STATE(401), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8269] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(839), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(837), 2,
      sym_nesting_selector,
      sym_important,
    STATE(411), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8340] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(703), 1,
      anon_sym_POUND,
    ACTIONS(705), 1,
      anon_sym_LBRACK,
    ACTIONS(707), 1,
      anon_sym_LPAREN2,
    ACTIONS(709), 1,
      anon_sym_SQUOTE,
    ACTIONS(711), 1,
      anon_sym_DQUOTE,
    ACTIONS(713), 1,
      aux_sym_integer_value_token1,
    ACTIONS(715), 1,
      aux_sym_float_value_token1,
    ACTIONS(717), 1,
      sym_identifier,
    ACTIONS(719), 1,
      sym_plain_value,
    ACTIONS(721), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(723), 1,
      anon_sym_DOLLAR,
    ACTIONS(725), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(727), 1,
      anon_sym_AT_AT,
    ACTIONS(843), 1,
      sym_variable,
    STATE(66), 1,
      sym_interpolation,
    ACTIONS(841), 2,
      sym_nesting_selector,
      sym_important,
    STATE(12), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8411] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(847), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(845), 2,
      sym_nesting_selector,
      sym_important,
    STATE(415), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8482] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(851), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(849), 2,
      sym_nesting_selector,
      sym_important,
    STATE(422), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8553] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(504), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(502), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [8594] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(855), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(853), 2,
      sym_nesting_selector,
      sym_important,
    STATE(414), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8665] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(859), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(857), 2,
      sym_nesting_selector,
      sym_important,
    STATE(356), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8736] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(863), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(861), 2,
      sym_nesting_selector,
      sym_important,
    STATE(387), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8807] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(867), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(865), 2,
      sym_nesting_selector,
      sym_important,
    STATE(19), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8878] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(871), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(869), 2,
      sym_nesting_selector,
      sym_important,
    STATE(420), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [8949] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(875), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(873), 2,
      sym_nesting_selector,
      sym_important,
    STATE(386), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9020] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(757), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(755), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [9061] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(879), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(877), 2,
      sym_nesting_selector,
      sym_important,
    STATE(409), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9132] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(691), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(689), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [9173] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(435), 1,
      sym_variable,
    ACTIONS(568), 1,
      sym_identifier,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(433), 2,
      sym_nesting_selector,
      sym_important,
    STATE(389), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9244] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(695), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(693), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [9285] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(809), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(807), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [9326] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(883), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(881), 2,
      sym_nesting_selector,
      sym_important,
    STATE(407), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9397] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(887), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(885), 2,
      sym_nesting_selector,
      sym_important,
    STATE(22), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9468] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(699), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(697), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [9509] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(371), 1,
      sym_variable,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(347), 2,
      sym_nesting_selector,
      sym_important,
    STATE(382), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9580] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(683), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(681), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [9621] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(431), 1,
      sym_variable,
    ACTIONS(568), 1,
      sym_identifier,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(429), 2,
      sym_nesting_selector,
      sym_important,
    STATE(383), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9692] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(891), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(889), 2,
      sym_nesting_selector,
      sym_important,
    STATE(21), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9763] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(291), 1,
      anon_sym_LPAREN2,
    ACTIONS(297), 1,
      aux_sym_integer_value_token1,
    ACTIONS(299), 1,
      aux_sym_float_value_token1,
    ACTIONS(303), 1,
      sym_plain_value,
    ACTIONS(307), 1,
      anon_sym_DOLLAR,
    ACTIONS(309), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(311), 1,
      anon_sym_AT_AT,
    ACTIONS(321), 1,
      anon_sym_POUND,
    ACTIONS(323), 1,
      anon_sym_LBRACK,
    ACTIONS(331), 1,
      anon_sym_SQUOTE,
    ACTIONS(333), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(895), 1,
      sym_variable,
    STATE(71), 1,
      sym_interpolation,
    ACTIONS(893), 2,
      sym_nesting_selector,
      sym_important,
    STATE(20), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9834] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(899), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(897), 2,
      sym_nesting_selector,
      sym_important,
    STATE(418), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9905] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(903), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(901), 2,
      sym_nesting_selector,
      sym_important,
    STATE(417), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [9976] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(907), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(905), 2,
      sym_nesting_selector,
      sym_important,
    STATE(379), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10047] = 20,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(911), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    STATE(410), 1,
      sym_binary_expression,
    ACTIONS(909), 2,
      sym_nesting_selector,
      sym_important,
    STATE(423), 12,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10120] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(915), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(913), 2,
      sym_nesting_selector,
      sym_important,
    STATE(413), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10191] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(801), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(799), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10232] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(919), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(917), 2,
      sym_nesting_selector,
      sym_important,
    STATE(378), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10303] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(797), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(795), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10344] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(793), 14,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(791), 16,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10385] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(375), 1,
      sym_variable,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(373), 2,
      sym_nesting_selector,
      sym_important,
    STATE(395), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10456] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(427), 1,
      sym_variable,
    ACTIONS(568), 1,
      sym_identifier,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(411), 2,
      sym_nesting_selector,
      sym_important,
    STATE(397), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10527] = 19,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN2,
    ACTIONS(355), 1,
      aux_sym_integer_value_token1,
    ACTIONS(357), 1,
      aux_sym_float_value_token1,
    ACTIONS(361), 1,
      sym_plain_value,
    ACTIONS(365), 1,
      anon_sym_DOLLAR,
    ACTIONS(367), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(369), 1,
      anon_sym_AT_AT,
    ACTIONS(413), 1,
      anon_sym_POUND,
    ACTIONS(415), 1,
      anon_sym_LBRACK,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(568), 1,
      sym_identifier,
    ACTIONS(923), 1,
      sym_variable,
    STATE(323), 1,
      sym_interpolation,
    ACTIONS(921), 2,
      sym_nesting_selector,
      sym_important,
    STATE(402), 13,
      sym__value,
      sym_parenthesized_value,
      sym_color_value,
      sym_string_value,
      sym_integer_value,
      sym_float_value,
      sym_grid_value,
      sym_call_expression,
      sym_binary_expression,
      sym_list_value,
      sym__concatenated_identifier,
      sym_property_value,
      sym_value_value,
  [10598] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(925), 6,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(517), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10642] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(929), 6,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(927), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      sym_nesting_selector,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10686] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(385), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(387), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(933), 6,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(931), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10730] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(397), 1,
      anon_sym_SEMI,
    ACTIONS(506), 1,
      anon_sym_RBRACE,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10774] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(629), 1,
      anon_sym_SEMI,
    ACTIONS(935), 1,
      anon_sym_RBRACE,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10818] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(937), 1,
      anon_sym_SEMI,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10859] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_SEMI,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10900] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_SEMI,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10941] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(397), 1,
      anon_sym_SEMI,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [10982] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(939), 1,
      anon_sym_SEMI,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [11023] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(629), 1,
      anon_sym_SEMI,
    ACTIONS(470), 11,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_plain_value,
      anon_sym_DOLLAR,
      sym_variable,
    ACTIONS(466), 16,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_LBRACK,
      sym_important,
      anon_sym_LPAREN2,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_AT_AT,
  [11064] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(272), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11123] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(398), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11182] = 7,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(947), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(274), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(468), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(464), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [11225] = 16,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(949), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    STATE(315), 1,
      sym_namespace_selector,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(408), 12,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_string_value,
  [11286] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(391), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11345] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(400), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11404] = 7,
    ACTIONS(955), 1,
      anon_sym_LPAREN,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(277), 1,
      sym_pseudo_class_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(953), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(951), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [11447] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(289), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11506] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(290), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11565] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(291), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11624] = 7,
    ACTIONS(955), 1,
      anon_sym_LPAREN,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(278), 1,
      sym_pseudo_class_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(961), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(959), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [11667] = 15,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(945), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(292), 13,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_namespace_selector,
      sym_string_value,
  [11726] = 16,
    ACTIONS(21), 1,
      sym_nesting_selector,
    ACTIONS(23), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_COLON_COLON,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_SQUOTE,
    ACTIONS(37), 1,
      anon_sym_DQUOTE,
    ACTIONS(51), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(941), 1,
      anon_sym_DOT,
    ACTIONS(943), 1,
      anon_sym_POUND,
    ACTIONS(963), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(282), 1,
      sym__concatenated_identifier,
    STATE(325), 1,
      sym_namespace_selector,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    STATE(408), 12,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
      sym_string_value,
  [11787] = 5,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(462), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(460), 21,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [11825] = 5,
    ACTIONS(957), 1,
      sym__concat,
    STATE(185), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(458), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(456), 21,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [11863] = 5,
    ACTIONS(965), 1,
      sym__concat,
    STATE(185), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(451), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(449), 21,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [11901] = 10,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_GT,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(947), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(274), 1,
      sym__concatenated_identifier,
    ACTIONS(470), 3,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(466), 7,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(464), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
  [11949] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(968), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(970), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [11982] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(451), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(449), 22,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [12015] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(478), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(476), 22,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [12048] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(972), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(974), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12081] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(976), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(978), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12114] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(980), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(982), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [12147] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(984), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(986), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12180] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(988), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(990), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [12213] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(992), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(994), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [12246] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(996), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(998), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12279] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1000), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1002), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12312] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1004), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1006), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12345] = 5,
    ACTIONS(955), 1,
      anon_sym_LPAREN,
    STATE(278), 1,
      sym_pseudo_class_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(961), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(959), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [12382] = 5,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1010), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1008), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [12419] = 5,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    STATE(267), 1,
      sym_pseudo_element_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1014), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1012), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [12456] = 11,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1018), 1,
      anon_sym_SEMI,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(1022), 4,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1020), 6,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    STATE(446), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [12505] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(984), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(986), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12538] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1030), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1032), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12571] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1034), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1036), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12604] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1038), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1040), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12637] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(988), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(990), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [12670] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1042), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1044), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12703] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1046), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1048), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12736] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1050), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1052), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12769] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(996), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(998), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12802] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1054), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1056), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12835] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(980), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(982), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [12868] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1058), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1060), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12901] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1062), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1064), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12934] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1066), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1068), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [12967] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1070), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1072), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13000] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1030), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1032), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13033] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1074), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(1076), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [13066] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1038), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1040), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13099] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1046), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1048), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13132] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1050), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1052), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13165] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1066), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1068), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13198] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1078), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1080), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13231] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1054), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1056), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13264] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1082), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1084), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13297] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1086), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1088), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13330] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1090), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1092), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13363] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1058), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1060), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13396] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1000), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1002), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13429] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1000), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1002), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13462] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1062), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1064), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13495] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1094), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1096), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13528] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(992), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(994), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [13561] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(976), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(978), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13594] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1098), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1100), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13627] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1070), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1072), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13660] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1102), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1104), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13693] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1106), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1108), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13726] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1110), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1112), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13759] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(972), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(974), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13792] = 10,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1114), 1,
      anon_sym_LPAREN,
    ACTIONS(1116), 1,
      sym__concat,
    STATE(305), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(330), 1,
      sym_arguments,
    ACTIONS(486), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(488), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(439), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
    ACTIONS(445), 9,
      anon_sym_GT,
      anon_sym_LPAREN2,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [13839] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1078), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1080), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13872] = 5,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1120), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1118), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [13909] = 11,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1122), 1,
      anon_sym_SEMI,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(1022), 4,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1020), 6,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    STATE(454), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [13958] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1124), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1126), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [13991] = 5,
    ACTIONS(955), 1,
      anon_sym_LPAREN,
    STATE(277), 1,
      sym_pseudo_class_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(953), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(951), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14028] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1128), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(1130), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [14061] = 5,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(441), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(437), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14098] = 5,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    STATE(276), 1,
      sym_pseudo_element_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1134), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1132), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14135] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1004), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1006), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14168] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1102), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1104), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14201] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1124), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1126), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14234] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1034), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1036), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14267] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1110), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1112), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14300] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(968), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(970), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [14333] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1074), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(1076), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [14366] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1082), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1084), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14399] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1128), 12,
      sym__pseudo_class_selector_colon,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
    ACTIONS(1130), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
  [14432] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1098), 12,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      sym_identifier,
      sym_at_keyword,
      anon_sym_each,
      anon_sym_ATplugin,
      sym_variable,
    ACTIONS(1100), 12,
      sym__pseudo_class_selector_colon,
      ts_builtin_sym_end,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_AT_LBRACE,
  [14465] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym__concat,
    STATE(262), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(462), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(460), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14503] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym__concat,
    STATE(263), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(458), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(456), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14541] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1136), 1,
      sym__concat,
    STATE(263), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(451), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(449), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14579] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1141), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1139), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14610] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1145), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1143), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14641] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1149), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1147), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14672] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1153), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1151), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14703] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1157), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1155), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14734] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_COMMA,
    ACTIONS(1116), 1,
      sym__concat,
    STATE(305), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(635), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(462), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(460), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [14775] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1120), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1118), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14806] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(504), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(502), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14837] = 4,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1163), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1159), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14870] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1167), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1165), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14901] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1010), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1008), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14932] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1171), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1169), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14963] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1175), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1173), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [14994] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1179), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1177), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15025] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1183), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1181), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15056] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1187), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1185), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15087] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1191), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1189), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15118] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1195), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1193), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15149] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(441), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(437), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15180] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1199), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1197), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15211] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(451), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(449), 19,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [15244] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1203), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1201), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15275] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(476), 19,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [15308] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1207), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1205), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15339] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1211), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1209), 20,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15370] = 4,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1215), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1213), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15403] = 4,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1219), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1217), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15436] = 4,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1223), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1221), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15469] = 4,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1227), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1225), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLONextend,
  [15502] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 10,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(476), 11,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [15534] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1114), 1,
      anon_sym_LPAREN,
    ACTIONS(1116), 1,
      sym__concat,
    STATE(305), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(330), 1,
      sym_arguments,
    ACTIONS(439), 8,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
    ACTIONS(445), 9,
      anon_sym_GT,
      anon_sym_LPAREN2,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [15574] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(504), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(502), 18,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [15606] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_GT,
    ACTIONS(470), 2,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(466), 8,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(437), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
  [15642] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(468), 1,
      anon_sym_GT,
    ACTIONS(470), 2,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(466), 8,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(464), 10,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
  [15678] = 7,
    ACTIONS(673), 1,
      anon_sym_RBRACK,
    ACTIONS(957), 1,
      sym__concat,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(441), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(671), 6,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
    ACTIONS(437), 9,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
  [15715] = 14,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1229), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1233), 1,
      anon_sym_COLON,
    STATE(231), 1,
      sym_block,
    STATE(556), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(431), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [15766] = 7,
    ACTIONS(957), 1,
      sym__concat,
    ACTIONS(1237), 1,
      anon_sym_RBRACK,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(441), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1235), 6,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
    ACTIONS(437), 9,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
  [15803] = 6,
    ACTIONS(957), 1,
      sym__concat,
    ACTIONS(1241), 1,
      anon_sym_LPAREN2,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1239), 3,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_important,
    ACTIONS(1008), 14,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_COLONextend,
  [15838] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(1243), 1,
      sym__concat,
    STATE(321), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(445), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(439), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [15877] = 8,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1245), 1,
      anon_sym_COLON,
    ACTIONS(1247), 1,
      sym__concat,
    STATE(314), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(623), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(437), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
  [15915] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1114), 1,
      anon_sym_LPAREN,
    STATE(330), 1,
      sym_arguments,
    ACTIONS(466), 8,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
    ACTIONS(470), 9,
      anon_sym_GT,
      anon_sym_LPAREN2,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [15949] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1116), 1,
      sym__concat,
    STATE(307), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(458), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(456), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [15983] = 10,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(1243), 1,
      sym__concat,
    ACTIONS(1249), 1,
      anon_sym_COLON,
    STATE(321), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(445), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(486), 3,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(439), 8,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16025] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1251), 1,
      sym__concat,
    STATE(307), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(451), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(449), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16059] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(476), 16,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_and,
      anon_sym_or,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16089] = 8,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1247), 1,
      sym__concat,
    ACTIONS(1254), 1,
      anon_sym_COLON,
    STATE(314), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(623), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(437), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
  [16127] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1116), 1,
      sym__concat,
    STATE(305), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(462), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(460), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16161] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1256), 1,
      sym_unit,
    ACTIONS(657), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(655), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16192] = 5,
    ACTIONS(1258), 1,
      sym__concat,
    STATE(312), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(451), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(449), 14,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
      anon_sym_PLUS_,
  [16223] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1261), 1,
      sym_unit,
    ACTIONS(663), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(661), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16254] = 5,
    ACTIONS(1247), 1,
      sym__concat,
    STATE(312), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(458), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(456), 14,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
      anon_sym_PLUS_,
  [16285] = 5,
    ACTIONS(673), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(468), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(671), 6,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
    ACTIONS(464), 9,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
  [16316] = 5,
    ACTIONS(1247), 1,
      sym__concat,
    STATE(314), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(462), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(460), 14,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
      anon_sym_PLUS_,
  [16347] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1263), 1,
      sym_unit,
    ACTIONS(657), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(655), 14,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16378] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(451), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(449), 10,
      sym__concat,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16407] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1265), 1,
      sym__concat,
    STATE(319), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(451), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(449), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16440] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(470), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(466), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16473] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1243), 1,
      sym__concat,
    STATE(319), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(458), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(456), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16506] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(478), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(476), 10,
      sym__concat,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16535] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1243), 1,
      sym__concat,
    STATE(321), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(462), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(460), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16568] = 8,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1268), 1,
      anon_sym_COLON,
    ACTIONS(1270), 1,
      sym__concat,
    STATE(343), 1,
      aux_sym__concatenated_identifier_repeat1,
    STATE(556), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(437), 12,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
  [16605] = 5,
    ACTIONS(1237), 1,
      anon_sym_RBRACK,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(468), 2,
      anon_sym_TILDE,
      anon_sym_PIPE,
    ACTIONS(1235), 6,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
    ACTIONS(464), 9,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_PLUS,
  [16636] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(809), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(807), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16664] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(801), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(799), 14,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      sym_important,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16692] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(769), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(767), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16720] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(809), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(807), 14,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      sym_important,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16748] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(773), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(771), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16776] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(781), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(779), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16804] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(478), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(476), 15,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
      anon_sym_PLUS_,
  [16830] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(777), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(775), 14,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16858] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(777), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(775), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16886] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(451), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(449), 15,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
      anon_sym_PLUS_,
  [16912] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(765), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(763), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [16940] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1272), 1,
      sym_unit,
    ACTIONS(663), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(661), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [16970] = 6,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1254), 1,
      anon_sym_COLON,
    STATE(623), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(437), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_COLONextend,
  [17002] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(797), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(795), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17030] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(683), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(681), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17058] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(699), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(697), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17086] = 5,
    ACTIONS(1270), 1,
      sym__concat,
    STATE(343), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(462), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(460), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PLUS_,
  [17116] = 5,
    ACTIONS(1270), 1,
      sym__concat,
    STATE(350), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(458), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(456), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PLUS_,
  [17146] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(695), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(693), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17174] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(691), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(689), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17202] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(757), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(755), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17230] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(793), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(791), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17258] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(451), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(449), 14,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17286] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(504), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(502), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17314] = 5,
    ACTIONS(1274), 1,
      sym__concat,
    STATE(350), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(451), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(449), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PLUS_,
  [17344] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(761), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(759), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17372] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(695), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(693), 14,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      sym_important,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17400] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(801), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(799), 9,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_LPAREN2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_LBRACE,
  [17428] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(478), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(476), 14,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PLUS_,
  [17453] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(504), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(502), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17480] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(757), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(755), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17507] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(699), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(697), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17534] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(683), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(681), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17561] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(773), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(771), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17588] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(451), 2,
      anon_sym_PLUS,
      anon_sym_COLON,
    ACTIONS(449), 14,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      sym__concat,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PLUS_,
  [17613] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(769), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(767), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17640] = 5,
    ACTIONS(957), 1,
      sym__concat,
    ACTIONS(1239), 1,
      anon_sym_LPAREN2,
    STATE(184), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1008), 13,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
  [17669] = 6,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1268), 1,
      anon_sym_COLON,
    STATE(556), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(437), 12,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PIPE,
  [17700] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(781), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(779), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17727] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(691), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(689), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17754] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(793), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(791), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17781] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(797), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(795), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17808] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(761), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(759), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17835] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(765), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(763), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17862] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1243), 1,
      sym__concat,
    STATE(321), 1,
      aux_sym__concatenated_identifier_repeat1,
    ACTIONS(633), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(462), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(460), 9,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [17895] = 15,
    ACTIONS(1277), 1,
      anon_sym_COMMA,
    ACTIONS(1279), 1,
      anon_sym_LBRACE,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1295), 1,
      anon_sym_COLONextend,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    STATE(507), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [17943] = 14,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    ACTIONS(498), 1,
      anon_sym_RPAREN,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    STATE(496), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [17988] = 14,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    ACTIONS(574), 1,
      anon_sym_RPAREN,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    STATE(495), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [18033] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1301), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(470), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(466), 10,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18060] = 14,
    ACTIONS(1277), 1,
      anon_sym_COMMA,
    ACTIONS(1279), 1,
      anon_sym_LBRACE,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    STATE(507), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [18105] = 4,
    ACTIONS(1303), 1,
      anon_sym_DOT,
    ACTIONS(1306), 1,
      anon_sym_GT,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1139), 12,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
      anon_sym_COLONextend,
  [18130] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(440), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18160] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1313), 1,
      anon_sym_RBRACK,
    STATE(499), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18190] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1317), 3,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18216] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(460), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18246] = 12,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(623), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [18286] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1319), 1,
      anon_sym_RBRACK,
    STATE(502), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18316] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1321), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18346] = 4,
    ACTIONS(1323), 1,
      anon_sym_DOT,
    ACTIONS(1326), 1,
      anon_sym_GT,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1139), 11,
      sym__descendant_operator,
      sym__pseudo_class_selector_colon,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
      anon_sym_PIPE,
  [18370] = 6,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1331), 1,
      anon_sym_COLON,
    ACTIONS(1329), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18398] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1333), 1,
      anon_sym_RBRACK,
    STATE(504), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18428] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1335), 1,
      anon_sym_RPAREN,
    STATE(506), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18458] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(434), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18488] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1337), 1,
      anon_sym_RPAREN,
    STATE(508), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18518] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1339), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(490), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18548] = 12,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1341), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [18588] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(435), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18618] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(433), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18648] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(445), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18678] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1343), 1,
      anon_sym_RBRACK,
    STATE(492), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18708] = 7,
    ACTIONS(249), 1,
      anon_sym_selector,
    ACTIONS(1024), 1,
      anon_sym_LPAREN2,
    ACTIONS(1026), 1,
      sym_identifier,
    ACTIONS(1028), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(247), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(476), 7,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
      sym_interpolation,
  [18738] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1345), 1,
      anon_sym_RPAREN,
    STATE(493), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18768] = 12,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(1347), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [18807] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1349), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18832] = 12,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(1351), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [18871] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_RBRACK,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18895] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18919] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1357), 1,
      anon_sym_COMMA,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18943] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1359), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18967] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1361), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [18991] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1363), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19015] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1365), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19039] = 11,
    ACTIONS(1281), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1283), 1,
      anon_sym_POUND,
    ACTIONS(1285), 1,
      anon_sym_LBRACK,
    ACTIONS(1287), 1,
      anon_sym_GT,
    ACTIONS(1289), 1,
      anon_sym_TILDE,
    ACTIONS(1291), 1,
      anon_sym_PLUS,
    ACTIONS(1293), 1,
      anon_sym_PIPE,
    ACTIONS(1297), 1,
      sym__descendant_operator,
    ACTIONS(1299), 1,
      sym__pseudo_class_selector_colon,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1161), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [19075] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_RBRACK,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19099] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1369), 1,
      anon_sym_RPAREN,
    ACTIONS(470), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(466), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19123] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19147] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1373), 1,
      anon_sym_SEMI,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19171] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1375), 1,
      anon_sym_SEMI,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19195] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1377), 1,
      anon_sym_SEMI,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19219] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1379), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19243] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1381), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19267] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1383), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19291] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19315] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1387), 1,
      anon_sym_COMMA,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19339] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19363] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1391), 1,
      anon_sym_SEMI,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19387] = 5,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_RBRACE,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19411] = 4,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(1315), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1311), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [19432] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(1395), 2,
      sym_identifier,
      sym_plain_value,
    STATE(624), 2,
      sym_string_value,
      sym_call_expression,
  [19459] = 8,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(1395), 2,
      sym_identifier,
      sym_plain_value,
    STATE(547), 2,
      sym_string_value,
      sym_call_expression,
  [19486] = 6,
    ACTIONS(1397), 1,
      anon_sym_RBRACE,
    ACTIONS(1401), 1,
      aux_sym_integer_value_token1,
    STATE(524), 1,
      sym_integer_value,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1399), 2,
      sym_from,
      sym_to,
    STATE(429), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
  [19508] = 6,
    ACTIONS(1401), 1,
      aux_sym_integer_value_token1,
    ACTIONS(1403), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_integer_value,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1399), 2,
      sym_from,
      sym_to,
    STATE(426), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
  [19530] = 6,
    ACTIONS(1401), 1,
      aux_sym_integer_value_token1,
    ACTIONS(1405), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_integer_value,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1399), 2,
      sym_from,
      sym_to,
    STATE(429), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
  [19552] = 6,
    ACTIONS(1407), 1,
      anon_sym_RBRACE,
    ACTIONS(1412), 1,
      aux_sym_integer_value_token1,
    STATE(524), 1,
      sym_integer_value,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1409), 2,
      sym_from,
      sym_to,
    STATE(429), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
  [19574] = 7,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1417), 1,
      anon_sym_SEMI,
    STATE(236), 1,
      sym_block,
    STATE(450), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19598] = 7,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1421), 1,
      anon_sym_SEMI,
    STATE(260), 1,
      sym_block,
    STATE(452), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19622] = 6,
    ACTIONS(1401), 1,
      aux_sym_integer_value_token1,
    ACTIONS(1423), 1,
      anon_sym_RBRACE,
    STATE(524), 1,
      sym_integer_value,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1399), 2,
      sym_from,
      sym_to,
    STATE(428), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
  [19644] = 6,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(251), 1,
      sym_block,
    STATE(456), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19665] = 6,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(198), 1,
      sym_block,
    STATE(486), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19686] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1425), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19699] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1427), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19712] = 7,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    ACTIONS(1429), 1,
      anon_sym_SEMI,
    ACTIONS(1431), 1,
      sym_important,
    ACTIONS(1433), 1,
      anon_sym_LPAREN2,
    STATE(485), 1,
      sym_parameters,
    STATE(529), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [19735] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(1395), 1,
      sym_plain_value,
    ACTIONS(1435), 1,
      sym_identifier,
    STATE(592), 2,
      sym_string_value,
      sym_call_expression,
  [19758] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1437), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19771] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1439), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19784] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(476), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19797] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1441), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19810] = 7,
    ACTIONS(3), 1,
      sym_js_comment,
    ACTIONS(5), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(421), 1,
      anon_sym_DQUOTE,
    ACTIONS(1395), 1,
      sym_plain_value,
    ACTIONS(1443), 1,
      sym_identifier,
    STATE(565), 2,
      sym_string_value,
      sym_call_expression,
  [19833] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(486), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [19846] = 3,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1445), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [19860] = 5,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1447), 1,
      anon_sym_SEMI,
    STATE(497), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19878] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1056), 5,
      anon_sym_RBRACE,
      sym_from,
      sym_to,
      anon_sym_RPAREN,
      aux_sym_integer_value_token1,
  [19890] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1064), 5,
      anon_sym_RBRACE,
      sym_from,
      sym_to,
      anon_sym_RPAREN,
      aux_sym_integer_value_token1,
  [19902] = 5,
    ACTIONS(1122), 1,
      anon_sym_SEMI,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(510), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19920] = 6,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1449), 1,
      anon_sym_SEMI,
    STATE(217), 1,
      sym_block,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [19940] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(992), 5,
      anon_sym_RBRACE,
      sym_from,
      sym_to,
      anon_sym_RPAREN,
      aux_sym_integer_value_token1,
  [19952] = 6,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1451), 1,
      anon_sym_SEMI,
    STATE(237), 1,
      sym_block,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [19972] = 5,
    ACTIONS(1018), 1,
      anon_sym_SEMI,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(505), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [19990] = 5,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1453), 1,
      anon_sym_SEMI,
    STATE(494), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [20008] = 4,
    ACTIONS(1455), 1,
      anon_sym_RPAREN,
    STATE(465), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [20023] = 5,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(218), 1,
      sym_block,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20040] = 4,
    ACTIONS(1457), 1,
      anon_sym_COMMA,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1445), 2,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [20055] = 5,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(327), 1,
      anon_sym_COLON,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    STATE(623), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20072] = 3,
    ACTIONS(1462), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1460), 3,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_important,
  [20085] = 4,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(223), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [20100] = 5,
    ACTIONS(721), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1464), 1,
      sym_identifier,
    ACTIONS(1466), 1,
      anon_sym_DASH2,
    STATE(80), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20117] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1468), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(274), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20134] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1470), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(199), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20151] = 5,
    ACTIONS(325), 1,
      anon_sym_PLUS,
    ACTIONS(339), 1,
      anon_sym_PLUS_,
    ACTIONS(1233), 1,
      anon_sym_COLON,
    STATE(556), 1,
      sym_merge_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20168] = 4,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(465), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1472), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [20183] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1475), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(274), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20200] = 5,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1477), 1,
      anon_sym_when,
    STATE(203), 1,
      sym_block,
    STATE(525), 1,
      sym_when_condition,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20217] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1479), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(270), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20234] = 3,
    ACTIONS(1483), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1481), 3,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_important,
  [20247] = 3,
    ACTIONS(1487), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1485), 3,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_important,
  [20260] = 5,
    ACTIONS(363), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1489), 1,
      sym_identifier,
    ACTIONS(1491), 1,
      anon_sym_DASH2,
    STATE(284), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20277] = 5,
    ACTIONS(47), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1493), 1,
      sym_identifier,
    ACTIONS(1495), 1,
      anon_sym_DASH2,
    STATE(360), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20294] = 5,
    ACTIONS(305), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1497), 1,
      sym_identifier,
    ACTIONS(1499), 1,
      anon_sym_DASH2,
    STATE(37), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20311] = 5,
    ACTIONS(81), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1501), 1,
      sym_identifier,
    ACTIONS(1503), 1,
      anon_sym_DASH2,
    STATE(335), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20328] = 4,
    ACTIONS(1505), 1,
      anon_sym_RPAREN,
    STATE(465), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [20343] = 4,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    STATE(216), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [20358] = 5,
    ACTIONS(393), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1507), 1,
      sym_identifier,
    ACTIONS(1509), 1,
      anon_sym_DASH2,
    STATE(78), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20375] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1511), 4,
      anon_sym_RBRACE,
      sym_from,
      sym_to,
      aux_sym_integer_value_token1,
  [20386] = 5,
    ACTIONS(829), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1513), 1,
      sym_identifier,
    ACTIONS(1515), 1,
      anon_sym_DASH2,
    STATE(318), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20403] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1517), 1,
      sym_identifier,
    ACTIONS(1519), 1,
      anon_sym_DASH2,
    STATE(188), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20420] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(947), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(274), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20437] = 4,
    ACTIONS(1521), 1,
      anon_sym_RPAREN,
    STATE(465), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [20452] = 5,
    ACTIONS(474), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1523), 1,
      sym_identifier,
    STATE(183), 1,
      sym_interpolation,
    STATE(247), 1,
      sym__concatenated_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20469] = 5,
    ACTIONS(425), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(1525), 1,
      sym_identifier,
    ACTIONS(1527), 1,
      anon_sym_DASH2,
    STATE(348), 1,
      sym_interpolation,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20486] = 5,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(1477), 1,
      anon_sym_when,
    STATE(193), 1,
      sym_block,
    STATE(516), 1,
      sym_when_condition,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20503] = 5,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(204), 1,
      sym_block,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20520] = 4,
    ACTIONS(1529), 1,
      anon_sym_COMMA,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1317), 2,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [20535] = 4,
    ACTIONS(1532), 1,
      anon_sym_RPAREN,
    STATE(465), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(480), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [20550] = 3,
    ACTIONS(1249), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(486), 3,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [20563] = 3,
    ACTIONS(1534), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1419), 2,
      anon_sym_and,
      anon_sym_or,
  [20575] = 4,
    ACTIONS(1341), 1,
      anon_sym_LBRACE,
    ACTIONS(1536), 1,
      anon_sym_COMMA,
    STATE(491), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20589] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1539), 1,
      anon_sym_RBRACK,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20603] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1541), 1,
      anon_sym_RPAREN,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20617] = 4,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1543), 1,
      anon_sym_SEMI,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20631] = 4,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    ACTIONS(1545), 1,
      anon_sym_RPAREN,
    STATE(501), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20645] = 4,
    ACTIONS(496), 1,
      anon_sym_COMMA,
    ACTIONS(1547), 1,
      anon_sym_RPAREN,
    STATE(501), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20659] = 4,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1549), 1,
      anon_sym_SEMI,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20673] = 4,
    ACTIONS(1551), 1,
      anon_sym_COMMA,
    ACTIONS(1554), 1,
      anon_sym_RPAREN,
    STATE(498), 1,
      aux_sym_parameters_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20687] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1556), 1,
      anon_sym_RBRACK,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20701] = 4,
    ACTIONS(1558), 1,
      anon_sym_COMMA,
    ACTIONS(1560), 1,
      anon_sym_RPAREN,
    STATE(498), 1,
      aux_sym_parameters_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20715] = 4,
    ACTIONS(623), 1,
      anon_sym_RPAREN,
    ACTIONS(1562), 1,
      anon_sym_COMMA,
    STATE(501), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20729] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1565), 1,
      anon_sym_RBRACK,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20743] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1567), 1,
      anon_sym_RPAREN,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20757] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1569), 1,
      anon_sym_RBRACK,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20771] = 4,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1447), 1,
      anon_sym_SEMI,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20785] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1571), 1,
      anon_sym_RPAREN,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20799] = 4,
    ACTIONS(1277), 1,
      anon_sym_COMMA,
    ACTIONS(1573), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20813] = 4,
    ACTIONS(1309), 1,
      anon_sym_COMMA,
    ACTIONS(1575), 1,
      anon_sym_RPAREN,
    STATE(487), 1,
      aux_sym_grid_value_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20827] = 4,
    ACTIONS(1558), 1,
      anon_sym_COMMA,
    ACTIONS(1577), 1,
      anon_sym_RPAREN,
    STATE(500), 1,
      aux_sym_parameters_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20841] = 4,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    ACTIONS(1453), 1,
      anon_sym_SEMI,
    STATE(457), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20855] = 3,
    ACTIONS(1579), 1,
      anon_sym_LPAREN2,
    STATE(467), 1,
      sym_parameters,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20866] = 3,
    ACTIONS(1581), 1,
      anon_sym_LPAREN2,
    STATE(568), 1,
      sym__extend_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20877] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1583), 2,
      anon_sym_LBRACE,
      anon_sym_when,
  [20886] = 3,
    ACTIONS(1585), 1,
      anon_sym_LBRACE,
    STATE(593), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20897] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1587), 2,
      anon_sym_LBRACE,
      anon_sym_when,
  [20906] = 3,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    STATE(224), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20917] = 3,
    ACTIONS(1589), 1,
      aux_sym_color_value_token1,
    ACTIONS(1591), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20928] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1593), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [20937] = 3,
    ACTIONS(1591), 1,
      sym_identifier,
    ACTIONS(1595), 1,
      aux_sym_color_value_token1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20948] = 3,
    ACTIONS(1597), 1,
      anon_sym_LBRACE,
    STATE(222), 1,
      sym_keyframe_block_list,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20959] = 3,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(235), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20970] = 3,
    ACTIONS(319), 1,
      anon_sym_LBRACE,
    STATE(191), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20981] = 3,
    ACTIONS(675), 1,
      anon_sym_LPAREN,
    STATE(359), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [20992] = 3,
    ACTIONS(1585), 1,
      anon_sym_LBRACE,
    STATE(478), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21003] = 3,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(243), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21014] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1554), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [21023] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1599), 2,
      anon_sym_LBRACE,
      anon_sym_when,
  [21032] = 3,
    ACTIONS(1601), 1,
      anon_sym_LBRACE,
    STATE(210), 1,
      sym_keyframe_block_list,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21043] = 3,
    ACTIONS(1603), 1,
      anon_sym_SEMI,
    ACTIONS(1605), 1,
      sym_important,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21054] = 3,
    ACTIONS(1585), 1,
      anon_sym_LBRACE,
    STATE(571), 1,
      sym_block,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21065] = 2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
    ACTIONS(1607), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [21074] = 2,
    ACTIONS(1609), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21082] = 2,
    ACTIONS(1611), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21090] = 2,
    ACTIONS(1613), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21098] = 2,
    ACTIONS(1613), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21106] = 2,
    ACTIONS(1615), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21114] = 2,
    ACTIONS(1617), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21122] = 2,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21130] = 2,
    ACTIONS(1619), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21138] = 2,
    ACTIONS(1621), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21146] = 2,
    ACTIONS(1623), 1,
      aux_sym_color_value_token1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21154] = 2,
    ACTIONS(1625), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21162] = 2,
    ACTIONS(1627), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21170] = 2,
    ACTIONS(1629), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21178] = 2,
    ACTIONS(1629), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21186] = 2,
    ACTIONS(1631), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21194] = 2,
    ACTIONS(1633), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21202] = 2,
    ACTIONS(1635), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21210] = 2,
    ACTIONS(1637), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21218] = 2,
    ACTIONS(1639), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21226] = 2,
    ACTIONS(1603), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21234] = 2,
    ACTIONS(1641), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21242] = 2,
    ACTIONS(1481), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21250] = 2,
    ACTIONS(1643), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21258] = 2,
    ACTIONS(1643), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21266] = 2,
    ACTIONS(1645), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21274] = 2,
    ACTIONS(1647), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21282] = 2,
    ACTIONS(1649), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21290] = 2,
    ACTIONS(1649), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21298] = 2,
    ACTIONS(1647), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21306] = 2,
    ACTIONS(1651), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21314] = 2,
    ACTIONS(1653), 1,
      anon_sym_SQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21322] = 2,
    ACTIONS(1653), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21330] = 2,
    ACTIONS(1485), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21338] = 2,
    ACTIONS(1655), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21346] = 2,
    ACTIONS(91), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21354] = 2,
    ACTIONS(1657), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21362] = 2,
    ACTIONS(1659), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21370] = 2,
    ACTIONS(1661), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21378] = 2,
    ACTIONS(1663), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21386] = 2,
    ACTIONS(1665), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21394] = 2,
    ACTIONS(1667), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21402] = 2,
    ACTIONS(1669), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21410] = 2,
    ACTIONS(1671), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21418] = 2,
    ACTIONS(1673), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21426] = 2,
    ACTIONS(1675), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21434] = 2,
    ACTIONS(1677), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21442] = 2,
    ACTIONS(1679), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21450] = 2,
    ACTIONS(1681), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21458] = 2,
    ACTIONS(1683), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21466] = 2,
    ACTIONS(1685), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21474] = 2,
    ACTIONS(1687), 1,
      aux_sym_color_value_token1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21482] = 2,
    ACTIONS(1689), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21490] = 2,
    ACTIONS(1691), 1,
      aux_sym_color_value_token1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21498] = 2,
    ACTIONS(1693), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21506] = 2,
    ACTIONS(1695), 1,
      aux_sym_color_value_token1,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21514] = 2,
    ACTIONS(1697), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21522] = 2,
    ACTIONS(1460), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21530] = 2,
    ACTIONS(1699), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21538] = 2,
    ACTIONS(1701), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21546] = 2,
    ACTIONS(1703), 1,
      anon_sym_LBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21554] = 2,
    ACTIONS(1705), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21562] = 2,
    ACTIONS(1707), 1,
      anon_sym_RPAREN,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21570] = 2,
    ACTIONS(1709), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21578] = 2,
    ACTIONS(1711), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21586] = 2,
    ACTIONS(1713), 1,
      ts_builtin_sym_end,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21594] = 2,
    ACTIONS(1715), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21602] = 2,
    ACTIONS(1717), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21610] = 2,
    ACTIONS(1719), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21618] = 2,
    ACTIONS(1721), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21626] = 2,
    ACTIONS(1723), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21634] = 2,
    ACTIONS(1725), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21642] = 2,
    ACTIONS(1727), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21650] = 2,
    ACTIONS(1729), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21658] = 2,
    ACTIONS(1731), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21666] = 2,
    ACTIONS(1733), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21674] = 2,
    ACTIONS(1735), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21682] = 2,
    ACTIONS(1737), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21690] = 2,
    ACTIONS(1739), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21698] = 2,
    ACTIONS(1741), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21706] = 2,
    ACTIONS(1743), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21714] = 2,
    ACTIONS(1745), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21722] = 2,
    ACTIONS(1747), 1,
      aux_sym_string_value_token1,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21730] = 2,
    ACTIONS(1749), 1,
      aux_sym_string_value_token2,
    ACTIONS(3), 2,
      sym_js_comment,
      sym_comment,
  [21738] = 2,
    ACTIONS(1751), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21746] = 2,
    ACTIONS(1631), 1,
      anon_sym_DQUOTE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21754] = 2,
    ACTIONS(1753), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21762] = 2,
    ACTIONS(1755), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21770] = 2,
    ACTIONS(1757), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21778] = 2,
    ACTIONS(1759), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21786] = 2,
    ACTIONS(1761), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21794] = 2,
    ACTIONS(1763), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21802] = 2,
    ACTIONS(1765), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21810] = 2,
    ACTIONS(1767), 1,
      anon_sym_SEMI,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21818] = 2,
    ACTIONS(1769), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21826] = 2,
    ACTIONS(63), 1,
      anon_sym_RBRACE,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
  [21834] = 2,
    ACTIONS(1771), 1,
      anon_sym_LPAREN2,
    ACTIONS(5), 2,
      sym_js_comment,
      sym_comment,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 123,
  [SMALL_STATE(4)] = 246,
  [SMALL_STATE(5)] = 369,
  [SMALL_STATE(6)] = 492,
  [SMALL_STATE(7)] = 615,
  [SMALL_STATE(8)] = 738,
  [SMALL_STATE(9)] = 858,
  [SMALL_STATE(10)] = 975,
  [SMALL_STATE(11)] = 1092,
  [SMALL_STATE(12)] = 1195,
  [SMALL_STATE(13)] = 1298,
  [SMALL_STATE(14)] = 1407,
  [SMALL_STATE(15)] = 1516,
  [SMALL_STATE(16)] = 1626,
  [SMALL_STATE(17)] = 1732,
  [SMALL_STATE(18)] = 1837,
  [SMALL_STATE(19)] = 1942,
  [SMALL_STATE(20)] = 2041,
  [SMALL_STATE(21)] = 2137,
  [SMALL_STATE(22)] = 2233,
  [SMALL_STATE(23)] = 2329,
  [SMALL_STATE(24)] = 2425,
  [SMALL_STATE(25)] = 2511,
  [SMALL_STATE(26)] = 2597,
  [SMALL_STATE(27)] = 2683,
  [SMALL_STATE(28)] = 2744,
  [SMALL_STATE(29)] = 2795,
  [SMALL_STATE(30)] = 2846,
  [SMALL_STATE(31)] = 2897,
  [SMALL_STATE(32)] = 2956,
  [SMALL_STATE(33)] = 3002,
  [SMALL_STATE(34)] = 3086,
  [SMALL_STATE(35)] = 3170,
  [SMALL_STATE(36)] = 3228,
  [SMALL_STATE(37)] = 3312,
  [SMALL_STATE(38)] = 3358,
  [SMALL_STATE(39)] = 3442,
  [SMALL_STATE(40)] = 3525,
  [SMALL_STATE(41)] = 3604,
  [SMALL_STATE(42)] = 3649,
  [SMALL_STATE(43)] = 3702,
  [SMALL_STATE(44)] = 3751,
  [SMALL_STATE(45)] = 3836,
  [SMALL_STATE(46)] = 3889,
  [SMALL_STATE(47)] = 3970,
  [SMALL_STATE(48)] = 4019,
  [SMALL_STATE(49)] = 4100,
  [SMALL_STATE(50)] = 4183,
  [SMALL_STATE(51)] = 4262,
  [SMALL_STATE(52)] = 4340,
  [SMALL_STATE(53)] = 4418,
  [SMALL_STATE(54)] = 4500,
  [SMALL_STATE(55)] = 4582,
  [SMALL_STATE(56)] = 4664,
  [SMALL_STATE(57)] = 4716,
  [SMALL_STATE(58)] = 4798,
  [SMALL_STATE(59)] = 4875,
  [SMALL_STATE(60)] = 4922,
  [SMALL_STATE(61)] = 4969,
  [SMALL_STATE(62)] = 5012,
  [SMALL_STATE(63)] = 5089,
  [SMALL_STATE(64)] = 5166,
  [SMALL_STATE(65)] = 5243,
  [SMALL_STATE(66)] = 5290,
  [SMALL_STATE(67)] = 5337,
  [SMALL_STATE(68)] = 5414,
  [SMALL_STATE(69)] = 5461,
  [SMALL_STATE(70)] = 5508,
  [SMALL_STATE(71)] = 5585,
  [SMALL_STATE(72)] = 5632,
  [SMALL_STATE(73)] = 5679,
  [SMALL_STATE(74)] = 5721,
  [SMALL_STATE(75)] = 5795,
  [SMALL_STATE(76)] = 5869,
  [SMALL_STATE(77)] = 5913,
  [SMALL_STATE(78)] = 5957,
  [SMALL_STATE(79)] = 5999,
  [SMALL_STATE(80)] = 6041,
  [SMALL_STATE(81)] = 6083,
  [SMALL_STATE(82)] = 6127,
  [SMALL_STATE(83)] = 6187,
  [SMALL_STATE(84)] = 6231,
  [SMALL_STATE(85)] = 6272,
  [SMALL_STATE(86)] = 6343,
  [SMALL_STATE(87)] = 6384,
  [SMALL_STATE(88)] = 6425,
  [SMALL_STATE(89)] = 6466,
  [SMALL_STATE(90)] = 6537,
  [SMALL_STATE(91)] = 6608,
  [SMALL_STATE(92)] = 6679,
  [SMALL_STATE(93)] = 6750,
  [SMALL_STATE(94)] = 6821,
  [SMALL_STATE(95)] = 6892,
  [SMALL_STATE(96)] = 6963,
  [SMALL_STATE(97)] = 7004,
  [SMALL_STATE(98)] = 7045,
  [SMALL_STATE(99)] = 7086,
  [SMALL_STATE(100)] = 7127,
  [SMALL_STATE(101)] = 7168,
  [SMALL_STATE(102)] = 7209,
  [SMALL_STATE(103)] = 7250,
  [SMALL_STATE(104)] = 7321,
  [SMALL_STATE(105)] = 7362,
  [SMALL_STATE(106)] = 7403,
  [SMALL_STATE(107)] = 7444,
  [SMALL_STATE(108)] = 7485,
  [SMALL_STATE(109)] = 7526,
  [SMALL_STATE(110)] = 7597,
  [SMALL_STATE(111)] = 7638,
  [SMALL_STATE(112)] = 7679,
  [SMALL_STATE(113)] = 7720,
  [SMALL_STATE(114)] = 7761,
  [SMALL_STATE(115)] = 7832,
  [SMALL_STATE(116)] = 7873,
  [SMALL_STATE(117)] = 7914,
  [SMALL_STATE(118)] = 7985,
  [SMALL_STATE(119)] = 8056,
  [SMALL_STATE(120)] = 8127,
  [SMALL_STATE(121)] = 8198,
  [SMALL_STATE(122)] = 8269,
  [SMALL_STATE(123)] = 8340,
  [SMALL_STATE(124)] = 8411,
  [SMALL_STATE(125)] = 8482,
  [SMALL_STATE(126)] = 8553,
  [SMALL_STATE(127)] = 8594,
  [SMALL_STATE(128)] = 8665,
  [SMALL_STATE(129)] = 8736,
  [SMALL_STATE(130)] = 8807,
  [SMALL_STATE(131)] = 8878,
  [SMALL_STATE(132)] = 8949,
  [SMALL_STATE(133)] = 9020,
  [SMALL_STATE(134)] = 9061,
  [SMALL_STATE(135)] = 9132,
  [SMALL_STATE(136)] = 9173,
  [SMALL_STATE(137)] = 9244,
  [SMALL_STATE(138)] = 9285,
  [SMALL_STATE(139)] = 9326,
  [SMALL_STATE(140)] = 9397,
  [SMALL_STATE(141)] = 9468,
  [SMALL_STATE(142)] = 9509,
  [SMALL_STATE(143)] = 9580,
  [SMALL_STATE(144)] = 9621,
  [SMALL_STATE(145)] = 9692,
  [SMALL_STATE(146)] = 9763,
  [SMALL_STATE(147)] = 9834,
  [SMALL_STATE(148)] = 9905,
  [SMALL_STATE(149)] = 9976,
  [SMALL_STATE(150)] = 10047,
  [SMALL_STATE(151)] = 10120,
  [SMALL_STATE(152)] = 10191,
  [SMALL_STATE(153)] = 10232,
  [SMALL_STATE(154)] = 10303,
  [SMALL_STATE(155)] = 10344,
  [SMALL_STATE(156)] = 10385,
  [SMALL_STATE(157)] = 10456,
  [SMALL_STATE(158)] = 10527,
  [SMALL_STATE(159)] = 10598,
  [SMALL_STATE(160)] = 10642,
  [SMALL_STATE(161)] = 10686,
  [SMALL_STATE(162)] = 10730,
  [SMALL_STATE(163)] = 10774,
  [SMALL_STATE(164)] = 10818,
  [SMALL_STATE(165)] = 10859,
  [SMALL_STATE(166)] = 10900,
  [SMALL_STATE(167)] = 10941,
  [SMALL_STATE(168)] = 10982,
  [SMALL_STATE(169)] = 11023,
  [SMALL_STATE(170)] = 11064,
  [SMALL_STATE(171)] = 11123,
  [SMALL_STATE(172)] = 11182,
  [SMALL_STATE(173)] = 11225,
  [SMALL_STATE(174)] = 11286,
  [SMALL_STATE(175)] = 11345,
  [SMALL_STATE(176)] = 11404,
  [SMALL_STATE(177)] = 11447,
  [SMALL_STATE(178)] = 11506,
  [SMALL_STATE(179)] = 11565,
  [SMALL_STATE(180)] = 11624,
  [SMALL_STATE(181)] = 11667,
  [SMALL_STATE(182)] = 11726,
  [SMALL_STATE(183)] = 11787,
  [SMALL_STATE(184)] = 11825,
  [SMALL_STATE(185)] = 11863,
  [SMALL_STATE(186)] = 11901,
  [SMALL_STATE(187)] = 11949,
  [SMALL_STATE(188)] = 11982,
  [SMALL_STATE(189)] = 12015,
  [SMALL_STATE(190)] = 12048,
  [SMALL_STATE(191)] = 12081,
  [SMALL_STATE(192)] = 12114,
  [SMALL_STATE(193)] = 12147,
  [SMALL_STATE(194)] = 12180,
  [SMALL_STATE(195)] = 12213,
  [SMALL_STATE(196)] = 12246,
  [SMALL_STATE(197)] = 12279,
  [SMALL_STATE(198)] = 12312,
  [SMALL_STATE(199)] = 12345,
  [SMALL_STATE(200)] = 12382,
  [SMALL_STATE(201)] = 12419,
  [SMALL_STATE(202)] = 12456,
  [SMALL_STATE(203)] = 12505,
  [SMALL_STATE(204)] = 12538,
  [SMALL_STATE(205)] = 12571,
  [SMALL_STATE(206)] = 12604,
  [SMALL_STATE(207)] = 12637,
  [SMALL_STATE(208)] = 12670,
  [SMALL_STATE(209)] = 12703,
  [SMALL_STATE(210)] = 12736,
  [SMALL_STATE(211)] = 12769,
  [SMALL_STATE(212)] = 12802,
  [SMALL_STATE(213)] = 12835,
  [SMALL_STATE(214)] = 12868,
  [SMALL_STATE(215)] = 12901,
  [SMALL_STATE(216)] = 12934,
  [SMALL_STATE(217)] = 12967,
  [SMALL_STATE(218)] = 13000,
  [SMALL_STATE(219)] = 13033,
  [SMALL_STATE(220)] = 13066,
  [SMALL_STATE(221)] = 13099,
  [SMALL_STATE(222)] = 13132,
  [SMALL_STATE(223)] = 13165,
  [SMALL_STATE(224)] = 13198,
  [SMALL_STATE(225)] = 13231,
  [SMALL_STATE(226)] = 13264,
  [SMALL_STATE(227)] = 13297,
  [SMALL_STATE(228)] = 13330,
  [SMALL_STATE(229)] = 13363,
  [SMALL_STATE(230)] = 13396,
  [SMALL_STATE(231)] = 13429,
  [SMALL_STATE(232)] = 13462,
  [SMALL_STATE(233)] = 13495,
  [SMALL_STATE(234)] = 13528,
  [SMALL_STATE(235)] = 13561,
  [SMALL_STATE(236)] = 13594,
  [SMALL_STATE(237)] = 13627,
  [SMALL_STATE(238)] = 13660,
  [SMALL_STATE(239)] = 13693,
  [SMALL_STATE(240)] = 13726,
  [SMALL_STATE(241)] = 13759,
  [SMALL_STATE(242)] = 13792,
  [SMALL_STATE(243)] = 13839,
  [SMALL_STATE(244)] = 13872,
  [SMALL_STATE(245)] = 13909,
  [SMALL_STATE(246)] = 13958,
  [SMALL_STATE(247)] = 13991,
  [SMALL_STATE(248)] = 14028,
  [SMALL_STATE(249)] = 14061,
  [SMALL_STATE(250)] = 14098,
  [SMALL_STATE(251)] = 14135,
  [SMALL_STATE(252)] = 14168,
  [SMALL_STATE(253)] = 14201,
  [SMALL_STATE(254)] = 14234,
  [SMALL_STATE(255)] = 14267,
  [SMALL_STATE(256)] = 14300,
  [SMALL_STATE(257)] = 14333,
  [SMALL_STATE(258)] = 14366,
  [SMALL_STATE(259)] = 14399,
  [SMALL_STATE(260)] = 14432,
  [SMALL_STATE(261)] = 14465,
  [SMALL_STATE(262)] = 14503,
  [SMALL_STATE(263)] = 14541,
  [SMALL_STATE(264)] = 14579,
  [SMALL_STATE(265)] = 14610,
  [SMALL_STATE(266)] = 14641,
  [SMALL_STATE(267)] = 14672,
  [SMALL_STATE(268)] = 14703,
  [SMALL_STATE(269)] = 14734,
  [SMALL_STATE(270)] = 14775,
  [SMALL_STATE(271)] = 14806,
  [SMALL_STATE(272)] = 14837,
  [SMALL_STATE(273)] = 14870,
  [SMALL_STATE(274)] = 14901,
  [SMALL_STATE(275)] = 14932,
  [SMALL_STATE(276)] = 14963,
  [SMALL_STATE(277)] = 14994,
  [SMALL_STATE(278)] = 15025,
  [SMALL_STATE(279)] = 15056,
  [SMALL_STATE(280)] = 15087,
  [SMALL_STATE(281)] = 15118,
  [SMALL_STATE(282)] = 15149,
  [SMALL_STATE(283)] = 15180,
  [SMALL_STATE(284)] = 15211,
  [SMALL_STATE(285)] = 15244,
  [SMALL_STATE(286)] = 15275,
  [SMALL_STATE(287)] = 15308,
  [SMALL_STATE(288)] = 15339,
  [SMALL_STATE(289)] = 15370,
  [SMALL_STATE(290)] = 15403,
  [SMALL_STATE(291)] = 15436,
  [SMALL_STATE(292)] = 15469,
  [SMALL_STATE(293)] = 15502,
  [SMALL_STATE(294)] = 15534,
  [SMALL_STATE(295)] = 15574,
  [SMALL_STATE(296)] = 15606,
  [SMALL_STATE(297)] = 15642,
  [SMALL_STATE(298)] = 15678,
  [SMALL_STATE(299)] = 15715,
  [SMALL_STATE(300)] = 15766,
  [SMALL_STATE(301)] = 15803,
  [SMALL_STATE(302)] = 15838,
  [SMALL_STATE(303)] = 15877,
  [SMALL_STATE(304)] = 15915,
  [SMALL_STATE(305)] = 15949,
  [SMALL_STATE(306)] = 15983,
  [SMALL_STATE(307)] = 16025,
  [SMALL_STATE(308)] = 16059,
  [SMALL_STATE(309)] = 16089,
  [SMALL_STATE(310)] = 16127,
  [SMALL_STATE(311)] = 16161,
  [SMALL_STATE(312)] = 16192,
  [SMALL_STATE(313)] = 16223,
  [SMALL_STATE(314)] = 16254,
  [SMALL_STATE(315)] = 16285,
  [SMALL_STATE(316)] = 16316,
  [SMALL_STATE(317)] = 16347,
  [SMALL_STATE(318)] = 16378,
  [SMALL_STATE(319)] = 16407,
  [SMALL_STATE(320)] = 16440,
  [SMALL_STATE(321)] = 16473,
  [SMALL_STATE(322)] = 16506,
  [SMALL_STATE(323)] = 16535,
  [SMALL_STATE(324)] = 16568,
  [SMALL_STATE(325)] = 16605,
  [SMALL_STATE(326)] = 16636,
  [SMALL_STATE(327)] = 16664,
  [SMALL_STATE(328)] = 16692,
  [SMALL_STATE(329)] = 16720,
  [SMALL_STATE(330)] = 16748,
  [SMALL_STATE(331)] = 16776,
  [SMALL_STATE(332)] = 16804,
  [SMALL_STATE(333)] = 16830,
  [SMALL_STATE(334)] = 16858,
  [SMALL_STATE(335)] = 16886,
  [SMALL_STATE(336)] = 16912,
  [SMALL_STATE(337)] = 16940,
  [SMALL_STATE(338)] = 16970,
  [SMALL_STATE(339)] = 17002,
  [SMALL_STATE(340)] = 17030,
  [SMALL_STATE(341)] = 17058,
  [SMALL_STATE(342)] = 17086,
  [SMALL_STATE(343)] = 17116,
  [SMALL_STATE(344)] = 17146,
  [SMALL_STATE(345)] = 17174,
  [SMALL_STATE(346)] = 17202,
  [SMALL_STATE(347)] = 17230,
  [SMALL_STATE(348)] = 17258,
  [SMALL_STATE(349)] = 17286,
  [SMALL_STATE(350)] = 17314,
  [SMALL_STATE(351)] = 17344,
  [SMALL_STATE(352)] = 17372,
  [SMALL_STATE(353)] = 17400,
  [SMALL_STATE(354)] = 17428,
  [SMALL_STATE(355)] = 17453,
  [SMALL_STATE(356)] = 17480,
  [SMALL_STATE(357)] = 17507,
  [SMALL_STATE(358)] = 17534,
  [SMALL_STATE(359)] = 17561,
  [SMALL_STATE(360)] = 17588,
  [SMALL_STATE(361)] = 17613,
  [SMALL_STATE(362)] = 17640,
  [SMALL_STATE(363)] = 17669,
  [SMALL_STATE(364)] = 17700,
  [SMALL_STATE(365)] = 17727,
  [SMALL_STATE(366)] = 17754,
  [SMALL_STATE(367)] = 17781,
  [SMALL_STATE(368)] = 17808,
  [SMALL_STATE(369)] = 17835,
  [SMALL_STATE(370)] = 17862,
  [SMALL_STATE(371)] = 17895,
  [SMALL_STATE(372)] = 17943,
  [SMALL_STATE(373)] = 17988,
  [SMALL_STATE(374)] = 18033,
  [SMALL_STATE(375)] = 18060,
  [SMALL_STATE(376)] = 18105,
  [SMALL_STATE(377)] = 18130,
  [SMALL_STATE(378)] = 18160,
  [SMALL_STATE(379)] = 18190,
  [SMALL_STATE(380)] = 18216,
  [SMALL_STATE(381)] = 18246,
  [SMALL_STATE(382)] = 18286,
  [SMALL_STATE(383)] = 18316,
  [SMALL_STATE(384)] = 18346,
  [SMALL_STATE(385)] = 18370,
  [SMALL_STATE(386)] = 18398,
  [SMALL_STATE(387)] = 18428,
  [SMALL_STATE(388)] = 18458,
  [SMALL_STATE(389)] = 18488,
  [SMALL_STATE(390)] = 18518,
  [SMALL_STATE(391)] = 18548,
  [SMALL_STATE(392)] = 18588,
  [SMALL_STATE(393)] = 18618,
  [SMALL_STATE(394)] = 18648,
  [SMALL_STATE(395)] = 18678,
  [SMALL_STATE(396)] = 18708,
  [SMALL_STATE(397)] = 18738,
  [SMALL_STATE(398)] = 18768,
  [SMALL_STATE(399)] = 18807,
  [SMALL_STATE(400)] = 18832,
  [SMALL_STATE(401)] = 18871,
  [SMALL_STATE(402)] = 18895,
  [SMALL_STATE(403)] = 18919,
  [SMALL_STATE(404)] = 18943,
  [SMALL_STATE(405)] = 18967,
  [SMALL_STATE(406)] = 18991,
  [SMALL_STATE(407)] = 19015,
  [SMALL_STATE(408)] = 19039,
  [SMALL_STATE(409)] = 19075,
  [SMALL_STATE(410)] = 19099,
  [SMALL_STATE(411)] = 19123,
  [SMALL_STATE(412)] = 19147,
  [SMALL_STATE(413)] = 19171,
  [SMALL_STATE(414)] = 19195,
  [SMALL_STATE(415)] = 19219,
  [SMALL_STATE(416)] = 19243,
  [SMALL_STATE(417)] = 19267,
  [SMALL_STATE(418)] = 19291,
  [SMALL_STATE(419)] = 19315,
  [SMALL_STATE(420)] = 19339,
  [SMALL_STATE(421)] = 19363,
  [SMALL_STATE(422)] = 19387,
  [SMALL_STATE(423)] = 19411,
  [SMALL_STATE(424)] = 19432,
  [SMALL_STATE(425)] = 19459,
  [SMALL_STATE(426)] = 19486,
  [SMALL_STATE(427)] = 19508,
  [SMALL_STATE(428)] = 19530,
  [SMALL_STATE(429)] = 19552,
  [SMALL_STATE(430)] = 19574,
  [SMALL_STATE(431)] = 19598,
  [SMALL_STATE(432)] = 19622,
  [SMALL_STATE(433)] = 19644,
  [SMALL_STATE(434)] = 19665,
  [SMALL_STATE(435)] = 19686,
  [SMALL_STATE(436)] = 19699,
  [SMALL_STATE(437)] = 19712,
  [SMALL_STATE(438)] = 19735,
  [SMALL_STATE(439)] = 19758,
  [SMALL_STATE(440)] = 19771,
  [SMALL_STATE(441)] = 19784,
  [SMALL_STATE(442)] = 19797,
  [SMALL_STATE(443)] = 19810,
  [SMALL_STATE(444)] = 19833,
  [SMALL_STATE(445)] = 19846,
  [SMALL_STATE(446)] = 19860,
  [SMALL_STATE(447)] = 19878,
  [SMALL_STATE(448)] = 19890,
  [SMALL_STATE(449)] = 19902,
  [SMALL_STATE(450)] = 19920,
  [SMALL_STATE(451)] = 19940,
  [SMALL_STATE(452)] = 19952,
  [SMALL_STATE(453)] = 19972,
  [SMALL_STATE(454)] = 19990,
  [SMALL_STATE(455)] = 20008,
  [SMALL_STATE(456)] = 20023,
  [SMALL_STATE(457)] = 20040,
  [SMALL_STATE(458)] = 20055,
  [SMALL_STATE(459)] = 20072,
  [SMALL_STATE(460)] = 20085,
  [SMALL_STATE(461)] = 20100,
  [SMALL_STATE(462)] = 20117,
  [SMALL_STATE(463)] = 20134,
  [SMALL_STATE(464)] = 20151,
  [SMALL_STATE(465)] = 20168,
  [SMALL_STATE(466)] = 20183,
  [SMALL_STATE(467)] = 20200,
  [SMALL_STATE(468)] = 20217,
  [SMALL_STATE(469)] = 20234,
  [SMALL_STATE(470)] = 20247,
  [SMALL_STATE(471)] = 20260,
  [SMALL_STATE(472)] = 20277,
  [SMALL_STATE(473)] = 20294,
  [SMALL_STATE(474)] = 20311,
  [SMALL_STATE(475)] = 20328,
  [SMALL_STATE(476)] = 20343,
  [SMALL_STATE(477)] = 20358,
  [SMALL_STATE(478)] = 20375,
  [SMALL_STATE(479)] = 20386,
  [SMALL_STATE(480)] = 20403,
  [SMALL_STATE(481)] = 20420,
  [SMALL_STATE(482)] = 20437,
  [SMALL_STATE(483)] = 20452,
  [SMALL_STATE(484)] = 20469,
  [SMALL_STATE(485)] = 20486,
  [SMALL_STATE(486)] = 20503,
  [SMALL_STATE(487)] = 20520,
  [SMALL_STATE(488)] = 20535,
  [SMALL_STATE(489)] = 20550,
  [SMALL_STATE(490)] = 20563,
  [SMALL_STATE(491)] = 20575,
  [SMALL_STATE(492)] = 20589,
  [SMALL_STATE(493)] = 20603,
  [SMALL_STATE(494)] = 20617,
  [SMALL_STATE(495)] = 20631,
  [SMALL_STATE(496)] = 20645,
  [SMALL_STATE(497)] = 20659,
  [SMALL_STATE(498)] = 20673,
  [SMALL_STATE(499)] = 20687,
  [SMALL_STATE(500)] = 20701,
  [SMALL_STATE(501)] = 20715,
  [SMALL_STATE(502)] = 20729,
  [SMALL_STATE(503)] = 20743,
  [SMALL_STATE(504)] = 20757,
  [SMALL_STATE(505)] = 20771,
  [SMALL_STATE(506)] = 20785,
  [SMALL_STATE(507)] = 20799,
  [SMALL_STATE(508)] = 20813,
  [SMALL_STATE(509)] = 20827,
  [SMALL_STATE(510)] = 20841,
  [SMALL_STATE(511)] = 20855,
  [SMALL_STATE(512)] = 20866,
  [SMALL_STATE(513)] = 20877,
  [SMALL_STATE(514)] = 20886,
  [SMALL_STATE(515)] = 20897,
  [SMALL_STATE(516)] = 20906,
  [SMALL_STATE(517)] = 20917,
  [SMALL_STATE(518)] = 20928,
  [SMALL_STATE(519)] = 20937,
  [SMALL_STATE(520)] = 20948,
  [SMALL_STATE(521)] = 20959,
  [SMALL_STATE(522)] = 20970,
  [SMALL_STATE(523)] = 20981,
  [SMALL_STATE(524)] = 20992,
  [SMALL_STATE(525)] = 21003,
  [SMALL_STATE(526)] = 21014,
  [SMALL_STATE(527)] = 21023,
  [SMALL_STATE(528)] = 21032,
  [SMALL_STATE(529)] = 21043,
  [SMALL_STATE(530)] = 21054,
  [SMALL_STATE(531)] = 21065,
  [SMALL_STATE(532)] = 21074,
  [SMALL_STATE(533)] = 21082,
  [SMALL_STATE(534)] = 21090,
  [SMALL_STATE(535)] = 21098,
  [SMALL_STATE(536)] = 21106,
  [SMALL_STATE(537)] = 21114,
  [SMALL_STATE(538)] = 21122,
  [SMALL_STATE(539)] = 21130,
  [SMALL_STATE(540)] = 21138,
  [SMALL_STATE(541)] = 21146,
  [SMALL_STATE(542)] = 21154,
  [SMALL_STATE(543)] = 21162,
  [SMALL_STATE(544)] = 21170,
  [SMALL_STATE(545)] = 21178,
  [SMALL_STATE(546)] = 21186,
  [SMALL_STATE(547)] = 21194,
  [SMALL_STATE(548)] = 21202,
  [SMALL_STATE(549)] = 21210,
  [SMALL_STATE(550)] = 21218,
  [SMALL_STATE(551)] = 21226,
  [SMALL_STATE(552)] = 21234,
  [SMALL_STATE(553)] = 21242,
  [SMALL_STATE(554)] = 21250,
  [SMALL_STATE(555)] = 21258,
  [SMALL_STATE(556)] = 21266,
  [SMALL_STATE(557)] = 21274,
  [SMALL_STATE(558)] = 21282,
  [SMALL_STATE(559)] = 21290,
  [SMALL_STATE(560)] = 21298,
  [SMALL_STATE(561)] = 21306,
  [SMALL_STATE(562)] = 21314,
  [SMALL_STATE(563)] = 21322,
  [SMALL_STATE(564)] = 21330,
  [SMALL_STATE(565)] = 21338,
  [SMALL_STATE(566)] = 21346,
  [SMALL_STATE(567)] = 21354,
  [SMALL_STATE(568)] = 21362,
  [SMALL_STATE(569)] = 21370,
  [SMALL_STATE(570)] = 21378,
  [SMALL_STATE(571)] = 21386,
  [SMALL_STATE(572)] = 21394,
  [SMALL_STATE(573)] = 21402,
  [SMALL_STATE(574)] = 21410,
  [SMALL_STATE(575)] = 21418,
  [SMALL_STATE(576)] = 21426,
  [SMALL_STATE(577)] = 21434,
  [SMALL_STATE(578)] = 21442,
  [SMALL_STATE(579)] = 21450,
  [SMALL_STATE(580)] = 21458,
  [SMALL_STATE(581)] = 21466,
  [SMALL_STATE(582)] = 21474,
  [SMALL_STATE(583)] = 21482,
  [SMALL_STATE(584)] = 21490,
  [SMALL_STATE(585)] = 21498,
  [SMALL_STATE(586)] = 21506,
  [SMALL_STATE(587)] = 21514,
  [SMALL_STATE(588)] = 21522,
  [SMALL_STATE(589)] = 21530,
  [SMALL_STATE(590)] = 21538,
  [SMALL_STATE(591)] = 21546,
  [SMALL_STATE(592)] = 21554,
  [SMALL_STATE(593)] = 21562,
  [SMALL_STATE(594)] = 21570,
  [SMALL_STATE(595)] = 21578,
  [SMALL_STATE(596)] = 21586,
  [SMALL_STATE(597)] = 21594,
  [SMALL_STATE(598)] = 21602,
  [SMALL_STATE(599)] = 21610,
  [SMALL_STATE(600)] = 21618,
  [SMALL_STATE(601)] = 21626,
  [SMALL_STATE(602)] = 21634,
  [SMALL_STATE(603)] = 21642,
  [SMALL_STATE(604)] = 21650,
  [SMALL_STATE(605)] = 21658,
  [SMALL_STATE(606)] = 21666,
  [SMALL_STATE(607)] = 21674,
  [SMALL_STATE(608)] = 21682,
  [SMALL_STATE(609)] = 21690,
  [SMALL_STATE(610)] = 21698,
  [SMALL_STATE(611)] = 21706,
  [SMALL_STATE(612)] = 21714,
  [SMALL_STATE(613)] = 21722,
  [SMALL_STATE(614)] = 21730,
  [SMALL_STATE(615)] = 21738,
  [SMALL_STATE(616)] = 21746,
  [SMALL_STATE(617)] = 21754,
  [SMALL_STATE(618)] = 21762,
  [SMALL_STATE(619)] = 21770,
  [SMALL_STATE(620)] = 21778,
  [SMALL_STATE(621)] = 21786,
  [SMALL_STATE(622)] = 21794,
  [SMALL_STATE(623)] = 21802,
  [SMALL_STATE(624)] = 21810,
  [SMALL_STATE(625)] = 21818,
  [SMALL_STATE(626)] = 21826,
  [SMALL_STATE(627)] = 21834,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stylesheet, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(619),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(598),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(576),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(627),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(123),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(388),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(127),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(443),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(576),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(396),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(172),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(288),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(466),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(615),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(621),
  [130] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(173),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(578),
  [136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(605),
  [139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(604),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(309),
  [145] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(15),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(627),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(85),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(122),
  [157] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(458),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(463),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2),
  [165] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(89),
  [168] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(393),
  [171] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(91),
  [174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(438),
  [177] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(619),
  [180] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(380),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(172),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(288),
  [189] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(462),
  [192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(615),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(612),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(173),
  [201] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(609),
  [204] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(605),
  [207] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(604),
  [210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(324),
  [213] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(299),
  [216] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(598),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(151),
  [222] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(148),
  [225] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(464),
  [228] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(463),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stylesheet, 1),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(313),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(575),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [281] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(317),
  [357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [361] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(583),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(395),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_declaration, 3, .production_id = 16),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [423] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__selector, 1, .production_id = 1),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1, .production_id = 3),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__selector, 1, .production_id = 1),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1, .production_id = 3),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2),
  [451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2),
  [453] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(473),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__concatenated_identifier, 2),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__concatenated_identifier, 2),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__concatenated_identifier, 1),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__concatenated_identifier, 1),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__selector, 1),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__selector, 1),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpolation, 3),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__query, 1, .production_id = 4),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__query, 1, .production_id = 4),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_value, 3),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_value, 3),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_declaration, 4, .production_id = 16),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [514] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(93),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2),
  [519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(161),
  [522] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(541),
  [525] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(156),
  [528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(157),
  [531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(607),
  [534] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(608),
  [537] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(76),
  [540] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(77),
  [543] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(42),
  [546] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(69),
  [549] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(124),
  [552] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(542),
  [555] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(606),
  [558] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(543),
  [561] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(161),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2),
  [578] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(160),
  [581] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(541),
  [584] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(156),
  [587] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(157),
  [590] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(607),
  [593] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(608),
  [596] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(76),
  [599] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(77),
  [602] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(42),
  [605] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(69),
  [608] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(124),
  [611] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(542),
  [614] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(606),
  [617] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(543),
  [620] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 2), SHIFT_REPEAT(160),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pseudo_class_arguments_repeat1, 2),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__query, 1),
  [635] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__query, 1),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [639] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(461),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [650] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(477),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_value, 1),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_integer_value, 1),
  [659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [661] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_value, 1),
  [663] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_value, 1),
  [665] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [667] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grid_value, 3),
  [683] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grid_value, 3),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [687] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_value, 3, .production_id = 8),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property_value, 3, .production_id = 8),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_value, 3),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_value, 3),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [715] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [717] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [723] = {.entry = {.count = 1, .reusable = false}}, SHIFT(581),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(406),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [745] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [753] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3),
  [757] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_value, 2, .production_id = 8),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_value, 2, .production_id = 8),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_color_value, 2),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_color_value, 2),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_value, 2, .production_id = 8),
  [769] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property_value, 2, .production_id = 8),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2, .production_id = 7),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2, .production_id = 7),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_value, 2),
  [777] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_integer_value, 2),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_value, 2),
  [781] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_value, 2),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [785] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [789] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grid_value, 4),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grid_value, 4),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_value, 4),
  [797] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_value, 4),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [801] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [805] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [813] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [817] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [821] = {.entry = {.count = 1, .reusable = false}}, SHIFT(404),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [827] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [831] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [835] = {.entry = {.count = 1, .reusable = false}}, SHIFT(401),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [839] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [843] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [851] = {.entry = {.count = 1, .reusable = false}}, SHIFT(422),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [855] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [859] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [867] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [871] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [903] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [907] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [911] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [915] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [919] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [923] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_postcss_statement_repeat1, 1),
  [929] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_postcss_statement_repeat1, 1),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 1),
  [933] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 1),
  [935] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_declaration, 5, .production_id = 16),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 11),
  [953] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 11),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 2, .production_id = 2),
  [961] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 2, .production_id = 2),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [965] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(480),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 7),
  [970] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 7),
  [972] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 3),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 3),
  [976] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_set, 2),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_set, 2),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 6),
  [982] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 6),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_definition, 3),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_definition, 3),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 3),
  [990] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_statement, 3),
  [992] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2),
  [994] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 4),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_rule, 2),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_rule, 2),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_media_statement, 3),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_media_statement, 3),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_selector, 2, .production_id = 2),
  [1010] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_selector, 2, .production_id = 2),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_selector, 2, .production_id = 5),
  [1014] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_selector, 2, .production_id = 5),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1022] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1026] = {.entry = {.count = 1, .reusable = false}}, SHIFT(444),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1030] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_media_statement, 4),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_media_statement, 4),
  [1034] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_charset_statement, 3),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_charset_statement, 3),
  [1038] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_statement, 4, .production_id = 14),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 4, .production_id = 14),
  [1042] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postcss_statement, 3),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postcss_statement, 3),
  [1046] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_keyframe_block_list, 2),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframe_block_list, 2),
  [1050] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_keyframes_statement, 3, .production_id = 9),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframes_statement, 3, .production_id = 9),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 4),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 4),
  [1058] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 4, .production_id = 16),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 4, .production_id = 16),
  [1062] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3),
  [1066] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_supports_statement, 3),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_supports_statement, 3),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_rule, 4),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_rule, 4),
  [1074] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 7, .production_id = 16),
  [1076] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 7, .production_id = 16),
  [1078] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_definition, 4),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_definition, 4),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 5, .production_id = 16),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 5, .production_id = 16),
  [1086] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_statement, 4, .production_id = 7),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_statement, 4, .production_id = 7),
  [1090] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_extend_statement, 4),
  [1092] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_extend_statement, 4),
  [1094] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_statement, 2, .production_id = 7),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_statement, 2, .production_id = 7),
  [1098] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_rule, 3),
  [1100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_rule, 3),
  [1102] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 5),
  [1104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 5),
  [1106] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_statement, 3, .production_id = 7),
  [1108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_statement, 3, .production_id = 7),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_keyframe_block_list, 3),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframe_block_list, 3),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_selector, 3, .production_id = 11),
  [1120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_selector, 3, .production_id = 11),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_plugin_statement, 3),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_plugin_statement, 3),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 6, .production_id = 16),
  [1130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 6, .production_id = 16),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_selector, 3, .production_id = 12),
  [1134] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_selector, 3, .production_id = 12),
  [1136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(471),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id_selector, 2, .production_id = 6),
  [1141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id_selector, 2, .production_id = 6),
  [1143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_arguments, 3),
  [1145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_arguments, 3),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 5, .production_id = 10),
  [1149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 5, .production_id = 10),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_selector, 3, .production_id = 5),
  [1153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_selector, 3, .production_id = 5),
  [1155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 4, .production_id = 17),
  [1157] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 4, .production_id = 17),
  [1159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_descendant_selector, 3),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_descendant_selector, 3),
  [1165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_arguments, 3),
  [1167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_arguments, 3),
  [1169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id_selector, 3, .production_id = 13),
  [1171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id_selector, 3, .production_id = 13),
  [1173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_selector, 4, .production_id = 12),
  [1175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_selector, 4, .production_id = 12),
  [1177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 4, .production_id = 11),
  [1179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 4, .production_id = 11),
  [1181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 2),
  [1183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 2),
  [1185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 6, .production_id = 17),
  [1187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 6, .production_id = 17),
  [1189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_arguments, 2),
  [1191] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_arguments, 2),
  [1193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 3, .production_id = 10),
  [1195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 3, .production_id = 10),
  [1197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_arguments, 4),
  [1199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_arguments, 4),
  [1201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_arguments, 2),
  [1203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_arguments, 2),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_arguments, 4),
  [1207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_arguments, 4),
  [1209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_universal_selector, 1),
  [1211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_universal_selector, 1),
  [1213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_selector, 3),
  [1215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_selector, 3),
  [1217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_adjacent_sibling_selector, 3),
  [1219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_adjacent_sibling_selector, 3),
  [1221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sibling_selector, 3),
  [1223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sibling_selector, 3),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_child_selector, 3),
  [1227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_child_selector, 3),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__mixin_name, 2, .production_id = 2),
  [1241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__mixin_name, 2, .production_id = 2),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(479),
  [1254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [1256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [1258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(474),
  [1261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(331),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1265] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(484),
  [1268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1274] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__concatenated_identifier_repeat1, 2), SHIFT_REPEAT(472),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selectors, 1),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1303] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_id_selector, 2, .production_id = 6), SHIFT(570),
  [1306] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_id_selector, 2, .production_id = 6), SHIFT(590),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [1317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_grid_value_repeat1, 2),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1323] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_id_selector, 2, .production_id = 6), SHIFT(625),
  [1326] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_id_selector, 2, .production_id = 6), SHIFT(620),
  [1329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [1341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_selectors_repeat1, 2),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 3, .production_id = 19),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2),
  [1409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2), SHIFT_REPEAT(524),
  [1412] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2), SHIFT_REPEAT(317),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_query, 3),
  [1427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_query, 3),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [1435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [1437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_feature_query, 5, .production_id = 20),
  [1439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_query, 2),
  [1441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selector_query, 4),
  [1443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [1445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2), SHIFT_REPEAT(394),
  [1460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__mixin_name, 3, .production_id = 11),
  [1462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__mixin_name, 3, .production_id = 11),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1472] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(74),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__mixin_name, 4, .production_id = 15),
  [1483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__mixin_name, 4, .production_id = 15),
  [1485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__mixin_name, 5, .production_id = 18),
  [1487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__mixin_name, 5, .production_id = 18),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1495] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [1511] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframe_block, 2),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [1529] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grid_value_repeat1, 2), SHIFT_REPEAT(149),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1536] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selectors_repeat1, 2), SHIFT_REPEAT(174),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1551] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2), SHIFT_REPEAT(51),
  [1554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1562] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pseudo_class_arguments_repeat1, 2), SHIFT_REPEAT(16),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selectors, 2),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 4),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2),
  [1589] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [1591] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [1593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rest_parameter, 1),
  [1595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rest_parameter, 2),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(560),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1657] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_merge_identifier, 1),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(557),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_when_condition, 4),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1709] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [1711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [1713] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__extend_arguments, 3),
  [1723] = {.entry = {.count = 1, .reusable = false}}, SHIFT(544),
  [1725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(616),
  [1731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [1737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(558),
  [1743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(559),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(562),
  [1749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token__descendant_operator = 0,
  ts_external_token__pseudo_class_selector_colon = 1,
  ts_external_token___error_recovery = 2,
  ts_external_token__concat = 3,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__descendant_operator] = sym__descendant_operator,
  [ts_external_token__pseudo_class_selector_colon] = sym__pseudo_class_selector_colon,
  [ts_external_token___error_recovery] = sym___error_recovery,
  [ts_external_token__concat] = sym__concat,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__descendant_operator] = true,
    [ts_external_token__pseudo_class_selector_colon] = true,
    [ts_external_token___error_recovery] = true,
    [ts_external_token__concat] = true,
  },
  [2] = {
    [ts_external_token__pseudo_class_selector_colon] = true,
  },
  [3] = {
    [ts_external_token__descendant_operator] = true,
    [ts_external_token__pseudo_class_selector_colon] = true,
    [ts_external_token__concat] = true,
  },
  [4] = {
    [ts_external_token__descendant_operator] = true,
    [ts_external_token__pseudo_class_selector_colon] = true,
  },
  [5] = {
    [ts_external_token__concat] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_less_external_scanner_create(void);
void tree_sitter_less_external_scanner_destroy(void *);
bool tree_sitter_less_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_less_external_scanner_serialize(void *, char *);
void tree_sitter_less_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_less() {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_less_external_scanner_create,
      tree_sitter_less_external_scanner_destroy,
      tree_sitter_less_external_scanner_scan,
      tree_sitter_less_external_scanner_serialize,
      tree_sitter_less_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
