#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1898
#define LARGE_STATE_COUNT 153
#define SYMBOL_COUNT 153
#define ALIAS_COUNT 1
#define TOKEN_COUNT 89
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 18
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 28

enum {
  sym_identifier = 1,
  anon_sym_COMMA = 2,
  anon_sym_BEGIN = 3,
  anon_sym_END = 4,
  anon_sym_BEGINFILE = 5,
  anon_sym_ENDFILE = 6,
  anon_sym_ATinclude = 7,
  anon_sym_ATload = 8,
  anon_sym_ATnamespace = 9,
  anon_sym_SEMI = 10,
  anon_sym_LF = 11,
  anon_sym_CR_LF = 12,
  anon_sym_if = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_else = 16,
  anon_sym_while = 17,
  anon_sym_do = 18,
  anon_sym_for = 19,
  anon_sym_in = 20,
  sym_break_statement = 21,
  sym_continue_statement = 22,
  anon_sym_delete = 23,
  anon_sym_exit = 24,
  anon_sym_return = 25,
  anon_sym_switch = 26,
  anon_sym_LBRACE = 27,
  anon_sym_RBRACE = 28,
  anon_sym_case = 29,
  anon_sym_COLON = 30,
  anon_sym_default = 31,
  anon_sym_getline = 32,
  anon_sym_LT = 33,
  sym_next_statement = 34,
  sym_nextfile_statement = 35,
  anon_sym_print = 36,
  anon_sym_LPAREN2 = 37,
  anon_sym_printf = 38,
  anon_sym_GT = 39,
  anon_sym_GT_GT = 40,
  anon_sym_PIPE = 41,
  anon_sym_PIPE_AMP = 42,
  anon_sym_QMARK = 43,
  anon_sym_CARET = 44,
  anon_sym_STAR_STAR = 45,
  anon_sym_STAR = 46,
  anon_sym_SLASH = 47,
  anon_sym_PERCENT = 48,
  anon_sym_PLUS = 49,
  anon_sym_DASH = 50,
  anon_sym_LT_EQ = 51,
  anon_sym_GT_EQ = 52,
  anon_sym_EQ_EQ = 53,
  anon_sym_BANG_EQ = 54,
  anon_sym_TILDE = 55,
  anon_sym_BANG_TILDE = 56,
  anon_sym_AMP_AMP = 57,
  anon_sym_PIPE_PIPE = 58,
  anon_sym_BANG = 59,
  anon_sym_PLUS_PLUS = 60,
  anon_sym_DASH_DASH = 61,
  anon_sym_EQ = 62,
  anon_sym_PLUS_EQ = 63,
  anon_sym_DASH_EQ = 64,
  anon_sym_STAR_EQ = 65,
  anon_sym_SLASH_EQ = 66,
  anon_sym_PERCENT_EQ = 67,
  anon_sym_CARET_EQ = 68,
  anon_sym_DOLLAR = 69,
  anon_sym_LBRACK = 70,
  anon_sym_RBRACK = 71,
  anon_sym_SLASH2 = 72,
  sym_regex_pattern = 73,
  sym_regex_flags = 74,
  anon_sym_AT = 75,
  anon_sym_COLON_COLON = 76,
  sym_number = 77,
  anon_sym_DQUOTE = 78,
  aux_sym_string_token1 = 79,
  sym_escape_sequence = 80,
  anon_sym_function = 81,
  anon_sym_func = 82,
  anon_sym_POUND = 83,
  aux_sym_comment_token1 = 84,
  sym_concatenating_space = 85,
  sym__if_else_separator = 86,
  sym__ambiguous_comment = 87,
  sym__no_space = 88,
  sym_program = 89,
  sym_rule = 90,
  sym_pattern = 91,
  sym_range_pattern = 92,
  sym__special_pattern = 93,
  sym_directive = 94,
  sym__statement = 95,
  sym__statement_separated = 96,
  sym__control_statement = 97,
  sym_if_statement = 98,
  sym_else_clause = 99,
  sym_while_statement = 100,
  sym_do_while_statement = 101,
  sym_for_statement = 102,
  sym_for_in_statement = 103,
  sym_delete_statement = 104,
  sym_exit_statement = 105,
  sym_return_statement = 106,
  sym_switch_statement = 107,
  sym_switch_body = 108,
  sym_switch_case = 109,
  sym_switch_default = 110,
  sym__io_statement = 111,
  sym__getline_exp = 112,
  sym_getline_input = 113,
  sym_getline_file = 114,
  sym__print_args = 115,
  sym_print_statement = 116,
  sym_printf_statement = 117,
  sym_redirected_io_statement = 118,
  sym_piped_io_statement = 119,
  sym_block = 120,
  sym__block_content = 121,
  sym__exp = 122,
  sym_ternary_exp = 123,
  sym_binary_exp = 124,
  sym_unary_exp = 125,
  sym_update_exp = 126,
  sym_assignment_exp = 127,
  sym_piped_io_exp = 128,
  sym_string_concat = 129,
  sym_field_ref = 130,
  sym_array_ref = 131,
  sym_exp_list = 132,
  sym_regex = 133,
  sym_regex_constant = 134,
  sym_grouping = 135,
  sym__primitive = 136,
  sym_namespace = 137,
  sym_ns_qualified_name = 138,
  sym_string = 139,
  sym_func_def = 140,
  sym_param_list = 141,
  sym_func_call = 142,
  sym_indirect_func_call = 143,
  sym_args = 144,
  sym_comment = 145,
  aux_sym_program_repeat1 = 146,
  aux_sym_switch_body_repeat1 = 147,
  aux_sym_block_repeat1 = 148,
  aux_sym_exp_list_repeat1 = 149,
  aux_sym_string_repeat1 = 150,
  aux_sym_param_list_repeat1 = 151,
  aux_sym_args_repeat1 = 152,
  anon_alias_sym_namespace = 153,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_COMMA] = ",",
  [anon_sym_BEGIN] = "BEGIN",
  [anon_sym_END] = "END",
  [anon_sym_BEGINFILE] = "BEGINFILE",
  [anon_sym_ENDFILE] = "ENDFILE",
  [anon_sym_ATinclude] = "@include",
  [anon_sym_ATload] = "@load",
  [anon_sym_ATnamespace] = "@namespace",
  [anon_sym_SEMI] = ";",
  [anon_sym_LF] = "\n",
  [anon_sym_CR_LF] = "\r\n",
  [anon_sym_if] = "if",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_delete] = "delete",
  [anon_sym_exit] = "exit",
  [anon_sym_return] = "return",
  [anon_sym_switch] = "switch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_case] = "case",
  [anon_sym_COLON] = ":",
  [anon_sym_default] = "default",
  [anon_sym_getline] = "getline",
  [anon_sym_LT] = "<",
  [sym_next_statement] = "next_statement",
  [sym_nextfile_statement] = "nextfile_statement",
  [anon_sym_print] = "print",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_printf] = "printf",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PIPE] = "|",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_QMARK] = "\?",
  [anon_sym_CARET] = "^",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [sym_number] = "number",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_function] = "function",
  [anon_sym_func] = "func",
  [anon_sym_POUND] = "#",
  [aux_sym_comment_token1] = "comment_token1",
  [sym_concatenating_space] = "concatenating_space",
  [sym__if_else_separator] = "_if_else_separator",
  [sym__ambiguous_comment] = "_ambiguous_comment",
  [sym__no_space] = "_no_space",
  [sym_program] = "program",
  [sym_rule] = "rule",
  [sym_pattern] = "pattern",
  [sym_range_pattern] = "range_pattern",
  [sym__special_pattern] = "_special_pattern",
  [sym_directive] = "directive",
  [sym__statement] = "_statement",
  [sym__statement_separated] = "_statement_separated",
  [sym__control_statement] = "_control_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_clause] = "else_clause",
  [sym_while_statement] = "while_statement",
  [sym_do_while_statement] = "do_while_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_exit_statement] = "exit_statement",
  [sym_return_statement] = "return_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym__io_statement] = "_io_statement",
  [sym__getline_exp] = "_getline_exp",
  [sym_getline_input] = "getline_input",
  [sym_getline_file] = "getline_file",
  [sym__print_args] = "_print_args",
  [sym_print_statement] = "print_statement",
  [sym_printf_statement] = "printf_statement",
  [sym_redirected_io_statement] = "redirected_io_statement",
  [sym_piped_io_statement] = "piped_io_statement",
  [sym_block] = "block",
  [sym__block_content] = "_block_content",
  [sym__exp] = "_exp",
  [sym_ternary_exp] = "ternary_exp",
  [sym_binary_exp] = "binary_exp",
  [sym_unary_exp] = "unary_exp",
  [sym_update_exp] = "update_exp",
  [sym_assignment_exp] = "assignment_exp",
  [sym_piped_io_exp] = "piped_io_exp",
  [sym_string_concat] = "string_concat",
  [sym_field_ref] = "field_ref",
  [sym_array_ref] = "array_ref",
  [sym_exp_list] = "exp_list",
  [sym_regex] = "regex",
  [sym_regex_constant] = "regex_constant",
  [sym_grouping] = "grouping",
  [sym__primitive] = "_primitive",
  [sym_namespace] = "namespace",
  [sym_ns_qualified_name] = "ns_qualified_name",
  [sym_string] = "string",
  [sym_func_def] = "func_def",
  [sym_param_list] = "param_list",
  [sym_func_call] = "func_call",
  [sym_indirect_func_call] = "indirect_func_call",
  [sym_args] = "args",
  [sym_comment] = "comment",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_exp_list_repeat1] = "exp_list_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_param_list_repeat1] = "param_list_repeat1",
  [aux_sym_args_repeat1] = "args_repeat1",
  [anon_alias_sym_namespace] = "namespace",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_BEGIN] = anon_sym_BEGIN,
  [anon_sym_END] = anon_sym_END,
  [anon_sym_BEGINFILE] = anon_sym_BEGINFILE,
  [anon_sym_ENDFILE] = anon_sym_ENDFILE,
  [anon_sym_ATinclude] = anon_sym_ATinclude,
  [anon_sym_ATload] = anon_sym_ATload,
  [anon_sym_ATnamespace] = anon_sym_ATnamespace,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR_LF] = anon_sym_CR_LF,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_exit] = anon_sym_exit,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_getline] = anon_sym_getline,
  [anon_sym_LT] = anon_sym_LT,
  [sym_next_statement] = sym_next_statement,
  [sym_nextfile_statement] = sym_nextfile_statement,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_printf] = anon_sym_printf,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PIPE_AMP] = anon_sym_PIPE_AMP,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_number] = sym_number,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym_concatenating_space] = sym_concatenating_space,
  [sym__if_else_separator] = sym__if_else_separator,
  [sym__ambiguous_comment] = sym__ambiguous_comment,
  [sym__no_space] = sym__no_space,
  [sym_program] = sym_program,
  [sym_rule] = sym_rule,
  [sym_pattern] = sym_pattern,
  [sym_range_pattern] = sym_range_pattern,
  [sym__special_pattern] = sym__special_pattern,
  [sym_directive] = sym_directive,
  [sym__statement] = sym__statement,
  [sym__statement_separated] = sym__statement_separated,
  [sym__control_statement] = sym__control_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_clause] = sym_else_clause,
  [sym_while_statement] = sym_while_statement,
  [sym_do_while_statement] = sym_do_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_exit_statement] = sym_exit_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym__io_statement] = sym__io_statement,
  [sym__getline_exp] = sym__getline_exp,
  [sym_getline_input] = sym_getline_input,
  [sym_getline_file] = sym_getline_file,
  [sym__print_args] = sym__print_args,
  [sym_print_statement] = sym_print_statement,
  [sym_printf_statement] = sym_printf_statement,
  [sym_redirected_io_statement] = sym_redirected_io_statement,
  [sym_piped_io_statement] = sym_piped_io_statement,
  [sym_block] = sym_block,
  [sym__block_content] = sym__block_content,
  [sym__exp] = sym__exp,
  [sym_ternary_exp] = sym_ternary_exp,
  [sym_binary_exp] = sym_binary_exp,
  [sym_unary_exp] = sym_unary_exp,
  [sym_update_exp] = sym_update_exp,
  [sym_assignment_exp] = sym_assignment_exp,
  [sym_piped_io_exp] = sym_piped_io_exp,
  [sym_string_concat] = sym_string_concat,
  [sym_field_ref] = sym_field_ref,
  [sym_array_ref] = sym_array_ref,
  [sym_exp_list] = sym_exp_list,
  [sym_regex] = sym_regex,
  [sym_regex_constant] = sym_regex_constant,
  [sym_grouping] = sym_grouping,
  [sym__primitive] = sym__primitive,
  [sym_namespace] = sym_namespace,
  [sym_ns_qualified_name] = sym_ns_qualified_name,
  [sym_string] = sym_string,
  [sym_func_def] = sym_func_def,
  [sym_param_list] = sym_param_list,
  [sym_func_call] = sym_func_call,
  [sym_indirect_func_call] = sym_indirect_func_call,
  [sym_args] = sym_args,
  [sym_comment] = sym_comment,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_exp_list_repeat1] = aux_sym_exp_list_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_param_list_repeat1] = aux_sym_param_list_repeat1,
  [aux_sym_args_repeat1] = aux_sym_args_repeat1,
  [anon_alias_sym_namespace] = anon_alias_sym_namespace,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BEGIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_END] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BEGINFILE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENDFILE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATnamespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_getline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_next_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nextfile_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_printf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_concatenating_space] = {
    .visible = true,
    .named = true,
  },
  [sym__if_else_separator] = {
    .visible = false,
    .named = true,
  },
  [sym__ambiguous_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__no_space] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_range_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__special_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__statement_separated] = {
    .visible = false,
    .named = true,
  },
  [sym__control_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym__io_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__getline_exp] = {
    .visible = false,
    .named = true,
  },
  [sym_getline_input] = {
    .visible = true,
    .named = true,
  },
  [sym_getline_file] = {
    .visible = true,
    .named = true,
  },
  [sym__print_args] = {
    .visible = false,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_printf_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_redirected_io_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_piped_io_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__block_content] = {
    .visible = false,
    .named = true,
  },
  [sym__exp] = {
    .visible = false,
    .named = true,
  },
  [sym_ternary_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_update_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_piped_io_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_string_concat] = {
    .visible = true,
    .named = true,
  },
  [sym_field_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_array_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_exp_list] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_grouping] = {
    .visible = true,
    .named = true,
  },
  [sym__primitive] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [sym_ns_qualified_name] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_func_def] = {
    .visible = true,
    .named = true,
  },
  [sym_param_list] = {
    .visible = true,
    .named = true,
  },
  [sym_func_call] = {
    .visible = true,
    .named = true,
  },
  [sym_indirect_func_call] = {
    .visible = true,
    .named = true,
  },
  [sym_args] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exp_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_param_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_namespace] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_advancement = 1,
  field_alternative = 2,
  field_argument = 3,
  field_command = 4,
  field_condition = 5,
  field_consequence = 6,
  field_filename = 7,
  field_flags = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_pattern = 14,
  field_right = 15,
  field_start = 16,
  field_stop = 17,
  field_value = 18,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_advancement] = "advancement",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_command] = "command",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_filename] = "filename",
  [field_flags] = "flags",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_pattern] = "pattern",
  [field_right] = "right",
  [field_start] = "start",
  [field_stop] = "stop",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 3},
  [10] = {.index = 14, .length = 1},
  [11] = {.index = 15, .length = 1},
  [12] = {.index = 16, .length = 1},
  [13] = {.index = 17, .length = 2},
  [14] = {.index = 19, .length = 1},
  [15] = {.index = 20, .length = 1},
  [16] = {.index = 21, .length = 3},
  [17] = {.index = 24, .length = 3},
  [18] = {.index = 27, .length = 3},
  [19] = {.index = 30, .length = 1},
  [20] = {.index = 31, .length = 1},
  [21] = {.index = 32, .length = 2},
  [22] = {.index = 34, .length = 1},
  [23] = {.index = 35, .length = 2},
  [24] = {.index = 37, .length = 2},
  [25] = {.index = 39, .length = 2},
  [26] = {.index = 41, .length = 1},
  [27] = {.index = 42, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 1},
    {field_operator, 0},
  [2] =
    {field_argument, 0},
    {field_operator, 1},
  [4] =
    {field_filename, 2},
  [5] =
    {field_pattern, 1},
  [6] =
    {field_left, 0},
    {field_right, 2},
  [8] =
    {field_name, 0},
  [9] =
    {field_start, 0},
    {field_stop, 2},
  [11] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [14] =
    {field_command, 0},
  [15] =
    {field_command, 2},
  [16] =
    {field_filename, 3},
  [17] =
    {field_flags, 3},
    {field_pattern, 1},
  [19] =
    {field_index, 2},
  [20] =
    {field_name, 1},
  [21] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [24] =
    {field_condition, 1},
    {field_condition, 2},
    {field_condition, 3},
  [27] =
    {field_condition, 3},
    {field_condition, 4},
    {field_condition, 5},
  [30] =
    {field_advancement, 4},
  [31] =
    {field_condition, 3},
  [32] =
    {field_left, 2},
    {field_right, 4},
  [34] =
    {field_initializer, 2},
  [35] =
    {field_advancement, 5},
    {field_condition, 3},
  [37] =
    {field_advancement, 5},
    {field_initializer, 2},
  [39] =
    {field_condition, 4},
    {field_initializer, 2},
  [41] =
    {field_value, 1},
  [42] =
    {field_advancement, 6},
    {field_condition, 4},
    {field_initializer, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_alias_sym_namespace,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(96)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(48)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(48)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(48)
      if (lookahead == '\r') SKIP(1)
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'v') ADVANCE(185);
      if (lookahead == 'x') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(187);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '\r') SKIP(6)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(49)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(49)
      if (lookahead == '\r') SKIP(8)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(38)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(38)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(42)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(42)
      if (lookahead == '\r') SKIP(12)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(44)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(44)
      if (lookahead == '\r') SKIP(14)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(51)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(51)
      if (lookahead == '\r') SKIP(16)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(53)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(53)
      if (lookahead == '\r') SKIP(18)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(55)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(55)
      if (lookahead == '\r') SKIP(20)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(55)
      if (lookahead == '\r') SKIP(20)
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'v') ADVANCE(185);
      if (lookahead == 'x') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(187);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(57)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(57)
      if (lookahead == '\r') SKIP(23)
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(174);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(58)
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(58)
      if (lookahead == '\r') ADVANCE(172);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(58)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(111);
      if (lookahead == '\r') ADVANCE(30);
      if (lookahead == '!') ADVANCE(156);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(34)
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(30)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 30:
      if (lookahead == '\n') ADVANCE(111);
      if (lookahead == '\r') ADVANCE(30);
      if (lookahead == '!') ADVANCE(156);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(34)
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(30)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(47)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(47)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(30)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(30)
      if (lookahead == '\r') SKIP(33)
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(40)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(40)
      if (lookahead == '\r') SKIP(35)
      END_STATE();
    case 37:
      if (lookahead == '\n') ADVANCE(112);
      if (lookahead == '\r') ADVANCE(38);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(38)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 38:
      if (lookahead == '\n') ADVANCE(112);
      if (lookahead == '\r') ADVANCE(38);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(38)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 39:
      if (lookahead == '\n') ADVANCE(113);
      if (lookahead == '\r') ADVANCE(40);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(36)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(40)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 40:
      if (lookahead == '\n') ADVANCE(113);
      if (lookahead == '\r') ADVANCE(40);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(36)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(40)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 41:
      if (lookahead == '\n') ADVANCE(114);
      if (lookahead == '\r') ADVANCE(42);
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(42)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 42:
      if (lookahead == '\n') ADVANCE(114);
      if (lookahead == '\r') ADVANCE(42);
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(42)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 43:
      if (lookahead == '\n') ADVANCE(115);
      if (lookahead == '\r') ADVANCE(44);
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(44)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 44:
      if (lookahead == '\n') ADVANCE(115);
      if (lookahead == '\r') ADVANCE(44);
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(44)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 45:
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '\r') ADVANCE(47);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(47)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 46:
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '\r') ADVANCE(47);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(47)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 47:
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '\r') ADVANCE(47);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(47)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 48:
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 49:
      if (lookahead == '!') ADVANCE(156);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '@') ADVANCE(177);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 50:
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 51:
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 52:
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '\\') SKIP(19)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 53:
      if (lookahead == '!') ADVANCE(61);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '\\') SKIP(19)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 54:
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 55:
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '\\') SKIP(21)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 56:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == '\\') SKIP(24)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 57:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == '\\') SKIP(24)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      END_STATE();
    case 58:
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      END_STATE();
    case 59:
      if (lookahead == '&') ADVANCE(154);
      END_STATE();
    case 60:
      if (lookahead == ':') ADVANCE(180);
      END_STATE();
    case 61:
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '~') ADVANCE(153);
      END_STATE();
    case 62:
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 63:
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == ']') ADVANCE(172);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 64:
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(63);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(75);
      END_STATE();
    case 69:
      if (lookahead == 'c') ADVANCE(74);
      END_STATE();
    case 70:
      if (lookahead == 'd') ADVANCE(107);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(73);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 75:
      if (lookahead == 'l') ADVANCE(81);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(72);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 79:
      if (lookahead == 'p') ADVANCE(67);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(71);
      END_STATE();
    case 82:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(188);
      END_STATE();
    case 83:
      if (lookahead != 0 &&
          lookahead != '\\' &&
          lookahead != ']') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == ']') ADVANCE(173);
      END_STATE();
    case 84:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 85:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(96)
      END_STATE();
    case 86:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(96)
      if (lookahead == '\r') SKIP(85)
      END_STATE();
    case 87:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(99)
      END_STATE();
    case 88:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(99)
      if (lookahead == '\r') SKIP(87)
      END_STATE();
    case 89:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(103)
      END_STATE();
    case 90:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(103)
      if (lookahead == '\r') SKIP(89)
      END_STATE();
    case 91:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(101)
      END_STATE();
    case 92:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(101)
      if (lookahead == '\r') SKIP(91)
      END_STATE();
    case 93:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(97)
      END_STATE();
    case 94:
      if (eof) ADVANCE(104);
      if (lookahead == '\n') SKIP(97)
      if (lookahead == '\r') SKIP(93)
      END_STATE();
    case 95:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(94)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(97)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 96:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(86)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(120);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(96)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 97:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(94)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(97)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 98:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '\\') SKIP(88)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(99)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 99:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == ';') ADVANCE(109);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '\\') SKIP(88)
      if (lookahead == ']') ADVANCE(169);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(99)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 100:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(92)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(101)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 101:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == ')') ADVANCE(118);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '[') ADVANCE(168);
      if (lookahead == '\\') SKIP(92)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(101)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 102:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '\\') SKIP(90)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(103)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 103:
      if (eof) ADVANCE(104);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '#') ADVANCE(189);
      if (lookahead == '$') ADVANCE(167);
      if (lookahead == '%') ADVANCE(140);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(117);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(105);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(125);
      if (lookahead == '?') ADVANCE(132);
      if (lookahead == '@') ADVANCE(178);
      if (lookahead == '\\') SKIP(90)
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(119);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '~') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(103)
      if (('.' <= lookahead && lookahead <= '9')) ADVANCE(181);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_ATinclude);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_ATload);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_ATnamespace);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(110);
      if (lookahead == '\r') ADVANCE(5);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(111);
      if (lookahead == '\r') ADVANCE(30);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(112);
      if (lookahead == '\r') ADVANCE(38);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(113);
      if (lookahead == '\r') ADVANCE(40);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(114);
      if (lookahead == '\r') ADVANCE(42);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(115);
      if (lookahead == '\r') ADVANCE(44);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '\r') ADVANCE(47);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(180);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(149);
      if (lookahead == '>') ADVANCE(128);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&') ADVANCE(131);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '|') ADVANCE(155);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(166);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(135);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(135);
      if (lookahead == '=') ADVANCE(163);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(164);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(158);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(158);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(159);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(159);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_BANG_TILDE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '~') ADVANCE(153);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '#') ADVANCE(190);
      if (lookahead == '[') ADVANCE(64);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '/') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(64);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '/') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(172);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '/') ADVANCE(63);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '/') ADVANCE(63);
      if (lookahead == '[') ADVANCE(63);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_regex_flags);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(179);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_regex_flags);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(77);
      if (lookahead == 'l') ADVANCE(78);
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(186);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '[') ADVANCE(64);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '/') ADVANCE(172);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\r') ADVANCE(195);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '#') ADVANCE(192);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(195);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'B') ADVANCE(1);
      if (lookahead == 'E') ADVANCE(2);
      if (lookahead == '\\') SKIP(3)
      if (lookahead == 'b') ADVANCE(4);
      if (lookahead == 'c') ADVANCE(5);
      if (lookahead == 'd') ADVANCE(6);
      if (lookahead == 'e') ADVANCE(7);
      if (lookahead == 'f') ADVANCE(8);
      if (lookahead == 'g') ADVANCE(9);
      if (lookahead == 'i') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 'w') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'E') ADVANCE(16);
      END_STATE();
    case 2:
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(18)
      END_STATE();
    case 4:
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'x') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 10:
      if (lookahead == 'f') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 12:
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'w') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'G') ADVANCE(36);
      END_STATE();
    case 17:
      if (lookahead == 'D') ADVANCE(37);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'f') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(44);
      END_STATE();
    case 26:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 27:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 31:
      if (lookahead == 'x') ADVANCE(48);
      END_STATE();
    case 32:
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 36:
      if (lookahead == 'I') ADVANCE(53);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_END);
      if (lookahead == 'F') ADVANCE(54);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(62);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 49:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 50:
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 53:
      if (lookahead == 'N') ADVANCE(69);
      END_STATE();
    case 54:
      if (lookahead == 'I') ADVANCE(70);
      END_STATE();
    case 55:
      if (lookahead == 'k') ADVANCE(71);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_exit);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_func);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_next_statement);
      if (lookahead == 'f') ADVANCE(77);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 67:
      if (lookahead == 'c') ADVANCE(80);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_BEGIN);
      if (lookahead == 'F') ADVANCE(82);
      END_STATE();
    case 70:
      if (lookahead == 'L') ADVANCE(83);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 73:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(87);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_print);
      if (lookahead == 'f') ADVANCE(90);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 80:
      if (lookahead == 'h') ADVANCE(92);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 82:
      if (lookahead == 'I') ADVANCE(93);
      END_STATE();
    case 83:
      if (lookahead == 'E') ADVANCE(94);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_printf);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 93:
      if (lookahead == 'L') ADVANCE(100);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_ENDFILE);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 97:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_getline);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 100:
      if (lookahead == 'E') ADVANCE(104);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_nextfile_statement);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_BEGINFILE);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 100},
  [2] = {.lex_state = 4, .external_lex_state = 2},
  [3] = {.lex_state = 4, .external_lex_state = 2},
  [4] = {.lex_state = 4},
  [5] = {.lex_state = 49},
  [6] = {.lex_state = 49},
  [7] = {.lex_state = 49},
  [8] = {.lex_state = 49},
  [9] = {.lex_state = 49},
  [10] = {.lex_state = 49},
  [11] = {.lex_state = 49},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 49},
  [14] = {.lex_state = 49},
  [15] = {.lex_state = 4, .external_lex_state = 2},
  [16] = {.lex_state = 49},
  [17] = {.lex_state = 49},
  [18] = {.lex_state = 49},
  [19] = {.lex_state = 49},
  [20] = {.lex_state = 49},
  [21] = {.lex_state = 49},
  [22] = {.lex_state = 49},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 49},
  [25] = {.lex_state = 49},
  [26] = {.lex_state = 49},
  [27] = {.lex_state = 49},
  [28] = {.lex_state = 49},
  [29] = {.lex_state = 49},
  [30] = {.lex_state = 49},
  [31] = {.lex_state = 49},
  [32] = {.lex_state = 49},
  [33] = {.lex_state = 49},
  [34] = {.lex_state = 49},
  [35] = {.lex_state = 49},
  [36] = {.lex_state = 49},
  [37] = {.lex_state = 49},
  [38] = {.lex_state = 49},
  [39] = {.lex_state = 49},
  [40] = {.lex_state = 49},
  [41] = {.lex_state = 49},
  [42] = {.lex_state = 49},
  [43] = {.lex_state = 49},
  [44] = {.lex_state = 49},
  [45] = {.lex_state = 49},
  [46] = {.lex_state = 49},
  [47] = {.lex_state = 49},
  [48] = {.lex_state = 49},
  [49] = {.lex_state = 49},
  [50] = {.lex_state = 49},
  [51] = {.lex_state = 49},
  [52] = {.lex_state = 49},
  [53] = {.lex_state = 49},
  [54] = {.lex_state = 49},
  [55] = {.lex_state = 49},
  [56] = {.lex_state = 49},
  [57] = {.lex_state = 49},
  [58] = {.lex_state = 49},
  [59] = {.lex_state = 49},
  [60] = {.lex_state = 49},
  [61] = {.lex_state = 49},
  [62] = {.lex_state = 49},
  [63] = {.lex_state = 49},
  [64] = {.lex_state = 49},
  [65] = {.lex_state = 49},
  [66] = {.lex_state = 49},
  [67] = {.lex_state = 49},
  [68] = {.lex_state = 49},
  [69] = {.lex_state = 49},
  [70] = {.lex_state = 49},
  [71] = {.lex_state = 49},
  [72] = {.lex_state = 49},
  [73] = {.lex_state = 49},
  [74] = {.lex_state = 49},
  [75] = {.lex_state = 49},
  [76] = {.lex_state = 49},
  [77] = {.lex_state = 49},
  [78] = {.lex_state = 49},
  [79] = {.lex_state = 49},
  [80] = {.lex_state = 49},
  [81] = {.lex_state = 49},
  [82] = {.lex_state = 49},
  [83] = {.lex_state = 49},
  [84] = {.lex_state = 49},
  [85] = {.lex_state = 49},
  [86] = {.lex_state = 49},
  [87] = {.lex_state = 49},
  [88] = {.lex_state = 49},
  [89] = {.lex_state = 49},
  [90] = {.lex_state = 49},
  [91] = {.lex_state = 49},
  [92] = {.lex_state = 49},
  [93] = {.lex_state = 45, .external_lex_state = 3},
  [94] = {.lex_state = 45, .external_lex_state = 3},
  [95] = {.lex_state = 46, .external_lex_state = 3},
  [96] = {.lex_state = 45, .external_lex_state = 4},
  [97] = {.lex_state = 45, .external_lex_state = 4},
  [98] = {.lex_state = 45, .external_lex_state = 3},
  [99] = {.lex_state = 45, .external_lex_state = 3},
  [100] = {.lex_state = 45, .external_lex_state = 3},
  [101] = {.lex_state = 45, .external_lex_state = 4},
  [102] = {.lex_state = 45, .external_lex_state = 3},
  [103] = {.lex_state = 46, .external_lex_state = 3},
  [104] = {.lex_state = 46, .external_lex_state = 4},
  [105] = {.lex_state = 45, .external_lex_state = 3},
  [106] = {.lex_state = 46, .external_lex_state = 3},
  [107] = {.lex_state = 46, .external_lex_state = 3},
  [108] = {.lex_state = 45, .external_lex_state = 4},
  [109] = {.lex_state = 46, .external_lex_state = 3},
  [110] = {.lex_state = 45, .external_lex_state = 3},
  [111] = {.lex_state = 46, .external_lex_state = 3},
  [112] = {.lex_state = 45, .external_lex_state = 4},
  [113] = {.lex_state = 46, .external_lex_state = 3},
  [114] = {.lex_state = 46, .external_lex_state = 3},
  [115] = {.lex_state = 46, .external_lex_state = 3},
  [116] = {.lex_state = 46, .external_lex_state = 3},
  [117] = {.lex_state = 46, .external_lex_state = 3},
  [118] = {.lex_state = 46, .external_lex_state = 3},
  [119] = {.lex_state = 46, .external_lex_state = 3},
  [120] = {.lex_state = 46, .external_lex_state = 3},
  [121] = {.lex_state = 45, .external_lex_state = 3},
  [122] = {.lex_state = 46, .external_lex_state = 3},
  [123] = {.lex_state = 46, .external_lex_state = 3},
  [124] = {.lex_state = 46, .external_lex_state = 3},
  [125] = {.lex_state = 46, .external_lex_state = 3},
  [126] = {.lex_state = 46, .external_lex_state = 3},
  [127] = {.lex_state = 46, .external_lex_state = 3},
  [128] = {.lex_state = 46, .external_lex_state = 4},
  [129] = {.lex_state = 45, .external_lex_state = 4},
  [130] = {.lex_state = 46, .external_lex_state = 3},
  [131] = {.lex_state = 46, .external_lex_state = 3},
  [132] = {.lex_state = 45, .external_lex_state = 4},
  [133] = {.lex_state = 46, .external_lex_state = 3},
  [134] = {.lex_state = 46, .external_lex_state = 4},
  [135] = {.lex_state = 46, .external_lex_state = 3},
  [136] = {.lex_state = 46, .external_lex_state = 3},
  [137] = {.lex_state = 46, .external_lex_state = 3},
  [138] = {.lex_state = 29, .external_lex_state = 2},
  [139] = {.lex_state = 46, .external_lex_state = 4},
  [140] = {.lex_state = 46, .external_lex_state = 4},
  [141] = {.lex_state = 46, .external_lex_state = 3},
  [142] = {.lex_state = 46, .external_lex_state = 3},
  [143] = {.lex_state = 46, .external_lex_state = 3},
  [144] = {.lex_state = 45, .external_lex_state = 4},
  [145] = {.lex_state = 45, .external_lex_state = 3},
  [146] = {.lex_state = 46, .external_lex_state = 3},
  [147] = {.lex_state = 46, .external_lex_state = 4},
  [148] = {.lex_state = 46, .external_lex_state = 4},
  [149] = {.lex_state = 46, .external_lex_state = 3},
  [150] = {.lex_state = 45, .external_lex_state = 3},
  [151] = {.lex_state = 46, .external_lex_state = 3},
  [152] = {.lex_state = 46, .external_lex_state = 3},
  [153] = {.lex_state = 46, .external_lex_state = 4},
  [154] = {.lex_state = 46, .external_lex_state = 3},
  [155] = {.lex_state = 46, .external_lex_state = 4},
  [156] = {.lex_state = 46, .external_lex_state = 4},
  [157] = {.lex_state = 46, .external_lex_state = 4},
  [158] = {.lex_state = 46, .external_lex_state = 4},
  [159] = {.lex_state = 46, .external_lex_state = 4},
  [160] = {.lex_state = 46, .external_lex_state = 4},
  [161] = {.lex_state = 46, .external_lex_state = 4},
  [162] = {.lex_state = 46, .external_lex_state = 4},
  [163] = {.lex_state = 46, .external_lex_state = 4},
  [164] = {.lex_state = 45, .external_lex_state = 4},
  [165] = {.lex_state = 46, .external_lex_state = 4},
  [166] = {.lex_state = 46, .external_lex_state = 4},
  [167] = {.lex_state = 46, .external_lex_state = 4},
  [168] = {.lex_state = 46, .external_lex_state = 3},
  [169] = {.lex_state = 46, .external_lex_state = 4},
  [170] = {.lex_state = 46, .external_lex_state = 4},
  [171] = {.lex_state = 46, .external_lex_state = 3},
  [172] = {.lex_state = 37, .external_lex_state = 3},
  [173] = {.lex_state = 46, .external_lex_state = 4},
  [174] = {.lex_state = 46, .external_lex_state = 4},
  [175] = {.lex_state = 46, .external_lex_state = 4},
  [176] = {.lex_state = 46, .external_lex_state = 4},
  [177] = {.lex_state = 46, .external_lex_state = 4},
  [178] = {.lex_state = 46, .external_lex_state = 4},
  [179] = {.lex_state = 45, .external_lex_state = 4},
  [180] = {.lex_state = 46, .external_lex_state = 4},
  [181] = {.lex_state = 46, .external_lex_state = 4},
  [182] = {.lex_state = 45, .external_lex_state = 4},
  [183] = {.lex_state = 46, .external_lex_state = 3},
  [184] = {.lex_state = 46, .external_lex_state = 4},
  [185] = {.lex_state = 46, .external_lex_state = 4},
  [186] = {.lex_state = 46, .external_lex_state = 4},
  [187] = {.lex_state = 29},
  [188] = {.lex_state = 46, .external_lex_state = 4},
  [189] = {.lex_state = 46, .external_lex_state = 3},
  [190] = {.lex_state = 46, .external_lex_state = 3},
  [191] = {.lex_state = 46, .external_lex_state = 3},
  [192] = {.lex_state = 46, .external_lex_state = 3},
  [193] = {.lex_state = 46, .external_lex_state = 3},
  [194] = {.lex_state = 46, .external_lex_state = 3},
  [195] = {.lex_state = 46, .external_lex_state = 4},
  [196] = {.lex_state = 46, .external_lex_state = 3},
  [197] = {.lex_state = 46, .external_lex_state = 3},
  [198] = {.lex_state = 46, .external_lex_state = 3},
  [199] = {.lex_state = 46, .external_lex_state = 3},
  [200] = {.lex_state = 46, .external_lex_state = 3},
  [201] = {.lex_state = 46, .external_lex_state = 3},
  [202] = {.lex_state = 37, .external_lex_state = 4},
  [203] = {.lex_state = 46, .external_lex_state = 4},
  [204] = {.lex_state = 46, .external_lex_state = 3},
  [205] = {.lex_state = 46, .external_lex_state = 4},
  [206] = {.lex_state = 46, .external_lex_state = 4},
  [207] = {.lex_state = 46, .external_lex_state = 4},
  [208] = {.lex_state = 46, .external_lex_state = 4},
  [209] = {.lex_state = 46, .external_lex_state = 4},
  [210] = {.lex_state = 46, .external_lex_state = 4},
  [211] = {.lex_state = 46, .external_lex_state = 4},
  [212] = {.lex_state = 46, .external_lex_state = 4},
  [213] = {.lex_state = 46, .external_lex_state = 4},
  [214] = {.lex_state = 46, .external_lex_state = 4},
  [215] = {.lex_state = 46, .external_lex_state = 4},
  [216] = {.lex_state = 46, .external_lex_state = 4},
  [217] = {.lex_state = 46, .external_lex_state = 4},
  [218] = {.lex_state = 46, .external_lex_state = 4},
  [219] = {.lex_state = 0, .external_lex_state = 4},
  [220] = {.lex_state = 0, .external_lex_state = 4},
  [221] = {.lex_state = 0, .external_lex_state = 4},
  [222] = {.lex_state = 95, .external_lex_state = 4},
  [223] = {.lex_state = 0, .external_lex_state = 4},
  [224] = {.lex_state = 0, .external_lex_state = 4},
  [225] = {.lex_state = 4, .external_lex_state = 2},
  [226] = {.lex_state = 95, .external_lex_state = 4},
  [227] = {.lex_state = 95, .external_lex_state = 4},
  [228] = {.lex_state = 4, .external_lex_state = 2},
  [229] = {.lex_state = 95, .external_lex_state = 4},
  [230] = {.lex_state = 4, .external_lex_state = 3},
  [231] = {.lex_state = 95, .external_lex_state = 4},
  [232] = {.lex_state = 4, .external_lex_state = 3},
  [233] = {.lex_state = 4, .external_lex_state = 3},
  [234] = {.lex_state = 95, .external_lex_state = 4},
  [235] = {.lex_state = 95, .external_lex_state = 4},
  [236] = {.lex_state = 95, .external_lex_state = 4},
  [237] = {.lex_state = 4},
  [238] = {.lex_state = 4, .external_lex_state = 3},
  [239] = {.lex_state = 39, .external_lex_state = 3},
  [240] = {.lex_state = 4, .external_lex_state = 4},
  [241] = {.lex_state = 95, .external_lex_state = 4},
  [242] = {.lex_state = 4, .external_lex_state = 4},
  [243] = {.lex_state = 4, .external_lex_state = 3},
  [244] = {.lex_state = 95, .external_lex_state = 4},
  [245] = {.lex_state = 95, .external_lex_state = 4},
  [246] = {.lex_state = 95, .external_lex_state = 4},
  [247] = {.lex_state = 95, .external_lex_state = 4},
  [248] = {.lex_state = 95, .external_lex_state = 4},
  [249] = {.lex_state = 95, .external_lex_state = 4},
  [250] = {.lex_state = 95, .external_lex_state = 4},
  [251] = {.lex_state = 95, .external_lex_state = 4},
  [252] = {.lex_state = 4, .external_lex_state = 4},
  [253] = {.lex_state = 95, .external_lex_state = 4},
  [254] = {.lex_state = 95, .external_lex_state = 4},
  [255] = {.lex_state = 95, .external_lex_state = 4},
  [256] = {.lex_state = 4, .external_lex_state = 3},
  [257] = {.lex_state = 95, .external_lex_state = 4},
  [258] = {.lex_state = 95, .external_lex_state = 4},
  [259] = {.lex_state = 95, .external_lex_state = 4},
  [260] = {.lex_state = 95, .external_lex_state = 4},
  [261] = {.lex_state = 95, .external_lex_state = 4},
  [262] = {.lex_state = 4, .external_lex_state = 3},
  [263] = {.lex_state = 95, .external_lex_state = 4},
  [264] = {.lex_state = 95, .external_lex_state = 4},
  [265] = {.lex_state = 95, .external_lex_state = 4},
  [266] = {.lex_state = 4, .external_lex_state = 3},
  [267] = {.lex_state = 4, .external_lex_state = 2},
  [268] = {.lex_state = 95, .external_lex_state = 4},
  [269] = {.lex_state = 95, .external_lex_state = 4},
  [270] = {.lex_state = 4, .external_lex_state = 2},
  [271] = {.lex_state = 4, .external_lex_state = 2},
  [272] = {.lex_state = 4, .external_lex_state = 2},
  [273] = {.lex_state = 4},
  [274] = {.lex_state = 95, .external_lex_state = 4},
  [275] = {.lex_state = 4, .external_lex_state = 2},
  [276] = {.lex_state = 4},
  [277] = {.lex_state = 4},
  [278] = {.lex_state = 4, .external_lex_state = 2},
  [279] = {.lex_state = 4, .external_lex_state = 3},
  [280] = {.lex_state = 4, .external_lex_state = 3},
  [281] = {.lex_state = 4, .external_lex_state = 2},
  [282] = {.lex_state = 4, .external_lex_state = 3},
  [283] = {.lex_state = 4, .external_lex_state = 3},
  [284] = {.lex_state = 4, .external_lex_state = 3},
  [285] = {.lex_state = 4, .external_lex_state = 3},
  [286] = {.lex_state = 4, .external_lex_state = 3},
  [287] = {.lex_state = 4, .external_lex_state = 3},
  [288] = {.lex_state = 4, .external_lex_state = 4},
  [289] = {.lex_state = 4, .external_lex_state = 3},
  [290] = {.lex_state = 4, .external_lex_state = 4},
  [291] = {.lex_state = 100},
  [292] = {.lex_state = 39, .external_lex_state = 4},
  [293] = {.lex_state = 4, .external_lex_state = 3},
  [294] = {.lex_state = 4, .external_lex_state = 3},
  [295] = {.lex_state = 4, .external_lex_state = 3},
  [296] = {.lex_state = 4, .external_lex_state = 3},
  [297] = {.lex_state = 4, .external_lex_state = 3},
  [298] = {.lex_state = 4, .external_lex_state = 3},
  [299] = {.lex_state = 4, .external_lex_state = 3},
  [300] = {.lex_state = 4, .external_lex_state = 3},
  [301] = {.lex_state = 4, .external_lex_state = 3},
  [302] = {.lex_state = 4},
  [303] = {.lex_state = 4, .external_lex_state = 2},
  [304] = {.lex_state = 4, .external_lex_state = 3},
  [305] = {.lex_state = 100},
  [306] = {.lex_state = 4, .external_lex_state = 4},
  [307] = {.lex_state = 4, .external_lex_state = 3},
  [308] = {.lex_state = 4, .external_lex_state = 3},
  [309] = {.lex_state = 4, .external_lex_state = 3},
  [310] = {.lex_state = 4, .external_lex_state = 3},
  [311] = {.lex_state = 4, .external_lex_state = 3},
  [312] = {.lex_state = 4, .external_lex_state = 3},
  [313] = {.lex_state = 4, .external_lex_state = 3},
  [314] = {.lex_state = 4, .external_lex_state = 3},
  [315] = {.lex_state = 4, .external_lex_state = 3},
  [316] = {.lex_state = 4, .external_lex_state = 3},
  [317] = {.lex_state = 0, .external_lex_state = 4},
  [318] = {.lex_state = 39, .external_lex_state = 2},
  [319] = {.lex_state = 4, .external_lex_state = 3},
  [320] = {.lex_state = 4, .external_lex_state = 3},
  [321] = {.lex_state = 4, .external_lex_state = 3},
  [322] = {.lex_state = 0, .external_lex_state = 4},
  [323] = {.lex_state = 4},
  [324] = {.lex_state = 4, .external_lex_state = 3},
  [325] = {.lex_state = 4, .external_lex_state = 4},
  [326] = {.lex_state = 4, .external_lex_state = 4},
  [327] = {.lex_state = 4},
  [328] = {.lex_state = 0, .external_lex_state = 4},
  [329] = {.lex_state = 4, .external_lex_state = 2},
  [330] = {.lex_state = 4, .external_lex_state = 4},
  [331] = {.lex_state = 4, .external_lex_state = 4},
  [332] = {.lex_state = 4, .external_lex_state = 4},
  [333] = {.lex_state = 4, .external_lex_state = 4},
  [334] = {.lex_state = 4, .external_lex_state = 4},
  [335] = {.lex_state = 4, .external_lex_state = 4},
  [336] = {.lex_state = 4, .external_lex_state = 4},
  [337] = {.lex_state = 4, .external_lex_state = 4},
  [338] = {.lex_state = 4, .external_lex_state = 4},
  [339] = {.lex_state = 4, .external_lex_state = 4},
  [340] = {.lex_state = 4, .external_lex_state = 4},
  [341] = {.lex_state = 4, .external_lex_state = 4},
  [342] = {.lex_state = 4, .external_lex_state = 4},
  [343] = {.lex_state = 4, .external_lex_state = 4},
  [344] = {.lex_state = 4, .external_lex_state = 4},
  [345] = {.lex_state = 4, .external_lex_state = 4},
  [346] = {.lex_state = 4, .external_lex_state = 4},
  [347] = {.lex_state = 4, .external_lex_state = 2},
  [348] = {.lex_state = 0, .external_lex_state = 4},
  [349] = {.lex_state = 4, .external_lex_state = 4},
  [350] = {.lex_state = 4, .external_lex_state = 4},
  [351] = {.lex_state = 4, .external_lex_state = 4},
  [352] = {.lex_state = 0, .external_lex_state = 4},
  [353] = {.lex_state = 4, .external_lex_state = 2},
  [354] = {.lex_state = 4, .external_lex_state = 2},
  [355] = {.lex_state = 4, .external_lex_state = 2},
  [356] = {.lex_state = 4, .external_lex_state = 2},
  [357] = {.lex_state = 4, .external_lex_state = 2},
  [358] = {.lex_state = 4, .external_lex_state = 2},
  [359] = {.lex_state = 4, .external_lex_state = 2},
  [360] = {.lex_state = 4, .external_lex_state = 2},
  [361] = {.lex_state = 4, .external_lex_state = 4},
  [362] = {.lex_state = 4, .external_lex_state = 2},
  [363] = {.lex_state = 4, .external_lex_state = 2},
  [364] = {.lex_state = 4, .external_lex_state = 2},
  [365] = {.lex_state = 4},
  [366] = {.lex_state = 4, .external_lex_state = 2},
  [367] = {.lex_state = 4, .external_lex_state = 2},
  [368] = {.lex_state = 95, .external_lex_state = 4},
  [369] = {.lex_state = 4, .external_lex_state = 2},
  [370] = {.lex_state = 4, .external_lex_state = 2},
  [371] = {.lex_state = 4, .external_lex_state = 4},
  [372] = {.lex_state = 4, .external_lex_state = 4},
  [373] = {.lex_state = 4},
  [374] = {.lex_state = 4, .external_lex_state = 4},
  [375] = {.lex_state = 0, .external_lex_state = 4},
  [376] = {.lex_state = 4, .external_lex_state = 4},
  [377] = {.lex_state = 4},
  [378] = {.lex_state = 39},
  [379] = {.lex_state = 95, .external_lex_state = 4},
  [380] = {.lex_state = 4, .external_lex_state = 4},
  [381] = {.lex_state = 4, .external_lex_state = 4},
  [382] = {.lex_state = 4, .external_lex_state = 2},
  [383] = {.lex_state = 4, .external_lex_state = 4},
  [384] = {.lex_state = 4, .external_lex_state = 4},
  [385] = {.lex_state = 4, .external_lex_state = 4},
  [386] = {.lex_state = 4, .external_lex_state = 4},
  [387] = {.lex_state = 4, .external_lex_state = 4},
  [388] = {.lex_state = 4, .external_lex_state = 4},
  [389] = {.lex_state = 98, .external_lex_state = 4},
  [390] = {.lex_state = 4},
  [391] = {.lex_state = 4},
  [392] = {.lex_state = 4},
  [393] = {.lex_state = 4},
  [394] = {.lex_state = 95, .external_lex_state = 4},
  [395] = {.lex_state = 95, .external_lex_state = 4},
  [396] = {.lex_state = 4},
  [397] = {.lex_state = 4},
  [398] = {.lex_state = 4},
  [399] = {.lex_state = 4},
  [400] = {.lex_state = 4},
  [401] = {.lex_state = 4},
  [402] = {.lex_state = 4},
  [403] = {.lex_state = 4},
  [404] = {.lex_state = 4},
  [405] = {.lex_state = 4},
  [406] = {.lex_state = 4},
  [407] = {.lex_state = 4},
  [408] = {.lex_state = 4},
  [409] = {.lex_state = 95, .external_lex_state = 4},
  [410] = {.lex_state = 95, .external_lex_state = 4},
  [411] = {.lex_state = 4},
  [412] = {.lex_state = 95, .external_lex_state = 4},
  [413] = {.lex_state = 95, .external_lex_state = 4},
  [414] = {.lex_state = 95, .external_lex_state = 4},
  [415] = {.lex_state = 95, .external_lex_state = 4},
  [416] = {.lex_state = 95, .external_lex_state = 4},
  [417] = {.lex_state = 95, .external_lex_state = 4},
  [418] = {.lex_state = 95, .external_lex_state = 4},
  [419] = {.lex_state = 4, .external_lex_state = 2},
  [420] = {.lex_state = 95, .external_lex_state = 4},
  [421] = {.lex_state = 4, .external_lex_state = 2},
  [422] = {.lex_state = 95, .external_lex_state = 4},
  [423] = {.lex_state = 4, .external_lex_state = 2},
  [424] = {.lex_state = 4, .external_lex_state = 2},
  [425] = {.lex_state = 4, .external_lex_state = 2},
  [426] = {.lex_state = 95, .external_lex_state = 4},
  [427] = {.lex_state = 95, .external_lex_state = 4},
  [428] = {.lex_state = 95, .external_lex_state = 4},
  [429] = {.lex_state = 95, .external_lex_state = 4},
  [430] = {.lex_state = 29, .external_lex_state = 2},
  [431] = {.lex_state = 4},
  [432] = {.lex_state = 4},
  [433] = {.lex_state = 4},
  [434] = {.lex_state = 4},
  [435] = {.lex_state = 4},
  [436] = {.lex_state = 29},
  [437] = {.lex_state = 29, .external_lex_state = 2},
  [438] = {.lex_state = 29},
  [439] = {.lex_state = 100, .external_lex_state = 4},
  [440] = {.lex_state = 100, .external_lex_state = 4},
  [441] = {.lex_state = 100, .external_lex_state = 4},
  [442] = {.lex_state = 100},
  [443] = {.lex_state = 100, .external_lex_state = 4},
  [444] = {.lex_state = 100},
  [445] = {.lex_state = 100, .external_lex_state = 4},
  [446] = {.lex_state = 100, .external_lex_state = 4},
  [447] = {.lex_state = 100, .external_lex_state = 4},
  [448] = {.lex_state = 102, .external_lex_state = 4},
  [449] = {.lex_state = 100},
  [450] = {.lex_state = 100, .external_lex_state = 4},
  [451] = {.lex_state = 100},
  [452] = {.lex_state = 100},
  [453] = {.lex_state = 100, .external_lex_state = 4},
  [454] = {.lex_state = 100, .external_lex_state = 4},
  [455] = {.lex_state = 100},
  [456] = {.lex_state = 100},
  [457] = {.lex_state = 100, .external_lex_state = 4},
  [458] = {.lex_state = 100, .external_lex_state = 4},
  [459] = {.lex_state = 100, .external_lex_state = 4},
  [460] = {.lex_state = 100, .external_lex_state = 4},
  [461] = {.lex_state = 100, .external_lex_state = 4},
  [462] = {.lex_state = 100, .external_lex_state = 4},
  [463] = {.lex_state = 100, .external_lex_state = 4},
  [464] = {.lex_state = 100, .external_lex_state = 4},
  [465] = {.lex_state = 100, .external_lex_state = 4},
  [466] = {.lex_state = 100, .external_lex_state = 4},
  [467] = {.lex_state = 100, .external_lex_state = 4},
  [468] = {.lex_state = 100, .external_lex_state = 4},
  [469] = {.lex_state = 100, .external_lex_state = 4},
  [470] = {.lex_state = 100, .external_lex_state = 4},
  [471] = {.lex_state = 100, .external_lex_state = 4},
  [472] = {.lex_state = 100, .external_lex_state = 4},
  [473] = {.lex_state = 100, .external_lex_state = 4},
  [474] = {.lex_state = 100, .external_lex_state = 4},
  [475] = {.lex_state = 100, .external_lex_state = 4},
  [476] = {.lex_state = 100, .external_lex_state = 4},
  [477] = {.lex_state = 100, .external_lex_state = 4},
  [478] = {.lex_state = 100, .external_lex_state = 4},
  [479] = {.lex_state = 100, .external_lex_state = 4},
  [480] = {.lex_state = 100, .external_lex_state = 4},
  [481] = {.lex_state = 100},
  [482] = {.lex_state = 100, .external_lex_state = 4},
  [483] = {.lex_state = 100, .external_lex_state = 4},
  [484] = {.lex_state = 100, .external_lex_state = 4},
  [485] = {.lex_state = 100, .external_lex_state = 4},
  [486] = {.lex_state = 45, .external_lex_state = 3},
  [487] = {.lex_state = 100},
  [488] = {.lex_state = 100, .external_lex_state = 4},
  [489] = {.lex_state = 100, .external_lex_state = 4},
  [490] = {.lex_state = 100, .external_lex_state = 4},
  [491] = {.lex_state = 102},
  [492] = {.lex_state = 45, .external_lex_state = 3},
  [493] = {.lex_state = 45, .external_lex_state = 3},
  [494] = {.lex_state = 100},
  [495] = {.lex_state = 100},
  [496] = {.lex_state = 100},
  [497] = {.lex_state = 100},
  [498] = {.lex_state = 45, .external_lex_state = 4},
  [499] = {.lex_state = 100},
  [500] = {.lex_state = 100},
  [501] = {.lex_state = 100},
  [502] = {.lex_state = 100},
  [503] = {.lex_state = 100},
  [504] = {.lex_state = 45, .external_lex_state = 3},
  [505] = {.lex_state = 100},
  [506] = {.lex_state = 45, .external_lex_state = 4},
  [507] = {.lex_state = 100},
  [508] = {.lex_state = 45, .external_lex_state = 3},
  [509] = {.lex_state = 100},
  [510] = {.lex_state = 100},
  [511] = {.lex_state = 100},
  [512] = {.lex_state = 45, .external_lex_state = 3},
  [513] = {.lex_state = 100},
  [514] = {.lex_state = 100},
  [515] = {.lex_state = 45, .external_lex_state = 4},
  [516] = {.lex_state = 45, .external_lex_state = 3},
  [517] = {.lex_state = 45, .external_lex_state = 4},
  [518] = {.lex_state = 4, .external_lex_state = 2},
  [519] = {.lex_state = 4, .external_lex_state = 2},
  [520] = {.lex_state = 100},
  [521] = {.lex_state = 45, .external_lex_state = 4},
  [522] = {.lex_state = 45, .external_lex_state = 3},
  [523] = {.lex_state = 45, .external_lex_state = 4},
  [524] = {.lex_state = 4},
  [525] = {.lex_state = 37, .external_lex_state = 3},
  [526] = {.lex_state = 45, .external_lex_state = 4},
  [527] = {.lex_state = 45, .external_lex_state = 3},
  [528] = {.lex_state = 4},
  [529] = {.lex_state = 45, .external_lex_state = 3},
  [530] = {.lex_state = 45, .external_lex_state = 3},
  [531] = {.lex_state = 45, .external_lex_state = 3},
  [532] = {.lex_state = 45, .external_lex_state = 4},
  [533] = {.lex_state = 45, .external_lex_state = 3},
  [534] = {.lex_state = 45, .external_lex_state = 3},
  [535] = {.lex_state = 45, .external_lex_state = 4},
  [536] = {.lex_state = 45, .external_lex_state = 3},
  [537] = {.lex_state = 45, .external_lex_state = 3},
  [538] = {.lex_state = 45, .external_lex_state = 3},
  [539] = {.lex_state = 45, .external_lex_state = 3},
  [540] = {.lex_state = 4, .external_lex_state = 2},
  [541] = {.lex_state = 4, .external_lex_state = 2},
  [542] = {.lex_state = 45, .external_lex_state = 3},
  [543] = {.lex_state = 37, .external_lex_state = 4},
  [544] = {.lex_state = 45, .external_lex_state = 3},
  [545] = {.lex_state = 45, .external_lex_state = 3},
  [546] = {.lex_state = 45, .external_lex_state = 4},
  [547] = {.lex_state = 45, .external_lex_state = 3},
  [548] = {.lex_state = 45, .external_lex_state = 3},
  [549] = {.lex_state = 45, .external_lex_state = 4},
  [550] = {.lex_state = 45, .external_lex_state = 3},
  [551] = {.lex_state = 45, .external_lex_state = 3},
  [552] = {.lex_state = 45, .external_lex_state = 4},
  [553] = {.lex_state = 45, .external_lex_state = 4},
  [554] = {.lex_state = 45, .external_lex_state = 4},
  [555] = {.lex_state = 45, .external_lex_state = 3},
  [556] = {.lex_state = 45, .external_lex_state = 3},
  [557] = {.lex_state = 45, .external_lex_state = 3},
  [558] = {.lex_state = 45, .external_lex_state = 3},
  [559] = {.lex_state = 37, .external_lex_state = 3},
  [560] = {.lex_state = 45, .external_lex_state = 4},
  [561] = {.lex_state = 45, .external_lex_state = 4},
  [562] = {.lex_state = 4, .external_lex_state = 2},
  [563] = {.lex_state = 4},
  [564] = {.lex_state = 45, .external_lex_state = 4},
  [565] = {.lex_state = 4, .external_lex_state = 2},
  [566] = {.lex_state = 45, .external_lex_state = 3},
  [567] = {.lex_state = 45, .external_lex_state = 4},
  [568] = {.lex_state = 45, .external_lex_state = 4},
  [569] = {.lex_state = 0, .external_lex_state = 4},
  [570] = {.lex_state = 45, .external_lex_state = 4},
  [571] = {.lex_state = 45, .external_lex_state = 4},
  [572] = {.lex_state = 45, .external_lex_state = 4},
  [573] = {.lex_state = 0, .external_lex_state = 4},
  [574] = {.lex_state = 45, .external_lex_state = 4},
  [575] = {.lex_state = 4, .external_lex_state = 2},
  [576] = {.lex_state = 45, .external_lex_state = 3},
  [577] = {.lex_state = 4, .external_lex_state = 2},
  [578] = {.lex_state = 45, .external_lex_state = 4},
  [579] = {.lex_state = 4},
  [580] = {.lex_state = 45, .external_lex_state = 3},
  [581] = {.lex_state = 0, .external_lex_state = 4},
  [582] = {.lex_state = 45, .external_lex_state = 4},
  [583] = {.lex_state = 45, .external_lex_state = 4},
  [584] = {.lex_state = 0, .external_lex_state = 4},
  [585] = {.lex_state = 4, .external_lex_state = 2},
  [586] = {.lex_state = 0, .external_lex_state = 4},
  [587] = {.lex_state = 45, .external_lex_state = 4},
  [588] = {.lex_state = 45, .external_lex_state = 4},
  [589] = {.lex_state = 45, .external_lex_state = 4},
  [590] = {.lex_state = 49},
  [591] = {.lex_state = 0, .external_lex_state = 4},
  [592] = {.lex_state = 45, .external_lex_state = 3},
  [593] = {.lex_state = 4},
  [594] = {.lex_state = 45, .external_lex_state = 4},
  [595] = {.lex_state = 45, .external_lex_state = 3},
  [596] = {.lex_state = 45, .external_lex_state = 3},
  [597] = {.lex_state = 49},
  [598] = {.lex_state = 49},
  [599] = {.lex_state = 4},
  [600] = {.lex_state = 49},
  [601] = {.lex_state = 0, .external_lex_state = 4},
  [602] = {.lex_state = 49},
  [603] = {.lex_state = 45, .external_lex_state = 3},
  [604] = {.lex_state = 45, .external_lex_state = 3},
  [605] = {.lex_state = 4},
  [606] = {.lex_state = 0, .external_lex_state = 4},
  [607] = {.lex_state = 49},
  [608] = {.lex_state = 45, .external_lex_state = 4},
  [609] = {.lex_state = 45, .external_lex_state = 3},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 4},
  [612] = {.lex_state = 45, .external_lex_state = 3},
  [613] = {.lex_state = 49},
  [614] = {.lex_state = 49},
  [615] = {.lex_state = 49},
  [616] = {.lex_state = 45, .external_lex_state = 3},
  [617] = {.lex_state = 45, .external_lex_state = 3},
  [618] = {.lex_state = 45, .external_lex_state = 3},
  [619] = {.lex_state = 49},
  [620] = {.lex_state = 37, .external_lex_state = 4},
  [621] = {.lex_state = 45, .external_lex_state = 3},
  [622] = {.lex_state = 45, .external_lex_state = 3},
  [623] = {.lex_state = 45, .external_lex_state = 3},
  [624] = {.lex_state = 45, .external_lex_state = 4},
  [625] = {.lex_state = 49},
  [626] = {.lex_state = 49},
  [627] = {.lex_state = 49},
  [628] = {.lex_state = 49},
  [629] = {.lex_state = 45, .external_lex_state = 4},
  [630] = {.lex_state = 49},
  [631] = {.lex_state = 49},
  [632] = {.lex_state = 45, .external_lex_state = 4},
  [633] = {.lex_state = 49},
  [634] = {.lex_state = 49},
  [635] = {.lex_state = 49},
  [636] = {.lex_state = 49},
  [637] = {.lex_state = 49},
  [638] = {.lex_state = 0, .external_lex_state = 4},
  [639] = {.lex_state = 45, .external_lex_state = 4},
  [640] = {.lex_state = 49},
  [641] = {.lex_state = 0, .external_lex_state = 4},
  [642] = {.lex_state = 49},
  [643] = {.lex_state = 4, .external_lex_state = 2},
  [644] = {.lex_state = 45, .external_lex_state = 4},
  [645] = {.lex_state = 49},
  [646] = {.lex_state = 49},
  [647] = {.lex_state = 49},
  [648] = {.lex_state = 49},
  [649] = {.lex_state = 49},
  [650] = {.lex_state = 49},
  [651] = {.lex_state = 49},
  [652] = {.lex_state = 45, .external_lex_state = 4},
  [653] = {.lex_state = 49},
  [654] = {.lex_state = 49},
  [655] = {.lex_state = 49},
  [656] = {.lex_state = 49},
  [657] = {.lex_state = 49},
  [658] = {.lex_state = 45, .external_lex_state = 4},
  [659] = {.lex_state = 49},
  [660] = {.lex_state = 49},
  [661] = {.lex_state = 45, .external_lex_state = 4},
  [662] = {.lex_state = 49},
  [663] = {.lex_state = 98, .external_lex_state = 4},
  [664] = {.lex_state = 49},
  [665] = {.lex_state = 4, .external_lex_state = 2},
  [666] = {.lex_state = 45, .external_lex_state = 4},
  [667] = {.lex_state = 45, .external_lex_state = 4},
  [668] = {.lex_state = 45, .external_lex_state = 4},
  [669] = {.lex_state = 45, .external_lex_state = 4},
  [670] = {.lex_state = 45, .external_lex_state = 4},
  [671] = {.lex_state = 49},
  [672] = {.lex_state = 45, .external_lex_state = 4},
  [673] = {.lex_state = 0, .external_lex_state = 4},
  [674] = {.lex_state = 49},
  [675] = {.lex_state = 49},
  [676] = {.lex_state = 0, .external_lex_state = 4},
  [677] = {.lex_state = 49},
  [678] = {.lex_state = 49},
  [679] = {.lex_state = 0, .external_lex_state = 4},
  [680] = {.lex_state = 49},
  [681] = {.lex_state = 49},
  [682] = {.lex_state = 49},
  [683] = {.lex_state = 49},
  [684] = {.lex_state = 49},
  [685] = {.lex_state = 49},
  [686] = {.lex_state = 49},
  [687] = {.lex_state = 49},
  [688] = {.lex_state = 49},
  [689] = {.lex_state = 49},
  [690] = {.lex_state = 49},
  [691] = {.lex_state = 0, .external_lex_state = 4},
  [692] = {.lex_state = 49},
  [693] = {.lex_state = 49},
  [694] = {.lex_state = 49},
  [695] = {.lex_state = 49},
  [696] = {.lex_state = 49},
  [697] = {.lex_state = 49},
  [698] = {.lex_state = 0, .external_lex_state = 4},
  [699] = {.lex_state = 49},
  [700] = {.lex_state = 49},
  [701] = {.lex_state = 49},
  [702] = {.lex_state = 49},
  [703] = {.lex_state = 4},
  [704] = {.lex_state = 49},
  [705] = {.lex_state = 0, .external_lex_state = 4},
  [706] = {.lex_state = 49},
  [707] = {.lex_state = 0, .external_lex_state = 4},
  [708] = {.lex_state = 0, .external_lex_state = 4},
  [709] = {.lex_state = 49},
  [710] = {.lex_state = 49},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 49},
  [713] = {.lex_state = 49},
  [714] = {.lex_state = 49},
  [715] = {.lex_state = 0, .external_lex_state = 4},
  [716] = {.lex_state = 4, .external_lex_state = 2},
  [717] = {.lex_state = 49},
  [718] = {.lex_state = 49},
  [719] = {.lex_state = 0, .external_lex_state = 4},
  [720] = {.lex_state = 49},
  [721] = {.lex_state = 49},
  [722] = {.lex_state = 0, .external_lex_state = 4},
  [723] = {.lex_state = 49},
  [724] = {.lex_state = 49},
  [725] = {.lex_state = 0, .external_lex_state = 4},
  [726] = {.lex_state = 0, .external_lex_state = 4},
  [727] = {.lex_state = 49},
  [728] = {.lex_state = 49},
  [729] = {.lex_state = 49},
  [730] = {.lex_state = 49},
  [731] = {.lex_state = 49},
  [732] = {.lex_state = 49},
  [733] = {.lex_state = 49},
  [734] = {.lex_state = 49},
  [735] = {.lex_state = 0, .external_lex_state = 4},
  [736] = {.lex_state = 49},
  [737] = {.lex_state = 49},
  [738] = {.lex_state = 49},
  [739] = {.lex_state = 49},
  [740] = {.lex_state = 49},
  [741] = {.lex_state = 49},
  [742] = {.lex_state = 49},
  [743] = {.lex_state = 49},
  [744] = {.lex_state = 49},
  [745] = {.lex_state = 49},
  [746] = {.lex_state = 49},
  [747] = {.lex_state = 49},
  [748] = {.lex_state = 49},
  [749] = {.lex_state = 49},
  [750] = {.lex_state = 49},
  [751] = {.lex_state = 49},
  [752] = {.lex_state = 49},
  [753] = {.lex_state = 49},
  [754] = {.lex_state = 49},
  [755] = {.lex_state = 49},
  [756] = {.lex_state = 49},
  [757] = {.lex_state = 0, .external_lex_state = 4},
  [758] = {.lex_state = 49},
  [759] = {.lex_state = 49},
  [760] = {.lex_state = 0, .external_lex_state = 4},
  [761] = {.lex_state = 49},
  [762] = {.lex_state = 0, .external_lex_state = 4},
  [763] = {.lex_state = 49},
  [764] = {.lex_state = 49},
  [765] = {.lex_state = 49},
  [766] = {.lex_state = 49},
  [767] = {.lex_state = 49},
  [768] = {.lex_state = 49},
  [769] = {.lex_state = 49},
  [770] = {.lex_state = 49},
  [771] = {.lex_state = 49},
  [772] = {.lex_state = 49},
  [773] = {.lex_state = 49},
  [774] = {.lex_state = 49},
  [775] = {.lex_state = 49},
  [776] = {.lex_state = 49},
  [777] = {.lex_state = 49},
  [778] = {.lex_state = 49},
  [779] = {.lex_state = 49},
  [780] = {.lex_state = 49},
  [781] = {.lex_state = 49},
  [782] = {.lex_state = 49},
  [783] = {.lex_state = 49},
  [784] = {.lex_state = 49},
  [785] = {.lex_state = 49},
  [786] = {.lex_state = 49},
  [787] = {.lex_state = 49},
  [788] = {.lex_state = 49},
  [789] = {.lex_state = 49},
  [790] = {.lex_state = 49},
  [791] = {.lex_state = 49},
  [792] = {.lex_state = 49},
  [793] = {.lex_state = 49},
  [794] = {.lex_state = 49},
  [795] = {.lex_state = 49},
  [796] = {.lex_state = 49},
  [797] = {.lex_state = 49},
  [798] = {.lex_state = 49},
  [799] = {.lex_state = 49},
  [800] = {.lex_state = 49},
  [801] = {.lex_state = 49},
  [802] = {.lex_state = 49},
  [803] = {.lex_state = 49},
  [804] = {.lex_state = 49},
  [805] = {.lex_state = 49},
  [806] = {.lex_state = 49},
  [807] = {.lex_state = 49},
  [808] = {.lex_state = 49},
  [809] = {.lex_state = 49},
  [810] = {.lex_state = 49},
  [811] = {.lex_state = 49},
  [812] = {.lex_state = 49},
  [813] = {.lex_state = 49},
  [814] = {.lex_state = 49},
  [815] = {.lex_state = 49},
  [816] = {.lex_state = 49},
  [817] = {.lex_state = 49},
  [818] = {.lex_state = 49},
  [819] = {.lex_state = 49},
  [820] = {.lex_state = 49},
  [821] = {.lex_state = 49},
  [822] = {.lex_state = 0, .external_lex_state = 4},
  [823] = {.lex_state = 49},
  [824] = {.lex_state = 49},
  [825] = {.lex_state = 49},
  [826] = {.lex_state = 49},
  [827] = {.lex_state = 49},
  [828] = {.lex_state = 49},
  [829] = {.lex_state = 49},
  [830] = {.lex_state = 49},
  [831] = {.lex_state = 49},
  [832] = {.lex_state = 49},
  [833] = {.lex_state = 49},
  [834] = {.lex_state = 49},
  [835] = {.lex_state = 49},
  [836] = {.lex_state = 49},
  [837] = {.lex_state = 49},
  [838] = {.lex_state = 49},
  [839] = {.lex_state = 49},
  [840] = {.lex_state = 49},
  [841] = {.lex_state = 49},
  [842] = {.lex_state = 49},
  [843] = {.lex_state = 49},
  [844] = {.lex_state = 49},
  [845] = {.lex_state = 49},
  [846] = {.lex_state = 49},
  [847] = {.lex_state = 49},
  [848] = {.lex_state = 49},
  [849] = {.lex_state = 49},
  [850] = {.lex_state = 49},
  [851] = {.lex_state = 49},
  [852] = {.lex_state = 49},
  [853] = {.lex_state = 49},
  [854] = {.lex_state = 49},
  [855] = {.lex_state = 49},
  [856] = {.lex_state = 49},
  [857] = {.lex_state = 49},
  [858] = {.lex_state = 4},
  [859] = {.lex_state = 49},
  [860] = {.lex_state = 49},
  [861] = {.lex_state = 49},
  [862] = {.lex_state = 49},
  [863] = {.lex_state = 49},
  [864] = {.lex_state = 49},
  [865] = {.lex_state = 49},
  [866] = {.lex_state = 49},
  [867] = {.lex_state = 49},
  [868] = {.lex_state = 49},
  [869] = {.lex_state = 49},
  [870] = {.lex_state = 49},
  [871] = {.lex_state = 49},
  [872] = {.lex_state = 49},
  [873] = {.lex_state = 49},
  [874] = {.lex_state = 49},
  [875] = {.lex_state = 49},
  [876] = {.lex_state = 49},
  [877] = {.lex_state = 49},
  [878] = {.lex_state = 49},
  [879] = {.lex_state = 49},
  [880] = {.lex_state = 49},
  [881] = {.lex_state = 49},
  [882] = {.lex_state = 49},
  [883] = {.lex_state = 49},
  [884] = {.lex_state = 49},
  [885] = {.lex_state = 49},
  [886] = {.lex_state = 49},
  [887] = {.lex_state = 49},
  [888] = {.lex_state = 49},
  [889] = {.lex_state = 49},
  [890] = {.lex_state = 49},
  [891] = {.lex_state = 49},
  [892] = {.lex_state = 49},
  [893] = {.lex_state = 49},
  [894] = {.lex_state = 49},
  [895] = {.lex_state = 49},
  [896] = {.lex_state = 49},
  [897] = {.lex_state = 49},
  [898] = {.lex_state = 49},
  [899] = {.lex_state = 49},
  [900] = {.lex_state = 49},
  [901] = {.lex_state = 49},
  [902] = {.lex_state = 49},
  [903] = {.lex_state = 0, .external_lex_state = 4},
  [904] = {.lex_state = 49},
  [905] = {.lex_state = 49},
  [906] = {.lex_state = 49},
  [907] = {.lex_state = 49},
  [908] = {.lex_state = 49},
  [909] = {.lex_state = 49},
  [910] = {.lex_state = 49},
  [911] = {.lex_state = 49},
  [912] = {.lex_state = 49},
  [913] = {.lex_state = 49},
  [914] = {.lex_state = 49},
  [915] = {.lex_state = 49},
  [916] = {.lex_state = 49},
  [917] = {.lex_state = 49},
  [918] = {.lex_state = 49},
  [919] = {.lex_state = 49},
  [920] = {.lex_state = 49},
  [921] = {.lex_state = 49},
  [922] = {.lex_state = 49},
  [923] = {.lex_state = 49},
  [924] = {.lex_state = 49},
  [925] = {.lex_state = 49},
  [926] = {.lex_state = 49},
  [927] = {.lex_state = 49},
  [928] = {.lex_state = 49},
  [929] = {.lex_state = 49},
  [930] = {.lex_state = 49},
  [931] = {.lex_state = 49},
  [932] = {.lex_state = 49},
  [933] = {.lex_state = 4, .external_lex_state = 2},
  [934] = {.lex_state = 49},
  [935] = {.lex_state = 49},
  [936] = {.lex_state = 49},
  [937] = {.lex_state = 49},
  [938] = {.lex_state = 49},
  [939] = {.lex_state = 49},
  [940] = {.lex_state = 49},
  [941] = {.lex_state = 49},
  [942] = {.lex_state = 49},
  [943] = {.lex_state = 49},
  [944] = {.lex_state = 49},
  [945] = {.lex_state = 49},
  [946] = {.lex_state = 49},
  [947] = {.lex_state = 49},
  [948] = {.lex_state = 49},
  [949] = {.lex_state = 49},
  [950] = {.lex_state = 49},
  [951] = {.lex_state = 49},
  [952] = {.lex_state = 49},
  [953] = {.lex_state = 49},
  [954] = {.lex_state = 49},
  [955] = {.lex_state = 49},
  [956] = {.lex_state = 49},
  [957] = {.lex_state = 49},
  [958] = {.lex_state = 49},
  [959] = {.lex_state = 49},
  [960] = {.lex_state = 49},
  [961] = {.lex_state = 49},
  [962] = {.lex_state = 49},
  [963] = {.lex_state = 49},
  [964] = {.lex_state = 49},
  [965] = {.lex_state = 49},
  [966] = {.lex_state = 49},
  [967] = {.lex_state = 49},
  [968] = {.lex_state = 49},
  [969] = {.lex_state = 49},
  [970] = {.lex_state = 49},
  [971] = {.lex_state = 49},
  [972] = {.lex_state = 49},
  [973] = {.lex_state = 49},
  [974] = {.lex_state = 49},
  [975] = {.lex_state = 49},
  [976] = {.lex_state = 49},
  [977] = {.lex_state = 49},
  [978] = {.lex_state = 0, .external_lex_state = 4},
  [979] = {.lex_state = 49},
  [980] = {.lex_state = 49},
  [981] = {.lex_state = 49},
  [982] = {.lex_state = 49},
  [983] = {.lex_state = 49},
  [984] = {.lex_state = 49},
  [985] = {.lex_state = 49},
  [986] = {.lex_state = 49},
  [987] = {.lex_state = 49},
  [988] = {.lex_state = 49},
  [989] = {.lex_state = 49},
  [990] = {.lex_state = 49},
  [991] = {.lex_state = 49},
  [992] = {.lex_state = 49},
  [993] = {.lex_state = 49},
  [994] = {.lex_state = 49},
  [995] = {.lex_state = 49},
  [996] = {.lex_state = 49},
  [997] = {.lex_state = 49},
  [998] = {.lex_state = 49},
  [999] = {.lex_state = 49},
  [1000] = {.lex_state = 49},
  [1001] = {.lex_state = 4, .external_lex_state = 2},
  [1002] = {.lex_state = 49},
  [1003] = {.lex_state = 49},
  [1004] = {.lex_state = 41, .external_lex_state = 3},
  [1005] = {.lex_state = 49},
  [1006] = {.lex_state = 49},
  [1007] = {.lex_state = 49},
  [1008] = {.lex_state = 49},
  [1009] = {.lex_state = 49},
  [1010] = {.lex_state = 49},
  [1011] = {.lex_state = 49},
  [1012] = {.lex_state = 49},
  [1013] = {.lex_state = 49},
  [1014] = {.lex_state = 49},
  [1015] = {.lex_state = 49},
  [1016] = {.lex_state = 49},
  [1017] = {.lex_state = 49},
  [1018] = {.lex_state = 49},
  [1019] = {.lex_state = 49},
  [1020] = {.lex_state = 49},
  [1021] = {.lex_state = 49},
  [1022] = {.lex_state = 49},
  [1023] = {.lex_state = 49},
  [1024] = {.lex_state = 49},
  [1025] = {.lex_state = 49},
  [1026] = {.lex_state = 49},
  [1027] = {.lex_state = 49},
  [1028] = {.lex_state = 49},
  [1029] = {.lex_state = 49},
  [1030] = {.lex_state = 49},
  [1031] = {.lex_state = 49},
  [1032] = {.lex_state = 49},
  [1033] = {.lex_state = 49},
  [1034] = {.lex_state = 49},
  [1035] = {.lex_state = 49},
  [1036] = {.lex_state = 49},
  [1037] = {.lex_state = 4, .external_lex_state = 2},
  [1038] = {.lex_state = 49},
  [1039] = {.lex_state = 49},
  [1040] = {.lex_state = 49},
  [1041] = {.lex_state = 4, .external_lex_state = 2},
  [1042] = {.lex_state = 4, .external_lex_state = 2},
  [1043] = {.lex_state = 49},
  [1044] = {.lex_state = 4, .external_lex_state = 2},
  [1045] = {.lex_state = 49},
  [1046] = {.lex_state = 4, .external_lex_state = 2},
  [1047] = {.lex_state = 4, .external_lex_state = 2},
  [1048] = {.lex_state = 49},
  [1049] = {.lex_state = 49},
  [1050] = {.lex_state = 4, .external_lex_state = 2},
  [1051] = {.lex_state = 4, .external_lex_state = 2},
  [1052] = {.lex_state = 4, .external_lex_state = 2},
  [1053] = {.lex_state = 49},
  [1054] = {.lex_state = 49},
  [1055] = {.lex_state = 49},
  [1056] = {.lex_state = 49},
  [1057] = {.lex_state = 49},
  [1058] = {.lex_state = 49},
  [1059] = {.lex_state = 49},
  [1060] = {.lex_state = 4, .external_lex_state = 2},
  [1061] = {.lex_state = 4, .external_lex_state = 2},
  [1062] = {.lex_state = 4, .external_lex_state = 2},
  [1063] = {.lex_state = 49},
  [1064] = {.lex_state = 49},
  [1065] = {.lex_state = 4, .external_lex_state = 2},
  [1066] = {.lex_state = 49},
  [1067] = {.lex_state = 4, .external_lex_state = 2},
  [1068] = {.lex_state = 49},
  [1069] = {.lex_state = 49},
  [1070] = {.lex_state = 4, .external_lex_state = 2},
  [1071] = {.lex_state = 49},
  [1072] = {.lex_state = 4, .external_lex_state = 2},
  [1073] = {.lex_state = 4, .external_lex_state = 2},
  [1074] = {.lex_state = 4, .external_lex_state = 2},
  [1075] = {.lex_state = 49},
  [1076] = {.lex_state = 4, .external_lex_state = 2},
  [1077] = {.lex_state = 4, .external_lex_state = 2},
  [1078] = {.lex_state = 49},
  [1079] = {.lex_state = 4, .external_lex_state = 2},
  [1080] = {.lex_state = 49},
  [1081] = {.lex_state = 4, .external_lex_state = 2},
  [1082] = {.lex_state = 4, .external_lex_state = 2},
  [1083] = {.lex_state = 4, .external_lex_state = 2},
  [1084] = {.lex_state = 4, .external_lex_state = 2},
  [1085] = {.lex_state = 49},
  [1086] = {.lex_state = 4, .external_lex_state = 2},
  [1087] = {.lex_state = 4, .external_lex_state = 2},
  [1088] = {.lex_state = 4, .external_lex_state = 2},
  [1089] = {.lex_state = 4, .external_lex_state = 2},
  [1090] = {.lex_state = 4, .external_lex_state = 2},
  [1091] = {.lex_state = 4, .external_lex_state = 2},
  [1092] = {.lex_state = 4, .external_lex_state = 2},
  [1093] = {.lex_state = 4},
  [1094] = {.lex_state = 41, .external_lex_state = 4},
  [1095] = {.lex_state = 4},
  [1096] = {.lex_state = 4},
  [1097] = {.lex_state = 4},
  [1098] = {.lex_state = 4},
  [1099] = {.lex_state = 4},
  [1100] = {.lex_state = 4},
  [1101] = {.lex_state = 4},
  [1102] = {.lex_state = 4},
  [1103] = {.lex_state = 4},
  [1104] = {.lex_state = 4},
  [1105] = {.lex_state = 4},
  [1106] = {.lex_state = 41, .external_lex_state = 3},
  [1107] = {.lex_state = 4},
  [1108] = {.lex_state = 4},
  [1109] = {.lex_state = 4},
  [1110] = {.lex_state = 0, .external_lex_state = 4},
  [1111] = {.lex_state = 4},
  [1112] = {.lex_state = 4},
  [1113] = {.lex_state = 4},
  [1114] = {.lex_state = 4},
  [1115] = {.lex_state = 4},
  [1116] = {.lex_state = 4},
  [1117] = {.lex_state = 4},
  [1118] = {.lex_state = 4},
  [1119] = {.lex_state = 41, .external_lex_state = 2},
  [1120] = {.lex_state = 4},
  [1121] = {.lex_state = 0, .external_lex_state = 4},
  [1122] = {.lex_state = 4},
  [1123] = {.lex_state = 4},
  [1124] = {.lex_state = 0, .external_lex_state = 4},
  [1125] = {.lex_state = 4},
  [1126] = {.lex_state = 4},
  [1127] = {.lex_state = 4},
  [1128] = {.lex_state = 4},
  [1129] = {.lex_state = 4},
  [1130] = {.lex_state = 0, .external_lex_state = 4},
  [1131] = {.lex_state = 4},
  [1132] = {.lex_state = 4},
  [1133] = {.lex_state = 0, .external_lex_state = 4},
  [1134] = {.lex_state = 41, .external_lex_state = 3},
  [1135] = {.lex_state = 0, .external_lex_state = 4},
  [1136] = {.lex_state = 4},
  [1137] = {.lex_state = 41},
  [1138] = {.lex_state = 41, .external_lex_state = 4},
  [1139] = {.lex_state = 41, .external_lex_state = 3},
  [1140] = {.lex_state = 41, .external_lex_state = 4},
  [1141] = {.lex_state = 41, .external_lex_state = 3},
  [1142] = {.lex_state = 41, .external_lex_state = 2},
  [1143] = {.lex_state = 41, .external_lex_state = 3},
  [1144] = {.lex_state = 4, .external_lex_state = 2},
  [1145] = {.lex_state = 4, .external_lex_state = 2},
  [1146] = {.lex_state = 4, .external_lex_state = 2},
  [1147] = {.lex_state = 41, .external_lex_state = 3},
  [1148] = {.lex_state = 41, .external_lex_state = 2},
  [1149] = {.lex_state = 4, .external_lex_state = 2},
  [1150] = {.lex_state = 41, .external_lex_state = 3},
  [1151] = {.lex_state = 41, .external_lex_state = 3},
  [1152] = {.lex_state = 41, .external_lex_state = 3},
  [1153] = {.lex_state = 43, .external_lex_state = 3},
  [1154] = {.lex_state = 41, .external_lex_state = 3},
  [1155] = {.lex_state = 41, .external_lex_state = 3},
  [1156] = {.lex_state = 41},
  [1157] = {.lex_state = 41, .external_lex_state = 3},
  [1158] = {.lex_state = 41, .external_lex_state = 2},
  [1159] = {.lex_state = 41, .external_lex_state = 4},
  [1160] = {.lex_state = 41, .external_lex_state = 4},
  [1161] = {.lex_state = 41, .external_lex_state = 3},
  [1162] = {.lex_state = 41, .external_lex_state = 3},
  [1163] = {.lex_state = 41, .external_lex_state = 3},
  [1164] = {.lex_state = 41, .external_lex_state = 3},
  [1165] = {.lex_state = 41, .external_lex_state = 3},
  [1166] = {.lex_state = 41},
  [1167] = {.lex_state = 41, .external_lex_state = 3},
  [1168] = {.lex_state = 41, .external_lex_state = 3},
  [1169] = {.lex_state = 41, .external_lex_state = 3},
  [1170] = {.lex_state = 41, .external_lex_state = 2},
  [1171] = {.lex_state = 41, .external_lex_state = 3},
  [1172] = {.lex_state = 41, .external_lex_state = 3},
  [1173] = {.lex_state = 41, .external_lex_state = 4},
  [1174] = {.lex_state = 41, .external_lex_state = 3},
  [1175] = {.lex_state = 41, .external_lex_state = 3},
  [1176] = {.lex_state = 41, .external_lex_state = 3},
  [1177] = {.lex_state = 41, .external_lex_state = 3},
  [1178] = {.lex_state = 41, .external_lex_state = 3},
  [1179] = {.lex_state = 41, .external_lex_state = 3},
  [1180] = {.lex_state = 41, .external_lex_state = 3},
  [1181] = {.lex_state = 41, .external_lex_state = 4},
  [1182] = {.lex_state = 41, .external_lex_state = 2},
  [1183] = {.lex_state = 4},
  [1184] = {.lex_state = 41, .external_lex_state = 2},
  [1185] = {.lex_state = 41, .external_lex_state = 4},
  [1186] = {.lex_state = 41, .external_lex_state = 3},
  [1187] = {.lex_state = 41, .external_lex_state = 4},
  [1188] = {.lex_state = 41, .external_lex_state = 4},
  [1189] = {.lex_state = 41, .external_lex_state = 2},
  [1190] = {.lex_state = 41, .external_lex_state = 4},
  [1191] = {.lex_state = 41, .external_lex_state = 4},
  [1192] = {.lex_state = 41, .external_lex_state = 3},
  [1193] = {.lex_state = 41, .external_lex_state = 3},
  [1194] = {.lex_state = 41, .external_lex_state = 2},
  [1195] = {.lex_state = 41, .external_lex_state = 2},
  [1196] = {.lex_state = 41, .external_lex_state = 2},
  [1197] = {.lex_state = 41, .external_lex_state = 4},
  [1198] = {.lex_state = 41},
  [1199] = {.lex_state = 41, .external_lex_state = 4},
  [1200] = {.lex_state = 41, .external_lex_state = 4},
  [1201] = {.lex_state = 41, .external_lex_state = 4},
  [1202] = {.lex_state = 41, .external_lex_state = 4},
  [1203] = {.lex_state = 41, .external_lex_state = 2},
  [1204] = {.lex_state = 41, .external_lex_state = 4},
  [1205] = {.lex_state = 41, .external_lex_state = 4},
  [1206] = {.lex_state = 41, .external_lex_state = 3},
  [1207] = {.lex_state = 41, .external_lex_state = 3},
  [1208] = {.lex_state = 41, .external_lex_state = 4},
  [1209] = {.lex_state = 41, .external_lex_state = 2},
  [1210] = {.lex_state = 41, .external_lex_state = 4},
  [1211] = {.lex_state = 41, .external_lex_state = 3},
  [1212] = {.lex_state = 41},
  [1213] = {.lex_state = 41, .external_lex_state = 4},
  [1214] = {.lex_state = 41, .external_lex_state = 4},
  [1215] = {.lex_state = 41, .external_lex_state = 2},
  [1216] = {.lex_state = 43, .external_lex_state = 2},
  [1217] = {.lex_state = 41, .external_lex_state = 4},
  [1218] = {.lex_state = 41, .external_lex_state = 4},
  [1219] = {.lex_state = 41, .external_lex_state = 4},
  [1220] = {.lex_state = 41, .external_lex_state = 4},
  [1221] = {.lex_state = 41, .external_lex_state = 2},
  [1222] = {.lex_state = 41, .external_lex_state = 3},
  [1223] = {.lex_state = 41, .external_lex_state = 4},
  [1224] = {.lex_state = 41, .external_lex_state = 2},
  [1225] = {.lex_state = 43, .external_lex_state = 4},
  [1226] = {.lex_state = 41},
  [1227] = {.lex_state = 41, .external_lex_state = 2},
  [1228] = {.lex_state = 41, .external_lex_state = 2},
  [1229] = {.lex_state = 41, .external_lex_state = 2},
  [1230] = {.lex_state = 41, .external_lex_state = 2},
  [1231] = {.lex_state = 41, .external_lex_state = 3},
  [1232] = {.lex_state = 41, .external_lex_state = 4},
  [1233] = {.lex_state = 41, .external_lex_state = 3},
  [1234] = {.lex_state = 41, .external_lex_state = 3},
  [1235] = {.lex_state = 41, .external_lex_state = 4},
  [1236] = {.lex_state = 41, .external_lex_state = 2},
  [1237] = {.lex_state = 41, .external_lex_state = 3},
  [1238] = {.lex_state = 41, .external_lex_state = 3},
  [1239] = {.lex_state = 41, .external_lex_state = 2},
  [1240] = {.lex_state = 41, .external_lex_state = 2},
  [1241] = {.lex_state = 41},
  [1242] = {.lex_state = 41},
  [1243] = {.lex_state = 41, .external_lex_state = 2},
  [1244] = {.lex_state = 41, .external_lex_state = 4},
  [1245] = {.lex_state = 50, .external_lex_state = 4},
  [1246] = {.lex_state = 41, .external_lex_state = 4},
  [1247] = {.lex_state = 41},
  [1248] = {.lex_state = 41, .external_lex_state = 4},
  [1249] = {.lex_state = 41, .external_lex_state = 2},
  [1250] = {.lex_state = 41},
  [1251] = {.lex_state = 41, .external_lex_state = 4},
  [1252] = {.lex_state = 41},
  [1253] = {.lex_state = 41, .external_lex_state = 4},
  [1254] = {.lex_state = 41, .external_lex_state = 4},
  [1255] = {.lex_state = 41, .external_lex_state = 2},
  [1256] = {.lex_state = 41},
  [1257] = {.lex_state = 41, .external_lex_state = 4},
  [1258] = {.lex_state = 41},
  [1259] = {.lex_state = 41},
  [1260] = {.lex_state = 41, .external_lex_state = 3},
  [1261] = {.lex_state = 50, .external_lex_state = 4},
  [1262] = {.lex_state = 41, .external_lex_state = 4},
  [1263] = {.lex_state = 41, .external_lex_state = 4},
  [1264] = {.lex_state = 41, .external_lex_state = 4},
  [1265] = {.lex_state = 41, .external_lex_state = 4},
  [1266] = {.lex_state = 41},
  [1267] = {.lex_state = 41, .external_lex_state = 2},
  [1268] = {.lex_state = 43},
  [1269] = {.lex_state = 41},
  [1270] = {.lex_state = 43, .external_lex_state = 3},
  [1271] = {.lex_state = 41},
  [1272] = {.lex_state = 41},
  [1273] = {.lex_state = 41, .external_lex_state = 4},
  [1274] = {.lex_state = 41},
  [1275] = {.lex_state = 41},
  [1276] = {.lex_state = 41},
  [1277] = {.lex_state = 41},
  [1278] = {.lex_state = 41},
  [1279] = {.lex_state = 41, .external_lex_state = 3},
  [1280] = {.lex_state = 41, .external_lex_state = 3},
  [1281] = {.lex_state = 50, .external_lex_state = 4},
  [1282] = {.lex_state = 41, .external_lex_state = 3},
  [1283] = {.lex_state = 49},
  [1284] = {.lex_state = 41},
  [1285] = {.lex_state = 41, .external_lex_state = 3},
  [1286] = {.lex_state = 43, .external_lex_state = 2},
  [1287] = {.lex_state = 50},
  [1288] = {.lex_state = 41},
  [1289] = {.lex_state = 41, .external_lex_state = 3},
  [1290] = {.lex_state = 49},
  [1291] = {.lex_state = 49},
  [1292] = {.lex_state = 41, .external_lex_state = 3},
  [1293] = {.lex_state = 41, .external_lex_state = 3},
  [1294] = {.lex_state = 41, .external_lex_state = 3},
  [1295] = {.lex_state = 41, .external_lex_state = 3},
  [1296] = {.lex_state = 43, .external_lex_state = 4},
  [1297] = {.lex_state = 41, .external_lex_state = 3},
  [1298] = {.lex_state = 41, .external_lex_state = 4},
  [1299] = {.lex_state = 41, .external_lex_state = 3},
  [1300] = {.lex_state = 41, .external_lex_state = 3},
  [1301] = {.lex_state = 41, .external_lex_state = 2},
  [1302] = {.lex_state = 41},
  [1303] = {.lex_state = 49},
  [1304] = {.lex_state = 50},
  [1305] = {.lex_state = 41},
  [1306] = {.lex_state = 50, .external_lex_state = 4},
  [1307] = {.lex_state = 50, .external_lex_state = 4},
  [1308] = {.lex_state = 50},
  [1309] = {.lex_state = 50, .external_lex_state = 4},
  [1310] = {.lex_state = 41, .external_lex_state = 4},
  [1311] = {.lex_state = 41, .external_lex_state = 4},
  [1312] = {.lex_state = 41, .external_lex_state = 2},
  [1313] = {.lex_state = 41, .external_lex_state = 4},
  [1314] = {.lex_state = 41, .external_lex_state = 2},
  [1315] = {.lex_state = 41, .external_lex_state = 2},
  [1316] = {.lex_state = 41},
  [1317] = {.lex_state = 41, .external_lex_state = 2},
  [1318] = {.lex_state = 41, .external_lex_state = 2},
  [1319] = {.lex_state = 41, .external_lex_state = 4},
  [1320] = {.lex_state = 41, .external_lex_state = 4},
  [1321] = {.lex_state = 52, .external_lex_state = 4},
  [1322] = {.lex_state = 41, .external_lex_state = 4},
  [1323] = {.lex_state = 41, .external_lex_state = 2},
  [1324] = {.lex_state = 50, .external_lex_state = 4},
  [1325] = {.lex_state = 41, .external_lex_state = 2},
  [1326] = {.lex_state = 41, .external_lex_state = 2},
  [1327] = {.lex_state = 50, .external_lex_state = 4},
  [1328] = {.lex_state = 41, .external_lex_state = 4},
  [1329] = {.lex_state = 41, .external_lex_state = 4},
  [1330] = {.lex_state = 41, .external_lex_state = 4},
  [1331] = {.lex_state = 43},
  [1332] = {.lex_state = 50},
  [1333] = {.lex_state = 41, .external_lex_state = 4},
  [1334] = {.lex_state = 41, .external_lex_state = 4},
  [1335] = {.lex_state = 41, .external_lex_state = 4},
  [1336] = {.lex_state = 41, .external_lex_state = 2},
  [1337] = {.lex_state = 50, .external_lex_state = 4},
  [1338] = {.lex_state = 50, .external_lex_state = 4},
  [1339] = {.lex_state = 50, .external_lex_state = 4},
  [1340] = {.lex_state = 50},
  [1341] = {.lex_state = 41},
  [1342] = {.lex_state = 50, .external_lex_state = 4},
  [1343] = {.lex_state = 50, .external_lex_state = 4},
  [1344] = {.lex_state = 50, .external_lex_state = 4},
  [1345] = {.lex_state = 50},
  [1346] = {.lex_state = 50, .external_lex_state = 4},
  [1347] = {.lex_state = 41},
  [1348] = {.lex_state = 50},
  [1349] = {.lex_state = 50, .external_lex_state = 4},
  [1350] = {.lex_state = 50, .external_lex_state = 4},
  [1351] = {.lex_state = 50, .external_lex_state = 4},
  [1352] = {.lex_state = 50, .external_lex_state = 4},
  [1353] = {.lex_state = 50, .external_lex_state = 4},
  [1354] = {.lex_state = 41},
  [1355] = {.lex_state = 50, .external_lex_state = 4},
  [1356] = {.lex_state = 41},
  [1357] = {.lex_state = 50},
  [1358] = {.lex_state = 50, .external_lex_state = 4},
  [1359] = {.lex_state = 41},
  [1360] = {.lex_state = 41},
  [1361] = {.lex_state = 41},
  [1362] = {.lex_state = 50, .external_lex_state = 4},
  [1363] = {.lex_state = 50, .external_lex_state = 4},
  [1364] = {.lex_state = 50, .external_lex_state = 4},
  [1365] = {.lex_state = 52},
  [1366] = {.lex_state = 50, .external_lex_state = 4},
  [1367] = {.lex_state = 50, .external_lex_state = 4},
  [1368] = {.lex_state = 50, .external_lex_state = 4},
  [1369] = {.lex_state = 50, .external_lex_state = 4},
  [1370] = {.lex_state = 50, .external_lex_state = 4},
  [1371] = {.lex_state = 50, .external_lex_state = 4},
  [1372] = {.lex_state = 50, .external_lex_state = 4},
  [1373] = {.lex_state = 50, .external_lex_state = 4},
  [1374] = {.lex_state = 50, .external_lex_state = 4},
  [1375] = {.lex_state = 50, .external_lex_state = 4},
  [1376] = {.lex_state = 50, .external_lex_state = 4},
  [1377] = {.lex_state = 50, .external_lex_state = 4},
  [1378] = {.lex_state = 50, .external_lex_state = 4},
  [1379] = {.lex_state = 50, .external_lex_state = 4},
  [1380] = {.lex_state = 41},
  [1381] = {.lex_state = 41},
  [1382] = {.lex_state = 50, .external_lex_state = 4},
  [1383] = {.lex_state = 50, .external_lex_state = 4},
  [1384] = {.lex_state = 41, .external_lex_state = 2},
  [1385] = {.lex_state = 50},
  [1386] = {.lex_state = 50},
  [1387] = {.lex_state = 50},
  [1388] = {.lex_state = 50},
  [1389] = {.lex_state = 41, .external_lex_state = 2},
  [1390] = {.lex_state = 41, .external_lex_state = 2},
  [1391] = {.lex_state = 41, .external_lex_state = 2},
  [1392] = {.lex_state = 41, .external_lex_state = 2},
  [1393] = {.lex_state = 50},
  [1394] = {.lex_state = 50},
  [1395] = {.lex_state = 50},
  [1396] = {.lex_state = 50},
  [1397] = {.lex_state = 50},
  [1398] = {.lex_state = 50},
  [1399] = {.lex_state = 50},
  [1400] = {.lex_state = 50},
  [1401] = {.lex_state = 50},
  [1402] = {.lex_state = 50},
  [1403] = {.lex_state = 50},
  [1404] = {.lex_state = 50},
  [1405] = {.lex_state = 100},
  [1406] = {.lex_state = 41},
  [1407] = {.lex_state = 100},
  [1408] = {.lex_state = 100},
  [1409] = {.lex_state = 41},
  [1410] = {.lex_state = 41},
  [1411] = {.lex_state = 41},
  [1412] = {.lex_state = 100},
  [1413] = {.lex_state = 100},
  [1414] = {.lex_state = 41},
  [1415] = {.lex_state = 100},
  [1416] = {.lex_state = 100},
  [1417] = {.lex_state = 100},
  [1418] = {.lex_state = 100},
  [1419] = {.lex_state = 100},
  [1420] = {.lex_state = 100},
  [1421] = {.lex_state = 50},
  [1422] = {.lex_state = 100},
  [1423] = {.lex_state = 50},
  [1424] = {.lex_state = 100},
  [1425] = {.lex_state = 50},
  [1426] = {.lex_state = 50},
  [1427] = {.lex_state = 50},
  [1428] = {.lex_state = 50},
  [1429] = {.lex_state = 50},
  [1430] = {.lex_state = 50},
  [1431] = {.lex_state = 50},
  [1432] = {.lex_state = 50},
  [1433] = {.lex_state = 50},
  [1434] = {.lex_state = 50},
  [1435] = {.lex_state = 50},
  [1436] = {.lex_state = 50},
  [1437] = {.lex_state = 50},
  [1438] = {.lex_state = 50},
  [1439] = {.lex_state = 50},
  [1440] = {.lex_state = 50},
  [1441] = {.lex_state = 50},
  [1442] = {.lex_state = 50},
  [1443] = {.lex_state = 50},
  [1444] = {.lex_state = 50},
  [1445] = {.lex_state = 50},
  [1446] = {.lex_state = 50},
  [1447] = {.lex_state = 50},
  [1448] = {.lex_state = 50},
  [1449] = {.lex_state = 50},
  [1450] = {.lex_state = 50},
  [1451] = {.lex_state = 50},
  [1452] = {.lex_state = 50},
  [1453] = {.lex_state = 50},
  [1454] = {.lex_state = 50},
  [1455] = {.lex_state = 50},
  [1456] = {.lex_state = 50},
  [1457] = {.lex_state = 50},
  [1458] = {.lex_state = 50},
  [1459] = {.lex_state = 50},
  [1460] = {.lex_state = 50},
  [1461] = {.lex_state = 50},
  [1462] = {.lex_state = 50},
  [1463] = {.lex_state = 50},
  [1464] = {.lex_state = 50},
  [1465] = {.lex_state = 50},
  [1466] = {.lex_state = 50},
  [1467] = {.lex_state = 50},
  [1468] = {.lex_state = 50},
  [1469] = {.lex_state = 50},
  [1470] = {.lex_state = 50},
  [1471] = {.lex_state = 50},
  [1472] = {.lex_state = 50},
  [1473] = {.lex_state = 50},
  [1474] = {.lex_state = 50},
  [1475] = {.lex_state = 50},
  [1476] = {.lex_state = 50},
  [1477] = {.lex_state = 50},
  [1478] = {.lex_state = 50},
  [1479] = {.lex_state = 50},
  [1480] = {.lex_state = 50},
  [1481] = {.lex_state = 50},
  [1482] = {.lex_state = 50},
  [1483] = {.lex_state = 50},
  [1484] = {.lex_state = 50},
  [1485] = {.lex_state = 50},
  [1486] = {.lex_state = 50},
  [1487] = {.lex_state = 50},
  [1488] = {.lex_state = 50},
  [1489] = {.lex_state = 50},
  [1490] = {.lex_state = 50},
  [1491] = {.lex_state = 50},
  [1492] = {.lex_state = 50},
  [1493] = {.lex_state = 50},
  [1494] = {.lex_state = 50},
  [1495] = {.lex_state = 50},
  [1496] = {.lex_state = 50},
  [1497] = {.lex_state = 50},
  [1498] = {.lex_state = 50},
  [1499] = {.lex_state = 50},
  [1500] = {.lex_state = 50},
  [1501] = {.lex_state = 50},
  [1502] = {.lex_state = 50},
  [1503] = {.lex_state = 50},
  [1504] = {.lex_state = 50},
  [1505] = {.lex_state = 50},
  [1506] = {.lex_state = 50},
  [1507] = {.lex_state = 50},
  [1508] = {.lex_state = 50},
  [1509] = {.lex_state = 50},
  [1510] = {.lex_state = 50},
  [1511] = {.lex_state = 50},
  [1512] = {.lex_state = 50},
  [1513] = {.lex_state = 50},
  [1514] = {.lex_state = 50},
  [1515] = {.lex_state = 50},
  [1516] = {.lex_state = 50},
  [1517] = {.lex_state = 50},
  [1518] = {.lex_state = 50},
  [1519] = {.lex_state = 50},
  [1520] = {.lex_state = 50},
  [1521] = {.lex_state = 50},
  [1522] = {.lex_state = 50},
  [1523] = {.lex_state = 50},
  [1524] = {.lex_state = 50},
  [1525] = {.lex_state = 50},
  [1526] = {.lex_state = 50},
  [1527] = {.lex_state = 50},
  [1528] = {.lex_state = 50},
  [1529] = {.lex_state = 50},
  [1530] = {.lex_state = 50},
  [1531] = {.lex_state = 50},
  [1532] = {.lex_state = 50},
  [1533] = {.lex_state = 50},
  [1534] = {.lex_state = 50},
  [1535] = {.lex_state = 50},
  [1536] = {.lex_state = 50},
  [1537] = {.lex_state = 50},
  [1538] = {.lex_state = 50},
  [1539] = {.lex_state = 50},
  [1540] = {.lex_state = 50},
  [1541] = {.lex_state = 50},
  [1542] = {.lex_state = 50},
  [1543] = {.lex_state = 49},
  [1544] = {.lex_state = 4, .external_lex_state = 2},
  [1545] = {.lex_state = 4},
  [1546] = {.lex_state = 4, .external_lex_state = 2},
  [1547] = {.lex_state = 4},
  [1548] = {.lex_state = 4, .external_lex_state = 2},
  [1549] = {.lex_state = 4, .external_lex_state = 2},
  [1550] = {.lex_state = 4, .external_lex_state = 2},
  [1551] = {.lex_state = 4, .external_lex_state = 2},
  [1552] = {.lex_state = 4},
  [1553] = {.lex_state = 0},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 100},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 100},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 100},
  [1563] = {.lex_state = 100},
  [1564] = {.lex_state = 100},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 100},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 100},
  [1570] = {.lex_state = 4},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 100},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 100},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 100},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 100},
  [1582] = {.lex_state = 100},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 100},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 100},
  [1588] = {.lex_state = 100},
  [1589] = {.lex_state = 100},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 100},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 100},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 100},
  [1596] = {.lex_state = 100},
  [1597] = {.lex_state = 100},
  [1598] = {.lex_state = 100},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 100},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 100},
  [1604] = {.lex_state = 100},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 54, .external_lex_state = 5},
  [1609] = {.lex_state = 54, .external_lex_state = 5},
  [1610] = {.lex_state = 54, .external_lex_state = 5},
  [1611] = {.lex_state = 54, .external_lex_state = 5},
  [1612] = {.lex_state = 54, .external_lex_state = 5},
  [1613] = {.lex_state = 54, .external_lex_state = 5},
  [1614] = {.lex_state = 4, .external_lex_state = 2},
  [1615] = {.lex_state = 4, .external_lex_state = 2},
  [1616] = {.lex_state = 54, .external_lex_state = 5},
  [1617] = {.lex_state = 54, .external_lex_state = 5},
  [1618] = {.lex_state = 54, .external_lex_state = 5},
  [1619] = {.lex_state = 54, .external_lex_state = 5},
  [1620] = {.lex_state = 4, .external_lex_state = 2},
  [1621] = {.lex_state = 4, .external_lex_state = 2},
  [1622] = {.lex_state = 54, .external_lex_state = 5},
  [1623] = {.lex_state = 54, .external_lex_state = 5},
  [1624] = {.lex_state = 54, .external_lex_state = 5},
  [1625] = {.lex_state = 54, .external_lex_state = 5},
  [1626] = {.lex_state = 54, .external_lex_state = 5},
  [1627] = {.lex_state = 54, .external_lex_state = 5},
  [1628] = {.lex_state = 54, .external_lex_state = 5},
  [1629] = {.lex_state = 54, .external_lex_state = 5},
  [1630] = {.lex_state = 54, .external_lex_state = 5},
  [1631] = {.lex_state = 54, .external_lex_state = 5},
  [1632] = {.lex_state = 54, .external_lex_state = 5},
  [1633] = {.lex_state = 0},
  [1634] = {.lex_state = 54, .external_lex_state = 5},
  [1635] = {.lex_state = 0},
  [1636] = {.lex_state = 0},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 4},
  [1640] = {.lex_state = 0},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 4},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 0},
  [1647] = {.lex_state = 0},
  [1648] = {.lex_state = 0},
  [1649] = {.lex_state = 0},
  [1650] = {.lex_state = 0},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 0},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 0},
  [1655] = {.lex_state = 0},
  [1656] = {.lex_state = 0},
  [1657] = {.lex_state = 0},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 0},
  [1662] = {.lex_state = 0},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 0},
  [1666] = {.lex_state = 0},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 0},
  [1669] = {.lex_state = 0},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 0},
  [1672] = {.lex_state = 0},
  [1673] = {.lex_state = 0},
  [1674] = {.lex_state = 0},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 0},
  [1678] = {.lex_state = 0},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 0},
  [1681] = {.lex_state = 0},
  [1682] = {.lex_state = 0},
  [1683] = {.lex_state = 0},
  [1684] = {.lex_state = 0},
  [1685] = {.lex_state = 0},
  [1686] = {.lex_state = 0},
  [1687] = {.lex_state = 0},
  [1688] = {.lex_state = 0},
  [1689] = {.lex_state = 0},
  [1690] = {.lex_state = 0},
  [1691] = {.lex_state = 0},
  [1692] = {.lex_state = 0},
  [1693] = {.lex_state = 0},
  [1694] = {.lex_state = 0},
  [1695] = {.lex_state = 0},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 0},
  [1698] = {.lex_state = 0},
  [1699] = {.lex_state = 0},
  [1700] = {.lex_state = 0},
  [1701] = {.lex_state = 0},
  [1702] = {.lex_state = 100},
  [1703] = {.lex_state = 0},
  [1704] = {.lex_state = 0},
  [1705] = {.lex_state = 0},
  [1706] = {.lex_state = 0},
  [1707] = {.lex_state = 0},
  [1708] = {.lex_state = 0},
  [1709] = {.lex_state = 56},
  [1710] = {.lex_state = 0},
  [1711] = {.lex_state = 0},
  [1712] = {.lex_state = 0},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 0},
  [1715] = {.lex_state = 0},
  [1716] = {.lex_state = 0},
  [1717] = {.lex_state = 0, .external_lex_state = 6},
  [1718] = {.lex_state = 0, .external_lex_state = 6},
  [1719] = {.lex_state = 0},
  [1720] = {.lex_state = 100},
  [1721] = {.lex_state = 0},
  [1722] = {.lex_state = 0},
  [1723] = {.lex_state = 0},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 100},
  [1727] = {.lex_state = 100},
  [1728] = {.lex_state = 100},
  [1729] = {.lex_state = 0},
  [1730] = {.lex_state = 171},
  [1731] = {.lex_state = 171},
  [1732] = {.lex_state = 171},
  [1733] = {.lex_state = 171},
  [1734] = {.lex_state = 171},
  [1735] = {.lex_state = 171},
  [1736] = {.lex_state = 171},
  [1737] = {.lex_state = 171},
  [1738] = {.lex_state = 171},
  [1739] = {.lex_state = 0, .external_lex_state = 6},
  [1740] = {.lex_state = 171},
  [1741] = {.lex_state = 0, .external_lex_state = 6},
  [1742] = {.lex_state = 171},
  [1743] = {.lex_state = 0, .external_lex_state = 6},
  [1744] = {.lex_state = 0},
  [1745] = {.lex_state = 171},
  [1746] = {.lex_state = 0, .external_lex_state = 6},
  [1747] = {.lex_state = 0},
  [1748] = {.lex_state = 171},
  [1749] = {.lex_state = 0, .external_lex_state = 6},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 100},
  [1752] = {.lex_state = 171},
  [1753] = {.lex_state = 0, .external_lex_state = 6},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 171},
  [1756] = {.lex_state = 0, .external_lex_state = 6},
  [1757] = {.lex_state = 0},
  [1758] = {.lex_state = 171},
  [1759] = {.lex_state = 0, .external_lex_state = 6},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 171},
  [1762] = {.lex_state = 0, .external_lex_state = 6},
  [1763] = {.lex_state = 0},
  [1764] = {.lex_state = 171},
  [1765] = {.lex_state = 0, .external_lex_state = 6},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 194},
  [1768] = {.lex_state = 171},
  [1769] = {.lex_state = 56},
  [1770] = {.lex_state = 0, .external_lex_state = 6},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 171},
  [1773] = {.lex_state = 0, .external_lex_state = 6},
  [1774] = {.lex_state = 0},
  [1775] = {.lex_state = 171},
  [1776] = {.lex_state = 0, .external_lex_state = 6},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 171},
  [1779] = {.lex_state = 0, .external_lex_state = 6},
  [1780] = {.lex_state = 0},
  [1781] = {.lex_state = 171},
  [1782] = {.lex_state = 0, .external_lex_state = 6},
  [1783] = {.lex_state = 0},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 56},
  [1786] = {.lex_state = 0},
  [1787] = {.lex_state = 0, .external_lex_state = 6},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 171},
  [1790] = {.lex_state = 56},
  [1791] = {.lex_state = 56},
  [1792] = {.lex_state = 56},
  [1793] = {.lex_state = 56},
  [1794] = {.lex_state = 0},
  [1795] = {.lex_state = 100},
  [1796] = {.lex_state = 56},
  [1797] = {.lex_state = 100},
  [1798] = {.lex_state = 56},
  [1799] = {.lex_state = 56},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 56},
  [1803] = {.lex_state = 0},
  [1804] = {.lex_state = 0},
  [1805] = {.lex_state = 0},
  [1806] = {.lex_state = 0},
  [1807] = {.lex_state = 0},
  [1808] = {.lex_state = 0},
  [1809] = {.lex_state = 0},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 0},
  [1812] = {.lex_state = 0},
  [1813] = {.lex_state = 0},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 0},
  [1816] = {.lex_state = 100},
  [1817] = {.lex_state = 100},
  [1818] = {.lex_state = 100},
  [1819] = {.lex_state = 100},
  [1820] = {.lex_state = 0},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 56},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 56},
  [1825] = {.lex_state = 0},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 56},
  [1829] = {.lex_state = 0},
  [1830] = {.lex_state = 0},
  [1831] = {.lex_state = 0},
  [1832] = {.lex_state = 56},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 0},
  [1836] = {.lex_state = 56},
  [1837] = {.lex_state = 0},
  [1838] = {.lex_state = 0},
  [1839] = {.lex_state = 0},
  [1840] = {.lex_state = 100},
  [1841] = {.lex_state = 100},
  [1842] = {.lex_state = 56},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 0},
  [1846] = {.lex_state = 100},
  [1847] = {.lex_state = 56},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 56},
  [1851] = {.lex_state = 0},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 56},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 56},
  [1860] = {.lex_state = 0},
  [1861] = {.lex_state = 0},
  [1862] = {.lex_state = 0},
  [1863] = {.lex_state = 0},
  [1864] = {.lex_state = 56},
  [1865] = {.lex_state = 0},
  [1866] = {.lex_state = 0},
  [1867] = {.lex_state = 0},
  [1868] = {.lex_state = 56},
  [1869] = {.lex_state = 0},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 56},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 100},
  [1875] = {.lex_state = 100},
  [1876] = {.lex_state = 100},
  [1877] = {.lex_state = 0},
  [1878] = {.lex_state = 0},
  [1879] = {.lex_state = 56},
  [1880] = {.lex_state = 56},
  [1881] = {.lex_state = 0},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 0},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 171},
  [1887] = {.lex_state = 0},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 100},
  [1890] = {.lex_state = 100},
  [1891] = {.lex_state = 100},
  [1892] = {.lex_state = 0},
  [1893] = {.lex_state = 100},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 100},
  [1896] = {.lex_state = 100},
  [1897] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_concatenating_space = 0,
  ts_external_token__if_else_separator = 1,
  ts_external_token__ambiguous_comment = 2,
  ts_external_token__no_space = 3,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_concatenating_space] = sym_concatenating_space,
  [ts_external_token__if_else_separator] = sym__if_else_separator,
  [ts_external_token__ambiguous_comment] = sym__ambiguous_comment,
  [ts_external_token__no_space] = sym__no_space,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_concatenating_space] = true,
    [ts_external_token__if_else_separator] = true,
    [ts_external_token__ambiguous_comment] = true,
    [ts_external_token__no_space] = true,
  },
  [2] = {
    [ts_external_token__if_else_separator] = true,
  },
  [3] = {
    [ts_external_token_concatenating_space] = true,
    [ts_external_token__if_else_separator] = true,
  },
  [4] = {
    [ts_external_token_concatenating_space] = true,
  },
  [5] = {
    [ts_external_token__ambiguous_comment] = true,
  },
  [6] = {
    [ts_external_token__no_space] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_BEGIN] = ACTIONS(1),
    [anon_sym_END] = ACTIONS(1),
    [anon_sym_BEGINFILE] = ACTIONS(1),
    [anon_sym_ENDFILE] = ACTIONS(1),
    [anon_sym_ATinclude] = ACTIONS(1),
    [anon_sym_ATload] = ACTIONS(1),
    [anon_sym_ATnamespace] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_exit] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_getline] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_next_statement] = ACTIONS(1),
    [sym_nextfile_statement] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_printf] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG_TILDE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(3),
    [sym_concatenating_space] = ACTIONS(1),
    [sym__if_else_separator] = ACTIONS(1),
    [sym__ambiguous_comment] = ACTIONS(1),
    [sym__no_space] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1863),
    [sym_rule] = STATE(1418),
    [sym_pattern] = STATE(1408),
    [sym_range_pattern] = STATE(1415),
    [sym__special_pattern] = STATE(1415),
    [sym_directive] = STATE(1418),
    [sym__getline_exp] = STATE(503),
    [sym_getline_input] = STATE(513),
    [sym_getline_file] = STATE(513),
    [sym_block] = STATE(1422),
    [sym__exp] = STATE(514),
    [sym_ternary_exp] = STATE(471),
    [sym_binary_exp] = STATE(471),
    [sym_unary_exp] = STATE(471),
    [sym_update_exp] = STATE(503),
    [sym_assignment_exp] = STATE(503),
    [sym_piped_io_exp] = STATE(503),
    [sym_string_concat] = STATE(471),
    [sym_field_ref] = STATE(415),
    [sym_array_ref] = STATE(409),
    [sym_regex] = STATE(503),
    [sym_regex_constant] = STATE(503),
    [sym_grouping] = STATE(471),
    [sym__primitive] = STATE(471),
    [sym_namespace] = STATE(1853),
    [sym_ns_qualified_name] = STATE(348),
    [sym_string] = STATE(479),
    [sym_func_def] = STATE(1418),
    [sym_func_call] = STATE(471),
    [sym_indirect_func_call] = STATE(503),
    [sym_comment] = STATE(1),
    [aux_sym_program_repeat1] = STATE(305),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_BEGIN] = ACTIONS(9),
    [anon_sym_END] = ACTIONS(9),
    [anon_sym_BEGINFILE] = ACTIONS(9),
    [anon_sym_ENDFILE] = ACTIONS(9),
    [anon_sym_ATinclude] = ACTIONS(11),
    [anon_sym_ATload] = ACTIONS(11),
    [anon_sym_ATnamespace] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_getline] = ACTIONS(17),
    [anon_sym_SLASH] = ACTIONS(19),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_PLUS_PLUS] = ACTIONS(25),
    [anon_sym_DASH_DASH] = ACTIONS(25),
    [anon_sym_DOLLAR] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(29),
    [sym_number] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_function] = ACTIONS(35),
    [anon_sym_func] = ACTIONS(35),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [2] = {
    [sym__statement] = STATE(1044),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(2),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_SEMI] = ACTIONS(39),
    [anon_sym_LF] = ACTIONS(39),
    [anon_sym_CR_LF] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_RBRACE] = ACTIONS(39),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_default] = ACTIONS(39),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(69),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DOLLAR] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_POUND] = ACTIONS(83),
    [sym__if_else_separator] = ACTIONS(85),
  },
  [3] = {
    [sym__statement] = STATE(1044),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(3),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_SEMI] = ACTIONS(39),
    [anon_sym_LF] = ACTIONS(39),
    [anon_sym_CR_LF] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(39),
    [sym_break_statement] = ACTIONS(39),
    [sym_continue_statement] = ACTIONS(39),
    [anon_sym_delete] = ACTIONS(39),
    [anon_sym_exit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_switch] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(39),
    [anon_sym_getline] = ACTIONS(39),
    [sym_next_statement] = ACTIONS(39),
    [sym_nextfile_statement] = ACTIONS(39),
    [anon_sym_print] = ACTIONS(39),
    [anon_sym_printf] = ACTIONS(39),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_PLUS_PLUS] = ACTIONS(39),
    [anon_sym_DASH_DASH] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [anon_sym_AT] = ACTIONS(39),
    [sym_number] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_POUND] = ACTIONS(83),
    [sym__if_else_separator] = ACTIONS(85),
  },
  [4] = {
    [sym__statement] = STATE(1098),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(4),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_SEMI] = ACTIONS(39),
    [anon_sym_LF] = ACTIONS(39),
    [anon_sym_CR_LF] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_RBRACE] = ACTIONS(39),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_default] = ACTIONS(39),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(117),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(119),
    [anon_sym_PLUS_PLUS] = ACTIONS(121),
    [anon_sym_DASH_DASH] = ACTIONS(121),
    [anon_sym_DOLLAR] = ACTIONS(123),
    [anon_sym_AT] = ACTIONS(125),
    [sym_number] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [anon_sym_POUND] = ACTIONS(83),
  },
  [5] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(5),
    [aux_sym_block_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(147),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [6] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(6),
    [aux_sym_block_repeat1] = STATE(8),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(171),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [7] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(7),
    [aux_sym_block_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(173),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [8] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(8),
    [aux_sym_block_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(175),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [9] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(9),
    [aux_sym_block_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(177),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [10] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(10),
    [aux_sym_block_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(179),
    [anon_sym_if] = ACTIONS(182),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(188),
    [anon_sym_do] = ACTIONS(191),
    [anon_sym_for] = ACTIONS(194),
    [sym_break_statement] = ACTIONS(197),
    [sym_continue_statement] = ACTIONS(197),
    [anon_sym_delete] = ACTIONS(200),
    [anon_sym_exit] = ACTIONS(203),
    [anon_sym_return] = ACTIONS(206),
    [anon_sym_switch] = ACTIONS(209),
    [anon_sym_LBRACE] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(215),
    [anon_sym_getline] = ACTIONS(217),
    [sym_next_statement] = ACTIONS(220),
    [sym_nextfile_statement] = ACTIONS(220),
    [anon_sym_print] = ACTIONS(223),
    [anon_sym_printf] = ACTIONS(226),
    [anon_sym_SLASH] = ACTIONS(229),
    [anon_sym_PLUS] = ACTIONS(232),
    [anon_sym_DASH] = ACTIONS(232),
    [anon_sym_BANG] = ACTIONS(235),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_DOLLAR] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(244),
    [sym_number] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(250),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [11] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(11),
    [aux_sym_block_repeat1] = STATE(9),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [12] = {
    [sym__statement] = STATE(1098),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(12),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_SEMI] = ACTIONS(39),
    [anon_sym_LF] = ACTIONS(39),
    [anon_sym_CR_LF] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(39),
    [sym_break_statement] = ACTIONS(39),
    [sym_continue_statement] = ACTIONS(39),
    [anon_sym_delete] = ACTIONS(39),
    [anon_sym_exit] = ACTIONS(39),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_switch] = ACTIONS(39),
    [anon_sym_LBRACE] = ACTIONS(39),
    [anon_sym_RBRACE] = ACTIONS(39),
    [anon_sym_getline] = ACTIONS(39),
    [sym_next_statement] = ACTIONS(39),
    [sym_nextfile_statement] = ACTIONS(39),
    [anon_sym_print] = ACTIONS(39),
    [anon_sym_printf] = ACTIONS(39),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_PLUS_PLUS] = ACTIONS(39),
    [anon_sym_DASH_DASH] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [anon_sym_AT] = ACTIONS(39),
    [sym_number] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_POUND] = ACTIONS(83),
  },
  [13] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(13),
    [aux_sym_block_repeat1] = STATE(10),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [14] = {
    [sym__statement] = STATE(1183),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1283),
    [sym__block_content] = STATE(1290),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(14),
    [aux_sym_block_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(145),
    [anon_sym_RBRACE] = ACTIONS(257),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [15] = {
    [sym__statement] = STATE(1044),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(15),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_SEMI] = ACTIONS(39),
    [anon_sym_LF] = ACTIONS(39),
    [anon_sym_CR_LF] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(275),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_PLUS_PLUS] = ACTIONS(279),
    [anon_sym_DASH_DASH] = ACTIONS(279),
    [anon_sym_DOLLAR] = ACTIONS(281),
    [anon_sym_AT] = ACTIONS(283),
    [sym_number] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [anon_sym_POUND] = ACTIONS(83),
    [sym__if_else_separator] = ACTIONS(85),
  },
  [16] = {
    [sym__statement] = STATE(1621),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1620),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(16),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_SEMI] = ACTIONS(285),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [17] = {
    [sym__statement] = STATE(1615),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1614),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(17),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_SEMI] = ACTIONS(307),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [18] = {
    [sym__statement] = STATE(1550),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1551),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(18),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [19] = {
    [sym__statement] = STATE(1144),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1149),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(19),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_SEMI] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [20] = {
    [sym__statement] = STATE(1570),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(20),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_case] = ACTIONS(363),
    [anon_sym_default] = ACTIONS(363),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [21] = {
    [sym__statement] = STATE(1145),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1146),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(21),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [22] = {
    [sym__statement] = STATE(1549),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1548),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(22),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_SEMI] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [23] = {
    [sym__statement] = STATE(1098),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(23),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(39),
    [anon_sym_LF] = ACTIONS(39),
    [anon_sym_CR_LF] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(399),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DOLLAR] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(407),
    [sym_number] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [anon_sym_POUND] = ACTIONS(83),
  },
  [24] = {
    [sym__statement] = STATE(1050),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1047),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(24),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [25] = {
    [sym__statement] = STATE(1092),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1091),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(25),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [26] = {
    [sym__statement] = STATE(1104),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1105),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(26),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [27] = {
    [sym__statement] = STATE(1102),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1103),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(27),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [28] = {
    [sym__statement] = STATE(1060),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1051),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(28),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [29] = {
    [sym__statement] = STATE(1062),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1061),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(29),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [30] = {
    [sym__statement] = STATE(1067),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1065),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(30),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [31] = {
    [sym__statement] = STATE(1074),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1073),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(31),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [32] = {
    [sym__statement] = STATE(1129),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1093),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(32),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [33] = {
    [sym__statement] = STATE(1077),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1076),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(33),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [34] = {
    [sym__statement] = STATE(1081),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1079),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(34),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [35] = {
    [sym__statement] = STATE(1083),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1082),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(35),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [36] = {
    [sym__statement] = STATE(1088),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1087),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(36),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [37] = {
    [sym__statement] = STATE(1136),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1132),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(37),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [38] = {
    [sym__statement] = STATE(1109),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1117),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(38),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [39] = {
    [sym__statement] = STATE(1092),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1091),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(39),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [40] = {
    [sym__statement] = STATE(1129),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1093),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(40),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [41] = {
    [sym__statement] = STATE(1128),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1113),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(41),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [42] = {
    [sym__statement] = STATE(1639),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1713),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(42),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [43] = {
    [sym__statement] = STATE(1136),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1132),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(43),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [44] = {
    [sym__statement] = STATE(1128),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1113),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(44),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [45] = {
    [sym__statement] = STATE(1109),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1117),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(45),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [46] = {
    [sym__statement] = STATE(1111),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1120),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(46),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [47] = {
    [sym__statement] = STATE(1123),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1112),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(47),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [48] = {
    [sym__statement] = STATE(1115),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1116),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(48),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [49] = {
    [sym__statement] = STATE(1107),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1100),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(49),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [50] = {
    [sym__statement] = STATE(1001),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1042),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(50),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [51] = {
    [sym__statement] = STATE(1104),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1105),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(51),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [52] = {
    [sym__statement] = STATE(1102),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1103),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(52),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [53] = {
    [sym__statement] = STATE(1111),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1120),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(53),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [54] = {
    [sym__statement] = STATE(1127),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1122),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(54),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [55] = {
    [sym__statement] = STATE(1001),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1042),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(55),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [56] = {
    [sym__statement] = STATE(1643),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1821),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(56),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [57] = {
    [sym__statement] = STATE(1060),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1051),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(57),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [58] = {
    [sym__statement] = STATE(1062),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1061),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(58),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [59] = {
    [sym__statement] = STATE(1067),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1065),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(59),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [60] = {
    [sym__statement] = STATE(1074),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1073),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(60),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [61] = {
    [sym__statement] = STATE(1127),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1122),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(61),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [62] = {
    [sym__statement] = STATE(1115),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1116),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(62),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [63] = {
    [sym__statement] = STATE(1077),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1076),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(63),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [64] = {
    [sym__statement] = STATE(1081),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1079),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(64),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [65] = {
    [sym__statement] = STATE(1083),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1082),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(65),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [66] = {
    [sym__statement] = STATE(1123),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1112),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(66),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [67] = {
    [sym__statement] = STATE(1127),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1122),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(67),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [68] = {
    [sym__statement] = STATE(1088),
    [sym__statement_separated] = STATE(15),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1546),
    [sym_printf_statement] = STATE(1546),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1087),
    [sym__exp] = STATE(1391),
    [sym_ternary_exp] = STATE(1279),
    [sym_binary_exp] = STATE(1279),
    [sym_unary_exp] = STATE(1279),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1279),
    [sym_field_ref] = STATE(595),
    [sym_array_ref] = STATE(576),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1279),
    [sym__primitive] = STATE(1279),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(551),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1279),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(68),
    [sym_identifier] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(289),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(263),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(269),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(271),
    [anon_sym_printf] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(293),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(295),
    [anon_sym_PLUS_PLUS] = ACTIONS(297),
    [anon_sym_DASH_DASH] = ACTIONS(297),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [69] = {
    [sym__statement] = STATE(1107),
    [sym__statement_separated] = STATE(12),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(391),
    [sym_getline_input] = STATE(392),
    [sym_getline_file] = STATE(392),
    [sym_print_statement] = STATE(703),
    [sym_printf_statement] = STATE(703),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1100),
    [sym__exp] = STATE(435),
    [sym_ternary_exp] = STATE(381),
    [sym_binary_exp] = STATE(381),
    [sym_unary_exp] = STATE(381),
    [sym_update_exp] = STATE(391),
    [sym_assignment_exp] = STATE(391),
    [sym_piped_io_exp] = STATE(391),
    [sym_string_concat] = STATE(381),
    [sym_field_ref] = STATE(208),
    [sym_array_ref] = STATE(203),
    [sym_regex] = STATE(391),
    [sym_regex_constant] = STATE(391),
    [sym_grouping] = STATE(381),
    [sym__primitive] = STATE(381),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(182),
    [sym_string] = STATE(330),
    [sym_func_call] = STATE(381),
    [sym_indirect_func_call] = STATE(391),
    [sym_comment] = STATE(69),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(135),
    [anon_sym_while] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(139),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(141),
    [anon_sym_return] = ACTIONS(143),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(149),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(151),
    [anon_sym_printf] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(155),
    [anon_sym_PLUS] = ACTIONS(157),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_BANG] = ACTIONS(159),
    [anon_sym_PLUS_PLUS] = ACTIONS(161),
    [anon_sym_DASH_DASH] = ACTIONS(161),
    [anon_sym_DOLLAR] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(165),
    [sym_number] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(169),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [70] = {
    [sym__statement] = STATE(1001),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1042),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(70),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [71] = {
    [sym__statement] = STATE(1111),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1120),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(71),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [72] = {
    [sym__statement] = STATE(1092),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1091),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(72),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [73] = {
    [sym__statement] = STATE(1088),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1087),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(73),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [74] = {
    [sym__statement] = STATE(1129),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1093),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(74),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [75] = {
    [sym__statement] = STATE(1083),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1082),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(75),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [76] = {
    [sym__statement] = STATE(1081),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1079),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(76),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [77] = {
    [sym__statement] = STATE(1050),
    [sym__statement_separated] = STATE(2),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(1194),
    [sym_getline_input] = STATE(1196),
    [sym_getline_file] = STATE(1196),
    [sym_print_statement] = STATE(1544),
    [sym_printf_statement] = STATE(1544),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1047),
    [sym__exp] = STATE(1325),
    [sym_ternary_exp] = STATE(1222),
    [sym_binary_exp] = STATE(1222),
    [sym_unary_exp] = STATE(1222),
    [sym_update_exp] = STATE(1194),
    [sym_assignment_exp] = STATE(1194),
    [sym_piped_io_exp] = STATE(1194),
    [sym_string_concat] = STATE(1222),
    [sym_field_ref] = STATE(550),
    [sym_array_ref] = STATE(534),
    [sym_regex] = STATE(1194),
    [sym_regex_constant] = STATE(1194),
    [sym_grouping] = STATE(1222),
    [sym__primitive] = STATE(1222),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(522),
    [sym_string] = STATE(1178),
    [sym_func_call] = STATE(1222),
    [sym_indirect_func_call] = STATE(1194),
    [sym_comment] = STATE(77),
    [sym_identifier] = ACTIONS(37),
    [anon_sym_if] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(55),
    [anon_sym_return] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(61),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(65),
    [anon_sym_printf] = ACTIONS(67),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(313),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_DOLLAR] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(319),
    [sym_number] = ACTIONS(303),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [78] = {
    [sym__statement] = STATE(1050),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1047),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(78),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [79] = {
    [sym__statement] = STATE(1077),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1076),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(79),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [80] = {
    [sym__statement] = STATE(1074),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1073),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(80),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [81] = {
    [sym__statement] = STATE(1136),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1132),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(81),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [82] = {
    [sym__statement] = STATE(1060),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1051),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(82),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [83] = {
    [sym__statement] = STATE(1102),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1103),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(83),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [84] = {
    [sym__statement] = STATE(1067),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1065),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(84),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [85] = {
    [sym__statement] = STATE(1128),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1113),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(85),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [86] = {
    [sym__statement] = STATE(1109),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1117),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(86),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [87] = {
    [sym__statement] = STATE(1123),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1112),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(87),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [88] = {
    [sym__statement] = STATE(1115),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1116),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(88),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [89] = {
    [sym__statement] = STATE(1104),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1105),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(89),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [90] = {
    [sym__statement] = STATE(1062),
    [sym__statement_separated] = STATE(3),
    [sym__control_statement] = STATE(1052),
    [sym_if_statement] = STATE(1037),
    [sym_while_statement] = STATE(1037),
    [sym_do_while_statement] = STATE(1037),
    [sym_for_statement] = STATE(1037),
    [sym_for_in_statement] = STATE(1037),
    [sym_delete_statement] = STATE(1037),
    [sym_exit_statement] = STATE(1037),
    [sym_return_statement] = STATE(1037),
    [sym_switch_statement] = STATE(1037),
    [sym__io_statement] = STATE(1052),
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym_print_statement] = STATE(665),
    [sym_printf_statement] = STATE(665),
    [sym_redirected_io_statement] = STATE(1046),
    [sym_piped_io_statement] = STATE(1046),
    [sym_block] = STATE(1061),
    [sym__exp] = STATE(419),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(90),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(331),
    [sym_break_statement] = ACTIONS(51),
    [sym_continue_statement] = ACTIONS(51),
    [anon_sym_delete] = ACTIONS(53),
    [anon_sym_exit] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(335),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(63),
    [sym_nextfile_statement] = ACTIONS(63),
    [anon_sym_print] = ACTIONS(339),
    [anon_sym_printf] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(343),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(347),
    [anon_sym_PLUS_PLUS] = ACTIONS(349),
    [anon_sym_DASH_DASH] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(351),
    [anon_sym_AT] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [91] = {
    [sym__statement] = STATE(1107),
    [sym__statement_separated] = STATE(23),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1547),
    [sym_printf_statement] = STATE(1547),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym_block] = STATE(1100),
    [sym__exp] = STATE(1411),
    [sym_ternary_exp] = STATE(1320),
    [sym_binary_exp] = STATE(1320),
    [sym_unary_exp] = STATE(1320),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1320),
    [sym_field_ref] = STATE(669),
    [sym_array_ref] = STATE(624),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1320),
    [sym__primitive] = STATE(1320),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(587),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1320),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(91),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(411),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(387),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(389),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_LBRACE] = ACTIONS(409),
    [anon_sym_getline] = ACTIONS(393),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(395),
    [anon_sym_printf] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(421),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [92] = {
    [sym__statement] = STATE(1552),
    [sym__statement_separated] = STATE(4),
    [sym__control_statement] = STATE(1095),
    [sym_if_statement] = STATE(1108),
    [sym_while_statement] = STATE(1108),
    [sym_do_while_statement] = STATE(1108),
    [sym_for_statement] = STATE(1108),
    [sym_for_in_statement] = STATE(1108),
    [sym_delete_statement] = STATE(1108),
    [sym_exit_statement] = STATE(1108),
    [sym_return_statement] = STATE(1108),
    [sym_switch_statement] = STATE(1108),
    [sym__io_statement] = STATE(1095),
    [sym__getline_exp] = STATE(1256),
    [sym_getline_input] = STATE(1247),
    [sym_getline_file] = STATE(1247),
    [sym_print_statement] = STATE(1545),
    [sym_printf_statement] = STATE(1545),
    [sym_redirected_io_statement] = STATE(1131),
    [sym_piped_io_statement] = STATE(1131),
    [sym__exp] = STATE(1341),
    [sym_ternary_exp] = STATE(1248),
    [sym_binary_exp] = STATE(1248),
    [sym_unary_exp] = STATE(1248),
    [sym_update_exp] = STATE(1256),
    [sym_assignment_exp] = STATE(1256),
    [sym_piped_io_exp] = STATE(1256),
    [sym_string_concat] = STATE(1248),
    [sym_field_ref] = STATE(572),
    [sym_array_ref] = STATE(552),
    [sym_regex] = STATE(1256),
    [sym_regex_constant] = STATE(1256),
    [sym_grouping] = STATE(1248),
    [sym__primitive] = STATE(1248),
    [sym_namespace] = STATE(1729),
    [sym_ns_qualified_name] = STATE(532),
    [sym_string] = STATE(1232),
    [sym_func_call] = STATE(1248),
    [sym_indirect_func_call] = STATE(1256),
    [sym_comment] = STATE(92),
    [sym_identifier] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_while] = ACTIONS(93),
    [anon_sym_do] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [sym_break_statement] = ACTIONS(99),
    [sym_continue_statement] = ACTIONS(99),
    [anon_sym_delete] = ACTIONS(101),
    [anon_sym_exit] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_switch] = ACTIONS(107),
    [anon_sym_getline] = ACTIONS(109),
    [sym_next_statement] = ACTIONS(111),
    [sym_nextfile_statement] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_printf] = ACTIONS(115),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(369),
    [anon_sym_DASH_DASH] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(373),
    [sym_number] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [93] = {
    [sym_comment] = STATE(93),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(425),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [94] = {
    [sym_comment] = STATE(94),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(425),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(435),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [95] = {
    [sym_comment] = STATE(95),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_COMMA] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_CR_LF] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_in] = ACTIONS(441),
    [sym_break_statement] = ACTIONS(441),
    [sym_continue_statement] = ACTIONS(441),
    [anon_sym_delete] = ACTIONS(441),
    [anon_sym_exit] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_RBRACE] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_getline] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(441),
    [sym_next_statement] = ACTIONS(441),
    [sym_nextfile_statement] = ACTIONS(441),
    [anon_sym_print] = ACTIONS(441),
    [anon_sym_printf] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_STAR_STAR] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_LT_EQ] = ACTIONS(441),
    [anon_sym_GT_EQ] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(441),
    [anon_sym_BANG_EQ] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG_TILDE] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(441),
    [anon_sym_PIPE_PIPE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS_PLUS] = ACTIONS(441),
    [anon_sym_DASH_DASH] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(441),
    [anon_sym_DASH_EQ] = ACTIONS(441),
    [anon_sym_STAR_EQ] = ACTIONS(441),
    [anon_sym_SLASH_EQ] = ACTIONS(441),
    [anon_sym_PERCENT_EQ] = ACTIONS(441),
    [anon_sym_CARET_EQ] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(443),
    [sym__if_else_separator] = ACTIONS(443),
  },
  [96] = {
    [sym_comment] = STATE(96),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(445),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(435),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
  },
  [97] = {
    [sym_comment] = STATE(97),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(445),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
  },
  [98] = {
    [sym_comment] = STATE(98),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(425),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [99] = {
    [sym_comment] = STATE(99),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(451),
    [anon_sym_SEMI] = ACTIONS(451),
    [anon_sym_LF] = ACTIONS(451),
    [anon_sym_CR_LF] = ACTIONS(451),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_do] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_in] = ACTIONS(451),
    [sym_break_statement] = ACTIONS(451),
    [sym_continue_statement] = ACTIONS(451),
    [anon_sym_delete] = ACTIONS(451),
    [anon_sym_exit] = ACTIONS(451),
    [anon_sym_return] = ACTIONS(451),
    [anon_sym_switch] = ACTIONS(451),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_RBRACE] = ACTIONS(451),
    [anon_sym_case] = ACTIONS(451),
    [anon_sym_default] = ACTIONS(451),
    [anon_sym_getline] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(451),
    [sym_next_statement] = ACTIONS(451),
    [sym_nextfile_statement] = ACTIONS(451),
    [anon_sym_print] = ACTIONS(451),
    [anon_sym_LPAREN2] = ACTIONS(453),
    [anon_sym_printf] = ACTIONS(451),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_GT_GT] = ACTIONS(451),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PIPE_AMP] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(451),
    [anon_sym_STAR_STAR] = ACTIONS(451),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_SLASH] = ACTIONS(451),
    [anon_sym_PERCENT] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(451),
    [anon_sym_DASH] = ACTIONS(451),
    [anon_sym_LT_EQ] = ACTIONS(451),
    [anon_sym_GT_EQ] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(451),
    [anon_sym_BANG_TILDE] = ACTIONS(451),
    [anon_sym_AMP_AMP] = ACTIONS(451),
    [anon_sym_PIPE_PIPE] = ACTIONS(451),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS_PLUS] = ACTIONS(451),
    [anon_sym_DASH_DASH] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(451),
    [anon_sym_PLUS_EQ] = ACTIONS(451),
    [anon_sym_DASH_EQ] = ACTIONS(451),
    [anon_sym_STAR_EQ] = ACTIONS(451),
    [anon_sym_SLASH_EQ] = ACTIONS(451),
    [anon_sym_PERCENT_EQ] = ACTIONS(451),
    [anon_sym_CARET_EQ] = ACTIONS(451),
    [anon_sym_DOLLAR] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(451),
    [anon_sym_AT] = ACTIONS(451),
    [sym_number] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(451),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(453),
    [sym__if_else_separator] = ACTIONS(453),
  },
  [100] = {
    [sym_comment] = STATE(100),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(425),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [101] = {
    [sym_comment] = STATE(101),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(451),
    [anon_sym_SEMI] = ACTIONS(451),
    [anon_sym_LF] = ACTIONS(451),
    [anon_sym_CR_LF] = ACTIONS(451),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_do] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_in] = ACTIONS(451),
    [sym_break_statement] = ACTIONS(451),
    [sym_continue_statement] = ACTIONS(451),
    [anon_sym_delete] = ACTIONS(451),
    [anon_sym_exit] = ACTIONS(451),
    [anon_sym_return] = ACTIONS(451),
    [anon_sym_switch] = ACTIONS(451),
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_RBRACE] = ACTIONS(451),
    [anon_sym_case] = ACTIONS(451),
    [anon_sym_default] = ACTIONS(451),
    [anon_sym_getline] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(451),
    [sym_next_statement] = ACTIONS(451),
    [sym_nextfile_statement] = ACTIONS(451),
    [anon_sym_print] = ACTIONS(451),
    [anon_sym_LPAREN2] = ACTIONS(453),
    [anon_sym_printf] = ACTIONS(451),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_GT_GT] = ACTIONS(451),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PIPE_AMP] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(451),
    [anon_sym_STAR_STAR] = ACTIONS(451),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_SLASH] = ACTIONS(451),
    [anon_sym_PERCENT] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(451),
    [anon_sym_DASH] = ACTIONS(451),
    [anon_sym_LT_EQ] = ACTIONS(451),
    [anon_sym_GT_EQ] = ACTIONS(451),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(451),
    [anon_sym_BANG_TILDE] = ACTIONS(451),
    [anon_sym_AMP_AMP] = ACTIONS(451),
    [anon_sym_PIPE_PIPE] = ACTIONS(451),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS_PLUS] = ACTIONS(451),
    [anon_sym_DASH_DASH] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(451),
    [anon_sym_PLUS_EQ] = ACTIONS(451),
    [anon_sym_DASH_EQ] = ACTIONS(451),
    [anon_sym_STAR_EQ] = ACTIONS(451),
    [anon_sym_SLASH_EQ] = ACTIONS(451),
    [anon_sym_PERCENT_EQ] = ACTIONS(451),
    [anon_sym_CARET_EQ] = ACTIONS(451),
    [anon_sym_DOLLAR] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(451),
    [anon_sym_AT] = ACTIONS(451),
    [sym_number] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(451),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(453),
  },
  [102] = {
    [sym_comment] = STATE(102),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(455),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(457),
    [anon_sym_EQ] = ACTIONS(459),
    [anon_sym_PLUS_EQ] = ACTIONS(459),
    [anon_sym_DASH_EQ] = ACTIONS(459),
    [anon_sym_STAR_EQ] = ACTIONS(459),
    [anon_sym_SLASH_EQ] = ACTIONS(459),
    [anon_sym_PERCENT_EQ] = ACTIONS(459),
    [anon_sym_CARET_EQ] = ACTIONS(459),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [103] = {
    [sym_comment] = STATE(103),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_STAR_EQ] = ACTIONS(461),
    [anon_sym_SLASH_EQ] = ACTIONS(461),
    [anon_sym_PERCENT_EQ] = ACTIONS(461),
    [anon_sym_CARET_EQ] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [104] = {
    [sym_comment] = STATE(104),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_COMMA] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_CR_LF] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_in] = ACTIONS(441),
    [sym_break_statement] = ACTIONS(441),
    [sym_continue_statement] = ACTIONS(441),
    [anon_sym_delete] = ACTIONS(441),
    [anon_sym_exit] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_RBRACE] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_getline] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(441),
    [sym_next_statement] = ACTIONS(441),
    [sym_nextfile_statement] = ACTIONS(441),
    [anon_sym_print] = ACTIONS(441),
    [anon_sym_printf] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_STAR_STAR] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_LT_EQ] = ACTIONS(441),
    [anon_sym_GT_EQ] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(441),
    [anon_sym_BANG_EQ] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG_TILDE] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(441),
    [anon_sym_PIPE_PIPE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS_PLUS] = ACTIONS(441),
    [anon_sym_DASH_DASH] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(441),
    [anon_sym_DASH_EQ] = ACTIONS(441),
    [anon_sym_STAR_EQ] = ACTIONS(441),
    [anon_sym_SLASH_EQ] = ACTIONS(441),
    [anon_sym_PERCENT_EQ] = ACTIONS(441),
    [anon_sym_CARET_EQ] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(443),
  },
  [105] = {
    [sym_comment] = STATE(105),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(455),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(463),
    [anon_sym_DASH_DASH] = ACTIONS(463),
    [anon_sym_EQ] = ACTIONS(465),
    [anon_sym_PLUS_EQ] = ACTIONS(465),
    [anon_sym_DASH_EQ] = ACTIONS(465),
    [anon_sym_STAR_EQ] = ACTIONS(465),
    [anon_sym_SLASH_EQ] = ACTIONS(465),
    [anon_sym_PERCENT_EQ] = ACTIONS(465),
    [anon_sym_CARET_EQ] = ACTIONS(465),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(467),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [106] = {
    [sym_comment] = STATE(106),
    [sym_identifier] = ACTIONS(469),
    [anon_sym_COMMA] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym_LF] = ACTIONS(469),
    [anon_sym_CR_LF] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_while] = ACTIONS(469),
    [anon_sym_do] = ACTIONS(469),
    [anon_sym_for] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(469),
    [sym_break_statement] = ACTIONS(469),
    [sym_continue_statement] = ACTIONS(469),
    [anon_sym_delete] = ACTIONS(469),
    [anon_sym_exit] = ACTIONS(469),
    [anon_sym_return] = ACTIONS(469),
    [anon_sym_switch] = ACTIONS(469),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_case] = ACTIONS(469),
    [anon_sym_default] = ACTIONS(469),
    [anon_sym_getline] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(469),
    [sym_next_statement] = ACTIONS(469),
    [sym_nextfile_statement] = ACTIONS(469),
    [anon_sym_print] = ACTIONS(469),
    [anon_sym_printf] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_PIPE_AMP] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_PERCENT] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG_TILDE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_PLUS_PLUS] = ACTIONS(469),
    [anon_sym_DASH_DASH] = ACTIONS(469),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_PLUS_EQ] = ACTIONS(469),
    [anon_sym_DASH_EQ] = ACTIONS(469),
    [anon_sym_STAR_EQ] = ACTIONS(469),
    [anon_sym_SLASH_EQ] = ACTIONS(469),
    [anon_sym_PERCENT_EQ] = ACTIONS(469),
    [anon_sym_CARET_EQ] = ACTIONS(469),
    [anon_sym_DOLLAR] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(469),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(471),
    [sym__if_else_separator] = ACTIONS(471),
  },
  [107] = {
    [sym_comment] = STATE(107),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [108] = {
    [sym_comment] = STATE(108),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(445),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
  },
  [109] = {
    [sym_comment] = STATE(109),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [110] = {
    [sym_comment] = STATE(110),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(455),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_STAR_EQ] = ACTIONS(461),
    [anon_sym_SLASH_EQ] = ACTIONS(461),
    [anon_sym_PERCENT_EQ] = ACTIONS(461),
    [anon_sym_CARET_EQ] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(435),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [111] = {
    [sym_comment] = STATE(111),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_COMMA] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_CR_LF] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_in] = ACTIONS(441),
    [sym_break_statement] = ACTIONS(441),
    [sym_continue_statement] = ACTIONS(441),
    [anon_sym_delete] = ACTIONS(441),
    [anon_sym_exit] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_RBRACE] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_getline] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(441),
    [sym_next_statement] = ACTIONS(441),
    [sym_nextfile_statement] = ACTIONS(441),
    [anon_sym_print] = ACTIONS(441),
    [anon_sym_printf] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_STAR_STAR] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_LT_EQ] = ACTIONS(441),
    [anon_sym_GT_EQ] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(441),
    [anon_sym_BANG_EQ] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG_TILDE] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(441),
    [anon_sym_PIPE_PIPE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS_PLUS] = ACTIONS(441),
    [anon_sym_DASH_DASH] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(441),
    [anon_sym_DASH_EQ] = ACTIONS(441),
    [anon_sym_STAR_EQ] = ACTIONS(441),
    [anon_sym_SLASH_EQ] = ACTIONS(441),
    [anon_sym_PERCENT_EQ] = ACTIONS(441),
    [anon_sym_CARET_EQ] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(441),
    [sym_number] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(443),
    [sym__if_else_separator] = ACTIONS(443),
  },
  [112] = {
    [sym_comment] = STATE(112),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(445),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
  },
  [113] = {
    [sym_comment] = STATE(113),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(473),
    [anon_sym_SEMI] = ACTIONS(473),
    [anon_sym_LF] = ACTIONS(473),
    [anon_sym_CR_LF] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_while] = ACTIONS(473),
    [anon_sym_do] = ACTIONS(473),
    [anon_sym_for] = ACTIONS(473),
    [anon_sym_in] = ACTIONS(473),
    [sym_break_statement] = ACTIONS(473),
    [sym_continue_statement] = ACTIONS(473),
    [anon_sym_delete] = ACTIONS(473),
    [anon_sym_exit] = ACTIONS(473),
    [anon_sym_return] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(473),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_case] = ACTIONS(473),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_getline] = ACTIONS(473),
    [anon_sym_LT] = ACTIONS(473),
    [sym_next_statement] = ACTIONS(473),
    [sym_nextfile_statement] = ACTIONS(473),
    [anon_sym_print] = ACTIONS(473),
    [anon_sym_printf] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_GT] = ACTIONS(473),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_QMARK] = ACTIONS(473),
    [anon_sym_CARET] = ACTIONS(473),
    [anon_sym_STAR_STAR] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(473),
    [anon_sym_PERCENT] = ACTIONS(473),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(473),
    [anon_sym_BANG_TILDE] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(473),
    [anon_sym_PLUS_PLUS] = ACTIONS(473),
    [anon_sym_DASH_DASH] = ACTIONS(473),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_PLUS_EQ] = ACTIONS(473),
    [anon_sym_DASH_EQ] = ACTIONS(473),
    [anon_sym_STAR_EQ] = ACTIONS(473),
    [anon_sym_SLASH_EQ] = ACTIONS(473),
    [anon_sym_PERCENT_EQ] = ACTIONS(473),
    [anon_sym_CARET_EQ] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(473),
    [anon_sym_LBRACK] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(473),
    [anon_sym_DQUOTE] = ACTIONS(473),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(475),
    [sym__if_else_separator] = ACTIONS(475),
  },
  [114] = {
    [sym_comment] = STATE(114),
    [sym_identifier] = ACTIONS(477),
    [anon_sym_COMMA] = ACTIONS(477),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_LF] = ACTIONS(477),
    [anon_sym_CR_LF] = ACTIONS(477),
    [anon_sym_if] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(477),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_do] = ACTIONS(477),
    [anon_sym_for] = ACTIONS(477),
    [anon_sym_in] = ACTIONS(477),
    [sym_break_statement] = ACTIONS(477),
    [sym_continue_statement] = ACTIONS(477),
    [anon_sym_delete] = ACTIONS(477),
    [anon_sym_exit] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(477),
    [anon_sym_switch] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(477),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_case] = ACTIONS(477),
    [anon_sym_default] = ACTIONS(477),
    [anon_sym_getline] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(477),
    [sym_next_statement] = ACTIONS(477),
    [sym_nextfile_statement] = ACTIONS(477),
    [anon_sym_print] = ACTIONS(477),
    [anon_sym_printf] = ACTIONS(477),
    [anon_sym_GT] = ACTIONS(477),
    [anon_sym_GT_GT] = ACTIONS(477),
    [anon_sym_PIPE] = ACTIONS(477),
    [anon_sym_PIPE_AMP] = ACTIONS(477),
    [anon_sym_QMARK] = ACTIONS(477),
    [anon_sym_CARET] = ACTIONS(477),
    [anon_sym_STAR_STAR] = ACTIONS(477),
    [anon_sym_STAR] = ACTIONS(477),
    [anon_sym_SLASH] = ACTIONS(477),
    [anon_sym_PERCENT] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(477),
    [anon_sym_DASH] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_TILDE] = ACTIONS(477),
    [anon_sym_BANG_TILDE] = ACTIONS(477),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_BANG] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [anon_sym_EQ] = ACTIONS(477),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_STAR_EQ] = ACTIONS(477),
    [anon_sym_SLASH_EQ] = ACTIONS(477),
    [anon_sym_PERCENT_EQ] = ACTIONS(477),
    [anon_sym_CARET_EQ] = ACTIONS(477),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [anon_sym_AT] = ACTIONS(477),
    [sym_number] = ACTIONS(477),
    [anon_sym_DQUOTE] = ACTIONS(477),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(479),
    [sym__if_else_separator] = ACTIONS(479),
  },
  [115] = {
    [sym_comment] = STATE(115),
    [sym_identifier] = ACTIONS(469),
    [anon_sym_COMMA] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym_LF] = ACTIONS(469),
    [anon_sym_CR_LF] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_while] = ACTIONS(469),
    [anon_sym_do] = ACTIONS(469),
    [anon_sym_for] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(469),
    [sym_break_statement] = ACTIONS(469),
    [sym_continue_statement] = ACTIONS(469),
    [anon_sym_delete] = ACTIONS(469),
    [anon_sym_exit] = ACTIONS(469),
    [anon_sym_return] = ACTIONS(469),
    [anon_sym_switch] = ACTIONS(469),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_case] = ACTIONS(469),
    [anon_sym_default] = ACTIONS(469),
    [anon_sym_getline] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(469),
    [sym_next_statement] = ACTIONS(469),
    [sym_nextfile_statement] = ACTIONS(469),
    [anon_sym_print] = ACTIONS(469),
    [anon_sym_printf] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_PIPE_AMP] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_PERCENT] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG_TILDE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_PLUS_PLUS] = ACTIONS(469),
    [anon_sym_DASH_DASH] = ACTIONS(469),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_PLUS_EQ] = ACTIONS(469),
    [anon_sym_DASH_EQ] = ACTIONS(469),
    [anon_sym_STAR_EQ] = ACTIONS(469),
    [anon_sym_SLASH_EQ] = ACTIONS(469),
    [anon_sym_PERCENT_EQ] = ACTIONS(469),
    [anon_sym_CARET_EQ] = ACTIONS(469),
    [anon_sym_DOLLAR] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(469),
    [sym_number] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(471),
    [sym__if_else_separator] = ACTIONS(471),
  },
  [116] = {
    [sym_comment] = STATE(116),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_COMMA] = ACTIONS(481),
    [anon_sym_SEMI] = ACTIONS(481),
    [anon_sym_LF] = ACTIONS(481),
    [anon_sym_CR_LF] = ACTIONS(481),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(481),
    [anon_sym_do] = ACTIONS(481),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_in] = ACTIONS(481),
    [sym_break_statement] = ACTIONS(481),
    [sym_continue_statement] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(481),
    [anon_sym_exit] = ACTIONS(481),
    [anon_sym_return] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(481),
    [anon_sym_LBRACE] = ACTIONS(481),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_case] = ACTIONS(481),
    [anon_sym_default] = ACTIONS(481),
    [anon_sym_getline] = ACTIONS(481),
    [anon_sym_LT] = ACTIONS(481),
    [sym_next_statement] = ACTIONS(481),
    [sym_nextfile_statement] = ACTIONS(481),
    [anon_sym_print] = ACTIONS(481),
    [anon_sym_printf] = ACTIONS(481),
    [anon_sym_GT] = ACTIONS(481),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_PIPE_AMP] = ACTIONS(481),
    [anon_sym_QMARK] = ACTIONS(481),
    [anon_sym_CARET] = ACTIONS(481),
    [anon_sym_STAR_STAR] = ACTIONS(481),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_SLASH] = ACTIONS(481),
    [anon_sym_PERCENT] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(481),
    [anon_sym_LT_EQ] = ACTIONS(481),
    [anon_sym_GT_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_TILDE] = ACTIONS(481),
    [anon_sym_BANG_TILDE] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_PLUS_PLUS] = ACTIONS(481),
    [anon_sym_DASH_DASH] = ACTIONS(481),
    [anon_sym_EQ] = ACTIONS(481),
    [anon_sym_PLUS_EQ] = ACTIONS(481),
    [anon_sym_DASH_EQ] = ACTIONS(481),
    [anon_sym_STAR_EQ] = ACTIONS(481),
    [anon_sym_SLASH_EQ] = ACTIONS(481),
    [anon_sym_PERCENT_EQ] = ACTIONS(481),
    [anon_sym_CARET_EQ] = ACTIONS(481),
    [anon_sym_DOLLAR] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(481),
    [sym_number] = ACTIONS(481),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(483),
    [sym__if_else_separator] = ACTIONS(483),
  },
  [117] = {
    [sym_comment] = STATE(117),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_COMMA] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_CR_LF] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_in] = ACTIONS(441),
    [sym_break_statement] = ACTIONS(441),
    [sym_continue_statement] = ACTIONS(441),
    [anon_sym_delete] = ACTIONS(441),
    [anon_sym_exit] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_RBRACE] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_getline] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(441),
    [sym_next_statement] = ACTIONS(441),
    [sym_nextfile_statement] = ACTIONS(441),
    [anon_sym_print] = ACTIONS(441),
    [anon_sym_printf] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_STAR_STAR] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_LT_EQ] = ACTIONS(441),
    [anon_sym_GT_EQ] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(441),
    [anon_sym_BANG_EQ] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG_TILDE] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(441),
    [anon_sym_PIPE_PIPE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS_PLUS] = ACTIONS(441),
    [anon_sym_DASH_DASH] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(441),
    [anon_sym_DASH_EQ] = ACTIONS(441),
    [anon_sym_STAR_EQ] = ACTIONS(441),
    [anon_sym_SLASH_EQ] = ACTIONS(441),
    [anon_sym_PERCENT_EQ] = ACTIONS(441),
    [anon_sym_CARET_EQ] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(441),
    [sym_number] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(443),
    [sym__if_else_separator] = ACTIONS(443),
  },
  [118] = {
    [sym_comment] = STATE(118),
    [sym_identifier] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(485),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_LF] = ACTIONS(485),
    [anon_sym_CR_LF] = ACTIONS(485),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_LPAREN] = ACTIONS(485),
    [anon_sym_while] = ACTIONS(485),
    [anon_sym_do] = ACTIONS(485),
    [anon_sym_for] = ACTIONS(485),
    [anon_sym_in] = ACTIONS(485),
    [sym_break_statement] = ACTIONS(485),
    [sym_continue_statement] = ACTIONS(485),
    [anon_sym_delete] = ACTIONS(485),
    [anon_sym_exit] = ACTIONS(485),
    [anon_sym_return] = ACTIONS(485),
    [anon_sym_switch] = ACTIONS(485),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_case] = ACTIONS(485),
    [anon_sym_default] = ACTIONS(485),
    [anon_sym_getline] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(485),
    [sym_next_statement] = ACTIONS(485),
    [sym_nextfile_statement] = ACTIONS(485),
    [anon_sym_print] = ACTIONS(485),
    [anon_sym_printf] = ACTIONS(485),
    [anon_sym_GT] = ACTIONS(485),
    [anon_sym_GT_GT] = ACTIONS(485),
    [anon_sym_PIPE] = ACTIONS(485),
    [anon_sym_PIPE_AMP] = ACTIONS(485),
    [anon_sym_QMARK] = ACTIONS(485),
    [anon_sym_CARET] = ACTIONS(485),
    [anon_sym_STAR_STAR] = ACTIONS(485),
    [anon_sym_STAR] = ACTIONS(485),
    [anon_sym_SLASH] = ACTIONS(485),
    [anon_sym_PERCENT] = ACTIONS(485),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(485),
    [anon_sym_GT_EQ] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(485),
    [anon_sym_BANG_EQ] = ACTIONS(485),
    [anon_sym_TILDE] = ACTIONS(485),
    [anon_sym_BANG_TILDE] = ACTIONS(485),
    [anon_sym_AMP_AMP] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(485),
    [anon_sym_PLUS_EQ] = ACTIONS(485),
    [anon_sym_DASH_EQ] = ACTIONS(485),
    [anon_sym_STAR_EQ] = ACTIONS(485),
    [anon_sym_SLASH_EQ] = ACTIONS(485),
    [anon_sym_PERCENT_EQ] = ACTIONS(485),
    [anon_sym_CARET_EQ] = ACTIONS(485),
    [anon_sym_DOLLAR] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(485),
    [sym_number] = ACTIONS(485),
    [anon_sym_DQUOTE] = ACTIONS(485),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(487),
    [sym__if_else_separator] = ACTIONS(487),
  },
  [119] = {
    [sym_comment] = STATE(119),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_COMMA] = ACTIONS(489),
    [anon_sym_SEMI] = ACTIONS(489),
    [anon_sym_LF] = ACTIONS(489),
    [anon_sym_CR_LF] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_in] = ACTIONS(489),
    [sym_break_statement] = ACTIONS(489),
    [sym_continue_statement] = ACTIONS(489),
    [anon_sym_delete] = ACTIONS(489),
    [anon_sym_exit] = ACTIONS(489),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_switch] = ACTIONS(489),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_case] = ACTIONS(489),
    [anon_sym_default] = ACTIONS(489),
    [anon_sym_getline] = ACTIONS(489),
    [anon_sym_LT] = ACTIONS(489),
    [sym_next_statement] = ACTIONS(489),
    [sym_nextfile_statement] = ACTIONS(489),
    [anon_sym_print] = ACTIONS(489),
    [anon_sym_printf] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(489),
    [anon_sym_GT_GT] = ACTIONS(489),
    [anon_sym_PIPE] = ACTIONS(489),
    [anon_sym_PIPE_AMP] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_CARET] = ACTIONS(489),
    [anon_sym_STAR_STAR] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(489),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_PERCENT] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(489),
    [anon_sym_LT_EQ] = ACTIONS(489),
    [anon_sym_GT_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_BANG_TILDE] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(489),
    [anon_sym_PIPE_PIPE] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_PLUS_PLUS] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(489),
    [anon_sym_PLUS_EQ] = ACTIONS(489),
    [anon_sym_DASH_EQ] = ACTIONS(489),
    [anon_sym_STAR_EQ] = ACTIONS(489),
    [anon_sym_SLASH_EQ] = ACTIONS(489),
    [anon_sym_PERCENT_EQ] = ACTIONS(489),
    [anon_sym_CARET_EQ] = ACTIONS(489),
    [anon_sym_DOLLAR] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(489),
    [sym_number] = ACTIONS(489),
    [anon_sym_DQUOTE] = ACTIONS(489),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(491),
    [sym__if_else_separator] = ACTIONS(491),
  },
  [120] = {
    [sym_comment] = STATE(120),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym_LF] = ACTIONS(493),
    [anon_sym_CR_LF] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_LPAREN] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_do] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_in] = ACTIONS(493),
    [sym_break_statement] = ACTIONS(493),
    [sym_continue_statement] = ACTIONS(493),
    [anon_sym_delete] = ACTIONS(493),
    [anon_sym_exit] = ACTIONS(493),
    [anon_sym_return] = ACTIONS(493),
    [anon_sym_switch] = ACTIONS(493),
    [anon_sym_LBRACE] = ACTIONS(493),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_case] = ACTIONS(493),
    [anon_sym_default] = ACTIONS(493),
    [anon_sym_getline] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(493),
    [sym_next_statement] = ACTIONS(493),
    [sym_nextfile_statement] = ACTIONS(493),
    [anon_sym_print] = ACTIONS(493),
    [anon_sym_printf] = ACTIONS(493),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_GT] = ACTIONS(493),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_PIPE_AMP] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(493),
    [anon_sym_CARET] = ACTIONS(493),
    [anon_sym_STAR_STAR] = ACTIONS(493),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(493),
    [anon_sym_PERCENT] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(493),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_EQ_EQ] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_TILDE] = ACTIONS(493),
    [anon_sym_BANG_TILDE] = ACTIONS(493),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_PLUS_EQ] = ACTIONS(493),
    [anon_sym_DASH_EQ] = ACTIONS(493),
    [anon_sym_STAR_EQ] = ACTIONS(493),
    [anon_sym_SLASH_EQ] = ACTIONS(493),
    [anon_sym_PERCENT_EQ] = ACTIONS(493),
    [anon_sym_CARET_EQ] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(493),
    [anon_sym_AT] = ACTIONS(493),
    [sym_number] = ACTIONS(493),
    [anon_sym_DQUOTE] = ACTIONS(493),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(495),
    [sym__if_else_separator] = ACTIONS(495),
  },
  [121] = {
    [sym_comment] = STATE(121),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(455),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(457),
    [anon_sym_EQ] = ACTIONS(459),
    [anon_sym_PLUS_EQ] = ACTIONS(459),
    [anon_sym_DASH_EQ] = ACTIONS(459),
    [anon_sym_STAR_EQ] = ACTIONS(459),
    [anon_sym_SLASH_EQ] = ACTIONS(459),
    [anon_sym_PERCENT_EQ] = ACTIONS(459),
    [anon_sym_CARET_EQ] = ACTIONS(459),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [122] = {
    [sym_namespace] = STATE(1813),
    [sym_ns_qualified_name] = STATE(115),
    [sym_comment] = STATE(122),
    [sym_identifier] = ACTIONS(497),
    [anon_sym_COMMA] = ACTIONS(499),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_LF] = ACTIONS(499),
    [anon_sym_CR_LF] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(499),
    [anon_sym_do] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(499),
    [anon_sym_in] = ACTIONS(499),
    [sym_break_statement] = ACTIONS(499),
    [sym_continue_statement] = ACTIONS(499),
    [anon_sym_delete] = ACTIONS(499),
    [anon_sym_exit] = ACTIONS(499),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_switch] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_getline] = ACTIONS(499),
    [anon_sym_LT] = ACTIONS(499),
    [sym_next_statement] = ACTIONS(499),
    [sym_nextfile_statement] = ACTIONS(499),
    [anon_sym_print] = ACTIONS(499),
    [anon_sym_printf] = ACTIONS(499),
    [anon_sym_GT] = ACTIONS(499),
    [anon_sym_GT_GT] = ACTIONS(499),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_PIPE_AMP] = ACTIONS(499),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_CARET] = ACTIONS(499),
    [anon_sym_STAR_STAR] = ACTIONS(499),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_SLASH] = ACTIONS(499),
    [anon_sym_PERCENT] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(499),
    [anon_sym_DASH] = ACTIONS(499),
    [anon_sym_LT_EQ] = ACTIONS(499),
    [anon_sym_GT_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(499),
    [anon_sym_BANG_TILDE] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(499),
    [anon_sym_PIPE_PIPE] = ACTIONS(499),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [anon_sym_EQ] = ACTIONS(499),
    [anon_sym_PLUS_EQ] = ACTIONS(499),
    [anon_sym_DASH_EQ] = ACTIONS(499),
    [anon_sym_STAR_EQ] = ACTIONS(499),
    [anon_sym_SLASH_EQ] = ACTIONS(499),
    [anon_sym_PERCENT_EQ] = ACTIONS(499),
    [anon_sym_CARET_EQ] = ACTIONS(499),
    [anon_sym_DOLLAR] = ACTIONS(499),
    [anon_sym_AT] = ACTIONS(499),
    [sym_number] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(501),
    [sym__if_else_separator] = ACTIONS(501),
  },
  [123] = {
    [sym_comment] = STATE(123),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_SEMI] = ACTIONS(503),
    [anon_sym_LF] = ACTIONS(503),
    [anon_sym_CR_LF] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(503),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_while] = ACTIONS(503),
    [anon_sym_do] = ACTIONS(503),
    [anon_sym_for] = ACTIONS(503),
    [anon_sym_in] = ACTIONS(503),
    [sym_break_statement] = ACTIONS(503),
    [sym_continue_statement] = ACTIONS(503),
    [anon_sym_delete] = ACTIONS(503),
    [anon_sym_exit] = ACTIONS(503),
    [anon_sym_return] = ACTIONS(503),
    [anon_sym_switch] = ACTIONS(503),
    [anon_sym_LBRACE] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_case] = ACTIONS(503),
    [anon_sym_default] = ACTIONS(503),
    [anon_sym_getline] = ACTIONS(503),
    [anon_sym_LT] = ACTIONS(503),
    [sym_next_statement] = ACTIONS(503),
    [sym_nextfile_statement] = ACTIONS(503),
    [anon_sym_print] = ACTIONS(503),
    [anon_sym_printf] = ACTIONS(503),
    [anon_sym_GT] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(503),
    [anon_sym_PIPE] = ACTIONS(503),
    [anon_sym_PIPE_AMP] = ACTIONS(503),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_CARET] = ACTIONS(503),
    [anon_sym_STAR_STAR] = ACTIONS(503),
    [anon_sym_STAR] = ACTIONS(503),
    [anon_sym_SLASH] = ACTIONS(503),
    [anon_sym_PERCENT] = ACTIONS(503),
    [anon_sym_PLUS] = ACTIONS(503),
    [anon_sym_DASH] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(503),
    [anon_sym_BANG_TILDE] = ACTIONS(503),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(503),
    [anon_sym_PLUS_PLUS] = ACTIONS(503),
    [anon_sym_DASH_DASH] = ACTIONS(503),
    [anon_sym_EQ] = ACTIONS(503),
    [anon_sym_PLUS_EQ] = ACTIONS(503),
    [anon_sym_DASH_EQ] = ACTIONS(503),
    [anon_sym_STAR_EQ] = ACTIONS(503),
    [anon_sym_SLASH_EQ] = ACTIONS(503),
    [anon_sym_PERCENT_EQ] = ACTIONS(503),
    [anon_sym_CARET_EQ] = ACTIONS(503),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_AT] = ACTIONS(503),
    [sym_number] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(505),
    [sym__if_else_separator] = ACTIONS(505),
  },
  [124] = {
    [sym_comment] = STATE(124),
    [sym_identifier] = ACTIONS(507),
    [anon_sym_COMMA] = ACTIONS(507),
    [anon_sym_SEMI] = ACTIONS(507),
    [anon_sym_LF] = ACTIONS(507),
    [anon_sym_CR_LF] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(507),
    [anon_sym_while] = ACTIONS(507),
    [anon_sym_do] = ACTIONS(507),
    [anon_sym_for] = ACTIONS(507),
    [anon_sym_in] = ACTIONS(507),
    [sym_break_statement] = ACTIONS(507),
    [sym_continue_statement] = ACTIONS(507),
    [anon_sym_delete] = ACTIONS(507),
    [anon_sym_exit] = ACTIONS(507),
    [anon_sym_return] = ACTIONS(507),
    [anon_sym_switch] = ACTIONS(507),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(507),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_default] = ACTIONS(507),
    [anon_sym_getline] = ACTIONS(507),
    [anon_sym_LT] = ACTIONS(507),
    [sym_next_statement] = ACTIONS(507),
    [sym_nextfile_statement] = ACTIONS(507),
    [anon_sym_print] = ACTIONS(507),
    [anon_sym_printf] = ACTIONS(507),
    [anon_sym_GT] = ACTIONS(507),
    [anon_sym_GT_GT] = ACTIONS(507),
    [anon_sym_PIPE] = ACTIONS(507),
    [anon_sym_PIPE_AMP] = ACTIONS(507),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_CARET] = ACTIONS(507),
    [anon_sym_STAR_STAR] = ACTIONS(507),
    [anon_sym_STAR] = ACTIONS(507),
    [anon_sym_SLASH] = ACTIONS(507),
    [anon_sym_PERCENT] = ACTIONS(507),
    [anon_sym_PLUS] = ACTIONS(507),
    [anon_sym_DASH] = ACTIONS(507),
    [anon_sym_LT_EQ] = ACTIONS(507),
    [anon_sym_GT_EQ] = ACTIONS(507),
    [anon_sym_EQ_EQ] = ACTIONS(507),
    [anon_sym_BANG_EQ] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(507),
    [anon_sym_BANG_TILDE] = ACTIONS(507),
    [anon_sym_AMP_AMP] = ACTIONS(507),
    [anon_sym_PIPE_PIPE] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(507),
    [anon_sym_PLUS_PLUS] = ACTIONS(507),
    [anon_sym_DASH_DASH] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(507),
    [anon_sym_PLUS_EQ] = ACTIONS(507),
    [anon_sym_DASH_EQ] = ACTIONS(507),
    [anon_sym_STAR_EQ] = ACTIONS(507),
    [anon_sym_SLASH_EQ] = ACTIONS(507),
    [anon_sym_PERCENT_EQ] = ACTIONS(507),
    [anon_sym_CARET_EQ] = ACTIONS(507),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [anon_sym_AT] = ACTIONS(507),
    [sym_number] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(507),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(509),
    [sym__if_else_separator] = ACTIONS(509),
  },
  [125] = {
    [sym_comment] = STATE(125),
    [sym_identifier] = ACTIONS(511),
    [anon_sym_COMMA] = ACTIONS(511),
    [anon_sym_SEMI] = ACTIONS(511),
    [anon_sym_LF] = ACTIONS(511),
    [anon_sym_CR_LF] = ACTIONS(511),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(511),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(511),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_in] = ACTIONS(511),
    [sym_break_statement] = ACTIONS(511),
    [sym_continue_statement] = ACTIONS(511),
    [anon_sym_delete] = ACTIONS(511),
    [anon_sym_exit] = ACTIONS(511),
    [anon_sym_return] = ACTIONS(511),
    [anon_sym_switch] = ACTIONS(511),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_case] = ACTIONS(511),
    [anon_sym_default] = ACTIONS(511),
    [anon_sym_getline] = ACTIONS(511),
    [anon_sym_LT] = ACTIONS(511),
    [sym_next_statement] = ACTIONS(511),
    [sym_nextfile_statement] = ACTIONS(511),
    [anon_sym_print] = ACTIONS(511),
    [anon_sym_printf] = ACTIONS(511),
    [anon_sym_GT] = ACTIONS(511),
    [anon_sym_GT_GT] = ACTIONS(511),
    [anon_sym_PIPE] = ACTIONS(511),
    [anon_sym_PIPE_AMP] = ACTIONS(511),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_CARET] = ACTIONS(511),
    [anon_sym_STAR_STAR] = ACTIONS(511),
    [anon_sym_STAR] = ACTIONS(511),
    [anon_sym_SLASH] = ACTIONS(511),
    [anon_sym_PERCENT] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(511),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_LT_EQ] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(511),
    [anon_sym_EQ_EQ] = ACTIONS(511),
    [anon_sym_BANG_EQ] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(511),
    [anon_sym_BANG_TILDE] = ACTIONS(511),
    [anon_sym_AMP_AMP] = ACTIONS(511),
    [anon_sym_PIPE_PIPE] = ACTIONS(511),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_PLUS_PLUS] = ACTIONS(511),
    [anon_sym_DASH_DASH] = ACTIONS(511),
    [anon_sym_EQ] = ACTIONS(511),
    [anon_sym_PLUS_EQ] = ACTIONS(511),
    [anon_sym_DASH_EQ] = ACTIONS(511),
    [anon_sym_STAR_EQ] = ACTIONS(511),
    [anon_sym_SLASH_EQ] = ACTIONS(511),
    [anon_sym_PERCENT_EQ] = ACTIONS(511),
    [anon_sym_CARET_EQ] = ACTIONS(511),
    [anon_sym_DOLLAR] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(511),
    [sym_number] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(513),
    [sym__if_else_separator] = ACTIONS(513),
  },
  [126] = {
    [sym_comment] = STATE(126),
    [sym_identifier] = ACTIONS(515),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_SEMI] = ACTIONS(515),
    [anon_sym_LF] = ACTIONS(515),
    [anon_sym_CR_LF] = ACTIONS(515),
    [anon_sym_if] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(515),
    [anon_sym_while] = ACTIONS(515),
    [anon_sym_do] = ACTIONS(515),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_in] = ACTIONS(515),
    [sym_break_statement] = ACTIONS(515),
    [sym_continue_statement] = ACTIONS(515),
    [anon_sym_delete] = ACTIONS(515),
    [anon_sym_exit] = ACTIONS(515),
    [anon_sym_return] = ACTIONS(515),
    [anon_sym_switch] = ACTIONS(515),
    [anon_sym_LBRACE] = ACTIONS(515),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_case] = ACTIONS(515),
    [anon_sym_default] = ACTIONS(515),
    [anon_sym_getline] = ACTIONS(515),
    [anon_sym_LT] = ACTIONS(515),
    [sym_next_statement] = ACTIONS(515),
    [sym_nextfile_statement] = ACTIONS(515),
    [anon_sym_print] = ACTIONS(515),
    [anon_sym_printf] = ACTIONS(515),
    [anon_sym_GT] = ACTIONS(515),
    [anon_sym_GT_GT] = ACTIONS(515),
    [anon_sym_PIPE] = ACTIONS(515),
    [anon_sym_PIPE_AMP] = ACTIONS(515),
    [anon_sym_QMARK] = ACTIONS(515),
    [anon_sym_CARET] = ACTIONS(515),
    [anon_sym_STAR_STAR] = ACTIONS(515),
    [anon_sym_STAR] = ACTIONS(515),
    [anon_sym_SLASH] = ACTIONS(515),
    [anon_sym_PERCENT] = ACTIONS(515),
    [anon_sym_PLUS] = ACTIONS(515),
    [anon_sym_DASH] = ACTIONS(515),
    [anon_sym_LT_EQ] = ACTIONS(515),
    [anon_sym_GT_EQ] = ACTIONS(515),
    [anon_sym_EQ_EQ] = ACTIONS(515),
    [anon_sym_BANG_EQ] = ACTIONS(515),
    [anon_sym_TILDE] = ACTIONS(515),
    [anon_sym_BANG_TILDE] = ACTIONS(515),
    [anon_sym_AMP_AMP] = ACTIONS(515),
    [anon_sym_PIPE_PIPE] = ACTIONS(515),
    [anon_sym_BANG] = ACTIONS(515),
    [anon_sym_PLUS_PLUS] = ACTIONS(515),
    [anon_sym_DASH_DASH] = ACTIONS(515),
    [anon_sym_EQ] = ACTIONS(515),
    [anon_sym_PLUS_EQ] = ACTIONS(515),
    [anon_sym_DASH_EQ] = ACTIONS(515),
    [anon_sym_STAR_EQ] = ACTIONS(515),
    [anon_sym_SLASH_EQ] = ACTIONS(515),
    [anon_sym_PERCENT_EQ] = ACTIONS(515),
    [anon_sym_CARET_EQ] = ACTIONS(515),
    [anon_sym_DOLLAR] = ACTIONS(515),
    [anon_sym_AT] = ACTIONS(515),
    [sym_number] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(517),
    [sym__if_else_separator] = ACTIONS(517),
  },
  [127] = {
    [sym_comment] = STATE(127),
    [sym_identifier] = ACTIONS(519),
    [anon_sym_COMMA] = ACTIONS(519),
    [anon_sym_SEMI] = ACTIONS(519),
    [anon_sym_LF] = ACTIONS(519),
    [anon_sym_CR_LF] = ACTIONS(519),
    [anon_sym_if] = ACTIONS(519),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_while] = ACTIONS(519),
    [anon_sym_do] = ACTIONS(519),
    [anon_sym_for] = ACTIONS(519),
    [anon_sym_in] = ACTIONS(519),
    [sym_break_statement] = ACTIONS(519),
    [sym_continue_statement] = ACTIONS(519),
    [anon_sym_delete] = ACTIONS(519),
    [anon_sym_exit] = ACTIONS(519),
    [anon_sym_return] = ACTIONS(519),
    [anon_sym_switch] = ACTIONS(519),
    [anon_sym_LBRACE] = ACTIONS(519),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_case] = ACTIONS(519),
    [anon_sym_default] = ACTIONS(519),
    [anon_sym_getline] = ACTIONS(519),
    [anon_sym_LT] = ACTIONS(519),
    [sym_next_statement] = ACTIONS(519),
    [sym_nextfile_statement] = ACTIONS(519),
    [anon_sym_print] = ACTIONS(519),
    [anon_sym_printf] = ACTIONS(519),
    [anon_sym_GT] = ACTIONS(519),
    [anon_sym_GT_GT] = ACTIONS(519),
    [anon_sym_PIPE] = ACTIONS(519),
    [anon_sym_PIPE_AMP] = ACTIONS(519),
    [anon_sym_QMARK] = ACTIONS(519),
    [anon_sym_CARET] = ACTIONS(519),
    [anon_sym_STAR_STAR] = ACTIONS(519),
    [anon_sym_STAR] = ACTIONS(519),
    [anon_sym_SLASH] = ACTIONS(519),
    [anon_sym_PERCENT] = ACTIONS(519),
    [anon_sym_PLUS] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(519),
    [anon_sym_LT_EQ] = ACTIONS(519),
    [anon_sym_GT_EQ] = ACTIONS(519),
    [anon_sym_EQ_EQ] = ACTIONS(519),
    [anon_sym_BANG_EQ] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(519),
    [anon_sym_BANG_TILDE] = ACTIONS(519),
    [anon_sym_AMP_AMP] = ACTIONS(519),
    [anon_sym_PIPE_PIPE] = ACTIONS(519),
    [anon_sym_BANG] = ACTIONS(519),
    [anon_sym_PLUS_PLUS] = ACTIONS(519),
    [anon_sym_DASH_DASH] = ACTIONS(519),
    [anon_sym_EQ] = ACTIONS(519),
    [anon_sym_PLUS_EQ] = ACTIONS(519),
    [anon_sym_DASH_EQ] = ACTIONS(519),
    [anon_sym_STAR_EQ] = ACTIONS(519),
    [anon_sym_SLASH_EQ] = ACTIONS(519),
    [anon_sym_PERCENT_EQ] = ACTIONS(519),
    [anon_sym_CARET_EQ] = ACTIONS(519),
    [anon_sym_DOLLAR] = ACTIONS(519),
    [anon_sym_AT] = ACTIONS(519),
    [sym_number] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(521),
    [sym__if_else_separator] = ACTIONS(521),
  },
  [128] = {
    [sym_comment] = STATE(128),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
  },
  [129] = {
    [sym_comment] = STATE(129),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(523),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(525),
    [anon_sym_DASH_DASH] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(527),
    [anon_sym_PLUS_EQ] = ACTIONS(527),
    [anon_sym_DASH_EQ] = ACTIONS(527),
    [anon_sym_STAR_EQ] = ACTIONS(527),
    [anon_sym_SLASH_EQ] = ACTIONS(527),
    [anon_sym_PERCENT_EQ] = ACTIONS(527),
    [anon_sym_CARET_EQ] = ACTIONS(527),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(529),
  },
  [130] = {
    [sym_comment] = STATE(130),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(435),
    [anon_sym_DASH_DASH] = ACTIONS(435),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [131] = {
    [sym_comment] = STATE(131),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_COMMA] = ACTIONS(531),
    [anon_sym_SEMI] = ACTIONS(531),
    [anon_sym_LF] = ACTIONS(531),
    [anon_sym_CR_LF] = ACTIONS(531),
    [anon_sym_if] = ACTIONS(531),
    [anon_sym_LPAREN] = ACTIONS(531),
    [anon_sym_while] = ACTIONS(531),
    [anon_sym_do] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(531),
    [anon_sym_in] = ACTIONS(531),
    [sym_break_statement] = ACTIONS(531),
    [sym_continue_statement] = ACTIONS(531),
    [anon_sym_delete] = ACTIONS(531),
    [anon_sym_exit] = ACTIONS(531),
    [anon_sym_return] = ACTIONS(531),
    [anon_sym_switch] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(531),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_case] = ACTIONS(531),
    [anon_sym_default] = ACTIONS(531),
    [anon_sym_getline] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(531),
    [sym_next_statement] = ACTIONS(531),
    [sym_nextfile_statement] = ACTIONS(531),
    [anon_sym_print] = ACTIONS(531),
    [anon_sym_printf] = ACTIONS(531),
    [anon_sym_GT] = ACTIONS(531),
    [anon_sym_GT_GT] = ACTIONS(531),
    [anon_sym_PIPE] = ACTIONS(531),
    [anon_sym_PIPE_AMP] = ACTIONS(531),
    [anon_sym_QMARK] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(531),
    [anon_sym_STAR_STAR] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(531),
    [anon_sym_SLASH] = ACTIONS(531),
    [anon_sym_PERCENT] = ACTIONS(531),
    [anon_sym_PLUS] = ACTIONS(531),
    [anon_sym_DASH] = ACTIONS(531),
    [anon_sym_LT_EQ] = ACTIONS(531),
    [anon_sym_GT_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(531),
    [anon_sym_BANG_TILDE] = ACTIONS(531),
    [anon_sym_AMP_AMP] = ACTIONS(531),
    [anon_sym_PIPE_PIPE] = ACTIONS(531),
    [anon_sym_BANG] = ACTIONS(531),
    [anon_sym_PLUS_PLUS] = ACTIONS(531),
    [anon_sym_DASH_DASH] = ACTIONS(531),
    [anon_sym_EQ] = ACTIONS(531),
    [anon_sym_PLUS_EQ] = ACTIONS(531),
    [anon_sym_DASH_EQ] = ACTIONS(531),
    [anon_sym_STAR_EQ] = ACTIONS(531),
    [anon_sym_SLASH_EQ] = ACTIONS(531),
    [anon_sym_PERCENT_EQ] = ACTIONS(531),
    [anon_sym_CARET_EQ] = ACTIONS(531),
    [anon_sym_DOLLAR] = ACTIONS(531),
    [anon_sym_AT] = ACTIONS(531),
    [sym_number] = ACTIONS(531),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(533),
    [sym__if_else_separator] = ACTIONS(533),
  },
  [132] = {
    [sym_comment] = STATE(132),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(523),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_STAR_EQ] = ACTIONS(461),
    [anon_sym_SLASH_EQ] = ACTIONS(461),
    [anon_sym_PERCENT_EQ] = ACTIONS(461),
    [anon_sym_CARET_EQ] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(435),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
  },
  [133] = {
    [sym_comment] = STATE(133),
    [sym_identifier] = ACTIONS(535),
    [anon_sym_COMMA] = ACTIONS(535),
    [anon_sym_SEMI] = ACTIONS(535),
    [anon_sym_LF] = ACTIONS(535),
    [anon_sym_CR_LF] = ACTIONS(535),
    [anon_sym_if] = ACTIONS(535),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_while] = ACTIONS(535),
    [anon_sym_do] = ACTIONS(535),
    [anon_sym_for] = ACTIONS(535),
    [anon_sym_in] = ACTIONS(535),
    [sym_break_statement] = ACTIONS(535),
    [sym_continue_statement] = ACTIONS(535),
    [anon_sym_delete] = ACTIONS(535),
    [anon_sym_exit] = ACTIONS(535),
    [anon_sym_return] = ACTIONS(535),
    [anon_sym_switch] = ACTIONS(535),
    [anon_sym_LBRACE] = ACTIONS(535),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_case] = ACTIONS(535),
    [anon_sym_default] = ACTIONS(535),
    [anon_sym_getline] = ACTIONS(535),
    [anon_sym_LT] = ACTIONS(535),
    [sym_next_statement] = ACTIONS(535),
    [sym_nextfile_statement] = ACTIONS(535),
    [anon_sym_print] = ACTIONS(535),
    [anon_sym_printf] = ACTIONS(535),
    [anon_sym_GT] = ACTIONS(535),
    [anon_sym_GT_GT] = ACTIONS(535),
    [anon_sym_PIPE] = ACTIONS(535),
    [anon_sym_PIPE_AMP] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(535),
    [anon_sym_CARET] = ACTIONS(535),
    [anon_sym_STAR_STAR] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(535),
    [anon_sym_SLASH] = ACTIONS(535),
    [anon_sym_PERCENT] = ACTIONS(535),
    [anon_sym_PLUS] = ACTIONS(535),
    [anon_sym_DASH] = ACTIONS(535),
    [anon_sym_LT_EQ] = ACTIONS(535),
    [anon_sym_GT_EQ] = ACTIONS(535),
    [anon_sym_EQ_EQ] = ACTIONS(535),
    [anon_sym_BANG_EQ] = ACTIONS(535),
    [anon_sym_TILDE] = ACTIONS(535),
    [anon_sym_BANG_TILDE] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(535),
    [anon_sym_PIPE_PIPE] = ACTIONS(535),
    [anon_sym_BANG] = ACTIONS(535),
    [anon_sym_PLUS_PLUS] = ACTIONS(535),
    [anon_sym_DASH_DASH] = ACTIONS(535),
    [anon_sym_EQ] = ACTIONS(535),
    [anon_sym_PLUS_EQ] = ACTIONS(535),
    [anon_sym_DASH_EQ] = ACTIONS(535),
    [anon_sym_STAR_EQ] = ACTIONS(535),
    [anon_sym_SLASH_EQ] = ACTIONS(535),
    [anon_sym_PERCENT_EQ] = ACTIONS(535),
    [anon_sym_CARET_EQ] = ACTIONS(535),
    [anon_sym_DOLLAR] = ACTIONS(535),
    [anon_sym_AT] = ACTIONS(535),
    [sym_number] = ACTIONS(535),
    [anon_sym_DQUOTE] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(537),
    [sym__if_else_separator] = ACTIONS(537),
  },
  [134] = {
    [sym_comment] = STATE(134),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_STAR_EQ] = ACTIONS(461),
    [anon_sym_SLASH_EQ] = ACTIONS(461),
    [anon_sym_PERCENT_EQ] = ACTIONS(461),
    [anon_sym_CARET_EQ] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
  },
  [135] = {
    [sym_comment] = STATE(135),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(435),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [136] = {
    [sym_comment] = STATE(136),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(423),
    [anon_sym_DASH_DASH] = ACTIONS(423),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [137] = {
    [sym_comment] = STATE(137),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_COMMA] = ACTIONS(539),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_LF] = ACTIONS(539),
    [anon_sym_CR_LF] = ACTIONS(539),
    [anon_sym_if] = ACTIONS(539),
    [anon_sym_LPAREN] = ACTIONS(539),
    [anon_sym_while] = ACTIONS(539),
    [anon_sym_do] = ACTIONS(539),
    [anon_sym_for] = ACTIONS(539),
    [anon_sym_in] = ACTIONS(539),
    [sym_break_statement] = ACTIONS(539),
    [sym_continue_statement] = ACTIONS(539),
    [anon_sym_delete] = ACTIONS(539),
    [anon_sym_exit] = ACTIONS(539),
    [anon_sym_return] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(539),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_case] = ACTIONS(539),
    [anon_sym_default] = ACTIONS(539),
    [anon_sym_getline] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(539),
    [sym_next_statement] = ACTIONS(539),
    [sym_nextfile_statement] = ACTIONS(539),
    [anon_sym_print] = ACTIONS(539),
    [anon_sym_printf] = ACTIONS(539),
    [anon_sym_GT] = ACTIONS(539),
    [anon_sym_GT_GT] = ACTIONS(539),
    [anon_sym_PIPE] = ACTIONS(539),
    [anon_sym_PIPE_AMP] = ACTIONS(539),
    [anon_sym_QMARK] = ACTIONS(539),
    [anon_sym_CARET] = ACTIONS(539),
    [anon_sym_STAR_STAR] = ACTIONS(539),
    [anon_sym_STAR] = ACTIONS(539),
    [anon_sym_SLASH] = ACTIONS(539),
    [anon_sym_PERCENT] = ACTIONS(539),
    [anon_sym_PLUS] = ACTIONS(539),
    [anon_sym_DASH] = ACTIONS(539),
    [anon_sym_LT_EQ] = ACTIONS(539),
    [anon_sym_GT_EQ] = ACTIONS(539),
    [anon_sym_EQ_EQ] = ACTIONS(539),
    [anon_sym_BANG_EQ] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(539),
    [anon_sym_BANG_TILDE] = ACTIONS(539),
    [anon_sym_AMP_AMP] = ACTIONS(539),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [anon_sym_BANG] = ACTIONS(539),
    [anon_sym_PLUS_PLUS] = ACTIONS(539),
    [anon_sym_DASH_DASH] = ACTIONS(539),
    [anon_sym_EQ] = ACTIONS(539),
    [anon_sym_PLUS_EQ] = ACTIONS(539),
    [anon_sym_DASH_EQ] = ACTIONS(539),
    [anon_sym_STAR_EQ] = ACTIONS(539),
    [anon_sym_SLASH_EQ] = ACTIONS(539),
    [anon_sym_PERCENT_EQ] = ACTIONS(539),
    [anon_sym_CARET_EQ] = ACTIONS(539),
    [anon_sym_DOLLAR] = ACTIONS(539),
    [anon_sym_AT] = ACTIONS(539),
    [sym_number] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(541),
    [sym__if_else_separator] = ACTIONS(541),
  },
  [138] = {
    [sym__getline_exp] = STATE(353),
    [sym_getline_input] = STATE(354),
    [sym_getline_file] = STATE(354),
    [sym__print_args] = STATE(585),
    [sym__exp] = STATE(369),
    [sym_ternary_exp] = STATE(286),
    [sym_binary_exp] = STATE(286),
    [sym_unary_exp] = STATE(286),
    [sym_update_exp] = STATE(353),
    [sym_assignment_exp] = STATE(353),
    [sym_piped_io_exp] = STATE(353),
    [sym_string_concat] = STATE(286),
    [sym_field_ref] = STATE(199),
    [sym_array_ref] = STATE(168),
    [sym_exp_list] = STATE(562),
    [sym_regex] = STATE(353),
    [sym_regex_constant] = STATE(353),
    [sym_grouping] = STATE(286),
    [sym__primitive] = STATE(286),
    [sym_namespace] = STATE(1810),
    [sym_ns_qualified_name] = STATE(145),
    [sym_string] = STATE(294),
    [sym_func_call] = STATE(286),
    [sym_indirect_func_call] = STATE(353),
    [sym_comment] = STATE(138),
    [aux_sym_exp_list_repeat1] = STATE(710),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym_LF] = ACTIONS(543),
    [anon_sym_CR_LF] = ACTIONS(543),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_LPAREN] = ACTIONS(545),
    [anon_sym_while] = ACTIONS(543),
    [anon_sym_do] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(543),
    [sym_break_statement] = ACTIONS(543),
    [sym_continue_statement] = ACTIONS(543),
    [anon_sym_delete] = ACTIONS(543),
    [anon_sym_exit] = ACTIONS(543),
    [anon_sym_return] = ACTIONS(543),
    [anon_sym_switch] = ACTIONS(543),
    [anon_sym_LBRACE] = ACTIONS(543),
    [anon_sym_RBRACE] = ACTIONS(543),
    [anon_sym_getline] = ACTIONS(337),
    [sym_next_statement] = ACTIONS(543),
    [sym_nextfile_statement] = ACTIONS(543),
    [anon_sym_print] = ACTIONS(543),
    [anon_sym_LPAREN2] = ACTIONS(547),
    [anon_sym_printf] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_GT_GT] = ACTIONS(543),
    [anon_sym_PIPE] = ACTIONS(543),
    [anon_sym_PIPE_AMP] = ACTIONS(543),
    [anon_sym_SLASH] = ACTIONS(549),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(551),
    [anon_sym_DASH_DASH] = ACTIONS(551),
    [anon_sym_DOLLAR] = ACTIONS(553),
    [anon_sym_AT] = ACTIONS(555),
    [sym_number] = ACTIONS(557),
    [anon_sym_DQUOTE] = ACTIONS(559),
    [anon_sym_POUND] = ACTIONS(83),
    [sym__if_else_separator] = ACTIONS(561),
  },
  [139] = {
    [sym_comment] = STATE(139),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(473),
    [anon_sym_SEMI] = ACTIONS(473),
    [anon_sym_LF] = ACTIONS(473),
    [anon_sym_CR_LF] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_while] = ACTIONS(473),
    [anon_sym_do] = ACTIONS(473),
    [anon_sym_for] = ACTIONS(473),
    [anon_sym_in] = ACTIONS(473),
    [sym_break_statement] = ACTIONS(473),
    [sym_continue_statement] = ACTIONS(473),
    [anon_sym_delete] = ACTIONS(473),
    [anon_sym_exit] = ACTIONS(473),
    [anon_sym_return] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(473),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_case] = ACTIONS(473),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_getline] = ACTIONS(473),
    [anon_sym_LT] = ACTIONS(473),
    [sym_next_statement] = ACTIONS(473),
    [sym_nextfile_statement] = ACTIONS(473),
    [anon_sym_print] = ACTIONS(473),
    [anon_sym_printf] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_GT_GT] = ACTIONS(473),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_QMARK] = ACTIONS(473),
    [anon_sym_CARET] = ACTIONS(473),
    [anon_sym_STAR_STAR] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(473),
    [anon_sym_PERCENT] = ACTIONS(473),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(473),
    [anon_sym_BANG_TILDE] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(473),
    [anon_sym_PLUS_PLUS] = ACTIONS(473),
    [anon_sym_DASH_DASH] = ACTIONS(473),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_PLUS_EQ] = ACTIONS(473),
    [anon_sym_DASH_EQ] = ACTIONS(473),
    [anon_sym_STAR_EQ] = ACTIONS(473),
    [anon_sym_SLASH_EQ] = ACTIONS(473),
    [anon_sym_PERCENT_EQ] = ACTIONS(473),
    [anon_sym_CARET_EQ] = ACTIONS(473),
    [anon_sym_DOLLAR] = ACTIONS(473),
    [anon_sym_LBRACK] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(473),
    [sym_number] = ACTIONS(473),
    [anon_sym_DQUOTE] = ACTIONS(473),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(475),
  },
  [140] = {
    [sym_comment] = STATE(140),
    [sym_identifier] = ACTIONS(469),
    [anon_sym_COMMA] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym_LF] = ACTIONS(469),
    [anon_sym_CR_LF] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_while] = ACTIONS(469),
    [anon_sym_do] = ACTIONS(469),
    [anon_sym_for] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(469),
    [sym_break_statement] = ACTIONS(469),
    [sym_continue_statement] = ACTIONS(469),
    [anon_sym_delete] = ACTIONS(469),
    [anon_sym_exit] = ACTIONS(469),
    [anon_sym_return] = ACTIONS(469),
    [anon_sym_switch] = ACTIONS(469),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_case] = ACTIONS(469),
    [anon_sym_default] = ACTIONS(469),
    [anon_sym_getline] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(469),
    [sym_next_statement] = ACTIONS(469),
    [sym_nextfile_statement] = ACTIONS(469),
    [anon_sym_print] = ACTIONS(469),
    [anon_sym_printf] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_PIPE_AMP] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_PERCENT] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG_TILDE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_PLUS_PLUS] = ACTIONS(469),
    [anon_sym_DASH_DASH] = ACTIONS(469),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_PLUS_EQ] = ACTIONS(469),
    [anon_sym_DASH_EQ] = ACTIONS(469),
    [anon_sym_STAR_EQ] = ACTIONS(469),
    [anon_sym_SLASH_EQ] = ACTIONS(469),
    [anon_sym_PERCENT_EQ] = ACTIONS(469),
    [anon_sym_CARET_EQ] = ACTIONS(469),
    [anon_sym_DOLLAR] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(469),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(471),
  },
  [141] = {
    [sym_comment] = STATE(141),
    [sym_identifier] = ACTIONS(563),
    [anon_sym_COMMA] = ACTIONS(563),
    [anon_sym_SEMI] = ACTIONS(563),
    [anon_sym_LF] = ACTIONS(563),
    [anon_sym_CR_LF] = ACTIONS(563),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_LPAREN] = ACTIONS(563),
    [anon_sym_while] = ACTIONS(563),
    [anon_sym_do] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(563),
    [anon_sym_in] = ACTIONS(563),
    [sym_break_statement] = ACTIONS(563),
    [sym_continue_statement] = ACTIONS(563),
    [anon_sym_delete] = ACTIONS(563),
    [anon_sym_exit] = ACTIONS(563),
    [anon_sym_return] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(563),
    [anon_sym_LBRACE] = ACTIONS(563),
    [anon_sym_RBRACE] = ACTIONS(563),
    [anon_sym_case] = ACTIONS(563),
    [anon_sym_default] = ACTIONS(563),
    [anon_sym_getline] = ACTIONS(563),
    [anon_sym_LT] = ACTIONS(563),
    [sym_next_statement] = ACTIONS(563),
    [sym_nextfile_statement] = ACTIONS(563),
    [anon_sym_print] = ACTIONS(563),
    [anon_sym_printf] = ACTIONS(563),
    [anon_sym_GT] = ACTIONS(563),
    [anon_sym_GT_GT] = ACTIONS(563),
    [anon_sym_PIPE] = ACTIONS(563),
    [anon_sym_PIPE_AMP] = ACTIONS(563),
    [anon_sym_QMARK] = ACTIONS(563),
    [anon_sym_CARET] = ACTIONS(563),
    [anon_sym_STAR_STAR] = ACTIONS(563),
    [anon_sym_STAR] = ACTIONS(563),
    [anon_sym_SLASH] = ACTIONS(563),
    [anon_sym_PERCENT] = ACTIONS(563),
    [anon_sym_PLUS] = ACTIONS(563),
    [anon_sym_DASH] = ACTIONS(563),
    [anon_sym_LT_EQ] = ACTIONS(563),
    [anon_sym_GT_EQ] = ACTIONS(563),
    [anon_sym_EQ_EQ] = ACTIONS(563),
    [anon_sym_BANG_EQ] = ACTIONS(563),
    [anon_sym_TILDE] = ACTIONS(563),
    [anon_sym_BANG_TILDE] = ACTIONS(563),
    [anon_sym_AMP_AMP] = ACTIONS(563),
    [anon_sym_PIPE_PIPE] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(563),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [anon_sym_EQ] = ACTIONS(563),
    [anon_sym_PLUS_EQ] = ACTIONS(563),
    [anon_sym_DASH_EQ] = ACTIONS(563),
    [anon_sym_STAR_EQ] = ACTIONS(563),
    [anon_sym_SLASH_EQ] = ACTIONS(563),
    [anon_sym_PERCENT_EQ] = ACTIONS(563),
    [anon_sym_CARET_EQ] = ACTIONS(563),
    [anon_sym_DOLLAR] = ACTIONS(563),
    [anon_sym_AT] = ACTIONS(563),
    [sym_number] = ACTIONS(563),
    [anon_sym_DQUOTE] = ACTIONS(563),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(565),
    [sym__if_else_separator] = ACTIONS(565),
  },
  [142] = {
    [sym_comment] = STATE(142),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(423),
    [anon_sym_DASH_DASH] = ACTIONS(423),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [143] = {
    [sym_namespace] = STATE(1813),
    [sym_ns_qualified_name] = STATE(198),
    [sym_comment] = STATE(143),
    [sym_identifier] = ACTIONS(567),
    [anon_sym_COMMA] = ACTIONS(499),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_LF] = ACTIONS(499),
    [anon_sym_CR_LF] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(499),
    [anon_sym_do] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(499),
    [anon_sym_in] = ACTIONS(499),
    [sym_break_statement] = ACTIONS(499),
    [sym_continue_statement] = ACTIONS(499),
    [anon_sym_delete] = ACTIONS(499),
    [anon_sym_exit] = ACTIONS(499),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_switch] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_getline] = ACTIONS(499),
    [anon_sym_LT] = ACTIONS(569),
    [sym_next_statement] = ACTIONS(499),
    [sym_nextfile_statement] = ACTIONS(499),
    [anon_sym_print] = ACTIONS(499),
    [anon_sym_printf] = ACTIONS(499),
    [anon_sym_GT] = ACTIONS(499),
    [anon_sym_GT_GT] = ACTIONS(499),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_PIPE_AMP] = ACTIONS(499),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_CARET] = ACTIONS(499),
    [anon_sym_STAR_STAR] = ACTIONS(499),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_SLASH] = ACTIONS(499),
    [anon_sym_PERCENT] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(499),
    [anon_sym_DASH] = ACTIONS(499),
    [anon_sym_LT_EQ] = ACTIONS(499),
    [anon_sym_GT_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(499),
    [anon_sym_BANG_TILDE] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(499),
    [anon_sym_PIPE_PIPE] = ACTIONS(499),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [anon_sym_EQ] = ACTIONS(499),
    [anon_sym_PLUS_EQ] = ACTIONS(499),
    [anon_sym_DASH_EQ] = ACTIONS(499),
    [anon_sym_STAR_EQ] = ACTIONS(499),
    [anon_sym_SLASH_EQ] = ACTIONS(499),
    [anon_sym_PERCENT_EQ] = ACTIONS(499),
    [anon_sym_CARET_EQ] = ACTIONS(499),
    [anon_sym_DOLLAR] = ACTIONS(499),
    [anon_sym_AT] = ACTIONS(499),
    [sym_number] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(501),
    [sym__if_else_separator] = ACTIONS(501),
  },
  [144] = {
    [sym_comment] = STATE(144),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(523),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(571),
    [anon_sym_DASH_DASH] = ACTIONS(571),
    [anon_sym_EQ] = ACTIONS(573),
    [anon_sym_PLUS_EQ] = ACTIONS(573),
    [anon_sym_DASH_EQ] = ACTIONS(573),
    [anon_sym_STAR_EQ] = ACTIONS(573),
    [anon_sym_SLASH_EQ] = ACTIONS(573),
    [anon_sym_PERCENT_EQ] = ACTIONS(573),
    [anon_sym_CARET_EQ] = ACTIONS(573),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_COLON_COLON] = ACTIONS(431),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
  },
  [145] = {
    [sym_comment] = STATE(145),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_LPAREN2] = ACTIONS(455),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(463),
    [anon_sym_DASH_DASH] = ACTIONS(463),
    [anon_sym_EQ] = ACTIONS(465),
    [anon_sym_PLUS_EQ] = ACTIONS(465),
    [anon_sym_DASH_EQ] = ACTIONS(465),
    [anon_sym_STAR_EQ] = ACTIONS(465),
    [anon_sym_SLASH_EQ] = ACTIONS(465),
    [anon_sym_PERCENT_EQ] = ACTIONS(465),
    [anon_sym_CARET_EQ] = ACTIONS(465),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(467),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [146] = {
    [sym_comment] = STATE(146),
    [sym_identifier] = ACTIONS(575),
    [anon_sym_COMMA] = ACTIONS(575),
    [anon_sym_SEMI] = ACTIONS(575),
    [anon_sym_LF] = ACTIONS(575),
    [anon_sym_CR_LF] = ACTIONS(575),
    [anon_sym_if] = ACTIONS(575),
    [anon_sym_LPAREN] = ACTIONS(575),
    [anon_sym_while] = ACTIONS(575),
    [anon_sym_do] = ACTIONS(575),
    [anon_sym_for] = ACTIONS(575),
    [anon_sym_in] = ACTIONS(575),
    [sym_break_statement] = ACTIONS(575),
    [sym_continue_statement] = ACTIONS(575),
    [anon_sym_delete] = ACTIONS(575),
    [anon_sym_exit] = ACTIONS(575),
    [anon_sym_return] = ACTIONS(575),
    [anon_sym_switch] = ACTIONS(575),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_RBRACE] = ACTIONS(575),
    [anon_sym_case] = ACTIONS(575),
    [anon_sym_default] = ACTIONS(575),
    [anon_sym_getline] = ACTIONS(575),
    [anon_sym_LT] = ACTIONS(575),
    [sym_next_statement] = ACTIONS(575),
    [sym_nextfile_statement] = ACTIONS(575),
    [anon_sym_print] = ACTIONS(575),
    [anon_sym_printf] = ACTIONS(575),
    [anon_sym_GT] = ACTIONS(575),
    [anon_sym_GT_GT] = ACTIONS(575),
    [anon_sym_PIPE] = ACTIONS(575),
    [anon_sym_PIPE_AMP] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(575),
    [anon_sym_CARET] = ACTIONS(575),
    [anon_sym_STAR_STAR] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(575),
    [anon_sym_SLASH] = ACTIONS(575),
    [anon_sym_PERCENT] = ACTIONS(575),
    [anon_sym_PLUS] = ACTIONS(575),
    [anon_sym_DASH] = ACTIONS(575),
    [anon_sym_LT_EQ] = ACTIONS(575),
    [anon_sym_GT_EQ] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_BANG_EQ] = ACTIONS(575),
    [anon_sym_TILDE] = ACTIONS(575),
    [anon_sym_BANG_TILDE] = ACTIONS(575),
    [anon_sym_AMP_AMP] = ACTIONS(575),
    [anon_sym_PIPE_PIPE] = ACTIONS(575),
    [anon_sym_BANG] = ACTIONS(575),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_EQ] = ACTIONS(575),
    [anon_sym_PLUS_EQ] = ACTIONS(575),
    [anon_sym_DASH_EQ] = ACTIONS(575),
    [anon_sym_STAR_EQ] = ACTIONS(575),
    [anon_sym_SLASH_EQ] = ACTIONS(575),
    [anon_sym_PERCENT_EQ] = ACTIONS(575),
    [anon_sym_CARET_EQ] = ACTIONS(575),
    [anon_sym_DOLLAR] = ACTIONS(575),
    [anon_sym_AT] = ACTIONS(575),
    [sym_number] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(575),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(577),
    [sym__if_else_separator] = ACTIONS(577),
  },
  [147] = {
    [sym_comment] = STATE(147),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_COMMA] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_CR_LF] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_in] = ACTIONS(441),
    [sym_break_statement] = ACTIONS(441),
    [sym_continue_statement] = ACTIONS(441),
    [anon_sym_delete] = ACTIONS(441),
    [anon_sym_exit] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_RBRACE] = ACTIONS(441),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_getline] = ACTIONS(441),
    [anon_sym_LT] = ACTIONS(441),
    [sym_next_statement] = ACTIONS(441),
    [sym_nextfile_statement] = ACTIONS(441),
    [anon_sym_print] = ACTIONS(441),
    [anon_sym_printf] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_STAR_STAR] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_LT_EQ] = ACTIONS(441),
    [anon_sym_GT_EQ] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(441),
    [anon_sym_BANG_EQ] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_BANG_TILDE] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(441),
    [anon_sym_PIPE_PIPE] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS_PLUS] = ACTIONS(441),
    [anon_sym_DASH_DASH] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(441),
    [anon_sym_DASH_EQ] = ACTIONS(441),
    [anon_sym_STAR_EQ] = ACTIONS(441),
    [anon_sym_SLASH_EQ] = ACTIONS(441),
    [anon_sym_PERCENT_EQ] = ACTIONS(441),
    [anon_sym_CARET_EQ] = ACTIONS(441),
    [anon_sym_DOLLAR] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(441),
    [sym_number] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(441),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(443),
  },
  [148] = {
    [sym_comment] = STATE(148),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
  },
  [149] = {
    [sym_comment] = STATE(149),
    [sym_identifier] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(423),
    [anon_sym_CR_LF] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(423),
    [anon_sym_do] = ACTIONS(423),
    [anon_sym_for] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(423),
    [sym_continue_statement] = ACTIONS(423),
    [anon_sym_delete] = ACTIONS(423),
    [anon_sym_exit] = ACTIONS(423),
    [anon_sym_return] = ACTIONS(423),
    [anon_sym_switch] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(423),
    [anon_sym_default] = ACTIONS(423),
    [anon_sym_getline] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(423),
    [sym_nextfile_statement] = ACTIONS(423),
    [anon_sym_print] = ACTIONS(423),
    [anon_sym_printf] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(423),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_DOLLAR] = ACTIONS(423),
    [anon_sym_AT] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(433),
    [sym__if_else_separator] = ACTIONS(433),
  },
  [150] = {
    [sym_comment] = STATE(150),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_LPAREN2] = ACTIONS(455),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_STAR_EQ] = ACTIONS(461),
    [anon_sym_SLASH_EQ] = ACTIONS(461),
    [anon_sym_PERCENT_EQ] = ACTIONS(461),
    [anon_sym_CARET_EQ] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
  [151] = {
    [sym_comment] = STATE(151),
    [sym_identifier] = ACTIONS(579),
    [anon_sym_COMMA] = ACTIONS(579),
    [anon_sym_SEMI] = ACTIONS(579),
    [anon_sym_LF] = ACTIONS(579),
    [anon_sym_CR_LF] = ACTIONS(579),
    [anon_sym_if] = ACTIONS(579),
    [anon_sym_LPAREN] = ACTIONS(579),
    [anon_sym_while] = ACTIONS(579),
    [anon_sym_do] = ACTIONS(579),
    [anon_sym_for] = ACTIONS(579),
    [anon_sym_in] = ACTIONS(579),
    [sym_break_statement] = ACTIONS(579),
    [sym_continue_statement] = ACTIONS(579),
    [anon_sym_delete] = ACTIONS(579),
    [anon_sym_exit] = ACTIONS(579),
    [anon_sym_return] = ACTIONS(579),
    [anon_sym_switch] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_RBRACE] = ACTIONS(579),
    [anon_sym_case] = ACTIONS(579),
    [anon_sym_default] = ACTIONS(579),
    [anon_sym_getline] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(579),
    [sym_next_statement] = ACTIONS(579),
    [sym_nextfile_statement] = ACTIONS(579),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_printf] = ACTIONS(579),
    [anon_sym_GT] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(579),
    [anon_sym_PIPE] = ACTIONS(579),
    [anon_sym_PIPE_AMP] = ACTIONS(579),
    [anon_sym_QMARK] = ACTIONS(579),
    [anon_sym_CARET] = ACTIONS(579),
    [anon_sym_STAR_STAR] = ACTIONS(579),
    [anon_sym_STAR] = ACTIONS(579),
    [anon_sym_SLASH] = ACTIONS(579),
    [anon_sym_PERCENT] = ACTIONS(579),
    [anon_sym_PLUS] = ACTIONS(579),
    [anon_sym_DASH] = ACTIONS(579),
    [anon_sym_LT_EQ] = ACTIONS(579),
    [anon_sym_GT_EQ] = ACTIONS(579),
    [anon_sym_EQ_EQ] = ACTIONS(579),
    [anon_sym_BANG_EQ] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(579),
    [anon_sym_BANG_TILDE] = ACTIONS(579),
    [anon_sym_AMP_AMP] = ACTIONS(579),
    [anon_sym_PIPE_PIPE] = ACTIONS(579),
    [anon_sym_BANG] = ACTIONS(579),
    [anon_sym_PLUS_PLUS] = ACTIONS(579),
    [anon_sym_DASH_DASH] = ACTIONS(579),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_PLUS_EQ] = ACTIONS(579),
    [anon_sym_DASH_EQ] = ACTIONS(579),
    [anon_sym_STAR_EQ] = ACTIONS(579),
    [anon_sym_SLASH_EQ] = ACTIONS(579),
    [anon_sym_PERCENT_EQ] = ACTIONS(579),
    [anon_sym_CARET_EQ] = ACTIONS(579),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(579),
    [sym_number] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(581),
    [sym__if_else_separator] = ACTIONS(581),
  },
  [152] = {
    [sym_comment] = STATE(152),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_CR_LF] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(423),
    [sym_break_statement] = ACTIONS(435),
    [sym_continue_statement] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_exit] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_getline] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(423),
    [sym_next_statement] = ACTIONS(435),
    [sym_nextfile_statement] = ACTIONS(435),
    [anon_sym_print] = ACTIONS(435),
    [anon_sym_printf] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_PIPE_AMP] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(423),
    [anon_sym_DASH] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_BANG_TILDE] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(437),
    [anon_sym_DASH_DASH] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(461),
    [anon_sym_DASH_EQ] = ACTIONS(461),
    [anon_sym_STAR_EQ] = ACTIONS(461),
    [anon_sym_SLASH_EQ] = ACTIONS(461),
    [anon_sym_PERCENT_EQ] = ACTIONS(461),
    [anon_sym_CARET_EQ] = ACTIONS(461),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [anon_sym_AT] = ACTIONS(435),
    [sym_number] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_POUND] = ACTIONS(83),
    [sym_concatenating_space] = ACTIONS(439),
    [sym__if_else_separator] = ACTIONS(439),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(565), 1,
      sym_concatenating_space,
    STATE(153), 1,
      sym_comment,
    ACTIONS(563), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [73] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    STATE(154), 1,
      sym_comment,
    ACTIONS(433), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(457), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(459), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [152] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    STATE(155), 1,
      sym_comment,
    ACTIONS(423), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [225] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(479), 1,
      sym_concatenating_space,
    STATE(156), 1,
      sym_comment,
    ACTIONS(477), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [298] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(439), 1,
      sym_concatenating_space,
    STATE(157), 1,
      sym_comment,
    ACTIONS(437), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 21,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 38,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [375] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(577), 1,
      sym_concatenating_space,
    STATE(158), 1,
      sym_comment,
    ACTIONS(575), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [448] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(443), 1,
      sym_concatenating_space,
    STATE(159), 1,
      sym_comment,
    ACTIONS(441), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [521] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(517), 1,
      sym_concatenating_space,
    STATE(160), 1,
      sym_comment,
    ACTIONS(515), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [594] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    STATE(161), 1,
      sym_comment,
    ACTIONS(449), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 59,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [669] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    STATE(162), 1,
      sym_comment,
    ACTIONS(423), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [742] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(505), 1,
      sym_concatenating_space,
    STATE(163), 1,
      sym_comment,
    ACTIONS(503), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [815] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    ACTIONS(447), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      anon_sym_LPAREN2,
    STATE(164), 1,
      sym_comment,
    ACTIONS(571), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(573), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [896] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(483), 1,
      sym_concatenating_space,
    STATE(165), 1,
      sym_comment,
    ACTIONS(481), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [969] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(501), 1,
      sym_concatenating_space,
    ACTIONS(583), 1,
      sym_identifier,
    ACTIONS(585), 1,
      anon_sym_LT,
    STATE(166), 1,
      sym_comment,
    STATE(207), 1,
      sym_ns_qualified_name,
    STATE(1808), 1,
      sym_namespace,
    ACTIONS(499), 57,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [1050] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(471), 1,
      sym_concatenating_space,
    STATE(167), 1,
      sym_comment,
    ACTIONS(469), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1123] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(433), 1,
      sym__if_else_separator,
    ACTIONS(467), 1,
      sym_concatenating_space,
    STATE(168), 1,
      sym_comment,
    ACTIONS(463), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(465), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1204] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(581), 1,
      sym_concatenating_space,
    STATE(169), 1,
      sym_comment,
    ACTIONS(579), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1277] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(439), 1,
      sym_concatenating_space,
    STATE(170), 1,
      sym_comment,
    ACTIONS(423), 21,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 40,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1352] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(171), 1,
      sym_comment,
    ACTIONS(453), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(451), 60,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1425] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(589), 1,
      sym_regex_flags,
    STATE(172), 1,
      sym_comment,
    ACTIONS(591), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(587), 59,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1500] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(521), 1,
      sym_concatenating_space,
    STATE(173), 1,
      sym_comment,
    ACTIONS(519), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1573] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(513), 1,
      sym_concatenating_space,
    STATE(174), 1,
      sym_comment,
    ACTIONS(511), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1646] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(487), 1,
      sym_concatenating_space,
    STATE(175), 1,
      sym_comment,
    ACTIONS(485), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1719] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(509), 1,
      sym_concatenating_space,
    STATE(176), 1,
      sym_comment,
    ACTIONS(507), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1792] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(501), 1,
      sym_concatenating_space,
    ACTIONS(593), 1,
      sym_identifier,
    STATE(167), 1,
      sym_ns_qualified_name,
    STATE(177), 1,
      sym_comment,
    STATE(1808), 1,
      sym_namespace,
    ACTIONS(499), 58,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [1871] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(178), 1,
      sym_comment,
    ACTIONS(539), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [1944] = 9,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(439), 1,
      sym_concatenating_space,
    ACTIONS(447), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      anon_sym_LPAREN2,
    STATE(179), 1,
      sym_comment,
    ACTIONS(437), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(461), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 21,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 29,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2027] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(533), 1,
      sym_concatenating_space,
    STATE(180), 1,
      sym_comment,
    ACTIONS(531), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2100] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(439), 1,
      sym_concatenating_space,
    STATE(181), 1,
      sym_comment,
    ACTIONS(437), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(461), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 21,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2179] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(447), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      anon_sym_LPAREN2,
    ACTIONS(529), 1,
      sym_concatenating_space,
    STATE(182), 1,
      sym_comment,
    ACTIONS(525), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(527), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2260] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(595), 1,
      anon_sym_LT,
    STATE(183), 1,
      sym_comment,
    ACTIONS(471), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(469), 58,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2337] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(495), 1,
      sym_concatenating_space,
    STATE(184), 1,
      sym_comment,
    ACTIONS(493), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2410] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(537), 1,
      sym_concatenating_space,
    STATE(185), 1,
      sym_comment,
    ACTIONS(535), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2483] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(491), 1,
      sym_concatenating_space,
    STATE(186), 1,
      sym_comment,
    ACTIONS(489), 61,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2556] = 26,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(149), 1,
      anon_sym_getline,
    ACTIONS(597), 1,
      anon_sym_LPAREN,
    ACTIONS(599), 1,
      anon_sym_LPAREN2,
    ACTIONS(601), 1,
      anon_sym_SLASH,
    ACTIONS(605), 1,
      anon_sym_DOLLAR,
    ACTIONS(607), 1,
      anon_sym_AT,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      anon_sym_DQUOTE,
    STATE(182), 1,
      sym_ns_qualified_name,
    STATE(187), 1,
      sym_comment,
    STATE(203), 1,
      sym_array_ref,
    STATE(208), 1,
      sym_field_ref,
    STATE(330), 1,
      sym_string,
    STATE(393), 1,
      sym__exp,
    STATE(610), 1,
      sym_exp_list,
    STATE(611), 1,
      sym__print_args,
    STATE(685), 1,
      aux_sym_exp_list_repeat1,
    STATE(1729), 1,
      sym_namespace,
    ACTIONS(603), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(392), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(157), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(381), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(391), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    ACTIONS(543), 23,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
  [2673] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(471), 1,
      sym_concatenating_space,
    ACTIONS(613), 1,
      anon_sym_LT,
    STATE(188), 1,
      sym_comment,
    ACTIONS(469), 58,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2749] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(189), 1,
      sym_comment,
    ACTIONS(433), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(457), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(459), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2825] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(190), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(539), 57,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2899] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(191), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 54,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [2975] = 9,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(192), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 44,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3057] = 11,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(625), 1,
      anon_sym_in,
    STATE(193), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(627), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 41,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3143] = 12,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(625), 1,
      anon_sym_in,
    ACTIONS(629), 1,
      anon_sym_AMP_AMP,
    STATE(194), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(627), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 40,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3231] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    ACTIONS(447), 1,
      anon_sym_LBRACK,
    STATE(195), 1,
      sym_comment,
    ACTIONS(571), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(573), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3309] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(625), 1,
      anon_sym_in,
    ACTIONS(629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(633), 1,
      anon_sym_QMARK,
    ACTIONS(635), 1,
      anon_sym_PIPE_PIPE,
    STATE(196), 1,
      sym_comment,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(627), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(637), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(631), 38,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3401] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(197), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3481] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(595), 1,
      anon_sym_LT,
    STATE(198), 1,
      sym_comment,
    ACTIONS(471), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(469), 58,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3555] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym__if_else_separator,
    ACTIONS(467), 1,
      sym_concatenating_space,
    STATE(199), 1,
      sym_comment,
    ACTIONS(463), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(465), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3633] = 10,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(200), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(627), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 42,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3717] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(625), 1,
      anon_sym_in,
    ACTIONS(629), 1,
      anon_sym_AMP_AMP,
    ACTIONS(633), 1,
      anon_sym_QMARK,
    ACTIONS(635), 1,
      anon_sym_PIPE_PIPE,
    STATE(201), 1,
      sym_comment,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(621), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(627), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(641), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 38,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3809] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(591), 1,
      sym_concatenating_space,
    ACTIONS(643), 1,
      sym_regex_flags,
    STATE(202), 1,
      sym_comment,
    ACTIONS(587), 59,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3883] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(447), 1,
      anon_sym_LBRACK,
    ACTIONS(529), 1,
      sym_concatenating_space,
    STATE(203), 1,
      sym_comment,
    ACTIONS(525), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(527), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [3961] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(204), 1,
      sym_comment,
    ACTIONS(615), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(623), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(647), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(645), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4039] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      sym_concatenating_space,
    STATE(205), 1,
      sym_comment,
    ACTIONS(451), 60,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4111] = 11,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    ACTIONS(649), 1,
      anon_sym_in,
    STATE(206), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(651), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 41,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4196] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(471), 1,
      sym_concatenating_space,
    ACTIONS(613), 1,
      anon_sym_LT,
    STATE(207), 1,
      sym_comment,
    ACTIONS(469), 58,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4269] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(529), 1,
      sym_concatenating_space,
    STATE(208), 1,
      sym_comment,
    ACTIONS(525), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(527), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4344] = 9,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(209), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(651), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 44,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4425] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(647), 1,
      sym_concatenating_space,
    STATE(210), 1,
      sym_comment,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(645), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4502] = 12,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    ACTIONS(649), 1,
      anon_sym_in,
    ACTIONS(663), 1,
      anon_sym_AMP_AMP,
    STATE(211), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(651), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 40,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4589] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(212), 1,
      sym_comment,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 54,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4664] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(213), 1,
      sym_comment,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(539), 57,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4737] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(637), 1,
      sym_concatenating_space,
    ACTIONS(649), 1,
      anon_sym_in,
    ACTIONS(663), 1,
      anon_sym_AMP_AMP,
    ACTIONS(665), 1,
      anon_sym_QMARK,
    ACTIONS(667), 1,
      anon_sym_PIPE_PIPE,
    STATE(214), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(651), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(631), 38,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4828] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    STATE(215), 1,
      sym_comment,
    ACTIONS(571), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(573), 7,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4903] = 10,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(216), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(651), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 42,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [4986] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(217), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [5065] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(641), 1,
      sym_concatenating_space,
    ACTIONS(649), 1,
      anon_sym_in,
    ACTIONS(663), 1,
      anon_sym_AMP_AMP,
    ACTIONS(665), 1,
      anon_sym_QMARK,
    ACTIONS(667), 1,
      anon_sym_PIPE_PIPE,
    STATE(218), 1,
      sym_comment,
    ACTIONS(653), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(655), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(659), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(657), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(651), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 38,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [5156] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(669), 1,
      anon_sym_LPAREN2,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(219), 1,
      sym_comment,
    ACTIONS(671), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 23,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_COLON,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 30,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5233] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(669), 1,
      anon_sym_LPAREN2,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(220), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 13,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(439), 19,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5314] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(221), 1,
      sym_comment,
    ACTIONS(451), 22,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(453), 35,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LPAREN2,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5382] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(222), 1,
      sym_comment,
    ACTIONS(441), 22,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_COLON,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(443), 33,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5454] = 9,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(669), 1,
      anon_sym_LPAREN2,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(223), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 12,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(439), 20,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5532] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(669), 1,
      anon_sym_LPAREN2,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(224), 1,
      sym_comment,
    ACTIONS(671), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 22,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 31,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5606] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      sym__if_else_separator,
    STATE(225), 1,
      sym_comment,
    ACTIONS(451), 55,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [5673] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(226), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(439), 21,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5748] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(227), 1,
      sym_comment,
    ACTIONS(473), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(475), 35,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5815] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(475), 1,
      sym__if_else_separator,
    STATE(228), 1,
      sym_comment,
    ACTIONS(473), 55,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [5882] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(229), 1,
      sym_comment,
    ACTIONS(441), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(443), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [5951] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(677), 1,
      sym_identifier,
    STATE(230), 1,
      sym_comment,
    STATE(310), 1,
      sym_ns_qualified_name,
    STATE(1812), 1,
      sym_namespace,
    ACTIONS(501), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(499), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [6024] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(231), 1,
      sym_comment,
    ACTIONS(671), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 32,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [6095] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(232), 1,
      sym_comment,
    ACTIONS(443), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [6166] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(681), 1,
      sym_identifier,
    ACTIONS(683), 1,
      anon_sym_LT,
    STATE(233), 1,
      sym_comment,
    STATE(287), 1,
      sym_ns_qualified_name,
    STATE(1812), 1,
      sym_namespace,
    ACTIONS(501), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(499), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [6241] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(461), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    STATE(234), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(685), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(435), 10,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(439), 15,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [6320] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    STATE(235), 1,
      sym_comment,
    ACTIONS(469), 22,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_COLON,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(471), 33,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [6389] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(236), 1,
      sym_comment,
    ACTIONS(489), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(491), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [6455] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(237), 1,
      sym_comment,
    ACTIONS(473), 55,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [6519] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(238), 1,
      sym_comment,
    ACTIONS(453), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(451), 53,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [6585] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(687), 1,
      sym_regex_flags,
    STATE(239), 1,
      sym_comment,
    ACTIONS(591), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(587), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [6653] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(443), 1,
      sym_concatenating_space,
    ACTIONS(689), 1,
      anon_sym_LBRACK,
    STATE(240), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [6723] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(241), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(439), 21,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [6795] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(501), 1,
      sym_concatenating_space,
    ACTIONS(691), 1,
      sym_identifier,
    ACTIONS(693), 1,
      anon_sym_LT,
    STATE(242), 1,
      sym_comment,
    STATE(334), 1,
      sym_ns_qualified_name,
    STATE(1807), 1,
      sym_namespace,
    ACTIONS(499), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [6869] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(243), 1,
      sym_comment,
    ACTIONS(475), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(473), 53,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [6935] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(244), 1,
      sym_comment,
    ACTIONS(515), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(517), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7001] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(245), 1,
      sym_comment,
    ACTIONS(671), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 32,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7069] = 9,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(461), 1,
      anon_sym_EQ,
    STATE(246), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(685), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(435), 10,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(439), 15,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7145] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(247), 1,
      sym_comment,
    ACTIONS(481), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(483), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7211] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(248), 1,
      sym_comment,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(439), 23,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7281] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(249), 1,
      sym_comment,
    ACTIONS(535), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(537), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7347] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(250), 1,
      sym_comment,
    ACTIONS(539), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7413] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(251), 1,
      sym_comment,
    ACTIONS(579), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(581), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7479] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(501), 1,
      sym_concatenating_space,
    ACTIONS(695), 1,
      sym_identifier,
    STATE(252), 1,
      sym_comment,
    STATE(344), 1,
      sym_ns_qualified_name,
    STATE(1807), 1,
      sym_namespace,
    ACTIONS(499), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [7551] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(253), 1,
      sym_comment,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7617] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(254), 1,
      sym_comment,
    ACTIONS(563), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(565), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7683] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(255), 1,
      sym_comment,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7749] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    STATE(256), 1,
      sym_comment,
    ACTIONS(471), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [7817] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(257), 1,
      sym_comment,
    ACTIONS(441), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(443), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7883] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(258), 1,
      sym_comment,
    ACTIONS(485), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(487), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [7949] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(259), 1,
      sym_comment,
    ACTIONS(477), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(479), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8015] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(260), 1,
      sym_comment,
    ACTIONS(503), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(505), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8081] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(261), 1,
      sym_comment,
    ACTIONS(493), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(495), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8147] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(679), 1,
      anon_sym_LBRACK,
    STATE(262), 1,
      sym_comment,
    ACTIONS(443), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [8215] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(263), 1,
      sym_comment,
    ACTIONS(531), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(533), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8281] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(264), 1,
      sym_comment,
    ACTIONS(575), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(577), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8347] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(265), 1,
      sym_comment,
    ACTIONS(507), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(509), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8413] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(697), 1,
      anon_sym_LT,
    STATE(266), 1,
      sym_comment,
    ACTIONS(471), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [8483] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(501), 1,
      sym__if_else_separator,
    ACTIONS(699), 1,
      sym_identifier,
    ACTIONS(701), 1,
      anon_sym_LT,
    STATE(267), 1,
      sym_comment,
    STATE(355), 1,
      sym_ns_qualified_name,
    STATE(1811), 1,
      sym_namespace,
    ACTIONS(499), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [8557] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(268), 1,
      sym_comment,
    ACTIONS(511), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(513), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8623] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(269), 1,
      sym_comment,
    ACTIONS(519), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(521), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [8689] = 23,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(321), 1,
      sym_identifier,
    ACTIONS(337), 1,
      anon_sym_getline,
    ACTIONS(545), 1,
      anon_sym_LPAREN,
    ACTIONS(549), 1,
      anon_sym_SLASH,
    ACTIONS(553), 1,
      anon_sym_DOLLAR,
    ACTIONS(555), 1,
      anon_sym_AT,
    ACTIONS(557), 1,
      sym_number,
    ACTIONS(559), 1,
      anon_sym_DQUOTE,
    ACTIONS(705), 1,
      sym__if_else_separator,
    STATE(145), 1,
      sym_ns_qualified_name,
    STATE(168), 1,
      sym_array_ref,
    STATE(199), 1,
      sym_field_ref,
    STATE(270), 1,
      sym_comment,
    STATE(294), 1,
      sym_string,
    STATE(423), 1,
      sym__exp,
    STATE(1810), 1,
      sym_namespace,
    ACTIONS(551), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(354), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(345), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(286), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(353), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    ACTIONS(703), 19,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
  [8793] = 23,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(321), 1,
      sym_identifier,
    ACTIONS(337), 1,
      anon_sym_getline,
    ACTIONS(545), 1,
      anon_sym_LPAREN,
    ACTIONS(549), 1,
      anon_sym_SLASH,
    ACTIONS(553), 1,
      anon_sym_DOLLAR,
    ACTIONS(555), 1,
      anon_sym_AT,
    ACTIONS(557), 1,
      sym_number,
    ACTIONS(559), 1,
      anon_sym_DQUOTE,
    ACTIONS(709), 1,
      sym__if_else_separator,
    STATE(145), 1,
      sym_ns_qualified_name,
    STATE(168), 1,
      sym_array_ref,
    STATE(199), 1,
      sym_field_ref,
    STATE(271), 1,
      sym_comment,
    STATE(294), 1,
      sym_string,
    STATE(424), 1,
      sym__exp,
    STATE(1810), 1,
      sym_namespace,
    ACTIONS(551), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(354), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(345), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(286), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(353), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    ACTIONS(707), 19,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
  [8897] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(443), 1,
      sym__if_else_separator,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    STATE(272), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [8967] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(273), 1,
      sym_comment,
    ACTIONS(451), 55,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9031] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(274), 1,
      sym_comment,
    ACTIONS(469), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(471), 34,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_RBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [9097] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(501), 1,
      sym__if_else_separator,
    ACTIONS(713), 1,
      sym_identifier,
    STATE(275), 1,
      sym_comment,
    STATE(367), 1,
      sym_ns_qualified_name,
    STATE(1811), 1,
      sym_namespace,
    ACTIONS(499), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [9169] = 22,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(149), 1,
      anon_sym_getline,
    ACTIONS(597), 1,
      anon_sym_LPAREN,
    ACTIONS(601), 1,
      anon_sym_SLASH,
    ACTIONS(605), 1,
      anon_sym_DOLLAR,
    ACTIONS(607), 1,
      anon_sym_AT,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      anon_sym_DQUOTE,
    STATE(182), 1,
      sym_ns_qualified_name,
    STATE(203), 1,
      sym_array_ref,
    STATE(208), 1,
      sym_field_ref,
    STATE(276), 1,
      sym_comment,
    STATE(330), 1,
      sym_string,
    STATE(432), 1,
      sym__exp,
    STATE(1729), 1,
      sym_namespace,
    ACTIONS(603), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(392), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(157), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(381), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(391), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    ACTIONS(703), 19,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
  [9270] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(715), 1,
      sym_identifier,
    ACTIONS(717), 1,
      anon_sym_LT,
    STATE(277), 1,
      sym_comment,
    STATE(398), 1,
      sym_ns_qualified_name,
    STATE(1801), 1,
      sym_namespace,
    ACTIONS(499), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [9341] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(443), 1,
      sym__if_else_separator,
    ACTIONS(711), 1,
      anon_sym_LBRACK,
    STATE(278), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9408] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(279), 1,
      sym_comment,
    ACTIONS(537), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(535), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9473] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(280), 1,
      sym_comment,
    ACTIONS(581), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(579), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9538] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(471), 1,
      sym__if_else_separator,
    STATE(281), 1,
      sym_comment,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9605] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(282), 1,
      sym_comment,
    ACTIONS(505), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(503), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9670] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(283), 1,
      sym_comment,
    ACTIONS(433), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9735] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(284), 1,
      sym_comment,
    ACTIONS(565), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(563), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9800] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(285), 1,
      sym_comment,
    ACTIONS(433), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9865] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym__if_else_separator,
    ACTIONS(467), 1,
      sym_concatenating_space,
    STATE(286), 1,
      sym_comment,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9932] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(697), 1,
      anon_sym_LT,
    STATE(287), 1,
      sym_comment,
    ACTIONS(471), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [9999] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      sym_concatenating_space,
    STATE(288), 1,
      sym_comment,
    ACTIONS(451), 53,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10064] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(289), 1,
      sym_comment,
    ACTIONS(443), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10129] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(475), 1,
      sym_concatenating_space,
    STATE(290), 1,
      sym_comment,
    ACTIONS(473), 53,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10194] = 31,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(719), 1,
      ts_builtin_sym_end,
    ACTIONS(721), 1,
      sym_identifier,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(733), 1,
      anon_sym_LBRACE,
    ACTIONS(736), 1,
      anon_sym_getline,
    ACTIONS(739), 1,
      anon_sym_SLASH,
    ACTIONS(745), 1,
      anon_sym_BANG,
    ACTIONS(751), 1,
      anon_sym_DOLLAR,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(757), 1,
      sym_number,
    ACTIONS(760), 1,
      anon_sym_DQUOTE,
    STATE(348), 1,
      sym_ns_qualified_name,
    STATE(409), 1,
      sym_array_ref,
    STATE(415), 1,
      sym_field_ref,
    STATE(479), 1,
      sym_string,
    STATE(514), 1,
      sym__exp,
    STATE(1408), 1,
      sym_pattern,
    STATE(1422), 1,
      sym_block,
    STATE(1853), 1,
      sym_namespace,
    ACTIONS(742), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(748), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(763), 2,
      anon_sym_function,
      anon_sym_func,
    STATE(291), 2,
      sym_comment,
      aux_sym_program_repeat1,
    STATE(513), 2,
      sym_getline_input,
      sym_getline_file,
    STATE(1415), 2,
      sym_range_pattern,
      sym__special_pattern,
    ACTIONS(727), 3,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
    STATE(1418), 3,
      sym_rule,
      sym_directive,
      sym_func_def,
    ACTIONS(724), 4,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
    STATE(471), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(503), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
  [10313] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(591), 1,
      sym_concatenating_space,
    ACTIONS(766), 1,
      sym_regex_flags,
    STATE(292), 1,
      sym_comment,
    ACTIONS(587), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10380] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(293), 1,
      sym_comment,
    ACTIONS(487), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(485), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10445] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(294), 1,
      sym_comment,
    ACTIONS(517), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(515), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10510] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(295), 1,
      sym_comment,
    ACTIONS(479), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(477), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10575] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(296), 1,
      sym_comment,
    ACTIONS(491), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(489), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10640] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(297), 1,
      sym_comment,
    ACTIONS(495), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(493), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10705] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    STATE(298), 1,
      sym_comment,
    ACTIONS(641), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10790] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(299), 1,
      sym_comment,
    ACTIONS(509), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(507), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10855] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(300), 1,
      sym_comment,
    ACTIONS(513), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(511), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10920] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(301), 1,
      sym_comment,
    ACTIONS(521), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(519), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [10985] = 22,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(149), 1,
      anon_sym_getline,
    ACTIONS(597), 1,
      anon_sym_LPAREN,
    ACTIONS(601), 1,
      anon_sym_SLASH,
    ACTIONS(605), 1,
      anon_sym_DOLLAR,
    ACTIONS(607), 1,
      anon_sym_AT,
    ACTIONS(609), 1,
      sym_number,
    ACTIONS(611), 1,
      anon_sym_DQUOTE,
    STATE(182), 1,
      sym_ns_qualified_name,
    STATE(203), 1,
      sym_array_ref,
    STATE(208), 1,
      sym_field_ref,
    STATE(302), 1,
      sym_comment,
    STATE(330), 1,
      sym_string,
    STATE(431), 1,
      sym__exp,
    STATE(1729), 1,
      sym_namespace,
    ACTIONS(603), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(392), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(157), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(381), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(391), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    ACTIONS(707), 19,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
  [11086] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(471), 1,
      sym__if_else_separator,
    ACTIONS(788), 1,
      anon_sym_LT,
    STATE(303), 1,
      sym_comment,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11155] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(304), 1,
      sym_comment,
    ACTIONS(647), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(645), 45,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11226] = 32,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(17), 1,
      anon_sym_getline,
    ACTIONS(19), 1,
      anon_sym_SLASH,
    ACTIONS(23), 1,
      anon_sym_BANG,
    ACTIONS(27), 1,
      anon_sym_DOLLAR,
    ACTIONS(29), 1,
      anon_sym_AT,
    ACTIONS(31), 1,
      sym_number,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(790), 1,
      ts_builtin_sym_end,
    STATE(291), 1,
      aux_sym_program_repeat1,
    STATE(305), 1,
      sym_comment,
    STATE(348), 1,
      sym_ns_qualified_name,
    STATE(409), 1,
      sym_array_ref,
    STATE(415), 1,
      sym_field_ref,
    STATE(479), 1,
      sym_string,
    STATE(514), 1,
      sym__exp,
    STATE(1408), 1,
      sym_pattern,
    STATE(1422), 1,
      sym_block,
    STATE(1853), 1,
      sym_namespace,
    ACTIONS(21), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(35), 2,
      anon_sym_function,
      anon_sym_func,
    STATE(513), 2,
      sym_getline_input,
      sym_getline_file,
    STATE(1415), 2,
      sym_range_pattern,
      sym__special_pattern,
    ACTIONS(11), 3,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
    STATE(1418), 3,
      sym_rule,
      sym_directive,
      sym_func_def,
    ACTIONS(9), 4,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
    STATE(471), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(503), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
  [11347] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(471), 1,
      sym_concatenating_space,
    STATE(306), 1,
      sym_comment,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11414] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(307), 1,
      sym_comment,
    ACTIONS(483), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(481), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11479] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(308), 1,
      sym_comment,
    ACTIONS(439), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(423), 21,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11546] = 10,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(309), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 35,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11623] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(310), 1,
      sym_comment,
    ACTIONS(471), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11688] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(311), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 43,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11761] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(312), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(539), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11826] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(313), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(539), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11893] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(314), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 47,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [11962] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(315), 1,
      sym_comment,
    ACTIONS(577), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(575), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12027] = 9,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(316), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 37,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12102] = 12,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(461), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(792), 1,
      anon_sym_LPAREN2,
    STATE(317), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(685), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(439), 10,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
  [12183] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(591), 1,
      sym__if_else_separator,
    ACTIONS(794), 1,
      sym_regex_flags,
    STATE(318), 1,
      sym_comment,
    ACTIONS(587), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12250] = 11,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    STATE(319), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 34,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12329] = 12,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    STATE(320), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 33,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12410] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(321), 1,
      sym_comment,
    ACTIONS(533), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(531), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12475] = 11,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(792), 1,
      anon_sym_LPAREN2,
    ACTIONS(798), 1,
      anon_sym_EQ,
    ACTIONS(802), 1,
      sym_concatenating_space,
    STATE(322), 1,
      sym_comment,
    ACTIONS(796), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(800), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(433), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
  [12554] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(804), 1,
      sym_identifier,
    STATE(323), 1,
      sym_comment,
    STATE(411), 1,
      sym_ns_qualified_name,
    STATE(1801), 1,
      sym_namespace,
    ACTIONS(499), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_number,
      anon_sym_DQUOTE,
  [12623] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    STATE(324), 1,
      sym_comment,
    ACTIONS(637), 2,
      sym_concatenating_space,
      sym__if_else_separator,
    ACTIONS(772), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(631), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12708] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(471), 1,
      sym_concatenating_space,
    ACTIONS(806), 1,
      anon_sym_LT,
    STATE(325), 1,
      sym_comment,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12777] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(443), 1,
      sym_concatenating_space,
    ACTIONS(689), 1,
      anon_sym_LBRACK,
    STATE(326), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12844] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(808), 1,
      anon_sym_LBRACK,
    STATE(327), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [12911] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(792), 1,
      anon_sym_LPAREN2,
    ACTIONS(812), 1,
      anon_sym_EQ,
    STATE(328), 1,
      sym_comment,
    ACTIONS(810), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(814), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 21,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [12988] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(641), 1,
      sym__if_else_separator,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    STATE(329), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13072] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(517), 1,
      sym_concatenating_space,
    STATE(330), 1,
      sym_comment,
    ACTIONS(515), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13136] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(479), 1,
      sym_concatenating_space,
    STATE(331), 1,
      sym_comment,
    ACTIONS(477), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13200] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(487), 1,
      sym_concatenating_space,
    STATE(332), 1,
      sym_comment,
    ACTIONS(485), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13264] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(443), 1,
      sym_concatenating_space,
    STATE(333), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13328] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(471), 1,
      sym_concatenating_space,
    ACTIONS(806), 1,
      anon_sym_LT,
    STATE(334), 1,
      sym_comment,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13394] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    STATE(335), 1,
      sym_comment,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13458] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(565), 1,
      sym_concatenating_space,
    STATE(336), 1,
      sym_comment,
    ACTIONS(563), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13522] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym_concatenating_space,
    STATE(337), 1,
      sym_comment,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13586] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(637), 1,
      sym_concatenating_space,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(338), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(631), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13670] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(495), 1,
      sym_concatenating_space,
    STATE(339), 1,
      sym_comment,
    ACTIONS(493), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13734] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(641), 1,
      sym_concatenating_space,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(340), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13818] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(509), 1,
      sym_concatenating_space,
    STATE(341), 1,
      sym_comment,
    ACTIONS(507), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13882] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(513), 1,
      sym_concatenating_space,
    STATE(342), 1,
      sym_comment,
    ACTIONS(511), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [13946] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(521), 1,
      sym_concatenating_space,
    STATE(343), 1,
      sym_comment,
    ACTIONS(519), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14010] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(471), 1,
      sym_concatenating_space,
    STATE(344), 1,
      sym_comment,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14074] = 8,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(345), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 43,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14146] = 10,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(346), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 35,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14222] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(581), 1,
      sym__if_else_separator,
    STATE(347), 1,
      sym_comment,
    ACTIONS(579), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14286] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(792), 1,
      anon_sym_LPAREN2,
    ACTIONS(798), 1,
      anon_sym_EQ,
    ACTIONS(802), 1,
      sym_concatenating_space,
    STATE(348), 1,
      sym_comment,
    ACTIONS(796), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(800), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(433), 20,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
  [14362] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(577), 1,
      sym_concatenating_space,
    STATE(349), 1,
      sym_comment,
    ACTIONS(575), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14426] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(505), 1,
      sym_concatenating_space,
    STATE(350), 1,
      sym_comment,
    ACTIONS(503), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14490] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(581), 1,
      sym_concatenating_space,
    STATE(351), 1,
      sym_comment,
    ACTIONS(579), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14554] = 11,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(461), 1,
      anon_sym_EQ,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(792), 1,
      anon_sym_LPAREN2,
    STATE(352), 1,
      sym_comment,
    ACTIONS(675), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(685), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(439), 10,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LBRACE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
    ACTIONS(433), 11,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
  [14632] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      sym__if_else_separator,
    STATE(353), 1,
      sym_comment,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14696] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(565), 1,
      sym__if_else_separator,
    STATE(354), 1,
      sym_comment,
    ACTIONS(563), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14760] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(471), 1,
      sym__if_else_separator,
    ACTIONS(788), 1,
      anon_sym_LT,
    STATE(355), 1,
      sym_comment,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14826] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(443), 1,
      sym__if_else_separator,
    STATE(356), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14890] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(487), 1,
      sym__if_else_separator,
    STATE(357), 1,
      sym_comment,
    ACTIONS(485), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [14954] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(479), 1,
      sym__if_else_separator,
    STATE(358), 1,
      sym_comment,
    ACTIONS(477), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15018] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(491), 1,
      sym__if_else_separator,
    STATE(359), 1,
      sym_comment,
    ACTIONS(489), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15082] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(537), 1,
      sym__if_else_separator,
    STATE(360), 1,
      sym_comment,
    ACTIONS(535), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15146] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(537), 1,
      sym_concatenating_space,
    STATE(361), 1,
      sym_comment,
    ACTIONS(535), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15210] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(495), 1,
      sym__if_else_separator,
    STATE(362), 1,
      sym_comment,
    ACTIONS(493), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15274] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(509), 1,
      sym__if_else_separator,
    STATE(363), 1,
      sym_comment,
    ACTIONS(507), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15338] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(513), 1,
      sym__if_else_separator,
    STATE(364), 1,
      sym_comment,
    ACTIONS(511), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15402] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(808), 1,
      anon_sym_LBRACK,
    STATE(365), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15466] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(521), 1,
      sym__if_else_separator,
    STATE(366), 1,
      sym_comment,
    ACTIONS(519), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15530] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(471), 1,
      sym__if_else_separator,
    STATE(367), 1,
      sym_comment,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15594] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(838), 1,
      sym_identifier,
    STATE(274), 1,
      sym_ns_qualified_name,
    STATE(368), 1,
      sym_comment,
    STATE(1804), 1,
      sym_namespace,
    ACTIONS(499), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(501), 30,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [15664] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(842), 1,
      anon_sym_COMMA,
    ACTIONS(844), 1,
      sym__if_else_separator,
    STATE(369), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(840), 33,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15748] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(577), 1,
      sym__if_else_separator,
    STATE(370), 1,
      sym_comment,
    ACTIONS(575), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15812] = 7,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(647), 1,
      sym_concatenating_space,
    STATE(371), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(645), 45,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15882] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(491), 1,
      sym_concatenating_space,
    STATE(372), 1,
      sym_comment,
    ACTIONS(489), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [15946] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(846), 1,
      anon_sym_LT,
    STATE(373), 1,
      sym_comment,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16012] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(533), 1,
      sym_concatenating_space,
    STATE(374), 1,
      sym_comment,
    ACTIONS(531), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16076] = 9,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(792), 1,
      anon_sym_LPAREN2,
    ACTIONS(812), 1,
      anon_sym_EQ,
    STATE(375), 1,
      sym_comment,
    ACTIONS(810), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(814), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_LPAREN,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 21,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [16150] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(439), 1,
      sym_concatenating_space,
    STATE(376), 1,
      sym_comment,
    ACTIONS(423), 21,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(435), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16216] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    STATE(377), 1,
      sym_comment,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16280] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(848), 1,
      sym_regex_flags,
    STATE(378), 1,
      sym_comment,
    ACTIONS(587), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16344] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(850), 1,
      sym_identifier,
    ACTIONS(852), 1,
      anon_sym_LT,
    STATE(379), 1,
      sym_comment,
    STATE(417), 1,
      sym_ns_qualified_name,
    STATE(1804), 1,
      sym_namespace,
    ACTIONS(499), 19,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(501), 30,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [16416] = 12,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    STATE(380), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 33,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16496] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(529), 1,
      sym_concatenating_space,
    STATE(381), 1,
      sym_comment,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16560] = 15,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(842), 1,
      anon_sym_COMMA,
    ACTIONS(856), 1,
      sym__if_else_separator,
    STATE(382), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(854), 30,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16646] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(383), 1,
      sym_comment,
    ACTIONS(539), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16710] = 11,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    ACTIONS(818), 1,
      anon_sym_in,
    STATE(384), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 34,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16788] = 9,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(385), 1,
      sym_comment,
    ACTIONS(822), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 37,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_QMARK,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16862] = 5,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(386), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(539), 50,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16928] = 6,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(541), 1,
      sym_concatenating_space,
    STATE(387), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 47,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [16996] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(483), 1,
      sym_concatenating_space,
    STATE(388), 1,
      sym_comment,
    ACTIONS(481), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17060] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(858), 1,
      sym_regex_flags,
    STATE(389), 1,
      sym_comment,
    ACTIONS(587), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(591), 30,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [17125] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(390), 1,
      sym_comment,
    ACTIONS(579), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17186] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(391), 1,
      sym_comment,
    ACTIONS(423), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17247] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(392), 1,
      sym_comment,
    ACTIONS(563), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17308] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(842), 1,
      anon_sym_COMMA,
    STATE(393), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 5,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(840), 33,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17389] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(812), 1,
      anon_sym_EQ,
    STATE(394), 1,
      sym_comment,
    ACTIONS(810), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(814), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 22,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [17460] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(860), 1,
      anon_sym_LT,
    STATE(395), 1,
      sym_comment,
    ACTIONS(469), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(471), 30,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [17527] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(396), 1,
      sym_comment,
    ACTIONS(511), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17588] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(397), 1,
      sym_comment,
    ACTIONS(575), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17649] = 4,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(846), 1,
      anon_sym_LT,
    STATE(398), 1,
      sym_comment,
    ACTIONS(469), 51,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17712] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(399), 1,
      sym_comment,
    ACTIONS(507), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17773] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(400), 1,
      sym_comment,
    ACTIONS(441), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17834] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(401), 1,
      sym_comment,
    ACTIONS(493), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17895] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(842), 1,
      anon_sym_COMMA,
    STATE(402), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(854), 30,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [17978] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(403), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 31,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT_GT,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18059] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(404), 1,
      sym_comment,
    ACTIONS(485), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18120] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(405), 1,
      sym_comment,
    ACTIONS(477), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18181] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(406), 1,
      sym_comment,
    ACTIONS(519), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18242] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(407), 1,
      sym_comment,
    ACTIONS(489), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18303] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(408), 1,
      sym_comment,
    ACTIONS(535), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18364] = 9,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(673), 1,
      anon_sym_LBRACK,
    ACTIONS(798), 1,
      anon_sym_EQ,
    ACTIONS(802), 1,
      sym_concatenating_space,
    STATE(409), 1,
      sym_comment,
    ACTIONS(796), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(800), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18437] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(410), 1,
      sym_comment,
    ACTIONS(451), 21,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(453), 31,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      anon_sym_LBRACK,
      sym_number,
      anon_sym_DQUOTE,
  [18500] = 3,
    ACTIONS(83), 1,
      anon_sym_POUND,
    STATE(411), 1,
      sym_comment,
    ACTIONS(469), 52,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      anon_sym_in,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      anon_sym_LT,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [18561] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    STATE(412), 1,
      sym_comment,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 17,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 29,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18629] = 12,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    STATE(413), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(878), 4,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 12,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 24,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18707] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    STATE(414), 1,
      sym_comment,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(645), 15,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(647), 29,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18777] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(798), 1,
      anon_sym_EQ,
    ACTIONS(802), 1,
      sym_concatenating_space,
    STATE(415), 1,
      sym_comment,
    ACTIONS(796), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(800), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 21,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18847] = 17,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    ACTIONS(880), 1,
      anon_sym_in,
    ACTIONS(882), 1,
      anon_sym_QMARK,
    ACTIONS(886), 1,
      anon_sym_AMP_AMP,
    ACTIONS(888), 1,
      anon_sym_PIPE_PIPE,
    STATE(416), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(884), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(878), 4,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(639), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(641), 19,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18935] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(860), 1,
      anon_sym_LT,
    STATE(417), 1,
      sym_comment,
    ACTIONS(469), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(471), 30,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [18999] = 13,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    STATE(418), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(884), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(878), 4,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 12,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 22,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19079] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(85), 1,
      sym__if_else_separator,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    STATE(419), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(39), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [19161] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(812), 1,
      anon_sym_EQ,
    STATE(420), 1,
      sym_comment,
    ACTIONS(810), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(814), 6,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(423), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(433), 22,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19229] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(892), 1,
      sym__if_else_separator,
    STATE(421), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(890), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [19311] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    STATE(422), 1,
      sym_comment,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(539), 14,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 28,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19385] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(896), 1,
      sym__if_else_separator,
    STATE(423), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(894), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [19467] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(900), 1,
      sym__if_else_separator,
    STATE(424), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(898), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [19549] = 14,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(768), 1,
      anon_sym_in,
    ACTIONS(774), 1,
      anon_sym_QMARK,
    ACTIONS(784), 1,
      anon_sym_AMP_AMP,
    ACTIONS(786), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(904), 1,
      sym__if_else_separator,
    STATE(425), 1,
      sym_comment,
    ACTIONS(776), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(780), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(782), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(816), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(778), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(770), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(902), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [19631] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    STATE(426), 1,
      sym_comment,
    ACTIONS(539), 20,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 29,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19697] = 17,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    ACTIONS(880), 1,
      anon_sym_in,
    ACTIONS(882), 1,
      anon_sym_QMARK,
    ACTIONS(886), 1,
      anon_sym_AMP_AMP,
    ACTIONS(888), 1,
      anon_sym_PIPE_PIPE,
    STATE(427), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(884), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(878), 4,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(631), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(637), 19,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19785] = 14,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    ACTIONS(880), 1,
      anon_sym_in,
    STATE(428), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(884), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(878), 4,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 22,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19867] = 15,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(864), 1,
      anon_sym_CARET,
    ACTIONS(866), 1,
      anon_sym_STAR_STAR,
    ACTIONS(872), 1,
      anon_sym_PIPE,
    ACTIONS(874), 1,
      anon_sym_PIPE_AMP,
    ACTIONS(880), 1,
      anon_sym_in,
    ACTIONS(886), 1,
      anon_sym_AMP_AMP,
    STATE(429), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(884), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(868), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(878), 4,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(539), 11,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_getline,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(541), 21,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [19951] = 27,
    ACTIONS(37), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(61), 1,
      anon_sym_getline,
    ACTIONS(69), 1,
      anon_sym_SLASH,
    ACTIONS(75), 1,
      anon_sym_DOLLAR,
    ACTIONS(77), 1,
      anon_sym_AT,
    ACTIONS(79), 1,
      sym_number,
    ACTIONS(81), 1,
      anon_sym_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(547), 1,
      anon_sym_LPAREN2,
    ACTIONS(561), 1,
      sym__if_else_separator,
    STATE(430), 1,
      sym_comment,
    STATE(522), 1,
      sym_ns_qualified_name,
    STATE(534), 1,
      sym_array_ref,
    STATE(550), 1,
      sym_field_ref,
    STATE(562), 1,
      sym_exp_list,
    STATE(585), 1,
      sym__print_args,
    STATE(700), 1,
      aux_sym_exp_list_repeat1,
    STATE(1178), 1,
      sym_string,
    STATE(1243), 1,
      sym__exp,
    STATE(1810), 1,
      sym_namespace,
    ACTIONS(73), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(1196), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(71), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(1194), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    STATE(1222), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    ACTIONS(543), 10,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
  [20058] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(431), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(898), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [20137] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(432), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(894), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [20216] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(902), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [20295] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(434), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(890), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [20374] = 13,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(818), 1,
      anon_sym_in,
    ACTIONS(824), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AMP_AMP,
    ACTIONS(836), 1,
      anon_sym_PIPE_PIPE,
    STATE(435), 1,
      sym_comment,
    ACTIONS(826), 2,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
    ACTIONS(830), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(832), 2,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
    ACTIONS(862), 2,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
    ACTIONS(828), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(820), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(39), 29,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_while,
      anon_sym_do,
      anon_sym_for,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_delete,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_switch,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_getline,
      sym_next_statement,
      sym_nextfile_statement,
      anon_sym_print,
      anon_sym_printf,
      anon_sym_BANG,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      anon_sym_AT,
      sym_identifier,
      sym_number,
      anon_sym_DQUOTE,
  [20453] = 26,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(109), 1,
      anon_sym_getline,
    ACTIONS(117), 1,
      anon_sym_SLASH,
    ACTIONS(123), 1,
      anon_sym_DOLLAR,
    ACTIONS(125), 1,
      anon_sym_AT,
    ACTIONS(127), 1,
      sym_number,
    ACTIONS(129), 1,
      anon_sym_DQUOTE,
    ACTIONS(599), 1,
      anon_sym_LPAREN2,
    STATE(436), 1,
      sym_comment,
    STATE(532), 1,
      sym_ns_qualified_name,
    STATE(552), 1,
      sym_array_ref,
    STATE(572), 1,
      sym_field_ref,
    STATE(610), 1,
      sym_exp_list,
    STATE(611), 1,
      sym__print_args,
    STATE(697), 1,
      aux_sym_exp_list_repeat1,
    STATE(1232), 1,
      sym_string,
    STATE(1302), 1,
      sym__exp,
    STATE(1729), 1,
      sym_namespace,
    ACTIONS(121), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(1247), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(119), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(1248), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    STATE(1256), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    ACTIONS(543), 10,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
  [20557] = 27,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(79), 1,
      sym_number,
    ACTIONS(81), 1,
      anon_sym_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(259), 1,
      sym_identifier,
    ACTIONS(269), 1,
      anon_sym_getline,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(281), 1,
      anon_sym_DOLLAR,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(547), 1,
      anon_sym_LPAREN2,
    ACTIONS(561), 1,
      sym__if_else_separator,
    STATE(437), 1,
      sym_comment,
    STATE(551), 1,
      sym_ns_qualified_name,
    STATE(562), 1,
      sym_exp_list,
    STATE(576), 1,
      sym_array_ref,
    STATE(585), 1,
      sym__print_args,
    STATE(595), 1,
      sym_field_ref,
    STATE(683), 1,
      aux_sym_exp_list_repeat1,
    STATE(1178), 1,
      sym_string,
    STATE(1326), 1,
      sym__exp,
    STATE(1810), 1,
      sym_namespace,
    ACTIONS(279), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(1196), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(277), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(1194), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    STATE(1279), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    ACTIONS(543), 8,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_while,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
  [20662] = 26,
    ACTIONS(83), 1,
      anon_sym_POUND,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    ACTIONS(127), 1,
      sym_number,
    ACTIONS(129), 1,
      anon_sym_DQUOTE,
    ACTIONS(383), 1,
      sym_identifier,
    ACTIONS(393), 1,
      anon_sym_getline,
    ACTIONS(399), 1,
      anon_sym_SLASH,
    ACTIONS(405), 1,
      anon_sym_DOLLAR,
    ACTIONS(407), 1,
      anon_sym_AT,
    ACTIONS(599), 1,
      anon_sym_LPAREN2,
    STATE(438), 1,
      sym_comment,
    STATE(587), 1,
      sym_ns_qualified_name,
    STATE(610), 1,
      sym_exp_list,
    STATE(611), 1,
      sym__print_args,
    STATE(624), 1,
      sym_array_ref,
    STATE(669), 1,
      sym_field_ref,
    STATE(684), 1,
      aux_sym_exp_list_repeat1,
    STATE(1232), 1,
      sym_string,
    STATE(1359), 1,
      sym__exp,
    STATE(1729), 1,
      sym_namespace,
    ACTIONS(403), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(1247), 2,
      sym_getline_input,
      sym_getline_file,
    ACTIONS(401), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
    STATE(1256), 7,
      sym__getline_exp,
      sym_update_exp,
      sym_assignment_exp,
      sym_piped_io_exp,
      sym_regex,
      sym_regex_constant,
      sym_indirect_func_call,
    STATE(1320), 7,
      sym_ternary_exp,
      sym_binary_exp,
      sym_unary_exp,
      sym_string_concat,
      sym_grouping,
      sym__primitive,
      sym_func_call,
    ACTIONS(543), 8,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR_LF,
      anon_sym_while,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_PIPE,
      anon_sym_PIPE_AMP,
  [20764] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(431), 1,
      anon_sym_COLON_COLON,
    ACTIONS(906), 1,
      anon_sym_LBRACK,
    STATE(439), 1,
      sym_comment,
    ACTIONS(441), 17,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      sym_identifier,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(443), 27,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DOLLAR,
      sym_number,
      anon_sym_DQUOTE,
  [20825] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(908), 1,
      sym_identifier,
    STATE(440), 1,
      sym_comment,
    STATE(460), 1,
      sym_ns_qualified_name,
    STATE(1803), 1,
      sym_namespace,
    ACTIONS(499), 16,
      anon_sym_BEGIN,
      anon_sym_END,
      anon_sym_BEGINFILE,
      anon_sym_ENDFILE,
      anon_sym_in,
      anon_sym_getline,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_AT,
      anon_sym_function,
      anon_sym_func,
    ACTIONS(501), 27,
      sym_concatenating_space,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_ATinclude,
      anon_sym_ATload,
      anon_sym_ATnamespace,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_AMP,
      anon_sym_QMARK,
      anon_sym_CARET,
      anon_sym_STAR_STAR,
   