# 23 "asllib/SimpleLexer0.mll"
 
open Parser0 (* The type token is defined in parser.mli *)

let tr_name = function
  | "AArch32" -> QUALIFIER "AArch32"
  | "AArch64" -> QUALIFIER "AArch64"
  | "AND" -> AND
  | "CONSTRAINED_UNPREDICTABLE" -> CONSTRAINED_UNPRED
  | "DIV" -> DIV
  | "EOR" -> XOR
  | "IMPLEMENTATION_DEFINED" -> IMPLEM_DEFINED
  | "IN" -> IN
  | "IFF" -> IFF
  | "IMPLIES" -> IMPLIES
  | "MOD" -> MOD
  | "NOT" -> NOT
  | "OR" -> OR
  | "QUOT" -> QUOT
  | "REM" -> REM
  | "SEE" -> SEE
  | "UNDEFINED" -> UNDEFINED
  | "UNKNOWN" -> UNKNOWN
  | "UNPREDICTABLE" -> UNPREDICTABLE
  | "__ExceptionTaken" -> UU_EXCEPTIONTAKEN
  | "__NOP" -> UU_NOP
  | "__UNALLOCATED" -> UU_UNALLOCATED
  | "__UNPREDICTABLE" -> UU_UNPREDICTABLE
  | "__array" -> UU_ARRAY
  | "__builtin" -> UU_BUILTIN
  | "__conditional" -> UU_CONDITIONAL
  | "__config" -> UU_CONFIG
  | "__decode" -> UU_DECODE
  | "__encoding" -> UU_ENCODING
  | "__event" -> UU_EVENT
  | "__execute" -> UU_EXECUTE
  | "__field" -> UU_FIELD
  | "__function" -> UU_FUNCTION
  | "__guard" -> UU_GUARD
  | "__instruction" -> UU_INSTRUCTION
  | "__instruction_set" -> UU_INSTRUCTION_SET
  | "__map" -> UU_MAP
  | "__newmap" -> UU_NEWMAP
  | "__newevent" -> UU_NEWEVENT
  | "__operator1" -> UU_OPERATOR_ONE
  | "__operator2" -> UU_OPERATOR_TWO
  | "__opcode" -> UU_OPCODE
  | "__postdecode" -> UU_POSTDECODE
  | "__readwrite" -> UU_READWRITE
  | "__register" -> UU_REGISTER
  | "__unpredictable_unless" -> UU_UNPREDICTABLE_UNLESS
  | "__write" -> UU_WRITE
  | "array" -> ARRAY
  | "assert" -> ASSERT
  | "bit" -> BIT
  | "bits" -> BITS
  | "boolean" -> BOOLEAN
  | "case" -> CASE
  | "catch" -> CATCH
  | "constant" -> CONSTANT
  | "config" -> CONFIG
  | "DEBUG" -> DEBUG
  | "do" -> DO
  | "downto" -> DOWNTO
  | "else" -> ELSE
  | "elsif" -> ELSIF
  | "enumeration" -> ENUMERATION
  | "FALSE" -> BOOL_LIT false
  | "for" -> FOR
  | "integer" -> INTEGER
  | "if" -> IF
  | "is" -> IS
  | "let" -> LET
  | "limit" -> LIMIT
  | "of" -> OF
  | "otherwise" -> OTHERWISE
  | "real" -> REAL
  | "record" -> RECORD
  | "repeat" -> REPEAT
  | "return" -> RETURN
  | "then" -> THEN
  | "throw" -> THROW
  | "to" -> TO
  | "TRUE" -> BOOL_LIT true
  | "try" -> TRY
  | "type" -> TYPE
  | "typeof" -> TYPEOF
  | "until" -> UNTIL
  | "Unreachable" -> UNREACHABLE
  | "when" -> WHEN
  | "while" -> WHILE
  | name -> IDENTIFIER name

let string_of_token = function
  | AND -> "AND"
  | ARRAY -> "array"
  | ASSERT -> "assert"
  | BIT -> "bit"
  | BITS -> "bits"
  | BOOLEAN -> "boolean"
  | CASE -> "case"
  | CATCH -> "catch"
  | CONFIG -> "config"
  | CONSTANT -> "constant"
  | CONSTRAINED_UNPRED -> "CONSTRAINED_UNPREDICTABLE"
  | DEBUG -> "DEBUG"
  | DIV -> "DIV"
  | DO -> "do"
  | DOWNTO -> "downto"
  | ELSE -> "else"
  | ELSIF -> "elsif"
  | ENUMERATION -> "enumeration"
  | XOR -> "EOR"
  | FOR -> "for"
  | IF -> "if"
  | IFF -> "IFF"
  | IMPLEM_DEFINED -> "IMPLEMENTATION_DEFINED"
  | IMPLIES -> "IMPLIES"
  | IN -> "IN"
  | INTEGER -> "integer"
  | IS -> "is"
  | MOD -> "MOD"
  | NOT -> "NOT"
  | OF -> "of"
  | OR -> "OR"
  | OTHERWISE -> "otherwise"
  | QUOT -> "QUOT"
  | REAL -> "real"
  | RECORD -> "record"
  | REM -> "REM"
  | REPEAT -> "repeat"
  | RETURN -> "return"
  | SEE -> "SEE"
  | THEN -> "then"
  | THROW -> "throw"
  | TO -> "to"
  | TRY -> "try"
  | TYPE -> "type"
  | TYPEOF -> "typeof"
  | UNDEFINED -> "UNDEFINED"
  | UNKNOWN -> "UNKNOWN"
  | UNPREDICTABLE -> "UNPREDICTABLE"
  | UNREACHABLE -> "Unreachable"
  | UNTIL -> "until"
  | UU_ARRAY -> "__array"
  | UU_BUILTIN -> "__builtin"
  | UU_CONDITIONAL -> "__conditional"
  | UU_CONFIG -> "__config"
  | UU_DECODE -> "__decode"
  | UU_ENCODING -> "__encoding"
  | UU_EVENT -> "__event"
  | UU_EXCEPTIONTAKEN -> "__ExceptionTaken"
  | UU_EXECUTE -> "__execute"
  | UU_FIELD -> "__field"
  | UU_FUNCTION -> "__function"
  | UU_GUARD -> "__guard"
  | UU_INSTRUCTION -> "__instruction"
  | UU_INSTRUCTION_SET -> "__instruction_set"
  | UU_MAP -> "__map"
  | UU_NEWEVENT -> "__newevent"
  | UU_NEWMAP -> "__newmap"
  | UU_NOP -> "__NOP"
  | UU_OPCODE -> "__opcode"
  | UU_OPERATOR_ONE -> "__operator1"
  | UU_OPERATOR_TWO -> "__operator2"
  | UU_POSTDECODE -> "__postdecode"
  | UU_READWRITE -> "__readwrite"
  | UU_REGISTER -> "__register"
  | UU_UNALLOCATED -> "__UNALLOCATED"
  | UU_UNPREDICTABLE -> "__UNPREDICTABLE"
  | UU_UNPREDICTABLE_UNLESS -> "__unpredictable_unless"
  | UU_WRITE -> "__write"
  | WHEN -> "when"
  | WHILE -> "while"
  (* Operators *)
  | AMP -> "&"
  | AMP_AMP -> "&&"
  | BANG -> "!"
  | BANG_EQ -> "!="
  | BAR_BAR -> "||"
  | CARET -> "^"
  | COLON -> ":"
  | COMMA -> ","
  | DOT -> "."
  | DOT_DOT -> ".."
  | EQ -> "="
  | EQ_EQ -> "=="
  | EQ_GT -> "=>"
  | GT -> ">"
  | GT_EQ -> ">="
  | GT_GT -> ">>"
  | LBRACE -> "{"
  | LBRACE_LBRACE -> "{{"
  | LBRACK -> "["
  | LIMIT -> "limit"
  | LPAREN -> "("
  | LT -> "<"
  | LT_EQ -> "<="
  | LT_LT -> "<<"
  | MINUS -> "-"
  | PLUS -> "+"
  | PLUS_COLON -> "+:"
  | PLUS_PLUS -> "++"
  | RBRACE -> "}"
  | RBRACE_RBRACE -> "}}"
  | RBRACK -> "]"
  | RPAREN -> ")"
  | SEMICOLON -> ";"
  | SLASH -> "/"
  | STAR -> "*" (* Literals *)
  | BOOL_LIT b -> if b then "TRUE" else "FALSE"
  | STRING_LIT s -> "\"" ^ s ^ "\""
  | BITS_LIT bv -> Bitvector.to_string bv
  | MASK_LIT m -> "'" ^ Bitvector.mask_to_string m ^ "'"
  | INT_LIT i -> Z.to_string i
  | REAL_LIT r -> Q.to_string r
  | QUALIFIER s -> s
  (* Special values *)
  | INDENT -> "IDENT"
  | DEDENT -> "DEDENT"
  | EOF -> "EOF"
  | EOL -> "EOL"
  | LET -> "LET"
  | IDENTIFIER s -> s

# 227 "asllib/SimpleLexer0.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\208\255\209\255\001\000\003\000\005\000\215\255\216\255\
    \217\255\002\000\068\000\071\000\227\255\228\255\046\000\232\255\
    \233\255\090\000\237\255\238\255\239\255\058\000\073\000\087\000\
    \164\000\176\000\202\000\002\000\001\000\103\000\254\255\255\255\
    \251\255\003\000\250\255\112\000\204\000\249\255\206\000\248\255\
    \212\000\232\000\031\001\222\000\242\255\240\255\234\255\235\255\
    \230\255\224\255\225\255\221\255\222\255\218\255\219\255\213\255\
    \212\255\210\255\025\001\252\255\253\255\100\000\107\000\255\255\
    \254\255";
  Lexing.lex_backtrk =
   "\255\255\255\255\255\255\044\000\047\000\041\000\255\255\255\255\
    \255\255\035\000\032\000\029\000\255\255\255\255\024\000\255\255\
    \255\255\019\000\255\255\255\255\255\255\014\000\012\000\011\000\
    \010\000\010\000\047\000\047\000\003\000\026\000\255\255\255\255\
    \255\255\002\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\008\000\009\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\003\000\003\000\255\255\
    \255\255";
  Lexing.lex_default =
   "\001\000\000\000\000\000\255\255\255\255\255\255\000\000\000\000\
    \000\000\255\255\255\255\255\255\000\000\000\000\255\255\000\000\
    \000\000\255\255\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\035\000\028\000\255\255\000\000\000\000\
    \000\000\033\000\000\000\035\000\255\255\000\000\255\255\000\000\
    \255\255\255\255\255\255\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\059\000\000\000\000\000\255\255\255\255\000\000\
    \000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\030\000\031\000\255\255\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \030\000\022\000\027\000\028\000\034\000\000\000\021\000\026\000\
    \020\000\019\000\018\000\017\000\016\000\015\000\014\000\029\000\
    \025\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\013\000\012\000\011\000\010\000\009\000\054\000\
    \053\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\008\000\048\000\007\000\006\000\023\000\
    \045\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\005\000\004\000\003\000\057\000\056\000\
    \055\000\052\000\051\000\050\000\049\000\047\000\044\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\032\000\034\000\064\000\046\000\063\000\033\000\000\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\000\000\000\000\000\000\000\000\023\000\000\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\040\000\000\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\040\000\000\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\024\000\024\000\
    \024\000\024\000\038\000\000\000\036\000\000\000\038\000\000\000\
    \000\000\037\000\000\000\039\000\000\000\037\000\000\000\000\000\
    \000\000\000\000\038\000\038\000\036\000\036\000\038\000\038\000\
    \002\000\255\255\255\255\255\255\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\000\000\060\000\000\000\000\000\000\000\000\000\
    \041\000\042\000\042\000\042\000\042\000\042\000\042\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\036\000\061\000\036\000\000\000\036\000\042\000\
    \062\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\042\000\000\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\028\000\255\255\033\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\027\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\009\000\
    \009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\014\000\000\000\000\000\000\000\
    \021\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\003\000\004\000\
    \005\000\010\000\010\000\011\000\011\000\017\000\022\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\029\000\035\000\061\000\017\000\062\000\029\000\255\255\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\255\255\255\255\255\255\255\255\023\000\255\255\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\023\000\024\000\255\255\024\000\024\000\024\000\024\000\
    \024\000\024\000\024\000\024\000\024\000\024\000\025\000\255\255\
    \025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\026\000\255\255\036\000\255\255\038\000\255\255\
    \255\255\026\000\255\255\036\000\255\255\038\000\255\255\255\255\
    \255\255\255\255\026\000\026\000\036\000\036\000\038\000\038\000\
    \000\000\028\000\027\000\033\000\040\000\040\000\040\000\040\000\
    \040\000\040\000\040\000\040\000\040\000\040\000\043\000\043\000\
    \043\000\043\000\043\000\043\000\043\000\043\000\043\000\043\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\255\255\058\000\255\255\255\255\255\255\255\255\
    \025\000\041\000\041\000\041\000\041\000\041\000\041\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\026\000\058\000\036\000\255\255\038\000\041\000\
    \058\000\041\000\041\000\041\000\041\000\041\000\041\000\042\000\
    \042\000\042\000\042\000\042\000\042\000\042\000\042\000\042\000\
    \042\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \042\000\042\000\042\000\042\000\042\000\042\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \035\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\042\000\255\255\
    \042\000\042\000\042\000\042\000\042\000\042\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\058\000\255\255\255\255\255\255\255\255\255\255\255\255\
    ";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec token lexbuf =
   __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 252 "asllib/SimpleLexer0.mll"
                                  ( Lexing.new_line lexbuf; EOL )
# 420 "asllib/SimpleLexer0.ml"

  | 1 ->
# 253 "asllib/SimpleLexer0.mll"
                                  ( token lexbuf )
# 425 "asllib/SimpleLexer0.ml"

  | 2 ->
# 254 "asllib/SimpleLexer0.mll"
                                  ( token lexbuf )
# 430 "asllib/SimpleLexer0.ml"

  | 3 ->
# 255 "asllib/SimpleLexer0.mll"
                                  ( token lexbuf )
# 435 "asllib/SimpleLexer0.ml"

  | 4 ->
# 256 "asllib/SimpleLexer0.mll"
                                  ( comment 1 lexbuf )
# 440 "asllib/SimpleLexer0.ml"

  | 5 ->
let
# 259 "asllib/SimpleLexer0.mll"
                      s
# 446 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 259 "asllib/SimpleLexer0.mll"
                                            ( STRING_LIT (s)                        )
# 450 "asllib/SimpleLexer0.ml"

  | 6 ->
let
# 260 "asllib/SimpleLexer0.mll"
                                        lxm
# 456 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 260 "asllib/SimpleLexer0.mll"
                                            ( BITS_LIT (Bitvector.of_string lxm)    )
# 460 "asllib/SimpleLexer0.ml"

  | 7 ->
let
# 261 "asllib/SimpleLexer0.mll"
                                  s
# 466 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 261 "asllib/SimpleLexer0.mll"
                                            ( MASK_LIT (Bitvector.mask_of_string s) )
# 470 "asllib/SimpleLexer0.ml"

  | 8 ->
let
# 262 "asllib/SimpleLexer0.mll"
                                        lxm
# 476 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 262 "asllib/SimpleLexer0.mll"
                                            ( INT_LIT (Z.of_string lxm)             )
# 480 "asllib/SimpleLexer0.ml"

  | 9 ->
let
# 263 "asllib/SimpleLexer0.mll"
                                        lxm
# 486 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 263 "asllib/SimpleLexer0.mll"
                                            ( REAL_LIT (Q.of_string lxm)            )
# 490 "asllib/SimpleLexer0.ml"

  | 10 ->
let
# 264 "asllib/SimpleLexer0.mll"
                                        lxm
# 496 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 264 "asllib/SimpleLexer0.mll"
                                            ( INT_LIT (Z.of_string lxm)             )
# 500 "asllib/SimpleLexer0.ml"

  | 11 ->
let
# 265 "asllib/SimpleLexer0.mll"
                                        lxm
# 506 "asllib/SimpleLexer0.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 265 "asllib/SimpleLexer0.mll"
                                            ( tr_name (lxm)                         )
# 510 "asllib/SimpleLexer0.ml"

  | 12 ->
# 268 "asllib/SimpleLexer0.mll"
                     ( BANG       )
# 515 "asllib/SimpleLexer0.ml"

  | 13 ->
# 269 "asllib/SimpleLexer0.mll"
                     ( BANG_EQ    )
# 520 "asllib/SimpleLexer0.ml"

  | 14 ->
# 270 "asllib/SimpleLexer0.mll"
                     ( AMP  )
# 525 "asllib/SimpleLexer0.ml"

  | 15 ->
# 271 "asllib/SimpleLexer0.mll"
                     ( AMP_AMP )
# 530 "asllib/SimpleLexer0.ml"

  | 16 ->
# 272 "asllib/SimpleLexer0.mll"
                     ( LPAREN     )
# 535 "asllib/SimpleLexer0.ml"

  | 17 ->
# 273 "asllib/SimpleLexer0.mll"
                     ( RPAREN     )
# 540 "asllib/SimpleLexer0.ml"

  | 18 ->
# 274 "asllib/SimpleLexer0.mll"
                     ( STAR       )
# 545 "asllib/SimpleLexer0.ml"

  | 19 ->
# 275 "asllib/SimpleLexer0.mll"
                     ( PLUS       )
# 550 "asllib/SimpleLexer0.ml"

  | 20 ->
# 276 "asllib/SimpleLexer0.mll"
                     ( PLUS_PLUS  )
# 555 "asllib/SimpleLexer0.ml"

  | 21 ->
# 277 "asllib/SimpleLexer0.mll"
                     ( PLUS_COLON )
# 560 "asllib/SimpleLexer0.ml"

  | 22 ->
# 278 "asllib/SimpleLexer0.mll"
                     ( COMMA      )
# 565 "asllib/SimpleLexer0.ml"

  | 23 ->
# 279 "asllib/SimpleLexer0.mll"
                     ( MINUS      )
# 570 "asllib/SimpleLexer0.ml"

  | 24 ->
# 280 "asllib/SimpleLexer0.mll"
                     ( DOT        )
# 575 "asllib/SimpleLexer0.ml"

  | 25 ->
# 281 "asllib/SimpleLexer0.mll"
                     ( DOT_DOT    )
# 580 "asllib/SimpleLexer0.ml"

  | 26 ->
# 282 "asllib/SimpleLexer0.mll"
                     ( SLASH      )
# 585 "asllib/SimpleLexer0.ml"

  | 27 ->
# 283 "asllib/SimpleLexer0.mll"
                     ( COLON      )
# 590 "asllib/SimpleLexer0.ml"

  | 28 ->
# 284 "asllib/SimpleLexer0.mll"
                     ( SEMICOLON  )
# 595 "asllib/SimpleLexer0.ml"

  | 29 ->
# 285 "asllib/SimpleLexer0.mll"
                     ( LT         )
# 600 "asllib/SimpleLexer0.ml"

  | 30 ->
# 286 "asllib/SimpleLexer0.mll"
                     ( LT_LT      )
# 605 "asllib/SimpleLexer0.ml"

  | 31 ->
# 287 "asllib/SimpleLexer0.mll"
                     ( LT_EQ      )
# 610 "asllib/SimpleLexer0.ml"

  | 32 ->
# 288 "asllib/SimpleLexer0.mll"
                     ( EQ         )
# 615 "asllib/SimpleLexer0.ml"

  | 33 ->
# 289 "asllib/SimpleLexer0.mll"
                     ( EQ_EQ      )
# 620 "asllib/SimpleLexer0.ml"

  | 34 ->
# 290 "asllib/SimpleLexer0.mll"
                     ( EQ_GT      )
# 625 "asllib/SimpleLexer0.ml"

  | 35 ->
# 291 "asllib/SimpleLexer0.mll"
                     ( GT         )
# 630 "asllib/SimpleLexer0.ml"

  | 36 ->
# 292 "asllib/SimpleLexer0.mll"
                     ( GT_EQ      )
# 635 "asllib/SimpleLexer0.ml"

  | 37 ->
# 293 "asllib/SimpleLexer0.mll"
                     ( GT_GT      )
# 640 "asllib/SimpleLexer0.ml"

  | 38 ->
# 294 "asllib/SimpleLexer0.mll"
                     ( LBRACK     )
# 645 "asllib/SimpleLexer0.ml"

  | 39 ->
# 295 "asllib/SimpleLexer0.mll"
                     ( RBRACK     )
# 650 "asllib/SimpleLexer0.ml"

  | 40 ->
# 296 "asllib/SimpleLexer0.mll"
                     ( CARET      )
# 655 "asllib/SimpleLexer0.ml"

  | 41 ->
# 297 "asllib/SimpleLexer0.mll"
                     ( LBRACE     )
# 660 "asllib/SimpleLexer0.ml"

  | 42 ->
# 298 "asllib/SimpleLexer0.mll"
                     ( LBRACE_LBRACE )
# 665 "asllib/SimpleLexer0.ml"

  | 43 ->
# 299 "asllib/SimpleLexer0.mll"
                     ( BAR_BAR    )
# 670 "asllib/SimpleLexer0.ml"

  | 44 ->
# 300 "asllib/SimpleLexer0.mll"
                     ( RBRACE     )
# 675 "asllib/SimpleLexer0.ml"

  | 45 ->
# 301 "asllib/SimpleLexer0.mll"
                     ( RBRACE_RBRACE )
# 680 "asllib/SimpleLexer0.ml"

  | 46 ->
# 302 "asllib/SimpleLexer0.mll"
                     ( EOF        )
# 685 "asllib/SimpleLexer0.ml"

  | 47 ->
# 304 "asllib/SimpleLexer0.mll"
      (
        let p1 = Lexing.lexeme_start_p lexbuf and p2 = Lexing.lexeme_end_p lexbuf in
        Error.fatal_here p1 p2 Error.UnknownSymbol
      )
# 693 "asllib/SimpleLexer0.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and comment depth lexbuf =
   __ocaml_lex_comment_rec depth lexbuf 58
and __ocaml_lex_comment_rec depth lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 310 "asllib/SimpleLexer0.mll"
              ( comment (depth+1) lexbuf )
# 705 "asllib/SimpleLexer0.ml"

  | 1 ->
# 311 "asllib/SimpleLexer0.mll"
              ( if depth = 1 then token lexbuf else comment (depth-1) lexbuf )
# 710 "asllib/SimpleLexer0.ml"

  | 2 ->
# 312 "asllib/SimpleLexer0.mll"
              ( Lexing.new_line lexbuf; comment depth lexbuf )
# 715 "asllib/SimpleLexer0.ml"

  | 3 ->
# 313 "asllib/SimpleLexer0.mll"
              ( comment depth lexbuf )
# 720 "asllib/SimpleLexer0.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comment_rec depth lexbuf __ocaml_lex_state

;;

# 315 "asllib/SimpleLexer0.mll"
 
  let token_with_debug lexbuf =
    let tok = token lexbuf in
    let () = Printf.eprintf "Parsed token %s\n" (string_of_token tok) in
    tok

# 734 "asllib/SimpleLexer0.ml"
