/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.schematic;

import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.zip.GZIPInputStream;
import javafx.geometry.Point3D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LitematicFile {
    @NotNull
    private final Path file;
    private final int version;
    private final int subVersion;
    private final int minecraftDataVersion;
    private final int regionCount;
    private final int[] previewImageData;
    private final String name;
    private final String author;
    private final String description;
    private final Instant timeCreated;
    private final Instant timeModified;
    private final int totalBlocks;
    private final int totalVolume;
    private final Point3D enclosingSize;

    private static int tryGetInt(Tag tag) {
        return tag instanceof IntTag ? ((IntTag)tag).getValue() : 0;
    }

    @Nullable
    private static Instant tryGetLongTimestamp(Tag tag) {
        if (tag instanceof LongTag) {
            return Instant.ofEpochMilli(((LongTag)tag).getValue());
        }
        return null;
    }

    @Nullable
    private static String tryGetString(Tag tag) {
        return tag instanceof StringTag ? ((StringTag)tag).getValue() : null;
    }

    public static LitematicFile load(Path file) throws IOException {
        CompoundTag root;
        try (GZIPInputStream in = new GZIPInputStream(Files.newInputStream(file, new OpenOption[0]));){
            root = (CompoundTag)NBTIO.readTag(in);
        }
        Object versionTag = root.get("Version");
        if (versionTag == null) {
            throw new IOException("Version tag not found");
        }
        if (!(versionTag instanceof IntTag)) {
            throw new IOException("Version tag is not an integer");
        }
        Object metadataTag = root.get("Metadata");
        if (metadataTag == null) {
            throw new IOException("Metadata tag not found");
        }
        if (!(metadataTag instanceof CompoundTag)) {
            throw new IOException("Metadata tag is not a compound tag");
        }
        int regions = 0;
        Object regionsTag = root.get("Regions");
        if (regionsTag instanceof CompoundTag) {
            regions = ((CompoundTag)regionsTag).size();
        }
        return new LitematicFile(file, (CompoundTag)metadataTag, ((IntTag)versionTag).getValue(), LitematicFile.tryGetInt(root.get("SubVersion")), LitematicFile.tryGetInt(root.get("MinecraftDataVersion")), regions);
    }

    private LitematicFile(@NotNull Path file, @NotNull CompoundTag metadata, int version, int subVersion, int minecraftDataVersion, int regionCount) {
        this.file = file;
        this.version = version;
        this.subVersion = subVersion;
        this.minecraftDataVersion = minecraftDataVersion;
        this.regionCount = regionCount;
        Object previewImageData = metadata.get("PreviewImageData");
        this.previewImageData = previewImageData instanceof IntArrayTag ? ((IntArrayTag)previewImageData).getValue() : null;
        this.name = LitematicFile.tryGetString(metadata.get("Name"));
        this.author = LitematicFile.tryGetString(metadata.get("Author"));
        this.description = LitematicFile.tryGetString(metadata.get("Description"));
        this.timeCreated = LitematicFile.tryGetLongTimestamp(metadata.get("TimeCreated"));
        this.timeModified = LitematicFile.tryGetLongTimestamp(metadata.get("TimeModified"));
        this.totalBlocks = LitematicFile.tryGetInt(metadata.get("TotalBlocks"));
        this.totalVolume = LitematicFile.tryGetInt(metadata.get("TotalVolume"));
        Point3D enclosingSize = null;
        Object enclosingSizeTag = metadata.get("EnclosingSize");
        if (enclosingSizeTag instanceof CompoundTag) {
            CompoundTag list = (CompoundTag)enclosingSizeTag;
            int x = LitematicFile.tryGetInt(list.get("x"));
            int y = LitematicFile.tryGetInt(list.get("y"));
            int z = LitematicFile.tryGetInt(list.get("z"));
            if (x >= 0 && y >= 0 && z >= 0) {
                enclosingSize = new Point3D((double)x, (double)y, (double)z);
            }
        }
        this.enclosingSize = enclosingSize;
    }

    @NotNull
    public Path getFile() {
        return this.file;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSubVersion() {
        return this.subVersion;
    }

    public int getMinecraftDataVersion() {
        return this.minecraftDataVersion;
    }

    public int[] getPreviewImageData() {
        return this.previewImageData != null ? (int[])this.previewImageData.clone() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    public Instant getTimeModified() {
        return this.timeModified;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public Point3D getEnclosingSize() {
        return this.enclosingSize;
    }

    public int getRegionCount() {
        return this.regionCount;
    }
}

