/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.ProgressBarSkin;
import com.jfoenix.controls.JFXProgressBar;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXProgressBarSkin
extends ProgressBarSkin {
    private static Color indicatorColor = Color.valueOf((String)"#0F9D58");
    private static Color trackColor = Color.valueOf((String)"#E0E0E0");
    private StackPane bar;
    private Region clip;

    public JFXProgressBarSkin(JFXProgressBar progressBar) {
        super(progressBar);
        this.init();
        this.registerChangeListener2((ObservableValue<?>)((ProgressIndicator)this.getSkinnable()).indeterminateProperty(), "INDETERMINATE", this::init);
    }

    protected void init() {
        this.bar = (StackPane)this.getChildren().get(1);
        this.bar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)indicatorColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.bar.setPadding(new Insets(1.5));
        StackPane track = (StackPane)this.getChildren().get(0);
        track.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)trackColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.clip = new Region();
        this.clip.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        ((ProgressIndicator)this.getSkinnable()).setClip((Node)this.clip);
        ((ProgressIndicator)this.getSkinnable()).requestLayout();
    }

    protected void layoutChildren(double x, double y, double W, double h) {
        super.layoutChildren(x, y, W, h);
        this.clip.resizeRelocate(x, y, W, h);
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            if (this.getIndeterminateTransition() != null) {
                this.getIndeterminateTransition().stop();
            }
            ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
            double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double bWidth = this.bar.getWidth();
            this.setIndeterminateTransition((Animation)new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.bar.scaleXProperty(), (Object)0, Interpolator.EASE_IN), new KeyValue((WritableValue)this.bar.translateXProperty(), (Object)(-bWidth), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)this.bar.scaleXProperty(), (Object)3, Interpolator.LINEAR), new KeyValue((WritableValue)this.bar.translateXProperty(), (Object)(w / 2.0), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.bar.scaleXProperty(), (Object)0, Interpolator.EASE_OUT), new KeyValue((WritableValue)this.bar.translateXProperty(), (Object)w, Interpolator.LINEAR)})}));
            this.getIndeterminateTransition().setCycleCount(-1);
            this.getIndeterminateTransition().play();
        }
    }
}

