/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.url.data;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Base64;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.NotNull;

public final class DataUri {
    public static final String SCHEME = "data";
    @NotNull
    private final String mediaType;
    @NotNull
    private final Charset charset;
    private final boolean base64;
    @NotNull
    private final String rawData;

    private static IllegalArgumentException invalidUri(URI uri) {
        return new IllegalArgumentException("Invalid data URI: " + String.valueOf(uri));
    }

    public static boolean isDataUri(URI uri) {
        return uri != null && SCHEME.equals(uri.getScheme());
    }

    public DataUri(URI uri) {
        if (!uri.getScheme().equals(SCHEME)) {
            throw new IllegalArgumentException("URI scheme must be data");
        }
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        if (schemeSpecificPart == null) {
            throw DataUri.invalidUri(uri);
        }
        int comma = schemeSpecificPart.indexOf(44);
        if (comma < 0) {
            throw DataUri.invalidUri(uri);
        }
        String mediaType = schemeSpecificPart.substring(0, comma);
        boolean base64 = mediaType.endsWith(";base64");
        if (base64) {
            mediaType = mediaType.substring(0, mediaType.length() - ";base64".length());
        }
        this.mediaType = mediaType.trim();
        this.charset = NetworkUtils.getCharsetFromContentType(mediaType);
        this.base64 = base64;
        this.rawData = schemeSpecificPart.substring(comma + 1);
    }

    @NotNull
    public String getMediaType() {
        return this.mediaType;
    }

    @NotNull
    public Charset getCharset() {
        return this.charset;
    }

    public boolean isBase64() {
        return this.base64;
    }

    @NotNull
    public String getRawData() {
        return this.rawData;
    }

    public byte[] readBytes() throws IOException {
        if (this.base64) {
            try {
                return Base64.getDecoder().decode(this.rawData);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        return this.rawData.getBytes(this.charset);
    }

    public String readString() throws IOException {
        if (this.base64) {
            try {
                return new String(Base64.getDecoder().decode(this.rawData), this.charset);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
        return this.rawData;
    }

    public String toString() {
        return String.format("DataUri{mediaType='%s', charset=%s, base64=%s, body='%s'}", this.mediaType, this.charset, this.base64, this.rawData);
    }
}

