/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jackhuang.hmcl.game.AssetObject;
import org.jackhuang.hmcl.util.ToStringBuilder;

public final class AssetIndex {
    @SerializedName(value="virtual")
    private final boolean virtual;
    @SerializedName(value="map_to_resources")
    private final boolean mapToResources;
    @SerializedName(value="objects")
    private final Map<String, AssetObject> objects;

    public AssetIndex() {
        this(false, Collections.emptyMap());
    }

    public AssetIndex(boolean virtual, Map<String, AssetObject> objects) {
        this.virtual = this.mapToResources = virtual;
        this.objects = new HashMap<String, AssetObject>(objects);
    }

    public boolean isVirtual() {
        return this.virtual || this.mapToResources;
    }

    public boolean needMapToResources() {
        return this.mapToResources;
    }

    public Map<String, AssetObject> getObjects() {
        return Collections.unmodifiableMap(this.objects);
    }

    public String toString() {
        return new ToStringBuilder(this).append("virtual", this.virtual).append("objects", this.objects).toString();
    }
}

