/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.application.Platform;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jetbrains.annotations.Nullable;

public class TransitionPane
extends StackPane {
    private Node currentNode;

    public TransitionPane() {
        FXUtils.setOverflowHidden((Region)this);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public final void setContent(Node newView, AnimationProducer transition) {
        this.setContent(newView, transition, Motion.SHORT4);
    }

    public final void setContent(Node newView, AnimationProducer transition, Duration duration) {
        this.setContent(newView, transition, duration, Motion.EASE);
    }

    public void setContent(Node newView, AnimationProducer transition, Duration duration, Interpolator interpolator) {
        CacheHint cacheHint;
        Node previousNode = this.currentNode != newView && this.getWidth() > 0.0 && this.getHeight() > 0.0 ? this.currentNode : null;
        this.currentNode = newView;
        if (!AnimationUtils.isAnimationEnabled() || previousNode == null || transition == ContainerAnimations.NONE) {
            AnimationUtils.reset(newView, true);
            this.getChildren().setAll((Object[])new Node[]{newView});
            return;
        }
        this.getChildren().setAll((Object[])new Node[]{previousNode, newView});
        this.setMouseTransparent(true);
        transition.init(this, previousNode, newView);
        if (newView instanceof Cacheable) {
            Cacheable cacheable = (Cacheable)newView;
            v0 = cacheable.getCacheHint(transition);
        } else {
            v0 = cacheHint = null;
        }
        if (cacheHint != null) {
            newView.setCache(true);
            newView.setCacheHint(cacheHint);
        }
        Platform.runLater(() -> {
            Animation newAnimation = transition.animate((Pane)this, previousNode, newView, duration, interpolator);
            newAnimation.setOnFinished(e -> {
                this.setMouseTransparent(false);
                this.getChildren().remove((Object)previousNode);
                if (cacheHint != null) {
                    newView.setCache(false);
                }
            });
            FXUtils.playAnimation((Node)this, "transition_pane", newAnimation);
        });
    }

    public static interface AnimationProducer {
        default public void init(TransitionPane container, Node previousNode, Node nextNode) {
            AnimationUtils.reset(previousNode, true);
            AnimationUtils.reset(nextNode, false);
        }

        public Animation animate(Pane var1, Node var2, Node var3, Duration var4, Interpolator var5);

        @Nullable
        default public AnimationProducer opposite() {
            return null;
        }
    }

    public static interface Cacheable {
        @Nullable
        default public CacheHint getCacheHint(AnimationProducer animationProducer) {
            return animationProducer == ContainerAnimations.SLIDE_UP_FADE_IN ? CacheHint.SPEED : null;
        }
    }
}

