/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackExportTask;
import org.jackhuang.hmcl.mod.modrinth.ModrinthModpackExportTask;
import org.jackhuang.hmcl.mod.multimc.MultiMCInstanceConfiguration;
import org.jackhuang.hmcl.mod.multimc.MultiMCModpackExportTask;
import org.jackhuang.hmcl.mod.server.ServerModpackExportTask;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.FontManager;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.export.ModpackFileSelectionPage;
import org.jackhuang.hmcl.ui.export.ModpackInfoPage;
import org.jackhuang.hmcl.ui.export.ModpackTypeSelectionPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.io.Zipper;

public final class ExportWizardProvider
implements WizardProvider {
    private final Profile profile;
    private final String version;

    public ExportWizardProvider(Profile profile, String version) {
        this.profile = profile;
        this.version = version;
    }

    @Override
    public void start(SettingsMap settings) {
    }

    @Override
    public Object finish(SettingsMap settings) {
        List<String> whitelist = settings.get(ModpackFileSelectionPage.MODPACK_FILE_SELECTION);
        Path modpackFile = settings.get(ModpackInfoPage.MODPACK_FILE);
        ModpackExportInfo exportInfo = settings.get(ModpackInfoPage.MODPACK_INFO);
        exportInfo.setWhitelist(whitelist);
        String modpackType = settings.get(ModpackTypeSelectionPage.MODPACK_TYPE);
        return this.exportWithLauncher(modpackType, exportInfo, modpackFile);
    }

    private Task<?> exportWithLauncher(final String modpackType, final ModpackExportInfo exportInfo, final Path modpackFile) {
        final Path launcherJar = JarUtils.thisJarPath();
        final boolean packWithLauncher = exportInfo.isPackWithLauncher() && launcherJar != null;
        return new Task<Object>(){
            Path tempModpack;
            Task<?> exportTask;
            {
                this.setSignificance(Task.TaskSignificance.MODERATE);
            }

            @Override
            public boolean doPreExecute() {
                return true;
            }

            @Override
            public void preExecute() throws Exception {
                Path dest = packWithLauncher ? (this.tempModpack = Files.createTempFile("hmcl", ".zip", new FileAttribute[0])) : modpackFile;
                switch (modpackType) {
                    case "mcbbs": {
                        this.exportTask = ExportWizardProvider.this.exportAsMcbbs(exportInfo, dest);
                        break;
                    }
                    case "multimc": {
                        this.exportTask = ExportWizardProvider.this.exportAsMultiMC(exportInfo, dest);
                        break;
                    }
                    case "server": {
                        this.exportTask = ExportWizardProvider.this.exportAsServer(exportInfo, dest);
                        break;
                    }
                    case "modrinth": {
                        this.exportTask = ExportWizardProvider.this.exportAsModrinth(exportInfo, dest);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized modpack type " + modpackType);
                    }
                }
            }

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(this.exportTask);
            }

            @Override
            public void execute() throws Exception {
                if (!packWithLauncher) {
                    return;
                }
                try (Zipper zip = new Zipper(modpackFile);){
                    Config exported = new Config();
                    exported.setBackgroundImageType(ConfigHolder.config().getBackgroundImageType());
                    exported.setBackgroundImage(ConfigHolder.config().getBackgroundImage());
                    exported.setThemeColor(ConfigHolder.config().getThemeColor());
                    exported.setDownloadType(ConfigHolder.config().getDownloadType());
                    exported.setPreferredLoginType(ConfigHolder.config().getPreferredLoginType());
                    exported.getAuthlibInjectorServers().setAll(ConfigHolder.config().getAuthlibInjectorServers());
                    zip.putTextFile(exported.toJson(), ".hmcl/hmcl.json");
                    zip.putFile(this.tempModpack, "modpack.zip");
                    Path bg = Metadata.HMCL_CURRENT_DIRECTORY.resolve("background");
                    if (!Files.isDirectory(bg, new LinkOption[0])) {
                        bg = Metadata.CURRENT_DIRECTORY.resolve("bg");
                    }
                    if (Files.isDirectory(bg, new LinkOption[0])) {
                        zip.putDirectory(bg, ".hmcl/bg");
                    }
                    for (String extension : FXUtils.IMAGE_EXTENSIONS) {
                        String fileName = "background." + extension;
                        Path background = Metadata.HMCL_CURRENT_DIRECTORY.resolve(fileName);
                        if (!Files.isRegularFile(background, new LinkOption[0])) {
                            background = Metadata.CURRENT_DIRECTORY.resolve(fileName);
                        }
                        if (!Files.isRegularFile(background, new LinkOption[0])) continue;
                        zip.putFile(background, ".hmcl/" + fileName);
                    }
                    for (String extension : FontManager.FONT_EXTENSIONS) {
                        String fileName = "font." + extension;
                        Path font = Metadata.HMCL_CURRENT_DIRECTORY.resolve(fileName);
                        if (!Files.isRegularFile(font, new LinkOption[0])) {
                            font = Metadata.CURRENT_DIRECTORY.resolve(fileName);
                        }
                        if (!Files.isRegularFile(font, new LinkOption[0])) continue;
                        zip.putFile(font, ".hmcl/" + fileName);
                    }
                    zip.putFile(launcherJar, launcherJar.getFileName().toString());
                }
            }
        };
    }

    private Task<?> exportAsMcbbs(final ModpackExportInfo exportInfo, final Path modpackFile) {
        return new Task<Void>(){
            Task<?> dependency = null;
            {
                this.setSignificance(Task.TaskSignificance.MODERATE);
            }

            @Override
            public void execute() {
                this.dependency = new McbbsModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo, modpackFile);
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    private Task<?> exportAsMultiMC(final ModpackExportInfo exportInfo, final Path modpackFile) {
        return new Task<Void>(){
            Task<?> dependency;
            {
                this.setSignificance(Task.TaskSignificance.MODERATE);
            }

            @Override
            public void execute() {
                VersionSetting vs = ExportWizardProvider.this.profile.getVersionSetting(ExportWizardProvider.this.version);
                this.dependency = new MultiMCModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo.getWhitelist(), new MultiMCInstanceConfiguration("OneSix", exportInfo.getName() + "-" + exportInfo.getVersion(), null, Lang.toIntOrNull(vs.getPermSize()), vs.getWrapper(), vs.getPreLaunchCommand(), null, exportInfo.getDescription(), null, exportInfo.getJavaArguments(), vs.isFullscreen(), vs.getWidth(), vs.getHeight(), vs.getMaxMemory(), exportInfo.getMinMemory(), vs.isShowLogs(), true, false, true, false, true, true, true, true, null), modpackFile);
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    private Task<?> exportAsServer(final ModpackExportInfo exportInfo, final Path modpackFile) {
        return new Task<Void>(){
            Task<?> dependency;
            {
                this.setSignificance(Task.TaskSignificance.MODERATE);
            }

            @Override
            public void execute() {
                this.dependency = new ServerModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo, modpackFile);
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    private Task<?> exportAsModrinth(final ModpackExportInfo exportInfo, final Path modpackFile) {
        return new Task<Void>(){
            Task<?> dependency;
            {
                this.setSignificance(Task.TaskSignificance.MODERATE);
            }

            @Override
            public void execute() {
                this.dependency = new ModrinthModpackExportTask(ExportWizardProvider.this.profile.getRepository(), ExportWizardProvider.this.version, exportInfo, modpackFile);
            }

            @Override
            public Collection<Task<?>> getDependencies() {
                return Collections.singleton(this.dependency);
            }
        };
    }

    @Override
    public Node createPage(WizardController controller, int step, SettingsMap settings) {
        return switch (step) {
            case 0 -> new ModpackTypeSelectionPage(controller);
            case 1 -> new ModpackInfoPage(controller, this.profile.getRepository(), this.version);
            case 2 -> new ModpackFileSelectionPage(controller, this.profile, this.version, ModAdviser::suggestMod);
            default -> throw new IllegalArgumentException("step");
        };
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

