/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXRippler;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.skin.RadioButtonSkin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;

public class JFXRadioButtonSkin
extends RadioButtonSkin {
    private static final double PADDING = 15.0;
    private boolean invalid = true;
    private final JFXRippler rippler;
    private final Circle radio;
    private final Circle dot;
    private Timeline timeline;
    private final AnchorPane container = new AnchorPane();
    private final double labelOffset = -10.0;

    public JFXRadioButtonSkin(JFXRadioButton control) {
        super((RadioButton)control);
        double radioRadius = 7.0;
        this.radio = new Circle(radioRadius);
        this.radio.getStyleClass().setAll((Object[])new String[]{"radio"});
        this.radio.setStrokeWidth(2.0);
        this.radio.setFill((Paint)Color.TRANSPARENT);
        this.dot = new Circle(4.0);
        this.dot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.dot.fillProperty().bind(control.selectedColorProperty());
        this.dot.setScaleX(0.0);
        this.dot.setScaleY(0.0);
        StackPane boxContainer = new StackPane();
        boxContainer.getChildren().addAll((Object[])new Node[]{this.radio, this.dot});
        boxContainer.setPadding(new Insets(15.0));
        this.rippler = new JFXRippler((Node)boxContainer, JFXRippler.RipplerMask.CIRCLE);
        this.container.getChildren().add((Object)this.rippler);
        AnchorPane.setRightAnchor((Node)this.rippler, (Double)this.labelOffset);
        this.updateChildren();
        control.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!((RadioButton)this.getSkinnable()).isPressed()) {
                    this.rippler.showOverlay();
                }
            } else {
                this.rippler.hideOverlay();
            }
        });
        control.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.hideOverlay());
        this.registerChangeListener((ObservableValue)control.selectedColorProperty(), ignored -> this.updateColors());
        this.registerChangeListener((ObservableValue)control.unSelectedColorProperty(), ignored -> this.updateColors());
        this.registerChangeListener((ObservableValue)control.selectedProperty(), ignored -> {
            this.updateColors();
            this.playAnimation();
        });
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.removeRadio();
            this.getChildren().add((Object)this.container);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        double contWidth = this.snapSizeX(this.container.prefWidth(-1.0)) + (double)(this.invalid ? 2 : 0);
        double contHeight = this.snapSizeY(this.container.prefHeight(-1.0)) + (double)(this.invalid ? 2 : 0);
        double computeWidth = Math.min(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0)) + this.labelOffset + 2.0 * 15.0;
        double labelWidth = Math.min(computeWidth - contWidth, w - this.snapSizeX(contWidth)) + this.labelOffset + 30.0;
        double labelHeight = Math.min(radioButton.prefHeight(labelWidth), h);
        double maxHeight = Math.max(contHeight, labelHeight);
        double xOffset = JFXRadioButtonSkin.computeXOffset(w, labelWidth + contWidth, radioButton.getAlignment().getHpos()) + x;
        double yOffset = JFXRadioButtonSkin.computeYOffset(h, maxHeight, radioButton.getAlignment().getVpos()) + x;
        if (this.invalid) {
            this.initializeComponents();
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + contWidth, yOffset, labelWidth, maxHeight, radioButton.getAlignment());
        ((Text)this.getChildren().get(this.getChildren().get(0) instanceof Text ? 0 : 1)).textProperty().set((Object)((String)((RadioButton)this.getSkinnable()).textProperty().get()));
        this.container.resize(this.snapSizeX(contWidth), this.snapSizeY(contHeight));
        this.positionInArea((Node)this.container, xOffset, yOffset, contWidth, maxHeight, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
    }

    private void initializeComponents() {
        this.updateColors();
        this.playAnimation();
    }

    private void playAnimation() {
        if (AnimationUtils.isAnimationEnabled()) {
            if (this.timeline == null) {
                this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.dot.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.dot.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.dot.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.dot.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            } else {
                this.timeline.stop();
            }
            this.timeline.setRate(((RadioButton)this.getSkinnable()).isSelected() ? 1.0 : -1.0);
            this.timeline.play();
        } else {
            double endScale = ((RadioButton)this.getSkinnable()).isSelected() ? 1.0 : 0.0;
            this.dot.setScaleX(endScale);
            this.dot.setScaleY(endScale);
        }
    }

    private void removeRadio() {
        this.getChildren().removeIf(node -> "radio".equals(node.getStyleClass().get(0)));
    }

    private void updateColors() {
        JFXRadioButton control = (JFXRadioButton)this.getSkinnable();
        boolean isSelected = control.isSelected();
        Color unSelectedColor = control.getUnSelectedColor();
        Color selectedColor = control.getSelectedColor();
        this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
        this.radio.setStroke((Paint)(isSelected ? selectedColor : unSelectedColor));
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.radio.minWidth(-1.0)) + this.labelOffset + 30.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.radio.prefWidth(-1.0)) + this.labelOffset + 30.0;
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        return switch (hpos) {
            default -> throw new IncompatibleClassChangeError();
            case HPos.LEFT -> 0.0;
            case HPos.CENTER -> (width - contentWidth) / 2.0;
            case HPos.RIGHT -> width - contentWidth;
        };
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        return switch (vpos) {
            default -> throw new IncompatibleClassChangeError();
            case VPos.TOP, VPos.BASELINE -> 0.0;
            case VPos.CENTER -> (height - contentHeight) / 2.0;
            case VPos.BOTTOM -> height - contentHeight;
        };
    }
}

