/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.model;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.glavo.pci.ids.internal.ArgumentValidator;
import org.glavo.pci.ids.model.ProgramInterface;

public final class DeviceSubclass
implements Comparable<DeviceSubclass> {
    private final Integer id;
    private final String name;
    private final String comment;
    private final SortedMap<Integer, ProgramInterface> programInterfaces;

    public DeviceSubclass(int id, String name, String comment) {
        ArgumentValidator.requireUnsignedByte(id, "Device subclass ID");
        ArgumentValidator.requireNonBlank(name, "Device subclass name");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.programInterfaces = new TreeMap<Integer, ProgramInterface>();
    }

    public void addProgramInterface(ProgramInterface iface) {
        ArgumentValidator.requireNonNull(iface, "Device subclass program interface");
        this.programInterfaces.put(iface.getId(), iface);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public SortedMap<Integer, ProgramInterface> getProgramInterfaces() {
        return Collections.unmodifiableSortedMap(this.programInterfaces);
    }

    @Override
    public int compareTo(DeviceSubclass t) {
        return Integer.compare(this.id, t.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeviceSubclass)) {
            return false;
        }
        DeviceSubclass that = (DeviceSubclass)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return String.format("DeviceSubclass[id=%02x, name='%s']", this.getId(), this.getName());
    }
}

