/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.terracotta.profile.TerracottaProfile;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.util.gson.JsonSubtype;
import org.jackhuang.hmcl.util.gson.JsonType;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TerracottaState {
    protected TerracottaState() {
    }

    public boolean isUIFakeState() {
        return false;
    }

    public boolean isForkOf(TerracottaState state) {
        return false;
    }

    public static final class Fatal
    extends TerracottaState {
        private final Type type;

        public Fatal(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isRecoverable() {
            return this.type != Type.UNKNOWN;
        }

        public static enum Type {
            OS,
            NETWORK,
            INSTALL,
            TERRACOTTA,
            UNKNOWN;

        }
    }

    public static final class Exception
    extends Ready
    implements Validation {
        private static final Type[] LOOKUP = Type.values();
        @SerializedName(value="type")
        private final int type;

        Exception(int port, int index, String state, int type) {
            super(port, index, state);
            this.type = type;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            if (this.type < 0 || this.type >= LOOKUP.length) {
                throw new JsonParseException(String.format("Type must between [0, %s)", LOOKUP.length));
            }
        }

        public Type getType() {
            return LOOKUP[this.type];
        }

        public static enum Type {
            PING_HOST_FAIL,
            PING_HOST_RST,
            GUEST_ET_CRASH,
            HOST_ET_CRASH,
            PING_SERVER_RST,
            SCAFFOLDING_INVALID_RESPONSE;

        }
    }

    public static final class GuestOK
    extends Ready
    implements Validation {
        @SerializedName(value="url")
        private final String url;
        @SerializedName(value="profile_index")
        private final int profileIndex;
        @SerializedName(value="profiles")
        private final List<TerracottaProfile> profiles;

        GuestOK(int port, int index, String state, String url, int profileIndex, List<TerracottaProfile> profiles) {
            super(port, index, state);
            this.url = url;
            this.profileIndex = profileIndex;
            this.profiles = profiles;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            if (this.profiles == null) {
                throw new JsonParseException("profiles is null");
            }
        }

        public String getUrl() {
            return this.url;
        }

        public List<TerracottaProfile> getProfiles() {
            return this.profiles;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isForkOf(TerracottaState state) {
            if (!(state instanceof GuestOK)) return false;
            GuestOK guestOK = (GuestOK)state;
            if (this.index - guestOK.index > this.profileIndex) return false;
            return true;
        }
    }

    public static final class GuestStarting
    extends Ready {
        GuestStarting(int port, int index, String state) {
            super(port, index, state);
        }
    }

    public static final class HostOK
    extends Ready
    implements Validation {
        @SerializedName(value="room")
        private final String code;
        @SerializedName(value="profile_index")
        private final int profileIndex;
        @SerializedName(value="profiles")
        private final List<TerracottaProfile> profiles;

        HostOK(int port, int index, String state, String code, int profileIndex, List<TerracottaProfile> profiles) {
            super(port, index, state);
            this.code = code;
            this.profileIndex = profileIndex;
            this.profiles = profiles;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            if (this.code == null) {
                throw new JsonParseException("code is null");
            }
            if (this.profiles == null) {
                throw new JsonParseException("profiles is null");
            }
        }

        public String getCode() {
            return this.code;
        }

        public List<TerracottaProfile> getProfiles() {
            return this.profiles;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isForkOf(TerracottaState state) {
            if (!(state instanceof HostOK)) return false;
            HostOK hostOK = (HostOK)state;
            if (this.index - hostOK.index > this.profileIndex) return false;
            return true;
        }
    }

    public static final class HostStarting
    extends Ready {
        HostStarting(int port, int index, String state) {
            super(port, index, state);
        }
    }

    public static final class HostScanning
    extends Ready {
        HostScanning(int port, int index, String state) {
            super(port, index, state);
        }
    }

    public static final class Waiting
    extends Ready {
        Waiting(int port, int index, String state) {
            super(port, index, state);
        }
    }

    public static final class Unknown
    extends PortSpecific {
        Unknown(int port) {
            super(port);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonType(property="state", subtypes={@JsonSubtype(clazz=Waiting.class, name="waiting"), @JsonSubtype(clazz=HostScanning.class, name="host-scanning"), @JsonSubtype(clazz=HostStarting.class, name="host-starting"), @JsonSubtype(clazz=HostOK.class, name="host-ok"), @JsonSubtype(clazz=GuestStarting.class, name="guest-connecting"), @JsonSubtype(clazz=GuestStarting.class, name="guest-starting"), @JsonSubtype(clazz=GuestOK.class, name="guest-ok"), @JsonSubtype(clazz=Exception.class, name="exception")})
    static abstract class Ready
    extends PortSpecific {
        @SerializedName(value="index")
        final int index;
        @SerializedName(value="state")
        private final String state;

        Ready(int port, int index, String state) {
            super(port);
            this.index = index;
            this.state = state;
        }

        @Override
        public boolean isUIFakeState() {
            return this.index == -1;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class PortSpecific
    extends TerracottaState {
        transient int port;

        protected PortSpecific(int port) {
            this.port = port;
        }
    }

    public static final class Launching
    extends TerracottaState {
        Launching() {
        }
    }

    public static final class Preparing
    extends TerracottaState
    implements ITerracottaProvider.Context {
        private final ReadOnlyDoubleWrapper progress;
        private final AtomicBoolean installFence = new AtomicBoolean(false);

        Preparing(ReadOnlyDoubleWrapper progress) {
            this.progress = progress;
        }

        public ReadOnlyDoubleProperty progressProperty() {
            return this.progress.getReadOnlyProperty();
        }

        @Override
        public void bindProgress(ObservableValue<? extends Number> value) {
            this.progress.bind(value);
        }

        @Override
        public boolean requestInstallFence() {
            return this.installFence.compareAndSet(false, true);
        }

        @Override
        public boolean hasInstallFence() {
            return !this.installFence.get();
        }
    }

    public static final class Uninitialized
    extends TerracottaState {
        private final boolean hasLegacy;

        Uninitialized(boolean hasLegacy) {
            this.hasLegacy = hasLegacy;
        }

        public boolean hasLegacy() {
            return this.hasLegacy;
        }
    }

    public static final class Bootstrap
    extends TerracottaState {
        static final Bootstrap INSTANCE = new Bootstrap();

        private Bootstrap() {
        }
    }
}

