/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.java.mojang;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.java.mojang.MojangJavaDownloads;
import org.jackhuang.hmcl.download.java.mojang.MojangJavaRemoteFiles;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.GameJavaVersion;
import org.jackhuang.hmcl.java.JavaInfo;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.UnsupportedPlatformException;
import org.tukaani.xz.LZMAInputStream;

public final class MojangJavaDownloadTask
extends Task<Result> {
    private final DownloadProvider downloadProvider;
    private final Path target;
    private final Task<MojangJavaRemoteFiles> javaDownloadsTask;
    private final List<Task<?>> dependencies = new ArrayList();
    private volatile MojangJavaDownloads.JavaDownload download;

    public MojangJavaDownloadTask(DownloadProvider downloadProvider, Path target, GameJavaVersion javaVersion, String platform) {
        this.target = target;
        this.downloadProvider = downloadProvider;
        this.javaDownloadsTask = new GetTask(downloadProvider.injectURLWithCandidates("https://piston-meta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json")).thenComposeAsync((T javaDownloadsJson) -> {
            MojangJavaDownloads allDownloads = JsonUtils.fromNonNullJson(javaDownloadsJson, MojangJavaDownloads.class);
            Map<String, List<MojangJavaDownloads.JavaDownload>> osDownloads = allDownloads.getDownloads().get(platform);
            if (osDownloads == null || !osDownloads.containsKey(javaVersion.component())) {
                throw new UnsupportedPlatformException("Unsupported platform: " + platform);
            }
            List<MojangJavaDownloads.JavaDownload> candidates = osDownloads.get(javaVersion.component());
            for (MojangJavaDownloads.JavaDownload download : candidates) {
                if (JavaInfo.parseVersion(download.getVersion().getName()) < javaVersion.majorVersion()) continue;
                this.download = download;
                return new GetTask(downloadProvider.injectURLWithCandidates(download.getManifest().getUrl()));
            }
            throw new UnsupportedPlatformException("Candidates: " + JsonUtils.GSON.toJson(candidates));
        }).thenApplyAsync(javaDownloadJson -> JsonUtils.fromNonNullJson(javaDownloadJson, MojangJavaRemoteFiles.class));
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return Collections.singleton(this.javaDownloadsTask);
    }

    @Override
    public void execute() throws Exception {
        for (Map.Entry<String, MojangJavaRemoteFiles.Remote> entry : this.javaDownloadsTask.getResult().getFiles().entrySet()) {
            Path dest = this.target.resolve(entry.getKey());
            if (entry.getValue() instanceof MojangJavaRemoteFiles.RemoteFile) {
                DownloadInfo download;
                MojangJavaRemoteFiles.RemoteFile file = (MojangJavaRemoteFiles.RemoteFile)entry.getValue();
                try {
                    BasicFileAttributes localFileAttributes = Files.readAttributes(dest, BasicFileAttributes.class, new LinkOption[0]);
                    if (localFileAttributes.isRegularFile() && file.getDownloads().containsKey("raw")) {
                        DownloadInfo downloadInfo = file.getDownloads().get("raw");
                        if (localFileAttributes.size() == (long)downloadInfo.getSize()) {
                            ChecksumMismatchException.verifyChecksum(dest, "SHA-1", downloadInfo.getSha1());
                            Logger.LOG.info("Skip existing file: " + String.valueOf(dest));
                            continue;
                        }
                    }
                }
                catch (IOException localFileAttributes) {
                    // empty catch block
                }
                if (file.getDownloads().containsKey("lzma")) {
                    download = file.getDownloads().get("lzma");
                    Path tempFile = this.target.resolve(entry.getKey() + ".lzma");
                    FileDownloadTask task = new FileDownloadTask(this.downloadProvider.injectURLWithCandidates(download.getUrl()), tempFile, new FileDownloadTask.IntegrityCheck("SHA-1", download.getSha1()));
                    task.setName(entry.getKey());
                    this.dependencies.add(task.thenRunAsync(() -> {
                        Path decompressed = this.target.resolve((String)entry.getKey() + ".tmp");
                        try (LZMAInputStream input = new LZMAInputStream(Files.newInputStream(tempFile, new OpenOption[0]));){
                            Files.copy(input, decompressed, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new ArtifactMalformedException("File " + (String)entry.getKey() + " is malformed", e);
                        }
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (IOException e) {
                            Logger.LOG.warning("Failed to delete temporary file: " + String.valueOf(tempFile), e);
                        }
                        Files.move(decompressed, dest, StandardCopyOption.REPLACE_EXISTING);
                        if (file.isExecutable()) {
                            FileUtils.setExecutable(dest);
                        }
                    }));
                    continue;
                }
                if (!file.getDownloads().containsKey("raw")) continue;
                download = file.getDownloads().get("raw");
                FileDownloadTask task = new FileDownloadTask(this.downloadProvider.injectURLWithCandidates(download.getUrl()), dest, new FileDownloadTask.IntegrityCheck("SHA-1", download.getSha1()));
                task.setName(entry.getKey());
                if (file.isExecutable()) {
                    this.dependencies.add(task.thenRunAsync(() -> FileUtils.setExecutable(dest)));
                    continue;
                }
                this.dependencies.add(task);
                continue;
            }
            if (entry.getValue() instanceof MojangJavaRemoteFiles.RemoteDirectory) {
                Files.createDirectories(dest, new FileAttribute[0]);
                continue;
            }
            if (!(entry.getValue() instanceof MojangJavaRemoteFiles.RemoteLink)) continue;
            MojangJavaRemoteFiles.RemoteLink link = (MojangJavaRemoteFiles.RemoteLink)entry.getValue();
            Files.deleteIfExists(dest);
            Files.createSymbolicLink(dest, Paths.get(link.getTarget(), new String[0]), new FileAttribute[0]);
        }
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        this.setResult(new Result(this.download, this.javaDownloadsTask.getResult()));
    }

    public static final class Result {
        public final MojangJavaDownloads.JavaDownload download;
        public final MojangJavaRemoteFiles remoteFiles;

        public Result(MojangJavaDownloads.JavaDownload download, MojangJavaRemoteFiles remoteFiles) {
            this.download = download;
            this.remoteFiles = remoteFiles;
        }
    }
}

