/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.resourcepack;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import kala.compress.archivers.zip.ZipArchiveEntry;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.modinfo.PackMcMeta;
import org.jackhuang.hmcl.resourcepack.ResourcepackFile;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.tree.ZipFileTree;
import org.jetbrains.annotations.Nullable;

public final class ResourcepackZipFile
implements ResourcepackFile {
    private final Path path;
    private final byte @Nullable [] icon;
    private final String name;
    private final LocalModFile.Description description;

    public ResourcepackZipFile(Path path) throws IOException {
        byte[] icon;
        LocalModFile.Description description;
        block15: {
            this.path = path;
            description = null;
            icon = null;
            try (ZipFileTree zipFileTree = new ZipFileTree(CompressingUtils.openZipFile(path));){
                try {
                    description = JsonUtils.fromNonNullJson(zipFileTree.readTextEntry("/pack.mcmeta"), PackMcMeta.class).pack().description();
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to parse resourcepack meta", e);
                }
                ZipArchiveEntry iconEntry = (ZipArchiveEntry)zipFileTree.getEntry("/pack.png");
                if (iconEntry == null) break block15;
                try (InputStream is = zipFileTree.getInputStream(iconEntry);){
                    icon = is.readAllBytes();
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to load resourcepack icon", e);
                }
            }
        }
        this.icon = icon;
        this.description = description;
        this.name = FileUtils.getNameWithoutExtension(path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public LocalModFile.Description getDescription() {
        return this.description;
    }

    @Override
    public byte @Nullable [] getIcon() {
        return this.icon;
    }
}

