/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;

final class ConfigUpgrader {
    private ConfigUpgrader() {
    }

    static void upgradeConfig(Config deserialized, String rawContent) {
        int configVersion = deserialized.getConfigVersion();
        if (configVersion >= 2) {
            return;
        }
        Logger.LOG.info(String.format("Updating configuration from %d to %d.", configVersion, 2));
        Map rawJson = Collections.unmodifiableMap((Map)new Gson().fromJson(rawContent, (Type)((Object)Map.class)));
        if (configVersion < 1) {
            Lang.tryCast(rawJson.get("auth"), Map.class).ifPresent(auth -> Lang.tryCast(auth.get("offline"), Map.class).ifPresent(offline -> {
                String selected = rawJson.containsKey("selectedAccount") ? null : (String)Lang.tryCast(offline.get("IAuthenticator_UserName"), String.class).orElse(null);
                Lang.tryCast(offline.get("uuidMap"), Map.class).ifPresent(uuidMap -> uuidMap.forEach((key, value) -> {
                    HashMap<String, Object> storage = new HashMap<String, Object>();
                    storage.put("type", "offline");
                    storage.put("username", key);
                    storage.put("uuid", value);
                    if (key.equals(selected)) {
                        storage.put("selected", true);
                    }
                    deserialized.getAccountStorages().add(storage);
                }));
            }));
            if (!rawJson.containsKey("commonDirType")) {
                deserialized.setCommonDirType(deserialized.getCommonDirectory().equals(Settings.getDefaultCommonDirectory()) ? EnumCommonDirectory.DEFAULT : EnumCommonDirectory.CUSTOM);
            }
            if (!rawJson.containsKey("backgroundType")) {
                deserialized.setBackgroundImageType(StringUtils.isNotBlank(deserialized.getBackgroundImage()) ? EnumBackgroundImage.CUSTOM : EnumBackgroundImage.DEFAULT);
            }
            if (!rawJson.containsKey("hasProxy")) {
                deserialized.setHasProxy(StringUtils.isNotBlank(deserialized.getProxyHost()));
            }
            if (!rawJson.containsKey("hasProxyAuth")) {
                deserialized.setHasProxyAuth(StringUtils.isNotBlank(deserialized.getProxyUser()));
            }
            if (!rawJson.containsKey("downloadType")) {
                Lang.tryCast(rawJson.get("downloadtype"), Number.class).map(Number::intValue).ifPresent(id -> {
                    if (id == 0) {
                        deserialized.setDownloadType("mojang");
                    } else if (id == 1) {
                        deserialized.setDownloadType("bmclapi");
                    }
                });
            }
        }
        deserialized.setConfigVersion(2);
    }
}

