/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskListener;
import org.jetbrains.annotations.Nullable;

public abstract class TaskExecutor {
    protected final Task<?> firstTask;
    protected final List<TaskListener> taskListeners = new ArrayList<TaskListener>(0);
    protected volatile boolean cancelled = false;
    protected Exception exception;
    private final List<String> stages;

    public TaskExecutor(Task<?> task) {
        List<Object> list;
        this.firstTask = task;
        if (task instanceof Task.StagesHintTask) {
            Task.StagesHintTask hintTask = (Task.StagesHintTask)task;
            list = hintTask.getStages();
        } else {
            list = Collections.emptyList();
        }
        this.stages = list;
    }

    public void addTaskListener(TaskListener taskListener) {
        this.taskListeners.add(taskListener);
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public abstract TaskExecutor start();

    public abstract boolean test();

    public abstract void cancel();

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<String> getStages() {
        return this.stages;
    }
}

