/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.construct.NoPaddingComponent;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

public abstract class LineButtonBase
extends StackPane
implements NoPaddingComponent {
    private static final Insets PADDING = new Insets(8.0, 8.0, 8.0, 16.0);
    protected final BorderPane root;
    protected final RipplerContainer container;
    private final Label titleLabel;
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private StringProperty subtitle;

    public LineButtonBase() {
        this.root = new BorderPane();
        this.root.setPadding(PADDING);
        this.root.setMinHeight(48.0);
        this.container = new RipplerContainer((Node)this.root);
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.titleLabel = new Label();
        this.root.setCenter((Node)this.titleLabel);
        BorderPane.setAlignment((Node)this.titleLabel, (Pos)Pos.CENTER_LEFT);
        this.titleLabel.textProperty().bind((ObservableValue)this.titleProperty());
        this.titleLabel.getStyleClass().add((Object)"title");
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.titleProperty().get();
    }

    public void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public StringProperty subtitleProperty() {
        if (this.subtitle == null) {
            this.subtitle = new StringPropertyBase(){
                private VBox left;
                private Label subtitleLabel;

                public String getName() {
                    return "subtitle";
                }

                public Object getBean() {
                    return LineButtonBase.this;
                }

                protected void invalidated() {
                    String subtitle = this.get();
                    if (subtitle != null && !subtitle.isEmpty()) {
                        if (this.left == null) {
                            this.left = new VBox();
                            this.left.setMouseTransparent(true);
                            this.left.setAlignment(Pos.CENTER_LEFT);
                            this.subtitleLabel = new Label();
                            this.subtitleLabel.setWrapText(true);
                            this.subtitleLabel.setMinHeight(Double.NEGATIVE_INFINITY);
                            this.subtitleLabel.getStyleClass().add((Object)"subtitle");
                        }
                        this.subtitleLabel.setText(subtitle);
                        this.left.getChildren().setAll((Object[])new Node[]{LineButtonBase.this.titleLabel, this.subtitleLabel});
                        LineButtonBase.this.root.setCenter((Node)this.left);
                    } else if (this.left != null) {
                        this.subtitleLabel.setText(null);
                        LineButtonBase.this.root.setCenter((Node)LineButtonBase.this.titleLabel);
                    }
                }
            };
        }
        return this.subtitle;
    }

    public String getSubtitle() {
        return (String)this.subtitleProperty().get();
    }

    public void setSubtitle(String subtitle) {
        this.subtitleProperty().set((Object)subtitle);
    }
}

