/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.LineButtonBase;

public final class LineNavigationButton
extends LineButtonBase {
    private static final String DEFAULT_STYLE_CLASS = "line-navigation-button";
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        protected void invalidated() {
            LineNavigationButton.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return LineNavigationButton.this;
        }

        public String getName() {
            return "onAction";
        }
    };
    private final StringProperty message = new SimpleStringProperty((Object)this, "message", "");

    public LineNavigationButton() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.root.setMouseTransparent(true);
        HBox right = new HBox();
        this.root.setRight((Node)right);
        right.setAlignment(Pos.CENTER_RIGHT);
        Label valueLabel = new Label();
        valueLabel.getStyleClass().add((Object)"subtitle");
        valueLabel.textProperty().bind((ObservableValue)this.messageProperty());
        Node arrowIcon = SVG.ARROW_FORWARD.createIcon(24.0);
        HBox.setMargin((Node)arrowIcon, (Insets)new Insets(0.0, 8.0, 0.0, 8.0));
        this.disabledProperty().addListener((observable, oldValue, newValue) -> arrowIcon.setOpacity(newValue != false ? 0.4 : 1.0));
        right.getChildren().setAll((Object[])new Node[]{valueLabel, arrowIcon});
        FXUtils.onClicked((Node)this.container, this::fire);
    }

    public void fire() {
        this.fireEvent((Event)new ActionEvent());
    }

    public ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public StringProperty messageProperty() {
        return this.message;
    }

    public String getMessage() {
        return (String)this.messageProperty().get();
    }

    public void setMessage(String message) {
        this.messageProperty().set((Object)message);
    }
}

