/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXPopup;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.LineButtonBase;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public final class LineSelectButton<T>
extends LineButtonBase {
    private static final String DEFAULT_STYLE_CLASS = "line-select-button";
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private JFXPopup popup;
    private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
    private final ObjectProperty<Function<T, String>> converter = new SimpleObjectProperty((Object)this, "converter");
    private ObjectProperty<Function<T, String>> descriptionConverter;
    private final ListProperty<T> items = new SimpleListProperty((Object)this, "items", FXCollections.emptyObservableList());

    public LineSelectButton() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.root.setMouseTransparent(true);
        HBox right = new HBox();
        this.root.setRight((Node)right);
        right.setAlignment(Pos.CENTER_RIGHT);
        Label valueLabel = new Label();
        valueLabel.getStyleClass().add((Object)"subtitle");
        InvalidationListener updateValue = observable -> {
            T value = this.getValue();
            if (value == null) {
                valueLabel.setText("");
            } else {
                Function<T, String> converter = this.getConverter();
                valueLabel.setText(converter != null ? converter.apply(value) : value.toString());
            }
        };
        this.converterProperty().addListener(updateValue);
        this.valueProperty().addListener(updateValue);
        Node arrowIcon = SVG.UNFOLD_MORE.createIcon(24.0);
        HBox.setMargin((Node)arrowIcon, (Insets)new Insets(0.0, 8.0, 0.0, 8.0));
        right.getChildren().setAll((Object[])new Node[]{valueLabel, arrowIcon});
        this.container.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                if (this.popup == null) {
                    PopupMenu popupMenu = new PopupMenu();
                    this.popup = new JFXPopup((Region)popupMenu);
                    this.container.addEventFilter(ScrollEvent.ANY, ignored -> this.popup.hide());
                    Bindings.bindContent(popupMenu.getContent(), MappedObservableList.create(this.itemsProperty(), item -> {
                        VBox vbox = new VBox();
                        Label itemTitleLabel = new Label();
                        itemTitleLabel.getStyleClass().add((Object)"title");
                        itemTitleLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                            if (item == null) {
                                return "";
                            }
                            Function<Object, String> converter = this.getConverter();
                            return converter != null ? converter.apply(item) : Objects.toString(item, "");
                        }, (Observable[])new Observable[]{this.converterProperty()}));
                        Label itemSubtitleLabel = new Label();
                        itemSubtitleLabel.getStyleClass().add((Object)"subtitle");
                        itemSubtitleLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                            Function<Object, String> descriptionConverter = this.getDescriptionConverter();
                            return descriptionConverter != null ? descriptionConverter.apply(item) : "";
                        }, (Observable[])new Observable[]{this.descriptionConverterProperty()}));
                        FXUtils.onChangeAndOperate(itemSubtitleLabel.textProperty(), text -> {
                            if (text == null || text.isEmpty()) {
                                vbox.getChildren().setAll((Object[])new Node[]{itemTitleLabel});
                            } else {
                                vbox.getChildren().setAll((Object[])new Node[]{itemTitleLabel, itemSubtitleLabel});
                            }
                        });
                        StackPane wrapper = new StackPane(new Node[]{vbox});
                        wrapper.setAlignment(Pos.CENTER_LEFT);
                        wrapper.getStyleClass().add((Object)"menu-container");
                        wrapper.setMouseTransparent(true);
                        RipplerContainer ripplerContainer = new RipplerContainer((Node)wrapper);
                        FXUtils.onClicked((Node)ripplerContainer, () -> {
                            this.setValue(item);
                            this.popup.hide();
                        });
                        FXUtils.onChangeAndOperate(this.valueProperty(), value -> wrapper.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, Objects.equals(value, item)));
                        return ripplerContainer;
                    }));
                    this.popup.showingProperty().addListener((observable, oldValue, newValue) -> this.container.getRippler().setRipplerDisabled((boolean)newValue));
                }
                if (this.popup.isShowing()) {
                    this.popup.hide();
                } else {
                    JFXPopup.PopupVPosition vPosition;
                    this.popup.show((Node)this, vPosition, JFXPopup.PopupHPosition.RIGHT, 0.0, (vPosition = FXUtils.determineOptimalPopupPosition((Node)this, this.popup)) == JFXPopup.PopupVPosition.TOP ? this.getHeight() : -this.getHeight());
                }
                event.consume();
            } else if (event.getButton() == MouseButton.SECONDARY) {
                if (this.popup != null) {
                    this.popup.hide();
                }
                event.consume();
            }
        });
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public T getValue() {
        return (T)this.valueProperty().get();
    }

    public void setValue(T value) {
        this.valueProperty().set(value);
    }

    public ObjectProperty<Function<T, String>> converterProperty() {
        return this.converter;
    }

    public Function<T, String> getConverter() {
        return (Function)this.converterProperty().get();
    }

    public void setConverter(Function<T, String> value) {
        this.converterProperty().set(value);
    }

    public ObjectProperty<Function<T, String>> descriptionConverterProperty() {
        if (this.descriptionConverter == null) {
            this.descriptionConverter = new SimpleObjectProperty((Object)this, "descriptionConverter");
        }
        return this.descriptionConverter;
    }

    public Function<T, String> getDescriptionConverter() {
        return (Function)this.descriptionConverterProperty().get();
    }

    public void setDescriptionConverter(Function<T, String> value) {
        this.descriptionConverterProperty().set(value);
    }

    public ListProperty<T> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public void setItems(Collection<T> value) {
        if (value instanceof ObservableList) {
            ObservableList observableList = (ObservableList)value;
            this.setItems(observableList);
        } else {
            this.setItems(FXCollections.observableArrayList(value));
        }
    }

    @SafeVarargs
    public final void setItems(T ... values) {
        this.setItems(FXCollections.observableArrayList((Object[])values));
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }
}

