/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.AggregatedObservableList;

public class TwoLineListItem
extends VBox {
    private static final String DEFAULT_STYLE_CLASS = "two-line-list-item";
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final ObservableList<Label> tags = FXCollections.observableArrayList();
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
    private final Label lblSubtitle;
    private final Label lblTitle;
    private final AggregatedObservableList<Node> firstLineChildren;

    private static Label createTagLabel(String tag) {
        Label tagLabel = new Label();
        tagLabel.setText(tag);
        HBox.setMargin((Node)tagLabel, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        return tagLabel;
    }

    public TwoLineListItem(String titleString, String subtitleString) {
        this();
        this.title.set((Object)titleString);
        this.subtitle.set((Object)subtitleString);
    }

    public TwoLineListItem() {
        this.setMouseTransparent(true);
        HBox firstLine = new HBox();
        firstLine.getStyleClass().add((Object)"first-line");
        this.lblTitle = new Label();
        this.lblTitle.getStyleClass().add((Object)"title");
        this.lblTitle.textProperty().bind((ObservableValue)this.title);
        this.firstLineChildren = new AggregatedObservableList();
        this.firstLineChildren.appendList((ObservableList<Node>)FXCollections.singletonObservableList((Object)this.lblTitle));
        this.firstLineChildren.appendList(this.tags);
        Bindings.bindContent((List)firstLine.getChildren(), this.firstLineChildren.getAggregatedList());
        this.lblSubtitle = new Label();
        this.lblSubtitle.getStyleClass().add((Object)"subtitle");
        this.lblSubtitle.textProperty().bind((ObservableValue)this.subtitle);
        HBox secondLine = new HBox();
        secondLine.getChildren().setAll((Object[])new Node[]{this.lblSubtitle});
        this.getChildren().setAll((Object[])new Node[]{firstLine, secondLine});
        FXUtils.onChangeAndOperate(this.subtitle, subtitleString -> {
            if (subtitleString == null) {
                this.getChildren().setAll((Object[])new Node[]{firstLine});
            } else {
                this.getChildren().setAll((Object[])new Node[]{firstLine, secondLine});
            }
        });
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public Label getSubtitleLabel() {
        return this.lblSubtitle;
    }

    public Label getTitleLabel() {
        return this.lblTitle;
    }

    public void addTag(String tag) {
        Label tagLabel = TwoLineListItem.createTagLabel(tag);
        tagLabel.getStyleClass().add((Object)"tag");
        this.getTags().add((Object)tagLabel);
    }

    public void addTagWarning(String tag) {
        Label tagLabel = TwoLineListItem.createTagLabel(tag);
        tagLabel.getStyleClass().add((Object)"tag-warning");
        this.getTags().add((Object)tagLabel);
    }

    public ObservableList<Label> getTags() {
        return this.tags;
    }

    public String toString() {
        return this.getTitle();
    }
}

