/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXRadioButtonSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.ColorConverter;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class JFXRadioButton
extends RadioButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-radio-button";
    private StyleableObjectProperty<Color> selectedColor;
    private static final Color DEFAULT_SELECTED_COLOR = Color.valueOf((String)"#0F9D58");
    private StyleableObjectProperty<Color> unSelectedColor;
    private static final Color DEFAULT_UNSELECTED_COLOR = Color.valueOf((String)"#5A5A5A");

    public JFXRadioButton(String text) {
        super(text);
        this.initialize();
    }

    public JFXRadioButton() {
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXRadioButtonSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final StyleableObjectProperty<Color> selectedColorProperty() {
        if (this.selectedColor == null) {
            this.selectedColor = new SimpleStyleableObjectProperty(StyleableProperties.SELECTED_COLOR, (Object)this, "selectedColor", (Object)DEFAULT_SELECTED_COLOR);
        }
        return this.selectedColor;
    }

    public final Color getSelectedColor() {
        return this.selectedColor == null ? DEFAULT_SELECTED_COLOR : (Color)this.selectedColorProperty().get();
    }

    public final void setSelectedColor(Color selectedColor) {
        this.selectedColorProperty().set((Object)selectedColor);
    }

    public final StyleableObjectProperty<Color> unSelectedColorProperty() {
        if (this.unSelectedColor == null) {
            this.unSelectedColor = new SimpleStyleableObjectProperty(StyleableProperties.UNSELECTED_COLOR, (Object)this, "unSelectedColor", (Object)DEFAULT_UNSELECTED_COLOR);
        }
        return this.unSelectedColor;
    }

    public final Color getUnSelectedColor() {
        return this.unSelectedColor == null ? DEFAULT_UNSELECTED_COLOR : (Color)this.unSelectedColorProperty().get();
    }

    public final void setUnSelectedColor(Color unSelectedColor) {
        this.unSelectedColorProperty().set((Object)unSelectedColor);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXRadioButton.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXRadioButton, Color> SELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-selected-color", ColorConverter.getInstance(), DEFAULT_SELECTED_COLOR){

            public boolean isSettable(JFXRadioButton control) {
                return control.selectedColor == null || !control.selectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton control) {
                return control.selectedColorProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Color> UNSELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-unselected-color", ColorConverter.getInstance(), DEFAULT_UNSELECTED_COLOR){

            public boolean isSettable(JFXRadioButton control) {
                return control.unSelectedColor == null || !control.unSelectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton control) {
                return control.unSelectedColorProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(RadioButton.getClassCssMetaData());
            Collections.addAll(styleables, SELECTED_COLOR, UNSELECTED_COLOR);
            CHILD_STYLEABLES = List.copyOf(styleables);
        }
    }
}

