/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.Function;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class JFXNodeUtils {
    @NotNull
    private static final Function<Node, ObservableBooleanValue> treeVisiblePropertyGetter = JFXNodeUtils.initTreeVisiblePropertyGetter();

    public static void updateBackground(Background newBackground, Region nodeToUpdate) {
        JFXNodeUtils.updateBackground(newBackground, nodeToUpdate, (Paint)Color.BLACK);
    }

    public static void updateBackground(Background newBackground, Region nodeToUpdate, Paint fill) {
        if (newBackground != null && !newBackground.getFills().isEmpty()) {
            BackgroundFill[] fills = new BackgroundFill[newBackground.getFills().size()];
            for (int i = 0; i < newBackground.getFills().size(); ++i) {
                BackgroundFill bf = (BackgroundFill)newBackground.getFills().get(i);
                fills[i] = new BackgroundFill(fill, bf.getRadii(), bf.getInsets());
            }
            nodeToUpdate.setBackground(new Background(fills));
        }
    }

    public static String colorToHex(Color c) {
        if (c != null) {
            return String.format((Locale)null, "#%02X%02X%02X", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0));
        }
        return null;
    }

    @NotNull
    private static Function<Node, ObservableBooleanValue> initTreeVisiblePropertyGetter() {
        MethodHandles.Lookup lookup;
        try {
            lookup = MethodHandles.privateLookupIn(Node.class, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            Logger.LOG.warning("Failed to get private lookup for Node", e);
            return JFXNodeUtils::defaultTreeVisibleProperty;
        }
        try {
            Method treeVisiblePropertyMethod = Node.class.getDeclaredMethod("treeVisibleProperty", new Class[0]);
            if (!ObservableBooleanValue.class.isAssignableFrom(treeVisiblePropertyMethod.getReturnType())) {
                Logger.LOG.warning("Node.treeVisibleProperty() does not return ObservableBooleanValue: " + String.valueOf(treeVisiblePropertyMethod.getReturnType()));
                return JFXNodeUtils::defaultTreeVisibleProperty;
            }
            MethodHandle handle = lookup.unreflect(treeVisiblePropertyMethod).asType(MethodType.methodType(ObservableBooleanValue.class, Node.class));
            return item -> {
                try {
                    return handle.invokeExact((Node)item);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new AssertionError("Unreachable", e);
                }
            };
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to get method handle for Node.treeVisibleProperty()", e);
            return JFXNodeUtils::defaultTreeVisibleProperty;
        }
    }

    @NotNull
    private static ObservableBooleanValue defaultTreeVisibleProperty(Node item) {
        return item.visibleProperty();
    }

    @NotNull
    public static ObservableBooleanValue treeVisibleProperty(Node item) {
        return treeVisiblePropertyGetter.apply(item);
    }

    public static boolean isTreeVisible(Node item) {
        return (Boolean)JFXNodeUtils.treeVisibleProperty(item).getValue();
    }

    public static boolean isTreeShowing(Node node) {
        if (node == null) {
            return false;
        }
        Scene scene = node.getScene();
        if (scene == null) {
            return false;
        }
        Window window = scene.getWindow();
        if (window == null || !window.isShowing()) {
            return false;
        }
        return JFXNodeUtils.isTreeVisible(node);
    }

    private JFXNodeUtils() {
    }
}

