/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.Locale;
import org.glavo.monetfx.ColorSpecVersion;

public enum ColorStyle {
    TONAL_SPOT,
    FIDELITY,
    MONOCHROME,
    NEUTRAL,
    VIBRANT,
    EXPRESSIVE,
    CONTENT,
    RAINBOW,
    FRUIT_SALAD;

    public static final ColorStyle DEFAULT;
    private final String displayName;

    private ColorStyle() {
        CharSequence[] parts = this.name().split("_");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ((String)parts[i]).charAt(0) + ((String)parts[i]).substring(1).toLowerCase(Locale.ROOT);
        }
        this.displayName = String.join((CharSequence)" ", parts);
    }

    public boolean isSupported(ColorSpecVersion specVersion) {
        switch (this.ordinal()) {
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                return specVersion != null;
            }
        }
        return specVersion == ColorSpecVersion.SPEC_2021;
    }

    public String toString() {
        return this.displayName;
    }

    static {
        DEFAULT = TONAL_SPOT;
    }
}

