/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.dynamiccolor;

import org.glavo.monetfx.internal.utils.MathUtils;

public final class ContrastCurve {
    private final double low;
    private final double normal;
    private final double medium;
    private final double high;

    public ContrastCurve(double low, double normal, double medium, double high) {
        this.low = low;
        this.normal = normal;
        this.medium = medium;
        this.high = high;
    }

    public double get(double contrastLevel) {
        if (contrastLevel <= -1.0) {
            return this.low;
        }
        if (contrastLevel < 0.0) {
            return MathUtils.lerp(this.low, this.normal, (contrastLevel - -1.0) / 1.0);
        }
        if (contrastLevel < 0.5) {
            return MathUtils.lerp(this.normal, this.medium, (contrastLevel - 0.0) / 0.5);
        }
        if (contrastLevel < 1.0) {
            return MathUtils.lerp(this.medium, this.high, (contrastLevel - 0.5) / 0.5);
        }
        return this.high;
    }
}

