/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.mcbbs;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackManifest;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackLocalInstallTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonSubtype;
import org.jackhuang.hmcl.util.gson.JsonType;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jetbrains.annotations.Nullable;

public class McbbsModpackManifest
implements ModpackManifest,
Validation {
    public static final String MANIFEST_TYPE = "minecraftModpack";
    private final String manifestType;
    private final int manifestVersion;
    private final String name;
    private final String version;
    private final String author;
    private final String description;
    @Nullable
    private final String fileApi;
    private final String url;
    private final boolean forceUpdate;
    @SerializedName(value="origin")
    private final List<Origin> origins;
    private final List<Addon> addons;
    private final List<Library> libraries;
    private final List<File> files;
    private final Settings settings;
    private final LaunchInfo launchInfo;

    public McbbsModpackManifest() {
        this(MANIFEST_TYPE, 1, "", "", "", "", null, "", false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new Settings(), new LaunchInfo());
    }

    public McbbsModpackManifest(String manifestType, int manifestVersion, String name, String version, String author, String description, @Nullable String fileApi, String url, boolean forceUpdate, List<Origin> origins, List<Addon> addons, List<Library> libraries, List<File> files, Settings settings, LaunchInfo launchInfo) {
        this.manifestType = manifestType;
        this.manifestVersion = manifestVersion;
        this.name = name;
        this.version = version;
        this.author = author;
        this.description = description;
        this.fileApi = fileApi;
        this.url = url;
        this.forceUpdate = forceUpdate;
        this.origins = origins;
        this.addons = addons;
        this.libraries = libraries;
        this.files = files;
        this.settings = settings;
        this.launchInfo = launchInfo;
    }

    public String getManifestType() {
        return this.manifestType;
    }

    public int getManifestVersion() {
        return this.manifestVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileApi() {
        return this.fileApi;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public List<Origin> getOrigins() {
        return this.origins;
    }

    public List<Addon> getAddons() {
        return this.addons;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public LaunchInfo getLaunchInfo() {
        return this.launchInfo;
    }

    public McbbsModpackManifest setFiles(List<File> files) {
        return new McbbsModpackManifest(this.manifestType, this.manifestVersion, this.name, this.version, this.author, this.description, this.fileApi, this.url, this.forceUpdate, this.origins, this.addons, this.libraries, files, this.settings, this.launchInfo);
    }

    @Override
    public ModpackProvider getProvider() {
        return McbbsModpackProvider.INSTANCE;
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        if (!MANIFEST_TYPE.equals(this.manifestType)) {
            throw new JsonParseException("McbbsModpackManifest.manifestType must be 'minecraftModpack'");
        }
        if (this.files == null) {
            throw new JsonParseException("McbbsModpackManifest.files cannot be null");
        }
        if (this.addons == null) {
            throw new JsonParseException("McbbsModpackManifest.addons cannot be null");
        }
    }

    public Modpack toModpack(Charset encoding) throws IOException {
        String gameVersion = this.addons.stream().filter(x -> LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId().equals(x.id)).findAny().orElseThrow(() -> new IOException("Cannot find game version")).getVersion();
        return new Modpack(this.name, this.author, this.version, gameVersion, this.description, encoding, this){

            @Override
            public Task<?> getInstallTask(DefaultDependencyManager dependencyManager, Path zipFile, String name, String iconUrl) {
                return new McbbsModpackLocalInstallTask(dependencyManager, zipFile, this, McbbsModpackManifest.this, name);
            }
        };
    }

    public void injectLaunchOptions(LaunchOptions.Builder launchOptions) {
        launchOptions.getGameArguments().addAll(this.launchInfo.getLaunchArguments());
        launchOptions.getJavaArguments().addAll(this.launchInfo.getJavaArguments());
    }

    public static final class Settings {
        @SerializedName(value="install_mods")
        private final boolean installMods;
        @SerializedName(value="install_resourcepack")
        private final boolean installResourcepack;

        public Settings() {
            this(true, true);
        }

        public Settings(boolean installMods, boolean installResourcepack) {
            this.installMods = installMods;
            this.installResourcepack = installResourcepack;
        }

        public boolean isInstallMods() {
            return this.installMods;
        }

        public boolean isInstallResourcepack() {
            return this.installResourcepack;
        }
    }

    public static final class LaunchInfo {
        private final int minMemory;
        private final List<Integer> supportJava;
        @SerializedName(value="launchArgument")
        private final List<String> launchArguments;
        @SerializedName(value="javaArgument")
        private final List<String> javaArguments;

        public LaunchInfo() {
            this(0, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public LaunchInfo(int minMemory, List<Integer> supportJava, List<String> launchArguments, List<String> javaArguments) {
            this.minMemory = minMemory;
            this.supportJava = supportJava;
            this.launchArguments = launchArguments;
            this.javaArguments = javaArguments;
        }

        public int getMinMemory() {
            return this.minMemory;
        }

        @Nullable
        public List<Integer> getSupportJava() {
            return this.supportJava;
        }

        public List<String> getLaunchArguments() {
            return Optional.ofNullable(this.launchArguments).orElseGet(Collections::emptyList);
        }

        public List<String> getJavaArguments() {
            return Optional.ofNullable(this.javaArguments).orElseGet(Collections::emptyList);
        }
    }

    public static final class Addon {
        private final String id;
        private final String version;

        public Addon() {
            this("", "");
        }

        public Addon(String id, String version) {
            this.id = id;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static class ServerInfo {
        private final String authlibInjectorServer;

        public ServerInfo() {
            this(null);
        }

        public ServerInfo(String authlibInjectorServer) {
            this.authlibInjectorServer = authlibInjectorServer;
        }

        @Nullable
        public String getAuthlibInjectorServer() {
            return this.authlibInjectorServer;
        }
    }

    public static final class CurseFile
    extends File {
        private final int projectID;
        private final int fileID;
        private final String fileName;
        private final String url;

        public CurseFile() {
            this(false, 0, 0, "", "");
        }

        public CurseFile(boolean force, int projectID, int fileID, String fileName, String url) {
            super(force);
            this.projectID = projectID;
            this.fileID = fileID;
            this.fileName = fileName;
            this.url = url;
        }

        public int getProjectID() {
            return this.projectID;
        }

        public int getFileID() {
            return this.fileID;
        }

        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        public String getUrl() {
            return this.url == null ? "https://www.curseforge.com/minecraft/mc-mods/" + this.projectID + "/download/" + this.fileID + "/file" : this.url;
        }

        public CurseFile withFileName(String fileName) {
            return new CurseFile(this.force, this.projectID, this.fileID, fileName, this.url);
        }

        public CurseFile withURL(String url) {
            return new CurseFile(this.force, this.projectID, this.fileID, this.fileName, url);
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            super.validate();
            if (this.projectID == 0 || this.fileID == 0) {
                throw new JsonParseException("CurseFile.{projectID|fileID} cannot be empty.");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurseFile curseFile = (CurseFile)o;
            return this.projectID == curseFile.projectID && this.fileID == curseFile.fileID;
        }

        public int hashCode() {
            return Objects.hash(this.projectID, this.fileID);
        }
    }

    public static final class AddonFile
    extends File {
        private final String path;
        private final String hash;

        public AddonFile(boolean force, String path, String hash) {
            super(force);
            this.path = Objects.requireNonNull(path);
            this.hash = Objects.requireNonNull(hash);
        }

        public String getPath() {
            return this.path;
        }

        public String getHash() {
            return this.hash;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            super.validate();
            Validation.requireNonNull(this.path, "AddonFile.path cannot be null");
            Validation.requireNonNull(this.hash, "AddonFile.hash cannot be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddonFile addonFile = (AddonFile)o;
            return this.path.equals(addonFile.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }

    @JsonType(property="type", subtypes={@JsonSubtype(clazz=AddonFile.class, name="addon"), @JsonSubtype(clazz=CurseFile.class, name="curse")})
    public static abstract class File
    implements Validation {
        protected final boolean force;

        public File(boolean force) {
            this.force = force;
        }

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
        }

        public boolean isForce() {
            return this.force;
        }
    }

    public static final class Origin {
        private final String type;
        private final int id;

        public Origin() {
            this("", 0);
        }

        public Origin(String type, int id) {
            this.type = type;
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }
    }
}

