/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.util.ArrayList;
import java.util.List;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskListener;
import org.jetbrains.annotations.Nullable;

public abstract class TaskExecutor {
    protected final Task<?> firstTask;
    protected final List<TaskListener> taskListeners = new ArrayList<TaskListener>(0);
    protected volatile boolean cancelled = false;
    protected Exception exception;
    private final List<Task.StagesHint> hints;

    public TaskExecutor(Task<?> task) {
        List<Object> list;
        this.firstTask = task;
        if (task instanceof Task.StagesHintTask) {
            Task.StagesHintTask hintTask = (Task.StagesHintTask)task;
            list = hintTask.getHints();
        } else {
            list = List.of();
        }
        this.hints = list;
    }

    public void addTaskListener(TaskListener taskListener) {
        this.taskListeners.add(taskListener);
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public abstract TaskExecutor start();

    public abstract boolean test();

    public abstract void cancel();

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<Task.StagesHint> getHints() {
        return this.hints;
    }
}

