/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class TerracottaNodeList {
    private static final String NODE_LIST_URL = "https://terracotta.glavo.site/nodes";
    private static volatile List<URI> list;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URI> fetch() {
        List<URI> list = TerracottaNodeList.list;
        if (list != null) {
            return list;
        }
        Class<TerracottaNodeList> clazz = TerracottaNodeList.class;
        synchronized (TerracottaNodeList.class) {
            list = TerracottaNodeList.list;
            if (list != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return list;
            }
            try {
                List<TerracottaNode> nodes = HttpRequest.GET(NODE_LIST_URL).getJson(JsonUtils.listTypeOf(TerracottaNode.class));
                if (nodes == null) {
                    list = List.of();
                    Logger.LOG.info("No available Terracotta nodes found");
                } else {
                    list = nodes.stream().filter(node -> {
                        if (node == null) {
                            return false;
                        }
                        try {
                            node.validate();
                        }
                        catch (Exception e) {
                            Logger.LOG.warning("Invalid terracotta node: " + String.valueOf(node), e);
                            return false;
                        }
                        return StringUtils.isBlank(node.region) || LocaleUtils.IS_CHINA_MAINLAND == "CN".equalsIgnoreCase(node.region);
                    }).map(it -> URI.create(it.url())).toList();
                    Logger.LOG.info("Terracotta node list: " + String.valueOf(list));
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to fetch terracotta node list", e);
                list = List.of();
            }
            TerracottaNodeList.list = list;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    private TerracottaNodeList() {
    }

    private record TerracottaNode(String url, @Nullable String region) implements Validation
    {
        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            Validation.requireNonNull(this.url, "TerracottaNode.url cannot be null");
            try {
                new URI(this.url);
            }
            catch (URISyntaxException e) {
                throw new JsonParseException("Invalid URL: " + this.url, e);
            }
        }
    }
}

