/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.BorderPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.SVGContainer;
import org.jackhuang.hmcl.ui.construct.AdvancedListItemSkin;

public class AdvancedListItem
extends Control {
    public static final double LEFT_GRAPHIC_SIZE = 32.0;
    public static final double LEFT_ICON_SIZE = 20.0;
    public static final Insets LEFT_ICON_MARGIN = new Insets(0.0, 6.0, 0.0, 6.0);
    private final ObjectProperty<Node> leftGraphic = new SimpleObjectProperty((Object)this, "leftGraphic");
    private final ObjectProperty<Node> rightGraphic = new SimpleObjectProperty((Object)this, "rightGraphic");
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
    private final BooleanProperty active = new SimpleBooleanProperty((Object)this, "active");
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty<EventHandler<ActionEvent>>((Object)this, "onAction"){

        protected void invalidated() {
            AdvancedListItem.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }
    };

    public static void setMargin(Node graphic, Insets margin) {
        BorderPane.setMargin((Node)graphic, (Insets)margin);
    }

    public static void setAlignment(Node graphic, Pos alignment) {
        BorderPane.setAlignment((Node)graphic, (Pos)alignment);
    }

    public AdvancedListItem() {
        this.getStyleClass().add((Object)"advanced-list-item");
        FXUtils.onClicked((Node)this, () -> this.fireEvent((Event)new ActionEvent()));
    }

    public ObjectProperty<Node> leftGraphicProperty() {
        return this.leftGraphic;
    }

    public Node getLeftGraphic() {
        return (Node)this.leftGraphic.get();
    }

    public void setLeftGraphic(Node leftGraphic) {
        this.leftGraphic.set((Object)leftGraphic);
    }

    public void setLeftIcon(SVG svg) {
        SVGContainer icon = svg.createIcon(20.0);
        icon.setMouseTransparent(true);
        BorderPane.setMargin((Node)icon, (Insets)LEFT_ICON_MARGIN);
        BorderPane.setAlignment((Node)icon, (Pos)Pos.CENTER);
        this.leftGraphicProperty().set((Object)icon);
    }

    public ObjectProperty<Node> rightGraphicProperty() {
        return this.rightGraphic;
    }

    public Node getRightGraphic() {
        return (Node)this.rightGraphic.get();
    }

    public void setRightGraphic(Node rightGraphic) {
        this.rightGraphic.set((Object)rightGraphic);
    }

    public void setRightAction(SVG icon, Runnable action) {
        JFXButton button = FXUtils.newToggleButton4(icon, 14);
        button.setOnAction(e -> {
            action.run();
            e.consume();
        });
        AdvancedListItem.setAlignment((Node)button, Pos.CENTER);
        this.setRightGraphic((Node)button);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    protected Skin<?> createDefaultSkin() {
        return new AdvancedListItemSkin(this);
    }
}

