/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.LineButton;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AboutPage
extends StackPane {
    private final WeakListenerHolder holder = new WeakListenerHolder();

    public AboutPage() {
        ComponentList about = new ComponentList();
        LineButton launcher = LineButton.createExternalLinkButton("https://hmcl.huangyuhui.net");
        launcher.setLargeTitle(true);
        launcher.setLeading(FXUtils.newBuiltinImage("/assets/img/icon.png"));
        launcher.setTitle("Hello Minecraft! Launcher");
        launcher.setSubtitle(Metadata.VERSION);
        LineButton author = LineButton.createExternalLinkButton("https://space.bilibili.com/1445341");
        author.setLargeTitle(true);
        author.setLeading(FXUtils.newBuiltinImage("/assets/img/yellow_fish.png"));
        author.setTitle("huanghongxun");
        author.setSubtitle(I18n.i18n("about.author.statement"));
        about.getContent().setAll((Object[])new Node[]{launcher, author});
        ComponentList thanks = this.loadIconedTwoLineList("/assets/about/thanks.json");
        ComponentList deps = this.loadIconedTwoLineList("/assets/about/deps.json");
        ComponentList legal = new ComponentList();
        LineButton copyright = LineButton.createExternalLinkButton("https://hmcl.huangyuhui.net/about");
        copyright.setLargeTitle(true);
        copyright.setTitle(I18n.i18n("about.copyright"));
        copyright.setSubtitle(I18n.i18n("about.copyright.statement"));
        LineButton claim = LineButton.createExternalLinkButton("https://docs.hmcl.net/eula/hmcl.html");
        claim.setLargeTitle(true);
        claim.setTitle(I18n.i18n("about.claim"));
        claim.setSubtitle(I18n.i18n("about.claim.statement"));
        LineButton openSource = LineButton.createExternalLinkButton("https://github.com/HMCL-dev/HMCL");
        openSource.setLargeTitle(true);
        openSource.setTitle(I18n.i18n("about.open_source"));
        openSource.setSubtitle(I18n.i18n("about.open_source.statement"));
        legal.getContent().setAll((Object[])new Node[]{copyright, claim, openSource});
        VBox content = new VBox(16.0);
        content.setPadding(new Insets(10.0));
        content.getChildren().setAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("about")), about, ComponentList.createComponentListTitle(I18n.i18n("about.thanks_to")), thanks, ComponentList.createComponentListTitle(I18n.i18n("about.dependency")), deps, ComponentList.createComponentListTitle(I18n.i18n("about.legal")), legal});
        ScrollPane scrollPane = new ScrollPane((Node)content);
        scrollPane.setFitToWidth(true);
        FXUtils.smoothScrolling(scrollPane);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
    }

    private static Image loadImage(String url) {
        return url.startsWith("/") ? FXUtils.newBuiltinImage(url) : new Image(url);
    }

    private ComponentList loadIconedTwoLineList(String path) {
        ComponentList componentList = new ComponentList();
        InputStream input = FXUtils.class.getResourceAsStream(path);
        if (input == null) {
            Logger.LOG.warning("Resources not found: " + path);
            return componentList;
        }
        try {
            JsonArray array = JsonUtils.fromJsonFully(input, JsonArray.class);
            for (JsonElement element : array) {
                JsonElement jsonElement;
                JsonObject obj = element.getAsJsonObject();
                LineButton button = new LineButton();
                button.setLargeTitle(true);
                JsonElement jsonElement2 = obj.get("externalLink");
                if (jsonElement2 instanceof JsonPrimitive) {
                    JsonPrimitive externalLink = (JsonPrimitive)jsonElement2;
                    button.setTrailingIcon(SVG.OPEN_IN_NEW);
                    String link = externalLink.getAsString();
                    button.setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> FXUtils.openLink(link)));
                }
                if (obj.has("image")) {
                    JsonElement image = obj.get("image");
                    if (image.isJsonPrimitive()) {
                        button.setLeading(AboutPage.loadImage(image.getAsString()));
                    } else if (image.isJsonObject()) {
                        this.holder.add(FXUtils.onWeakChangeAndOperate(Themes.darkModeProperty(), darkMode -> button.setLeading(darkMode != false ? AboutPage.loadImage(image.getAsJsonObject().get("dark").getAsString()) : AboutPage.loadImage(image.getAsJsonObject().get("light").getAsString()))));
                    }
                }
                if ((jsonElement = obj.get("title")) instanceof JsonPrimitive) {
                    JsonPrimitive title = (JsonPrimitive)jsonElement;
                    button.setTitle(title.getAsString());
                } else {
                    jsonElement = obj.get("titleLocalized");
                    if (jsonElement instanceof JsonPrimitive) {
                        JsonPrimitive titleLocalized = (JsonPrimitive)jsonElement;
                        button.setTitle(I18n.i18n(titleLocalized.getAsString()));
                    }
                }
                jsonElement = obj.get("subtitle");
                if (jsonElement instanceof JsonPrimitive) {
                    JsonPrimitive subtitle = (JsonPrimitive)jsonElement;
                    button.setSubtitle(subtitle.getAsString());
                } else {
                    jsonElement = obj.get("subtitleLocalized");
                    if (jsonElement instanceof JsonPrimitive) {
                        JsonPrimitive subtitleLocalized = (JsonPrimitive)jsonElement;
                        button.setSubtitle(I18n.i18n(subtitleLocalized.getAsString()));
                    }
                }
                componentList.getContent().add((Object)button);
            }
        }
        catch (JsonParseException | IOException e) {
            Logger.LOG.warning("Failed to load list: " + path, e);
        }
        return componentList;
    }
}

