/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.mod.Datapack;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.versions.DatapackListPageSkin;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class DatapackListPage
extends ListPageBase<DatapackListPageSkin.DatapackInfoObject>
implements WorldManagePage.WorldRefreshable {
    private final World world;
    private final Datapack datapack;
    final BooleanProperty readOnly;

    public DatapackListPage(WorldManagePage worldManagePage) {
        this.world = worldManagePage.getWorld();
        this.datapack = new Datapack(this.world.getFile().resolve("datapacks"));
        this.setItems(MappedObservableList.create(this.datapack.getPacks(), DatapackListPageSkin.DatapackInfoObject::new));
        this.readOnly = worldManagePage.readOnlyProperty();
        FXUtils.applyDragListener((Node)this, it -> Objects.equals("zip", FileUtils.getExtension(it)), this::installMultiDatapack, this::refresh);
        this.refresh();
    }

    private void installMultiDatapack(List<Path> datapackPath) {
        datapackPath.forEach(this::installSingleDatapack);
        if (this.readOnly.get()) {
            Controllers.showToast(I18n.i18n("datapack.reload.toast"));
        }
    }

    private void installSingleDatapack(Path datapack) {
        try {
            this.datapack.installPack(datapack, this.world.getGameVersion());
        }
        catch (IOException | IllegalArgumentException e) {
            Logger.LOG.warning("Unable to parse datapack file " + String.valueOf(datapack), e);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new DatapackListPageSkin(this);
    }

    @Override
    public void refresh() {
        this.setLoading(true);
        Task.runAsync(this.datapack::loadFromDir).withRunAsync(Schedulers.javafx(), () -> this.setLoading(false)).start();
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("datapack.add.title"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("extension.datapack"), new String[]{"*.zip"})});
        List<Path> res = FileUtils.toPaths(chooser.showOpenMultipleDialog((Window)Controllers.getStage()));
        if (res != null) {
            this.installMultiDatapack(res);
        }
        this.datapack.loadFromDir();
    }

    void removeSelected(ObservableList<DatapackListPageSkin.DatapackInfoObject> selectedItems) {
        selectedItems.stream().map(DatapackListPageSkin.DatapackInfoObject::getPackInfo).forEach(pack -> {
            try {
                this.datapack.deletePack((Datapack.Pack)pack);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete datapack \"" + pack.getId() + "\"", e);
            }
        });
    }

    void enableSelected(ObservableList<DatapackListPageSkin.DatapackInfoObject> selectedItems) {
        selectedItems.stream().map(DatapackListPageSkin.DatapackInfoObject::getPackInfo).forEach(pack -> pack.setActive(true));
    }

    void disableSelected(ObservableList<DatapackListPageSkin.DatapackInfoObject> selectedItems) {
        selectedItems.stream().map(DatapackListPageSkin.DatapackInfoObject::getPackInfo).forEach(pack -> pack.setActive(false));
    }

    void openDataPackFolder() {
        FXUtils.openFolder(this.datapack.getPath());
    }

    @NotNull
    Predicate<DatapackListPageSkin.DatapackInfoObject> updateSearchPredicate(String queryString) {
        Predicate<String> stringPredicate;
        if (queryString.isBlank()) {
            return dataPack -> true;
        }
        if (queryString.startsWith("regex:")) {
            try {
                Pattern pattern = Pattern.compile(StringUtils.substringAfter(queryString, "regex:"));
                stringPredicate = s -> s != null && pattern.matcher((CharSequence)s).find();
            }
            catch (Exception e) {
                return dataPack -> false;
            }
        } else {
            String lowerCaseFilter = queryString.toLowerCase(Locale.ROOT);
            stringPredicate = s -> s != null && s.toLowerCase(Locale.ROOT).contains(lowerCaseFilter);
        }
        return dataPack -> {
            String id = dataPack.getPackInfo().getId();
            String description = dataPack.getPackInfo().getDescription().toString();
            return stringPredicate.test(id) || stringPredicate.test(description);
        };
    }
}

