/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.versions.ModCheckUpdatesTask;
import org.jackhuang.hmcl.ui.versions.ModListPageSkin;
import org.jackhuang.hmcl.ui.versions.ModUpdatesPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class ModListPage
extends ListPageBase<ModListPageSkin.ModInfoObject>
implements VersionPage.VersionLoadable,
PageAware {
    private final BooleanProperty modded = new SimpleBooleanProperty((Object)this, "modded", false);
    private final ReentrantLock lock = new ReentrantLock();
    private ModManager modManager;
    private Profile profile;
    private String instanceId;
    private String gameVersion;
    final EnumSet<ModLoaderType> supportedLoaders = EnumSet.noneOf(ModLoaderType.class);

    public ModListPage() {
        FXUtils.applyDragListener((Node)this, it -> Arrays.asList("jar", "zip", "litemod").contains(FileUtils.getExtension(it)), mods -> {
            mods.forEach(it -> {
                try {
                    this.modManager.addMod((Path)it);
                }
                catch (IOException | IllegalArgumentException e) {
                    Logger.LOG.warning("Unable to parse mod file " + String.valueOf(it), e);
                }
            });
            this.loadMods(this.modManager);
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new ModListPageSkin(this);
    }

    public void refresh() {
        this.loadMods(this.modManager);
    }

    @Override
    public void loadVersion(Profile profile, String id) {
        this.profile = profile;
        this.instanceId = id;
        HMCLGameRepository repository = profile.getRepository();
        Version resolved = repository.getResolvedPreservingPatchesVersion(id);
        this.gameVersion = repository.getGameVersion(resolved).orElse(null);
        LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(resolved, this.gameVersion);
        this.modded.set(analyzer.hasModLoader());
        this.loadMods(profile.getRepository().getModManager(id));
    }

    private void loadMods(ModManager modManager) {
        this.setLoading(true);
        this.modManager = modManager;
        CompletableFuture.supplyAsync(() -> {
            this.lock.lock();
            try {
                modManager.refreshMods();
                List<ModListPageSkin.ModInfoObject> list = modManager.getMods().stream().map(ModListPageSkin.ModInfoObject::new).toList();
                return list;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }, Schedulers.io()).whenCompleteAsync((list, exception) -> {
            this.updateSupportedLoaders(modManager);
            if (exception == null) {
                this.getItems().setAll((Collection)list);
            } else {
                Logger.LOG.warning("Failed to load mods", (Throwable)exception);
                this.getItems().clear();
            }
            this.setLoading(false);
        }, Schedulers.javafx());
    }

    private void updateSupportedLoaders(ModManager modManager) {
        this.supportedLoaders.clear();
        LibraryAnalyzer analyzer = modManager.getLibraryAnalyzer();
        if (analyzer == null) {
            Collections.addAll(this.supportedLoaders, ModLoaderType.values());
            return;
        }
        for (LibraryAnalyzer.LibraryType type : LibraryAnalyzer.LibraryType.values()) {
            ModLoaderType modLoaderType;
            if (!type.isModLoader() || !analyzer.has(type) || (modLoaderType = type.getModLoaderType()) == null) continue;
            this.supportedLoaders.add(modLoaderType);
            if (modLoaderType != ModLoaderType.CLEANROOM) continue;
            this.supportedLoaders.add(ModLoaderType.FORGE);
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE) && "1.20.1".equals(this.gameVersion)) {
            this.supportedLoaders.add(ModLoaderType.FORGE);
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.QUILT)) {
            this.supportedLoaders.add(ModLoaderType.FABRIC);
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.LEGACY_FABRIC)) {
            this.supportedLoaders.add(ModLoaderType.FABRIC);
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.FABRIC) && modManager.hasMod("kilt", ModLoaderType.FABRIC)) {
            this.supportedLoaders.add(ModLoaderType.FORGE);
            this.supportedLoaders.add(ModLoaderType.NEO_FORGED);
        }
        if (analyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE) && modManager.hasMod("connectormod", ModLoaderType.NEO_FORGED) || "1.20.1".equals(this.gameVersion) && analyzer.has(LibraryAnalyzer.LibraryType.FORGE) && modManager.hasMod("connectormod", ModLoaderType.FORGE)) {
            this.supportedLoaders.add(ModLoaderType.FABRIC);
        }
    }

    public void add() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("mods.add.title"));
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18n.i18n("extension.mod"), new String[]{"*.jar", "*.zip", "*.litemod"})});
        List<Path> res = FileUtils.toPaths(chooser.showOpenMultipleDialog((Window)Controllers.getStage()));
        if (res == null) {
            return;
        }
        ArrayList succeeded = new ArrayList(res.size());
        ArrayList failed = new ArrayList();
        Task.runAsync(() -> {
            for (Path file : res) {
                try {
                    this.modManager.addMod(file);
                    succeeded.add(FileUtils.getName(file));
                }
                catch (Exception e) {
                    Logger.LOG.warning("Unable to add mod " + String.valueOf(file), e);
                    failed.add(FileUtils.getName(file));
                }
            }
        }).withRunAsync(Schedulers.javafx(), () -> {
            ArrayList<String> prompt = new ArrayList<String>(1);
            if (!succeeded.isEmpty()) {
                prompt.add(I18n.i18n("mods.add.success", String.join((CharSequence)", ", succeeded)));
            }
            if (!failed.isEmpty()) {
                prompt.add(I18n.i18n("mods.add.failed", String.join((CharSequence)", ", failed)));
            }
            Controllers.dialog(String.join((CharSequence)"\n", prompt), I18n.i18n("mods.add"));
            this.loadMods(this.modManager);
        }).start();
    }

    void removeSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        try {
            this.modManager.removeMods((LocalModFile[])selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).toArray(LocalModFile[]::new));
            this.loadMods(this.modManager);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void enableSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).forEach(info -> info.setActive(true));
    }

    void disableSelected(ObservableList<ModListPageSkin.ModInfoObject> selectedItems) {
        selectedItems.stream().filter(Objects::nonNull).map(ModListPageSkin.ModInfoObject::getModInfo).forEach(info -> info.setActive(false));
    }

    public void openModFolder() {
        FXUtils.openFolder(this.profile.getRepository().getRunDirectory(this.instanceId).resolve("mods"));
    }

    public void checkUpdates(Collection<LocalModFile> mods) {
        Objects.requireNonNull(mods);
        Runnable action = () -> Controllers.taskDialog(Task.composeAsync(() -> {
            Optional<String> gameVersion = this.profile.getRepository().getGameVersion(this.instanceId);
            if (gameVersion.isPresent()) {
                return new ModCheckUpdatesTask(gameVersion.get(), mods);
            }
            return null;
        }).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception != null || result == null) {
                Controllers.dialog(I18n.i18n("mods.check_updates.failed_check"), I18n.i18n("message.failed"), MessageDialogPane.MessageType.ERROR);
            } else if (result.isEmpty()) {
                Controllers.dialog(I18n.i18n("mods.check_updates.empty"));
            } else {
                Controllers.navigateForward((Node)new ModUpdatesPage(this.modManager, (List<LocalModFile.ModUpdate>)result));
            }
        }).withStagesHints("update.checking"), I18n.i18n("mods.check_updates"), TaskCancellationAction.NORMAL);
        if (this.profile.getRepository().isModpack(this.instanceId)) {
            Controllers.confirm(I18n.i18n("mods.update_modpack_mod.warning"), null, MessageDialogPane.MessageType.WARNING, action, null);
        } else {
            action.run();
        }
    }

    public void download() {
        Controllers.getDownloadPage().showModDownloads().selectVersion(this.instanceId);
        Controllers.navigate((Node)Controllers.getDownloadPage());
    }

    public void rollback(LocalModFile from, LocalModFile to) {
        try {
            this.modManager.rollback(from, to);
            this.refresh();
        }
        catch (IOException ex) {
            Controllers.showToast(I18n.i18n("message.failed"));
        }
    }

    public boolean isModded() {
        return this.modded.get();
    }

    public BooleanProperty moddedProperty() {
        return this.modded;
    }

    public void setModded(boolean modded) {
        this.modded.set(modded);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

