/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.chardet;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public final class DetectedCharset {
    public static final DetectedCharset US_ASCII = new DetectedCharset("US-ASCII", StandardCharsets.US_ASCII);
    public static final DetectedCharset UTF_8 = new DetectedCharset("UTF-8", StandardCharsets.UTF_8);
    public static final DetectedCharset UTF_16LE = new DetectedCharset("UTF-16LE", StandardCharsets.UTF_16LE);
    public static final DetectedCharset UTF_16BE = new DetectedCharset("UTF-16BE", StandardCharsets.UTF_16BE);
    public static final DetectedCharset UTF_32LE = new DetectedCharset("UTF-32LE");
    public static final DetectedCharset UTF_32BE = new DetectedCharset("UTF-32BE");
    public static final DetectedCharset ISO_2022_JP = new DetectedCharset("ISO-2022-JP");
    public static final DetectedCharset ISO_2022_CN = new DetectedCharset("ISO-2022-CN");
    public static final DetectedCharset ISO_2022_KR = new DetectedCharset("ISO-2022-KR");
    public static final DetectedCharset ISO_8859_5 = new DetectedCharset("ISO-8859-5");
    public static final DetectedCharset ISO_8859_7 = new DetectedCharset("ISO-8859-7");
    public static final DetectedCharset ISO_8859_8 = new DetectedCharset("ISO-8859-8");
    public static final DetectedCharset BIG5 = new DetectedCharset("Big5");
    public static final DetectedCharset GB18030 = new DetectedCharset("GB18030");
    public static final DetectedCharset EUC_JP = new DetectedCharset("EUC-JP");
    public static final DetectedCharset EUC_KR = new DetectedCharset("EUC-KR");
    public static final DetectedCharset EUC_TW = new DetectedCharset("EUC-TW");
    public static final DetectedCharset SHIFT_JIS = new DetectedCharset("Shift_JIS");
    public static final DetectedCharset IBM855 = new DetectedCharset("IBM855");
    public static final DetectedCharset IBM866 = new DetectedCharset("IBM866");
    public static final DetectedCharset KOI8_R = new DetectedCharset("KOI8-R");
    public static final DetectedCharset MAC_CYRILLIC = new DetectedCharset("MacCyrillic");
    public static final DetectedCharset WINDOWS_1251 = new DetectedCharset("windows-1251");
    public static final DetectedCharset WINDOWS_1252 = new DetectedCharset("windows-1252");
    public static final DetectedCharset WINDOWS_1253 = new DetectedCharset("windows-1253");
    public static final DetectedCharset WINDOWS_1255 = new DetectedCharset("windows-1255");
    public static final DetectedCharset TIS620 = new DetectedCharset("TIS-620");
    public static final DetectedCharset HZ_GB_2312 = new DetectedCharset("HZ-GB-2312", null);
    public static final DetectedCharset X_ISO_10646_UCS_4_3412 = new DetectedCharset("X-ISO-10646-UCS-4-3412", null);
    public static final DetectedCharset X_ISO_10646_UCS_4_2143 = new DetectedCharset("X-ISO-10646-UCS-4-2143", null);
    private final String name;
    private Charset charset;
    private boolean needInit;

    private DetectedCharset(String name) {
        this.name = name;
        this.needInit = true;
    }

    private DetectedCharset(String name, Charset charset) {
        this.name = name;
        this.charset = charset;
        this.needInit = false;
    }

    public String getName() {
        return this.name;
    }

    private void initCharset() {
        if (this.needInit) {
            try {
                this.charset = Charset.forName(this.name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.needInit = false;
        }
    }

    public Charset getCharset() throws UnsupportedCharsetException {
        this.initCharset();
        if (this.charset == null) {
            throw new UnsupportedCharsetException(this.name);
        }
        return this.charset;
    }

    public Charset getCharset(Charset defaultCharset) {
        this.initCharset();
        return this.charset != null ? this.charset : defaultCharset;
    }

    public boolean isSupported() {
        this.initCharset();
        return this.charset != null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectedCharset)) {
            return false;
        }
        return this.name.equals(((DetectedCharset)o).name);
    }

    public String toString() {
        return this.name;
    }
}

