/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;

public final class GameDownloadTask
extends Task<Void> {
    private final DefaultDependencyManager dependencyManager;
    private final String gameVersion;
    private final Version version;
    private final List<Task<?>> dependencies = new ArrayList();

    public GameDownloadTask(DefaultDependencyManager dependencyManager, String gameVersion, Version version) {
        this.dependencyManager = dependencyManager;
        this.gameVersion = gameVersion;
        this.version = version.resolve(dependencyManager.getGameRepository());
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() {
        Path jar = this.dependencyManager.getGameRepository().getVersionJar(this.version);
        FileDownloadTask task = new FileDownloadTask(this.dependencyManager.getDownloadProvider().injectURLWithCandidates(this.version.getDownloadInfo().getUrl()), jar, FileDownloadTask.IntegrityCheck.of("SHA-1", this.version.getDownloadInfo().getSha1()));
        task.setCaching(true);
        task.setCacheRepository(this.dependencyManager.getCacheRepository());
        if (this.gameVersion != null) {
            task.setCandidate(this.dependencyManager.getCacheRepository().getCommonDirectory().resolve("jars").resolve(this.gameVersion + ".jar"));
        }
        this.dependencies.add(task);
    }
}

