/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.FileNotFoundException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javax.net.ssl.SSLHandshakeException;
import org.jackhuang.hmcl.download.AdaptedDownloadProvider;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.download.AutoDownloadProvider;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.BalancedDownloadProvider;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.DownloadProviderWrapper;
import org.jackhuang.hmcl.download.MojangDownloadProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ResponseCodeException;

public final class DownloadProviders {
    private static final DownloadProviderWrapper provider;
    public static final Map<String, DownloadProvider> providersById;
    public static final Map<String, DownloadProvider> rawProviders;
    private static final AdaptedDownloadProvider fileDownloadProvider;
    private static final MojangDownloadProvider MOJANG;
    private static final BMCLAPIDownloadProvider BMCLAPI;
    public static final String DEFAULT_PROVIDER_ID = "balanced";
    public static final String DEFAULT_RAW_PROVIDER_ID = "bmclapi";
    private static final InvalidationListener observer;

    private DownloadProviders() {
    }

    static void init() {
        InvalidationListener onChangeDownloadSource = observable -> {
            String versionListSource = Objects.requireNonNullElse(ConfigHolder.config().getVersionListSource(), "");
            if (ConfigHolder.config().isAutoChooseDownloadType()) {
                DownloadProvider currentDownloadProvider = providersById.get(versionListSource);
                if (currentDownloadProvider == null) {
                    currentDownloadProvider = Objects.requireNonNull(providersById.get(DEFAULT_PROVIDER_ID), "default provider is null");
                }
                provider.setProvider(currentDownloadProvider);
            } else {
                provider.setProvider(fileDownloadProvider);
            }
        };
        ConfigHolder.config().versionListSourceProperty().addListener(onChangeDownloadSource);
        ConfigHolder.config().autoChooseDownloadTypeProperty().addListener(onChangeDownloadSource);
        onChangeDownloadSource.invalidated(null);
        FXUtils.onChangeAndOperate(ConfigHolder.config().downloadTypeProperty(), downloadType -> {
            DownloadProvider primary = Objects.requireNonNullElseGet(rawProviders.get(Objects.requireNonNullElse(downloadType, "")), () -> rawProviders.get(DEFAULT_RAW_PROVIDER_ID));
            ArrayList<DownloadProvider> providers = new ArrayList<DownloadProvider>(rawProviders.size());
            providers.add(primary);
            for (DownloadProvider provider : rawProviders.values()) {
                if (provider == primary) continue;
                providers.add(provider);
            }
            fileDownloadProvider.setDownloadProviderCandidates(providers);
        });
    }

    public static DownloadProvider getDownloadProvider() {
        return provider;
    }

    public static String localizeErrorMessage(Throwable exception) {
        if (exception instanceof DownloadException) {
            URI uri = ((DownloadException)exception).getUri();
            if (exception.getCause() instanceof SocketTimeoutException) {
                return I18n.i18n("install.failed.downloading.timeout", uri);
            }
            if (exception.getCause() instanceof ResponseCodeException) {
                ResponseCodeException responseCodeException = (ResponseCodeException)exception.getCause();
                if (I18n.hasKey("download.code." + responseCodeException.getResponseCode())) {
                    return I18n.i18n("download.code." + responseCodeException.getResponseCode(), uri);
                }
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(exception.getCause());
            }
            if (exception.getCause() instanceof FileNotFoundException) {
                return I18n.i18n("download.code.404", uri);
            }
            if (exception.getCause() instanceof AccessDeniedException) {
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + I18n.i18n("exception.access_denied", ((AccessDeniedException)exception.getCause()).getFile());
            }
            if (exception.getCause() instanceof ArtifactMalformedException) {
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + I18n.i18n("exception.artifact_malformed");
            }
            if (exception.getCause() instanceof SSLHandshakeException) {
                return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + I18n.i18n("exception.ssl_handshake");
            }
            return I18n.i18n("install.failed.downloading.detail", uri) + "\n" + StringUtils.getStackTrace(exception.getCause());
        }
        if (exception instanceof ArtifactMalformedException) {
            return I18n.i18n("exception.artifact_malformed");
        }
        if (exception instanceof CancellationException) {
            return I18n.i18n("message.cancelled");
        }
        return StringUtils.getStackTrace(exception);
    }

    static {
        fileDownloadProvider = new AdaptedDownloadProvider();
        String bmclapiRoot = "https://bmclapi2.bangbang93.com";
        String bmclapiRootOverride = System.getProperty("hmcl.bmclapi.override");
        if (bmclapiRootOverride != null) {
            bmclapiRoot = bmclapiRootOverride;
        }
        MOJANG = new MojangDownloadProvider();
        BMCLAPI = new BMCLAPIDownloadProvider(bmclapiRoot);
        rawProviders = Map.of("mojang", MOJANG, DEFAULT_RAW_PROVIDER_ID, BMCLAPI);
        AdaptedDownloadProvider fileProvider = new AdaptedDownloadProvider();
        fileProvider.setDownloadProviderCandidates(List.of(BMCLAPI, MOJANG));
        BalancedDownloadProvider balanced = new BalancedDownloadProvider(MOJANG, BMCLAPI);
        providersById = Map.of("official", new AutoDownloadProvider(MOJANG, fileProvider), DEFAULT_PROVIDER_ID, new AutoDownloadProvider(balanced, fileProvider), "mirror", new AutoDownloadProvider(BMCLAPI, fileProvider));
        observer = FXUtils.observeWeak(() -> FetchTask.setDownloadExecutorConcurrency(ConfigHolder.config().getAutoDownloadThreads() ? FetchTask.DEFAULT_CONCURRENCY : ConfigHolder.config().getDownloadThreads()), new Observable[]{ConfigHolder.config().autoDownloadThreadsProperty(), ConfigHolder.config().downloadThreadsProperty()});
        provider = new DownloadProviderWrapper(MOJANG);
    }
}

