/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;

public class MenuUpDownButton
extends Control {
    private final BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected");
    private final StringProperty text = new SimpleStringProperty((Object)this, "text");

    protected Skin<?> createDefaultSkin() {
        return new MenuUpDownButtonSkin(this);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    private static class MenuUpDownButtonSkin
    extends SkinBase<MenuUpDownButton> {
        protected MenuUpDownButtonSkin(MenuUpDownButton control) {
            super((Control)control);
            HBox content = new HBox(8.0);
            content.setAlignment(Pos.CENTER);
            Label label = new Label();
            label.setStyle("-fx-text-fill: black;");
            label.textProperty().bind((ObservableValue)control.text);
            Node up = SVG.ARROW_DROP_UP.createIcon((Paint)Theme.blackFill(), 16.0);
            Node down = SVG.ARROW_DROP_DOWN.createIcon((Paint)Theme.blackFill(), 16.0);
            JFXButton button = new JFXButton();
            button.setGraphic((Node)content);
            button.setOnAction(e -> control.selected.set(!control.isSelected()));
            FXUtils.onChangeAndOperate(control.selected, selected -> {
                if (selected.booleanValue()) {
                    content.getChildren().setAll((Object[])new Node[]{label, up});
                } else {
                    content.getChildren().setAll((Object[])new Node[]{label, down});
                }
            });
            this.getChildren().setAll((Object[])new Node[]{button});
        }
    }
}

