/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import jdk.internal.loader.BuiltinClassLoader;

public final class JavaFXPatcher {
    private JavaFXPatcher() {
    }

    public static void patch(Set<String> modules, Path[] jarPaths, String[] addOpens) throws ReflectiveOperationException {
        ModuleFinder finder = ModuleFinder.of(jarPaths);
        for (ModuleReference mref : finder.findAll()) {
            ((BuiltinClassLoader)ClassLoader.getSystemClassLoader()).loadModule(mref);
        }
        Configuration config = Configuration.resolveAndBind(finder, List.of(ModuleLayer.boot().configuration()), finder, modules);
        ModuleLayer layer = ModuleLayer.defineModules(config, List.of(ModuleLayer.boot()), name -> ClassLoader.getSystemClassLoader()).layer();
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Module.class, MethodHandles.lookup());
            MethodHandle handle = lookup.findVirtual(Module.class, "implAddOpensToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
            for (String target : addOpens) {
                String[] name2 = target.split("/", 2);
                layer.findModule(name2[0]).ifPresent(m -> {
                    try {
                        handle.invokeWithArguments(m, name2[1]);
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                });
            }
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }
}

