/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx;

import java.util.Objects;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.ColorSpecVersion;
import org.glavo.monetfx.ColorStyle;
import org.glavo.monetfx.Contrast;
import org.glavo.monetfx.TargetPlatform;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorSchemeBuilder {
    private Color primaryColorSeed;
    private Color secondaryColorSeed;
    private Color tertiaryColorSeed;
    private Color neutralColorSeed;
    private Color neutralVariantColorSeed;
    private Color errorColorSeed;
    private Brightness brightness = Brightness.DEFAULT;
    private ColorStyle colorStyle = ColorStyle.DEFAULT;
    private Contrast contrast = Contrast.DEFAULT;
    private ColorSpecVersion specVersion = ColorSpecVersion.DEFAULT;
    private TargetPlatform platform = TargetPlatform.DEFAULT;

    ColorSchemeBuilder() {
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setPrimaryColorSeed(@Nullable Color primaryColorSeed) {
        this.primaryColorSeed = primaryColorSeed;
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setWallpaper(@NotNull Image image) {
        this.primaryColorSeed = ColorScheme.extractColor(image);
        return this;
    }

    @Contract(value="_, _ -> this")
    public ColorSchemeBuilder setWallpaper(@NotNull Image image, Color fallbackColor) {
        this.primaryColorSeed = ColorScheme.extractColor(image, fallbackColor);
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setSecondaryColorSeed(@Nullable Color secondaryColorSeed) {
        this.secondaryColorSeed = secondaryColorSeed;
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setTertiaryColorSeed(@Nullable Color tertiaryColorSeed) {
        this.tertiaryColorSeed = tertiaryColorSeed;
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setNeutralColorSeed(@Nullable Color neutralColorSeed) {
        this.neutralColorSeed = neutralColorSeed;
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setNeutralVariantColorSeed(@Nullable Color neutralVariantColorSeed) {
        this.neutralVariantColorSeed = neutralVariantColorSeed;
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setErrorColorSeed(@Nullable Color errorColorSeed) {
        this.errorColorSeed = errorColorSeed;
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setBrightness(@NotNull Brightness brightness) {
        this.brightness = Objects.requireNonNull(brightness);
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setColorStyle(@NotNull ColorStyle colorStyle) {
        this.colorStyle = Objects.requireNonNull(colorStyle);
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setContrast(@NotNull Contrast contrast) {
        this.contrast = Objects.requireNonNull(contrast);
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setPlatform(@NotNull TargetPlatform platform) {
        this.platform = Objects.requireNonNull(platform);
        return this;
    }

    @Contract(value="_ -> this")
    public ColorSchemeBuilder setSpecVersion(@NotNull ColorSpecVersion specVersion) {
        this.specVersion = Objects.requireNonNull(specVersion);
        return this;
    }

    public ColorScheme build() {
        Color primaryColorSeed = this.primaryColorSeed;
        if (primaryColorSeed == null) {
            primaryColorSeed = ColorScheme.FALLBACK_COLOR;
        }
        boolean darkMode = this.brightness == Brightness.DARK;
        TargetPlatform platform = this.platform;
        ColorSpecVersion specVersion = this.specVersion;
        if (!this.colorStyle.isSupported(ColorSpecVersion.SPEC_2025)) {
            platform = TargetPlatform.DEFAULT;
            specVersion = ColorSpecVersion.DEFAULT;
        }
        if (platform == TargetPlatform.WATCH) {
            darkMode = true;
            specVersion = ColorSpecVersion.SPEC_2025;
        }
        return new ColorScheme(this.colorStyle, darkMode, this.contrast.getValue(), platform, specVersion, primaryColorSeed, this.secondaryColorSeed, this.tertiaryColorSeed, this.neutralColorSeed, this.neutralVariantColorSeed, this.errorColorSeed);
    }
}

