/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.quantize;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.glavo.monetfx.internal.quantize.PointProviderLab;

public final class QuantizerWsmeans {
    private static final int MAX_ITERATIONS = 10;
    private static final double MIN_MOVEMENT_DISTANCE = 3.0;

    private QuantizerWsmeans() {
    }

    public static Map<Integer, Integer> quantize(int[] inputPixels, int[] startingClusters, int maxColors) {
        int i;
        Random random = new Random(272008L);
        LinkedHashMap<Integer, Integer> pixelToCount = new LinkedHashMap<Integer, Integer>();
        double[][] points = new double[inputPixels.length][];
        int[] pixels = new int[inputPixels.length];
        PointProviderLab pointProvider = new PointProviderLab();
        int pointCount = 0;
        for (int inputPixel : inputPixels) {
            Integer pixelCount = (Integer)pixelToCount.get(inputPixel);
            if (pixelCount == null) {
                points[pointCount] = pointProvider.fromInt(inputPixel);
                pixels[pointCount] = inputPixel;
                ++pointCount;
                pixelToCount.put(inputPixel, 1);
                continue;
            }
            pixelToCount.put(inputPixel, pixelCount + 1);
        }
        int[] counts = new int[pointCount];
        for (int i2 = 0; i2 < pointCount; ++i2) {
            int count;
            int pixel = pixels[i2];
            counts[i2] = count = ((Integer)pixelToCount.get(pixel)).intValue();
        }
        int clusterCount = Math.min(maxColors, pointCount);
        if (startingClusters.length != 0) {
            clusterCount = Math.min(clusterCount, startingClusters.length);
        }
        double[][] clusters = new double[clusterCount][];
        int clustersCreated = 0;
        for (int i3 = 0; i3 < startingClusters.length; ++i3) {
            clusters[i3] = pointProvider.fromInt(startingClusters[i3]);
            ++clustersCreated;
        }
        int additionalClustersNeeded = clusterCount - clustersCreated;
        if (additionalClustersNeeded > 0) {
            for (int i4 = 0; i4 < additionalClustersNeeded; ++i4) {
            }
        }
        int[] clusterIndices = new int[pointCount];
        for (int i5 = 0; i5 < pointCount; ++i5) {
            clusterIndices[i5] = random.nextInt(clusterCount);
        }
        int[][] indexMatrix = new int[clusterCount][];
        for (int i6 = 0; i6 < clusterCount; ++i6) {
            indexMatrix[i6] = new int[clusterCount];
        }
        Distance[][] distanceToIndexMatrix = new Distance[clusterCount][];
        for (int i7 = 0; i7 < clusterCount; ++i7) {
            distanceToIndexMatrix[i7] = new Distance[clusterCount];
            for (int j = 0; j < clusterCount; ++j) {
                distanceToIndexMatrix[i7][j] = new Distance();
            }
        }
        int[] pixelCountSums = new int[clusterCount];
        for (int iteration = 0; iteration < 10; ++iteration) {
            int i8;
            for (i = 0; i < clusterCount; ++i) {
                int j;
                for (j = i + 1; j < clusterCount; ++j) {
                    double distance;
                    distanceToIndexMatrix[j][i].distance = distance = pointProvider.distance(clusters[i], clusters[j]);
                    distanceToIndexMatrix[j][i].index = i;
                    distanceToIndexMatrix[i][j].distance = distance;
                    distanceToIndexMatrix[i][j].index = j;
                }
                Arrays.sort(distanceToIndexMatrix[i]);
                for (j = 0; j < clusterCount; ++j) {
                    indexMatrix[i][j] = distanceToIndexMatrix[i][j].index;
                }
            }
            int pointsMoved = 0;
            for (int i9 = 0; i9 < pointCount; ++i9) {
                double distanceChange;
                double previousDistance;
                double[] point = points[i9];
                int previousClusterIndex = clusterIndices[i9];
                double[] previousCluster = clusters[previousClusterIndex];
                double minimumDistance = previousDistance = pointProvider.distance(point, previousCluster);
                int newClusterIndex = -1;
                for (int j = 0; j < clusterCount; ++j) {
                    double distance;
                    if (distanceToIndexMatrix[previousClusterIndex][j].distance >= 4.0 * previousDistance || !((distance = pointProvider.distance(point, clusters[j])) < minimumDistance)) continue;
                    minimumDistance = distance;
                    newClusterIndex = j;
                }
                if (newClusterIndex == -1 || !((distanceChange = Math.abs(Math.sqrt(minimumDistance) - Math.sqrt(previousDistance))) > 3.0)) continue;
                ++pointsMoved;
                clusterIndices[i9] = newClusterIndex;
            }
            if (pointsMoved == 0 && iteration != 0) break;
            double[] componentASums = new double[clusterCount];
            double[] componentBSums = new double[clusterCount];
            double[] componentCSums = new double[clusterCount];
            Arrays.fill(pixelCountSums, 0);
            for (i8 = 0; i8 < pointCount; ++i8) {
                int clusterIndex = clusterIndices[i8];
                double[] point = points[i8];
                int count = counts[i8];
                int n = clusterIndex;
                pixelCountSums[n] = pixelCountSums[n] + count;
                int n2 = clusterIndex;
                componentASums[n2] = componentASums[n2] + point[0] * (double)count;
                int n3 = clusterIndex;
                componentBSums[n3] = componentBSums[n3] + point[1] * (double)count;
                int n4 = clusterIndex;
                componentCSums[n4] = componentCSums[n4] + point[2] * (double)count;
            }
            for (i8 = 0; i8 < clusterCount; ++i8) {
                int count = pixelCountSums[i8];
                if (count == 0) {
                    clusters[i8] = new double[]{0.0, 0.0, 0.0};
                    continue;
                }
                double a = componentASums[i8] / (double)count;
                double b = componentBSums[i8] / (double)count;
                double c = componentCSums[i8] / (double)count;
                clusters[i8][0] = a;
                clusters[i8][1] = b;
                clusters[i8][2] = c;
            }
        }
        LinkedHashMap<Integer, Integer> argbToPopulation = new LinkedHashMap<Integer, Integer>();
        for (i = 0; i < clusterCount; ++i) {
            int possibleNewCluster;
            int count = pixelCountSums[i];
            if (count == 0 || argbToPopulation.containsKey(possibleNewCluster = pointProvider.toInt(clusters[i]))) continue;
            argbToPopulation.put(possibleNewCluster, count);
        }
        return argbToPopulation;
    }

    private static final class Distance
    implements Comparable<Distance> {
        int index = -1;
        double distance = -1.0;

        Distance() {
        }

        @Override
        public int compareTo(Distance other) {
            return Double.valueOf(this.distance).compareTo(other.distance);
        }
    }
}

