/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.theme;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import org.glavo.monetfx.Brightness;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.Contrast;
import org.glavo.monetfx.beans.property.ColorSchemeProperty;
import org.glavo.monetfx.beans.property.ReadOnlyColorSchemeProperty;
import org.glavo.monetfx.beans.property.SimpleColorSchemeProperty;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.theme.Theme;
import org.jackhuang.hmcl.theme.ThemeColor;
import org.jackhuang.hmcl.ui.FXUtils;

public final class Themes {
    private static final ObjectExpression<Theme> theme = new ObjectBinding<Theme>(){
        {
            ArrayList<Object> observables = new ArrayList<Object>();
            observables.add(ConfigHolder.config().themeBrightnessProperty());
            observables.add(ConfigHolder.config().themeColorProperty());
            if (FXUtils.DARK_MODE != null) {
                observables.add(FXUtils.DARK_MODE);
            }
            this.bind(observables.toArray(new Observable[0]));
        }

        private Brightness getBrightness() {
            String themeBrightness = ConfigHolder.config().getThemeBrightness();
            if (themeBrightness == null) {
                return Brightness.DEFAULT;
            }
            return switch (themeBrightness.toLowerCase(Locale.ROOT).trim()) {
                case "auto" -> {
                    if (FXUtils.DARK_MODE != null) {
                        if (FXUtils.DARK_MODE.get()) {
                            yield Brightness.DARK;
                        }
                        yield Brightness.LIGHT;
                    }
                    yield Brightness.DEFAULT;
                }
                case "dark" -> Brightness.DARK;
                case "light" -> Brightness.LIGHT;
                default -> Brightness.DEFAULT;
            };
        }

        protected Theme computeValue() {
            ThemeColor themeColor = Objects.requireNonNullElse(ConfigHolder.config().getThemeColor(), ThemeColor.DEFAULT);
            return new Theme(themeColor, this.getBrightness(), Theme.DEFAULT.colorStyle(), Contrast.DEFAULT);
        }
    };
    private static final ColorSchemeProperty colorScheme = new SimpleColorSchemeProperty();
    private static final BooleanBinding darkMode = Bindings.createBooleanBinding(() -> ((ColorScheme)colorScheme.get()).getBrightness() == Brightness.DARK, (Observable[])new Observable[]{colorScheme});
    private static final ObjectBinding<Color> titleFill;

    public static ObjectExpression<Theme> themeProperty() {
        return theme;
    }

    public static Theme getTheme() {
        return (Theme)Themes.themeProperty().get();
    }

    public static ReadOnlyColorSchemeProperty colorSchemeProperty() {
        return colorScheme;
    }

    public static ColorScheme getColorScheme() {
        return (ColorScheme)colorScheme.get();
    }

    public static ObservableValue<Color> titleFillProperty() {
        return titleFill;
    }

    public static BooleanBinding darkModeProperty() {
        return darkMode;
    }

    private Themes() {
    }

    static {
        ChangeListener listener = (observable, oldValue, newValue) -> {
            if (!Objects.equals(oldValue, newValue)) {
                colorScheme.set(newValue != null ? newValue.toColorScheme() : Theme.DEFAULT.toColorScheme());
            }
        };
        listener.changed(theme, null, (Object)((Theme)theme.get()));
        theme.addListener(listener);
        titleFill = Bindings.createObjectBinding(() -> ConfigHolder.config().isTitleTransparent() ? Themes.getColorScheme().getOnSurface() : Themes.getColorScheme().getOnPrimaryContainer(), (Observable[])new Observable[]{Themes.colorSchemeProperty(), ConfigHolder.config().titleTransparentProperty()});
    }
}

