/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import java.util.Objects;
import javafx.animation.Interpolator;
import javafx.util.Duration;

public final class Motion {
    public static final Interpolator LINEAR = Interpolator.LINEAR;
    public static final Interpolator EMPHASIZED_ACCELERATE = new Cubic(0.3, 0.0, 0.8, 0.15);
    public static final Interpolator EMPHASIZED_DECELERATE = new Cubic(0.05, 0.7, 0.1, 1.0);
    public static final Interpolator STANDARD = new Cubic(0.2, 0.0, 0.0, 1.0);
    public static final Interpolator STANDARD_ACCELERATE = new Cubic(0.3, 0.0, 1.0, 1.0);
    public static Interpolator STANDARD_DECELERATE = new Cubic(0.0, 0.0, 0.0, 1.0);
    public static Interpolator LEGACY_DECELERATE = new Cubic(0.0, 0.0, 0.2, 1.0);
    public static Interpolator LEGACY_ACCELERATE = new Cubic(0.4, 0.0, 1.0, 1.0);
    public static Interpolator LEGACY = new Cubic(0.4, 0.0, 0.2, 1.0);
    public static final Interpolator EASE = new Cubic(0.25, 0.1, 0.25, 1.0);
    public static final Interpolator EASE_IN = new Cubic(0.42, 0.0, 1.0, 1.0);
    public static final Interpolator EASE_IN_TO_LINEAR = new Cubic(0.67, 0.03, 0.65, 0.09);
    public static final Interpolator EASE_IN_SINE = new Cubic(0.47, 0.0, 0.745, 0.715);
    public static final Interpolator EASE_IN_QUAD = new Cubic(0.55, 0.085, 0.68, 0.53);
    public static final Interpolator EASE_IN_CUBIC = new Cubic(0.55, 0.055, 0.675, 0.19);
    public static final Interpolator EASE_IN_QUART = new Cubic(0.895, 0.03, 0.685, 0.22);
    public static final Interpolator EASE_IN_QUINT = new Cubic(0.755, 0.05, 0.855, 0.06);
    public static final Interpolator EASE_IN_EXPO = new Cubic(0.95, 0.05, 0.795, 0.035);
    public static final Interpolator EASE_IN_CIRC = new Cubic(0.6, 0.04, 0.98, 0.335);
    public static final Interpolator EASE_IN_BACK = new Cubic(0.6, -0.28, 0.735, 0.045);
    public static final Interpolator EASE_OUT = new Cubic(0.0, 0.0, 0.58, 1.0);
    public static final Interpolator LINEAR_TO_EASE_OUT = new Cubic(0.35, 0.91, 0.33, 0.97);
    public static final Interpolator EASE_OUT_SINE = new Cubic(0.39, 0.575, 0.565, 1.0);
    public static final Interpolator EASE_OUT_QUAD = new Cubic(0.25, 0.46, 0.45, 0.94);
    public static final Interpolator EASE_OUT_CUBIC = new Cubic(0.215, 0.61, 0.355, 1.0);
    public static final Interpolator EASE_OUT_QUART = new Cubic(0.165, 0.84, 0.44, 1.0);
    public static final Interpolator EASE_OUT_QUINT = new Cubic(0.23, 1.0, 0.32, 1.0);
    public static final Interpolator EASE_OUT_EXPO = new Cubic(0.19, 1.0, 0.22, 1.0);
    public static final Interpolator EASE_OUT_CIRC = new Cubic(0.075, 0.82, 0.165, 1.0);
    public static final Interpolator EASE_OUT_BACK = new Cubic(0.175, 0.885, 0.32, 1.275);
    public static final Interpolator EASE_IN_OUT = new Cubic(0.42, 0.0, 0.58, 1.0);
    public static final Interpolator EASE_IN_OUT_SINE = new Cubic(0.445, 0.05, 0.55, 0.95);
    public static final Interpolator EASE_IN_OUT_QUAD = new Cubic(0.455, 0.03, 0.515, 0.955);
    public static final Interpolator EASE_IN_OUT_CUBIC = new Cubic(0.645, 0.045, 0.355, 1.0);
    public static final Interpolator EASE_IN_OUT_QUART = new Cubic(0.77, 0.0, 0.175, 1.0);
    public static final Interpolator EASE_IN_OUT_QUINT = new Cubic(0.86, 0.0, 0.07, 1.0);
    public static final Interpolator EASE_IN_OUT_EXPO = new Cubic(1.0, 0.0, 0.0, 1.0);
    public static final Interpolator EASE_IN_OUT_CIRC = new Cubic(0.785, 0.135, 0.15, 0.86);
    public static final Interpolator EASE_IN_OUT_CUBIC_EMPHASIZED = new ThreePointCubic(new Offset(0.05, 0.0), new Offset(0.133333, 0.06), new Offset(0.166666, 0.4), new Offset(0.208333, 0.82), new Offset(0.25, 1.0));
    public static final Interpolator EASE_IN_OUT_BACK = new Cubic(0.68, -0.55, 0.265, 1.55);
    public static final Interpolator FAST_OUT_SLOW_IN = new Cubic(0.4, 0.0, 0.2, 1.0);
    public static final Interpolator SLOW_MIDDLE = new Cubic(0.15, 0.85, 0.85, 0.15);
    public static final Interpolator BOUNCE_IN = new Interpolator(){

        protected double curve(double t) {
            return 1.0 - Motion.bounce(1.0 - t);
        }
    };
    public static final Interpolator BOUNCE_OUT = new Interpolator(){

        protected double curve(double t) {
            return Motion.bounce(t);
        }
    };
    public static final Interpolator BOUNCE_IN_OUT = new Interpolator(){

        protected double curve(double t) {
            if (t < 0.5) {
                return (1.0 - Motion.bounce(1.0 - t * 2.0)) * 0.5;
            }
            return Motion.bounce(t * 2.0 - 1.0) * 0.5 + 0.5;
        }
    };
    private static final double PERIOD = 0.4;
    public static final Interpolator ELASTIC_IN = new Interpolator(){

        protected double curve(double t) {
            double s = 0.1;
            return -Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t - 0.1) * (Math.PI * 2) / 0.4);
        }
    };
    public static Interpolator ELASTIC_OUT = new Interpolator(){

        protected double curve(double t) {
            double s = 0.1;
            return Math.pow(2.0, -10.0 * t) * Math.sin((t - 0.1) * (Math.PI * 2) / 0.4) + 1.0;
        }
    };
    public static Interpolator ELASTIC_IN_OUT = new Interpolator(){

        protected double curve(double t) {
            double s = 0.1;
            if ((t = 2.0 * t - 1.0) < 0.0) {
                return -0.5 * Math.pow(2.0, 10.0 * t) * Math.sin((t - 0.1) * (Math.PI * 2) / 0.4);
            }
            return Math.pow(2.0, -10.0 * t) * Math.sin((t - 0.1) * (Math.PI * 2) / 0.4) * 0.5 + 1.0;
        }
    };
    public static final Duration SHORT1 = Duration.millis((double)50.0);
    public static final Duration SHORT2 = Duration.millis((double)100.0);
    public static final Duration SHORT3 = Duration.millis((double)150.0);
    public static final Duration SHORT4 = Duration.millis((double)200.0);
    public static final Duration MEDIUM1 = Duration.millis((double)250.0);
    public static final Duration MEDIUM2 = Duration.millis((double)300.0);
    public static final Duration MEDIUM3 = Duration.millis((double)350.0);
    public static final Duration MEDIUM4 = Duration.millis((double)400.0);
    public static final Duration LONG1 = Duration.millis((double)450.0);
    public static final Duration LONG2 = Duration.millis((double)500.0);
    public static final Duration LONG3 = Duration.millis((double)550.0);
    public static final Duration LONG4 = Duration.millis((double)600.0);
    public static final Duration EXTRA_LONG1 = Duration.millis((double)700.0);
    public static final Duration EXTRA_LONG2 = Duration.millis((double)800.0);
    public static final Duration EXTRA_LONG3 = Duration.millis((double)900.0);
    public static final Duration EXTRA_LONG4 = Duration.millis((double)1000.0);

    private static double bounce(double t) {
        if (t < 0.36363636363636365) {
            return 7.5625 * t * t;
        }
        if (t < 0.7272727272727273) {
            return 7.5625 * (t -= 0.5454545454545454) * t + 0.75;
        }
        if (t < 0.9090909090909091) {
            return 7.5625 * (t -= 0.8181818181818182) * t + 0.9375;
        }
        return 7.5625 * (t -= 0.9545454545454546) * t + 0.984375;
    }

    private Motion() {
    }

    private static final class Cubic
    extends Interpolator {
        private static final double CUBIC_ERROR_BOUND = 0.001;
        private final double a;
        private final double b;
        private final double c;
        private final double d;

        private Cubic(double a, double b, double c, double d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        double _evaluateCubic(double a, double b, double m) {
            return 3.0 * a * (1.0 - m) * (1.0 - m) * m + 3.0 * b * (1.0 - m) * m * m + m * m * m;
        }

        protected double curve(double t) {
            double start = 0.0;
            double end = 1.0;
            double midpoint;
            double estimate;
            while (!(Math.abs(t - (estimate = this._evaluateCubic(this.a, this.c, midpoint = (start + end) / 2.0))) < 0.001)) {
                if (estimate < t) {
                    start = midpoint;
                    continue;
                }
                end = midpoint;
            }
            return this._evaluateCubic(this.b, this.d, midpoint);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Cubic)) return false;
            Cubic cubic = (Cubic)((Object)o);
            if (this.a != cubic.a) return false;
            if (this.b != cubic.b) return false;
            if (this.c != cubic.c) return false;
            if (this.d != cubic.d) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b, this.c, this.d);
        }

        public String toString() {
            return "Cubic[a=%s, b=%s, c=%s, d=%s]".formatted(this.a, this.b, this.c, this.d);
        }
    }

    private static final class ThreePointCubic
    extends Interpolator {
        private final Offset a1;
        private final Offset b1;
        private final Offset midpoint;
        private final Offset a2;
        private final Offset b2;

        private ThreePointCubic(Offset a1, Offset b1, Offset midpoint, Offset a2, Offset b2) {
            this.a1 = a1;
            this.b1 = b1;
            this.midpoint = midpoint;
            this.a2 = a2;
            this.b2 = b2;
        }

        protected double curve(double t) {
            boolean firstCurve = t < this.midpoint.dx;
            double scaleX = firstCurve ? this.midpoint.dx : 1.0 - this.midpoint.dx;
            double scaleY = firstCurve ? this.midpoint.dy : 1.0 - this.midpoint.dy;
            double scaledT = (t - (firstCurve ? 0.0 : this.midpoint.dx)) / scaleX;
            if (firstCurve) {
                return new Cubic(this.a1.dx / scaleX, this.a1.dy / scaleY, this.b1.dx / scaleX, this.b1.dy / scaleY).curve(scaledT) * scaleY;
            }
            return new Cubic((this.a2.dx - this.midpoint.dx) / scaleX, (this.a2.dy - this.midpoint.dy) / scaleY, (this.b2.dx - this.midpoint.dx) / scaleX, (this.b2.dy - this.midpoint.dy) / scaleY).curve(scaledT) * scaleY + this.midpoint.dy;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof ThreePointCubic)) return false;
            ThreePointCubic that = (ThreePointCubic)((Object)o);
            if (!this.a1.equals(that.a1)) return false;
            if (!this.b1.equals(that.b1)) return false;
            if (!this.midpoint.equals(that.midpoint)) return false;
            if (!this.a2.equals(that.a2)) return false;
            if (!this.b2.equals(that.b2)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.a1, this.b1, this.midpoint, this.a2, this.b2);
        }

        public String toString() {
            return "ThreePointCubic[a1=%s, b1=%s, midpoint=%s, a2=%s, b2=%s]".formatted(this.a1, this.b1, this.midpoint, this.a2, this.b2);
        }
    }

    private record Offset(double dx, double dy) {
    }
}

